# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_lead import AccountLead


class AccountLeadsResult(object):

    """Implementation of the 'AccountLeadsResult' model.

    Returns information for all leads associated with an account.

    Attributes:
        has_more_data (bool): False if no more leads.True if there is more
            data to be retrieved.
        leads (List[AccountLead]): The leads associated with an account.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "has_more_data": 'hasMoreData',
        "leads": 'leads'
    }

    _optionals = [
        'has_more_data',
        'leads',
    ]

    def __init__(self,
                 has_more_data=APIHelper.SKIP,
                 leads=APIHelper.SKIP):
        """Constructor for the AccountLeadsResult class"""

        # Initialize members of the class
        if has_more_data is not APIHelper.SKIP:
            self.has_more_data = has_more_data 
        if leads is not APIHelper.SKIP:
            self.leads = leads 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        has_more_data = dictionary.get("hasMoreData") if "hasMoreData" in dictionary.keys() else APIHelper.SKIP
        leads = None
        if dictionary.get('leads') is not None:
            leads = [AccountLead.from_dictionary(x) for x in dictionary.get('leads')]
        else:
            leads = APIHelper.SKIP
        # Return an object of this model
        return cls(has_more_data,
                   leads)
