# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.address import Address


class AccountLead(object):

    """Implementation of the 'AccountLead' model.

    A successful response returns an array of lead objects.

    Attributes:
        address (Address): The customer address for the line's primary place
            of use, for line usage taxation.
        lead_id (str): Unique number for each lead. Use this value in the
            leadId parameter when activating devices to credit the activations
            to the lead.
        lead_state (str): The current state of the lead, such as “Qualified”
            or “Closed.”

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "address": 'address',
        "lead_id": 'leadId',
        "lead_state": 'leadState'
    }

    _optionals = [
        'address',
        'lead_id',
        'lead_state',
    ]

    def __init__(self,
                 address=APIHelper.SKIP,
                 lead_id=APIHelper.SKIP,
                 lead_state=APIHelper.SKIP):
        """Constructor for the AccountLead class"""

        # Initialize members of the class
        if address is not APIHelper.SKIP:
            self.address = address 
        if lead_id is not APIHelper.SKIP:
            self.lead_id = lead_id 
        if lead_state is not APIHelper.SKIP:
            self.lead_state = lead_state 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        address = Address.from_dictionary(dictionary.get('address')) if 'address' in dictionary.keys() else APIHelper.SKIP
        lead_id = dictionary.get("leadId") if dictionary.get("leadId") else APIHelper.SKIP
        lead_state = dictionary.get("leadState") if dictionary.get("leadState") else APIHelper.SKIP
        # Return an object of this model
        return cls(address,
                   lead_id,
                   lead_state)
