# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.ip_pool import IPPool
from verizon.models.service_plan import ServicePlan


class Account(object):

    """Implementation of the 'Account' model.

    Returns information about a specified account.

    Attributes:
        account_name (str): The name of the account.
        account_number (str): The billing number of the account.
        organization_name (str): The name of the organization that the account
            is part of.
        is_provisioning_allowed (bool): True if devices can be added to the
            account and activated with a single request. False if devices must
            be added to the account before they can be activated.
        carriers (List[str]): The names of all carriers for the account.
        features (List[str]): The names of features that are enabled for the
            account.
        i_p_pools (List[IPPool]): Array of IP pools that are available to the
            account.
        service_plans (List[ServicePlan]): Array of service plans that are
            available to the account.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "account_number": 'accountNumber',
        "organization_name": 'organizationName',
        "is_provisioning_allowed": 'isProvisioningAllowed',
        "carriers": 'carriers',
        "features": 'features',
        "i_p_pools": 'iPPools',
        "service_plans": 'servicePlans'
    }

    _optionals = [
        'account_name',
        'account_number',
        'organization_name',
        'is_provisioning_allowed',
        'carriers',
        'features',
        'i_p_pools',
        'service_plans',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 organization_name=APIHelper.SKIP,
                 is_provisioning_allowed=APIHelper.SKIP,
                 carriers=APIHelper.SKIP,
                 features=APIHelper.SKIP,
                 i_p_pools=APIHelper.SKIP,
                 service_plans=APIHelper.SKIP):
        """Constructor for the Account class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if organization_name is not APIHelper.SKIP:
            self.organization_name = organization_name 
        if is_provisioning_allowed is not APIHelper.SKIP:
            self.is_provisioning_allowed = is_provisioning_allowed 
        if carriers is not APIHelper.SKIP:
            self.carriers = carriers 
        if features is not APIHelper.SKIP:
            self.features = features 
        if i_p_pools is not APIHelper.SKIP:
            self.i_p_pools = i_p_pools 
        if service_plans is not APIHelper.SKIP:
            self.service_plans = service_plans 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        organization_name = dictionary.get("organizationName") if dictionary.get("organizationName") else APIHelper.SKIP
        is_provisioning_allowed = dictionary.get("isProvisioningAllowed") if "isProvisioningAllowed" in dictionary.keys() else APIHelper.SKIP
        carriers = dictionary.get("carriers") if dictionary.get("carriers") else APIHelper.SKIP
        features = dictionary.get("features") if dictionary.get("features") else APIHelper.SKIP
        i_p_pools = None
        if dictionary.get('iPPools') is not None:
            i_p_pools = [IPPool.from_dictionary(x) for x in dictionary.get('iPPools')]
        else:
            i_p_pools = APIHelper.SKIP
        service_plans = None
        if dictionary.get('servicePlans') is not None:
            service_plans = [ServicePlan.from_dictionary(x) for x in dictionary.get('servicePlans')]
        else:
            service_plans = APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   account_number,
                   organization_name,
                   is_provisioning_allowed,
                   carriers,
                   features,
                   i_p_pools,
                   service_plans)
