# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.m_201_success import M201success
from verizon.exceptions.default_response_exception import DefaultResponseException


class ThingSpaceQualityOfServiceAPIActionsController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(ThingSpaceQualityOfServiceAPIActionsController, self).__init__(config)

    def create_a_thing_space_quality_of_service_api_subscription(self,
                                                                 body):
        """Does a POST request to /m2m/v1/devices/actions/enhanceQoS.

        Creates a QoS elevation subscription ID and activates the
        subscription.

        Args:
            body (SubscribeRequest): The request details to create a
                ThingSpace Quality of Service API subscription.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Success
                Response

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/actions/enhanceQoS')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(M201success.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Error Response', DefaultResponseException)
        ).execute()

    def stop_a_thing_space_quality_of_service_api_subscription(self,
                                                               account_name,
                                                               qos_subscription_id):
        """Does a DELETE request to /m2m/v1/devices/actions/enhanceQoS.

        Stops an active ThingSpace Quality of Service API subscription using
        the account name and the subscription ID.

        Args:
            account_name (str): TODO: type description here.
            qos_subscription_id (str): TODO: type description here.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Success
                Response

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/actions/enhanceQoS')
            .http_method(HttpMethodEnum.DELETE)
            .query_param(Parameter()
                         .key('accountName')
                         .value(account_name))
            .query_param(Parameter()
                         .key('qosSubscriptionId')
                         .value(qos_subscription_id))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(M201success.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Error Response', DefaultResponseException)
        ).execute()
