# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.target import Target
from verizon.models.generate_external_id_result import GenerateExternalIDResult
from verizon.models.create_io_t_application_response import CreateIoTApplicationResponse


class TargetsController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(TargetsController, self).__init__(config)

    def query_target(self,
                     body):
        """Does a POST request to /targets/actions/query.

        Search for targets by property values. Returns an array of all
        matching target resources.

        Args:
            body (QueryTargetRequest): Search for targets by property values.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. A success
                response includes an array of all matching targets. Each
                target includes the full target resource definition.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CLOUD_CONNECTOR)
            .path('/targets/actions/query')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(Target.from_dictionary)
            .is_api_response(True)
        ).execute()

    def delete_target(self,
                      body):
        """Does a POST request to /targets/actions/delete.

        Remove a target from a ThingSpace account.

        Args:
            body (DeleteTargetRequest): The request body identifies the target
                to delete.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Target
                deleted successfully.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CLOUD_CONNECTOR)
            .path('/targets/actions/delete')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .is_api_response(True)
        ).execute()

    def create_target(self,
                      body):
        """Does a POST request to /targets.

        Define a target to receive data streams, alerts, or callbacks. After
        creating the target resource, use its ID in a subscription to set up a
        data stream.

        Args:
            body (CreateTargetRequest): The request body provides the details
                of the target that you want to create.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. A success
                response includes the full target resource definition.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CLOUD_CONNECTOR)
            .path('/targets')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(Target.from_dictionary)
            .is_api_response(True)
        ).execute()

    def generate_target_external_id(self,
                                    body):
        """Does a POST request to /targets/actions/newextid.

        Create a unique string that ThingSpace will pass to AWS for increased
        security.

        Args:
            body (GenerateExternalIDRequest): The request body only contains
                the authenticating account.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Returns a
                new external ID.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CLOUD_CONNECTOR)
            .path('/targets/actions/newextid')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(GenerateExternalIDResult.from_dictionary)
            .is_api_response(True)
        ).execute()

    def create_azure_central_io_t_application(self,
                                              billingaccount_id,
                                              body):
        """Does a POST request to /targets/actions/newaic.

        Deploy a new Azure IoT Central application based on the Verizon ARM
        template within the specified Azure Active Directory account.

        Args:
            billingaccount_id (str): TThe ThingSpace ID of the authenticating
                billing account.
            body (CreateIoTApplicationRequest): The request body must include
                the UUID of the subscription that you want to update plus any
                properties that you want to change.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. A success
                response includes the full subscription resource definition.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CLOUD_CONNECTOR)
            .path('/targets/actions/newaic')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('BillingaccountID')
                          .value(billingaccount_id))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(CreateIoTApplicationResponse.from_dictionary)
            .is_api_response(True)
        ).execute()
