# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.v1_account_subscription import V1AccountSubscription
from verizon.models.account_license_info import AccountLicenseInfo
from verizon.exceptions.fota_v1_result_exception import FotaV1ResultException


class SoftwareManagementSubscriptionsV1Controller(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(SoftwareManagementSubscriptionsV1Controller, self).__init__(config)

    def get_account_subscription_status(self,
                                        account):
        """Does a GET request to /subscriptions/{account}.

        This subscriptions endpoint retrieves an account's current Software
        Management Service subscription status.

        Args:
            account (str): Account identifier in "##########-#####".

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Account
                subscription information.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/subscriptions/{account}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(V1AccountSubscription.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()

    def get_account_license_status(self,
                                   account,
                                   start_index):
        """Does a GET request to /licenses/{account}/index/{startIndex}.

        Returns information about an account's Software Management Services
        licenses and a list of licensed devices.

        Args:
            account (str): Account identifier in "##########-#####".
            start_index (str): The zero-based number of the first record to
                return. Set startIndex=0 for the first request. If there are
                more than 1,000 devices in the response, set startIndex=1000
                for the second request, 2000 for the third request, etc.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Account
                license information.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SOFTWARE_MANAGEMENT_V1)
            .path('/licenses/{account}/index/{startIndex}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('startIndex')
                            .value(start_index)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(AccountLicenseInfo.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', FotaV1ResultException)
        ).execute()
