# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.kpi_info_list import KPIInfoList
from verizon.models.mec_profile_list import MECProfileList
from verizon.models.change_mec_device_state_response import ChangeMecDeviceStateResponse
from verizon.models.change_mec_device_profile_response import ChangeMecDeviceProfileResponse
from verizon.models.change_mec_device_ip_address_response import ChangeMecDeviceIPAddressResponse
from verizon.models.get_mec_performance_consent_response import GetMECPerformanceConsentResponse


class MECController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(MECController, self).__init__(config)

    def kpi_list(self,
                 aname):
        """Does a GET request to /m2m/v1/devices/mec/kpi/list/{aname}.

        TODO: type endpoint description here.

        Args:
            aname (str): Account name.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Kpi list
                received on a successful response.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/mec/kpi/list/{aname}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('aname')
                            .value(aname)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(KPIInfoList.from_dictionary)
            .is_api_response(True)
        ).execute()

    def get_profile_list(self,
                         aname):
        """Does a GET request to /m2m/v1/devices/mec/profiles/list/{aname}.

        TODO: type endpoint description here.

        Args:
            aname (str): Account name.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. MEC
                profiles list received on a successful response.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/mec/profiles/list/{aname}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('aname')
                            .value(aname)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(MECProfileList.from_dictionary)
            .is_api_response(True)
        ).execute()

    def change_pmec_device_state_activate(self,
                                          body):
        """Does a POST request to /m2m/v1/devices/mec/actions/state/activate.

        TODO: type endpoint description here.

        Args:
            body (ChangePmecDeviceStateActivateRequest): TODO: type
                description here.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                ID received on a successful response.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/mec/actions/state/activate')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ChangeMecDeviceStateResponse.from_dictionary)
            .is_api_response(True)
        ).execute()

    def change_pmec_device_state_bulk_deactivate(self,
                                                 body):
        """Does a POST request to /m2m/v1/devices/mec/actions/state/deactivate.

        TODO: type endpoint description here.

        Args:
            body (ChangePmecDeviceStateBulkDeactivateRequest): TODO: type
                description here.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                ID received on a successful response.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/mec/actions/state/deactivate')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ChangeMecDeviceStateResponse.from_dictionary)
            .is_api_response(True)
        ).execute()

    def change_pmec_device_profile(self,
                                   body):
        """Does a POST request to /m2m/v1/devices/mec/actions/profile.

        TODO: type endpoint description here.

        Args:
            body (ChangePmecDeviceProfileRequest): TODO: type description
                here.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                ID received on a successful response.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/mec/actions/profile')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ChangeMecDeviceProfileResponse.from_dictionary)
            .is_api_response(True)
        ).execute()

    def change_pmec_device_i_paddress_bulk(self,
                                           body):
        """Does a PUT request to /m2m/v1/devices/mec/actions/ipaddress.

        TODO: type endpoint description here.

        Args:
            body (ChangePmecDeviceStateBulkDeactivateRequest): TODO: type
                description here.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                ID received on a successful response.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/mec/actions/ipaddress')
            .http_method(HttpMethodEnum.PUT)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ChangeMecDeviceIPAddressResponse.from_dictionary)
            .is_api_response(True)
        ).execute()

    def get_mec_performance_consent(self,
                                    aname):
        """Does a GET request to /m2m/v1/devices/mec/performance/consent/{aname}.

        TODO: type endpoint description here.

        Args:
            aname (str): Account name.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. consent
                received on a successful response.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/mec/performance/consent/{aname}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('aname')
                            .value(aname)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(GetMECPerformanceConsentResponse.from_dictionary)
            .is_api_response(True)
        ).execute()
