# coding: utf-8

# (C) Copyright IBM Corp. 2025.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# IBM OpenAPI SDK Code Generator Version: 3.108.0-56772134-20251111-102802

"""
No description provided (generated by Openapi Generator
https://github.com/openapitools/openapi-generator)

API Version: 1.0.0
"""

from datetime import datetime
from enum import Enum
from typing import Dict, List, Optional
import json

from ibm_cloud_sdk_core import BaseService, DetailedResponse
from ibm_cloud_sdk_core.authenticators.authenticator import Authenticator
from ibm_cloud_sdk_core.get_authenticator import get_authenticator_from_environment
from ibm_cloud_sdk_core.utils import datetime_to_string, string_to_datetime

from .common import get_sdk_headers

##############################################################################
# Service
##############################################################################


class DrAutomationServiceV1(BaseService):
    """The DrAutomation Service V1 service."""

    DEFAULT_SERVICE_URL = 'https://power-dra.cloud.ibm.com'
    DEFAULT_SERVICE_NAME = 'dr_automation_service'

    @classmethod
    def new_instance(
        cls,
        service_name: str = DEFAULT_SERVICE_NAME,
    ) -> 'DrAutomationServiceV1':
        """
        Return a new client for the DrAutomation Service service using the
               specified parameters and external configuration.
        """
        authenticator = get_authenticator_from_environment(service_name)
        service = cls(authenticator)
        service.configure_service(service_name)
        return service

    def __init__(
        self,
        authenticator: Authenticator = None,
    ) -> None:
        """
        Construct a new client for the DrAutomation Service service.

        :param Authenticator authenticator: The authenticator specifies the authentication mechanism.
               Get up to date information from https://github.com/IBM/python-sdk-core/blob/main/README.md
               about initializing the authenticator of your choice.
        """
        BaseService.__init__(self, service_url=self.DEFAULT_SERVICE_URL, authenticator=authenticator)

    #########################
    # drAutomationConfig
    #########################

    def update_apikey(
        self,
        instance_id: str,
        api_key: str,
        *,
        accept_language: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Updates the API key for the specified service instance.

        Updating the current API key details for the specified service instance.

        :param str instance_id: instance id of instance to provision.
        :param str api_key: The new API key value that will replace the existing
               one.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `ValidationKeyResponse` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        if api_key is None:
            raise ValueError('api_key must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='update_apikey',
        )
        headers.update(sdk_headers)

        data = {
            'api_key': api_key,
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/apikey/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='PUT',
            url=url,
            headers=headers,
            data=data,
        )

        response = self.send(request, **kwargs)
        return response

    def get_dr_grs_location_pair(
        self,
        instance_id: str,
        *,
        accept_language: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Get GRS location pairs based on managed vms.

        Retrieves the (GRS) location pairs associated with the specified service instance
        based on managed VMs.

        :param str instance_id: instance id of instance to provision.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GetGRSLocationPairResponse` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='get_dr_grs_location_pair',
        )
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/dr_grs_location_pairs/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
        )

        response = self.send(request, **kwargs)
        return response

    def get_dr_locations(
        self,
        instance_id: str,
        *,
        accept_language: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Get Disaster recovery locations.

        Retrieves the list of disaster recovery (DR) locations available for the specified
        service instance.

        :param str instance_id: instance id of instance to provision.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `GetDrLocationsResponse` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='get_dr_locations',
        )
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/dr_locations/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
        )

        response = self.send(request, **kwargs)
        return response

    def get_dr_managed_vm(
        self,
        instance_id: str,
        *,
        accept_language: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Get managed vms for the instance.

        Retrieves the list of disaster recovery (DR) managed virtual machines for the
        specified service instance.

        :param str instance_id: instance id of instance to provision.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `ManagedVmMapResponse` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='get_dr_managed_vm',
        )
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/dr_managed_vms/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
        )

        response = self.send(request, **kwargs)
        return response

    def get_dr_summary(
        self,
        instance_id: str,
        *,
        accept_language: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Disaster recovery deployment details.

        Retrieves the disaster recovery (DR) summary details for the specified service
        instance, including key configuration, status information and managed vm details.

        :param str instance_id: instance id of instance to provision.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DrAutomationGetSummaryResponse` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='get_dr_summary',
        )
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/dr_summary/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
        )

        response = self.send(request, **kwargs)
        return response

    #########################
    # drAutomationIbmCloud
    #########################

    def get_machine_type(
        self,
        instance_id: str,
        primary_workspace_name: str,
        *,
        accept_language: Optional[str] = None,
        standby_workspace_name: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Get MachineTypes based on selected workspaces.

        Retrieves the list of supported machine types for the given workspace. This
        endpoint is used to identify machine types available for disaster recovery
        automation.

        :param str instance_id: instance id of instance to provision.
        :param str primary_workspace_name: The primary Power virtual server
               workspace name.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param str standby_workspace_name: (optional) The standby Power virtual
               server workspace name.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `MachineTypesByWorkspace` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        if not primary_workspace_name:
            raise ValueError('primary_workspace_name must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='get_machine_type',
        )
        headers.update(sdk_headers)

        params = {
            'primary_workspace_name': primary_workspace_name,
            'standby_workspace_name': standby_workspace_name,
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/machinetypes/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
            params=params,
        )

        response = self.send(request, **kwargs)
        return response

    def get_powervs_workspaces(
        self,
        instance_id: str,
        location_id: str,
        **kwargs,
    ) -> DetailedResponse:
        """
        List of primary and standby powervs workspaces.

        Retrieves the power virtual server workspaces for primary and standby orchestrator
        based on location id.

        :param str instance_id: instance id of instance to provision.
        :param str location_id: Location ID value.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DrData` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        if not location_id:
            raise ValueError('location_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='get_powervs_workspaces',
        )
        headers.update(sdk_headers)

        params = {
            'location_id': location_id,
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/powervs_workspaces/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
            params=params,
        )

        response = self.send(request, **kwargs)
        return response

    #########################
    # drAutomationManageDr
    #########################

    def create_manage_dr(
        self,
        instance_id: str,
        location_id: str,
        machine_type: str,
        orchestrator_location_type: str,
        orchestrator_name: str,
        orchestrator_password: str,
        orchestrator_workspace_id: str,
        *,
        api_key: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        guid: Optional[str] = None,
        orchestrator_ha: Optional[bool] = None,
        proxy_ip: Optional[str] = None,
        region_id: Optional[str] = None,
        resource_instance: Optional[str] = None,
        secret: Optional[str] = None,
        secret_group: Optional[str] = None,
        ssh_key_name: Optional[str] = None,
        standby_machine_type: Optional[str] = None,
        standby_orchestrator_name: Optional[str] = None,
        standby_orchestrator_workspace_id: Optional[str] = None,
        standby_tier: Optional[str] = None,
        tenant_name: Optional[str] = None,
        tier: Optional[str] = None,
        stand_by_redeploy: Optional[str] = None,
        accept_language: Optional[str] = None,
        accepts_incomplete: Optional[bool] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Create DR Deployment.

        Creates DR Deployment by creating Orchestrator instance in the given PowerVS
        workspace and configuration. Orchestrator instance can be used to manage multiple
        virtual servers and ensure continuous availability. For more details, refer
        Deploying the Orchestrator -
        https://cloud.ibm.com/docs/dr-automation-powervs?topic=dr-automation-powervs-idep-the-orch.

        :param str instance_id: instance id of instance to provision.
        :param str location_id: The location or data center identifier where the
               service instance is deployed.
        :param str machine_type: The machine type used for deploying orchestrator.
        :param str orchestrator_location_type: The cloud location where your
               orchestator need to be created.
        :param str orchestrator_name: The username used for the orchestrator.
        :param str orchestrator_password: The password that you can use to access
               your orchestrator.
        :param str orchestrator_workspace_id: The unique identifier orchestrator
               workspace.
        :param str api_key: (optional) The api Key of the service instance for
               deploying the disaster recovery service.
        :param str client_id: (optional) The Client Id created for MFA
               authentication API.
        :param str client_secret: (optional) The client secret created for MFA
               authentication API.
        :param str guid: (optional) The global unique identifier of the service
               instance.
        :param bool orchestrator_ha: (optional) Indicates whether the orchestrator
               High Availability (HA) is enabled for the service instance.
        :param str proxy_ip: (optional) Proxy IP for the Communication between
               Orchestrator and Service broker.
        :param str region_id: (optional) The power virtual server region where the
               service instance is deployed.
        :param str resource_instance: (optional) The uniquie identifier of the
               associated IBM Cloud resource instance.
        :param str secret: (optional) The secret name or identifier used for
               retrieving credentials from secrets manager.
        :param str secret_group: (optional) The secret group name in IBM Cloud
               Secrets Manager containing sensitive data for the service instance.
        :param str ssh_key_name: (optional) The name of the SSH key used for
               deploying the orchestator.
        :param str standby_machine_type: (optional) The machine type used for
               deploying standby virtual machines.
        :param str standby_orchestrator_name: (optional) The username for the
               standby orchestrator management interface.
        :param str standby_orchestrator_workspace_id: (optional) The unique
               identifier of the standby orchestrator workspace.
        :param str standby_tier: (optional) The storage tier used for deploying
               standby orchestrator.
        :param str tenant_name: (optional) The tenant name for MFA authentication
               API.
        :param str tier: (optional) The storage tier used for deploying primary
               orchestrator.
        :param str stand_by_redeploy: (optional) Flag to indicate if standby should
               be redeployed (must be "true" or "false").
        :param str accept_language: (optional) The language requested for the
               return document.
        :param bool accepts_incomplete: (optional) A value of true indicates that
               both the IBM Cloud platform and the requesting client support asynchronous
               deprovisioning.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `ServiceInstanceManageDR` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        if location_id is None:
            raise ValueError('location_id must be provided')
        if machine_type is None:
            raise ValueError('machine_type must be provided')
        if orchestrator_location_type is None:
            raise ValueError('orchestrator_location_type must be provided')
        if orchestrator_name is None:
            raise ValueError('orchestrator_name must be provided')
        if orchestrator_password is None:
            raise ValueError('orchestrator_password must be provided')
        if orchestrator_workspace_id is None:
            raise ValueError('orchestrator_workspace_id must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='create_manage_dr',
        )
        headers.update(sdk_headers)

        params = {
            'stand_by_redeploy': stand_by_redeploy,
            'accepts_incomplete': accepts_incomplete,
        }

        data = {
            'location_id': location_id,
            'machine_type': machine_type,
            'orchestrator_location_type': orchestrator_location_type,
            'orchestrator_name': orchestrator_name,
            'orchestrator_password': orchestrator_password,
            'orchestrator_workspace_id': orchestrator_workspace_id,
            'api_key': api_key,
            'client_id': client_id,
            'client_secret': client_secret,
            'guid': guid,
            'orchestrator_ha': orchestrator_ha,
            'proxy_ip': proxy_ip,
            'region_id': region_id,
            'resource_instance': resource_instance,
            'secret': secret,
            'secret_group': secret_group,
            'ssh_key_name': ssh_key_name,
            'standby_machine_type': standby_machine_type,
            'standby_orchestrator_name': standby_orchestrator_name,
            'standby_orchestrator_workspace_id': standby_orchestrator_workspace_id,
            'standby_tier': standby_tier,
            'tenant_name': tenant_name,
            'tier': tier,
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/manage_dr/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='POST',
            url=url,
            headers=headers,
            params=params,
            data=data,
        )

        response = self.send(request, **kwargs)
        return response

    #########################
    # drAutomationServiceInstance
    #########################

    def get_last_operation(
        self,
        instance_id: str,
        *,
        accept_language: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        View details of Last operation performed on the instance.

        Retrieves the status of the last operation performed on the specified service
        instance, such as provisioning, updating, or deprovisioning.

        :param str instance_id: instance id of instance to provision.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `ServiceInstanceStatus` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='get_last_operation',
        )
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/last_operation/{instance_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
        )

        response = self.send(request, **kwargs)
        return response

    #########################
    # drEvents
    #########################

    def list_events(
        self,
        instance_id: str,
        *,
        time: Optional[str] = None,
        from_time: Optional[str] = None,
        to_time: Optional[str] = None,
        accept_language: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Get events from the cloud instance since a specific timestamp.

        Retrieves the list of events from the specified service instance ID.

        :param str instance_id: instance id of instance to provision.
        :param str time: (optional) (deprecated - use from_time) A time in either
               ISO 8601 or unix epoch format.
        :param str from_time: (optional) A from query time in either ISO 8601 or
               unix epoch format.
        :param str to_time: (optional) A to query time in either ISO 8601 or unix
               epoch format.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `EventCollection` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='list_events',
        )
        headers.update(sdk_headers)

        params = {
            'time': time,
            'from_time': from_time,
            'to_time': to_time,
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/service_instances/{instance_id}/events'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
            params=params,
        )

        response = self.send(request, **kwargs)
        return response

    def get_event(
        self,
        instance_id: str,
        event_id: str,
        *,
        accept_language: Optional[str] = None,
        **kwargs,
    ) -> DetailedResponse:
        """
        Get a single event.

        Retrieves the details of a specific event for the given service instance provision
        ID.

        :param str instance_id: instance id of instance to provision.
        :param str event_id: Event ID.
        :param str accept_language: (optional) The language requested for the
               return document.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Event` object
        """

        if not instance_id:
            raise ValueError('instance_id must be provided')
        if not event_id:
            raise ValueError('event_id must be provided')
        headers = {
            'Accept-Language': accept_language,
        }
        sdk_headers = get_sdk_headers(
            service_name=self.DEFAULT_SERVICE_NAME,
            service_version='V1',
            operation_id='get_event',
        )
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'event_id']
        path_param_values = self.encode_path_vars(instance_id, event_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/drautomation/v1/service_instances/{instance_id}/events/{event_id}'.format(**path_param_dict)
        request = self.prepare_request(
            method='GET',
            url=url,
            headers=headers,
        )

        response = self.send(request, **kwargs)
        return response


##############################################################################
# Models
##############################################################################


class DRStandbyWorkspace:
    """
    Represents the standby DR workspace details.

    :param DetailsDr details: (optional) The detailed information of the standby DR
          workspace.
    :param str id: (optional) The unique identifier of the standby workspace.
    :param LocationDr location: (optional) The location information of the standby
          workspace.
    :param str name: (optional) The name of the standby workspace.
    :param str status: (optional) The status of the standby workspace.
    """

    def __init__(
        self,
        *,
        details: Optional['DetailsDr'] = None,
        id: Optional[str] = None,
        location: Optional['LocationDr'] = None,
        name: Optional[str] = None,
        status: Optional[str] = None,
    ) -> None:
        """
        Initialize a DRStandbyWorkspace object.

        :param DetailsDr details: (optional) The detailed information of the
               standby DR workspace.
        :param str id: (optional) The unique identifier of the standby workspace.
        :param LocationDr location: (optional) The location information of the
               standby workspace.
        :param str name: (optional) The name of the standby workspace.
        :param str status: (optional) The status of the standby workspace.
        """
        self.details = details
        self.id = id
        self.location = location
        self.name = name
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DRStandbyWorkspace':
        """Initialize a DRStandbyWorkspace object from a json dictionary."""
        args = {}
        if (details := _dict.get('details')) is not None:
            args['details'] = DetailsDr.from_dict(details)
        if (id := _dict.get('id')) is not None:
            args['id'] = id
        if (location := _dict.get('location')) is not None:
            args['location'] = LocationDr.from_dict(location)
        if (name := _dict.get('name')) is not None:
            args['name'] = name
        if (status := _dict.get('status')) is not None:
            args['status'] = status
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DRStandbyWorkspace object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'details') and self.details is not None:
            if isinstance(self.details, dict):
                _dict['details'] = self.details
            else:
                _dict['details'] = self.details.to_dict()
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'location') and self.location is not None:
            if isinstance(self.location, dict):
                _dict['location'] = self.location
            else:
                _dict['location'] = self.location.to_dict()
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DRStandbyWorkspace object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DRStandbyWorkspace') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DRStandbyWorkspace') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class DRWorkspace:
    """
    Represents a disaster recovery workspace, including the details, location, and status.

    :param bool default: (optional) Indicates if this is the default DR workspace.
    :param DetailsDr details: (optional) The detailed information about the DR
          workspace.
    :param str id: (optional) The unique identifier of the DR workspace.
    :param LocationDr location: (optional) The location information of the DR
          workspace.
    :param str name: (optional) The name of the DR workspace.
    :param str status: (optional) The status of the DR workspace.
    """

    def __init__(
        self,
        *,
        default: Optional[bool] = None,
        details: Optional['DetailsDr'] = None,
        id: Optional[str] = None,
        location: Optional['LocationDr'] = None,
        name: Optional[str] = None,
        status: Optional[str] = None,
    ) -> None:
        """
        Initialize a DRWorkspace object.

        :param bool default: (optional) Indicates if this is the default DR
               workspace.
        :param DetailsDr details: (optional) The detailed information about the DR
               workspace.
        :param str id: (optional) The unique identifier of the DR workspace.
        :param LocationDr location: (optional) The location information of the DR
               workspace.
        :param str name: (optional) The name of the DR workspace.
        :param str status: (optional) The status of the DR workspace.
        """
        self.default = default
        self.details = details
        self.id = id
        self.location = location
        self.name = name
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DRWorkspace':
        """Initialize a DRWorkspace object from a json dictionary."""
        args = {}
        if (default := _dict.get('default')) is not None:
            args['default'] = default
        if (details := _dict.get('details')) is not None:
            args['details'] = DetailsDr.from_dict(details)
        if (id := _dict.get('id')) is not None:
            args['id'] = id
        if (location := _dict.get('location')) is not None:
            args['location'] = LocationDr.from_dict(location)
        if (name := _dict.get('name')) is not None:
            args['name'] = name
        if (status := _dict.get('status')) is not None:
            args['status'] = status
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DRWorkspace object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'default') and self.default is not None:
            _dict['default'] = self.default
        if hasattr(self, 'details') and self.details is not None:
            if isinstance(self.details, dict):
                _dict['details'] = self.details
            else:
                _dict['details'] = self.details.to_dict()
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'location') and self.location is not None:
            if isinstance(self.location, dict):
                _dict['location'] = self.location
            else:
                _dict['location'] = self.location.to_dict()
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DRWorkspace object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DRWorkspace') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DRWorkspace') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class DetailsDr:
    """
    Details of the DR workspace.

    :param str crn: (optional) Cloud Resource Name (CRN) of the DR workspace.
    """

    def __init__(
        self,
        *,
        crn: Optional[str] = None,
    ) -> None:
        """
        Initialize a DetailsDr object.

        :param str crn: (optional) Cloud Resource Name (CRN) of the DR workspace.
        """
        self.crn = crn

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DetailsDr':
        """Initialize a DetailsDr object from a json dictionary."""
        args = {}
        if (crn := _dict.get('crn')) is not None:
            args['crn'] = crn
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DetailsDr object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DetailsDr object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DetailsDr') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DetailsDr') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class DrAutomationGetSummaryResponse:
    """
    Response object containing all DR automation summary information.

    :param dict managed_vm_list: A flexible schema placeholder to allow any JSON
          value (aligns with interface{} in Go).
    :param OrchestratorDetails orchestrator_details: Contains details about the
          orchestrator configuration.
    :param ServiceDetails service_details: Contains details about the DR automation
          service.
    """

    def __init__(
        self,
        managed_vm_list: dict,
        orchestrator_details: 'OrchestratorDetails',
        service_details: 'ServiceDetails',
    ) -> None:
        """
        Initialize a DrAutomationGetSummaryResponse object.

        :param dict managed_vm_list: A flexible schema placeholder to allow any
               JSON value (aligns with interface{} in Go).
        :param OrchestratorDetails orchestrator_details: Contains details about the
               orchestrator configuration.
        :param ServiceDetails service_details: Contains details about the DR
               automation service.
        """
        self.managed_vm_list = managed_vm_list
        self.orchestrator_details = orchestrator_details
        self.service_details = service_details

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DrAutomationGetSummaryResponse':
        """Initialize a DrAutomationGetSummaryResponse object from a json dictionary."""
        args = {}
        if (managed_vm_list := _dict.get('managed_vm_list')) is not None:
            args['managed_vm_list'] = managed_vm_list
        else:
            raise ValueError('Required property \'managed_vm_list\' not present in DrAutomationGetSummaryResponse JSON')
        if (orchestrator_details := _dict.get('orchestrator_details')) is not None:
            args['orchestrator_details'] = OrchestratorDetails.from_dict(orchestrator_details)
        else:
            raise ValueError(
                'Required property \'orchestrator_details\' not present in DrAutomationGetSummaryResponse JSON'
            )
        if (service_details := _dict.get('service_details')) is not None:
            args['service_details'] = ServiceDetails.from_dict(service_details)
        else:
            raise ValueError('Required property \'service_details\' not present in DrAutomationGetSummaryResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DrAutomationGetSummaryResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'managed_vm_list') and self.managed_vm_list is not None:
            _dict['managed_vm_list'] = self.managed_vm_list
        if hasattr(self, 'orchestrator_details') and self.orchestrator_details is not None:
            if isinstance(self.orchestrator_details, dict):
                _dict['orchestrator_details'] = self.orchestrator_details
            else:
                _dict['orchestrator_details'] = self.orchestrator_details.to_dict()
        if hasattr(self, 'service_details') and self.service_details is not None:
            if isinstance(self.service_details, dict):
                _dict['service_details'] = self.service_details
            else:
                _dict['service_details'] = self.service_details.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DrAutomationGetSummaryResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DrAutomationGetSummaryResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DrAutomationGetSummaryResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class DrData:
    """
    The list of primary and standby disaster recovery Power virtual server workspaces.

    :param object dr_standby_workspace_description: (optional) Description of
          Standby Workspace.
    :param List[DRStandbyWorkspace] dr_standby_workspaces: The list of standby
          disaster recovery workspaces.
    :param object dr_workspace_description: (optional) Description of Workspace.
    :param List[DRWorkspace] dr_workspaces: The list of primary disaster recovery
          workspaces.
    """

    def __init__(
        self,
        dr_standby_workspaces: List['DRStandbyWorkspace'],
        dr_workspaces: List['DRWorkspace'],
        *,
        dr_standby_workspace_description: Optional[object] = None,
        dr_workspace_description: Optional[object] = None,
    ) -> None:
        """
        Initialize a DrData object.

        :param List[DRStandbyWorkspace] dr_standby_workspaces: The list of standby
               disaster recovery workspaces.
        :param List[DRWorkspace] dr_workspaces: The list of primary disaster
               recovery workspaces.
        :param object dr_standby_workspace_description: (optional) Description of
               Standby Workspace.
        :param object dr_workspace_description: (optional) Description of
               Workspace.
        """
        self.dr_standby_workspace_description = dr_standby_workspace_description
        self.dr_standby_workspaces = dr_standby_workspaces
        self.dr_workspace_description = dr_workspace_description
        self.dr_workspaces = dr_workspaces

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DrData':
        """Initialize a DrData object from a json dictionary."""
        args = {}
        if (dr_standby_workspace_description := _dict.get('dr_standby_workspace_description')) is not None:
            args['dr_standby_workspace_description'] = dr_standby_workspace_description
        if (dr_standby_workspaces := _dict.get('dr_standby_workspaces')) is not None:
            args['dr_standby_workspaces'] = [DRStandbyWorkspace.from_dict(v) for v in dr_standby_workspaces]
        else:
            raise ValueError('Required property \'dr_standby_workspaces\' not present in DrData JSON')
        if (dr_workspace_description := _dict.get('dr_workspace_description')) is not None:
            args['dr_workspace_description'] = dr_workspace_description
        if (dr_workspaces := _dict.get('dr_workspaces')) is not None:
            args['dr_workspaces'] = [DRWorkspace.from_dict(v) for v in dr_workspaces]
        else:
            raise ValueError('Required property \'dr_workspaces\' not present in DrData JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DrData object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'dr_standby_workspace_description') and self.dr_standby_workspace_description is not None:
            _dict['dr_standby_workspace_description'] = self.dr_standby_workspace_description
        if hasattr(self, 'dr_standby_workspaces') and self.dr_standby_workspaces is not None:
            dr_standby_workspaces_list = []
            for v in self.dr_standby_workspaces:
                if isinstance(v, dict):
                    dr_standby_workspaces_list.append(v)
                else:
                    dr_standby_workspaces_list.append(v.to_dict())
            _dict['dr_standby_workspaces'] = dr_standby_workspaces_list
        if hasattr(self, 'dr_workspace_description') and self.dr_workspace_description is not None:
            _dict['dr_workspace_description'] = self.dr_workspace_description
        if hasattr(self, 'dr_workspaces') and self.dr_workspaces is not None:
            dr_workspaces_list = []
            for v in self.dr_workspaces:
                if isinstance(v, dict):
                    dr_workspaces_list.append(v)
                else:
                    dr_workspaces_list.append(v.to_dict())
            _dict['dr_workspaces'] = dr_workspaces_list
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DrData object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DrData') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DrData') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class DrLocation:
    """
    Represents a disaster recovery location with its ID and name. .

    :param str id: (optional) Unique identifier of the DR location.
    :param str name: (optional) The name of the Power virtual server DR location .
    """

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
    ) -> None:
        """
        Initialize a DrLocation object.

        :param str id: (optional) Unique identifier of the DR location.
        :param str name: (optional) The name of the Power virtual server DR
               location .
        """
        self.id = id
        self.name = name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DrLocation':
        """Initialize a DrLocation object from a json dictionary."""
        args = {}
        if (id := _dict.get('id')) is not None:
            args['id'] = id
        if (name := _dict.get('name')) is not None:
            args['name'] = name
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DrLocation object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DrLocation object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DrLocation') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DrLocation') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class Event:
    """
    Represents an individual event in the system, including details about action,
    resource, user, and timestamps.

    :param str action: Type of action for this event.
    :param str api_source: (optional) Source of API when it being executed.
    :param str event_id: ID of the Activity.
    :param str level: Level of the event (notice, info, warning, error).
    :param str message: The (translated) message of the event.
    :param dict message_data: (optional) A flexible schema placeholder to allow any
          JSON value (aligns with interface{} in Go).
    :param dict metadata: (optional) A flexible schema placeholder to allow any JSON
          value (aligns with interface{} in Go).
    :param str resource: Type of resource for this event.
    :param datetime time: Time of activity in ISO 8601 - RFC3339.
    :param str timestamp: Time of activity in unix epoch.
    :param EventUser user: (optional) Information about a user associated with an
          event.
    """

    def __init__(
        self,
        action: str,
        event_id: str,
        level: str,
        message: str,
        resource: str,
        time: datetime,
        timestamp: str,
        *,
        api_source: Optional[str] = None,
        message_data: Optional[dict] = None,
        metadata: Optional[dict] = None,
        user: Optional['EventUser'] = None,
    ) -> None:
        """
        Initialize a Event object.

        :param str action: Type of action for this event.
        :param str event_id: ID of the Activity.
        :param str level: Level of the event (notice, info, warning, error).
        :param str message: The (translated) message of the event.
        :param str resource: Type of resource for this event.
        :param datetime time: Time of activity in ISO 8601 - RFC3339.
        :param str timestamp: Time of activity in unix epoch.
        :param str api_source: (optional) Source of API when it being executed.
        :param dict message_data: (optional) A flexible schema placeholder to allow
               any JSON value (aligns with interface{} in Go).
        :param dict metadata: (optional) A flexible schema placeholder to allow any
               JSON value (aligns with interface{} in Go).
        :param EventUser user: (optional) Information about a user associated with
               an event.
        """
        self.action = action
        self.api_source = api_source
        self.event_id = event_id
        self.level = level
        self.message = message
        self.message_data = message_data
        self.metadata = metadata
        self.resource = resource
        self.time = time
        self.timestamp = timestamp
        self.user = user

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Event':
        """Initialize a Event object from a json dictionary."""
        args = {}
        if (action := _dict.get('action')) is not None:
            args['action'] = action
        else:
            raise ValueError('Required property \'action\' not present in Event JSON')
        if (api_source := _dict.get('api_source')) is not None:
            args['api_source'] = api_source
        if (event_id := _dict.get('event_id')) is not None:
            args['event_id'] = event_id
        else:
            raise ValueError('Required property \'event_id\' not present in Event JSON')
        if (level := _dict.get('level')) is not None:
            args['level'] = level
        else:
            raise ValueError('Required property \'level\' not present in Event JSON')
        if (message := _dict.get('message')) is not None:
            args['message'] = message
        else:
            raise ValueError('Required property \'message\' not present in Event JSON')
        if (message_data := _dict.get('message_data')) is not None:
            args['message_data'] = message_data
        if (metadata := _dict.get('metadata')) is not None:
            args['metadata'] = metadata
        if (resource := _dict.get('resource')) is not None:
            args['resource'] = resource
        else:
            raise ValueError('Required property \'resource\' not present in Event JSON')
        if (time := _dict.get('time')) is not None:
            args['time'] = string_to_datetime(time)
        else:
            raise ValueError('Required property \'time\' not present in Event JSON')
        if (timestamp := _dict.get('timestamp')) is not None:
            args['timestamp'] = timestamp
        else:
            raise ValueError('Required property \'timestamp\' not present in Event JSON')
        if (user := _dict.get('user')) is not None:
            args['user'] = EventUser.from_dict(user)
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Event object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'action') and self.action is not None:
            _dict['action'] = self.action
        if hasattr(self, 'api_source') and self.api_source is not None:
            _dict['api_source'] = self.api_source
        if hasattr(self, 'event_id') and self.event_id is not None:
            _dict['event_id'] = self.event_id
        if hasattr(self, 'level') and self.level is not None:
            _dict['level'] = self.level
        if hasattr(self, 'message') and self.message is not None:
            _dict['message'] = self.message
        if hasattr(self, 'message_data') and self.message_data is not None:
            _dict['message_data'] = self.message_data
        if hasattr(self, 'metadata') and self.metadata is not None:
            _dict['metadata'] = self.metadata
        if hasattr(self, 'resource') and self.resource is not None:
            _dict['resource'] = self.resource
        if hasattr(self, 'time') and self.time is not None:
            _dict['time'] = datetime_to_string(self.time)
        if hasattr(self, 'timestamp') and self.timestamp is not None:
            _dict['timestamp'] = self.timestamp
        if hasattr(self, 'user') and self.user is not None:
            if isinstance(self.user, dict):
                _dict['user'] = self.user
            else:
                _dict['user'] = self.user.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Event object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Event') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Event') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class LevelEnum(str, Enum):
        """
        Level of the event (notice, info, warning, error).
        """

        NOTICE = 'notice'
        INFO = 'info'
        WARNING = 'warning'
        ERROR = 'error'


class EventCollection:
    """
    Container object holding a list of events.

    :param List[Event] events: Events.
    """

    def __init__(
        self,
        events: List['Event'],
    ) -> None:
        """
        Initialize a EventCollection object.

        :param List[Event] events: Events.
        """
        self.events = events

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'EventCollection':
        """Initialize a EventCollection object from a json dictionary."""
        args = {}
        if (events := _dict.get('events')) is not None:
            args['events'] = [Event.from_dict(v) for v in events]
        else:
            raise ValueError('Required property \'events\' not present in EventCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a EventCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'events') and self.events is not None:
            events_list = []
            for v in self.events:
                if isinstance(v, dict):
                    events_list.append(v)
                else:
                    events_list.append(v.to_dict())
            _dict['events'] = events_list
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this EventCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'EventCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'EventCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class EventUser:
    """
    Information about a user associated with an event.

    :param str email: (optional) Email of the User.
    :param str name: (optional) Name of the User.
    :param str user_id: ID of user who created/caused the event.
    """

    def __init__(
        self,
        user_id: str,
        *,
        email: Optional[str] = None,
        name: Optional[str] = None,
    ) -> None:
        """
        Initialize a EventUser object.

        :param str user_id: ID of user who created/caused the event.
        :param str email: (optional) Email of the User.
        :param str name: (optional) Name of the User.
        """
        self.email = email
        self.name = name
        self.user_id = user_id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'EventUser':
        """Initialize a EventUser object from a json dictionary."""
        args = {}
        if (email := _dict.get('email')) is not None:
            args['email'] = email
        if (name := _dict.get('name')) is not None:
            args['name'] = name
        if (user_id := _dict.get('user_id')) is not None:
            args['user_id'] = user_id
        else:
            raise ValueError('Required property \'user_id\' not present in EventUser JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a EventUser object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'email') and self.email is not None:
            _dict['email'] = self.email
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'user_id') and self.user_id is not None:
            _dict['user_id'] = self.user_id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this EventUser object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'EventUser') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'EventUser') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class GetDrLocationsResponse:
    """
    Response object containing a list of disaster recovery locations.

    :param List[DrLocation] dr_locations: List of disaster recovery locations
          available for the service.
    """

    def __init__(
        self,
        dr_locations: List['DrLocation'],
    ) -> None:
        """
        Initialize a GetDrLocationsResponse object.

        :param List[DrLocation] dr_locations: List of disaster recovery locations
               available for the service.
        """
        self.dr_locations = dr_locations

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GetDrLocationsResponse':
        """Initialize a GetDrLocationsResponse object from a json dictionary."""
        args = {}
        if (dr_locations := _dict.get('dr_locations')) is not None:
            args['dr_locations'] = [DrLocation.from_dict(v) for v in dr_locations]
        else:
            raise ValueError('Required property \'dr_locations\' not present in GetDrLocationsResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GetDrLocationsResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'dr_locations') and self.dr_locations is not None:
            dr_locations_list = []
            for v in self.dr_locations:
                if isinstance(v, dict):
                    dr_locations_list.append(v)
                else:
                    dr_locations_list.append(v.to_dict())
            _dict['dr_locations'] = dr_locations_list
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GetDrLocationsResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GetDrLocationsResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GetDrLocationsResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class GetGRSLocationPairResponse:
    """
    Response body containing GRS location pairs.

    :param dict location_pairs: (optional) A map of GRS location pairs where each
          key is a primary location and the value is its paired location.
    """

    def __init__(
        self,
        *,
        location_pairs: Optional[dict] = None,
    ) -> None:
        """
        Initialize a GetGRSLocationPairResponse object.

        :param dict location_pairs: (optional) A map of GRS location pairs where
               each key is a primary location and the value is its paired location.
        """
        self.location_pairs = location_pairs

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'GetGRSLocationPairResponse':
        """Initialize a GetGRSLocationPairResponse object from a json dictionary."""
        args = {}
        if (location_pairs := _dict.get('location_pairs')) is not None:
            args['location_pairs'] = location_pairs
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a GetGRSLocationPairResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'location_pairs') and self.location_pairs is not None:
            _dict['location_pairs'] = self.location_pairs
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this GetGRSLocationPairResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'GetGRSLocationPairResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'GetGRSLocationPairResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class LocationDr:
    """
    Represents a disaster recovery location.

    :param str region: (optional) The region identifier of the DR location.
    :param str type: (optional) The type of location (e.g., data-center,
          cloud-region).
    :param str url: (optional) The URL endpoint to access the DR location.
    """

    def __init__(
        self,
        *,
        region: Optional[str] = None,
        type: Optional[str] = None,
        url: Optional[str] = None,
    ) -> None:
        """
        Initialize a LocationDr object.

        :param str region: (optional) The region identifier of the DR location.
        :param str type: (optional) The type of location (e.g., data-center,
               cloud-region).
        :param str url: (optional) The URL endpoint to access the DR location.
        """
        self.region = region
        self.type = type
        self.url = url

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'LocationDr':
        """Initialize a LocationDr object from a json dictionary."""
        args = {}
        if (region := _dict.get('region')) is not None:
            args['region'] = region
        if (type := _dict.get('type')) is not None:
            args['type'] = type
        if (url := _dict.get('url')) is not None:
            args['url'] = url
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a LocationDr object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'region') and self.region is not None:
            _dict['region'] = self.region
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'url') and self.url is not None:
            _dict['url'] = self.url
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this LocationDr object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'LocationDr') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'LocationDr') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class MachineTypesByWorkspace:
    """
    The Response body containing machine types supported by power virtual server
    workspace.

    :param dict workspaces: (optional) The Map of workspace IDs to lists of machine
          types.
    """

    def __init__(
        self,
        *,
        workspaces: Optional[dict] = None,
    ) -> None:
        """
        Initialize a MachineTypesByWorkspace object.

        :param dict workspaces: (optional) The Map of workspace IDs to lists of
               machine types.
        """
        self.workspaces = workspaces

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'MachineTypesByWorkspace':
        """Initialize a MachineTypesByWorkspace object from a json dictionary."""
        args = {}
        if (workspaces := _dict.get('workspaces')) is not None:
            args['workspaces'] = workspaces
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a MachineTypesByWorkspace object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'workspaces') and self.workspaces is not None:
            _dict['workspaces'] = self.workspaces
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this MachineTypesByWorkspace object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'MachineTypesByWorkspace') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'MachineTypesByWorkspace') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ManagedVmDetails:
    """
    The detailed information of a disaster recovery enabled virtual machines for the
    service.

    :param str core: (optional) The Number of cores assigned to the managed vitual
          machine.
    :param str dr_average_time: (optional) The DR operation average time(in minutes)
          for the managed virtual machine.
    :param str dr_region: (optional) The name of the region where the virtual
          machine is recovered.
    :param str memory: (optional) The amount of memory (in GB) assigned to the
          managed virtual machine.
    :param str region: (optional) The source region where the managed virtual
          machine is deployed.
    :param str vm_name: (optional) The name of the managed virtual machine.
    :param str workgroup_name: (optional) The name of the workgroup where the
          managed virtual machine is added for disaster recovery.
    :param str workspace_name: (optional) The Name of the power virtual server
          workspace.
    """

    def __init__(
        self,
        *,
        core: Optional[str] = None,
        dr_average_time: Optional[str] = None,
        dr_region: Optional[str] = None,
        memory: Optional[str] = None,
        region: Optional[str] = None,
        vm_name: Optional[str] = None,
        workgroup_name: Optional[str] = None,
        workspace_name: Optional[str] = None,
    ) -> None:
        """
        Initialize a ManagedVmDetails object.

        :param str core: (optional) The Number of cores assigned to the managed
               vitual machine.
        :param str dr_average_time: (optional) The DR operation average time(in
               minutes) for the managed virtual machine.
        :param str dr_region: (optional) The name of the region where the virtual
               machine is recovered.
        :param str memory: (optional) The amount of memory (in GB) assigned to the
               managed virtual machine.
        :param str region: (optional) The source region where the managed virtual
               machine is deployed.
        :param str vm_name: (optional) The name of the managed virtual machine.
        :param str workgroup_name: (optional) The name of the workgroup where the
               managed virtual machine is added for disaster recovery.
        :param str workspace_name: (optional) The Name of the power virtual server
               workspace.
        """
        self.core = core
        self.dr_average_time = dr_average_time
        self.dr_region = dr_region
        self.memory = memory
        self.region = region
        self.vm_name = vm_name
        self.workgroup_name = workgroup_name
        self.workspace_name = workspace_name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ManagedVmDetails':
        """Initialize a ManagedVmDetails object from a json dictionary."""
        args = {}
        if (core := _dict.get('core')) is not None:
            args['core'] = core
        if (dr_average_time := _dict.get('dr_average_time')) is not None:
            args['dr_average_time'] = dr_average_time
        if (dr_region := _dict.get('dr_region')) is not None:
            args['dr_region'] = dr_region
        if (memory := _dict.get('memory')) is not None:
            args['memory'] = memory
        if (region := _dict.get('region')) is not None:
            args['region'] = region
        if (vm_name := _dict.get('vm_name')) is not None:
            args['vm_name'] = vm_name
        if (workgroup_name := _dict.get('workgroup_name')) is not None:
            args['workgroup_name'] = workgroup_name
        if (workspace_name := _dict.get('workspace_name')) is not None:
            args['workspace_name'] = workspace_name
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ManagedVmDetails object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'core') and self.core is not None:
            _dict['core'] = self.core
        if hasattr(self, 'dr_average_time') and self.dr_average_time is not None:
            _dict['dr_average_time'] = self.dr_average_time
        if hasattr(self, 'dr_region') and self.dr_region is not None:
            _dict['dr_region'] = self.dr_region
        if hasattr(self, 'memory') and self.memory is not None:
            _dict['memory'] = self.memory
        if hasattr(self, 'region') and self.region is not None:
            _dict['region'] = self.region
        if hasattr(self, 'vm_name') and self.vm_name is not None:
            _dict['vm_name'] = self.vm_name
        if hasattr(self, 'workgroup_name') and self.workgroup_name is not None:
            _dict['workgroup_name'] = self.workgroup_name
        if hasattr(self, 'workspace_name') and self.workspace_name is not None:
            _dict['workspace_name'] = self.workspace_name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ManagedVmDetails object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ManagedVmDetails') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ManagedVmDetails') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ManagedVmMapResponse:
    """
    Map of VM IDs to managed VM details.

    :param dict managed_vm_list: (optional) A map where the key is the VM ID and the
          value is the corresponding ManagedVmDetails object.
    """

    def __init__(
        self,
        *,
        managed_vm_list: Optional[dict] = None,
    ) -> None:
        """
        Initialize a ManagedVmMapResponse object.

        :param dict managed_vm_list: (optional) A map where the key is the VM ID
               and the value is the corresponding ManagedVmDetails object.
        """
        self.managed_vm_list = managed_vm_list

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ManagedVmMapResponse':
        """Initialize a ManagedVmMapResponse object from a json dictionary."""
        args = {}
        if (managed_vm_list := _dict.get('managed_vm_list')) is not None:
            args['managed_vm_list'] = {k: ManagedVmDetails.from_dict(v) for k, v in managed_vm_list.items()}
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ManagedVmMapResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'managed_vm_list') and self.managed_vm_list is not None:
            managed_vm_list_map = {}
            for k, v in self.managed_vm_list.items():
                if isinstance(v, dict):
                    managed_vm_list_map[k] = v
                else:
                    managed_vm_list_map[k] = v.to_dict()
            _dict['managed_vm_list'] = managed_vm_list_map
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ManagedVmMapResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ManagedVmMapResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ManagedVmMapResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class OrchestratorDetails:
    """
    Contains details about the orchestrator configuration.

    :param datetime last_updated_orchestrator_deployment_time: The deployment time
          of primary orchestrator VM.
    :param datetime last_updated_standby_orchestrator_deployment_time: The
          deployment time of StandBy orchestrator VM.
    :param datetime latest_orchestrator_time: (optional) Latest Orchestrator Time in
          COS.
    :param str location_id: The unique identifier of location.
    :param str mfa_enabled: indicates if Multi Factor Authentication is enabled or
          not.
    :param str orch_ext_connectivity_status: The external connectivity status of the
          orchestrator.
    :param str orch_standby_node_addition_status: The status of standby node
          addition.
    :param str orchestrator_cluster_message: The message regarding orchestrator
          cluster status.
    :param str orchestrator_config_status: The configuration status of the
          orchestrator.
    :param str orchestrator_group_leader: The leader node of the orchestrator group.
    :param str orchestrator_location_type: The type of orchestrator Location.
    :param str orchestrator_name: The name of the primary orchestrator.
    :param str orchestrator_status: The status of the primary orchestrator.
    :param str orchestrator_workspace_name: The name of the orchestrator workspace.
    :param str proxy_ip: The IP address of the proxy.
    :param str schematic_workspace_name: The name of the schematic workspace.
    :param str schematic_workspace_status: The status of the schematic workspace.
    :param str ssh_key_name: SSH key name used for the orchestrator.
    :param str standby_orchestrator_name: The name of the standby orchestrator.
    :param str standby_orchestrator_status: The status of the standby orchestrator.
    :param str standby_orchestrator_workspace_name: The name of the standby
          orchestrator workspace.
    :param str transit_gateway_name: The name of the transit gateway.
    :param str vpc_name: The name of the VPC.
    """

    def __init__(
        self,
        last_updated_orchestrator_deployment_time: datetime,
        last_updated_standby_orchestrator_deployment_time: datetime,
        location_id: str,
        mfa_enabled: str,
        orch_ext_connectivity_status: str,
        orch_standby_node_addition_status: str,
        orchestrator_cluster_message: str,
        orchestrator_config_status: str,
        orchestrator_group_leader: str,
        orchestrator_location_type: str,
        orchestrator_name: str,
        orchestrator_status: str,
        orchestrator_workspace_name: str,
        proxy_ip: str,
        schematic_workspace_name: str,
        schematic_workspace_status: str,
        ssh_key_name: str,
        standby_orchestrator_name: str,
        standby_orchestrator_status: str,
        standby_orchestrator_workspace_name: str,
        transit_gateway_name: str,
        vpc_name: str,
        *,
        latest_orchestrator_time: Optional[datetime] = None,
    ) -> None:
        """
        Initialize a OrchestratorDetails object.

        :param datetime last_updated_orchestrator_deployment_time: The deployment
               time of primary orchestrator VM.
        :param datetime last_updated_standby_orchestrator_deployment_time: The
               deployment time of StandBy orchestrator VM.
        :param str location_id: The unique identifier of location.
        :param str mfa_enabled: indicates if Multi Factor Authentication is enabled
               or not.
        :param str orch_ext_connectivity_status: The external connectivity status
               of the orchestrator.
        :param str orch_standby_node_addition_status: The status of standby node
               addition.
        :param str orchestrator_cluster_message: The message regarding orchestrator
               cluster status.
        :param str orchestrator_config_status: The configuration status of the
               orchestrator.
        :param str orchestrator_group_leader: The leader node of the orchestrator
               group.
        :param str orchestrator_location_type: The type of orchestrator Location.
        :param str orchestrator_name: The name of the primary orchestrator.
        :param str orchestrator_status: The status of the primary orchestrator.
        :param str orchestrator_workspace_name: The name of the orchestrator
               workspace.
        :param str proxy_ip: The IP address of the proxy.
        :param str schematic_workspace_name: The name of the schematic workspace.
        :param str schematic_workspace_status: The status of the schematic
               workspace.
        :param str ssh_key_name: SSH key name used for the orchestrator.
        :param str standby_orchestrator_name: The name of the standby orchestrator.
        :param str standby_orchestrator_status: The status of the standby
               orchestrator.
        :param str standby_orchestrator_workspace_name: The name of the standby
               orchestrator workspace.
        :param str transit_gateway_name: The name of the transit gateway.
        :param str vpc_name: The name of the VPC.
        :param datetime latest_orchestrator_time: (optional) Latest Orchestrator
               Time in COS.
        """
        self.last_updated_orchestrator_deployment_time = last_updated_orchestrator_deployment_time
        self.last_updated_standby_orchestrator_deployment_time = last_updated_standby_orchestrator_deployment_time
        self.latest_orchestrator_time = latest_orchestrator_time
        self.location_id = location_id
        self.mfa_enabled = mfa_enabled
        self.orch_ext_connectivity_status = orch_ext_connectivity_status
        self.orch_standby_node_addition_status = orch_standby_node_addition_status
        self.orchestrator_cluster_message = orchestrator_cluster_message
        self.orchestrator_config_status = orchestrator_config_status
        self.orchestrator_group_leader = orchestrator_group_leader
        self.orchestrator_location_type = orchestrator_location_type
        self.orchestrator_name = orchestrator_name
        self.orchestrator_status = orchestrator_status
        self.orchestrator_workspace_name = orchestrator_workspace_name
        self.proxy_ip = proxy_ip
        self.schematic_workspace_name = schematic_workspace_name
        self.schematic_workspace_status = schematic_workspace_status
        self.ssh_key_name = ssh_key_name
        self.standby_orchestrator_name = standby_orchestrator_name
        self.standby_orchestrator_status = standby_orchestrator_status
        self.standby_orchestrator_workspace_name = standby_orchestrator_workspace_name
        self.transit_gateway_name = transit_gateway_name
        self.vpc_name = vpc_name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'OrchestratorDetails':
        """Initialize a OrchestratorDetails object from a json dictionary."""
        args = {}
        if (
            last_updated_orchestrator_deployment_time := _dict.get('last_updated_orchestrator_deployment_time')
        ) is not None:
            args['last_updated_orchestrator_deployment_time'] = string_to_datetime(
                last_updated_orchestrator_deployment_time
            )
        else:
            raise ValueError(
                'Required property \'last_updated_orchestrator_deployment_time\' not present in OrchestratorDetails JSON'
            )
        if (
            last_updated_standby_orchestrator_deployment_time := _dict.get(
                'last_updated_standby_orchestrator_deployment_time'
            )
        ) is not None:
            args['last_updated_standby_orchestrator_deployment_time'] = string_to_datetime(
                last_updated_standby_orchestrator_deployment_time
            )
        else:
            raise ValueError(
                'Required property \'last_updated_standby_orchestrator_deployment_time\' not present in OrchestratorDetails JSON'
            )
        if (latest_orchestrator_time := _dict.get('latest_orchestrator_time')) is not None:
            args['latest_orchestrator_time'] = string_to_datetime(latest_orchestrator_time)
        if (location_id := _dict.get('location_id')) is not None:
            args['location_id'] = location_id
        else:
            raise ValueError('Required property \'location_id\' not present in OrchestratorDetails JSON')
        if (mfa_enabled := _dict.get('mfa_enabled')) is not None:
            args['mfa_enabled'] = mfa_enabled
        else:
            raise ValueError('Required property \'mfa_enabled\' not present in OrchestratorDetails JSON')
        if (orch_ext_connectivity_status := _dict.get('orch_ext_connectivity_status')) is not None:
            args['orch_ext_connectivity_status'] = orch_ext_connectivity_status
        else:
            raise ValueError(
                'Required property \'orch_ext_connectivity_status\' not present in OrchestratorDetails JSON'
            )
        if (orch_standby_node_addition_status := _dict.get('orch_standby_node_addition_status')) is not None:
            args['orch_standby_node_addition_status'] = orch_standby_node_addition_status
        else:
            raise ValueError(
                'Required property \'orch_standby_node_addition_status\' not present in OrchestratorDetails JSON'
            )
        if (orchestrator_cluster_message := _dict.get('orchestrator_cluster_message')) is not None:
            args['orchestrator_cluster_message'] = orchestrator_cluster_message
        else:
            raise ValueError(
                'Required property \'orchestrator_cluster_message\' not present in OrchestratorDetails JSON'
            )
        if (orchestrator_config_status := _dict.get('orchestrator_config_status')) is not None:
            args['orchestrator_config_status'] = orchestrator_config_status
        else:
            raise ValueError('Required property \'orchestrator_config_status\' not present in OrchestratorDetails JSON')
        if (orchestrator_group_leader := _dict.get('orchestrator_group_leader')) is not None:
            args['orchestrator_group_leader'] = orchestrator_group_leader
        else:
            raise ValueError('Required property \'orchestrator_group_leader\' not present in OrchestratorDetails JSON')
        if (orchestrator_location_type := _dict.get('orchestrator_location_type')) is not None:
            args['orchestrator_location_type'] = orchestrator_location_type
        else:
            raise ValueError('Required property \'orchestrator_location_type\' not present in OrchestratorDetails JSON')
        if (orchestrator_name := _dict.get('orchestrator_name')) is not None:
            args['orchestrator_name'] = orchestrator_name
        else:
            raise ValueError('Required property \'orchestrator_name\' not present in OrchestratorDetails JSON')
        if (orchestrator_status := _dict.get('orchestrator_status')) is not None:
            args['orchestrator_status'] = orchestrator_status
        else:
            raise ValueError('Required property \'orchestrator_status\' not present in OrchestratorDetails JSON')
        if (orchestrator_workspace_name := _dict.get('orchestrator_workspace_name')) is not None:
            args['orchestrator_workspace_name'] = orchestrator_workspace_name
        else:
            raise ValueError(
                'Required property \'orchestrator_workspace_name\' not present in OrchestratorDetails JSON'
            )
        if (proxy_ip := _dict.get('proxy_ip')) is not None:
            args['proxy_ip'] = proxy_ip
        else:
            raise ValueError('Required property \'proxy_ip\' not present in OrchestratorDetails JSON')
        if (schematic_workspace_name := _dict.get('schematic_workspace_name')) is not None:
            args['schematic_workspace_name'] = schematic_workspace_name
        else:
            raise ValueError('Required property \'schematic_workspace_name\' not present in OrchestratorDetails JSON')
        if (schematic_workspace_status := _dict.get('schematic_workspace_status')) is not None:
            args['schematic_workspace_status'] = schematic_workspace_status
        else:
            raise ValueError('Required property \'schematic_workspace_status\' not present in OrchestratorDetails JSON')
        if (ssh_key_name := _dict.get('ssh_key_name')) is not None:
            args['ssh_key_name'] = ssh_key_name
        else:
            raise ValueError('Required property \'ssh_key_name\' not present in OrchestratorDetails JSON')
        if (standby_orchestrator_name := _dict.get('standby_orchestrator_name')) is not None:
            args['standby_orchestrator_name'] = standby_orchestrator_name
        else:
            raise ValueError('Required property \'standby_orchestrator_name\' not present in OrchestratorDetails JSON')
        if (standby_orchestrator_status := _dict.get('standby_orchestrator_status')) is not None:
            args['standby_orchestrator_status'] = standby_orchestrator_status
        else:
            raise ValueError(
                'Required property \'standby_orchestrator_status\' not present in OrchestratorDetails JSON'
            )
        if (standby_orchestrator_workspace_name := _dict.get('standby_orchestrator_workspace_name')) is not None:
            args['standby_orchestrator_workspace_name'] = standby_orchestrator_workspace_name
        else:
            raise ValueError(
                'Required property \'standby_orchestrator_workspace_name\' not present in OrchestratorDetails JSON'
            )
        if (transit_gateway_name := _dict.get('transit_gateway_name')) is not None:
            args['transit_gateway_name'] = transit_gateway_name
        else:
            raise ValueError('Required property \'transit_gateway_name\' not present in OrchestratorDetails JSON')
        if (vpc_name := _dict.get('vpc_name')) is not None:
            args['vpc_name'] = vpc_name
        else:
            raise ValueError('Required property \'vpc_name\' not present in OrchestratorDetails JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a OrchestratorDetails object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if (
            hasattr(self, 'last_updated_orchestrator_deployment_time')
            and self.last_updated_orchestrator_deployment_time is not None
        ):
            _dict['last_updated_orchestrator_deployment_time'] = datetime_to_string(
                self.last_updated_orchestrator_deployment_time
            )
        if (
            hasattr(self, 'last_updated_standby_orchestrator_deployment_time')
            and self.last_updated_standby_orchestrator_deployment_time is not None
        ):
            _dict['last_updated_standby_orchestrator_deployment_time'] = datetime_to_string(
                self.last_updated_standby_orchestrator_deployment_time
            )
        if hasattr(self, 'latest_orchestrator_time') and self.latest_orchestrator_time is not None:
            _dict['latest_orchestrator_time'] = datetime_to_string(self.latest_orchestrator_time)
        if hasattr(self, 'location_id') and self.location_id is not None:
            _dict['location_id'] = self.location_id
        if hasattr(self, 'mfa_enabled') and self.mfa_enabled is not None:
            _dict['mfa_enabled'] = self.mfa_enabled
        if hasattr(self, 'orch_ext_connectivity_status') and self.orch_ext_connectivity_status is not None:
            _dict['orch_ext_connectivity_status'] = self.orch_ext_connectivity_status
        if hasattr(self, 'orch_standby_node_addition_status') and self.orch_standby_node_addition_status is not None:
            _dict['orch_standby_node_addition_status'] = self.orch_standby_node_addition_status
        if hasattr(self, 'orchestrator_cluster_message') and self.orchestrator_cluster_message is not None:
            _dict['orchestrator_cluster_message'] = self.orchestrator_cluster_message
        if hasattr(self, 'orchestrator_config_status') and self.orchestrator_config_status is not None:
            _dict['orchestrator_config_status'] = self.orchestrator_config_status
        if hasattr(self, 'orchestrator_group_leader') and self.orchestrator_group_leader is not None:
            _dict['orchestrator_group_leader'] = self.orchestrator_group_leader
        if hasattr(self, 'orchestrator_location_type') and self.orchestrator_location_type is not None:
            _dict['orchestrator_location_type'] = self.orchestrator_location_type
        if hasattr(self, 'orchestrator_name') and self.orchestrator_name is not None:
            _dict['orchestrator_name'] = self.orchestrator_name
        if hasattr(self, 'orchestrator_status') and self.orchestrator_status is not None:
            _dict['orchestrator_status'] = self.orchestrator_status
        if hasattr(self, 'orchestrator_workspace_name') and self.orchestrator_workspace_name is not None:
            _dict['orchestrator_workspace_name'] = self.orchestrator_workspace_name
        if hasattr(self, 'proxy_ip') and self.proxy_ip is not None:
            _dict['proxy_ip'] = self.proxy_ip
        if hasattr(self, 'schematic_workspace_name') and self.schematic_workspace_name is not None:
            _dict['schematic_workspace_name'] = self.schematic_workspace_name
        if hasattr(self, 'schematic_workspace_status') and self.schematic_workspace_status is not None:
            _dict['schematic_workspace_status'] = self.schematic_workspace_status
        if hasattr(self, 'ssh_key_name') and self.ssh_key_name is not None:
            _dict['ssh_key_name'] = self.ssh_key_name
        if hasattr(self, 'standby_orchestrator_name') and self.standby_orchestrator_name is not None:
            _dict['standby_orchestrator_name'] = self.standby_orchestrator_name
        if hasattr(self, 'standby_orchestrator_status') and self.standby_orchestrator_status is not None:
            _dict['standby_orchestrator_status'] = self.standby_orchestrator_status
        if (
            hasattr(self, 'standby_orchestrator_workspace_name')
            and self.standby_orchestrator_workspace_name is not None
        ):
            _dict['standby_orchestrator_workspace_name'] = self.standby_orchestrator_workspace_name
        if hasattr(self, 'transit_gateway_name') and self.transit_gateway_name is not None:
            _dict['transit_gateway_name'] = self.transit_gateway_name
        if hasattr(self, 'vpc_name') and self.vpc_name is not None:
            _dict['vpc_name'] = self.vpc_name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this OrchestratorDetails object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'OrchestratorDetails') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'OrchestratorDetails') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ServiceDetails:
    """
    Contains details about the DR automation service.

    :param str crn: The deployment crn.
    :param str deployment_name: The name of the deployment.
    :param str description: The Service description.
    :param bool orchestrator_ha: The flag indicating whether orchestartor HA is
          enabled.
    :param str plan_name: The plan name.
    :param str primary_ip_address: The service Orchestator primary IP address.
    :param str primary_orchestrator_dashboard_url: The Primary Orchestrator
          Dashboard URL.
    :param str recovery_location: The disaster recovery location.
    :param str resource_group: The Resource group name.
    :param str standby_description: The standby orchestrator current status details.
    :param str standby_ip_address: The service Orchestator standby IP address.
    :param str standby_orchestrator_dashboard_url: The Standby Orchestrator
          Dashboard URL.
    :param str standby_status: The standby orchestrator current status.
    :param str status: The Status of the service.
    """

    def __init__(
        self,
        crn: str,
        deployment_name: str,
        description: str,
        orchestrator_ha: bool,
        plan_name: str,
        primary_ip_address: str,
        primary_orchestrator_dashboard_url: str,
        recovery_location: str,
        resource_group: str,
        standby_description: str,
        standby_ip_address: str,
        standby_orchestrator_dashboard_url: str,
        standby_status: str,
        status: str,
    ) -> None:
        """
        Initialize a ServiceDetails object.

        :param str crn: The deployment crn.
        :param str deployment_name: The name of the deployment.
        :param str description: The Service description.
        :param bool orchestrator_ha: The flag indicating whether orchestartor HA is
               enabled.
        :param str plan_name: The plan name.
        :param str primary_ip_address: The service Orchestator primary IP address.
        :param str primary_orchestrator_dashboard_url: The Primary Orchestrator
               Dashboard URL.
        :param str recovery_location: The disaster recovery location.
        :param str resource_group: The Resource group name.
        :param str standby_description: The standby orchestrator current status
               details.
        :param str standby_ip_address: The service Orchestator standby IP address.
        :param str standby_orchestrator_dashboard_url: The Standby Orchestrator
               Dashboard URL.
        :param str standby_status: The standby orchestrator current status.
        :param str status: The Status of the service.
        """
        self.crn = crn
        self.deployment_name = deployment_name
        self.description = description
        self.orchestrator_ha = orchestrator_ha
        self.plan_name = plan_name
        self.primary_ip_address = primary_ip_address
        self.primary_orchestrator_dashboard_url = primary_orchestrator_dashboard_url
        self.recovery_location = recovery_location
        self.resource_group = resource_group
        self.standby_description = standby_description
        self.standby_ip_address = standby_ip_address
        self.standby_orchestrator_dashboard_url = standby_orchestrator_dashboard_url
        self.standby_status = standby_status
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ServiceDetails':
        """Initialize a ServiceDetails object from a json dictionary."""
        args = {}
        if (crn := _dict.get('crn')) is not None:
            args['crn'] = crn
        else:
            raise ValueError('Required property \'crn\' not present in ServiceDetails JSON')
        if (deployment_name := _dict.get('deployment_name')) is not None:
            args['deployment_name'] = deployment_name
        else:
            raise ValueError('Required property \'deployment_name\' not present in ServiceDetails JSON')
        if (description := _dict.get('description')) is not None:
            args['description'] = description
        else:
            raise ValueError('Required property \'description\' not present in ServiceDetails JSON')
        if (orchestrator_ha := _dict.get('orchestrator_ha')) is not None:
            args['orchestrator_ha'] = orchestrator_ha
        else:
            raise ValueError('Required property \'orchestrator_ha\' not present in ServiceDetails JSON')
        if (plan_name := _dict.get('plan_name')) is not None:
            args['plan_name'] = plan_name
        else:
            raise ValueError('Required property \'plan_name\' not present in ServiceDetails JSON')
        if (primary_ip_address := _dict.get('primary_ip_address')) is not None:
            args['primary_ip_address'] = primary_ip_address
        else:
            raise ValueError('Required property \'primary_ip_address\' not present in ServiceDetails JSON')
        if (primary_orchestrator_dashboard_url := _dict.get('primary_orchestrator_dashboard_url')) is not None:
            args['primary_orchestrator_dashboard_url'] = primary_orchestrator_dashboard_url
        else:
            raise ValueError(
                'Required property \'primary_orchestrator_dashboard_url\' not present in ServiceDetails JSON'
            )
        if (recovery_location := _dict.get('recovery_location')) is not None:
            args['recovery_location'] = recovery_location
        else:
            raise ValueError('Required property \'recovery_location\' not present in ServiceDetails JSON')
        if (resource_group := _dict.get('resource_group')) is not None:
            args['resource_group'] = resource_group
        else:
            raise ValueError('Required property \'resource_group\' not present in ServiceDetails JSON')
        if (standby_description := _dict.get('standby_description')) is not None:
            args['standby_description'] = standby_description
        else:
            raise ValueError('Required property \'standby_description\' not present in ServiceDetails JSON')
        if (standby_ip_address := _dict.get('standby_ip_address')) is not None:
            args['standby_ip_address'] = standby_ip_address
        else:
            raise ValueError('Required property \'standby_ip_address\' not present in ServiceDetails JSON')
        if (standby_orchestrator_dashboard_url := _dict.get('standby_orchestrator_dashboard_url')) is not None:
            args['standby_orchestrator_dashboard_url'] = standby_orchestrator_dashboard_url
        else:
            raise ValueError(
                'Required property \'standby_orchestrator_dashboard_url\' not present in ServiceDetails JSON'
            )
        if (standby_status := _dict.get('standby_status')) is not None:
            args['standby_status'] = standby_status
        else:
            raise ValueError('Required property \'standby_status\' not present in ServiceDetails JSON')
        if (status := _dict.get('status')) is not None:
            args['status'] = status
        else:
            raise ValueError('Required property \'status\' not present in ServiceDetails JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ServiceDetails object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'deployment_name') and self.deployment_name is not None:
            _dict['deployment_name'] = self.deployment_name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'orchestrator_ha') and self.orchestrator_ha is not None:
            _dict['orchestrator_ha'] = self.orchestrator_ha
        if hasattr(self, 'plan_name') and self.plan_name is not None:
            _dict['plan_name'] = self.plan_name
        if hasattr(self, 'primary_ip_address') and self.primary_ip_address is not None:
            _dict['primary_ip_address'] = self.primary_ip_address
        if hasattr(self, 'primary_orchestrator_dashboard_url') and self.primary_orchestrator_dashboard_url is not None:
            _dict['primary_orchestrator_dashboard_url'] = self.primary_orchestrator_dashboard_url
        if hasattr(self, 'recovery_location') and self.recovery_location is not None:
            _dict['recovery_location'] = self.recovery_location
        if hasattr(self, 'resource_group') and self.resource_group is not None:
            _dict['resource_group'] = self.resource_group
        if hasattr(self, 'standby_description') and self.standby_description is not None:
            _dict['standby_description'] = self.standby_description
        if hasattr(self, 'standby_ip_address') and self.standby_ip_address is not None:
            _dict['standby_ip_address'] = self.standby_ip_address
        if hasattr(self, 'standby_orchestrator_dashboard_url') and self.standby_orchestrator_dashboard_url is not None:
            _dict['standby_orchestrator_dashboard_url'] = self.standby_orchestrator_dashboard_url
        if hasattr(self, 'standby_status') and self.standby_status is not None:
            _dict['standby_status'] = self.standby_status
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ServiceDetails object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ServiceDetails') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ServiceDetails') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ServiceInstanceManageDR:
    """
    Represents the response details for managing a DR service instance.

    :param str dashboard_url: (optional) URL to the dashboard for managing the DR
          service instance in IBM Cloud.
    :param str id: (optional) The CRN (Cloud Resource Name) of the DR service
          instance.
    """

    def __init__(
        self,
        *,
        dashboard_url: Optional[str] = None,
        id: Optional[str] = None,
    ) -> None:
        """
        Initialize a ServiceInstanceManageDR object.

        :param str dashboard_url: (optional) URL to the dashboard for managing the
               DR service instance in IBM Cloud.
        :param str id: (optional) The CRN (Cloud Resource Name) of the DR service
               instance.
        """
        self.dashboard_url = dashboard_url
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ServiceInstanceManageDR':
        """Initialize a ServiceInstanceManageDR object from a json dictionary."""
        args = {}
        if (dashboard_url := _dict.get('dashboard_url')) is not None:
            args['dashboard_url'] = dashboard_url
        if (id := _dict.get('id')) is not None:
            args['id'] = id
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ServiceInstanceManageDR object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'dashboard_url') and self.dashboard_url is not None:
            _dict['dashboard_url'] = self.dashboard_url
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ServiceInstanceManageDR object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ServiceInstanceManageDR') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ServiceInstanceManageDR') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ServiceInstanceStatus:
    """
    Represents the current status and details of a service instance including orchestrator
    state, networking, and recovery information.

    :param str crn: The service instance crn.
    :param str deployment_name: The name of the service instance deployment.
    :param datetime last_updated_orchestrator_deployment_time: The deployment time
          of primary orchestrator VM.
    :param datetime last_updated_standby_orchestrator_deployment_time: The
          deployment time of StandBy orchestrator VM.
    :param str mfa_enabled: Indicated whether multi factor authentication is
          ennabled or not.
    :param str orch_ext_connectivity_status: (optional) Status of standby node
          addition to the orchestrator cluster.
    :param str orch_standby_node_addtion_status: The status of standby node in the
          Orchestrator cluster.
    :param str orchestrator_cluster_message: The current status of the primary
          orchestrator VM.
    :param str orchestrator_config_status: The configuration status of the
          orchestrator cluster.
    :param bool orchestrator_ha: Indicates whether high availability (HA) is enabled
          for the orchestrator.
    :param str plan_name: The name of the DR Automation plan.
    :param str primary_description: Indicates the progress details of primary
          orchestrator creation.
    :param str primary_ip_address: The IP address of the primary orchestrator VM.
    :param str primary_orchestrator_status: The configuration status of the
          orchestrator cluster.
    :param str recovery_location: The disaster recovery location associated with the
          instance.
    :param str resource_group: The resource group to which the service instance
          belongs.
    :param str standby_description: Indicates the progress details of primary
          orchestrator creation.
    :param str standby_ip_address: The IP address of the standby orchestrator VM.
    :param str standby_status: The current state of the standby orchestrator.
    :param str status: The current state of the primary orchestrator.
    """

    def __init__(
        self,
        crn: str,
        deployment_name: str,
        last_updated_orchestrator_deployment_time: datetime,
        last_updated_standby_orchestrator_deployment_time: datetime,
        mfa_enabled: str,
        orch_standby_node_addtion_status: str,
        orchestrator_cluster_message: str,
        orchestrator_config_status: str,
        orchestrator_ha: bool,
        plan_name: str,
        primary_description: str,
        primary_ip_address: str,
        primary_orchestrator_status: str,
        recovery_location: str,
        resource_group: str,
        standby_description: str,
        standby_ip_address: str,
        standby_status: str,
        status: str,
        *,
        orch_ext_connectivity_status: Optional[str] = None,
    ) -> None:
        """
        Initialize a ServiceInstanceStatus object.

        :param str crn: The service instance crn.
        :param str deployment_name: The name of the service instance deployment.
        :param datetime last_updated_orchestrator_deployment_time: The deployment
               time of primary orchestrator VM.
        :param datetime last_updated_standby_orchestrator_deployment_time: The
               deployment time of StandBy orchestrator VM.
        :param str mfa_enabled: Indicated whether multi factor authentication is
               ennabled or not.
        :param str orch_standby_node_addtion_status: The status of standby node in
               the Orchestrator cluster.
        :param str orchestrator_cluster_message: The current status of the primary
               orchestrator VM.
        :param str orchestrator_config_status: The configuration status of the
               orchestrator cluster.
        :param bool orchestrator_ha: Indicates whether high availability (HA) is
               enabled for the orchestrator.
        :param str plan_name: The name of the DR Automation plan.
        :param str primary_description: Indicates the progress details of primary
               orchestrator creation.
        :param str primary_ip_address: The IP address of the primary orchestrator
               VM.
        :param str primary_orchestrator_status: The configuration status of the
               orchestrator cluster.
        :param str recovery_location: The disaster recovery location associated
               with the instance.
        :param str resource_group: The resource group to which the service instance
               belongs.
        :param str standby_description: Indicates the progress details of primary
               orchestrator creation.
        :param str standby_ip_address: The IP address of the standby orchestrator
               VM.
        :param str standby_status: The current state of the standby orchestrator.
        :param str status: The current state of the primary orchestrator.
        :param str orch_ext_connectivity_status: (optional) Status of standby node
               addition to the orchestrator cluster.
        """
        self.crn = crn
        self.deployment_name = deployment_name
        self.last_updated_orchestrator_deployment_time = last_updated_orchestrator_deployment_time
        self.last_updated_standby_orchestrator_deployment_time = last_updated_standby_orchestrator_deployment_time
        self.mfa_enabled = mfa_enabled
        self.orch_ext_connectivity_status = orch_ext_connectivity_status
        self.orch_standby_node_addtion_status = orch_standby_node_addtion_status
        self.orchestrator_cluster_message = orchestrator_cluster_message
        self.orchestrator_config_status = orchestrator_config_status
        self.orchestrator_ha = orchestrator_ha
        self.plan_name = plan_name
        self.primary_description = primary_description
        self.primary_ip_address = primary_ip_address
        self.primary_orchestrator_status = primary_orchestrator_status
        self.recovery_location = recovery_location
        self.resource_group = resource_group
        self.standby_description = standby_description
        self.standby_ip_address = standby_ip_address
        self.standby_status = standby_status
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ServiceInstanceStatus':
        """Initialize a ServiceInstanceStatus object from a json dictionary."""
        args = {}
        if (crn := _dict.get('crn')) is not None:
            args['crn'] = crn
        else:
            raise ValueError('Required property \'crn\' not present in ServiceInstanceStatus JSON')
        if (deployment_name := _dict.get('deployment_name')) is not None:
            args['deployment_name'] = deployment_name
        else:
            raise ValueError('Required property \'deployment_name\' not present in ServiceInstanceStatus JSON')
        if (
            last_updated_orchestrator_deployment_time := _dict.get('last_updated_orchestrator_deployment_time')
        ) is not None:
            args['last_updated_orchestrator_deployment_time'] = string_to_datetime(
                last_updated_orchestrator_deployment_time
            )
        else:
            raise ValueError(
                'Required property \'last_updated_orchestrator_deployment_time\' not present in ServiceInstanceStatus JSON'
            )
        if (
            last_updated_standby_orchestrator_deployment_time := _dict.get(
                'last_updated_standby_orchestrator_deployment_time'
            )
        ) is not None:
            args['last_updated_standby_orchestrator_deployment_time'] = string_to_datetime(
                last_updated_standby_orchestrator_deployment_time
            )
        else:
            raise ValueError(
                'Required property \'last_updated_standby_orchestrator_deployment_time\' not present in ServiceInstanceStatus JSON'
            )
        if (mfa_enabled := _dict.get('mfa_enabled')) is not None:
            args['mfa_enabled'] = mfa_enabled
        else:
            raise ValueError('Required property \'mfa_enabled\' not present in ServiceInstanceStatus JSON')
        if (orch_ext_connectivity_status := _dict.get('orch_ext_connectivity_status')) is not None:
            args['orch_ext_connectivity_status'] = orch_ext_connectivity_status
        if (orch_standby_node_addtion_status := _dict.get('orch_standby_node_addtion_status')) is not None:
            args['orch_standby_node_addtion_status'] = orch_standby_node_addtion_status
        else:
            raise ValueError(
                'Required property \'orch_standby_node_addtion_status\' not present in ServiceInstanceStatus JSON'
            )
        if (orchestrator_cluster_message := _dict.get('orchestrator_cluster_message')) is not None:
            args['orchestrator_cluster_message'] = orchestrator_cluster_message
        else:
            raise ValueError(
                'Required property \'orchestrator_cluster_message\' not present in ServiceInstanceStatus JSON'
            )
        if (orchestrator_config_status := _dict.get('orchestrator_config_status')) is not None:
            args['orchestrator_config_status'] = orchestrator_config_status
        else:
            raise ValueError(
                'Required property \'orchestrator_config_status\' not present in ServiceInstanceStatus JSON'
            )
        if (orchestrator_ha := _dict.get('orchestrator_ha')) is not None:
            args['orchestrator_ha'] = orchestrator_ha
        else:
            raise ValueError('Required property \'orchestrator_ha\' not present in ServiceInstanceStatus JSON')
        if (plan_name := _dict.get('plan_name')) is not None:
            args['plan_name'] = plan_name
        else:
            raise ValueError('Required property \'plan_name\' not present in ServiceInstanceStatus JSON')
        if (primary_description := _dict.get('primary_description')) is not None:
            args['primary_description'] = primary_description
        else:
            raise ValueError('Required property \'primary_description\' not present in ServiceInstanceStatus JSON')
        if (primary_ip_address := _dict.get('primary_ip_address')) is not None:
            args['primary_ip_address'] = primary_ip_address
        else:
            raise ValueError('Required property \'primary_ip_address\' not present in ServiceInstanceStatus JSON')
        if (primary_orchestrator_status := _dict.get('primary_orchestrator_status')) is not None:
            args['primary_orchestrator_status'] = primary_orchestrator_status
        else:
            raise ValueError(
                'Required property \'primary_orchestrator_status\' not present in ServiceInstanceStatus JSON'
            )
        if (recovery_location := _dict.get('recovery_location')) is not None:
            args['recovery_location'] = recovery_location
        else:
            raise ValueError('Required property \'recovery_location\' not present in ServiceInstanceStatus JSON')
        if (resource_group := _dict.get('resource_group')) is not None:
            args['resource_group'] = resource_group
        else:
            raise ValueError('Required property \'resource_group\' not present in ServiceInstanceStatus JSON')
        if (standby_description := _dict.get('standby_description')) is not None:
            args['standby_description'] = standby_description
        else:
            raise ValueError('Required property \'standby_description\' not present in ServiceInstanceStatus JSON')
        if (standby_ip_address := _dict.get('standby_ip_address')) is not None:
            args['standby_ip_address'] = standby_ip_address
        else:
            raise ValueError('Required property \'standby_ip_address\' not present in ServiceInstanceStatus JSON')
        if (standby_status := _dict.get('standby_status')) is not None:
            args['standby_status'] = standby_status
        else:
            raise ValueError('Required property \'standby_status\' not present in ServiceInstanceStatus JSON')
        if (status := _dict.get('status')) is not None:
            args['status'] = status
        else:
            raise ValueError('Required property \'status\' not present in ServiceInstanceStatus JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ServiceInstanceStatus object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'deployment_name') and self.deployment_name is not None:
            _dict['deployment_name'] = self.deployment_name
        if (
            hasattr(self, 'last_updated_orchestrator_deployment_time')
            and self.last_updated_orchestrator_deployment_time is not None
        ):
            _dict['last_updated_orchestrator_deployment_time'] = datetime_to_string(
                self.last_updated_orchestrator_deployment_time
            )
        if (
            hasattr(self, 'last_updated_standby_orchestrator_deployment_time')
            and self.last_updated_standby_orchestrator_deployment_time is not None
        ):
            _dict['last_updated_standby_orchestrator_deployment_time'] = datetime_to_string(
                self.last_updated_standby_orchestrator_deployment_time
            )
        if hasattr(self, 'mfa_enabled') and self.mfa_enabled is not None:
            _dict['mfa_enabled'] = self.mfa_enabled
        if hasattr(self, 'orch_ext_connectivity_status') and self.orch_ext_connectivity_status is not None:
            _dict['orch_ext_connectivity_status'] = self.orch_ext_connectivity_status
        if hasattr(self, 'orch_standby_node_addtion_status') and self.orch_standby_node_addtion_status is not None:
            _dict['orch_standby_node_addtion_status'] = self.orch_standby_node_addtion_status
        if hasattr(self, 'orchestrator_cluster_message') and self.orchestrator_cluster_message is not None:
            _dict['orchestrator_cluster_message'] = self.orchestrator_cluster_message
        if hasattr(self, 'orchestrator_config_status') and self.orchestrator_config_status is not None:
            _dict['orchestrator_config_status'] = self.orchestrator_config_status
        if hasattr(self, 'orchestrator_ha') and self.orchestrator_ha is not None:
            _dict['orchestrator_ha'] = self.orchestrator_ha
        if hasattr(self, 'plan_name') and self.plan_name is not None:
            _dict['plan_name'] = self.plan_name
        if hasattr(self, 'primary_description') and self.primary_description is not None:
            _dict['primary_description'] = self.primary_description
        if hasattr(self, 'primary_ip_address') and self.primary_ip_address is not None:
            _dict['primary_ip_address'] = self.primary_ip_address
        if hasattr(self, 'primary_orchestrator_status') and self.primary_orchestrator_status is not None:
            _dict['primary_orchestrator_status'] = self.primary_orchestrator_status
        if hasattr(self, 'recovery_location') and self.recovery_location is not None:
            _dict['recovery_location'] = self.recovery_location
        if hasattr(self, 'resource_group') and self.resource_group is not None:
            _dict['resource_group'] = self.resource_group
        if hasattr(self, 'standby_description') and self.standby_description is not None:
            _dict['standby_description'] = self.standby_description
        if hasattr(self, 'standby_ip_address') and self.standby_ip_address is not None:
            _dict['standby_ip_address'] = self.standby_ip_address
        if hasattr(self, 'standby_status') and self.standby_status is not None:
            _dict['standby_status'] = self.standby_status
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ServiceInstanceStatus object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ServiceInstanceStatus') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ServiceInstanceStatus') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other


class ValidationKeyResponse:
    """
    Response object for API key validation, including ID, status, and description.

    :param str description: (optional) Validation result message.
    :param str id: (optional) Unique identifier of the API key.
    :param str status: (optional) Status of the API key.
    """

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        id: Optional[str] = None,
        status: Optional[str] = None,
    ) -> None:
        """
        Initialize a ValidationKeyResponse object.

        :param str description: (optional) Validation result message.
        :param str id: (optional) Unique identifier of the API key.
        :param str status: (optional) Status of the API key.
        """
        self.description = description
        self.id = id
        self.status = status

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ValidationKeyResponse':
        """Initialize a ValidationKeyResponse object from a json dictionary."""
        args = {}
        if (description := _dict.get('description')) is not None:
            args['description'] = description
        if (id := _dict.get('id')) is not None:
            args['id'] = id
        if (status := _dict.get('status')) is not None:
            args['status'] = status
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ValidationKeyResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ValidationKeyResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ValidationKeyResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ValidationKeyResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other
