# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/02_utils.ipynb.

# %% auto 0
__all__ = ['get_data_home', 'load_file', 'download_deepfluoro', 'download_ljubljana']

# %% ../notebooks/02_utils.ipynb 3
import subprocess
from pathlib import Path

import h5py

# %% ../notebooks/02_utils.ipynb 4
def get_data_home() -> Path:
    """By default, datasets are saved in `~/diffdrr_data`."""
    data_home = Path("~/diffdrr_data").expanduser()
    data_home.mkdir(exist_ok=True)
    return data_home

# %% ../notebooks/02_utils.ipynb 5
def load_file(filename: str):
    """Internal function for loading datasets."""

    file_path = get_data_home() / filename

    if filename == "ipcai_2020_full_res_data.h5":  # DeepFluoro dataset
        try:
            f = h5py.File(file_path)
        except FileNotFoundError:
            print(f"Downloading DeepFluoro dataset (~2.5 GB) to {file_path}")
            download_deepfluoro()
            f = h5py.File(file_path)
    elif filename == "ljubljana.h5":
        try:
            f = h5py.File(file_path)
        except FileNotFoundError:
            print(f"Downloading DeepFluoro dataset (~2.5 GB) to {file_path}")
            download_ljubljana()
            f = h5py.File(file_path)
    else:
        raise ValueError(f"Unrecognized filename {filename}")

    return f

# %% ../notebooks/02_utils.ipynb 6
def download_deepfluoro():
    data_home = get_data_home()
    download_link = "http://archive.data.jhu.edu/api/access/datafile/:persistentId/?persistentId=doi:10.7281/T1/IFSXNV/EAN9GH"
    download_path = data_home / "ipcai_2020_full_res_data.zip"
    subprocess.run(
        f"wget -q --no-check-certificate -O {download_path} {download_link}".split(" ")
    )
    subprocess.run(f"unzip -o {download_path} -d {data_home}".split(" "))
    subprocess.run(f"rm {download_path}".split(" "))

# %% ../notebooks/02_utils.ipynb 7
def download_ljubljana():
    data_home = get_data_home()
    download_link = "https://drive.usercontent.google.com/download?id=1x585pGLI8QGk21qZ2oGwwQ9LMJ09Tqrx&confirm=xxx"
    download_path = data_home / "ljubljana.zip"
    subprocess.run(
        f"curl -s {download_link} -o {download_path} ".split(" ")
    )
    subprocess.run(f"unzip -o {download_path} -d {data_home}".split(" "))
    subprocess.run(f"rm {download_path}".split(" "))
