# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AIAnalysisTemplateItem(AbstractModel):
    """AI 智能分析模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 智能分析模板唯一标识。
        :type Definition: int
        :param _Name: 智能分析模板名称。
        :type Name: str
        :param _Comment: 智能分析模板描述信息。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassificationConfigure: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        :param _TagConfigure: 智能标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagConfigure: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        :param _CoverConfigure: 智能封面任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type CoverConfigure: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type FrameTagConfigure: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        :param _HighlightConfigure: 智能精彩集锦任务控制参数。
        :type HighlightConfigure: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._HighlightConfigure = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        """智能分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        """智能分析模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """智能分析模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        """智能分类任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        """
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        """智能标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        """
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        """智能封面任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        """
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        """智能按帧标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        """
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def HighlightConfigure(self):
        """智能精彩集锦任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        """
        return self._HighlightConfigure

    @HighlightConfigure.setter
    def HighlightConfigure(self, HighlightConfigure):
        self._HighlightConfigure = HighlightConfigure

    @property
    def CreateTime(self):
        """模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        if params.get("HighlightConfigure") is not None:
            self._HighlightConfigure = HighlightsConfigureInfo()
            self._HighlightConfigure._deserialize(params.get("HighlightConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AIRecognitionTemplateItem(AbstractModel):
    """视频内容识别模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        :param _Name: 视频内容识别模板名称。
        :type Name: str
        :param _Comment: 视频内容识别模板描述信息。
        :type Comment: str
        :param _Type: 模板类型，取值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _HeadTailConfigure: 头尾识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type HeadTailConfigure: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        :param _SegmentConfigure: 拆条识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type SegmentConfigure: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        :param _FaceConfigure: 人脸识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type FaceConfigure: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        :param _AsrTranslateConfigure: 语音翻译控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrTranslateConfigure: :class:`tencentcloud.vod.v20180717.models.AsrTranslateConfigureInfo`
        :param _ObjectConfigure: 物体识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectConfigure: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        :param _ScreenshotInterval: 截图时间间隔，单位：秒。
        :type ScreenshotInterval: float
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._Type = None
        self._HeadTailConfigure = None
        self._SegmentConfigure = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._AsrTranslateConfigure = None
        self._ObjectConfigure = None
        self._ScreenshotInterval = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        """视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        """视频内容识别模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """视频内容识别模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Type(self):
        """模板类型，取值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def HeadTailConfigure(self):
        """头尾识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        """
        return self._HeadTailConfigure

    @HeadTailConfigure.setter
    def HeadTailConfigure(self, HeadTailConfigure):
        self._HeadTailConfigure = HeadTailConfigure

    @property
    def SegmentConfigure(self):
        """拆条识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        """
        return self._SegmentConfigure

    @SegmentConfigure.setter
    def SegmentConfigure(self, SegmentConfigure):
        self._SegmentConfigure = SegmentConfigure

    @property
    def FaceConfigure(self):
        """人脸识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        """
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        """文本全文识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        """
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        """文本关键词识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        """
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        """语音全文识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        """
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        """语音关键词识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        """
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def AsrTranslateConfigure(self):
        """语音翻译控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrTranslateConfigureInfo`
        """
        return self._AsrTranslateConfigure

    @AsrTranslateConfigure.setter
    def AsrTranslateConfigure(self, AsrTranslateConfigure):
        self._AsrTranslateConfigure = AsrTranslateConfigure

    @property
    def ObjectConfigure(self):
        """物体识别控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        """
        return self._ObjectConfigure

    @ObjectConfigure.setter
    def ObjectConfigure(self, ObjectConfigure):
        self._ObjectConfigure = ObjectConfigure

    @property
    def ScreenshotInterval(self):
        """截图时间间隔，单位：秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def CreateTime(self):
        """模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Type = params.get("Type")
        if params.get("HeadTailConfigure") is not None:
            self._HeadTailConfigure = HeadTailConfigureInfo()
            self._HeadTailConfigure._deserialize(params.get("HeadTailConfigure"))
        if params.get("SegmentConfigure") is not None:
            self._SegmentConfigure = SegmentConfigureInfo()
            self._SegmentConfigure._deserialize(params.get("SegmentConfigure"))
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("AsrTranslateConfigure") is not None:
            self._AsrTranslateConfigure = AsrTranslateConfigureInfo()
            self._AsrTranslateConfigure._deserialize(params.get("AsrTranslateConfigure"))
        if params.get("ObjectConfigure") is not None:
            self._ObjectConfigure = ObjectConfigureInfo()
            self._ObjectConfigure._deserialize(params.get("ObjectConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalLightingConfigureInfo(AbstractModel):
    """视频画面低光、过曝检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面低光、过曝检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """视频画面低光、过曝检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalLightingConfigureInfoForUpdate(AbstractModel):
    """视频画面低光、过曝检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面低光、过曝检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """视频画面低光、过曝检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccelerateAreaInfo(AbstractModel):
    """域名的地区加速信息

    """

    def __init__(self):
        r"""
        :param _Area: 加速地区，可选值：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland：中国境外。</li>
        :type Area: str
        :param _TencentDisableReason: 腾讯禁用原因，可选值：
<li>ForLegalReasons：因法律原因导致关闭加速；</li>
<li>ForOverdueBills：因欠费停服导致关闭加速。</li>
        :type TencentDisableReason: str
        :param _TencentEdgeDomain: 加速域名对应的 CNAME 域名。
        :type TencentEdgeDomain: str
        """
        self._Area = None
        self._TencentDisableReason = None
        self._TencentEdgeDomain = None

    @property
    def Area(self):
        """加速地区，可选值：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland：中国境外。</li>
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def TencentDisableReason(self):
        """腾讯禁用原因，可选值：
<li>ForLegalReasons：因法律原因导致关闭加速；</li>
<li>ForOverdueBills：因欠费停服导致关闭加速。</li>
        :rtype: str
        """
        return self._TencentDisableReason

    @TencentDisableReason.setter
    def TencentDisableReason(self, TencentDisableReason):
        self._TencentDisableReason = TencentDisableReason

    @property
    def TencentEdgeDomain(self):
        """加速域名对应的 CNAME 域名。
        :rtype: str
        """
        return self._TencentEdgeDomain

    @TencentEdgeDomain.setter
    def TencentEdgeDomain(self, TencentEdgeDomain):
        self._TencentEdgeDomain = TencentEdgeDomain


    def _deserialize(self, params):
        self._Area = params.get("Area")
        self._TencentDisableReason = params.get("TencentDisableReason")
        self._TencentEdgeDomain = params.get("TencentEdgeDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingInfoItem(AbstractModel):
    """转自适应码流信息

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流规格。
        :type Definition: int
        :param _Package: 打包格式，取值范围：
<li>HLS；</li>
<li>DASH。</li>
        :type Package: str
        :param _DrmType: 加密类型。
        :type DrmType: str
        :param _Url: 播放地址。
        :type Url: str
        :param _Size: 媒体文件大小，单位：字节。
<li>当媒体文件为 HLS 时，大小是 m3u8 和 ts 文件大小的总和；</li>
<li>当媒体文件为 DASH 时，大小是 mpd 和分片文件大小的总和；</li>
<li><font color=red>注意</font>：在 2022-01-10T16:00:00Z 前处理生成的自适应码流文件此字段为0。</li>
        :type Size: int
        :param _DigitalWatermarkType: 数字水印类型。可选值：
<li>Trace 表示经过溯源水印处理；</li>
<li>CopyRight 表示经过版权水印处理；</li>
<li>None 表示没有经过数字水印处理。</li>
        :type DigitalWatermarkType: str
        :param _SubStreamSet: 子流信息列表。
        :type SubStreamSet: list of MediaSubStreamInfoItem
        :param _CopyRightWatermarkText: 版权信息。
        :type CopyRightWatermarkText: str
        :param _SubtitleSet: 字幕信息列表。
        :type SubtitleSet: list of MediaSubtitleItem
        :param _DefaultSubtitleId: 默认字幕的唯一标识。
        :type DefaultSubtitleId: str
        """
        self._Definition = None
        self._Package = None
        self._DrmType = None
        self._Url = None
        self._Size = None
        self._DigitalWatermarkType = None
        self._SubStreamSet = None
        self._CopyRightWatermarkText = None
        self._SubtitleSet = None
        self._DefaultSubtitleId = None

    @property
    def Definition(self):
        """转自适应码流规格。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Package(self):
        """打包格式，取值范围：
<li>HLS；</li>
<li>DASH。</li>
        :rtype: str
        """
        return self._Package

    @Package.setter
    def Package(self, Package):
        self._Package = Package

    @property
    def DrmType(self):
        """加密类型。
        :rtype: str
        """
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def Url(self):
        """播放地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Size(self):
        """媒体文件大小，单位：字节。
<li>当媒体文件为 HLS 时，大小是 m3u8 和 ts 文件大小的总和；</li>
<li>当媒体文件为 DASH 时，大小是 mpd 和分片文件大小的总和；</li>
<li><font color=red>注意</font>：在 2022-01-10T16:00:00Z 前处理生成的自适应码流文件此字段为0。</li>
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def DigitalWatermarkType(self):
        """数字水印类型。可选值：
<li>Trace 表示经过溯源水印处理；</li>
<li>CopyRight 表示经过版权水印处理；</li>
<li>None 表示没有经过数字水印处理。</li>
        :rtype: str
        """
        return self._DigitalWatermarkType

    @DigitalWatermarkType.setter
    def DigitalWatermarkType(self, DigitalWatermarkType):
        self._DigitalWatermarkType = DigitalWatermarkType

    @property
    def SubStreamSet(self):
        """子流信息列表。
        :rtype: list of MediaSubStreamInfoItem
        """
        return self._SubStreamSet

    @SubStreamSet.setter
    def SubStreamSet(self, SubStreamSet):
        self._SubStreamSet = SubStreamSet

    @property
    def CopyRightWatermarkText(self):
        """版权信息。
        :rtype: str
        """
        return self._CopyRightWatermarkText

    @CopyRightWatermarkText.setter
    def CopyRightWatermarkText(self, CopyRightWatermarkText):
        self._CopyRightWatermarkText = CopyRightWatermarkText

    @property
    def SubtitleSet(self):
        """字幕信息列表。
        :rtype: list of MediaSubtitleItem
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet

    @property
    def DefaultSubtitleId(self):
        """默认字幕的唯一标识。
        :rtype: str
        """
        return self._DefaultSubtitleId

    @DefaultSubtitleId.setter
    def DefaultSubtitleId(self, DefaultSubtitleId):
        self._DefaultSubtitleId = DefaultSubtitleId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Package = params.get("Package")
        self._DrmType = params.get("DrmType")
        self._Url = params.get("Url")
        self._Size = params.get("Size")
        self._DigitalWatermarkType = params.get("DigitalWatermarkType")
        if params.get("SubStreamSet") is not None:
            self._SubStreamSet = []
            for item in params.get("SubStreamSet"):
                obj = MediaSubStreamInfoItem()
                obj._deserialize(item)
                self._SubStreamSet.append(obj)
        self._CopyRightWatermarkText = params.get("CopyRightWatermarkText")
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = MediaSubtitleItem()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        self._DefaultSubtitleId = params.get("DefaultSubtitleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTaskInput(AbstractModel):
    """对视频转自适应码流的输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板 ID。
        :type Definition: int
        :param _WatermarkSet: 水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :type WatermarkSet: list of WatermarkInput
        :param _TraceWatermark: 溯源水印，该功能已不再支持使用。
        :type TraceWatermark: :class:`tencentcloud.vod.v20180717.models.TraceWatermarkInput`
        :param _CopyRightWatermark: 版权水印，该功能已不再支持使用。
        :type CopyRightWatermark: :class:`tencentcloud.vod.v20180717.models.CopyRightWatermarkInput`
        :param _SubtitleSet: 字幕列表，元素为字幕 ID，支持多个字幕，最大可支持16个。
        :type SubtitleSet: list of str
        """
        self._Definition = None
        self._WatermarkSet = None
        self._TraceWatermark = None
        self._CopyRightWatermark = None
        self._SubtitleSet = None

    @property
    def Definition(self):
        """转自适应码流模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def WatermarkSet(self):
        """水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :rtype: list of WatermarkInput
        """
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def TraceWatermark(self):
        """溯源水印，该功能已不再支持使用。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TraceWatermarkInput`
        """
        return self._TraceWatermark

    @TraceWatermark.setter
    def TraceWatermark(self, TraceWatermark):
        self._TraceWatermark = TraceWatermark

    @property
    def CopyRightWatermark(self):
        """版权水印，该功能已不再支持使用。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CopyRightWatermarkInput`
        """
        return self._CopyRightWatermark

    @CopyRightWatermark.setter
    def CopyRightWatermark(self, CopyRightWatermark):
        self._CopyRightWatermark = CopyRightWatermark

    @property
    def SubtitleSet(self):
        """字幕列表，元素为字幕 ID，支持多个字幕，最大可支持16个。
        :rtype: list of str
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("TraceWatermark") is not None:
            self._TraceWatermark = TraceWatermarkInput()
            self._TraceWatermark._deserialize(params.get("TraceWatermark"))
        if params.get("CopyRightWatermark") is not None:
            self._CopyRightWatermark = CopyRightWatermarkInput()
            self._CopyRightWatermark._deserialize(params.get("CopyRightWatermark"))
        self._SubtitleSet = params.get("SubtitleSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTemplate(AbstractModel):
    """转自适应码流模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转自适应码流模板名称。
        :type Name: str
        :param _Comment: 转自适应码流模板描述信息。
        :type Comment: str
        :param _Format: 自适应转码格式，取值范围：
<li>HLS。</li>
        :type Format: str
        :param _DrmType: DRM 类型，取值范围：
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
如果取值为空字符串，代表不对视频做 DRM 保护。
        :type DrmType: str
        :param _DrmKeyProvider: DRM 的密钥提供商，取值范围：
<li>SDMC：华曦达；</li>
<li>VOD：云点播。</li>
默认值为 VOD 。
        :type DrmKeyProvider: str
        :param _StreamInfos: 自适应转码输入流参数信息，最多输入10路流。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoResolution: int
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        :param _SegmentType: 切片类型，仅当 Format 为 HLS 时有效。
        :type SegmentType: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Format = None
        self._DrmType = None
        self._DrmKeyProvider = None
        self._StreamInfos = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._CreateTime = None
        self._UpdateTime = None
        self._SegmentType = None

    @property
    def Definition(self):
        """转自适应码流模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        """模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        """转自适应码流模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """转自适应码流模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        """自适应转码格式，取值范围：
<li>HLS。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def DrmType(self):
        """DRM 类型，取值范围：
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
如果取值为空字符串，代表不对视频做 DRM 保护。
        :rtype: str
        """
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def DrmKeyProvider(self):
        """DRM 的密钥提供商，取值范围：
<li>SDMC：华曦达；</li>
<li>VOD：云点播。</li>
默认值为 VOD 。
        :rtype: str
        """
        return self._DrmKeyProvider

    @DrmKeyProvider.setter
    def DrmKeyProvider(self, DrmKeyProvider):
        self._DrmKeyProvider = DrmKeyProvider

    @property
    def StreamInfos(self):
        """自适应转码输入流参数信息，最多输入10路流。
        :rtype: list of AdaptiveStreamTemplate
        """
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def DisableHigherVideoBitrate(self):
        """是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        """是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def CreateTime(self):
        """模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def SegmentType(self):
        """切片类型，仅当 Format 为 HLS 时有效。
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        self._DrmType = params.get("DrmType")
        self._DrmKeyProvider = params.get("DrmKeyProvider")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveStreamTemplate(AbstractModel):
    """自适应转码流参数模板

    """

    def __init__(self):
        r"""
        :param _Video: 视频参数信息。
        :type Video: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        :param _Audio: 音频参数信息。
        :type Audio: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        :param _RemoveAudio: 是否移除音频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type RemoveAudio: int
        :param _RemoveVideo: 是否移除视频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type RemoveVideo: int
        :param _TEHDConfig: 极速高清转码参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TEHDConfig: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        """
        self._Video = None
        self._Audio = None
        self._RemoveAudio = None
        self._RemoveVideo = None
        self._TEHDConfig = None

    @property
    def Video(self):
        """视频参数信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        """
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        """音频参数信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        """
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def RemoveAudio(self):
        """是否移除音频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def RemoveVideo(self):
        """是否移除视频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def TEHDConfig(self):
        """极速高清转码参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        """
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig


    def _deserialize(self, params):
        if params.get("Video") is not None:
            self._Video = VideoTemplateInfo()
            self._Video._deserialize(params.get("Video"))
        if params.get("Audio") is not None:
            self._Audio = AudioTemplateInfo()
            self._Audio._deserialize(params.get("Audio"))
        self._RemoveAudio = params.get("RemoveAudio")
        self._RemoveVideo = params.get("RemoveVideo")
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisResult(AbstractModel):
    """智能分析结果

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Classification：智能分类</li>
<li>Cover：智能封面</li>
<li>Tag：智能标签</li>
<li>FrameTag：智能按帧标签</li>
<li>Highlight：智能精彩集锦</li>
        :type Type: str
        :param _ClassificationTask: 视频内容分析智能分类任务的查询结果，当任务类型为 Classification 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassificationTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationResult`
        :param _CoverTask: 视频内容分析智能封面任务的查询结果，当任务类型为 Cover 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type CoverTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverResult`
        :param _TagTask: 视频内容分析智能标签任务的查询结果，当任务类型为 Tag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagResult`
        :param _FrameTagTask: 视频内容分析智能按帧标签任务的查询结果，当任务类型为 FrameTag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type FrameTagTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagResult`
        :param _HighlightTask: 视频内容分析智能精彩集锦任务的查询结果，当任务类型为 Highlight 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type HighlightTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightResult`
        """
        self._Type = None
        self._ClassificationTask = None
        self._CoverTask = None
        self._TagTask = None
        self._FrameTagTask = None
        self._HighlightTask = None

    @property
    def Type(self):
        """任务的类型，可以取的值有：
<li>Classification：智能分类</li>
<li>Cover：智能封面</li>
<li>Tag：智能标签</li>
<li>FrameTag：智能按帧标签</li>
<li>Highlight：智能精彩集锦</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassificationTask(self):
        """视频内容分析智能分类任务的查询结果，当任务类型为 Classification 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationResult`
        """
        return self._ClassificationTask

    @ClassificationTask.setter
    def ClassificationTask(self, ClassificationTask):
        self._ClassificationTask = ClassificationTask

    @property
    def CoverTask(self):
        """视频内容分析智能封面任务的查询结果，当任务类型为 Cover 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverResult`
        """
        return self._CoverTask

    @CoverTask.setter
    def CoverTask(self, CoverTask):
        self._CoverTask = CoverTask

    @property
    def TagTask(self):
        """视频内容分析智能标签任务的查询结果，当任务类型为 Tag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagResult`
        """
        return self._TagTask

    @TagTask.setter
    def TagTask(self, TagTask):
        self._TagTask = TagTask

    @property
    def FrameTagTask(self):
        """视频内容分析智能按帧标签任务的查询结果，当任务类型为 FrameTag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagResult`
        """
        return self._FrameTagTask

    @FrameTagTask.setter
    def FrameTagTask(self, FrameTagTask):
        self._FrameTagTask = FrameTagTask

    @property
    def HighlightTask(self):
        """视频内容分析智能精彩集锦任务的查询结果，当任务类型为 Highlight 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightResult`
        """
        return self._HighlightTask

    @HighlightTask.setter
    def HighlightTask(self, HighlightTask):
        self._HighlightTask = HighlightTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ClassificationTask") is not None:
            self._ClassificationTask = AiAnalysisTaskClassificationResult()
            self._ClassificationTask._deserialize(params.get("ClassificationTask"))
        if params.get("CoverTask") is not None:
            self._CoverTask = AiAnalysisTaskCoverResult()
            self._CoverTask._deserialize(params.get("CoverTask"))
        if params.get("TagTask") is not None:
            self._TagTask = AiAnalysisTaskTagResult()
            self._TagTask._deserialize(params.get("TagTask"))
        if params.get("FrameTagTask") is not None:
            self._FrameTagTask = AiAnalysisTaskFrameTagResult()
            self._FrameTagTask._deserialize(params.get("FrameTagTask"))
        if params.get("HighlightTask") is not None:
            self._HighlightTask = AiAnalysisTaskHighlightResult()
            self._HighlightTask._deserialize(params.get("HighlightTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationInput(AbstractModel):
    """智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能分类模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频智能分类模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationOutput(AbstractModel):
    """智能分类结果信息

    """

    def __init__(self):
        r"""
        :param _ClassificationSet: 视频智能分类列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ClassificationSetFileUrl 对应的文件中获取。
        :type ClassificationSet: list of MediaAiAnalysisClassificationItem
        :param _ClassificationSetFileUrl: 视频智能分类列表文件 URL。文件的内容为 JSON，数据结构与 ClassificationSet 字段一致。 （文件不会永久存储，到达 ClassificationSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ClassificationSetFileUrl: str
        :param _ClassificationSetFileUrlExpireTime: 视频智能分类列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ClassificationSetFileUrlExpireTime: str
        """
        self._ClassificationSet = None
        self._ClassificationSetFileUrl = None
        self._ClassificationSetFileUrlExpireTime = None

    @property
    def ClassificationSet(self):
        """视频智能分类列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ClassificationSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisClassificationItem
        """
        return self._ClassificationSet

    @ClassificationSet.setter
    def ClassificationSet(self, ClassificationSet):
        self._ClassificationSet = ClassificationSet

    @property
    def ClassificationSetFileUrl(self):
        """视频智能分类列表文件 URL。文件的内容为 JSON，数据结构与 ClassificationSet 字段一致。 （文件不会永久存储，到达 ClassificationSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ClassificationSetFileUrl

    @ClassificationSetFileUrl.setter
    def ClassificationSetFileUrl(self, ClassificationSetFileUrl):
        self._ClassificationSetFileUrl = ClassificationSetFileUrl

    @property
    def ClassificationSetFileUrlExpireTime(self):
        """视频智能分类列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ClassificationSetFileUrlExpireTime

    @ClassificationSetFileUrlExpireTime.setter
    def ClassificationSetFileUrlExpireTime(self, ClassificationSetFileUrlExpireTime):
        self._ClassificationSetFileUrlExpireTime = ClassificationSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ClassificationSet") is not None:
            self._ClassificationSet = []
            for item in params.get("ClassificationSet"):
                obj = MediaAiAnalysisClassificationItem()
                obj._deserialize(item)
                self._ClassificationSet.append(obj)
        self._ClassificationSetFileUrl = params.get("ClassificationSetFileUrl")
        self._ClassificationSetFileUrlExpireTime = params.get("ClassificationSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationResult(AbstractModel):
    """智能分类任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能分类任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationInput`
        :param _Output: 智能分类任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationOutput`
        :param _Progress: 智能分类任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能分类任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能分类任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """智能分类任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """智能分类任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """智能分类任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """智能分类任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """智能分类任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskClassificationInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskClassificationOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverInput(AbstractModel):
    """智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能封面模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频智能封面模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverOutput(AbstractModel):
    """智能封面结果信息

    """

    def __init__(self):
        r"""
        :param _CoverSet: 智能封面列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 CoverSetFileUrl 对应的文件中获取。
        :type CoverSet: list of MediaAiAnalysisCoverItem
        :param _CoverSetFileUrl: 智能封面列表文件 URL。文件的内容为 JSON，数据结构与 CoverSet 字段一致。 （文件不会永久存储，到达 CoverSetFileUrlExpireTime 时间点后文件将被删除）。
        :type CoverSetFileUrl: str
        :param _CoverSetFileUrlExpireTime: 智能封面列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CoverSetFileUrlExpireTime: str
        """
        self._CoverSet = None
        self._CoverSetFileUrl = None
        self._CoverSetFileUrlExpireTime = None

    @property
    def CoverSet(self):
        """智能封面列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 CoverSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisCoverItem
        """
        return self._CoverSet

    @CoverSet.setter
    def CoverSet(self, CoverSet):
        self._CoverSet = CoverSet

    @property
    def CoverSetFileUrl(self):
        """智能封面列表文件 URL。文件的内容为 JSON，数据结构与 CoverSet 字段一致。 （文件不会永久存储，到达 CoverSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._CoverSetFileUrl

    @CoverSetFileUrl.setter
    def CoverSetFileUrl(self, CoverSetFileUrl):
        self._CoverSetFileUrl = CoverSetFileUrl

    @property
    def CoverSetFileUrlExpireTime(self):
        """智能封面列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CoverSetFileUrlExpireTime

    @CoverSetFileUrlExpireTime.setter
    def CoverSetFileUrlExpireTime(self, CoverSetFileUrlExpireTime):
        self._CoverSetFileUrlExpireTime = CoverSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("CoverSet") is not None:
            self._CoverSet = []
            for item in params.get("CoverSet"):
                obj = MediaAiAnalysisCoverItem()
                obj._deserialize(item)
                self._CoverSet.append(obj)
        self._CoverSetFileUrl = params.get("CoverSetFileUrl")
        self._CoverSetFileUrlExpireTime = params.get("CoverSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverResult(AbstractModel):
    """智能封面结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能封面任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverInput`
        :param _Output: 智能封面任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverOutput`
        :param _Progress: 智能封面任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能封面任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能封面任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """智能封面任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """智能封面任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """智能封面任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """智能封面任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """智能封面任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskCoverInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskCoverOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagInput(AbstractModel):
    """智能按帧标签任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能按帧标签模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频智能按帧标签模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagOutput(AbstractModel):
    """智能按帧标签结果信息

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 视频按帧标签列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaAiAnalysisFrameTagSegmentItem
        :param _SegmentSetFileUrl: 视频按帧标签列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 视频按帧标签列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        """视频按帧标签列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisFrameTagSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """视频按帧标签列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """视频按帧标签列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaAiAnalysisFrameTagSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagResult(AbstractModel):
    """智能按帧标签结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能按帧标签任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagInput`
        :param _Output: 智能按帧标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagOutput`
        :param _Progress: 智能按帧标签任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能按帧标签任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能按帧标签任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """智能按帧标签任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """智能按帧标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """智能按帧标签任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """智能按帧标签任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """智能按帧标签任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskFrameTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskFrameTagOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightInput(AbstractModel):
    """智能精彩片段任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能精彩片段模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频智能精彩片段模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightOutput(AbstractModel):
    """智能精彩片段结果信息

    """

    def __init__(self):
        r"""
        :param _HighlightSet: 视频智能精彩片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 HighlightSetFileUrl 对应的文件中获取。
        :type HighlightSet: list of MediaAiAnalysisHighlightItem
        :param _HighlightSetFileUrl: 视频智能精彩片段列表文件 URL。文件的内容为 JSON，数据结构与 HighlightSet 字段一致。 （文件不会永久存储，到达 HighlightSetFileUrlExpireTime 时间点后文件将被删除）。
        :type HighlightSetFileUrl: str
        :param _HighlightSetFileUrlExpireTime: 视频智能精彩片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type HighlightSetFileUrlExpireTime: str
        """
        self._HighlightSet = None
        self._HighlightSetFileUrl = None
        self._HighlightSetFileUrlExpireTime = None

    @property
    def HighlightSet(self):
        """视频智能精彩片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 HighlightSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisHighlightItem
        """
        return self._HighlightSet

    @HighlightSet.setter
    def HighlightSet(self, HighlightSet):
        self._HighlightSet = HighlightSet

    @property
    def HighlightSetFileUrl(self):
        """视频智能精彩片段列表文件 URL。文件的内容为 JSON，数据结构与 HighlightSet 字段一致。 （文件不会永久存储，到达 HighlightSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._HighlightSetFileUrl

    @HighlightSetFileUrl.setter
    def HighlightSetFileUrl(self, HighlightSetFileUrl):
        self._HighlightSetFileUrl = HighlightSetFileUrl

    @property
    def HighlightSetFileUrlExpireTime(self):
        """视频智能精彩片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._HighlightSetFileUrlExpireTime

    @HighlightSetFileUrlExpireTime.setter
    def HighlightSetFileUrlExpireTime(self, HighlightSetFileUrlExpireTime):
        self._HighlightSetFileUrlExpireTime = HighlightSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("HighlightSet") is not None:
            self._HighlightSet = []
            for item in params.get("HighlightSet"):
                obj = MediaAiAnalysisHighlightItem()
                obj._deserialize(item)
                self._HighlightSet.append(obj)
        self._HighlightSetFileUrl = params.get("HighlightSetFileUrl")
        self._HighlightSetFileUrlExpireTime = params.get("HighlightSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightResult(AbstractModel):
    """智能精彩片段结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能精彩片段任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightInput`
        :param _Output: 智能精彩片段任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightOutput`
        :param _Progress: 智能精彩片段任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能精彩片段任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能精彩片段任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """智能精彩片段任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """智能精彩片段任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """智能精彩片段任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """智能精彩片段任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """智能精彩片段任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHighlightInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHighlightOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskInput(AbstractModel):
    """AI 视频智能分析输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频内容分析模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagInput(AbstractModel):
    """智能标签任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能标签模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频智能标签模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagOutput(AbstractModel):
    """智能标签结果信息

    """

    def __init__(self):
        r"""
        :param _TagSet: 视频智能标签列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 TagSetFileUrl 对应的文件中获取。
        :type TagSet: list of MediaAiAnalysisTagItem
        :param _TagSetFileUrl: 视频智能标签列表文件 URL。文件的内容为 JSON，数据结构与 TagSet 字段一致。 （文件不会永久存储，到达 TagSetFileUrlExpireTime 时间点后文件将被删除）。
        :type TagSetFileUrl: str
        :param _TagSetFileUrlExpireTime: 视频智能标签列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type TagSetFileUrlExpireTime: str
        """
        self._TagSet = None
        self._TagSetFileUrl = None
        self._TagSetFileUrlExpireTime = None

    @property
    def TagSet(self):
        """视频智能标签列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 TagSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisTagItem
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def TagSetFileUrl(self):
        """视频智能标签列表文件 URL。文件的内容为 JSON，数据结构与 TagSet 字段一致。 （文件不会永久存储，到达 TagSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._TagSetFileUrl

    @TagSetFileUrl.setter
    def TagSetFileUrl(self, TagSetFileUrl):
        self._TagSetFileUrl = TagSetFileUrl

    @property
    def TagSetFileUrlExpireTime(self):
        """视频智能标签列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._TagSetFileUrlExpireTime

    @TagSetFileUrlExpireTime.setter
    def TagSetFileUrlExpireTime(self, TagSetFileUrlExpireTime):
        self._TagSetFileUrlExpireTime = TagSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._TagSetFileUrl = params.get("TagSetFileUrl")
        self._TagSetFileUrlExpireTime = params.get("TagSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagResult(AbstractModel):
    """智能标签结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能标签任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagInput`
        :param _Output: 智能标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagOutput`
        :param _Progress: 智能标签任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能标签任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能标签任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """智能标签任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """智能标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """智能标签任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """智能标签任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """智能标签任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskTagOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewResult(AbstractModel):
    """音视频审核结果

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Porn：图片鉴别是否涉及令人反感的信息</li>
<li>Terrorism：图片鉴别是否涉及令人不安全的信息</li>
<li>Political：图片鉴别是否涉及令人不适宜的信息</li>
<li>Porn.Asr：Asr 文字（ 音频中的文字）鉴别是否涉及令人反感的信息</li>
<li>Porn.Ocr：Ocr 文字鉴别是否涉及令人反感的信息</li>
<li>Political.Asr：Asr 文字（ 音频中的文字）鉴别是否涉及令人不适宜的信息</li>
<li>Political.Ocr：Ocr 文字鉴别是否涉及令人不适宜的信息</li>
<li>Terrorism.Ocr：Ocr 文字鉴别是否涉及令人不安全的信息</li>
<li>Prohibited.Asr：Asr 文字（ 音频中的文字）鉴违禁</li>
<li>Prohibited.Ocr：Ocr 文字鉴违禁</li>
        :type Type: str
        :param _PornTask: 视频音视频审核任务（画面涉及令人反感的信息）的查询结果，当任务类型为 Porn 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornResult`
        :param _TerrorismTask: 视频音视频审核任务（画面涉及令人不安全的信息）的查询结果，当任务类型为 Terrorism 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismResult`
        :param _PoliticalTask: 视频音视频审核任务（画面涉及令人不适宜的信息）的查询结果，当任务类型为 Political 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalResult`
        :param _PornAsrTask: 视频音视频审核任务（Asr 文字涉及令人反感的信息）的查询结果，当任务类型为 Porn.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornAsrResult`
        :param _PornOcrTask: 视频音视频审核任务（Ocr 文字涉及令人反感的信息）的查询结果，当任务类型为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornOcrResult`
        :param _PoliticalAsrTask: 视频音视频审核任务（Asr 文字涉及令人不适宜的信息）的查询结果，当任务类型为 Political.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalAsrResult`
        :param _PoliticalOcrTask: 视频音视频审核任务（Ocr 文字涉及令人不适宜的信息）的查询结果，当任务类型为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalOcrResult`
        :param _TerrorismOcrTask: 视频音视频审核任务（ Ocr 文字涉及令人不安全的信息）的查询结果，当任务类型为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismOcrResult`
        :param _ProhibitedOcrTask: 视频音视频审核 Ocr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedOcrResult`
        :param _ProhibitedAsrTask: 视频音视频审核 Asr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedAsrResult`
        """
        self._Type = None
        self._PornTask = None
        self._TerrorismTask = None
        self._PoliticalTask = None
        self._PornAsrTask = None
        self._PornOcrTask = None
        self._PoliticalAsrTask = None
        self._PoliticalOcrTask = None
        self._TerrorismOcrTask = None
        self._ProhibitedOcrTask = None
        self._ProhibitedAsrTask = None

    @property
    def Type(self):
        """任务的类型，可以取的值有：
<li>Porn：图片鉴别是否涉及令人反感的信息</li>
<li>Terrorism：图片鉴别是否涉及令人不安全的信息</li>
<li>Political：图片鉴别是否涉及令人不适宜的信息</li>
<li>Porn.Asr：Asr 文字（ 音频中的文字）鉴别是否涉及令人反感的信息</li>
<li>Porn.Ocr：Ocr 文字鉴别是否涉及令人反感的信息</li>
<li>Political.Asr：Asr 文字（ 音频中的文字）鉴别是否涉及令人不适宜的信息</li>
<li>Political.Ocr：Ocr 文字鉴别是否涉及令人不适宜的信息</li>
<li>Terrorism.Ocr：Ocr 文字鉴别是否涉及令人不安全的信息</li>
<li>Prohibited.Asr：Asr 文字（ 音频中的文字）鉴违禁</li>
<li>Prohibited.Ocr：Ocr 文字鉴违禁</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PornTask(self):
        """视频音视频审核任务（画面涉及令人反感的信息）的查询结果，当任务类型为 Porn 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornResult`
        """
        return self._PornTask

    @PornTask.setter
    def PornTask(self, PornTask):
        self._PornTask = PornTask

    @property
    def TerrorismTask(self):
        """视频音视频审核任务（画面涉及令人不安全的信息）的查询结果，当任务类型为 Terrorism 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismResult`
        """
        return self._TerrorismTask

    @TerrorismTask.setter
    def TerrorismTask(self, TerrorismTask):
        self._TerrorismTask = TerrorismTask

    @property
    def PoliticalTask(self):
        """视频音视频审核任务（画面涉及令人不适宜的信息）的查询结果，当任务类型为 Political 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalResult`
        """
        return self._PoliticalTask

    @PoliticalTask.setter
    def PoliticalTask(self, PoliticalTask):
        self._PoliticalTask = PoliticalTask

    @property
    def PornAsrTask(self):
        """视频音视频审核任务（Asr 文字涉及令人反感的信息）的查询结果，当任务类型为 Porn.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornAsrResult`
        """
        return self._PornAsrTask

    @PornAsrTask.setter
    def PornAsrTask(self, PornAsrTask):
        self._PornAsrTask = PornAsrTask

    @property
    def PornOcrTask(self):
        """视频音视频审核任务（Ocr 文字涉及令人反感的信息）的查询结果，当任务类型为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornOcrResult`
        """
        return self._PornOcrTask

    @PornOcrTask.setter
    def PornOcrTask(self, PornOcrTask):
        self._PornOcrTask = PornOcrTask

    @property
    def PoliticalAsrTask(self):
        """视频音视频审核任务（Asr 文字涉及令人不适宜的信息）的查询结果，当任务类型为 Political.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalAsrResult`
        """
        return self._PoliticalAsrTask

    @PoliticalAsrTask.setter
    def PoliticalAsrTask(self, PoliticalAsrTask):
        self._PoliticalAsrTask = PoliticalAsrTask

    @property
    def PoliticalOcrTask(self):
        """视频音视频审核任务（Ocr 文字涉及令人不适宜的信息）的查询结果，当任务类型为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalOcrResult`
        """
        return self._PoliticalOcrTask

    @PoliticalOcrTask.setter
    def PoliticalOcrTask(self, PoliticalOcrTask):
        self._PoliticalOcrTask = PoliticalOcrTask

    @property
    def TerrorismOcrTask(self):
        """视频音视频审核任务（ Ocr 文字涉及令人不安全的信息）的查询结果，当任务类型为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismOcrResult`
        """
        return self._TerrorismOcrTask

    @TerrorismOcrTask.setter
    def TerrorismOcrTask(self, TerrorismOcrTask):
        self._TerrorismOcrTask = TerrorismOcrTask

    @property
    def ProhibitedOcrTask(self):
        """视频音视频审核 Ocr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedOcrResult`
        """
        return self._ProhibitedOcrTask

    @ProhibitedOcrTask.setter
    def ProhibitedOcrTask(self, ProhibitedOcrTask):
        self._ProhibitedOcrTask = ProhibitedOcrTask

    @property
    def ProhibitedAsrTask(self):
        """视频音视频审核 Asr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedAsrResult`
        """
        return self._ProhibitedAsrTask

    @ProhibitedAsrTask.setter
    def ProhibitedAsrTask(self, ProhibitedAsrTask):
        self._ProhibitedAsrTask = ProhibitedAsrTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("PornTask") is not None:
            self._PornTask = AiReviewTaskPornResult()
            self._PornTask._deserialize(params.get("PornTask"))
        if params.get("TerrorismTask") is not None:
            self._TerrorismTask = AiReviewTaskTerrorismResult()
            self._TerrorismTask._deserialize(params.get("TerrorismTask"))
        if params.get("PoliticalTask") is not None:
            self._PoliticalTask = AiReviewTaskPoliticalResult()
            self._PoliticalTask._deserialize(params.get("PoliticalTask"))
        if params.get("PornAsrTask") is not None:
            self._PornAsrTask = AiReviewTaskPornAsrResult()
            self._PornAsrTask._deserialize(params.get("PornAsrTask"))
        if params.get("PornOcrTask") is not None:
            self._PornOcrTask = AiReviewTaskPornOcrResult()
            self._PornOcrTask._deserialize(params.get("PornOcrTask"))
        if params.get("PoliticalAsrTask") is not None:
            self._PoliticalAsrTask = AiReviewTaskPoliticalAsrResult()
            self._PoliticalAsrTask._deserialize(params.get("PoliticalAsrTask"))
        if params.get("PoliticalOcrTask") is not None:
            self._PoliticalOcrTask = AiReviewTaskPoliticalOcrResult()
            self._PoliticalOcrTask._deserialize(params.get("PoliticalOcrTask"))
        if params.get("TerrorismOcrTask") is not None:
            self._TerrorismOcrTask = AiReviewTaskTerrorismOcrResult()
            self._TerrorismOcrTask._deserialize(params.get("TerrorismOcrTask"))
        if params.get("ProhibitedOcrTask") is not None:
            self._ProhibitedOcrTask = AiReviewTaskProhibitedOcrResult()
            self._ProhibitedOcrTask._deserialize(params.get("ProhibitedOcrTask"))
        if params.get("ProhibitedAsrTask") is not None:
            self._ProhibitedAsrTask = AiReviewTaskProhibitedAsrResult()
            self._ProhibitedAsrTask._deserialize(params.get("ProhibitedAsrTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewTaskInput(AbstractModel):
    """音视频审核任务类型

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频审核模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """音视频审核模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionResult(AbstractModel):
    """智能识别结果。

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，取值范围：
<li>FaceRecognition：人脸识别，</li>
<li>AsrWordsRecognition：语音关键词识别，</li>
<li>OcrWordsRecognition：文本关键词识别，</li>
<li>AsrFullTextRecognition：语音全文识别，</li>
<li>AsrTranslateRecognition：语音翻译识别，</li>
<li>OcrFullTextRecognition：文本全文识别，</li>
<li>HeadTailRecognition：视频片头片尾识别，</li>
<li>ObjectRecognition：物体识别。</li>
        :type Type: str
        :param _HeadTailTask: 视频片头片尾识别结果，当 Type 为
 HeadTailRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type HeadTailTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResult`
        :param _SegmentTask: 视频拆条识别结果，当 Type 为
 SegmentRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type SegmentTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResult`
        :param _FaceTask: 人脸识别结果，当 Type 为 
 FaceRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type FaceTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResult`
        :param _AsrWordsTask: 语音关键词识别结果，当 Type 为
 AsrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrWordsTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResult`
        :param _AsrFullTextTask: 语音全文识别结果，当 Type 为
 AsrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrFullTextTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResult`
        :param _AsrTranslateTask: 语音翻译结果，当 Type 为 AsrTranslateRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrTranslateTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResult`
        :param _OcrWordsTask: 文本关键词识别结果，当 Type 为
 OcrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrWordsTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResult`
        :param _OcrFullTextTask: 文本全文识别结果，当 Type 为
 OcrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrFullTextTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResult`
        :param _ObjectTask: 物体识别结果，当 Type 为
 ObjectRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResult`
        """
        self._Type = None
        self._HeadTailTask = None
        self._SegmentTask = None
        self._FaceTask = None
        self._AsrWordsTask = None
        self._AsrFullTextTask = None
        self._AsrTranslateTask = None
        self._OcrWordsTask = None
        self._OcrFullTextTask = None
        self._ObjectTask = None

    @property
    def Type(self):
        """任务的类型，取值范围：
<li>FaceRecognition：人脸识别，</li>
<li>AsrWordsRecognition：语音关键词识别，</li>
<li>OcrWordsRecognition：文本关键词识别，</li>
<li>AsrFullTextRecognition：语音全文识别，</li>
<li>AsrTranslateRecognition：语音翻译识别，</li>
<li>OcrFullTextRecognition：文本全文识别，</li>
<li>HeadTailRecognition：视频片头片尾识别，</li>
<li>ObjectRecognition：物体识别。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def HeadTailTask(self):
        """视频片头片尾识别结果，当 Type 为
 HeadTailRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResult`
        """
        return self._HeadTailTask

    @HeadTailTask.setter
    def HeadTailTask(self, HeadTailTask):
        self._HeadTailTask = HeadTailTask

    @property
    def SegmentTask(self):
        """视频拆条识别结果，当 Type 为
 SegmentRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResult`
        """
        return self._SegmentTask

    @SegmentTask.setter
    def SegmentTask(self, SegmentTask):
        self._SegmentTask = SegmentTask

    @property
    def FaceTask(self):
        """人脸识别结果，当 Type 为 
 FaceRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResult`
        """
        return self._FaceTask

    @FaceTask.setter
    def FaceTask(self, FaceTask):
        self._FaceTask = FaceTask

    @property
    def AsrWordsTask(self):
        """语音关键词识别结果，当 Type 为
 AsrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResult`
        """
        return self._AsrWordsTask

    @AsrWordsTask.setter
    def AsrWordsTask(self, AsrWordsTask):
        self._AsrWordsTask = AsrWordsTask

    @property
    def AsrFullTextTask(self):
        """语音全文识别结果，当 Type 为
 AsrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResult`
        """
        return self._AsrFullTextTask

    @AsrFullTextTask.setter
    def AsrFullTextTask(self, AsrFullTextTask):
        self._AsrFullTextTask = AsrFullTextTask

    @property
    def AsrTranslateTask(self):
        """语音翻译结果，当 Type 为 AsrTranslateRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResult`
        """
        return self._AsrTranslateTask

    @AsrTranslateTask.setter
    def AsrTranslateTask(self, AsrTranslateTask):
        self._AsrTranslateTask = AsrTranslateTask

    @property
    def OcrWordsTask(self):
        """文本关键词识别结果，当 Type 为
 OcrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResult`
        """
        return self._OcrWordsTask

    @OcrWordsTask.setter
    def OcrWordsTask(self, OcrWordsTask):
        self._OcrWordsTask = OcrWordsTask

    @property
    def OcrFullTextTask(self):
        """文本全文识别结果，当 Type 为
 OcrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResult`
        """
        return self._OcrFullTextTask

    @OcrFullTextTask.setter
    def OcrFullTextTask(self, OcrFullTextTask):
        self._OcrFullTextTask = OcrFullTextTask

    @property
    def ObjectTask(self):
        """物体识别结果，当 Type 为
 ObjectRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResult`
        """
        return self._ObjectTask

    @ObjectTask.setter
    def ObjectTask(self, ObjectTask):
        self._ObjectTask = ObjectTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("HeadTailTask") is not None:
            self._HeadTailTask = AiRecognitionTaskHeadTailResult()
            self._HeadTailTask._deserialize(params.get("HeadTailTask"))
        if params.get("SegmentTask") is not None:
            self._SegmentTask = AiRecognitionTaskSegmentResult()
            self._SegmentTask._deserialize(params.get("SegmentTask"))
        if params.get("FaceTask") is not None:
            self._FaceTask = AiRecognitionTaskFaceResult()
            self._FaceTask._deserialize(params.get("FaceTask"))
        if params.get("AsrWordsTask") is not None:
            self._AsrWordsTask = AiRecognitionTaskAsrWordsResult()
            self._AsrWordsTask._deserialize(params.get("AsrWordsTask"))
        if params.get("AsrFullTextTask") is not None:
            self._AsrFullTextTask = AiRecognitionTaskAsrFullTextResult()
            self._AsrFullTextTask._deserialize(params.get("AsrFullTextTask"))
        if params.get("AsrTranslateTask") is not None:
            self._AsrTranslateTask = AiRecognitionTaskAsrTranslateResult()
            self._AsrTranslateTask._deserialize(params.get("AsrTranslateTask"))
        if params.get("OcrWordsTask") is not None:
            self._OcrWordsTask = AiRecognitionTaskOcrWordsResult()
            self._OcrWordsTask._deserialize(params.get("OcrWordsTask"))
        if params.get("OcrFullTextTask") is not None:
            self._OcrFullTextTask = AiRecognitionTaskOcrFullTextResult()
            self._OcrFullTextTask._deserialize(params.get("OcrFullTextTask"))
        if params.get("ObjectTask") is not None:
            self._ObjectTask = AiRecognitionTaskObjectResult()
            self._ObjectTask._deserialize(params.get("ObjectTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResult(AbstractModel):
    """语音全文识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音全文识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultInput`
        :param _Output: 语音全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultOutput`
        :param _Progress: 语音全文识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 语音全文识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 语音全文识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """语音全文识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """语音全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """语音全文识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """语音全文识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """语音全文识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultInput(AbstractModel):
    """语音全文识别的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音全文识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """语音全文识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutput(AbstractModel):
    """语音全文识别结果。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 语音全文识别片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of AiRecognitionTaskAsrFullTextSegmentItem
        :param _SegmentSetFileUrl: 语音全文识别片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 语音全文识别片段列表文件 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        :param _SubtitleSet: 生成的字幕列表，对应 [语音全文识别任务控制参数](https://cloud.tencent.com/document/api/266/31773#AsrFullTextConfigureInfo) SubtitleFormats。
        :type SubtitleSet: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        :param _SubtitleUrl: 生成的字幕文件 Url，对应 [语音全文识别任务控制参数](https://cloud.tencent.com/document/api/266/31773#AsrFullTextConfigureInfo) SubtitleFormat。
        :type SubtitleUrl: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None
        self._SubtitleSet = None
        self._SubtitleUrl = None

    @property
    def SegmentSet(self):
        """语音全文识别片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskAsrFullTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """语音全文识别片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """语音全文识别片段列表文件 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime

    @property
    def SubtitleSet(self):
        """生成的字幕列表，对应 [语音全文识别任务控制参数](https://cloud.tencent.com/document/api/266/31773#AsrFullTextConfigureInfo) SubtitleFormats。
        :rtype: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet

    @property
    def SubtitleUrl(self):
        """生成的字幕文件 Url，对应 [语音全文识别任务控制参数](https://cloud.tencent.com/document/api/266/31773#AsrFullTextConfigureInfo) SubtitleFormat。
        :rtype: str
        """
        return self._SubtitleUrl

    @SubtitleUrl.setter
    def SubtitleUrl(self, SubtitleUrl):
        self._SubtitleUrl = SubtitleUrl


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = AiRecognitionTaskAsrFullTextResultOutputSubtitleItem()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        self._SubtitleUrl = params.get("SubtitleUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutputSubtitleItem(AbstractModel):
    """字幕信息。

    """

    def __init__(self):
        r"""
        :param _Id: 媒资字幕 ID，用于媒资字幕管理，仅当 Format 为 vtt 时有效。
<font color=red>注意：</font>2024-11-01T10:00:00Z 之前的任务返回此字段无效。
        :type Id: str
        :param _Name: 媒资字幕名字，用于播放器展示，仅当 Format 为 vtt 时有效。
<font color=red>注意：</font>2024-11-01T10:00:00Z 之前的任务返回此字段无效。
        :type Name: str
        :param _Language: 字幕语言。
        :type Language: str
        :param _Format: 字幕文件格式，取值范围：
<li>vtt：WebVTT 字幕文件；</li>
<li>srt：SRT 字幕文件。</li>
        :type Format: str
        :param _Url: 字幕文件 Url。
        :type Url: str
        """
        self._Id = None
        self._Name = None
        self._Language = None
        self._Format = None
        self._Url = None

    @property
    def Id(self):
        """媒资字幕 ID，用于媒资字幕管理，仅当 Format 为 vtt 时有效。
<font color=red>注意：</font>2024-11-01T10:00:00Z 之前的任务返回此字段无效。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        """媒资字幕名字，用于播放器展示，仅当 Format 为 vtt 时有效。
<font color=red>注意：</font>2024-11-01T10:00:00Z 之前的任务返回此字段无效。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Language(self):
        """字幕语言。
        :rtype: str
        """
        return self._Language

    @Language.setter
    def Language(self, Language):
        self._Language = Language

    @property
    def Format(self):
        """字幕文件格式，取值范围：
<li>vtt：WebVTT 字幕文件；</li>
<li>srt：SRT 字幕文件。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Url(self):
        """字幕文件 Url。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Language = params.get("Language")
        self._Format = params.get("Format")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextSegmentItem(AbstractModel):
    """语音全文识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Text: 识别文本。
        :type Text: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None

    @property
    def Confidence(self):
        """识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        """识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        """识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrTranslateResult(AbstractModel):
    """语音翻译结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音翻译任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResultInput`
        :param _Output: 语音翻译任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResultOutput`
        :param _Progress: 语音翻译任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 语音翻译任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 语音翻译任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """语音翻译任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """语音翻译任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """语音翻译任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """语音翻译任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """语音翻译任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrTranslateResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrTranslateResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrTranslateResultInput(AbstractModel):
    """语音翻译的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音翻译模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """语音翻译模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrTranslateResultOutput(AbstractModel):
    """语音翻译结果。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 语音翻译片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of AiRecognitionTaskAsrTranslateSegmentItem
        :param _SegmentSetFileUrl: 语音翻译片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 语音翻译片段列表文件 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        :param _SubtitleSet: 生成的字幕列表。
        :type SubtitleSet: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None
        self._SubtitleSet = None

    @property
    def SegmentSet(self):
        """语音翻译片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskAsrTranslateSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """语音翻译片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """语音翻译片段列表文件 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime

    @property
    def SubtitleSet(self):
        """生成的字幕列表。
        :rtype: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrTranslateSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = AiRecognitionTaskAsrFullTextResultOutputSubtitleItem()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrTranslateSegmentItem(AbstractModel):
    """语音翻译片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 语音翻译片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 语音翻译片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 语音翻译片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Text: 识别文本。
        :type Text: str
        :param _Translation: 翻译文本。
        :type Translation: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None
        self._Translation = None

    @property
    def Confidence(self):
        """语音翻译片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        """语音翻译片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """语音翻译片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        """识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Translation(self):
        """翻译文本。
        :rtype: str
        """
        return self._Translation

    @Translation.setter
    def Translation(self, Translation):
        self._Translation = Translation


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        self._Translation = params.get("Translation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResult(AbstractModel):
    """语音关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音关键词识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultInput`
        :param _Output: 语音关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultOutput`
        :param _Progress: 语音关键词识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 语音关键词识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 语音关键词识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """语音关键词识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """语音关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """语音关键词识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """语音关键词识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """语音关键词识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultInput(AbstractModel):
    """语音关键词识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音关键词识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """语音关键词识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultItem(AbstractModel):
    """语音关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Word: 语音关键词。
        :type Word: str
        :param _SegmentSet: 语音关键词出现的时间片段列表。
        :type SegmentSet: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        """语音关键词。
        :rtype: str
        """
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        """语音关键词出现的时间片段列表。
        :rtype: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultOutput(AbstractModel):
    """语音关键词识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 语音关键词识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :type ResultSet: list of AiRecognitionTaskAsrWordsResultItem
        :param _ResultSetFileUrl: 语音关键词识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: 语音关键词识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        """语音关键词识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskAsrWordsResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        """语音关键词识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        """语音关键词识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskAsrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsSegmentItem(AbstractModel):
    """语音识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None

    @property
    def StartTimeOffset(self):
        """识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        """识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResult(AbstractModel):
    """人脸识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 人脸识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultInput`
        :param _Output: 人脸识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultOutput`
        :param _Progress: 人脸识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 人脸识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 人脸识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """人脸识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """人脸识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """人脸识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """人脸识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """人脸识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskFaceResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskFaceResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultInput(AbstractModel):
    """人脸识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 人脸识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """人脸识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultItem(AbstractModel):
    """人脸识别结果

    """

    def __init__(self):
        r"""
        :param _Id: 人物唯一标识 ID。
        :type Id: str
        :param _Type: 人物库类型，表示识别出的人物来自哪个人物库：
<li>Default：默认人物库；</li>
<li>UserDefine：用户自定义人物库。</li>
        :type Type: str
        :param _Name: 人物名称。
        :type Name: str
        :param _SegmentSet: 人物出现的片段结果集。
        :type SegmentSet: list of AiRecognitionTaskFaceSegmentItem
        """
        self._Id = None
        self._Type = None
        self._Name = None
        self._SegmentSet = None

    @property
    def Id(self):
        """人物唯一标识 ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        """人物库类型，表示识别出的人物来自哪个人物库：
<li>Default：默认人物库；</li>
<li>UserDefine：用户自定义人物库。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        """人物名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        """人物出现的片段结果集。
        :rtype: list of AiRecognitionTaskFaceSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskFaceSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultOutput(AbstractModel):
    """智能人脸识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 智能人脸识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :type ResultSet: list of AiRecognitionTaskFaceResultItem
        :param _ResultSetFileUrl: 智能人脸识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: 智能人脸识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        """智能人脸识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskFaceResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        """智能人脸识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        """智能人脸识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskFaceResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceSegmentItem(AbstractModel):
    """人脸识别结果片段

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        """识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        """识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        """识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResult(AbstractModel):
    """视频片头片尾识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 视频片头片尾识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultInput`
        :param _Output: 视频片头片尾识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultOutput`
        :param _Progress: 视频片头片尾识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 视频片头片尾识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 视频片头片尾识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """视频片头片尾识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """视频片头片尾识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """视频片头片尾识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """视频片头片尾识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """视频片头片尾识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskHeadTailResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskHeadTailResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResultInput(AbstractModel):
    """视频片头片尾识别的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 视频片头片尾识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频片头片尾识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResultOutput(AbstractModel):
    """视频片头片尾识别输出。

    """

    def __init__(self):
        r"""
        :param _HeadConfidence: 片头识别置信度。取值：0~100。
        :type HeadConfidence: float
        :param _HeadTimeOffset: 视频片头的结束时间点，单位：秒。
        :type HeadTimeOffset: float
        :param _TailConfidence: 片尾识别置信度。取值：0~100。
        :type TailConfidence: float
        :param _TailTimeOffset: 视频片尾的开始时间点，单位：秒。
        :type TailTimeOffset: float
        """
        self._HeadConfidence = None
        self._HeadTimeOffset = None
        self._TailConfidence = None
        self._TailTimeOffset = None

    @property
    def HeadConfidence(self):
        """片头识别置信度。取值：0~100。
        :rtype: float
        """
        return self._HeadConfidence

    @HeadConfidence.setter
    def HeadConfidence(self, HeadConfidence):
        self._HeadConfidence = HeadConfidence

    @property
    def HeadTimeOffset(self):
        """视频片头的结束时间点，单位：秒。
        :rtype: float
        """
        return self._HeadTimeOffset

    @HeadTimeOffset.setter
    def HeadTimeOffset(self, HeadTimeOffset):
        self._HeadTimeOffset = HeadTimeOffset

    @property
    def TailConfidence(self):
        """片尾识别置信度。取值：0~100。
        :rtype: float
        """
        return self._TailConfidence

    @TailConfidence.setter
    def TailConfidence(self, TailConfidence):
        self._TailConfidence = TailConfidence

    @property
    def TailTimeOffset(self):
        """视频片尾的开始时间点，单位：秒。
        :rtype: float
        """
        return self._TailTimeOffset

    @TailTimeOffset.setter
    def TailTimeOffset(self, TailTimeOffset):
        self._TailTimeOffset = TailTimeOffset


    def _deserialize(self, params):
        self._HeadConfidence = params.get("HeadConfidence")
        self._HeadTimeOffset = params.get("HeadTimeOffset")
        self._TailConfidence = params.get("TailConfidence")
        self._TailTimeOffset = params.get("TailTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskInput(AbstractModel):
    """视频内容识别输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能识别模板 ID 。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频智能识别模板 ID 。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResult(AbstractModel):
    """物体识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 物体识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultInput`
        :param _Output: 物体识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultOutput`
        :param _Progress: 物体识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 物体识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 物体识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """物体识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """物体识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """物体识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """物体识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """物体识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskObjectResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskObjectResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultInput(AbstractModel):
    """物体识别任务输入类型。

    """

    def __init__(self):
        r"""
        :param _Definition: 物体识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """物体识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultItem(AbstractModel):
    """单个物体识别结果。

    """

    def __init__(self):
        r"""
        :param _Name: 识别的物体名称。
        :type Name: str
        :param _SegmentSet: 物体出现的片段列表。
        :type SegmentSet: list of AiRecognitionTaskObjectSeqmentItem
        :param _RecognitionSegmentSet: 物体出现的片段列表。
        :type RecognitionSegmentSet: list of AiRecognitionTaskObjectSegmentItem
        """
        self._Name = None
        self._SegmentSet = None
        self._RecognitionSegmentSet = None

    @property
    def Name(self):
        """识别的物体名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        warnings.warn("parameter `SegmentSet` is deprecated", DeprecationWarning) 

        """物体出现的片段列表。
        :rtype: list of AiRecognitionTaskObjectSeqmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        warnings.warn("parameter `SegmentSet` is deprecated", DeprecationWarning) 

        self._SegmentSet = SegmentSet

    @property
    def RecognitionSegmentSet(self):
        """物体出现的片段列表。
        :rtype: list of AiRecognitionTaskObjectSegmentItem
        """
        return self._RecognitionSegmentSet

    @RecognitionSegmentSet.setter
    def RecognitionSegmentSet(self, RecognitionSegmentSet):
        self._RecognitionSegmentSet = RecognitionSegmentSet


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskObjectSeqmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        if params.get("RecognitionSegmentSet") is not None:
            self._RecognitionSegmentSet = []
            for item in params.get("RecognitionSegmentSet"):
                obj = AiRecognitionTaskObjectSegmentItem()
                obj._deserialize(item)
                self._RecognitionSegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultOutput(AbstractModel):
    """智能物体识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 智能物体识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :type ResultSet: list of AiRecognitionTaskObjectResultItem
        :param _ResultSetFileUrl: 智能物体识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: 智能物体识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        """智能物体识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskObjectResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        """智能物体识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        """智能物体识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskObjectResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSegmentItem(AbstractModel):
    """物体识别结果片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        """识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        """识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        """识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSeqmentItem(AbstractModel):
    """物体识别结果片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        """识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        """识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        """识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResult(AbstractModel):
    """文本全文识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 文本全文识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultInput`
        :param _Output: 文本全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultOutput`
        :param _Progress: 文本全文识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 文本全文识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 文本全文识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """文本全文识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """文本全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """文本全文识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """文本全文识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """文本全文识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultInput(AbstractModel):
    """文本全文识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 文本全文识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """文本全文识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultOutput(AbstractModel):
    """文本全文识别输出。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 文本全文识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of AiRecognitionTaskOcrFullTextSegmentItem
        :param _SegmentSetFileUrl: 文本全文识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 文本全文识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        """文本全文识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskOcrFullTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """文本全文识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """文本全文识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentItem(AbstractModel):
    """文本全文识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _TextSet: 识别片段结果集。
        :type TextSet: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TextSet = None

    @property
    def StartTimeOffset(self):
        """识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TextSet(self):
        """识别片段结果集。
        :rtype: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        return self._TextSet

    @TextSet.setter
    def TextSet(self, TextSet):
        self._TextSet = TextSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TextSet") is not None:
            self._TextSet = []
            for item in params.get("TextSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentTextItem()
                obj._deserialize(item)
                self._TextSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentTextItem(AbstractModel):
    """文本全文识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        :param _Text: 识别文本。
        :type Text: str
        """
        self._Confidence = None
        self._AreaCoordSet = None
        self._Text = None

    @property
    def Confidence(self):
        """识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        """识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Text(self):
        """识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResult(AbstractModel):
    """文本关键识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 文本关键词识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultInput`
        :param _Output: 文本关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultOutput`
        :param _Progress: 文本关键词识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 文本关键词识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 文本关键词识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """文本关键词识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """文本关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """文本关键词识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """文本关键词识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """文本关键词识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultInput(AbstractModel):
    """文本关键词识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 文本关键词识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """文本关键词识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultItem(AbstractModel):
    """文本关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Word: 文本关键词。
        :type Word: str
        :param _SegmentSet: 文本关键出现的片段列表。
        :type SegmentSet: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        """文本关键词。
        :rtype: str
        """
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        """文本关键出现的片段列表。
        :rtype: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultOutput(AbstractModel):
    """文本关键词识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 文本关键词识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :type ResultSet: list of AiRecognitionTaskOcrWordsResultItem
        :param _ResultSetFileUrl: 文本关键词识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: 文本关键词识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        """文本关键词识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskOcrWordsResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        """文本关键词识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        """文本关键词识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskOcrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsSegmentItem(AbstractModel):
    """文本识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        """识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        """识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        """识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResult(AbstractModel):
    """视频拆条结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 视频拆条任务输入信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultInput`
        :param _Output: 视频拆条任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultOutput`
        :param _Progress: 视频拆条任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 视频拆条任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 视频拆条任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """视频拆条任务输入信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """视频拆条任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """视频拆条任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        """视频拆条任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """视频拆条任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskSegmentResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskSegmentResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResultInput(AbstractModel):
    """视频拆条输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 视频拆条模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """视频拆条模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResultOutput(AbstractModel):
    """视频拆条输出。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 视频拆条片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of AiRecognitionTaskSegmentSegmentItem
        :param _SegmentSetFileUrl: 视频拆条片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 视频拆条片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        """视频拆条片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskSegmentSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """视频拆条片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """视频拆条片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskSegmentSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentSegmentItem(AbstractModel):
    """视频拆条片段。

    """

    def __init__(self):
        r"""
        :param _FileId: 文件 ID。仅当处理的是点播文件并且拆条生成的子片段为点播文件时有效。
        :type FileId: str
        :param _SegmentUrl: 视频拆条片段 Url。
        :type SegmentUrl: str
        :param _Confidence: 拆条片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 拆条片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 拆条片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _CovImgUrl: 拆条封面图片 Url。
        :type CovImgUrl: str
        :param _SpecialInfo: 特殊字段，请忽略。
        :type SpecialInfo: str
        """
        self._FileId = None
        self._SegmentUrl = None
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._CovImgUrl = None
        self._SpecialInfo = None

    @property
    def FileId(self):
        """文件 ID。仅当处理的是点播文件并且拆条生成的子片段为点播文件时有效。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SegmentUrl(self):
        """视频拆条片段 Url。
        :rtype: str
        """
        return self._SegmentUrl

    @SegmentUrl.setter
    def SegmentUrl(self, SegmentUrl):
        self._SegmentUrl = SegmentUrl

    @property
    def Confidence(self):
        """拆条片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        """拆条片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """拆条片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def CovImgUrl(self):
        """拆条封面图片 Url。
        :rtype: str
        """
        return self._CovImgUrl

    @CovImgUrl.setter
    def CovImgUrl(self, CovImgUrl):
        self._CovImgUrl = CovImgUrl

    @property
    def SpecialInfo(self):
        """特殊字段，请忽略。
        :rtype: str
        """
        return self._SpecialInfo

    @SpecialInfo.setter
    def SpecialInfo(self, SpecialInfo):
        self._SpecialInfo = SpecialInfo


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SegmentUrl = params.get("SegmentUrl")
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._CovImgUrl = params.get("CovImgUrl")
        self._SpecialInfo = params.get("SpecialInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskInput(AbstractModel):
    """音视频审核 Asr 文字涉及令人不适宜的信息、违规任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不适宜信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴别涉及令人不适宜信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskOutput(AbstractModel):
    """Asr 文字涉及令人不适宜的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉及令人不适宜的信息、违规评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉及令人不适宜的信息、违规结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """Asr 文字涉及令人不适宜的信息、违规评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """Asr 文字涉及令人不适宜的信息、违规结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        """Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskInput(AbstractModel):
    """音视频审核 Ocr 文字涉及令人不适宜信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不适宜信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴别涉及令人不适宜信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskOutput(AbstractModel):
    """Ocr 文字涉及令人不适宜的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉及令人不适宜的信息、违规评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉及令人不适宜的信息、违规结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """Ocr 文字涉及令人不适宜的信息、违规评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """Ocr 文字涉及令人不适宜的信息、违规结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        """Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskInput(AbstractModel):
    """音视频审核涉及令人不适宜信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不适宜信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴别涉及令人不适宜信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskOutput(AbstractModel):
    """涉及令人不适宜的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频涉及令人不适宜信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 涉及令人不适宜信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频涉及令人不适宜信息的结果标签。音视频审核模板[画面鉴政任务控制参数](https://cloud.tencent.com/document/api/266/31773#PoliticalImgReviewTemplateInfo)里 LabelSet 参数与此参数取值范围的对应关系：
violation_photo：
<li>violation_photo：违规图标。</li>
其他（即 politician/entertainment/sport/entrepreneur/scholar/celebrity/military）：
<li>politician：相关人物。</li>
        :type Label: str
        :param _SegmentSet: 有涉及令人不适宜信息嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewPoliticalSegmentItem
        :param _SegmentSetFileUrl: 有涉及令人不适宜的信息嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 有涉及令人不适宜的信息嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """视频涉及令人不适宜信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """涉及令人不适宜信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        """视频涉及令人不适宜信息的结果标签。音视频审核模板[画面鉴政任务控制参数](https://cloud.tencent.com/document/api/266/31773#PoliticalImgReviewTemplateInfo)里 LabelSet 参数与此参数取值范围的对应关系：
violation_photo：
<li>violation_photo：违规图标。</li>
其他（即 politician/entertainment/sport/entrepreneur/scholar/celebrity/military）：
<li>politician：相关人物。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        """有涉及令人不适宜信息嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewPoliticalSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """有涉及令人不适宜的信息嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """有涉及令人不适宜的信息嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewPoliticalSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskInput(AbstractModel):
    """音视频审核 Asr 文字涉及令人反感的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人反感的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴别涉及令人反感的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskOutput(AbstractModel):
    """Asr 文字涉及令人反感的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉及令人反感的信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """Asr 文字涉及令人反感的信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """Asr 文字涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        """Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskInput(AbstractModel):
    """音视频审核 Ocr 文字涉及令人反感的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人反感的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴别涉及令人反感的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskOutput(AbstractModel):
    """Ocr 文字涉及令人反感的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉及令人反感的信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """Ocr 文字涉及令人反感的信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """Ocr 文字涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        """Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskInput(AbstractModel):
    """音视频审核涉及令人反感的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人反感的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴别涉及令人反感的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskOutput(AbstractModel):
    """鉴别涉及令人反感的信息的结果信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频鉴别涉及令人反感的信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 鉴别涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频鉴别涉及令人反感的信息的结果标签，取值范围：
<li>porn：色情。</li>
<li>sexy：性感。</li>
<li>vulgar：低俗。</li>
<li>intimacy：亲密行为。</li>
        :type Label: str
        :param _SegmentSet: 有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewSegmentItem
        :param _SegmentSetFileUrl: 涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """视频鉴别涉及令人反感的信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """鉴别涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        """视频鉴别涉及令人反感的信息的结果标签，取值范围：
<li>porn：色情。</li>
<li>sexy：性感。</li>
<li>vulgar：低俗。</li>
<li>intimacy：亲密行为。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        """有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskInput(AbstractModel):
    """音视频审核 Asr 文字鉴违禁任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴违禁模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴违禁模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskOutput(AbstractModel):
    """Asr 文字涉违禁信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉违禁评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉违禁嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: Asr 文字有涉违禁嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Asr 文字有涉违禁嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """Asr 文字涉违禁评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """Asr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        """Asr 文字有涉违禁嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """Asr 文字有涉违禁嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """Asr 文字有涉违禁嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskInput(AbstractModel):
    """音视频审核 Ocr 文字鉴违禁任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴违禁模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴违禁模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskOutput(AbstractModel):
    """Ocr 文字涉违禁信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉违禁评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉违禁嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: Ocr 文字有涉违禁嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Ocr 文字有涉违禁嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """Ocr 文字涉违禁评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """Ocr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        """Ocr 文字有涉违禁嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """Ocr 文字有涉违禁嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """Ocr 文字有涉违禁嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalAsrResult(AbstractModel):
    """音视频审核 Asr 文字涉及令人不适宜信息、违规任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Asr 文字涉及令人不适宜信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskInput`
        :param _Output: 音视频审核 Asr 文字涉及令人不适宜信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskOutput`
        :param _Progress: 音视频审核 Asr 文字涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核 Asr 文字涉及令人不适宜信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核 Asr 文字涉及令人不适宜信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核 Asr 文字涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalOcrResult(AbstractModel):
    """音视频审核 Ocr 文字涉及令人不适宜信息、违规任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Ocr 文字涉及令人不适宜信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskInput`
        :param _Output: 音视频审核 Ocr 文字涉及令人不适宜信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskOutput`
        :param _Progress: 音视频审核 Ocr 文字涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核 Ocr 文字涉及令人不适宜信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核 Ocr 文字涉及令人不适宜信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核 Ocr 文字涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalResult(AbstractModel):
    """音视频审核涉及令人不适宜信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核涉及令人不适宜信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskInput`
        :param _Output: 音视频审核涉及令人不适宜信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskOutput`
        :param _Progress: 音视频审核涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核涉及令人不适宜信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核涉及令人不适宜信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornAsrResult(AbstractModel):
    """音视频审核 Asr 文字涉及令人反感的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Asr 文字涉及令人反感的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskInput`
        :param _Output: 音视频审核 Asr 文字涉及令人反感的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskOutput`
        :param _Progress: 音视频审核 Asr 文字涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核 Asr 文字涉及令人反感的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核 Asr 文字涉及令人反感的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核 Asr 文字涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornOcrResult(AbstractModel):
    """音视频审核 Ocr 文字涉及令人反感的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Ocr 文字涉及令人反感的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskInput`
        :param _Output: Ocr 文字音视频审核涉及令人反感的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskOutput`
        :param _Progress: Ocr 文字音视频审核涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核 Ocr 文字涉及令人反感的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """Ocr 文字音视频审核涉及令人反感的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """Ocr 文字音视频审核涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornResult(AbstractModel):
    """音视频审核涉及令人反感的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核涉及令人反感的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskInput`
        :param _Output: 音视频审核涉及令人反感的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskOutput`
        :param _Progress: 音视频审核涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核涉及令人反感的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核涉及令人反感的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedAsrResult(AbstractModel):
    """音视频审核 Asr 文字鉴违禁任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Asr 文字鉴违禁任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskInput`
        :param _Output: 音视频审核 Asr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskOutput`
        :param _Progress: 音视频审核 Asr 文字鉴违禁任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核 Asr 文字鉴违禁任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核 Asr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核 Asr 文字鉴违禁任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedOcrResult(AbstractModel):
    """音视频审核 Ocr 文字鉴违禁任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Ocr 文字鉴违禁任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskInput`
        :param _Output: 音视频审核 Ocr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskOutput`
        :param _Progress: 音视频审核 Ocr 文字鉴违禁任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核 Ocr 文字鉴违禁任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核 Ocr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核 Ocr 文字鉴违禁任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismOcrResult(AbstractModel):
    """音视频审核 Ocr 文字鉴别涉及令人不安全的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Ocr 文字涉及令人不安全的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskInput`
        :param _Output: 音视频审核 Ocr 文字涉及令人不安全的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskOutput`
        :param _Progress: 音视频审核 Ocr 文字涉及令人不安全的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核 Ocr 文字涉及令人不安全的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核 Ocr 文字涉及令人不安全的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核 Ocr 文字涉及令人不安全的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismResult(AbstractModel):
    """音视频审核涉及令人不安全的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核涉及令人不安全的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskInput`
        :param _Output: 音视频审核涉及令人不安全的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskOutput`
        :param _Progress: 音视频审核涉及令人不安全的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        """音视频审核涉及令人不安全的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """音视频审核涉及令人不安全的信息的任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        """音视频审核涉及令人不安全的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskInput(AbstractModel):
    """音视频审核 Ocr 文字涉及令人不安全的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不安全的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴别涉及令人不安全的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskOutput(AbstractModel):
    """Ocr 文字涉及令人不安全的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字有涉及令人不安全信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字有涉及令人不安全信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """Ocr 文字有涉及令人不安全信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """Ocr 文字有涉及令人不安全信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        """Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskInput(AbstractModel):
    """音视频审核涉及令人不安全的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不安全的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """鉴别涉及令人不安全的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskOutput(AbstractModel):
    """暴恐信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频暴恐评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 暴恐结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频暴恐结果标签，取值范围：
<li>guns：武器枪支。</li>
<li>crowd：人群聚集。</li>
<li>police：警察部队。</li>
<li>bloody：血腥画面。</li>
<li>banners：暴恐旗帜。</li>
<li>militant：武装分子。</li>
<li>explosion：爆炸火灾。</li>
<li>terrorists：暴恐人物。</li>
<li>scenario：暴恐画面。</li>
        :type Label: str
        :param _SegmentSet: 有暴恐嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewSegmentItem
        :param _SegmentSetFileUrl: 暴恐嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 暴恐嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        """视频暴恐评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """暴恐结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        """视频暴恐结果标签，取值范围：
<li>guns：武器枪支。</li>
<li>crowd：人群聚集。</li>
<li>police：警察部队。</li>
<li>bloody：血腥画面。</li>
<li>banners：暴恐旗帜。</li>
<li>militant：武装分子。</li>
<li>explosion：爆炸火灾。</li>
<li>terrorists：暴恐人物。</li>
<li>scenario：暴恐画面。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        """有暴恐嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        """暴恐嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        """暴恐嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceInfo(AbstractModel):
    """AI 样本管理，人脸信息。

    """

    def __init__(self):
        r"""
        :param _FaceId: 人脸图片 ID。
        :type FaceId: str
        :param _Url: 人脸图片地址。
        :type Url: str
        """
        self._FaceId = None
        self._Url = None

    @property
    def FaceId(self):
        """人脸图片 ID。
        :rtype: str
        """
        return self._FaceId

    @FaceId.setter
    def FaceId(self, FaceId):
        self._FaceId = FaceId

    @property
    def Url(self):
        """人脸图片地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._FaceId = params.get("FaceId")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceOperation(AbstractModel):
    """AI 样本管理，人脸数据操作。

    """

    def __init__(self):
        r"""
        :param _Type: 操作类型，可选值：add（添加）、delete（删除）、reset（重置）。重置操作将清空该人物已有人脸数据，并添加 FaceContents 指定人脸数据。
        :type Type: str
        :param _FaceIds: 人脸 ID 集合，当 Type为delete 时，该字段必填。
        :type FaceIds: list of str
        :param _FaceContents: 人脸图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串集合，仅支持 jpeg、png 图片格式。
<li>当 Type为add 或 reset 时，该字段必填；</li>
<li>数组长度限制：5 张图片。</li>
注意：图片必须是单人像正面人脸较清晰的照片，像素不低于 200*200。
        :type FaceContents: list of str
        """
        self._Type = None
        self._FaceIds = None
        self._FaceContents = None

    @property
    def Type(self):
        """操作类型，可选值：add（添加）、delete（删除）、reset（重置）。重置操作将清空该人物已有人脸数据，并添加 FaceContents 指定人脸数据。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceIds(self):
        """人脸 ID 集合，当 Type为delete 时，该字段必填。
        :rtype: list of str
        """
        return self._FaceIds

    @FaceIds.setter
    def FaceIds(self, FaceIds):
        self._FaceIds = FaceIds

    @property
    def FaceContents(self):
        """人脸图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串集合，仅支持 jpeg、png 图片格式。
<li>当 Type为add 或 reset 时，该字段必填；</li>
<li>数组长度限制：5 张图片。</li>
注意：图片必须是单人像正面人脸较清晰的照片，像素不低于 200*200。
        :rtype: list of str
        """
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FaceIds = params.get("FaceIds")
        self._FaceContents = params.get("FaceContents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFailFaceInfo(AbstractModel):
    """AI 样本管理，处理失败的人脸信息

    """

    def __init__(self):
        r"""
        :param _Index: 对应入参 FaceContents 中错误图片下标，从 0 开始。
        :type Index: int
        :param _ErrCode: 错误码，取值：
<li>0：成功；</li>
<li>其他：失败。</li>
        :type ErrCode: int
        :param _Message: 错误描述。
        :type Message: str
        """
        self._Index = None
        self._ErrCode = None
        self._Message = None

    @property
    def Index(self):
        """对应入参 FaceContents 中错误图片下标，从 0 开始。
        :rtype: int
        """
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index

    @property
    def ErrCode(self):
        """错误码，取值：
<li>0：成功；</li>
<li>其他：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误描述。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Index = params.get("Index")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSamplePerson(AbstractModel):
    """AI 样本管理，人物信息。

    """

    def __init__(self):
        r"""
        :param _PersonId: 人物 ID。
        :type PersonId: str
        :param _Name: 人物名称。
        :type Name: str
        :param _Description: 人物描述。
        :type Description: str
        :param _FaceInfoSet: 人脸信息。
        :type FaceInfoSet: list of AiSampleFaceInfo
        :param _TagSet: 人物标签。
        :type TagSet: list of str
        :param _UsageSet: 应用场景。
        :type UsageSet: list of str
        :param _CreateTime: 创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._FaceInfoSet = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PersonId(self):
        """人物 ID。
        :rtype: str
        """
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        """人物名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """人物描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceInfoSet(self):
        """人脸信息。
        :rtype: list of AiSampleFaceInfo
        """
        return self._FaceInfoSet

    @FaceInfoSet.setter
    def FaceInfoSet(self, FaceInfoSet):
        self._FaceInfoSet = FaceInfoSet

    @property
    def TagSet(self):
        """人物标签。
        :rtype: list of str
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        """应用场景。
        :rtype: list of str
        """
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        """创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("FaceInfoSet") is not None:
            self._FaceInfoSet = []
            for item in params.get("FaceInfoSet"):
                obj = AiSampleFaceInfo()
                obj._deserialize(item)
                self._FaceInfoSet.append(obj)
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleTagOperation(AbstractModel):
    """AI 样本管理，标签操作。

    """

    def __init__(self):
        r"""
        :param _Type: 操作类型，可选值：add（添加）、delete（删除）、reset（重置）。
        :type Type: str
        :param _Tags: 标签，长度限制：128 个字符。
        :type Tags: list of str
        """
        self._Type = None
        self._Tags = None

    @property
    def Type(self):
        """操作类型，可选值：add（添加）、delete（删除）、reset（重置）。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        """标签，长度限制：128 个字符。
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWord(AbstractModel):
    """AI 样本管理，关键词输出信息。

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词。
        :type Keyword: str
        :param _TagSet: 关键词标签。
        :type TagSet: list of str
        :param _UsageSet: 关键词应用场景。
        :type UsageSet: list of str
        :param _CreateTime: 创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Keyword = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Keyword(self):
        """关键词。
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TagSet(self):
        """关键词标签。
        :rtype: list of str
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        """关键词应用场景。
        :rtype: list of str
        """
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        """创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWordInfo(AbstractModel):
    """AI 样本管理，关键词输入信息。

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词，长度限制：20 个字符。
        :type Keyword: str
        :param _Tags: 关键词标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :type Tags: list of str
        """
        self._Keyword = None
        self._Tags = None

    @property
    def Keyword(self):
        """关键词，长度限制：20 个字符。
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Tags(self):
        """关键词标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicTaskInput(AbstractModel):
    """转动图任务类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频转动图模板 ID
        :type Definition: int
        :param _StartTimeOffset: 动图在视频中的起始时间偏移，单位为秒。
<li>不填或填0，表示从视频的起始位置开始；</li>
<li>当数值大于0时（假设为 n），表示从视频的第 n 秒位置开始；</li>
<li>当数值小于0时（假设为 -n），表示从视频结束 n 秒前的位置开始。</li>
        :type StartTimeOffset: float
        :param _EndTimeOffset: 动图在视频中的终止时间偏移，单位为秒。
<li>不填或填0，表示持续到视频的末尾终止；</li>
<li>当数值大于0时（假设为 n），表示持续到视频第 n 秒时终止；</li>
<li>当数值小于0时（假设为 -n），表示持续到视频结束 n 秒前终止。</li>
        :type EndTimeOffset: float
        """
        self._Definition = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Definition(self):
        """视频转动图模板 ID
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def StartTimeOffset(self):
        """动图在视频中的起始时间偏移，单位为秒。
<li>不填或填0，表示从视频的起始位置开始；</li>
<li>当数值大于0时（假设为 n），表示从视频的第 n 秒位置开始；</li>
<li>当数值小于0时（假设为 -n），表示从视频结束 n 秒前的位置开始。</li>
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """动图在视频中的终止时间偏移，单位为秒。
<li>不填或填0，表示持续到视频的末尾终止；</li>
<li>当数值大于0时（假设为 n），表示持续到视频第 n 秒时终止；</li>
<li>当数值小于0时（假设为 -n），表示持续到视频结束 n 秒前终止。</li>
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicsTemplate(AbstractModel):
    """转动图模板详情。

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转动图模板名称。
        :type Name: str
        :param _Comment: 转动图模板描述信息。
        :type Comment: str
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式。
        :type Format: str
        :param _Fps: 帧率。
        :type Fps: int
        :param _Quality: 图片质量。
        :type Quality: float
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        """转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        """模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        """转动图模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """转动图模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        """动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        """分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        """动图格式。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        """帧率。
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        """图片质量。
        :rtype: float
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def CreateTime(self):
        """模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyUploadRequest(AbstractModel):
    """ApplyUpload请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MediaType: 媒体类型，可选值请参考 [上传能力综述](/document/product/266/9760#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B)。
        :type MediaType: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _MediaName: 媒体名称。
        :type MediaName: str
        :param _CoverType: 封面类型，可选值请参考 [上传能力综述](/document/product/266/9760#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B)。
        :type CoverType: str
        :param _Procedure: 媒体后续任务处理操作，即完成媒体上传后，可自动发起任务流操作。参数值为任务流模板名，云点播支持 [创建任务流模板](/document/product/266/33819) 并为模板命名。
        :type Procedure: str
        :param _ExpireTime: 媒体文件过期时间，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type ExpireTime: str
        :param _StorageRegion: 指定上传园区，仅适用于对上传地域有特殊需求的用户。
        :type StorageRegion: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _SourceContext: 来源上下文，用于透传用户请求信息，[上传完成回调](/document/product/266/7830) 将返回该字段值，最长 250 个字符。
        :type SourceContext: str
        :param _SessionContext: 会话上下文，用于透传用户请求信息，当指定 Procedure 参数后，[任务流状态变更回调](/document/product/266/9636) 将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        """
        self._MediaType = None
        self._SubAppId = None
        self._MediaName = None
        self._CoverType = None
        self._Procedure = None
        self._ExpireTime = None
        self._StorageRegion = None
        self._ClassId = None
        self._SourceContext = None
        self._SessionContext = None
        self._ExtInfo = None

    @property
    def MediaType(self):
        """媒体类型，可选值请参考 [上传能力综述](/document/product/266/9760#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B)。
        :rtype: str
        """
        return self._MediaType

    @MediaType.setter
    def MediaType(self, MediaType):
        self._MediaType = MediaType

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def MediaName(self):
        """媒体名称。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def CoverType(self):
        """封面类型，可选值请参考 [上传能力综述](/document/product/266/9760#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B)。
        :rtype: str
        """
        return self._CoverType

    @CoverType.setter
    def CoverType(self, CoverType):
        self._CoverType = CoverType

    @property
    def Procedure(self):
        """媒体后续任务处理操作，即完成媒体上传后，可自动发起任务流操作。参数值为任务流模板名，云点播支持 [创建任务流模板](/document/product/266/33819) 并为模板命名。
        :rtype: str
        """
        return self._Procedure

    @Procedure.setter
    def Procedure(self, Procedure):
        self._Procedure = Procedure

    @property
    def ExpireTime(self):
        """媒体文件过期时间，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def StorageRegion(self):
        """指定上传园区，仅适用于对上传地域有特殊需求的用户。
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def ClassId(self):
        """分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def SourceContext(self):
        """来源上下文，用于透传用户请求信息，[上传完成回调](/document/product/266/7830) 将返回该字段值，最长 250 个字符。
        :rtype: str
        """
        return self._SourceContext

    @SourceContext.setter
    def SourceContext(self, SourceContext):
        self._SourceContext = SourceContext

    @property
    def SessionContext(self):
        """会话上下文，用于透传用户请求信息，当指定 Procedure 参数后，[任务流状态变更回调](/document/product/266/9636) 将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ExtInfo(self):
        """保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._MediaType = params.get("MediaType")
        self._SubAppId = params.get("SubAppId")
        self._MediaName = params.get("MediaName")
        self._CoverType = params.get("CoverType")
        self._Procedure = params.get("Procedure")
        self._ExpireTime = params.get("ExpireTime")
        self._StorageRegion = params.get("StorageRegion")
        self._ClassId = params.get("ClassId")
        self._SourceContext = params.get("SourceContext")
        self._SessionContext = params.get("SessionContext")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyUploadResponse(AbstractModel):
    """ApplyUpload返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StorageBucket: 存储桶，用于上传接口 URL 的 bucket_name。
        :type StorageBucket: str
        :param _StorageRegion: 存储园区，用于上传接口 Host 的 Region。
        :type StorageRegion: str
        :param _VodSessionKey: 点播会话，用于确认上传接口的参数 VodSessionKey。
        :type VodSessionKey: str
        :param _MediaStoragePath: 媒体存储路径，用于上传接口存储媒体的对象键（Key）。
        :type MediaStoragePath: str
        :param _CoverStoragePath: 封面存储路径，用于上传接口存储封面的对象键（Key）。
        :type CoverStoragePath: str
        :param _TempCertificate: 临时凭证，用于上传接口的权限验证。
        :type TempCertificate: :class:`tencentcloud.vod.v20180717.models.TempCertificate`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StorageBucket = None
        self._StorageRegion = None
        self._VodSessionKey = None
        self._MediaStoragePath = None
        self._CoverStoragePath = None
        self._TempCertificate = None
        self._RequestId = None

    @property
    def StorageBucket(self):
        """存储桶，用于上传接口 URL 的 bucket_name。
        :rtype: str
        """
        return self._StorageBucket

    @StorageBucket.setter
    def StorageBucket(self, StorageBucket):
        self._StorageBucket = StorageBucket

    @property
    def StorageRegion(self):
        """存储园区，用于上传接口 Host 的 Region。
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def VodSessionKey(self):
        """点播会话，用于确认上传接口的参数 VodSessionKey。
        :rtype: str
        """
        return self._VodSessionKey

    @VodSessionKey.setter
    def VodSessionKey(self, VodSessionKey):
        self._VodSessionKey = VodSessionKey

    @property
    def MediaStoragePath(self):
        """媒体存储路径，用于上传接口存储媒体的对象键（Key）。
        :rtype: str
        """
        return self._MediaStoragePath

    @MediaStoragePath.setter
    def MediaStoragePath(self, MediaStoragePath):
        self._MediaStoragePath = MediaStoragePath

    @property
    def CoverStoragePath(self):
        """封面存储路径，用于上传接口存储封面的对象键（Key）。
        :rtype: str
        """
        return self._CoverStoragePath

    @CoverStoragePath.setter
    def CoverStoragePath(self, CoverStoragePath):
        self._CoverStoragePath = CoverStoragePath

    @property
    def TempCertificate(self):
        """临时凭证，用于上传接口的权限验证。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TempCertificate`
        """
        return self._TempCertificate

    @TempCertificate.setter
    def TempCertificate(self, TempCertificate):
        self._TempCertificate = TempCertificate

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StorageBucket = params.get("StorageBucket")
        self._StorageRegion = params.get("StorageRegion")
        self._VodSessionKey = params.get("VodSessionKey")
        self._MediaStoragePath = params.get("MediaStoragePath")
        self._CoverStoragePath = params.get("CoverStoragePath")
        if params.get("TempCertificate") is not None:
            self._TempCertificate = TempCertificate()
            self._TempCertificate._deserialize(params.get("TempCertificate"))
        self._RequestId = params.get("RequestId")


class AreaCLSTargetInfo(AbstractModel):
    """日志推送目标。

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属地区：
<li>ap-guangzhou：广州；</li>
<li>ap-beijing：北京；</li>
<li>ap-chengdu：成都；</li>
<li>ap-chongqing：重庆；</li>
<li>ap-nanjing：南京；</li>
<li>ap-shanghai：上海；</li>
<li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        :param _TopicId: 投递的目标主题 ID。
        :type TopicId: str
        :param _LogsetId: 投递的目标集 ID。
        :type LogsetId: str
        :param _Switch: 日志投递状态。
 ON：启用；
 OFF：停用。
        :type Switch: str
        """
        self._CLSRegion = None
        self._TopicId = None
        self._LogsetId = None
        self._Switch = None

    @property
    def CLSRegion(self):
        """日志集所属地区：
<li>ap-guangzhou：广州；</li>
<li>ap-beijing：北京；</li>
<li>ap-chengdu：成都；</li>
<li>ap-chongqing：重庆；</li>
<li>ap-nanjing：南京；</li>
<li>ap-shanghai：上海；</li>
<li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def TopicId(self):
        """投递的目标主题 ID。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def LogsetId(self):
        """投递的目标集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def Switch(self):
        """日志投递状态。
 ON：启用；
 OFF：停用。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._TopicId = params.get("TopicId")
        self._LogsetId = params.get("LogsetId")
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ArtifactRepairInfo(AbstractModel):
    """去伪影（毛刺）控制信息

    """

    def __init__(self):
        r"""
        :param _Switch: 去伪影（毛刺）控制开关，可选值：
<li>ON：开启去伪影（毛刺）；</li>
<li>OFF：关闭去伪影（毛刺）。</li>
        :type Switch: str
        :param _Type: 去伪影（毛刺）类型，仅当去伪影（毛刺）控制开关为 ON 时有效，可选值：
<li>weak：轻去伪影（毛刺）；</li>
<li>strong：强去伪影（毛刺）。</li>
默认值：weak。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        """去伪影（毛刺）控制开关，可选值：
<li>ON：开启去伪影（毛刺）；</li>
<li>OFF：关闭去伪影（毛刺）。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        """去伪影（毛刺）类型，仅当去伪影（毛刺）控制开关为 ON 时有效，可选值：
<li>weak：轻去伪影（毛刺）；</li>
<li>strong：强去伪影（毛刺）。</li>
默认值：weak。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfo(AbstractModel):
    """语音全文识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :type Switch: str
        :param _SubtitleFormats: 生成的字幕文件格式列表，不填或者填空数组表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li><font color=red>注意：</font>云点播媒资信息仅支持添加 vtt 字幕，因此当且仅当 SubtitleFormats 包含 vtt 时，云点播将生成的字幕添加到媒资。
        :type SubtitleFormats: list of str
        :param _SubtitleFormat: 生成的字幕文件格式，不填或者填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li>
<font color='red'>注意：此字段已废弃，建议使用 SubtitleFormats。</font>
        :type SubtitleFormat: str
        :param _SrcLanguage: 媒体源语言，取值范围：
<li>zh：中文普通话；</li>
<li>en：英语；</li>
<li>ja：日语；</li>
<li>zh-ca：粤语。</li>
<font color=red>注意：</font> 填空字符串，或者不填该参数，则自动识别（效果较难保证，推荐填写原始媒体对应的语言，以提高识别的准确率）。
        :type SrcLanguage: str
        :param _SubtitleName: 指定字幕名称，长度限制：64 个字符。该值将用于播放器展示，若不填则云点播自动生成。
<font color=red>注意：</font>仅当 SubtitleFormats 包含 vtt 时，该字段有效。
        :type SubtitleName: str
        """
        self._Switch = None
        self._SubtitleFormats = None
        self._SubtitleFormat = None
        self._SrcLanguage = None
        self._SubtitleName = None

    @property
    def Switch(self):
        """语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormats(self):
        """生成的字幕文件格式列表，不填或者填空数组表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li><font color=red>注意：</font>云点播媒资信息仅支持添加 vtt 字幕，因此当且仅当 SubtitleFormats 包含 vtt 时，云点播将生成的字幕添加到媒资。
        :rtype: list of str
        """
        return self._SubtitleFormats

    @SubtitleFormats.setter
    def SubtitleFormats(self, SubtitleFormats):
        self._SubtitleFormats = SubtitleFormats

    @property
    def SubtitleFormat(self):
        """生成的字幕文件格式，不填或者填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li>
<font color='red'>注意：此字段已废弃，建议使用 SubtitleFormats。</font>
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def SrcLanguage(self):
        """媒体源语言，取值范围：
<li>zh：中文普通话；</li>
<li>en：英语；</li>
<li>ja：日语；</li>
<li>zh-ca：粤语。</li>
<font color=red>注意：</font> 填空字符串，或者不填该参数，则自动识别（效果较难保证，推荐填写原始媒体对应的语言，以提高识别的准确率）。
        :rtype: str
        """
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage

    @property
    def SubtitleName(self):
        """指定字幕名称，长度限制：64 个字符。该值将用于播放器展示，若不填则云点播自动生成。
<font color=red>注意：</font>仅当 SubtitleFormats 包含 vtt 时，该字段有效。
        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormats = params.get("SubtitleFormats")
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SrcLanguage = params.get("SrcLanguage")
        self._SubtitleName = params.get("SubtitleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfoForUpdate(AbstractModel):
    """语音全文识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :type Switch: str
        :param _SubtitleFormatsOperation: 字幕格式列表操作信息。
        :type SubtitleFormatsOperation: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        :param _SubtitleFormat: 生成的字幕文件格式，<font color='red'>填空字符串</font>表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li>
<font color='red'>注意：此字段已废弃，建议使用 SubtitleFormatsOperation。</font>
        :type SubtitleFormat: str
        :param _SrcLanguage: 媒体源语言，取值范围：
<li>zh：中文普通话；</li>
<li>en：英语；</li>
<li>ja：日语；</li>
<li>zh-ca：粤语。</li>
        :type SrcLanguage: str
        :param _SubtitleName: 指定字幕名称，长度限制：64 个字符。该值将用于播放器展示。
        :type SubtitleName: str
        """
        self._Switch = None
        self._SubtitleFormatsOperation = None
        self._SubtitleFormat = None
        self._SrcLanguage = None
        self._SubtitleName = None

    @property
    def Switch(self):
        """语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormatsOperation(self):
        """字幕格式列表操作信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        """
        return self._SubtitleFormatsOperation

    @SubtitleFormatsOperation.setter
    def SubtitleFormatsOperation(self, SubtitleFormatsOperation):
        self._SubtitleFormatsOperation = SubtitleFormatsOperation

    @property
    def SubtitleFormat(self):
        """生成的字幕文件格式，<font color='red'>填空字符串</font>表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li>
<font color='red'>注意：此字段已废弃，建议使用 SubtitleFormatsOperation。</font>
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def SrcLanguage(self):
        """媒体源语言，取值范围：
<li>zh：中文普通话；</li>
<li>en：英语；</li>
<li>ja：日语；</li>
<li>zh-ca：粤语。</li>
        :rtype: str
        """
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage

    @property
    def SubtitleName(self):
        """指定字幕名称，长度限制：64 个字符。该值将用于播放器展示。
        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("SubtitleFormatsOperation") is not None:
            self._SubtitleFormatsOperation = SubtitleFormatsOperation()
            self._SubtitleFormatsOperation._deserialize(params.get("SubtitleFormatsOperation"))
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SrcLanguage = params.get("SrcLanguage")
        self._SubtitleName = params.get("SubtitleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrTranslateConfigureInfo(AbstractModel):
    """语音翻译任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音翻译任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li><font color=red>注意：</font>语音翻译任务本身会返回 ASR 全文识别结果，为避免重复收费，因此禁止同时开启语音翻译和 ASR 全文识别功能项。

        :type Switch: str
        :param _SrcLanguage: 媒体源语言，当 Switch 为 ON 时，此参数必填。取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>vi：越南语；</li>
<li>ms：马来语；</li>
<li>th：泰语；</li>
<li>pt：葡萄牙语；</li>
<li>tr：土耳其语；</li>
<li>ar：阿拉伯语；</li>
<li>es：西班牙语；</li>
<li>hi：印地语；</li>
<li>fr：法语。</li>
        :type SrcLanguage: str
        :param _DstLanguage: 翻译目标语言，当 Switch 为 ON 时，此参数必填。
当 SrcLanguage 为 zh（中文）时，取值范围：
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语。</li>
当 SrcLanguage 为 en（英文）时，取值范围：
<li>zh：中文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语；</li>
<li>ar：阿拉伯语；</li>
<li>hi：印地语。</li>
当 SrcLanguage 为 ja（日文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ko：韩文。</li>
当 SrcLanguage 为 ko（韩文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文。</li>
当 SrcLanguage 为 vi（越南语）或 ms（马来语）或 th（泰语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文。</li>
当 SrcLanguage 为 pt（葡萄牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语。</li>
当 SrcLanguage 为 tr（土耳其语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 es（西班牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 ar（阿拉伯语）或 hi（印地语）时，取值范围：
<li>en：英文。</li>
当 SrcLanguage 为 fr（法语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
        :type DstLanguage: str
        :param _SubtitleFormats: 生成的字幕文件格式列表，不填或者填空数组表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li><font color=red>注意：</font> 云点播媒资信息仅支持添加 vtt 字幕，因此当且仅当 SubtitleFormats 包含 vtt 时，云点播将生成的字幕添加到媒资。
        :type SubtitleFormats: list of str
        :param _SubtitleName: 指定字幕名称，长度限制：64 个字符。该值将用于播放器展示，若不填则云点播自动生成。
<font color=red>注意：</font>仅当 SubtitleFormats 包含 vtt 时，该字段有效。

        :type SubtitleName: str
        """
        self._Switch = None
        self._SrcLanguage = None
        self._DstLanguage = None
        self._SubtitleFormats = None
        self._SubtitleName = None

    @property
    def Switch(self):
        """语音翻译任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li><font color=red>注意：</font>语音翻译任务本身会返回 ASR 全文识别结果，为避免重复收费，因此禁止同时开启语音翻译和 ASR 全文识别功能项。

        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SrcLanguage(self):
        """媒体源语言，当 Switch 为 ON 时，此参数必填。取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>vi：越南语；</li>
<li>ms：马来语；</li>
<li>th：泰语；</li>
<li>pt：葡萄牙语；</li>
<li>tr：土耳其语；</li>
<li>ar：阿拉伯语；</li>
<li>es：西班牙语；</li>
<li>hi：印地语；</li>
<li>fr：法语。</li>
        :rtype: str
        """
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage

    @property
    def DstLanguage(self):
        """翻译目标语言，当 Switch 为 ON 时，此参数必填。
当 SrcLanguage 为 zh（中文）时，取值范围：
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语。</li>
当 SrcLanguage 为 en（英文）时，取值范围：
<li>zh：中文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语；</li>
<li>ar：阿拉伯语；</li>
<li>hi：印地语。</li>
当 SrcLanguage 为 ja（日文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ko：韩文。</li>
当 SrcLanguage 为 ko（韩文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文。</li>
当 SrcLanguage 为 vi（越南语）或 ms（马来语）或 th（泰语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文。</li>
当 SrcLanguage 为 pt（葡萄牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语。</li>
当 SrcLanguage 为 tr（土耳其语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 es（西班牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 ar（阿拉伯语）或 hi（印地语）时，取值范围：
<li>en：英文。</li>
当 SrcLanguage 为 fr（法语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
        :rtype: str
        """
        return self._DstLanguage

    @DstLanguage.setter
    def DstLanguage(self, DstLanguage):
        self._DstLanguage = DstLanguage

    @property
    def SubtitleFormats(self):
        """生成的字幕文件格式列表，不填或者填空数组表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li><font color=red>注意：</font> 云点播媒资信息仅支持添加 vtt 字幕，因此当且仅当 SubtitleFormats 包含 vtt 时，云点播将生成的字幕添加到媒资。
        :rtype: list of str
        """
        return self._SubtitleFormats

    @SubtitleFormats.setter
    def SubtitleFormats(self, SubtitleFormats):
        self._SubtitleFormats = SubtitleFormats

    @property
    def SubtitleName(self):
        """指定字幕名称，长度限制：64 个字符。该值将用于播放器展示，若不填则云点播自动生成。
<font color=red>注意：</font>仅当 SubtitleFormats 包含 vtt 时，该字段有效。

        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SrcLanguage = params.get("SrcLanguage")
        self._DstLanguage = params.get("DstLanguage")
        self._SubtitleFormats = params.get("SubtitleFormats")
        self._SubtitleName = params.get("SubtitleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrTranslateConfigureInfoForUpdate(AbstractModel):
    """语音翻译控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音翻译任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        :param _SrcLanguage: 媒体源语言，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>vi：越南语；</li>
<li>ms：马来语；</li>
<li>th：泰语；</li>
<li>pt：葡萄牙语；</li>
<li>tr：土耳其语；</li>
<li>ar：阿拉伯语；</li>
<li>es：西班牙语；</li>
<li>hi：印地语；</li>
<li>fr：法语。</li>
        :type SrcLanguage: str
        :param _DstLanguage: 翻译目标语言。
当 SrcLanguage 为 zh（中文）时，取值范围：
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语。</li>
当 SrcLanguage 为 en（英文）时，取值范围：
<li>zh：中文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语；</li>
<li>ar：阿拉伯语；</li>
<li>hi：印地语。</li>
当 SrcLanguage 为 ja（日文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ko：韩文。</li>
当 SrcLanguage 为 ko（韩文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文。</li>
当 SrcLanguage 为 vi（越南语）或 ms（马来语）或 th（泰语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文。</li>
当 SrcLanguage 为 pt（葡萄牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语。</li>
当 SrcLanguage 为 tr（土耳其语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 es（西班牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 ar（阿拉伯语）或 hi（印地语）时，取值范围：
<li>en：英文。</li>
当 SrcLanguage 为 fr（法语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
        :type DstLanguage: str
        :param _SubtitleFormatsOperation: 字幕格式列表操作信息。
        :type SubtitleFormatsOperation: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        :param _SubtitleName: 指定字幕名称，长度限制：64 个字符。该值将用于播放器展示。
        :type SubtitleName: str
        """
        self._Switch = None
        self._SrcLanguage = None
        self._DstLanguage = None
        self._SubtitleFormatsOperation = None
        self._SubtitleName = None

    @property
    def Switch(self):
        """语音翻译任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SrcLanguage(self):
        """媒体源语言，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>vi：越南语；</li>
<li>ms：马来语；</li>
<li>th：泰语；</li>
<li>pt：葡萄牙语；</li>
<li>tr：土耳其语；</li>
<li>ar：阿拉伯语；</li>
<li>es：西班牙语；</li>
<li>hi：印地语；</li>
<li>fr：法语。</li>
        :rtype: str
        """
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage

    @property
    def DstLanguage(self):
        """翻译目标语言。
当 SrcLanguage 为 zh（中文）时，取值范围：
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语。</li>
当 SrcLanguage 为 en（英文）时，取值范围：
<li>zh：中文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语；</li>
<li>ar：阿拉伯语；</li>
<li>hi：印地语。</li>
当 SrcLanguage 为 ja（日文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ko：韩文。</li>
当 SrcLanguage 为 ko（韩文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文。</li>
当 SrcLanguage 为 vi（越南语）或 ms（马来语）或 th（泰语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文。</li>
当 SrcLanguage 为 pt（葡萄牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语。</li>
当 SrcLanguage 为 tr（土耳其语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 es（西班牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 ar（阿拉伯语）或 hi（印地语）时，取值范围：
<li>en：英文。</li>
当 SrcLanguage 为 fr（法语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
        :rtype: str
        """
        return self._DstLanguage

    @DstLanguage.setter
    def DstLanguage(self, DstLanguage):
        self._DstLanguage = DstLanguage

    @property
    def SubtitleFormatsOperation(self):
        """字幕格式列表操作信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        """
        return self._SubtitleFormatsOperation

    @SubtitleFormatsOperation.setter
    def SubtitleFormatsOperation(self, SubtitleFormatsOperation):
        self._SubtitleFormatsOperation = SubtitleFormatsOperation

    @property
    def SubtitleName(self):
        """指定字幕名称，长度限制：64 个字符。该值将用于播放器展示。
        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SrcLanguage = params.get("SrcLanguage")
        self._DstLanguage = params.get("DstLanguage")
        if params.get("SubtitleFormatsOperation") is not None:
            self._SubtitleFormatsOperation = SubtitleFormatsOperation()
            self._SubtitleFormatsOperation._deserialize(params.get("SubtitleFormatsOperation"))
        self._SubtitleName = params.get("SubtitleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfo(AbstractModel):
    """语音关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        """语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        """关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :rtype: list of str
        """
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfoForUpdate(AbstractModel):
    """语音关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        """语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        """关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :rtype: list of str
        """
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachMediaSubtitlesRequest(AbstractModel):
    """AttachMediaSubtitles请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件唯一标识。
        :type FileId: str
        :param _Operation: 操作。取值如下：
<li>Attach：关联字幕。</li>
<li>Detach：解除关联字幕。</li>
        :type Operation: str
        :param _AdaptiveDynamicStreamingDefinition: [转自适应码流模板号](https://cloud.tencent.com/document/product/266/34071#zsy)。
        :type AdaptiveDynamicStreamingDefinition: int
        :param _SubtitleIds: 字幕的唯一标识。
        :type SubtitleIds: list of str
        :param _DefaultSubtitleId: 默认字幕的唯一标识。不填则不设置默认字幕。
        :type DefaultSubtitleId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._FileId = None
        self._Operation = None
        self._AdaptiveDynamicStreamingDefinition = None
        self._SubtitleIds = None
        self._DefaultSubtitleId = None
        self._SubAppId = None

    @property
    def FileId(self):
        """媒体文件唯一标识。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Operation(self):
        """操作。取值如下：
<li>Attach：关联字幕。</li>
<li>Detach：解除关联字幕。</li>
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def AdaptiveDynamicStreamingDefinition(self):
        """[转自适应码流模板号](https://cloud.tencent.com/document/product/266/34071#zsy)。
        :rtype: int
        """
        return self._AdaptiveDynamicStreamingDefinition

    @AdaptiveDynamicStreamingDefinition.setter
    def AdaptiveDynamicStreamingDefinition(self, AdaptiveDynamicStreamingDefinition):
        self._AdaptiveDynamicStreamingDefinition = AdaptiveDynamicStreamingDefinition

    @property
    def SubtitleIds(self):
        """字幕的唯一标识。
        :rtype: list of str
        """
        return self._SubtitleIds

    @SubtitleIds.setter
    def SubtitleIds(self, SubtitleIds):
        self._SubtitleIds = SubtitleIds

    @property
    def DefaultSubtitleId(self):
        """默认字幕的唯一标识。不填则不设置默认字幕。
        :rtype: str
        """
        return self._DefaultSubtitleId

    @DefaultSubtitleId.setter
    def DefaultSubtitleId(self, DefaultSubtitleId):
        self._DefaultSubtitleId = DefaultSubtitleId

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._Operation = params.get("Operation")
        self._AdaptiveDynamicStreamingDefinition = params.get("AdaptiveDynamicStreamingDefinition")
        self._SubtitleIds = params.get("SubtitleIds")
        self._DefaultSubtitleId = params.get("DefaultSubtitleId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachMediaSubtitlesResponse(AbstractModel):
    """AttachMediaSubtitles返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AudioDenoiseInfo(AbstractModel):
    """音频降噪控制信息

    """

    def __init__(self):
        r"""
        :param _Switch: 音频降噪控制开关，可选值：
<li>ON：开启音频降噪；</li>
<li>OFF：关闭音频降噪。</li>
        :type Switch: str
        :param _Type: 音频降噪类型，仅当音频降噪控制开关为 ON 时有效，可选值：
<li>weak：轻音频降噪；</li>
<li>normal：正常音频降噪；</li>
<li>strong：强音频降噪。</li>
默认值：weak。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        """音频降噪控制开关，可选值：
<li>ON：开启音频降噪；</li>
<li>OFF：关闭音频降噪。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        """音频降噪类型，仅当音频降噪控制开关为 ON 时有效，可选值：
<li>weak：轻音频降噪；</li>
<li>normal：正常音频降噪；</li>
<li>strong：强音频降噪。</li>
默认值：weak。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfo(AbstractModel):
    """音频流配置参数

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码格式。
当外层参数 Container 为 mp3 时，可选值为：
<li>libmp3lame。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>libfdk_aac；</li>
<li>libmp3lame；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>libfdk_aac：更适合 mp4；</li>
<li>libmp3lame：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Format 为 HLS 或 MPEG-DASH 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Container 为 wav 时，可选值为：
<li>pcm16。</li>
        :type Codec: str
        :param _Bitrate: 音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。
当取值为 0，表示音频码率和原始音频保持一致。
        :type Bitrate: int
        :param _SampleRate: 音频流的采样率，可选值：
<li>16000，仅当 Codec 为 pcm16 时可选。</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :type SampleRate: int
        :param _AudioChannel: 音频通道，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：立体声</li>
<li>0：音频声道数和原始音频保持一致</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为立体声。
默认值：2。
        :type AudioChannel: int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        """音频流的编码格式。
当外层参数 Container 为 mp3 时，可选值为：
<li>libmp3lame。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>libfdk_aac；</li>
<li>libmp3lame；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>libfdk_aac：更适合 mp4；</li>
<li>libmp3lame：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Format 为 HLS 或 MPEG-DASH 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Container 为 wav 时，可选值为：
<li>pcm16。</li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        """音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。
当取值为 0，表示音频码率和原始音频保持一致。
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        """音频流的采样率，可选值：
<li>16000，仅当 Codec 为 pcm16 时可选。</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        """音频通道，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：立体声</li>
<li>0：音频声道数和原始音频保持一致</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为立体声。
默认值：2。
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfoForUpdate(AbstractModel):
    """音频流配置参数

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码格式。
当外层参数 Container 为 mp3 时，可选值为：
<li>libmp3lame。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>libfdk_aac；</li>
<li>libmp3lame；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>libfdk_aac：更适合 mp4；</li>
<li>libmp3lame：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Format 为 HLS 或 MPEG-DASH 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Container 为 wav 时，可选值为：
<li>pcm16。</li>
        :type Codec: str
        :param _Bitrate: 音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。 当取值为 0，表示音频码率和原始音频保持一致。
        :type Bitrate: int
        :param _SampleRate: 音频流的采样率，可选值：
<li>16000，仅当 Codec 为 pcm16 时可选。</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :type SampleRate: int
        :param _AudioChannel: 音频通道，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：立体声</li>
<li>0：音频声道数和原始音频保持一致</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为立体声。
        :type AudioChannel: int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        """音频流的编码格式。
当外层参数 Container 为 mp3 时，可选值为：
<li>libmp3lame。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>libfdk_aac；</li>
<li>libmp3lame；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>libfdk_aac：更适合 mp4；</li>
<li>libmp3lame：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Format 为 HLS 或 MPEG-DASH 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Container 为 wav 时，可选值为：
<li>pcm16。</li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        """音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。 当取值为 0，表示音频码率和原始音频保持一致。
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        """音频流的采样率，可选值：
<li>16000，仅当 Codec 为 pcm16 时可选。</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        """音频通道，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：立体声</li>
<li>0：音频声道数和原始音频保持一致</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为立体声。
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTrackItem(AbstractModel):
    """音频轨道上的音频片段信息。

    """

    def __init__(self):
        r"""
        :param _SourceMedia: 音频片段的媒体素材来源，可以是：
<li>点播的媒体文件 ID；</li>
<li>其他媒体文件的下载 URL。</li>
注意：当使用其他媒体文件的下载 URL 作为素材来源，且开启了访问控制（如防盗链）时，需要在 URL 携带访问控制参数（如防盗链签名）。
        :type SourceMedia: str
        :param _SourceMediaStartTime: 音频片段取自素材文件的起始时间，单位为秒。0 表示从素材开始位置截取。默认为0。
        :type SourceMediaStartTime: float
        :param _Duration: 音频片段的时长，单位为秒。默认和素材本身长度一致，表示截取全部素材。
        :type Duration: float
        :param _TargetDuration: 音频片段目标时长，单位为秒。
<li>当 TargetDuration 不填或填0时，表示目标时长和 Duration 一致；</li>
<li>当 TargetDuration 取大于0的值时，将对音频片段做快进或慢放等处理，使得输出片段的时长等于 TargetDuration。</li>
        :type TargetDuration: float
        :param _AudioOperations: 对音频片段进行的操作，如音量调节等。
        :type AudioOperations: list of AudioTransform
        """
        self._SourceMedia = None
        self._SourceMediaStartTime = None
        self._Duration = None
        self._TargetDuration = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        """音频片段的媒体素材来源，可以是：
<li>点播的媒体文件 ID；</li>
<li>其他媒体文件的下载 URL。</li>
注意：当使用其他媒体文件的下载 URL 作为素材来源，且开启了访问控制（如防盗链）时，需要在 URL 携带访问控制参数（如防盗链签名）。
        :rtype: str
        """
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def SourceMediaStartTime(self):
        """音频片段取自素材文件的起始时间，单位为秒。0 表示从素材开始位置截取。默认为0。
        :rtype: float
        """
        return self._SourceMediaStartTime

    @SourceMediaStartTime.setter
    def SourceMediaStartTime(self, SourceMediaStartTime):
        self._SourceMediaStartTime = SourceMediaStartTime

    @property
    def Duration(self):
        """音频片段的时长，单位为秒。默认和素材本身长度一致，表示截取全部素材。
        :rtype: float
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def TargetDuration(self):
        """音频片段目标时长，单位为秒。
<li>当 TargetDuration 不填或填0时，表示目标时长和 Duration 一致；</li>
<li>当 TargetDuration 取大于0的值时，将对音频片段做快进或慢放等处理，使得输出片段的时长等于 TargetDuration。</li>
        :rtype: float
        """
        return self._TargetDuration

    @TargetDuration.setter
    def TargetDuration(self, TargetDuration):
        self._TargetDuration = TargetDuration

    @property
    def AudioOperations(self):
        """对音频片段进行的操作，如音量调节等。
        :rtype: list of AudioTransform
        """
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        self._SourceMedia = params.get("SourceMedia")
        self._SourceMediaStartTime = params.get("SourceMediaStartTime")
        self._Duration = params.get("Duration")
        self._TargetDuration = params.get("TargetDuration")
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = AudioTransform()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTransform(AbstractModel):
    """音频操作

    """

    def __init__(self):
        r"""
        :param _Type: 音频操作类型，取值有：
<li>Volume：音量调节。</li>
        :type Type: str
        :param _VolumeParam: 音量调节参数， 当 Type = Volume 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type VolumeParam: :class:`tencentcloud.vod.v20180717.models.AudioVolumeParam`
        """
        self._Type = None
        self._VolumeParam = None

    @property
    def Type(self):
        """音频操作类型，取值有：
<li>Volume：音量调节。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def VolumeParam(self):
        """音量调节参数， 当 Type = Volume 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioVolumeParam`
        """
        return self._VolumeParam

    @VolumeParam.setter
    def VolumeParam(self, VolumeParam):
        self._VolumeParam = VolumeParam


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("VolumeParam") is not None:
            self._VolumeParam = AudioVolumeParam()
            self._VolumeParam._deserialize(params.get("VolumeParam"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioVolumeParam(AbstractModel):
    """音频增益调节参数

    """

    def __init__(self):
        r"""
        :param _Mute: 是否静音，取值范围0或1。
<li>0表示不静音。</li>
<li>1表示静音。</li>
默认是0。
        :type Mute: int
        :param _Gain: 音频增益，取值范围0~10。
<li>大于1表示增加音量。</li>
<li>小于1表示降低音量。</li>
<li>0和1：表示不改变。</li>
默认是0。
        :type Gain: float
        """
        self._Mute = None
        self._Gain = None

    @property
    def Mute(self):
        """是否静音，取值范围0或1。
<li>0表示不静音。</li>
<li>1表示静音。</li>
默认是0。
        :rtype: int
        """
        return self._Mute

    @Mute.setter
    def Mute(self, Mute):
        self._Mute = Mute

    @property
    def Gain(self):
        """音频增益，取值范围0~10。
<li>大于1表示增加音量。</li>
<li>小于1表示降低音量。</li>
<li>0和1：表示不改变。</li>
默认是0。
        :rtype: float
        """
        return self._Gain

    @Gain.setter
    def Gain(self, Gain):
        self._Gain = Gain


    def _deserialize(self, params):
        self._Mute = params.get("Mute")
        self._Gain = params.get("Gain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlackWhiteEdgeConfigureInfo(AbstractModel):
    """视频画面黑边、白边、黑屏、白屏检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面黑边、白边、黑屏、白屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """视频画面黑边、白边、黑屏、白屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlackWhiteEdgeConfigureInfoForUpdate(AbstractModel):
    """视频画面黑边、白边、黑屏、白屏检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面黑边、白边、黑屏、白屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """视频画面黑边、白边、黑屏、白屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlurConfigureInfo(AbstractModel):
    """视频画面模糊检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面模糊检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """视频画面模糊检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlurConfigureInfoForUpdate(AbstractModel):
    """视频画面模糊检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面模糊检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """视频画面模糊检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CLSLogsetInfo(AbstractModel):
    """CLS 日志集信息

    """

    def __init__(self):
        r"""
        :param _LogsetId: 日志集 ID。
        :type LogsetId: str
        :param _LogsetName: 日志集名。
        :type LogsetName: str
        """
        self._LogsetId = None
        self._LogsetName = None

    @property
    def LogsetId(self):
        """日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def LogsetName(self):
        """日志集名。
        :rtype: str
        """
        return self._LogsetName

    @LogsetName.setter
    def LogsetName(self, LogsetName):
        self._LogsetName = LogsetName


    def _deserialize(self, params):
        self._LogsetId = params.get("LogsetId")
        self._LogsetName = params.get("LogsetName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CLSTopicInfo(AbstractModel):
    """CLS日志主题信息。

    """

    def __init__(self):
        r"""
        :param _TopicId: 日志主题 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type TopicId: str
        :param _TopicName: 日志主题名。
注意：此字段可能返回 null，表示取不到有效值。
        :type TopicName: str
        :param _LogsetId: 日志集 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type LogsetId: str
        """
        self._TopicId = None
        self._TopicName = None
        self._LogsetId = None

    @property
    def TopicId(self):
        """日志主题 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        """日志主题名。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def LogsetId(self):
        """日志集 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._LogsetId = params.get("LogsetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Canvas(AbstractModel):
    """画布信息。制作视频时，如果源素材（视频或者图片）不能填满输出的视频窗口，将用设置的画布进行背景绘制。

    """

    def __init__(self):
        r"""
        :param _Color: 背景颜色，取值有：
<li>Black：黑色背景</li>
<li>White：白色背景</li>
默认值：Black。
        :type Color: str
        :param _Width: 画布宽度，即输出视频的宽度，取值范围：0~ 3840，单位：px。
默认值：0，表示和第一个视频轨的第一个视频片段的视频宽度一致。
        :type Width: int
        :param _Height: 画布高度，即输出视频的高度（或长边），取值范围：0~ 3840，单位：px。
默认值：0，表示和第一个视频轨的第一个视频片段的视频高度一致。
        :type Height: int
        """
        self._Color = None
        self._Width = None
        self._Height = None

    @property
    def Color(self):
        """背景颜色，取值有：
<li>Black：黑色背景</li>
<li>White：白色背景</li>
默认值：Black。
        :rtype: str
        """
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color

    @property
    def Width(self):
        """画布宽度，即输出视频的宽度，取值范围：0~ 3840，单位：px。
默认值：0，表示和第一个视频轨的第一个视频片段的视频宽度一致。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """画布高度，即输出视频的高度（或长边），取值范围：0~ 3840，单位：px。
默认值：0，表示和第一个视频轨的第一个视频片段的视频高度一致。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Color = params.get("Color")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CdnLogInfo(AbstractModel):
    """CDN 日志信息

    """

    def __init__(self):
        r"""
        :param _Date: 日志所属日期， 格式为：yyyy-MM-dd ，如2018-03-01。
        :type Date: str
        :param _Name: 日志名称，格式为：日期小时-域名
如 2018120101-test.vod2.mqcloud.com。
        :type Name: str
        :param _Url: 日志下载链接，24小时内下载有效。
        :type Url: str
        :param _StartTime: 日志起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type StartTime: str
        :param _EndTime: 日志结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type EndTime: str
        """
        self._Date = None
        self._Name = None
        self._Url = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Date(self):
        """日志所属日期， 格式为：yyyy-MM-dd ，如2018-03-01。
        :rtype: str
        """
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def Name(self):
        """日志名称，格式为：日期小时-域名
如 2018120101-test.vod2.mqcloud.com。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Url(self):
        """日志下载链接，24小时内下载有效。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def StartTime(self):
        """日志起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """日志结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._Name = params.get("Name")
        self._Url = params.get("Url")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfo(AbstractModel):
    """智能分类任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfoForUpdate(AbstractModel):
    """智能分类任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClipFileInfo2017(AbstractModel):
    """视频裁剪结果文件信息（2017 版）

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误描述。
        :type Message: str
        :param _FileId: 输出目标文件的文件 ID。
        :type FileId: str
        :param _FileUrl: 输出目标文件的文件地址。
        :type FileUrl: str
        :param _FileType: 输出目标文件的文件类型。
        :type FileType: str
        """
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._FileUrl = None
        self._FileType = None

    @property
    def ErrCode(self):
        """错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误描述。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        """输出目标文件的文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        """输出目标文件的文件地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileType(self):
        """输出目标文件的文件类型。
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._FileType = params.get("FileType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClipTask2017(AbstractModel):
    """视频剪辑任务信息，该结构仅用于对 2017 版[视频剪辑](https://cloud.tencent.com/document/product/266/10156)接口发起的任务。

    """

    def __init__(self):
        r"""
        :param _TaskId: 视频剪辑任务 ID。
        :type TaskId: str
        :param _SrcFileId: 视频剪辑任务源文件 ID。
        :type SrcFileId: str
        :param _FileInfo: 视频剪辑输出的文件信息。
        :type FileInfo: :class:`tencentcloud.vod.v20180717.models.ClipFileInfo2017`
        """
        self._TaskId = None
        self._SrcFileId = None
        self._FileInfo = None

    @property
    def TaskId(self):
        """视频剪辑任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SrcFileId(self):
        """视频剪辑任务源文件 ID。
        :rtype: str
        """
        return self._SrcFileId

    @SrcFileId.setter
    def SrcFileId(self, SrcFileId):
        self._SrcFileId = SrcFileId

    @property
    def FileInfo(self):
        """视频剪辑输出的文件信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ClipFileInfo2017`
        """
        return self._FileInfo

    @FileInfo.setter
    def FileInfo(self, FileInfo):
        self._FileInfo = FileInfo


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SrcFileId = params.get("SrcFileId")
        if params.get("FileInfo") is not None:
            self._FileInfo = ClipFileInfo2017()
            self._FileInfo._deserialize(params.get("FileInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColorEnhanceInfo(AbstractModel):
    """色彩增强控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 色彩增强控制开关，可选值：
<li>ON：开启综合增强；</li>
<li>OFF：关闭综合增强。</li>
        :type Switch: str
        :param _Type: 色彩增强类型，仅当色彩增强控制开关为 ON 时有效，可选值：
<li>weak：轻色彩增强；</li>
<li>normal：正常色彩增强；</li>
<li>strong：强色彩增强。</li>
默认值：weak。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        """色彩增强控制开关，可选值：
<li>ON：开启综合增强；</li>
<li>OFF：关闭综合增强。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        """色彩增强类型，仅当色彩增强控制开关为 ON 时有效，可选值：
<li>weak：轻色彩增强；</li>
<li>normal：正常色彩增强；</li>
<li>strong：强色彩增强。</li>
默认值：weak。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitUploadRequest(AbstractModel):
    """CommitUpload请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VodSessionKey: 点播会话，取申请上传接口的返回值 VodSessionKey。
        :type VodSessionKey: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._VodSessionKey = None
        self._SubAppId = None

    @property
    def VodSessionKey(self):
        """点播会话，取申请上传接口的返回值 VodSessionKey。
        :rtype: str
        """
        return self._VodSessionKey

    @VodSessionKey.setter
    def VodSessionKey(self, VodSessionKey):
        self._VodSessionKey = VodSessionKey

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._VodSessionKey = params.get("VodSessionKey")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitUploadResponse(AbstractModel):
    """CommitUpload返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件的唯一标识。
        :type FileId: str
        :param _MediaUrl: 媒体播放地址。
        :type MediaUrl: str
        :param _CoverUrl: 媒体封面地址。
        :type CoverUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FileId = None
        self._MediaUrl = None
        self._CoverUrl = None
        self._RequestId = None

    @property
    def FileId(self):
        """媒体文件的唯一标识。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def MediaUrl(self):
        """媒体播放地址。
        :rtype: str
        """
        return self._MediaUrl

    @MediaUrl.setter
    def MediaUrl(self, MediaUrl):
        self._MediaUrl = MediaUrl

    @property
    def CoverUrl(self):
        """媒体封面地址。
        :rtype: str
        """
        return self._CoverUrl

    @CoverUrl.setter
    def CoverUrl(self, CoverUrl):
        self._CoverUrl = CoverUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._MediaUrl = params.get("MediaUrl")
        self._CoverUrl = params.get("CoverUrl")
        self._RequestId = params.get("RequestId")


class ComplexAdaptiveDynamicStreamingTask(AbstractModel):
    """自适应码流任务信息。

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>

        :type Status: str
        :param _ComplexAdaptiveDynamicStreamingTaskResultSet: 自适应码流任务的执行状态与结果，每个元素对应一个自适应码流模版。
        :type ComplexAdaptiveDynamicStreamingTaskResultSet: list of ComplexAdaptiveDynamicStreamingTaskResult
        """
        self._TaskId = None
        self._Status = None
        self._ComplexAdaptiveDynamicStreamingTaskResultSet = None

    @property
    def TaskId(self):
        """任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        """任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>

        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ComplexAdaptiveDynamicStreamingTaskResultSet(self):
        """自适应码流任务的执行状态与结果，每个元素对应一个自适应码流模版。
        :rtype: list of ComplexAdaptiveDynamicStreamingTaskResult
        """
        return self._ComplexAdaptiveDynamicStreamingTaskResultSet

    @ComplexAdaptiveDynamicStreamingTaskResultSet.setter
    def ComplexAdaptiveDynamicStreamingTaskResultSet(self, ComplexAdaptiveDynamicStreamingTaskResultSet):
        self._ComplexAdaptiveDynamicStreamingTaskResultSet = ComplexAdaptiveDynamicStreamingTaskResultSet


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        if params.get("ComplexAdaptiveDynamicStreamingTaskResultSet") is not None:
            self._ComplexAdaptiveDynamicStreamingTaskResultSet = []
            for item in params.get("ComplexAdaptiveDynamicStreamingTaskResultSet"):
                obj = ComplexAdaptiveDynamicStreamingTaskResult()
                obj._deserialize(item)
                self._ComplexAdaptiveDynamicStreamingTaskResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskAudioInput(AbstractModel):
    """自适应码流任务多语言音频流输入参数。

    """

    def __init__(self):
        r"""
        :param _FileId: 音频源的媒体 ID。固定取该媒体中的首个音频流，视频流和其它音频流（如有）将被忽略。
        :type FileId: str
        :param _Name: 输出的自适应码流中的音频流名称，长度限制为16个字符。
        :type Name: str
        :param _Language: 输出的自适应码流中的音频流语言，长度限制为16个字符。要求符合 RFC5646 规范。
        :type Language: str
        :param _Default: 是否设置为自适应码流的默认音频。取值：
<li>YES：设置为默认音频；</li>
<li>NO：不设置为默认音频（默认值）。</li>

        :type Default: str
        """
        self._FileId = None
        self._Name = None
        self._Language = None
        self._Default = None

    @property
    def FileId(self):
        """音频源的媒体 ID。固定取该媒体中的首个音频流，视频流和其它音频流（如有）将被忽略。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Name(self):
        """输出的自适应码流中的音频流名称，长度限制为16个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Language(self):
        """输出的自适应码流中的音频流语言，长度限制为16个字符。要求符合 RFC5646 规范。
        :rtype: str
        """
        return self._Language

    @Language.setter
    def Language(self, Language):
        self._Language = Language

    @property
    def Default(self):
        """是否设置为自适应码流的默认音频。取值：
<li>YES：设置为默认音频；</li>
<li>NO：不设置为默认音频（默认值）。</li>

        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._Name = params.get("Name")
        self._Language = params.get("Language")
        self._Default = params.get("Default")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskInput(AbstractModel):
    """自适应码流任务的输入参数。

    """

    def __init__(self):
        r"""
        :param _StreamPara: 自适应码流参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type StreamPara: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskStreamPara`
        """
        self._StreamPara = None

    @property
    def StreamPara(self):
        """自适应码流参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskStreamPara`
        """
        return self._StreamPara

    @StreamPara.setter
    def StreamPara(self, StreamPara):
        self._StreamPara = StreamPara


    def _deserialize(self, params):
        if params.get("StreamPara") is not None:
            self._StreamPara = ComplexAdaptiveDynamicStreamingTaskStreamPara()
            self._StreamPara._deserialize(params.get("StreamPara"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskOutput(AbstractModel):
    """自适应码流任务的输出结果。

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应码流模版 ID。
        :type Definition: int
        :param _Format: 自适应码流打包格式。可选值：
<li>HLS；</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _DrmType: DRM 方案类型。可选值：
<li>空字符串：无加密；</li>
<li>SimpleAES；</li>
<li>Widevine；</li>
<li>FairPlay。</li>
        :type DrmType: str
        :param _Url: 自适应码流的播放地址。
        :type Url: str
        """
        self._Definition = None
        self._Format = None
        self._DrmType = None
        self._Url = None

    @property
    def Definition(self):
        """自适应码流模版 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Format(self):
        """自适应码流打包格式。可选值：
<li>HLS；</li>
<li>MPEG-DASH。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def DrmType(self):
        """DRM 方案类型。可选值：
<li>空字符串：无加密；</li>
<li>SimpleAES；</li>
<li>Widevine；</li>
<li>FairPlay。</li>
        :rtype: str
        """
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def Url(self):
        """自适应码流的播放地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Format = params.get("Format")
        self._DrmType = params.get("DrmType")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskResult(AbstractModel):
    """自适应码流任务信息。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>SUCCESS：已完成；</li>
<li>FAIL：失败。</li>
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _Message: 错误信息。
        :type Message: str
        :param _Progress: 转码进度，取值范围 [0-100] 。
        :type Progress: int
        :param _Input: 自适应码流任务的输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskInput`
        :param _Output: 自适应码流任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._Message = None
        self._Progress = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        """任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>SUCCESS：已完成；</li>
<li>FAIL：失败。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        """转码进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Input(self):
        """自适应码流任务的输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """自适应码流任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        if params.get("Input") is not None:
            self._Input = ComplexAdaptiveDynamicStreamingTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = ComplexAdaptiveDynamicStreamingTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskStreamPara(AbstractModel):
    """自适应码流任务的流参数。

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应码流模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        """自适应码流模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskSubtitleInput(AbstractModel):
    """自适应码流任务多语言字幕的输入参数。

    """

    def __init__(self):
        r"""
        :param _Id: 字幕 ID。该字幕必须归属于自适应码流任务的输入主媒体。
        :type Id: str
        :param _Default: 是否设置为自适应码流的默认字幕。取值：
<li>YES：设置为默认字幕；</li>
<li>NO：不设置为默认字幕（默认值）。</li>
        :type Default: str
        """
        self._Id = None
        self._Default = None

    @property
    def Id(self):
        """字幕 ID。该字幕必须归属于自适应码流任务的输入主媒体。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Default(self):
        """是否设置为自适应码流的默认字幕。取值：
<li>YES：设置为默认字幕；</li>
<li>NO：不设置为默认字幕（默认值）。</li>
        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Default = params.get("Default")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaOutput(AbstractModel):
    """输出的媒体文件信息。

    """

    def __init__(self):
        r"""
        :param _FileName: 文件名称，最长 64 个字符。
        :type FileName: str
        :param _Description: 描述信息，最长 128 个字符。
        :type Description: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        :param _Container: 封装格式，可选值：mp4、mp3。其中，mp3 为纯音频文件。
        :type Container: str
        :param _VideoStream: 输出的视频信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type VideoStream: :class:`tencentcloud.vod.v20180717.models.OutputVideoStream`
        :param _AudioStream: 输出的音频信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type AudioStream: :class:`tencentcloud.vod.v20180717.models.OutputAudioStream`
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveAudio: int
        """
        self._FileName = None
        self._Description = None
        self._ClassId = None
        self._ExpireTime = None
        self._Container = None
        self._VideoStream = None
        self._AudioStream = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def FileName(self):
        """文件名称，最长 64 个字符。
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def Description(self):
        """描述信息，最长 128 个字符。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ClassId(self):
        """分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        """输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Container(self):
        """封装格式，可选值：mp4、mp3。其中，mp3 为纯音频文件。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def VideoStream(self):
        """输出的视频信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OutputVideoStream`
        """
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def AudioStream(self):
        """输出的音频信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OutputAudioStream`
        """
        return self._AudioStream

    @AudioStream.setter
    def AudioStream(self, AudioStream):
        self._AudioStream = AudioStream

    @property
    def RemoveVideo(self):
        """是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        """是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._FileName = params.get("FileName")
        self._Description = params.get("Description")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        self._Container = params.get("Container")
        if params.get("VideoStream") is not None:
            self._VideoStream = OutputVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("AudioStream") is not None:
            self._AudioStream = OutputAudioStream()
            self._AudioStream._deserialize(params.get("AudioStream"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaRequest(AbstractModel):
    """ComposeMedia请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Tracks: 输入的媒体轨道列表，包括视频、音频、图片等素材组成的多个轨道信息，其中：<li>输入的多个轨道在时间轴上和输出媒体文件的时间轴对齐；</li><li>时间轴上相同时间点的各个轨道的素材进行重叠，视频或者图片按轨道顺序进行图像的叠加，轨道顺序高的素材叠加在上面，音频素材进行混音；</li><li>视频、音频、图片，每一种类型的轨道最多支持 10 个。</li><li>所有类型的轨道上放置的媒体片段数量总和最多支持 500 个。</li>
        :type Tracks: list of MediaTrack
        :param _Output: 输出的媒体文件信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Canvas: 制作视频文件时使用的画布。
        :type Canvas: :class:`tencentcloud.vod.v20180717.models.Canvas`
        :param _SessionContext: 标识来源上下文，用于透传用户请求信息，在ComposeMediaComplete回调将返回该字段值，最长 1000个字符。
        :type SessionContext: str
        :param _SessionId: 用于任务去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        """
        self._Tracks = None
        self._Output = None
        self._SubAppId = None
        self._Canvas = None
        self._SessionContext = None
        self._SessionId = None

    @property
    def Tracks(self):
        """输入的媒体轨道列表，包括视频、音频、图片等素材组成的多个轨道信息，其中：<li>输入的多个轨道在时间轴上和输出媒体文件的时间轴对齐；</li><li>时间轴上相同时间点的各个轨道的素材进行重叠，视频或者图片按轨道顺序进行图像的叠加，轨道顺序高的素材叠加在上面，音频素材进行混音；</li><li>视频、音频、图片，每一种类型的轨道最多支持 10 个。</li><li>所有类型的轨道上放置的媒体片段数量总和最多支持 500 个。</li>
        :rtype: list of MediaTrack
        """
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks

    @property
    def Output(self):
        """输出的媒体文件信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Canvas(self):
        """制作视频文件时使用的画布。
        :rtype: :class:`tencentcloud.vod.v20180717.models.Canvas`
        """
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def SessionContext(self):
        """标识来源上下文，用于透传用户请求信息，在ComposeMediaComplete回调将返回该字段值，最长 1000个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def SessionId(self):
        """用于任务去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = MediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        if params.get("Output") is not None:
            self._Output = ComposeMediaOutput()
            self._Output._deserialize(params.get("Output"))
        self._SubAppId = params.get("SubAppId")
        if params.get("Canvas") is not None:
            self._Canvas = Canvas()
            self._Canvas._deserialize(params.get("Canvas"))
        self._SessionContext = params.get("SessionContext")
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaResponse(AbstractModel):
    """ComposeMedia返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 制作媒体文件的任务 ID，可以通过该 ID 查询制作任务（任务类型为 MakeMedia）的状态。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """制作媒体文件的任务 ID，可以通过该 ID 查询制作任务（任务类型为 MakeMedia）的状态。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ComposeMediaTask(AbstractModel):
    """制作媒体文件任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务流状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :type Status: str
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Progress: 制作媒体文件任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _Input: 制作媒体文件任务的输入。
注意：此字段可能返回 null，表示取不到有效值。
        :type Input: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskInput`
        :param _Output: 制作媒体文件任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskOutput`
        :param _MetaData: 输出视频的元信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type MetaData: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Progress = None
        self._Input = None
        self._Output = None
        self._MetaData = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        """任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        """任务流状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        """错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        """制作媒体文件任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Input(self):
        """制作媒体文件任务的输入。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        """制作媒体文件任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def MetaData(self):
        """输出视频的元信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        """
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def SessionId(self):
        """用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        """来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        if params.get("Input") is not None:
            self._Input = ComposeMediaTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = ComposeMediaTaskOutput()
            self._Output._deserialize(params.get("Output"))
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTaskInput(AbstractModel):
    """制作媒体文件任务的输入。

    """

    def __init__(self):
        r"""
        :param _Tracks: 输入的媒体轨道列表，包括视频、音频、图片等素材组成的多个轨道信息。
        :type Tracks: list of MediaTrack
        :param _Canvas: 制作视频文件时使用的画布。
注意：此字段可能返回 null，表示取不到有效值。
        :type Canvas: :class:`tencentcloud.vod.v20180717.models.Canvas`
        :param _Output: 输出的媒体文件信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        """
        self._Tracks = None
        self._Canvas = None
        self._Output = None

    @property
    def Tracks(self):
        """输入的媒体轨道列表，包括视频、音频、图片等素材组成的多个轨道信息。
        :rtype: list of MediaTrack
        """
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks

    @property
    def Canvas(self):
        """制作视频文件时使用的画布。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.Canvas`
        """
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def Output(self):
        """输出的媒体文件信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = MediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        if params.get("Canvas") is not None:
            self._Canvas = Canvas()
            self._Canvas._deserialize(params.get("Canvas"))
        if params.get("Output") is not None:
            self._Output = ComposeMediaOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTaskOutput(AbstractModel):
    """制作媒体文件任务的输出。

    """

    def __init__(self):
        r"""
        :param _FileType: 文件类型，例如 mp4、mp3 等。
        :type FileType: str
        :param _FileId: 媒体文件 ID。
        :type FileId: str
        :param _FileUrl: 媒体文件播放地址。
        :type FileUrl: str
        :param _MediaName: 文件名称，最长 64 个字符。
        :type MediaName: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        """
        self._FileType = None
        self._FileId = None
        self._FileUrl = None
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None

    @property
    def FileType(self):
        """文件类型，例如 mp4、mp3 等。
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FileId(self):
        """媒体文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        """媒体文件播放地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def MediaName(self):
        """文件名称，最长 64 个字符。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        """分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        """输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._FileType = params.get("FileType")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConcatFileInfo2017(AbstractModel):
    """视频拼接源文件信息（2017 版）

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _FileId: 视频拼接源文件的 ID。
        :type FileId: str
        :param _FileUrl: 视频拼接源文件的地址。
        :type FileUrl: str
        :param _FileType: 视频拼接源文件的格式。
        :type FileType: str
        """
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._FileUrl = None
        self._FileType = None

    @property
    def ErrCode(self):
        """错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        """视频拼接源文件的 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        """视频拼接源文件的地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileType(self):
        """视频拼接源文件的格式。
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._FileType = params.get("FileType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConcatTask2017(AbstractModel):
    """视频拼接任务信息，该结构仅用于对 2017 版[视频拼接](https://cloud.tencent.com/document/product/266/7821)接口发起的任务。

    """

    def __init__(self):
        r"""
        :param _TaskId: 视频拼接任务 ID。
        :type TaskId: str
        :param _FileInfoSet: 视频拼接源文件信息。
        :type FileInfoSet: list of ConcatFileInfo2017
        """
        self._TaskId = None
        self._FileInfoSet = None

    @property
    def TaskId(self):
        """视频拼接任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def FileInfoSet(self):
        """视频拼接源文件信息。
        :rtype: list of ConcatFileInfo2017
        """
        return self._FileInfoSet

    @FileInfoSet.setter
    def FileInfoSet(self, FileInfoSet):
        self._FileInfoSet = FileInfoSet


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        if params.get("FileInfoSet") is not None:
            self._FileInfoSet = []
            for item in params.get("FileInfoSet"):
                obj = ConcatFileInfo2017()
                obj._deserialize(item)
                self._FileInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmEventsRequest(AbstractModel):
    """ConfirmEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventHandles: 事件句柄，即 [拉取事件通知](/document/product/266/33433) 接口输出参数中的 EventSet. EventHandle 字段。
数组长度限制：16。
        :type EventHandles: list of str
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._EventHandles = None
        self._ExtInfo = None
        self._SubAppId = None

    @property
    def EventHandles(self):
        """事件句柄，即 [拉取事件通知](/document/product/266/33433) 接口输出参数中的 EventSet. EventHandle 字段。
数组长度限制：16。
        :rtype: list of str
        """
        return self._EventHandles

    @EventHandles.setter
    def EventHandles(self, EventHandles):
        self._EventHandles = EventHandles

    @property
    def ExtInfo(self):
        """保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._EventHandles = params.get("EventHandles")
        self._ExtInfo = params.get("ExtInfo")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmEventsResponse(AbstractModel):
    """ConfirmEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ContentReviewOcrResult(AbstractModel):
    """图片Ocr 文字鉴别信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字鉴别结果的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字鉴别的结果建议，取值范围：
<li>pass；</li>
<li>review；</li>
<li>block。</li>
        :type Suggestion: str
        :param _KeywordSet: Ocr 文字鉴别的嫌疑关键词列表。
        :type KeywordSet: list of str
        :param _AreaCoordSet: Ocr 文字鉴别的嫌疑文字出现的区域坐标 (像素级)，[x1, y1, x2, y2]，即左上角坐标、右下角坐标。
        :type AreaCoordSet: list of int
        """
        self._Confidence = None
        self._Suggestion = None
        self._KeywordSet = None
        self._AreaCoordSet = None

    @property
    def Confidence(self):
        """Ocr 文字鉴别结果的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        """Ocr 文字鉴别的结果建议，取值范围：
<li>pass；</li>
<li>review；</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def KeywordSet(self):
        """Ocr 文字鉴别的嫌疑关键词列表。
        :rtype: list of str
        """
        return self._KeywordSet

    @KeywordSet.setter
    def KeywordSet(self, KeywordSet):
        self._KeywordSet = KeywordSet

    @property
    def AreaCoordSet(self):
        """Ocr 文字鉴别的嫌疑文字出现的区域坐标 (像素级)，[x1, y1, x2, y2]，即左上角坐标、右下角坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._KeywordSet = params.get("KeywordSet")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewResult(AbstractModel):
    """图片智能内容识别任务结果

    """

    def __init__(self):
        r"""
        :param _Type: 结果类型，取值范围：
<li>Porn.Image：图片画面中的鉴别令人反感的信息结果；</li>
<li>Terrorism.Image：图片画面中的鉴别令人不安全的信息结果；</li>
<li>Political.Image：图片画面中的鉴别令人不适宜信息结果；</li>
<li>Porn.Ocr：图片 OCR 文字中的鉴别令人反感的信息结果；</li>
<li>Terrorism.Ocr：图片 OCR 文字中的鉴别令人不安全的信息结果；</li>
<li>Political.Ocr：图片 OCR 文字中的鉴别令人不适宜信息结果。</li>
        :type Type: str
        :param _PornImageResult: 图片画面中的鉴别令人反感的信息结果，当 Type 为 Porn.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornImageResult: :class:`tencentcloud.vod.v20180717.models.PornImageResult`
        :param _TerrorismImageResult: 图片画面中的鉴别令人不安全的信息结果，当 Type 为 Terrorism.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismImageResult: :class:`tencentcloud.vod.v20180717.models.TerrorismImageResult`
        :param _PoliticalImageResult: 图片画面中的鉴别令人不适宜信息结果，当 Type 为 Political.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalImageResult: :class:`tencentcloud.vod.v20180717.models.PoliticalImageResult`
        :param _PornOcrResult: 图片 OCR 文字中的鉴别令人反感的信息结果，当 Type 为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        :param _TerrorismOcrResult: 图片 OCR 中的鉴别令人不安全的信息结果，当 Type 为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        :param _PoliticalOcrResult: 图片 OCR 文字中的鉴别令人不适宜信息结果，当 Type 为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        self._Type = None
        self._PornImageResult = None
        self._TerrorismImageResult = None
        self._PoliticalImageResult = None
        self._PornOcrResult = None
        self._TerrorismOcrResult = None
        self._PoliticalOcrResult = None

    @property
    def Type(self):
        """结果类型，取值范围：
<li>Porn.Image：图片画面中的鉴别令人反感的信息结果；</li>
<li>Terrorism.Image：图片画面中的鉴别令人不安全的信息结果；</li>
<li>Political.Image：图片画面中的鉴别令人不适宜信息结果；</li>
<li>Porn.Ocr：图片 OCR 文字中的鉴别令人反感的信息结果；</li>
<li>Terrorism.Ocr：图片 OCR 文字中的鉴别令人不安全的信息结果；</li>
<li>Political.Ocr：图片 OCR 文字中的鉴别令人不适宜信息结果。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PornImageResult(self):
        """图片画面中的鉴别令人反感的信息结果，当 Type 为 Porn.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PornImageResult`
        """
        return self._PornImageResult

    @PornImageResult.setter
    def PornImageResult(self, PornImageResult):
        self._PornImageResult = PornImageResult

    @property
    def TerrorismImageResult(self):
        """图片画面中的鉴别令人不安全的信息结果，当 Type 为 Terrorism.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TerrorismImageResult`
        """
        return self._TerrorismImageResult

    @TerrorismImageResult.setter
    def TerrorismImageResult(self, TerrorismImageResult):
        self._TerrorismImageResult = TerrorismImageResult

    @property
    def PoliticalImageResult(self):
        """图片画面中的鉴别令人不适宜信息结果，当 Type 为 Political.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PoliticalImageResult`
        """
        return self._PoliticalImageResult

    @PoliticalImageResult.setter
    def PoliticalImageResult(self, PoliticalImageResult):
        self._PoliticalImageResult = PoliticalImageResult

    @property
    def PornOcrResult(self):
        """图片 OCR 文字中的鉴别令人反感的信息结果，当 Type 为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        return self._PornOcrResult

    @PornOcrResult.setter
    def PornOcrResult(self, PornOcrResult):
        self._PornOcrResult = PornOcrResult

    @property
    def TerrorismOcrResult(self):
        """图片 OCR 中的鉴别令人不安全的信息结果，当 Type 为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        return self._TerrorismOcrResult

    @TerrorismOcrResult.setter
    def TerrorismOcrResult(self, TerrorismOcrResult):
        self._TerrorismOcrResult = TerrorismOcrResult

    @property
    def PoliticalOcrResult(self):
        """图片 OCR 文字中的鉴别令人不适宜信息结果，当 Type 为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        return self._PoliticalOcrResult

    @PoliticalOcrResult.setter
    def PoliticalOcrResult(self, PoliticalOcrResult):
        self._PoliticalOcrResult = PoliticalOcrResult


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("PornImageResult") is not None:
            self._PornImageResult = PornImageResult()
            self._PornImageResult._deserialize(params.get("PornImageResult"))
        if params.get("TerrorismImageResult") is not None:
            self._TerrorismImageResult = TerrorismImageResult()
            self._TerrorismImageResult._deserialize(params.get("TerrorismImageResult"))
        if params.get("PoliticalImageResult") is not None:
            self._PoliticalImageResult = PoliticalImageResult()
            self._PoliticalImageResult._deserialize(params.get("PoliticalImageResult"))
        if params.get("PornOcrResult") is not None:
            self._PornOcrResult = ContentReviewOcrResult()
            self._PornOcrResult._deserialize(params.get("PornOcrResult"))
        if params.get("TerrorismOcrResult") is not None:
            self._TerrorismOcrResult = ContentReviewOcrResult()
            self._TerrorismOcrResult._deserialize(params.get("TerrorismOcrResult"))
        if params.get("PoliticalOcrResult") is not None:
            self._PoliticalOcrResult = ContentReviewOcrResult()
            self._PoliticalOcrResult._deserialize(params.get("PoliticalOcrResult"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewTemplateItem(AbstractModel):
    """音视频审核模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频审核模板唯一标识。
        :type Definition: int
        :param _Name: 音视频审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 音视频审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 鉴别涉及令人反感的信息的控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornConfigure: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        :param _TerrorismConfigure: 鉴别涉及令人不安全的信息的控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismConfigure: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: 鉴别涉及令人不适宜的信息的控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalConfigure: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedConfigure: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: 用户自定义音视频审核控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type UserDefineConfigure: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        :param _ReviewWallSwitch: 音视频审核结果是否进入音视频审核墙（对音视频审核结果进行人工复核）的开关。
<li>ON：是；</li>
<li>OFF：否。</li>
        :type ReviewWallSwitch: str
        :param _ScreenshotInterval: 截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :type ScreenshotInterval: float
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._ReviewWallSwitch = None
        self._ScreenshotInterval = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        """音视频审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        """音视频审核模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """音视频审核模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        """鉴别涉及令人反感的信息的控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        """
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        """鉴别涉及令人不安全的信息的控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        """
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        """鉴别涉及令人不适宜的信息的控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        """
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        """违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        """
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        """用户自定义音视频审核控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        """
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def ReviewWallSwitch(self):
        """音视频审核结果是否进入音视频审核墙（对音视频审核结果进行人工复核）的开关。
<li>ON：是；</li>
<li>OFF：否。</li>
        :rtype: str
        """
        return self._ReviewWallSwitch

    @ReviewWallSwitch.setter
    def ReviewWallSwitch(self, ReviewWallSwitch):
        self._ReviewWallSwitch = ReviewWallSwitch

    @property
    def ScreenshotInterval(self):
        """截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def CreateTime(self):
        """模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._ReviewWallSwitch = params.get("ReviewWallSwitch")
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyRightWatermarkInput(AbstractModel):
    """版权水印参数

    """

    def __init__(self):
        r"""
        :param _Text: 版权信息，最大长度为 200 个字符。
        :type Text: str
        """
        self._Text = None

    @property
    def Text(self):
        """版权信息，最大长度为 200 个字符。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverBySnapshotTaskInput(AbstractModel):
    """对视频截图做封面任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 指定时间点截图模板 ID。
        :type Definition: int
        :param _PositionType: 截图方式。包含：
<li>Time：依照时间点截图</li>
<li>Percent：依照百分比截图</li>
        :type PositionType: str
        :param _PositionValue: 截图位置：
<li>对于依照时间点截图，该值表示指定视频第几秒的截图作为封面</li>
<li>对于依照百分比截图，该值表示使用视频百分之多少的截图作为封面</li>
        :type PositionValue: float
        :param _WatermarkSet: 水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :type WatermarkSet: list of WatermarkInput
        """
        self._Definition = None
        self._PositionType = None
        self._PositionValue = None
        self._WatermarkSet = None

    @property
    def Definition(self):
        """指定时间点截图模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def PositionType(self):
        """截图方式。包含：
<li>Time：依照时间点截图</li>
<li>Percent：依照百分比截图</li>
        :rtype: str
        """
        return self._PositionType

    @PositionType.setter
    def PositionType(self, PositionType):
        self._PositionType = PositionType

    @property
    def PositionValue(self):
        """截图位置：
<li>对于依照时间点截图，该值表示指定视频第几秒的截图作为封面</li>
<li>对于依照百分比截图，该值表示使用视频百分之多少的截图作为封面</li>
        :rtype: float
        """
        return self._PositionValue

    @PositionValue.setter
    def PositionValue(self, PositionValue):
        self._PositionValue = PositionValue

    @property
    def WatermarkSet(self):
        """水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :rtype: list of WatermarkInput
        """
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._PositionType = params.get("PositionType")
        self._PositionValue = params.get("PositionValue")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverBySnapshotTaskOutput(AbstractModel):
    """对视频截图做封面任务输出类型

    """

    def __init__(self):
        r"""
        :param _CoverUrl: 封面 URL。
        :type CoverUrl: str
        """
        self._CoverUrl = None

    @property
    def CoverUrl(self):
        """封面 URL。
        :rtype: str
        """
        return self._CoverUrl

    @CoverUrl.setter
    def CoverUrl(self, CoverUrl):
        self._CoverUrl = CoverUrl


    def _deserialize(self, params):
        self._CoverUrl = params.get("CoverUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfo(AbstractModel):
    """智能封面任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfoForUpdate(AbstractModel):
    """智能封面任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CrashScreenConfigureInfo(AbstractModel):
    """视频画面花屏检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面花屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """视频画面花屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CrashScreenConfigureInfoForUpdate(AbstractModel):
    """视频画面花屏检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面花屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        """视频画面花屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateRequest(AbstractModel):
    """CreateAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音视频内容分析模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 音视频内容分析模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
        :type ClassificationConfigure: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        :param _TagConfigure: 智能标签任务控制参数。
        :type TagConfigure: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        :param _CoverConfigure: 智能封面任务控制参数。
        :type CoverConfigure: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
        :type FrameTagConfigure: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        :param _HighlightConfigure: 智能精彩集锦任务控制参数。
        :type HighlightConfigure: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._HighlightConfigure = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """音视频内容分析模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """音视频内容分析模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        """智能分类任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        """
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        """智能标签任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        """
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        """智能封面任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        """
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        """智能按帧标签任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        """
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def HighlightConfigure(self):
        """智能精彩集锦任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        """
        return self._HighlightConfigure

    @HighlightConfigure.setter
    def HighlightConfigure(self, HighlightConfigure):
        self._HighlightConfigure = HighlightConfigure


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        if params.get("HighlightConfigure") is not None:
            self._HighlightConfigure = HighlightsConfigureInfo()
            self._HighlightConfigure._deserialize(params.get("HighlightConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateResponse(AbstractModel):
    """CreateAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容分析模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """音视频内容分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAIRecognitionTemplateRequest(AbstractModel):
    """CreateAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音视频内容识别模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 音视频内容识别模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _HeadTailConfigure: 视频片头片尾识别控制参数。
        :type HeadTailConfigure: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        :param _SegmentConfigure: 视频拆条识别控制参数。
        :type SegmentConfigure: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        :param _FaceConfigure: 人脸识别控制参数。
        :type FaceConfigure: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
        :type OcrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
        :type OcrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
        :type AsrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
        :type AsrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        :param _AsrTranslateConfigure: 语音翻译控制参数。
        :type AsrTranslateConfigure: :class:`tencentcloud.vod.v20180717.models.AsrTranslateConfigureInfo`
        :param _ObjectConfigure: 物体识别控制参数。
        :type ObjectConfigure: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        :param _ScreenshotInterval: 截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :type ScreenshotInterval: float
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._HeadTailConfigure = None
        self._SegmentConfigure = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._AsrTranslateConfigure = None
        self._ObjectConfigure = None
        self._ScreenshotInterval = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """音视频内容识别模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """音视频内容识别模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def HeadTailConfigure(self):
        """视频片头片尾识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        """
        return self._HeadTailConfigure

    @HeadTailConfigure.setter
    def HeadTailConfigure(self, HeadTailConfigure):
        self._HeadTailConfigure = HeadTailConfigure

    @property
    def SegmentConfigure(self):
        """视频拆条识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        """
        return self._SegmentConfigure

    @SegmentConfigure.setter
    def SegmentConfigure(self, SegmentConfigure):
        self._SegmentConfigure = SegmentConfigure

    @property
    def FaceConfigure(self):
        """人脸识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        """
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        """文本全文识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        """
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        """文本关键词识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        """
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        """语音全文识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        """
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        """语音关键词识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        """
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def AsrTranslateConfigure(self):
        """语音翻译控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrTranslateConfigureInfo`
        """
        return self._AsrTranslateConfigure

    @AsrTranslateConfigure.setter
    def AsrTranslateConfigure(self, AsrTranslateConfigure):
        self._AsrTranslateConfigure = AsrTranslateConfigure

    @property
    def ObjectConfigure(self):
        """物体识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        """
        return self._ObjectConfigure

    @ObjectConfigure.setter
    def ObjectConfigure(self, ObjectConfigure):
        self._ObjectConfigure = ObjectConfigure

    @property
    def ScreenshotInterval(self):
        """截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("HeadTailConfigure") is not None:
            self._HeadTailConfigure = HeadTailConfigureInfo()
            self._HeadTailConfigure._deserialize(params.get("HeadTailConfigure"))
        if params.get("SegmentConfigure") is not None:
            self._SegmentConfigure = SegmentConfigureInfo()
            self._SegmentConfigure._deserialize(params.get("SegmentConfigure"))
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("AsrTranslateConfigure") is not None:
            self._AsrTranslateConfigure = AsrTranslateConfigureInfo()
            self._AsrTranslateConfigure._deserialize(params.get("AsrTranslateConfigure"))
        if params.get("ObjectConfigure") is not None:
            self._ObjectConfigure = ObjectConfigureInfo()
            self._ObjectConfigure._deserialize(params.get("ObjectConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIRecognitionTemplateResponse(AbstractModel):
    """CreateAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容识别模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """音视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """CreateAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Format: 自适应转码格式，取值范围：
<li>HLS；</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _StreamInfos: 自适应转码输出子流参数信息，最多输出10路子流。
注意：各个子流的帧率必须保持一致；如果不一致，采用第一个子流的帧率作为输出帧率。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 模板名称，长度限制：64 个字符。
        :type Name: str
        :param _DrmType: DRM 方案类型，取值范围：
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
默认值为空字符串，如果取值为空字符串，代表不对视频做 DRM 保护。
        :type DrmType: str
        :param _DrmKeyProvider: DRM 的密钥提供商，取值范围：
<li>SDMC：华曦达；</li>
<li>VOD：云点播。</li>
默认为 VOD 。
        :type DrmKeyProvider: str
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :type DisableHigherVideoResolution: int
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _SegmentType: 切片类型，当 Format 为 HLS 时有效，可选值：
<li>ts：ts 切片；</li>
<li>fmp4：fmp4 切片。</li>
默认值：ts。
        :type SegmentType: str
        """
        self._Format = None
        self._StreamInfos = None
        self._SubAppId = None
        self._Name = None
        self._DrmType = None
        self._DrmKeyProvider = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._Comment = None
        self._SegmentType = None

    @property
    def Format(self):
        """自适应转码格式，取值范围：
<li>HLS；</li>
<li>MPEG-DASH。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        """自适应转码输出子流参数信息，最多输出10路子流。
注意：各个子流的帧率必须保持一致；如果不一致，采用第一个子流的帧率作为输出帧率。
        :rtype: list of AdaptiveStreamTemplate
        """
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DrmType(self):
        """DRM 方案类型，取值范围：
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
默认值为空字符串，如果取值为空字符串，代表不对视频做 DRM 保护。
        :rtype: str
        """
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def DrmKeyProvider(self):
        """DRM 的密钥提供商，取值范围：
<li>SDMC：华曦达；</li>
<li>VOD：云点播。</li>
默认为 VOD 。
        :rtype: str
        """
        return self._DrmKeyProvider

    @DrmKeyProvider.setter
    def DrmKeyProvider(self, DrmKeyProvider):
        self._DrmKeyProvider = DrmKeyProvider

    @property
    def DisableHigherVideoBitrate(self):
        """是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :rtype: int
        """
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        """是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :rtype: int
        """
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def SegmentType(self):
        """切片类型，当 Format 为 HLS 时有效，可选值：
<li>ts：ts 切片；</li>
<li>fmp4：fmp4 切片。</li>
默认值：ts。
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._DrmType = params.get("DrmType")
        self._DrmKeyProvider = params.get("DrmKeyProvider")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._Comment = params.get("Comment")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """CreateAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应转码模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """自适应转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAnimatedGraphicsTemplateRequest(AbstractModel):
    """CreateAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Fps: 帧率，取值范围：[1, 30]，单位：Hz。
        :type Fps: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式，取值为 gif 和 webp。默认为 gif。
        :type Format: str
        :param _Quality: 图片质量，取值范围：[1, 100]，默认值为 75。
        :type Quality: float
        :param _Name: 转动图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Fps = None
        self._SubAppId = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Quality = None
        self._Name = None
        self._Comment = None

    @property
    def Fps(self):
        """帧率，取值范围：[1, 30]，单位：Hz。
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Width(self):
        """动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        """分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        """动图格式，取值为 gif 和 webp。默认为 gif。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Quality(self):
        """图片质量，取值范围：[1, 100]，默认值为 75。
        :rtype: float
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Name(self):
        """转动图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._SubAppId = params.get("SubAppId")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Quality = params.get("Quality")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnimatedGraphicsTemplateResponse(AbstractModel):
    """CreateAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateCLSLogsetRequest(AbstractModel):
    """CreateCLSLogset请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        """
        self._CLSRegion = None

    @property
    def CLSRegion(self):
        """日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCLSLogsetResponse(AbstractModel):
    """CreateCLSLogset返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LogsetId: 日志集 ID。
        :type LogsetId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LogsetId = None
        self._RequestId = None

    @property
    def LogsetId(self):
        """日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LogsetId = params.get("LogsetId")
        self._RequestId = params.get("RequestId")


class CreateCLSTopicRequest(AbstractModel):
    """CreateCLSTopic请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        :param _TopicName: 日志主题名。
        :type TopicName: str
        :param _LogsetId: 日志集 ID。
        :type LogsetId: str
        """
        self._CLSRegion = None
        self._TopicName = None
        self._LogsetId = None

    @property
    def CLSRegion(self):
        """日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def TopicName(self):
        """日志主题名。
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def LogsetId(self):
        """日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._TopicName = params.get("TopicName")
        self._LogsetId = params.get("LogsetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCLSTopicResponse(AbstractModel):
    """CreateCLSTopic返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TopicId: 日志主题 ID。
        :type TopicId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TopicId = None
        self._RequestId = None

    @property
    def TopicId(self):
        """日志主题 ID。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._RequestId = params.get("RequestId")


class CreateClassRequest(AbstractModel):
    """CreateClass请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ParentId: 父类 ID，一级分类填写 -1。
        :type ParentId: int
        :param _ClassName: 分类名称，长度限制：1-64 个字符。
        :type ClassName: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._ParentId = None
        self._ClassName = None
        self._SubAppId = None

    @property
    def ParentId(self):
        """父类 ID，一级分类填写 -1。
        :rtype: int
        """
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def ClassName(self):
        """分类名称，长度限制：1-64 个字符。
        :rtype: str
        """
        return self._ClassName

    @ClassName.setter
    def ClassName(self, ClassName):
        self._ClassName = ClassName

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._ParentId = params.get("ParentId")
        self._ClassName = params.get("ClassName")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClassResponse(AbstractModel):
    """CreateClass返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassId: 分类 ID
        :type ClassId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClassId = None
        self._RequestId = None

    @property
    def ClassId(self):
        """分类 ID
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClassId = params.get("ClassId")
        self._RequestId = params.get("RequestId")


class CreateComplexAdaptiveDynamicStreamingTaskRequest(AbstractModel):
    """CreateComplexAdaptiveDynamicStreamingTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。</b>
        :type SubAppId: int
        :param _FileId: 主媒体文件的媒体 ID。
        :type FileId: str
        :param _StreamParaSet: 自适应码流参数，最大支持8个。
        :type StreamParaSet: list of ComplexAdaptiveDynamicStreamingTaskStreamPara
        :param _HeadTailSet: 片头片尾列表，支持多片头片尾，最大可支持 4 个。如果填写了该字段，AudioSet 和 SubtitleSet 中指定的媒体的起始时间将会自动调整，和主媒体保持同步。
        :type HeadTailSet: list of HeadTailTaskInput
        :param _AudioSet: 多语言音频流参数，最大支持16个。每个数组元素对应自适应码流中的一条音频流。如果要将主媒体文件中的音频流添加到输出的自适应码流中，那么也需要在此处指定。数组中元素的顺序将决定自适应码流中的音频流顺序。如果输入的媒体文件同时带有视频流和音频流，那么视频流将被忽略。
        :type AudioSet: list of ComplexAdaptiveDynamicStreamingTaskAudioInput
        :param _SubtitleSet: 多语言字幕参数，最大可支持16个。每个数组元素对应自适应码流中的一条字幕流。数组中元素的顺序将决定自适应码流中的字幕流顺序。
        :type SubtitleSet: list of ComplexAdaptiveDynamicStreamingTaskSubtitleInput
        """
        self._SubAppId = None
        self._FileId = None
        self._StreamParaSet = None
        self._HeadTailSet = None
        self._AudioSet = None
        self._SubtitleSet = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def FileId(self):
        """主媒体文件的媒体 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StreamParaSet(self):
        """自适应码流参数，最大支持8个。
        :rtype: list of ComplexAdaptiveDynamicStreamingTaskStreamPara
        """
        return self._StreamParaSet

    @StreamParaSet.setter
    def StreamParaSet(self, StreamParaSet):
        self._StreamParaSet = StreamParaSet

    @property
    def HeadTailSet(self):
        """片头片尾列表，支持多片头片尾，最大可支持 4 个。如果填写了该字段，AudioSet 和 SubtitleSet 中指定的媒体的起始时间将会自动调整，和主媒体保持同步。
        :rtype: list of HeadTailTaskInput
        """
        return self._HeadTailSet

    @HeadTailSet.setter
    def HeadTailSet(self, HeadTailSet):
        self._HeadTailSet = HeadTailSet

    @property
    def AudioSet(self):
        """多语言音频流参数，最大支持16个。每个数组元素对应自适应码流中的一条音频流。如果要将主媒体文件中的音频流添加到输出的自适应码流中，那么也需要在此处指定。数组中元素的顺序将决定自适应码流中的音频流顺序。如果输入的媒体文件同时带有视频流和音频流，那么视频流将被忽略。
        :rtype: list of ComplexAdaptiveDynamicStreamingTaskAudioInput
        """
        return self._AudioSet

    @AudioSet.setter
    def AudioSet(self, AudioSet):
        self._AudioSet = AudioSet

    @property
    def SubtitleSet(self):
        """多语言字幕参数，最大可支持16个。每个数组元素对应自适应码流中的一条字幕流。数组中元素的顺序将决定自适应码流中的字幕流顺序。
        :rtype: list of ComplexAdaptiveDynamicStreamingTaskSubtitleInput
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._FileId = params.get("FileId")
        if params.get("StreamParaSet") is not None:
            self._StreamParaSet = []
            for item in params.get("StreamParaSet"):
                obj = ComplexAdaptiveDynamicStreamingTaskStreamPara()
                obj._deserialize(item)
                self._StreamParaSet.append(obj)
        if params.get("HeadTailSet") is not None:
            self._HeadTailSet = []
            for item in params.get("HeadTailSet"):
                obj = HeadTailTaskInput()
                obj._deserialize(item)
                self._HeadTailSet.append(obj)
        if params.get("AudioSet") is not None:
            self._AudioSet = []
            for item in params.get("AudioSet"):
                obj = ComplexAdaptiveDynamicStreamingTaskAudioInput()
                obj._deserialize(item)
                self._AudioSet.append(obj)
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = ComplexAdaptiveDynamicStreamingTaskSubtitleInput()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateComplexAdaptiveDynamicStreamingTaskResponse(AbstractModel):
    """CreateComplexAdaptiveDynamicStreamingTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateContentReviewTemplateRequest(AbstractModel):
    """CreateContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ReviewWallSwitch: 音视频审核结果是否进入音视频审核墙（对识别结果进行人工复核）的开关。
<li>ON：是；</li>
<li>OFF：否。</li>
        :type ReviewWallSwitch: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 内容审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 内容审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 令人反感的信息的控制参数。
        :type PornConfigure: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        :param _TerrorismConfigure: 令人不安全的信息的控制参数。
        :type TerrorismConfigure: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: 令人不适宜的控制参数。
        :type PoliticalConfigure: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
        :type ProhibitedConfigure: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: 用户自定义内容审核控制参数。
        :type UserDefineConfigure: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        :param _ScreenshotInterval: 截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :type ScreenshotInterval: float
        """
        self._ReviewWallSwitch = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._ScreenshotInterval = None

    @property
    def ReviewWallSwitch(self):
        """音视频审核结果是否进入音视频审核墙（对识别结果进行人工复核）的开关。
<li>ON：是；</li>
<li>OFF：否。</li>
        :rtype: str
        """
        return self._ReviewWallSwitch

    @ReviewWallSwitch.setter
    def ReviewWallSwitch(self, ReviewWallSwitch):
        self._ReviewWallSwitch = ReviewWallSwitch

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """内容审核模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """内容审核模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        """令人反感的信息的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        """
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        """令人不安全的信息的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        """
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        """令人不适宜的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        """
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        """违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
        :rtype: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        """
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        """用户自定义内容审核控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        """
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def ScreenshotInterval(self):
        """截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval


    def _deserialize(self, params):
        self._ReviewWallSwitch = params.get("ReviewWallSwitch")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContentReviewTemplateResponse(AbstractModel):
    """CreateContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容审核模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """音视频内容审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateDomainVerifyRecordRequest(AbstractModel):
    """CreateDomainVerifyRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要接入点播的加速域名。
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        """需要接入点播的加速域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDomainVerifyRecordResponse(AbstractModel):
    """CreateDomainVerifyRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DNSVerifyInfo: DNS解析信息
        :type DNSVerifyInfo: :class:`tencentcloud.vod.v20180717.models.DNSVerifyInfo`
        :param _FileVerifyInfo: 文件验证信息
        :type FileVerifyInfo: :class:`tencentcloud.vod.v20180717.models.FileVerifyInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DNSVerifyInfo = None
        self._FileVerifyInfo = None
        self._RequestId = None

    @property
    def DNSVerifyInfo(self):
        """DNS解析信息
        :rtype: :class:`tencentcloud.vod.v20180717.models.DNSVerifyInfo`
        """
        return self._DNSVerifyInfo

    @DNSVerifyInfo.setter
    def DNSVerifyInfo(self, DNSVerifyInfo):
        self._DNSVerifyInfo = DNSVerifyInfo

    @property
    def FileVerifyInfo(self):
        """文件验证信息
        :rtype: :class:`tencentcloud.vod.v20180717.models.FileVerifyInfo`
        """
        return self._FileVerifyInfo

    @FileVerifyInfo.setter
    def FileVerifyInfo(self, FileVerifyInfo):
        self._FileVerifyInfo = FileVerifyInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DNSVerifyInfo") is not None:
            self._DNSVerifyInfo = DNSVerifyInfo()
            self._DNSVerifyInfo._deserialize(params.get("DNSVerifyInfo"))
        if params.get("FileVerifyInfo") is not None:
            self._FileVerifyInfo = FileVerifyInfo()
            self._FileVerifyInfo._deserialize(params.get("FileVerifyInfo"))
        self._RequestId = params.get("RequestId")


class CreateEnhanceMediaTemplateRequest(AbstractModel):
    """CreateEnhanceMediaTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Container: 输出文件封装格式，可选值：mp4、flv、hls。
        :type Container: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音画质重生模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RebuildVideoInfo: 音画质重生视频控制控制信息。
        :type RebuildVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        :param _RebuildAudioInfo: 音画质重生音频控制控制信息。
        :type RebuildAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        :param _TargetVideoInfo: 输出目标视频控制信息。
        :type TargetVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        :param _TargetAudioInfo: 输出目标音频控制信息。
        :type TargetAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :type RemoveAudio: int
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RebuildVideoInfo = None
        self._RebuildAudioInfo = None
        self._TargetVideoInfo = None
        self._TargetAudioInfo = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def Container(self):
        """输出文件封装格式，可选值：mp4、flv、hls。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """音画质重生模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RebuildVideoInfo(self):
        """音画质重生视频控制控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        """
        return self._RebuildVideoInfo

    @RebuildVideoInfo.setter
    def RebuildVideoInfo(self, RebuildVideoInfo):
        self._RebuildVideoInfo = RebuildVideoInfo

    @property
    def RebuildAudioInfo(self):
        """音画质重生音频控制控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        """
        return self._RebuildAudioInfo

    @RebuildAudioInfo.setter
    def RebuildAudioInfo(self, RebuildAudioInfo):
        self._RebuildAudioInfo = RebuildAudioInfo

    @property
    def TargetVideoInfo(self):
        """输出目标视频控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        """
        return self._TargetVideoInfo

    @TargetVideoInfo.setter
    def TargetVideoInfo(self, TargetVideoInfo):
        self._TargetVideoInfo = TargetVideoInfo

    @property
    def TargetAudioInfo(self):
        """输出目标音频控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        """
        return self._TargetAudioInfo

    @TargetAudioInfo.setter
    def TargetAudioInfo(self, TargetAudioInfo):
        self._TargetAudioInfo = TargetAudioInfo

    @property
    def RemoveVideo(self):
        """是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        """是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("RebuildVideoInfo") is not None:
            self._RebuildVideoInfo = RebuildVideoInfo()
            self._RebuildVideoInfo._deserialize(params.get("RebuildVideoInfo"))
        if params.get("RebuildAudioInfo") is not None:
            self._RebuildAudioInfo = RebuildAudioInfo()
            self._RebuildAudioInfo._deserialize(params.get("RebuildAudioInfo"))
        if params.get("TargetVideoInfo") is not None:
            self._TargetVideoInfo = RebuildMediaTargetVideoStream()
            self._TargetVideoInfo._deserialize(params.get("TargetVideoInfo"))
        if params.get("TargetAudioInfo") is not None:
            self._TargetAudioInfo = RebuildMediaTargetAudioStream()
            self._TargetAudioInfo._deserialize(params.get("TargetAudioInfo"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEnhanceMediaTemplateResponse(AbstractModel):
    """CreateEnhanceMediaTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音画质重生模板 ID。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """音画质重生模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateHeadTailTemplateRequest(AbstractModel):
    """CreateHeadTailTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 模板名，长度限制 64 个字符。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Comment: 模板描述信息，长度限制 256 个字符。
        :type Comment: str
        :param _HeadCandidateSet: 片头候选列表，填写视频的 FileId。转码时将自动选择与正片宽高比最接近的一个片头（相同宽高比时，靠前的候选项优先）。最多支持 5 个候选片头。
        :type HeadCandidateSet: list of str
        :param _TailCandidateSet: 片尾候选列表，填写视频的 FileId。转码时将自动选择与正片宽高比最接近的一个片尾（相同宽高比时，靠前的候选项优先）。最多支持 5 个候选片尾。
        :type TailCandidateSet: list of str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li> gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊；</li>
<li> white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充；</li>
<li> black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：stretch 。
        :type FillType: str
        """
        self._Name = None
        self._SubAppId = None
        self._Comment = None
        self._HeadCandidateSet = None
        self._TailCandidateSet = None
        self._FillType = None

    @property
    def Name(self):
        """模板名，长度限制 64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Comment(self):
        """模板描述信息，长度限制 256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def HeadCandidateSet(self):
        """片头候选列表，填写视频的 FileId。转码时将自动选择与正片宽高比最接近的一个片头（相同宽高比时，靠前的候选项优先）。最多支持 5 个候选片头。
        :rtype: list of str
        """
        return self._HeadCandidateSet

    @HeadCandidateSet.setter
    def HeadCandidateSet(self, HeadCandidateSet):
        self._HeadCandidateSet = HeadCandidateSet

    @property
    def TailCandidateSet(self):
        """片尾候选列表，填写视频的 FileId。转码时将自动选择与正片宽高比最接近的一个片尾（相同宽高比时，靠前的候选项优先）。最多支持 5 个候选片尾。
        :rtype: list of str
        """
        return self._TailCandidateSet

    @TailCandidateSet.setter
    def TailCandidateSet(self, TailCandidateSet):
        self._TailCandidateSet = TailCandidateSet

    @property
    def FillType(self):
        """填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li> gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊；</li>
<li> white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充；</li>
<li> black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：stretch 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._Comment = params.get("Comment")
        self._HeadCandidateSet = params.get("HeadCandidateSet")
        self._TailCandidateSet = params.get("TailCandidateSet")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHeadTailTemplateResponse(AbstractModel):
    """CreateHeadTailTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 片头片尾模板号。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """片头片尾模板号。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageProcessingTemplateRequest(AbstractModel):
    """CreateImageProcessingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Operations: 图片处理操作数组，操作将以其在数组中的顺序执行。
<li>长度限制：10。</li>
        :type Operations: list of ImageOperation
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 图片处理模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Operations = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None

    @property
    def Operations(self):
        """图片处理操作数组，操作将以其在数组中的顺序执行。
<li>长度限制：10。</li>
        :rtype: list of ImageOperation
        """
        return self._Operations

    @Operations.setter
    def Operations(self, Operations):
        self._Operations = Operations

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """图片处理模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        if params.get("Operations") is not None:
            self._Operations = []
            for item in params.get("Operations"):
                obj = ImageOperation()
                obj._deserialize(item)
                self._Operations.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageProcessingTemplateResponse(AbstractModel):
    """CreateImageProcessingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 图片处理模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """图片处理模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageSpriteTask2017(AbstractModel):
    """视频截取雪碧图任务，该结构仅用于对 2017 版[截取雪碧图](https://cloud.tencent.com/document/product/266/8101)接口发起的任务。

    """

    def __init__(self):
        r"""
        :param _TaskId: 截图雪碧图任务 ID。
        :type TaskId: str
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _FileId: 截取雪碧图文件 ID。
        :type FileId: str
        :param _Definition: 雪碧图规格，参见[雪碧图截图模板](https://cloud.tencent.com/document/product/266/33480#.E9.9B.AA.E7.A2.A7.E5.9B.BE.E6.A8.A1.E6.9D.BF)。
        :type Definition: int
        :param _TotalCount: 雪碧图小图总数量。
        :type TotalCount: int
        :param _ImageSpriteUrlSet: 截取雪碧图输出的地址。
        :type ImageSpriteUrlSet: list of str
        :param _WebVttUrl: 雪碧图子图位置与时间关系 WebVtt 文件地址。
        :type WebVttUrl: str
        """
        self._TaskId = None
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._Definition = None
        self._TotalCount = None
        self._ImageSpriteUrlSet = None
        self._WebVttUrl = None

    @property
    def TaskId(self):
        """截图雪碧图任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ErrCode(self):
        """错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        """截取雪碧图文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Definition(self):
        """雪碧图规格，参见[雪碧图截图模板](https://cloud.tencent.com/document/product/266/33480#.E9.9B.AA.E7.A2.A7.E5.9B.BE.E6.A8.A1.E6.9D.BF)。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def TotalCount(self):
        """雪碧图小图总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteUrlSet(self):
        """截取雪碧图输出的地址。
        :rtype: list of str
        """
        return self._ImageSpriteUrlSet

    @ImageSpriteUrlSet.setter
    def ImageSpriteUrlSet(self, ImageSpriteUrlSet):
        self._ImageSpriteUrlSet = ImageSpriteUrlSet

    @property
    def WebVttUrl(self):
        """雪碧图子图位置与时间关系 WebVtt 文件地址。
        :rtype: str
        """
        return self._WebVttUrl

    @WebVttUrl.setter
    def WebVttUrl(self, WebVttUrl):
        self._WebVttUrl = WebVttUrl


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._Definition = params.get("Definition")
        self._TotalCount = params.get("TotalCount")
        self._ImageSpriteUrlSet = params.get("ImageSpriteUrlSet")
        self._WebVttUrl = params.get("WebVttUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateRequest(AbstractModel):
    """CreateImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleType: 采样类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _RowCount: 雪碧图中小图的行数。
注意：小图的行数会影响最终大图的高度，大图的高度最大为15000像素，其中大图的高度为小图行数与小图高度的乘积。
        :type RowCount: int
        :param _ColumnCount: 雪碧图中小图的列数。
注意：小图的列数会影响最终大图的宽度，大图的宽度最大为15000像素，其中大图的宽度为小图列数与小图宽度的乘积。
        :type ColumnCount: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 雪碧图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：black 。
        :type FillType: str
        :param _Width: 雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
注意：小图的宽度会影响最终大图的宽度，大图的宽度最大为15000像素，其中大图的宽度为小图列数与小图宽度的乘积。
        :type Width: int
        :param _Height: 雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
注意：小图的高度会影响最终大图的高度，大图的高度最大为15000像素，其中大图的高度为小图行数与小图高度的乘积。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值：
<li> jpg：jpg 格式；</li>
<li> png：png 格式；</li>
<li> webp：webp 格式。</li>
默认值：jpg。
        :type Format: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._FillType = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None

    @property
    def SampleType(self):
        """采样类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :rtype: str
        """
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        """采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :rtype: int
        """
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        """雪碧图中小图的行数。
注意：小图的行数会影响最终大图的高度，大图的高度最大为15000像素，其中大图的高度为小图行数与小图高度的乘积。
        :rtype: int
        """
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        """雪碧图中小图的列数。
注意：小图的列数会影响最终大图的宽度，大图的宽度最大为15000像素，其中大图的宽度为小图列数与小图宽度的乘积。
        :rtype: int
        """
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """雪碧图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        """填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Width(self):
        """雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
注意：小图的宽度会影响最终大图的宽度，大图的宽度最大为15000像素，其中大图的宽度为小图列数与小图宽度的乘积。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
注意：小图的高度会影响最终大图的高度，大图的高度最大为15000像素，其中大图的高度为小图行数与小图高度的乘积。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        """分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        """图片格式，取值：
<li> jpg：jpg 格式；</li>
<li> png：png 格式；</li>
<li> webp：webp 格式。</li>
默认值：jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateResponse(AbstractModel):
    """CreateImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """雪碧图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateJustInTimeTranscodeTemplateRequest(AbstractModel):
    """CreateJustInTimeTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 模板名字，长度限制64个字符。
        :type Name: str
        :param _VideoConfigure: 视频参数配置。
        :type VideoConfigure: :class:`tencentcloud.vod.v20180717.models.VideoConfigureInfo`
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _WatermarkConfigure: 水印参数配置。
        :type WatermarkConfigure: :class:`tencentcloud.vod.v20180717.models.WatermarkConfigureInfo`
        :param _Comment: 模板描述，长度限制256个字符。
        :type Comment: str
        """
        self._Name = None
        self._VideoConfigure = None
        self._SubAppId = None
        self._WatermarkConfigure = None
        self._Comment = None

    @property
    def Name(self):
        """模板名字，长度限制64个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def VideoConfigure(self):
        """视频参数配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.VideoConfigureInfo`
        """
        return self._VideoConfigure

    @VideoConfigure.setter
    def VideoConfigure(self, VideoConfigure):
        self._VideoConfigure = VideoConfigure

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def WatermarkConfigure(self):
        """水印参数配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.WatermarkConfigureInfo`
        """
        return self._WatermarkConfigure

    @WatermarkConfigure.setter
    def WatermarkConfigure(self, WatermarkConfigure):
        self._WatermarkConfigure = WatermarkConfigure

    @property
    def Comment(self):
        """模板描述，长度限制256个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("VideoConfigure") is not None:
            self._VideoConfigure = VideoConfigureInfo()
            self._VideoConfigure._deserialize(params.get("VideoConfigure"))
        self._SubAppId = params.get("SubAppId")
        if params.get("WatermarkConfigure") is not None:
            self._WatermarkConfigure = WatermarkConfigureInfo()
            self._WatermarkConfigure._deserialize(params.get("WatermarkConfigure"))
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateJustInTimeTranscodeTemplateResponse(AbstractModel):
    """CreateJustInTimeTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePersonSampleRequest(AbstractModel):
    """CreatePersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 素材名称，长度限制：20 个字符。
        :type Name: str
        :param _Usages: 素材应用场景，可选值：
1. Recognition：用于内容识别，等价于 Recognition.Face。
2. Review：用于内容不适宜，等价于 Review.Face。
3. All：包含以上全部，等价于 1+2。
        :type Usages: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Description: 素材描述，长度限制：1024 个字符。
        :type Description: str
        :param _FaceContents: 素材图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串，仅支持 jpeg、png 图片格式。数组长度限制：5 张图片。
注意：图片必须是单人像五官较清晰的照片，像素不低于 200*200。
        :type FaceContents: list of str
        :param _Tags: 素材标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :type Tags: list of str
        """
        self._Name = None
        self._Usages = None
        self._SubAppId = None
        self._Description = None
        self._FaceContents = None
        self._Tags = None

    @property
    def Name(self):
        """素材名称，长度限制：20 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Usages(self):
        """素材应用场景，可选值：
1. Recognition：用于内容识别，等价于 Recognition.Face。
2. Review：用于内容不适宜，等价于 Review.Face。
3. All：包含以上全部，等价于 1+2。
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Description(self):
        """素材描述，长度限制：1024 个字符。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceContents(self):
        """素材图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串，仅支持 jpeg、png 图片格式。数组长度限制：5 张图片。
注意：图片必须是单人像五官较清晰的照片，像素不低于 200*200。
        :rtype: list of str
        """
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents

    @property
    def Tags(self):
        """素材标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Usages = params.get("Usages")
        self._SubAppId = params.get("SubAppId")
        self._Description = params.get("Description")
        self._FaceContents = params.get("FaceContents")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleResponse(AbstractModel):
    """CreatePersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Person: 素材信息。
        :type Person: :class:`tencentcloud.vod.v20180717.models.AiSamplePerson`
        :param _FailFaceInfoSet: 处理失败的五官定位信息。
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        """素材信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiSamplePerson`
        """
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        """处理失败的五官定位信息。
        :rtype: list of AiSampleFailFaceInfo
        """
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateProcedureTemplateRequest(AbstractModel):
    """CreateProcedureTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 任务流名字（支持中文，不超过20个字）。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _MediaProcessTask: 视频处理类型任务参数。
        :type MediaProcessTask: :class:`tencentcloud.vod.v20180717.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: AI 内容审核类型任务参数 \*。
<font color=red>\*：该参数用于发起旧版审核，不建议使用。推荐使用 ReviewAudioVideoTask 参数发起审核。</font> 
        :type AiContentReviewTask: :class:`tencentcloud.vod.v20180717.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: AI 内容分析类型任务参数。
        :type AiAnalysisTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: AI 内容识别类型任务参数。
        :type AiRecognitionTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskInput`
        :param _ReviewAudioVideoTask: 音视频审核类型任务参数。
        :type ReviewAudioVideoTask: :class:`tencentcloud.vod.v20180717.models.ProcedureReviewAudioVideoTaskInput`
        """
        self._Name = None
        self._SubAppId = None
        self._Comment = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._ReviewAudioVideoTask = None

    @property
    def Name(self):
        """任务流名字（支持中文，不超过20个字）。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def MediaProcessTask(self):
        """视频处理类型任务参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.MediaProcessTaskInput`
        """
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        """AI 内容审核类型任务参数 \*。
<font color=red>\*：该参数用于发起旧版审核，不建议使用。推荐使用 ReviewAudioVideoTask 参数发起审核。</font> 
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiContentReviewTaskInput`
        """
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        """AI 内容分析类型任务参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskInput`
        """
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        """AI 内容识别类型任务参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskInput`
        """
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def ReviewAudioVideoTask(self):
        """音视频审核类型任务参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ProcedureReviewAudioVideoTaskInput`
        """
        return self._ReviewAudioVideoTask

    @ReviewAudioVideoTask.setter
    def ReviewAudioVideoTask(self, ReviewAudioVideoTask):
        self._ReviewAudioVideoTask = ReviewAudioVideoTask


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._Comment = params.get("Comment")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("ReviewAudioVideoTask") is not None:
            self._ReviewAudioVideoTask = ProcedureReviewAudioVideoTaskInput()
            self._ReviewAudioVideoTask._deserialize(params.get("ReviewAudioVideoTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProcedureTemplateResponse(AbstractModel):
    """CreateProcedureTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateQualityInspectTemplateRequest(AbstractModel):
    """CreateQualityInspectTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音画质检测模板名称。
        :type Name: str
        :param _Comment: 音画质检测模板描述。
        :type Comment: str
        :param _ScreenshotInterval: 截帧间隔，单位为秒，最小值为 1。当不填时，默认截帧间隔为 1 秒。
        :type ScreenshotInterval: float
        :param _JitterConfigure: 视频画面抖动重影检测的控制参数。
        :type JitterConfigure: :class:`tencentcloud.vod.v20180717.models.JitterConfigureInfo`
        :param _BlurConfigure: 视频画面模糊检测的控制参数。
        :type BlurConfigure: :class:`tencentcloud.vod.v20180717.models.BlurConfigureInfo`
        :param _AbnormalLightingConfigure: 视频画面低光、过曝检测的控制参数。
        :type AbnormalLightingConfigure: :class:`tencentcloud.vod.v20180717.models.AbnormalLightingConfigureInfo`
        :param _CrashScreenConfigure: 视频画面花屏检测的控制参数。
        :type CrashScreenConfigure: :class:`tencentcloud.vod.v20180717.models.CrashScreenConfigureInfo`
        :param _BlackWhiteEdgeConfigure: 视频画面黑边、白边、黑屏、白屏检测的控制参数。
        :type BlackWhiteEdgeConfigure: :class:`tencentcloud.vod.v20180717.models.BlackWhiteEdgeConfigureInfo`
        :param _NoiseConfigure: 视频画面噪点检测的控制参数。
        :type NoiseConfigure: :class:`tencentcloud.vod.v20180717.models.NoiseConfigureInfo`
        :param _MosaicConfigure: 视频画面马赛克检测的控制参数。
        :type MosaicConfigure: :class:`tencentcloud.vod.v20180717.models.MosaicConfigureInfo`
        :param _QRCodeConfigure: 视频画面二维码检测的控制参数。
        :type QRCodeConfigure: :class:`tencentcloud.vod.v20180717.models.QRCodeConfigureInfo`
        :param _VoiceConfigure: 音频（静音、低音、爆音）检测的控制参数。
        :type VoiceConfigure: :class:`tencentcloud.vod.v20180717.models.VoiceConfigureInfo`
        :param _QualityEvaluationConfigure: 视频画面质量评价的控制参数。
        :type QualityEvaluationConfigure: :class:`tencentcloud.vod.v20180717.models.QualityEvaluationConfigureInfo`
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._ScreenshotInterval = None
        self._JitterConfigure = None
        self._BlurConfigure = None
        self._AbnormalLightingConfigure = None
        self._CrashScreenConfigure = None
        self._BlackWhiteEdgeConfigure = None
        self._NoiseConfigure = None
        self._MosaicConfigure = None
        self._QRCodeConfigure = None
        self._VoiceConfigure = None
        self._QualityEvaluationConfigure = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """音画质检测模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """音画质检测模板描述。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ScreenshotInterval(self):
        """截帧间隔，单位为秒，最小值为 1。当不填时，默认截帧间隔为 1 秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def JitterConfigure(self):
        """视频画面抖动重影检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.JitterConfigureInfo`
        """
        return self._JitterConfigure

    @JitterConfigure.setter
    def JitterConfigure(self, JitterConfigure):
        self._JitterConfigure = JitterConfigure

    @property
    def BlurConfigure(self):
        """视频画面模糊检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.BlurConfigureInfo`
        """
        return self._BlurConfigure

    @BlurConfigure.setter
    def BlurConfigure(self, BlurConfigure):
        self._BlurConfigure = BlurConfigure

    @property
    def AbnormalLightingConfigure(self):
        """视频画面低光、过曝检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AbnormalLightingConfigureInfo`
        """
        return self._AbnormalLightingConfigure

    @AbnormalLightingConfigure.setter
    def AbnormalLightingConfigure(self, AbnormalLightingConfigure):
        self._AbnormalLightingConfigure = AbnormalLightingConfigure

    @property
    def CrashScreenConfigure(self):
        """视频画面花屏检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CrashScreenConfigureInfo`
        """
        return self._CrashScreenConfigure

    @CrashScreenConfigure.setter
    def CrashScreenConfigure(self, CrashScreenConfigure):
        self._CrashScreenConfigure = CrashScreenConfigure

    @property
    def BlackWhiteEdgeConfigure(self):
        """视频画面黑边、白边、黑屏、白屏检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.BlackWhiteEdgeConfigureInfo`
        """
        return self._BlackWhiteEdgeConfigure

    @BlackWhiteEdgeConfigure.setter
    def BlackWhiteEdgeConfigure(self, BlackWhiteEdgeConfigure):
        self._BlackWhiteEdgeConfigure = BlackWhiteEdgeConfigure

    @property
    def NoiseConfigure(self):
        """视频画面噪点检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.NoiseConfigureInfo`
        """
        return self._NoiseConfigure

    @NoiseConfigure.setter
    def NoiseConfigure(self, NoiseConfigure):
        self._NoiseConfigure = NoiseConfigure

    @property
    def MosaicConfigure(self):
        """视频画面马赛克检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.MosaicConfigureInfo`
        """
        return self._MosaicConfigure

    @MosaicConfigure.setter
    def MosaicConfigure(self, MosaicConfigure):
        self._MosaicConfigure = MosaicConfigure

    @property
    def QRCodeConfigure(self):
        """视频画面二维码检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.QRCodeConfigureInfo`
        """
        return self._QRCodeConfigure

    @QRCodeConfigure.setter
    def QRCodeConfigure(self, QRCodeConfigure):
        self._QRCodeConfigure = QRCodeConfigure

    @property
    def VoiceConfigure(self):
        """音频（静音、低音、爆音）检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.VoiceConfigureInfo`
        """
        return self._VoiceConfigure

    @VoiceConfigure.setter
    def VoiceConfigure(self, VoiceConfigure):
        self._VoiceConfigure = VoiceConfigure

    @property
    def QualityEvaluationConfigure(self):
        """视频画面质量评价的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.QualityEvaluationConfigureInfo`
        """
        return self._QualityEvaluationConfigure

    @QualityEvaluationConfigure.setter
    def QualityEvaluationConfigure(self, QualityEvaluationConfigure):
        self._QualityEvaluationConfigure = QualityEvaluationConfigure


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        if params.get("JitterConfigure") is not None:
            self._JitterConfigure = JitterConfigureInfo()
            self._JitterConfigure._deserialize(params.get("JitterConfigure"))
        if params.get("BlurConfigure") is not None:
            self._BlurConfigure = BlurConfigureInfo()
            self._BlurConfigure._deserialize(params.get("BlurConfigure"))
        if params.get("AbnormalLightingConfigure") is not None:
            self._AbnormalLightingConfigure = AbnormalLightingConfigureInfo()
            self._AbnormalLightingConfigure._deserialize(params.get("AbnormalLightingConfigure"))
        if params.get("CrashScreenConfigure") is not None:
            self._CrashScreenConfigure = CrashScreenConfigureInfo()
            self._CrashScreenConfigure._deserialize(params.get("CrashScreenConfigure"))
        if params.get("BlackWhiteEdgeConfigure") is not None:
            self._BlackWhiteEdgeConfigure = BlackWhiteEdgeConfigureInfo()
            self._BlackWhiteEdgeConfigure._deserialize(params.get("BlackWhiteEdgeConfigure"))
        if params.get("NoiseConfigure") is not None:
            self._NoiseConfigure = NoiseConfigureInfo()
            self._NoiseConfigure._deserialize(params.get("NoiseConfigure"))
        if params.get("MosaicConfigure") is not None:
            self._MosaicConfigure = MosaicConfigureInfo()
            self._MosaicConfigure._deserialize(params.get("MosaicConfigure"))
        if params.get("QRCodeConfigure") is not None:
            self._QRCodeConfigure = QRCodeConfigureInfo()
            self._QRCodeConfigure._deserialize(params.get("QRCodeConfigure"))
        if params.get("VoiceConfigure") is not None:
            self._VoiceConfigure = VoiceConfigureInfo()
            self._VoiceConfigure._deserialize(params.get("VoiceConfigure"))
        if params.get("QualityEvaluationConfigure") is not None:
            self._QualityEvaluationConfigure = QualityEvaluationConfigureInfo()
            self._QualityEvaluationConfigure._deserialize(params.get("QualityEvaluationConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateQualityInspectTemplateResponse(AbstractModel):
    """CreateQualityInspectTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音画质检测模板 ID。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """音画质检测模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateRebuildMediaTemplateRequest(AbstractModel):
    """CreateRebuildMediaTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Container: 输出文件封装格式，可选值：mp4、flv、hls。
        :type Container: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音画质重生模板名称。
        :type Name: str
        :param _Comment: 模板描述。
        :type Comment: str
        :param _RebuildVideoInfo: 音画质重生视频控制控制信息。
        :type RebuildVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        :param _RebuildAudioInfo: 音画质重生音频控制控制信息。
        :type RebuildAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        :param _TargetVideoInfo: 输出目标视频控制信息。
        :type TargetVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        :param _TargetAudioInfo: 输出目标音频控制信息。
        :type TargetAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :type RemoveAudio: str
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RebuildVideoInfo = None
        self._RebuildAudioInfo = None
        self._TargetVideoInfo = None
        self._TargetAudioInfo = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def Container(self):
        """输出文件封装格式，可选值：mp4、flv、hls。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """音画质重生模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """模板描述。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RebuildVideoInfo(self):
        """音画质重生视频控制控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        """
        return self._RebuildVideoInfo

    @RebuildVideoInfo.setter
    def RebuildVideoInfo(self, RebuildVideoInfo):
        self._RebuildVideoInfo = RebuildVideoInfo

    @property
    def RebuildAudioInfo(self):
        """音画质重生音频控制控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        """
        return self._RebuildAudioInfo

    @RebuildAudioInfo.setter
    def RebuildAudioInfo(self, RebuildAudioInfo):
        self._RebuildAudioInfo = RebuildAudioInfo

    @property
    def TargetVideoInfo(self):
        """输出目标视频控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        """
        return self._TargetVideoInfo

    @TargetVideoInfo.setter
    def TargetVideoInfo(self, TargetVideoInfo):
        self._TargetVideoInfo = TargetVideoInfo

    @property
    def TargetAudioInfo(self):
        """输出目标音频控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        """
        return self._TargetAudioInfo

    @TargetAudioInfo.setter
    def TargetAudioInfo(self, TargetAudioInfo):
        self._TargetAudioInfo = TargetAudioInfo

    @property
    def RemoveVideo(self):
        """是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        """是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :rtype: str
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("RebuildVideoInfo") is not None:
            self._RebuildVideoInfo = RebuildVideoInfo()
            self._RebuildVideoInfo._deserialize(params.get("RebuildVideoInfo"))
        if params.get("RebuildAudioInfo") is not None:
            self._RebuildAudioInfo = RebuildAudioInfo()
            self._RebuildAudioInfo._deserialize(params.get("RebuildAudioInfo"))
        if params.get("TargetVideoInfo") is not None:
            self._TargetVideoInfo = RebuildMediaTargetVideoStream()
            self._TargetVideoInfo._deserialize(params.get("TargetVideoInfo"))
        if params.get("TargetAudioInfo") is not None:
            self._TargetAudioInfo = RebuildMediaTargetAudioStream()
            self._TargetAudioInfo._deserialize(params.get("TargetAudioInfo"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRebuildMediaTemplateResponse(AbstractModel):
    """CreateRebuildMediaTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频重生模板 ID。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """视频重生模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateReviewTemplateRequest(AbstractModel):
    """CreateReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Labels: 需要返回的违规标签列表，可选值为：
<li>Porn：色情；</li>
<li>Terror：暴力；</li>
<li>Polity：不适宜的信息；</li>
<li>Illegal：违法；</li>
<li>Abuse：谩骂；</li>
<li>Ad：广告；</li>
<li>Moan：娇喘。</li>
        :type Labels: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: str
        :param _Name: 审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Labels = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None

    @property
    def Labels(self):
        """需要返回的违规标签列表，可选值为：
<li>Porn：色情；</li>
<li>Terror：暴力；</li>
<li>Polity：不适宜的信息；</li>
<li>Illegal：违法；</li>
<li>Abuse：谩骂；</li>
<li>Ad：广告；</li>
<li>Moan：娇喘。</li>
        :rtype: list of str
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """审核模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """审核模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Labels = params.get("Labels")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateReviewTemplateResponse(AbstractModel):
    """CreateReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 审核模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateRoundPlayRequest(AbstractModel):
    """CreateRoundPlay请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 启播时间，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _RoundPlaylist: 轮播列表。
<li>数组长度限制：100。</li>
        :type RoundPlaylist: list of RoundPlayListItemInfo
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 轮播播单名称，长度限制：64 个字符。
        :type Name: str
        :param _Desc: 轮播播单描述信息，长度限制：256 个字符。
        :type Desc: str
        :param _PlayBackMode: 播放模式，可选值：
<li>Loop：循环播放播单；</li>
<li>Linear：单次播放，播单播放完停止播放。</li>
默认值：Loop。
        :type PlayBackMode: str
        """
        self._StartTime = None
        self._RoundPlaylist = None
        self._SubAppId = None
        self._Name = None
        self._Desc = None
        self._PlayBackMode = None

    @property
    def StartTime(self):
        """启播时间，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def RoundPlaylist(self):
        """轮播列表。
<li>数组长度限制：100。</li>
        :rtype: list of RoundPlayListItemInfo
        """
        return self._RoundPlaylist

    @RoundPlaylist.setter
    def RoundPlaylist(self, RoundPlaylist):
        self._RoundPlaylist = RoundPlaylist

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """轮播播单名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        """轮播播单描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def PlayBackMode(self):
        """播放模式，可选值：
<li>Loop：循环播放播单；</li>
<li>Linear：单次播放，播单播放完停止播放。</li>
默认值：Loop。
        :rtype: str
        """
        return self._PlayBackMode

    @PlayBackMode.setter
    def PlayBackMode(self, PlayBackMode):
        self._PlayBackMode = PlayBackMode


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        if params.get("RoundPlaylist") is not None:
            self._RoundPlaylist = []
            for item in params.get("RoundPlaylist"):
                obj = RoundPlayListItemInfo()
                obj._deserialize(item)
                self._RoundPlaylist.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._PlayBackMode = params.get("PlayBackMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoundPlayResponse(AbstractModel):
    """CreateRoundPlay返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RoundPlayId: 轮播播单唯一标识。
        :type RoundPlayId: str
        :param _Url: 轮播播放地址。
        :type Url: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RoundPlayId = None
        self._Url = None
        self._RequestId = None

    @property
    def RoundPlayId(self):
        """轮播播单唯一标识。
        :rtype: str
        """
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def Url(self):
        """轮播播放地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoundPlayId = params.get("RoundPlayId")
        self._Url = params.get("Url")
        self._RequestId = params.get("RequestId")


class CreateSampleSnapshotTemplateRequest(AbstractModel):
    """CreateSampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleType: 采样截图类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 采样截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值为 jpg 和 png。默认为 jpg。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._SubAppId = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SampleType(self):
        """采样截图类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :rtype: str
        """
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        """采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :rtype: int
        """
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """采样截图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        """截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        """分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        """图片格式，取值为 jpg 和 png。默认为 jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        """填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSampleSnapshotTemplateResponse(AbstractModel):
    """CreateSampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """采样截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """CreateSnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 指定时间点截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值可以为 jpg 和 png。默认为 jpg。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._SubAppId = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """指定时间点截图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        """截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        """分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        """图片格式，取值可以为 jpg 和 png。默认为 jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        """填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """CreateSnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 时间点截图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """时间点截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateStorageRegionRequest(AbstractModel):
    """CreateStorageRegion请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StorageRegion: 待开通的存储地域，必须是系统支持的地域。
        :type StorageRegion: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StorageRegion = None
        self._SubAppId = None

    @property
    def StorageRegion(self):
        """待开通的存储地域，必须是系统支持的地域。
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StorageRegion = params.get("StorageRegion")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStorageRegionResponse(AbstractModel):
    """CreateStorageRegion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSubAppIdRequest(AbstractModel):
    """CreateSubAppId请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 应用名称，长度限制：40个字符。
        :type Name: str
        :param _Description: 应用简介，长度限制： 300个字符。
        :type Description: str
        """
        self._Name = None
        self._Description = None

    @property
    def Name(self):
        """应用名称，长度限制：40个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """应用简介，长度限制： 300个字符。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubAppIdResponse(AbstractModel):
    """CreateSubAppId返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: 新创建的应用 ID。
        :type SubAppId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SubAppId = None
        self._RequestId = None

    @property
    def SubAppId(self):
        """新创建的应用 ID。
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._RequestId = params.get("RequestId")


class CreateSuperPlayerConfigRequest(AbstractModel):
    """CreateSuperPlayerConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 播放器配置名称，长度限制：64 个字符。只允许出现 [0-9a-zA-Z] 及 _- 字符（如 test_ABC-123），同一个用户该名称唯一。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _AudioVideoType: 播放的音视频类型，可选值：
<li>AdaptiveDynamicStream：自适应码流输出；</li>
<li>Transcode：转码输出；</li>
<li>Original：原始音视频。</li>
默认为 AdaptiveDynamicStream。
        :type AudioVideoType: str
        :param _DrmSwitch: 播放 DRM 保护的自适应码流开关：
<li>ON：开启，表示仅播放 DRM  保护的自适应码流输出；</li>
<li>OFF：关闭，表示播放未加密的自适应码流输出。</li>
默认为 OFF。
当 AudioVideoType 为 AdaptiveDynamicStream 时，此参数有效。
        :type DrmSwitch: str
        :param _AdaptiveDynamicStreamingDefinition: 允许输出的未加密的自适应码流模板 ID。

当 AudioVideoType 为 AdaptiveDynamicStream 并且 DrmSwitch 为 OFF 时，此参数为必填。
        :type AdaptiveDynamicStreamingDefinition: int
        :param _DrmStreamingsInfo: 允许输出的 DRM 自适应码流模板内容。

当 AudioVideoType 为 AdaptiveDynamicStream 并且 DrmSwitch 为 ON 时，此参数为必填。
        :type DrmStreamingsInfo: :class:`tencentcloud.vod.v20180717.models.DrmStreamingsInfo`
        :param _TranscodeDefinition: 允许输出的转码模板 ID。

当 AudioVideoType 为 Transcode 时必填。
        :type TranscodeDefinition: int
        :param _ImageSpriteDefinition: 允许输出的雪碧图模板 ID。
        :type ImageSpriteDefinition: int
        :param _ResolutionNames: 播放器对于不同分辨率的子流展示名字，不填或者填空数组则使用默认配置：
<li>MinEdgeLength：240，Name：流畅；</li>
<li>MinEdgeLength：480，Name：标清；</li>
<li>MinEdgeLength：720，Name：高清；</li>
<li>MinEdgeLength：1080，Name：全高清；</li>
<li>MinEdgeLength：1440，Name：2K；</li>
<li>MinEdgeLength：2160，Name：4K；</li>
<li>MinEdgeLength：4320，Name：8K。</li>
        :type ResolutionNames: list of ResolutionNameInfo
        :param _Domain: 播放时使用的域名。不填或者填 Default，表示使用[默认分发配置](https://cloud.tencent.com/document/product/266/33373)中的域名。
        :type Domain: str
        :param _Scheme: 播放时使用的 Scheme。不填或者填 Default，表示使用[默认分发配置](https://cloud.tencent.com/document/product/266/33373)中的 Scheme。其他可选值：
<li>HTTP；</li>
<li>HTTPS。</li>
        :type Scheme: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Name = None
        self._SubAppId = None
        self._AudioVideoType = None
        self._DrmSwitch = None
        self._AdaptiveDynamicStreamingDefinition = None
        self._DrmStreamingsInfo = None
        self._TranscodeDefinition = None
        self._ImageSpriteDefinition = None
        self._ResolutionNames = None
        self._Domain = None
        self._Scheme = None
        self._Comment = None

    @property
    def Name(self):
        """播放器配置名称，长度限制：64 个字符。只允许出现 [0-9a-zA-Z] 及 _- 字符（如 test_ABC-123），同一个用户该名称唯一。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def AudioVideoType(self):
        """播放的音视频类型，可选值：
<li>AdaptiveDynamicStream：自适应码流输出；</li>
<li>Transcode：转码输出；</li>
<li>Original：原始音视频。</li>
默认为 AdaptiveDynamicStream。
        :rtype: str
        """
        return self._AudioVideoType

    @AudioVideoType.setter
    def AudioVideoType(self, AudioVideoType):
        self._AudioVideoType = AudioVideoType

    @property
    def DrmSwitch(self):
        """播放 DRM 保护的自适应码流开关：
<li>ON：开启，表示仅播放 DRM  保护的自适应码流输出；</li>
<li>OFF：关闭，表示播放未加密的自适应码流输出。</li>
默认为 OFF。
当 AudioVideoType 为 AdaptiveDynamicStream 时，此参数有效。
        :rtype: str
        """
        return self._DrmSwitch

    @DrmSwitch.setter
    def DrmSwitch(self, DrmSwitch):
        self._DrmSwitch = DrmSwitch

    @property
    def AdaptiveDynamicStreamingDefinition(self):
        """允许输出的未加密的自适应码流模板 ID。

当 AudioVideoType 为 AdaptiveDynamicStream 并且 DrmSwitch 为 OFF 时，此参数为必填。
        :rtype: int
        """
        return self._AdaptiveDynamicStreamingDefinition

    @AdaptiveDynamicStreamingDefinition.setter
    def AdaptiveDynamicStreamingDefinition(self, AdaptiveDynamicStreamingDefinition):
        self._AdaptiveDynamicStreamingDefinition = AdaptiveDynamicStreamingDefinition

    @property
    def DrmStreamingsInfo(self):
        """允许输出的 DRM 自适应码流模板内容。

当 AudioVideoType 为 AdaptiveDynamicStream 并且 DrmSwitch 为 ON 时，此参数为必填。
        :rtype: :class:`tencentcloud.vod.v20180717.models.DrmStreamingsInfo`
        """
        return self._DrmStreamingsInfo

    @DrmStreamingsInfo.setter
    def DrmStreamingsInfo(self, DrmStreamingsInfo):
        self._DrmStreamingsInfo = DrmStreamingsInfo

    @property
    def TranscodeDefinition(self):
        """允许输出的转码模板 ID。

当 AudioVideoType 为 Transcode 时必填。
        :rtype: int
        """
        return self._TranscodeDefinition

    @TranscodeDefinition.setter
    def TranscodeDefinition(self, TranscodeDefinition):
        self._TranscodeDefinition = TranscodeDefinition

    @property
    def ImageSpriteDefinition(self):
        """允许输出的雪碧图模板 ID。
        :rtype: int
        """
        return self._ImageSpriteDefinition

    @ImageSpriteDefinition.setter
    def ImageSpriteDefinition(self, ImageSpriteDefinition):
        self._ImageSpriteDefinition = ImageSpriteDefinition

    @property
    def ResolutionNames(self):
        """播放器对于不同分辨率的子流展示名字，不填或者填空数组则使用默认配置：
<li>MinEdgeLength：240，Name：流畅；</li>
<li>MinEdgeLength：480，Name：标清；</li>
<li>MinEdgeLength：720，Name：高清；</li>
<li>MinEdgeLength：1080，Name：全高清；</li>
<li>MinEdgeLength：1440，Name：2K；</li>
<li>MinEdgeLength：2160，Name：4K；</li>
<li>MinEdgeLength：4320，Name：8K。</li>
        :rtype: list of ResolutionNameInfo
        """
        return self._ResolutionNames

    @ResolutionNames.setter
    def ResolutionNames(self, ResolutionNames):
        self._ResolutionNames = ResolutionNames

    @property
    def Domain(self):
        """播放时使用的域名。不填或者填 Default，表示使用[默认分发配置](https://cloud.tencent.com/document/product/266/33373)中的域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Scheme(self):
        """播放时使用的 Scheme。不填或者填 Default，表示使用[默认分发配置](https://cloud.tencent.com/document/product/266/33373)中的 Scheme。其他可选值：
<li>HTTP；</li>
<li>HTTPS。</li>
        :rtype: str
        """
        return self._Scheme

    @Scheme.setter
    def Scheme(self, Scheme):
        self._Scheme = Scheme

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._AudioVideoType = params.get("AudioVideoType")
        self._DrmSwitch = params.get("DrmSwitch")
        self._AdaptiveDynamicStreamingDefinition = params.get("AdaptiveDynamicStreamingDefinition")
        if params.get("DrmStreamingsInfo") is not None:
            self._DrmStreamingsInfo = DrmStreamingsInfo()
            self._DrmStreamingsInfo._deserialize(params.get("DrmStreamingsInfo"))
        self._TranscodeDefinition = params.get("TranscodeDefinition")
        self._ImageSpriteDefinition = params.get("ImageSpriteDefinition")
        if params.get("ResolutionNames") is not None:
            self._ResolutionNames = []
            for item in params.get("ResolutionNames"):
                obj = ResolutionNameInfo()
                obj._deserialize(item)
                self._ResolutionNames.append(obj)
        self._Domain = params.get("Domain")
        self._Scheme = params.get("Scheme")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSuperPlayerConfigResponse(AbstractModel):
    """CreateSuperPlayerConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateTranscodeTemplateRequest(AbstractModel):
    """CreateTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Container: 封装格式，可选值：mp4、flv、hls、mp3、flac、ogg、m4a、wav。其中，mp3、flac、ogg、m4a、wav 为纯音频文件。
        :type Container: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 转码模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveAudio: int
        :param _VideoTemplate: 视频流配置参数，当 RemoveVideo 为 0，该字段必填。
        :type VideoTemplate: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        :param _AudioTemplate: 音频流配置参数，当 RemoveAudio 为 0，该字段必填。
        :type AudioTemplate: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        :param _TEHDConfig: 极速高清转码参数。
        :type TEHDConfig: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        :param _SegmentType: 切片类型，当 Container 为 hls 时有效，可选值：
<li>ts：ts 切片；</li>
<li>fmp4：fmp4 切片。</li>
默认值：ts。
        :type SegmentType: str
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._SegmentType = None

    @property
    def Container(self):
        """封装格式，可选值：mp4、flv、hls、mp3、flac、ogg、m4a、wav。其中，mp3、flac、ogg、m4a、wav 为纯音频文件。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """转码模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        """是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        """是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        """视频流配置参数，当 RemoveVideo 为 0，该字段必填。
        :rtype: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        """
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        """音频流配置参数，当 RemoveAudio 为 0，该字段必填。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        """
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        """极速高清转码参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        """
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def SegmentType(self):
        """切片类型，当 Container 为 hls 时有效，可选值：
<li>ts：ts 切片；</li>
<li>fmp4：fmp4 切片。</li>
默认值：ts。
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfo()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfo()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTranscodeTemplateResponse(AbstractModel):
    """CreateTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        """转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateVodDomainRequest(AbstractModel):
    """CreateVodDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要接入点播的加速域名。注意：不支持填写泛域名。
        :type Domain: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _AccelerateArea: 需要开启 CDN 加速的区域：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland: 中国境外。</li>
<li>Global: 全球范围。</li>
如果没有设置 AccelerateArea， 点播会根据用户在腾讯云设置的地域信息自动开通中国境内或者中国境外的 CDN 加速。开启中国境内加速的域名，需要先[备案域名](/document/product/243/18905)。
        :type AccelerateArea: str
        """
        self._Domain = None
        self._SubAppId = None
        self._AccelerateArea = None

    @property
    def Domain(self):
        """需要接入点播的加速域名。注意：不支持填写泛域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def AccelerateArea(self):
        """需要开启 CDN 加速的区域：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland: 中国境外。</li>
<li>Global: 全球范围。</li>
如果没有设置 AccelerateArea， 点播会根据用户在腾讯云设置的地域信息自动开通中国境内或者中国境外的 CDN 加速。开启中国境内加速的域名，需要先[备案域名](/document/product/243/18905)。
        :rtype: str
        """
        return self._AccelerateArea

    @AccelerateArea.setter
    def AccelerateArea(self, AccelerateArea):
        self._AccelerateArea = AccelerateArea


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SubAppId = params.get("SubAppId")
        self._AccelerateArea = params.get("AccelerateArea")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVodDomainResponse(AbstractModel):
    """CreateVodDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateWatermarkTemplateRequest(AbstractModel):
    """CreateWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 水印类型，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :type Type: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 水印模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _CoordinateOrigin: 原点位置，可选值：
<li>TopLeft：表示坐标原点位于视频图像左上角，水印原点为图片或文字的左上角；</li>
<li>TopRight：表示坐标原点位于视频图像的右上角，水印原点为图片或文字的右上角；</li>
<li>BottomLeft：表示坐标原点位于视频图像的左下角，水印原点为图片或文字的左下角；</li>
<li>BottomRight：表示坐标原点位于视频图像的右下角，水印原点为图片或文字的右下角。</li>
默认值：TopLeft。
        :type CoordinateOrigin: str
        :param _XPos: 水印原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
默认值：0px。
        :type XPos: str
        :param _YPos: 水印原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
默认值：0px。
        :type YPos: str
        :param _ImageTemplate: 图片水印模板，当 Type 为 image，该字段必填。当 Type 为 text，该字段无效。
        :type ImageTemplate: :class:`tencentcloud.vod.v20180717.models.ImageWatermarkInput`
        :param _TextTemplate: 文字水印模板，当 Type 为 text，该字段必填。当 Type 为 image，该字段无效。
        :type TextTemplate: :class:`tencentcloud.vod.v20180717.models.TextWatermarkTemplateInput`
        :param _SvgTemplate: SVG水印模板，当 Type 为 svg，该字段必填。当 Type 为 image 或 text，该字段无效。
        :type SvgTemplate: :class:`tencentcloud.vod.v20180717.models.SvgWatermarkInput`
        """
        self._Type = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Type(self):
        """水印类型，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        """水印模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        """模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        """原点位置，可选值：
<li>TopLeft：表示坐标原点位于视频图像左上角，水印原点为图片或文字的左上角；</li>
<li>TopRight：表示坐标原点位于视频图像的右上角，水印原点为图片或文字的右上角；</li>
<li>BottomLeft：表示坐标原点位于视频图像的左下角，水印原点为图片或文字的左下角；</li>
<li>BottomRight：表示坐标原点位于视频图像的右下角，水印原点为图片或文字的右下角。</li>
默认值：TopLeft。
        :rtype: str
        """
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        """水印原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
默认值：0px。
        :rtype: str
        """
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        """水印原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
默认值：0px。
        :rtype: str
        """
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        """图片水印模板，当 Type 为 image，该字段必填。当 Type 为 text，该字段无效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ImageWatermarkInput`
        """
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        """文字水印模板，当 Type 为 text，该字段必填。当 Type 为 image，该字段无效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TextWatermarkTemplateInput`
        """
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        """SVG水印模板，当 Type 为 svg，该字段必填。当 Type 为 image 或 text，该字段无效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SvgWatermarkInput`
        """
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInput()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInput()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInput()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWatermarkTemplateResponse(AbstractModel):
    """CreateWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        :param _ImageUrl: 水印图片地址，仅当 Type 为 image，该字段有效。
        :type ImageUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._ImageUrl = None
        self._RequestId = None

    @property
    def Definition(self):
        """水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ImageUrl(self):
        """水印图片地址，仅当 Type 为 image，该字段有效。
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class CreateWordSamplesRequest(AbstractModel):
    """CreateWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Usages: <b>关键词应用场景，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜内容识别，等价于 3+4；
7. All：通过光学字符识别技术、音频识别技术，进行内容识别、不适宜内容识别，等价于 1+2+3+4。
        :type Usages: list of str
        :param _Words: 关键词，数组长度限制：100。
        :type Words: list of AiSampleWordInfo
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Usages = None
        self._Words = None
        self._SubAppId = None

    @property
    def Usages(self):
        """<b>关键词应用场景，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜内容识别，等价于 3+4；
7. All：通过光学字符识别技术、音频识别技术，进行内容识别、不适宜内容识别，等价于 1+2+3+4。
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Words(self):
        """关键词，数组长度限制：100。
        :rtype: list of AiSampleWordInfo
        """
        return self._Words

    @Words.setter
    def Words(self, Words):
        self._Words = Words

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Usages = params.get("Usages")
        if params.get("Words") is not None:
            self._Words = []
            for item in params.get("Words"):
                obj = AiSampleWordInfo()
                obj._deserialize(item)
                self._Words.append(obj)
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWordSamplesResponse(AbstractModel):
    """CreateWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DNSVerifyInfo(AbstractModel):
    """DNS解析验证信息

    """

    def __init__(self):
        r"""
        :param _SubDomain: 子解析。
        :type SubDomain: str
        :param _Record: 解析值。
        :type Record: str
        :param _RecordType: 解析类型。
        :type RecordType: str
        """
        self._SubDomain = None
        self._Record = None
        self._RecordType = None

    @property
    def SubDomain(self):
        """子解析。
        :rtype: str
        """
        return self._SubDomain

    @SubDomain.setter
    def SubDomain(self, SubDomain):
        self._SubDomain = SubDomain

    @property
    def Record(self):
        """解析值。
        :rtype: str
        """
        return self._Record

    @Record.setter
    def Record(self, Record):
        self._Record = Record

    @property
    def RecordType(self):
        """解析类型。
        :rtype: str
        """
        return self._RecordType

    @RecordType.setter
    def RecordType(self, RecordType):
        self._RecordType = RecordType


    def _deserialize(self, params):
        self._SubDomain = params.get("SubDomain")
        self._Record = params.get("Record")
        self._RecordType = params.get("RecordType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DailyPlayStatInfo(AbstractModel):
    """播放统计信息。

    """

    def __init__(self):
        r"""
        :param _Date: 播放媒体文件的日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type Date: str
        :param _FileId: 媒体文件ID。
        :type FileId: str
        :param _PlayTimes: 播放次数。
        :type PlayTimes: int
        :param _Traffic: 播放流量，单位：字节。
        :type Traffic: int
        """
        self._Date = None
        self._FileId = None
        self._PlayTimes = None
        self._Traffic = None

    @property
    def Date(self):
        """播放媒体文件的日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def FileId(self):
        """媒体文件ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def PlayTimes(self):
        """播放次数。
        :rtype: int
        """
        return self._PlayTimes

    @PlayTimes.setter
    def PlayTimes(self, PlayTimes):
        self._PlayTimes = PlayTimes

    @property
    def Traffic(self):
        """播放流量，单位：字节。
        :rtype: int
        """
        return self._Traffic

    @Traffic.setter
    def Traffic(self, Traffic):
        self._Traffic = Traffic


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._FileId = params.get("FileId")
        self._PlayTimes = params.get("PlayTimes")
        self._Traffic = params.get("Traffic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateRequest(AbstractModel):
    """DeleteAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容分析模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """音视频内容分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateResponse(AbstractModel):
    """DeleteAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAIRecognitionTemplateRequest(AbstractModel):
    """DeleteAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容识别模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """音视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIRecognitionTemplateResponse(AbstractModel):
    """DeleteAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """DeleteAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应转码模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """自适应转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """DeleteAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAnimatedGraphicsTemplateRequest(AbstractModel):
    """DeleteAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnimatedGraphicsTemplateResponse(AbstractModel):
    """DeleteAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCLSTopicRequest(AbstractModel):
    """DeleteCLSTopic请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        :param _TopicId: 日志主题 ID。
        :type TopicId: str
        """
        self._CLSRegion = None
        self._TopicId = None

    @property
    def CLSRegion(self):
        """日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def TopicId(self):
        """日志主题 ID。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._TopicId = params.get("TopicId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCLSTopicResponse(AbstractModel):
    """DeleteCLSTopic返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClassRequest(AbstractModel):
    """DeleteClass请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassId: 分类 ID
        :type ClassId: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._ClassId = None
        self._SubAppId = None

    @property
    def ClassId(self):
        """分类 ID
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._ClassId = params.get("ClassId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClassResponse(AbstractModel):
    """DeleteClass返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteContentReviewTemplateRequest(AbstractModel):
    """DeleteContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """内容审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContentReviewTemplateResponse(AbstractModel):
    """DeleteContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEnhanceMediaTemplateRequest(AbstractModel):
    """DeleteEnhanceMediaTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音画质重生模板号。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """音画质重生模板号。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEnhanceMediaTemplateResponse(AbstractModel):
    """DeleteEnhanceMediaTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHeadTailTemplateRequest(AbstractModel):
    """DeleteHeadTailTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 片头片尾模板号。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """片头片尾模板号。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHeadTailTemplateResponse(AbstractModel):
    """DeleteHeadTailTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageProcessingTemplateRequest(AbstractModel):
    """DeleteImageProcessingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 图片处理模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """图片处理模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageProcessingTemplateResponse(AbstractModel):
    """DeleteImageProcessingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageSpriteTemplateRequest(AbstractModel):
    """DeleteImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """雪碧图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageSpriteTemplateResponse(AbstractModel):
    """DeleteImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteJustInTimeTranscodeTemplateRequest(AbstractModel):
    """DeleteJustInTimeTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 模板名字。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        """模板名字。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteJustInTimeTranscodeTemplateResponse(AbstractModel):
    """DeleteJustInTimeTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMediaRequest(AbstractModel):
    """DeleteMedia请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件的唯一标识。
        :type FileId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _DeleteParts: 指定本次需要删除的部分。默认值为 "[]", 表示删除媒体及其对应的全部视频处理文件。
        :type DeleteParts: list of MediaDeleteItem
        """
        self._FileId = None
        self._SubAppId = None
        self._DeleteParts = None

    @property
    def FileId(self):
        """媒体文件的唯一标识。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DeleteParts(self):
        """指定本次需要删除的部分。默认值为 "[]", 表示删除媒体及其对应的全部视频处理文件。
        :rtype: list of MediaDeleteItem
        """
        return self._DeleteParts

    @DeleteParts.setter
    def DeleteParts(self, DeleteParts):
        self._DeleteParts = DeleteParts


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SubAppId = params.get("SubAppId")
        if params.get("DeleteParts") is not None:
            self._DeleteParts = []
            for item in params.get("DeleteParts"):
                obj = MediaDeleteItem()
                obj._deserialize(item)
                self._DeleteParts.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMediaResponse(AbstractModel):
    """DeleteMedia返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePersonSampleRequest(AbstractModel):
    """DeletePersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PersonId: 素材 ID。
        :type PersonId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._PersonId = None
        self._SubAppId = None

    @property
    def PersonId(self):
        """素材 ID。
        :rtype: str
        """
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePersonSampleResponse(AbstractModel):
    """DeletePersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteProcedureTemplateRequest(AbstractModel):
    """DeleteProcedureTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 任务流名字。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        """任务流名字。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProcedureTemplateResponse(AbstractModel):
    """DeleteProcedureTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteQualityInspectTemplateRequest(AbstractModel):
    """DeleteQualityInspectTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音画质检测模板 ID。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """音画质检测模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteQualityInspectTemplateResponse(AbstractModel):
    """DeleteQualityInspectTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRebuildMediaTemplateRequest(AbstractModel):
    """DeleteRebuildMediaTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频重生模板号。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """视频重生模板号。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRebuildMediaTemplateResponse(AbstractModel):
    """DeleteRebuildMediaTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReviewTemplateRequest(AbstractModel):
    """DeleteReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 审核模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReviewTemplateResponse(AbstractModel):
    """DeleteReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoundPlayRequest(AbstractModel):
    """DeleteRoundPlay请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RoundPlayId: 轮播播单唯一标识。
        :type RoundPlayId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._RoundPlayId = None
        self._SubAppId = None

    @property
    def RoundPlayId(self):
        """轮播播单唯一标识。
        :rtype: str
        """
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._RoundPlayId = params.get("RoundPlayId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoundPlayResponse(AbstractModel):
    """DeleteRoundPlay返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSampleSnapshotTemplateRequest(AbstractModel):
    """DeleteSampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """采样截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSampleSnapshotTemplateResponse(AbstractModel):
    """DeleteSampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """DeleteSnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 指定时间点截图模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """指定时间点截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """DeleteSnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSuperPlayerConfigRequest(AbstractModel):
    """DeleteSuperPlayerConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 播放器配置名称。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        """播放器配置名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSuperPlayerConfigResponse(AbstractModel):
    """DeleteSuperPlayerConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTranscodeTemplateRequest(AbstractModel):
    """DeleteTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTranscodeTemplateResponse(AbstractModel):
    """DeleteTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVodDomainRequest(AbstractModel):
    """DeleteVodDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 要删除的点播加速域名。
        :type Domain: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Domain = None
        self._SubAppId = None

    @property
    def Domain(self):
        """要删除的点播加速域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVodDomainResponse(AbstractModel):
    """DeleteVodDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWatermarkTemplateRequest(AbstractModel):
    """DeleteWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        """水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWatermarkTemplateResponse(AbstractModel):
    """DeleteWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWordSamplesRequest(AbstractModel):
    """DeleteWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Keywords: 关键词，数组长度限制：100 个词。
        :type Keywords: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Keywords = None
        self._SubAppId = None

    @property
    def Keywords(self):
        """关键词，数组长度限制：100 个词。
        :rtype: list of str
        """
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWordSamplesResponse(AbstractModel):
    """DeleteWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAIAnalysisTemplatesRequest(AbstractModel):
    """DescribeAIAnalysisTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 音视频内容分析模板唯一标识过滤条件，数组长度最大值：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """音视频内容分析模板唯一标识过滤条件，数组长度最大值：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIAnalysisTemplatesResponse(AbstractModel):
    """DescribeAIAnalysisTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AIAnalysisTemplateSet: 音视频内容分析模板详情列表。
        :type AIAnalysisTemplateSet: list of AIAnalysisTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIAnalysisTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIAnalysisTemplateSet(self):
        """音视频内容分析模板详情列表。
        :rtype: list of AIAnalysisTemplateItem
        """
        return self._AIAnalysisTemplateSet

    @AIAnalysisTemplateSet.setter
    def AIAnalysisTemplateSet(self, AIAnalysisTemplateSet):
        self._AIAnalysisTemplateSet = AIAnalysisTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIAnalysisTemplateSet") is not None:
            self._AIAnalysisTemplateSet = []
            for item in params.get("AIAnalysisTemplateSet"):
                obj = AIAnalysisTemplateItem()
                obj._deserialize(item)
                self._AIAnalysisTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAIRecognitionTemplatesRequest(AbstractModel):
    """DescribeAIRecognitionTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 音视频内容识别模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：<li>Preset：系统预置模板；</li><li>Custom：用户自定义模板。</li>不填默认为空，即不对模板类型过滤。
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """音视频内容识别模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        """模板类型过滤条件，可选值：<li>Preset：系统预置模板；</li><li>Custom：用户自定义模板。</li>不填默认为空，即不对模板类型过滤。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIRecognitionTemplatesResponse(AbstractModel):
    """DescribeAIRecognitionTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AIRecognitionTemplateSet: 音视频内容识别模板详情列表。
        :type AIRecognitionTemplateSet: list of AIRecognitionTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIRecognitionTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIRecognitionTemplateSet(self):
        """音视频内容识别模板详情列表。
        :rtype: list of AIRecognitionTemplateItem
        """
        return self._AIRecognitionTemplateSet

    @AIRecognitionTemplateSet.setter
    def AIRecognitionTemplateSet(self, AIRecognitionTemplateSet):
        self._AIRecognitionTemplateSet = AIRecognitionTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIRecognitionTemplateSet") is not None:
            self._AIRecognitionTemplateSet = []
            for item in params.get("AIRecognitionTemplateSet"):
                obj = AIRecognitionTemplateItem()
                obj._deserialize(item)
                self._AIRecognitionTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAdaptiveDynamicStreamingTemplatesRequest(AbstractModel):
    """DescribeAdaptiveDynamicStreamingTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 转自适应码流模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """转自适应码流模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAdaptiveDynamicStreamingTemplatesResponse(AbstractModel):
    """DescribeAdaptiveDynamicStreamingTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AdaptiveDynamicStreamingTemplateSet: 转自适应码流模板详情列表。
        :type AdaptiveDynamicStreamingTemplateSet: list of AdaptiveDynamicStreamingTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AdaptiveDynamicStreamingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AdaptiveDynamicStreamingTemplateSet(self):
        """转自适应码流模板详情列表。
        :rtype: list of AdaptiveDynamicStreamingTemplate
        """
        return self._AdaptiveDynamicStreamingTemplateSet

    @AdaptiveDynamicStreamingTemplateSet.setter
    def AdaptiveDynamicStreamingTemplateSet(self, AdaptiveDynamicStreamingTemplateSet):
        self._AdaptiveDynamicStreamingTemplateSet = AdaptiveDynamicStreamingTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AdaptiveDynamicStreamingTemplateSet") is not None:
            self._AdaptiveDynamicStreamingTemplateSet = []
            for item in params.get("AdaptiveDynamicStreamingTemplateSet"):
                obj = AdaptiveDynamicStreamingTemplate()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAllClassRequest(AbstractModel):
    """DescribeAllClass请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllClassResponse(AbstractModel):
    """DescribeAllClass返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassInfoSet: 分类信息集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassInfoSet: list of MediaClassInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClassInfoSet = None
        self._RequestId = None

    @property
    def ClassInfoSet(self):
        """分类信息集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of MediaClassInfo
        """
        return self._ClassInfoSet

    @ClassInfoSet.setter
    def ClassInfoSet(self, ClassInfoSet):
        self._ClassInfoSet = ClassInfoSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClassInfoSet") is not None:
            self._ClassInfoSet = []
            for item in params.get("ClassInfoSet"):
                obj = MediaClassInfo()
                obj._deserialize(item)
                self._ClassInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAnimatedGraphicsTemplatesRequest(AbstractModel):
    """DescribeAnimatedGraphicsTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 转动图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """转动图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnimatedGraphicsTemplatesResponse(AbstractModel):
    """DescribeAnimatedGraphicsTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AnimatedGraphicsTemplateSet: 转动图模板详情列表。
        :type AnimatedGraphicsTemplateSet: list of AnimatedGraphicsTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AnimatedGraphicsTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AnimatedGraphicsTemplateSet(self):
        """转动图模板详情列表。
        :rtype: list of AnimatedGraphicsTemplate
        """
        return self._AnimatedGraphicsTemplateSet

    @AnimatedGraphicsTemplateSet.setter
    def AnimatedGraphicsTemplateSet(self, AnimatedGraphicsTemplateSet):
        self._AnimatedGraphicsTemplateSet = AnimatedGraphicsTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AnimatedGraphicsTemplateSet") is not None:
            self._AnimatedGraphicsTemplateSet = []
            for item in params.get("AnimatedGraphicsTemplateSet"):
                obj = AnimatedGraphicsTemplate()
                obj._deserialize(item)
                self._AnimatedGraphicsTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCDNStatDetailsRequest(AbstractModel):
    """DescribeCDNStatDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Metric: 查询指标，取值有：
<li>Traffic：流量，单位为 Byte。</li>
<li>Bandwidth：带宽，单位为 Bps。</li>
<li>Requests：请求数。</li>
<li>QUICRequests：QUIC 请求数。</li>
<li>IpVisit：IP 访问数。</li>
        :type Metric: str
        :param _StartTime: 起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _DomainNames: 域名列表。一次最多查询20个域名的数据。默认返回所有域名叠加的用量数据。
        :type DomainNames: list of str
        :param _Area: 服务区域，取值有：
<li>Chinese Mainland：中国大陆。 </li>
<li>Asia Pacific Region 1：亚太一区，包括中国香港、中国澳门、新加坡、越南、泰国。 </li>
<li>Asia Pacific Region 2：亚太二区，包括中国台湾、日本、马来西亚、印度尼西亚、韩国。 </li>
<li>Asia Pacific Region 3：亚太三区，包括菲律宾、印度、澳大利亚和亚太其它国家和地区。 </li>
<li>Middle East：中东。 </li>
<li>Europe：欧洲。</li>
<li>North America：北美。</li>
<li>South America：南美。</li>
<li>Africa：非洲。</li>
默认为中国大陆。
        :type Area: str
        :param _Districts: 用户所在地区，Area 为 Chinese Mainland 时，取值为以下地区信息，当 Area 为其它值时， 忽略 Districts 参数。
<li>Beijing：北京。</li>
<li>Inner Mongolia：内蒙古。</li>
<li>Shanxi：山西。</li>
<li>Hebei：河北。</li>
<li>Tianjin：天津。</li>
<li>Ningxia：宁夏。</li>
<li>Shaanxi：陕西。</li>
<li>Gansu：甘肃。</li>
<li>Qinghai：青海。</li>
<li>Xinjiang：新疆。</li>
<li>Heilongjiang：黑龙江。</li>
<li>Jilin：吉林。</li>
<li>Liaoning：辽宁。</li>
<li>Fujian：福建。</li>
<li>Jiangsu：江苏。</li>
<li>Anhui：安徽。</li>
<li>Shandong：山东。</li>
<li>Shanghai：上海。</li>
<li>Zhejiang：浙江。</li>
<li>Henan：河南。</li>
<li>Hubei：湖北。</li>
<li>Jiangxi：江西。</li>
<li>Hunan：湖南。</li>
<li>Guizhou：贵州。</li>
<li>Yunnan：云南。</li>
<li>Chongqing：重庆。</li>
<li>Sichuan：四川。</li>
<li>Tibet：西藏。</li>
<li>Guangdong：广东。</li>
<li>Guangxi：广西。</li>
<li>Hainan：海南。</li>
<li>Hong Kong, Macao and Taiwan：港澳台。</li>
<li>Outside Chinese Mainland：海外。</li>
<li>Other：其他 。</li>
        :type Districts: list of str
        :param _Isps: 用户所属运营商信息，Area 为 Chinese Mainland 时，取值为以下运营商信息。当 Area 为其它值时忽略 Isps 参数。
<li>China Telecom：中国电信。 </li>
<li>China Unicom：中国联通。 </li>
<li>CERNET：教育网。</li>
<li>Great Wall Broadband Network：长城宽带。</li>
<li>China Mobile：中国移动。</li>
<li>China Mobile Tietong：中国铁通。</li>
<li>ISPs outside Chinese Mainland：海外运营商。</li>
<li>Other ISPs：其他运营商。</li>
        :type Isps: list of str
        :param _DataInterval: 每条数据的时间粒度，单位：分钟，取值有：
<li>5：5 分钟粒度，返回指定查询时间内5分钟粒度的明细数据。</li>
<li>1440：天粒度，返回指定查询时间内1天粒度的数据。起始时间和结束时间跨度大于24小时，只支持天粒度的数据。</li>
当 StartTime 和 EndTime 时间跨度大于24小时时，DataInterval 默认为 1440。
        :type DataInterval: int
        """
        self._Metric = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._DomainNames = None
        self._Area = None
        self._Districts = None
        self._Isps = None
        self._DataInterval = None

    @property
    def Metric(self):
        """查询指标，取值有：
<li>Traffic：流量，单位为 Byte。</li>
<li>Bandwidth：带宽，单位为 Bps。</li>
<li>Requests：请求数。</li>
<li>QUICRequests：QUIC 请求数。</li>
<li>IpVisit：IP 访问数。</li>
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def StartTime(self):
        """起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DomainNames(self):
        """域名列表。一次最多查询20个域名的数据。默认返回所有域名叠加的用量数据。
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames

    @property
    def Area(self):
        """服务区域，取值有：
<li>Chinese Mainland：中国大陆。 </li>
<li>Asia Pacific Region 1：亚太一区，包括中国香港、中国澳门、新加坡、越南、泰国。 </li>
<li>Asia Pacific Region 2：亚太二区，包括中国台湾、日本、马来西亚、印度尼西亚、韩国。 </li>
<li>Asia Pacific Region 3：亚太三区，包括菲律宾、印度、澳大利亚和亚太其它国家和地区。 </li>
<li>Middle East：中东。 </li>
<li>Europe：欧洲。</li>
<li>North America：北美。</li>
<li>South America：南美。</li>
<li>Africa：非洲。</li>
默认为中国大陆。
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Districts(self):
        """用户所在地区，Area 为 Chinese Mainland 时，取值为以下地区信息，当 Area 为其它值时， 忽略 Districts 参数。
<li>Beijing：北京。</li>
<li>Inner Mongolia：内蒙古。</li>
<li>Shanxi：山西。</li>
<li>Hebei：河北。</li>
<li>Tianjin：天津。</li>
<li>Ningxia：宁夏。</li>
<li>Shaanxi：陕西。</li>
<li>Gansu：甘肃。</li>
<li>Qinghai：青海。</li>
<li>Xinjiang：新疆。</li>
<li>Heilongjiang：黑龙江。</li>
<li>Jilin：吉林。</li>
<li>Liaoning：辽宁。</li>
<li>Fujian：福建。</li>
<li>Jiangsu：江苏。</li>
<li>Anhui：安徽。</li>
<li>Shandong：山东。</li>
<li>Shanghai：上海。</li>
<li>Zhejiang：浙江。</li>
<li>Henan：河南。</li>
<li>Hubei：湖北。</li>
<li>Jiangxi：江西。</li>
<li>Hunan：湖南。</li>
<li>Guizhou：贵州。</li>
<li>Yunnan：云南。</li>
<li>Chongqing：重庆。</li>
<li>Sichuan：四川。</li>
<li>Tibet：西藏。</li>
<li>Guangdong：广东。</li>
<li>Guangxi：广西。</li>
<li>Hainan：海南。</li>
<li>Hong Kong, Macao and Taiwan：港澳台。</li>
<li>Outside Chinese Mainland：海外。</li>
<li>Other：其他 。</li>
        :rtype: list of str
        """
        return self._Districts

    @Districts.setter
    def Districts(self, Districts):
        self._Districts = Districts

    @property
    def Isps(self):
        """用户所属运营商信息，Area 为 Chinese Mainland 时，取值为以下运营商信息。当 Area 为其它值时忽略 Isps 参数。
<li>China Telecom：中国电信。 </li>
<li>China Unicom：中国联通。 </li>
<li>CERNET：教育网。</li>
<li>Great Wall Broadband Network：长城宽带。</li>
<li>China Mobile：中国移动。</li>
<li>China Mobile Tietong：中国铁通。</li>
<li>ISPs outside Chinese Mainland：海外运营商。</li>
<li>Other ISPs：其他运营商。</li>
        :rtype: list of str
        """
        return self._Isps

    @Isps.setter
    def Isps(self, Isps):
        self._Isps = Isps

    @property
    def DataInterval(self):
        """每条数据的时间粒度，单位：分钟，取值有：
<li>5：5 分钟粒度，返回指定查询时间内5分钟粒度的明细数据。</li>
<li>1440：天粒度，返回指定查询时间内1天粒度的数据。起始时间和结束时间跨度大于24小时，只支持天粒度的数据。</li>
当 StartTime 和 EndTime 时间跨度大于24小时时，DataInterval 默认为 1440。
        :rtype: int
        """
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._DomainNames = params.get("DomainNames")
        self._Area = params.get("Area")
        self._Districts = params.get("Districts")
        self._Isps = params.get("Isps")
        self._DataInterval = params.get("DataInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCDNStatDetailsResponse(AbstractModel):
    """DescribeCDNStatDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInterval: 每条数据的时间粒度，单位：分钟。
        :type DataInterval: int
        :param _Data: CDN 用量数据。
        :type Data: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInterval = None
        self._Data = None
        self._RequestId = None

    @property
    def DataInterval(self):
        """每条数据的时间粒度，单位：分钟。
        :rtype: int
        """
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def Data(self):
        """CDN 用量数据。
        :rtype: list of StatDataItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataInterval = params.get("DataInterval")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCDNUsageDataRequest(AbstractModel):
    """DescribeCDNUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于开始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _DataType: CDN 统计数据类型，有效值：
<li>Flux：流量，单位为 byte。</li>
<li>Bandwidth：带宽，单位为 bps。</li>
        :type DataType: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _DataInterval: 用量数据的时间粒度，单位：分钟，取值有：
<li>5：5 分钟粒度，返回指定查询时间内5分钟粒度的明细数据。</li>
<li>60：小时粒度，返回指定查询时间内1小时粒度的数据。</li>
<li>1440：天粒度，返回指定查询时间内1天粒度的数据。</li>
默认值为1440，返回天粒度的数据。
        :type DataInterval: int
        :param _DomainNames: 域名列表。一次最多查询20个域名的用量数据。可以指定多个域名，查询这些域名叠加的用量数据。默认返回所有域名叠加的用量数据。
        :type DomainNames: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._DataType = None
        self._SubAppId = None
        self._DataInterval = None
        self._DomainNames = None

    @property
    def StartTime(self):
        """起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束日期，需大于开始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataType(self):
        """CDN 统计数据类型，有效值：
<li>Flux：流量，单位为 byte。</li>
<li>Bandwidth：带宽，单位为 bps。</li>
        :rtype: str
        """
        return self._DataType

    @DataType.setter
    def DataType(self, DataType):
        self._DataType = DataType

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DataInterval(self):
        """用量数据的时间粒度，单位：分钟，取值有：
<li>5：5 分钟粒度，返回指定查询时间内5分钟粒度的明细数据。</li>
<li>60：小时粒度，返回指定查询时间内1小时粒度的数据。</li>
<li>1440：天粒度，返回指定查询时间内1天粒度的数据。</li>
默认值为1440，返回天粒度的数据。
        :rtype: int
        """
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def DomainNames(self):
        """域名列表。一次最多查询20个域名的用量数据。可以指定多个域名，查询这些域名叠加的用量数据。默认返回所有域名叠加的用量数据。
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataType = params.get("DataType")
        self._SubAppId = params.get("SubAppId")
        self._DataInterval = params.get("DataInterval")
        self._DomainNames = params.get("DomainNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCDNUsageDataResponse(AbstractModel):
    """DescribeCDNUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInterval: 时间粒度，单位：分钟。
        :type DataInterval: int
        :param _Data: CDN 统计数据。
        :type Data: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInterval = None
        self._Data = None
        self._RequestId = None

    @property
    def DataInterval(self):
        """时间粒度，单位：分钟。
        :rtype: int
        """
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def Data(self):
        """CDN 统计数据。
        :rtype: list of StatDataItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataInterval = params.get("DataInterval")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCLSLogsetsRequest(AbstractModel):
    """DescribeCLSLogsets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        """
        self._CLSRegion = None

    @property
    def CLSRegion(self):
        """日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCLSLogsetsResponse(AbstractModel):
    """DescribeCLSLogsets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Logsets: 查询到的日志集列表。
        :type Logsets: list of CLSLogsetInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Logsets = None
        self._RequestId = None

    @property
    def Logsets(self):
        """查询到的日志集列表。
        :rtype: list of CLSLogsetInfo
        """
        return self._Logsets

    @Logsets.setter
    def Logsets(self, Logsets):
        self._Logsets = Logsets

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Logsets") is not None:
            self._Logsets = []
            for item in params.get("Logsets"):
                obj = CLSLogsetInfo()
                obj._deserialize(item)
                self._Logsets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCLSPushTargetsRequest(AbstractModel):
    """DescribeCLSPushTargets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domains: 点播域名。
        :type Domains: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Domains = None
        self._SubAppId = None

    @property
    def Domains(self):
        """点播域名。
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domains = params.get("Domains")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCLSPushTargetsResponse(AbstractModel):
    """DescribeCLSPushTargets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 域名推送总数量。
        :type TotalCount: int
        :param _DomainCLSTargets: 域名推送 CLS 目标列表。
        :type DomainCLSTargets: list of DomainCLSTargetInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._DomainCLSTargets = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """域名推送总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DomainCLSTargets(self):
        """域名推送 CLS 目标列表。
        :rtype: list of DomainCLSTargetInfo
        """
        return self._DomainCLSTargets

    @DomainCLSTargets.setter
    def DomainCLSTargets(self, DomainCLSTargets):
        self._DomainCLSTargets = DomainCLSTargets

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DomainCLSTargets") is not None:
            self._DomainCLSTargets = []
            for item in params.get("DomainCLSTargets"):
                obj = DomainCLSTargetInfo()
                obj._deserialize(item)
                self._DomainCLSTargets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCLSTopicsRequest(AbstractModel):
    """DescribeCLSTopics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        :param _LogsetId: 日志主题所属日志集 ID。
        :type LogsetId: str
        :param _TopicIds: 日志主题 ID 列表。如果不填，表示查询所有的日志主题。
        :type TopicIds: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：20，最大值：100。
        :type Limit: int
        """
        self._CLSRegion = None
        self._LogsetId = None
        self._TopicIds = None
        self._Offset = None
        self._Limit = None

    @property
    def CLSRegion(self):
        """日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def LogsetId(self):
        """日志主题所属日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def TopicIds(self):
        """日志主题 ID 列表。如果不填，表示查询所有的日志主题。
        :rtype: list of str
        """
        return self._TopicIds

    @TopicIds.setter
    def TopicIds(self, TopicIds):
        self._TopicIds = TopicIds

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：20，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._LogsetId = params.get("LogsetId")
        self._TopicIds = params.get("TopicIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCLSTopicsResponse(AbstractModel):
    """DescribeCLSTopics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 日志主题总数量。
        :type TotalCount: int
        :param _Topics: 日志主题列表。
        :type Topics: list of CLSTopicInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Topics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """日志主题总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Topics(self):
        """日志主题列表。
        :rtype: list of CLSTopicInfo
        """
        return self._Topics

    @Topics.setter
    def Topics(self, Topics):
        self._Topics = Topics

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Topics") is not None:
            self._Topics = []
            for item in params.get("Topics"):
                obj = CLSTopicInfo()
                obj._deserialize(item)
                self._Topics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCdnLogsRequest(AbstractModel):
    """DescribeCdnLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        :param _StartTime: 获取日志起始时间点，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type StartTime: str
        :param _EndTime: 结束时间需大于起始时间；使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Limit: 分页拉取的最大返回结果数。默认值：100；最大值：1000。
        :type Limit: int
        :param _Offset: 分页拉取的起始偏移量。默认值：0。
        :type Offset: int
        """
        self._DomainName = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Limit = None
        self._Offset = None

    @property
    def DomainName(self):
        """域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StartTime(self):
        """获取日志起始时间点，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间需大于起始时间；使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Limit(self):
        """分页拉取的最大返回结果数。默认值：100；最大值：1000。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """分页拉取的起始偏移量。默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCdnLogsResponse(AbstractModel):
    """DescribeCdnLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 日志下载链接总数量。
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _OverseaCdnLogs: 海外CDN节点的日志下载列表。如果域名没有开启海外加速，忽略该参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type OverseaCdnLogs: list of CdnLogInfo
        :param _DomesticCdnLogs: 国内CDN节点的日志下载列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type DomesticCdnLogs: list of CdnLogInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._OverseaCdnLogs = None
        self._DomesticCdnLogs = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """日志下载链接总数量。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def OverseaCdnLogs(self):
        """海外CDN节点的日志下载列表。如果域名没有开启海外加速，忽略该参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CdnLogInfo
        """
        return self._OverseaCdnLogs

    @OverseaCdnLogs.setter
    def OverseaCdnLogs(self, OverseaCdnLogs):
        self._OverseaCdnLogs = OverseaCdnLogs

    @property
    def DomesticCdnLogs(self):
        """国内CDN节点的日志下载列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CdnLogInfo
        """
        return self._DomesticCdnLogs

    @DomesticCdnLogs.setter
    def DomesticCdnLogs(self, DomesticCdnLogs):
        self._DomesticCdnLogs = DomesticCdnLogs

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("OverseaCdnLogs") is not None:
            self._OverseaCdnLogs = []
            for item in params.get("OverseaCdnLogs"):
                obj = CdnLogInfo()
                obj._deserialize(item)
                self._OverseaCdnLogs.append(obj)
        if params.get("DomesticCdnLogs") is not None:
            self._DomesticCdnLogs = []
            for item in params.get("DomesticCdnLogs"):
                obj = CdnLogInfo()
                obj._deserialize(item)
                self._DomesticCdnLogs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClientUploadAccelerationUsageDataRequest(AbstractModel):
    """DescribeClientUploadAccelerationUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 客户端上传加速类型，取值有：
<li> AccelerationWithHTTP：HTTP 传输方式的上传加速。</li>
<li> AccelerationWithQUIC：QUIC 传输方式的上传加速。</li>
默认查询所有加速类型的用量 。
        :type Type: str
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Type = None

    @property
    def StartTime(self):
        """起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        """客户端上传加速类型，取值有：
<li> AccelerationWithHTTP：HTTP 传输方式的上传加速。</li>
<li> AccelerationWithQUIC：QUIC 传输方式的上传加速。</li>
默认查询所有加速类型的用量 。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClientUploadAccelerationUsageDataResponse(AbstractModel):
    """DescribeClientUploadAccelerationUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClientUploadAccelerationUsageDataSet: 客户端上传加速统计数据。
        :type ClientUploadAccelerationUsageDataSet: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClientUploadAccelerationUsageDataSet = None
        self._RequestId = None

    @property
    def ClientUploadAccelerationUsageDataSet(self):
        """客户端上传加速统计数据。
        :rtype: list of StatDataItem
        """
        return self._ClientUploadAccelerationUsageDataSet

    @ClientUploadAccelerationUsageDataSet.setter
    def ClientUploadAccelerationUsageDataSet(self, ClientUploadAccelerationUsageDataSet):
        self._ClientUploadAccelerationUsageDataSet = ClientUploadAccelerationUsageDataSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClientUploadAccelerationUsageDataSet") is not None:
            self._ClientUploadAccelerationUsageDataSet = []
            for item in params.get("ClientUploadAccelerationUsageDataSet"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._ClientUploadAccelerationUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentReviewTemplatesRequest(AbstractModel):
    """DescribeContentReviewTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 内容审核模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """内容审核模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentReviewTemplatesResponse(AbstractModel):
    """DescribeContentReviewTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ContentReviewTemplateSet: 内容审核模板详情列表。
        :type ContentReviewTemplateSet: list of ContentReviewTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ContentReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ContentReviewTemplateSet(self):
        """内容审核模板详情列表。
        :rtype: list of ContentReviewTemplateItem
        """
        return self._ContentReviewTemplateSet

    @ContentReviewTemplateSet.setter
    def ContentReviewTemplateSet(self, ContentReviewTemplateSet):
        self._ContentReviewTemplateSet = ContentReviewTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ContentReviewTemplateSet") is not None:
            self._ContentReviewTemplateSet = []
            for item in params.get("ContentReviewTemplateSet"):
                obj = ContentReviewTemplateItem()
                obj._deserialize(item)
                self._ContentReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCurrentPlaylistRequest(AbstractModel):
    """DescribeCurrentPlaylist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。</b>
        :type SubAppId: int
        :param _RoundPlayId: 轮播播单唯一标识。
        :type RoundPlayId: str
        :param _Limit: 返回的播放列表的长度。最大10，默认值为5。
        :type Limit: int
        """
        self._SubAppId = None
        self._RoundPlayId = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def RoundPlayId(self):
        """轮播播单唯一标识。
        :rtype: str
        """
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def Limit(self):
        """返回的播放列表的长度。最大10，默认值为5。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._RoundPlayId = params.get("RoundPlayId")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCurrentPlaylistResponse(AbstractModel):
    """DescribeCurrentPlaylist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentPlaylist: 当前播放列表信息。
        :type CurrentPlaylist: list of RoundPlayFilePlayInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CurrentPlaylist = None
        self._RequestId = None

    @property
    def CurrentPlaylist(self):
        """当前播放列表信息。
        :rtype: list of RoundPlayFilePlayInfo
        """
        return self._CurrentPlaylist

    @CurrentPlaylist.setter
    def CurrentPlaylist(self, CurrentPlaylist):
        self._CurrentPlaylist = CurrentPlaylist

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CurrentPlaylist") is not None:
            self._CurrentPlaylist = []
            for item in params.get("CurrentPlaylist"):
                obj = RoundPlayFilePlayInfo()
                obj._deserialize(item)
                self._CurrentPlaylist.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDailyMediaPlayStatRequest(AbstractModel):
    """DescribeDailyMediaPlayStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件 ID 。
        :type FileId: str
        :param _StartDate: 起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :type StartDate: str
        :param _EndDate: 结束日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :type EndDate: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._FileId = None
        self._StartDate = None
        self._EndDate = None
        self._SubAppId = None

    @property
    def FileId(self):
        """媒体文件 ID 。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartDate(self):
        """起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :rtype: str
        """
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        """结束日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDailyMediaPlayStatResponse(AbstractModel):
    """DescribeDailyMediaPlayStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DailyPlayStatInfoSet: 播放统计数据。
        :type DailyPlayStatInfoSet: list of DailyPlayStatInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DailyPlayStatInfoSet = None
        self._RequestId = None

    @property
    def DailyPlayStatInfoSet(self):
        """播放统计数据。
        :rtype: list of DailyPlayStatInfo
        """
        return self._DailyPlayStatInfoSet

    @DailyPlayStatInfoSet.setter
    def DailyPlayStatInfoSet(self, DailyPlayStatInfoSet):
        self._DailyPlayStatInfoSet = DailyPlayStatInfoSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DailyPlayStatInfoSet") is not None:
            self._DailyPlayStatInfoSet = []
            for item in params.get("DailyPlayStatInfoSet"):
                obj = DailyPlayStatInfo()
                obj._deserialize(item)
                self._DailyPlayStatInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDailyMostPlayedStatRequest(AbstractModel):
    """DescribeDailyMostPlayedStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Date: 查询日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :type Date: str
        :param _DomainName: 域名。查询该域名播放 Top100 的媒体文件的统计数据。默认查询所有域名的播放统计数据。
        :type DomainName: str
        :param _Metric: Top 数据的统计指标，取值有：
<li>Traffic：播放流量，按播放流量统计 Top100 的数据。</li>
<li>PlayTimes：播放次数，按播放次数统计播放 Top100 的数据。</li>
默认值为Traffic。
        :type Metric: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Date = None
        self._DomainName = None
        self._Metric = None
        self._SubAppId = None

    @property
    def Date(self):
        """查询日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :rtype: str
        """
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def DomainName(self):
        """域名。查询该域名播放 Top100 的媒体文件的统计数据。默认查询所有域名的播放统计数据。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Metric(self):
        """Top 数据的统计指标，取值有：
<li>Traffic：播放流量，按播放流量统计 Top100 的数据。</li>
<li>PlayTimes：播放次数，按播放次数统计播放 Top100 的数据。</li>
默认值为Traffic。
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._DomainName = params.get("DomainName")
        self._Metric = params.get("Metric")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDailyMostPlayedStatResponse(AbstractModel):
    """DescribeDailyMostPlayedStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DailyPlayStatInfoSet: 媒体文件播放统计信息。
        :type DailyPlayStatInfoSet: list of DailyPlayStatInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DailyPlayStatInfoSet = None
        self._RequestId = None

    @property
    def DailyPlayStatInfoSet(self):
        """媒体文件播放统计信息。
        :rtype: list of DailyPlayStatInfo
        """
        return self._DailyPlayStatInfoSet

    @DailyPlayStatInfoSet.setter
    def DailyPlayStatInfoSet(self, DailyPlayStatInfoSet):
        self._DailyPlayStatInfoSet = DailyPlayStatInfoSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DailyPlayStatInfoSet") is not None:
            self._DailyPlayStatInfoSet = []
            for item in params.get("DailyPlayStatInfoSet"):
                obj = DailyPlayStatInfo()
                obj._deserialize(item)
                self._DailyPlayStatInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDailyPlayStatFileListRequest(AbstractModel):
    """DescribeDailyPlayStatFileList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        """起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDailyPlayStatFileListResponse(AbstractModel):
    """DescribeDailyPlayStatFileList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PlayStatFileSet: 播放统计文件列表。
        :type PlayStatFileSet: list of PlayStatFileInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PlayStatFileSet = None
        self._RequestId = None

    @property
    def PlayStatFileSet(self):
        """播放统计文件列表。
        :rtype: list of PlayStatFileInfo
        """
        return self._PlayStatFileSet

    @PlayStatFileSet.setter
    def PlayStatFileSet(self, PlayStatFileSet):
        self._PlayStatFileSet = PlayStatFileSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PlayStatFileSet") is not None:
            self._PlayStatFileSet = []
            for item in params.get("PlayStatFileSet"):
                obj = PlayStatFileInfo()
                obj._deserialize(item)
                self._PlayStatFileSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDefaultDistributionConfigRequest(AbstractModel):
    """DescribeDefaultDistributionConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDefaultDistributionConfigResponse(AbstractModel):
    """DescribeDefaultDistributionConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 分发配置的域名(已废弃）。
        :type DomainName: str
        :param _Domain: 分发配置的域名。
        :type Domain: str
        :param _Scheme: 分发配置的协议，为 HTTP 或 HTTPS。
        :type Scheme: str
        :param _PlayKey: 播放密钥，由大小写字母（a - Z）或者数字（0 - 9）组成，长度在8 - 20个字符之间。
        :type PlayKey: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DomainName = None
        self._Domain = None
        self._Scheme = None
        self._PlayKey = None
        self._RequestId = None

    @property
    def DomainName(self):
        warnings.warn("parameter `DomainName` is deprecated", DeprecationWarning) 

        """分发配置的域名(已废弃）。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        warnings.warn("parameter `DomainName` is deprecated", DeprecationWarning) 

        self._DomainName = DomainName

    @property
    def Domain(self):
        """分发配置的域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Scheme(self):
        """分发配置的协议，为 HTTP 或 HTTPS。
        :rtype: str
        """
        return self._Scheme

    @Scheme.setter
    def Scheme(self, Scheme):
        self._Scheme = Scheme

    @property
    def PlayKey(self):
        """播放密钥，由大小写字母（a - Z）或者数字（0 - 9）组成，长度在8 - 20个字符之间。
        :rtype: str
        """
        return self._PlayKey

    @PlayKey.setter
    def PlayKey(self, PlayKey):
        self._PlayKey = PlayKey

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Domain = params.get("Domain")
        self._Scheme = params.get("Scheme")
        self._PlayKey = params.get("PlayKey")
        self._RequestId = params.get("RequestId")


class DescribeDrmDataKeyRequest(AbstractModel):
    """DescribeDrmDataKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EdkList: 加密后的数据密钥列表，最大支持10个。
        :type EdkList: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._EdkList = None
        self._SubAppId = None

    @property
    def EdkList(self):
        """加密后的数据密钥列表，最大支持10个。
        :rtype: list of str
        """
        return self._EdkList

    @EdkList.setter
    def EdkList(self, EdkList):
        self._EdkList = EdkList

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._EdkList = params.get("EdkList")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrmDataKeyResponse(AbstractModel):
    """DescribeDrmDataKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _KeyList: 密钥列表，包含加密的数据密钥。
        :type KeyList: list of SimpleAesEdkPair
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._KeyList = None
        self._RequestId = None

    @property
    def KeyList(self):
        """密钥列表，包含加密的数据密钥。
        :rtype: list of SimpleAesEdkPair
        """
        return self._KeyList

    @KeyList.setter
    def KeyList(self, KeyList):
        self._KeyList = KeyList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("KeyList") is not None:
            self._KeyList = []
            for item in params.get("KeyList"):
                obj = SimpleAesEdkPair()
                obj._deserialize(item)
                self._KeyList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDrmKeyProviderInfoRequest(AbstractModel):
    """DescribeDrmKeyProviderInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrmKeyProviderInfoResponse(AbstractModel):
    """DescribeDrmKeyProviderInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SDMCInfo: 华曦达（SDMC）相关的 DRM 密钥提供商信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type SDMCInfo: :class:`tencentcloud.vod.v20180717.models.SDMCDrmKeyProviderInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SDMCInfo = None
        self._RequestId = None

    @property
    def SDMCInfo(self):
        """华曦达（SDMC）相关的 DRM 密钥提供商信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SDMCDrmKeyProviderInfo`
        """
        return self._SDMCInfo

    @SDMCInfo.setter
    def SDMCInfo(self, SDMCInfo):
        self._SDMCInfo = SDMCInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SDMCInfo") is not None:
            self._SDMCInfo = SDMCDrmKeyProviderInfo()
            self._SDMCInfo._deserialize(params.get("SDMCInfo"))
        self._RequestId = params.get("RequestId")


class DescribeEnhanceMediaTemplatesRequest(AbstractModel):
    """DescribeEnhanceMediaTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 音画质重生模板列表。长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """音画质重生模板列表。长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnhanceMediaTemplatesResponse(AbstractModel):
    """DescribeEnhanceMediaTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _RebuildMediaTemplateSet: 音画质重生模板详情列表。
        :type RebuildMediaTemplateSet: list of RebuildMediaTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RebuildMediaTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RebuildMediaTemplateSet(self):
        """音画质重生模板详情列表。
        :rtype: list of RebuildMediaTemplate
        """
        return self._RebuildMediaTemplateSet

    @RebuildMediaTemplateSet.setter
    def RebuildMediaTemplateSet(self, RebuildMediaTemplateSet):
        self._RebuildMediaTemplateSet = RebuildMediaTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RebuildMediaTemplateSet") is not None:
            self._RebuildMediaTemplateSet = []
            for item in params.get("RebuildMediaTemplateSet"):
                obj = RebuildMediaTemplate()
                obj._deserialize(item)
                self._RebuildMediaTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEventConfigRequest(AbstractModel):
    """DescribeEventConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventConfigResponse(AbstractModel):
    """DescribeEventConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Mode: 接收事件通知的方式。"PUSH" 为 [HTTP 回调通知](https://cloud.tencent.com/document/product/266/7829#http.E5.9B.9E.E8.B0.83)，"PULL" 为 [基于消息队列的可靠通知](https://cloud.tencent.com/document/product/266/7829#.E5.9F.BA.E4.BA.8E.E6.B6.88.E6.81.AF.E9.98.9F.E5.88.97.E7.9A.84.E5.8F.AF.E9.9D.A0.E9.80.9A.E7.9F.A5)。
        :type Mode: str
        :param _NotificationUrl: 采用 [HTTP 回调通知](https://cloud.tencent.com/document/product/266/7829#http.E5.9B.9E.E8.B0.83) 接收方式时，用于接收 V3 版本事件通知的地址。
        :type NotificationUrl: str
        :param _UploadMediaCompleteEventSwitch: 是否接收 [视频上传完成](https://cloud.tencent.com/document/product/266/7830) 事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :type UploadMediaCompleteEventSwitch: str
        :param _DeleteMediaCompleteEventSwitch: 是否接收 [视频删除完成](https://cloud.tencent.com/document/product/266/13434) 事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :type DeleteMediaCompleteEventSwitch: str
        :param _PersistenceCompleteEventSwitch: 是否接收剪辑固化完成事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :type PersistenceCompleteEventSwitch: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Mode = None
        self._NotificationUrl = None
        self._UploadMediaCompleteEventSwitch = None
        self._DeleteMediaCompleteEventSwitch = None
        self._PersistenceCompleteEventSwitch = None
        self._RequestId = None

    @property
    def Mode(self):
        """接收事件通知的方式。"PUSH" 为 [HTTP 回调通知](https://cloud.tencent.com/document/product/266/7829#http.E5.9B.9E.E8.B0.83)，"PULL" 为 [基于消息队列的可靠通知](https://cloud.tencent.com/document/product/266/7829#.E5.9F.BA.E4.BA.8E.E6.B6.88.E6.81.AF.E9.98.9F.E5.88.97.E7.9A.84.E5.8F.AF.E9.9D.A0.E9.80.9A.E7.9F.A5)。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def NotificationUrl(self):
        """采用 [HTTP 回调通知](https://cloud.tencent.com/document/product/266/7829#http.E5.9B.9E.E8.B0.83) 接收方式时，用于接收 V3 版本事件通知的地址。
        :rtype: str
        """
        return self._NotificationUrl

    @NotificationUrl.setter
    def NotificationUrl(self, NotificationUrl):
        self._NotificationUrl = NotificationUrl

    @property
    def UploadMediaCompleteEventSwitch(self):
        """是否接收 [视频上传完成](https://cloud.tencent.com/document/product/266/7830) 事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :rtype: str
        """
        return self._UploadMediaCompleteEventSwitch

    @UploadMediaCompleteEventSwitch.setter
    def UploadMediaCompleteEventSwitch(self, UploadMediaCompleteEventSwitch):
        self._UploadMediaCompleteEventSwitch = UploadMediaCompleteEventSwitch

    @property
    def DeleteMediaCompleteEventSwitch(self):
        """是否接收 [视频删除完成](https://cloud.tencent.com/document/product/266/13434) 事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :rtype: str
        """
        return self._DeleteMediaCompleteEventSwitch

    @DeleteMediaCompleteEventSwitch.setter
    def DeleteMediaCompleteEventSwitch(self, DeleteMediaCompleteEventSwitch):
        self._DeleteMediaCompleteEventSwitch = DeleteMediaCompleteEventSwitch

    @property
    def PersistenceCompleteEventSwitch(self):
        """是否接收剪辑固化完成事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :rtype: str
        """
        return self._PersistenceCompleteEventSwitch

    @PersistenceCompleteEventSwitch.setter
    def PersistenceCompleteEventSwitch(self, PersistenceCompleteEventSwitch):
        self._PersistenceCompleteEventSwitch = PersistenceCompleteEventSwitch

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._NotificationUrl = params.get("NotificationUrl")
        self._UploadMediaCompleteEventSwitch = params.get("UploadMediaCompleteEventSwitch")
        self._DeleteMediaCompleteEventSwitch = params.get("DeleteMediaCompleteEventSwitch")
        self._PersistenceCompleteEventSwitch = params.get("PersistenceCompleteEventSwitch")
        self._RequestId = params.get("RequestId")


class DescribeEventsStateRequest(AbstractModel):
    """DescribeEventsState请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventsStateResponse(AbstractModel):
    """DescribeEventsState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CountOfEventsToPull: 待进行拉取的事件通知数，为近似值，约5秒延迟。
        :type CountOfEventsToPull: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CountOfEventsToPull = None
        self._RequestId = None

    @property
    def CountOfEventsToPull(self):
        """待进行拉取的事件通知数，为近似值，约5秒延迟。
        :rtype: int
        """
        return self._CountOfEventsToPull

    @CountOfEventsToPull.setter
    def CountOfEventsToPull(self, CountOfEventsToPull):
        self._CountOfEventsToPull = CountOfEventsToPull

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CountOfEventsToPull = params.get("CountOfEventsToPull")
        self._RequestId = params.get("RequestId")


class DescribeFileAttributesRequest(AbstractModel):
    """DescribeFileAttributes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件 ID
        :type FileId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _SessionId: 用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        :param _TasksPriority: 任务优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :type TasksPriority: int
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        """
        self._FileId = None
        self._SubAppId = None
        self._SessionId = None
        self._SessionContext = None
        self._TasksPriority = None
        self._ExtInfo = None

    @property
    def FileId(self):
        """媒体文件 ID
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SessionId(self):
        """用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        """来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        """任务优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        """保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SubAppId = params.get("SubAppId")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileAttributesResponse(AbstractModel):
    """DescribeFileAttributes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID 。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务 ID 。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeFileAttributesTask(AbstractModel):
    """获取文件属性任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败：
<li>40000：输入参数不合法，请检查输入参数；</li>
<li>60000：源文件错误（如视频数据损坏），请确认源文件是否正常；</li>
<li>70000：内部服务错误，建议重试。</li>
        :type ErrCode: int
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _Message: 错误信息。
        :type Message: str
        :param _Progress: 任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _FileId: 媒体文件 ID。
        :type FileId: str
        :param _Output: 获取媒体文件属性任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTaskOutput`
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._ErrCodeExt = None
        self._Message = None
        self._Progress = None
        self._FileId = None
        self._Output = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        """任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        """任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        """错误码，0 表示成功，其他值表示失败：
<li>40000：输入参数不合法，请检查输入参数；</li>
<li>60000：源文件错误（如视频数据损坏），请确认源文件是否正常；</li>
<li>70000：内部服务错误，建议重试。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrCodeExt(self):
        """错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Message(self):
        """错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        """任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def FileId(self):
        """媒体文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Output(self):
        """获取媒体文件属性任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SessionId(self):
        """用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        """来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        self._FileId = params.get("FileId")
        if params.get("Output") is not None:
            self._Output = DescribeFileAttributesTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileAttributesTaskOutput(AbstractModel):
    """获取文件属性任务输出

    """

    def __init__(self):
        r"""
        :param _Md5: 媒体文件的 Md5 值。
        :type Md5: str
        :param _Sha1: 媒体文件的 Sha1 值。
        :type Sha1: str
        """
        self._Md5 = None
        self._Sha1 = None

    @property
    def Md5(self):
        """媒体文件的 Md5 值。
        :rtype: str
        """
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Sha1(self):
        """媒体文件的 Sha1 值。
        :rtype: str
        """
        return self._Sha1

    @Sha1.setter
    def Sha1(self, Sha1):
        self._Sha1 = Sha1


    def _deserialize(self, params):
        self._Md5 = params.get("Md5")
        self._Sha1 = params.get("Sha1")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHeadTailTemplatesRequest(AbstractModel):
    """DescribeHeadTailTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 片头片尾模板号，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """片头片尾模板号，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHeadTailTemplatesResponse(AbstractModel):
    """DescribeHeadTailTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _HeadTailTemplateSet: 片头片尾模板详情列表。
        :type HeadTailTemplateSet: list of HeadTailTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._HeadTailTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HeadTailTemplateSet(self):
        """片头片尾模板详情列表。
        :rtype: list of HeadTailTemplate
        """
        return self._HeadTailTemplateSet

    @HeadTailTemplateSet.setter
    def HeadTailTemplateSet(self, HeadTailTemplateSet):
        self._HeadTailTemplateSet = HeadTailTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HeadTailTemplateSet") is not None:
            self._HeadTailTemplateSet = []
            for item in params.get("HeadTailTemplateSet"):
                obj = HeadTailTemplate()
                obj._deserialize(item)
                self._HeadTailTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageProcessingTemplatesRequest(AbstractModel):
    """DescribeImageProcessingTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 图片处理模板标识列表。长度限制：100。
        :type Definitions: list of int non-negative
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """图片处理模板标识列表。长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageProcessingTemplatesResponse(AbstractModel):
    """DescribeImageProcessingTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ImageProcessingTemplateSet: 图片处理模板详情列表。
        :type ImageProcessingTemplateSet: list of ImageProcessingTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageProcessingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageProcessingTemplateSet(self):
        """图片处理模板详情列表。
        :rtype: list of ImageProcessingTemplate
        """
        return self._ImageProcessingTemplateSet

    @ImageProcessingTemplateSet.setter
    def ImageProcessingTemplateSet(self, ImageProcessingTemplateSet):
        self._ImageProcessingTemplateSet = ImageProcessingTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageProcessingTemplateSet") is not None:
            self._ImageProcessingTemplateSet = []
            for item in params.get("ImageProcessingTemplateSet"):
                obj = ImageProcessingTemplate()
                obj._deserialize(item)
                self._ImageProcessingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageReviewUsageDataRequest(AbstractModel):
    """DescribeImageReviewUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        """起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageReviewUsageDataResponse(AbstractModel):
    """DescribeImageReviewUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageReviewUsageDataSet: 图片审核次数统计数据，展示查询时间范围内的图片审核次数的概览数据。
        :type ImageReviewUsageDataSet: list of ImageReviewUsageDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageReviewUsageDataSet = None
        self._RequestId = None

    @property
    def ImageReviewUsageDataSet(self):
        """图片审核次数统计数据，展示查询时间范围内的图片审核次数的概览数据。
        :rtype: list of ImageReviewUsageDataItem
        """
        return self._ImageReviewUsageDataSet

    @ImageReviewUsageDataSet.setter
    def ImageReviewUsageDataSet(self, ImageReviewUsageDataSet):
        self._ImageReviewUsageDataSet = ImageReviewUsageDataSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageReviewUsageDataSet") is not None:
            self._ImageReviewUsageDataSet = []
            for item in params.get("ImageReviewUsageDataSet"):
                obj = ImageReviewUsageDataItem()
                obj._deserialize(item)
                self._ImageReviewUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageSpriteTemplatesRequest(AbstractModel):
    """DescribeImageSpriteTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 雪碧图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """雪碧图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesResponse(AbstractModel):
    """DescribeImageSpriteTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ImageSpriteTemplateSet: 雪碧图模板详情列表。
        :type ImageSpriteTemplateSet: list of ImageSpriteTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageSpriteTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteTemplateSet(self):
        """雪碧图模板详情列表。
        :rtype: list of ImageSpriteTemplate
        """
        return self._ImageSpriteTemplateSet

    @ImageSpriteTemplateSet.setter
    def ImageSpriteTemplateSet(self, ImageSpriteTemplateSet):
        self._ImageSpriteTemplateSet = ImageSpriteTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageSpriteTemplateSet") is not None:
            self._ImageSpriteTemplateSet = []
            for item in params.get("ImageSpriteTemplateSet"):
                obj = ImageSpriteTemplate()
                obj._deserialize(item)
                self._ImageSpriteTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeJustInTimeTranscodeTemplatesRequest(AbstractModel):
    """DescribeJustInTimeTranscodeTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Names: 模板名过滤条件，数组长度限制：100。
        :type Names: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置任务流模板；</li>
<li>Custom：用户自定义任务流模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._Names = None
        self._SubAppId = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Names(self):
        """模板名过滤条件，数组长度限制：100。
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置任务流模板；</li>
<li>Custom：用户自定义任务流模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Names = params.get("Names")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJustInTimeTranscodeTemplatesResponse(AbstractModel):
    """DescribeJustInTimeTranscodeTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _JustInTimeTranscodeTemplateSet: 模板详情列表。
        :type JustInTimeTranscodeTemplateSet: list of JustInTimeTranscodeTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._JustInTimeTranscodeTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def JustInTimeTranscodeTemplateSet(self):
        """模板详情列表。
        :rtype: list of JustInTimeTranscodeTemplate
        """
        return self._JustInTimeTranscodeTemplateSet

    @JustInTimeTranscodeTemplateSet.setter
    def JustInTimeTranscodeTemplateSet(self, JustInTimeTranscodeTemplateSet):
        self._JustInTimeTranscodeTemplateSet = JustInTimeTranscodeTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("JustInTimeTranscodeTemplateSet") is not None:
            self._JustInTimeTranscodeTemplateSet = []
            for item in params.get("JustInTimeTranscodeTemplateSet"):
                obj = JustInTimeTranscodeTemplate()
                obj._deserialize(item)
                self._JustInTimeTranscodeTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLicenseUsageDataRequest(AbstractModel):
    """DescribeLicenseUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _LicenseType: License 类型，默认为 DRM 。目前支持的 License 类型包括：
<li> DRM: DRM 加密播放 License</li>
        :type LicenseType: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._LicenseType = None
        self._SubAppId = None

    @property
    def StartTime(self):
        """起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def LicenseType(self):
        """License 类型，默认为 DRM 。目前支持的 License 类型包括：
<li> DRM: DRM 加密播放 License</li>
        :rtype: str
        """
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._LicenseType = params.get("LicenseType")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseUsageDataResponse(AbstractModel):
    """DescribeLicenseUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LicenseUsageDataSet: License 查询次数统计数据，展示所查询 License 次数的明细数据。
        :type LicenseUsageDataSet: list of LicenseUsageDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LicenseUsageDataSet = None
        self._RequestId = None

    @property
    def LicenseUsageDataSet(self):
        """License 查询次数统计数据，展示所查询 License 次数的明细数据。
        :rtype: list of LicenseUsageDataItem
        """
        return self._LicenseUsageDataSet

    @LicenseUsageDataSet.setter
    def LicenseUsageDataSet(self, LicenseUsageDataSet):
        self._LicenseUsageDataSet = LicenseUsageDataSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LicenseUsageDataSet") is not None:
            self._LicenseUsageDataSet = []
            for item in params.get("LicenseUsageDataSet"):
                obj = LicenseUsageDataItem()
                obj._deserialize(item)
                self._LicenseUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaInfosRequest(AbstractModel):
    """DescribeMediaInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileIds: 媒体文件 ID 列表，N 从 0 开始取值，最大 19。
        :type FileIds: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Filters: 指定所有媒体文件需要返回的信息，可同时指定多个信息，N 从 0 开始递增。如果未填写该字段，默认返回所有信息。选项有：
<li>basicInfo（视频基础信息）。</li>
<li>metaData（视频元信息）。</li>
<li>transcodeInfo（视频转码结果信息）。</li>
<li>animatedGraphicsInfo（视频转动图结果信息）。</li>
<li>imageSpriteInfo（视频雪碧图信息）。</li>
<li>snapshotByTimeOffsetInfo（视频指定时间点截图信息）。</li>
<li>sampleSnapshotInfo（采样截图信息）。</li>
<li>keyFrameDescInfo（打点信息）。</li>
<li>adaptiveDynamicStreamingInfo（转自适应码流信息）。</li>
<li>miniProgramReviewInfo（小程序审核信息）。</li>
<li>subtitleInfo（字幕信息）。</li>
<li>reviewInfo（审核信息）。</li>
        :type Filters: list of str
        """
        self._FileIds = None
        self._SubAppId = None
        self._Filters = None

    @property
    def FileIds(self):
        """媒体文件 ID 列表，N 从 0 开始取值，最大 19。
        :rtype: list of str
        """
        return self._FileIds

    @FileIds.setter
    def FileIds(self, FileIds):
        self._FileIds = FileIds

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Filters(self):
        """指定所有媒体文件需要返回的信息，可同时指定多个信息，N 从 0 开始递增。如果未填写该字段，默认返回所有信息。选项有：
<li>basicInfo（视频基础信息）。</li>
<li>metaData（视频元信息）。</li>
<li>transcodeInfo（视频转码结果信息）。</li>
<li>animatedGraphicsInfo（视频转动图结果信息）。</li>
<li>imageSpriteInfo（视频雪碧图信息）。</li>
<li>snapshotByTimeOffsetInfo（视频指定时间点截图信息）。</li>
<li>sampleSnapshotInfo（采样截图信息）。</li>
<li>keyFrameDescInfo（打点信息）。</li>
<li>adaptiveDynamicStreamingInfo（转自适应码流信息）。</li>
<li>miniProgramReviewInfo（小程序审核信息）。</li>
<li>subtitleInfo（字幕信息）。</li>
<li>reviewInfo（审核信息）。</li>
        :rtype: list of str
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._FileIds = params.get("FileIds")
        self._SubAppId = params.get("SubAppId")
        self._Filters = params.get("Filters")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaInfosResponse(AbstractModel):
    """DescribeMediaInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MediaInfoSet: 媒体文件信息列表。
        :type MediaInfoSet: list of MediaInfo
        :param _NotExistFileIdSet: 不存在的文件 ID 列表。
        :type NotExistFileIdSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MediaInfoSet = None
        self._NotExistFileIdSet = None
        self._RequestId = None

    @property
    def MediaInfoSet(self):
        """媒体文件信息列表。
        :rtype: list of MediaInfo
        """
        return self._MediaInfoSet

    @MediaInfoSet.setter
    def MediaInfoSet(self, MediaInfoSet):
        self._MediaInfoSet = MediaInfoSet

    @property
    def NotExistFileIdSet(self):
        """不存在的文件 ID 列表。
        :rtype: list of str
        """
        return self._NotExistFileIdSet

    @NotExistFileIdSet.setter
    def NotExistFileIdSet(self, NotExistFileIdSet):
        self._NotExistFileIdSet = NotExistFileIdSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MediaInfoSet") is not None:
            self._MediaInfoSet = []
            for item in params.get("MediaInfoSet"):
                obj = MediaInfo()
                obj._deserialize(item)
                self._MediaInfoSet.append(obj)
        self._NotExistFileIdSet = params.get("NotExistFileIdSet")
        self._RequestId = params.get("RequestId")


class DescribeMediaPlayStatDetailsRequest(AbstractModel):
    """DescribeMediaPlayStatDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件 ID。
        :type FileId: str
        :param _StartTime: 起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Interval: 统计时间粒度，有效值：
<li>Hour：以小时为粒度。</li>
<li>Day：以天为粒度。</li>
默认按时间跨度决定，小于1天以小时为粒度，大于等于1天则以天为粒度。
        :type Interval: str
        """
        self._FileId = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Interval = None

    @property
    def FileId(self):
        """媒体文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTime(self):
        """起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Interval(self):
        """统计时间粒度，有效值：
<li>Hour：以小时为粒度。</li>
<li>Day：以天为粒度。</li>
默认按时间跨度决定，小于1天以小时为粒度，大于等于1天则以天为粒度。
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Interval = params.get("Interval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaPlayStatDetailsResponse(AbstractModel):
    """DescribeMediaPlayStatDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PlayStatInfoSet: 播放统计数据。
        :type PlayStatInfoSet: list of PlayStatInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PlayStatInfoSet = None
        self._RequestId = None

    @property
    def PlayStatInfoSet(self):
        """播放统计数据。
        :rtype: list of PlayStatInfo
        """
        return self._PlayStatInfoSet

    @PlayStatInfoSet.setter
    def PlayStatInfoSet(self, PlayStatInfoSet):
        self._PlayStatInfoSet = PlayStatInfoSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PlayStatInfoSet") is not None:
            self._PlayStatInfoSet = []
            for item in params.get("PlayStatInfoSet"):
                obj = PlayStatInfo()
                obj._deserialize(item)
                self._PlayStatInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaProcessUsageDataRequest(AbstractModel):
    """DescribeMediaProcessUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 查询视频处理任务类型，目前支持的任务类型包括：
<li> Transcoding: 普通转码</li>
<li> Transcoding-TESHD: 极速高清转码</li>
<li> Editing: 视频编辑</li>
<li> Editing-TESHD: 极速高清视频编辑</li>
<li> AdaptiveBitrateStreaming: 自适应码流</li>
<li> ContentAudit: 内容审核</li>
<li> ContentRecognition: 内容识别</li>
<li> RemoveWatermark: 去除水印</li>
<li> ExtractTraceWatermark: 提取水印</li>
<li> AddTraceWatermark: 添加水印</li>
<li> RebuildMedia: 音画质重生</li>
<li> QualityInspect: 音画质检测</li>
<li> VideoHighlight: 视频智能集锦</li>
<li> VideoTag: 视频智能标签</li>
<li> VideoClassification:  视频智能分类</li>
<li> VideoCover: 视频智能封面</li>
<li> VideoSegment: 视频智能拆条</li>
<li> VideoProduce: 视频制作</li>
<li> MediaCast: 媒体转推</li>
<li>Transcode: 转码，包含普通转码、极速高清和视频编辑（不推荐使用）</li>
<li>VoiceTranslation: 语音翻译</li>
        :type Type: str
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Type = None

    @property
    def StartTime(self):
        """起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        """查询视频处理任务类型，目前支持的任务类型包括：
<li> Transcoding: 普通转码</li>
<li> Transcoding-TESHD: 极速高清转码</li>
<li> Editing: 视频编辑</li>
<li> Editing-TESHD: 极速高清视频编辑</li>
<li> AdaptiveBitrateStreaming: 自适应码流</li>
<li> ContentAudit: 内容审核</li>
<li> ContentRecognition: 内容识别</li>
<li> RemoveWatermark: 去除水印</li>
<li> ExtractTraceWatermark: 提取水印</li>
<li> AddTraceWatermark: 添加水印</li>
<li> RebuildMedia: 音画质重生</li>
<li> QualityInspect: 音画质检测</li>
<li> VideoHighlight: 视频智能集锦</li>
<li> VideoTag: 视频智能标签</li>
<li> VideoClassification:  视频智能分类</li>
<li> VideoCover: 视频智能封面</li>
<li> VideoSegment: 视频智能拆条</li>
<li> VideoProduce: 视频制作</li>
<li> MediaCast: 媒体转推</li>
<li>Transcode: 转码，包含普通转码、极速高清和视频编辑（不推荐使用）</li>
<li>VoiceTranslation: 语音翻译</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaProcessUsageDataResponse(AbstractModel):
    """DescribeMediaProcessUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MediaProcessDataSet: 视频处理统计数据概览，展示所查询任务的概览以及详细数据。
        :type MediaProcessDataSet: list of TaskStatData
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MediaProcessDataSet = None
        self._RequestId = None

    @property
    def MediaProcessDataSet(self):
        """视频处理统计数据概览，展示所查询任务的概览以及详细数据。
        :rtype: list of TaskStatData
        """
        return self._MediaProcessDataSet

    @MediaProcessDataSet.setter
    def MediaProcessDataSet(self, MediaProcessDataSet):
        self._MediaProcessDataSet = MediaProcessDataSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MediaProcessDataSet") is not None:
            self._MediaProcessDataSet = []
            for item in params.get("MediaProcessDataSet"):
                obj = TaskStatData()
                obj._deserialize(item)
                self._MediaProcessDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePersonSamplesRequest(AbstractModel):
    """DescribePersonSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 拉取的素材类型，可选值：
<li>UserDefine：用户自定义素材库；</li>
<li>Default：系统默认素材库。</li>

默认值：UserDefine，拉取用户自定义素材库素材。
说明：如果是拉取系统默认素材库，只能使用素材名字或者素材 ID + 素材名字的方式进行拉取，且五官图片只返回一张。
        :type Type: str
        :param _PersonIds: 素材 ID，数组长度限制：100。
        :type PersonIds: list of str
        :param _Names: 素材名称，数组长度限制：20。
        :type Names: list of str
        :param _Tags: 素材标签，数组长度限制：20。
        :type Tags: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：100，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Type = None
        self._PersonIds = None
        self._Names = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        """拉取的素材类型，可选值：
<li>UserDefine：用户自定义素材库；</li>
<li>Default：系统默认素材库。</li>

默认值：UserDefine，拉取用户自定义素材库素材。
说明：如果是拉取系统默认素材库，只能使用素材名字或者素材 ID + 素材名字的方式进行拉取，且五官图片只返回一张。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PersonIds(self):
        """素材 ID，数组长度限制：100。
        :rtype: list of str
        """
        return self._PersonIds

    @PersonIds.setter
    def PersonIds(self, PersonIds):
        self._PersonIds = PersonIds

    @property
    def Names(self):
        """素材名称，数组长度限制：20。
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Tags(self):
        """素材标签，数组长度限制：20。
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：100，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._PersonIds = params.get("PersonIds")
        self._Names = params.get("Names")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesResponse(AbstractModel):
    """DescribePersonSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的记录总数。
        :type TotalCount: int
        :param _PersonSet: 人物信息。
        :type PersonSet: list of AiSamplePerson
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PersonSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PersonSet(self):
        """人物信息。
        :rtype: list of AiSamplePerson
        """
        return self._PersonSet

    @PersonSet.setter
    def PersonSet(self, PersonSet):
        self._PersonSet = PersonSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PersonSet") is not None:
            self._PersonSet = []
            for item in params.get("PersonSet"):
                obj = AiSamplePerson()
                obj._deserialize(item)
                self._PersonSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrepaidProductsRequest(AbstractModel):
    """DescribePrepaidProducts请求参数结构体

    """


class DescribePrepaidProductsResponse(AbstractModel):
    """DescribePrepaidProducts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ProductInstanceSet: 购买的预付费商品实例列表。
        :type ProductInstanceSet: list of ProductInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ProductInstanceSet = None
        self._RequestId = None

    @property
    def ProductInstanceSet(self):
        """购买的预付费商品实例列表。
        :rtype: list of ProductInstance
        """
        return self._ProductInstanceSet

    @ProductInstanceSet.setter
    def ProductInstanceSet(self, ProductInstanceSet):
        self._ProductInstanceSet = ProductInstanceSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ProductInstanceSet") is not None:
            self._ProductInstanceSet = []
            for item in params.get("ProductInstanceSet"):
                obj = ProductInstance()
                obj._deserialize(item)
                self._ProductInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProcedureTemplatesRequest(AbstractModel):
    """DescribeProcedureTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Names: 任务流模板名字过滤条件，数组长度限制：100。
        :type Names: list of str
        :param _Type: 任务流模板类型过滤条件，可选值：
<li>Preset：系统预置任务流模板；</li>
<li>Custom：用户自定义任务流模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Names = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Names(self):
        """任务流模板名字过滤条件，数组长度限制：100。
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Type(self):
        """任务流模板类型过滤条件，可选值：
<li>Preset：系统预置任务流模板；</li>
<li>Custom：用户自定义任务流模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Names = params.get("Names")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProcedureTemplatesResponse(AbstractModel):
    """DescribeProcedureTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ProcedureTemplateSet: 任务流模板详情列表。
        :type ProcedureTemplateSet: list of ProcedureTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProcedureTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProcedureTemplateSet(self):
        """任务流模板详情列表。
        :rtype: list of ProcedureTemplate
        """
        return self._ProcedureTemplateSet

    @ProcedureTemplateSet.setter
    def ProcedureTemplateSet(self, ProcedureTemplateSet):
        self._ProcedureTemplateSet = ProcedureTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProcedureTemplateSet") is not None:
            self._ProcedureTemplateSet = []
            for item in params.get("ProcedureTemplateSet"):
                obj = ProcedureTemplate()
                obj._deserialize(item)
                self._ProcedureTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeQualityInspectTemplatesRequest(AbstractModel):
    """DescribeQualityInspectTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 音画质检测模板列表。长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """音画质检测模板列表。长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityInspectTemplatesResponse(AbstractModel):
    """DescribeQualityInspectTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _QualityInspectTemplateSet: 音画质检测模板详情列表。
        :type QualityInspectTemplateSet: list of QualityInspectTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._QualityInspectTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def QualityInspectTemplateSet(self):
        """音画质检测模板详情列表。
        :rtype: list of QualityInspectTemplateItem
        """
        return self._QualityInspectTemplateSet

    @QualityInspectTemplateSet.setter
    def QualityInspectTemplateSet(self, QualityInspectTemplateSet):
        self._QualityInspectTemplateSet = QualityInspectTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("QualityInspectTemplateSet") is not None:
            self._QualityInspectTemplateSet = []
            for item in params.get("QualityInspectTemplateSet"):
                obj = QualityInspectTemplateItem()
                obj._deserialize(item)
                self._QualityInspectTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRebuildMediaTemplatesRequest(AbstractModel):
    """DescribeRebuildMediaTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 视频重生模板列表。
        :type Definitions: list of int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._Definitions = None
        self._SubAppId = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Definitions(self):
        """视频重生模板列表。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRebuildMediaTemplatesResponse(AbstractModel):
    """DescribeRebuildMediaTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _RebuildMediaTemplateSet: 视频重生模板详情列表。
        :type RebuildMediaTemplateSet: list of RebuildMediaTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RebuildMediaTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RebuildMediaTemplateSet(self):
        """视频重生模板详情列表。
        :rtype: list of RebuildMediaTemplate
        """
        return self._RebuildMediaTemplateSet

    @RebuildMediaTemplateSet.setter
    def RebuildMediaTemplateSet(self, RebuildMediaTemplateSet):
        self._RebuildMediaTemplateSet = RebuildMediaTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RebuildMediaTemplateSet") is not None:
            self._RebuildMediaTemplateSet = []
            for item in params.get("RebuildMediaTemplateSet"):
                obj = RebuildMediaTemplate()
                obj._deserialize(item)
                self._RebuildMediaTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReviewDetailsRequest(AbstractModel):
    """DescribeReviewDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        """起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束日期，需大于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReviewDetailsResponse(AbstractModel):
    """DescribeReviewDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 发起内容智能识别次数。
        :type TotalCount: int
        :param _TotalDuration: 内容智能识别总时长。
        :type TotalDuration: int
        :param _Data: 内容智能识别时长统计数据，每天一个数据。
        :type Data: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._TotalDuration = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """发起内容智能识别次数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalDuration(self):
        """内容智能识别总时长。
        :rtype: int
        """
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def Data(self):
        """内容智能识别时长统计数据，每天一个数据。
        :rtype: list of StatDataItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalDuration = params.get("TotalDuration")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReviewTemplatesRequest(AbstractModel):
    """DescribeReviewTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 审核模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """审核模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReviewTemplatesResponse(AbstractModel):
    """DescribeReviewTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ReviewTemplateSet: 审核模板详情列表。
        :type ReviewTemplateSet: list of ReviewTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ReviewTemplateSet(self):
        """审核模板详情列表。
        :rtype: list of ReviewTemplate
        """
        return self._ReviewTemplateSet

    @ReviewTemplateSet.setter
    def ReviewTemplateSet(self, ReviewTemplateSet):
        self._ReviewTemplateSet = ReviewTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ReviewTemplateSet") is not None:
            self._ReviewTemplateSet = []
            for item in params.get("ReviewTemplateSet"):
                obj = ReviewTemplate()
                obj._deserialize(item)
                self._ReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRoundPlaysRequest(AbstractModel):
    """DescribeRoundPlays请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _RoundPlayIds: 过滤条件：轮播播单标识，数组长度限制：100。
        :type RoundPlayIds: list of str
        :param _Status: 过滤条件，轮播播单状态，可选值： <li>Enabled：启动状态；</li> <li>Disabled：停止状态。</li>
        :type Status: str
        :param _CreateTime: 过滤条件：轮播播单创建时间。
        :type CreateTime: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        :param _UpdateTime: 过滤条件：轮播播单更新时间。
        :type UpdateTime: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        :param _ScrollToken: 翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :type ScrollToken: str
        :param _Offset: 分页偏移量，默认值：0。已经废弃，请根据 ScrollToken 参数进行分批次查询。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._RoundPlayIds = None
        self._Status = None
        self._CreateTime = None
        self._UpdateTime = None
        self._ScrollToken = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def RoundPlayIds(self):
        """过滤条件：轮播播单标识，数组长度限制：100。
        :rtype: list of str
        """
        return self._RoundPlayIds

    @RoundPlayIds.setter
    def RoundPlayIds(self, RoundPlayIds):
        self._RoundPlayIds = RoundPlayIds

    @property
    def Status(self):
        """过滤条件，轮播播单状态，可选值： <li>Enabled：启动状态；</li> <li>Disabled：停止状态。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        """过滤条件：轮播播单创建时间。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """过滤条件：轮播播单更新时间。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ScrollToken(self):
        """翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def Offset(self):
        """分页偏移量，默认值：0。已经废弃，请根据 ScrollToken 参数进行分批次查询。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._RoundPlayIds = params.get("RoundPlayIds")
        self._Status = params.get("Status")
        if params.get("CreateTime") is not None:
            self._CreateTime = TimeRange()
            self._CreateTime._deserialize(params.get("CreateTime"))
        if params.get("UpdateTime") is not None:
            self._UpdateTime = TimeRange()
            self._UpdateTime._deserialize(params.get("UpdateTime"))
        self._ScrollToken = params.get("ScrollToken")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoundPlaysResponse(AbstractModel):
    """DescribeRoundPlays返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的轮播播单总数。已经废弃，分批次查询请请使用 ScrollToken 参数。
        :type TotalCount: int
        :param _RoundPlaySet: 轮播播单详情列表。
        :type RoundPlaySet: list of RoundPlayInfo
        :param _ScrollToken: 翻页标识，当请求未返回所有数据，该字段表示下一条记录的 ID。当该字段为空，说明已无更多数据。
        :type ScrollToken: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RoundPlaySet = None
        self._ScrollToken = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的轮播播单总数。已经废弃，分批次查询请请使用 ScrollToken 参数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RoundPlaySet(self):
        """轮播播单详情列表。
        :rtype: list of RoundPlayInfo
        """
        return self._RoundPlaySet

    @RoundPlaySet.setter
    def RoundPlaySet(self, RoundPlaySet):
        self._RoundPlaySet = RoundPlaySet

    @property
    def ScrollToken(self):
        """翻页标识，当请求未返回所有数据，该字段表示下一条记录的 ID。当该字段为空，说明已无更多数据。
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RoundPlaySet") is not None:
            self._RoundPlaySet = []
            for item in params.get("RoundPlaySet"):
                obj = RoundPlayInfo()
                obj._deserialize(item)
                self._RoundPlaySet.append(obj)
        self._ScrollToken = params.get("ScrollToken")
        self._RequestId = params.get("RequestId")


class DescribeSampleSnapshotTemplatesRequest(AbstractModel):
    """DescribeSampleSnapshotTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 采样截图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """采样截图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleSnapshotTemplatesResponse(AbstractModel):
    """DescribeSampleSnapshotTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _SampleSnapshotTemplateSet: 采样截图模板详情列表。
        :type SampleSnapshotTemplateSet: list of SampleSnapshotTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SampleSnapshotTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SampleSnapshotTemplateSet(self):
        """采样截图模板详情列表。
        :rtype: list of SampleSnapshotTemplate
        """
        return self._SampleSnapshotTemplateSet

    @SampleSnapshotTemplateSet.setter
    def SampleSnapshotTemplateSet(self, SampleSnapshotTemplateSet):
        self._SampleSnapshotTemplateSet = SampleSnapshotTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SampleSnapshotTemplateSet") is not None:
            self._SampleSnapshotTemplateSet = []
            for item in params.get("SampleSnapshotTemplateSet"):
                obj = SampleSnapshotTemplate()
                obj._deserialize(item)
                self._SampleSnapshotTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotByTimeOffsetTemplatesRequest(AbstractModel):
    """DescribeSnapshotByTimeOffsetTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 指定时间点截图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """指定时间点截图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotByTimeOffsetTemplatesResponse(AbstractModel):
    """DescribeSnapshotByTimeOffsetTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _SnapshotByTimeOffsetTemplateSet: 指定时间点截图模板详情列表。
        :type SnapshotByTimeOffsetTemplateSet: list of SnapshotByTimeOffsetTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SnapshotByTimeOffsetTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SnapshotByTimeOffsetTemplateSet(self):
        """指定时间点截图模板详情列表。
        :rtype: list of SnapshotByTimeOffsetTemplate
        """
        return self._SnapshotByTimeOffsetTemplateSet

    @SnapshotByTimeOffsetTemplateSet.setter
    def SnapshotByTimeOffsetTemplateSet(self, SnapshotByTimeOffsetTemplateSet):
        self._SnapshotByTimeOffsetTemplateSet = SnapshotByTimeOffsetTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SnapshotByTimeOffsetTemplateSet") is not None:
            self._SnapshotByTimeOffsetTemplateSet = []
            for item in params.get("SnapshotByTimeOffsetTemplateSet"):
                obj = SnapshotByTimeOffsetTemplate()
                obj._deserialize(item)
                self._SnapshotByTimeOffsetTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStorageDataRequest(AbstractModel):
    """DescribeStorageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStorageDataResponse(AbstractModel):
    """DescribeStorageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MediaCount: 当前媒体总量。
        :type MediaCount: int
        :param _TotalStorage: 当前总存储量，单位是字节。
        :type TotalStorage: int
        :param _StandardStorage: 当前标准存储量，单位是字节。
        :type StandardStorage: int
        :param _InfrequentStorage: 当前低频存储量，单位是字节。
        :type InfrequentStorage: int
        :param _ArchiveStorage: 当前归档存储量，单位是字节。
        :type ArchiveStorage: int
        :param _DeepArchiveStorage: 当前深度归档存储量，单位是字节。
        :type DeepArchiveStorage: int
        :param _StorageStat: 各计费区域的存储用量。
        :type StorageStat: list of StorageStatData
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MediaCount = None
        self._TotalStorage = None
        self._StandardStorage = None
        self._InfrequentStorage = None
        self._ArchiveStorage = None
        self._DeepArchiveStorage = None
        self._StorageStat = None
        self._RequestId = None

    @property
    def MediaCount(self):
        """当前媒体总量。
        :rtype: int
        """
        return self._MediaCount

    @MediaCount.setter
    def MediaCount(self, MediaCount):
        self._MediaCount = MediaCount

    @property
    def TotalStorage(self):
        """当前总存储量，单位是字节。
        :rtype: int
        """
        return self._TotalStorage

    @TotalStorage.setter
    def TotalStorage(self, TotalStorage):
        self._TotalStorage = TotalStorage

    @property
    def StandardStorage(self):
        """当前标准存储量，单位是字节。
        :rtype: int
        """
        return self._StandardStorage

    @StandardStorage.setter
    def StandardStorage(self, StandardStorage):
        self._StandardStorage = StandardStorage

    @property
    def InfrequentStorage(self):
        """当前低频存储量，单位是字节。
        :rtype: int
        """
        return self._InfrequentStorage

    @InfrequentStorage.setter
    def InfrequentStorage(self, InfrequentStorage):
        self._InfrequentStorage = InfrequentStorage

    @property
    def ArchiveStorage(self):
        """当前归档存储量，单位是字节。
        :rtype: int
        """
        return self._ArchiveStorage

    @ArchiveStorage.setter
    def ArchiveStorage(self, ArchiveStorage):
        self._ArchiveStorage = ArchiveStorage

    @property
    def DeepArchiveStorage(self):
        """当前深度归档存储量，单位是字节。
        :rtype: int
        """
        return self._DeepArchiveStorage

    @DeepArchiveStorage.setter
    def DeepArchiveStorage(self, DeepArchiveStorage):
        self._DeepArchiveStorage = DeepArchiveStorage

    @property
    def StorageStat(self):
        """各计费区域的存储用量。
        :rtype: list of StorageStatData
        """
        return self._StorageStat

    @StorageStat.setter
    def StorageStat(self, StorageStat):
        self._StorageStat = StorageStat

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MediaCount = params.get("MediaCount")
        self._TotalStorage = params.get("TotalStorage")
        self._StandardStorage = params.get("StandardStorage")
        self._InfrequentStorage = params.get("InfrequentStorage")
        self._ArchiveStorage = params.get("ArchiveStorage")
        self._DeepArchiveStorage = params.get("DeepArchiveStorage")
        if params.get("StorageStat") is not None:
            self._StorageStat = []
            for item in params.get("StorageStat"):
                obj = StorageStatData()
                obj._deserialize(item)
                self._StorageStat.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStorageDetailsRequest(AbstractModel):
    """DescribeStorageDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束时间，需大于开始日期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Interval: 统计时间粒度，有效值：
<li>Minute：以5分钟为粒度。</li>
<li>Day：以天为粒度。</li>
默认按时间跨度决定，小于等于1天以5分钟为粒度，大于1天则以天为粒度。
        :type Interval: str
        :param _StorageType: 查询的存储类型，有效值：
<li>TotalStorage：存储总量，标准、低频、归档和深度归档存储量之和，不含提前删除量。</li>
<li>StandardStorage：标准存储。</li>
<li>InfrequentStorage：低频存储。</li>
<li>ArchiveStorage：归档存储。</li>
<li>DeepArchiveStorage：深度归档存储。</li>
<li>DeletedInfrequentStorage：低频存储提前删除量。</li>
<li>DeletedArchiveStorage：归档提前删除量。</li>
<li>DeletedDeepArchiveStorage：深度归档提前删除量。</li>
<li>ArchiveStandardRetrieval：归档标准取回量。</li>
<li>ArchiveExpeditedRetrieval：归档快速取回量。</li>
<li>ArchiveBulkRetrieval：归档批量取回量。</li>
<li>DeepArchiveStandardRetrieval：深度归档标准取回量。</li>
<li>DeepArchiveBulkRetrieval：深度归档批量取回量。</li>
<li>InfrequentRetrieval：低频存储取回量。</li>
默认值为 TotalStorage。
        :type StorageType: str
        :param _Area: 查询的存储区域，有效值：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland：中国境外。</li>
默认值为 Chinese Mainland。
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Interval = None
        self._StorageType = None
        self._Area = None

    @property
    def StartTime(self):
        """起始时间，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，需大于开始日期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Interval(self):
        """统计时间粒度，有效值：
<li>Minute：以5分钟为粒度。</li>
<li>Day：以天为粒度。</li>
默认按时间跨度决定，小于等于1天以5分钟为粒度，大于1天则以天为粒度。
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def StorageType(self):
        """查询的存储类型，有效值：
<li>TotalStorage：存储总量，标准、低频、归档和深度归档存储量之和，不含提前删除量。</li>
<li>StandardStorage：标准存储。</li>
<li>InfrequentStorage：低频存储。</li>
<li>ArchiveStorage：归档存储。</li>
<li>DeepArchiveStorage：深度归档存储。</li>
<li>DeletedInfrequentStorage：低频存储提前删除量。</li>
<li>DeletedArchiveStorage：归档提前删除量。</li>
<li>DeletedDeepArchiveStorage：深度归档提前删除量。</li>
<li>ArchiveStandardRetrieval：归档标准取回量。</li>
<li>ArchiveExpeditedRetrieval：归档快速取回量。</li>
<li>ArchiveBulkRetrieval：归档批量取回量。</li>
<li>DeepArchiveStandardRetrieval：深度归档标准取回量。</li>
<li>DeepArchiveBulkRetrieval：深度归档批量取回量。</li>
<li>InfrequentRetrieval：低频存储取回量。</li>
默认值为 TotalStorage。
        :rtype: str
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def Area(self):
        """查询的存储区域，有效值：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland：中国境外。</li>
默认值为 Chinese Mainland。
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Interval = params.get("Interval")
        self._StorageType = params.get("StorageType")
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStorageDetailsResponse(AbstractModel):
    """DescribeStorageDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 存储统计数据，每5分钟或每天一条数据。
        :type Data: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        """存储统计数据，每5分钟或每天一条数据。
        :rtype: list of StatDataItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStorageRegionsRequest(AbstractModel):
    """DescribeStorageRegions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStorageRegionsResponse(AbstractModel):
    """DescribeStorageRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StorageRegionInfos: 存储地域信息列表。
        :type StorageRegionInfos: list of StorageRegionInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StorageRegionInfos = None
        self._RequestId = None

    @property
    def StorageRegionInfos(self):
        """存储地域信息列表。
        :rtype: list of StorageRegionInfo
        """
        return self._StorageRegionInfos

    @StorageRegionInfos.setter
    def StorageRegionInfos(self, StorageRegionInfos):
        self._StorageRegionInfos = StorageRegionInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("StorageRegionInfos") is not None:
            self._StorageRegionInfos = []
            for item in params.get("StorageRegionInfos"):
                obj = StorageRegionInfo()
                obj._deserialize(item)
                self._StorageRegionInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSubAppIdsRequest(AbstractModel):
    """DescribeSubAppIds请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 应用名称。
        :type Name: str
        :param _Tags: 标签信息，查询指定标签的应用列表。
        :type Tags: list of ResourceTag
        :param _Offset: 分页拉取的起始偏移量。默认值：0。
        :type Offset: int
        :param _Limit: 分页拉取的最大返回结果数。默认值：200；最大值：200。
        :type Limit: int
        """
        self._Name = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Name(self):
        """应用名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Tags(self):
        """标签信息，查询指定标签的应用列表。
        :rtype: list of ResourceTag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        """分页拉取的起始偏移量。默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页拉取的最大返回结果数。默认值：200；最大值：200。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = ResourceTag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubAppIdsResponse(AbstractModel):
    """DescribeSubAppIds返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppIdInfoSet: 应用信息集合。
        :type SubAppIdInfoSet: list of SubAppIdInfo
        :param _TotalCount: 应用总数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SubAppIdInfoSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SubAppIdInfoSet(self):
        """应用信息集合。
        :rtype: list of SubAppIdInfo
        """
        return self._SubAppIdInfoSet

    @SubAppIdInfoSet.setter
    def SubAppIdInfoSet(self, SubAppIdInfoSet):
        self._SubAppIdInfoSet = SubAppIdInfoSet

    @property
    def TotalCount(self):
        """应用总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SubAppIdInfoSet") is not None:
            self._SubAppIdInfoSet = []
            for item in params.get("SubAppIdInfoSet"):
                obj = SubAppIdInfo()
                obj._deserialize(item)
                self._SubAppIdInfoSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSuperPlayerConfigsRequest(AbstractModel):
    """DescribeSuperPlayerConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Names: 播放器配置名字过滤条件，数组长度限制：100。
        :type Names: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 播放器配置类型过滤条件，可选值：
<li>Preset：系统预置配置；</li>
<li>Custom：用户自定义配置。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Names = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Names(self):
        """播放器配置名字过滤条件，数组长度限制：100。
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        """播放器配置类型过滤条件，可选值：
<li>Preset：系统预置配置；</li>
<li>Custom：用户自定义配置。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Names = params.get("Names")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSuperPlayerConfigsResponse(AbstractModel):
    """DescribeSuperPlayerConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _PlayerConfigSet: 播放器配置数组。
        :type PlayerConfigSet: list of PlayerConfig
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PlayerConfigSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PlayerConfigSet(self):
        """播放器配置数组。
        :rtype: list of PlayerConfig
        """
        return self._PlayerConfigSet

    @PlayerConfigSet.setter
    def PlayerConfigSet(self, PlayerConfigSet):
        self._PlayerConfigSet = PlayerConfigSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PlayerConfigSet") is not None:
            self._PlayerConfigSet = []
            for item in params.get("PlayerConfigSet"):
                obj = PlayerConfig()
                obj._deserialize(item)
                self._PlayerConfigSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    """DescribeTaskDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 视频处理任务的任务 ID。
        :type TaskId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._TaskId = None
        self._SubAppId = None

    @property
    def TaskId(self):
        """视频处理任务的任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    """DescribeTaskDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型，取值：<li>Procedure：视频处理任务；</li><li>EditMedia：视频编辑任务；</li><li>SplitMedia：视频拆条任务；</li><li>ComposeMedia：制作媒体文件任务；</li><li>WechatPublish：微信发布任务；</li><li>WechatMiniProgramPublish：微信小程序视频发布任务；</li><li>PullUpload：拉取上传媒体文件任务；</li><li>FastClipMedia：快速剪辑任务；</li><li>RemoveWatermarkTask：智能去除水印任务；</li><li>DescribeFileAttributesTask：获取文件属性任务；</li><li>RebuildMedia：音画质重生任务（不推荐使用）；</li><li>ReviewAudioVideo：音视频审核任务；</li><li>ExtractTraceWatermark：提取溯源水印任务；</li><li>ExtractCopyRightWatermark：提取版权水印任务；</li><li>QualityInspect：音画质检测任务；</li><li>QualityEnhance：音画质重生任务；</li><li>ComplexAdaptiveDynamicStreaming：复杂自适应码流任务。</li>
        :type TaskType: str
        :param _Status: 任务状态，取值：
<li>WAITING：等待中；</li>
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成；</li>
<li>ABORTED：已终止。</li>
        :type Status: str
        :param _CreateTime: 任务的创建时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        :param _ProcedureTask: 视频处理任务信息，仅当 TaskType 为 Procedure，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProcedureTask: :class:`tencentcloud.vod.v20180717.models.ProcedureTask`
        :param _EditMediaTask: 视频编辑任务信息，仅当 TaskType 为 EditMedia，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type EditMediaTask: :class:`tencentcloud.vod.v20180717.models.EditMediaTask`
        :param _WechatPublishTask: 微信发布任务信息，仅当 TaskType 为 WechatPublish，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type WechatPublishTask: :class:`tencentcloud.vod.v20180717.models.WechatPublishTask`
        :param _ComposeMediaTask: 制作媒体文件任务信息，仅当 TaskType 为 ComposeMedia，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ComposeMediaTask: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTask`
        :param _SplitMediaTask: 视频拆条任务信息，仅当 TaskType 为 SplitMedia，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type SplitMediaTask: :class:`tencentcloud.vod.v20180717.models.SplitMediaTask`
        :param _WechatMiniProgramPublishTask: 微信小程序发布任务信息，仅当 TaskType 为 WechatMiniProgramPublish，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type WechatMiniProgramPublishTask: :class:`tencentcloud.vod.v20180717.models.WechatMiniProgramPublishTask`
        :param _PullUploadTask: 拉取上传媒体文件任务信息，仅当 TaskType 为 PullUpload，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type PullUploadTask: :class:`tencentcloud.vod.v20180717.models.PullUploadTask`
        :param _TranscodeTask: 视频转码任务信息，仅当 TaskType 为 Transcode，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type TranscodeTask: :class:`tencentcloud.vod.v20180717.models.TranscodeTask2017`
        :param _ConcatTask: 视频拼接任务信息，仅当 TaskType 为 Concat，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ConcatTask: :class:`tencentcloud.vod.v20180717.models.ConcatTask2017`
        :param _ClipTask: 视频剪辑任务信息，仅当 TaskType 为 Clip，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClipTask: :class:`tencentcloud.vod.v20180717.models.ClipTask2017`
        :param _CreateImageSpriteTask: 截取雪碧图任务信息，仅当 TaskType 为 ImageSprite，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateImageSpriteTask: :class:`tencentcloud.vod.v20180717.models.CreateImageSpriteTask2017`
        :param _SnapshotByTimeOffsetTask: 视频指定时间点截图任务信息，仅当 TaskType 为 SnapshotByTimeOffset，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.vod.v20180717.models.SnapshotByTimeOffsetTask2017`
        :param _RemoveWatermarkTask: 智能去除水印任务信息，仅当 TaskType 为 RemoveWatermark，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type RemoveWatermarkTask: :class:`tencentcloud.vod.v20180717.models.RemoveWatermarkTask`
        :param _RebuildMediaTask: 音画质重生任务信息，仅当 TaskType 为 RebuildMedia，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type RebuildMediaTask: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTask`
        :param _ExtractTraceWatermarkTask: 提取溯源水印任务信息，仅当 TaskType 为 ExtractTraceWatermark，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtractTraceWatermarkTask: :class:`tencentcloud.vod.v20180717.models.ExtractTraceWatermarkTask`
        :param _ExtractCopyRightWatermarkTask: 提取版权水印任务信息，仅当 TaskType 为 ExtractCopyRightWatermark，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtractCopyRightWatermarkTask: :class:`tencentcloud.vod.v20180717.models.ExtractCopyRightWatermarkTask`
        :param _ReviewAudioVideoTask: 音视频审核任务信息，仅当 TaskType 为 ReviewAudioVideo，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ReviewAudioVideoTask: :class:`tencentcloud.vod.v20180717.models.ReviewAudioVideoTask`
        :param _ReduceMediaBitrateTask: 该字段已无效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ReduceMediaBitrateTask: :class:`tencentcloud.vod.v20180717.models.ReduceMediaBitrateTask`
        :param _DescribeFileAttributesTask: 获取文件属性任务信息，仅当 TaskType 为 DescribeFileAttributes，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type DescribeFileAttributesTask: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTask`
        :param _QualityInspectTask: 音画质检测任务信息，仅当 TaskType 为 QualityInspect 时该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityInspectTask: :class:`tencentcloud.vod.v20180717.models.QualityInspectTask`
        :param _QualityEnhanceTask: 音画质重生任务信息，仅当 TaskType 为 QualityEnhance，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityEnhanceTask: :class:`tencentcloud.vod.v20180717.models.QualityEnhanceTask`
        :param _ComplexAdaptiveDynamicStreamingTask: 复杂自适应码流任务信息，仅当 TaskType 为 ComplexAdaptiveDynamicStreaming，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ComplexAdaptiveDynamicStreamingTask: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTask`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._CreateTime = None
        self._BeginProcessTime = None
        self._FinishTime = None
        self._ProcedureTask = None
        self._EditMediaTask = None
        self._WechatPublishTask = None
        self._ComposeMediaTask = None
        self._SplitMediaTask = None
        self._WechatMiniProgramPublishTask = None
        self._PullUploadTask = None
        self._TranscodeTask = None
        self._ConcatTask = None
        self._ClipTask = None
        self._CreateImageSpriteTask = None
        self._SnapshotByTimeOffsetTask = None
        self._RemoveWatermarkTask = None
        self._RebuildMediaTask = None
        self._ExtractTraceWatermarkTask = None
        self._ExtractCopyRightWatermarkTask = None
        self._ReviewAudioVideoTask = None
        self._ReduceMediaBitrateTask = None
        self._DescribeFileAttributesTask = None
        self._QualityInspectTask = None
        self._QualityEnhanceTask = None
        self._ComplexAdaptiveDynamicStreamingTask = None
        self._RequestId = None

    @property
    def TaskType(self):
        """任务类型，取值：<li>Procedure：视频处理任务；</li><li>EditMedia：视频编辑任务；</li><li>SplitMedia：视频拆条任务；</li><li>ComposeMedia：制作媒体文件任务；</li><li>WechatPublish：微信发布任务；</li><li>WechatMiniProgramPublish：微信小程序视频发布任务；</li><li>PullUpload：拉取上传媒体文件任务；</li><li>FastClipMedia：快速剪辑任务；</li><li>RemoveWatermarkTask：智能去除水印任务；</li><li>DescribeFileAttributesTask：获取文件属性任务；</li><li>RebuildMedia：音画质重生任务（不推荐使用）；</li><li>ReviewAudioVideo：音视频审核任务；</li><li>ExtractTraceWatermark：提取溯源水印任务；</li><li>ExtractCopyRightWatermark：提取版权水印任务；</li><li>QualityInspect：音画质检测任务；</li><li>QualityEnhance：音画质重生任务；</li><li>ComplexAdaptiveDynamicStreaming：复杂自适应码流任务。</li>
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        """任务状态，取值：
<li>WAITING：等待中；</li>
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成；</li>
<li>ABORTED：已终止。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        """任务的创建时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BeginProcessTime(self):
        """任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        """任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def ProcedureTask(self):
        """视频处理任务信息，仅当 TaskType 为 Procedure，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ProcedureTask`
        """
        return self._ProcedureTask

    @ProcedureTask.setter
    def ProcedureTask(self, ProcedureTask):
        self._ProcedureTask = ProcedureTask

    @property
    def EditMediaTask(self):
        """视频编辑任务信息，仅当 TaskType 为 EditMedia，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.EditMediaTask`
        """
        return self._EditMediaTask

    @EditMediaTask.setter
    def EditMediaTask(self, EditMediaTask):
        self._EditMediaTask = EditMediaTask

    @property
    def WechatPublishTask(self):
        """微信发布任务信息，仅当 TaskType 为 WechatPublish，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.WechatPublishTask`
        """
        return self._WechatPublishTask

    @WechatPublishTask.setter
    def WechatPublishTask(self, WechatPublishTask):
        self._WechatPublishTask = WechatPublishTask

    @property
    def ComposeMediaTask(self):
        """制作媒体文件任务信息，仅当 TaskType 为 ComposeMedia，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTask`
        """
        return self._ComposeMediaTask

    @ComposeMediaTask.setter
    def ComposeMediaTask(self, ComposeMediaTask):
        self._ComposeMediaTask = ComposeMediaTask

    @property
    def SplitMediaTask(self):
        """视频拆条任务信息，仅当 TaskType 为 SplitMedia，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SplitMediaTask`
        """
        return self._SplitMediaTask

    @SplitMediaTask.setter
    def SplitMediaTask(self, SplitMediaTask):
        self._SplitMediaTask = SplitMediaTask

    @property
    def WechatMiniProgramPublishTask(self):
        """微信小程序发布任务信息，仅当 TaskType 为 WechatMiniProgramPublish，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.WechatMiniProgramPublishTask`
        """
        return self._WechatMiniProgramPublishTask

    @WechatMiniProgramPublishTask.setter
    def WechatMiniProgramPublishTask(self, WechatMiniProgramPublishTask):
        self._WechatMiniProgramPublishTask = WechatMiniProgramPublishTask

    @property
    def PullUploadTask(self):
        """拉取上传媒体文件任务信息，仅当 TaskType 为 PullUpload，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PullUploadTask`
        """
        return self._PullUploadTask

    @PullUploadTask.setter
    def PullUploadTask(self, PullUploadTask):
        self._PullUploadTask = PullUploadTask

    @property
    def TranscodeTask(self):
        """视频转码任务信息，仅当 TaskType 为 Transcode，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TranscodeTask2017`
        """
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def ConcatTask(self):
        """视频拼接任务信息，仅当 TaskType 为 Concat，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ConcatTask2017`
        """
        return self._ConcatTask

    @ConcatTask.setter
    def ConcatTask(self, ConcatTask):
        self._ConcatTask = ConcatTask

    @property
    def ClipTask(self):
        """视频剪辑任务信息，仅当 TaskType 为 Clip，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ClipTask2017`
        """
        return self._ClipTask

    @ClipTask.setter
    def ClipTask(self, ClipTask):
        self._ClipTask = ClipTask

    @property
    def CreateImageSpriteTask(self):
        """截取雪碧图任务信息，仅当 TaskType 为 ImageSprite，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CreateImageSpriteTask2017`
        """
        return self._CreateImageSpriteTask

    @CreateImageSpriteTask.setter
    def CreateImageSpriteTask(self, CreateImageSpriteTask):
        self._CreateImageSpriteTask = CreateImageSpriteTask

    @property
    def SnapshotByTimeOffsetTask(self):
        """视频指定时间点截图任务信息，仅当 TaskType 为 SnapshotByTimeOffset，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SnapshotByTimeOffsetTask2017`
        """
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def RemoveWatermarkTask(self):
        """智能去除水印任务信息，仅当 TaskType 为 RemoveWatermark，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RemoveWatermarkTask`
        """
        return self._RemoveWatermarkTask

    @RemoveWatermarkTask.setter
    def RemoveWatermarkTask(self, RemoveWatermarkTask):
        self._RemoveWatermarkTask = RemoveWatermarkTask

    @property
    def RebuildMediaTask(self):
        """音画质重生任务信息，仅当 TaskType 为 RebuildMedia，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTask`
        """
        return self._RebuildMediaTask

    @RebuildMediaTask.setter
    def RebuildMediaTask(self, RebuildMediaTask):
        self._RebuildMediaTask = RebuildMediaTask

    @property
    def ExtractTraceWatermarkTask(self):
        """提取溯源水印任务信息，仅当 TaskType 为 ExtractTraceWatermark，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ExtractTraceWatermarkTask`
        """
        return self._ExtractTraceWatermarkTask

    @ExtractTraceWatermarkTask.setter
    def ExtractTraceWatermarkTask(self, ExtractTraceWatermarkTask):
        self._ExtractTraceWatermarkTask = ExtractTraceWatermarkTask

    @property
    def ExtractCopyRightWatermarkTask(self):
        """提取版权水印任务信息，仅当 TaskType 为 ExtractCopyRightWatermark，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ExtractCopyRightWatermarkTask`
        """
        return self._ExtractCopyRightWatermarkTask

    @ExtractCopyRightWatermarkTask.setter
    def ExtractCopyRightWatermarkTask(self, ExtractCopyRightWatermarkTask):
        self._ExtractCopyRightWatermarkTask = ExtractCopyRightWatermarkTask

    @property
    def ReviewAudioVideoTask(self):
        """音视频审核任务信息，仅当 TaskType 为 ReviewAudioVideo，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ReviewAudioVideoTask`
        """
        return self._ReviewAudioVideoTask

    @ReviewAudioVideoTask.setter
    def ReviewAudioVideoTask(self, ReviewAudioVideoTask):
        self._ReviewAudioVideoTask = ReviewAudioVideoTask

    @property
    def ReduceMediaBitrateTask(self):
        """该字段已无效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ReduceMediaBitrateTask`
        """
        return self._ReduceMediaBitrateTask

    @ReduceMediaBitrateTask.setter
    def ReduceMediaBitrateTask(self, ReduceMediaBitrateTask):
        self._ReduceMediaBitrateTask = ReduceMediaBitrateTask

    @property
    def DescribeFileAttributesTask(self):
        """获取文件属性任务信息，仅当 TaskType 为 DescribeFileAttributes，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTask`
        """
        return self._DescribeFileAttributesTask

    @DescribeFileAttributesTask.setter
    def DescribeFileAttributesTask(self, DescribeFileAttributesTask):
        self._DescribeFileAttributesTask = DescribeFileAttributesTask

    @property
    def QualityInspectTask(self):
        """音画质检测任务信息，仅当 TaskType 为 QualityInspect 时该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.QualityInspectTask`
        """
        return self._QualityInspectTask

    @QualityInspectTask.setter
    def QualityInspectTask(self, QualityInspectTask):
        self._QualityInspectTask = QualityInspectTask

    @property
    def QualityEnhanceTask(self):
        """音画质重生任务信息，仅当 TaskType 为 QualityEnhance，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.QualityEnhanceTask`
        """
        return self._QualityEnhanceTask

    @QualityEnhanceTask.setter
    def QualityEnhanceTask(self, QualityEnhanceTask):
        self._QualityEnhanceTask = QualityEnhanceTask

    @property
    def ComplexAdaptiveDynamicStreamingTask(self):
        """复杂自适应码流任务信息，仅当 TaskType 为 ComplexAdaptiveDynamicStreaming，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTask`
        """
        return self._ComplexAdaptiveDynamicStreamingTask

    @ComplexAdaptiveDynamicStreamingTask.setter
    def ComplexAdaptiveDynamicStreamingTask(self, ComplexAdaptiveDynamicStreamingTask):
        self._ComplexAdaptiveDynamicStreamingTask = ComplexAdaptiveDynamicStreamingTask

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        if params.get("ProcedureTask") is not None:
            self._ProcedureTask = ProcedureTask()
            self._ProcedureTask._deserialize(params.get("ProcedureTask"))
        if params.get("EditMediaTask") is not None:
            self._EditMediaTask = EditMediaTask()
            self._EditMediaTask._deserialize(params.get("EditMediaTask"))
        if params.get("WechatPublishTask") is not None:
            self._WechatPublishTask = WechatPublishTask()
            self._WechatPublishTask._deserialize(params.get("WechatPublishTask"))
        if params.get("ComposeMediaTask") is not None:
            self._ComposeMediaTask = ComposeMediaTask()
            self._ComposeMediaTask._deserialize(params.get("ComposeMediaTask"))
        if params.get("SplitMediaTask") is not None:
            self._SplitMediaTask = SplitMediaTask()
            self._SplitMediaTask._deserialize(params.get("SplitMediaTask"))
        if params.get("WechatMiniProgramPublishTask") is not None:
            self._WechatMiniProgramPublishTask = WechatMiniProgramPublishTask()
            self._WechatMiniProgramPublishTask._deserialize(params.get("WechatMiniProgramPublishTask"))
        if params.get("PullUploadTask") is not None:
            self._PullUploadTask = PullUploadTask()
            self._PullUploadTask._deserialize(params.get("PullUploadTask"))
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = TranscodeTask2017()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("ConcatTask") is not None:
            self._ConcatTask = ConcatTask2017()
            self._ConcatTask._deserialize(params.get("ConcatTask"))
        if params.get("ClipTask") is not None:
            self._ClipTask = ClipTask2017()
            self._ClipTask._deserialize(params.get("ClipTask"))
        if params.get("CreateImageSpriteTask") is not None:
            self._CreateImageSpriteTask = CreateImageSpriteTask2017()
            self._CreateImageSpriteTask._deserialize(params.get("CreateImageSpriteTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask2017()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("RemoveWatermarkTask") is not None:
            self._RemoveWatermarkTask = RemoveWatermarkTask()
            self._RemoveWatermarkTask._deserialize(params.get("RemoveWatermarkTask"))
        if params.get("RebuildMediaTask") is not None:
            self._RebuildMediaTask = RebuildMediaTask()
            self._RebuildMediaTask._deserialize(params.get("RebuildMediaTask"))
        if params.get("ExtractTraceWatermarkTask") is not None:
            self._ExtractTraceWatermarkTask = ExtractTraceWatermarkTask()
            self._ExtractTraceWatermarkTask._deserialize(params.get("ExtractTraceWatermarkTask"))
        if params.get("ExtractCopyRightWatermarkTask") is not None:
            self._ExtractCopyRightWatermarkTask = ExtractCopyRightWatermarkTask()
            self._ExtractCopyRightWatermarkTask._deserialize(params.get("ExtractCopyRightWatermarkTask"))
        if params.get("ReviewAudioVideoTask") is not None:
            self._ReviewAudioVideoTask = ReviewAudioVideoTask()
            self._ReviewAudioVideoTask._deserialize(params.get("ReviewAudioVideoTask"))
        if params.get("ReduceMediaBitrateTask") is not None:
            self._ReduceMediaBitrateTask = ReduceMediaBitrateTask()
            self._ReduceMediaBitrateTask._deserialize(params.get("ReduceMediaBitrateTask"))
        if params.get("DescribeFileAttributesTask") is not None:
            self._DescribeFileAttributesTask = DescribeFileAttributesTask()
            self._DescribeFileAttributesTask._deserialize(params.get("DescribeFileAttributesTask"))
        if params.get("QualityInspectTask") is not None:
            self._QualityInspectTask = QualityInspectTask()
            self._QualityInspectTask._deserialize(params.get("QualityInspectTask"))
        if params.get("QualityEnhanceTask") is not None:
            self._QualityEnhanceTask = QualityEnhanceTask()
            self._QualityEnhanceTask._deserialize(params.get("QualityEnhanceTask"))
        if params.get("ComplexAdaptiveDynamicStreamingTask") is not None:
            self._ComplexAdaptiveDynamicStreamingTask = ComplexAdaptiveDynamicStreamingTask()
            self._ComplexAdaptiveDynamicStreamingTask._deserialize(params.get("ComplexAdaptiveDynamicStreamingTask"))
        self._RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    """DescribeTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Status: 过滤条件：任务状态，可选值：WAITING（等待中）、PROCESSING（处理中）、FINISH（已完成）。
        :type Status: str
        :param _FileId: 过滤条件：文件 ID。
        :type FileId: str
        :param _CreateTime: 过滤条件：任务创建时间。
        :type CreateTime: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        :param _FinishTime: 过滤条件：任务结束时间。
        :type FinishTime: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        :param _Sort: 排序方式。Sort.Field 可选：
<li> CreateTime 任务创建时间。</li>
<li>FinishTime 任务结束时间。</li>
        :type Sort: :class:`tencentcloud.vod.v20180717.models.SortBy`
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _ScrollToken: 翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :type ScrollToken: str
        """
        self._SubAppId = None
        self._Status = None
        self._FileId = None
        self._CreateTime = None
        self._FinishTime = None
        self._Sort = None
        self._Limit = None
        self._ScrollToken = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Status(self):
        """过滤条件：任务状态，可选值：WAITING（等待中）、PROCESSING（处理中）、FINISH（已完成）。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def FileId(self):
        """过滤条件：文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def CreateTime(self):
        """过滤条件：任务创建时间。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def FinishTime(self):
        """过滤条件：任务结束时间。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def Sort(self):
        """排序方式。Sort.Field 可选：
<li> CreateTime 任务创建时间。</li>
<li>FinishTime 任务结束时间。</li>
        :rtype: :class:`tencentcloud.vod.v20180717.models.SortBy`
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ScrollToken(self):
        """翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Status = params.get("Status")
        self._FileId = params.get("FileId")
        if params.get("CreateTime") is not None:
            self._CreateTime = TimeRange()
            self._CreateTime._deserialize(params.get("CreateTime"))
        if params.get("FinishTime") is not None:
            self._FinishTime = TimeRange()
            self._FinishTime._deserialize(params.get("FinishTime"))
        if params.get("Sort") is not None:
            self._Sort = SortBy()
            self._Sort._deserialize(params.get("Sort"))
        self._Limit = params.get("Limit")
        self._ScrollToken = params.get("ScrollToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    """DescribeTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskSet: 任务概要列表。
        :type TaskSet: list of TaskSimpleInfo
        :param _ScrollToken: 翻页标识，当请求未返回所有数据，该字段表示下一条记录的 ID。当该字段为空，说明已无更多数据。
        :type ScrollToken: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskSet = None
        self._ScrollToken = None
        self._RequestId = None

    @property
    def TaskSet(self):
        """任务概要列表。
        :rtype: list of TaskSimpleInfo
        """
        return self._TaskSet

    @TaskSet.setter
    def TaskSet(self, TaskSet):
        self._TaskSet = TaskSet

    @property
    def ScrollToken(self):
        """翻页标识，当请求未返回所有数据，该字段表示下一条记录的 ID。当该字段为空，说明已无更多数据。
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskSet") is not None:
            self._TaskSet = []
            for item in params.get("TaskSet"):
                obj = TaskSimpleInfo()
                obj._deserialize(item)
                self._TaskSet.append(obj)
        self._ScrollToken = params.get("ScrollToken")
        self._RequestId = params.get("RequestId")


class DescribeTranscodeTemplatesRequest(AbstractModel):
    """DescribeTranscodeTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 转码模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _ContainerType: 封装格式过滤条件，可选值：
<li>Video：视频格式，可以同时包含视频流和音频流的封装格式板；</li>
<li>PureAudio：纯音频格式，只能包含音频流的封装格式。</li>
        :type ContainerType: str
        :param _TEHDType: 极速高清过滤条件，用于过滤普通转码或极速高清转码模板，可选值：
<li>Common：普通转码模板；</li>
<li>TEHD：极速高清模板。</li>
        :type TEHDType: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._ContainerType = None
        self._TEHDType = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        """转码模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        """模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ContainerType(self):
        """封装格式过滤条件，可选值：
<li>Video：视频格式，可以同时包含视频流和音频流的封装格式板；</li>
<li>PureAudio：纯音频格式，只能包含音频流的封装格式。</li>
        :rtype: str
        """
        return self._ContainerType

    @ContainerType.setter
    def ContainerType(self, ContainerType):
        self._ContainerType = ContainerType

    @property
    def TEHDType(self):
        """极速高清过滤条件，用于过滤普通转码或极速高清转码模板，可选值：
<li>Common：普通转码模板；</li>
<li>TEHD：极速高清模板。</li>
        :rtype: str
        """
        return self._TEHDType

    @TEHDType.setter
    def TEHDType(self, TEHDType):
        self._TEHDType = TEHDType

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._ContainerType = params.get("ContainerType")
        self._TEHDType = params.get("TEHDType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTranscodeTemplatesResponse(AbstractModel):
    """DescribeTranscodeTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _TranscodeTemplateSet: 转码模板详情列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type TranscodeTemplateSet: list of TranscodeTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._TranscodeTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TranscodeTemplateSet(self):
        """转码模板详情列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TranscodeTemplate
        """
        return self._TranscodeTemplateSet

    @TranscodeTemplateSet.setter
    def TranscodeTemplateSet(self, TranscodeTemplateSet):
        self._TranscodeTemplateSet = TranscodeTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TranscodeTemplateSet") is not None:
            self._TranscodeTemplateSet = []
            for item in params.get("TranscodeTemplateSet"):
                obj = TranscodeTemplate()
                obj._deserialize(item)
                self._TranscodeTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVodDomainsRequest(AbstractModel):
    """DescribeVodDomains请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domains: 域名列表。当该字段不填时，则默认列出所有域名信息。本字段限制如下：
<li>域名个数度最大为 20。</li>
        :type Domains: list of str
        :param _Limit: 分页拉取的最大返回结果数。默认值：20。
        :type Limit: int
        :param _Offset: 分页拉取的起始偏移量。默认值：0。
        :type Offset: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Domains = None
        self._Limit = None
        self._Offset = None
        self._SubAppId = None

    @property
    def Domains(self):
        """域名列表。当该字段不填时，则默认列出所有域名信息。本字段限制如下：
<li>域名个数度最大为 20。</li>
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Limit(self):
        """分页拉取的最大返回结果数。默认值：20。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """分页拉取的起始偏移量。默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domains = params.get("Domains")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVodDomainsResponse(AbstractModel):
    """DescribeVodDomains返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 域名总数量。
        :type TotalCount: int
        :param _DomainSet: 域名信息列表。
        :type DomainSet: list of DomainDetailInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._DomainSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """域名总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DomainSet(self):
        """域名信息列表。
        :rtype: list of DomainDetailInfo
        """
        return self._DomainSet

    @DomainSet.setter
    def DomainSet(self, DomainSet):
        self._DomainSet = DomainSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DomainSet") is not None:
            self._DomainSet = []
            for item in params.get("DomainSet"):
                obj = DomainDetailInfo()
                obj._deserialize(item)
                self._DomainSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWatermarkTemplatesRequest(AbstractModel):
    """DescribeWatermarkTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 水印类型过滤条件，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Definitions: 水印模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Limit: 返回记录条数
<li>默认值：10；</li>
<li>最大值：100。</li>
        :type Limit: int
        """
        self._SubAppId = None
        self._Type = None
        self._Offset = None
        self._Definitions = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        """水印类型过滤条件，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Definitions(self):
        """水印模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Limit(self):
        """返回记录条数
<li>默认值：10；</li>
<li>最大值：100。</li>
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Definitions = params.get("Definitions")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWatermarkTemplatesResponse(AbstractModel):
    """DescribeWatermarkTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _WatermarkTemplateSet: 水印模板详情列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type WatermarkTemplateSet: list of WatermarkTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WatermarkTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WatermarkTemplateSet(self):
        """水印模板详情列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of WatermarkTemplate
        """
        return self._WatermarkTemplateSet

    @WatermarkTemplateSet.setter
    def WatermarkTemplateSet(self, WatermarkTemplateSet):
        self._WatermarkTemplateSet = WatermarkTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WatermarkTemplateSet") is not None:
            self._WatermarkTemplateSet = []
            for item in params.get("WatermarkTemplateSet"):
                obj = WatermarkTemplate()
                obj._deserialize(item)
                self._WatermarkTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWordSamplesRequest(AbstractModel):
    """DescribeWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Usages: <b>关键词应用场景过滤条件，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜的内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜的内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜的内容识别，等价于 3+4；
可多选，元素间关系为 or，即关键词的应用场景包含该字段集合中任意元素的记录，均符合该条件。
        :type Usages: list of str
        :param _Keywords: 关键词过滤条件，数组长度限制：100 个词。
        :type Keywords: list of str
        :param _Tags: 标签过滤条件，数组长度限制：20 个词。
        :type Tags: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：100，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Usages = None
        self._Keywords = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Usages(self):
        """<b>关键词应用场景过滤条件，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜的内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜的内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜的内容识别，等价于 3+4；
可多选，元素间关系为 or，即关键词的应用场景包含该字段集合中任意元素的记录，均符合该条件。
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Keywords(self):
        """关键词过滤条件，数组长度限制：100 个词。
        :rtype: list of str
        """
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def Tags(self):
        """标签过滤条件，数组长度限制：20 个词。
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        """分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认值：100，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Usages = params.get("Usages")
        self._Keywords = params.get("Keywords")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWordSamplesResponse(AbstractModel):
    """DescribeWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的记录总数。
        :type TotalCount: int
        :param _WordSet: 关键词信息。
        :type WordSet: list of AiSampleWord
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WordSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WordSet(self):
        """关键词信息。
        :rtype: list of AiSampleWord
        """
        return self._WordSet

    @WordSet.setter
    def WordSet(self, WordSet):
        self._WordSet = WordSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WordSet") is not None:
            self._WordSet = []
            for item in params.get("WordSet"):
                obj = AiSampleWord()
                obj._deserialize(item)
                self._WordSet.append(obj)
        self._RequestId = params.get("RequestId")


class DomainCLSTargetInfo(AbstractModel):
    """域名推送 CLS 目标。

    """

    def __init__(self):
        r"""
        :param _Domain: 域名。
        :type Domain: str
        :param _ChineseMainlandCLSTargetInfo: 中国大陆地区的日志推送目标。
        :type ChineseMainlandCLSTargetInfo: :class:`tencentcloud.vod.v20180717.models.AreaCLSTargetInfo`
        :param _OutsideChineseMainlandCLSTargetInfo: 中国大陆以外地区的日志推送目标。
        :type OutsideChineseMainlandCLSTargetInfo: :class:`tencentcloud.vod.v20180717.models.AreaCLSTargetInfo`
        """
        self._Domain = None
        self._ChineseMainlandCLSTargetInfo = None
        self._OutsideChineseMainlandCLSTargetInfo = None

    @property
    def Domain(self):
        """域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ChineseMainlandCLSTargetInfo(self):
        """中国大陆地区的日志推送目标。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AreaCLSTargetInfo`
        """
        return self._ChineseMainlandCLSTargetInfo

    @ChineseMainlandCLSTargetInfo.setter
    def ChineseMainlandCLSTargetInfo(self, ChineseMainlandCLSTargetInfo):
        self._ChineseMainlandCLSTargetInfo = ChineseMainlandCLSTargetInfo

    @property
    def OutsideChineseMainlandCLSTargetInfo(self):
        """中国大陆以外地区的日志推送目标。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AreaCLSTargetInfo`
        """
        return self._OutsideChineseMainlandCLSTargetInfo

    @OutsideChineseMainlandCLSTargetInfo.setter
    def OutsideChineseMainlandCLSTargetInfo(self, OutsideChineseMainlandCLSTargetInfo):
        self._OutsideChineseMainlandCLSTargetInfo = OutsideChineseMainlandCLSTargetInfo


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        if params.get("ChineseMainlandCLSTargetInfo") is not None:
            self._ChineseMainlandCLSTargetInfo = AreaCLSTargetInfo()
            self._ChineseMainlandCLSTargetInfo._deserialize(params.get("ChineseMainlandCLSTargetInfo"))
        if params.get("OutsideChineseMainlandCLSTargetInfo") is not None:
            self._OutsideChineseMainlandCLSTargetInfo = AreaCLSTargetInfo()
            self._OutsideChineseMainlandCLSTargetInfo._deserialize(params.get("OutsideChineseMainlandCLSTargetInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainDetailInfo(AbstractModel):
    """域名信息

    """

    def __init__(self):
        r"""
        :param _Domain: 域名名称。
        :type Domain: str
        :param _AccelerateAreaInfos: 加速地区信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type AccelerateAreaInfos: list of AccelerateAreaInfo
        :param _DeployStatus: 部署状态，取值有：
<li>Online：上线；</li>
<li>Deploying：部署中；</li>
<li>Locked: 锁定中，出现该状态时，无法对该域名进行部署变更。</li>
        :type DeployStatus: str
        :param _HTTPSConfig: HTTPS 配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type HTTPSConfig: :class:`tencentcloud.vod.v20180717.models.DomainHTTPSConfig`
        :param _UrlSignatureAuthPolicy: [Key 防盗链](https://cloud.tencent.com/document/product/266/14047)配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type UrlSignatureAuthPolicy: :class:`tencentcloud.vod.v20180717.models.UrlSignatureAuthPolicy`
        :param _RefererAuthPolicy: [Referer 防盗链](https://cloud.tencent.com/document/product/266/14046)配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RefererAuthPolicy: :class:`tencentcloud.vod.v20180717.models.RefererAuthPolicy`
        :param _CreateTime: 域名添加到腾讯云点播系统中的时间。
<li>格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。</li>
        :type CreateTime: str
        :param _QUICConfig: 域名 QUIC 配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type QUICConfig: :class:`tencentcloud.vod.v20180717.models.DomainQUICConfig`
        :param _IPFilterPolicy: IP 访问限制配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type IPFilterPolicy: :class:`tencentcloud.vod.v20180717.models.IPFilterPolicy`
        """
        self._Domain = None
        self._AccelerateAreaInfos = None
        self._DeployStatus = None
        self._HTTPSConfig = None
        self._UrlSignatureAuthPolicy = None
        self._RefererAuthPolicy = None
        self._CreateTime = None
        self._QUICConfig = None
        self._IPFilterPolicy = None

    @property
    def Domain(self):
        """域名名称。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def AccelerateAreaInfos(self):
        """加速地区信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AccelerateAreaInfo
        """
        return self._AccelerateAreaInfos

    @AccelerateAreaInfos.setter
    def AccelerateAreaInfos(self, AccelerateAreaInfos):
        self._AccelerateAreaInfos = AccelerateAreaInfos

    @property
    def DeployStatus(self):
        """部署状态，取值有：
<li>Online：上线；</li>
<li>Deploying：部署中；</li>
<li>Locked: 锁定中，出现该状态时，无法对该域名进行部署变更。</li>
        :rtype: str
        """
        return self._DeployStatus

    @DeployStatus.setter
    def DeployStatus(self, DeployStatus):
        self._DeployStatus = DeployStatus

    @property
    def HTTPSConfig(self):
        """HTTPS 配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.DomainHTTPSConfig`
        """
        return self._HTTPSConfig

    @HTTPSConfig.setter
    def HTTPSConfig(self, HTTPSConfig):
        self._HTTPSConfig = HTTPSConfig

    @property
    def UrlSignatureAuthPolicy(self):
        """[Key 防盗链](https://cloud.tencent.com/document/product/266/14047)配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.UrlSignatureAuthPolicy`
        """
        return self._UrlSignatureAuthPolicy

    @UrlSignatureAuthPolicy.setter
    def UrlSignatureAuthPolicy(self, UrlSignatureAuthPolicy):
        self._UrlSignatureAuthPolicy = UrlSignatureAuthPolicy

    @property
    def RefererAuthPolicy(self):
        """[Referer 防盗链](https://cloud.tencent.com/document/product/266/14046)配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RefererAuthPolicy`
        """
        return self._RefererAuthPolicy

    @RefererAuthPolicy.setter
    def RefererAuthPolicy(self, RefererAuthPolicy):
        self._RefererAuthPolicy = RefererAuthPolicy

    @property
    def CreateTime(self):
        """域名添加到腾讯云点播系统中的时间。
<li>格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。</li>
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def QUICConfig(self):
        """域名 QUIC 配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.DomainQUICConfig`
        """
        return self._QUICConfig

    @QUICConfig.setter
    def QUICConfig(self, QUICConfig):
        self._QUICConfig = QUICConfig

    @property
    def IPFilterPolicy(self):
        """IP 访问限制配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.IPFilterPolicy`
        """
        return self._IPFilterPolicy

    @IPFilterPolicy.setter
    def IPFilterPolicy(self, IPFilterPolicy):
        self._IPFilterPolicy = IPFilterPolicy


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        if params.get("AccelerateAreaInfos") is not None:
            self._AccelerateAreaInfos = []
            for item in params.get("AccelerateAreaInfos"):
                obj = AccelerateAreaInfo()
                obj._deserialize(item)
                self._AccelerateAreaInfos.append(obj)
        self._DeployStatus = params.get("DeployStatus")
        if params.get("HTTPSConfig") is not None:
            self._HTTPSConfig = DomainHTTPSConfig()
            self._HTTPSConfig._deserialize(params.get("HTTPSConfig"))
        if params.get("UrlSignatureAuthPolicy") is not None:
            self._UrlSignatureAuthPolicy = UrlSignatureAuthPolicy()
            self._UrlSignatureAuthPolicy._deserialize(params.get("UrlSignatureAuthPolicy"))
        if params.get("RefererAuthPolicy") is not None:
            self._RefererAuthPolicy = RefererAuthPolicy()
            self._RefererAuthPolicy._deserialize(params.get("RefererAuthPolicy"))
        self._CreateTime = params.get("CreateTime")
        if params.get("QUICConfig") is not None:
            self._QUICConfig = DomainQUICConfig()
            self._QUICConfig._deserialize(params.get("QUICConfig"))
        if params.get("IPFilterPolicy") is not None:
            self._IPFilterPolicy = IPFilterPolicy()
            self._IPFilterPolicy._deserialize(params.get("IPFilterPolicy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainHTTPSConfig(AbstractModel):
    """域名 HTTPS 配置信息

    """

    def __init__(self):
        r"""
        :param _CertExpireTime: 证书过期时间。
<li>格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。</li>
        :type CertExpireTime: str
        :param _CloudCertId: 腾讯云 SSL 产品中的证书 ID。
        :type CloudCertId: str
        """
        self._CertExpireTime = None
        self._CloudCertId = None

    @property
    def CertExpireTime(self):
        """证书过期时间。
<li>格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。</li>
        :rtype: str
        """
        return self._CertExpireTime

    @CertExpireTime.setter
    def CertExpireTime(self, CertExpireTime):
        self._CertExpireTime = CertExpireTime

    @property
    def CloudCertId(self):
        """腾讯云 SSL 产品中的证书 ID。
        :rtype: str
        """
        return self._CloudCertId

    @CloudCertId.setter
    def CloudCertId(self, CloudCertId):
        self._CloudCertId = CloudCertId


    def _deserialize(self, params):
        self._CertExpireTime = params.get("CertExpireTime")
        self._CloudCertId = params.get("CloudCertId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainQUICConfig(AbstractModel):
    """域名 QUIC 配置信息

    """

    def __init__(self):
        r"""
        :param _Status: QUIC 配置状态，可选值：
<li>Enabled: 启用；</li>
<li>Disabled: 禁用。</li>
        :type Status: str
        """
        self._Status = None

    @property
    def Status(self):
        """QUIC 配置状态，可选值：
<li>Enabled: 启用；</li>
<li>Disabled: 禁用。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DrmStreamingsInfo(AbstractModel):
    """DRM 自适应码流播放信息

    """

    def __init__(self):
        r"""
        :param _SimpleAesDefinition: 保护类型为 SimpleAES 的转自适应码流模板 ID。
        :type SimpleAesDefinition: int
        :param _WidevineDefinition: 保护类型为 Widevine 的转自适应码流模板 ID。
        :type WidevineDefinition: int
        :param _FairPlayDefinition: 保护类型为 FairPlay 的转自适应码流模板 ID。
        :type FairPlayDefinition: int
        """
        self._SimpleAesDefinition = None
        self._WidevineDefinition = None
        self._FairPlayDefinition = None

    @property
    def SimpleAesDefinition(self):
        """保护类型为 SimpleAES 的转自适应码流模板 ID。
        :rtype: int
        """
        return self._SimpleAesDefinition

    @SimpleAesDefinition.setter
    def SimpleAesDefinition(self, SimpleAesDefinition):
        self._SimpleAesDefinition = SimpleAesDefinition

    @property
    def WidevineDefinition(self):
        """保护类型为 Widevine 的转自适应码流模板 ID。
        :rtype: int
        """
        return self._WidevineDefinition

    @WidevineDefinition.setter
    def WidevineDefinition(self, WidevineDefinition):
        self._WidevineDefinition = WidevineDefinition

    @property
    def FairPlayDefinition(self):
        """保护类型为 FairPlay 的转自适应码流模板 ID。
        :rtype: int
        """
        return self._FairPlayDefinition

    @FairPlayDefinition.setter
    def FairPlayDefinition(self, FairPlayDefinition):
        self._FairPlayDefinition = FairPlayDefinition


    def _deserialize(self, params):
        self._SimpleAesDefinition = params.get("SimpleAesDefinition")
        self._WidevineDefinition = params.get("WidevineDefinition")
        self._FairPlayDefinition = params.get("FairPlayDefinition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DrmStreamingsInfoForUpdate(AbstractModel):
    """DRM 自适应码流播放信息修改对象

    """

    def __init__(self):
        r"""
        :param _SimpleAesDefinition: 保护类型为 SimpleAES 的转自适应码流模板 ID。
        :type SimpleAesDefinition: int
        :param _WidevineDefinition: 保护类型为 Widevine 的转自适应码流模板 ID。
        :type WidevineDefinition: int
        :param _FairPlayDefinition: 保护类型为 FairPlay 的转自适应码流模板 ID。
        :type FairPlayDefinition: int
        """
        self._SimpleAesDefinition = None
        self._WidevineDefinition = None
        self._FairPlayDefinition = None

    @property
    def SimpleAesDefinition(self):
        """保护类型为 SimpleAES 的转自适应码流模板 ID。
        :rtype: int
        """
        return self._SimpleAesDefinition

    @SimpleAesDefinition.setter
    def SimpleAesDefinition(self, SimpleAesDefinition):
        self._SimpleAesDefinition = SimpleAesDefinition

    @property
    def WidevineDefinition(self):
        """保护类型为 Widevine 的转自适应码流模板 ID。
        :rtype: int
        """
        return self._WidevineDefinition

    @WidevineDefinition.setter
    def WidevineDefinition(self, WidevineDefinition):
        self._WidevineDefinition = WidevineDefinition

    @property
    def FairPlayDefinition(self):
        """保护类型为 FairPlay 的转自适应码流模板 ID。
        :rtype: int
        """
        return self._FairPlayDefinition

    @FairPlayDefinition.setter
    def FairPlayDefinition(self, FairPlayDefinition):
        self._FairPlayDefinition = FairPlayDefinition


    def _deserialize(self, params):
        self._SimpleAesDefinition = params.get("SimpleAesDefinition")
        self._WidevineDefinition = params.get("WidevineDefinition")
        self._FairPlayDefinition = params.get("FairPlayDefinition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DynamicRangeInfo(AbstractModel):
    """画面动态范围信息。

    """

    def __init__(self):
        r"""
        :param _Type: 画面动态范围信息。可取值：
<li>SDR：Standard Dynamic Range 标准动态范围；</li>
<li>HDR：High Dynamic Range 高动态范围。</li>
        :type Type: str
        :param _HDRType: 高动态范围类型，当 Type 为 HDR 时有效。目前支持的可取值：
<li>hdr10：表示 hdr10 标准；</li>
<li>hlg：表示 hlg 标准。</li>
        :type HDRType: str
        """
        self._Type = None
        self._HDRType = None

    @property
    def Type(self):
        """画面动态范围信息。可取值：
<li>SDR：Standard Dynamic Range 标准动态范围；</li>
<li>HDR：High Dynamic Range 高动态范围。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def HDRType(self):
        """高动态范围类型，当 Type 为 HDR 时有效。目前支持的可取值：
<li>hdr10：表示 hdr10 标准；</li>
<li>hlg：表示 hlg 标准。</li>
        :rtype: str
        """
        return self._HDRType

    @HDRType.setter
    def HDRType(self, HDRType):
        self._HDRType = HDRType


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._HDRType = params.get("HDRType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaFileInfo(AbstractModel):
    """编辑点播视频文件信息

    """

    def __init__(self):
        r"""
        :param _FileId: 视频的 ID。
        :type FileId: str
        :param _StartTimeOffset: 视频剪辑起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 视频剪辑结束的偏移时间，单位：秒。
        :type EndTimeOffset: float
        """
        self._FileId = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def FileId(self):
        """视频的 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTimeOffset(self):
        """视频剪辑起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        """视频剪辑结束的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaOutputConfig(AbstractModel):
    """编辑视频的结果文件输出。

    """

    def __init__(self):
        r"""
        :param _MediaName: 输出文件名，最长 64 个字符。缺省由系统指定生成文件名。
        :type MediaName: str
        :param _Type: 输出文件格式，可选值：mp4、hls。默认是 mp4。
        :type Type: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        :param _VideoStream: 输出的视频信息。
        :type VideoStream: :class:`tencentcloud.vod.v20180717.models.EditMediaVideoStream`
        :param _TEHDConfig: 极速高清转码参数。
        :type TEHDConfig: :class:`tencentcloud.vod.v20180717.models.EditMediaTEHDConfig`
        """
        self._MediaName = None
        self._Type = None
        self._ClassId = None
        self._ExpireTime = None
        self._VideoStream = None
        self._TEHDConfig = None

    @property
    def MediaName(self):
        """输出文件名，最长 64 个字符。缺省由系统指定生成文件名。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def Type(self):
        """输出文件格式，可选值：mp4、hls。默认是 mp4。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassId(self):
        """分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        """输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def VideoStream(self):
        """输出的视频信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.EditMediaVideoStream`
        """
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def TEHDConfig(self):
        """极速高清转码参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.EditMediaTEHDConfig`
        """
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig


    def _deserialize(self, params):
        self._MediaName = params.get("MediaName")
        self._Type = params.get("Type")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        if params.get("VideoStream") is not None:
            self._VideoStream = EditMediaVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = EditMediaTEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaRequest(AbstractModel):
    """EditMedia请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InputType: 输入视频的类型，可以取的值为  File，Stream 两种。
        :type InputType: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _FileInfos: 输入的视频文件信息，当 InputType 为 File 时必填。
        :type FileInfos: list of EditMediaFileInfo
        :param _StreamInfos: 输入的流信息，当 InputType 为 Stream 时必填。
        :type StreamInfos: list of EditMediaStreamInfo
        :param _Definition: 编辑模板 ID，取值有 10，20，不填代表使用 10 模板。
<li>10：拼接时，以分辨率最高的输入为基准；</li>
<li>20：拼接时，以码率最高的输入为基准。</li>
        :type Definition: int
        :param _ProcedureName: [任务流模板](/document/product/266/11700#.E4.BB.BB.E5.8A.A1.E6.B5.81.E6.A8.A1.E6.9D.BF)名字，如果要对生成的新视频执行任务流时填写。
        :type ProcedureName: str
        :param _OutputConfig: 编辑后生成的文件配置。
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.EditMediaOutputConfig`
        :param _SessionContext: 标识来源上下文，用于透传用户请求信息，在EditMediaComplete回调和任务流状态变更回调将返回该字段值，最长 1000个字符。
        :type SessionContext: str
        :param _TasksPriority: 任务的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :type TasksPriority: int
        :param _SessionId: 用于任务去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        """
        self._InputType = None
        self._SubAppId = None
        self._FileInfos = None
        self._StreamInfos = None
        self._Definition = None
        self._ProcedureName = None
        self._OutputConfig = None
        self._SessionContext = None
        self._TasksPriority = None
        self._SessionId = None
        self._ExtInfo = None

    @property
    def InputType(self):
        """输入视频的类型，可以取的值为  File，Stream 两种。
        :rtype: str
        """
        return self._InputType

    @InputType.setter
    def InputType(self, InputType):
        self._InputType = InputType

    @property
    def SubAppId(self):
        """<b>点播[应用](/document/product/266