/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Cache a Google account email
 * @param email The email address to cache
 */
export declare function cacheGoogleAccount(email: string): Promise<void>;
/**
 * Get the cached Google account email
 * @returns The cached email or null if none is cached
 */
export declare function getCachedGoogleAccount(): string | null;
/**
 * Clear the cached Google account
 */
export declare function clearCachedGoogleAccount(): Promise<void>;
