export const getLogger = (prefix, chalk) => ({
    info: (msg, ...optionalParams) => {
        console.info(`${chalk.bold(`[${prefix}]`)} ${chalk(msg)}`, ...optionalParams);
    },
    error: (msg, ...optionalParams) => {
        console.info(`${chalk.bold.red(`[${prefix}]`)} ${chalk.red(msg)}`, ...optionalParams);
    }
});
//# sourceMappingURL=logger.js.map