import { OAuth2Client } from "google-auth-library";
import * as OpenAI from "../types/openai.js";
import * as Gemini from "../types/gemini.js";
/**
 * Custom error class for Gemini API errors with status code information
 */
export declare class GeminiApiError extends Error {
    readonly statusCode: number;
    readonly responseText?: string | undefined;
    constructor(message: string, statusCode: number, responseText?: string | undefined);
}
/**
 * Handles communication with Google's Gemini API through the Code Assist endpoint.
 */
export declare class GeminiApiClient {
    private readonly authClient;
    private readonly googleCloudProject;
    private readonly disableAutoModelSwitch;
    private projectId;
    private firstChunk;
    private readonly creationTime;
    private readonly chatID;
    private readonly autoSwitcher;
    private readonly logger;
    constructor(authClient: OAuth2Client, googleCloudProject: string | undefined, disableAutoModelSwitch: boolean);
    /**
     * Discovers the Google Cloud project ID.
     */
    discoverProjectId(): Promise<string>;
    private callEndpoint;
    /**
     * Get non-streaming completion from Gemini API.
     */
    getCompletion(geminiCompletionRequest: Gemini.ChatCompletionRequest, isRetry?: boolean): Promise<{
        content: string;
        tool_calls?: OpenAI.ToolCall[];
        usage?: {
            inputTokens: number;
            outputTokens: number;
        };
        _autoSwitchNotification?: string;
    }>;
    /**
     * Stream content from Gemini API.
     */
    streamContent(geminiCompletionRequest: Gemini.ChatCompletionRequest, isRetry?: boolean): AsyncGenerator<OpenAI.StreamChunk>;
    /**
     * Internal streaming method with no retry logic
     */
    private streamContentInternal;
    /**
     * Creates an OpenAI stream chunk with the given delta
     */
    private createOpenAIChunk;
    /**
     * Parses a server-sent event (SSE) stream from the Gemini API.
     */
    private parseSSEStream;
}
