/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/Tabs.tsx":
/*!**********************!*\
  !*** ./src/Tabs.tsx ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/BaseStyles.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Box/Box.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/UnderlineNav/index.js");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @primer/octicons-react */ "./node_modules/@primer/octicons-react/dist/index.esm.js");
/* harmony import */ var _tabs_Tab1__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./tabs/Tab1 */ "./src/tabs/Tab1.tsx");
/* harmony import */ var _tabs_Tab2__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./tabs/Tab2 */ "./src/tabs/Tab2.tsx");
/* harmony import */ var _tabs_Tab3__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./tabs/Tab3 */ "./src/tabs/Tab3.tsx");
/* harmony import */ var _tabs_Tab4__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./tabs/Tab4 */ "./src/tabs/Tab4.tsx");
/* harmony import */ var _tabs_Tab5__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./tabs/Tab5 */ "./src/tabs/Tab5.tsx");
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./handler */ "./src/handler.ts");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");












const Tabs = () => {
  const [tab, setTab] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(1);
  const [version, setVersion] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    (0,_handler__WEBPACK_IMPORTED_MODULE_2__.requestAPI)('config').then(data => {
      setVersion(data.version);
    }).catch(reason => {
      console.error(`Error while accessing the jupyter server jupyter_functions extension.\n${reason}`);
    });
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
          style: {
            maxWidth: 700
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_6__.UnderlineNav, {
              "aria-label": "jupyter-functions",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__.UnderlineNav.Item, {
                "aria-current": tab === 1 ? "page" : undefined,
                "aria-label": "tab-1",
                icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_7__.CpuIcon,
                onSelect: e => {
                  e.preventDefault();
                  setTab(1);
                },
                children: "Kernels"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__.UnderlineNav.Item, {
                "aria-current": tab === 2 ? "page" : undefined,
                icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_7__.CodeIcon,
                counter: 6,
                "aria-label": "tab-2",
                onSelect: e => {
                  e.preventDefault();
                  setTab(2);
                },
                children: "Notebooks"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__.UnderlineNav.Item, {
                "aria-current": tab === 3 ? "page" : undefined,
                icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_7__.AlertIcon,
                "aria-label": "tab-3",
                onSelect: e => {
                  e.preventDefault();
                  setTab(3);
                },
                children: "Warnings"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__.UnderlineNav.Item, {
                "aria-current": tab === 4 ? "page" : undefined,
                icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_7__.HistoryIcon,
                counter: 7,
                "aria-label": "tab-4",
                onSelect: e => {
                  e.preventDefault();
                  setTab(4);
                },
                children: "History"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__.UnderlineNav.Item, {
                "aria-current": tab === 5 ? "page" : undefined,
                icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_7__.CommentDiscussionIcon,
                "aria-label": "tab-5",
                onSelect: e => {
                  e.preventDefault();
                  setTab(5);
                },
                children: "More"
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
            m: 3,
            children: [tab === 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_tabs_Tab1__WEBPACK_IMPORTED_MODULE_8__["default"], {
              version: version
            }), tab === 2 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_tabs_Tab2__WEBPACK_IMPORTED_MODULE_9__["default"], {}), tab === 3 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_tabs_Tab3__WEBPACK_IMPORTED_MODULE_10__["default"], {}), tab === 4 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_tabs_Tab4__WEBPACK_IMPORTED_MODULE_11__["default"], {}), tab === 5 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_tabs_Tab5__WEBPACK_IMPORTED_MODULE_12__["default"], {})]
          })]
        })
      })
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tabs);

/***/ }),

/***/ "./src/handler.ts":
/*!************************!*\
  !*** ./src/handler.ts ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "requestAPI": () => (/* binding */ requestAPI)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "./node_modules/@jupyterlab/services/lib/index.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);



/**
 * Call the API extension
 *
 * @param endPoint API REST end point for the extension
 * @param init Initial values for the request
 * @returns The response body interpreted as JSON
 */
async function requestAPI(endPoint = '', init = {}) {
  // Make request to Jupyter API
  const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
  const requestUrl = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.URLExt.join(settings.baseUrl, 'jupyter_functions',
  // API Namespace
  endPoint);
  let response;
  try {
    response = await _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(requestUrl, init, settings);
  } catch (error) {
    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.NetworkError(error);
  }
  let data = await response.text();
  if (data.length > 0) {
    try {
      data = JSON.parse(data);
    } catch (error) {
      console.log('Not a JSON response body.', response);
    }
  }
  if (!response.ok) {
    throw new _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.ResponseError(response, data.message || data);
  }
  return data;
}

/***/ }),

/***/ "./src/tabs/Tab1.tsx":
/*!***************************!*\
  !*** ./src/tabs/Tab1.tsx ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/ActionMenu.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Text/Text.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/ActionList/index.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Box/Box.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/ProgressBar/index.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Avatar/Avatar.js");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @primer/octicons-react */ "./node_modules/@primer/octicons-react/dist/index.esm.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data1/esm/DaskIcon.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data1/esm/PyTorchIcon.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data2/esm/TensorFlowIcon.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const Tab1 = props => {
  const {
    version
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.ActionMenu, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: ["Version: ", version]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.ActionMenu.Button, {
        children: "Kernels"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.ActionMenu.Overlay, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
            onSelect: event => console.log('New file'),
            children: "New kernel"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
            children: "Copy kernel"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
            children: "Edit kernel"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Divider, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
            variant: "danger",
            children: "Delete kernel"
          })]
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_datalayer_icons_react__WEBPACK_IMPORTED_MODULE_4__["default"], {})
        }), "Dask kernel"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_datalayer_icons_react__WEBPACK_IMPORTED_MODULE_5__["default"], {})
        }), "PyTorch Kernel"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_datalayer_icons_react__WEBPACK_IMPORTED_MODULE_6__["default"], {})
        }), "Tensorflow Kernel"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
        borderColor: "border.default",
        borderBottomWidth: 1,
        borderBottomStyle: "solid",
        pb: 3
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_8__.LinkIcon, {})
        }), "Starting..."]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_9__.ProgressBar, {
        progress: 80
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
        borderColor: "border.default",
        borderBottomWidth: 1,
        borderBottomStyle: "solid",
        pb: 3
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_10__["default"], {
            src: "https://github.com/mona.png"
          })
        }), "Me"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.Item, {
        variant: "danger",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_8__.AlertIcon, {})
        }), "4 vulnerabilities"]
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tab1);

/***/ }),

/***/ "./src/tabs/Tab2.tsx":
/*!***************************!*\
  !*** ./src/tabs/Tab2.tsx ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/TreeView/TreeView.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Octicon/Octicon.js");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/octicons-react */ "./node_modules/@primer/octicons-react/dist/index.esm.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");





const Tab2 = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.Item, {
        id: "",
        defaultExpanded: true,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.DirectoryIcon, {})
        }), "Notebooks", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.SubTree, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.Item, {
            id: "src/Avatar.tsx",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.LeadingVisual, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__.FileIcon, {})
            }), "Deep learing", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.TrailingVisual, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
                icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__.DiffAddedIcon,
                color: "success.fg",
                "aria-label": "added"
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.Item, {
            id: "",
            current: true,
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.LeadingVisual, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__.FileIcon, {})
            }), "AI for fun", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.TrailingVisual, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
                icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__.DiffModifiedIcon,
                color: "attention.fg",
                "aria-label": "modified"
              })
            })]
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.Item, {
        id: "",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__.FileIcon, {})
        }), "README.mdx", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.TreeView.TrailingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
            icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__.DiffModifiedIcon,
            color: "attention.fg",
            "aria-label": "modified"
          })
        })]
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tab2);

/***/ }),

/***/ "./src/tabs/Tab3.tsx":
/*!***************************!*\
  !*** ./src/tabs/Tab3.tsx ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Box/Box.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Button/Button.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Popover/Popover.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Heading/Heading.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Text/Text.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");




const Tab3 = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__["default"], {
      style: {
        width: 300,
        paddingTop: 20
      },
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__["default"], {
        justifyContent: "center",
        display: "flex",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ButtonComponent, {
          variant: "primary",
          children: "Hello!"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
        relative: true,
        open: true,
        caret: "top",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Content, {
          sx: {
            mt: 2
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
            sx: {
              fontSize: 2
            },
            children: "Popover heading"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_5__["default"], {
            as: "p",
            children: "Message about this particular piece of UI."
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ButtonComponent, {
            children: "Got it!"
          })]
        })
      })]
    })
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tab3);

/***/ }),

/***/ "./src/tabs/Tab4.tsx":
/*!***************************!*\
  !*** ./src/tabs/Tab4.tsx ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Box/Box.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/SubNav/SubNav.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Timeline/Timeline.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Octicon/Octicon.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Link/Link.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data1/esm/PyTorchIcon.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data2/esm/TensorFlowIcon.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data1/esm/DaskIcon.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");




const Tab4 = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__["default"], {
    m: 1,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__["default"].Links, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__["default"].Link, {
          href: "#",
          selected: true,
          children: "All"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__["default"].Link, {
          href: "#",
          children: "Recent"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__["default"].Link, {
          href: "#",
          children: "Older"
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Badge, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
            icon: _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_5__["default"]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Body, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            sx: {
              fontWeight: 'bold',
              color: 'fg.default',
              mr: 1
            },
            muted: true,
            children: "You"
          }), "created one ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            sx: {
              fontWeight: 'bold',
              color: 'fg.default',
              mr: 1
            },
            muted: true,
            children: "PyTorch Kernel"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            color: "fg.muted",
            muted: true,
            children: "Just now"
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Badge, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
            icon: _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_7__["default"]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Body, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            sx: {
              fontWeight: 'bold',
              color: 'fg.default',
              mr: 1
            },
            muted: true,
            children: "You"
          }), "created one ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            sx: {
              fontWeight: 'bold',
              color: 'fg.default',
              mr: 1
            },
            muted: true,
            children: "TensorFlow Kernel"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            color: "fg.muted",
            muted: true,
            children: "5m ago"
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Badge, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_4__["default"], {
            icon: _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_8__["default"]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_3__["default"].Body, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            sx: {
              fontWeight: 'bold',
              color: 'fg.default',
              mr: 1
            },
            muted: true,
            children: "You"
          }), "created one ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            sx: {
              fontWeight: 'bold',
              color: 'fg.default',
              mr: 1
            },
            muted: true,
            children: "Dask Kernel"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: "#",
            color: "fg.muted",
            muted: true,
            children: "7m ago"
          })]
        })]
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tab4);

/***/ }),

/***/ "./src/tabs/Tab5.tsx":
/*!***************************!*\
  !*** ./src/tabs/Tab5.tsx ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/ActionMenu.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/ActionList/index.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Avatar/Avatar.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/ProgressBar/index.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Box/Box.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Button/Button.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Popover/Popover.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Heading/Heading.js");
/* harmony import */ var _primer_react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @primer/react */ "./node_modules/@primer/react/lib-esm/Text/Text.js");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @primer/octicons-react */ "./node_modules/@primer/octicons-react/dist/index.esm.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data1/esm/DaskIcon.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data1/esm/PyTorchIcon.js");
/* harmony import */ var _datalayer_icons_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @datalayer/icons-react */ "./node_modules/@datalayer/icons-react/data2/esm/TensorFlowIcon.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");






const Tab5 = () => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.ActionMenu, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.ActionMenu.Button, {
        children: "Menu"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_1__.ActionMenu.Overlay, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
            onSelect: event => console.log('New file'),
            children: "New file"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
            children: "Copy link"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
            children: "Edit file"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Divider, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
            variant: "danger",
            children: "Delete file"
          })]
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_datalayer_icons_react__WEBPACK_IMPORTED_MODULE_3__["default"], {})
        }), "Dask kernel"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_datalayer_icons_react__WEBPACK_IMPORTED_MODULE_4__["default"], {})
        }), "PyTorch Kernel"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_datalayer_icons_react__WEBPACK_IMPORTED_MODULE_5__["default"], {})
        }), "Tensorflow Kernel"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_6__.LinkIcon, {})
        }), "github.com/primer"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
        variant: "danger",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_6__.AlertIcon, {})
        }), "4 vulnerabilities"]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.Item, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_2__.ActionList.LeadingVisual, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_7__["default"], {
            src: "https://github.com/mona.png"
          })
        }), "mona"]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_8__.ProgressBar, {
      progress: 80
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_9__["default"], {
      style: {
        width: 300,
        paddingTop: 20
      },
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_9__["default"], {
        justifyContent: "center",
        display: "flex",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_10__.ButtonComponent, {
          variant: "primary",
          children: "Hello!"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_11__["default"], {
        relative: true,
        open: true,
        caret: "top",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_primer_react__WEBPACK_IMPORTED_MODULE_11__["default"].Content, {
          sx: {
            mt: 2
          },
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_12__["default"], {
            sx: {
              fontSize: 2
            },
            children: "Popover heading"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_13__["default"], {
            as: "p",
            children: "Message about this particular piece of UI."
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_primer_react__WEBPACK_IMPORTED_MODULE_10__.ButtonComponent, {
            children: "Got it!"
          })]
        })
      })]
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tab5);

/***/ }),

/***/ "./node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isPropValid)
/* harmony export */ });
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");

var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|abbr|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|enterKeyHint|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|translate|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|incremental|fallback|inert|itemProp|itemScope|itemType|itemID|itemRef|on|option|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

var isPropValid = /* #__PURE__ */(0,_emotion_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function (prop) {
  return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
  /* o */ && prop.charCodeAt(1) === 110
  /* n */ && prop.charCodeAt(2) < 91;
}
/* Z+1 */);



/***/ }),

/***/ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ memoize)
/* harmony export */ });
function memoize(fn) {
  var cache = Object.create(null);
  return function (arg) {
    if (cache[arg] === undefined) cache[arg] = fn(arg);
    return cache[arg];
  };
}


/***/ }),

/***/ "./node_modules/@emotion/stylis/dist/stylis.browser.esm.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@emotion/stylis/dist/stylis.browser.esm.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function stylis_min(W) {
  function M(d, c, e, h, a) {
    for (var m = 0, b = 0, v = 0, n = 0, q, g, x = 0, K = 0, k, u = k = q = 0, l = 0, r = 0, I = 0, t = 0, B = e.length, J = B - 1, y, f = '', p = '', F = '', G = '', C; l < B;) {
      g = e.charCodeAt(l);
      l === J && 0 !== b + n + v + m && (0 !== b && (g = 47 === b ? 10 : 47), n = v = m = 0, B++, J++);
      if (0 === b + n + v + m) {
        if (l === J && (0 < r && (f = f.replace(N, '')), 0 < f.trim().length)) {
          switch (g) {
            case 32:
            case 9:
            case 59:
            case 13:
            case 10:
              break;
            default:
              f += e.charAt(l);
          }
          g = 59;
        }
        switch (g) {
          case 123:
            f = f.trim();
            q = f.charCodeAt(0);
            k = 1;
            for (t = ++l; l < B;) {
              switch (g = e.charCodeAt(l)) {
                case 123:
                  k++;
                  break;
                case 125:
                  k--;
                  break;
                case 47:
                  switch (g = e.charCodeAt(l + 1)) {
                    case 42:
                    case 47:
                      a: {
                        for (u = l + 1; u < J; ++u) {
                          switch (e.charCodeAt(u)) {
                            case 47:
                              if (42 === g && 42 === e.charCodeAt(u - 1) && l + 2 !== u) {
                                l = u + 1;
                                break a;
                              }
                              break;
                            case 10:
                              if (47 === g) {
                                l = u + 1;
                                break a;
                              }
                          }
                        }
                        l = u;
                      }
                  }
                  break;
                case 91:
                  g++;
                case 40:
                  g++;
                case 34:
                case 39:
                  for (; l++ < J && e.charCodeAt(l) !== g;) {}
              }
              if (0 === k) break;
              l++;
            }
            k = e.substring(t, l);
            0 === q && (q = (f = f.replace(ca, '').trim()).charCodeAt(0));
            switch (q) {
              case 64:
                0 < r && (f = f.replace(N, ''));
                g = f.charCodeAt(1);
                switch (g) {
                  case 100:
                  case 109:
                  case 115:
                  case 45:
                    r = c;
                    break;
                  default:
                    r = O;
                }
                k = M(c, r, k, g, a + 1);
                t = k.length;
                0 < A && (r = X(O, f, I), C = H(3, k, r, c, D, z, t, g, a, h), f = r.join(''), void 0 !== C && 0 === (t = (k = C.trim()).length) && (g = 0, k = ''));
                if (0 < t) switch (g) {
                  case 115:
                    f = f.replace(da, ea);
                  case 100:
                  case 109:
                  case 45:
                    k = f + '{' + k + '}';
                    break;
                  case 107:
                    f = f.replace(fa, '$1 $2');
                    k = f + '{' + k + '}';
                    k = 1 === w || 2 === w && L('@' + k, 3) ? '@-webkit-' + k + '@' + k : '@' + k;
                    break;
                  default:
                    k = f + k, 112 === h && (k = (p += k, ''));
                } else k = '';
                break;
              default:
                k = M(c, X(c, f, I), k, h, a + 1);
            }
            F += k;
            k = I = r = u = q = 0;
            f = '';
            g = e.charCodeAt(++l);
            break;
          case 125:
          case 59:
            f = (0 < r ? f.replace(N, '') : f).trim();
            if (1 < (t = f.length)) switch (0 === u && (q = f.charCodeAt(0), 45 === q || 96 < q && 123 > q) && (t = (f = f.replace(' ', ':')).length), 0 < A && void 0 !== (C = H(1, f, c, d, D, z, p.length, h, a, h)) && 0 === (t = (f = C.trim()).length) && (f = '\x00\x00'), q = f.charCodeAt(0), g = f.charCodeAt(1), q) {
              case 0:
                break;
              case 64:
                if (105 === g || 99 === g) {
                  G += f + e.charAt(l);
                  break;
                }
              default:
                58 !== f.charCodeAt(t - 1) && (p += P(f, q, g, f.charCodeAt(2)));
            }
            I = r = u = q = 0;
            f = '';
            g = e.charCodeAt(++l);
        }
      }
      switch (g) {
        case 13:
        case 10:
          47 === b ? b = 0 : 0 === 1 + q && 107 !== h && 0 < f.length && (r = 1, f += '\x00');
          0 < A * Y && H(0, f, c, d, D, z, p.length, h, a, h);
          z = 1;
          D++;
          break;
        case 59:
        case 125:
          if (0 === b + n + v + m) {
            z++;
            break;
          }
        default:
          z++;
          y = e.charAt(l);
          switch (g) {
            case 9:
            case 32:
              if (0 === n + m + b) switch (x) {
                case 44:
                case 58:
                case 9:
                case 32:
                  y = '';
                  break;
                default:
                  32 !== g && (y = ' ');
              }
              break;
            case 0:
              y = '\\0';
              break;
            case 12:
              y = '\\f';
              break;
            case 11:
              y = '\\v';
              break;
            case 38:
              0 === n + b + m && (r = I = 1, y = '\f' + y);
              break;
            case 108:
              if (0 === n + b + m + E && 0 < u) switch (l - u) {
                case 2:
                  112 === x && 58 === e.charCodeAt(l - 3) && (E = x);
                case 8:
                  111 === K && (E = K);
              }
              break;
            case 58:
              0 === n + b + m && (u = l);
              break;
            case 44:
              0 === b + v + n + m && (r = 1, y += '\r');
              break;
            case 34:
            case 39:
              0 === b && (n = n === g ? 0 : 0 === n ? g : n);
              break;
            case 91:
              0 === n + b + v && m++;
              break;
            case 93:
              0 === n + b + v && m--;
              break;
            case 41:
              0 === n + b + m && v--;
              break;
            case 40:
              if (0 === n + b + m) {
                if (0 === q) switch (2 * x + 3 * K) {
                  case 533:
                    break;
                  default:
                    q = 1;
                }
                v++;
              }
              break;
            case 64:
              0 === b + v + n + m + u + k && (k = 1);
              break;
            case 42:
            case 47:
              if (!(0 < n + m + v)) switch (b) {
                case 0:
                  switch (2 * g + 3 * e.charCodeAt(l + 1)) {
                    case 235:
                      b = 47;
                      break;
                    case 220:
                      t = l, b = 42;
                  }
                  break;
                case 42:
                  47 === g && 42 === x && t + 2 !== l && (33 === e.charCodeAt(t + 2) && (p += e.substring(t, l + 1)), y = '', b = 0);
              }
          }
          0 === b && (f += y);
      }
      K = x;
      x = g;
      l++;
    }
    t = p.length;
    if (0 < t) {
      r = c;
      if (0 < A && (C = H(2, p, r, d, D, z, t, h, a, h), void 0 !== C && 0 === (p = C).length)) return G + p + F;
      p = r.join(',') + '{' + p + '}';
      if (0 !== w * E) {
        2 !== w || L(p, 2) || (E = 0);
        switch (E) {
          case 111:
            p = p.replace(ha, ':-moz-$1') + p;
            break;
          case 112:
            p = p.replace(Q, '::-webkit-input-$1') + p.replace(Q, '::-moz-$1') + p.replace(Q, ':-ms-input-$1') + p;
        }
        E = 0;
      }
    }
    return G + p + F;
  }
  function X(d, c, e) {
    var h = c.trim().split(ia);
    c = h;
    var a = h.length,
      m = d.length;
    switch (m) {
      case 0:
      case 1:
        var b = 0;
        for (d = 0 === m ? '' : d[0] + ' '; b < a; ++b) {
          c[b] = Z(d, c[b], e).trim();
        }
        break;
      default:
        var v = b = 0;
        for (c = []; b < a; ++b) {
          for (var n = 0; n < m; ++n) {
            c[v++] = Z(d[n] + ' ', h[b], e).trim();
          }
        }
    }
    return c;
  }
  function Z(d, c, e) {
    var h = c.charCodeAt(0);
    33 > h && (h = (c = c.trim()).charCodeAt(0));
    switch (h) {
      case 38:
        return c.replace(F, '$1' + d.trim());
      case 58:
        return d.trim() + c.replace(F, '$1' + d.trim());
      default:
        if (0 < 1 * e && 0 < c.indexOf('\f')) return c.replace(F, (58 === d.charCodeAt(0) ? '' : '$1') + d.trim());
    }
    return d + c;
  }
  function P(d, c, e, h) {
    var a = d + ';',
      m = 2 * c + 3 * e + 4 * h;
    if (944 === m) {
      d = a.indexOf(':', 9) + 1;
      var b = a.substring(d, a.length - 1).trim();
      b = a.substring(0, d).trim() + b + ';';
      return 1 === w || 2 === w && L(b, 1) ? '-webkit-' + b + b : b;
    }
    if (0 === w || 2 === w && !L(a, 1)) return a;
    switch (m) {
      case 1015:
        return 97 === a.charCodeAt(10) ? '-webkit-' + a + a : a;
      case 951:
        return 116 === a.charCodeAt(3) ? '-webkit-' + a + a : a;
      case 963:
        return 110 === a.charCodeAt(5) ? '-webkit-' + a + a : a;
      case 1009:
        if (100 !== a.charCodeAt(4)) break;
      case 969:
      case 942:
        return '-webkit-' + a + a;
      case 978:
        return '-webkit-' + a + '-moz-' + a + a;
      case 1019:
      case 983:
        return '-webkit-' + a + '-moz-' + a + '-ms-' + a + a;
      case 883:
        if (45 === a.charCodeAt(8)) return '-webkit-' + a + a;
        if (0 < a.indexOf('image-set(', 11)) return a.replace(ja, '$1-webkit-$2') + a;
        break;
      case 932:
        if (45 === a.charCodeAt(4)) switch (a.charCodeAt(5)) {
          case 103:
            return '-webkit-box-' + a.replace('-grow', '') + '-webkit-' + a + '-ms-' + a.replace('grow', 'positive') + a;
          case 115:
            return '-webkit-' + a + '-ms-' + a.replace('shrink', 'negative') + a;
          case 98:
            return '-webkit-' + a + '-ms-' + a.replace('basis', 'preferred-size') + a;
        }
        return '-webkit-' + a + '-ms-' + a + a;
      case 964:
        return '-webkit-' + a + '-ms-flex-' + a + a;
      case 1023:
        if (99 !== a.charCodeAt(8)) break;
        b = a.substring(a.indexOf(':', 15)).replace('flex-', '').replace('space-between', 'justify');
        return '-webkit-box-pack' + b + '-webkit-' + a + '-ms-flex-pack' + b + a;
      case 1005:
        return ka.test(a) ? a.replace(aa, ':-webkit-') + a.replace(aa, ':-moz-') + a : a;
      case 1e3:
        b = a.substring(13).trim();
        c = b.indexOf('-') + 1;
        switch (b.charCodeAt(0) + b.charCodeAt(c)) {
          case 226:
            b = a.replace(G, 'tb');
            break;
          case 232:
            b = a.replace(G, 'tb-rl');
            break;
          case 220:
            b = a.replace(G, 'lr');
            break;
          default:
            return a;
        }
        return '-webkit-' + a + '-ms-' + b + a;
      case 1017:
        if (-1 === a.indexOf('sticky', 9)) break;
      case 975:
        c = (a = d).length - 10;
        b = (33 === a.charCodeAt(c) ? a.substring(0, c) : a).substring(d.indexOf(':', 7) + 1).trim();
        switch (m = b.charCodeAt(0) + (b.charCodeAt(7) | 0)) {
          case 203:
            if (111 > b.charCodeAt(8)) break;
          case 115:
            a = a.replace(b, '-webkit-' + b) + ';' + a;
            break;
          case 207:
          case 102:
            a = a.replace(b, '-webkit-' + (102 < m ? 'inline-' : '') + 'box') + ';' + a.replace(b, '-webkit-' + b) + ';' + a.replace(b, '-ms-' + b + 'box') + ';' + a;
        }
        return a + ';';
      case 938:
        if (45 === a.charCodeAt(5)) switch (a.charCodeAt(6)) {
          case 105:
            return b = a.replace('-items', ''), '-webkit-' + a + '-webkit-box-' + b + '-ms-flex-' + b + a;
          case 115:
            return '-webkit-' + a + '-ms-flex-item-' + a.replace(ba, '') + a;
          default:
            return '-webkit-' + a + '-ms-flex-line-pack' + a.replace('align-content', '').replace(ba, '') + a;
        }
        break;
      case 973:
      case 989:
        if (45 !== a.charCodeAt(3) || 122 === a.charCodeAt(4)) break;
      case 931:
      case 953:
        if (!0 === la.test(d)) return 115 === (b = d.substring(d.indexOf(':') + 1)).charCodeAt(0) ? P(d.replace('stretch', 'fill-available'), c, e, h).replace(':fill-available', ':stretch') : a.replace(b, '-webkit-' + b) + a.replace(b, '-moz-' + b.replace('fill-', '')) + a;
        break;
      case 962:
        if (a = '-webkit-' + a + (102 === a.charCodeAt(5) ? '-ms-' + a : '') + a, 211 === e + h && 105 === a.charCodeAt(13) && 0 < a.indexOf('transform', 10)) return a.substring(0, a.indexOf(';', 27) + 1).replace(ma, '$1-webkit-$2') + a;
    }
    return a;
  }
  function L(d, c) {
    var e = d.indexOf(1 === c ? ':' : '{'),
      h = d.substring(0, 3 !== c ? e : 10);
    e = d.substring(e + 1, d.length - 1);
    return R(2 !== c ? h : h.replace(na, '$1'), e, c);
  }
  function ea(d, c) {
    var e = P(c, c.charCodeAt(0), c.charCodeAt(1), c.charCodeAt(2));
    return e !== c + ';' ? e.replace(oa, ' or ($1)').substring(4) : '(' + c + ')';
  }
  function H(d, c, e, h, a, m, b, v, n, q) {
    for (var g = 0, x = c, w; g < A; ++g) {
      switch (w = S[g].call(B, d, x, e, h, a, m, b, v, n, q)) {
        case void 0:
        case !1:
        case !0:
        case null:
          break;
        default:
          x = w;
      }
    }
    if (x !== c) return x;
  }
  function T(d) {
    switch (d) {
      case void 0:
      case null:
        A = S.length = 0;
        break;
      default:
        if ('function' === typeof d) S[A++] = d;else if ('object' === typeof d) for (var c = 0, e = d.length; c < e; ++c) {
          T(d[c]);
        } else Y = !!d | 0;
    }
    return T;
  }
  function U(d) {
    d = d.prefix;
    void 0 !== d && (R = null, d ? 'function' !== typeof d ? w = 1 : (w = 2, R = d) : w = 0);
    return U;
  }
  function B(d, c) {
    var e = d;
    33 > e.charCodeAt(0) && (e = e.trim());
    V = e;
    e = [V];
    if (0 < A) {
      var h = H(-1, c, e, e, D, z, 0, 0, 0, 0);
      void 0 !== h && 'string' === typeof h && (c = h);
    }
    var a = M(O, e, c, 0, 0);
    0 < A && (h = H(-2, a, e, e, D, z, a.length, 0, 0, 0), void 0 !== h && (a = h));
    V = '';
    E = 0;
    z = D = 1;
    return a;
  }
  var ca = /^\0+/g,
    N = /[\0\r\f]/g,
    aa = /: */g,
    ka = /zoo|gra/,
    ma = /([,: ])(transform)/g,
    ia = /,\r+?/g,
    F = /([\t\r\n ])*\f?&/g,
    fa = /@(k\w+)\s*(\S*)\s*/,
    Q = /::(place)/g,
    ha = /:(read-only)/g,
    G = /[svh]\w+-[tblr]{2}/,
    da = /\(\s*(.*)\s*\)/g,
    oa = /([\s\S]*?);/g,
    ba = /-self|flex-/g,
    na = /[^]*?(:[rp][el]a[\w-]+)[^]*/,
    la = /stretch|:\s*\w+\-(?:conte|avail)/,
    ja = /([^-])(image-set\()/,
    z = 1,
    D = 1,
    E = 0,
    w = 1,
    O = [],
    S = [],
    A = 0,
    R = null,
    Y = 0,
    V = '';
  B.use = T;
  B.set = U;
  void 0 !== W && U(W);
  return B;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (stylis_min);

/***/ }),

/***/ "./node_modules/@emotion/unitless/dist/unitless.browser.esm.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@emotion/unitless/dist/unitless.browser.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var unitlessKeys = {
  animationIterationCount: 1,
  borderImageOutset: 1,
  borderImageSlice: 1,
  borderImageWidth: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  columns: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridRowEnd: 1,
  gridRowSpan: 1,
  gridRowStart: 1,
  gridColumn: 1,
  gridColumnEnd: 1,
  gridColumnSpan: 1,
  gridColumnStart: 1,
  msGridRow: 1,
  msGridRowSpan: 1,
  msGridColumn: 1,
  msGridColumnSpan: 1,
  fontWeight: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  WebkitLineClamp: 1,
  // SVG-related properties
  fillOpacity: 1,
  floodOpacity: 1,
  stopOpacity: 1,
  strokeDasharray: 1,
  strokeDashoffset: 1,
  strokeMiterlimit: 1,
  strokeOpacity: 1,
  strokeWidth: 1
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (unitlessKeys);

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/activitymonitor.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/activitymonitor.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ActivityMonitor = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/**
 * A class that monitors activity on a signal.
 */
class ActivityMonitor {
  /**
   * Construct a new activity monitor.
   */
  constructor(options) {
    this._timer = -1;
    this._timeout = -1;
    this._isDisposed = false;
    this._activityStopped = new signaling_1.Signal(this);
    options.signal.connect(this._onSignalFired, this);
    this._timeout = options.timeout || 1000;
  }
  /**
   * A signal emitted when activity has ceased.
   */
  get activityStopped() {
    return this._activityStopped;
  }
  /**
   * The timeout associated with the monitor, in milliseconds.
   */
  get timeout() {
    return this._timeout;
  }
  set timeout(value) {
    this._timeout = value;
  }
  /**
   * Test whether the monitor has been disposed.
   *
   * #### Notes
   * This is a read-only property.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Dispose of the resources used by the activity monitor.
   */
  dispose() {
    if (this._isDisposed) {
      return;
    }
    this._isDisposed = true;
    signaling_1.Signal.clearData(this);
  }
  /**
   * A signal handler for the monitored signal.
   */
  _onSignalFired(sender, args) {
    clearTimeout(this._timer);
    this._sender = sender;
    this._args = args;
    this._timer = setTimeout(() => {
      this._activityStopped.emit({
        sender: this._sender,
        args: this._args
      });
    }, this._timeout);
  }
}
exports.ActivityMonitor = ActivityMonitor;

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/index.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module coreutils
 */
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = this && this.__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
__exportStar(__webpack_require__(/*! ./activitymonitor */ "./node_modules/@jupyterlab/coreutils/lib/activitymonitor.js"), exports);
__exportStar(__webpack_require__(/*! ./interfaces */ "./node_modules/@jupyterlab/coreutils/lib/interfaces.js"), exports);
__exportStar(__webpack_require__(/*! ./markdowncodeblocks */ "./node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js"), exports);
__exportStar(__webpack_require__(/*! ./pageconfig */ "./node_modules/@jupyterlab/coreutils/lib/pageconfig.js"), exports);
__exportStar(__webpack_require__(/*! ./path */ "./node_modules/@jupyterlab/coreutils/lib/path.js"), exports);
__exportStar(__webpack_require__(/*! ./signal */ "./node_modules/@jupyterlab/coreutils/lib/signal.js"), exports);
__exportStar(__webpack_require__(/*! ./text */ "./node_modules/@jupyterlab/coreutils/lib/text.js"), exports);
__exportStar(__webpack_require__(/*! ./time */ "./node_modules/@jupyterlab/coreutils/lib/time.js"), exports);
__exportStar(__webpack_require__(/*! ./url */ "./node_modules/@jupyterlab/coreutils/lib/url.js"), exports);

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/interfaces.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/interfaces.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MarkdownCodeBlocks = void 0;
/**
 * The namespace for code block functions which help
 * in extract code from markdown text
 */
var MarkdownCodeBlocks;
(function (MarkdownCodeBlocks) {
  MarkdownCodeBlocks.CODE_BLOCK_MARKER = '```';
  const markdownExtensions = ['.markdown', '.mdown', '.mkdn', '.md', '.mkd', '.mdwn', '.mdtxt', '.mdtext', '.text', '.txt', '.Rmd'];
  class MarkdownCodeBlock {
    constructor(startLine) {
      this.startLine = startLine;
      this.code = '';
      this.endLine = -1;
    }
  }
  MarkdownCodeBlocks.MarkdownCodeBlock = MarkdownCodeBlock;
  /**
   * Check whether the given file extension is a markdown extension
   * @param extension - A file extension
   *
   * @returns true/false depending on whether this is a supported markdown extension
   */
  function isMarkdown(extension) {
    return markdownExtensions.indexOf(extension) > -1;
  }
  MarkdownCodeBlocks.isMarkdown = isMarkdown;
  /**
   * Construct all code snippets from current text
   * (this could be potentially optimized if we can cache and detect differences)
   * @param text - A string to parse codeblocks from
   *
   * @returns An array of MarkdownCodeBlocks.
   */
  function findMarkdownCodeBlocks(text) {
    if (!text || text === '') {
      return [];
    }
    const lines = text.split('\n');
    const codeBlocks = [];
    let currentBlock = null;
    for (let lineIndex = 0; lineIndex < lines.length; lineIndex++) {
      const line = lines[lineIndex];
      const lineContainsMarker = line.indexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER) === 0;
      const constructingBlock = currentBlock != null;
      // Skip this line if it is not part of any code block and doesn't contain a marker.
      if (!lineContainsMarker && !constructingBlock) {
        continue;
      }
      // Check if we are already constructing a code block.
      if (!constructingBlock) {
        // Start constructing a new code block.
        currentBlock = new MarkdownCodeBlock(lineIndex);
        // Check whether this is a single line code block of the form ```a = 10```.
        const firstIndex = line.indexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER);
        const lastIndex = line.lastIndexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER);
        const isSingleLine = firstIndex !== lastIndex;
        if (isSingleLine) {
          currentBlock.code = line.substring(firstIndex + MarkdownCodeBlocks.CODE_BLOCK_MARKER.length, lastIndex);
          currentBlock.endLine = lineIndex;
          codeBlocks.push(currentBlock);
          currentBlock = null;
        }
      } else if (currentBlock) {
        if (lineContainsMarker) {
          // End of block, finish it up.
          currentBlock.endLine = lineIndex - 1;
          codeBlocks.push(currentBlock);
          currentBlock = null;
        } else {
          // Append the current line.
          currentBlock.code += line + '\n';
        }
      }
    }
    return codeBlocks;
  }
  MarkdownCodeBlocks.findMarkdownCodeBlocks = findMarkdownCodeBlocks;
})(MarkdownCodeBlocks = exports.MarkdownCodeBlocks || (exports.MarkdownCodeBlocks = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/pageconfig.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/pageconfig.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process/browser */ "./node_modules/process/browser.js");


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PageConfig = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
const minimist_1 = __importDefault(__webpack_require__(/*! minimist */ "./node_modules/minimist/index.js"));
const url_1 = __webpack_require__(/*! ./url */ "./node_modules/@jupyterlab/coreutils/lib/url.js");
/**
 * The namespace for `PageConfig` functions.
 */
var PageConfig;
(function (PageConfig) {
  /**
   * Get global configuration data for the Jupyter application.
   *
   * @param name - The name of the configuration option.
   *
   * @returns The config value or an empty string if not found.
   *
   * #### Notes
   * All values are treated as strings.
   * For browser based applications, it is assumed that the page HTML
   * includes a script tag with the id `jupyter-config-data` containing the
   * configuration as valid JSON.  In order to support the classic Notebook,
   * we fall back on checking for `body` data of the given `name`.
   *
   * For node applications, it is assumed that the process was launched
   * with a `--jupyter-config-data` option pointing to a JSON settings
   * file.
   */
  function getOption(name) {
    if (configData) {
      return configData[name] || getBodyData(name);
    }
    configData = Object.create(null);
    let found = false;
    // Use script tag if available.
    if (typeof document !== 'undefined' && document) {
      const el = document.getElementById('jupyter-config-data');
      if (el) {
        configData = JSON.parse(el.textContent || '');
        found = true;
      }
    }
    // Otherwise use CLI if given.
    if (!found && typeof process !== 'undefined' && process.argv) {
      try {
        const cli = (0, minimist_1.default)(process.argv.slice(2));
        const path = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js");
        let fullPath = '';
        if ('jupyter-config-data' in cli) {
          fullPath = path.resolve(cli['jupyter-config-data']);
        } else if ('JUPYTER_CONFIG_DATA' in process.env) {
          fullPath = path.resolve(process.env['JUPYTER_CONFIG_DATA']);
        }
        if (fullPath) {
          // Force Webpack to ignore this require.
          // eslint-disable-next-line
          configData = eval('require')(fullPath);
        }
      } catch (e) {
        console.error(e);
      }
    }
    if (!coreutils_1.JSONExt.isObject(configData)) {
      configData = Object.create(null);
    } else {
      for (const key in configData) {
        // PageConfig expects strings
        if (typeof configData[key] !== 'string') {
          configData[key] = JSON.stringify(configData[key]);
        }
      }
    }
    return configData[name] || getBodyData(name);
  }
  PageConfig.getOption = getOption;
  /**
   * Set global configuration data for the Jupyter application.
   *
   * @param name - The name of the configuration option.
   * @param value - The value to set the option to.
   *
   * @returns The last config value or an empty string if it doesn't exist.
   */
  function setOption(name, value) {
    const last = getOption(name);
    configData[name] = value;
    return last;
  }
  PageConfig.setOption = setOption;
  /**
   * Get the base url for a Jupyter application, or the base url of the page.
   */
  function getBaseUrl() {
    return url_1.URLExt.normalize(getOption('baseUrl') || '/');
  }
  PageConfig.getBaseUrl = getBaseUrl;
  /**
   * Get the tree url for a JupyterLab application.
   */
  function getTreeUrl() {
    return url_1.URLExt.join(getBaseUrl(), getOption('treeUrl'));
  }
  PageConfig.getTreeUrl = getTreeUrl;
  /**
   * Get the base url for sharing links (usually baseUrl)
   */
  function getShareUrl() {
    return url_1.URLExt.normalize(getOption('shareUrl') || getBaseUrl());
  }
  PageConfig.getShareUrl = getShareUrl;
  /**
   * Get the tree url for shareable links.
   * Usually the same as treeUrl,
   * but overrideable e.g. when sharing with JupyterHub.
   */
  function getTreeShareUrl() {
    return url_1.URLExt.normalize(url_1.URLExt.join(getShareUrl(), getOption('treeUrl')));
  }
  PageConfig.getTreeShareUrl = getTreeShareUrl;
  /**
   * Create a new URL given an optional mode and tree path.
   *
   * This is used to create URLS when the mode or tree path change as the user
   * changes mode or the current document in the main area. If fields in
   * options are omitted, the value in PageConfig will be used.
   *
   * @param options - IGetUrlOptions for the new path.
   */
  function getUrl(options) {
    var _a, _b, _c, _d;
    let path = options.toShare ? getShareUrl() : getBaseUrl();
    const mode = (_a = options.mode) !== null && _a !== void 0 ? _a : getOption('mode');
    const workspace = (_b = options.workspace) !== null && _b !== void 0 ? _b : getOption('workspace');
    const labOrDoc = mode === 'single-document' ? 'doc' : 'lab';
    path = url_1.URLExt.join(path, labOrDoc);
    if (workspace !== PageConfig.defaultWorkspace) {
      path = url_1.URLExt.join(path, 'workspaces', encodeURIComponent((_c = getOption('workspace')) !== null && _c !== void 0 ? _c : PageConfig.defaultWorkspace));
    }
    const treePath = (_d = options.treePath) !== null && _d !== void 0 ? _d : getOption('treePath');
    if (treePath) {
      path = url_1.URLExt.join(path, 'tree', url_1.URLExt.encodeParts(treePath));
    }
    return path;
  }
  PageConfig.getUrl = getUrl;
  PageConfig.defaultWorkspace = 'default';
  /**
   * Get the base websocket url for a Jupyter application, or an empty string.
   */
  function getWsUrl(baseUrl) {
    let wsUrl = getOption('wsUrl');
    if (!wsUrl) {
      baseUrl = baseUrl ? url_1.URLExt.normalize(baseUrl) : getBaseUrl();
      if (baseUrl.indexOf('http') !== 0) {
        return '';
      }
      wsUrl = 'ws' + baseUrl.slice(4);
    }
    return url_1.URLExt.normalize(wsUrl);
  }
  PageConfig.getWsUrl = getWsUrl;
  /**
   * Returns the URL converting this notebook to a certain
   * format with nbconvert.
   */
  function getNBConvertURL({
    path,
    format,
    download
  }) {
    const notebookPath = url_1.URLExt.encodeParts(path);
    const url = url_1.URLExt.join(getBaseUrl(), 'nbconvert', format, notebookPath);
    if (download) {
      return url + '?download=true';
    }
    return url;
  }
  PageConfig.getNBConvertURL = getNBConvertURL;
  /**
   * Get the authorization token for a Jupyter application.
   */
  function getToken() {
    return getOption('token') || getBodyData('jupyterApiToken');
  }
  PageConfig.getToken = getToken;
  /**
   * Get the Notebook version info [major, minor, patch].
   */
  function getNotebookVersion() {
    const notebookVersion = getOption('notebookVersion');
    if (notebookVersion === '') {
      return [0, 0, 0];
    }
    return JSON.parse(notebookVersion);
  }
  PageConfig.getNotebookVersion = getNotebookVersion;
  /**
   * Private page config data for the Jupyter application.
   */
  let configData = null;
  /**
   * Get a url-encoded item from `body.data` and decode it
   * We should never have any encoded URLs anywhere else in code
   * until we are building an actual request.
   */
  function getBodyData(key) {
    if (typeof document === 'undefined' || !document.body) {
      return '';
    }
    const val = document.body.dataset[key];
    if (typeof val === 'undefined') {
      return '';
    }
    return decodeURIComponent(val);
  }
  /**
   * The namespace for page config `Extension` functions.
   */
  let Extension;
  (function (Extension) {
    /**
     * Populate an array from page config.
     *
     * @param key - The page config key (e.g., `deferredExtensions`).
     *
     * #### Notes
     * This is intended for `deferredExtensions` and `disabledExtensions`.
     */
    function populate(key) {
      try {
        const raw = getOption(key);
        if (raw) {
          return JSON.parse(raw);
        }
      } catch (error) {
        console.warn(`Unable to parse ${key}.`, error);
      }
      return [];
    }
    /**
     * The collection of deferred extensions in page config.
     */
    Extension.deferred = populate('deferredExtensions');
    /**
     * The collection of disabled extensions in page config.
     */
    Extension.disabled = populate('disabledExtensions');
    /**
     * Returns whether a plugin is deferred.
     *
     * @param id - The plugin ID.
     */
    function isDeferred(id) {
      // Check for either a full plugin id match or an extension
      // name match.
      const separatorIndex = id.indexOf(':');
      let extName = '';
      if (separatorIndex !== -1) {
        extName = id.slice(0, separatorIndex);
      }
      return Extension.deferred.some(val => val === id || extName && val === extName);
    }
    Extension.isDeferred = isDeferred;
    /**
     * Returns whether a plugin is disabled.
     *
     * @param id - The plugin ID.
     */
    function isDisabled(id) {
      // Check for either a full plugin id match or an extension
      // name match.
      const separatorIndex = id.indexOf(':');
      let extName = '';
      if (separatorIndex !== -1) {
        extName = id.slice(0, separatorIndex);
      }
      return Extension.disabled.some(val => val === id || extName && val === extName);
    }
    Extension.isDisabled = isDisabled;
  })(Extension = PageConfig.Extension || (PageConfig.Extension = {}));
})(PageConfig = exports.PageConfig || (exports.PageConfig = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/path.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/path.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PathExt = void 0;
const path_1 = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js");
/**
 * The namespace for path-related functions.
 *
 * Note that Jupyter server paths do not start with a leading slash.
 */
var PathExt;
(function (PathExt) {
  /**
   * Join all arguments together and normalize the resulting path.
   * Arguments must be strings. In v0.8, non-string arguments were silently ignored. In v0.10 and up, an exception is thrown.
   *
   * @param paths - The string paths to join.
   */
  function join(...paths) {
    const path = path_1.posix.join(...paths);
    return path === '.' ? '' : removeSlash(path);
  }
  PathExt.join = join;
  /**
   * Return the last portion of a path. Similar to the Unix basename command.
   * Often used to extract the file name from a fully qualified path.
   *
   * @param path - The path to evaluate.
   *
   * @param ext - An extension to remove from the result.
   */
  function basename(path, ext) {
    return path_1.posix.basename(path, ext);
  }
  PathExt.basename = basename;
  /**
   * Get the directory name of a path, similar to the Unix dirname command.
   * When an empty path is given, returns the root path.
   *
   * @param path - The file path.
   */
  function dirname(path) {
    const dir = removeSlash(path_1.posix.dirname(path));
    return dir === '.' ? '' : dir;
  }
  PathExt.dirname = dirname;
  /**
   * Get the extension of the path.
   *
   * @param path - The file path.
   *
   * @returns the extension of the file.
   *
   * #### Notes
   * The extension is the string from the last occurrence of the `.`
   * character to end of string in the last portion of the path, inclusive.
   * If there is no `.` in the last portion of the path, or if the first
   * character of the basename of path [[basename]] is `.`, then an
   * empty string is returned.
   */
  function extname(path) {
    return path_1.posix.extname(path);
  }
  PathExt.extname = extname;
  /**
   * Normalize a string path, reducing '..' and '.' parts.
   * When multiple slashes are found, they're replaced by a single one; when the path contains a trailing slash, it is preserved. On Windows backslashes are used.
   * When an empty path is given, returns the root path.
   *
   * @param path - The string path to normalize.
   */
  function normalize(path) {
    if (path === '') {
      return '';
    }
    return removeSlash(path_1.posix.normalize(path));
  }
  PathExt.normalize = normalize;
  /**
   * Resolve a sequence of paths or path segments into an absolute path.
   * The root path in the application has no leading slash, so it is removed.
   *
   * @param parts - The paths to join.
   *
   * #### Notes
   * The right-most parameter is considered \{to\}.  Other parameters are considered an array of \{from\}.
   *
   * Starting from leftmost \{from\} parameter, resolves \{to\} to an absolute path.
   *
   * If \{to\} isn't already absolute, \{from\} arguments are prepended in right to left order, until an absolute path is found. If after using all \{from\} paths still no absolute path is found, the current working directory is used as well. The resulting path is normalized, and trailing slashes are removed unless the path gets resolved to the root directory.
   */
  function resolve(...parts) {
    return removeSlash(path_1.posix.resolve(...parts));
  }
  PathExt.resolve = resolve;
  /**
   * Solve the relative path from \{from\} to \{to\}.
   *
   * @param from - The source path.
   *
   * @param to - The target path.
   *
   * #### Notes
   * If from and to each resolve to the same path (after calling
   * path.resolve() on each), a zero-length string is returned.
   * If a zero-length string is passed as from or to, `/`
   * will be used instead of the zero-length strings.
   */
  function relative(from, to) {
    return removeSlash(path_1.posix.relative(from, to));
  }
  PathExt.relative = relative;
  /**
   * Normalize a file extension to be of the type `'.foo'`.
   *
   * @param extension - the file extension.
   *
   * #### Notes
   * Adds a leading dot if not present and converts to lower case.
   */
  function normalizeExtension(extension) {
    if (extension.length > 0 && extension.indexOf('.') !== 0) {
      extension = `.${extension}`;
    }
    return extension;
  }
  PathExt.normalizeExtension = normalizeExtension;
  /**
   * Remove the leading slash from a path.
   *
   * @param path: the path from which to remove a leading slash.
   */
  function removeSlash(path) {
    if (path.indexOf('/') === 0) {
      path = path.slice(1);
    }
    return path;
  }
  PathExt.removeSlash = removeSlash;
})(PathExt = exports.PathExt || (exports.PathExt = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/signal.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/signal.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.signalToPromise = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
/**
 * Convert a signal into a promise for the first emitted value.
 *
 * @param signal - The signal we are listening to.
 * @param timeout - Timeout to wait for signal in ms (not timeout if not defined or 0)
 *
 * @returns a Promise that resolves with a `(sender, args)` pair.
 */
function signalToPromise(signal, timeout) {
  const waitForSignal = new coreutils_1.PromiseDelegate();
  function cleanup() {
    signal.disconnect(slot);
  }
  function slot(sender, args) {
    cleanup();
    waitForSignal.resolve([sender, args]);
  }
  signal.connect(slot);
  if ((timeout !== null && timeout !== void 0 ? timeout : 0) > 0) {
    setTimeout(() => {
      cleanup();
      waitForSignal.reject(`Signal not emitted within ${timeout} ms.`);
    }, timeout);
  }
  return waitForSignal.promise;
}
exports.signalToPromise = signalToPromise;

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/text.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/text.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Text = void 0;
/**
 * The namespace for text-related functions.
 */
var Text;
(function (Text) {
  // javascript stores text as utf16 and string indices use "code units",
  // which stores high-codepoint characters as "surrogate pairs",
  // which occupy two indices in the javascript string.
  // We need to translate cursor_pos in the Jupyter protocol (in characters)
  // to js offset (with surrogate pairs taking two spots).
  const HAS_SURROGATES = '𝐚'.length > 1;
  /**
   * Convert a javascript string index into a unicode character offset
   *
   * @param jsIdx - The javascript string index (counting surrogate pairs)
   *
   * @param text - The text in which the offset is calculated
   *
   * @returns The unicode character offset
   */
  function jsIndexToCharIndex(jsIdx, text) {
    if (HAS_SURROGATES) {
      // not using surrogates, nothing to do
      return jsIdx;
    }
    let charIdx = jsIdx;
    for (let i = 0; i + 1 < text.length && i < jsIdx; i++) {
      const charCode = text.charCodeAt(i);
      // check for surrogate pair
      if (charCode >= 0xd800 && charCode <= 0xdbff) {
        const nextCharCode = text.charCodeAt(i + 1);
        if (nextCharCode >= 0xdc00 && nextCharCode <= 0xdfff) {
          charIdx--;
          i++;
        }
      }
    }
    return charIdx;
  }
  Text.jsIndexToCharIndex = jsIndexToCharIndex;
  /**
   * Convert a unicode character offset to a javascript string index.
   *
   * @param charIdx - The index in unicode characters
   *
   * @param text - The text in which the offset is calculated
   *
   * @returns The js-native index
   */
  function charIndexToJsIndex(charIdx, text) {
    if (HAS_SURROGATES) {
      // not using surrogates, nothing to do
      return charIdx;
    }
    let jsIdx = charIdx;
    for (let i = 0; i + 1 < text.length && i < jsIdx; i++) {
      const charCode = text.charCodeAt(i);
      // check for surrogate pair
      if (charCode >= 0xd800 && charCode <= 0xdbff) {
        const nextCharCode = text.charCodeAt(i + 1);
        if (nextCharCode >= 0xdc00 && nextCharCode <= 0xdfff) {
          jsIdx++;
          i++;
        }
      }
    }
    return jsIdx;
  }
  Text.charIndexToJsIndex = charIndexToJsIndex;
  /**
   * Given a 'snake-case', 'snake_case', 'snake:case', or
   * 'snake case' string, will return the camel case version: 'snakeCase'.
   *
   * @param str: the snake-case input string.
   *
   * @param upper: default = false. If true, the first letter of the
   * returned string will be capitalized.
   *
   * @returns the camel case version of the input string.
   */
  function camelCase(str, upper = false) {
    return str.replace(/^(\w)|[\s-_:]+(\w)/g, function (match, p1, p2) {
      if (p2) {
        return p2.toUpperCase();
      } else {
        return upper ? p1.toUpperCase() : p1.toLowerCase();
      }
    });
  }
  Text.camelCase = camelCase;
  /**
   * Given a string, title case the words in the string.
   *
   * @param str: the string to title case.
   *
   * @returns the same string, but with each word capitalized.
   */
  function titleCase(str) {
    return (str || '').toLowerCase().split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(' ');
  }
  Text.titleCase = titleCase;
})(Text = exports.Text || (exports.Text = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/time.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/time.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Time = void 0;
/**
 * A list of time units with their associated value in milliseconds.
 */
const UNITS = [{
  name: 'years',
  milliseconds: 365 * 24 * 60 * 60 * 1000
}, {
  name: 'months',
  milliseconds: 30 * 24 * 60 * 60 * 1000
}, {
  name: 'days',
  milliseconds: 24 * 60 * 60 * 1000
}, {
  name: 'hours',
  milliseconds: 60 * 60 * 1000
}, {
  name: 'minutes',
  milliseconds: 60 * 1000
}, {
  name: 'seconds',
  milliseconds: 1000
}];
/**
 * The namespace for date functions.
 */
var Time;
(function (Time) {
  /**
   * Convert a timestring to a human readable string (e.g. 'two minutes ago').
   *
   * @param value - The date timestring or date object.
   *
   * @returns A formatted date.
   */
  function formatHuman(value) {
    const lang = document.documentElement.lang || 'en';
    const formatter = new Intl.RelativeTimeFormat(lang, {
      numeric: 'auto'
    });
    const delta = new Date(value).getTime() - Date.now();
    for (let unit of UNITS) {
      const amount = Math.ceil(delta / unit.milliseconds);
      if (amount === 0) {
        continue;
      }
      return formatter.format(amount, unit.name);
    }
    return formatter.format(0, 'seconds');
  }
  Time.formatHuman = formatHuman;
  /**
   * Convenient helper to convert a timestring to a date format.
   *
   * @param value - The date timestring or date object.
   *
   * @returns A formatted date.
   */
  function format(value) {
    const lang = document.documentElement.lang || 'en';
    const formatter = new Intl.DateTimeFormat(lang, {
      dateStyle: 'short',
      timeStyle: 'short'
    });
    return formatter.format(new Date(value));
  }
  Time.format = format;
})(Time = exports.Time || (exports.Time = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/url.js":
/*!*******************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/url.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.URLExt = void 0;
const path_1 = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js");
const url_parse_1 = __importDefault(__webpack_require__(/*! url-parse */ "./node_modules/url-parse/index.js"));
/**
 * The namespace for URL-related functions.
 */
var URLExt;
(function (URLExt) {
  /**
   * Parse a url into a URL object.
   *
   * @param urlString - The URL string to parse.
   *
   * @returns A URL object.
   */
  function parse(url) {
    if (typeof document !== 'undefined' && document) {
      const a = document.createElement('a');
      a.href = url;
      return a;
    }
    return (0, url_parse_1.default)(url);
  }
  URLExt.parse = parse;
  /**
   * Parse URL and retrieve hostname
   *
   * @param url - The URL string to parse
   *
   * @returns a hostname string value
   */
  function getHostName(url) {
    return (0, url_parse_1.default)(url).hostname;
  }
  URLExt.getHostName = getHostName;
  function normalize(url) {
    return url && parse(url).toString();
  }
  URLExt.normalize = normalize;
  /**
   * Join a sequence of url components and normalizes as in node `path.join`.
   *
   * @param parts - The url components.
   *
   * @returns the joined url.
   */
  function join(...parts) {
    let u = (0, url_parse_1.default)(parts[0], {});
    // Schema-less URL can be only parsed as relative to a base URL
    // see https://github.com/unshiftio/url-parse/issues/219#issuecomment-1002219326
    const isSchemaLess = u.protocol === '' && u.slashes;
    if (isSchemaLess) {
      u = (0, url_parse_1.default)(parts[0], 'https:' + parts[0]);
    }
    const prefix = `${isSchemaLess ? '' : u.protocol}${u.slashes ? '//' : ''}${u.auth}${u.auth ? '@' : ''}${u.host}`;
    // If there was a prefix, then the first path must start at the root.
    const path = path_1.posix.join(`${!!prefix && u.pathname[0] !== '/' ? '/' : ''}${u.pathname}`, ...parts.slice(1));
    return `${prefix}${path === '.' ? '' : path}`;
  }
  URLExt.join = join;
  /**
   * Encode the components of a multi-segment url.
   *
   * @param url - The url to encode.
   *
   * @returns the encoded url.
   *
   * #### Notes
   * Preserves the `'/'` separators.
   * Should not include the base url, since all parts are escaped.
   */
  function encodeParts(url) {
    return join(...url.split('/').map(encodeURIComponent));
  }
  URLExt.encodeParts = encodeParts;
  /**
   * Return a serialized object string suitable for a query.
   *
   * @param object - The source object.
   *
   * @returns an encoded url query.
   *
   * #### Notes
   * Modified version of [stackoverflow](http://stackoverflow.com/a/30707423).
   */
  function objectToQueryString(value) {
    const keys = Object.keys(value).filter(key => key.length > 0);
    if (!keys.length) {
      return '';
    }
    return '?' + keys.map(key => {
      const content = encodeURIComponent(String(value[key]));
      return key + (content ? '=' + content : '');
    }).join('&');
  }
  URLExt.objectToQueryString = objectToQueryString;
  /**
   * Return a parsed object that represents the values in a query string.
   */
  function queryStringToObject(value) {
    return value.replace(/^\?/, '').split('&').reduce((acc, val) => {
      const [key, value] = val.split('=');
      if (key.length > 0) {
        acc[key] = decodeURIComponent(value || '');
      }
      return acc;
    }, {});
  }
  URLExt.queryStringToObject = queryStringToObject;
  /**
   * Test whether the url is a local url.
   *
   * #### Notes
   * This function returns `false` for any fully qualified url, including
   * `data:`, `file:`, and `//` protocol URLs.
   */
  function isLocal(url) {
    const {
      protocol
    } = parse(url);
    return (!protocol || url.toLowerCase().indexOf(protocol) !== 0) && url.indexOf('/') !== 0;
  }
  URLExt.isLocal = isLocal;
})(URLExt = exports.URLExt || (exports.URLExt = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/basemanager.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/basemanager.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.BaseManager = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const serverconnection_1 = __webpack_require__(/*! ./serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
class BaseManager {
  constructor(options) {
    var _a;
    this._isDisposed = false;
    this._disposed = new signaling_1.Signal(this);
    this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
  }
  /**
   * A signal emitted when the delegate is disposed.
   */
  get disposed() {
    return this._disposed;
  }
  /**
   * Test whether the delegate has been disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Whether the manager is active.
   */
  get isActive() {
    return true;
  }
  /**
   * Dispose of the delegate and invoke the callback function.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._disposed.emit(undefined);
    signaling_1.Signal.clearData(this);
  }
}
exports.BaseManager = BaseManager;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/builder/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/builder/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.BuildManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the lab build service.
 */
const BUILD_SETTINGS_URL = 'api/build';
/**
 * The build API service manager.
 */
class BuildManager {
  /**
   * Create a new setting manager.
   */
  constructor(options = {}) {
    var _a;
    this._url = '';
    this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
    const {
      baseUrl,
      appUrl
    } = this.serverSettings;
    this._url = coreutils_1.URLExt.join(baseUrl, appUrl, BUILD_SETTINGS_URL);
  }
  /**
   * Test whether the build service is available.
   */
  get isAvailable() {
    return coreutils_1.PageConfig.getOption('buildAvailable').toLowerCase() === 'true';
  }
  /**
   * Test whether to check build status automatically.
   */
  get shouldCheck() {
    return coreutils_1.PageConfig.getOption('buildCheck').toLowerCase() === 'true';
  }
  /**
   * Get whether the application should be built.
   */
  getStatus() {
    const {
      _url,
      serverSettings
    } = this;
    const promise = serverconnection_1.ServerConnection.makeRequest(_url, {}, serverSettings);
    return promise.then(response => {
      if (response.status !== 200) {
        throw new serverconnection_1.ServerConnection.ResponseError(response);
      }
      return response.json();
    }).then(data => {
      if (typeof data.status !== 'string') {
        throw new Error('Invalid data');
      }
      if (typeof data.message !== 'string') {
        throw new Error('Invalid data');
      }
      return data;
    });
  }
  /**
   * Build the application.
   */
  build() {
    const {
      _url,
      serverSettings
    } = this;
    const init = {
      method: 'POST'
    };
    const promise = serverconnection_1.ServerConnection.makeRequest(_url, init, serverSettings);
    return promise.then(response => {
      if (response.status === 400) {
        throw new serverconnection_1.ServerConnection.ResponseError(response, 'Build aborted');
      }
      if (response.status !== 200) {
        const message = `Build failed with ${response.status}.

        If you are experiencing the build failure after installing an extension (or trying to include previously installed extension after updating JupyterLab) please check the extension repository for new installation instructions as many extensions migrated to the prebuilt extensions system which no longer requires rebuilding JupyterLab (but uses a different installation procedure, typically involving a package manager such as 'pip' or 'conda').

        If you specifically intended to install a source extension, please run 'jupyter lab build' on the server for full output.`;
        throw new serverconnection_1.ServerConnection.ResponseError(response, message);
      }
    });
  }
  /**
   * Cancel an active build.
   */
  cancel() {
    const {
      _url,
      serverSettings
    } = this;
    const init = {
      method: 'DELETE'
    };
    const promise = serverconnection_1.ServerConnection.makeRequest(_url, init, serverSettings);
    return promise.then(response => {
      if (response.status !== 204) {
        throw new serverconnection_1.ServerConnection.ResponseError(response);
      }
    });
  }
}
exports.BuildManager = BuildManager;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/config/index.js":
/*!***************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/config/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ConfigWithDefaults = exports.ConfigSection = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const __1 = __webpack_require__(/*! .. */ "./node_modules/@jupyterlab/services/lib/index.js");
/**
 * The url for the config service.
 */
const SERVICE_CONFIG_URL = 'api/config';
/**
 * The namespace for ConfigSection statics.
 */
var ConfigSection;
(function (ConfigSection) {
  /**
   * Create a config section.
   *
   * @returns A Promise that is fulfilled with the config section is loaded.
   */
  function create(options) {
    const section = new DefaultConfigSection(options);
    return section.load().then(() => {
      return section;
    });
  }
  ConfigSection.create = create;
})(ConfigSection = exports.ConfigSection || (exports.ConfigSection = {}));
/**
 * Implementation of the Configurable data section.
 */
class DefaultConfigSection {
  /**
   * Construct a new config section.
   */
  constructor(options) {
    var _a;
    this._url = 'unknown';
    const settings = this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : __1.ServerConnection.makeSettings();
    this._url = coreutils_1.URLExt.join(settings.baseUrl, SERVICE_CONFIG_URL, encodeURIComponent(options.name));
  }
  /**
   * Get the data for this section.
   */
  get data() {
    return this._data;
  }
  /**
   * Load the initial data for this section.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/config).
   *
   * The promise is fulfilled on a valid response and rejected otherwise.
   */
  async load() {
    const response = await __1.ServerConnection.makeRequest(this._url, {}, this.serverSettings);
    if (response.status !== 200) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    this._data = await response.json();
  }
  /**
   * Modify the stored config values.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/config).
   *
   * The promise is fulfilled on a valid response and rejected otherwise.
   *
   * Updates the local data immediately, sends the change to the server,
   * and updates the local data with the response, and fulfils the promise
   * with that data.
   */
  async update(newdata) {
    this._data = {
      ...this._data,
      ...newdata
    };
    const init = {
      method: 'PATCH',
      body: JSON.stringify(newdata)
    };
    const response = await __1.ServerConnection.makeRequest(this._url, init, this.serverSettings);
    if (response.status !== 200) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    this._data = await response.json();
    return this._data;
  }
}
/**
 * Configurable object with defaults.
 */
class ConfigWithDefaults {
  /**
   * Create a new config with defaults.
   */
  constructor(options) {
    var _a, _b;
    this._className = '';
    this._section = options.section;
    this._defaults = (_a = options.defaults) !== null && _a !== void 0 ? _a : {};
    this._className = (_b = options.className) !== null && _b !== void 0 ? _b : '';
  }
  /**
   * Get data from the config section or fall back to defaults.
   */
  get(key) {
    const data = this._classData();
    return key in data ? data[key] : this._defaults[key];
  }
  /**
   * Set a config value.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/config).
   *
   * The promise is fulfilled on a valid response and rejected otherwise.
   *
   * Sends the update to the server, and changes our local copy of the data
   * immediately.
   */
  set(key, value) {
    const d = {};
    d[key] = value;
    if (this._className) {
      const d2 = {};
      d2[this._className] = d;
      return this._section.update(d2);
    } else {
      return this._section.update(d);
    }
  }
  /**
   * Get data from the Section with our classname, if available.
   *
   * #### Notes
   * If we have no classname, get all of the data in the Section
   */
  _classData() {
    const data = this._section.data;
    if (this._className && this._className in data) {
      return data[this._className];
    }
    return data;
  }
}
exports.ConfigWithDefaults = ConfigWithDefaults;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/contents/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/contents/index.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Drive = exports.ContentsManager = exports.Contents = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "./node_modules/@jupyterlab/services/lib/index.js");
const validate = __importStar(__webpack_require__(/*! ./validate */ "./node_modules/@jupyterlab/services/lib/contents/validate.js"));
/**
 * The url for the default drive service.
 */
const SERVICE_DRIVE_URL = 'api/contents';
/**
 * The url for the file access.
 */
const FILES_URL = 'files';
/**
 * A namespace for contents interfaces.
 */
var Contents;
(function (Contents) {
  /**
   * Validates an IModel, throwing an error if it does not pass.
   */
  function validateContentsModel(contents) {
    validate.validateContentsModel(contents);
  }
  Contents.validateContentsModel = validateContentsModel;
  /**
   * Validates an ICheckpointModel, throwing an error if it does not pass.
   */
  function validateCheckpointModel(checkpoint) {
    validate.validateCheckpointModel(checkpoint);
  }
  Contents.validateCheckpointModel = validateCheckpointModel;
})(Contents = exports.Contents || (exports.Contents = {}));
/**
 * A contents manager that passes file operations to the server.
 * Multiple servers implementing the `IDrive` interface can be
 * attached to the contents manager, so that the same session can
 * perform file operations on multiple backends.
 *
 * This includes checkpointing with the normal file operations.
 */
class ContentsManager {
  /**
   * Construct a new contents manager object.
   *
   * @param options - The options used to initialize the object.
   */
  constructor(options = {}) {
    var _a, _b;
    this._isDisposed = false;
    this._additionalDrives = new Map();
    this._fileChanged = new signaling_1.Signal(this);
    const serverSettings = this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : __1.ServerConnection.makeSettings();
    this._defaultDrive = (_b = options.defaultDrive) !== null && _b !== void 0 ? _b : new Drive({
      serverSettings
    });
    this._defaultDrive.fileChanged.connect(this._onFileChanged, this);
  }
  /**
   * A signal emitted when a file operation takes place.
   */
  get fileChanged() {
    return this._fileChanged;
  }
  /**
   * Test whether the manager has been disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Dispose of the resources held by the manager.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._isDisposed = true;
    signaling_1.Signal.clearData(this);
  }
  /**
   * Add an `IDrive` to the manager.
   */
  addDrive(drive) {
    this._additionalDrives.set(drive.name, drive);
    drive.fileChanged.connect(this._onFileChanged, this);
  }
  /**
   * Given a path, get a shared model factory from the
   * relevant backend. Returns `null` if the backend
   * does not provide one.
   */
  getSharedModelFactory(path) {
    var _a;
    const [drive] = this._driveForPath(path);
    return (_a = drive === null || drive === void 0 ? void 0 : drive.sharedModelFactory) !== null && _a !== void 0 ? _a : null;
  }
  /**
   * Given a path of the form `drive:local/portion/of/it.txt`
   * get the local part of it.
   *
   * @param path: the path.
   *
   * @returns The local part of the path.
   */
  localPath(path) {
    const parts = path.split('/');
    const firstParts = parts[0].split(':');
    if (firstParts.length === 1 || !this._additionalDrives.has(firstParts[0])) {
      return coreutils_1.PathExt.removeSlash(path);
    }
    return coreutils_1.PathExt.join(firstParts.slice(1).join(':'), ...parts.slice(1));
  }
  /**
   * Normalize a global path. Reduces '..' and '.' parts, and removes
   * leading slashes from the local part of the path, while retaining
   * the drive name if it exists.
   *
   * @param path: the path.
   *
   * @returns The normalized path.
   */
  normalize(path) {
    const parts = path.split(':');
    if (parts.length === 1) {
      return coreutils_1.PathExt.normalize(path);
    }
    return `${parts[0]}:${coreutils_1.PathExt.normalize(parts.slice(1).join(':'))}`;
  }
  /**
   * Resolve a global path, starting from the root path. Behaves like
   * posix-path.resolve, with 3 differences:
   *  - will never prepend cwd
   *  - if root has a drive name, the result is prefixed with "<drive>:"
   *  - before adding drive name, leading slashes are removed
   *
   * @param path: the path.
   *
   * @returns The normalized path.
   */
  resolvePath(root, path) {
    const driveName = this.driveName(root);
    const localPath = this.localPath(root);
    const resolved = coreutils_1.PathExt.resolve('/', localPath, path);
    return driveName ? `${driveName}:${resolved}` : resolved;
  }
  /**
   * Given a path of the form `drive:local/portion/of/it.txt`
   * get the name of the drive. If the path is missing
   * a drive portion, returns an empty string.
   *
   * @param path: the path.
   *
   * @returns The drive name for the path, or the empty string.
   */
  driveName(path) {
    const parts = path.split('/');
    const firstParts = parts[0].split(':');
    if (firstParts.length === 1) {
      return '';
    }
    if (this._additionalDrives.has(firstParts[0])) {
      return firstParts[0];
    }
    return '';
  }
  /**
   * Get a file or directory.
   *
   * @param path: The path to the file.
   *
   * @param options: The options used to fetch the file.
   *
   * @returns A promise which resolves with the file content.
   */
  get(path, options) {
    const [drive, localPath] = this._driveForPath(path);
    return drive.get(localPath, options).then(contentsModel => {
      const listing = [];
      if (contentsModel.type === 'directory' && contentsModel.content) {
        for (const item of contentsModel.content) {
          listing.push({
            ...item,
            path: this._toGlobalPath(drive, item.path)
          });
        }
        return {
          ...contentsModel,
          path: this._toGlobalPath(drive, localPath),
          content: listing,
          serverPath: contentsModel.path
        };
      } else {
        return {
          ...contentsModel,
          path: this._toGlobalPath(drive, localPath),
          serverPath: contentsModel.path
        };
      }
    });
  }
  /**
   * Get an encoded download url given a file path.
   *
   * @param path - An absolute POSIX file path on the server.
   *
   * #### Notes
   * It is expected that the path contains no relative paths.
   *
   * The returned URL may include a query parameter.
   */
  getDownloadUrl(path) {
    const [drive, localPath] = this._driveForPath(path);
    return drive.getDownloadUrl(localPath);
  }
  /**
   * Create a new untitled file or directory in the specified directory path.
   *
   * @param options: The options used to create the file.
   *
   * @returns A promise which resolves with the created file content when the
   *    file is created.
   */
  newUntitled(options = {}) {
    if (options.path) {
      const globalPath = this.normalize(options.path);
      const [drive, localPath] = this._driveForPath(globalPath);
      return drive.newUntitled({
        ...options,
        path: localPath
      }).then(contentsModel => {
        return {
          ...contentsModel,
          path: coreutils_1.PathExt.join(globalPath, contentsModel.name),
          serverPath: contentsModel.path
        };
      });
    } else {
      return this._defaultDrive.newUntitled(options);
    }
  }
  /**
   * Delete a file.
   *
   * @param path - The path to the file.
   *
   * @returns A promise which resolves when the file is deleted.
   */
  delete(path) {
    const [drive, localPath] = this._driveForPath(path);
    return drive.delete(localPath);
  }
  /**
   * Rename a file or directory.
   *
   * @param path - The original file path.
   *
   * @param newPath - The new file path.
   *
   * @returns A promise which resolves with the new file contents model when
   *   the file is renamed.
   */
  rename(path, newPath) {
    const [drive1, path1] = this._driveForPath(path);
    const [drive2, path2] = this._driveForPath(newPath);
    if (drive1 !== drive2) {
      throw Error('ContentsManager: renaming files must occur within a Drive');
    }
    return drive1.rename(path1, path2).then(contentsModel => {
      return {
        ...contentsModel,
        path: this._toGlobalPath(drive1, path2),
        serverPath: contentsModel.path
      };
    });
  }
  /**
   * Save a file.
   *
   * @param path - The desired file path.
   *
   * @param options - Optional overrides to the model.
   *
   * @returns A promise which resolves with the file content model when the
   *   file is saved.
   *
   * #### Notes
   * Ensure that `model.content` is populated for the file.
   */
  save(path, options = {}) {
    const globalPath = this.normalize(path);
    const [drive, localPath] = this._driveForPath(path);
    return drive.save(localPath, {
      ...options,
      path: localPath
    }).then(contentsModel => {
      return {
        ...contentsModel,
        path: globalPath,
        serverPath: contentsModel.path
      };
    });
  }
  /**
   * Copy a file into a given directory.
   *
   * @param path - The original file path.
   *
   * @param toDir - The destination directory path.
   *
   * @returns A promise which resolves with the new contents model when the
   *  file is copied.
   *
   * #### Notes
   * The server will select the name of the copied file.
   */
  copy(fromFile, toDir) {
    const [drive1, path1] = this._driveForPath(fromFile);
    const [drive2, path2] = this._driveForPath(toDir);
    if (drive1 === drive2) {
      return drive1.copy(path1, path2).then(contentsModel => {
        return {
          ...contentsModel,
          path: this._toGlobalPath(drive1, contentsModel.path),
          serverPath: contentsModel.path
        };
      });
    } else {
      throw Error('Copying files between drives is not currently implemented');
    }
  }
  /**
   * Create a checkpoint for a file.
   *
   * @param path - The path of the file.
   *
   * @returns A promise which resolves with the new checkpoint model when the
   *   checkpoint is created.
   */
  createCheckpoint(path) {
    const [drive, localPath] = this._driveForPath(path);
    return drive.createCheckpoint(localPath);
  }
  /**
   * List available checkpoints for a file.
   *
   * @param path - The path of the file.
   *
   * @returns A promise which resolves with a list of checkpoint models for
   *    the file.
   */
  listCheckpoints(path) {
    const [drive, localPath] = this._driveForPath(path);
    return drive.listCheckpoints(localPath);
  }
  /**
   * Restore a file to a known checkpoint state.
   *
   * @param path - The path of the file.
   *
   * @param checkpointID - The id of the checkpoint to restore.
   *
   * @returns A promise which resolves when the checkpoint is restored.
   */
  restoreCheckpoint(path, checkpointID) {
    const [drive, localPath] = this._driveForPath(path);
    return drive.restoreCheckpoint(localPath, checkpointID);
  }
  /**
   * Delete a checkpoint for a file.
   *
   * @param path - The path of the file.
   *
   * @param checkpointID - The id of the checkpoint to delete.
   *
   * @returns A promise which resolves when the checkpoint is deleted.
   */
  deleteCheckpoint(path, checkpointID) {
    const [drive, localPath] = this._driveForPath(path);
    return drive.deleteCheckpoint(localPath, checkpointID);
  }
  /**
   * Given a drive and a local path, construct a fully qualified
   * path. The inverse of `_driveForPath`.
   *
   * @param drive: an `IDrive`.
   *
   * @param localPath: the local path on the drive.
   *
   * @returns the fully qualified path.
   */
  _toGlobalPath(drive, localPath) {
    if (drive === this._defaultDrive) {
      return coreutils_1.PathExt.removeSlash(localPath);
    } else {
      return `${drive.name}:${coreutils_1.PathExt.removeSlash(localPath)}`;
    }
  }
  /**
   * Given a path, get the `IDrive to which it refers,
   * where the path satisfies the pattern
   * `'driveName:path/to/file'`. If there is no `driveName`
   * prepended to the path, it returns the default drive.
   *
   * @param path: a path to a file.
   *
   * @returns A tuple containing an `IDrive` object for the path,
   * and a local path for that drive.
   */
  _driveForPath(path) {
    const driveName = this.driveName(path);
    const localPath = this.localPath(path);
    if (driveName) {
      return [this._additionalDrives.get(driveName), localPath];
    } else {
      return [this._defaultDrive, localPath];
    }
  }
  /**
   * Respond to fileChanged signals from the drives attached to
   * the manager. This prepends the drive name to the path if necessary,
   * and then forwards the signal.
   */
  _onFileChanged(sender, args) {
    var _a, _b;
    if (sender === this._defaultDrive) {
      this._fileChanged.emit(args);
    } else {
      let newValue = null;
      let oldValue = null;
      if ((_a = args.newValue) === null || _a === void 0 ? void 0 : _a.path) {
        newValue = {
          ...args.newValue,
          path: this._toGlobalPath(sender, args.newValue.path)
        };
      }
      if ((_b = args.oldValue) === null || _b === void 0 ? void 0 : _b.path) {
        oldValue = {
          ...args.oldValue,
          path: this._toGlobalPath(sender, args.oldValue.path)
        };
      }
      this._fileChanged.emit({
        type: args.type,
        newValue,
        oldValue
      });
    }
  }
}
exports.ContentsManager = ContentsManager;
/**
 * A default implementation for an `IDrive`, talking to the
 * server using the Jupyter REST API.
 */
class Drive {
  /**
   * Construct a new contents manager object.
   *
   * @param options - The options used to initialize the object.
   */
  constructor(options = {}) {
    var _a, _b, _c;
    this._isDisposed = false;
    this._fileChanged = new signaling_1.Signal(this);
    this.name = (_a = options.name) !== null && _a !== void 0 ? _a : 'Default';
    this._apiEndpoint = (_b = options.apiEndpoint) !== null && _b !== void 0 ? _b : SERVICE_DRIVE_URL;
    this.serverSettings = (_c = options.serverSettings) !== null && _c !== void 0 ? _c : __1.ServerConnection.makeSettings();
  }
  /**
   * A signal emitted when a file operation takes place.
   */
  get fileChanged() {
    return this._fileChanged;
  }
  /**
   * Test whether the manager has been disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Dispose of the resources held by the manager.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._isDisposed = true;
    signaling_1.Signal.clearData(this);
  }
  /**
   * Get a file or directory.
   *
   * @param localPath: The path to the file.
   *
   * @param options: The options used to fetch the file.
   *
   * @returns A promise which resolves with the file content.
   *
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
   */
  async get(localPath, options) {
    let url = this._getUrl(localPath);
    if (options) {
      // The notebook type cannot take an format option.
      if (options.type === 'notebook') {
        delete options['format'];
      }
      const content = options.content ? '1' : '0';
      const params = {
        ...options,
        content
      };
      url += coreutils_1.URLExt.objectToQueryString(params);
    }
    const settings = this.serverSettings;
    const response = await __1.ServerConnection.makeRequest(url, {}, settings);
    if (response.status !== 200) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    const data = await response.json();
    validate.validateContentsModel(data);
    return data;
  }
  /**
   * Get an encoded download url given a file path.
   *
   * @param localPath - An absolute POSIX file path on the server.
   *
   * #### Notes
   * It is expected that the path contains no relative paths.
   *
   * The returned URL may include a query parameter.
   */
  getDownloadUrl(localPath) {
    const baseUrl = this.serverSettings.baseUrl;
    let url = coreutils_1.URLExt.join(baseUrl, FILES_URL, coreutils_1.URLExt.encodeParts(localPath));
    const xsrfTokenMatch = document.cookie.match('\\b_xsrf=([^;]*)\\b');
    if (xsrfTokenMatch) {
      const fullUrl = new URL(url);
      fullUrl.searchParams.append('_xsrf', xsrfTokenMatch[1]);
      url = fullUrl.toString();
    }
    return Promise.resolve(url);
  }
  /**
   * Create a new untitled file or directory in the specified directory path.
   *
   * @param options: The options used to create the file.
   *
   * @returns A promise which resolves with the created file content when the
   *    file is created.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
   */
  async newUntitled(options = {}) {
    var _a;
    let body = '{}';
    if (options) {
      if (options.ext) {
        options.ext = Private.normalizeExtension(options.ext);
      }
      body = JSON.stringify(options);
    }
    const settings = this.serverSettings;
    const url = this._getUrl((_a = options.path) !== null && _a !== void 0 ? _a : '');
    const init = {
      method: 'POST',
      body
    };
    const response = await __1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 201) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    const data = await response.json();
    validate.validateContentsModel(data);
    this._fileChanged.emit({
      type: 'new',
      oldValue: null,
      newValue: data
    });
    return data;
  }
  /**
   * Delete a file.
   *
   * @param localPath - The path to the file.
   *
   * @returns A promise which resolves when the file is deleted.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents).
   */
  async delete(localPath) {
    const url = this._getUrl(localPath);
    const settings = this.serverSettings;
    const init = {
      method: 'DELETE'
    };
    const response = await __1.ServerConnection.makeRequest(url, init, settings);
    // TODO: update IPEP27 to specify errors more precisely, so
    // that error types can be detected here with certainty.
    if (response.status !== 204) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    this._fileChanged.emit({
      type: 'delete',
      oldValue: {
        path: localPath
      },
      newValue: null
    });
  }
  /**
   * Rename a file or directory.
   *
   * @param oldLocalPath - The original file path.
   *
   * @param newLocalPath - The new file path.
   *
   * @returns A promise which resolves with the new file contents model when
   *   the file is renamed.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
   */
  async rename(oldLocalPath, newLocalPath) {
    const settings = this.serverSettings;
    const url = this._getUrl(oldLocalPath);
    const init = {
      method: 'PATCH',
      body: JSON.stringify({
        path: newLocalPath
      })
    };
    const response = await __1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 200) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    const data = await response.json();
    validate.validateContentsModel(data);
    this._fileChanged.emit({
      type: 'rename',
      oldValue: {
        path: oldLocalPath
      },
      newValue: data
    });
    return data;
  }
  /**
   * Save a file.
   *
   * @param localPath - The desired file path.
   *
   * @param options - Optional overrides to the model.
   *
   * @returns A promise which resolves with the file content model when the
   *   file is saved.
   *
   * #### Notes
   * Ensure that `model.content` is populated for the file.
   *
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
   */
  async save(localPath, options = {}) {
    const settings = this.serverSettings;
    const url = this._getUrl(localPath);
    const init = {
      method: 'PUT',
      body: JSON.stringify(options)
    };
    const response = await __1.ServerConnection.makeRequest(url, init, settings);
    // will return 200 for an existing file and 201 for a new file
    if (response.status !== 200 && response.status !== 201) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    const data = await response.json();
    validate.validateContentsModel(data);
    this._fileChanged.emit({
      type: 'save',
      oldValue: null,
      newValue: data
    });
    return data;
  }
  /**
   * Copy a file into a given directory.
   *
   * @param localPath - The original file path.
   *
   * @param toDir - The destination directory path.
   *
   * @returns A promise which resolves with the new contents model when the
   *  file is copied.
   *
   * #### Notes
   * The server will select the name of the copied file.
   *
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
   */
  async copy(fromFile, toDir) {
    const settings = this.serverSettings;
    const url = this._getUrl(toDir);
    const init = {
      method: 'POST',
      body: JSON.stringify({
        copy_from: fromFile
      })
    };
    const response = await __1.ServerConnection.makeRequest(url, init, settings);
    if (response.status !== 201) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    const data = await response.json();
    validate.validateContentsModel(data);
    this._fileChanged.emit({
      type: 'new',
      oldValue: null,
      newValue: data
    });
    return data;
  }
  /**
   * Create a checkpoint for a file.
   *
   * @param localPath - The path of the file.
   *
   * @returns A promise which resolves with the new checkpoint model when the
   *   checkpoint is created.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
   */
  async createCheckpoint(localPath) {
    const url = this._getUrl(localPath, 'checkpoints');
    const init = {
      method: 'POST'
    };
    const response = await __1.ServerConnection.makeRequest(url, init, this.serverSettings);
    if (response.status !== 201) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    const data = await response.json();
    validate.validateCheckpointModel(data);
    return data;
  }
  /**
   * List available checkpoints for a file.
   *
   * @param localPath - The path of the file.
   *
   * @returns A promise which resolves with a list of checkpoint models for
   *    the file.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents) and validates the response model.
   */
  async listCheckpoints(localPath) {
    const url = this._getUrl(localPath, 'checkpoints');
    const response = await __1.ServerConnection.makeRequest(url, {}, this.serverSettings);
    if (response.status !== 200) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    const data = await response.json();
    if (!Array.isArray(data)) {
      throw new Error('Invalid Checkpoint list');
    }
    for (let i = 0; i < data.length; i++) {
      validate.validateCheckpointModel(data[i]);
    }
    return data;
  }
  /**
   * Restore a file to a known checkpoint state.
   *
   * @param localPath - The path of the file.
   *
   * @param checkpointID - The id of the checkpoint to restore.
   *
   * @returns A promise which resolves when the checkpoint is restored.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents).
   */
  async restoreCheckpoint(localPath, checkpointID) {
    const url = this._getUrl(localPath, 'checkpoints', checkpointID);
    const init = {
      method: 'POST'
    };
    const response = await __1.ServerConnection.makeRequest(url, init, this.serverSettings);
    if (response.status !== 204) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
  }
  /**
   * Delete a checkpoint for a file.
   *
   * @param localPath - The path of the file.
   *
   * @param checkpointID - The id of the checkpoint to delete.
   *
   * @returns A promise which resolves when the checkpoint is deleted.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/contents).
   */
  async deleteCheckpoint(localPath, checkpointID) {
    const url = this._getUrl(localPath, 'checkpoints', checkpointID);
    const init = {
      method: 'DELETE'
    };
    const response = await __1.ServerConnection.makeRequest(url, init, this.serverSettings);
    if (response.status !== 204) {
      const err = await __1.ServerConnection.ResponseError.create(response);
      throw err;
    }
  }
  /**
   * Get a REST url for a file given a path.
   */
  _getUrl(...args) {
    const parts = args.map(path => coreutils_1.URLExt.encodeParts(path));
    const baseUrl = this.serverSettings.baseUrl;
    return coreutils_1.URLExt.join(baseUrl, this._apiEndpoint, ...parts);
  }
}
exports.Drive = Drive;
/**
 * A namespace for module private data.
 */
var Private;
(function (Private) {
  /**
   * Normalize a file extension to be of the type `'.foo'`.
   *
   * Adds a leading dot if not present and converts to lower case.
   */
  function normalizeExtension(extension) {
    if (extension.length > 0 && extension.indexOf('.') !== 0) {
      extension = `.${extension}`;
    }
    return extension;
  }
  Private.normalizeExtension = normalizeExtension;
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/contents/validate.js":
/*!********************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/contents/validate.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.validateCheckpointModel = exports.validateContentsModel = void 0;
const validate_1 = __webpack_require__(/*! ../validate */ "./node_modules/@jupyterlab/services/lib/validate.js");
/**
 * Validate an `Contents.IModel` object.
 */
function validateContentsModel(model) {
  (0, validate_1.validateProperty)(model, 'name', 'string');
  (0, validate_1.validateProperty)(model, 'path', 'string');
  (0, validate_1.validateProperty)(model, 'type', 'string');
  (0, validate_1.validateProperty)(model, 'created', 'string');
  (0, validate_1.validateProperty)(model, 'last_modified', 'string');
  (0, validate_1.validateProperty)(model, 'mimetype', 'object');
  (0, validate_1.validateProperty)(model, 'content', 'object');
  (0, validate_1.validateProperty)(model, 'format', 'object');
}
exports.validateContentsModel = validateContentsModel;
/**
 * Validate an `Contents.ICheckpointModel` object.
 */
function validateCheckpointModel(model) {
  (0, validate_1.validateProperty)(model, 'id', 'string');
  (0, validate_1.validateProperty)(model, 'last_modified', 'string');
}
exports.validateCheckpointModel = validateCheckpointModel;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/event/index.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/event/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.EventManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const polling_1 = __webpack_require__(/*! @lumino/polling */ "./node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the jupyter-server events service.
 */
const SERVICE_EVENTS_URL = 'api/events';
/**
 * The events API service manager.
 */
class EventManager {
  /**
   * Create a new event manager.
   */
  constructor(options = {}) {
    var _a;
    this._socket = null;
    this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
    // If subscription fails, the poll attempts to reconnect and backs off.
    this._poll = new polling_1.Poll({
      factory: () => this._subscribe()
    });
    this._stream = new signaling_1.Stream(this);
    // Subscribe to the events socket.
    void this._poll.start();
  }
  /**
   * Whether the event manager is disposed.
   */
  get isDisposed() {
    return this._poll.isDisposed;
  }
  /**
   * An event stream that emits and yields each new event.
   */
  get stream() {
    return this._stream;
  }
  /**
   * Dispose the event manager.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    // Clean up poll.
    this._poll.dispose();
    // Clean up socket.
    const socket = this._socket;
    if (socket) {
      this._socket = null;
      socket.onopen = () => undefined;
      socket.onerror = () => undefined;
      socket.onmessage = () => undefined;
      socket.onclose = () => undefined;
      socket.close();
    }
    // Clean up stream.
    signaling_1.Signal.clearData(this);
    this._stream.stop();
  }
  /**
   * Post an event request to be emitted by the event bus.
   */
  async emit(event) {
    const {
      serverSettings
    } = this;
    const {
      baseUrl,
      token
    } = serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const url = coreutils_1.URLExt.join(baseUrl, SERVICE_EVENTS_URL) + (token ? `?token=${token}` : '');
    const init = {
      body: JSON.stringify(event),
      method: 'POST'
    };
    const response = await makeRequest(url, init, serverSettings);
    if (response.status !== 204) {
      throw new ResponseError(response);
    }
  }
  /**
   * Subscribe to event bus emissions.
   */
  _subscribe() {
    return new Promise((_, reject) => {
      if (this.isDisposed) {
        return;
      }
      const {
        token,
        WebSocket,
        wsUrl
      } = this.serverSettings;
      const url = coreutils_1.URLExt.join(wsUrl, SERVICE_EVENTS_URL, 'subscribe') + (token ? `?token=${encodeURIComponent(token)}` : '');
      const socket = this._socket = new WebSocket(url);
      const stream = this._stream;
      socket.onclose = () => reject(new Error('EventManager socket closed'));
      socket.onmessage = msg => msg.data && stream.emit(JSON.parse(msg.data));
    });
  }
}
exports.EventManager = EventManager;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/index.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/index.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module services
 */
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = this && this.__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
__exportStar(__webpack_require__(/*! ./basemanager */ "./node_modules/@jupyterlab/services/lib/basemanager.js"), exports);
__exportStar(__webpack_require__(/*! ./config */ "./node_modules/@jupyterlab/services/lib/config/index.js"), exports);
__exportStar(__webpack_require__(/*! ./contents */ "./node_modules/@jupyterlab/services/lib/contents/index.js"), exports);
__exportStar(__webpack_require__(/*! ./event */ "./node_modules/@jupyterlab/services/lib/event/index.js"), exports);
__exportStar(__webpack_require__(/*! ./kernel */ "./node_modules/@jupyterlab/services/lib/kernel/index.js"), exports);
__exportStar(__webpack_require__(/*! ./kernelspec */ "./node_modules/@jupyterlab/services/lib/kernelspec/index.js"), exports);
__exportStar(__webpack_require__(/*! ./manager */ "./node_modules/@jupyterlab/services/lib/manager.js"), exports);
__exportStar(__webpack_require__(/*! ./serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js"), exports);
__exportStar(__webpack_require__(/*! ./session */ "./node_modules/@jupyterlab/services/lib/session/index.js"), exports);
__exportStar(__webpack_require__(/*! ./setting */ "./node_modules/@jupyterlab/services/lib/setting/index.js"), exports);
__exportStar(__webpack_require__(/*! ./terminal */ "./node_modules/@jupyterlab/services/lib/terminal/index.js"), exports);
__exportStar(__webpack_require__(/*! ./user */ "./node_modules/@jupyterlab/services/lib/user/index.js"), exports);
__exportStar(__webpack_require__(/*! ./workspace */ "./node_modules/@jupyterlab/services/lib/workspace/index.js"), exports);
__exportStar(__webpack_require__(/*! ./nbconvert */ "./node_modules/@jupyterlab/services/lib/nbconvert/index.js"), exports);

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/comm.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/comm.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CommHandler = void 0;
const disposable_1 = __webpack_require__(/*! @lumino/disposable */ "./node_modules/@lumino/disposable/dist/index.es6.js");
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "./node_modules/@jupyterlab/services/lib/kernel/messages.js"));
/**
 * Comm channel handler.
 */
class CommHandler extends disposable_1.DisposableDelegate {
  /**
   * Construct a new comm channel.
   */
  constructor(target, id, kernel, disposeCb) {
    super(disposeCb);
    this._target = '';
    this._id = '';
    this._id = id;
    this._target = target;
    this._kernel = kernel;
  }
  /**
   * The unique id for the comm channel.
   */
  get commId() {
    return this._id;
  }
  /**
   * The target name for the comm channel.
   */
  get targetName() {
    return this._target;
  }
  /**
   * Get the callback for a comm close event.
   *
   * #### Notes
   * This is called when the comm is closed from either the server or client.
   *
   * **See also:** [[ICommClose]], [[close]]
   */
  get onClose() {
    return this._onClose;
  }
  /**
   * Set the callback for a comm close event.
   *
   * #### Notes
   * This is called when the comm is closed from either the server or client. If
   * the function returns a promise, and the kernel was closed from the server,
   * kernel message processing will pause until the returned promise is
   * fulfilled.
   *
   * **See also:** [[close]]
   */
  set onClose(cb) {
    this._onClose = cb;
  }
  /**
   * Get the callback for a comm message received event.
   */
  get onMsg() {
    return this._onMsg;
  }
  /**
   * Set the callback for a comm message received event.
   *
   * #### Notes
   * This is called when a comm message is received. If the function returns a
   * promise, kernel message processing will pause until it is fulfilled.
   */
  set onMsg(cb) {
    this._onMsg = cb;
  }
  /**
   * Open a comm with optional data and metadata.
   *
   * #### Notes
   * This sends a `comm_open` message to the server.
   *
   * **See also:** [[ICommOpen]]
   */
  open(data, metadata, buffers = []) {
    if (this.isDisposed || this._kernel.isDisposed) {
      throw new Error('Cannot open');
    }
    const msg = KernelMessage.createMessage({
      msgType: 'comm_open',
      channel: 'shell',
      username: this._kernel.username,
      session: this._kernel.clientId,
      content: {
        comm_id: this._id,
        target_name: this._target,
        data: data !== null && data !== void 0 ? data : {}
      },
      metadata,
      buffers
    });
    return this._kernel.sendShellMessage(msg, false, true);
  }
  /**
   * Send a `comm_msg` message to the kernel.
   *
   * #### Notes
   * This is a no-op if the comm has been closed.
   *
   * **See also:** [[ICommMsg]]
   */
  send(data, metadata, buffers = [], disposeOnDone = true) {
    if (this.isDisposed || this._kernel.isDisposed) {
      throw new Error('Cannot send');
    }
    const msg = KernelMessage.createMessage({
      msgType: 'comm_msg',
      channel: 'shell',
      username: this._kernel.username,
      session: this._kernel.clientId,
      content: {
        comm_id: this._id,
        data: data
      },
      metadata,
      buffers
    });
    return this._kernel.sendShellMessage(msg, false, disposeOnDone);
  }
  /**
   * Close the comm.
   *
   * #### Notes
   * This will send a `comm_close` message to the kernel, and call the
   * `onClose` callback if set.
   *
   * This is a no-op if the comm is already closed.
   *
   * **See also:** [[ICommClose]], [[onClose]]
   */
  close(data, metadata, buffers = []) {
    if (this.isDisposed || this._kernel.isDisposed) {
      throw new Error('Cannot close');
    }
    const msg = KernelMessage.createMessage({
      msgType: 'comm_close',
      channel: 'shell',
      username: this._kernel.username,
      session: this._kernel.clientId,
      content: {
        comm_id: this._id,
        data: data !== null && data !== void 0 ? data : {}
      },
      metadata,
      buffers
    });
    const future = this._kernel.sendShellMessage(msg, false, true);
    const onClose = this._onClose;
    if (onClose) {
      const ioMsg = KernelMessage.createMessage({
        msgType: 'comm_close',
        channel: 'iopub',
        username: this._kernel.username,
        session: this._kernel.clientId,
        content: {
          comm_id: this._id,
          data: data !== null && data !== void 0 ? data : {}
        },
        metadata,
        buffers
      });
      // In the future, we may want to communicate back to the user the possible
      // promise returned from onClose.
      void onClose(ioMsg);
    }
    this.dispose();
    return future;
  }
}
exports.CommHandler = CommHandler;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/default.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/default.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.KernelConnection = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const coreutils_2 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "./node_modules/@jupyterlab/services/lib/index.js");
const comm_1 = __webpack_require__(/*! ./comm */ "./node_modules/@jupyterlab/services/lib/kernel/comm.js");
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "./node_modules/@jupyterlab/services/lib/kernel/messages.js"));
const future_1 = __webpack_require__(/*! ./future */ "./node_modules/@jupyterlab/services/lib/kernel/future.js");
const serialize_1 = __webpack_require__(/*! ./serialize */ "./node_modules/@jupyterlab/services/lib/kernel/serialize.js");
const validate = __importStar(__webpack_require__(/*! ./validate */ "./node_modules/@jupyterlab/services/lib/kernel/validate.js"));
const kernelspec_1 = __webpack_require__(/*! ../kernelspec */ "./node_modules/@jupyterlab/services/lib/kernelspec/index.js");
const restapi = __importStar(__webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/kernel/restapi.js"));
const KERNEL_INFO_TIMEOUT = 3000;
const RESTARTING_KERNEL_SESSION = '_RESTARTING_';
const STARTING_KERNEL_SESSION = '';
/**
 * Implementation of the Kernel object.
 *
 * #### Notes
 * Messages from the server are handled in the order they were received and
 * asynchronously. Any message handler can return a promise, and message
 * handling will pause until the promise is fulfilled.
 */
class KernelConnection {
  /**
   * Construct a kernel object.
   */
  constructor(options) {
    var _a, _b, _c, _d;
    /**
     * Create the kernel websocket connection and add socket status handlers.
     */
    this._createSocket = (useProtocols = true) => {
      this._errorIfDisposed();
      // Make sure the socket is clear
      this._clearSocket();
      // Update the connection status to reflect opening a new connection.
      this._updateConnectionStatus('connecting');
      const settings = this.serverSettings;
      const partialUrl = coreutils_1.URLExt.join(settings.wsUrl, restapi.KERNEL_SERVICE_URL, encodeURIComponent(this._id));
      // Strip any authentication from the display string.
      const display = partialUrl.replace(/^((?:\w+:)?\/\/)(?:[^@\/]+@)/, '$1');
      console.debug(`Starting WebSocket: ${display}`);
      let url = coreutils_1.URLExt.join(partialUrl, 'channels?session_id=' + encodeURIComponent(this._clientId));
      // If token authentication is in use.
      const token = settings.token;
      if (settings.appendToken && token !== '') {
        url = url + `&token=${encodeURIComponent(token)}`;
      }
      // Try opening the websocket with our list of subprotocols.
      // If the server doesn't handle subprotocols,
      // the accepted protocol will be ''.
      // But we cannot send '' as a subprotocol, so if connection fails,
      // reconnect without subprotocols.
      const supportedProtocols = useProtocols ? this._supportedProtocols : [];
      this._ws = new settings.WebSocket(url, supportedProtocols);
      // Ensure incoming binary messages are not Blobs
      this._ws.binaryType = 'arraybuffer';
      let alreadyCalledOnclose = false;
      const getKernelModel = async evt => {
        var _a, _b;
        if (this._isDisposed) {
          return;
        }
        this._reason = '';
        this._model = undefined;
        try {
          const model = await restapi.getKernelModel(this._id, settings);
          this._model = model;
          if ((model === null || model === void 0 ? void 0 : model.execution_state) === 'dead') {
            this._updateStatus('dead');
          } else {
            this._onWSClose(evt);
          }
        } catch (err) {
          // Try again, if there is a network failure
          // Handle network errors, as well as cases where we are on a
          // JupyterHub and the server is not running. JupyterHub returns a
          // 503 (<2.0) or 424 (>2.0) in that case.
          if (err instanceof __1.ServerConnection.NetworkError || ((_a = err.response) === null || _a === void 0 ? void 0 : _a.status) === 503 || ((_b = err.response) === null || _b === void 0 ? void 0 : _b.status) === 424) {
            const timeout = Private.getRandomIntInclusive(10, 30) * 1e3;
            setTimeout(getKernelModel, timeout, evt);
          } else {
            this._reason = 'Kernel died unexpectedly';
            this._updateStatus('dead');
          }
        }
        return;
      };
      const earlyClose = async evt => {
        // If the websocket was closed early, that could mean
        // that the kernel is actually dead. Try getting
        // information about the kernel from the API call,
        // if that fails, then assume the kernel is dead,
        // otherwise just follow the typical websocket closed
        // protocol.
        if (alreadyCalledOnclose) {
          return;
        }
        alreadyCalledOnclose = true;
        await getKernelModel(evt);
        return;
      };
      this._ws.onmessage = this._onWSMessage;
      this._ws.onopen = this._onWSOpen;
      this._ws.onclose = earlyClose;
      this._ws.onerror = earlyClose;
    };
    // Make websocket callbacks arrow functions so they bind `this`.
    /**
     * Handle a websocket open event.
     */
    this._onWSOpen = evt => {
      if (this._ws.protocol !== '' && !this._supportedProtocols.includes(this._ws.protocol)) {
        console.log('Server selected unknown kernel wire protocol:', this._ws.protocol);
        this._updateStatus('dead');
        throw new Error(`Unknown kernel wire protocol:  ${this._ws.protocol}`);
      }
      // Remember the kernel wire protocol selected by the server.
      this._selectedProtocol = this._ws.protocol;
      this._ws.onclose = this._onWSClose;
      this._ws.onerror = this._onWSClose;
      this._updateConnectionStatus('connected');
    };
    /**
     * Handle a websocket message, validating and routing appropriately.
     */
    this._onWSMessage = evt => {
      // Notify immediately if there is an error with the message.
      let msg;
      try {
        msg = (0, serialize_1.deserialize)(evt.data, this._ws.protocol);
        validate.validateMessage(msg);
      } catch (error) {
        error.message = `Kernel message validation error: ${error.message}`;
        // We throw the error so that it bubbles up to the top, and displays the right stack.
        throw error;
      }
      // Update the current kernel session id
      this._kernelSession = msg.header.session;
      // Handle the message asynchronously, in the order received.
      this._msgChain = this._msgChain.then(() => {
        // Return so that any promises from handling a message are fulfilled
        // before proceeding to the next message.
        return this._handleMessage(msg);
      }).catch(error => {
        // Log any errors in handling the message, thus resetting the _msgChain
        // promise so we can process more messages.
        // Ignore the "Canceled" errors that are thrown during kernel dispose.
        if (error.message.startsWith('Canceled future for ')) {
          console.error(error);
        }
      });
      // Emit the message receive signal
      this._anyMessage.emit({
        msg,
        direction: 'recv'
      });
    };
    /**
     * Handle a websocket close event.
     */
    this._onWSClose = evt => {
      if (!this.isDisposed) {
        this._reconnect();
      }
    };
    this._id = '';
    this._name = '';
    this._status = 'unknown';
    this._connectionStatus = 'connecting';
    this._kernelSession = '';
    this._isDisposed = false;
    /**
     * Websocket to communicate with kernel.
     */
    this._ws = null;
    this._username = '';
    this._reconnectLimit = 7;
    this._reconnectAttempt = 0;
    this._reconnectTimeout = null;
    this._supportedProtocols = Object.values(KernelMessage.supportedKernelWebSocketProtocols);
    this._selectedProtocol = '';
    this._futures = new Map();
    this._comms = new Map();
    this._targetRegistry = Object.create(null);
    this._info = new coreutils_2.PromiseDelegate();
    this._pendingMessages = [];
    this._statusChanged = new signaling_1.Signal(this);
    this._connectionStatusChanged = new signaling_1.Signal(this);
    this._disposed = new signaling_1.Signal(this);
    this._iopubMessage = new signaling_1.Signal(this);
    this._anyMessage = new signaling_1.Signal(this);
    this._pendingInput = new signaling_1.Signal(this);
    this._unhandledMessage = new signaling_1.Signal(this);
    this._displayIdToParentIds = new Map();
    this._msgIdToDisplayIds = new Map();
    this._msgChain = Promise.resolve();
    this._hasPendingInput = false;
    this._reason = '';
    this._noOp = () => {
      /* no-op */
    };
    this._name = options.model.name;
    this._id = options.model.id;
    this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : __1.ServerConnection.makeSettings();
    this._clientId = (_b = options.clientId) !== null && _b !== void 0 ? _b : coreutils_2.UUID.uuid4();
    this._username = (_c = options.username) !== null && _c !== void 0 ? _c : '';
    this.handleComms = (_d = options.handleComms) !== null && _d !== void 0 ? _d : true;
    this._createSocket();
  }
  get disposed() {
    return this._disposed;
  }
  /**
   * A signal emitted when the kernel status changes.
   */
  get statusChanged() {
    return this._statusChanged;
  }
  /**
   * A signal emitted when the kernel status changes.
   */
  get connectionStatusChanged() {
    return this._connectionStatusChanged;
  }
  /**
   * A signal emitted for iopub kernel messages.
   *
   * #### Notes
   * This signal is emitted after the iopub message is handled asynchronously.
   */
  get iopubMessage() {
    return this._iopubMessage;
  }
  /**
   * A signal emitted for unhandled kernel message.
   *
   * #### Notes
   * This signal is emitted for a message that was not handled. It is emitted
   * during the asynchronous message handling code.
   */
  get unhandledMessage() {
    return this._unhandledMessage;
  }
  /**
   * The kernel model
   */
  get model() {
    return this._model || {
      id: this.id,
      name: this.name,
      reason: this._reason
    };
  }
  /**
   * A signal emitted for any kernel message.
   *
   * #### Notes
   * This signal is emitted when a message is received, before it is handled
   * asynchronously.
   *
   * This message is emitted when a message is queued for sending (either in
   * the websocket buffer, or our own pending message buffer). The message may
   * actually be sent across the wire at a later time.
   *
   * The message emitted in this signal should not be modified in any way.
   */
  get anyMessage() {
    return this._anyMessage;
  }
  /**
   * A signal emitted when a kernel has pending inputs from the user.
   */
  get pendingInput() {
    return this._pendingInput;
  }
  /**
   * The id of the server-side kernel.
   */
  get id() {
    return this._id;
  }
  /**
   * The name of the server-side kernel.
   */
  get name() {
    return this._name;
  }
  /**
   * The client username.
   */
  get username() {
    return this._username;
  }
  /**
   * The client unique id.
   */
  get clientId() {
    return this._clientId;
  }
  /**
   * The current status of the kernel.
   */
  get status() {
    return this._status;
  }
  /**
   * The current connection status of the kernel connection.
   */
  get connectionStatus() {
    return this._connectionStatus;
  }
  /**
   * Test whether the kernel has been disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * The cached kernel info.
   *
   * @returns A promise that resolves to the kernel info.
   */
  get info() {
    return this._info.promise;
  }
  /**
   * The kernel spec.
   *
   * @returns A promise that resolves to the kernel spec.
   */
  get spec() {
    if (this._specPromise) {
      return this._specPromise;
    }
    this._specPromise = kernelspec_1.KernelSpecAPI.getSpecs(this.serverSettings).then(specs => {
      return specs.kernelspecs[this._name];
    });
    return this._specPromise;
  }
  /**
   * Clone the current kernel with a new clientId.
   */
  clone(options = {}) {
    return new KernelConnection({
      model: this.model,
      username: this.username,
      serverSettings: this.serverSettings,
      // handleComms defaults to false since that is safer
      handleComms: false,
      ...options
    });
  }
  /**
   * Dispose of the resources held by the kernel.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._isDisposed = true;
    this._disposed.emit();
    this._updateConnectionStatus('disconnected');
    this._clearKernelState();
    this._pendingMessages = [];
    this._clearSocket();
    // Clear Lumino signals
    signaling_1.Signal.clearData(this);
  }
  /**
   * Send a shell message to the kernel.
   *
   * #### Notes
   * Send a message to the kernel's shell channel, yielding a future object
   * for accepting replies.
   *
   * If `expectReply` is given and `true`, the future is disposed when both a
   * shell reply and an idle status message are received. If `expectReply`
   * is not given or is `false`, the future is resolved when an idle status
   * message is received.
   * If `disposeOnDone` is not given or is `true`, the Future is disposed at this point.
   * If `disposeOnDone` is given and `false`, it is up to the caller to dispose of the Future.
   *
   * All replies are validated as valid kernel messages.
   *
   * If the kernel status is `dead`, this will throw an error.
   */
  sendShellMessage(msg, expectReply = false, disposeOnDone = true) {
    return this._sendKernelShellControl(future_1.KernelShellFutureHandler, msg, expectReply, disposeOnDone);
  }
  /**
   * Send a control message to the kernel.
   *
   * #### Notes
   * Send a message to the kernel's control channel, yielding a future object
   * for accepting replies.
   *
   * If `expectReply` is given and `true`, the future is disposed when both a
   * control reply and an idle status message are received. If `expectReply`
   * is not given or is `false`, the future is resolved when an idle status
   * message is received.
   * If `disposeOnDone` is not given or is `true`, the Future is disposed at this point.
   * If `disposeOnDone` is given and `false`, it is up to the caller to dispose of the Future.
   *
   * All replies are validated as valid kernel messages.
   *
   * If the kernel status is `dead`, this will throw an error.
   */
  sendControlMessage(msg, expectReply = false, disposeOnDone = true) {
    return this._sendKernelShellControl(future_1.KernelControlFutureHandler, msg, expectReply, disposeOnDone);
  }
  _sendKernelShellControl(ctor, msg, expectReply = false, disposeOnDone = true) {
    this._sendMessage(msg);
    this._anyMessage.emit({
      msg,
      direction: 'send'
    });
    const future = new ctor(() => {
      const msgId = msg.header.msg_id;
      this._futures.delete(msgId);
      // Remove stored display id information.
      const displayIds = this._msgIdToDisplayIds.get(msgId);
      if (!displayIds) {
        return;
      }
      displayIds.forEach(displayId => {
        const msgIds = this._displayIdToParentIds.get(displayId);
        if (msgIds) {
          const idx = msgIds.indexOf(msgId);
          if (idx === -1) {
            return;
          }
          if (msgIds.length === 1) {
            this._displayIdToParentIds.delete(displayId);
          } else {
            msgIds.splice(idx, 1);
            this._displayIdToParentIds.set(displayId, msgIds);
          }
        }
      });
      this._msgIdToDisplayIds.delete(msgId);
    }, msg, expectReply, disposeOnDone, this);
    this._futures.set(msg.header.msg_id, future);
    return future;
  }
  /**
   * Send a message on the websocket.
   *
   * If queue is true, queue the message for later sending if we cannot send
   * now. Otherwise throw an error.
   *
   * #### Notes
   * As an exception to the queueing, if we are sending a kernel_info_request
   * message while we think the kernel is restarting, we send the message
   * immediately without queueing. This is so that we can trigger a message
   * back, which will then clear the kernel restarting state.
   */
  _sendMessage(msg, queue = true) {
    if (this.status === 'dead') {
      throw new Error('Kernel is dead');
    }
    // If we have a kernel_info_request and we are starting or restarting, send the
    // kernel_info_request immediately if we can, and if not throw an error so
    // we can retry later. On restarting we do this because we must get at least one message
    // from the kernel to reset the kernel session (thus clearing the restart
    // status sentinel).
    if ((this._kernelSession === STARTING_KERNEL_SESSION || this._kernelSession === RESTARTING_KERNEL_SESSION) && KernelMessage.isInfoRequestMsg(msg)) {
      if (this.connectionStatus === 'connected') {
        this._ws.send((0, serialize_1.serialize)(msg, this._ws.protocol));
        return;
      } else {
        throw new Error('Could not send message: status is not connected');
      }
    }
    // If there are pending messages, add to the queue so we keep messages in order
    if (queue && this._pendingMessages.length > 0) {
      this._pendingMessages.push(msg);
      return;
    }
    // Send if the ws allows it, otherwise queue the message.
    if (this.connectionStatus === 'connected' && this._kernelSession !== RESTARTING_KERNEL_SESSION) {
      this._ws.send((0, serialize_1.serialize)(msg, this._ws.protocol));
    } else if (queue) {
      this._pendingMessages.push(msg);
    } else {
      throw new Error('Could not send message');
    }
  }
  /**
   * Interrupt a kernel.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels).
   *
   * The promise is fulfilled on a valid response and rejected otherwise.
   *
   * It is assumed that the API call does not mutate the kernel id or name.
   *
   * The promise will be rejected if the kernel status is `Dead` or if the
   * request fails or the response is invalid.
   */
  async interrupt() {
    this.hasPendingInput = false;
    if (this.status === 'dead') {
      throw new Error('Kernel is dead');
    }
    return restapi.interruptKernel(this.id, this.serverSettings);
  }
  /**
   * Request a kernel restart.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels)
   * and validates the response model.
   *
   * Any existing Future or Comm objects are cleared once the kernel has
   * actually be restarted.
   *
   * The promise is fulfilled on a valid server response (after the kernel restarts)
   * and rejected otherwise.
   *
   * It is assumed that the API call does not mutate the kernel id or name.
   *
   * The promise will be rejected if the request fails or the response is
   * invalid.
   */
  async restart() {
    if (this.status === 'dead') {
      throw new Error('Kernel is dead');
    }
    this._updateStatus('restarting');
    this._clearKernelState();
    this._kernelSession = RESTARTING_KERNEL_SESSION;
    await restapi.restartKernel(this.id, this.serverSettings);
    // Reconnect to the kernel to address cases where kernel ports
    // have changed during the restart.
    await this.reconnect();
    this.hasPendingInput = false;
  }
  /**
   * Reconnect to a kernel.
   *
   * #### Notes
   * This may try multiple times to reconnect to a kernel, and will sever any
   * existing connection.
   */
  reconnect() {
    this._errorIfDisposed();
    const result = new coreutils_2.PromiseDelegate();
    // Set up a listener for the connection status changing, which accepts or
    // rejects after the retries are done.
    const fulfill = (sender, status) => {
      if (status === 'connected') {
        result.resolve();
        this.connectionStatusChanged.disconnect(fulfill, this);
      } else if (status === 'disconnected') {
        result.reject(new Error('Kernel connection disconnected'));
        this.connectionStatusChanged.disconnect(fulfill, this);
      }
    };
    this.connectionStatusChanged.connect(fulfill, this);
    // Reset the reconnect limit so we start the connection attempts fresh
    this._reconnectAttempt = 0;
    // Start the reconnection process, which will also clear any existing
    // connection.
    this._reconnect();
    // Return the promise that should resolve on connection or reject if the
    // retries don't work.
    return result.promise;
  }
  /**
   * Shutdown a kernel.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels).
   *
   * The promise is fulfilled on a valid response and rejected otherwise.
   *
   * On a valid response, disposes this kernel connection.
   *
   * If the kernel is already `dead`, disposes this kernel connection without
   * a server request.
   */
  async shutdown() {
    if (this.status !== 'dead') {
      await restapi.shutdownKernel(this.id, this.serverSettings);
    }
    this.handleShutdown();
  }
  /**
   * Handles a kernel shutdown.
   *
   * #### Notes
   * This method should be called if we know from outside information that a
   * kernel is dead (for example, we cannot find the kernel model on the
   * server).
   */
  handleShutdown() {
    this._updateStatus('dead');
    this.dispose();
  }
  /**
   * Send a `kernel_info_request` message.
   *
   * #### Notes
   * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#kernel-info).
   *
   * Fulfills with the `kernel_info_response` content when the shell reply is
   * received and validated.
   */
  async requestKernelInfo() {
    const msg = KernelMessage.createMessage({
      msgType: 'kernel_info_request',
      channel: 'shell',
      username: this._username,
      session: this._clientId,
      content: {}
    });
    let reply;
    try {
      reply = await Private.handleShellMessage(this, msg);
    } catch (e) {
      // If we rejected because the future was disposed, ignore and return.
      if (this.isDisposed) {
        return;
      } else {
        throw e;
      }
    }
    this._errorIfDisposed();
    if (!reply) {
      return;
    }
    // Kernels sometimes do not include a status field on kernel_info_reply
    // messages, so set a default for now.
    // See https://github.com/jupyterlab/jupyterlab/issues/6760
    if (reply.content.status === undefined) {
      reply.content.status = 'ok';
    }
    if (reply.content.status !== 'ok') {
      this._info.reject('Kernel info reply errored');
      return reply;
    }
    this._info.resolve(reply.content);
    this._kernelSession = reply.header.session;
    return reply;
  }
  /**
   * Send a `complete_request` message.
   *
   * #### Notes
   * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#completion).
   *
   * Fulfills with the `complete_reply` content when the shell reply is
   * received and validated.
   */
  requestComplete(content) {
    const msg = KernelMessage.createMessage({
      msgType: 'complete_request',
      channel: 'shell',
      username: this._username,
      session: this._clientId,
      content
    });
    return Private.handleShellMessage(this, msg);
  }
  /**
   * Send an `inspect_request` message.
   *
   * #### Notes
   * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#introspection).
   *
   * Fulfills with the `inspect_reply` content when the shell reply is
   * received and validated.
   */
  requestInspect(content) {
    const msg = KernelMessage.createMessage({
      msgType: 'inspect_request',
      channel: 'shell',
      username: this._username,
      session: this._clientId,
      content: content
    });
    return Private.handleShellMessage(this, msg);
  }
  /**
   * Send a `history_request` message.
   *
   * #### Notes
   * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#history).
   *
   * Fulfills with the `history_reply` content when the shell reply is
   * received and validated.
   */
  requestHistory(content) {
    const msg = KernelMessage.createMessage({
      msgType: 'history_request',
      channel: 'shell',
      username: this._username,
      session: this._clientId,
      content
    });
    return Private.handleShellMessage(this, msg);
  }
  /**
   * Send an `execute_request` message.
   *
   * #### Notes
   * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#execute).
   *
   * Future `onReply` is called with the `execute_reply` content when the
   * shell reply is received and validated. The future will resolve when
   * this message is received and the `idle` iopub status is received.
   * The future will also be disposed at this point unless `disposeOnDone`
   * is specified and `false`, in which case it is up to the caller to dispose
   * of the future.
   *
   * **See also:** [[IExecuteReply]]
   */
  requestExecute(content, disposeOnDone = true, metadata) {
    const defaults = {
      silent: false,
      store_history: true,
      user_expressions: {},
      allow_stdin: true,
      stop_on_error: false
    };
    const msg = KernelMessage.createMessage({
      msgType: 'execute_request',
      channel: 'shell',
      username: this._username,
      session: this._clientId,
      content: {
        ...defaults,
        ...content
      },
      metadata
    });
    return this.sendShellMessage(msg, true, disposeOnDone);
  }
  /**
   * Send an experimental `debug_request` message.
   *
   * @hidden
   *
   * #### Notes
   * Debug messages are experimental messages that are not in the official
   * kernel message specification. As such, this function is *NOT* considered
   * part of the public API, and may change without notice.
   */
  requestDebug(content, disposeOnDone = true) {
    const msg = KernelMessage.createMessage({
      msgType: 'debug_request',
      channel: 'control',
      username: this._username,
      session: this._clientId,
      content
    });
    return this.sendControlMessage(msg, true, disposeOnDone);
  }
  /**
   * Send an `is_complete_request` message.
   *
   * #### Notes
   * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#code-completeness).
   *
   * Fulfills with the `is_complete_response` content when the shell reply is
   * received and validated.
   */
  requestIsComplete(content) {
    const msg = KernelMessage.createMessage({
      msgType: 'is_complete_request',
      channel: 'shell',
      username: this._username,
      session: this._clientId,
      content
    });
    return Private.handleShellMessage(this, msg);
  }
  /**
   * Send a `comm_info_request` message.
   *
   * #### Notes
   * Fulfills with the `comm_info_reply` content when the shell reply is
   * received and validated.
   */
  requestCommInfo(content) {
    const msg = KernelMessage.createMessage({
      msgType: 'comm_info_request',
      channel: 'shell',
      username: this._username,
      session: this._clientId,
      content
    });
    return Private.handleShellMessage(this, msg);
  }
  /**
   * Send an `input_reply` message.
   *
   * #### Notes
   * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#messages-on-the-stdin-router-dealer-sockets).
   */
  sendInputReply(content, parent_header) {
    const msg = KernelMessage.createMessage({
      msgType: 'input_reply',
      channel: 'stdin',
      username: this._username,
      session: this._clientId,
      content
    });
    msg.parent_header = parent_header;
    this._sendMessage(msg);
    this._anyMessage.emit({
      msg,
      direction: 'send'
    });
    this.hasPendingInput = false;
  }
  /**
   * Create a new comm.
   *
   * #### Notes
   * If a client-side comm already exists with the given commId, an error is thrown.
   * If the kernel does not handle comms, an error is thrown.
   */
  createComm(targetName, commId = coreutils_2.UUID.uuid4()) {
    if (!this.handleComms) {
      throw new Error('Comms are disabled on this kernel connection');
    }
    if (this._comms.has(commId)) {
      throw new Error('Comm is already created');
    }
    const comm = new comm_1.CommHandler(targetName, commId, this, () => {
      this._unregisterComm(commId);
    });
    this._comms.set(commId, comm);
    return comm;
  }
  /**
   * Check if a comm exists.
   */
  hasComm(commId) {
    return this._comms.has(commId);
  }
  /**
   * Register a comm target handler.
   *
   * @param targetName - The name of the comm target.
   *
   * @param callback - The callback invoked for a comm open message.
   *
   * @returns A disposable used to unregister the comm target.
   *
   * #### Notes
   * Only one comm target can be registered to a target name at a time, an
   * existing callback for the same target name will be overridden.  A registered
   * comm target handler will take precedence over a comm which specifies a
   * `target_module`.
   *
   * If the callback returns a promise, kernel message processing will pause
   * until the returned promise is fulfilled.
   */
  registerCommTarget(targetName, callback) {
    if (!this.handleComms) {
      return;
    }
    this._targetRegistry[targetName] = callback;
  }
  /**
   * Remove a comm target handler.
   *
   * @param targetName - The name of the comm target to remove.
   *
   * @param callback - The callback to remove.
   *
   * #### Notes
   * The comm target is only removed if the callback argument matches.
   */
  removeCommTarget(targetName, callback) {
    if (!this.handleComms) {
      return;
    }
    if (!this.isDisposed && this._targetRegistry[targetName] === callback) {
      delete this._targetRegistry[targetName];
    }
  }
  /**
   * Register an IOPub message hook.
   *
   * @param msg_id - The parent_header message id the hook will intercept.
   *
   * @param hook - The callback invoked for the message.
   *
   * #### Notes
   * The IOPub hook system allows you to preempt the handlers for IOPub
   * messages that are responses to a given message id.
   *
   * The most recently registered hook is run first. A hook can return a
   * boolean or a promise to a boolean, in which case all kernel message
   * processing pauses until the promise is fulfilled. If a hook return value
   * resolves to false, any later hooks will not run and the function will
   * return a promise resolving to false. If a hook throws an error, the error
   * is logged to the console and the next hook is run. If a hook is
   * registered during the hook processing, it will not run until the next
   * message. If a hook is removed during the hook processing, it will be
   * deactivated immediately.
   *
   * See also [[IFuture.registerMessageHook]].
   */
  registerMessageHook(msgId, hook) {
    var _a;
    const future = (_a = this._futures) === null || _a === void 0 ? void 0 : _a.get(msgId);
    if (future) {
      future.registerMessageHook(hook);
    }
  }
  /**
   * Remove an IOPub message hook.
   *
   * @param msg_id - The parent_header message id the hook intercepted.
   *
   * @param hook - The callback invoked for the message.
   *
   */
  removeMessageHook(msgId, hook) {
    var _a;
    const future = (_a = this._futures) === null || _a === void 0 ? void 0 : _a.get(msgId);
    if (future) {
      future.removeMessageHook(hook);
    }
  }
  /**
   * Remove the input guard, if any.
   */
  removeInputGuard() {
    this.hasPendingInput = false;
  }
  /**
   * Handle a message with a display id.
   *
   * @returns Whether the message was handled.
   */
  async _handleDisplayId(displayId, msg) {
    var _a, _b;
    const msgId = msg.parent_header.msg_id;
    let parentIds = this._displayIdToParentIds.get(displayId);
    if (parentIds) {
      // We've seen it before, update existing outputs with same display_id
      // by handling display_data as update_display_data.
      const updateMsg = {
        header: coreutils_2.JSONExt.deepCopy(msg.header),
        parent_header: coreutils_2.JSONExt.deepCopy(msg.parent_header),
        metadata: coreutils_2.JSONExt.deepCopy(msg.metadata),
        content: coreutils_2.JSONExt.deepCopy(msg.content),
        channel: msg.channel,
        buffers: msg.buffers ? msg.buffers.slice() : []
      };
      updateMsg.header.msg_type = 'update_display_data';
      await Promise.all(parentIds.map(async parentId => {
        const future = this._futures && this._futures.get(parentId);
        if (future) {
          await future.handleMsg(updateMsg);
        }
      }));
    }
    // We're done here if it's update_display.
    if (msg.header.msg_type === 'update_display_data') {
      // It's an update, don't proceed to the normal display.
      return true;
    }
    // Regular display_data with id, record it for future updating
    // in _displayIdToParentIds for future lookup.
    parentIds = (_a = this._displayIdToParentIds.get(displayId)) !== null && _a !== void 0 ? _a : [];
    if (parentIds.indexOf(msgId) === -1) {
      parentIds.push(msgId);
    }
    this._displayIdToParentIds.set(displayId, parentIds);
    // Add to our map of display ids for this message.
    const displayIds = (_b = this._msgIdToDisplayIds.get(msgId)) !== null && _b !== void 0 ? _b : [];
    if (displayIds.indexOf(msgId) === -1) {
      displayIds.push(msgId);
    }
    this._msgIdToDisplayIds.set(msgId, displayIds);
    // Let the message propagate to the intended recipient.
    return false;
  }
  /**
   * Forcefully clear the socket state.
   *
   * #### Notes
   * This will clear all socket state without calling any handlers and will
   * not update the connection status. If you call this method, you are
   * responsible for updating the connection status as needed and recreating
   * the socket if you plan to reconnect.
   */
  _clearSocket() {
    if (this._ws !== null) {
      // Clear the websocket event handlers and the socket itself.
      this._ws.onopen = this._noOp;
      this._ws.onclose = this._noOp;
      this._ws.onerror = this._noOp;
      this._ws.onmessage = this._noOp;
      this._ws.close();
      this._ws = null;
    }
  }
  /**
   * Handle status iopub messages from the kernel.
   */
  _updateStatus(status) {
    if (this._status === status || this._status === 'dead') {
      return;
    }
    this._status = status;
    Private.logKernelStatus(this);
    this._statusChanged.emit(status);
    if (status === 'dead') {
      this.dispose();
    }
  }
  /**
   * Send pending messages to the kernel.
   */
  _sendPending() {
    // We check to make sure we are still connected each time. For
    // example, if a websocket buffer overflows, it may close, so we should
    // stop sending messages.
    while (this.connectionStatus === 'connected' && this._kernelSession !== RESTARTING_KERNEL_SESSION && this._pendingMessages.length > 0) {
      this._sendMessage(this._pendingMessages[0], false);
      // We shift the message off the queue after the message is sent so that
      // if there is an exception, the message is still pending.
      this._pendingMessages.shift();
    }
  }
  /**
   * Clear the internal state.
   */
  _clearKernelState() {
    this._kernelSession = '';
    this._pendingMessages = [];
    this._futures.forEach(future => {
      future.dispose();
    });
    this._comms.forEach(comm => {
      comm.dispose();
    });
    this._msgChain = Promise.resolve();
    this._futures = new Map();
    this._comms = new Map();
    this._displayIdToParentIds.clear();
    this._msgIdToDisplayIds.clear();
  }
  /**
   * Check to make sure it is okay to proceed to handle a message.
   *
   * #### Notes
   * Because we handle messages asynchronously, before a message is handled the
   * kernel might be disposed or restarted (and have a different session id).
   * This function throws an error in each of these cases. This is meant to be
   * called at the start of an asynchronous message handler to cancel message
   * processing if the message no longer is valid.
   */
  _assertCurrentMessage(msg) {
    this._errorIfDisposed();
    if (msg.header.session !== this._kernelSession) {
      throw new Error(`Canceling handling of old message: ${msg.header.msg_type}`);
    }
  }
  /**
   * Handle a `comm_open` kernel message.
   */
  async _handleCommOpen(msg) {
    this._assertCurrentMessage(msg);
    const content = msg.content;
    const comm = new comm_1.CommHandler(content.target_name, content.comm_id, this, () => {
      this._unregisterComm(content.comm_id);
    });
    this._comms.set(content.comm_id, comm);
    try {
      const target = await Private.loadObject(content.target_name, content.target_module, this._targetRegistry);
      await target(comm, msg);
    } catch (e) {
      // Close the comm asynchronously. We cannot block message processing on
      // kernel messages to wait for another kernel message.
      comm.close();
      console.error('Exception opening new comm');
      throw e;
    }
  }
  /**
   * Handle 'comm_close' kernel message.
   */
  async _handleCommClose(msg) {
    this._assertCurrentMessage(msg);
    const content = msg.content;
    const comm = this._comms.get(content.comm_id);
    if (!comm) {
      console.error('Comm not found for comm id ' + content.comm_id);
      return;
    }
    this._unregisterComm(comm.commId);
    const onClose = comm.onClose;
    if (onClose) {
      // tslint:disable-next-line:await-promise
      await onClose(msg);
    }
    comm.dispose();
  }
  /**
   * Handle a 'comm_msg' kernel message.
   */
  async _handleCommMsg(msg) {
    this._assertCurrentMessage(msg);
    const content = msg.content;
    const comm = this._comms.get(content.comm_id);
    if (!comm) {
      return;
    }
    const onMsg = comm.onMsg;
    if (onMsg) {
      // tslint:disable-next-line:await-promise
      await onMsg(msg);
    }
  }
  /**
   * Unregister a comm instance.
   */
  _unregisterComm(commId) {
    this._comms.delete(commId);
  }
  /**
   * Handle connection status changes.
   */
  _updateConnectionStatus(connectionStatus) {
    if (this._connectionStatus === connectionStatus) {
      return;
    }
    this._connectionStatus = connectionStatus;
    // If we are not 'connecting', reset any reconnection attempts.
    if (connectionStatus !== 'connecting') {
      this._reconnectAttempt = 0;
      clearTimeout(this._reconnectTimeout);
    }
    if (this.status !== 'dead') {
      if (connectionStatus === 'connected') {
        let restarting = this._kernelSession === RESTARTING_KERNEL_SESSION;
        // Send a kernel info request to make sure we send at least one
        // message to get kernel status back. Always request kernel info
        // first, to get kernel status back and ensure iopub is fully
        // established. If we are restarting, this message will skip the queue
        // and be sent immediately.
        let p = this.requestKernelInfo();
        // Send any pending messages after the kernelInfo resolves, or after a
        // timeout as a failsafe.
        let sendPendingCalled = false;
        let sendPendingOnce = () => {
          if (sendPendingCalled) {
            return;
          }
          sendPendingCalled = true;
          if (restarting && this._kernelSession === RESTARTING_KERNEL_SESSION) {
            // We were restarting and a message didn't arrive to set the
            // session, but we just assume the restart succeeded and send any
            // pending messages.
            // FIXME: it would be better to retry the kernel_info_request here
            this._kernelSession = '';
          }
          clearTimeout(timeoutHandle);
          if (this._pendingMessages.length > 0) {
            this._sendPending();
          }
        };
        void p.then(sendPendingOnce);
        // FIXME: if sent while zmq subscriptions are not established,
        // kernelInfo may not resolve, so use a timeout to ensure we don't hang forever.
        // It may be preferable to retry kernelInfo rather than give up after one timeout.
        let timeoutHandle = setTimeout(sendPendingOnce, KERNEL_INFO_TIMEOUT);
      } else {
        // If the connection is down, then we do not know what is happening
        // with the kernel, so set the status to unknown.
        this._updateStatus('unknown');
      }
    }
    // Notify others that the connection status changed.
    this._connectionStatusChanged.emit(connectionStatus);
  }
  async _handleMessage(msg) {
    var _a, _b;
    let handled = false;
    // Check to see if we have a display_id we need to reroute.
    if (msg.parent_header && msg.channel === 'iopub' && (KernelMessage.isDisplayDataMsg(msg) || KernelMessage.isUpdateDisplayDataMsg(msg) || KernelMessage.isExecuteResultMsg(msg))) {
      // display_data messages may re-route based on their display_id.
      const transient = (_a = msg.content.transient) !== null && _a !== void 0 ? _a : {};
      const displayId = transient['display_id'];
      if (displayId) {
        handled = await this._handleDisplayId(displayId, msg);
        // The await above may make this message out of date, so check again.
        this._assertCurrentMessage(msg);
      }
    }
    if (!handled && msg.parent_header) {
      const parentHeader = msg.parent_header;
      const future = (_b = this._futures) === null || _b === void 0 ? void 0 : _b.get(parentHeader.msg_id);
      if (future) {
        await future.handleMsg(msg);
        this._assertCurrentMessage(msg);
      } else {
        // If the message was sent by us and was not iopub, it is orphaned.
        const owned = parentHeader.session === this.clientId;
        if (msg.channel !== 'iopub' && owned) {
          this._unhandledMessage.emit(msg);
        }
      }
    }
    if (msg.channel === 'iopub') {
      switch (msg.header.msg_type) {
        case 'status':
          {
            // Updating the status is synchronous, and we call no async user code
            const executionState = msg.content.execution_state;
            if (executionState === 'restarting') {
              // The kernel has been auto-restarted by the server. After
              // processing for this message is completely done, we want to
              // handle this restart, so we don't await, but instead schedule
              // the work as a microtask (i.e., in a promise resolution). We
              // schedule this here so that it comes before any microtasks that
              // might be scheduled in the status signal emission below.
              void Promise.resolve().then(async () => {
                this._updateStatus('autorestarting');
                this._clearKernelState();
                // We must reconnect since the kernel connection information may have
                // changed, and the server only refreshes its zmq connection when a new
                // websocket is opened.
                await this.reconnect();
              });
            }
            this._updateStatus(executionState);
            break;
          }
        case 'comm_open':
          if (this.handleComms) {
            await this._handleCommOpen(msg);
          }
          break;
        case 'comm_msg':
          if (this.handleComms) {
            await this._handleCommMsg(msg);
          }
          break;
        case 'comm_close':
          if (this.handleComms) {
            await this._handleCommClose(msg);
          }
          break;
        default:
          break;
      }
      // If the message was a status dead message, we might have disposed ourselves.
      if (!this.isDisposed) {
        this._assertCurrentMessage(msg);
        // the message wouldn't be emitted if we were disposed anyway.
        this._iopubMessage.emit(msg);
      }
    }
  }
  /**
   * Attempt a connection if we have not exhausted connection attempts.
   */
  _reconnect() {
    this._errorIfDisposed();
    // Clear any existing reconnection attempt
    clearTimeout(this._reconnectTimeout);
    // Update the connection status and schedule a possible reconnection.
    if (this._reconnectAttempt < this._reconnectLimit) {
      this._updateConnectionStatus('connecting');
      // The first reconnect attempt should happen immediately, and subsequent
      // attempts should pick a random number in a growing range so that we
      // don't overload the server with synchronized reconnection attempts
      // across multiple kernels.
      const timeout = Private.getRandomIntInclusive(0, 1e3 * (Math.pow(2, this._reconnectAttempt) - 1));
      console.warn(`Connection lost, reconnecting in ${Math.floor(timeout / 1000)} seconds.`);
      // Try reconnection with subprotocols if the server had supported them.
      // Otherwise, try reconnection without subprotocols.
      const useProtocols = this._selectedProtocol !== '' ? true : false;
      this._reconnectTimeout = setTimeout(this._createSocket, timeout, useProtocols);
      this._reconnectAttempt += 1;
    } else {
      this._updateConnectionStatus('disconnected');
    }
    // Clear the websocket event handlers and the socket itself.
    this._clearSocket();
  }
  /**
   * Utility function to throw an error if this instance is disposed.
   */
  _errorIfDisposed() {
    if (this.isDisposed) {
      throw new Error('Kernel connection is disposed');
    }
  }
  get hasPendingInput() {
    return this._hasPendingInput;
  }
  set hasPendingInput(value) {
    this._hasPendingInput = value;
    this._pendingInput.emit(value);
  }
}
exports.KernelConnection = KernelConnection;
/**
 * A private namespace for the Kernel.
 */
var Private;
(function (Private) {
  /**
   * Log the current kernel status.
   */
  function logKernelStatus(kernel) {
    switch (kernel.status) {
      case 'idle':
      case 'busy':
      case 'unknown':
        return;
      default:
        console.debug(`Kernel: ${kernel.status} (${kernel.id})`);
        break;
    }
  }
  Private.logKernelStatus = logKernelStatus;
  /**
   * Send a kernel message to the kernel and resolve the reply message.
   */
  async function handleShellMessage(kernel, msg) {
    const future = kernel.sendShellMessage(msg, true);
    return future.done;
  }
  Private.handleShellMessage = handleShellMessage;
  /**
   * Try to load an object from a module or a registry.
   *
   * Try to load an object from a module asynchronously if a module
   * is specified, otherwise tries to load an object from the global
   * registry, if the global registry is provided.
   *
   * #### Notes
   * Loading a module uses requirejs.
   */
  function loadObject(name, moduleName, registry) {
    return new Promise((resolve, reject) => {
      // Try loading the module using require.js
      if (moduleName) {
        if (typeof requirejs === 'undefined') {
          throw new Error('requirejs not found');
        }
        requirejs([moduleName], mod => {
          if (mod[name] === void 0) {
            const msg = `Object '${name}' not found in module '${moduleName}'`;
            reject(new Error(msg));
          } else {
            resolve(mod[name]);
          }
        }, reject);
      } else {
        if (registry === null || registry === void 0 ? void 0 : registry[name]) {
          resolve(registry[name]);
        } else {
          reject(new Error(`Object '${name}' not found in registry`));
        }
      }
    });
  }
  Private.loadObject = loadObject;
  /**
   * Get a random integer between min and max, inclusive of both.
   *
   * #### Notes
   * From
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random#Getting_a_random_integer_between_two_values_inclusive
   *
   * From the MDN page: It might be tempting to use Math.round() to accomplish
   * that, but doing so would cause your random numbers to follow a non-uniform
   * distribution, which may not be acceptable for your needs.
   */
  function getRandomIntInclusive(min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min + 1)) + min;
  }
  Private.getRandomIntInclusive = getRandomIntInclusive;
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/future.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/future.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.KernelShellFutureHandler = exports.KernelControlFutureHandler = exports.KernelFutureHandler = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
const disposable_1 = __webpack_require__(/*! @lumino/disposable */ "./node_modules/@lumino/disposable/dist/index.es6.js");
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "./node_modules/@jupyterlab/services/lib/kernel/messages.js"));
/**
 * Implementation of a kernel future.
 *
 * If a reply is expected, the Future is considered done when both a `reply`
 * message and an `idle` iopub status message have been received.  Otherwise, it
 * is considered done when the `idle` status is received.
 *
 */
class KernelFutureHandler extends disposable_1.DisposableDelegate {
  /**
   * Construct a new KernelFutureHandler.
   */
  constructor(cb, msg, expectReply, disposeOnDone, kernel) {
    super(cb);
    this._status = 0;
    this._stdin = Private.noOp;
    this._iopub = Private.noOp;
    this._reply = Private.noOp;
    this._done = new coreutils_1.PromiseDelegate();
    this._hooks = new Private.HookList();
    this._disposeOnDone = true;
    this._msg = msg;
    if (!expectReply) {
      this._setFlag(Private.KernelFutureFlag.GotReply);
    }
    this._disposeOnDone = disposeOnDone;
    this._kernel = kernel;
  }
  /**
   * Get the original outgoing message.
   */
  get msg() {
    return this._msg;
  }
  /**
   * A promise that resolves when the future is done.
   */
  get done() {
    return this._done.promise;
  }
  /**
   * Get the reply handler.
   */
  get onReply() {
    return this._reply;
  }
  /**
   * Set the reply handler.
   */
  set onReply(cb) {
    this._reply = cb;
  }
  /**
   * Get the iopub handler.
   */
  get onIOPub() {
    return this._iopub;
  }
  /**
   * Set the iopub handler.
   */
  set onIOPub(cb) {
    this._iopub = cb;
  }
  /**
   * Get the stdin handler.
   */
  get onStdin() {
    return this._stdin;
  }
  /**
   * Set the stdin handler.
   */
  set onStdin(cb) {
    this._stdin = cb;
  }
  /**
   * Register hook for IOPub messages.
   *
   * @param hook - The callback invoked for an IOPub message.
   *
   * #### Notes
   * The IOPub hook system allows you to preempt the handlers for IOPub
   * messages handled by the future.
   *
   * The most recently registered hook is run first. A hook can return a
   * boolean or a promise to a boolean, in which case all kernel message
   * processing pauses until the promise is fulfilled. If a hook return value
   * resolves to false, any later hooks will not run and the function will
   * return a promise resolving to false. If a hook throws an error, the error
   * is logged to the console and the next hook is run. If a hook is
   * registered during the hook processing, it will not run until the next
   * message. If a hook is removed during the hook processing, it will be
   * deactivated immediately.
   */
  registerMessageHook(hook) {
    if (this.isDisposed) {
      throw new Error('Kernel future is disposed');
    }
    this._hooks.add(hook);
  }
  /**
   * Remove a hook for IOPub messages.
   *
   * @param hook - The hook to remove.
   *
   * #### Notes
   * If a hook is removed during the hook processing, it will be deactivated immediately.
   */
  removeMessageHook(hook) {
    if (this.isDisposed) {
      return;
    }
    this._hooks.remove(hook);
  }
  /**
   * Send an `input_reply` message.
   */
  sendInputReply(content, parent_header) {
    this._kernel.sendInputReply(content, parent_header);
  }
  /**
   * Dispose and unregister the future.
   */
  dispose() {
    this._stdin = Private.noOp;
    this._iopub = Private.noOp;
    this._reply = Private.noOp;
    this._hooks = null;
    if (!this._testFlag(Private.KernelFutureFlag.IsDone)) {
      // TODO: Uncomment the following logging code, and check for any tests that trigger it.
      // let status = [];
      // if (!this._testFlag(Private.KernelFutureFlag.GotIdle)) {
      //   status.push('idle');
      // }
      // if (!this._testFlag(Private.KernelFutureFlag.GotReply)) {
      //   status.push('reply');
      // }
      // console.warn(
      //   `*************** DISPOSED BEFORE DONE: K${this._kernel.id.slice(
      //     0,
      //     6
      //   )} M${this._msg.header.msg_id.slice(0, 6)} missing ${status.join(' ')}`
      // );
      // Reject the `done` promise, but catch its error here in case no one else
      // is waiting for the promise to resolve. This prevents the error from
      // being displayed in the console, but does not prevent it from being
      // caught by a client who is waiting for it.
      this._done.promise.catch(() => {
        /* no-op */
      });
      this._done.reject(new Error(`Canceled future for ${this.msg.header.msg_type} message before replies were done`));
    }
    super.dispose();
  }
  /**
   * Handle an incoming kernel message.
   */
  async handleMsg(msg) {
    switch (msg.channel) {
      case 'control':
      case 'shell':
        if (msg.channel === this.msg.channel && msg.parent_header.msg_id === this.msg.header.msg_id) {
          await this._handleReply(msg);
        }
        break;
      case 'stdin':
        await this._handleStdin(msg);
        break;
      case 'iopub':
        await this._handleIOPub(msg);
        break;
      default:
        break;
    }
  }
  async _handleReply(msg) {
    const reply = this._reply;
    if (reply) {
      // tslint:disable-next-line:await-promise
      await reply(msg);
    }
    this._replyMsg = msg;
    this._setFlag(Private.KernelFutureFlag.GotReply);
    if (this._testFlag(Private.KernelFutureFlag.GotIdle)) {
      this._handleDone();
    }
  }
  async _handleStdin(msg) {
    this._kernel.hasPendingInput = true;
    const stdin = this._stdin;
    if (stdin) {
      // tslint:disable-next-line:await-promise
      await stdin(msg);
    }
  }
  async _handleIOPub(msg) {
    const process = await this._hooks.process(msg);
    const iopub = this._iopub;
    if (process && iopub) {
      // tslint:disable-next-line:await-promise
      await iopub(msg);
    }
    if (KernelMessage.isStatusMsg(msg) && msg.content.execution_state === 'idle') {
      this._setFlag(Private.KernelFutureFlag.GotIdle);
      if (this._testFlag(Private.KernelFutureFlag.GotReply)) {
        this._handleDone();
      }
    }
  }
  _handleDone() {
    if (this._testFlag(Private.KernelFutureFlag.IsDone)) {
      return;
    }
    this._setFlag(Private.KernelFutureFlag.IsDone);
    this._done.resolve(this._replyMsg);
    if (this._disposeOnDone) {
      this.dispose();
    }
  }
  /**
   * Test whether the given future flag is set.
   */
  _testFlag(flag) {
    // tslint:disable-next-line
    return (this._status & flag) !== 0;
  }
  /**
   * Set the given future flag.
   */
  _setFlag(flag) {
    // tslint:disable-next-line
    this._status |= flag;
  }
}
exports.KernelFutureHandler = KernelFutureHandler;
class KernelControlFutureHandler extends KernelFutureHandler {}
exports.KernelControlFutureHandler = KernelControlFutureHandler;
class KernelShellFutureHandler extends KernelFutureHandler {}
exports.KernelShellFutureHandler = KernelShellFutureHandler;
var Private;
(function (Private) {
  /**
   * A no-op function.
   */
  Private.noOp = () => {
    /* no-op */
  };
  /**
   * Defer a computation.
   *
   * #### NOTES
   * We can't just use requestAnimationFrame since it is not available in node.
   * This implementation is from Phosphor:
   * https://github.com/phosphorjs/phosphor/blob/e88e4321289bb1198f3098e7bda40736501f2ed8/tests/test-messaging/src/index.spec.ts#L63
   */
  const defer = (() => {
    const ok = typeof requestAnimationFrame === 'function';
    return ok ? requestAnimationFrame : setImmediate;
  })();
  class HookList {
    constructor() {
      this._hooks = [];
    }
    /**
     * Register a hook.
     *
     * @param hook - The callback to register.
     */
    add(hook) {
      this.remove(hook);
      this._hooks.push(hook);
    }
    /**
     * Remove a hook, if it exists in the hook list.
     *
     * @param hook - The callback to remove.
     */
    remove(hook) {
      const index = this._hooks.indexOf(hook);
      if (index >= 0) {
        this._hooks[index] = null;
        this._scheduleCompact();
      }
    }
    /**
     * Process a message through the hooks.
     *
     * @returns a promise resolving to false if any hook resolved as false,
     * otherwise true
     *
     * #### Notes
     * The most recently registered hook is run first. A hook can return a
     * boolean or a promise to a boolean, in which case processing pauses until
     * the promise is fulfilled. If a hook return value resolves to false, any
     * later hooks will not run and the function will return a promise resolving
     * to false. If a hook throws an error, the error is logged to the console
     * and the next hook is run. If a hook is registered during the hook
     * processing, it will not run until the next message. If a hook is removed
     * during the hook processing, it will be deactivated immediately.
     */
    async process(msg) {
      // Wait until we can start a new process run.
      await this._processing;
      // Start the next process run.
      const processing = new coreutils_1.PromiseDelegate();
      this._processing = processing.promise;
      let continueHandling;
      // Call the end hook (most recently-added) first. Starting at the end also
      // guarantees that hooks added during the processing will not be run in
      // this process run.
      for (let i = this._hooks.length - 1; i >= 0; i--) {
        const hook = this._hooks[i];
        // If the hook has been removed, continue to the next one.
        if (hook === null) {
          continue;
        }
        // Execute the hook and log any errors.
        try {
          // tslint:disable-next-line:await-promise
          continueHandling = await hook(msg);
        } catch (err) {
          continueHandling = true;
          console.error(err);
        }
        // If the hook resolved to false, stop processing and return.
        if (continueHandling === false) {
          processing.resolve(undefined);
          return false;
        }
      }
      // All hooks returned true (or errored out), so return true.
      processing.resolve(undefined);
      return true;
    }
    /**
     * Schedule a cleanup of the list, removing any hooks that have been nulled out.
     */
    _scheduleCompact() {
      if (!this._compactScheduled) {
        this._compactScheduled = true;
        // Schedule a compaction in between processing runs. We do the
        // scheduling in an animation frame to rate-limit our compactions. If we
        // need to compact more frequently, we can change this to directly
        // schedule the compaction.
        defer(() => {
          this._processing = this._processing.then(() => {
            this._compactScheduled = false;
            this._compact();
          });
        });
      }
    }
    /**
     * Compact the list, removing any nulls.
     */
    _compact() {
      let numNulls = 0;
      for (let i = 0, len = this._hooks.length; i < len; i++) {
        const hook = this._hooks[i];
        if (this._hooks[i] === null) {
          numNulls++;
        } else {
          this._hooks[i - numNulls] = hook;
        }
      }
      this._hooks.length -= numNulls;
    }
  }
  Private.HookList = HookList;
  /**
   * Bit flags for the kernel future state.
   */
  let KernelFutureFlag;
  (function (KernelFutureFlag) {
    KernelFutureFlag[KernelFutureFlag["GotReply"] = 1] = "GotReply";
    KernelFutureFlag[KernelFutureFlag["GotIdle"] = 2] = "GotIdle";
    KernelFutureFlag[KernelFutureFlag["IsDone"] = 4] = "IsDone";
    KernelFutureFlag[KernelFutureFlag["DisposeOnDone"] = 8] = "DisposeOnDone";
  })(KernelFutureFlag = Private.KernelFutureFlag || (Private.KernelFutureFlag = {}));
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/index.js":
/*!***************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/index.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __exportStar = this && this.__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.KernelConnection = exports.KernelAPI = exports.KernelMessage = exports.Kernel = void 0;
// Namespace some of our modules for convenience and backwards compatibility.
const Kernel = __importStar(__webpack_require__(/*! ./kernel */ "./node_modules/@jupyterlab/services/lib/kernel/kernel.js"));
exports.Kernel = Kernel;
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "./node_modules/@jupyterlab/services/lib/kernel/messages.js"));
exports.KernelMessage = KernelMessage;
const KernelAPI = __importStar(__webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/kernel/restapi.js"));
exports.KernelAPI = KernelAPI;
const default_1 = __webpack_require__(/*! ./default */ "./node_modules/@jupyterlab/services/lib/kernel/default.js");
Object.defineProperty(exports, "KernelConnection", ({
  enumerable: true,
  get: function () {
    return default_1.KernelConnection;
  }
}));
__exportStar(__webpack_require__(/*! ./manager */ "./node_modules/@jupyterlab/services/lib/kernel/manager.js"), exports);

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/kernel.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/kernel.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/manager.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/manager.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.KernelManager = void 0;
const polling_1 = __webpack_require__(/*! @lumino/polling */ "./node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "./node_modules/@jupyterlab/services/lib/index.js");
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "./node_modules/@jupyterlab/services/lib/basemanager.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/kernel/restapi.js");
const default_1 = __webpack_require__(/*! ./default */ "./node_modules/@jupyterlab/services/lib/kernel/default.js");
/**
 * An implementation of a kernel manager.
 */
class KernelManager extends basemanager_1.BaseManager {
  /**
   * Construct a new kernel manager.
   *
   * @param options - The default options for kernel.
   */
  constructor(options = {}) {
    var _a;
    super(options);
    this._isReady = false;
    this._kernelConnections = new Set();
    this._models = new Map();
    this._runningChanged = new signaling_1.Signal(this);
    this._connectionFailure = new signaling_1.Signal(this);
    // Start model and specs polling with exponential backoff.
    this._pollModels = new polling_1.Poll({
      auto: false,
      factory: () => this.requestRunning(),
      frequency: {
        interval: 10 * 1000,
        backoff: true,
        max: 300 * 1000
      },
      name: `@jupyterlab/services:KernelManager#models`,
      standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
    });
    // Initialize internal data.
    this._ready = (async () => {
      await this._pollModels.start();
      await this._pollModels.tick;
      this._isReady = true;
    })();
  }
  /**
   * Test whether the manager is ready.
   */
  get isReady() {
    return this._isReady;
  }
  /**
   * A promise that fulfills when the manager is ready.
   */
  get ready() {
    return this._ready;
  }
  /**
   * A signal emitted when the running kernels change.
   */
  get runningChanged() {
    return this._runningChanged;
  }
  /**
   * A signal emitted when there is a connection failure.
   */
  get connectionFailure() {
    return this._connectionFailure;
  }
  /**
   * Dispose of the resources used by the manager.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._models.clear();
    this._kernelConnections.forEach(x => x.dispose());
    this._pollModels.dispose();
    super.dispose();
  }
  /**
   * Connect to an existing kernel.
   *
   * @returns The new kernel connection.
   *
   * #### Notes
   * This will use the manager's server settings and ignore any server
   * settings passed in the options.
   */
  connectTo(options) {
    var _a;
    const {
      id
    } = options.model;
    let handleComms = (_a = options.handleComms) !== null && _a !== void 0 ? _a : true;
    // By default, handle comms only if no other kernel connection is.
    if (options.handleComms === undefined) {
      for (const kc of this._kernelConnections) {
        if (kc.id === id && kc.handleComms) {
          handleComms = false;
          break;
        }
      }
    }
    const kernelConnection = new default_1.KernelConnection({
      handleComms,
      ...options,
      serverSettings: this.serverSettings
    });
    this._onStarted(kernelConnection);
    if (!this._models.has(id)) {
      // We trust the user to connect to an existing kernel, but we verify
      // asynchronously.
      void this.refreshRunning().catch(() => {
        /* no-op */
      });
    }
    return kernelConnection;
  }
  /**
   * Create an iterator over the most recent running kernels.
   *
   * @returns A new iterator over the running kernels.
   */
  running() {
    return this._models.values();
  }
  /**
   * Force a refresh of the running kernels.
   *
   * @returns A promise that resolves when the running list has been refreshed.
   *
   * #### Notes
   * This is not typically meant to be called by the user, since the
   * manager maintains its own internal state.
   */
  async refreshRunning() {
    await this._pollModels.refresh();
    await this._pollModels.tick;
  }
  /**
   * Start a new kernel.
   *
   * @param createOptions - The kernel creation options
   *
   * @param connectOptions - The kernel connection options
   *
   * @returns A promise that resolves with the kernel connection.
   *
   * #### Notes
   * The manager `serverSettings` will be always be used.
   */
  async startNew(createOptions = {}, connectOptions = {}) {
    const model = await (0, restapi_1.startNew)(createOptions, this.serverSettings);
    return this.connectTo({
      ...connectOptions,
      model
    });
  }
  /**
   * Shut down a kernel by id.
   *
   * @param id - The id of the target kernel.
   *
   * @returns A promise that resolves when the operation is complete.
   */
  async shutdown(id) {
    await (0, restapi_1.shutdownKernel)(id, this.serverSettings);
    await this.refreshRunning();
  }
  /**
   * Shut down all kernels.
   *
   * @returns A promise that resolves when all of the kernels are shut down.
   */
  async shutdownAll() {
    // Update the list of models to make sure our list is current.
    await this.refreshRunning();
    // Shut down all models.
    await Promise.all([...this._models.keys()].map(id => (0, restapi_1.shutdownKernel)(id, this.serverSettings)));
    // Update the list of models to clear out our state.
    await this.refreshRunning();
  }
  /**
   * Find a kernel by id.
   *
   * @param id - The id of the target kernel.
   *
   * @returns A promise that resolves with the kernel's model.
   */
  async findById(id) {
    if (this._models.has(id)) {
      return this._models.get(id);
    }
    await this.refreshRunning();
    return this._models.get(id);
  }
  /**
   * Execute a request to the server to poll running kernels and update state.
   */
  async requestRunning() {
    var _a, _b;
    let models;
    try {
      models = await (0, restapi_1.listRunning)(this.serverSettings);
    } catch (err) {
      // Handle network errors, as well as cases where we are on a
      // JupyterHub and the server is not running. JupyterHub returns a
      // 503 (<2.0) or 424 (>2.0) in that case.
      if (err instanceof __1.ServerConnection.NetworkError || ((_a = err.response) === null || _a === void 0 ? void 0 : _a.status) === 503 || ((_b = err.response) === null || _b === void 0 ? void 0 : _b.status) === 424) {
        this._connectionFailure.emit(err);
      }
      throw err;
    }
    if (this.isDisposed) {
      return;
    }
    if (this._models.size === models.length && models.every(model => {
      const existing = this._models.get(model.id);
      if (!existing) {
        return false;
      }
      return existing.connections === model.connections && existing.execution_state === model.execution_state && existing.last_activity === model.last_activity && existing.name === model.name && existing.reason === model.reason && existing.traceback === model.traceback;
    })) {
      // Identical models list (presuming models does not contain duplicate
      // ids), so just return
      return;
    }
    this._models = new Map(models.map(x => [x.id, x]));
    // For any kernel connection to a kernel that doesn't exist, notify it of
    // the shutdown.
    this._kernelConnections.forEach(kc => {
      if (!this._models.has(kc.id)) {
        kc.handleShutdown();
      }
    });
    this._runningChanged.emit(models);
  }
  /**
   * Handle a kernel starting.
   */
  _onStarted(kernelConnection) {
    this._kernelConnections.add(kernelConnection);
    kernelConnection.statusChanged.connect(this._onStatusChanged, this);
    kernelConnection.disposed.connect(this._onDisposed, this);
  }
  _onDisposed(kernelConnection) {
    this._kernelConnections.delete(kernelConnection);
    // A dispose emission could mean the server session is deleted, or that
    // the kernel JS object is disposed and the kernel still exists on the
    // server, so we refresh from the server to make sure we reflect the
    // server state.
    void this.refreshRunning().catch(() => {
      /* no-op */
    });
  }
  _onStatusChanged(kernelConnection, status) {
    if (status === 'dead') {
      // We asynchronously update our list of kernels, which asynchronously
      // will dispose them. We do not want to immediately dispose them because
      // there may be other signal handlers that want to be called.
      void this.refreshRunning().catch(() => {
        /* no-op */
      });
    }
  }
}
exports.KernelManager = KernelManager;
/**
 * The namespace for `KernelManager` class statics.
 */
(function (KernelManager) {
  /**
   * A no-op kernel manager to be used when starting kernels.
   */
  class NoopManager extends KernelManager {
    constructor() {
      super(...arguments);
      this._readyPromise = new Promise(() => {
        /* no-op */
      });
    }
    /**
     * Whether the manager is active.
     */
    get isActive() {
      return false;
    }
    /**
     * Used for testing.
     */
    get parentReady() {
      return super.ready;
    }
    /**
     * Start a new kernel - throws an error since it is not supported.
     */
    async startNew(createOptions = {}, connectOptions = {}) {
      return Promise.reject(new Error('Not implemented in no-op Kernel Manager'));
    }
    /**
     * Connect to an existing kernel - throws an error since it is not supported.
     */
    connectTo(options) {
      throw new Error('Not implemented in no-op Kernel Manager');
    }
    /**
     * Shut down a kernel by id - throws an error since it is not supported.
     */
    async shutdown(id) {
      return Promise.reject(new Error('Not implemented in no-op Kernel Manager'));
    }
    /**
     * A promise that fulfills when the manager is ready (never).
     */
    get ready() {
      return this.parentReady.then(() => this._readyPromise);
    }
    /**
     * Execute a request to the server to poll running kernels and update state.
     */
    async requestRunning() {
      return Promise.resolve();
    }
  }
  KernelManager.NoopManager = NoopManager;
})(KernelManager = exports.KernelManager || (exports.KernelManager = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/messages.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/messages.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.supportedKernelWebSocketProtocols = exports.isInputReplyMsg = exports.isInputRequestMsg = exports.isDebugReplyMsg = exports.isDebugRequestMsg = exports.isExecuteReplyMsg = exports.isInfoRequestMsg = exports.isCommMsgMsg = exports.isCommCloseMsg = exports.isCommOpenMsg = exports.isDebugEventMsg = exports.isClearOutputMsg = exports.isStatusMsg = exports.isErrorMsg = exports.isExecuteResultMsg = exports.isExecuteInputMsg = exports.isUpdateDisplayDataMsg = exports.isDisplayDataMsg = exports.isStreamMsg = exports.createMessage = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
function createMessage(options) {
  var _a, _b, _c, _d, _e;
  return {
    buffers: (_a = options.buffers) !== null && _a !== void 0 ? _a : [],
    channel: options.channel,
    content: options.content,
    header: {
      date: new Date().toISOString(),
      msg_id: (_b = options.msgId) !== null && _b !== void 0 ? _b : coreutils_1.UUID.uuid4(),
      msg_type: options.msgType,
      session: options.session,
      username: (_c = options.username) !== null && _c !== void 0 ? _c : '',
      version: '5.2'
    },
    metadata: (_d = options.metadata) !== null && _d !== void 0 ? _d : {},
    parent_header: (_e = options.parentHeader) !== null && _e !== void 0 ? _e : {}
  };
}
exports.createMessage = createMessage;
/**
 * Test whether a kernel message is a `'stream'` message.
 */
function isStreamMsg(msg) {
  return msg.header.msg_type === 'stream';
}
exports.isStreamMsg = isStreamMsg;
/**
 * Test whether a kernel message is an `'display_data'` message.
 */
function isDisplayDataMsg(msg) {
  return msg.header.msg_type === 'display_data';
}
exports.isDisplayDataMsg = isDisplayDataMsg;
/**
 * Test whether a kernel message is an `'update_display_data'` message.
 */
function isUpdateDisplayDataMsg(msg) {
  return msg.header.msg_type === 'update_display_data';
}
exports.isUpdateDisplayDataMsg = isUpdateDisplayDataMsg;
/**
 * Test whether a kernel message is an `'execute_input'` message.
 */
function isExecuteInputMsg(msg) {
  return msg.header.msg_type === 'execute_input';
}
exports.isExecuteInputMsg = isExecuteInputMsg;
/**
 * Test whether a kernel message is an `'execute_result'` message.
 */
function isExecuteResultMsg(msg) {
  return msg.header.msg_type === 'execute_result';
}
exports.isExecuteResultMsg = isExecuteResultMsg;
/**
 * Test whether a kernel message is an `'error'` message.
 */
function isErrorMsg(msg) {
  return msg.header.msg_type === 'error';
}
exports.isErrorMsg = isErrorMsg;
/**
 * Test whether a kernel message is a `'status'` message.
 */
function isStatusMsg(msg) {
  return msg.header.msg_type === 'status';
}
exports.isStatusMsg = isStatusMsg;
/**
 * Test whether a kernel message is a `'clear_output'` message.
 */
function isClearOutputMsg(msg) {
  return msg.header.msg_type === 'clear_output';
}
exports.isClearOutputMsg = isClearOutputMsg;
/**
 * Test whether a kernel message is an experimental `'debug_event'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugEventMsg(msg) {
  return msg.header.msg_type === 'debug_event';
}
exports.isDebugEventMsg = isDebugEventMsg;
/**
 * Test whether a kernel message is a `'comm_open'` message.
 */
function isCommOpenMsg(msg) {
  return msg.header.msg_type === 'comm_open';
}
exports.isCommOpenMsg = isCommOpenMsg;
/**
 * Test whether a kernel message is a `'comm_close'` message.
 */
function isCommCloseMsg(msg) {
  return msg.header.msg_type === 'comm_close';
}
exports.isCommCloseMsg = isCommCloseMsg;
/**
 * Test whether a kernel message is a `'comm_msg'` message.
 */
function isCommMsgMsg(msg) {
  return msg.header.msg_type === 'comm_msg';
}
exports.isCommMsgMsg = isCommMsgMsg;
/**
 * Test whether a kernel message is a `'kernel_info_request'` message.
 */
function isInfoRequestMsg(msg) {
  return msg.header.msg_type === 'kernel_info_request';
}
exports.isInfoRequestMsg = isInfoRequestMsg;
/**
 * Test whether a kernel message is an `'execute_reply'` message.
 */
function isExecuteReplyMsg(msg) {
  return msg.header.msg_type === 'execute_reply';
}
exports.isExecuteReplyMsg = isExecuteReplyMsg;
/**
 * Test whether a kernel message is an experimental `'debug_request'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugRequestMsg(msg) {
  return msg.header.msg_type === 'debug_request';
}
exports.isDebugRequestMsg = isDebugRequestMsg;
/**
 * Test whether a kernel message is an experimental `'debug_reply'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugReplyMsg(msg) {
  return msg.header.msg_type === 'debug_reply';
}
exports.isDebugReplyMsg = isDebugReplyMsg;
/**
 * Test whether a kernel message is an `'input_request'` message.
 */
function isInputRequestMsg(msg) {
  return msg.header.msg_type === 'input_request';
}
exports.isInputRequestMsg = isInputRequestMsg;
/**
 * Test whether a kernel message is an `'input_reply'` message.
 */
function isInputReplyMsg(msg) {
  return msg.header.msg_type === 'input_reply';
}
exports.isInputReplyMsg = isInputReplyMsg;
// ///////////////////////////////////////////////
// Message (de)serialization
// ///////////////////////////////////////////////
/**
 * The list of supported kernel wire protocols over websocket.
 */
var supportedKernelWebSocketProtocols;
(function (supportedKernelWebSocketProtocols) {
  supportedKernelWebSocketProtocols["v1KernelWebsocketJupyterOrg"] = "v1.kernel.websocket.jupyter.org";
})(supportedKernelWebSocketProtocols = exports.supportedKernelWebSocketProtocols || (exports.supportedKernelWebSocketProtocols = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/restapi.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/restapi.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getKernelModel = exports.shutdownKernel = exports.interruptKernel = exports.restartKernel = exports.startNew = exports.listRunning = exports.KERNEL_SERVICE_URL = void 0;
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const validate_1 = __webpack_require__(/*! ./validate */ "./node_modules/@jupyterlab/services/lib/kernel/validate.js");
/**
 * The url for the kernel service.
 */
exports.KERNEL_SERVICE_URL = 'api/kernels';
/**
 * Fetch the running kernels.
 *
 * @param settings - The optional server settings.
 *
 * @returns A promise that resolves with the list of running kernels.
 *
 * #### Notes
 * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function listRunning(settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL);
  const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
  if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  (0, validate_1.validateModels)(data);
  return data;
}
exports.listRunning = listRunning;
/**
 * Start a new kernel.
 *
 * @param options - The options used to create the kernel.
 *
 * @returns A promise that resolves with a kernel connection object.
 *
 * #### Notes
 * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function startNew(options = {}, settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL);
  const init = {
    method: 'POST',
    body: JSON.stringify(options)
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status !== 201) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  (0, validate_1.validateModel)(data);
  return data;
}
exports.startNew = startNew;
/**
 * Restart a kernel.
 *
 * #### Notes
 * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response (and thus after a restart) and rejected otherwise.
 */
async function restartKernel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL, encodeURIComponent(id), 'restart');
  const init = {
    method: 'POST'
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  (0, validate_1.validateModel)(data);
}
exports.restartKernel = restartKernel;
/**
 * Interrupt a kernel.
 *
 * #### Notes
 * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function interruptKernel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL, encodeURIComponent(id), 'interrupt');
  const init = {
    method: 'POST'
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status !== 204) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
}
exports.interruptKernel = interruptKernel;
/**
 * Shut down a kernel.
 *
 * @param id - The id of the running kernel.
 *
 * @param settings - The server settings for the request.
 *
 * @returns A promise that resolves when the kernel is shut down.
 *
 *
 * #### Notes
 * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function shutdownKernel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL, encodeURIComponent(id));
  const init = {
    method: 'DELETE'
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status === 404) {
    const msg = `The kernel "${id}" does not exist on the server`;
    console.warn(msg);
  } else if (response.status !== 204) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
}
exports.shutdownKernel = shutdownKernel;
/**
 * Get a full kernel model from the server by kernel id string.
 *
 * #### Notes
 * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernels) and validates the response model.
 *
 * The promise is fulfilled on a valid response and rejected otherwise.
 */
async function getKernelModel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.KERNEL_SERVICE_URL, encodeURIComponent(id));
  const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
  if (response.status === 404) {
    return undefined;
  } else if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  (0, validate_1.validateModel)(data);
  return data;
}
exports.getKernelModel = getKernelModel;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/serialize.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/serialize.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.deserialize = exports.serialize = void 0;
const KernelMessage = __importStar(__webpack_require__(/*! ./messages */ "./node_modules/@jupyterlab/services/lib/kernel/messages.js"));
/**
 * Serialize a kernel message for transport.
 */
function serialize(msg, protocol = '') {
  switch (protocol) {
    case KernelMessage.supportedKernelWebSocketProtocols.v1KernelWebsocketJupyterOrg:
      return Private.serializeV1KernelWebsocketJupyterOrg(msg);
    default:
      return Private.serializeDefault(msg);
  }
}
exports.serialize = serialize;
/**
 * Deserialize and return the unpacked message.
 */
function deserialize(data, protocol = '') {
  switch (protocol) {
    case KernelMessage.supportedKernelWebSocketProtocols.v1KernelWebsocketJupyterOrg:
      return Private.deserializeV1KernelWebsocketJupyterOrg(data);
    default:
      return Private.deserializeDefault(data);
  }
}
exports.deserialize = deserialize;
var Private;
(function (Private) {
  /**
   * Deserialize and return the unpacked message.
   * Protocol `v1.kernel.websocket.jupyter.org`
   */
  function deserializeV1KernelWebsocketJupyterOrg(binMsg) {
    let msg;
    const data = new DataView(binMsg);
    const offsetNumber = Number(data.getBigUint64(0, true /* littleEndian */));
    let offsets = [];
    for (let i = 0; i < offsetNumber; i++) {
      // WARNING: we cast our 64-bit unsigned int to a number!
      // so offsets cannot index up to 2**64 bytes
      offsets.push(Number(data.getBigUint64(8 * (i + 1), true /* littleEndian */)));
    }

    const decoder = new TextDecoder('utf8');
    const channel = decoder.decode(binMsg.slice(offsets[0], offsets[1]));
    const header = JSON.parse(decoder.decode(binMsg.slice(offsets[1], offsets[2])));
    const parent_header = JSON.parse(decoder.decode(binMsg.slice(offsets[2], offsets[3])));
    const metadata = JSON.parse(decoder.decode(binMsg.slice(offsets[3], offsets[4])));
    const content = JSON.parse(decoder.decode(binMsg.slice(offsets[4], offsets[5])));
    let buffers = [];
    for (let i = 5; i < offsets.length - 1; i++) {
      buffers.push(new DataView(binMsg.slice(offsets[i], offsets[i + 1])));
    }
    msg = {
      channel,
      header,
      parent_header,
      metadata,
      content,
      buffers
    };
    return msg;
  }
  Private.deserializeV1KernelWebsocketJupyterOrg = deserializeV1KernelWebsocketJupyterOrg;
  /**
   * Serialize a kernel message for transport.
   * Protocol `v1.kernel.websocket.jupyter.org`
   */
  function serializeV1KernelWebsocketJupyterOrg(msg) {
    const header = JSON.stringify(msg.header);
    const parentHeader = msg.parent_header == null ? '{}' : JSON.stringify(msg.parent_header);
    const metadata = JSON.stringify(msg.metadata);
    const content = JSON.stringify(msg.content);
    const buffers = msg.buffers !== undefined ? msg.buffers : [];
    const offsetNumber = 1 + 4 + buffers.length + 1;
    let offsets = [];
    offsets.push(8 * (1 + offsetNumber));
    offsets.push(msg.channel.length + offsets[offsets.length - 1]);
    const encoder = new TextEncoder();
    const channelEncoded = encoder.encode(msg.channel);
    const headerEncoded = encoder.encode(header);
    const parentHeaderEncoded = encoder.encode(parentHeader);
    const metadataEncoded = encoder.encode(metadata);
    const contentEncoded = encoder.encode(content);
    const binMsgNoBuff = new Uint8Array(channelEncoded.length + headerEncoded.length + parentHeaderEncoded.length + metadataEncoded.length + contentEncoded.length);
    binMsgNoBuff.set(channelEncoded);
    binMsgNoBuff.set(headerEncoded, channelEncoded.length);
    binMsgNoBuff.set(parentHeaderEncoded, channelEncoded.length + headerEncoded.length);
    binMsgNoBuff.set(metadataEncoded, channelEncoded.length + headerEncoded.length + parentHeaderEncoded.length);
    binMsgNoBuff.set(contentEncoded, channelEncoded.length + headerEncoded.length + parentHeaderEncoded.length + metadataEncoded.length);
    for (let length of [headerEncoded.length, parentHeaderEncoded.length, metadataEncoded.length, contentEncoded.length]) {
      offsets.push(length + offsets[offsets.length - 1]);
    }
    let buffersByteLength = 0;
    for (let buffer of buffers) {
      let length = buffer.byteLength;
      offsets.push(length + offsets[offsets.length - 1]);
      buffersByteLength += length;
    }
    const binMsg = new Uint8Array(8 * (1 + offsetNumber) + binMsgNoBuff.byteLength + buffersByteLength);
    const word = new ArrayBuffer(8);
    const data = new DataView(word);
    data.setBigUint64(0, BigInt(offsetNumber), true /* littleEndian */);
    binMsg.set(new Uint8Array(word), 0);
    for (let i = 0; i < offsets.length; i++) {
      data.setBigUint64(0, BigInt(offsets[i]), true /* littleEndian */);
      binMsg.set(new Uint8Array(word), 8 * (i + 1));
    }
    binMsg.set(binMsgNoBuff, offsets[0]);
    for (let i = 0; i < buffers.length; i++) {
      const buffer = buffers[i];
      binMsg.set(new Uint8Array(ArrayBuffer.isView(buffer) ? buffer.buffer : buffer), offsets[5 + i]);
    }
    return binMsg.buffer;
  }
  Private.serializeV1KernelWebsocketJupyterOrg = serializeV1KernelWebsocketJupyterOrg;
  /**
   * Deserialize and return the unpacked message.
   * Default protocol
   *
   * #### Notes
   * Handles JSON blob strings and binary messages.
   */
  function deserializeDefault(data) {
    let value;
    if (typeof data === 'string') {
      value = JSON.parse(data);
    } else {
      value = deserializeBinary(data);
    }
    return value;
  }
  Private.deserializeDefault = deserializeDefault;
  /**
   * Serialize a kernel message for transport.
   * Default protocol
   *
   * #### Notes
   * If there is binary content, an `ArrayBuffer` is returned,
   * otherwise the message is converted to a JSON string.
   */
  function serializeDefault(msg) {
    var _a;
    let value;
    if ((_a = msg.buffers) === null || _a === void 0 ? void 0 : _a.length) {
      value = serializeBinary(msg);
    } else {
      value = JSON.stringify(msg);
    }
    return value;
  }
  Private.serializeDefault = serializeDefault;
  /**
   * Deserialize a binary message to a Kernel Message.
   */
  function deserializeBinary(buf) {
    const data = new DataView(buf);
    // read the header: 1 + nbufs 32b integers
    const nbufs = data.getUint32(0);
    const offsets = [];
    if (nbufs < 2) {
      throw new Error('Invalid incoming Kernel Message');
    }
    for (let i = 1; i <= nbufs; i++) {
      offsets.push(data.getUint32(i * 4));
    }
    const jsonBytes = new Uint8Array(buf.slice(offsets[0], offsets[1]));
    const msg = JSON.parse(new TextDecoder('utf8').decode(jsonBytes));
    // the remaining chunks are stored as DataViews in msg.buffers
    msg.buffers = [];
    for (let i = 1; i < nbufs; i++) {
      const start = offsets[i];
      const stop = offsets[i + 1] || buf.byteLength;
      msg.buffers.push(new DataView(buf.slice(start, stop)));
    }
    return msg;
  }
  /**
   * Implement the binary serialization protocol.
   *
   * Serialize Kernel message to ArrayBuffer.
   */
  function serializeBinary(msg) {
    const offsets = [];
    const buffers = [];
    const encoder = new TextEncoder();
    let origBuffers = [];
    if (msg.buffers !== undefined) {
      origBuffers = msg.buffers;
      delete msg['buffers'];
    }
    const jsonUtf8 = encoder.encode(JSON.stringify(msg));
    buffers.push(jsonUtf8.buffer);
    for (let i = 0; i < origBuffers.length; i++) {
      // msg.buffers elements could be either views or ArrayBuffers
      // buffers elements are ArrayBuffers
      const b = origBuffers[i];
      buffers.push(ArrayBuffer.isView(b) ? b.buffer : b);
    }
    const nbufs = buffers.length;
    offsets.push(4 * (nbufs + 1));
    for (let i = 0; i + 1 < buffers.length; i++) {
      offsets.push(offsets[offsets.length - 1] + buffers[i].byteLength);
    }
    const msgBuf = new Uint8Array(offsets[offsets.length - 1] + buffers[buffers.length - 1].byteLength);
    // use DataView.setUint32 for network byte-order
    const view = new DataView(msgBuf.buffer);
    // write nbufs to first 4 bytes
    view.setUint32(0, nbufs);
    // write offsets to next 4 * nbufs bytes
    for (let i = 0; i < offsets.length; i++) {
      view.setUint32(4 * (i + 1), offsets[i]);
    }
    // write all the buffers at their respective offsets
    for (let i = 0; i < buffers.length; i++) {
      msgBuf.set(new Uint8Array(buffers[i]), offsets[i]);
    }
    return msgBuf.buffer;
  }
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernel/validate.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernel/validate.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.validateModels = exports.validateModel = exports.validateMessage = void 0;
const validate_1 = __webpack_require__(/*! ../validate */ "./node_modules/@jupyterlab/services/lib/validate.js");
/**
 * Required fields for `IKernelHeader`.
 */
const HEADER_FIELDS = ['username', 'version', 'session', 'msg_id', 'msg_type'];
/**
 * Required fields and types for contents of various types of `kernel.IMessage`
 * messages on the iopub channel.
 */
const IOPUB_CONTENT_FIELDS = {
  stream: {
    name: 'string',
    text: 'string'
  },
  display_data: {
    data: 'object',
    metadata: 'object'
  },
  execute_input: {
    code: 'string',
    execution_count: 'number'
  },
  execute_result: {
    execution_count: 'number',
    data: 'object',
    metadata: 'object'
  },
  error: {
    ename: 'string',
    evalue: 'string',
    traceback: 'object'
  },
  status: {
    execution_state: ['string', ['starting', 'idle', 'busy', 'restarting', 'dead']]
  },
  clear_output: {
    wait: 'boolean'
  },
  comm_open: {
    comm_id: 'string',
    target_name: 'string',
    data: 'object'
  },
  comm_msg: {
    comm_id: 'string',
    data: 'object'
  },
  comm_close: {
    comm_id: 'string'
  },
  shutdown_reply: {
    restart: 'boolean'
  } // Emitted by the IPython kernel.
};
/**
 * Validate the header of a kernel message.
 */
function validateHeader(header) {
  for (let i = 0; i < HEADER_FIELDS.length; i++) {
    (0, validate_1.validateProperty)(header, HEADER_FIELDS[i], 'string');
  }
}
/**
 * Validate a kernel message object.
 */
function validateMessage(msg) {
  (0, validate_1.validateProperty)(msg, 'metadata', 'object');
  (0, validate_1.validateProperty)(msg, 'content', 'object');
  (0, validate_1.validateProperty)(msg, 'channel', 'string');
  validateHeader(msg.header);
  if (msg.channel === 'iopub') {
    validateIOPubContent(msg);
  }
}
exports.validateMessage = validateMessage;
/**
 * Validate content an kernel message on the iopub channel.
 */
function validateIOPubContent(msg) {
  if (msg.channel === 'iopub') {
    const fields = IOPUB_CONTENT_FIELDS[msg.header.msg_type];
    // Check for unknown message type.
    if (fields === undefined) {
      return;
    }
    const names = Object.keys(fields);
    const content = msg.content;
    for (let i = 0; i < names.length; i++) {
      let args = fields[names[i]];
      if (!Array.isArray(args)) {
        args = [args];
      }
      (0, validate_1.validateProperty)(content, names[i], ...args);
    }
  }
}
/**
 * Validate a `Kernel.IModel` object.
 */
function validateModel(model) {
  (0, validate_1.validateProperty)(model, 'name', 'string');
  (0, validate_1.validateProperty)(model, 'id', 'string');
}
exports.validateModel = validateModel;
/**
 * Validate an array of `IModel` objects.
 */
function validateModels(models) {
  if (!Array.isArray(models)) {
    throw new Error('Invalid kernel list');
  }
  models.forEach(d => validateModel(d));
}
exports.validateModels = validateModels;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernelspec/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernelspec/index.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __exportStar = this && this.__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.KernelSpecAPI = exports.KernelSpec = void 0;
const KernelSpec = __importStar(__webpack_require__(/*! ./kernelspec */ "./node_modules/@jupyterlab/services/lib/kernelspec/kernelspec.js"));
exports.KernelSpec = KernelSpec;
const KernelSpecAPI = __importStar(__webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/kernelspec/restapi.js"));
exports.KernelSpecAPI = KernelSpecAPI;
__exportStar(__webpack_require__(/*! ./manager */ "./node_modules/@jupyterlab/services/lib/kernelspec/manager.js"), exports);

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernelspec/kernelspec.js":
/*!************************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernelspec/kernelspec.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernelspec/manager.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernelspec/manager.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.KernelSpecManager = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
const polling_1 = __webpack_require__(/*! @lumino/polling */ "./node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const restapi = __importStar(__webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/kernelspec/restapi.js"));
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "./node_modules/@jupyterlab/services/lib/basemanager.js");
/**
 * An implementation of a kernel spec manager.
 */
class KernelSpecManager extends basemanager_1.BaseManager {
  /**
   * Construct a new kernel spec manager.
   *
   * @param options - The default options for kernel.
   */
  constructor(options = {}) {
    var _a;
    super(options);
    this._isReady = false;
    this._connectionFailure = new signaling_1.Signal(this);
    this._specs = null;
    this._specsChanged = new signaling_1.Signal(this);
    // Initialize internal data.
    this._ready = Promise.all([this.requestSpecs()]).then(_ => undefined).catch(_ => undefined).then(() => {
      if (this.isDisposed) {
        return;
      }
      this._isReady = true;
    });
    this._pollSpecs = new polling_1.Poll({
      auto: false,
      factory: () => this.requestSpecs(),
      frequency: {
        interval: 61 * 1000,
        backoff: true,
        max: 300 * 1000
      },
      name: `@jupyterlab/services:KernelSpecManager#specs`,
      standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
    });
    void this.ready.then(() => {
      void this._pollSpecs.start();
    });
  }
  /**
   * Test whether the manager is ready.
   */
  get isReady() {
    return this._isReady;
  }
  /**
   * A promise that fulfills when the manager is ready.
   */
  get ready() {
    return this._ready;
  }
  /**
   * Get the most recently fetched kernel specs.
   */
  get specs() {
    return this._specs;
  }
  /**
   * A signal emitted when the specs change.
   */
  get specsChanged() {
    return this._specsChanged;
  }
  /**
   * A signal emitted when there is a connection failure.
   */
  get connectionFailure() {
    return this._connectionFailure;
  }
  /**
   * Dispose of the resources used by the manager.
   */
  dispose() {
    this._pollSpecs.dispose();
    super.dispose();
  }
  /**
   * Force a refresh of the specs from the server.
   *
   * @returns A promise that resolves when the specs are fetched.
   *
   * #### Notes
   * This is intended to be called only in response to a user action,
   * since the manager maintains its internal state.
   */
  async refreshSpecs() {
    await this._pollSpecs.refresh();
    await this._pollSpecs.tick;
  }
  /**
   * Execute a request to the server to poll specs and update state.
   */
  async requestSpecs() {
    const specs = await restapi.getSpecs(this.serverSettings);
    if (this.isDisposed) {
      return;
    }
    if (!coreutils_1.JSONExt.deepEqual(specs, this._specs)) {
      this._specs = specs;
      this._specsChanged.emit(specs);
    }
  }
}
exports.KernelSpecManager = KernelSpecManager;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernelspec/restapi.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernelspec/restapi.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getSpecs = void 0;
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
const validate_1 = __webpack_require__(/*! ./validate */ "./node_modules/@jupyterlab/services/lib/kernelspec/validate.js");
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/**
 * The url for the kernelspec service.
 */
const KERNELSPEC_SERVICE_URL = 'api/kernelspecs';
/**
 * Fetch all of the kernel specs.
 *
 * @param settings - The optional server settings.
 * @param useCache - Whether to use the cache. If false, always request.
 *
 * @returns A promise that resolves with the kernel specs.
 *
 * #### Notes
 * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/kernelspecs).
 */
async function getSpecs(settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, KERNELSPEC_SERVICE_URL);
  const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
  if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  return (0, validate_1.validateSpecModels)(data);
}
exports.getSpecs = getSpecs;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/kernelspec/validate.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/kernelspec/validate.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.validateSpecModels = exports.validateSpecModel = void 0;
const validate_1 = __webpack_require__(/*! ../validate */ "./node_modules/@jupyterlab/services/lib/validate.js");
/**
 * Validate a server kernelspec model to a client side model.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function validateSpecModel(data) {
  const spec = data.spec;
  if (!spec) {
    throw new Error('Invalid kernel spec');
  }
  (0, validate_1.validateProperty)(data, 'name', 'string');
  (0, validate_1.validateProperty)(data, 'resources', 'object');
  (0, validate_1.validateProperty)(spec, 'language', 'string');
  (0, validate_1.validateProperty)(spec, 'display_name', 'string');
  (0, validate_1.validateProperty)(spec, 'argv', 'array');
  let metadata = null;
  if (spec.hasOwnProperty('metadata')) {
    (0, validate_1.validateProperty)(spec, 'metadata', 'object');
    metadata = spec.metadata;
  }
  let env = null;
  if (spec.hasOwnProperty('env')) {
    (0, validate_1.validateProperty)(spec, 'env', 'object');
    env = spec.env;
  }
  return {
    name: data.name,
    resources: data.resources,
    language: spec.language,
    display_name: spec.display_name,
    argv: spec.argv,
    metadata,
    env
  };
}
exports.validateSpecModel = validateSpecModel;
/**
 * Validate a `Kernel.ISpecModels` object.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function validateSpecModels(data) {
  if (!data.hasOwnProperty('kernelspecs')) {
    throw new Error('No kernelspecs found');
  }
  let keys = Object.keys(data.kernelspecs);
  const kernelspecs = Object.create(null);
  let defaultSpec = data.default;
  for (let i = 0; i < keys.length; i++) {
    const ks = data.kernelspecs[keys[i]];
    try {
      kernelspecs[keys[i]] = validateSpecModel(ks);
    } catch (err) {
      // Remove the errant kernel spec.
      console.warn(`Removing errant kernel spec: ${keys[i]}`);
    }
  }
  keys = Object.keys(kernelspecs);
  if (!keys.length) {
    throw new Error('No valid kernelspecs found');
  }
  if (!defaultSpec || typeof defaultSpec !== 'string' || !(defaultSpec in kernelspecs)) {
    defaultSpec = keys[0];
    console.warn(`Default kernel not found, using '${keys[0]}'`);
  }
  return {
    default: defaultSpec,
    kernelspecs
  };
}
exports.validateSpecModels = validateSpecModels;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/manager.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/manager.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ServiceManager = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const builder_1 = __webpack_require__(/*! ./builder */ "./node_modules/@jupyterlab/services/lib/builder/index.js");
const contents_1 = __webpack_require__(/*! ./contents */ "./node_modules/@jupyterlab/services/lib/contents/index.js");
const event_1 = __webpack_require__(/*! ./event */ "./node_modules/@jupyterlab/services/lib/event/index.js");
const kernel_1 = __webpack_require__(/*! ./kernel */ "./node_modules/@jupyterlab/services/lib/kernel/index.js");
const kernelspec_1 = __webpack_require__(/*! ./kernelspec */ "./node_modules/@jupyterlab/services/lib/kernelspec/index.js");
const nbconvert_1 = __webpack_require__(/*! ./nbconvert */ "./node_modules/@jupyterlab/services/lib/nbconvert/index.js");
const serverconnection_1 = __webpack_require__(/*! ./serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
const session_1 = __webpack_require__(/*! ./session */ "./node_modules/@jupyterlab/services/lib/session/index.js");
const setting_1 = __webpack_require__(/*! ./setting */ "./node_modules/@jupyterlab/services/lib/setting/index.js");
const terminal_1 = __webpack_require__(/*! ./terminal */ "./node_modules/@jupyterlab/services/lib/terminal/index.js");
const user_1 = __webpack_require__(/*! ./user */ "./node_modules/@jupyterlab/services/lib/user/index.js");
const workspace_1 = __webpack_require__(/*! ./workspace */ "./node_modules/@jupyterlab/services/lib/workspace/index.js");
/**
 * A Jupyter services manager.
 */
class ServiceManager {
  /**
   * Construct a new services provider.
   */
  constructor(options = {}) {
    var _a, _b;
    this._isDisposed = false;
    this._connectionFailure = new signaling_1.Signal(this);
    this._isReady = false;
    const defaultDrive = options.defaultDrive;
    const serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
    const standby = (_b = options.standby) !== null && _b !== void 0 ? _b : 'when-hidden';
    const normalized = {
      defaultDrive,
      serverSettings,
      standby
    };
    this.serverSettings = serverSettings;
    this.contents = options.contents || new contents_1.ContentsManager(normalized);
    this.events = options.events || new event_1.EventManager(normalized);
    this.kernels = options.kernels || new kernel_1.KernelManager(normalized);
    this.sessions = options.sessions || new session_1.SessionManager({
      ...normalized,
      kernelManager: this.kernels
    });
    this.settings = options.settings || new setting_1.SettingManager(normalized);
    this.terminals = options.terminals || new terminal_1.TerminalManager(normalized);
    this.builder = options.builder || new builder_1.BuildManager(normalized);
    this.workspaces = options.workspaces || new workspace_1.WorkspaceManager(normalized);
    this.nbconvert = options.nbconvert || new nbconvert_1.NbConvertManager(normalized);
    this.kernelspecs = options.kernelspecs || new kernelspec_1.KernelSpecManager(normalized);
    this.user = options.user || new user_1.UserManager(normalized);
    // Proxy all connection failures from the individual service managers.
    this.kernelspecs.connectionFailure.connect(this._onConnectionFailure, this);
    this.sessions.connectionFailure.connect(this._onConnectionFailure, this);
    this.terminals.connectionFailure.connect(this._onConnectionFailure, this);
    // Define promises that need to be resolved before service manager is ready.
    const readyList = [this.sessions.ready, this.kernelspecs.ready];
    if (this.terminals.isAvailable()) {
      readyList.push(this.terminals.ready);
    }
    this._readyPromise = Promise.all(readyList).then(() => {
      this._isReady = true;
    });
  }
  /**
   * A signal emitted when there is a connection failure with the kernel.
   */
  get connectionFailure() {
    return this._connectionFailure;
  }
  /**
   * Test whether the service manager is disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Dispose of the resources used by the manager.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._isDisposed = true;
    signaling_1.Signal.clearData(this);
    this.contents.dispose();
    this.events.dispose();
    this.sessions.dispose();
    this.terminals.dispose();
  }
  /**
   * Test whether the manager is ready.
   */
  get isReady() {
    return this._isReady;
  }
  /**
   * A promise that fulfills when the manager is ready.
   */
  get ready() {
    return this._readyPromise;
  }
  _onConnectionFailure(sender, err) {
    this._connectionFailure.emit(err);
  }
}
exports.ServiceManager = ServiceManager;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/nbconvert/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/nbconvert/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.NbConvertManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
const coreutils_2 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
/**
 * The url for the lab nbconvert service.
 */
const NBCONVERT_SETTINGS_URL = 'api/nbconvert';
/**
 * The nbconvert API service manager.
 */
class NbConvertManager {
  /**
   * Create a new nbconvert manager.
   */
  constructor(options = {}) {
    var _a;
    this._exportFormats = null;
    this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
  }
  /**
   * Fetch and cache the export formats from the expensive nbconvert handler.
   */
  async fetchExportFormats() {
    this._requestingFormats = new coreutils_2.PromiseDelegate();
    this._exportFormats = null;
    const base = this.serverSettings.baseUrl;
    const url = coreutils_1.URLExt.join(base, NBCONVERT_SETTINGS_URL);
    const {
      serverSettings
    } = this;
    const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, serverSettings);
    if (response.status !== 200) {
      const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
      throw err;
    }
    const data = await response.json();
    const exportList = {};
    const keys = Object.keys(data);
    keys.forEach(function (key) {
      const mimeType = data[key].output_mimetype;
      exportList[key] = {
        output_mimetype: mimeType
      };
    });
    this._exportFormats = exportList;
    this._requestingFormats.resolve(exportList);
    return exportList;
  }
  /**
   * Get the list of export formats, preferring pre-cached ones.
   */
  async getExportFormats(force = true) {
    if (this._requestingFormats) {
      return this._requestingFormats.promise;
    }
    if (force || !this._exportFormats) {
      return await this.fetchExportFormats();
    }
    return this._exportFormats;
  }
}
exports.NbConvertManager = NbConvertManager;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/serverconnection.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/serverconnection.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process/browser */ "./node_modules/process/browser.js");


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ServerConnection = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
let WEBSOCKET;
if (typeof window === 'undefined') {
  // Mangle the require statements so it does not get picked up in the
  // browser assets.
  WEBSOCKET = __webpack_require__(/*! ws */ "./node_modules/@jupyterlab/services/lib/shim/ws.js");
} else {
  WEBSOCKET = WebSocket;
}
/**
 * The namespace for ServerConnection functions.
 *
 * #### Notes
 * This is only intended to manage communication with the Jupyter server.
 *
 * The default values can be used in a JupyterLab or Jupyter Notebook context.
 *
 * We use `token` authentication if available, falling back on an XSRF
 * cookie if one has been provided on the `document`.
 *
 * A content type of `'application/json'` is added when using authentication
 * and there is no body data to allow the server to prevent malicious forms.
 */
var ServerConnection;
(function (ServerConnection) {
  /**
   * Create a settings object given a subset of options.
   *
   * @param options - An optional partial set of options.
   *
   * @returns The full settings object.
   */
  function makeSettings(options) {
    return Private.makeSettings(options);
  }
  ServerConnection.makeSettings = makeSettings;
  /**
   * Make an request to the notebook server.
   *
   * @param url - The url for the request.
   *
   * @param init - The initialization options for the request.
   *
   * @param settings - The server settings to apply to the request.
   *
   * @returns a Promise that resolves with the response.
   *
   * @throws If the url of the request is not a notebook server url.
   *
   * #### Notes
   * The `url` must start with `settings.baseUrl`.  The `init` settings are
   * merged with `settings.init`, with `init` taking precedence.
   * The headers in the two objects are not merged.
   * If there is no body data, we set the content type to `application/json`
   * because it is required by the Notebook server.
   */
  function makeRequest(url, init, settings) {
    return Private.handleRequest(url, init, settings);
  }
  ServerConnection.makeRequest = makeRequest;
  /**
   * A wrapped error for a fetch response.
   */
  class ResponseError extends Error {
    /**
     * Create a ResponseError from a response, handling the traceback and message
     * as appropriate.
     *
     * @param response The response object.
     *
     * @returns A promise that resolves with a `ResponseError` object.
     */
    static async create(response) {
      try {
        const data = await response.json();
        const {
          message,
          traceback
        } = data;
        if (traceback) {
          console.error(traceback);
        }
        return new ResponseError(response, message !== null && message !== void 0 ? message : ResponseError._defaultMessage(response), traceback !== null && traceback !== void 0 ? traceback : '');
      } catch (e) {
        console.debug(e);
        return new ResponseError(response);
      }
    }
    /**
     * Create a new response error.
     */
    constructor(response, message = ResponseError._defaultMessage(response), traceback = '') {
      super(message);
      this.response = response;
      this.traceback = traceback;
    }
    static _defaultMessage(response) {
      return `Invalid response: ${response.status} ${response.statusText}`;
    }
  }
  ServerConnection.ResponseError = ResponseError;
  /**
   * A wrapped error for a network error.
   */
  class NetworkError extends TypeError {
    /**
     * Create a new network error.
     */
    constructor(original) {
      super(original.message);
      this.stack = original.stack;
    }
  }
  ServerConnection.NetworkError = NetworkError;
})(ServerConnection = exports.ServerConnection || (exports.ServerConnection = {}));
/**
 * The namespace for module private data.
 */
var Private;
(function (Private) {
  /**
   * Handle the server connection settings, returning a new value.
   */
  function makeSettings(options = {}) {
    var _a;
    const pageBaseUrl = coreutils_1.PageConfig.getBaseUrl();
    const pageWsUrl = coreutils_1.PageConfig.getWsUrl();
    const baseUrl = coreutils_1.URLExt.normalize(options.baseUrl) || pageBaseUrl;
    let wsUrl = options.wsUrl;
    // Prefer the default wsUrl if we are using the default baseUrl.
    if (!wsUrl && baseUrl === pageBaseUrl) {
      wsUrl = pageWsUrl;
    }
    // Otherwise convert the baseUrl to a wsUrl if possible.
    if (!wsUrl && baseUrl.indexOf('http') === 0) {
      wsUrl = 'ws' + baseUrl.slice(4);
    }
    // Otherwise fall back on the default wsUrl.
    wsUrl = wsUrl !== null && wsUrl !== void 0 ? wsUrl : pageWsUrl;
    return {
      init: {
        cache: 'no-store',
        credentials: 'same-origin'
      },
      fetch,
      Headers,
      Request,
      WebSocket: WEBSOCKET,
      token: coreutils_1.PageConfig.getToken(),
      appUrl: coreutils_1.PageConfig.getOption('appUrl'),
      appendToken: typeof window === 'undefined' || typeof process !== 'undefined' && ((_a = process === null || process === void 0 ? void 0 : process.env) === null || _a === void 0 ? void 0 : _a.JEST_WORKER_ID) !== undefined || coreutils_1.URLExt.getHostName(pageBaseUrl) !== coreutils_1.URLExt.getHostName(wsUrl),
      ...options,
      baseUrl,
      wsUrl
    };
  }
  Private.makeSettings = makeSettings;
  /**
   * Handle a request.
   *
   * @param url - The url for the request.
   *
   * @param init - The overrides for the request init.
   *
   * @param settings - The settings object for the request.
   *
   * #### Notes
   * The `url` must start with `settings.baseUrl`.  The `init` settings
   * take precedence over `settings.init`.
   */
  function handleRequest(url, init, settings) {
    var _a;
    // Handle notebook server requests.
    if (url.indexOf(settings.baseUrl) !== 0) {
      throw new Error('Can only be used for notebook server requests');
    }
    // Use explicit cache buster when `no-store` is set since
    // not all browsers use it properly.
    const cache = (_a = init.cache) !== null && _a !== void 0 ? _a : settings.init.cache;
    if (cache === 'no-store') {
      // https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/Using_XMLHttpRequest#Bypassing_the_cache
      url += (/\?/.test(url) ? '&' : '?') + new Date().getTime();
    }
    const request = new settings.Request(url, {
      ...settings.init,
      ...init
    });
    // Handle authentication. Authentication can be overdetermined by
    // settings token and XSRF token.
    let authenticated = false;
    if (settings.token) {
      authenticated = true;
      request.headers.append('Authorization', `token ${settings.token}`);
    }
    if (typeof document !== 'undefined' && (document === null || document === void 0 ? void 0 : document.cookie)) {
      const xsrfToken = getCookie('_xsrf');
      if (xsrfToken !== undefined) {
        authenticated = true;
        request.headers.append('X-XSRFToken', xsrfToken);
      }
    }
    // Set the content type if there is no given data and we are
    // using an authenticated connection.
    if (!request.headers.has('Content-Type') && authenticated) {
      request.headers.set('Content-Type', 'application/json');
    }
    // Use `call` to avoid a `TypeError` in the browser.
    return settings.fetch.call(null, request).catch(e => {
      // Convert the TypeError into a more specific error.
      throw new ServerConnection.NetworkError(e);
    });
    // TODO: *this* is probably where we need a system-wide connectionFailure
    // signal we can hook into.
  }

  Private.handleRequest = handleRequest;
  /**
   * Get a cookie from the document.
   */
  function getCookie(name) {
    // From http://www.tornadoweb.org/en/stable/guide/security.html
    const matches = document.cookie.match('\\b' + name + '=([^;]*)\\b');
    return matches === null || matches === void 0 ? void 0 : matches[1];
  }
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/session/default.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/session/default.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SessionConnection = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "./node_modules/@jupyterlab/services/lib/index.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/session/restapi.js");
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
/**
 * Session object for accessing the session REST api. The session
 * should be used to start kernels and then shut them down -- for
 * all other kernel operations, the kernel object should be used.
 */
class SessionConnection {
  /**
   * Construct a new session.
   */
  constructor(options) {
    var _a, _b, _c, _d;
    this._id = '';
    this._path = '';
    this._name = '';
    this._type = '';
    this._kernel = null;
    this._isDisposed = false;
    this._disposed = new signaling_1.Signal(this);
    this._kernelChanged = new signaling_1.Signal(this);
    this._statusChanged = new signaling_1.Signal(this);
    this._connectionStatusChanged = new signaling_1.Signal(this);
    this._pendingInput = new signaling_1.Signal(this);
    this._iopubMessage = new signaling_1.Signal(this);
    this._unhandledMessage = new signaling_1.Signal(this);
    this._anyMessage = new signaling_1.Signal(this);
    this._propertyChanged = new signaling_1.Signal(this);
    this._id = options.model.id;
    this._name = options.model.name;
    this._path = options.model.path;
    this._type = options.model.type;
    this._username = (_a = options.username) !== null && _a !== void 0 ? _a : '';
    this._clientId = (_b = options.clientId) !== null && _b !== void 0 ? _b : coreutils_1.UUID.uuid4();
    this._connectToKernel = options.connectToKernel;
    this._kernelConnectionOptions = (_c = options.kernelConnectionOptions) !== null && _c !== void 0 ? _c : {};
    this.serverSettings = (_d = options.serverSettings) !== null && _d !== void 0 ? _d : __1.ServerConnection.makeSettings();
    this.setupKernel(options.model.kernel);
  }
  /**
   * A signal emitted when the session is disposed.
   */
  get disposed() {
    return this._disposed;
  }
  /**
   * A signal emitted when the kernel changes.
   */
  get kernelChanged() {
    return this._kernelChanged;
  }
  /**
   * A signal proxied from the connection about the kernel status.
   */
  get statusChanged() {
    return this._statusChanged;
  }
  /**
   * A signal proxied from the kernel about the connection status.
   */
  get connectionStatusChanged() {
    return this._connectionStatusChanged;
  }
  /**
   * A signal proxied from the kernel pending input.
   */
  get pendingInput() {
    return this._pendingInput;
  }
  /**
   * A signal proxied from the kernel about iopub kernel messages.
   */
  get iopubMessage() {
    return this._iopubMessage;
  }
  /**
   * A signal proxied from the kernel for an unhandled kernel message.
   */
  get unhandledMessage() {
    return this._unhandledMessage;
  }
  /**
   * A signal proxied from the kernel emitted for any kernel message.
   *
   * #### Notes
   * The behavior is undefined if the message is modified during message
   * handling. As such, it should be treated as read-only.
   */
  get anyMessage() {
    return this._anyMessage;
  }
  /**
   * A signal emitted when a session property changes.
   */
  get propertyChanged() {
    return this._propertyChanged;
  }
  /**
   * Get the session id.
   */
  get id() {
    return this._id;
  }
  /**
   * Get the session kernel connection object.
   *
   * #### Notes
   * This is a read-only property, and can be altered by [changeKernel].
   */
  get kernel() {
    return this._kernel;
  }
  /**
   * Get the session path.
   */
  get path() {
    return this._path;
  }
  /**
   * Get the session type.
   */
  get type() {
    return this._type;
  }
  /**
   * Get the session name.
   */
  get name() {
    return this._name;
  }
  /**
   * Get the model associated with the session.
   */
  get model() {
    return {
      id: this.id,
      kernel: this.kernel && {
        id: this.kernel.id,
        name: this.kernel.name
      },
      path: this._path,
      type: this._type,
      name: this._name
    };
  }
  /**
   * Test whether the session has been disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Update the session based on a session model from the server.
   *
   * #### Notes
   * This only updates this session connection instance. Use `setPath`,
   * `setName`, `setType`, and `changeKernel` to change the session values on
   * the server.
   */
  update(model) {
    const oldModel = this.model;
    this._path = model.path;
    this._name = model.name;
    this._type = model.type;
    if (this._kernel === null && model.kernel !== null || this._kernel !== null && model.kernel === null || this._kernel !== null && model.kernel !== null && this._kernel.id !== model.kernel.id) {
      if (this._kernel !== null) {
        this._kernel.dispose();
      }
      const oldValue = this._kernel || null;
      this.setupKernel(model.kernel);
      const newValue = this._kernel || null;
      this._kernelChanged.emit({
        name: 'kernel',
        oldValue,
        newValue
      });
    }
    this._handleModelChange(oldModel);
  }
  /**
   * Dispose of the resources held by the session.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._isDisposed = true;
    this._disposed.emit();
    if (this._kernel) {
      this._kernel.dispose();
      const oldValue = this._kernel;
      this._kernel = null;
      const newValue = this._kernel;
      this._kernelChanged.emit({
        name: 'kernel',
        oldValue,
        newValue
      });
    }
    signaling_1.Signal.clearData(this);
  }
  /**
   * Change the session path.
   *
   * @param path - The new session path.
   *
   * @returns A promise that resolves when the session has renamed.
   *
   * #### Notes
   * This uses the Jupyter REST API, and the response is validated.
   * The promise is fulfilled on a valid response and rejected otherwise.
   */
  async setPath(path) {
    if (this.isDisposed) {
      throw new Error('Session is disposed');
    }
    await this._patch({
      path
    });
  }
  /**
   * Change the session name.
   */
  async setName(name) {
    if (this.isDisposed) {
      throw new Error('Session is disposed');
    }
    await this._patch({
      name
    });
  }
  /**
   * Change the session type.
   */
  async setType(type) {
    if (this.isDisposed) {
      throw new Error('Session is disposed');
    }
    await this._patch({
      type
    });
  }
  /**
   * Change the kernel.
   *
   * @param options - The name or id of the new kernel.
   *
   * #### Notes
   * This shuts down the existing kernel and creates a new kernel,
   * keeping the existing session ID and session path.
   */
  async changeKernel(options) {
    if (this.isDisposed) {
      throw new Error('Session is disposed');
    }
    await this._patch({
      kernel: options
    });
    return this.kernel;
  }
  /**
   * Kill the kernel and shutdown the session.
   *
   * @returns - The promise fulfilled on a valid response from the server.
   *
   * #### Notes
   * Uses the [Jupyter Notebook API](https://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter-server/jupyter_server/main/jupyter_server/services/api/api.yaml#!/sessions), and validates the response.
   * Disposes of the session and emits a [sessionDied] signal on success.
   */
  async shutdown() {
    if (this.isDisposed) {
      throw new Error('Session is disposed');
    }
    await (0, restapi_1.shutdownSession)(this.id, this.serverSettings);
    this.dispose();
  }
  /**
   * Create a new kernel connection and connect to its signals.
   *
   * #### Notes
   * This method is not meant to be subclassed.
   */
  setupKernel(model) {
    if (model === null) {
      this._kernel = null;
      return;
    }
    const kc = this._connectToKernel({
      ...this._kernelConnectionOptions,
      model,
      username: this._username,
      clientId: this._clientId,
      serverSettings: this.serverSettings
    });
    this._kernel = kc;
    kc.statusChanged.connect(this.onKernelStatus, this);
    kc.connectionStatusChanged.connect(this.onKernelConnectionStatus, this);
    kc.pendingInput.connect(this.onPendingInput, this);
    kc.unhandledMessage.connect(this.onUnhandledMessage, this);
    kc.iopubMessage.connect(this.onIOPubMessage, this);
    kc.anyMessage.connect(this.onAnyMessage, this);
  }
  /**
   * Handle to changes in the Kernel status.
   */
  onKernelStatus(sender, state) {
    this._statusChanged.emit(state);
  }
  /**
   * Handle to changes in the Kernel status.
   */
  onKernelConnectionStatus(sender, state) {
    this._connectionStatusChanged.emit(state);
  }
  /**
   * Handle a change in the pendingInput.
   */
  onPendingInput(sender, state) {
    this._pendingInput.emit(state);
  }
  /**
   * Handle iopub kernel messages.
   */
  onIOPubMessage(sender, msg) {
    this._iopubMessage.emit(msg);
  }
  /**
   * Handle unhandled kernel messages.
   */
  onUnhandledMessage(sender, msg) {
    this._unhandledMessage.emit(msg);
  }
  /**
   * Handle any kernel messages.
   */
  onAnyMessage(sender, args) {
    this._anyMessage.emit(args);
  }
  /**
   * Send a PATCH to the server, updating the session path or the kernel.
   */
  async _patch(body) {
    const model = await (0, restapi_1.updateSession)({
      ...body,
      id: this._id
    }, this.serverSettings);
    this.update(model);
    return model;
  }
  /**
   * Handle a change to the model.
   */
  _handleModelChange(oldModel) {
    if (oldModel.name !== this._name) {
      this._propertyChanged.emit('name');
    }
    if (oldModel.type !== this._type) {
      this._propertyChanged.emit('type');
    }
    if (oldModel.path !== this._path) {
      this._propertyChanged.emit('path');
    }
  }
}
exports.SessionConnection = SessionConnection;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/session/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/session/index.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __exportStar = this && this.__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SessionAPI = exports.Session = void 0;
const Session = __importStar(__webpack_require__(/*! ./session */ "./node_modules/@jupyterlab/services/lib/session/session.js"));
exports.Session = Session;
const SessionAPI = __importStar(__webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/session/restapi.js"));
exports.SessionAPI = SessionAPI;
__exportStar(__webpack_require__(/*! ./manager */ "./node_modules/@jupyterlab/services/lib/session/manager.js"), exports);

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/session/manager.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/session/manager.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SessionManager = void 0;
const polling_1 = __webpack_require__(/*! @lumino/polling */ "./node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "./node_modules/@jupyterlab/services/lib/basemanager.js");
const default_1 = __webpack_require__(/*! ./default */ "./node_modules/@jupyterlab/services/lib/session/default.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/session/restapi.js");
/**
 * An implementation of a session manager.
 */
class SessionManager extends basemanager_1.BaseManager {
  /**
   * Construct a new session manager.
   *
   * @param options - The default options for each session.
   */
  constructor(options) {
    var _a;
    super(options);
    this._isReady = false;
    this._sessionConnections = new Set();
    this._models = new Map();
    this._runningChanged = new signaling_1.Signal(this);
    this._connectionFailure = new signaling_1.Signal(this);
    // We define these here so they bind `this` correctly
    this._connectToKernel = options => {
      return this._kernelManager.connectTo(options);
    };
    this._kernelManager = options.kernelManager;
    // Start model polling with exponential backoff.
    this._pollModels = new polling_1.Poll({
      auto: false,
      factory: () => this.requestRunning(),
      frequency: {
        interval: 10 * 1000,
        backoff: true,
        max: 300 * 1000
      },
      name: `@jupyterlab/services:SessionManager#models`,
      standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
    });
    // Initialize internal data.
    this._ready = (async () => {
      await this._pollModels.start();
      await this._pollModels.tick;
      if (this._kernelManager.isActive) {
        await this._kernelManager.ready;
      }
      this._isReady = true;
    })();
  }
  /**
   * Test whether the manager is ready.
   */
  get isReady() {
    return this._isReady;
  }
  /**
   * A promise that fulfills when the manager is ready.
   */
  get ready() {
    return this._ready;
  }
  /**
   * A signal emitted when the running sessions change.
   */
  get runningChanged() {
    return this._runningChanged;
  }
  /**
   * A signal emitted when there is a connection failure.
   */
  get connectionFailure() {
    return this._connectionFailure;
  }
  /**
   * Dispose of the resources used by the manager.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._models.clear();
    this._sessionConnections.forEach(x => x.dispose());
    this._pollModels.dispose();
    super.dispose();
  }
  /*
   * Connect to a running session.  See also [[connectToSession]].
   */
  connectTo(options) {
    const sessionConnection = new default_1.SessionConnection({
      ...options,
      connectToKernel: this._connectToKernel,
      serverSettings: this.serverSettings
    });
    this._onStarted(sessionConnection);
    if (!this._models.has(options.model.id)) {
      // We trust the user to connect to an existing session, but we verify
      // asynchronously.
      void this.refreshRunning().catch(() => {
        /* no-op */
      });
    }
    return sessionConnection;
  }
  /**
   * Create an iterator over the most recent running sessions.
   *
   * @returns A new iterator over the running sessions.
   */
  running() {
    return this._models.values();
  }
  /**
   * Force a refresh of the running sessions.
   *
   * @returns A promise that with the list of running sessions.
   *
   * #### Notes
   * This is not typically meant to be called by the user, since the
   * manager maintains its own internal state.
   */
  async refreshRunning() {
    await this._pollModels.refresh();
    await this._pollModels.tick;
  }
  /**
   * Start a new session.  See also [[startNewSession]].
   *
   * @param createOptions - Options for creating the session
   *
   * @param connectOptions - Options for connecting to the session
   */
  async startNew(createOptions, connectOptions = {}) {
    const model = await (0, restapi_1.startSession)(createOptions, this.serverSettings);
    await this.refreshRunning();
    return this.connectTo({
      ...connectOptions,
      model
    });
  }
  /**
   * Shut down a session by id.
   */
  async shutdown(id) {
    await (0, restapi_1.shutdownSession)(id, this.serverSettings);
    await this.refreshRunning();
  }
  /**
   * Shut down all sessions.
   *
   * @returns A promise that resolves when all of the kernels are shut down.
   */
  async shutdownAll() {
    // Update the list of models to make sure our list is current.
    await this.refreshRunning();
    // Shut down all models.
    await Promise.all([...this._models.keys()].map(id => (0, restapi_1.shutdownSession)(id, this.serverSettings)));
    // Update the list of models to clear out our state.
    await this.refreshRunning();
  }
  /**
   * Find a session associated with a path and stop it if it is the only session
   * using that kernel.
   *
   * @param path - The path in question.
   *
   * @returns A promise that resolves when the relevant sessions are stopped.
   */
  async stopIfNeeded(path) {
    try {
      const sessions = await (0, restapi_1.listRunning)(this.serverSettings);
      const matches = sessions.filter(value => value.path === path);
      if (matches.length === 1) {
        const id = matches[0].id;
        await this.shutdown(id);
      }
    } catch (error) {
      /* Always succeed. */
    }
  }
  /**
   * Find a session by id.
   */
  async findById(id) {
    if (this._models.has(id)) {
      return this._models.get(id);
    }
    await this.refreshRunning();
    return this._models.get(id);
  }
  /**
   * Find a session by path.
   */
  async findByPath(path) {
    for (const m of this._models.values()) {
      if (m.path === path) {
        return m;
      }
    }
    await this.refreshRunning();
    for (const m of this._models.values()) {
      if (m.path === path) {
        return m;
      }
    }
    return undefined;
  }
  /**
   * Execute a request to the server to poll running kernels and update state.
   */
  async requestRunning() {
    var _a, _b;
    let models;
    try {
      models = await (0, restapi_1.listRunning)(this.serverSettings);
    } catch (err) {
      // Handle network errors, as well as cases where we are on a
      // JupyterHub and the server is not running. JupyterHub returns a
      // 503 (<2.0) or 424 (>2.0) in that case.
      if (err instanceof serverconnection_1.ServerConnection.NetworkError || ((_a = err.response) === null || _a === void 0 ? void 0 : _a.status) === 503 || ((_b = err.response) === null || _b === void 0 ? void 0 : _b.status) === 424) {
        this._connectionFailure.emit(err);
      }
      throw err;
    }
    if (this.isDisposed) {
      return;
    }
    if (this._models.size === models.length && models.every(model => {
      var _a, _b, _c, _d;
      const existing = this._models.get(model.id);
      if (!existing) {
        return false;
      }
      return ((_a = existing.kernel) === null || _a === void 0 ? void 0 : _a.id) === ((_b = model.kernel) === null || _b === void 0 ? void 0 : _b.id) && ((_c = existing.kernel) === null || _c === void 0 ? void 0 : _c.name) === ((_d = model.kernel) === null || _d === void 0 ? void 0 : _d.name) && existing.name === model.name && existing.path === model.path && existing.type === model.type;
    })) {
      // Identical models list (presuming models does not contain duplicate
      // ids), so just return
      return;
    }
    this._models = new Map(models.map(x => [x.id, x]));
    this._sessionConnections.forEach(sc => {
      if (this._models.has(sc.id)) {
        sc.update(this._models.get(sc.id));
      } else {
        sc.dispose();
      }
    });
    this._runningChanged.emit(models);
  }
  /**
   * Handle a session starting.
   */
  _onStarted(sessionConnection) {
    this._sessionConnections.add(sessionConnection);
    sessionConnection.disposed.connect(this._onDisposed, this);
    sessionConnection.propertyChanged.connect(this._onChanged, this);
    sessionConnection.kernelChanged.connect(this._onChanged, this);
  }
  _onDisposed(sessionConnection) {
    this._sessionConnections.delete(sessionConnection);
    // A session termination emission could mean the server session is deleted,
    // or that the session JS object is disposed and the session still exists on
    // the server, so we refresh from the server to make sure we reflect the
    // server state.
    void this.refreshRunning().catch(() => {
      /* no-op */
    });
  }
  _onChanged() {
    void this.refreshRunning().catch(() => {
      /* no-op */
    });
  }
}
exports.SessionManager = SessionManager;
/**
 * The namespace for `SessionManager` class statics.
 */
(function (SessionManager) {
  /**
   * A no-op session manager to be used when starting sessions is not supported.
   */
  class NoopManager extends SessionManager {
    constructor() {
      super(...arguments);
      this._readyPromise = new Promise(() => {
        /* no-op */
      });
    }
    /**
     * Whether the manager is active.
     */
    get isActive() {
      return false;
    }
    /**
     * Used for testing.
     */
    get parentReady() {
      return super.ready;
    }
    /**
     * Start a new session - throw an error since it is not supported.
     */
    async startNew(createOptions, connectOptions = {}) {
      return Promise.reject(new Error('Not implemented in no-op Session Manager'));
    }
    /*
     * Connect to a running session - throw an error since it is not supported.
     */
    connectTo(options) {
      throw Error('Not implemented in no-op Session Manager');
    }
    /**
     * A promise that fulfills when the manager is ready (never).
     */
    get ready() {
      return this.parentReady.then(() => this._readyPromise);
    }
    /**
     * Shut down a session by id - throw an error since it is not supported.
     */
    async shutdown(id) {
      return Promise.reject(new Error('Not implemented in no-op Session Manager'));
    }
    /**
     * Execute a request to the server to poll running sessions and update state.
     */
    async requestRunning() {
      return Promise.resolve();
    }
  }
  SessionManager.NoopManager = NoopManager;
})(SessionManager = exports.SessionManager || (exports.SessionManager = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/session/restapi.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/session/restapi.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.updateSession = exports.startSession = exports.getSessionModel = exports.shutdownSession = exports.getSessionUrl = exports.listRunning = exports.SESSION_SERVICE_URL = void 0;
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const validate_1 = __webpack_require__(/*! ./validate */ "./node_modules/@jupyterlab/services/lib/session/validate.js");
/**
 * The url for the session service.
 */
exports.SESSION_SERVICE_URL = 'api/sessions';
/**
 * List the running sessions.
 */
async function listRunning(settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.SESSION_SERVICE_URL);
  const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
  if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  if (!Array.isArray(data)) {
    throw new Error('Invalid Session list');
  }
  data.forEach(m => {
    (0, validate_1.updateLegacySessionModel)(m);
    (0, validate_1.validateModel)(m);
  });
  return data;
}
exports.listRunning = listRunning;
/**
 * Get a session url.
 */
function getSessionUrl(baseUrl, id) {
  return coreutils_1.URLExt.join(baseUrl, exports.SESSION_SERVICE_URL, id);
}
exports.getSessionUrl = getSessionUrl;
/**
 * Shut down a session by id.
 */
async function shutdownSession(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
  var _a;
  const url = getSessionUrl(settings.baseUrl, id);
  const init = {
    method: 'DELETE'
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status === 404) {
    const data = await response.json();
    const msg = (_a = data.message) !== null && _a !== void 0 ? _a : `The session "${id}"" does not exist on the server`;
    console.warn(msg);
  } else if (response.status === 410) {
    throw new serverconnection_1.ServerConnection.ResponseError(response, 'The kernel was deleted but the session was not');
  } else if (response.status !== 204) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
}
exports.shutdownSession = shutdownSession;
/**
 * Get a full session model from the server by session id string.
 */
async function getSessionModel(id, settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = getSessionUrl(settings.baseUrl, id);
  const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
  if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  (0, validate_1.updateLegacySessionModel)(data);
  (0, validate_1.validateModel)(data);
  return data;
}
exports.getSessionModel = getSessionModel;
/**
 * Create a new session, or return an existing session if the session path
 * already exists.
 */
async function startSession(options, settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.SESSION_SERVICE_URL);
  const init = {
    method: 'POST',
    body: JSON.stringify(options)
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status !== 201) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  (0, validate_1.updateLegacySessionModel)(data);
  (0, validate_1.validateModel)(data);
  return data;
}
exports.startSession = startSession;
/**
 * Send a PATCH to the server, updating the session path or the kernel.
 */
async function updateSession(model, settings = serverconnection_1.ServerConnection.makeSettings()) {
  const url = getSessionUrl(settings.baseUrl, model.id);
  const init = {
    method: 'PATCH',
    body: JSON.stringify(model)
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  (0, validate_1.updateLegacySessionModel)(data);
  (0, validate_1.validateModel)(data);
  return data;
}
exports.updateSession = updateSession;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/session/session.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/session/session.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/session/validate.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/session/validate.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.validateModels = exports.updateLegacySessionModel = exports.validateModel = void 0;
const validate_1 = __webpack_require__(/*! ../kernel/validate */ "./node_modules/@jupyterlab/services/lib/kernel/validate.js");
const validate_2 = __webpack_require__(/*! ../validate */ "./node_modules/@jupyterlab/services/lib/validate.js");
/**
 * Validate an `Session.IModel` object.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function validateModel(data) {
  (0, validate_2.validateProperty)(data, 'id', 'string');
  (0, validate_2.validateProperty)(data, 'type', 'string');
  (0, validate_2.validateProperty)(data, 'name', 'string');
  (0, validate_2.validateProperty)(data, 'path', 'string');
  (0, validate_2.validateProperty)(data, 'kernel', 'object');
  (0, validate_1.validateModel)(data.kernel);
}
exports.validateModel = validateModel;
/**
 * Update model from legacy session data.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function updateLegacySessionModel(data) {
  if (data.path === undefined && data.notebook !== undefined) {
    data.path = data.notebook.path;
    data.type = 'notebook';
    data.name = '';
  }
}
exports.updateLegacySessionModel = updateLegacySessionModel;
/**
 * Validate an array of `Session.IModel` objects.
 */
function validateModels(models) {
  if (!Array.isArray(models)) {
    throw new Error('Invalid session list');
  }
  models.forEach(d => validateModel(d));
}
exports.validateModels = validateModels;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/setting/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/setting/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SettingManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const statedb_1 = __webpack_require__(/*! @jupyterlab/statedb */ "./node_modules/@jupyterlab/statedb/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the lab settings service.
 */
const SERVICE_SETTINGS_URL = 'api/settings';
/**
 * The settings API service manager.
 */
class SettingManager extends statedb_1.DataConnector {
  /**
   * Create a new setting manager.
   */
  constructor(options = {}) {
    var _a;
    super();
    this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
  }
  /**
   * Fetch a plugin's settings.
   *
   * @param id - The plugin's ID.
   *
   * @returns A promise that resolves if successful.
   */
  async fetch(id) {
    if (!id) {
      throw new Error('Plugin `id` parameter is required for settings fetch.');
    }
    const {
      serverSettings
    } = this;
    const {
      baseUrl,
      appUrl
    } = serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const base = baseUrl + appUrl;
    const url = Private.url(base, id);
    const response = await makeRequest(url, {}, serverSettings);
    if (response.status !== 200) {
      const err = await ResponseError.create(response);
      throw err;
    }
    // Assert what type the server response is returning.
    return response.json();
  }
  /**
   * Fetch the list of all plugin setting bundles.
   *
   * @returns A promise that resolves if successful.
   */
  async list(query) {
    var _a, _b, _c, _d;
    const {
      serverSettings
    } = this;
    const {
      baseUrl,
      appUrl
    } = serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const base = baseUrl + appUrl;
    const url = Private.url(base, '', query === 'ids');
    const response = await makeRequest(url, {}, serverSettings);
    if (response.status !== 200) {
      throw new ResponseError(response);
    }
    const json = await response.json();
    const ids = (_b = (_a = json === null || json === void 0 ? void 0 : json['settings']) === null || _a === void 0 ? void 0 : _a.map(plugin => plugin.id)) !== null && _b !== void 0 ? _b : [];
    let values = [];
    if (!query) {
      values = (_d = (_c = json === null || json === void 0 ? void 0 : json['settings']) === null || _c === void 0 ? void 0 : _c.map(plugin => {
        plugin.data = {
          composite: {},
          user: {}
        };
        return plugin;
      })) !== null && _d !== void 0 ? _d : [];
    }
    return {
      ids,
      values
    };
  }
  /**
   * Save a plugin's settings.
   *
   * @param id - The plugin's ID.
   *
   * @param raw - The user setting values as a raw string of JSON with comments.
   *
   * @returns A promise that resolves if successful.
   */
  async save(id, raw) {
    const {
      serverSettings
    } = this;
    const {
      baseUrl,
      appUrl
    } = serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const base = baseUrl + appUrl;
    const url = Private.url(base, id);
    // NOTE: 'raw' is JSON5 (not valid JSON), so we encode it as a string in a valid JSON body
    const init = {
      body: JSON.stringify({
        raw
      }),
      method: 'PUT'
    };
    const response = await makeRequest(url, init, serverSettings);
    if (response.status !== 204) {
      throw new ResponseError(response);
    }
  }
}
exports.SettingManager = SettingManager;
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
  /**
   * Get the url for a plugin's settings.
   */
  function url(base, id, idsOnly) {
    const idsOnlyParam = idsOnly ? coreutils_1.URLExt.objectToQueryString({
      ids_only: true
    }) : '';
    return `${coreutils_1.URLExt.join(base, SERVICE_SETTINGS_URL, id)}${idsOnlyParam}`;
  }
  Private.url = url;
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/shim/ws.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/shim/ws.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = WebSocket;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/terminal/default.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/terminal/default.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.TerminalConnection = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const coreutils_2 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "./node_modules/@jupyterlab/services/lib/index.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/terminal/restapi.js");
/**
 * An implementation of a terminal interface.
 */
class TerminalConnection {
  /**
   * Construct a new terminal session.
   */
  constructor(options) {
    var _a;
    /**
     * Create the terminal websocket connection and add socket status handlers.
     *
     * #### Notes
     * You are responsible for updating the connection status as appropriate.
     */
    this._createSocket = () => {
      this._errorIfDisposed();
      // Make sure the socket is clear
      this._clearSocket();
      // Update the connection status to reflect opening a new connection.
      this._updateConnectionStatus('connecting');
      const name = this._name;
      const settings = this.serverSettings;
      let url = coreutils_1.URLExt.join(settings.wsUrl, 'terminals', 'websocket', encodeURIComponent(name));
      // If token authentication is in use.
      const token = settings.token;
      if (settings.appendToken && token !== '') {
        url = url + `?token=${encodeURIComponent(token)}`;
      }
      this._ws = new settings.WebSocket(url);
      this._ws.onmessage = this._onWSMessage;
      this._ws.onclose = this._onWSClose;
      this._ws.onerror = this._onWSClose;
    };
    // Websocket messages events are defined as variables to bind `this`
    this._onWSMessage = event => {
      if (this._isDisposed) {
        return;
      }
      const data = JSON.parse(event.data);
      // Handle a disconnect message.
      if (data[0] === 'disconnect') {
        this.dispose();
      }
      if (this._connectionStatus === 'connecting') {
        // After reconnection, ignore all messages until a 'setup' message
        // before we are truly connected. Setting the connection status to
        // connected only then means that if we do not get a setup message
        // before our retry timeout, we will delete the websocket and try again.
        if (data[0] === 'setup') {
          this._updateConnectionStatus('connected');
        }
        return;
      }
      this._messageReceived.emit({
        type: data[0],
        content: data.slice(1)
      });
    };
    this._onWSClose = event => {
      console.warn(`Terminal websocket closed: ${event.code}`);
      if (!this.isDisposed) {
        this._reconnect();
      }
    };
    this._connectionStatus = 'connecting';
    this._connectionStatusChanged = new signaling_1.Signal(this);
    this._isDisposed = false;
    this._disposed = new signaling_1.Signal(this);
    this._messageReceived = new signaling_1.Signal(this);
    this._reconnectTimeout = null;
    this._ws = null;
    this._noOp = () => {
      /* no-op */
    };
    this._reconnectLimit = 7;
    this._reconnectAttempt = 0;
    this._pendingMessages = [];
    this._name = options.model.name;
    this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : __1.ServerConnection.makeSettings();
    this._createSocket();
  }
  /**
   * A signal emitted when the session is disposed.
   */
  get disposed() {
    return this._disposed;
  }
  /**
   * A signal emitted when a message is received from the server.
   */
  get messageReceived() {
    return this._messageReceived;
  }
  /**
   * Get the name of the terminal session.
   */
  get name() {
    return this._name;
  }
  /**
   * Get the model for the terminal session.
   */
  get model() {
    return {
      name: this._name
    };
  }
  /**
   * Test whether the session is disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Dispose of the resources held by the session.
   */
  dispose() {
    if (this._isDisposed) {
      return;
    }
    this._isDisposed = true;
    this._disposed.emit();
    this._updateConnectionStatus('disconnected');
    this._clearSocket();
    signaling_1.Signal.clearData(this);
  }
  /**
   * Send a message to the terminal session.
   *
   * #### Notes
   * If the connection is down, the message will be queued for sending when
   * the connection comes back up.
   */
  send(message) {
    this._sendMessage(message);
  }
  /**
   * Send a message on the websocket, or possibly queue for later sending.
   *
   * @param queue - whether to queue the message if it cannot be sent
   */
  _sendMessage(message, queue = true) {
    if (this._isDisposed || !message.content) {
      return;
    }
    if (this.connectionStatus === 'connected' && this._ws) {
      const msg = [message.type, ...message.content];
      this._ws.send(JSON.stringify(msg));
    } else if (queue) {
      this._pendingMessages.push(message);
    } else {
      throw new Error(`Could not send message: ${JSON.stringify(message)}`);
    }
  }
  /**
   * Send pending messages to the kernel.
   */
  _sendPending() {
    // We check to make sure we are still connected each time. For
    // example, if a websocket buffer overflows, it may close, so we should
    // stop sending messages.
    while (this.connectionStatus === 'connected' && this._pendingMessages.length > 0) {
      this._sendMessage(this._pendingMessages[0], false);
      // We shift the message off the queue after the message is sent so that
      // if there is an exception, the message is still pending.
      this._pendingMessages.shift();
    }
  }
  /**
   * Reconnect to a terminal.
   *
   * #### Notes
   * This may try multiple times to reconnect to a terminal, and will sever
   * any existing connection.
   */
  reconnect() {
    this._errorIfDisposed();
    const result = new coreutils_2.PromiseDelegate();
    // Set up a listener for the connection status changing, which accepts or
    // rejects after the retries are done.
    const fulfill = (sender, status) => {
      if (status === 'connected') {
        result.resolve();
        this.connectionStatusChanged.disconnect(fulfill, this);
      } else if (status === 'disconnected') {
        result.reject(new Error('Terminal connection disconnected'));
        this.connectionStatusChanged.disconnect(fulfill, this);
      }
    };
    this.connectionStatusChanged.connect(fulfill, this);
    // Reset the reconnect limit so we start the connection attempts fresh
    this._reconnectAttempt = 0;
    // Start the reconnection process, which will also clear any existing
    // connection.
    this._reconnect();
    // Return the promise that should resolve on connection or reject if the
    // retries don't work.
    return result.promise;
  }
  /**
   * Attempt a connection if we have not exhausted connection attempts.
   */
  _reconnect() {
    this._errorIfDisposed();
    // Clear any existing reconnection attempt
    clearTimeout(this._reconnectTimeout);
    // Update the connection status and schedule a possible reconnection.
    if (this._reconnectAttempt < this._reconnectLimit) {
      this._updateConnectionStatus('connecting');
      // The first reconnect attempt should happen immediately, and subsequent
      // attempts should pick a random number in a growing range so that we
      // don't overload the server with synchronized reconnection attempts
      // across multiple kernels.
      const timeout = Private.getRandomIntInclusive(0, 1e3 * (Math.pow(2, this._reconnectAttempt) - 1));
      console.error(`Connection lost, reconnecting in ${Math.floor(timeout / 1000)} seconds.`);
      this._reconnectTimeout = setTimeout(this._createSocket, timeout);
      this._reconnectAttempt += 1;
    } else {
      this._updateConnectionStatus('disconnected');
    }
    // Clear the websocket event handlers and the socket itself.
    this._clearSocket();
  }
  /**
   * Forcefully clear the socket state.
   *
   * #### Notes
   * This will clear all socket state without calling any handlers and will
   * not update the connection status. If you call this method, you are
   * responsible for updating the connection status as needed and recreating
   * the socket if you plan to reconnect.
   */
  _clearSocket() {
    if (this._ws !== null) {
      // Clear the websocket event handlers and the socket itself.
      this._ws.onopen = this._noOp;
      this._ws.onclose = this._noOp;
      this._ws.onerror = this._noOp;
      this._ws.onmessage = this._noOp;
      this._ws.close();
      this._ws = null;
    }
  }
  /**
   * Shut down the terminal session.
   */
  async shutdown() {
    await (0, restapi_1.shutdownTerminal)(this.name, this.serverSettings);
    this.dispose();
  }
  /**
   * Clone the current terminal connection.
   */
  clone() {
    return new TerminalConnection(this);
  }
  /**
   * Handle connection status changes.
   */
  _updateConnectionStatus(connectionStatus) {
    if (this._connectionStatus === connectionStatus) {
      return;
    }
    this._connectionStatus = connectionStatus;
    // If we are not 'connecting', stop any reconnection attempts.
    if (connectionStatus !== 'connecting') {
      this._reconnectAttempt = 0;
      clearTimeout(this._reconnectTimeout);
    }
    // Send the pending messages if we just connected.
    if (connectionStatus === 'connected') {
      this._sendPending();
    }
    // Notify others that the connection status changed.
    this._connectionStatusChanged.emit(connectionStatus);
  }
  /**
   * Utility function to throw an error if this instance is disposed.
   */
  _errorIfDisposed() {
    if (this.isDisposed) {
      throw new Error('Terminal connection is disposed');
    }
  }
  /**
   * A signal emitted when the terminal connection status changes.
   */
  get connectionStatusChanged() {
    return this._connectionStatusChanged;
  }
  /**
   * The current connection status of the terminal connection.
   */
  get connectionStatus() {
    return this._connectionStatus;
  }
}
exports.TerminalConnection = TerminalConnection;
var Private;
(function (Private) {
  /**
   * Get the url for a terminal.
   */
  function getTermUrl(baseUrl, name) {
    return coreutils_1.URLExt.join(baseUrl, restapi_1.TERMINAL_SERVICE_URL, encodeURIComponent(name));
  }
  Private.getTermUrl = getTermUrl;
  /**
   * Get a random integer between min and max, inclusive of both.
   *
   * #### Notes
   * From
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random#Getting_a_random_integer_between_two_values_inclusive
   *
   * From the MDN page: It might be tempting to use Math.round() to accomplish
   * that, but doing so would cause your random numbers to follow a non-uniform
   * distribution, which may not be acceptable for your needs.
   */
  function getRandomIntInclusive(min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min + 1)) + min;
  }
  Private.getRandomIntInclusive = getRandomIntInclusive;
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/terminal/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/terminal/index.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = this && this.__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __exportStar = this && this.__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.TerminalAPI = exports.Terminal = void 0;
const Terminal = __importStar(__webpack_require__(/*! ./terminal */ "./node_modules/@jupyterlab/services/lib/terminal/terminal.js"));
exports.Terminal = Terminal;
const TerminalAPI = __importStar(__webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/terminal/restapi.js"));
exports.TerminalAPI = TerminalAPI;
__exportStar(__webpack_require__(/*! ./manager */ "./node_modules/@jupyterlab/services/lib/terminal/manager.js"), exports);

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/terminal/manager.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/terminal/manager.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.TerminalManager = void 0;
const polling_1 = __webpack_require__(/*! @lumino/polling */ "./node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const __1 = __webpack_require__(/*! .. */ "./node_modules/@jupyterlab/services/lib/index.js");
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "./node_modules/@jupyterlab/services/lib/basemanager.js");
const restapi_1 = __webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/terminal/restapi.js");
const default_1 = __webpack_require__(/*! ./default */ "./node_modules/@jupyterlab/services/lib/terminal/default.js");
/**
 * A terminal session manager.
 */
class TerminalManager extends basemanager_1.BaseManager {
  /**
   * Construct a new terminal manager.
   */
  constructor(options = {}) {
    var _a;
    super(options);
    this._isReady = false;
    // As an optimization, we unwrap the models to just store the names.
    this._names = [];
    this._terminalConnections = new Set();
    this._runningChanged = new signaling_1.Signal(this);
    this._connectionFailure = new signaling_1.Signal(this);
    // Check if terminals are available
    if (!this.isAvailable()) {
      this._ready = Promise.reject('Terminals unavailable');
      this._ready.catch(_ => undefined);
      return;
    }
    // Start polling with exponential backoff.
    this._pollModels = new polling_1.Poll({
      auto: false,
      factory: () => this.requestRunning(),
      frequency: {
        interval: 10 * 1000,
        backoff: true,
        max: 300 * 1000
      },
      name: `@jupyterlab/services:TerminalManager#models`,
      standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
    });
    // Initialize internal data.
    this._ready = (async () => {
      await this._pollModels.start();
      await this._pollModels.tick;
      this._isReady = true;
    })();
  }
  /**
   * Test whether the manager is ready.
   */
  get isReady() {
    return this._isReady;
  }
  /**
   * A promise that fulfills when the manager is ready.
   */
  get ready() {
    return this._ready;
  }
  /**
   * A signal emitted when the running terminals change.
   */
  get runningChanged() {
    return this._runningChanged;
  }
  /**
   * A signal emitted when there is a connection failure.
   */
  get connectionFailure() {
    return this._connectionFailure;
  }
  /**
   * Dispose of the resources used by the manager.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._names.length = 0;
    this._terminalConnections.forEach(x => x.dispose());
    this._pollModels.dispose();
    super.dispose();
  }
  /**
   * Whether the terminal service is available.
   */
  isAvailable() {
    return (0, restapi_1.isAvailable)();
  }
  /*
   * Connect to a running terminal.
   *
   * @param options - The options used to connect to the terminal.
   *
   * @returns The new terminal connection instance.
   *
   * #### Notes
   * The manager `serverSettings` will be used.
   */
  connectTo(options) {
    const terminalConnection = new default_1.TerminalConnection({
      ...options,
      serverSettings: this.serverSettings
    });
    this._onStarted(terminalConnection);
    if (!this._names.includes(options.model.name)) {
      // We trust the user to connect to an existing session, but we verify
      // asynchronously.
      void this.refreshRunning().catch(() => {
        /* no-op */
      });
    }
    return terminalConnection;
  }
  /**
   * Create an iterator over the most recent running terminals.
   *
   * @returns A new iterator over the running terminals.
   */
  running() {
    return this._models[Symbol.iterator]();
  }
  /**
   * Force a refresh of the running terminals.
   *
   * @returns A promise that with the list of running terminals.
   *
   * #### Notes
   * This is intended to be called only in response to a user action,
   * since the manager maintains its internal state.
   */
  async refreshRunning() {
    await this._pollModels.refresh();
    await this._pollModels.tick;
  }
  /**
   * Create a new terminal session.
   *
   * @param options - The options used to create the terminal.
   *
   * @returns A promise that resolves with the terminal connection instance.
   *
   * #### Notes
   * The manager `serverSettings` will be used unless overridden in the
   * options.
   */
  async startNew(options) {
    const model = await (0, restapi_1.startNew)(this.serverSettings, options === null || options === void 0 ? void 0 : options.name, options === null || options === void 0 ? void 0 : options.cwd);
    await this.refreshRunning();
    return this.connectTo({
      model
    });
  }
  /**
   * Shut down a terminal session by name.
   */
  async shutdown(name) {
    await (0, restapi_1.shutdownTerminal)(name, this.serverSettings);
    await this.refreshRunning();
  }
  /**
   * Shut down all terminal sessions.
   *
   * @returns A promise that resolves when all of the sessions are shut down.
   */
  async shutdownAll() {
    // Update the list of models to make sure our list is current.
    await this.refreshRunning();
    // Shut down all models.
    await Promise.all(this._names.map(name => (0, restapi_1.shutdownTerminal)(name, this.serverSettings)));
    // Update the list of models to clear out our state.
    await this.refreshRunning();
  }
  /**
   * Execute a request to the server to poll running terminals and update state.
   */
  async requestRunning() {
    var _a, _b;
    let models;
    try {
      models = await (0, restapi_1.listRunning)(this.serverSettings);
    } catch (err) {
      // Handle network errors, as well as cases where we are on a
      // JupyterHub and the server is not running. JupyterHub returns a
      // 503 (<2.0) or 424 (>2.0) in that case.
      if (err instanceof __1.ServerConnection.NetworkError || ((_a = err.response) === null || _a === void 0 ? void 0 : _a.status) === 503 || ((_b = err.response) === null || _b === void 0 ? void 0 : _b.status) === 424) {
        this._connectionFailure.emit(err);
      }
      throw err;
    }
    if (this.isDisposed) {
      return;
    }
    const names = models.map(({
      name
    }) => name).sort();
    if (names === this._names) {
      // Identical models list, so just return
      return;
    }
    this._names = names;
    this._terminalConnections.forEach(tc => {
      if (!names.includes(tc.name)) {
        tc.dispose();
      }
    });
    this._runningChanged.emit(this._models);
  }
  /**
   * Handle a session starting.
   */
  _onStarted(terminalConnection) {
    this._terminalConnections.add(terminalConnection);
    terminalConnection.disposed.connect(this._onDisposed, this);
  }
  /**
   * Handle a session terminating.
   */
  _onDisposed(terminalConnection) {
    this._terminalConnections.delete(terminalConnection);
    // Update the running models to make sure we reflect the server state
    void this.refreshRunning().catch(() => {
      /* no-op */
    });
  }
  get _models() {
    return this._names.map(name => {
      return {
        name
      };
    });
  }
}
exports.TerminalManager = TerminalManager;
/**
 * The namespace for TerminalManager statics.
 */
(function (TerminalManager) {
  /**
   * A no-op terminal manager to be used when starting terminals is not supported.
   */
  class NoopManager extends TerminalManager {
    constructor() {
      super(...arguments);
      this._readyPromise = new Promise(() => {
        /* no-op */
      });
    }
    /**
     * Whether the manager is active.
     */
    get isActive() {
      return false;
    }
    /**
     * Used for testing.
     */
    get parentReady() {
      return super.ready;
    }
    /**
     * A promise that fulfills when the manager is ready (never).
     */
    get ready() {
      return this.parentReady.then(() => this._readyPromise);
    }
    /**
     * Create a new terminal session - throw an error since it is not supported.
     *
     */
    async startNew(options) {
      return Promise.reject(new Error('Not implemented in no-op Terminal Manager'));
    }
    /*
     * Connect to a running terminal - throw an error since it is not supported.
     */
    connectTo(options) {
      throw Error('Not implemented in no-op Terminal Manager');
    }
    /**
     * Shut down a session by id - throw an error since it is not supported.
     */
    async shutdown(id) {
      return Promise.reject(new Error('Not implemented in no-op Terminal Manager'));
    }
    /**
     * Execute a request to the server to poll running sessions and update state.
     */
    async requestRunning() {
      return Promise.resolve();
    }
  }
  TerminalManager.NoopManager = NoopManager;
})(TerminalManager = exports.TerminalManager || (exports.TerminalManager = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/terminal/restapi.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/terminal/restapi.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.shutdownTerminal = exports.listRunning = exports.startNew = exports.isAvailable = exports.TERMINAL_SERVICE_URL = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the terminal service.
 */
exports.TERMINAL_SERVICE_URL = 'api/terminals';
/**
 * Whether the terminal service is available.
 */
function isAvailable() {
  const available = String(coreutils_1.PageConfig.getOption('terminalsAvailable'));
  return available.toLowerCase() === 'true';
}
exports.isAvailable = isAvailable;
/**
 * Start a new terminal session.
 *
 * @param settings - The server settings to use.
 *
 * @param name - The name of the target terminal.
 *
 * @param cwd - The path in which the terminal will start.
 *
 * @returns A promise that resolves with the session model.
 */
async function startNew(settings = serverconnection_1.ServerConnection.makeSettings(), name, cwd) {
  Private.errorIfNotAvailable();
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.TERMINAL_SERVICE_URL);
  const init = {
    method: 'POST',
    body: JSON.stringify({
      name,
      cwd
    })
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  // TODO: Validate model
  return data;
}
exports.startNew = startNew;
/**
 * List the running terminal sessions.
 *
 * @param settings - The server settings to use.
 *
 * @returns A promise that resolves with the list of running session models.
 */
async function listRunning(settings = serverconnection_1.ServerConnection.makeSettings()) {
  Private.errorIfNotAvailable();
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.TERMINAL_SERVICE_URL);
  const response = await serverconnection_1.ServerConnection.makeRequest(url, {}, settings);
  if (response.status !== 200) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
  const data = await response.json();
  if (!Array.isArray(data)) {
    throw new Error('Invalid terminal list');
  }
  // TODO: validate each model
  return data;
}
exports.listRunning = listRunning;
/**
 * Shut down a terminal session by name.
 *
 * @param name - The name of the target session.
 *
 * @param settings - The server settings to use.
 *
 * @returns A promise that resolves when the session is shut down.
 */
async function shutdownTerminal(name, settings = serverconnection_1.ServerConnection.makeSettings()) {
  var _a;
  Private.errorIfNotAvailable();
  const url = coreutils_1.URLExt.join(settings.baseUrl, exports.TERMINAL_SERVICE_URL, name);
  const init = {
    method: 'DELETE'
  };
  const response = await serverconnection_1.ServerConnection.makeRequest(url, init, settings);
  if (response.status === 404) {
    const data = await response.json();
    const msg = (_a = data.message) !== null && _a !== void 0 ? _a : `The terminal session "${name}"" does not exist on the server`;
    console.warn(msg);
  } else if (response.status !== 204) {
    const err = await serverconnection_1.ServerConnection.ResponseError.create(response);
    throw err;
  }
}
exports.shutdownTerminal = shutdownTerminal;
var Private;
(function (Private) {
  /**
   * Throw an error if terminals are not available.
   */
  function errorIfNotAvailable() {
    if (!isAvailable()) {
      throw new Error('Terminals Unavailable');
    }
  }
  Private.errorIfNotAvailable = errorIfNotAvailable;
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/terminal/terminal.js":
/*!********************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/terminal/terminal.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isAvailable = void 0;
const restapi_1 = __webpack_require__(/*! ./restapi */ "./node_modules/@jupyterlab/services/lib/terminal/restapi.js");
Object.defineProperty(exports, "isAvailable", ({
  enumerable: true,
  get: function () {
    return restapi_1.isAvailable;
  }
}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/user/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/user/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.UserManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const coreutils_2 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
const polling_1 = __webpack_require__(/*! @lumino/polling */ "./node_modules/@lumino/polling/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
const basemanager_1 = __webpack_require__(/*! ../basemanager */ "./node_modules/@jupyterlab/services/lib/basemanager.js");
/**
 * The url for the lab workspaces service.
 */
const SERVICE_USER_URL = 'api/me';
/**
 * The service's ID.
 * Used to uniquely identify the poll, and
 * the item in local storage.
 */
const SERVICE_ID = '@jupyterlab/services:UserManager#user';
/**
 * The user API service manager.
 */
class UserManager extends basemanager_1.BaseManager {
  /**
   * Create a new user manager.
   */
  constructor(options = {}) {
    var _a;
    super(options);
    this._isReady = false;
    this._userChanged = new signaling_1.Signal(this);
    this._connectionFailure = new signaling_1.Signal(this);
    // Initialize internal data.
    this._ready = this.requestUser().then(() => {
      if (this.isDisposed) {
        return;
      }
      this._isReady = true;
    }).catch(_ =>
    // Return a promise that will never resolve, so user service is never ready
    // This typically occurs when the backend has no user service
    new Promise(() => {
      // no-op
    }));
    this._pollSpecs = new polling_1.Poll({
      auto: false,
      factory: () => this.requestUser(),
      frequency: {
        interval: 61 * 1000,
        backoff: true,
        max: 300 * 1000
      },
      name: SERVICE_ID,
      standby: (_a = options.standby) !== null && _a !== void 0 ? _a : 'when-hidden'
    });
    void this.ready.then(() => {
      void this._pollSpecs.start();
    });
  }
  /**
   * Test whether the manager is ready.
   */
  get isReady() {
    return this._isReady;
  }
  /**
   * A promise that fulfills when the manager is ready.
   */
  get ready() {
    return this._ready;
  }
  /**
   * Get the most recently fetched identity.
   */
  get identity() {
    return this._identity;
  }
  /**
   * Get the most recently fetched permissions.
   */
  get permissions() {
    return this._permissions;
  }
  /**
   * A signal emitted when the user changes.
   */
  get userChanged() {
    return this._userChanged;
  }
  /**
   * A signal emitted when there is a connection failure.
   */
  get connectionFailure() {
    return this._connectionFailure;
  }
  /**
   * Dispose of the resources used by the manager.
   */
  dispose() {
    this._pollSpecs.dispose();
    super.dispose();
  }
  /**
   * Force a refresh of the specs from the server.
   *
   * @returns A promise that resolves when the specs are fetched.
   *
   * #### Notes
   * This is intended to be called only in response to a user action,
   * since the manager maintains its internal state.
   */
  async refreshUser() {
    await this._pollSpecs.refresh();
    await this._pollSpecs.tick;
  }
  /**
   * Execute a request to the server to poll the user and update state.
   */
  async requestUser() {
    if (this.isDisposed) {
      return;
    }
    const {
      baseUrl
    } = this.serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const url = coreutils_1.URLExt.join(baseUrl, SERVICE_USER_URL);
    const response = await makeRequest(url, {}, this.serverSettings);
    if (response.status !== 200) {
      const err = await ResponseError.create(response);
      throw err;
    }
    const oldUser = {
      identity: this._identity,
      permissions: this._permissions
    };
    const newUser = await response.json();
    const identity = newUser.identity;
    // store the color and initials for the user
    // this info is not provided by the server
    const {
      localStorage
    } = window;
    const data = localStorage.getItem(SERVICE_ID);
    if (data && (!identity.initials || !identity.color)) {
      const localUser = JSON.parse(data);
      identity.initials = identity.initials || localUser.initials || identity.name.substring(0, 1);
      identity.color = identity.color || localUser.color || Private.getRandomColor();
    }
    if (!coreutils_2.JSONExt.deepEqual(newUser, oldUser)) {
      this._identity = identity;
      this._permissions = newUser.permissions;
      localStorage.setItem(SERVICE_ID, JSON.stringify(identity));
      this._userChanged.emit(newUser);
    }
  }
}
exports.UserManager = UserManager;
/**
 * A namespace for module-private functionality.
 *
 * Note: We do not want to export this function
 * to move it to css variables in the Theme.
 */
var Private;
(function (Private) {
  /**
   * Predefined colors for users
   */
  const userColors = ['var(--jp-collaborator-color1)', 'var(--jp-collaborator-color2)', 'var(--jp-collaborator-color3)', 'var(--jp-collaborator-color4)', 'var(--jp-collaborator-color5)', 'var(--jp-collaborator-color6)', 'var(--jp-collaborator-color7)'];
  /**
   * Get a random color from the list of colors.
   */
  Private.getRandomColor = () => userColors[Math.floor(Math.random() * userColors.length)];
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/validate.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/validate.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.validateProperty = void 0;
/**
 * Validate a property as being on an object, and optionally
 * of a given type and among a given set of values.
 */
function validateProperty(
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
object, name, typeName, values = []) {
  if (!object.hasOwnProperty(name)) {
    throw Error(`Missing property '${name}'`);
  }
  const value = object[name];
  if (typeName !== void 0) {
    let valid = true;
    switch (typeName) {
      case 'array':
        valid = Array.isArray(value);
        break;
      case 'object':
        valid = typeof value !== 'undefined';
        break;
      default:
        valid = typeof value === typeName;
    }
    if (!valid) {
      throw new Error(`Property '${name}' is not of type '${typeName}'`);
    }
    if (values.length > 0) {
      let valid = true;
      switch (typeName) {
        case 'string':
        case 'number':
        case 'boolean':
          valid = values.includes(value);
          break;
        default:
          valid = values.findIndex(v => v === value) >= 0;
          break;
      }
      if (!valid) {
        throw new Error(`Property '${name}' is not one of the valid values ${JSON.stringify(values)}`);
      }
    }
  }
}
exports.validateProperty = validateProperty;

/***/ }),

/***/ "./node_modules/@jupyterlab/services/lib/workspace/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/services/lib/workspace/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WorkspaceManager = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
const statedb_1 = __webpack_require__(/*! @jupyterlab/statedb */ "./node_modules/@jupyterlab/statedb/lib/index.js");
const serverconnection_1 = __webpack_require__(/*! ../serverconnection */ "./node_modules/@jupyterlab/services/lib/serverconnection.js");
/**
 * The url for the lab workspaces service.
 */
const SERVICE_WORKSPACES_URL = 'api/workspaces';
/**
 * The workspaces API service manager.
 */
class WorkspaceManager extends statedb_1.DataConnector {
  /**
   * Create a new workspace manager.
   */
  constructor(options = {}) {
    var _a;
    super();
    this.serverSettings = (_a = options.serverSettings) !== null && _a !== void 0 ? _a : serverconnection_1.ServerConnection.makeSettings();
  }
  /**
   * Fetch a workspace.
   *
   * @param id - The workspace's ID.
   *
   * @returns A promise that resolves if successful.
   */
  async fetch(id) {
    const {
      serverSettings
    } = this;
    const {
      baseUrl,
      appUrl
    } = serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const base = baseUrl + appUrl;
    const url = Private.url(base, id);
    const response = await makeRequest(url, {}, serverSettings);
    if (response.status !== 200) {
      const err = await ResponseError.create(response);
      throw err;
    }
    return response.json();
  }
  /**
   * Fetch the list of workspace IDs that exist on the server.
   *
   * @returns A promise that resolves if successful.
   */
  async list() {
    const {
      serverSettings
    } = this;
    const {
      baseUrl,
      appUrl
    } = serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const base = baseUrl + appUrl;
    const url = Private.url(base, '');
    const response = await makeRequest(url, {}, serverSettings);
    if (response.status !== 200) {
      const err = await ResponseError.create(response);
      throw err;
    }
    const result = await response.json();
    return result.workspaces;
  }
  /**
   * Remove a workspace from the server.
   *
   * @param id - The workspaces's ID.
   *
   * @returns A promise that resolves if successful.
   */
  async remove(id) {
    const {
      serverSettings
    } = this;
    const {
      baseUrl,
      appUrl
    } = serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const base = baseUrl + appUrl;
    const url = Private.url(base, id);
    const init = {
      method: 'DELETE'
    };
    const response = await makeRequest(url, init, serverSettings);
    if (response.status !== 204) {
      const err = await ResponseError.create(response);
      throw err;
    }
  }
  /**
   * Save a workspace.
   *
   * @param id - The workspace's ID.
   *
   * @param workspace - The workspace being saved.
   *
   * @returns A promise that resolves if successful.
   */
  async save(id, workspace) {
    const {
      serverSettings
    } = this;
    const {
      baseUrl,
      appUrl
    } = serverSettings;
    const {
      makeRequest,
      ResponseError
    } = serverconnection_1.ServerConnection;
    const base = baseUrl + appUrl;
    const url = Private.url(base, id);
    const init = {
      body: JSON.stringify(workspace),
      method: 'PUT'
    };
    const response = await makeRequest(url, init, serverSettings);
    if (response.status !== 204) {
      const err = await ResponseError.create(response);
      throw err;
    }
  }
}
exports.WorkspaceManager = WorkspaceManager;
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
  /**
   * Get the url for a workspace.
   */
  function url(base, id) {
    return coreutils_1.URLExt.join(base, SERVICE_WORKSPACES_URL, id);
  }
  Private.url = url;
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/statedb/lib/dataconnector.js":
/*!***************************************************************!*\
  !*** ./node_modules/@jupyterlab/statedb/lib/dataconnector.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DataConnector = void 0;
/**
 * An abstract class that adheres to the data connector interface.
 *
 * @typeparam T - The basic entity response type a service's connector.
 *
 * @typeparam U - The basic entity request type, which is conventionally the
 * same as the response type but may be different if a service's implementation
 * requires input data to be different from output responses. Defaults to `T`.
 *
 * @typeparam V - The basic token applied to a request, conventionally a string
 * ID or filter, but may be set to a different type when an implementation
 * requires it. Defaults to `string`.
 *
 * @typeparam W - The type of the optional `query` parameter of the `list`
 * method. Defaults to `string`.
 *
 * #### Notes
 * The only abstract method in this class is the `fetch` method, which must be
 * reimplemented by all subclasses. The `remove` and `save` methods have a
 * default implementation that returns a promise that will always reject. This
 * class is a convenience superclass for connectors that only need to `fetch`.
 */
class DataConnector {
  /**
   * Retrieve the list of items available from the data connector.
   *
   * @param query - The optional query filter to apply to the connector request.
   *
   * @returns A promise that always rejects with an error.
   *
   * #### Notes
   * Subclasses should reimplement if they support a back-end that can list.
   */
  async list(query) {
    throw new Error('DataConnector#list method has not been implemented.');
  }
  /**
   * Remove a value using the data connector.
   *
   * @param id - The identifier for the data being removed.
   *
   * @returns A promise that always rejects with an error.
   *
   * #### Notes
   * Subclasses should reimplement if they support a back-end that can remove.
   */
  async remove(id) {
    throw new Error('DataConnector#remove method has not been implemented.');
  }
  /**
   * Save a value using the data connector.
   *
   * @param id - The identifier for the data being saved.
   *
   * @param value - The data being saved.
   *
   * @returns A promise that always rejects with an error.
   *
   * #### Notes
   * Subclasses should reimplement if they support a back-end that can save.
   */
  async save(id, value) {
    throw new Error('DataConnector#save method has not been implemented.');
  }
}
exports.DataConnector = DataConnector;

/***/ }),

/***/ "./node_modules/@jupyterlab/statedb/lib/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/@jupyterlab/statedb/lib/index.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/**
 * @packageDocumentation
 * @module statedb
 */
var __createBinding = this && this.__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = this && this.__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
__exportStar(__webpack_require__(/*! ./dataconnector */ "./node_modules/@jupyterlab/statedb/lib/dataconnector.js"), exports);
__exportStar(__webpack_require__(/*! ./interfaces */ "./node_modules/@jupyterlab/statedb/lib/interfaces.js"), exports);
__exportStar(__webpack_require__(/*! ./restorablepool */ "./node_modules/@jupyterlab/statedb/lib/restorablepool.js"), exports);
__exportStar(__webpack_require__(/*! ./statedb */ "./node_modules/@jupyterlab/statedb/lib/statedb.js"), exports);
__exportStar(__webpack_require__(/*! ./tokens */ "./node_modules/@jupyterlab/statedb/lib/tokens.js"), exports);

/***/ }),

/***/ "./node_modules/@jupyterlab/statedb/lib/interfaces.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlab/statedb/lib/interfaces.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));

/***/ }),

/***/ "./node_modules/@jupyterlab/statedb/lib/restorablepool.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/statedb/lib/restorablepool.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.RestorablePool = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
const properties_1 = __webpack_require__(/*! @lumino/properties */ "./node_modules/@lumino/properties/dist/index.es6.js");
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/**
 * An object pool that supports restoration.
 *
 * @typeparam T - The type of object being tracked.
 */
class RestorablePool {
  /**
   * Create a new restorable pool.
   *
   * @param options - The instantiation options for a restorable pool.
   */
  constructor(options) {
    this._added = new signaling_1.Signal(this);
    this._current = null;
    this._currentChanged = new signaling_1.Signal(this);
    this._hasRestored = false;
    this._isDisposed = false;
    this._objects = new Set();
    this._restore = null;
    this._restored = new coreutils_1.PromiseDelegate();
    this._updated = new signaling_1.Signal(this);
    this.namespace = options.namespace;
  }
  /**
   * A signal emitted when an object object is added.
   *
   * #### Notes
   * This signal will only fire when an object is added to the pool.
   * It will not fire if an object injected into the pool.
   */
  get added() {
    return this._added;
  }
  /**
   * The current object.
   *
   * #### Notes
   * The restorable pool does not set `current`. It is intended for client use.
   *
   * If `current` is set to an object that does not exist in the pool, it is a
   * no-op.
   */
  get current() {
    return this._current;
  }
  set current(obj) {
    if (this._current === obj) {
      return;
    }
    if (obj !== null && this._objects.has(obj)) {
      this._current = obj;
      this._currentChanged.emit(this._current);
    }
  }
  /**
   * A signal emitted when the current widget changes.
   */
  get currentChanged() {
    return this._currentChanged;
  }
  /**
   * Test whether the pool is disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * A promise resolved when the restorable pool has been restored.
   */
  get restored() {
    return this._restored.promise;
  }
  /**
   * The number of objects held by the pool.
   */
  get size() {
    return this._objects.size;
  }
  /**
   * A signal emitted when an object is updated.
   */
  get updated() {
    return this._updated;
  }
  /**
   * Add a new object to the pool.
   *
   * @param obj - The object object being added.
   *
   * #### Notes
   * The object passed into the pool is added synchronously; its existence in
   * the pool can be checked with the `has()` method. The promise this method
   * returns resolves after the object has been added and saved to an underlying
   * restoration connector, if one is available.
   */
  async add(obj) {
    var _a, _b;
    if (obj.isDisposed) {
      const warning = 'A disposed object cannot be added.';
      console.warn(warning, obj);
      throw new Error(warning);
    }
    if (this._objects.has(obj)) {
      const warning = 'This object already exists in the pool.';
      console.warn(warning, obj);
      throw new Error(warning);
    }
    this._objects.add(obj);
    obj.disposed.connect(this._onInstanceDisposed, this);
    if (Private.injectedProperty.get(obj)) {
      return;
    }
    if (this._restore) {
      const {
        connector
      } = this._restore;
      const objName = this._restore.name(obj);
      if (objName) {
        const name = `${this.namespace}:${objName}`;
        const data = (_b = (_a = this._restore).args) === null || _b === void 0 ? void 0 : _b.call(_a, obj);
        Private.nameProperty.set(obj, name);
        await connector.save(name, {
          data
        });
      }
    }
    // Emit the added signal.
    this._added.emit(obj);
  }
  /**
   * Dispose of the resources held by the pool.
   *
   * #### Notes
   * Disposing a pool does not affect the underlying data in the data connector,
   * it simply disposes the client-side pool without making any connector calls.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._current = null;
    this._isDisposed = true;
    this._objects.clear();
    signaling_1.Signal.clearData(this);
  }
  /**
   * Find the first object in the pool that satisfies a filter function.
   *
   * @param - fn The filter function to call on each object.
   */
  find(fn) {
    const values = this._objects.values();
    for (const value of values) {
      if (fn(value)) {
        return value;
      }
    }
    return undefined;
  }
  /**
   * Iterate through each object in the pool.
   *
   * @param fn - The function to call on each object.
   */
  forEach(fn) {
    this._objects.forEach(fn);
  }
  /**
   * Filter the objects in the pool based on a predicate.
   *
   * @param fn - The function by which to filter.
   */
  filter(fn) {
    const filtered = [];
    this.forEach(obj => {
      if (fn(obj)) {
        filtered.push(obj);
      }
    });
    return filtered;
  }
  /**
   * Inject an object into the restorable pool without the pool handling its
   * restoration lifecycle.
   *
   * @param obj - The object to inject into the pool.
   */
  inject(obj) {
    Private.injectedProperty.set(obj, true);
    return this.add(obj);
  }
  /**
   * Check if this pool has the specified object.
   *
   * @param obj - The object whose existence is being checked.
   */
  has(obj) {
    return this._objects.has(obj);
  }
  /**
   * Restore the objects in this pool's namespace.
   *
   * @param options - The configuration options that describe restoration.
   *
   * @returns A promise that resolves when restoration has completed.
   *
   * #### Notes
   * This function should almost never be invoked by client code. Its primary
   * use case is to be invoked by a layout restorer plugin that handles
   * multiple restorable pools and, when ready, asks them each to restore their
   * respective objects.
   */
  async restore(options) {
    if (this._hasRestored) {
      throw new Error('This pool has already been restored.');
    }
    this._hasRestored = true;
    const {
      command,
      connector,
      registry,
      when
    } = options;
    const namespace = this.namespace;
    const promises = when ? [connector.list(namespace)].concat(when) : [connector.list(namespace)];
    this._restore = options;
    const [saved] = await Promise.all(promises);
    const values = await Promise.all(saved.ids.map(async (id, index) => {
      const value = saved.values[index];
      const args = value && value.data;
      if (args === undefined) {
        return connector.remove(id);
      }
      // Execute the command and if it fails, delete the state restore data.
      return registry.execute(command, args).catch(() => connector.remove(id));
    }));
    this._restored.resolve();
    return values;
  }
  /**
   * Save the restore data for a given object.
   *
   * @param obj - The object being saved.
   */
  async save(obj) {
    var _a, _b;
    const injected = Private.injectedProperty.get(obj);
    if (!this._restore || !this.has(obj) || injected) {
      return;
    }
    const {
      connector
    } = this._restore;
    const objName = this._restore.name(obj);
    const oldName = Private.nameProperty.get(obj);
    const newName = objName ? `${this.namespace}:${objName}` : '';
    if (oldName && oldName !== newName) {
      await connector.remove(oldName);
    }
    // Set the name property irrespective of whether the new name is null.
    Private.nameProperty.set(obj, newName);
    if (newName) {
      const data = (_b = (_a = this._restore).args) === null || _b === void 0 ? void 0 : _b.call(_a, obj);
      await connector.save(newName, {
        data
      });
    }
    if (oldName !== newName) {
      this._updated.emit(obj);
    }
  }
  /**
   * Clean up after disposed objects.
   */
  _onInstanceDisposed(obj) {
    this._objects.delete(obj);
    if (obj === this._current) {
      this._current = null;
      this._currentChanged.emit(this._current);
    }
    if (Private.injectedProperty.get(obj)) {
      return;
    }
    if (!this._restore) {
      return;
    }
    const {
      connector
    } = this._restore;
    const name = Private.nameProperty.get(obj);
    if (name) {
      void connector.remove(name);
    }
  }
}
exports.RestorablePool = RestorablePool;
/*
 * A namespace for private data.
 */
var Private;
(function (Private) {
  /**
   * An attached property to indicate whether an object has been injected.
   */
  Private.injectedProperty = new properties_1.AttachedProperty({
    name: 'injected',
    create: () => false
  });
  /**
   * An attached property for an object's ID.
   */
  Private.nameProperty = new properties_1.AttachedProperty({
    name: 'name',
    create: () => ''
  });
})(Private || (Private = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/statedb/lib/statedb.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlab/statedb/lib/statedb.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.StateDB = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/**
 * The default concrete implementation of a state database.
 */
class StateDB {
  /**
   * Create a new state database.
   *
   * @param options - The instantiation options for a state database.
   */
  constructor(options = {}) {
    this._changed = new signaling_1.Signal(this);
    const {
      connector,
      transform
    } = options;
    this._connector = connector || new StateDB.Connector();
    if (!transform) {
      this._ready = Promise.resolve(undefined);
    } else {
      this._ready = transform.then(transformation => {
        const {
          contents,
          type
        } = transformation;
        switch (type) {
          case 'cancel':
            return;
          case 'clear':
            return this._clear();
          case 'merge':
            return this._merge(contents || {});
          case 'overwrite':
            return this._overwrite(contents || {});
          default:
            return;
        }
      });
    }
  }
  /**
   * A signal that emits the change type any time a value changes.
   */
  get changed() {
    return this._changed;
  }
  /**
   * Clear the entire database.
   */
  async clear() {
    await this._ready;
    await this._clear();
  }
  /**
   * Retrieve a saved bundle from the database.
   *
   * @param id - The identifier used to retrieve a data bundle.
   *
   * @returns A promise that bears a data payload if available.
   *
   * #### Notes
   * The `id` values of stored items in the state database are formatted:
   * `'namespace:identifier'`, which is the same convention that command
   * identifiers in JupyterLab use as well. While this is not a technical
   * requirement for `fetch()`, `remove()`, and `save()`, it *is* necessary for
   * using the `list(namespace: string)` method.
   *
   * The promise returned by this method may be rejected if an error occurs in
   * retrieving the data. Non-existence of an `id` will succeed with the `value`
   * `undefined`.
   */
  async fetch(id) {
    await this._ready;
    return this._fetch(id);
  }
  /**
   * Retrieve all the saved bundles for a namespace.
   *
   * @param filter - The namespace prefix to retrieve.
   *
   * @returns A promise that bears a collection of payloads for a namespace.
   *
   * #### Notes
   * Namespaces are entirely conventional entities. The `id` values of stored
   * items in the state database are formatted: `'namespace:identifier'`, which
   * is the same convention that command identifiers in JupyterLab use as well.
   *
   * If there are any errors in retrieving the data, they will be logged to the
   * console in order to optimistically return any extant data without failing.
   * This promise will always succeed.
   */
  async list(namespace) {
    await this._ready;
    return this._list(namespace);
  }
  /**
   * Remove a value from the database.
   *
   * @param id - The identifier for the data being removed.
   *
   * @returns A promise that is rejected if remove fails and succeeds otherwise.
   */
  async remove(id) {
    await this._ready;
    await this._remove(id);
    this._changed.emit({
      id,
      type: 'remove'
    });
  }
  /**
   * Save a value in the database.
   *
   * @param id - The identifier for the data being saved.
   *
   * @param value - The data being saved.
   *
   * @returns A promise that is rejected if saving fails and succeeds otherwise.
   *
   * #### Notes
   * The `id` values of stored items in the state database are formatted:
   * `'namespace:identifier'`, which is the same convention that command
   * identifiers in JupyterLab use as well. While this is not a technical
   * requirement for `fetch()`, `remove()`, and `save()`, it *is* necessary for
   * using the `list(namespace: string)` method.
   */
  async save(id, value) {
    await this._ready;
    await this._save(id, value);
    this._changed.emit({
      id,
      type: 'save'
    });
  }
  /**
   * Return a serialized copy of the state database's entire contents.
   *
   * @returns A promise that resolves with the database contents as JSON.
   */
  async toJSON() {
    await this._ready;
    const {
      ids,
      values
    } = await this._list();
    return values.reduce((acc, val, idx) => {
      acc[ids[idx]] = val;
      return acc;
    }, {});
  }
  /**
   * Clear the entire database.
   */
  async _clear() {
    await Promise.all((await this._list()).ids.map(id => this._remove(id)));
  }
  /**
   * Fetch a value from the database.
   */
  async _fetch(id) {
    const value = await this._connector.fetch(id);
    if (value) {
      return JSON.parse(value).v;
    }
  }
  /**
   * Fetch a list from the database.
   */
  async _list(namespace = '') {
    const {
      ids,
      values
    } = await this._connector.list(namespace);
    return {
      ids,
      values: values.map(val => JSON.parse(val).v)
    };
  }
  /**
   * Merge data into the state database.
   */
  async _merge(contents) {
    await Promise.all(Object.keys(contents).map(key => contents[key] && this._save(key, contents[key])));
  }
  /**
   * Overwrite the entire database with new contents.
   */
  async _overwrite(contents) {
    await this._clear();
    await this._merge(contents);
  }
  /**
   * Remove a key in the database.
   */
  async _remove(id) {
    return this._connector.remove(id);
  }
  /**
   * Save a key and its value in the database.
   */
  async _save(id, value) {
    return this._connector.save(id, JSON.stringify({
      v: value
    }));
  }
}
exports.StateDB = StateDB;
/**
 * A namespace for StateDB statics.
 */
(function (StateDB) {
  /**
   * An in-memory string key/value data connector.
   */
  class Connector {
    constructor() {
      this._storage = {};
    }
    /**
     * Retrieve an item from the data connector.
     */
    async fetch(id) {
      return this._storage[id];
    }
    /**
     * Retrieve the list of items available from the data connector.
     *
     * @param namespace - If not empty, only keys whose first token before `:`
     * exactly match `namespace` will be returned, e.g. `foo` in `foo:bar`.
     */
    async list(namespace = '') {
      return Object.keys(this._storage).reduce((acc, val) => {
        if (namespace === '' ? true : namespace === val.split(':')[0]) {
          acc.ids.push(val);
          acc.values.push(this._storage[val]);
        }
        return acc;
      }, {
        ids: [],
        values: []
      });
    }
    /**
     * Remove a value using the data connector.
     */
    async remove(id) {
      delete this._storage[id];
    }
    /**
     * Save a value using the data connector.
     */
    async save(id, value) {
      this._storage[id] = value;
    }
  }
  StateDB.Connector = Connector;
})(StateDB = exports.StateDB || (exports.StateDB = {}));

/***/ }),

/***/ "./node_modules/@jupyterlab/statedb/lib/tokens.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/statedb/lib/tokens.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.IStateDB = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
/**
 * The default state database token.
 */
exports.IStateDB = new coreutils_1.Token('@jupyterlab/coreutils:IStateDB', `A service for the JupyterLab state database.
  Use this if you want to store data that will persist across page loads.
  See "state database" for more information.`);

/***/ }),

/***/ "./node_modules/@lumino/algorithm/dist/index.es6.js":
/*!**********************************************************!*\
  !*** ./node_modules/@lumino/algorithm/dist/index.es6.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArrayExt": () => (/* binding */ ArrayExt),
/* harmony export */   "StringExt": () => (/* binding */ StringExt),
/* harmony export */   "chain": () => (/* binding */ chain),
/* harmony export */   "each": () => (/* binding */ each),
/* harmony export */   "empty": () => (/* binding */ empty),
/* harmony export */   "enumerate": () => (/* binding */ enumerate),
/* harmony export */   "every": () => (/* binding */ every),
/* harmony export */   "filter": () => (/* binding */ filter),
/* harmony export */   "find": () => (/* binding */ find),
/* harmony export */   "findIndex": () => (/* binding */ findIndex),
/* harmony export */   "map": () => (/* binding */ map),
/* harmony export */   "max": () => (/* binding */ max),
/* harmony export */   "min": () => (/* binding */ min),
/* harmony export */   "minmax": () => (/* binding */ minmax),
/* harmony export */   "once": () => (/* binding */ once),
/* harmony export */   "range": () => (/* binding */ range),
/* harmony export */   "reduce": () => (/* binding */ reduce),
/* harmony export */   "repeat": () => (/* binding */ repeat),
/* harmony export */   "retro": () => (/* binding */ retro),
/* harmony export */   "some": () => (/* binding */ some),
/* harmony export */   "stride": () => (/* binding */ stride),
/* harmony export */   "take": () => (/* binding */ take),
/* harmony export */   "toArray": () => (/* binding */ toArray),
/* harmony export */   "toObject": () => (/* binding */ toObject),
/* harmony export */   "topologicSort": () => (/* binding */ topologicSort),
/* harmony export */   "zip": () => (/* binding */ zip)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * The namespace for array-specific algorithms.
 */
var ArrayExt;
(function (ArrayExt) {
  /**
   * Find the index of the first occurrence of a value in an array.
   *
   * @param array - The array-like object to search.
   *
   * @param value - The value to locate in the array. Values are
   *   compared using strict `===` equality.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The index of the first occurrence of the value, or `-1`
   *   if the value is not found.
   *
   * #### Notes
   * If `stop < start` the search will wrap at the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start` or `stop` which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = ['one', 'two', 'three', 'four', 'one'];
   * ArrayExt.firstIndexOf(data, 'red');        // -1
   * ArrayExt.firstIndexOf(data, 'one');        // 0
   * ArrayExt.firstIndexOf(data, 'one', 1);     // 4
   * ArrayExt.firstIndexOf(data, 'two', 2);     // -1
   * ArrayExt.firstIndexOf(data, 'two', 2, 1);  // 1
   * ```
   */
  function firstIndexOf(array, value, start = 0, stop = -1) {
    let n = array.length;
    if (n === 0) {
      return -1;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let span;
    if (stop < start) {
      span = stop + 1 + (n - start);
    } else {
      span = stop - start + 1;
    }
    for (let i = 0; i < span; ++i) {
      let j = (start + i) % n;
      if (array[j] === value) {
        return j;
      }
    }
    return -1;
  }
  ArrayExt.firstIndexOf = firstIndexOf;
  /**
   * Find the index of the last occurrence of a value in an array.
   *
   * @param array - The array-like object to search.
   *
   * @param value - The value to locate in the array. Values are
   *   compared using strict `===` equality.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The index of the last occurrence of the value, or `-1`
   *   if the value is not found.
   *
   * #### Notes
   * If `start < stop` the search will wrap at the front of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start` or `stop` which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = ['one', 'two', 'three', 'four', 'one'];
   * ArrayExt.lastIndexOf(data, 'red');        // -1
   * ArrayExt.lastIndexOf(data, 'one');        // 4
   * ArrayExt.lastIndexOf(data, 'one', 1);     // 0
   * ArrayExt.lastIndexOf(data, 'two', 0);     // -1
   * ArrayExt.lastIndexOf(data, 'two', 0, 1);  // 1
   * ```
   */
  function lastIndexOf(array, value, start = -1, stop = 0) {
    let n = array.length;
    if (n === 0) {
      return -1;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let span;
    if (start < stop) {
      span = start + 1 + (n - stop);
    } else {
      span = start - stop + 1;
    }
    for (let i = 0; i < span; ++i) {
      let j = (start - i + n) % n;
      if (array[j] === value) {
        return j;
      }
    }
    return -1;
  }
  ArrayExt.lastIndexOf = lastIndexOf;
  /**
   * Find the index of the first value which matches a predicate.
   *
   * @param array - The array-like object to search.
   *
   * @param fn - The predicate function to apply to the values.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The index of the first matching value, or `-1` if no
   *   matching value is found.
   *
   * #### Notes
   * If `stop < start` the search will wrap at the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start` or `stop` which is non-integral.
   *
   * Modifying the length of the array while searching.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function isEven(value: number): boolean {
   *   return value % 2 === 0;
   * }
   *
   * let data = [1, 2, 3, 4, 3, 2, 1];
   * ArrayExt.findFirstIndex(data, isEven);       // 1
   * ArrayExt.findFirstIndex(data, isEven, 4);    // 5
   * ArrayExt.findFirstIndex(data, isEven, 6);    // -1
   * ArrayExt.findFirstIndex(data, isEven, 6, 5); // 1
   * ```
   */
  function findFirstIndex(array, fn, start = 0, stop = -1) {
    let n = array.length;
    if (n === 0) {
      return -1;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let span;
    if (stop < start) {
      span = stop + 1 + (n - start);
    } else {
      span = stop - start + 1;
    }
    for (let i = 0; i < span; ++i) {
      let j = (start + i) % n;
      if (fn(array[j], j)) {
        return j;
      }
    }
    return -1;
  }
  ArrayExt.findFirstIndex = findFirstIndex;
  /**
   * Find the index of the last value which matches a predicate.
   *
   * @param object - The array-like object to search.
   *
   * @param fn - The predicate function to apply to the values.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The index of the last matching value, or `-1` if no
   *   matching value is found.
   *
   * #### Notes
   * If `start < stop` the search will wrap at the front of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start` or `stop` which is non-integral.
   *
   * Modifying the length of the array while searching.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function isEven(value: number): boolean {
   *   return value % 2 === 0;
   * }
   *
   * let data = [1, 2, 3, 4, 3, 2, 1];
   * ArrayExt.findLastIndex(data, isEven);        // 5
   * ArrayExt.findLastIndex(data, isEven, 4);     // 3
   * ArrayExt.findLastIndex(data, isEven, 0);     // -1
   * ArrayExt.findLastIndex(data, isEven, 0, 1);  // 5
   * ```
   */
  function findLastIndex(array, fn, start = -1, stop = 0) {
    let n = array.length;
    if (n === 0) {
      return -1;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let d;
    if (start < stop) {
      d = start + 1 + (n - stop);
    } else {
      d = start - stop + 1;
    }
    for (let i = 0; i < d; ++i) {
      let j = (start - i + n) % n;
      if (fn(array[j], j)) {
        return j;
      }
    }
    return -1;
  }
  ArrayExt.findLastIndex = findLastIndex;
  /**
   * Find the first value which matches a predicate.
   *
   * @param array - The array-like object to search.
   *
   * @param fn - The predicate function to apply to the values.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The first matching value, or `undefined` if no matching
   *   value is found.
   *
   * #### Notes
   * If `stop < start` the search will wrap at the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start` or `stop` which is non-integral.
   *
   * Modifying the length of the array while searching.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function isEven(value: number): boolean {
   *   return value % 2 === 0;
   * }
   *
   * let data = [1, 2, 3, 4, 3, 2, 1];
   * ArrayExt.findFirstValue(data, isEven);       // 2
   * ArrayExt.findFirstValue(data, isEven, 2);    // 4
   * ArrayExt.findFirstValue(data, isEven, 6);    // undefined
   * ArrayExt.findFirstValue(data, isEven, 6, 5); // 2
   * ```
   */
  function findFirstValue(array, fn, start = 0, stop = -1) {
    let index = findFirstIndex(array, fn, start, stop);
    return index !== -1 ? array[index] : undefined;
  }
  ArrayExt.findFirstValue = findFirstValue;
  /**
   * Find the last value which matches a predicate.
   *
   * @param object - The array-like object to search.
   *
   * @param fn - The predicate function to apply to the values.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The last matching value, or `undefined` if no matching
   *   value is found.
   *
   * #### Notes
   * If `start < stop` the search will wrap at the front of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start` or `stop` which is non-integral.
   *
   * Modifying the length of the array while searching.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function isEven(value: number): boolean {
   *   return value % 2 === 0;
   * }
   *
   * let data = [1, 2, 3, 4, 3, 2, 1];
   * ArrayExt.findLastValue(data, isEven);        // 2
   * ArrayExt.findLastValue(data, isEven, 4);     // 4
   * ArrayExt.findLastValue(data, isEven, 0);     // undefined
   * ArrayExt.findLastValue(data, isEven, 0, 1);  // 2
   * ```
   */
  function findLastValue(array, fn, start = -1, stop = 0) {
    let index = findLastIndex(array, fn, start, stop);
    return index !== -1 ? array[index] : undefined;
  }
  ArrayExt.findLastValue = findLastValue;
  /**
   * Find the index of the first element which compares `>=` to a value.
   *
   * @param array - The sorted array-like object to search.
   *
   * @param value - The value to locate in the array.
   *
   * @param fn - The 3-way comparison function to apply to the values.
   *   It should return `< 0` if an element is less than a value, `0` if
   *   an element is equal to a value, or `> 0` if an element is greater
   *   than a value.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The index of the first element which compares `>=` to the
   *   value, or `length` if there is no such element. If the computed
   *   index for `stop` is less than `start`, then the computed index
   *   for `start` is returned.
   *
   * #### Notes
   * The array must already be sorted in ascending order according to
   * the comparison function.
   *
   * #### Complexity
   * Logarithmic.
   *
   * #### Undefined Behavior
   * Searching a range which is not sorted in ascending order.
   *
   * A `start` or `stop` which is non-integral.
   *
   * Modifying the length of the array while searching.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function numberCmp(a: number, b: number): number {
   *   return a - b;
   * }
   *
   * let data = [0, 3, 4, 7, 7, 9];
   * ArrayExt.lowerBound(data, 0, numberCmp);   // 0
   * ArrayExt.lowerBound(data, 6, numberCmp);   // 3
   * ArrayExt.lowerBound(data, 7, numberCmp);   // 3
   * ArrayExt.lowerBound(data, -1, numberCmp);  // 0
   * ArrayExt.lowerBound(data, 10, numberCmp);  // 6
   * ```
   */
  function lowerBound(array, value, fn, start = 0, stop = -1) {
    let n = array.length;
    if (n === 0) {
      return 0;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let begin = start;
    let span = stop - start + 1;
    while (span > 0) {
      let half = span >> 1;
      let middle = begin + half;
      if (fn(array[middle], value) < 0) {
        begin = middle + 1;
        span -= half + 1;
      } else {
        span = half;
      }
    }
    return begin;
  }
  ArrayExt.lowerBound = lowerBound;
  /**
   * Find the index of the first element which compares `>` than a value.
   *
   * @param array - The sorted array-like object to search.
   *
   * @param value - The value to locate in the array.
   *
   * @param fn - The 3-way comparison function to apply to the values.
   *   It should return `< 0` if an element is less than a value, `0` if
   *   an element is equal to a value, or `> 0` if an element is greater
   *   than a value.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The index of the first element which compares `>` than the
   *   value, or `length` if there is no such element. If the computed
   *   index for `stop` is less than `start`, then the computed index
   *   for `start` is returned.
   *
   * #### Notes
   * The array must already be sorted in ascending order according to
   * the comparison function.
   *
   * #### Complexity
   * Logarithmic.
   *
   * #### Undefined Behavior
   * Searching a range which is not sorted in ascending order.
   *
   * A `start` or `stop` which is non-integral.
   *
   * Modifying the length of the array while searching.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function numberCmp(a: number, b: number): number {
   *   return a - b;
   * }
   *
   * let data = [0, 3, 4, 7, 7, 9];
   * ArrayExt.upperBound(data, 0, numberCmp);   // 1
   * ArrayExt.upperBound(data, 6, numberCmp);   // 3
   * ArrayExt.upperBound(data, 7, numberCmp);   // 5
   * ArrayExt.upperBound(data, -1, numberCmp);  // 0
   * ArrayExt.upperBound(data, 10, numberCmp);  // 6
   * ```
   */
  function upperBound(array, value, fn, start = 0, stop = -1) {
    let n = array.length;
    if (n === 0) {
      return 0;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let begin = start;
    let span = stop - start + 1;
    while (span > 0) {
      let half = span >> 1;
      let middle = begin + half;
      if (fn(array[middle], value) > 0) {
        span = half;
      } else {
        begin = middle + 1;
        span -= half + 1;
      }
    }
    return begin;
  }
  ArrayExt.upperBound = upperBound;
  /**
   * Test whether two arrays are shallowly equal.
   *
   * @param a - The first array-like object to compare.
   *
   * @param b - The second array-like object to compare.
   *
   * @param fn - The comparison function to apply to the elements. It
   *   should return `true` if the elements are "equal". The default
   *   compares elements using strict `===` equality.
   *
   * @returns Whether the two arrays are shallowly equal.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * Modifying the length of the arrays while comparing.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let d1 = [0, 3, 4, 7, 7, 9];
   * let d2 = [0, 3, 4, 7, 7, 9];
   * let d3 = [42];
   * ArrayExt.shallowEqual(d1, d2);  // true
   * ArrayExt.shallowEqual(d2, d3);  // false
   * ```
   */
  function shallowEqual(a, b, fn) {
    // Check for object identity first.
    if (a === b) {
      return true;
    }
    // Bail early if the lengths are different.
    if (a.length !== b.length) {
      return false;
    }
    // Compare each element for equality.
    for (let i = 0, n = a.length; i < n; ++i) {
      if (fn ? !fn(a[i], b[i]) : a[i] !== b[i]) {
        return false;
      }
    }
    // The array are shallowly equal.
    return true;
  }
  ArrayExt.shallowEqual = shallowEqual;
  /**
   * Create a slice of an array subject to an optional step.
   *
   * @param array - The array-like object of interest.
   *
   * @param options - The options for configuring the slice.
   *
   * @returns A new array with the specified values.
   *
   * @throws An exception if the slice `step` is `0`.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start`, `stop`, or `step` which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = [0, 3, 4, 7, 7, 9];
   * ArrayExt.slice(data);                         // [0, 3, 4, 7, 7, 9]
   * ArrayExt.slice(data, { start: 2 });           // [4, 7, 7, 9]
   * ArrayExt.slice(data, { start: 0, stop: 4 });  // [0, 3, 4, 7]
   * ArrayExt.slice(data, { step: 2 });            // [0, 4, 7]
   * ArrayExt.slice(data, { step: -1 });           // [9, 7, 7, 4, 3, 0]
   * ```
   */
  function slice(array, options = {}) {
    // Extract the options.
    let {
      start,
      stop,
      step
    } = options;
    // Set up the `step` value.
    if (step === undefined) {
      step = 1;
    }
    // Validate the step size.
    if (step === 0) {
      throw new Error('Slice `step` cannot be zero.');
    }
    // Look up the length of the array.
    let n = array.length;
    // Set up the `start` value.
    if (start === undefined) {
      start = step < 0 ? n - 1 : 0;
    } else if (start < 0) {
      start = Math.max(start + n, step < 0 ? -1 : 0);
    } else if (start >= n) {
      start = step < 0 ? n - 1 : n;
    }
    // Set up the `stop` value.
    if (stop === undefined) {
      stop = step < 0 ? -1 : n;
    } else if (stop < 0) {
      stop = Math.max(stop + n, step < 0 ? -1 : 0);
    } else if (stop >= n) {
      stop = step < 0 ? n - 1 : n;
    }
    // Compute the slice length.
    let length;
    if (step < 0 && stop >= start || step > 0 && start >= stop) {
      length = 0;
    } else if (step < 0) {
      length = Math.floor((stop - start + 1) / step + 1);
    } else {
      length = Math.floor((stop - start - 1) / step + 1);
    }
    // Compute the sliced result.
    let result = [];
    for (let i = 0; i < length; ++i) {
      result[i] = array[start + i * step];
    }
    // Return the result.
    return result;
  }
  ArrayExt.slice = slice;
  /**
   * Move an element in an array from one index to another.
   *
   * @param array - The mutable array-like object of interest.
   *
   * @param fromIndex - The index of the element to move. Negative
   *   values are taken as an offset from the end of the array.
   *
   * @param toIndex - The target index of the element. Negative
   *   values are taken as an offset from the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `fromIndex` or `toIndex` which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from from '@lumino/algorithm';
   *
   * let data = [0, 1, 2, 3, 4];
   * ArrayExt.move(data, 1, 2);  // [0, 2, 1, 3, 4]
   * ArrayExt.move(data, 4, 2);  // [0, 2, 4, 1, 3]
   * ```
   */
  function move(array, fromIndex, toIndex) {
    let n = array.length;
    if (n <= 1) {
      return;
    }
    if (fromIndex < 0) {
      fromIndex = Math.max(0, fromIndex + n);
    } else {
      fromIndex = Math.min(fromIndex, n - 1);
    }
    if (toIndex < 0) {
      toIndex = Math.max(0, toIndex + n);
    } else {
      toIndex = Math.min(toIndex, n - 1);
    }
    if (fromIndex === toIndex) {
      return;
    }
    let value = array[fromIndex];
    let d = fromIndex < toIndex ? 1 : -1;
    for (let i = fromIndex; i !== toIndex; i += d) {
      array[i] = array[i + d];
    }
    array[toIndex] = value;
  }
  ArrayExt.move = move;
  /**
   * Reverse an array in-place.
   *
   * @param array - The mutable array-like object of interest.
   *
   * @param start - The index of the first element in the range to be
   *   reversed, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   reversed, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start` or  `stop` index which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = [0, 1, 2, 3, 4];
   * ArrayExt.reverse(data, 1, 3);  // [0, 3, 2, 1, 4]
   * ArrayExt.reverse(data, 3);     // [0, 3, 2, 4, 1]
   * ArrayExt.reverse(data);        // [1, 4, 2, 3, 0]
   * ```
   */
  function reverse(array, start = 0, stop = -1) {
    let n = array.length;
    if (n <= 1) {
      return;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    while (start < stop) {
      let a = array[start];
      let b = array[stop];
      array[start++] = b;
      array[stop--] = a;
    }
  }
  ArrayExt.reverse = reverse;
  /**
   * Rotate the elements of an array in-place.
   *
   * @param array - The mutable array-like object of interest.
   *
   * @param delta - The amount of rotation to apply to the elements. A
   *   positive value will rotate the elements to the left. A negative
   *   value will rotate the elements to the right.
   *
   * @param start - The index of the first element in the range to be
   *   rotated, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   rotated, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `delta`, `start`, or `stop` which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = [0, 1, 2, 3, 4];
   * ArrayExt.rotate(data, 2);        // [2, 3, 4, 0, 1]
   * ArrayExt.rotate(data, -2);       // [0, 1, 2, 3, 4]
   * ArrayExt.rotate(data, 10);       // [0, 1, 2, 3, 4]
   * ArrayExt.rotate(data, 9);        // [4, 0, 1, 2, 3]
   * ArrayExt.rotate(data, 2, 1, 3);  // [4, 2, 0, 1, 3]
   * ```
   */
  function rotate(array, delta, start = 0, stop = -1) {
    let n = array.length;
    if (n <= 1) {
      return;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    if (start >= stop) {
      return;
    }
    let length = stop - start + 1;
    if (delta > 0) {
      delta = delta % length;
    } else if (delta < 0) {
      delta = (delta % length + length) % length;
    }
    if (delta === 0) {
      return;
    }
    let pivot = start + delta;
    reverse(array, start, pivot - 1);
    reverse(array, pivot, stop);
    reverse(array, start, stop);
  }
  ArrayExt.rotate = rotate;
  /**
   * Fill an array with a static value.
   *
   * @param array - The mutable array-like object to fill.
   *
   * @param value - The static value to use to fill the array.
   *
   * @param start - The index of the first element in the range to be
   *   filled, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   filled, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * #### Notes
   * If `stop < start` the fill will wrap at the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * A `start` or `stop` which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = ['one', 'two', 'three', 'four'];
   * ArrayExt.fill(data, 'r');        // ['r', 'r', 'r', 'r']
   * ArrayExt.fill(data, 'g', 1);     // ['r', 'g', 'g', 'g']
   * ArrayExt.fill(data, 'b', 2, 3);  // ['r', 'g', 'b', 'b']
   * ArrayExt.fill(data, 'z', 3, 1);  // ['z', 'z', 'b', 'z']
   * ```
   */
  function fill(array, value, start = 0, stop = -1) {
    let n = array.length;
    if (n === 0) {
      return;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let span;
    if (stop < start) {
      span = stop + 1 + (n - start);
    } else {
      span = stop - start + 1;
    }
    for (let i = 0; i < span; ++i) {
      array[(start + i) % n] = value;
    }
  }
  ArrayExt.fill = fill;
  /**
   * Insert a value into an array at a specific index.
   *
   * @param array - The array of interest.
   *
   * @param index - The index at which to insert the value. Negative
   *   values are taken as an offset from the end of the array.
   *
   * @param value - The value to set at the specified index.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * An `index` which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = [0, 1, 2];
   * ArrayExt.insert(data, 0, -1);  // [-1, 0, 1, 2]
   * ArrayExt.insert(data, 2, 12);  // [-1, 0, 12, 1, 2]
   * ArrayExt.insert(data, -1, 7);  // [-1, 0, 12, 1, 7, 2]
   * ArrayExt.insert(data, 6, 19);  // [-1, 0, 12, 1, 7, 2, 19]
   * ```
   */
  function insert(array, index, value) {
    let n = array.length;
    if (index < 0) {
      index = Math.max(0, index + n);
    } else {
      index = Math.min(index, n);
    }
    for (let i = n; i > index; --i) {
      array[i] = array[i - 1];
    }
    array[index] = value;
  }
  ArrayExt.insert = insert;
  /**
   * Remove and return a value at a specific index in an array.
   *
   * @param array - The array of interest.
   *
   * @param index - The index of the value to remove. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The value at the specified index, or `undefined` if the
   *   index is out of range.
   *
   * #### Complexity
   * Linear.
   *
   * #### Undefined Behavior
   * An `index` which is non-integral.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = [0, 12, 23, 39, 14, 12, 75];
   * ArrayExt.removeAt(data, 2);   // 23
   * ArrayExt.removeAt(data, -2);  // 12
   * ArrayExt.removeAt(data, 10);  // undefined;
   * ```
   */
  function removeAt(array, index) {
    let n = array.length;
    if (index < 0) {
      index += n;
    }
    if (index < 0 || index >= n) {
      return undefined;
    }
    let value = array[index];
    for (let i = index + 1; i < n; ++i) {
      array[i - 1] = array[i];
    }
    array.length = n - 1;
    return value;
  }
  ArrayExt.removeAt = removeAt;
  /**
   * Remove the first occurrence of a value from an array.
   *
   * @param array - The array of interest.
   *
   * @param value - The value to remove from the array. Values are
   *   compared using strict `===` equality.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The index of the removed value, or `-1` if the value
   *   is not contained in the array.
   *
   * #### Notes
   * If `stop < start` the search will wrap at the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = [0, 12, 23, 39, 14, 12, 75];
   * ArrayExt.removeFirstOf(data, 12);        // 1
   * ArrayExt.removeFirstOf(data, 17);        // -1
   * ArrayExt.removeFirstOf(data, 39, 3);     // -1
   * ArrayExt.removeFirstOf(data, 39, 3, 2);  // 2
   * ```
   */
  function removeFirstOf(array, value, start = 0, stop = -1) {
    let index = firstIndexOf(array, value, start, stop);
    if (index !== -1) {
      removeAt(array, index);
    }
    return index;
  }
  ArrayExt.removeFirstOf = removeFirstOf;
  /**
   * Remove the last occurrence of a value from an array.
   *
   * @param array - The array of interest.
   *
   * @param value - The value to remove from the array. Values are
   *   compared using strict `===` equality.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The index of the removed value, or `-1` if the value
   *   is not contained in the array.
   *
   * #### Notes
   * If `start < stop` the search will wrap at the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = [0, 12, 23, 39, 14, 12, 75];
   * ArrayExt.removeLastOf(data, 12);        // 5
   * ArrayExt.removeLastOf(data, 17);        // -1
   * ArrayExt.removeLastOf(data, 39, 2);     // -1
   * ArrayExt.removeLastOf(data, 39, 2, 3);  // 3
   * ```
   */
  function removeLastOf(array, value, start = -1, stop = 0) {
    let index = lastIndexOf(array, value, start, stop);
    if (index !== -1) {
      removeAt(array, index);
    }
    return index;
  }
  ArrayExt.removeLastOf = removeLastOf;
  /**
   * Remove all occurrences of a value from an array.
   *
   * @param array - The array of interest.
   *
   * @param value - The value to remove from the array. Values are
   *   compared using strict `===` equality.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The number of elements removed from the array.
   *
   * #### Notes
   * If `stop < start` the search will conceptually wrap at the end of
   * the array, however the array will be traversed front-to-back.
   *
   * #### Complexity
   * Linear.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * let data = [14, 12, 23, 39, 14, 12, 19, 14];
   * ArrayExt.removeAllOf(data, 12);        // 2
   * ArrayExt.removeAllOf(data, 17);        // 0
   * ArrayExt.removeAllOf(data, 14, 1, 4);  // 1
   * ```
   */
  function removeAllOf(array, value, start = 0, stop = -1) {
    let n = array.length;
    if (n === 0) {
      return 0;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let count = 0;
    for (let i = 0; i < n; ++i) {
      if (start <= stop && i >= start && i <= stop && array[i] === value) {
        count++;
      } else if (stop < start && (i <= stop || i >= start) && array[i] === value) {
        count++;
      } else if (count > 0) {
        array[i - count] = array[i];
      }
    }
    if (count > 0) {
      array.length = n - count;
    }
    return count;
  }
  ArrayExt.removeAllOf = removeAllOf;
  /**
   * Remove the first occurrence of a value which matches a predicate.
   *
   * @param array - The array of interest.
   *
   * @param fn - The predicate function to apply to the values.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The removed `{ index, value }`, which will be `-1` and
   *   `undefined` if the value is not contained in the array.
   *
   * #### Notes
   * If `stop < start` the search will wrap at the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function isEven(value: number): boolean {
   *   return value % 2 === 0;
   * }
   *
   * let data = [0, 12, 23, 39, 14, 12, 75];
   * ArrayExt.removeFirstWhere(data, isEven);     // { index: 0, value: 0 }
   * ArrayExt.removeFirstWhere(data, isEven, 2);  // { index: 3, value: 14 }
   * ArrayExt.removeFirstWhere(data, isEven, 4);  // { index: -1, value: undefined }
   * ```
   */
  function removeFirstWhere(array, fn, start = 0, stop = -1) {
    let value;
    let index = findFirstIndex(array, fn, start, stop);
    if (index !== -1) {
      value = removeAt(array, index);
    }
    return {
      index,
      value
    };
  }
  ArrayExt.removeFirstWhere = removeFirstWhere;
  /**
   * Remove the last occurrence of a value which matches a predicate.
   *
   * @param array - The array of interest.
   *
   * @param fn - The predicate function to apply to the values.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The removed `{ index, value }`, which will be `-1` and
   *   `undefined` if the value is not contained in the array.
   *
   * #### Notes
   * If `start < stop` the search will wrap at the end of the array.
   *
   * #### Complexity
   * Linear.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function isEven(value: number): boolean {
   *   return value % 2 === 0;
   * }
   *
   * let data = [0, 12, 23, 39, 14, 12, 75];
   * ArrayExt.removeLastWhere(data, isEven);        // { index: 5, value: 12 }
   * ArrayExt.removeLastWhere(data, isEven, 2);     // { index: 1, value: 12 }
   * ArrayExt.removeLastWhere(data, isEven, 2, 1);  // { index: -1, value: undefined }
   * ```
   */
  function removeLastWhere(array, fn, start = -1, stop = 0) {
    let value;
    let index = findLastIndex(array, fn, start, stop);
    if (index !== -1) {
      value = removeAt(array, index);
    }
    return {
      index,
      value
    };
  }
  ArrayExt.removeLastWhere = removeLastWhere;
  /**
   * Remove all occurrences of values which match a predicate.
   *
   * @param array - The array of interest.
   *
   * @param fn - The predicate function to apply to the values.
   *
   * @param start - The index of the first element in the range to be
   *   searched, inclusive. The default value is `0`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @param stop - The index of the last element in the range to be
   *   searched, inclusive. The default value is `-1`. Negative values
   *   are taken as an offset from the end of the array.
   *
   * @returns The number of elements removed from the array.
   *
   * #### Notes
   * If `stop < start` the search will conceptually wrap at the end of
   * the array, however the array will be traversed front-to-back.
   *
   * #### Complexity
   * Linear.
   *
   * #### Example
   * ```typescript
   * import { ArrayExt } from '@lumino/algorithm';
   *
   * function isEven(value: number): boolean {
   *   return value % 2 === 0;
   * }
   *
   * function isNegative(value: number): boolean {
   *   return value < 0;
   * }
   *
   * let data = [0, 12, -13, -9, 23, 39, 14, -15, 12, 75];
   * ArrayExt.removeAllWhere(data, isEven);            // 4
   * ArrayExt.removeAllWhere(data, isNegative, 0, 3);  // 2
   * ```
   */
  function removeAllWhere(array, fn, start = 0, stop = -1) {
    let n = array.length;
    if (n === 0) {
      return 0;
    }
    if (start < 0) {
      start = Math.max(0, start + n);
    } else {
      start = Math.min(start, n - 1);
    }
    if (stop < 0) {
      stop = Math.max(0, stop + n);
    } else {
      stop = Math.min(stop, n - 1);
    }
    let count = 0;
    for (let i = 0; i < n; ++i) {
      if (start <= stop && i >= start && i <= stop && fn(array[i], i)) {
        count++;
      } else if (stop < start && (i <= stop || i >= start) && fn(array[i], i)) {
        count++;
      } else if (count > 0) {
        array[i - count] = array[i];
      }
    }
    if (count > 0) {
      array.length = n - count;
    }
    return count;
  }
  ArrayExt.removeAllWhere = removeAllWhere;
})(ArrayExt || (ArrayExt = {}));

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Chain together several iterables.
 *
 * @deprecated
 *
 * @param objects - The iterable objects of interest.
 *
 * @returns An iterator which yields the values of the iterables
 *   in the order in which they are supplied.
 *
 * #### Example
 * ```typescript
 * import { chain } from '@lumino/algorithm';
 *
 * let data1 = [1, 2, 3];
 * let data2 = [4, 5, 6];
 *
 * let stream = chain(data1, data2);
 *
 * Array.from(stream);  // [1, 2, 3, 4, 5, 6]
 * ```
 */
function* chain(...objects) {
  for (const object of objects) {
    yield* object;
  }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an empty iterator.
 *
 * @returns A new iterator which yields nothing.
 *
 * #### Example
 * ```typescript
 * import { empty } from '@lumino/algorithm';
 *
 * let stream = empty<number>();
 *
 * Array.from(stream);  // []
 * ```
 */
// eslint-disable-next-line require-yield
function* empty() {
  return;
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Enumerate an iterable object.
 *
 * @param object - The iterable object of interest.
 *
 * @param start - The starting enum value. The default is `0`.
 *
 * @returns An iterator which yields the enumerated values.
 *
 * #### Example
 * ```typescript
 * import { enumerate } from '@lumino/algorithm';
 *
 * let data = ['foo', 'bar', 'baz'];
 *
 * let stream = enumerate(data, 1);
 *
 * Array.from(stream);  // [[1, 'foo'], [2, 'bar'], [3, 'baz']]
 * ```
 */
function* enumerate(object, start = 0) {
  for (const value of object) {
    yield [start++, value];
  }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Filter an iterable for values which pass a test.
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The predicate function to invoke for each value.
 *
 * @returns An iterator which yields the values which pass the test.
 *
 * #### Example
 * ```typescript
 * import { filter } from '@lumino/algorithm';
 *
 * let data = [1, 2, 3, 4, 5, 6];
 *
 * let stream = filter(data, value => value % 2 === 0);
 *
 * Array.from(stream);  // [2, 4, 6]
 * ```
 */
function* filter(object, fn) {
  let index = 0;
  for (const value of object) {
    if (fn(value, index++)) {
      yield value;
    }
  }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Find the first value in an iterable which matches a predicate.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The predicate function to apply to the values.
 *
 * @returns The first matching value, or `undefined` if no matching
 *   value is found.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { find } from '@lumino/algorithm';
 *
 * interface IAnimal { species: string, name: string };
 *
 * function isCat(value: IAnimal): boolean {
 *   return value.species === 'cat';
 * }
 *
 * let data: IAnimal[] = [
 *   { species: 'dog', name: 'spot' },
 *   { species: 'cat', name: 'fluffy' },
 *   { species: 'alligator', name: 'pocho' }
 * ];
 *
 * find(data, isCat).name;  // 'fluffy'
 * ```
 */
function find(object, fn) {
  let index = 0;
  for (const value of object) {
    if (fn(value, index++)) {
      return value;
    }
  }
  return undefined;
}
/**
 * Find the index of the first value which matches a predicate.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The predicate function to apply to the values.
 *
 * @returns The index of the first matching value, or `-1` if no
 *   matching value is found.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { findIndex } from '@lumino/algorithm';
 *
 * interface IAnimal { species: string, name: string };
 *
 * function isCat(value: IAnimal): boolean {
 *   return value.species === 'cat';
 * }
 *
 * let data: IAnimal[] = [
 *   { species: 'dog', name: 'spot' },
 *   { species: 'cat', name: 'fluffy' },
 *   { species: 'alligator', name: 'pocho' }
 * ];
 *
 * findIndex(data, isCat);  // 1
 * ```
 */
function findIndex(object, fn) {
  let index = 0;
  for (const value of object) {
    if (fn(value, index++)) {
      return index - 1;
    }
  }
  return -1;
}
/**
 * Find the minimum value in an iterable.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The 3-way comparison function to apply to the values.
 *   It should return `< 0` if the first value is less than the second.
 *   `0` if the values are equivalent, or `> 0` if the first value is
 *   greater than the second.
 *
 * @returns The minimum value in the iterable. If multiple values are
 *   equivalent to the minimum, the left-most value is returned. If
 *   the iterable is empty, this returns `undefined`.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { min } from '@lumino/algorithm';
 *
 * function numberCmp(a: number, b: number): number {
 *   return a - b;
 * }
 *
 * min([7, 4, 0, 3, 9, 4], numberCmp);  // 0
 * ```
 */
function min(object, fn) {
  let result = undefined;
  for (const value of object) {
    if (result === undefined) {
      result = value;
      continue;
    }
    if (fn(value, result) < 0) {
      result = value;
    }
  }
  return result;
}
/**
 * Find the maximum value in an iterable.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The 3-way comparison function to apply to the values.
 *   It should return `< 0` if the first value is less than the second.
 *   `0` if the values are equivalent, or `> 0` if the first value is
 *   greater than the second.
 *
 * @returns The maximum value in the iterable. If multiple values are
 *   equivalent to the maximum, the left-most value is returned. If
 *   the iterable is empty, this returns `undefined`.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { max } from '@lumino/algorithm';
 *
 * function numberCmp(a: number, b: number): number {
 *   return a - b;
 * }
 *
 * max([7, 4, 0, 3, 9, 4], numberCmp);  // 9
 * ```
 */
function max(object, fn) {
  let result = undefined;
  for (const value of object) {
    if (result === undefined) {
      result = value;
      continue;
    }
    if (fn(value, result) > 0) {
      result = value;
    }
  }
  return result;
}
/**
 * Find the minimum and maximum values in an iterable.
 *
 * @param object - The iterable object to search.
 *
 * @param fn - The 3-way comparison function to apply to the values.
 *   It should return `< 0` if the first value is less than the second.
 *   `0` if the values are equivalent, or `> 0` if the first value is
 *   greater than the second.
 *
 * @returns A 2-tuple of the `[min, max]` values in the iterable. If
 *   multiple values are equivalent, the left-most values are returned.
 *   If the iterable is empty, this returns `undefined`.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { minmax } from '@lumino/algorithm';
 *
 * function numberCmp(a: number, b: number): number {
 *   return a - b;
 * }
 *
 * minmax([7, 4, 0, 3, 9, 4], numberCmp);  // [0, 9]
 * ```
 */
function minmax(object, fn) {
  let empty = true;
  let vmin;
  let vmax;
  for (const value of object) {
    if (empty) {
      vmin = value;
      vmax = value;
      empty = false;
    } else if (fn(value, vmin) < 0) {
      vmin = value;
    } else if (fn(value, vmax) > 0) {
      vmax = value;
    }
  }
  return empty ? undefined : [vmin, vmax];
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an array from an iterable of values.
 *
 * @deprecated
 *
 * @param object - The iterable object of interest.
 *
 * @returns A new array of values from the given object.
 *
 * #### Example
 * ```typescript
 * import { toArray } from '@lumino/algorithm';
 *
 * let stream = [1, 2, 3, 4, 5, 6][Symbol.iterator]();
 *
 * toArray(stream);  // [1, 2, 3, 4, 5, 6];
 * ```
 */
function toArray(object) {
  return Array.from(object);
}
/**
 * Create an object from an iterable of key/value pairs.
 *
 * @param object - The iterable object of interest.
 *
 * @returns A new object mapping keys to values.
 *
 * #### Example
 * ```typescript
 * import { toObject } from '@lumino/algorithm';
 *
 * let data: [string, number][] = [['one', 1], ['two', 2], ['three', 3]];
 *
 * toObject(data);  // { one: 1, two: 2, three: 3 }
 * ```
 */
function toObject(object) {
  const result = {};
  for (const [key, value] of object) {
    result[key] = value;
  }
  return result;
}
/**
 * Invoke a function for each value in an iterable.
 *
 * @deprecated
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The callback function to invoke for each value.
 *
 * #### Notes
 * Iteration can be terminated early by returning `false` from the
 * callback function.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { each } from '@lumino/algorithm';
 *
 * let data = [5, 7, 0, -2, 9];
 *
 * each(data, value => { console.log(value); });
 * ```
 */
function each(object, fn) {
  let index = 0;
  for (const value of object) {
    if (false === fn(value, index++)) {
      return;
    }
  }
}
/**
 * Test whether all values in an iterable satisfy a predicate.
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The predicate function to invoke for each value.
 *
 * @returns `true` if all values pass the test, `false` otherwise.
 *
 * #### Notes
 * Iteration terminates on the first `false` predicate result.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { every } from '@lumino/algorithm';
 *
 * let data = [5, 7, 1];
 *
 * every(data, value => value % 2 === 0);  // false
 * every(data, value => value % 2 === 1);  // true
 * ```
 */
function every(object, fn) {
  let index = 0;
  for (const value of object) {
    if (false === fn(value, index++)) {
      return false;
    }
  }
  return true;
}
/**
 * Test whether any value in an iterable satisfies a predicate.
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The predicate function to invoke for each value.
 *
 * @returns `true` if any value passes the test, `false` otherwise.
 *
 * #### Notes
 * Iteration terminates on the first `true` predicate result.
 *
 * #### Complexity
 * Linear.
 *
 * #### Example
 * ```typescript
 * import { some } from '@lumino/algorithm';
 *
 * let data = [5, 7, 1];
 *
 * some(data, value => value === 7);  // true
 * some(data, value => value === 3);  // false
 * ```
 */
function some(object, fn) {
  let index = 0;
  for (const value of object) {
    if (fn(value, index++)) {
      return true;
    }
  }
  return false;
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Transform the values of an iterable with a mapping function.
 *
 * @param object - The iterable object of interest.
 *
 * @param fn - The mapping function to invoke for each value.
 *
 * @returns An iterator which yields the transformed values.
 *
 * #### Example
 * ```typescript
 * import { map } from '@lumino/algorithm';
 *
 * let data = [1, 2, 3];
 *
 * let stream = map(data, value => value * 2);
 *
 * Array.from(stream);  // [2, 4, 6]
 * ```
 */
function* map(object, fn) {
  let index = 0;
  for (const value of object) {
    yield fn(value, index++);
  }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an iterator of evenly spaced values.
 *
 * @param start - The starting value for the range, inclusive.
 *
 * @param stop - The stopping value for the range, exclusive.
 *
 * @param step - The distance between each value.
 *
 * @returns An iterator which produces evenly spaced values.
 *
 * #### Notes
 * In the single argument form of `range(stop)`, `start` defaults to
 * `0` and `step` defaults to `1`.
 *
 * In the two argument form of `range(start, stop)`, `step` defaults
 * to `1`.
 *
 * #### Example
 * ```typescript
 * import { range } from '@lumino/algorithm';
 *
 * let stream = range(2, 4);
 *
 * Array.from(stream);  // [2, 3]
 * ```
 */
function* range(start, stop, step) {
  if (stop === undefined) {
    stop = start;
    start = 0;
    step = 1;
  } else if (step === undefined) {
    step = 1;
  }
  const length = Private.rangeLength(start, stop, step);
  for (let index = 0; index < length; index++) {
    yield start + step * index;
  }
}
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
  /**
   * Compute the effective length of a range.
   *
   * @param start - The starting value for the range, inclusive.
   *
   * @param stop - The stopping value for the range, exclusive.
   *
   * @param step - The distance between each value.
   *
   * @returns The number of steps need to traverse the range.
   */
  function rangeLength(start, stop, step) {
    if (step === 0) {
      return Infinity;
    }
    if (start > stop && step > 0) {
      return 0;
    }
    if (start < stop && step < 0) {
      return 0;
    }
    return Math.ceil((stop - start) / step);
  }
  Private.rangeLength = rangeLength;
})(Private || (Private = {}));

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
function reduce(object, fn, initial) {
  // Setup the iterator and fetch the first value.
  const it = object[Symbol.iterator]();
  let index = 0;
  let first = it.next();
  // An empty iterator and no initial value is an error.
  if (first.done && initial === undefined) {
    throw new TypeError('Reduce of empty iterable with no initial value.');
  }
  // If the iterator is empty, return the initial value.
  if (first.done) {
    return initial;
  }
  // If the iterator has a single item and no initial value, the
  // reducer is not invoked and the first item is the return value.
  let second = it.next();
  if (second.done && initial === undefined) {
    return first.value;
  }
  // If iterator has a single item and an initial value is provided,
  // the reducer is invoked and that result is the return value.
  if (second.done) {
    return fn(initial, first.value, index++);
  }
  // Setup the initial accumlated value.
  let accumulator;
  if (initial === undefined) {
    accumulator = fn(first.value, second.value, index++);
  } else {
    accumulator = fn(fn(initial, first.value, index++), second.value, index++);
  }
  // Iterate the rest of the values, updating the accumulator.
  let next;
  while (!(next = it.next()).done) {
    accumulator = fn(accumulator, next.value, index++);
  }
  // Return the final accumulated value.
  return accumulator;
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an iterator which repeats a value a number of times.
 *
 * @deprecated
 *
 * @param value - The value to repeat.
 *
 * @param count - The number of times to repeat the value.
 *
 * @returns A new iterator which repeats the specified value.
 *
 * #### Example
 * ```typescript
 * import { repeat } from '@lumino/algorithm';
 *
 * let stream = repeat(7, 3);
 *
 * Array.from(stream);  // [7, 7, 7]
 * ```
 */
function* repeat(value, count) {
  while (0 < count--) {
    yield value;
  }
}
/**
 * Create an iterator which yields a value a single time.
 *
 * @deprecated
 *
 * @param value - The value to wrap in an iterator.
 *
 * @returns A new iterator which yields the value a single time.
 *
 * #### Example
 * ```typescript
 * import { once } from '@lumino/algorithm';
 *
 * let stream = once(7);
 *
 * Array.from(stream);  // [7]
 * ```
 */
function* once(value) {
  yield value;
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Create an iterator for a retroable object.
 *
 * @param object - The retroable or array-like object of interest.
 *
 * @returns An iterator which traverses the object's values in reverse.
 *
 * #### Example
 * ```typescript
 * import { retro } from '@lumino/algorithm';
 *
 * let data = [1, 2, 3, 4, 5, 6];
 *
 * let stream = retro(data);
 *
 * Array.from(stream);  // [6, 5, 4, 3, 2, 1]
 * ```
 */
function* retro(object) {
  if (typeof object.retro === 'function') {
    yield* object.retro();
  } else {
    for (let index = object.length - 1; index > -1; index--) {
      yield object[index];
    }
  }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Topologically sort an iterable of edges.
 *
 * @param edges - The iterable object of edges to sort.
 *   An edge is represented as a 2-tuple of `[fromNode, toNode]`.
 *
 * @returns The topologically sorted array of nodes.
 *
 * #### Notes
 * If a cycle is present in the graph, the cycle will be ignored and
 * the return value will be only approximately sorted.
 *
 * #### Example
 * ```typescript
 * import { topologicSort } from '@lumino/algorithm';
 *
 * let data = [
 *   ['d', 'e'],
 *   ['c', 'd'],
 *   ['a', 'b'],
 *   ['b', 'c']
 * ];
 *
 * topologicSort(data);  // ['a', 'b', 'c', 'd', 'e']
 * ```
 */
function topologicSort(edges) {
  // Setup the shared sorting state.
  let sorted = [];
  let visited = new Set();
  let graph = new Map();
  // Add the edges to the graph.
  for (const edge of edges) {
    addEdge(edge);
  }
  // Visit each node in the graph.
  for (const [k] of graph) {
    visit(k);
  }
  // Return the sorted results.
  return sorted;
  // Add an edge to the graph.
  function addEdge(edge) {
    let [fromNode, toNode] = edge;
    let children = graph.get(toNode);
    if (children) {
      children.push(fromNode);
    } else {
      graph.set(toNode, [fromNode]);
    }
  }
  // Recursively visit the node.
  function visit(node) {
    if (visited.has(node)) {
      return;
    }
    visited.add(node);
    let children = graph.get(node);
    if (children) {
      for (const child of children) {
        visit(child);
      }
    }
    sorted.push(node);
  }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Iterate over an iterable using a stepped increment.
 *
 * @param object - The iterable object of interest.
 *
 * @param step - The distance to step on each iteration. A value
 *   of less than `1` will behave the same as a value of `1`.
 *
 * @returns An iterator which traverses the iterable step-wise.
 *
 * #### Example
 * ```typescript
 * import { stride } from '@lumino/algorithm';
 *
 * let data = [1, 2, 3, 4, 5, 6];
 *
 * let stream = stride(data, 2);
 *
 * Array.from(stream);  // [1, 3, 5];
 * ```
 */
function* stride(object, step) {
  let count = 0;
  for (const value of object) {
    if (0 === count++ % step) {
      yield value;
    }
  }
}

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * The namespace for string-specific algorithms.
 */
var StringExt;
(function (StringExt) {
  /**
   * Find the indices of characters in a source text.
   *
   * @param source - The source text which should be searched.
   *
   * @param query - The characters to locate in the source text.
   *
   * @param start - The index to start the search.
   *
   * @returns The matched indices, or `null` if there is no match.
   *
   * #### Complexity
   * Linear on `sourceText`.
   *
   * #### Notes
   * In order for there to be a match, all of the characters in `query`
   * **must** appear in `source` in the order given by `query`.
   *
   * Characters are matched using strict `===` equality.
   */
  function findIndices(source, query, start = 0) {
    let indices = new Array(query.length);
    for (let i = 0, j = start, n = query.length; i < n; ++i, ++j) {
      j = source.indexOf(query[i], j);
      if (j === -1) {
        return null;
      }
      indices[i] = j;
    }
    return indices;
  }
  StringExt.findIndices = findIndices;
  /**
   * A string matcher which uses a sum-of-squares algorithm.
   *
   * @param source - The source text which should be searched.
   *
   * @param query - The characters to locate in the source text.
   *
   * @param start - The index to start the search.
   *
   * @returns The match result, or `null` if there is no match.
   *   A lower `score` represents a stronger match.
   *
   * #### Complexity
   * Linear on `sourceText`.
   *
   * #### Notes
   * This scoring algorithm uses a sum-of-squares approach to determine
   * the score. In order for there to be a match, all of the characters
   * in `query` **must** appear in `source` in order. The index of each
   * matching character is squared and added to the score. This means
   * that early and consecutive character matches are preferred, while
   * late matches are heavily penalized.
   */
  function matchSumOfSquares(source, query, start = 0) {
    let indices = findIndices(source, query, start);
    if (!indices) {
      return null;
    }
    let score = 0;
    for (let i = 0, n = indices.length; i < n; ++i) {
      let j = indices[i] - start;
      score += j * j;
    }
    return {
      score,
      indices
    };
  }
  StringExt.matchSumOfSquares = matchSumOfSquares;
  /**
   * A string matcher which uses a sum-of-deltas algorithm.
   *
   * @param source - The source text which should be searched.
   *
   * @param query - The characters to locate in the source text.
   *
   * @param start - The index to start the search.
   *
   * @returns The match result, or `null` if there is no match.
   *   A lower `score` represents a stronger match.
   *
   * #### Complexity
   * Linear on `sourceText`.
   *
   * #### Notes
   * This scoring algorithm uses a sum-of-deltas approach to determine
   * the score. In order for there to be a match, all of the characters
   * in `query` **must** appear in `source` in order. The delta between
   * the indices are summed to create the score. This means that groups
   * of matched characters are preferred, while fragmented matches are
   * penalized.
   */
  function matchSumOfDeltas(source, query, start = 0) {
    let indices = findIndices(source, query, start);
    if (!indices) {
      return null;
    }
    let score = 0;
    let last = start - 1;
    for (let i = 0, n = indices.length; i < n; ++i) {
      let j = indices[i];
      score += j - last - 1;
      last = j;
    }
    return {
      score,
      indices
    };
  }
  StringExt.matchSumOfDeltas = matchSumOfDeltas;
  /**
   * Highlight the matched characters of a source text.
   *
   * @param source - The text which should be highlighted.
   *
   * @param indices - The indices of the matched characters. They must
   *   appear in increasing order and must be in bounds of the source.
   *
   * @param fn - The function to apply to the matched chunks.
   *
   * @returns An array of unmatched and highlighted chunks.
   */
  function highlight(source, indices, fn) {
    // Set up the result array.
    let result = [];
    // Set up the counter variables.
    let k = 0;
    let last = 0;
    let n = indices.length;
    // Iterator over each index.
    while (k < n) {
      // Set up the chunk indices.
      let i = indices[k];
      let j = indices[k];
      // Advance the right chunk index until it's non-contiguous.
      while (++k < n && indices[k] === j + 1) {
        j++;
      }
      // Extract the unmatched text.
      if (last < i) {
        result.push(source.slice(last, i));
      }
      // Extract and highlight the matched text.
      if (i < j + 1) {
        result.push(fn(source.slice(i, j + 1)));
      }
      // Update the last visited index.
      last = j + 1;
    }
    // Extract any remaining unmatched text.
    if (last < source.length) {
      result.push(source.slice(last));
    }
    // Return the highlighted result.
    return result;
  }
  StringExt.highlight = highlight;
  /**
   * A 3-way string comparison function.
   *
   * @param a - The first string of interest.
   *
   * @param b - The second string of interest.
   *
   * @returns `-1` if `a < b`, else `1` if `a > b`, else `0`.
   */
  function cmp(a, b) {
    return a < b ? -1 : a > b ? 1 : 0;
  }
  StringExt.cmp = cmp;
})(StringExt || (StringExt = {}));

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * Take a fixed number of items from an iterable.
 *
 * @param object - The iterable object of interest.
 *
 * @param count - The number of items to take from the iterable.
 *
 * @returns An iterator which yields the specified number of items
 *   from the source iterable.
 *
 * #### Notes
 * The returned iterator will exhaust early if the source iterable
 * contains an insufficient number of items.
 *
 * #### Example
 * ```typescript
 * import { take } from '@lumino/algorithm';
 *
 * let stream = take([5, 4, 3, 2, 1, 0, -1], 3);
 *
 * Array.from(stream);  // [5, 4, 3]
 * ```
 */
function* take(object, count) {
  if (count < 1) {
    return;
  }
  const it = object[Symbol.iterator]();
  let item;
  while (0 < count-- && !(item = it.next()).done) {
    yield item.value;
  }
}

// Copyright (c) Jupyter Development Team.
/**
 * Iterate several iterables in lockstep.
 *
 * @param objects - The iterable objects of interest.
 *
 * @returns An iterator which yields successive tuples of values where
 *   each value is taken in turn from the provided iterables. It will
 *   be as long as the shortest provided iterable.
 *
 * #### Example
 * ```typescript
 * import { zip } from '@lumino/algorithm';
 *
 * let data1 = [1, 2, 3];
 * let data2 = [4, 5, 6];
 *
 * let stream = zip(data1, data2);
 *
 * Array.from(stream);  // [[1, 4], [2, 5], [3, 6]]
 * ```
 */
function* zip(...objects) {
  const iters = objects.map(obj => obj[Symbol.iterator]());
  let tuple = iters.map(it => it.next());
  for (; every(tuple, item => !item.done); tuple = iters.map(it => it.next())) {
    yield tuple.map(item => item.value);
  }
}


/***/ }),

/***/ "./node_modules/@lumino/coreutils/dist/index.js":
/*!******************************************************!*\
  !*** ./node_modules/@lumino/coreutils/dist/index.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports) {

(function (global, factory) {
   true ? factory(exports) : 0;
})(this, function (exports) {
  'use strict';

  // Copyright (c) Jupyter Development Team.
  // Distributed under the terms of the Modified BSD License.
  /*-----------------------------------------------------------------------------
  | Copyright (c) 2014-2017, PhosphorJS Contributors
  |
  | Distributed under the terms of the BSD 3-Clause License.
  |
  | The full license is in the file LICENSE, distributed with this software.
  |----------------------------------------------------------------------------*/
  /**
   * The namespace for JSON-specific functions.
   */
  exports.JSONExt = void 0;
  (function (JSONExt) {
    /**
     * A shared frozen empty JSONObject
     */
    JSONExt.emptyObject = Object.freeze({});
    /**
     * A shared frozen empty JSONArray
     */
    JSONExt.emptyArray = Object.freeze([]);
    /**
     * Test whether a JSON value is a primitive.
     *
     * @param value - The JSON value of interest.
     *
     * @returns `true` if the value is a primitive,`false` otherwise.
     */
    function isPrimitive(value) {
      return value === null || typeof value === 'boolean' || typeof value === 'number' || typeof value === 'string';
    }
    JSONExt.isPrimitive = isPrimitive;
    function isArray(value) {
      return Array.isArray(value);
    }
    JSONExt.isArray = isArray;
    function isObject(value) {
      return !isPrimitive(value) && !isArray(value);
    }
    JSONExt.isObject = isObject;
    /**
     * Compare two JSON values for deep equality.
     *
     * @param first - The first JSON value of interest.
     *
     * @param second - The second JSON value of interest.
     *
     * @returns `true` if the values are equivalent, `false` otherwise.
     */
    function deepEqual(first, second) {
      // Check referential and primitive equality first.
      if (first === second) {
        return true;
      }
      // If one is a primitive, the `===` check ruled out the other.
      if (isPrimitive(first) || isPrimitive(second)) {
        return false;
      }
      // Test whether they are arrays.
      let a1 = isArray(first);
      let a2 = isArray(second);
      // Bail if the types are different.
      if (a1 !== a2) {
        return false;
      }
      // If they are both arrays, compare them.
      if (a1 && a2) {
        return deepArrayEqual(first, second);
      }
      // At this point, they must both be objects.
      return deepObjectEqual(first, second);
    }
    JSONExt.deepEqual = deepEqual;
    /**
     * Create a deep copy of a JSON value.
     *
     * @param value - The JSON value to copy.
     *
     * @returns A deep copy of the given JSON value.
     */
    function deepCopy(value) {
      // Do nothing for primitive values.
      if (isPrimitive(value)) {
        return value;
      }
      // Deep copy an array.
      if (isArray(value)) {
        return deepArrayCopy(value);
      }
      // Deep copy an object.
      return deepObjectCopy(value);
    }
    JSONExt.deepCopy = deepCopy;
    /**
     * Compare two JSON arrays for deep equality.
     */
    function deepArrayEqual(first, second) {
      // Check referential equality first.
      if (first === second) {
        return true;
      }
      // Test the arrays for equal length.
      if (first.length !== second.length) {
        return false;
      }
      // Compare the values for equality.
      for (let i = 0, n = first.length; i < n; ++i) {
        if (!deepEqual(first[i], second[i])) {
          return false;
        }
      }
      // At this point, the arrays are equal.
      return true;
    }
    /**
     * Compare two JSON objects for deep equality.
     */
    function deepObjectEqual(first, second) {
      // Check referential equality first.
      if (first === second) {
        return true;
      }
      // Check for the first object's keys in the second object.
      for (let key in first) {
        if (first[key] !== undefined && !(key in second)) {
          return false;
        }
      }
      // Check for the second object's keys in the first object.
      for (let key in second) {
        if (second[key] !== undefined && !(key in first)) {
          return false;
        }
      }
      // Compare the values for equality.
      for (let key in first) {
        // Get the values.
        let firstValue = first[key];
        let secondValue = second[key];
        // If both are undefined, ignore the key.
        if (firstValue === undefined && secondValue === undefined) {
          continue;
        }
        // If only one value is undefined, the objects are not equal.
        if (firstValue === undefined || secondValue === undefined) {
          return false;
        }
        // Compare the values.
        if (!deepEqual(firstValue, secondValue)) {
          return false;
        }
      }
      // At this point, the objects are equal.
      return true;
    }
    /**
     * Create a deep copy of a JSON array.
     */
    function deepArrayCopy(value) {
      let result = new Array(value.length);
      for (let i = 0, n = value.length; i < n; ++i) {
        result[i] = deepCopy(value[i]);
      }
      return result;
    }
    /**
     * Create a deep copy of a JSON object.
     */
    function deepObjectCopy(value) {
      let result = {};
      for (let key in value) {
        // Ignore undefined values.
        let subvalue = value[key];
        if (subvalue === undefined) {
          continue;
        }
        result[key] = deepCopy(subvalue);
      }
      return result;
    }
  })(exports.JSONExt || (exports.JSONExt = {}));

  // Copyright (c) Jupyter Development Team.
  // Distributed under the terms of the Modified BSD License.
  /*-----------------------------------------------------------------------------
  | Copyright (c) 2014-2017, PhosphorJS Contributors
  |
  | Distributed under the terms of the BSD 3-Clause License.
  |
  | The full license is in the file LICENSE, distributed with this software.
  |----------------------------------------------------------------------------*/
  /**
   * An object which stores MIME data for general application use.
   *
   * #### Notes
   * This class does not attempt to enforce "correctness" of MIME types
   * and their associated data. Since this class is designed to transfer
   * arbitrary data and objects within the same application, it assumes
   * that the user provides correct and accurate data.
   */
  class MimeData {
    constructor() {
      this._types = [];
      this._values = [];
    }
    /**
     * Get an array of the MIME types contained within the dataset.
     *
     * @returns A new array of the MIME types, in order of insertion.
     */
    types() {
      return this._types.slice();
    }
    /**
     * Test whether the dataset has an entry for the given type.
     *
     * @param mime - The MIME type of interest.
     *
     * @returns `true` if the dataset contains a value for the given
     *   MIME type, `false` otherwise.
     */
    hasData(mime) {
      return this._types.indexOf(mime) !== -1;
    }
    /**
     * Get the data value for the given MIME type.
     *
     * @param mime - The MIME type of interest.
     *
     * @returns The value for the given MIME type, or `undefined` if
     *   the dataset does not contain a value for the type.
     */
    getData(mime) {
      let i = this._types.indexOf(mime);
      return i !== -1 ? this._values[i] : undefined;
    }
    /**
     * Set the data value for the given MIME type.
     *
     * @param mime - The MIME type of interest.
     *
     * @param data - The data value for the given MIME type.
     *
     * #### Notes
     * This will overwrite any previous entry for the MIME type.
     */
    setData(mime, data) {
      this.clearData(mime);
      this._types.push(mime);
      this._values.push(data);
    }
    /**
     * Remove the data entry for the given MIME type.
     *
     * @param mime - The MIME type of interest.
     *
     * #### Notes
     * This is a no-op if there is no entry for the given MIME type.
     */
    clearData(mime) {
      let i = this._types.indexOf(mime);
      if (i !== -1) {
        this._types.splice(i, 1);
        this._values.splice(i, 1);
      }
    }
    /**
     * Remove all data entries from the dataset.
     */
    clear() {
      this._types.length = 0;
      this._values.length = 0;
    }
  }

  // Copyright (c) Jupyter Development Team.
  // Distributed under the terms of the Modified BSD License.
  /*-----------------------------------------------------------------------------
  | Copyright (c) 2014-2017, PhosphorJS Contributors
  |
  | Distributed under the terms of the BSD 3-Clause License.
  |
  | The full license is in the file LICENSE, distributed with this software.
  |----------------------------------------------------------------------------*/
  /**
   * A class which wraps a promise into a delegate object.
   *
   * #### Notes
   * This class is useful when the logic to resolve or reject a promise
   * cannot be defined at the point where the promise is created.
   */
  class PromiseDelegate {
    /**
     * Construct a new promise delegate.
     */
    constructor() {
      this.promise = new Promise((resolve, reject) => {
        this._resolve = resolve;
        this._reject = reject;
      });
    }
    /**
     * Resolve the wrapped promise with the given value.
     *
     * @param value - The value to use for resolving the promise.
     */
    resolve(value) {
      let resolve = this._resolve;
      resolve(value);
    }
    /**
     * Reject the wrapped promise with the given value.
     *
     * @reason - The reason for rejecting the promise.
     */
    reject(reason) {
      let reject = this._reject;
      reject(reason);
    }
  }

  // Copyright (c) Jupyter Development Team.
  // Distributed under the terms of the Modified BSD License.
  /*-----------------------------------------------------------------------------
  | Copyright (c) 2014-2017, PhosphorJS Contributors
  |
  | Distributed under the terms of the BSD 3-Clause License.
  |
  | The full license is in the file LICENSE, distributed with this software.
  |----------------------------------------------------------------------------*/
  /**
   * A runtime object which captures compile-time type information.
   *
   * #### Notes
   * A token captures the compile-time type of an interface or class in
   * an object which can be used at runtime in a type-safe fashion.
   */
  class Token {
    /**
     * Construct a new token.
     *
     * @param name - A human readable name for the token.
     * @param description - Token purpose description for documentation.
     */
    constructor(name, description) {
      this.name = name;
      this.description = description !== null && description !== void 0 ? description : '';
      this._tokenStructuralPropertyT = null;
    }
  }

  // Copyright (c) Jupyter Development Team.
  // Distributed under the terms of the Modified BSD License.
  /*-----------------------------------------------------------------------------
  | Copyright (c) 2014-2017, PhosphorJS Contributors
  |
  | Distributed under the terms of the BSD 3-Clause License.
  |
  | The full license is in the file LICENSE, distributed with this software.
  |----------------------------------------------------------------------------*/
  // Fallback
  function fallbackRandomValues(buffer) {
    let value = 0;
    for (let i = 0, n = buffer.length; i < n; ++i) {
      if (i % 4 === 0) {
        value = Math.random() * 0xffffffff >>> 0;
      }
      buffer[i] = value & 0xff;
      value >>>= 8;
    }
  }

  // Copyright (c) Jupyter Development Team.
  /**
   * The namespace for random number related functionality.
   */
  exports.Random = void 0;
  (function (Random) {
    /**
     * A function which generates random bytes.
     *
     * @param buffer - The `Uint8Array` to fill with random bytes.
     *
     * #### Notes
     * A cryptographically strong random number generator will be used if
     * available. Otherwise, `Math.random` will be used as a fallback for
     * randomness.
     *
     * The following RNGs are supported, listed in order of precedence:
     *   - `window.crypto.getRandomValues`
     *   - `window.msCrypto.getRandomValues`
     *   - `require('crypto').randomFillSync
     *   - `require('crypto').randomBytes
     *   - `Math.random`
     */
    Random.getRandomValues = (() => {
      // Look up the crypto module if available.
      const crypto = typeof window !== 'undefined' && (window.crypto || window.msCrypto) || null;
      // Modern browsers and IE 11
      if (crypto && typeof crypto.getRandomValues === 'function') {
        return function getRandomValues(buffer) {
          return crypto.getRandomValues(buffer);
        };
      }
      // Fallback
      return fallbackRandomValues;
    })();
  })(exports.Random || (exports.Random = {}));

  // Copyright (c) Jupyter Development Team.
  // Distributed under the terms of the Modified BSD License.
  /*-----------------------------------------------------------------------------
  | Copyright (c) 2014-2017, PhosphorJS Contributors
  |
  | Distributed under the terms of the BSD 3-Clause License.
  |
  | The full license is in the file LICENSE, distributed with this software.
  |----------------------------------------------------------------------------*/
  /**
   * A function which creates a function that generates UUID v4 identifiers.
   *
   * @returns A new function that creates a UUID v4 string.
   *
   * #### Notes
   * This implementation complies with RFC 4122.
   *
   * This uses `Random.getRandomValues()` for random bytes, which in
   * turn will use the underlying `crypto` module of the platform if
   * it is available. The fallback for randomness is `Math.random`.
   */
  function uuid4Factory(getRandomValues) {
    // Create a 16 byte array to hold the random values.
    const bytes = new Uint8Array(16);
    // Create a look up table from bytes to hex strings.
    const lut = new Array(256);
    // Pad the single character hex digits with a leading zero.
    for (let i = 0; i < 16; ++i) {
      lut[i] = '0' + i.toString(16);
    }
    // Populate the rest of the hex digits.
    for (let i = 16; i < 256; ++i) {
      lut[i] = i.toString(16);
    }
    // Return a function which generates the UUID.
    return function uuid4() {
      // Get a new batch of random values.
      getRandomValues(bytes);
      // Set the UUID version number to 4.
      bytes[6] = 0x40 | bytes[6] & 0x0f;
      // Set the clock sequence bit to the RFC spec.
      bytes[8] = 0x80 | bytes[8] & 0x3f;
      // Assemble the UUID string.
      return lut[bytes[0]] + lut[bytes[1]] + lut[bytes[2]] + lut[bytes[3]] + '-' + lut[bytes[4]] + lut[bytes[5]] + '-' + lut[bytes[6]] + lut[bytes[7]] + '-' + lut[bytes[8]] + lut[bytes[9]] + '-' + lut[bytes[10]] + lut[bytes[11]] + lut[bytes[12]] + lut[bytes[13]] + lut[bytes[14]] + lut[bytes[15]];
    };
  }

  // Copyright (c) Jupyter Development Team.
  /**
   * The namespace for UUID related functionality.
   */
  exports.UUID = void 0;
  (function (UUID) {
    /**
     * A function which generates UUID v4 identifiers.
     *
     * @returns A new UUID v4 string.
     *
     * #### Notes
     * This implementation complies with RFC 4122.
     *
     * This uses `Random.getRandomValues()` for random bytes, which in
     * turn will use the underlying `crypto` module of the platform if
     * it is available. The fallback for randomness is `Math.random`.
     */
    UUID.uuid4 = uuid4Factory(exports.Random.getRandomValues);
  })(exports.UUID || (exports.UUID = {}));
  exports.MimeData = MimeData;
  exports.PromiseDelegate = PromiseDelegate;
  exports.Token = Token;
});

/***/ }),

/***/ "./node_modules/@lumino/disposable/dist/index.es6.js":
/*!***********************************************************!*\
  !*** ./node_modules/@lumino/disposable/dist/index.es6.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DisposableDelegate": () => (/* binding */ DisposableDelegate),
/* harmony export */   "DisposableSet": () => (/* binding */ DisposableSet),
/* harmony export */   "ObservableDisposableDelegate": () => (/* binding */ ObservableDisposableDelegate),
/* harmony export */   "ObservableDisposableSet": () => (/* binding */ ObservableDisposableSet)
/* harmony export */ });
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");


// Copyright (c) Jupyter Development Team.
/**
 * A disposable object which delegates to a callback function.
 */
class DisposableDelegate {
  /**
   * Construct a new disposable delegate.
   *
   * @param fn - The callback function to invoke on dispose.
   */
  constructor(fn) {
    this._fn = fn;
  }
  /**
   * Test whether the delegate has been disposed.
   */
  get isDisposed() {
    return !this._fn;
  }
  /**
   * Dispose of the delegate and invoke the callback function.
   */
  dispose() {
    if (!this._fn) {
      return;
    }
    let fn = this._fn;
    this._fn = null;
    fn();
  }
}
/**
 * An observable disposable object which delegates to a callback function.
 */
class ObservableDisposableDelegate extends DisposableDelegate {
  constructor() {
    super(...arguments);
    this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
  }
  /**
   * A signal emitted when the delegate is disposed.
   */
  get disposed() {
    return this._disposed;
  }
  /**
   * Dispose of the delegate and invoke the callback function.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    super.dispose();
    this._disposed.emit(undefined);
    _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
  }
}
/**
 * An object which manages a collection of disposable items.
 */
class DisposableSet {
  constructor() {
    this._isDisposed = false;
    this._items = new Set();
  }
  /**
   * Test whether the set has been disposed.
   */
  get isDisposed() {
    return this._isDisposed;
  }
  /**
   * Dispose of the set and the items it contains.
   *
   * #### Notes
   * Items are disposed in the order they are added to the set.
   */
  dispose() {
    if (this._isDisposed) {
      return;
    }
    this._isDisposed = true;
    this._items.forEach(item => {
      item.dispose();
    });
    this._items.clear();
  }
  /**
   * Test whether the set contains a specific item.
   *
   * @param item - The item of interest.
   *
   * @returns `true` if the set contains the item, `false` otherwise.
   */
  contains(item) {
    return this._items.has(item);
  }
  /**
   * Add a disposable item to the set.
   *
   * @param item - The item to add to the set.
   *
   * #### Notes
   * If the item is already contained in the set, this is a no-op.
   */
  add(item) {
    this._items.add(item);
  }
  /**
   * Remove a disposable item from the set.
   *
   * @param item - The item to remove from the set.
   *
   * #### Notes
   * If the item is not contained in the set, this is a no-op.
   */
  remove(item) {
    this._items.delete(item);
  }
  /**
   * Remove all items from the set.
   */
  clear() {
    this._items.clear();
  }
}
/**
 * The namespace for the `DisposableSet` class statics.
 */
(function (DisposableSet) {
  /**
   * Create a disposable set from an iterable of items.
   *
   * @param items - The iterable object of interest.
   *
   * @returns A new disposable initialized with the given items.
   */
  function from(items) {
    let set = new DisposableSet();
    for (const item of items) {
      set.add(item);
    }
    return set;
  }
  DisposableSet.from = from;
})(DisposableSet || (DisposableSet = {}));
/**
 * An observable object which manages a collection of disposable items.
 */
class ObservableDisposableSet extends DisposableSet {
  constructor() {
    super(...arguments);
    this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
  }
  /**
   * A signal emitted when the set is disposed.
   */
  get disposed() {
    return this._disposed;
  }
  /**
   * Dispose of the set and the items it contains.
   *
   * #### Notes
   * Items are disposed in the order they are added to the set.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    super.dispose();
    this._disposed.emit(undefined);
    _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
  }
}
/**
 * The namespace for the `ObservableDisposableSet` class statics.
 */
(function (ObservableDisposableSet) {
  /**
   * Create an observable disposable set from an iterable of items.
   *
   * @param items - The iterable object of interest.
   *
   * @returns A new disposable initialized with the given items.
   */
  function from(items) {
    let set = new ObservableDisposableSet();
    for (const item of items) {
      set.add(item);
    }
    return set;
  }
  ObservableDisposableSet.from = from;
})(ObservableDisposableSet || (ObservableDisposableSet = {}));


/***/ }),

/***/ "./node_modules/@lumino/polling/dist/index.es6.js":
/*!********************************************************!*\
  !*** ./node_modules/@lumino/polling/dist/index.es6.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Debouncer": () => (/* binding */ Debouncer),
/* harmony export */   "Poll": () => (/* binding */ Poll),
/* harmony export */   "RateLimiter": () => (/* binding */ RateLimiter),
/* harmony export */   "Throttler": () => (/* binding */ Throttler)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");



// Copyright (c) Jupyter Development Team.
/**
 * A class that wraps an asynchronous function to poll at a regular interval
 * with exponential increases to the interval length if the poll fails.
 *
 * @typeparam T - The resolved type of the factory's promises.
 * Defaults to `any`.
 *
 * @typeparam U - The rejected type of the factory's promises.
 * Defaults to `any`.
 *
 * @typeparam V - An optional type to extend the phases supported by a poll.
 * Defaults to `standby`, which already exists in the `Phase` type.
 */
class Poll {
  /**
   * Instantiate a new poll with exponential backoff in case of failure.
   *
   * @param options - The poll instantiation options.
   */
  constructor(options) {
    var _a;
    this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
    this._lingered = 0;
    this._tick = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
    this._ticked = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
    this._factory = options.factory;
    this._linger = (_a = options.linger) !== null && _a !== void 0 ? _a : Private.DEFAULT_LINGER;
    this._standby = options.standby || Private.DEFAULT_STANDBY;
    this._state = {
      ...Private.DEFAULT_STATE,
      timestamp: new Date().getTime()
    };
    // Normalize poll frequency `max` to be the greater of
    // default `max`, `options.frequency.max`, or `options.frequency.interval`.
    const frequency = options.frequency || {};
    const max = Math.max(frequency.interval || 0, frequency.max || 0, Private.DEFAULT_FREQUENCY.max);
    this.frequency = {
      ...Private.DEFAULT_FREQUENCY,
      ...frequency,
      ...{
        max
      }
    };
    this.name = options.name || Private.DEFAULT_NAME;
    if ('auto' in options ? options.auto : true) {
      setTimeout(() => this.start());
    }
  }
  /**
   * A signal emitted when the poll is disposed.
   */
  get disposed() {
    return this._disposed;
  }
  /**
   * The polling frequency parameters.
   */
  get frequency() {
    return this._frequency;
  }
  set frequency(frequency) {
    if (this.isDisposed || _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.JSONExt.deepEqual(frequency, this.frequency || {})) {
      return;
    }
    let {
      backoff,
      interval,
      max
    } = frequency;
    interval = Math.round(interval);
    max = Math.round(max);
    if (typeof backoff === 'number' && backoff < 1) {
      throw new Error('Poll backoff growth factor must be at least 1');
    }
    if ((interval < 0 || interval > max) && interval !== Poll.NEVER) {
      throw new Error('Poll interval must be between 0 and max');
    }
    if (max > Poll.MAX_INTERVAL && max !== Poll.NEVER) {
      throw new Error(`Max interval must be less than ${Poll.MAX_INTERVAL}`);
    }
    this._frequency = {
      backoff,
      interval,
      max
    };
  }
  /**
   * Whether the poll is disposed.
   */
  get isDisposed() {
    return this.state.phase === 'disposed';
  }
  /**
   * Indicates when the poll switches to standby.
   */
  get standby() {
    return this._standby;
  }
  set standby(standby) {
    if (this.isDisposed || this.standby === standby) {
      return;
    }
    this._standby = standby;
  }
  /**
   * The poll state, which is the content of the current poll tick.
   */
  get state() {
    return this._state;
  }
  /**
   * A promise that resolves when the poll next ticks.
   */
  get tick() {
    return this._tick.promise;
  }
  /**
   * A signal emitted when the poll ticks and fires off a new request.
   */
  get ticked() {
    return this._ticked;
  }
  /**
   * Return an async iterator that yields every tick.
   */
  async *[Symbol.asyncIterator]() {
    while (!this.isDisposed) {
      yield this.state;
      await this.tick.catch(() => undefined);
    }
  }
  /**
   * Dispose the poll.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this._state = {
      ...Private.DISPOSED_STATE,
      timestamp: new Date().getTime()
    };
    this._tick.promise.catch(_ => undefined);
    this._tick.reject(new Error(`Poll (${this.name}) is disposed.`));
    this._disposed.emit(undefined);
    _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);
  }
  /**
   * Refreshes the poll. Schedules `refreshed` tick if necessary.
   *
   * @returns A promise that resolves after tick is scheduled and never rejects.
   *
   * #### Notes
   * The returned promise resolves after the tick is scheduled, but before
   * the polling action is run. To wait until after the poll action executes,
   * await the `poll.tick` promise: `await poll.refresh(); await poll.tick;`
   */
  refresh() {
    return this.schedule({
      cancel: ({
        phase
      }) => phase === 'refreshed',
      interval: Poll.IMMEDIATE,
      phase: 'refreshed'
    });
  }
  /**
   * Schedule the next poll tick.
   *
   * @param next - The next poll state data to schedule. Defaults to standby.
   *
   * @param next.cancel - Cancels state transition if function returns `true`.
   *
   * @returns A promise that resolves when the next poll state is active.
   *
   * #### Notes
   * This method is not meant to be invoked by user code typically. It is public
   * to allow poll instances to be composed into classes that schedule ticks.
   */
  async schedule(next = {}) {
    if (this.isDisposed) {
      return;
    }
    // Check if the phase transition should be canceled.
    if (next.cancel && next.cancel(this.state)) {
      return;
    }
    // Update poll state.
    const pending = this._tick;
    const scheduled = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
    const state = {
      interval: this.frequency.interval,
      payload: null,
      phase: 'standby',
      timestamp: new Date().getTime(),
      ...next
    };
    this._state = state;
    this._tick = scheduled;
    // Clear the schedule if possible.
    clearTimeout(this._timeout);
    // Emit ticked signal, resolve pending promise, and await its settlement.
    this._ticked.emit(this.state);
    pending.resolve(this);
    await pending.promise;
    if (state.interval === Poll.NEVER) {
      this._timeout = undefined;
      return;
    }
    // Schedule next execution and cache its timeout handle.
    const execute = () => {
      if (this.isDisposed || this.tick !== scheduled.promise) {
        return;
      }
      this._execute();
    };
    // Cache the handle in case it needs to be unscheduled.
    this._timeout = setTimeout(execute, state.interval);
  }
  /**
   * Starts the poll. Schedules `started` tick if necessary.
   *
   * @returns A promise that resolves after tick is scheduled and never rejects.
   */
  start() {
    return this.schedule({
      cancel: ({
        phase
      }) => phase !== 'constructed' && phase !== 'standby' && phase !== 'stopped',
      interval: Poll.IMMEDIATE,
      phase: 'started'
    });
  }
  /**
   * Stops the poll. Schedules `stopped` tick if necessary.
   *
   * @returns A promise that resolves after tick is scheduled and never rejects.
   */
  stop() {
    return this.schedule({
      cancel: ({
        phase
      }) => phase === 'stopped',
      interval: Poll.NEVER,
      phase: 'stopped'
    });
  }
  /**
   * Whether the poll is hidden.
   *
   * #### Notes
   * This property is only relevant in a browser context.
   */
  get hidden() {
    return Private.hidden;
  }
  /**
   * Execute a new poll factory promise or stand by if necessary.
   */
  _execute() {
    let standby = typeof this.standby === 'function' ? this.standby() : this.standby;
    // Check if execution should proceed, linger, or stand by.
    if (standby === 'never') {
      standby = false;
    } else if (standby === 'when-hidden') {
      if (this.hidden) {
        standby = ++this._lingered > this._linger;
      } else {
        this._lingered = 0;
        standby = false;
      }
    }
    // If in standby mode schedule next tick without calling the factory.
    if (standby) {
      void this.schedule();
      return;
    }
    const pending = this.tick;
    this._factory(this.state).then(resolved => {
      if (this.isDisposed || this.tick !== pending) {
        return;
      }
      void this.schedule({
        payload: resolved,
        phase: this.state.phase === 'rejected' ? 'reconnected' : 'resolved'
      });
    }).catch(rejected => {
      if (this.isDisposed || this.tick !== pending) {
        return;
      }
      void this.schedule({
        interval: Private.sleep(this.frequency, this.state),
        payload: rejected,
        phase: 'rejected'
      });
    });
  }
}
/**
 * A namespace for `Poll` types, interfaces, and statics.
 */
(function (Poll) {
  /**
   * An interval value in ms that indicates the poll should tick immediately.
   */
  Poll.IMMEDIATE = 0;
  /**
   * Delays are 32-bit integers in many browsers so intervals need to be capped.
   *
   * #### Notes
   * https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/setTimeout#Maximum_delay_value
   */
  Poll.MAX_INTERVAL = 2147483647;
  /**
   * An interval value that indicates the poll should never tick.
   */
  Poll.NEVER = Infinity;
})(Poll || (Poll = {}));
/**
 * A namespace for private module data.
 */
var Private;
(function (Private) {
  /**
   * The default backoff growth rate if `backoff` is `true`.
   */
  Private.DEFAULT_BACKOFF = 3;
  /**
   * The default polling frequency.
   */
  Private.DEFAULT_FREQUENCY = {
    backoff: true,
    interval: 1000,
    max: 30 * 1000
  };
  /**
   * The default number of times to `linger` when a poll is hidden.
   */
  Private.DEFAULT_LINGER = 1;
  /**
   * The default poll name.
   */
  Private.DEFAULT_NAME = 'unknown';
  /**
   * The default poll standby behavior.
   */
  Private.DEFAULT_STANDBY = 'when-hidden';
  /**
   * The first poll tick state's default values superseded in constructor.
   */
  Private.DEFAULT_STATE = {
    interval: Poll.NEVER,
    payload: null,
    phase: 'constructed',
    timestamp: new Date(0).getTime()
  };
  /**
   * The disposed tick state values.
   */
  Private.DISPOSED_STATE = {
    interval: Poll.NEVER,
    payload: null,
    phase: 'disposed',
    timestamp: new Date(0).getTime()
  };
  /**
   * Returns the number of milliseconds to sleep before the next tick.
   *
   * @param frequency - The poll's base frequency.
   * @param last - The poll's last tick.
   */
  function sleep(frequency, last) {
    const {
      backoff,
      interval,
      max
    } = frequency;
    if (interval === Poll.NEVER) {
      return interval;
    }
    const growth = backoff === true ? Private.DEFAULT_BACKOFF : backoff === false ? 1 : backoff;
    const random = getRandomIntInclusive(interval, last.interval * growth);
    return Math.min(max, random);
  }
  Private.sleep = sleep;
  /**
   * Keep track of whether the document is hidden. This flag is only relevant in
   * a browser context.
   *
   * Listen to `visibilitychange` event to set the `hidden` flag.
   *
   * Listening to `pagehide` is also necessary because Safari support for
   * `visibilitychange` events is partial, cf.
   * https://developer.mozilla.org/docs/Web/API/Document/visibilitychange_event
   */
  Private.hidden = (() => {
    if (typeof document === 'undefined') {
      return false;
    }
    document.addEventListener('visibilitychange', () => {
      Private.hidden = document.visibilityState === 'hidden';
    });
    document.addEventListener('pagehide', () => {
      Private.hidden = document.visibilityState === 'hidden';
    });
    return document.visibilityState === 'hidden';
  })();
  /**
   * Get a random integer between min and max, inclusive of both.
   *
   * #### Notes
   * From
   * https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Math/random#Getting_a_random_integer_between_two_values_inclusive
   *
   * From the MDN page: It might be tempting to use Math.round() to accomplish
   * that, but doing so would cause your random numbers to follow a non-uniform
   * distribution, which may not be acceptable for your needs.
   */
  function getRandomIntInclusive(min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min + 1)) + min;
  }
})(Private || (Private = {}));

// Copyright (c) Jupyter Development Team.
/**
 * A base class to implement rate limiters with different invocation strategies.
 *
 * @typeparam T - The resolved type of the underlying function.
 *
 * @typeparam U - The rejected type of the underlying function.
 *
 * @typeparam V - Arguments for the underlying function.
 */
class RateLimiter {
  /**
   * Instantiate a rate limiter.
   *
   * @param fn - The function to rate limit.
   *
   * @param limit - The rate limit; defaults to 500ms.
   */
  constructor(fn, limit = 500) {
    /**
     * Arguments for the underlying function.
     */
    this.args = undefined;
    /**
     * A promise that resolves on each successful invocation.
     */
    this.payload = null;
    this.limit = limit;
    this.poll = new Poll({
      auto: false,
      factory: async () => {
        const {
          args
        } = this;
        this.args = undefined;
        return fn(...args);
      },
      frequency: {
        backoff: false,
        interval: Poll.NEVER,
        max: Poll.NEVER
      },
      standby: 'never'
    });
    this.payload = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
    this.poll.ticked.connect((_, state) => {
      const {
        payload
      } = this;
      if (state.phase === 'resolved') {
        this.payload = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
        payload.resolve(state.payload);
        return;
      }
      if (state.phase === 'rejected' || state.phase === 'stopped') {
        this.payload = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
        payload.promise.catch(_ => undefined);
        payload.reject(state.payload);
        return;
      }
    }, this);
  }
  /**
   * Whether the rate limiter is disposed.
   */
  get isDisposed() {
    return this.payload === null;
  }
  /**
   * Disposes the rate limiter.
   */
  dispose() {
    if (this.isDisposed) {
      return;
    }
    this.args = undefined;
    this.payload = null;
    this.poll.dispose();
  }
  /**
   * Stop the function if it is mid-flight.
   */
  async stop() {
    return this.poll.stop();
  }
}
/**
 * Wraps and debounces a function that can be called multiple times and only
 * executes the underlying function one `interval` after the last invocation.
 *
 * @typeparam T - The resolved type of the underlying function. Defaults to any.
 *
 * @typeparam U - The rejected type of the underlying function. Defaults to any.
 *
 * @typeparam V - Arguments for the underlying function. Defaults to any[].
 */
class Debouncer extends RateLimiter {
  /**
   * Invokes the function and only executes after rate limit has elapsed.
   * Each invocation resets the timer.
   */
  invoke(...args) {
    this.args = args;
    void this.poll.schedule({
      interval: this.limit,
      phase: 'invoked'
    });
    return this.payload.promise;
  }
}
/**
 * Wraps and throttles a function that can be called multiple times and only
 * executes the underlying function once per `interval`.
 *
 * @typeparam T - The resolved type of the underlying function. Defaults to any.
 *
 * @typeparam U - The rejected type of the underlying function. Defaults to any.
 *
 * @typeparam V - Arguments for the underlying function. Defaults to any[].
 */
class Throttler extends RateLimiter {
  /**
   * Instantiate a throttler.
   *
   * @param fn - The function being throttled.
   *
   * @param options - Throttling configuration or throttling limit in ms.
   *
   * #### Notes
   * The `edge` defaults to `leading`; the `limit` defaults to `500`.
   */
  constructor(fn, options) {
    super(fn, typeof options === 'number' ? options : options && options.limit);
    this._trailing = false;
    if (typeof options !== 'number' && options && options.edge === 'trailing') {
      this._trailing = true;
    }
    this._interval = this._trailing ? this.limit : Poll.IMMEDIATE;
  }
  /**
   * Throttles function invocations if one is currently in flight.
   */
  invoke(...args) {
    const idle = this.poll.state.phase !== 'invoked';
    if (idle || this._trailing) {
      this.args = args;
    }
    if (idle) {
      void this.poll.schedule({
        interval: this._interval,
        phase: 'invoked'
      });
    }
    return this.payload.promise;
  }
}


/***/ }),

/***/ "./node_modules/@lumino/properties/dist/index.es6.js":
/*!***********************************************************!*\
  !*** ./node_modules/@lumino/properties/dist/index.es6.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AttachedProperty": () => (/* binding */ AttachedProperty)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/*-----------------------------------------------------------------------------
| Copyright (c) 2014-2017, PhosphorJS Contributors
|
| Distributed under the terms of the BSD 3-Clause License.
|
| The full license is in the file LICENSE, distributed with this software.
|----------------------------------------------------------------------------*/
/**
 * A class which attaches a value to an external object.
 *
 * #### Notes
 * Attached properties are used to extend the state of an object with
 * semantic data from an unrelated class. They also encapsulate value
 * creation, coercion, and notification.
 *
 * Because attached property values are stored in a hash table, which
 * in turn is stored in a WeakMap keyed on the owner object, there is
 * non-trivial storage overhead involved in their use. The pattern is
 * therefore best used for the storage of rare data.
 */
class AttachedProperty {
  /**
   * Construct a new attached property.
   *
   * @param options - The options for initializing the property.
   */
  constructor(options) {
    this._pid = Private.nextPID();
    this.name = options.name;
    this._create = options.create;
    this._coerce = options.coerce || null;
    this._compare = options.compare || null;
    this._changed = options.changed || null;
  }
  /**
   * Get the current value of the property for a given owner.
   *
   * @param owner - The property owner of interest.
   *
   * @returns The current value of the property.
   *
   * #### Notes
   * If the value has not yet been set, the default value will be
   * computed and assigned as the current value of the property.
   */
  get(owner) {
    let value;
    let map = Private.ensureMap(owner);
    if (this._pid in map) {
      value = map[this._pid];
    } else {
      value = map[this._pid] = this._createValue(owner);
    }
    return value;
  }
  /**
   * Set the current value of the property for a given owner.
   *
   * @param owner - The property owner of interest.
   *
   * @param value - The value for the property.
   *
   * #### Notes
   * If the value has not yet been set, the default value will be
   * computed and used as the previous value for the comparison.
   */
  set(owner, value) {
    let oldValue;
    let map = Private.ensureMap(owner);
    if (this._pid in map) {
      oldValue = map[this._pid];
    } else {
      oldValue = map[this._pid] = this._createValue(owner);
    }
    let newValue = this._coerceValue(owner, value);
    this._maybeNotify(owner, oldValue, map[this._pid] = newValue);
  }
  /**
   * Explicitly coerce the current property value for a given owner.
   *
   * @param owner - The property owner of interest.
   *
   * #### Notes
   * If the value has not yet been set, the default value will be
   * computed and used as the previous value for the comparison.
   */
  coerce(owner) {
    let oldValue;
    let map = Private.ensureMap(owner);
    if (this._pid in map) {
      oldValue = map[this._pid];
    } else {
      oldValue = map[this._pid] = this._createValue(owner);
    }
    let newValue = this._coerceValue(owner, oldValue);
    this._maybeNotify(owner, oldValue, map[this._pid] = newValue);
  }
  /**
   * Get or create the default value for the given owner.
   */
  _createValue(owner) {
    let create = this._create;
    return create(owner);
  }
  /**
   * Coerce the value for the given owner.
   */
  _coerceValue(owner, value) {
    let coerce = this._coerce;
    return coerce ? coerce(owner, value) : value;
  }
  /**
   * Compare the old value and new value for equality.
   */
  _compareValue(oldValue, newValue) {
    let compare = this._compare;
    return compare ? compare(oldValue, newValue) : oldValue === newValue;
  }
  /**
   * Run the change notification if the given values are different.
   */
  _maybeNotify(owner, oldValue, newValue) {
    let changed = this._changed;
    if (changed && !this._compareValue(oldValue, newValue)) {
      changed(owner, oldValue, newValue);
    }
  }
}
/**
 * The namespace for the `AttachedProperty` class statics.
 */
(function (AttachedProperty) {
  /**
   * Clear the stored property data for the given owner.
   *
   * @param owner - The property owner of interest.
   *
   * #### Notes
   * This will clear all property values for the owner, but it will
   * **not** run the change notification for any of the properties.
   */
  function clearData(owner) {
    Private.ownerData.delete(owner);
  }
  AttachedProperty.clearData = clearData;
})(AttachedProperty || (AttachedProperty = {}));
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
  /**
   * A weak mapping of property owner to property map.
   */
  Private.ownerData = new WeakMap();
  /**
   * A function which computes successive unique property ids.
   */
  Private.nextPID = (() => {
    let id = 0;
    return () => {
      let rand = Math.random();
      let stem = `${rand}`.slice(2);
      return `pid-${stem}-${id++}`;
    };
  })();
  /**
   * Lookup the data map for the property owner.
   *
   * This will create the map if one does not already exist.
   */
  function ensureMap(owner) {
    let map = Private.ownerData.get(owner);
    if (map) {
      return map;
    }
    map = Object.create(null);
    Private.ownerData.set(owner, map);
    return map;
  }
  Private.ensureMap = ensureMap;
})(Private || (Private = {}));


/***/ }),

/***/ "./node_modules/@lumino/signaling/dist/index.es6.js":
/*!**********************************************************!*\
  !*** ./node_modules/@lumino/signaling/dist/index.es6.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Signal": () => (/* binding */ Signal),
/* harmony export */   "Stream": () => (/* binding */ Stream)
/* harmony export */ });
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);



// Copyright (c) Jupyter Development Team.
/**
 * A concrete implementation of `ISignal`.
 *
 * #### Example
 * ```typescript
 * import { ISignal, Signal } from '@lumino/signaling';
 *
 * class SomeClass {
 *
 *   constructor(name: string) {
 *     this.name = name;
 *   }
 *
 *   readonly name: string;
 *
 *   get valueChanged: ISignal<this, number> {
 *     return this._valueChanged;
 *   }
 *
 *   get value(): number {
 *     return this._value;
 *   }
 *
 *   set value(value: number) {
 *     if (value === this._value) {
 *       return;
 *     }
 *     this._value = value;
 *     this._valueChanged.emit(value);
 *   }
 *
 *   private _value = 0;
 *   private _valueChanged = new Signal<this, number>(this);
 * }
 *
 * function logger(sender: SomeClass, value: number): void {
 *   console.log(sender.name, value);
 * }
 *
 * let m1 = new SomeClass('foo');
 * let m2 = new SomeClass('bar');
 *
 * m1.valueChanged.connect(logger);
 * m2.valueChanged.connect(logger);
 *
 * m1.value = 42;  // logs: foo 42
 * m2.value = 17;  // logs: bar 17
 * ```
 */
class Signal {
  /**
   * Construct a new signal.
   *
   * @param sender - The sender which owns the signal.
   */
  constructor(sender) {
    this.sender = sender;
  }
  /**
   * Connect a slot to the signal.
   *
   * @param slot - The slot to invoke when the signal is emitted.
   *
   * @param thisArg - The `this` context for the slot. If provided,
   *   this must be a non-primitive object.
   *
   * @returns `true` if the connection succeeds, `false` otherwise.
   */
  connect(slot, thisArg) {
    return Private.connect(this, slot, thisArg);
  }
  /**
   * Disconnect a slot from the signal.
   *
   * @param slot - The slot to disconnect from the signal.
   *
   * @param thisArg - The `this` context for the slot. If provided,
   *   this must be a non-primitive object.
   *
   * @returns `true` if the connection is removed, `false` otherwise.
   */
  disconnect(slot, thisArg) {
    return Private.disconnect(this, slot, thisArg);
  }
  /**
   * Emit the signal and invoke the connected slots.
   *
   * @param args - The args to pass to the connected slots.
   *
   * #### Notes
   * Slots are invoked synchronously in connection order.
   *
   * Exceptions thrown by connected slots will be caught and logged.
   */
  emit(args) {
    Private.emit(this, args);
  }
}
/**
 * The namespace for the `Signal` class statics.
 */
(function (Signal) {
  /**
   * Remove all connections between a sender and receiver.
   *
   * @param sender - The sender object of interest.
   *
   * @param receiver - The receiver object of interest.
   *
   * #### Notes
   * If a `thisArg` is provided when connecting a signal, that object
   * is considered the receiver. Otherwise, the `slot` is considered
   * the receiver.
   */
  function disconnectBetween(sender, receiver) {
    Private.disconnectBetween(sender, receiver);
  }
  Signal.disconnectBetween = disconnectBetween;
  /**
   * Remove all connections where the given object is the sender.
   *
   * @param sender - The sender object of interest.
   */
  function disconnectSender(sender) {
    Private.disconnectSender(sender);
  }
  Signal.disconnectSender = disconnectSender;
  /**
   * Remove all connections where the given object is the receiver.
   *
   * @param receiver - The receiver object of interest.
   *
   * #### Notes
   * If a `thisArg` is provided when connecting a signal, that object
   * is considered the receiver. Otherwise, the `slot` is considered
   * the receiver.
   */
  function disconnectReceiver(receiver) {
    Private.disconnectReceiver(receiver);
  }
  Signal.disconnectReceiver = disconnectReceiver;
  /**
   * Remove all connections where an object is the sender or receiver.
   *
   * @param object - The object of interest.
   *
   * #### Notes
   * If a `thisArg` is provided when connecting a signal, that object
   * is considered the receiver. Otherwise, the `slot` is considered
   * the receiver.
   */
  function disconnectAll(object) {
    Private.disconnectAll(object);
  }
  Signal.disconnectAll = disconnectAll;
  /**
   * Clear all signal data associated with the given object.
   *
   * @param object - The object for which the data should be cleared.
   *
   * #### Notes
   * This removes all signal connections and any other signal data
   * associated with the object.
   */
  function clearData(object) {
    Private.disconnectAll(object);
  }
  Signal.clearData = clearData;
  /**
   * Get the signal exception handler.
   *
   * @returns The current exception handler.
   *
   * #### Notes
   * The default exception handler is `console.error`.
   */
  function getExceptionHandler() {
    return Private.exceptionHandler;
  }
  Signal.getExceptionHandler = getExceptionHandler;
  /**
   * Set the signal exception handler.
   *
   * @param handler - The function to use as the exception handler.
   *
   * @returns The old exception handler.
   *
   * #### Notes
   * The exception handler is invoked when a slot throws an exception.
   */
  function setExceptionHandler(handler) {
    let old = Private.exceptionHandler;
    Private.exceptionHandler = handler;
    return old;
  }
  Signal.setExceptionHandler = setExceptionHandler;
})(Signal || (Signal = {}));
/**
 * A concrete implementation of `IStream`.
 *
 * #### Example
 * ```typescript
 * import { IStream, Stream } from '@lumino/signaling';
 *
 * class SomeClass {
 *
 *   constructor(name: string) {
 *     this.name = name;
 *   }
 *
 *   readonly name: string;
 *
 *   get pings(): IStream<this, string> {
 *     return this._pings;
 *   }
 *
 *   ping(value: string) {
 *     this._pings.emit(value);
 *   }
 *
 *   private _pings = new Stream<this, string>(this);
 * }
 *
 * let m1 = new SomeClass('foo');
 *
 * m1.pings.connect((_, value: string) => {
 *   console.log('connect', value);
 * });
 *
 * void (async () => {
 *   for await (const ping of m1.pings) {
 *     console.log('iterator', ping);
 *   }
 * })();
 *
 * m1.ping('alpha');  // logs: connect alpha
 *                    // logs: iterator alpha
 * m1.ping('beta');   // logs: connect beta
 *                    // logs: iterator beta
 * ```
 */
class Stream extends Signal {
  constructor() {
    super(...arguments);
    this._pending = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
  }
  /**
   * Return an async iterator that yields every emission.
   */
  async *[Symbol.asyncIterator]() {
    let pending = this._pending;
    while (true) {
      try {
        const {
          args,
          next
        } = await pending.promise;
        pending = next;
        yield args;
      } catch (_) {
        return; // Any promise rejection stops the iterator.
      }
    }
  }
  /**
   * Emit the signal, invoke the connected slots, and yield the emission.
   *
   * @param args - The args to pass to the connected slots.
   */
  emit(args) {
    const pending = this._pending;
    const next = this._pending = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
    pending.resolve({
      args,
      next
    });
    super.emit(args);
  }
  /**
   * Stop the stream's async iteration.
   */
  stop() {
    this._pending.promise.catch(() => undefined);
    this._pending.reject('stop');
    this._pending = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
  }
}
/**
 * The namespace for the module implementation details.
 */
var Private;
(function (Private) {
  /**
   * The signal exception handler function.
   */
  Private.exceptionHandler = err => {
    console.error(err);
  };
  /**
   * Connect a slot to a signal.
   *
   * @param signal - The signal of interest.
   *
   * @param slot - The slot to invoke when the signal is emitted.
   *
   * @param thisArg - The `this` context for the slot. If provided,
   *   this must be a non-primitive object.
   *
   * @returns `true` if the connection succeeds, `false` otherwise.
   */
  function connect(signal, slot, thisArg) {
    // Coerce a `null` `thisArg` to `undefined`.
    thisArg = thisArg || undefined;
    // Ensure the sender's array of receivers is created.
    let receivers = receiversForSender.get(signal.sender);
    if (!receivers) {
      receivers = [];
      receiversForSender.set(signal.sender, receivers);
    }
    // Bail if a matching connection already exists.
    if (findConnection(receivers, signal, slot, thisArg)) {
      return false;
    }
    // Choose the best object for the receiver.
    let receiver = thisArg || slot;
    // Ensure the receiver's array of senders is created.
    let senders = sendersForReceiver.get(receiver);
    if (!senders) {
      senders = [];
      sendersForReceiver.set(receiver, senders);
    }
    // Create a new connection and add it to the end of each array.
    let connection = {
      signal,
      slot,
      thisArg
    };
    receivers.push(connection);
    senders.push(connection);
    // Indicate a successful connection.
    return true;
  }
  Private.connect = connect;
  /**
   * Disconnect a slot from a signal.
   *
   * @param signal - The signal of interest.
   *
   * @param slot - The slot to disconnect from the signal.
   *
   * @param thisArg - The `this` context for the slot. If provided,
   *   this must be a non-primitive object.
   *
   * @returns `true` if the connection is removed, `false` otherwise.
   */
  function disconnect(signal, slot, thisArg) {
    // Coerce a `null` `thisArg` to `undefined`.
    thisArg = thisArg || undefined;
    // Lookup the list of receivers, and bail if none exist.
    let receivers = receiversForSender.get(signal.sender);
    if (!receivers || receivers.length === 0) {
      return false;
    }
    // Bail if no matching connection exits.
    let connection = findConnection(receivers, signal, slot, thisArg);
    if (!connection) {
      return false;
    }
    // Choose the best object for the receiver.
    let receiver = thisArg || slot;
    // Lookup the array of senders, which is now known to exist.
    let senders = sendersForReceiver.get(receiver);
    // Clear the connection and schedule cleanup of the arrays.
    connection.signal = null;
    scheduleCleanup(receivers);
    scheduleCleanup(senders);
    // Indicate a successful disconnection.
    return true;
  }
  Private.disconnect = disconnect;
  /**
   * Remove all connections between a sender and receiver.
   *
   * @param sender - The sender object of interest.
   *
   * @param receiver - The receiver object of interest.
   */
  function disconnectBetween(sender, receiver) {
    // If there are no receivers, there is nothing to do.
    let receivers = receiversForSender.get(sender);
    if (!receivers || receivers.length === 0) {
      return;
    }
    // If there are no senders, there is nothing to do.
    let senders = sendersForReceiver.get(receiver);
    if (!senders || senders.length === 0) {
      return;
    }
    // Clear each connection between the sender and receiver.
    for (const connection of senders) {
      // Skip connections which have already been cleared.
      if (!connection.signal) {
        continue;
      }
      // Clear the connection if it matches the sender.
      if (connection.signal.sender === sender) {
        connection.signal = null;
      }
    }
    // Schedule a cleanup of the senders and receivers.
    scheduleCleanup(receivers);
    scheduleCleanup(senders);
  }
  Private.disconnectBetween = disconnectBetween;
  /**
   * Remove all connections where the given object is the sender.
   *
   * @param sender - The sender object of interest.
   */
  function disconnectSender(sender) {
    // If there are no receivers, there is nothing to do.
    let receivers = receiversForSender.get(sender);
    if (!receivers || receivers.length === 0) {
      return;
    }
    // Clear each receiver connection.
    for (const connection of receivers) {
      // Skip connections which have already been cleared.
      if (!connection.signal) {
        continue;
      }
      // Choose the best object for the receiver.
      let receiver = connection.thisArg || connection.slot;
      // Clear the connection.
      connection.signal = null;
      // Cleanup the array of senders, which is now known to exist.
      scheduleCleanup(sendersForReceiver.get(receiver));
    }
    // Schedule a cleanup of the receivers.
    scheduleCleanup(receivers);
  }
  Private.disconnectSender = disconnectSender;
  /**
   * Remove all connections where the given object is the receiver.
   *
   * @param receiver - The receiver object of interest.
   */
  function disconnectReceiver(receiver) {
    // If there are no senders, there is nothing to do.
    let senders = sendersForReceiver.get(receiver);
    if (!senders || senders.length === 0) {
      return;
    }
    // Clear each sender connection.
    for (const connection of senders) {
      // Skip connections which have already been cleared.
      if (!connection.signal) {
        continue;
      }
      // Lookup the sender for the connection.
      let sender = connection.signal.sender;
      // Clear the connection.
      connection.signal = null;
      // Cleanup the array of receivers, which is now known to exist.
      scheduleCleanup(receiversForSender.get(sender));
    }
    // Schedule a cleanup of the list of senders.
    scheduleCleanup(senders);
  }
  Private.disconnectReceiver = disconnectReceiver;
  /**
   * Remove all connections where an object is the sender or receiver.
   *
   * @param object - The object of interest.
   */
  function disconnectAll(object) {
    // Remove all connections where the given object is the sender.
    disconnectSender(object);
    // Remove all connections where the given object is the receiver.
    disconnectReceiver(object);
  }
  Private.disconnectAll = disconnectAll;
  /**
   * Emit a signal and invoke its connected slots.
   *
   * @param signal - The signal of interest.
   *
   * @param args - The args to pass to the connected slots.
   *
   * #### Notes
   * Slots are invoked synchronously in connection order.
   *
   * Exceptions thrown by connected slots will be caught and logged.
   */
  function emit(signal, args) {
    // If there are no receivers, there is nothing to do.
    let receivers = receiversForSender.get(signal.sender);
    if (!receivers || receivers.length === 0) {
      return;
    }
    // Invoke the slots for connections with a matching signal.
    // Any connections added during emission are not invoked.
    for (let i = 0, n = receivers.length; i < n; ++i) {
      let connection = receivers[i];
      if (connection.signal === signal) {
        invokeSlot(connection, args);
      }
    }
  }
  Private.emit = emit;
  /**
   * A weak mapping of sender to array of receiver connections.
   */
  const receiversForSender = new WeakMap();
  /**
   * A weak mapping of receiver to array of sender connections.
   */
  const sendersForReceiver = new WeakMap();
  /**
   * A set of connection arrays which are pending cleanup.
   */
  const dirtySet = new Set();
  /**
   * A function to schedule an event loop callback.
   */
  const schedule = (() => {
    let ok = typeof requestAnimationFrame === 'function';
    return ok ? requestAnimationFrame : setImmediate;
  })();
  /**
   * Find a connection which matches the given parameters.
   */
  function findConnection(connections, signal, slot, thisArg) {
    return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.find)(connections, connection => connection.signal === signal && connection.slot === slot && connection.thisArg === thisArg);
  }
  /**
   * Invoke a slot with the given parameters.
   *
   * The connection is assumed to be valid.
   *
   * Exceptions in the slot will be caught and logged.
   */
  function invokeSlot(connection, args) {
    let {
      signal,
      slot,
      thisArg
    } = connection;
    try {
      slot.call(thisArg, signal.sender, args);
    } catch (err) {
      Private.exceptionHandler(err);
    }
  }
  /**
   * Schedule a cleanup of a connection array.
   *
   * This will add the array to the dirty set and schedule a deferred
   * cleanup of the array contents. On cleanup, any connection with a
   * `null` signal will be removed from the array.
   */
  function scheduleCleanup(array) {
    if (dirtySet.size === 0) {
      schedule(cleanupDirtySet);
    }
    dirtySet.add(array);
  }
  /**
   * Cleanup the connection lists in the dirty set.
   *
   * This function should only be invoked asynchronously, when the
   * stack frame is guaranteed to not be on the path of user code.
   */
  function cleanupDirtySet() {
    dirtySet.forEach(cleanupConnections);
    dirtySet.clear();
  }
  /**
   * Cleanup the dirty connections in a connections array.
   *
   * This will remove any connection with a `null` signal.
   *
   * This function should only be invoked asynchronously, when the
   * stack frame is guaranteed to not be on the path of user code.
   */
  function cleanupConnections(connections) {
    _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.removeAllWhere(connections, isDeadConnection);
  }
  /**
   * Test whether a connection is dead.
   *
   * A dead connection has a `null` signal.
   */
  function isDeadConnection(connection) {
    return connection.signal === null;
  }
})(Private || (Private = {}));


/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/anchored-position.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/anchored-position.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getAnchoredPosition": () => (/* binding */ getAnchoredPosition)
/* harmony export */ });
const alternateOrders = {
  'outside-top': ['outside-bottom', 'outside-right', 'outside-left', 'outside-bottom'],
  'outside-bottom': ['outside-top', 'outside-right', 'outside-left', 'outside-bottom'],
  'outside-left': ['outside-right', 'outside-bottom', 'outside-top', 'outside-bottom'],
  'outside-right': ['outside-left', 'outside-bottom', 'outside-top', 'outside-bottom']
};
const alternateAlignments = {
  start: ['end', 'center'],
  end: ['start', 'center'],
  center: ['end', 'start']
};
function getAnchoredPosition(floatingElement, anchorElement, settings = {}) {
  const parentElement = getPositionedParent(floatingElement);
  const clippingRect = getClippingRect(parentElement);
  const parentElementStyle = getComputedStyle(parentElement);
  const parentElementRect = parentElement.getBoundingClientRect();
  const [borderTop, borderLeft] = [parentElementStyle.borderTopWidth, parentElementStyle.borderLeftWidth].map(v => parseInt(v, 10) || 0);
  const relativeRect = {
    top: parentElementRect.top + borderTop,
    left: parentElementRect.left + borderLeft
  };
  return pureCalculateAnchoredPosition(clippingRect, relativeRect, floatingElement.getBoundingClientRect(), anchorElement instanceof Element ? anchorElement.getBoundingClientRect() : anchorElement, getDefaultSettings(settings));
}
function getPositionedParent(element) {
  if (isOnTopLayer(element)) return document.body;
  let parentNode = element.parentNode;
  while (parentNode !== null) {
    if (parentNode instanceof HTMLElement && getComputedStyle(parentNode).position !== 'static') {
      return parentNode;
    }
    parentNode = parentNode.parentNode;
  }
  return document.body;
}
function isOnTopLayer(element) {
  var _a;
  if (element.tagName === 'DIALOG') {
    return true;
  }
  try {
    if (element.matches(':popover-open') && /native code/.test((_a = document.body.showPopover) === null || _a === void 0 ? void 0 : _a.toString())) {
      return true;
    }
  } catch (_b) {
    return false;
  }
  return false;
}
function getClippingRect(element) {
  let parentNode = element;
  while (parentNode !== null) {
    if (parentNode === document.body) {
      break;
    }
    const parentNodeStyle = getComputedStyle(parentNode);
    if (parentNodeStyle.overflow !== 'visible') {
      break;
    }
    parentNode = parentNode.parentNode;
  }
  const clippingNode = parentNode === document.body || !(parentNode instanceof HTMLElement) ? document.body : parentNode;
  const elemRect = clippingNode.getBoundingClientRect();
  const elemStyle = getComputedStyle(clippingNode);
  const [borderTop, borderLeft, borderRight, borderBottom] = [elemStyle.borderTopWidth, elemStyle.borderLeftWidth, elemStyle.borderRightWidth, elemStyle.borderBottomWidth].map(v => parseInt(v, 10) || 0);
  return {
    top: elemRect.top + borderTop,
    left: elemRect.left + borderLeft,
    width: elemRect.width - borderRight - borderLeft,
    height: Math.max(elemRect.height - borderTop - borderBottom, clippingNode === document.body ? window.innerHeight : -Infinity)
  };
}
const positionDefaults = {
  side: 'outside-bottom',
  align: 'start',
  anchorOffset: 4,
  alignmentOffset: 4,
  allowOutOfBounds: false
};
function getDefaultSettings(settings = {}) {
  var _a, _b, _c, _d, _e;
  const side = (_a = settings.side) !== null && _a !== void 0 ? _a : positionDefaults.side;
  const align = (_b = settings.align) !== null && _b !== void 0 ? _b : positionDefaults.align;
  return {
    side,
    align,
    anchorOffset: (_c = settings.anchorOffset) !== null && _c !== void 0 ? _c : side === 'inside-center' ? 0 : positionDefaults.anchorOffset,
    alignmentOffset: (_d = settings.alignmentOffset) !== null && _d !== void 0 ? _d : align !== 'center' && side.startsWith('inside') ? positionDefaults.alignmentOffset : 0,
    allowOutOfBounds: (_e = settings.allowOutOfBounds) !== null && _e !== void 0 ? _e : positionDefaults.allowOutOfBounds
  };
}
function pureCalculateAnchoredPosition(viewportRect, relativePosition, floatingRect, anchorRect, {
  side,
  align,
  allowOutOfBounds,
  anchorOffset,
  alignmentOffset
}) {
  const relativeViewportRect = {
    top: viewportRect.top - relativePosition.top,
    left: viewportRect.left - relativePosition.left,
    width: viewportRect.width,
    height: viewportRect.height
  };
  let pos = calculatePosition(floatingRect, anchorRect, side, align, anchorOffset, alignmentOffset);
  let anchorSide = side;
  let anchorAlign = align;
  pos.top -= relativePosition.top;
  pos.left -= relativePosition.left;
  if (!allowOutOfBounds) {
    const alternateOrder = alternateOrders[side];
    let positionAttempt = 0;
    if (alternateOrder) {
      let prevSide = side;
      while (positionAttempt < alternateOrder.length && shouldRecalculatePosition(prevSide, pos, relativeViewportRect, floatingRect)) {
        const nextSide = alternateOrder[positionAttempt++];
        prevSide = nextSide;
        pos = calculatePosition(floatingRect, anchorRect, nextSide, align, anchorOffset, alignmentOffset);
        pos.top -= relativePosition.top;
        pos.left -= relativePosition.left;
        anchorSide = nextSide;
      }
    }
    const alternateAlignment = alternateAlignments[align];
    let alignmentAttempt = 0;
    if (alternateAlignment) {
      let prevAlign = align;
      while (alignmentAttempt < alternateAlignment.length && shouldRecalculateAlignment(prevAlign, pos, relativeViewportRect, floatingRect)) {
        const nextAlign = alternateAlignment[alignmentAttempt++];
        prevAlign = nextAlign;
        pos = calculatePosition(floatingRect, anchorRect, anchorSide, nextAlign, anchorOffset, alignmentOffset);
        pos.top -= relativePosition.top;
        pos.left -= relativePosition.left;
        anchorAlign = nextAlign;
      }
    }
    if (pos.top < relativeViewportRect.top) {
      pos.top = relativeViewportRect.top;
    }
    if (pos.left < relativeViewportRect.left) {
      pos.left = relativeViewportRect.left;
    }
    if (pos.left + floatingRect.width > viewportRect.width + relativeViewportRect.left) {
      pos.left = viewportRect.width + relativeViewportRect.left - floatingRect.width;
    }
    if (alternateOrder && positionAttempt < alternateOrder.length) {
      if (pos.top + floatingRect.height > viewportRect.height + relativeViewportRect.top) {
        pos.top = viewportRect.height + relativeViewportRect.top - floatingRect.height;
      }
    }
  }
  return Object.assign(Object.assign({}, pos), {
    anchorSide,
    anchorAlign
  });
}
function calculatePosition(elementDimensions, anchorPosition, side, align, anchorOffset, alignmentOffset) {
  const anchorRight = anchorPosition.left + anchorPosition.width;
  const anchorBottom = anchorPosition.top + anchorPosition.height;
  let top = -1;
  let left = -1;
  if (side === 'outside-top') {
    top = anchorPosition.top - anchorOffset - elementDimensions.height;
  } else if (side === 'outside-bottom') {
    top = anchorBottom + anchorOffset;
  } else if (side === 'outside-left') {
    left = anchorPosition.left - anchorOffset - elementDimensions.width;
  } else if (side === 'outside-right') {
    left = anchorRight + anchorOffset;
  }
  if (side === 'outside-top' || side === 'outside-bottom') {
    if (align === 'start') {
      left = anchorPosition.left + alignmentOffset;
    } else if (align === 'center') {
      left = anchorPosition.left - (elementDimensions.width - anchorPosition.width) / 2 + alignmentOffset;
    } else {
      left = anchorRight - elementDimensions.width - alignmentOffset;
    }
  }
  if (side === 'outside-left' || side === 'outside-right') {
    if (align === 'start') {
      top = anchorPosition.top + alignmentOffset;
    } else if (align === 'center') {
      top = anchorPosition.top - (elementDimensions.height - anchorPosition.height) / 2 + alignmentOffset;
    } else {
      top = anchorBottom - elementDimensions.height - alignmentOffset;
    }
  }
  if (side === 'inside-top') {
    top = anchorPosition.top + anchorOffset;
  } else if (side === 'inside-bottom') {
    top = anchorBottom - anchorOffset - elementDimensions.height;
  } else if (side === 'inside-left') {
    left = anchorPosition.left + anchorOffset;
  } else if (side === 'inside-right') {
    left = anchorRight - anchorOffset - elementDimensions.width;
  } else if (side === 'inside-center') {
    left = (anchorRight + anchorPosition.left) / 2 - elementDimensions.width / 2 + anchorOffset;
  }
  if (side === 'inside-top' || side === 'inside-bottom') {
    if (align === 'start') {
      left = anchorPosition.left + alignmentOffset;
    } else if (align === 'center') {
      left = anchorPosition.left - (elementDimensions.width - anchorPosition.width) / 2 + alignmentOffset;
    } else {
      left = anchorRight - elementDimensions.width - alignmentOffset;
    }
  } else if (side === 'inside-left' || side === 'inside-right' || side === 'inside-center') {
    if (align === 'start') {
      top = anchorPosition.top + alignmentOffset;
    } else if (align === 'center') {
      top = anchorPosition.top - (elementDimensions.height - anchorPosition.height) / 2 + alignmentOffset;
    } else {
      top = anchorBottom - elementDimensions.height - alignmentOffset;
    }
  }
  return {
    top,
    left
  };
}
function shouldRecalculatePosition(side, currentPos, containerDimensions, elementDimensions) {
  if (side === 'outside-top' || side === 'outside-bottom') {
    return currentPos.top < containerDimensions.top || currentPos.top + elementDimensions.height > containerDimensions.height + containerDimensions.top;
  } else {
    return currentPos.left < containerDimensions.left || currentPos.left + elementDimensions.width > containerDimensions.width + containerDimensions.left;
  }
}
function shouldRecalculateAlignment(align, currentPos, containerDimensions, elementDimensions) {
  if (align === 'end') {
    return currentPos.left < containerDimensions.left;
  } else if (align === 'start' || align === 'center') {
    return currentPos.left + elementDimensions.width > containerDimensions.left + containerDimensions.width || currentPos.left < containerDimensions.left;
  }
}

/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/focus-trap.js":
/*!***************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/focus-trap.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "focusTrap": () => (/* binding */ focusTrap)
/* harmony export */ });
/* harmony import */ var _utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/iterate-focusable-elements.js */ "./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");
/* harmony import */ var _polyfills_event_listener_signal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./polyfills/event-listener-signal.js */ "./node_modules/@primer/behaviors/dist/esm/polyfills/event-listener-signal.js");


(0,_polyfills_event_listener_signal_js__WEBPACK_IMPORTED_MODULE_0__.polyfill)();
const suspendedTrapStack = [];
let activeTrap = undefined;
function tryReactivate() {
  const trapToReactivate = suspendedTrapStack.pop();
  if (trapToReactivate) {
    focusTrap(trapToReactivate.container, trapToReactivate.initialFocus, trapToReactivate.originalSignal);
  }
}
function followSignal(signal) {
  const controller = new AbortController();
  signal.addEventListener('abort', () => {
    controller.abort();
  });
  return controller;
}
function focusTrap(container, initialFocus, abortSignal) {
  const controller = new AbortController();
  const signal = abortSignal !== null && abortSignal !== void 0 ? abortSignal : controller.signal;
  container.setAttribute('data-focus-trap', 'active');
  const sentinelStart = document.createElement('span');
  sentinelStart.setAttribute('class', 'sentinel');
  sentinelStart.setAttribute('tabindex', '0');
  sentinelStart.setAttribute('aria-hidden', 'true');
  sentinelStart.onfocus = () => {
    const lastFocusableChild = (0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__.getFocusableChild)(container, true);
    lastFocusableChild === null || lastFocusableChild === void 0 ? void 0 : lastFocusableChild.focus();
  };
  const sentinelEnd = document.createElement('span');
  sentinelEnd.setAttribute('class', 'sentinel');
  sentinelEnd.setAttribute('tabindex', '0');
  sentinelEnd.setAttribute('aria-hidden', 'true');
  sentinelEnd.onfocus = () => {
    const firstFocusableChild = (0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__.getFocusableChild)(container);
    firstFocusableChild === null || firstFocusableChild === void 0 ? void 0 : firstFocusableChild.focus();
  };
  container.prepend(sentinelStart);
  container.append(sentinelEnd);
  let lastFocusedChild = undefined;
  function ensureTrapZoneHasFocus(focusedElement) {
    if (focusedElement instanceof HTMLElement && document.contains(container)) {
      if (container.contains(focusedElement)) {
        lastFocusedChild = focusedElement;
        return;
      } else {
        if (lastFocusedChild && (0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__.isTabbable)(lastFocusedChild) && container.contains(lastFocusedChild)) {
          lastFocusedChild.focus();
          return;
        } else if (initialFocus && container.contains(initialFocus)) {
          initialFocus.focus();
          return;
        } else {
          const firstFocusableChild = (0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__.getFocusableChild)(container);
          firstFocusableChild === null || firstFocusableChild === void 0 ? void 0 : firstFocusableChild.focus();
          return;
        }
      }
    }
  }
  const wrappingController = followSignal(signal);
  if (activeTrap) {
    const suspendedTrap = activeTrap;
    activeTrap.container.setAttribute('data-focus-trap', 'suspended');
    activeTrap.controller.abort();
    suspendedTrapStack.push(suspendedTrap);
  }
  wrappingController.signal.addEventListener('abort', () => {
    activeTrap = undefined;
  });
  signal.addEventListener('abort', () => {
    container.removeAttribute('data-focus-trap');
    const sentinels = container.getElementsByClassName('sentinel');
    while (sentinels.length > 0) sentinels[0].remove();
    const suspendedTrapIndex = suspendedTrapStack.findIndex(t => t.container === container);
    if (suspendedTrapIndex >= 0) {
      suspendedTrapStack.splice(suspendedTrapIndex, 1);
    }
    tryReactivate();
  });
  document.addEventListener('focus', event => {
    ensureTrapZoneHasFocus(event.target);
  }, {
    signal: wrappingController.signal,
    capture: true
  });
  ensureTrapZoneHasFocus(document.activeElement);
  activeTrap = {
    container,
    controller: wrappingController,
    initialFocus,
    originalSignal: signal
  };
  const suspendedTrapIndex = suspendedTrapStack.findIndex(t => t.container === container);
  if (suspendedTrapIndex >= 0) {
    suspendedTrapStack.splice(suspendedTrapIndex, 1);
  }
  if (!abortSignal) {
    return controller;
  }
}

/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/focus-zone.js":
/*!***************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/focus-zone.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FocusKeys": () => (/* binding */ FocusKeys),
/* harmony export */   "activeDescendantActivatedDirectly": () => (/* binding */ activeDescendantActivatedDirectly),
/* harmony export */   "activeDescendantActivatedIndirectly": () => (/* binding */ activeDescendantActivatedIndirectly),
/* harmony export */   "focusZone": () => (/* binding */ focusZone),
/* harmony export */   "hasActiveDescendantAttribute": () => (/* binding */ hasActiveDescendantAttribute),
/* harmony export */   "isActiveDescendantAttribute": () => (/* binding */ isActiveDescendantAttribute)
/* harmony export */ });
/* harmony import */ var _polyfills_event_listener_signal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./polyfills/event-listener-signal.js */ "./node_modules/@primer/behaviors/dist/esm/polyfills/event-listener-signal.js");
/* harmony import */ var _utils_user_agent_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/user-agent.js */ "./node_modules/@primer/behaviors/dist/esm/utils/user-agent.js");
/* harmony import */ var _utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/iterate-focusable-elements.js */ "./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");
/* harmony import */ var _utils_unique_id_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/unique-id.js */ "./node_modules/@primer/behaviors/dist/esm/utils/unique-id.js");




(0,_polyfills_event_listener_signal_js__WEBPACK_IMPORTED_MODULE_0__.polyfill)();
var FocusKeys;
(function (FocusKeys) {
  FocusKeys[FocusKeys["ArrowHorizontal"] = 1] = "ArrowHorizontal";
  FocusKeys[FocusKeys["ArrowVertical"] = 2] = "ArrowVertical";
  FocusKeys[FocusKeys["JK"] = 4] = "JK";
  FocusKeys[FocusKeys["HL"] = 8] = "HL";
  FocusKeys[FocusKeys["HomeAndEnd"] = 16] = "HomeAndEnd";
  FocusKeys[FocusKeys["PageUpDown"] = 256] = "PageUpDown";
  FocusKeys[FocusKeys["WS"] = 32] = "WS";
  FocusKeys[FocusKeys["AD"] = 64] = "AD";
  FocusKeys[FocusKeys["Tab"] = 128] = "Tab";
  FocusKeys[FocusKeys["Backspace"] = 512] = "Backspace";
  FocusKeys[FocusKeys["ArrowAll"] = 3] = "ArrowAll";
  FocusKeys[FocusKeys["HJKL"] = 12] = "HJKL";
  FocusKeys[FocusKeys["WASD"] = 96] = "WASD";
  FocusKeys[FocusKeys["All"] = 511] = "All";
})(FocusKeys || (FocusKeys = {}));
const KEY_TO_BIT = {
  ArrowLeft: FocusKeys.ArrowHorizontal,
  ArrowDown: FocusKeys.ArrowVertical,
  ArrowUp: FocusKeys.ArrowVertical,
  ArrowRight: FocusKeys.ArrowHorizontal,
  h: FocusKeys.HL,
  j: FocusKeys.JK,
  k: FocusKeys.JK,
  l: FocusKeys.HL,
  a: FocusKeys.AD,
  s: FocusKeys.WS,
  w: FocusKeys.WS,
  d: FocusKeys.AD,
  Tab: FocusKeys.Tab,
  Home: FocusKeys.HomeAndEnd,
  End: FocusKeys.HomeAndEnd,
  PageUp: FocusKeys.PageUpDown,
  PageDown: FocusKeys.PageUpDown,
  Backspace: FocusKeys.Backspace
};
const KEY_TO_DIRECTION = {
  ArrowLeft: 'previous',
  ArrowDown: 'next',
  ArrowUp: 'previous',
  ArrowRight: 'next',
  h: 'previous',
  j: 'next',
  k: 'previous',
  l: 'next',
  a: 'previous',
  s: 'next',
  w: 'previous',
  d: 'next',
  Tab: 'next',
  Home: 'start',
  End: 'end',
  PageUp: 'start',
  PageDown: 'end',
  Backspace: 'previous'
};
function getDirection(keyboardEvent) {
  const direction = KEY_TO_DIRECTION[keyboardEvent.key];
  if (keyboardEvent.key === 'Tab' && keyboardEvent.shiftKey) {
    return 'previous';
  }
  const isMac = (0,_utils_user_agent_js__WEBPACK_IMPORTED_MODULE_1__.isMacOS)();
  if (isMac && keyboardEvent.metaKey || !isMac && keyboardEvent.ctrlKey) {
    if (keyboardEvent.key === 'ArrowLeft' || keyboardEvent.key === 'ArrowUp') {
      return 'start';
    } else if (keyboardEvent.key === 'ArrowRight' || keyboardEvent.key === 'ArrowDown') {
      return 'end';
    }
  }
  return direction;
}
function shouldIgnoreFocusHandling(keyboardEvent, activeElement) {
  const key = keyboardEvent.key;
  const keyLength = [...key].length;
  const isTextInput = activeElement instanceof HTMLInputElement && activeElement.type === 'text' || activeElement instanceof HTMLTextAreaElement;
  if (isTextInput && (keyLength === 1 || key === 'Home' || key === 'End')) {
    return true;
  }
  if (activeElement instanceof HTMLSelectElement) {
    if (keyLength === 1) {
      return true;
    }
    if (key === 'ArrowDown' && (0,_utils_user_agent_js__WEBPACK_IMPORTED_MODULE_1__.isMacOS)() && !keyboardEvent.metaKey) {
      return true;
    }
    if (key === 'ArrowDown' && !(0,_utils_user_agent_js__WEBPACK_IMPORTED_MODULE_1__.isMacOS)() && keyboardEvent.altKey) {
      return true;
    }
  }
  if (activeElement instanceof HTMLTextAreaElement && (key === 'PageUp' || key === 'PageDown')) {
    return true;
  }
  if (isTextInput) {
    const textInput = activeElement;
    const cursorAtStart = textInput.selectionStart === 0 && textInput.selectionEnd === 0;
    const cursorAtEnd = textInput.selectionStart === textInput.value.length && textInput.selectionEnd === textInput.value.length;
    if (key === 'ArrowLeft' && !cursorAtStart) {
      return true;
    }
    if (key === 'ArrowRight' && !cursorAtEnd) {
      return true;
    }
    if (textInput instanceof HTMLTextAreaElement) {
      if (key === 'ArrowUp' && !cursorAtStart) {
        return true;
      }
      if (key === 'ArrowDown' && !cursorAtEnd) {
        return true;
      }
    }
  }
  return false;
}
const isActiveDescendantAttribute = 'data-is-active-descendant';
const activeDescendantActivatedDirectly = 'activated-directly';
const activeDescendantActivatedIndirectly = 'activated-indirectly';
const hasActiveDescendantAttribute = 'data-has-active-descendant';
function focusZone(container, settings) {
  var _a, _b, _c, _d, _e;
  const focusableElements = [];
  const savedTabIndex = new WeakMap();
  const bindKeys = (_a = settings === null || settings === void 0 ? void 0 : settings.bindKeys) !== null && _a !== void 0 ? _a : ((settings === null || settings === void 0 ? void 0 : settings.getNextFocusable) ? FocusKeys.ArrowAll : FocusKeys.ArrowVertical) | FocusKeys.HomeAndEnd;
  const focusOutBehavior = (_b = settings === null || settings === void 0 ? void 0 : settings.focusOutBehavior) !== null && _b !== void 0 ? _b : 'stop';
  const focusInStrategy = (_c = settings === null || settings === void 0 ? void 0 : settings.focusInStrategy) !== null && _c !== void 0 ? _c : 'previous';
  const activeDescendantControl = settings === null || settings === void 0 ? void 0 : settings.activeDescendantControl;
  const activeDescendantCallback = settings === null || settings === void 0 ? void 0 : settings.onActiveDescendantChanged;
  let currentFocusedElement;
  const preventScroll = (_d = settings === null || settings === void 0 ? void 0 : settings.preventScroll) !== null && _d !== void 0 ? _d : false;
  function getFirstFocusableElement() {
    return focusableElements[0];
  }
  function isActiveDescendantInputFocused() {
    return document.activeElement === activeDescendantControl;
  }
  function updateFocusedElement(to, directlyActivated = false) {
    const from = currentFocusedElement;
    currentFocusedElement = to;
    if (activeDescendantControl) {
      if (to && isActiveDescendantInputFocused()) {
        setActiveDescendant(from, to, directlyActivated);
      } else {
        clearActiveDescendant();
      }
      return;
    }
    if (from && from !== to && savedTabIndex.has(from)) {
      from.setAttribute('tabindex', '-1');
    }
    to === null || to === void 0 ? void 0 : to.setAttribute('tabindex', '0');
  }
  function setActiveDescendant(from, to, directlyActivated = false) {
    if (!to.id) {
      to.setAttribute('id', (0,_utils_unique_id_js__WEBPACK_IMPORTED_MODULE_2__.uniqueId)());
    }
    if (from && from !== to) {
      from.removeAttribute(isActiveDescendantAttribute);
    }
    if (!activeDescendantControl || !directlyActivated && activeDescendantControl.getAttribute('aria-activedescendant') === to.id) {
      return;
    }
    activeDescendantControl.setAttribute('aria-activedescendant', to.id);
    container.setAttribute(hasActiveDescendantAttribute, to.id);
    to.setAttribute(isActiveDescendantAttribute, directlyActivated ? activeDescendantActivatedDirectly : activeDescendantActivatedIndirectly);
    activeDescendantCallback === null || activeDescendantCallback === void 0 ? void 0 : activeDescendantCallback(to, from, directlyActivated);
  }
  function clearActiveDescendant(previouslyActiveElement = currentFocusedElement) {
    if (focusInStrategy === 'first') {
      currentFocusedElement = undefined;
    }
    activeDescendantControl === null || activeDescendantControl === void 0 ? void 0 : activeDescendantControl.removeAttribute('aria-activedescendant');
    container.removeAttribute(hasActiveDescendantAttribute);
    previouslyActiveElement === null || previouslyActiveElement === void 0 ? void 0 : previouslyActiveElement.removeAttribute(isActiveDescendantAttribute);
    activeDescendantCallback === null || activeDescendantCallback === void 0 ? void 0 : activeDescendantCallback(undefined, previouslyActiveElement, false);
  }
  function beginFocusManagement(...elements) {
    const filteredElements = elements.filter(e => {
      var _a, _b;
      return (_b = (_a = settings === null || settings === void 0 ? void 0 : settings.focusableElementFilter) === null || _a === void 0 ? void 0 : _a.call(settings, e)) !== null && _b !== void 0 ? _b : true;
    });
    if (filteredElements.length === 0) {
      return;
    }
    focusableElements.splice(findInsertionIndex(filteredElements), 0, ...filteredElements);
    for (const element of filteredElements) {
      if (!savedTabIndex.has(element)) {
        savedTabIndex.set(element, element.getAttribute('tabindex'));
      }
      element.setAttribute('tabindex', '-1');
    }
    if (!currentFocusedElement) {
      updateFocusedElement(getFirstFocusableElement());
    }
  }
  function findInsertionIndex(elementsToInsert) {
    const firstElementToInsert = elementsToInsert[0];
    if (focusableElements.length === 0) return 0;
    let iMin = 0;
    let iMax = focusableElements.length - 1;
    while (iMin <= iMax) {
      const i = Math.floor((iMin + iMax) / 2);
      const element = focusableElements[i];
      if (followsInDocument(firstElementToInsert, element)) {
        iMax = i - 1;
      } else {
        iMin = i + 1;
      }
    }
    return iMin;
  }
  function followsInDocument(first, second) {
    return (second.compareDocumentPosition(first) & Node.DOCUMENT_POSITION_PRECEDING) > 0;
  }
  function endFocusManagement(...elements) {
    for (const element of elements) {
      const focusableElementIndex = focusableElements.indexOf(element);
      if (focusableElementIndex >= 0) {
        focusableElements.splice(focusableElementIndex, 1);
      }
      const savedIndex = savedTabIndex.get(element);
      if (savedIndex !== undefined) {
        if (savedIndex === null) {
          element.removeAttribute('tabindex');
        } else {
          element.setAttribute('tabindex', savedIndex);
        }
        savedTabIndex.delete(element);
      }
      if (element === currentFocusedElement) {
        const nextElementToFocus = getFirstFocusableElement();
        updateFocusedElement(nextElementToFocus);
      }
    }
  }
  beginFocusManagement(...(0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_3__.iterateFocusableElements)(container));
  const initialElement = typeof focusInStrategy === 'function' ? focusInStrategy(document.body) : getFirstFocusableElement();
  updateFocusedElement(initialElement);
  const observer = new MutationObserver(mutations => {
    for (const mutation of mutations) {
      for (const removedNode of mutation.removedNodes) {
        if (removedNode instanceof HTMLElement) {
          endFocusManagement(...(0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_3__.iterateFocusableElements)(removedNode));
        }
      }
    }
    for (const mutation of mutations) {
      for (const addedNode of mutation.addedNodes) {
        if (addedNode instanceof HTMLElement) {
          beginFocusManagement(...(0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_3__.iterateFocusableElements)(addedNode));
        }
      }
    }
  });
  observer.observe(container, {
    subtree: true,
    childList: true
  });
  const controller = new AbortController();
  const signal = (_e = settings === null || settings === void 0 ? void 0 : settings.abortSignal) !== null && _e !== void 0 ? _e : controller.signal;
  signal.addEventListener('abort', () => {
    endFocusManagement(...focusableElements);
  });
  let elementIndexFocusedByClick = undefined;
  container.addEventListener('mousedown', event => {
    if (event.target instanceof HTMLElement && event.target !== document.activeElement) {
      elementIndexFocusedByClick = focusableElements.indexOf(event.target);
    }
  }, {
    signal
  });
  if (activeDescendantControl) {
    container.addEventListener('focusin', event => {
      if (event.target instanceof HTMLElement && focusableElements.includes(event.target)) {
        activeDescendantControl.focus({
          preventScroll
        });
        updateFocusedElement(event.target);
      }
    });
    container.addEventListener('mousemove', ({
      target
    }) => {
      if (!(target instanceof Node)) {
        return;
      }
      const focusableElement = focusableElements.find(element => element.contains(target));
      if (focusableElement) {
        updateFocusedElement(focusableElement);
      }
    }, {
      signal,
      capture: true
    });
    activeDescendantControl.addEventListener('focusin', () => {
      if (!currentFocusedElement) {
        updateFocusedElement(getFirstFocusableElement());
      } else {
        setActiveDescendant(undefined, currentFocusedElement);
      }
    });
    activeDescendantControl.addEventListener('focusout', () => {
      clearActiveDescendant();
    });
  } else {
    container.addEventListener('focusin', event => {
      if (event.target instanceof HTMLElement) {
        if (elementIndexFocusedByClick !== undefined) {
          if (elementIndexFocusedByClick >= 0) {
            if (focusableElements[elementIndexFocusedByClick] !== currentFocusedElement) {
              updateFocusedElement(focusableElements[elementIndexFocusedByClick]);
            }
          }
          elementIndexFocusedByClick = undefined;
        } else {
          if (focusInStrategy === 'previous') {
            updateFocusedElement(event.target);
          } else if (focusInStrategy === 'closest' || focusInStrategy === 'first') {
            if (event.relatedTarget instanceof Element && !container.contains(event.relatedTarget)) {
              const targetElementIndex = lastKeyboardFocusDirection === 'previous' ? focusableElements.length - 1 : 0;
              const targetElement = focusableElements[targetElementIndex];
              targetElement === null || targetElement === void 0 ? void 0 : targetElement.focus({
                preventScroll
              });
              return;
            } else {
              updateFocusedElement(event.target);
            }
          } else if (typeof focusInStrategy === 'function') {
            if (event.relatedTarget instanceof Element && !container.contains(event.relatedTarget)) {
              const elementToFocus = focusInStrategy(event.relatedTarget);
              const requestedFocusElementIndex = elementToFocus ? focusableElements.indexOf(elementToFocus) : -1;
              if (requestedFocusElementIndex >= 0 && elementToFocus instanceof HTMLElement) {
                elementToFocus.focus({
                  preventScroll
                });
                return;
              } else {
                console.warn('Element requested is not a known focusable element.');
              }
            } else {
              updateFocusedElement(event.target);
            }
          }
        }
      }
      lastKeyboardFocusDirection = undefined;
    }, {
      signal
    });
  }
  const keyboardEventRecipient = activeDescendantControl !== null && activeDescendantControl !== void 0 ? activeDescendantControl : container;
  let lastKeyboardFocusDirection = undefined;
  if (focusInStrategy === 'closest') {
    document.addEventListener('keydown', event => {
      if (event.key === 'Tab') {
        lastKeyboardFocusDirection = getDirection(event);
      }
    }, {
      signal,
      capture: true
    });
  }
  function getCurrentFocusedIndex() {
    if (!currentFocusedElement) {
      return 0;
    }
    const focusedIndex = focusableElements.indexOf(currentFocusedElement);
    const fallbackIndex = currentFocusedElement === container ? -1 : 0;
    return focusedIndex !== -1 ? focusedIndex : fallbackIndex;
  }
  keyboardEventRecipient.addEventListener('keydown', event => {
    var _a;
    if (event.key in KEY_TO_DIRECTION) {
      const keyBit = KEY_TO_BIT[event.key];
      if (!event.defaultPrevented && (keyBit & bindKeys) > 0 && !shouldIgnoreFocusHandling(event, document.activeElement)) {
        const direction = getDirection(event);
        let nextElementToFocus = undefined;
        if (settings === null || settings === void 0 ? void 0 : settings.getNextFocusable) {
          nextElementToFocus = settings.getNextFocusable(direction, (_a = document.activeElement) !== null && _a !== void 0 ? _a : undefined, event);
        }
        if (!nextElementToFocus) {
          const lastFocusedIndex = getCurrentFocusedIndex();
          let nextFocusedIndex = lastFocusedIndex;
          if (direction === 'previous') {
            nextFocusedIndex -= 1;
          } else if (direction === 'start') {
            nextFocusedIndex = 0;
          } else if (direction === 'next') {
            nextFocusedIndex += 1;
          } else {
            nextFocusedIndex = focusableElements.length - 1;
          }
          if (nextFocusedIndex < 0) {
            if (focusOutBehavior === 'wrap' && event.key !== 'Tab') {
              nextFocusedIndex = focusableElements.length - 1;
            } else {
              nextFocusedIndex = 0;
            }
          }
          if (nextFocusedIndex >= focusableElements.length) {
            if (focusOutBehavior === 'wrap' && event.key !== 'Tab') {
              nextFocusedIndex = 0;
            } else {
              nextFocusedIndex = focusableElements.length - 1;
            }
          }
          if (lastFocusedIndex !== nextFocusedIndex) {
            nextElementToFocus = focusableElements[nextFocusedIndex];
          }
        }
        if (activeDescendantControl) {
          updateFocusedElement(nextElementToFocus || currentFocusedElement, true);
        } else if (nextElementToFocus) {
          lastKeyboardFocusDirection = direction;
          nextElementToFocus.focus({
            preventScroll
          });
        }
        if (event.key !== 'Tab' || nextElementToFocus) {
          event.preventDefault();
        }
      }
    }
  }, {
    signal
  });
  return controller;
}

/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/polyfills/event-listener-signal.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/polyfills/event-listener-signal.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyfill": () => (/* binding */ polyfill)
/* harmony export */ });
let signalSupported = false;
function noop() {}
try {
  const options = Object.create({}, {
    signal: {
      get() {
        signalSupported = true;
      }
    }
  });
  window.addEventListener('test', noop, options);
  window.removeEventListener('test', noop, options);
} catch (e) {}
function featureSupported() {
  return signalSupported;
}
function monkeyPatch() {
  if (typeof window === 'undefined') {
    return;
  }
  const originalAddEventListener = EventTarget.prototype.addEventListener;
  EventTarget.prototype.addEventListener = function (name, originalCallback, optionsOrCapture) {
    if (typeof optionsOrCapture === 'object' && 'signal' in optionsOrCapture && optionsOrCapture.signal instanceof AbortSignal) {
      originalAddEventListener.call(optionsOrCapture.signal, 'abort', () => {
        this.removeEventListener(name, originalCallback, optionsOrCapture);
      });
    }
    return originalAddEventListener.call(this, name, originalCallback, optionsOrCapture);
  };
}
function polyfill() {
  if (!featureSupported()) {
    monkeyPatch();
    signalSupported = true;
  }
}

/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getFocusableChild": () => (/* binding */ getFocusableChild),
/* harmony export */   "isFocusable": () => (/* binding */ isFocusable),
/* harmony export */   "isTabbable": () => (/* binding */ isTabbable),
/* harmony export */   "iterateFocusableElements": () => (/* binding */ iterateFocusableElements)
/* harmony export */ });
function* iterateFocusableElements(container, options = {}) {
  var _a, _b;
  const strict = (_a = options.strict) !== null && _a !== void 0 ? _a : false;
  const acceptFn = ((_b = options.onlyTabbable) !== null && _b !== void 0 ? _b : false) ? isTabbable : isFocusable;
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, {
    acceptNode: node => node instanceof HTMLElement && acceptFn(node, strict) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP
  });
  let nextNode = null;
  if (!options.reverse && acceptFn(container, strict)) {
    yield container;
  }
  if (options.reverse) {
    let lastChild = walker.lastChild();
    while (lastChild) {
      nextNode = lastChild;
      lastChild = walker.lastChild();
    }
  } else {
    nextNode = walker.firstChild();
  }
  while (nextNode instanceof HTMLElement) {
    yield nextNode;
    nextNode = options.reverse ? walker.previousNode() : walker.nextNode();
  }
  if (options.reverse && acceptFn(container, strict)) {
    yield container;
  }
  return undefined;
}
function getFocusableChild(container, lastChild = false) {
  return iterateFocusableElements(container, {
    reverse: lastChild,
    strict: true,
    onlyTabbable: true
  }).next().value;
}
function isFocusable(elem, strict = false) {
  const disabledAttrInert = ['BUTTON', 'INPUT', 'SELECT', 'TEXTAREA', 'OPTGROUP', 'OPTION', 'FIELDSET'].includes(elem.tagName) && elem.disabled;
  const hiddenInert = elem.hidden;
  const hiddenInputInert = elem instanceof HTMLInputElement && elem.type === 'hidden';
  const sentinelInert = elem.classList.contains('sentinel');
  if (disabledAttrInert || hiddenInert || hiddenInputInert || sentinelInert) {
    return false;
  }
  if (strict) {
    const sizeInert = elem.offsetWidth === 0 || elem.offsetHeight === 0;
    const visibilityInert = ['hidden', 'collapse'].includes(getComputedStyle(elem).visibility);
    const clientRectsInert = elem.getClientRects().length === 0;
    if (sizeInert || visibilityInert || clientRectsInert) {
      return false;
    }
  }
  if (elem.getAttribute('tabindex') != null) {
    return true;
  }
  if (elem instanceof HTMLAnchorElement && elem.getAttribute('href') == null) {
    return false;
  }
  return elem.tabIndex !== -1;
}
function isTabbable(elem, strict = false) {
  return isFocusable(elem, strict) && elem.getAttribute('tabindex') !== '-1';
}

/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/utils/unique-id.js":
/*!********************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/utils/unique-id.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "uniqueId": () => (/* binding */ uniqueId)
/* harmony export */ });
let idSeed = 10000;
function uniqueId() {
  return `__primer_id_${idSeed++}`;
}

/***/ }),

/***/ "./node_modules/@primer/behaviors/dist/esm/utils/user-agent.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@primer/behaviors/dist/esm/utils/user-agent.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isMacOS": () => (/* binding */ isMacOS)
/* harmony export */ });
let isMac = undefined;
function isMacOS() {
  if (isMac === undefined) {
    isMac = /^mac/i.test(window.navigator.platform);
  }
  return isMac;
}

/***/ }),

/***/ "./node_modules/@primer/octicons-react/dist/index.esm.js":
/*!***************************************************************!*\
  !*** ./node_modules/@primer/octicons-react/dist/index.esm.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccessibilityIcon": () => (/* binding */ AccessibilityIcon),
/* harmony export */   "AccessibilityInsetIcon": () => (/* binding */ AccessibilityInsetIcon),
/* harmony export */   "AlertFillIcon": () => (/* binding */ AlertFillIcon),
/* harmony export */   "AlertIcon": () => (/* binding */ AlertIcon),
/* harmony export */   "AppsIcon": () => (/* binding */ AppsIcon),
/* harmony export */   "ArchiveIcon": () => (/* binding */ ArchiveIcon),
/* harmony export */   "ArrowBothIcon": () => (/* binding */ ArrowBothIcon),
/* harmony export */   "ArrowDownIcon": () => (/* binding */ ArrowDownIcon),
/* harmony export */   "ArrowDownLeftIcon": () => (/* binding */ ArrowDownLeftIcon),
/* harmony export */   "ArrowDownRightIcon": () => (/* binding */ ArrowDownRightIcon),
/* harmony export */   "ArrowLeftIcon": () => (/* binding */ ArrowLeftIcon),
/* harmony export */   "ArrowRightIcon": () => (/* binding */ ArrowRightIcon),
/* harmony export */   "ArrowSwitchIcon": () => (/* binding */ ArrowSwitchIcon),
/* harmony export */   "ArrowUpIcon": () => (/* binding */ ArrowUpIcon),
/* harmony export */   "ArrowUpLeftIcon": () => (/* binding */ ArrowUpLeftIcon),
/* harmony export */   "ArrowUpRightIcon": () => (/* binding */ ArrowUpRightIcon),
/* harmony export */   "BeakerIcon": () => (/* binding */ BeakerIcon),
/* harmony export */   "BellFillIcon": () => (/* binding */ BellFillIcon),
/* harmony export */   "BellIcon": () => (/* binding */ BellIcon),
/* harmony export */   "BellSlashIcon": () => (/* binding */ BellSlashIcon),
/* harmony export */   "BlockedIcon": () => (/* binding */ BlockedIcon),
/* harmony export */   "BoldIcon": () => (/* binding */ BoldIcon),
/* harmony export */   "BookIcon": () => (/* binding */ BookIcon),
/* harmony export */   "BookmarkFillIcon": () => (/* binding */ BookmarkFillIcon),
/* harmony export */   "BookmarkIcon": () => (/* binding */ BookmarkIcon),
/* harmony export */   "BookmarkSlashFillIcon": () => (/* binding */ BookmarkSlashFillIcon),
/* harmony export */   "BookmarkSlashIcon": () => (/* binding */ BookmarkSlashIcon),
/* harmony export */   "BriefcaseIcon": () => (/* binding */ BriefcaseIcon),
/* harmony export */   "BroadcastIcon": () => (/* binding */ BroadcastIcon),
/* harmony export */   "BrowserIcon": () => (/* binding */ BrowserIcon),
/* harmony export */   "BugIcon": () => (/* binding */ BugIcon),
/* harmony export */   "CacheIcon": () => (/* binding */ CacheIcon),
/* harmony export */   "CalendarIcon": () => (/* binding */ CalendarIcon),
/* harmony export */   "CheckCircleFillIcon": () => (/* binding */ CheckCircleFillIcon),
/* harmony export */   "CheckCircleIcon": () => (/* binding */ CheckCircleIcon),
/* harmony export */   "CheckIcon": () => (/* binding */ CheckIcon),
/* harmony export */   "CheckboxIcon": () => (/* binding */ CheckboxIcon),
/* harmony export */   "ChecklistIcon": () => (/* binding */ ChecklistIcon),
/* harmony export */   "ChevronDownIcon": () => (/* binding */ ChevronDownIcon),
/* harmony export */   "ChevronLeftIcon": () => (/* binding */ ChevronLeftIcon),
/* harmony export */   "ChevronRightIcon": () => (/* binding */ ChevronRightIcon),
/* harmony export */   "ChevronUpIcon": () => (/* binding */ ChevronUpIcon),
/* harmony export */   "CircleIcon": () => (/* binding */ CircleIcon),
/* harmony export */   "CircleSlashIcon": () => (/* binding */ CircleSlashIcon),
/* harmony export */   "ClockFillIcon": () => (/* binding */ ClockFillIcon),
/* harmony export */   "ClockIcon": () => (/* binding */ ClockIcon),
/* harmony export */   "CloudIcon": () => (/* binding */ CloudIcon),
/* harmony export */   "CloudOfflineIcon": () => (/* binding */ CloudOfflineIcon),
/* harmony export */   "CodeIcon": () => (/* binding */ CodeIcon),
/* harmony export */   "CodeOfConductIcon": () => (/* binding */ CodeOfConductIcon),
/* harmony export */   "CodeReviewIcon": () => (/* binding */ CodeReviewIcon),
/* harmony export */   "CodeSquareIcon": () => (/* binding */ CodeSquareIcon),
/* harmony export */   "CodescanCheckmarkIcon": () => (/* binding */ CodescanCheckmarkIcon),
/* harmony export */   "CodescanIcon": () => (/* binding */ CodescanIcon),
/* harmony export */   "CodespacesIcon": () => (/* binding */ CodespacesIcon),
/* harmony export */   "ColumnsIcon": () => (/* binding */ ColumnsIcon),
/* harmony export */   "CommandPaletteIcon": () => (/* binding */ CommandPaletteIcon),
/* harmony export */   "CommentDiscussionIcon": () => (/* binding */ CommentDiscussionIcon),
/* harmony export */   "CommentIcon": () => (/* binding */ CommentIcon),
/* harmony export */   "CommitIcon": () => (/* binding */ CommitIcon),
/* harmony export */   "ContainerIcon": () => (/* binding */ ContainerIcon),
/* harmony export */   "CopilotErrorIcon": () => (/* binding */ CopilotErrorIcon),
/* harmony export */   "CopilotIcon": () => (/* binding */ CopilotIcon),
/* harmony export */   "CopilotWarningIcon": () => (/* binding */ CopilotWarningIcon),
/* harmony export */   "CopyIcon": () => (/* binding */ CopyIcon),
/* harmony export */   "CpuIcon": () => (/* binding */ CpuIcon),
/* harmony export */   "CreditCardIcon": () => (/* binding */ CreditCardIcon),
/* harmony export */   "CrossReferenceIcon": () => (/* binding */ CrossReferenceIcon),
/* harmony export */   "DashIcon": () => (/* binding */ DashIcon),
/* harmony export */   "DatabaseIcon": () => (/* binding */ DatabaseIcon),
/* harmony export */   "DependabotIcon": () => (/* binding */ DependabotIcon),
/* harmony export */   "DesktopDownloadIcon": () => (/* binding */ DesktopDownloadIcon),
/* harmony export */   "DeviceCameraIcon": () => (/* binding */ DeviceCameraIcon),
/* harmony export */   "DeviceCameraVideoIcon": () => (/* binding */ DeviceCameraVideoIcon),
/* harmony export */   "DeviceDesktopIcon": () => (/* binding */ DeviceDesktopIcon),
/* harmony export */   "DeviceMobileIcon": () => (/* binding */ DeviceMobileIcon),
/* harmony export */   "DevicesIcon": () => (/* binding */ DevicesIcon),
/* harmony export */   "DiamondIcon": () => (/* binding */ DiamondIcon),
/* harmony export */   "DiffAddedIcon": () => (/* binding */ DiffAddedIcon),
/* harmony export */   "DiffIcon": () => (/* binding */ DiffIcon),
/* harmony export */   "DiffIgnoredIcon": () => (/* binding */ DiffIgnoredIcon),
/* harmony export */   "DiffModifiedIcon": () => (/* binding */ DiffModifiedIcon),
/* harmony export */   "DiffRemovedIcon": () => (/* binding */ DiffRemovedIcon),
/* harmony export */   "DiffRenamedIcon": () => (/* binding */ DiffRenamedIcon),
/* harmony export */   "DiscussionClosedIcon": () => (/* binding */ DiscussionClosedIcon),
/* harmony export */   "DiscussionDuplicateIcon": () => (/* binding */ DiscussionDuplicateIcon),
/* harmony export */   "DiscussionOutdatedIcon": () => (/* binding */ DiscussionOutdatedIcon),
/* harmony export */   "DotFillIcon": () => (/* binding */ DotFillIcon),
/* harmony export */   "DotIcon": () => (/* binding */ DotIcon),
/* harmony export */   "DownloadIcon": () => (/* binding */ DownloadIcon),
/* harmony export */   "DuplicateIcon": () => (/* binding */ DuplicateIcon),
/* harmony export */   "EllipsisIcon": () => (/* binding */ EllipsisIcon),
/* harmony export */   "EyeClosedIcon": () => (/* binding */ EyeClosedIcon),
/* harmony export */   "EyeIcon": () => (/* binding */ EyeIcon),
/* harmony export */   "FeedDiscussionIcon": () => (/* binding */ FeedDiscussionIcon),
/* harmony export */   "FeedForkedIcon": () => (/* binding */ FeedForkedIcon),
/* harmony export */   "FeedHeartIcon": () => (/* binding */ FeedHeartIcon),
/* harmony export */   "FeedIssueClosedIcon": () => (/* binding */ FeedIssueClosedIcon),
/* harmony export */   "FeedIssueDraftIcon": () => (/* binding */ FeedIssueDraftIcon),
/* harmony export */   "FeedIssueOpenIcon": () => (/* binding */ FeedIssueOpenIcon),
/* harmony export */   "FeedMergedIcon": () => (/* binding */ FeedMergedIcon),
/* harmony export */   "FeedPersonIcon": () => (/* binding */ FeedPersonIcon),
/* harmony export */   "FeedPlusIcon": () => (/* binding */ FeedPlusIcon),
/* harmony export */   "FeedPublicIcon": () => (/* binding */ FeedPublicIcon),
/* harmony export */   "FeedPullRequestClosedIcon": () => (/* binding */ FeedPullRequestClosedIcon),
/* harmony export */   "FeedPullRequestDraftIcon": () => (/* binding */ FeedPullRequestDraftIcon),
/* harmony export */   "FeedPullRequestOpenIcon": () => (/* binding */ FeedPullRequestOpenIcon),
/* harmony export */   "FeedRepoIcon": () => (/* binding */ FeedRepoIcon),
/* harmony export */   "FeedRocketIcon": () => (/* binding */ FeedRocketIcon),
/* harmony export */   "FeedStarIcon": () => (/* binding */ FeedStarIcon),
/* harmony export */   "FeedTagIcon": () => (/* binding */ FeedTagIcon),
/* harmony export */   "FeedTrophyIcon": () => (/* binding */ FeedTrophyIcon),
/* harmony export */   "FileAddedIcon": () => (/* binding */ FileAddedIcon),
/* harmony export */   "FileBadgeIcon": () => (/* binding */ FileBadgeIcon),
/* harmony export */   "FileBinaryIcon": () => (/* binding */ FileBinaryIcon),
/* harmony export */   "FileCodeIcon": () => (/* binding */ FileCodeIcon),
/* harmony export */   "FileDiffIcon": () => (/* binding */ FileDiffIcon),
/* harmony export */   "FileDirectoryFillIcon": () => (/* binding */ FileDirectoryFillIcon),
/* harmony export */   "FileDirectoryIcon": () => (/* binding */ FileDirectoryIcon),
/* harmony export */   "FileDirectoryOpenFillIcon": () => (/* binding */ FileDirectoryOpenFillIcon),
/* harmony export */   "FileDirectorySymlinkIcon": () => (/* binding */ FileDirectorySymlinkIcon),
/* harmony export */   "FileIcon": () => (/* binding */ FileIcon),
/* harmony export */   "FileMediaIcon": () => (/* binding */ FileMediaIcon),
/* harmony export */   "FileMovedIcon": () => (/* binding */ FileMovedIcon),
/* harmony export */   "FileRemovedIcon": () => (/* binding */ FileRemovedIcon),
/* harmony export */   "FileSubmoduleIcon": () => (/* binding */ FileSubmoduleIcon),
/* harmony export */   "FileSymlinkFileIcon": () => (/* binding */ FileSymlinkFileIcon),
/* harmony export */   "FileZipIcon": () => (/* binding */ FileZipIcon),
/* harmony export */   "FilterIcon": () => (/* binding */ FilterIcon),
/* harmony export */   "FiscalHostIcon": () => (/* binding */ FiscalHostIcon),
/* harmony export */   "FlameIcon": () => (/* binding */ FlameIcon),
/* harmony export */   "FoldDownIcon": () => (/* binding */ FoldDownIcon),
/* harmony export */   "FoldIcon": () => (/* binding */ FoldIcon),
/* harmony export */   "FoldUpIcon": () => (/* binding */ FoldUpIcon),
/* harmony export */   "GearIcon": () => (/* binding */ GearIcon),
/* harmony export */   "GiftIcon": () => (/* binding */ GiftIcon),
/* harmony export */   "GitBranchIcon": () => (/* binding */ GitBranchIcon),
/* harmony export */   "GitCommitIcon": () => (/* binding */ GitCommitIcon),
/* harmony export */   "GitCompareIcon": () => (/* binding */ GitCompareIcon),
/* harmony export */   "GitMergeIcon": () => (/* binding */ GitMergeIcon),
/* harmony export */   "GitMergeQueueIcon": () => (/* binding */ GitMergeQueueIcon),
/* harmony export */   "GitPullRequestClosedIcon": () => (/* binding */ GitPullRequestClosedIcon),
/* harmony export */   "GitPullRequestDraftIcon": () => (/* binding */ GitPullRequestDraftIcon),
/* harmony export */   "GitPullRequestIcon": () => (/* binding */ GitPullRequestIcon),
/* harmony export */   "GlobeIcon": () => (/* binding */ GlobeIcon),
/* harmony export */   "GoalIcon": () => (/* binding */ GoalIcon),
/* harmony export */   "GrabberIcon": () => (/* binding */ GrabberIcon),
/* harmony export */   "GraphIcon": () => (/* binding */ GraphIcon),
/* harmony export */   "HashIcon": () => (/* binding */ HashIcon),
/* harmony export */   "HeadingIcon": () => (/* binding */ HeadingIcon),
/* harmony export */   "HeartFillIcon": () => (/* binding */ HeartFillIcon),
/* harmony export */   "HeartIcon": () => (/* binding */ HeartIcon),
/* harmony export */   "HistoryIcon": () => (/* binding */ HistoryIcon),
/* harmony export */   "HomeFillIcon": () => (/* binding */ HomeFillIcon),
/* harmony export */   "HomeIcon": () => (/* binding */ HomeIcon),
/* harmony export */   "HorizontalRuleIcon": () => (/* binding */ HorizontalRuleIcon),
/* harmony export */   "HourglassIcon": () => (/* binding */ HourglassIcon),
/* harmony export */   "HubotIcon": () => (/* binding */ HubotIcon),
/* harmony export */   "IdBadgeIcon": () => (/* binding */ IdBadgeIcon),
/* harmony export */   "ImageIcon": () => (/* binding */ ImageIcon),
/* harmony export */   "InboxIcon": () => (/* binding */ InboxIcon),
/* harmony export */   "InfinityIcon": () => (/* binding */ InfinityIcon),
/* harmony export */   "InfoIcon": () => (/* binding */ InfoIcon),
/* harmony export */   "IssueClosedIcon": () => (/* binding */ IssueClosedIcon),
/* harmony export */   "IssueDraftIcon": () => (/* binding */ IssueDraftIcon),
/* harmony export */   "IssueOpenedIcon": () => (/* binding */ IssueOpenedIcon),
/* harmony export */   "IssueReopenedIcon": () => (/* binding */ IssueReopenedIcon),
/* harmony export */   "IssueTrackedByIcon": () => (/* binding */ IssueTrackedByIcon),
/* harmony export */   "IssueTracksIcon": () => (/* binding */ IssueTracksIcon),
/* harmony export */   "ItalicIcon": () => (/* binding */ ItalicIcon),
/* harmony export */   "IterationsIcon": () => (/* binding */ IterationsIcon),
/* harmony export */   "KebabHorizontalIcon": () => (/* binding */ KebabHorizontalIcon),
/* harmony export */   "KeyAsteriskIcon": () => (/* binding */ KeyAsteriskIcon),
/* harmony export */   "KeyIcon": () => (/* binding */ KeyIcon),
/* harmony export */   "LawIcon": () => (/* binding */ LawIcon),
/* harmony export */   "LightBulbIcon": () => (/* binding */ LightBulbIcon),
/* harmony export */   "LinkExternalIcon": () => (/* binding */ LinkExternalIcon),
/* harmony export */   "LinkIcon": () => (/* binding */ LinkIcon),
/* harmony export */   "ListOrderedIcon": () => (/* binding */ ListOrderedIcon),
/* harmony export */   "ListUnorderedIcon": () => (/* binding */ ListUnorderedIcon),
/* harmony export */   "LocationIcon": () => (/* binding */ LocationIcon),
/* harmony export */   "LockIcon": () => (/* binding */ LockIcon),
/* harmony export */   "LogIcon": () => (/* binding */ LogIcon),
/* harmony export */   "LogoGistIcon": () => (/* binding */ LogoGistIcon),
/* harmony export */   "LogoGithubIcon": () => (/* binding */ LogoGithubIcon),
/* harmony export */   "MailIcon": () => (/* binding */ MailIcon),
/* harmony export */   "MarkGithubIcon": () => (/* binding */ MarkGithubIcon),
/* harmony export */   "MarkdownIcon": () => (/* binding */ MarkdownIcon),
/* harmony export */   "MegaphoneIcon": () => (/* binding */ MegaphoneIcon),
/* harmony export */   "MentionIcon": () => (/* binding */ MentionIcon),
/* harmony export */   "MeterIcon": () => (/* binding */ MeterIcon),
/* harmony export */   "MilestoneIcon": () => (/* binding */ MilestoneIcon),
/* harmony export */   "MirrorIcon": () => (/* binding */ MirrorIcon),
/* harmony export */   "MoonIcon": () => (/* binding */ MoonIcon),
/* harmony export */   "MortarBoardIcon": () => (/* binding */ MortarBoardIcon),
/* harmony export */   "MoveToBottomIcon": () => (/* binding */ MoveToBottomIcon),
/* harmony export */   "MoveToEndIcon": () => (/* binding */ MoveToEndIcon),
/* harmony export */   "MoveToStartIcon": () => (/* binding */ MoveToStartIcon),
/* harmony export */   "MoveToTopIcon": () => (/* binding */ MoveToTopIcon),
/* harmony export */   "MultiSelectIcon": () => (/* binding */ MultiSelectIcon),
/* harmony export */   "MuteIcon": () => (/* binding */ MuteIcon),
/* harmony export */   "NoEntryFillIcon": () => (/* binding */ NoEntryFillIcon),
/* harmony export */   "NoEntryIcon": () => (/* binding */ NoEntryIcon),
/* harmony export */   "NorthStarIcon": () => (/* binding */ NorthStarIcon),
/* harmony export */   "NoteIcon": () => (/* binding */ NoteIcon),
/* harmony export */   "NumberIcon": () => (/* binding */ NumberIcon),
/* harmony export */   "OrganizationIcon": () => (/* binding */ OrganizationIcon),
/* harmony export */   "PackageDependenciesIcon": () => (/* binding */ PackageDependenciesIcon),
/* harmony export */   "PackageDependentsIcon": () => (/* binding */ PackageDependentsIcon),
/* harmony export */   "PackageIcon": () => (/* binding */ PackageIcon),
/* harmony export */   "PaintbrushIcon": () => (/* binding */ PaintbrushIcon),
/* harmony export */   "PaperAirplaneIcon": () => (/* binding */ PaperAirplaneIcon),
/* harmony export */   "PaperclipIcon": () => (/* binding */ PaperclipIcon),
/* harmony export */   "PasskeyFillIcon": () => (/* binding */ PasskeyFillIcon),
/* harmony export */   "PasteIcon": () => (/* binding */ PasteIcon),
/* harmony export */   "PencilIcon": () => (/* binding */ PencilIcon),
/* harmony export */   "PeopleIcon": () => (/* binding */ PeopleIcon),
/* harmony export */   "PersonAddIcon": () => (/* binding */ PersonAddIcon),
/* harmony export */   "PersonFillIcon": () => (/* binding */ PersonFillIcon),
/* harmony export */   "PersonIcon": () => (/* binding */ PersonIcon),
/* harmony export */   "PinIcon": () => (/* binding */ PinIcon),
/* harmony export */   "PinSlashIcon": () => (/* binding */ PinSlashIcon),
/* harmony export */   "PivotColumnIcon": () => (/* binding */ PivotColumnIcon),
/* harmony export */   "PlayIcon": () => (/* binding */ PlayIcon),
/* harmony export */   "PlugIcon": () => (/* binding */ PlugIcon),
/* harmony export */   "PlusCircleIcon": () => (/* binding */ PlusCircleIcon),
/* harmony export */   "PlusIcon": () => (/* binding */ PlusIcon),
/* harmony export */   "ProjectIcon": () => (/* binding */ ProjectIcon),
/* harmony export */   "ProjectRoadmapIcon": () => (/* binding */ ProjectRoadmapIcon),
/* harmony export */   "ProjectSymlinkIcon": () => (/* binding */ ProjectSymlinkIcon),
/* harmony export */   "ProjectTemplateIcon": () => (/* binding */ ProjectTemplateIcon),
/* harmony export */   "PulseIcon": () => (/* binding */ PulseIcon),
/* harmony export */   "QuestionIcon": () => (/* binding */ QuestionIcon),
/* harmony export */   "QuoteIcon": () => (/* binding */ QuoteIcon),
/* harmony export */   "ReadIcon": () => (/* binding */ ReadIcon),
/* harmony export */   "RedoIcon": () => (/* binding */ RedoIcon),
/* harmony export */   "RelFilePathIcon": () => (/* binding */ RelFilePathIcon),
/* harmony export */   "ReplyIcon": () => (/* binding */ ReplyIcon),
/* harmony export */   "RepoCloneIcon": () => (/* binding */ RepoCloneIcon),
/* harmony export */   "RepoDeletedIcon": () => (/* binding */ RepoDeletedIcon),
/* harmony export */   "RepoForkedIcon": () => (/* binding */ RepoForkedIcon),
/* harmony export */   "RepoIcon": () => (/* binding */ RepoIcon),
/* harmony export */   "RepoLockedIcon": () => (/* binding */ RepoLockedIcon),
/* harmony export */   "RepoPullIcon": () => (/* binding */ RepoPullIcon),
/* harmony export */   "RepoPushIcon": () => (/* binding */ RepoPushIcon),
/* harmony export */   "RepoTemplateIcon": () => (/* binding */ RepoTemplateIcon),
/* harmony export */   "ReportIcon": () => (/* binding */ ReportIcon),
/* harmony export */   "RocketIcon": () => (/* binding */ RocketIcon),
/* harmony export */   "RowsIcon": () => (/* binding */ RowsIcon),
/* harmony export */   "RssIcon": () => (/* binding */ RssIcon),
/* harmony export */   "RubyIcon": () => (/* binding */ RubyIcon),
/* harmony export */   "ScreenFullIcon": () => (/* binding */ ScreenFullIcon),
/* harmony export */   "ScreenNormalIcon": () => (/* binding */ ScreenNormalIcon),
/* harmony export */   "SearchIcon": () => (/* binding */ SearchIcon),
/* harmony export */   "ServerIcon": () => (/* binding */ ServerIcon),
/* harmony export */   "ShareAndroidIcon": () => (/* binding */ ShareAndroidIcon),
/* harmony export */   "ShareIcon": () => (/* binding */ ShareIcon),
/* harmony export */   "ShieldCheckIcon": () => (/* binding */ ShieldCheckIcon),
/* harmony export */   "ShieldIcon": () => (/* binding */ ShieldIcon),
/* harmony export */   "ShieldLockIcon": () => (/* binding */ ShieldLockIcon),
/* harmony export */   "ShieldSlashIcon": () => (/* binding */ ShieldSlashIcon),
/* harmony export */   "ShieldXIcon": () => (/* binding */ ShieldXIcon),
/* harmony export */   "SidebarCollapseIcon": () => (/* binding */ SidebarCollapseIcon),
/* harmony export */   "SidebarExpandIcon": () => (/* binding */ SidebarExpandIcon),
/* harmony export */   "SignInIcon": () => (/* binding */ SignInIcon),
/* harmony export */   "SignOutIcon": () => (/* binding */ SignOutIcon),
/* harmony export */   "SingleSelectIcon": () => (/* binding */ SingleSelectIcon),
/* harmony export */   "SkipFillIcon": () => (/* binding */ SkipFillIcon),
/* harmony export */   "SkipIcon": () => (/* binding */ SkipIcon),
/* harmony export */   "SlidersIcon": () => (/* binding */ SlidersIcon),
/* harmony export */   "SmileyIcon": () => (/* binding */ SmileyIcon),
/* harmony export */   "SortAscIcon": () => (/* binding */ SortAscIcon),
/* harmony export */   "SortDescIcon": () => (/* binding */ SortDescIcon),
/* harmony export */   "SparkleFillIcon": () => (/* binding */ SparkleFillIcon),
/* harmony export */   "SponsorTiersIcon": () => (/* binding */ SponsorTiersIcon),
/* harmony export */   "SquareFillIcon": () => (/* binding */ SquareFillIcon),
/* harmony export */   "SquareIcon": () => (/* binding */ SquareIcon),
/* harmony export */   "SquirrelIcon": () => (/* binding */ SquirrelIcon),
/* harmony export */   "StackIcon": () => (/* binding */ StackIcon),
/* harmony export */   "StarFillIcon": () => (/* binding */ StarFillIcon),
/* harmony export */   "StarIcon": () => (/* binding */ StarIcon),
/* harmony export */   "StopIcon": () => (/* binding */ StopIcon),
/* harmony export */   "StopwatchIcon": () => (/* binding */ StopwatchIcon),
/* harmony export */   "StrikethroughIcon": () => (/* binding */ StrikethroughIcon),
/* harmony export */   "SunIcon": () => (/* binding */ SunIcon),
/* harmony export */   "SyncIcon": () => (/* binding */ SyncIcon),
/* harmony export */   "TabExternalIcon": () => (/* binding */ TabExternalIcon),
/* harmony export */   "TabIcon": () => (/* binding */ TabIcon),
/* harmony export */   "TableIcon": () => (/* binding */ TableIcon),
/* harmony export */   "TagIcon": () => (/* binding */ TagIcon),
/* harmony export */   "TasklistIcon": () => (/* binding */ TasklistIcon),
/* harmony export */   "TelescopeFillIcon": () => (/* binding */ TelescopeFillIcon),
/* harmony export */   "TelescopeIcon": () => (/* binding */ TelescopeIcon),
/* harmony export */   "TerminalIcon": () => (/* binding */ TerminalIcon),
/* harmony export */   "ThreeBarsIcon": () => (/* binding */ ThreeBarsIcon),
/* harmony export */   "ThumbsdownIcon": () => (/* binding */ ThumbsdownIcon),
/* harmony export */   "ThumbsupIcon": () => (/* binding */ ThumbsupIcon),
/* harmony export */   "ToolsIcon": () => (/* binding */ ToolsIcon),
/* harmony export */   "TrackedByClosedCompletedIcon": () => (/* binding */ TrackedByClosedCompletedIcon),
/* harmony export */   "TrackedByClosedNotPlannedIcon": () => (/* binding */ TrackedByClosedNotPlannedIcon),
/* harmony export */   "TrashIcon": () => (/* binding */ TrashIcon),
/* harmony export */   "TriangleDownIcon": () => (/* binding */ TriangleDownIcon),
/* harmony export */   "TriangleLeftIcon": () => (/* binding */ TriangleLeftIcon),
/* harmony export */   "TriangleRightIcon": () => (/* binding */ TriangleRightIcon),
/* harmony export */   "TriangleUpIcon": () => (/* binding */ TriangleUpIcon),
/* harmony export */   "TrophyIcon": () => (/* binding */ TrophyIcon),
/* harmony export */   "TypographyIcon": () => (/* binding */ TypographyIcon),
/* harmony export */   "UndoIcon": () => (/* binding */ UndoIcon),
/* harmony export */   "UnfoldIcon": () => (/* binding */ UnfoldIcon),
/* harmony export */   "UnlinkIcon": () => (/* binding */ UnlinkIcon),
/* harmony export */   "UnlockIcon": () => (/* binding */ UnlockIcon),
/* harmony export */   "UnmuteIcon": () => (/* binding */ UnmuteIcon),
/* harmony export */   "UnreadIcon": () => (/* binding */ UnreadIcon),
/* harmony export */   "UnverifiedIcon": () => (/* binding */ UnverifiedIcon),
/* harmony export */   "UploadIcon": () => (/* binding */ UploadIcon),
/* harmony export */   "VerifiedIcon": () => (/* binding */ VerifiedIcon),
/* harmony export */   "VersionsIcon": () => (/* binding */ VersionsIcon),
/* harmony export */   "VideoIcon": () => (/* binding */ VideoIcon),
/* harmony export */   "WebhookIcon": () => (/* binding */ WebhookIcon),
/* harmony export */   "WorkflowIcon": () => (/* binding */ WorkflowIcon),
/* harmony export */   "XCircleFillIcon": () => (/* binding */ XCircleFillIcon),
/* harmony export */   "XCircleIcon": () => (/* binding */ XCircleIcon),
/* harmony export */   "XIcon": () => (/* binding */ XIcon),
/* harmony export */   "ZapIcon": () => (/* binding */ ZapIcon),
/* harmony export */   "ZoomInIcon": () => (/* binding */ ZoomInIcon),
/* harmony export */   "ZoomOutIcon": () => (/* binding */ ZoomOutIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

var sizeMap = {
  small: 16,
  medium: 32,
  large: 64
};
function createIconComponent(name, defaultClassName, getSVGData) {
  var svgDataByHeight = getSVGData();
  var heights = Object.keys(svgDataByHeight);
  var Icon = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(function (_ref, forwardedRef) {
    var ariaLabel = _ref['aria-label'],
      arialabelledby = _ref['aria-labelledby'],
      tabIndex = _ref.tabIndex,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? defaultClassName : _ref$className,
      _ref$fill = _ref.fill,
      fill = _ref$fill === void 0 ? 'currentColor' : _ref$fill,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 16 : _ref$size,
      _ref$verticalAlign = _ref.verticalAlign,
      verticalAlign = _ref$verticalAlign === void 0 ? 'text-bottom' : _ref$verticalAlign,
      id = _ref.id,
      title = _ref.title;
    var height = sizeMap[size] || size;
    var naturalHeight = closestNaturalHeight(heights, height);
    var naturalWidth = svgDataByHeight[naturalHeight].width;
    var width = height * (naturalWidth / naturalHeight);
    var path = svgDataByHeight[naturalHeight].path;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", {
      ref: forwardedRef,
      "aria-hidden": ariaLabel ? 'false' : 'true',
      tabIndex: tabIndex,
      focusable: tabIndex >= 0 ? 'true' : 'false',
      "aria-label": ariaLabel,
      "aria-labelledby": arialabelledby,
      role: "img",
      className: className,
      viewBox: "0 0 ".concat(naturalWidth, " ").concat(naturalHeight),
      width: width,
      height: height,
      fill: fill,
      id: id,
      style: {
        display: 'inline-block',
        userSelect: 'none',
        verticalAlign: verticalAlign,
        overflow: 'visible'
      }
    }, title ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("title", null, title) : null, path);
  });
  Icon.displayName = name;
  return Icon;
}
function closestNaturalHeight(naturalHeights, height) {
  return naturalHeights.map(function (naturalHeight) {
    return parseInt(naturalHeight, 10);
  }).reduce(function (acc, naturalHeight) {
    return naturalHeight <= height ? naturalHeight : acc;
  }, naturalHeights[0]);
}

/* THIS FILE IS GENERATED. DO NOT EDIT IT. */
var AccessibilityIcon = /*#__PURE__*/createIconComponent("AccessibilityIcon", "octicon octicon-accessibility", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.923 5.302c.063.063.122.129.178.198H14A.75.75 0 0 1 14 7h-3.3l.578 5.163.362 2.997a.75.75 0 0 1-1.49.18L9.868 13H6.132l-.282 2.34a.75.75 0 0 1-1.49-.18l.362-2.997L5.3 7H2a.75.75 0 0 1 0-1.5h3.9a2.54 2.54 0 0 1 .176-.198 3 3 0 1 1 3.847 0ZM9.2 7.073h-.001a1.206 1.206 0 0 0-2.398 0L6.305 11.5h3.39ZM9.5 3a1.5 1.5 0 1 0-3.001.001A1.5 1.5 0 0 0 9.5 3Z"
      })
    }
  };
});
var AccessibilityInsetIcon = /*#__PURE__*/createIconComponent("AccessibilityInsetIcon", "octicon octicon-accessibility-inset", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0Zm2 4a2 2 0 1 0-2.95 1.76 1.87 1.87 0 0 0-.32.24H3.75a.75.75 0 0 0 0 1.5h2.363l-.607 5.67a.75.75 0 1 0 1.49.16l.25-2.33h1.508l.25 2.33a.75.75 0 0 0 1.492-.16L9.888 7.5h2.362a.75.75 0 0 0 0-1.5H9.27a1.98 1.98 0 0 0-.32-.24A2 2 0 0 0 10 4Z"
      })
    }
  };
});
var AlertIcon = /*#__PURE__*/createIconComponent("AlertIcon", "octicon octicon-alert", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.457 1.047c.659-1.234 2.427-1.234 3.086 0l6.082 11.378A1.75 1.75 0 0 1 14.082 15H1.918a1.75 1.75 0 0 1-1.543-2.575Zm1.763.707a.25.25 0 0 0-.44 0L1.698 13.132a.25.25 0 0 0 .22.368h12.164a.25.25 0 0 0 .22-.368Zm.53 3.996v2.5a.75.75 0 0 1-1.5 0v-2.5a.75.75 0 0 1 1.5 0ZM9 11a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13 17.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-.25-8.25a.75.75 0 0 0-1.5 0v4.5a.75.75 0 0 0 1.5 0v-4.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.836 3.244c.963-1.665 3.365-1.665 4.328 0l8.967 15.504c.963 1.667-.24 3.752-2.165 3.752H3.034c-1.926 0-3.128-2.085-2.165-3.752Zm3.03.751a1.002 1.002 0 0 0-1.732 0L2.168 19.499A1.002 1.002 0 0 0 3.034 21h17.932a1.002 1.002 0 0 0 .866-1.5L12.866 3.994Z"
      }))
    }
  };
});
var AlertFillIcon = /*#__PURE__*/createIconComponent("AlertFillIcon", "octicon octicon-alert-fill", function () {
  return {
    "12": {
      "width": 12,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.855.708c.5-.896 1.79-.896 2.29 0l4.675 8.351a1.312 1.312 0 0 1-1.146 1.954H1.33A1.313 1.313 0 0 1 .183 9.058ZM7 7V3H5v4Zm-1 3a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
      })
    },
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.457 1.047c.659-1.234 2.427-1.234 3.086 0l6.082 11.378A1.75 1.75 0 0 1 14.082 15H1.918a1.75 1.75 0 0 1-1.543-2.575ZM8 5a.75.75 0 0 0-.75.75v2.5a.75.75 0 0 0 1.5 0v-2.5A.75.75 0 0 0 8 5Zm1 6a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.836 3.244c.963-1.665 3.365-1.665 4.328 0l8.967 15.504c.963 1.667-.24 3.752-2.165 3.752H3.034c-1.926 0-3.128-2.085-2.165-3.752ZM12 8.5a.75.75 0 0 0-.75.75v4.5a.75.75 0 0 0 1.5 0v-4.5A.75.75 0 0 0 12 8.5Zm1 9a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"
      })
    }
  };
});
var AppsIcon = /*#__PURE__*/createIconComponent("AppsIcon", "octicon octicon-apps", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 3.25c0-.966.784-1.75 1.75-1.75h2.5c.966 0 1.75.784 1.75 1.75v2.5A1.75 1.75 0 0 1 5.75 7.5h-2.5A1.75 1.75 0 0 1 1.5 5.75Zm7 0c0-.966.784-1.75 1.75-1.75h2.5c.966 0 1.75.784 1.75 1.75v2.5a1.75 1.75 0 0 1-1.75 1.75h-2.5A1.75 1.75 0 0 1 8.5 5.75Zm-7 7c0-.966.784-1.75 1.75-1.75h2.5c.966 0 1.75.784 1.75 1.75v2.5a1.75 1.75 0 0 1-1.75 1.75h-2.5a1.75 1.75 0 0 1-1.75-1.75Zm7 0c0-.966.784-1.75 1.75-1.75h2.5c.966 0 1.75.784 1.75 1.75v2.5a1.75 1.75 0 0 1-1.75 1.75h-2.5a1.75 1.75 0 0 1-1.75-1.75ZM3.25 3a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25h2.5A.25.25 0 0 0 6 5.75v-2.5A.25.25 0 0 0 5.75 3Zm7 0a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25h2.5a.25.25 0 0 0 .25-.25v-2.5a.25.25 0 0 0-.25-.25Zm-7 7a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25h2.5a.25.25 0 0 0 .25-.25v-2.5a.25.25 0 0 0-.25-.25Zm7 0a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25h2.5a.25.25 0 0 0 .25-.25v-2.5a.25.25 0 0 0-.25-.25Z"
      })
    }
  };
});
var ArchiveIcon = /*#__PURE__*/createIconComponent("ArchiveIcon", "octicon octicon-archive", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.784.784 1 1.75 1h12.5c.966 0 1.75.784 1.75 1.75v1.5A1.75 1.75 0 0 1 14.25 6H1.75A1.75 1.75 0 0 1 0 4.25ZM1.75 7a.75.75 0 0 1 .75.75v5.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25v-5.5a.75.75 0 0 1 1.5 0v5.5A1.75 1.75 0 0 1 13.25 15H2.75A1.75 1.75 0 0 1 1 13.25v-5.5A.75.75 0 0 1 1.75 7Zm0-4.5a.25.25 0 0 0-.25.25v1.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-1.5a.25.25 0 0 0-.25-.25ZM6.25 8h3.5a.75.75 0 0 1 0 1.5h-3.5a.75.75 0 0 1 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 2h18.5c.966 0 1.75.784 1.75 1.75v3.5A1.75 1.75 0 0 1 21.25 9H2.75A1.75 1.75 0 0 1 1 7.25v-3.5C1 2.784 1.784 2 2.75 2Zm18.5 1.5H2.75a.25.25 0 0 0-.25.25v3.5c0 .138.112.25.25.25h18.5a.25.25 0 0 0 .25-.25v-3.5a.25.25 0 0 0-.25-.25ZM2.75 10a.75.75 0 0 1 .75.75v9.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25v-9.5a.75.75 0 0 1 1.5 0v9.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25v-9.5a.75.75 0 0 1 .75-.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.75 11.5a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5Z"
      }))
    }
  };
});
var ArrowBothIcon = /*#__PURE__*/createIconComponent("ArrowBothIcon", "octicon octicon-arrow-both", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.72 3.72a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042L2.56 7h10.88l-2.22-2.22a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018l3.5 3.5a.75.75 0 0 1 0 1.06l-3.5 3.5a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l2.22-2.22H2.56l2.22 2.22a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-3.5-3.5a.75.75 0 0 1 0-1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.78 5.97a.75.75 0 0 0-1.06 0l-5.25 5.25a.75.75 0 0 0 0 1.06l5.25 5.25a.75.75 0 0 0 1.06-1.06L3.81 12.5h16.38l-3.97 3.97a.75.75 0 1 0 1.06 1.06l5.25-5.25a.75.75 0 0 0 0-1.06l-5.25-5.25a.75.75 0 1 0-1.06 1.06L20.19 11H3.81l3.97-3.97a.75.75 0 0 0 0-1.06Z"
      })
    }
  };
});
var ArrowDownIcon = /*#__PURE__*/createIconComponent("ArrowDownIcon", "octicon octicon-arrow-down", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.03 8.22a.75.75 0 0 1 0 1.06l-4.25 4.25a.75.75 0 0 1-1.06 0L3.47 9.28a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018l2.97 2.97V3.75a.75.75 0 0 1 1.5 0v7.44l2.97-2.97a.75.75 0 0 1 1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.97 13.22a.75.75 0 0 1 1.06 0L11 18.19V3.75a.75.75 0 0 1 1.5 0v14.44l4.97-4.97a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734l-6.25 6.25a.75.75 0 0 1-1.06 0l-6.25-6.25a.75.75 0 0 1 0-1.06Z"
      })
    }
  };
});
var ArrowDownLeftIcon = /*#__PURE__*/createIconComponent("ArrowDownLeftIcon", "octicon octicon-arrow-down-left", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.78 4.22a.75.75 0 0 1 0 1.06l-5.26 5.26h4.2a.75.75 0 0 1 0 1.5H4.71a.75.75 0 0 1-.75-.75V5.28a.75.75 0 0 1 1.5 0v4.2l5.26-5.26a.75.75 0 0 1 1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 8.5a.75.75 0 0 1 .75.75v7.19L16.72 6.22a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042L7.56 17.5h7.19a.75.75 0 0 1 0 1.5h-9a.75.75 0 0 1-.75-.75v-9a.75.75 0 0 1 .75-.75Z"
      })
    }
  };
});
var ArrowDownRightIcon = /*#__PURE__*/createIconComponent("ArrowDownRightIcon", "octicon octicon-arrow-down-right", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.22 4.179a.75.75 0 0 1 1.06 0l5.26 5.26v-4.2a.75.75 0 0 1 1.5 0v6.01a.75.75 0 0 1-.75.75H5.28a.75.75 0 0 1 0-1.5h4.2L4.22 5.24a.75.75 0 0 1 0-1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M18.25 8.5a.75.75 0 0 1 .75.75v9a.75.75 0 0 1-.75.75h-9a.75.75 0 0 1 0-1.5h7.19L6.22 7.28a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018L17.5 16.44V9.25a.75.75 0 0 1 .75-.75Z"
      })
    }
  };
});
var ArrowLeftIcon = /*#__PURE__*/createIconComponent("ArrowLeftIcon", "octicon octicon-arrow-left", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.78 12.53a.75.75 0 0 1-1.06 0L2.47 8.28a.75.75 0 0 1 0-1.06l4.25-4.25a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042L4.81 7h7.44a.75.75 0 0 1 0 1.5H4.81l2.97 2.97a.75.75 0 0 1 0 1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.78 19.03a.75.75 0 0 1-1.06 0l-6.25-6.25a.75.75 0 0 1 0-1.06l6.25-6.25a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734L5.81 11.5h14.44a.75.75 0 0 1 0 1.5H5.81l4.97 4.97a.75.75 0 0 1 0 1.06Z"
      })
    }
  };
});
var ArrowRightIcon = /*#__PURE__*/createIconComponent("ArrowRightIcon", "octicon octicon-arrow-right", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.22 2.97a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042l2.97-2.97H3.75a.75.75 0 0 1 0-1.5h7.44L8.22 4.03a.75.75 0 0 1 0-1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.22 19.03a.75.75 0 0 1 0-1.06L18.19 13H3.75a.75.75 0 0 1 0-1.5h14.44l-4.97-4.97a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215l6.25 6.25a.75.75 0 0 1 0 1.06l-6.25 6.25a.75.75 0 0 1-1.06 0Z"
      })
    }
  };
});
var ArrowSwitchIcon = /*#__PURE__*/createIconComponent("ArrowSwitchIcon", "octicon octicon-arrow-switch", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.22 14.78a.75.75 0 0 0 1.06-1.06L4.56 12h8.69a.75.75 0 0 0 0-1.5H4.56l1.72-1.72a.75.75 0 0 0-1.06-1.06l-3 3a.75.75 0 0 0 0 1.06l3 3Zm5.56-6.5a.75.75 0 1 1-1.06-1.06l1.72-1.72H2.75a.75.75 0 0 1 0-1.5h8.69L9.72 2.28a.75.75 0 0 1 1.06-1.06l3 3a.75.75 0 0 1 0 1.06l-3 3Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.72 21.78a.75.75 0 0 0 1.06-1.06L5.56 17.5h14.69a.75.75 0 0 0 0-1.5H5.56l3.22-3.22a.75.75 0 1 0-1.06-1.06l-4.5 4.5a.75.75 0 0 0 0 1.06l4.5 4.5Zm8.56-9.5a.75.75 0 1 1-1.06-1.06L18.44 8H3.75a.75.75 0 0 1 0-1.5h14.69l-3.22-3.22a.75.75 0 0 1 1.06-1.06l4.5 4.5a.75.75 0 0 1 0 1.06l-4.5 4.5Z"
      })
    }
  };
});
var ArrowUpIcon = /*#__PURE__*/createIconComponent("ArrowUpIcon", "octicon octicon-arrow-up", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.47 7.78a.75.75 0 0 1 0-1.06l4.25-4.25a.75.75 0 0 1 1.06 0l4.25 4.25a.751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018L9 4.81v7.44a.75.75 0 0 1-1.5 0V4.81L4.53 7.78a.75.75 0 0 1-1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M18.655 10.405a.75.75 0 0 1-1.06 0l-4.97-4.97v14.44a.75.75 0 0 1-1.5 0V5.435l-4.97 4.97a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l6.25-6.25a.75.75 0 0 1 1.06 0l6.25 6.25a.75.75 0 0 1 0 1.06Z"
      })
    }
  };
});
var ArrowUpLeftIcon = /*#__PURE__*/createIconComponent("ArrowUpLeftIcon", "octicon octicon-arrow-up-left", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.96 4.75A.75.75 0 0 1 4.71 4h6.01a.75.75 0 0 1 0 1.5h-4.2l5.26 5.26a.75.75 0 0 1-1.06 1.061l-5.26-5.26v4.2a.75.75 0 0 1-1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 15.5a.75.75 0 0 1-.75-.75v-9A.75.75 0 0 1 5.75 5h9a.75.75 0 0 1 0 1.5H7.56l10.22 10.22a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L6.5 7.56v7.19a.75.75 0 0 1-.75.75Z"
      })
    }
  };
});
var ArrowUpRightIcon = /*#__PURE__*/createIconComponent("ArrowUpRightIcon", "octicon octicon-arrow-up-right", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.53 4.75A.75.75 0 0 1 5.28 4h6.01a.75.75 0 0 1 .75.75v6.01a.75.75 0 0 1-1.5 0v-4.2l-5.26 5.261a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734L9.48 5.5h-4.2a.75.75 0 0 1-.75-.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M18.25 15.5a.75.75 0 0 1-.75-.75V7.56L7.28 17.78a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734L16.44 6.5H9.25a.75.75 0 0 1 0-1.5h9a.75.75 0 0 1 .75.75v9a.75.75 0 0 1-.75.75Z"
      })
    }
  };
});
var BeakerIcon = /*#__PURE__*/createIconComponent("BeakerIcon", "octicon octicon-beaker", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 5.782V2.5h-.25a.75.75 0 0 1 0-1.5h6.5a.75.75 0 0 1 0 1.5H11v3.282l3.666 5.76C15.619 13.04 14.543 15 12.767 15H3.233c-1.776 0-2.852-1.96-1.899-3.458Zm-2.4 6.565a.75.75 0 0 0 .633 1.153h9.534a.75.75 0 0 0 .633-1.153L12.225 10.5h-8.45ZM9.5 2.5h-3V6c0 .143-.04.283-.117.403L4.73 9h6.54L9.617 6.403A.746.746 0 0 1 9.5 6Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 8.807V3.5h-.563a.75.75 0 0 1 0-1.5h9.125a.75.75 0 0 1 0 1.5H16v5.307l5.125 9.301c.964 1.75-.302 3.892-2.299 3.892H5.174c-1.998 0-3.263-2.142-2.3-3.892ZM4.189 18.832a1.123 1.123 0 0 0 .985 1.668h13.652a1.123 1.123 0 0 0 .985-1.668L17.7 15H6.3ZM14.5 3.5h-5V9a.75.75 0 0 1-.093.362L7.127 13.5h9.746l-2.28-4.138A.75.75 0 0 1 14.5 9Z"
      })
    }
  };
});
var BellIcon = /*#__PURE__*/createIconComponent("BellIcon", "octicon octicon-bell", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16a2 2 0 0 0 1.985-1.75c.017-.137-.097-.25-.235-.25h-3.5c-.138 0-.252.113-.235.25A2 2 0 0 0 8 16ZM3 5a5 5 0 0 1 10 0v2.947c0 .05.015.098.042.139l1.703 2.555A1.519 1.519 0 0 1 13.482 13H2.518a1.516 1.516 0 0 1-1.263-2.36l1.703-2.554A.255.255 0 0 0 3 7.947Zm5-3.5A3.5 3.5 0 0 0 4.5 5v2.947c0 .346-.102.683-.294.97l-1.703 2.556a.017.017 0 0 0-.003.01l.001.006c0 .002.002.004.004.006l.006.004.007.001h10.964l.007-.001.006-.004.004-.006.001-.007a.017.017 0 0 0-.003-.01l-1.703-2.554a1.745 1.745 0 0 1-.294-.97V5A3.5 3.5 0 0 0 8 1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c3.681 0 7 2.565 7 6v4.539c0 .642.189 1.269.545 1.803l2.2 3.298A1.517 1.517 0 0 1 20.482 19H15.5a3.5 3.5 0 1 1-7 0H3.519a1.518 1.518 0 0 1-1.265-2.359l2.2-3.299A3.25 3.25 0 0 0 5 11.539V7c0-3.435 3.318-6 7-6ZM6.5 7v4.539a4.75 4.75 0 0 1-.797 2.635l-2.2 3.298-.003.01.001.007.004.006.006.004.007.001h16.964l.007-.001.006-.004.004-.006.001-.006a.017.017 0 0 0-.003-.01l-2.199-3.299a4.753 4.753 0 0 1-.798-2.635V7c0-2.364-2.383-4.5-5.5-4.5S6.5 4.636 6.5 7ZM14 19h-4a2 2 0 1 0 4 0Z"
      })
    }
  };
});
var BellFillIcon = /*#__PURE__*/createIconComponent("BellFillIcon", "octicon octicon-bell-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16c.9 0 1.7-.6 1.9-1.5.1-.3-.1-.5-.4-.5h-3c-.3 0-.5.2-.4.5.2.9 1 1.5 1.9 1.5ZM3 5c0-2.8 2.2-5 5-5s5 2.2 5 5v3l1.7 2.6c.2.2.3.5.3.8 0 .8-.7 1.5-1.5 1.5h-11c-.8.1-1.5-.6-1.5-1.4 0-.3.1-.6.3-.8L3 8.1V5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 8a6 6 0 1 1 12 0v2.917c0 .703.228 1.387.65 1.95L20.7 15.6a1.5 1.5 0 0 1-1.2 2.4h-15a1.5 1.5 0 0 1-1.2-2.4l2.05-2.733a3.25 3.25 0 0 0 .65-1.95Zm6 13.5A3.502 3.502 0 0 1 8.645 19h6.71A3.502 3.502 0 0 1 12 21.5Z"
      })
    }
  };
});
var BellSlashIcon = /*#__PURE__*/createIconComponent("BellSlashIcon", "octicon octicon-bell-slash", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m4.182 4.31.016.011 10.104 7.316.013.01 1.375.996a.75.75 0 1 1-.88 1.214L13.626 13H2.518a1.516 1.516 0 0 1-1.263-2.36l1.703-2.554A.255.255 0 0 0 3 7.947V5.305L.31 3.357a.75.75 0 1 1 .88-1.214Zm7.373 7.19L4.5 6.391v1.556c0 .346-.102.683-.294.97l-1.703 2.556a.017.017 0 0 0-.003.01c0 .005.002.009.005.012l.006.004.007.001ZM8 1.5c-.997 0-1.895.416-2.534 1.086A.75.75 0 1 1 4.38 1.55 5 5 0 0 1 13 5v2.373a.75.75 0 0 1-1.5 0V5A3.5 3.5 0 0 0 8 1.5ZM8 16a2 2 0 0 1-1.985-1.75c-.017-.137.097-.25.235-.25h3.5c.138 0 .252.113.235.25A2 2 0 0 1 8 16Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.22 1.22a.75.75 0 0 1 1.06 0l20.5 20.5a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L17.94 19H15.5a3.5 3.5 0 1 1-7 0H3.518a1.516 1.516 0 0 1-1.263-2.36l2.2-3.298A3.249 3.249 0 0 0 5 11.539V7c0-.294.025-.583.073-.866L1.22 2.28a.75.75 0 0 1 0-1.06ZM6.5 7.56h-.001v3.979a4.75 4.75 0 0 1-.797 2.635l-2.2 3.298-.003.01.001.007.004.006.006.004.007.001H16.44ZM10 19a2 2 0 1 0 4 0Zm2-16.5c-1.463 0-2.8.485-3.788 1.257l-.04.032a.75.75 0 1 1-.935-1.173l.05-.04C8.548 1.59 10.212 1 12 1c3.681 0 7 2.565 7 6v4.539c0 .642.19 1.269.546 1.803l1.328 1.992a.75.75 0 1 1-1.248.832l-1.328-1.992a4.75 4.75 0 0 1-.798-2.635V7c0-2.364-2.383-4.5-5.5-4.5Z"
      })
    }
  };
});
var BlockedIcon = /*#__PURE__*/createIconComponent("BlockedIcon", "octicon octicon-blocked", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.467.22a.749.749 0 0 1 .53-.22h6.006c.199 0 .389.079.53.22l4.247 4.247c.141.14.22.331.22.53v6.006a.749.749 0 0 1-.22.53l-4.247 4.247a.749.749 0 0 1-.53.22H4.997a.749.749 0 0 1-.53-.22L.22 11.533a.749.749 0 0 1-.22-.53V4.997c0-.199.079-.389.22-.53Zm.84 1.28L1.5 5.308v5.384L5.308 14.5h5.384l3.808-3.808V5.308L10.692 1.5ZM4 7.75A.75.75 0 0 1 4.75 7h6.5a.75.75 0 0 1 0 1.5h-6.5A.75.75 0 0 1 4 7.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.638 2.22a.749.749 0 0 1 .53-.22h7.664c.199 0 .389.079.53.22l5.418 5.418c.141.14.22.332.22.53v7.664a.749.749 0 0 1-.22.53l-5.418 5.418a.749.749 0 0 1-.53.22H8.168a.749.749 0 0 1-.53-.22l-5.42-5.418a.752.752 0 0 1-.219-.53V8.168c0-.199.079-.389.22-.53l5.418-5.42ZM8.48 3.5 3.5 8.48v7.04l4.98 4.98h7.04l4.98-4.98V8.48L15.52 3.5ZM7 11.75a.75.75 0 0 1 .75-.75h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var BoldIcon = /*#__PURE__*/createIconComponent("BoldIcon", "octicon octicon-bold", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 2h4.5a3.501 3.501 0 0 1 2.852 5.53A3.499 3.499 0 0 1 9.5 14H4a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1Zm1 7v3h4.5a1.5 1.5 0 0 0 0-3Zm3.5-2a1.5 1.5 0 0 0 0-3H5v3Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 4.75c0-.69.56-1.25 1.25-1.25h5a4.752 4.752 0 0 1 3.888 7.479A5 5 0 0 1 14 20.5H7.25c-.69 0-1.25-.56-1.25-1.25ZM8.5 13v5H14a2.5 2.5 0 1 0 0-5Zm0-2.5h3.751A2.25 2.25 0 0 0 12.25 6H8.5Z"
      })
    }
  };
});
var BookIcon = /*#__PURE__*/createIconComponent("BookIcon", "octicon octicon-book", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 1.75A.75.75 0 0 1 .75 1h4.253c1.227 0 2.317.59 3 1.501A3.743 3.743 0 0 1 11.006 1h4.245a.75.75 0 0 1 .75.75v10.5a.75.75 0 0 1-.75.75h-4.507a2.25 2.25 0 0 0-1.591.659l-.622.621a.75.75 0 0 1-1.06 0l-.622-.621A2.25 2.25 0 0 0 5.258 13H.75a.75.75 0 0 1-.75-.75Zm7.251 10.324.004-5.073-.002-2.253A2.25 2.25 0 0 0 5.003 2.5H1.5v9h3.757a3.75 3.75 0 0 1 1.994.574ZM8.755 4.75l-.004 7.322a3.752 3.752 0 0 1 1.992-.572H14.5v-9h-3.495a2.25 2.25 0 0 0-2.25 2.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 3.75A.75.75 0 0 1 .75 3h7.497c1.566 0 2.945.8 3.751 2.014A4.495 4.495 0 0 1 15.75 3h7.5a.75.75 0 0 1 .75.75v15.063a.752.752 0 0 1-.755.75l-7.682-.052a3 3 0 0 0-2.142.878l-.89.891a.75.75 0 0 1-1.061 0l-.902-.901a2.996 2.996 0 0 0-2.121-.879H.75a.75.75 0 0 1-.75-.75Zm12.75 15.232a4.503 4.503 0 0 1 2.823-.971l6.927.047V4.5h-6.75a3 3 0 0 0-3 3ZM11.247 7.497a3 3 0 0 0-3-2.997H1.5V18h6.947c1.018 0 2.006.346 2.803.98Z"
      })
    }
  };
});
var BookmarkIcon = /*#__PURE__*/createIconComponent("BookmarkIcon", "octicon octicon-bookmark", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 2.75C3 1.784 3.784 1 4.75 1h6.5c.966 0 1.75.784 1.75 1.75v11.5a.75.75 0 0 1-1.227.579L8 11.722l-3.773 3.107A.751.751 0 0 1 3 14.25Zm1.75-.25a.25.25 0 0 0-.25.25v9.91l3.023-2.489a.75.75 0 0 1 .954 0l3.023 2.49V2.75a.25.25 0 0 0-.25-.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 3.75C5 2.784 5.784 2 6.75 2h10.5c.966 0 1.75.784 1.75 1.75v17.5a.75.75 0 0 1-1.218.586L12 17.21l-5.781 4.625A.75.75 0 0 1 5 21.25Zm1.75-.25a.25.25 0 0 0-.25.25v15.94l5.031-4.026a.749.749 0 0 1 .938 0L17.5 19.69V3.75a.25.25 0 0 0-.25-.25Z"
      })
    }
  };
});
var BookmarkFillIcon = /*#__PURE__*/createIconComponent("BookmarkFillIcon", "octicon octicon-bookmark-fill", function () {
  return {
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.69 2h10.56c.966 0 1.75.784 1.75 1.75v17.5a.75.75 0 0 1-1.218.585L12 17.21l-5.781 4.626A.75.75 0 0 1 5 21.253L4.94 3.756A1.748 1.748 0 0 1 6.69 2Z"
      })
    }
  };
});
var BookmarkSlashIcon = /*#__PURE__*/createIconComponent("BookmarkSlashIcon", "octicon octicon-bookmark-slash", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.19 1.143 4.182 3.31l.014.01 8.486 6.145.014.01 2.994 2.168a.75.75 0 1 1-.88 1.214L13 11.547v2.703a.75.75 0 0 1-1.206.596L8 11.944l-3.794 2.902A.75.75 0 0 1 3 14.25V4.305L.31 2.357a.75.75 0 1 1 .88-1.214ZM4.5 5.39v7.341l3.044-2.328a.75.75 0 0 1 .912 0l3.044 2.328V10.46ZM5.865 1h5.385c.966 0 1.75.784 1.75 1.75v3.624a.75.75 0 0 1-1.5 0V2.75a.25.25 0 0 0-.25-.25H5.865a.75.75 0 0 1 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.565 2.018v-.001l21.75 15.75a.75.75 0 1 1-.88 1.215L19 16.495v4.764a.748.748 0 0 1-1.219.584L12 17.21l-5.781 4.634A.75.75 0 0 1 5 21.259V6.357L.685 3.232a.75.75 0 0 1 .88-1.214ZM17.5 15.408l-11-7.965v12.254l5.031-4.032a.749.749 0 0 1 .938 0l5.031 4.032ZM7.25 2a.75.75 0 0 0 0 1.5h10a.25.25 0 0 1 .25.25v6.5a.75.75 0 0 0 1.5 0v-6.5A1.75 1.75 0 0 0 17.25 2h-10Z"
      })
    }
  };
});
var BookmarkSlashFillIcon = /*#__PURE__*/createIconComponent("BookmarkSlashFillIcon", "octicon octicon-bookmark-slash-fill", function () {
  return {
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m3.232 2.175 18.5 15.5a.75.75 0 1 1-.964 1.15L19 17.343v3.907a.75.75 0 0 1-1.218.585L12 17.21l-5.781 4.626A.75.75 0 0 1 5 21.253L4.947 5.569 2.268 3.325a.75.75 0 1 1 .964-1.15ZM7.421 2h9.829c.966 0 1.75.784 1.75 1.75v8.073a.75.75 0 0 1-1.232.575L6.94 3.325A.75.75 0 0 1 7.421 2Z"
      })
    }
  };
});
var BriefcaseIcon = /*#__PURE__*/createIconComponent("BriefcaseIcon", "octicon octicon-briefcase", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.75 0h2.5C10.216 0 11 .784 11 1.75V3h3.25c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 15H1.75A1.75 1.75 0 0 1 0 13.25v-8.5C0 3.784.784 3 1.75 3H5V1.75C5 .784 5.784 0 6.75 0ZM3.5 9.5a3.49 3.49 0 0 1-2-.627v4.377c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V8.873a3.49 3.49 0 0 1-2 .627Zm-1.75-5a.25.25 0 0 0-.25.25V6a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2V4.75a.25.25 0 0 0-.25-.25H1.75ZM9.5 3V1.75a.25.25 0 0 0-.25-.25h-2.5a.25.25 0 0 0-.25.25V3Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.5 1.75C7.5.784 8.284 0 9.25 0h5.5c.966 0 1.75.784 1.75 1.75V4h4.75c.966 0 1.75.784 1.75 1.75v14.5A1.75 1.75 0 0 1 21.25 22H2.75A1.75 1.75 0 0 1 1 20.25V5.75C1 4.784 1.784 4 2.75 4H7.5Zm-5 10.24v8.26c0 .138.112.25.25.25h18.5a.25.25 0 0 0 .25-.25v-8.26A4.235 4.235 0 0 1 18.75 13H5.25a4.235 4.235 0 0 1-2.75-1.01Zm19-3.24v-3a.25.25 0 0 0-.25-.25H2.75a.25.25 0 0 0-.25.25v3a2.75 2.75 0 0 0 2.75 2.75h13.5a2.75 2.75 0 0 0 2.75-2.75Zm-6.5-7a.25.25 0 0 0-.25-.25h-5.5a.25.25 0 0 0-.25.25V4h6Z"
      })
    }
  };
});
var BroadcastIcon = /*#__PURE__*/createIconComponent("BroadcastIcon", "octicon octicon-broadcast", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75 8.582v5.668a.75.75 0 0 1-1.5 0V8.582a1.75 1.75 0 1 1 1.5 0Zm3.983-7.125a.75.75 0 0 1 1.06.026A7.976 7.976 0 0 1 16 7c0 2.139-.84 4.083-2.207 5.517a.75.75 0 1 1-1.086-1.034A6.474 6.474 0 0 0 14.5 7a6.474 6.474 0 0 0-1.793-4.483.75.75 0 0 1 .026-1.06Zm-9.466 0c.3.286.312.76.026 1.06A6.474 6.474 0 0 0 1.5 7a6.47 6.47 0 0 0 1.793 4.483.75.75 0 0 1-1.086 1.034A7.973 7.973 0 0 1 0 7c0-2.139.84-4.083 2.207-5.517a.75.75 0 0 1 1.06-.026Zm8.556 2.321A4.988 4.988 0 0 1 13 7a4.988 4.988 0 0 1-1.177 3.222.75.75 0 1 1-1.146-.967A3.487 3.487 0 0 0 11.5 7c0-.86-.309-1.645-.823-2.255a.75.75 0 0 1 1.146-.967Zm-6.492.958A3.48 3.48 0 0 0 4.5 7a3.48 3.48 0 0 0 .823 2.255.75.75 0 0 1-1.146.967A4.981 4.981 0 0 1 3 7a4.982 4.982 0 0 1 1.188-3.236.75.75 0 1 1 1.143.972Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M20.485 2.515a.75.75 0 0 0-1.06 1.06A10.465 10.465 0 0 1 22.5 11c0 2.9-1.174 5.523-3.075 7.424a.75.75 0 0 0 1.06 1.061A11.965 11.965 0 0 0 24 11c0-3.314-1.344-6.315-3.515-8.485Zm-15.91 1.06a.75.75 0 0 0-1.06-1.06A11.965 11.965 0 0 0 0 11c0 3.313 1.344 6.314 3.515 8.485a.75.75 0 0 0 1.06-1.06A10.465 10.465 0 0 1 1.5 11c0-2.9 1.174-5.524 3.075-7.425ZM8.11 7.11a.75.75 0 0 0-1.06-1.06A6.98 6.98 0 0 0 5 11a6.98 6.98 0 0 0 2.05 4.95.75.75 0 0 0 1.06-1.061 5.48 5.48 0 0 1-1.61-3.89 5.48 5.48 0 0 1 1.61-3.888Zm8.84-1.06a.75.75 0 1 0-1.06 1.06A5.48 5.48 0 0 1 17.5 11a5.48 5.48 0 0 1-1.61 3.889.75.75 0 1 0 1.06 1.06A6.98 6.98 0 0 0 19 11a6.98 6.98 0 0 0-2.05-4.949ZM14 11a2 2 0 0 1-1.25 1.855v8.395a.75.75 0 0 1-1.5 0v-8.395A2 2 0 1 1 14 11Z"
      })
    }
  };
});
var BrowserIcon = /*#__PURE__*/createIconComponent("BrowserIcon", "octicon octicon-browser", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.784.784 1 1.75 1h12.5c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 14.25 15H1.75A1.75 1.75 0 0 1 0 13.25ZM14.5 6h-13v7.25c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25Zm-6-3.5v2h6V2.75a.25.25 0 0 0-.25-.25ZM5 2.5v2h2v-2Zm-3.25 0a.25.25 0 0 0-.25.25V4.5h2v-2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 3.75C0 2.784.784 2 1.75 2h20.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 22.25 22H1.75A1.75 1.75 0 0 1 0 20.25ZM22.5 7h-21v13.25c0 .138.112.25.25.25h20.5a.25.25 0 0 0 .25-.25Zm-10-3.5v2h10V3.75a.25.25 0 0 0-.25-.25ZM7 3.5v2h4v-2Zm-5.25 0a.25.25 0 0 0-.25.25V5.5h4v-2Z"
      })
    }
  };
});
var BugIcon = /*#__PURE__*/createIconComponent("BugIcon", "octicon octicon-bug", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.72.22a.75.75 0 0 1 1.06 0l1 .999a3.488 3.488 0 0 1 2.441 0l.999-1a.748.748 0 0 1 1.265.332.75.75 0 0 1-.205.729l-.775.776c.616.63.995 1.493.995 2.444v.327c0 .1-.009.197-.025.292.408.14.764.392 1.029.722l1.968-.787a.75.75 0 0 1 .556 1.392L13 7.258V9h2.25a.75.75 0 0 1 0 1.5H13v.5c0 .409-.049.806-.141 1.186l2.17.868a.75.75 0 0 1-.557 1.392l-2.184-.873A4.997 4.997 0 0 1 8 16a4.997 4.997 0 0 1-4.288-2.427l-2.183.873a.75.75 0 0 1-.558-1.392l2.17-.868A5.036 5.036 0 0 1 3 11v-.5H.75a.75.75 0 0 1 0-1.5H3V7.258L.971 6.446a.75.75 0 0 1 .558-1.392l1.967.787c.265-.33.62-.583 1.03-.722a1.677 1.677 0 0 1-.026-.292V4.5c0-.951.38-1.814.995-2.444L4.72 1.28a.75.75 0 0 1 0-1.06Zm.53 6.28a.75.75 0 0 0-.75.75V11a3.5 3.5 0 1 0 7 0V7.25a.75.75 0 0 0-.75-.75ZM6.173 5h3.654A.172.172 0 0 0 10 4.827V4.5a2 2 0 1 0-4 0v.327c0 .096.077.173.173.173Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.72.22a.75.75 0 0 1 1.06 0l1.204 1.203A4.98 4.98 0 0 1 12 1c.717 0 1.4.151 2.016.423L15.22.22a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042l-.971.972A4.991 4.991 0 0 1 17 6v1.104a2.755 2.755 0 0 1 1.917 1.974l1.998-.999a.75.75 0 0 1 .67 1.342L19 10.714V13.5l3.25.003a.75.75 0 0 1 0 1.5L19 15.001V16c0 .568-.068 1.134-.204 1.686l.04.018 2.75 1.375a.75.75 0 1 1-.671 1.342l-2.638-1.319A6.998 6.998 0 0 1 12 23a6.998 6.998 0 0 1-6.197-3.742l-2.758 1.181a.752.752 0 0 1-1.064-.776.752.752 0 0 1 .474-.602l2.795-1.199A6.976 6.976 0 0 1 5 16v-.996H1.75a.75.75 0 0 1 0-1.5H5v-2.79L2.415 9.42a.75.75 0 0 1 .67-1.342l1.998.999A2.756 2.756 0 0 1 7 7.104V6a4.99 4.99 0 0 1 1.69-3.748l-.97-.972a.75.75 0 0 1 0-1.06ZM6.5 9.75V16a5.5 5.5 0 1 0 11 0V9.75c0-.69-.56-1.25-1.25-1.25h-8.5c-.69 0-1.25.56-1.25 1.25ZM8.5 7h7V6a3.5 3.5 0 1 0-7 0Z"
      })
    }
  };
});
var CacheIcon = /*#__PURE__*/createIconComponent("CacheIcon", "octicon octicon-cache", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.5 5.724V8c0 .248.238.7 1.169 1.159.874.43 2.144.745 3.62.822a.75.75 0 1 1-.078 1.498c-1.622-.085-3.102-.432-4.204-.975a5.565 5.565 0 0 1-.507-.28V12.5c0 .133.058.318.282.551.227.237.591.483 1.101.707 1.015.447 2.47.742 4.117.742.406 0 .802-.018 1.183-.052a.751.751 0 1 1 .134 1.494C8.89 15.98 8.45 16 8 16c-1.805 0-3.475-.32-4.721-.869-.623-.274-1.173-.619-1.579-1.041-.408-.425-.7-.964-.7-1.59v-9c0-.626.292-1.165.7-1.591.406-.42.956-.766 1.579-1.04C4.525.32 6.195 0 8 0c1.806 0 3.476.32 4.721.869.623.274 1.173.619 1.579 1.041.408.425.7.964.7 1.59 0 .626-.292 1.165-.7 1.591-.406.42-.956.766-1.578 1.04C11.475 6.68 9.805 7 8 7c-1.805 0-3.475-.32-4.721-.869a6.15 6.15 0 0 1-.779-.407Zm0-2.224c0 .133.058.318.282.551.227.237.591.483 1.101.707C4.898 5.205 6.353 5.5 8 5.5c1.646 0 3.101-.295 4.118-.742.508-.224.873-.471 1.1-.708.224-.232.282-.417.282-.55 0-.133-.058-.318-.282-.551-.227-.237-.591-.483-1.101-.707C11.102 1.795 9.647 1.5 8 1.5c-1.646 0-3.101.295-4.118.742-.508.224-.873.471-1.1.708-.224.232-.282.417-.282.55Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.49 7.582a.375.375 0 0 0-.66-.313l-3.625 4.625a.375.375 0 0 0 .295.606h2.127l-.619 2.922a.375.375 0 0 0 .666.304l3.125-4.125A.375.375 0 0 0 15.5 11h-1.778l.769-3.418Z"
      }))
    }
  };
});
var CalendarIcon = /*#__PURE__*/createIconComponent("CalendarIcon", "octicon octicon-calendar", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 0a.75.75 0 0 1 .75.75V2h5V.75a.75.75 0 0 1 1.5 0V2h1.25c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 13.25 16H2.75A1.75 1.75 0 0 1 1 14.25V3.75C1 2.784 1.784 2 2.75 2H4V.75A.75.75 0 0 1 4.75 0ZM2.5 7.5v6.75c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V7.5Zm10.75-4H2.75a.25.25 0 0 0-.25.25V6h11V3.75a.25.25 0 0 0-.25-.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.75 0a.75.75 0 0 1 .75.75V3h9V.75a.75.75 0 0 1 1.5 0V3h2.75c.966 0 1.75.784 1.75 1.75v16a1.75 1.75 0 0 1-1.75 1.75H3.25a1.75 1.75 0 0 1-1.75-1.75v-16C1.5 3.784 2.284 3 3.25 3H6V.75A.75.75 0 0 1 6.75 0ZM21 9.5H3v11.25c0 .138.112.25.25.25h17.5a.25.25 0 0 0 .25-.25Zm-17.75-5a.25.25 0 0 0-.25.25V8h18V4.75a.25.25 0 0 0-.25-.25Z"
      })
    }
  };
});
var CheckIcon = /*#__PURE__*/createIconComponent("CheckIcon", "octicon octicon-check", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.78 4.22a.75.75 0 0 1 0 1.06l-7.25 7.25a.75.75 0 0 1-1.06 0L2.22 9.28a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018L6 10.94l6.72-6.72a.75.75 0 0 1 1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M21.03 5.72a.75.75 0 0 1 0 1.06l-11.5 11.5a.747.747 0 0 1-1.072-.012l-5.5-5.75a.75.75 0 1 1 1.084-1.036l4.97 5.195L19.97 5.72a.75.75 0 0 1 1.06 0Z"
      })
    }
  };
});
var CheckCircleIcon = /*#__PURE__*/createIconComponent("CheckCircleIcon", "octicon octicon-check-circle", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8Zm1.5 0a6.5 6.5 0 1 0 13 0 6.5 6.5 0 0 0-13 0Zm10.28-1.72-4.5 4.5a.75.75 0 0 1-1.06 0l-2-2a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018l1.47 1.47 3.97-3.97a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M17.28 9.28a.75.75 0 0 0-1.06-1.06l-5.97 5.97-2.47-2.47a.75.75 0 0 0-1.06 1.06l3 3a.75.75 0 0 0 1.06 0l6.5-6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      }))
    }
  };
});
var CheckCircleFillIcon = /*#__PURE__*/createIconComponent("CheckCircleFillIcon", "octicon octicon-check-circle-fill", function () {
  return {
    "12": {
      "width": 12,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 0a6 6 0 1 1 0 12A6 6 0 0 1 6 0Zm-.705 8.737L9.63 4.403 8.392 3.166 5.295 6.263l-1.7-1.702L2.356 5.8l2.938 2.938Z"
      })
    },
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16Zm3.78-9.72a.751.751 0 0 0-.018-1.042.751.751 0 0 0-1.042-.018L6.75 9.19 5.28 7.72a.751.751 0 0 0-1.042.018.751.751 0 0 0-.018 1.042l2 2a.75.75 0 0 0 1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 12C1 5.925 5.925 1 12 1s11 4.925 11 11-4.925 11-11 11S1 18.075 1 12Zm16.28-2.72a.751.751 0 0 0-.018-1.042.751.751 0 0 0-1.042-.018l-5.97 5.97-2.47-2.47a.751.751 0 0 0-1.042.018.751.751 0 0 0-.018 1.042l3 3a.75.75 0 0 0 1.06 0Z"
      })
    }
  };
});
var CheckboxIcon = /*#__PURE__*/createIconComponent("CheckboxIcon", "octicon octicon-checkbox", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 1h10.5c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 13.25 15H2.75A1.75 1.75 0 0 1 1 13.25V2.75C1 1.784 1.784 1 2.75 1ZM2.5 2.75v10.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V2.75a.25.25 0 0 0-.25-.25H2.75a.25.25 0 0 0-.25.25Zm9.28 3.53-4.5 4.5a.75.75 0 0 1-1.06 0l-2-2a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018l1.47 1.47 3.97-3.97a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M17.28 9.28a.75.75 0 0 0-1.06-1.06l-5.97 5.97-2.47-2.47a.75.75 0 0 0-1.06 1.06l3 3a.75.75 0 0 0 1.06 0l6.5-6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 2h16.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25V3.75C2 2.784 2.784 2 3.75 2ZM3.5 3.75v16.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25H3.75a.25.25 0 0 0-.25.25Z"
      }))
    }
  };
});
var ChecklistIcon = /*#__PURE__*/createIconComponent("ChecklistIcon", "octicon octicon-checklist", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.5 1.75v11.5c0 .138.112.25.25.25h3.17a.75.75 0 0 1 0 1.5H2.75A1.75 1.75 0 0 1 1 13.25V1.75C1 .784 1.784 0 2.75 0h8.5C12.216 0 13 .784 13 1.75v7.736a.75.75 0 0 1-1.5 0V1.75a.25.25 0 0 0-.25-.25h-8.5a.25.25 0 0 0-.25.25Zm13.274 9.537v-.001l-4.557 4.45a.75.75 0 0 1-1.055-.008l-1.943-1.95a.75.75 0 0 1 1.062-1.058l1.419 1.425 4.026-3.932a.75.75 0 1 1 1.048 1.074ZM4.75 4h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1 0-1.5ZM4 7.75A.75.75 0 0 1 4.75 7h2a.75.75 0 0 1 0 1.5h-2A.75.75 0 0 1 4 7.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.5 3.75a.25.25 0 0 1 .25-.25h13.5a.25.25 0 0 1 .25.25v10a.75.75 0 0 0 1.5 0v-10A1.75 1.75 0 0 0 17.25 2H3.75A1.75 1.75 0 0 0 2 3.75v16.5c0 .966.784 1.75 1.75 1.75h7a.75.75 0 0 0 0-1.5h-7a.25.25 0 0 1-.25-.25V3.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.25 7a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Zm-.75 4.75a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Zm16.28 4.53a.75.75 0 1 0-1.06-1.06l-4.97 4.97-1.97-1.97a.75.75 0 1 0-1.06 1.06l2.5 2.5a.75.75 0 0 0 1.06 0l5.5-5.5Z"
      }))
    }
  };
});
var ChevronDownIcon = /*#__PURE__*/createIconComponent("ChevronDownIcon", "octicon octicon-chevron-down", function () {
  return {
    "12": {
      "width": 12,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 8.825c-.2 0-.4-.1-.5-.2l-3.3-3.3c-.3-.3-.3-.8 0-1.1.3-.3.8-.3 1.1 0l2.7 2.7 2.7-2.7c.3-.3.8-.3 1.1 0 .3.3.3.8 0 1.1l-3.2 3.2c-.2.2-.4.3-.6.3Z"
      })
    },
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.78 5.22a.749.749 0 0 1 0 1.06l-4.25 4.25a.749.749 0 0 1-1.06 0L3.22 6.28a.749.749 0 1 1 1.06-1.06L8 8.939l3.72-3.719a.749.749 0 0 1 1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.22 8.22a.749.749 0 0 0 0 1.06l6.25 6.25a.749.749 0 0 0 1.06 0l6.25-6.25a.749.749 0 1 0-1.06-1.06L12 13.939 6.28 8.22a.749.749 0 0 0-1.06 0Z"
      })
    }
  };
});
var ChevronLeftIcon = /*#__PURE__*/createIconComponent("ChevronLeftIcon", "octicon octicon-chevron-left", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.78 12.78a.75.75 0 0 1-1.06 0L4.47 8.53a.75.75 0 0 1 0-1.06l4.25-4.25a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042L6.06 8l3.72 3.72a.75.75 0 0 1 0 1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.28 5.22a.75.75 0 0 1 0 1.06L9.56 12l5.72 5.72a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-6.25-6.25a.75.75 0 0 1 0-1.06l6.25-6.25a.75.75 0 0 1 1.06 0Z"
      })
    }
  };
});
var ChevronRightIcon = /*#__PURE__*/createIconComponent("ChevronRightIcon", "octicon octicon-chevron-right", function () {
  return {
    "12": {
      "width": 12,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.7 10c-.2 0-.4-.1-.5-.2-.3-.3-.3-.8 0-1.1L6.9 6 4.2 3.3c-.3-.3-.3-.8 0-1.1.3-.3.8-.3 1.1 0l3.3 3.2c.3.3.3.8 0 1.1L5.3 9.7c-.2.2-.4.3-.6.3Z"
      })
    },
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.22 3.22a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042L9.94 8 6.22 4.28a.75.75 0 0 1 0-1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.72 18.78a.75.75 0 0 1 0-1.06L14.44 12 8.72 6.28a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018l6.25 6.25a.75.75 0 0 1 0 1.06l-6.25 6.25a.75.75 0 0 1-1.06 0Z"
      })
    }
  };
});
var ChevronUpIcon = /*#__PURE__*/createIconComponent("ChevronUpIcon", "octicon octicon-chevron-up", function () {
  return {
    "12": {
      "width": 12,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 4c-.2 0-.4.1-.5.2L2.2 7.5c-.3.3-.3.8 0 1.1.3.3.8.3 1.1 0L6 5.9l2.7 2.7c.3.3.8.3 1.1 0 .3-.3.3-.8 0-1.1L6.6 4.3C6.4 4.1 6.2 4 6 4Z"
      })
    },
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.22 10.53a.749.749 0 0 1 0-1.06l4.25-4.25a.749.749 0 0 1 1.06 0l4.25 4.25a.749.749 0 1 1-1.06 1.06L8 6.811 4.28 10.53a.749.749 0 0 1-1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M18.78 15.78a.749.749 0 0 1-1.06 0L12 10.061 6.28 15.78a.749.749 0 1 1-1.06-1.06l6.25-6.25a.749.749 0 0 1 1.06 0l6.25 6.25a.749.749 0 0 1 0 1.06Z"
      })
    }
  };
});
var CircleIcon = /*#__PURE__*/createIconComponent("CircleIcon", "octicon octicon-circle", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8Zm8-6.5a6.5 6.5 0 1 0 0 13 6.5 6.5 0 0 0 0-13Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 12C1 5.925 5.925 1 12 1s11 4.925 11 11-4.925 11-11 11S1 18.075 1 12Zm11-9.5A9.5 9.5 0 0 0 2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5Z"
      })
    }
  };
});
var CircleSlashIcon = /*#__PURE__*/createIconComponent("CircleSlashIcon", "octicon octicon-circle-slash", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0ZM3.965 13.096a6.5 6.5 0 0 0 9.131-9.131ZM1.5 8a6.474 6.474 0 0 0 1.404 4.035l9.131-9.131A6.499 6.499 0 0 0 1.5 8Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM5.834 19.227A9.464 9.464 0 0 0 12 21.5a9.5 9.5 0 0 0 9.5-9.5 9.464 9.464 0 0 0-2.273-6.166ZM2.5 12a9.464 9.464 0 0 0 2.273 6.166L18.166 4.773A9.463 9.463 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      })
    }
  };
});
var ClockIcon = /*#__PURE__*/createIconComponent("ClockIcon", "octicon octicon-clock", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0ZM1.5 8a6.5 6.5 0 1 0 13 0 6.5 6.5 0 0 0-13 0Zm7-3.25v2.992l2.028.812a.75.75 0 0 1-.557 1.392l-2.5-1A.751.751 0 0 1 7 8.25v-3.5a.75.75 0 0 1 1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.5 7.25a.75.75 0 0 0-1.5 0v5.5c0 .27.144.518.378.651l3.5 2a.75.75 0 0 0 .744-1.302L12.5 12.315V7.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      }))
    }
  };
});
var ClockFillIcon = /*#__PURE__*/createIconComponent("ClockFillIcon", "octicon octicon-clock-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8Zm8.575-3.25a.825.825 0 1 0-1.65 0v3.5c0 .337.205.64.519.766l2.5 1a.825.825 0 0 0 .612-1.532l-1.981-.793Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 12C1 5.925 5.925 1 12 1s11 4.925 11 11-4.925 11-11 11S1 18.075 1 12Zm11.575-4.75a.825.825 0 1 0-1.65 0v5.5c0 .296.159.57.416.716l3.5 2a.825.825 0 0 0 .818-1.432l-3.084-1.763Z"
      })
    }
  };
});
var CloudIcon = /*#__PURE__*/createIconComponent("CloudIcon", "octicon octicon-cloud", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 7.25A5.225 5.225 0 0 1 7.25 2a5.222 5.222 0 0 1 4.767 3.029A4.472 4.472 0 0 1 16 9.5c0 2.505-1.995 4.5-4.5 4.5h-8A3.474 3.474 0 0 1 0 10.5c0-1.41.809-2.614 2.001-3.17Zm1.54.482a.75.75 0 0 1-.556.832c-.86.22-1.484.987-1.484 1.936 0 1.124.876 2 2 2h8c1.676 0 3-1.324 3-3s-1.324-3-3-3a.75.75 0 0 1-.709-.504A3.72 3.72 0 0 0 7.25 3.5C5.16 3.5 3.5 5.16 3.5 7.25c.002.146.014.292.035.436l.004.036.001.008Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.103 10.107c0-4.244 3.445-7.607 7.733-7.607 3.19 0 5.912 1.858 7.099 4.563l.01.022.001.006C21.348 7.345 24 10.095 24 13.536 24 17.148 21.076 20 17.431 20H5.017C2.23 20 0 17.83 0 15.06a4.899 4.899 0 0 1 3.112-4.581 7.696 7.696 0 0 1-.009-.372ZM10.836 4c-3.485 0-6.233 2.717-6.233 6.107 0 .284.022.602.052.756a.75.75 0 0 1-.552.869c-1.52.385-2.603 1.712-2.603 3.328 0 1.917 1.532 3.44 3.517 3.44h12.414c2.843 0 5.069-2.206 5.069-4.964 0-2.759-2.226-4.965-5.069-4.965a.75.75 0 0 1-.696-.47l-.179-.446C15.606 5.5 13.424 4 10.836 4Z"
      })
    }
  };
});
var CloudOfflineIcon = /*#__PURE__*/createIconComponent("CloudOfflineIcon", "octicon octicon-cloud-offline", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.25 2c-.69 0-1.351.13-1.957.371a.75.75 0 1 0 .554 1.394c.43-.17.903-.265 1.403-.265a3.72 3.72 0 0 1 3.541 2.496.75.75 0 0 0 .709.504c1.676 0 3 1.324 3 3a3 3 0 0 1-.681 1.92.75.75 0 0 0 1.156.955A4.496 4.496 0 0 0 16 9.5a4.472 4.472 0 0 0-3.983-4.471A5.222 5.222 0 0 0 7.25 2ZM.72 1.72a.75.75 0 0 1 1.06 0l2.311 2.31c.03.025.056.052.08.08l8.531 8.532.035.034 2.043 2.044a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-1.8-1.799a4.54 4.54 0 0 1-.42.019h-8A3.474 3.474 0 0 1 0 10.5c0-1.41.809-2.614 2.001-3.17a5.218 5.218 0 0 1 .646-2.622L.72 2.78a.75.75 0 0 1 0-1.06ZM3.5 7.25c.004.161.018.322.041.481a.75.75 0 0 1-.557.833c-.86.22-1.484.986-1.484 1.936 0 1.124.876 2 2 2h6.94L3.771 5.832A3.788 3.788 0 0 0 3.5 7.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m2.78 2.22 19.5 19.5a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-2.845-2.845a6.932 6.932 0 0 1-.944.065H5.017C2.229 20 0 17.831 0 15.059a4.899 4.899 0 0 1 3.111-4.58A7.52 7.52 0 0 1 4.36 5.922L1.72 3.28a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018ZM16.94 18.5 5.448 7.01a6.026 6.026 0 0 0-.794 3.853.75.75 0 0 1-.552.869c-1.52.385-2.603 1.712-2.603 3.328 0 1.917 1.532 3.44 3.517 3.44Zm-6.104-16a7.865 7.865 0 0 0-3.638.88.75.75 0 1 0 .692 1.331A6.365 6.365 0 0 1 10.836 4c2.588 0 4.77 1.5 5.72 3.655l.179.445a.75.75 0 0 0 .696.471c2.843 0 5.069 2.206 5.069 4.965a4.9 4.9 0 0 1-1.684 3.716.75.75 0 0 0 .986 1.13A6.396 6.396 0 0 0 24 13.536c0-3.44-2.652-6.191-6.054-6.445l-.002-.006a.634.634 0 0 0-.01-.022C16.749 4.358 14.026 2.5 10.837 2.5Z"
      })
    }
  };
});
var CodeIcon = /*#__PURE__*/createIconComponent("CodeIcon", "octicon octicon-code", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m11.28 3.22 4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734L13.94 8l-3.72-3.72a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215Zm-6.56 0a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042L2.06 8l3.72 3.72a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L.47 8.53a.75.75 0 0 1 0-1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.22 4.97a.75.75 0 0 1 1.06 0l6.5 6.5a.75.75 0 0 1 0 1.06l-6.5 6.5a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734L21.19 12l-5.97-5.97a.75.75 0 0 1 0-1.06Zm-6.44 0a.75.75 0 0 1 0 1.06L2.81 12l5.97 5.97a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-6.5-6.5a.75.75 0 0 1 0-1.06l6.5-6.5a.75.75 0 0 1 1.06 0Z"
      })
    }
  };
});
var CodeOfConductIcon = /*#__PURE__*/createIconComponent("CodeOfConductIcon", "octicon octicon-code-of-conduct", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.048 2.241c.964-.709 2.079-1.238 3.325-1.241a4.616 4.616 0 0 1 3.282 1.355c.41.408.757.86.996 1.428.238.568.348 1.206.347 1.968 0 2.193-1.505 4.254-3.081 5.862-1.496 1.526-3.213 2.796-4.249 3.563l-.22.163a.749.749 0 0 1-.895 0l-.221-.163c-1.036-.767-2.753-2.037-4.249-3.563C1.51 10.008.007 7.952.002 5.762a4.614 4.614 0 0 1 1.353-3.407C3.123.585 6.223.537 8.048 2.24Zm-1.153.983c-1.25-1.033-3.321-.967-4.48.191a3.115 3.115 0 0 0-.913 2.335c0 1.556 1.109 3.24 2.652 4.813C5.463 11.898 6.96 13.032 8 13.805c.353-.262.758-.565 1.191-.905l-1.326-1.223a.75.75 0 0 1 1.018-1.102l1.48 1.366c.328-.281.659-.577.984-.887L9.99 9.802a.75.75 0 1 1 1.019-1.103l1.384 1.28c.295-.329.566-.661.81-.995L12.92 8.7l-1.167-1.168c-.674-.671-1.78-.664-2.474.03-.268.269-.538.537-.802.797-.893.882-2.319.843-3.185-.032-.346-.35-.693-.697-1.043-1.047a.75.75 0 0 1-.04-1.016c.162-.191.336-.401.52-.623.62-.748 1.356-1.637 2.166-2.417Zm7.112 4.442c.313-.65.491-1.293.491-1.916v-.001c0-.614-.088-1.045-.23-1.385-.143-.339-.357-.633-.673-.949a3.111 3.111 0 0 0-2.218-.915c-1.092.003-2.165.627-3.226 1.602-.823.755-1.554 1.637-2.228 2.45l-.127.154.562.566a.755.755 0 0 0 1.066.02l.794-.79c1.258-1.258 3.312-1.31 4.594-.032.396.394.792.791 1.173 1.173Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.828 4.328C5.26 1.896 9.5 1.881 11.935 4.317c.024.024.046.05.067.076 1.391-1.078 2.993-1.886 4.777-1.89a6.22 6.22 0 0 1 4.424 1.825c.559.56 1.023 1.165 1.34 1.922.318.756.47 1.617.468 2.663 0 2.972-2.047 5.808-4.269 8.074-2.098 2.14-4.507 3.924-5.974 5.009l-.311.23a.752.752 0 0 1-.897 0l-.312-.23c-1.466-1.085-3.875-2.869-5.973-5.009-2.22-2.263-4.264-5.095-4.27-8.063a6.216 6.216 0 0 1 1.823-4.596Zm8.033 1.042c-1.846-1.834-5.124-1.823-6.969.022a4.712 4.712 0 0 0-1.382 3.52c0 2.332 1.65 4.79 3.839 7.022 1.947 1.986 4.184 3.66 5.66 4.752a78.214 78.214 0 0 0 2.159-1.645l-2.14-1.974a.752.752 0 0 1 1.02-1.106l2.295 2.118c.616-.52 1.242-1.08 1.85-1.672l-2.16-1.992a.753.753 0 0 1 1.021-1.106l2.188 2.02a18.963 18.963 0 0 0 1.528-1.877l-.585-.586-1.651-1.652c-1.078-1.074-2.837-1.055-3.935.043-.379.38-.76.758-1.132 1.126-1.14 1.124-2.96 1.077-4.07-.043-.489-.495-.98-.988-1.475-1.482a.752.752 0 0 1-.04-1.019c.234-.276.483-.576.745-.893.928-1.12 2.023-2.442 3.234-3.576Zm9.725 6.77c.579-1.08.92-2.167.92-3.228.002-.899-.128-1.552-.35-2.08-.22-.526-.551-.974-1.017-1.44a4.71 4.71 0 0 0-3.356-1.384c-1.66.004-3.25.951-4.77 2.346-1.18 1.084-2.233 2.353-3.188 3.506l-.351.423c.331.332.663.664.993.998a1.375 1.375 0 0 0 1.943.03c.37-.365.748-.74 1.125-1.118 1.662-1.663 4.373-1.726 6.06-.045.56.558 1.12 1.12 1.658 1.658Z"
      })
    }
  };
});
var CodeReviewIcon = /*#__PURE__*/createIconComponent("CodeReviewIcon", "octicon octicon-code-review", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 1h12.5c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 13H8.061l-2.574 2.573A1.458 1.458 0 0 1 3 14.543V13H1.75A1.75 1.75 0 0 1 0 11.25v-8.5C0 1.784.784 1 1.75 1ZM1.5 2.75v8.5c0 .138.112.25.25.25h2a.75.75 0 0 1 .75.75v2.19l2.72-2.72a.749.749 0 0 1 .53-.22h6.5a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25Zm5.28 1.72a.75.75 0 0 1 0 1.06L5.31 7l1.47 1.47a.751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018l-2-2a.75.75 0 0 1 0-1.06l2-2a.75.75 0 0 1 1.06 0Zm2.44 0a.75.75 0 0 1 1.06 0l2 2a.75.75 0 0 1 0 1.06l-2 2a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042L10.69 7 9.22 5.53a.75.75 0 0 1 0-1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.3 6.74a.75.75 0 0 1-.04 1.06l-2.908 2.7 2.908 2.7a.75.75 0 1 1-1.02 1.1l-3.5-3.25a.75.75 0 0 1 0-1.1l3.5-3.25a.75.75 0 0 1 1.06.04Zm3.44 1.06a.75.75 0 1 1 1.02-1.1l3.5 3.25a.75.75 0 0 1 0 1.1l-3.5 3.25a.75.75 0 1 1-1.02-1.1l2.908-2.7-2.908-2.7Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 4.25c0-.966.784-1.75 1.75-1.75h17.5c.966 0 1.75.784 1.75 1.75v12.5a1.75 1.75 0 0 1-1.75 1.75h-9.69l-3.573 3.573A1.458 1.458 0 0 1 5 21.043V18.5H3.25a1.75 1.75 0 0 1-1.75-1.75ZM3.25 4a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h2.5a.75.75 0 0 1 .75.75v3.19l3.72-3.72a.749.749 0 0 1 .53-.22h10a.25.25 0 0 0 .25-.25V4.25a.25.25 0 0 0-.25-.25Z"
      }))
    }
  };
});
var CodeSquareIcon = /*#__PURE__*/createIconComponent("CodeSquareIcon", "octicon octicon-code-square", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 1.75C0 .784.784 0 1.75 0h12.5C15.216 0 16 .784 16 1.75v12.5A1.75 1.75 0 0 1 14.25 16H1.75A1.75 1.75 0 0 1 0 14.25Zm1.75-.25a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25Zm7.47 3.97a.75.75 0 0 1 1.06 0l2 2a.75.75 0 0 1 0 1.06l-2 2a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734L10.69 8 9.22 6.53a.75.75 0 0 1 0-1.06ZM6.78 6.53 5.31 8l1.47 1.47a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-2-2a.75.75 0 0 1 0-1.06l2-2a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.3 8.24a.75.75 0 0 1-.04 1.06L7.352 12l2.908 2.7a.75.75 0 1 1-1.02 1.1l-3.5-3.25a.75.75 0 0 1 0-1.1l3.5-3.25a.75.75 0 0 1 1.06.04Zm3.44 1.06a.75.75 0 1 1 1.02-1.1l3.5 3.25a.75.75 0 0 1 0 1.1l-3.5 3.25a.75.75 0 1 1-1.02-1.1l2.908-2.7-2.908-2.7Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 3.75C2 2.784 2.784 2 3.75 2h16.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25Zm1.75-.25a.25.25 0 0 0-.25.25v16.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25Z"
      }))
    }
  };
});
var CodescanIcon = /*#__PURE__*/createIconComponent("CodescanIcon", "octicon octicon-codescan", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.47 4.97a.75.75 0 0 0 0 1.06L9.94 7.5 8.47 8.97a.75.75 0 1 0 1.06 1.06l2-2a.75.75 0 0 0 0-1.06l-2-2a.75.75 0 0 0-1.06 0ZM6.53 6.03a.75.75 0 0 0-1.06-1.06l-2 2a.75.75 0 0 0 0 1.06l2 2a.75.75 0 1 0 1.06-1.06L5.06 7.5l1.47-1.47Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.246 13.307a7.501 7.501 0 1 1 1.06-1.06l2.474 2.473a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215ZM1.5 7.5a6.002 6.002 0 0 0 3.608 5.504 6.002 6.002 0 0 0 6.486-1.117.748.748 0 0 1 .292-.293A6 6 0 1 0 1.5 7.5Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.97 6.97a.75.75 0 0 0 0 1.06l2.47 2.47-2.47 2.47a.75.75 0 1 0 1.06 1.06l3-3a.75.75 0 0 0 0-1.06l-3-3a.75.75 0 0 0-1.06 0ZM9.03 8.03a.75.75 0 0 0-1.06-1.06l-3 3a.75.75 0 0 0 0 1.06l3 3a.75.75 0 0 0 1.06-1.06L6.56 10.5l2.47-2.47Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.5 0C16.299 0 21 4.701 21 10.5a10.457 10.457 0 0 1-2.564 6.875l4.344 4.345a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-4.345-4.344A10.459 10.459 0 0 1 10.5 21C4.701 21 0 16.299 0 10.5S4.701 0 10.5 0Zm-9 10.5a9 9 0 0 0 9 9 9 9 0 0 0 9-9 9 9 0 0 0-9-9 9 9 0 0 0-9 9Z"
      }))
    }
  };
});
var CodescanCheckmarkIcon = /*#__PURE__*/createIconComponent("CodescanCheckmarkIcon", "octicon octicon-codescan-checkmark", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.28 6.28a.75.75 0 1 0-1.06-1.06L6.25 8.19l-.97-.97a.75.75 0 0 0-1.06 1.06l1.5 1.5a.75.75 0 0 0 1.06 0l3.5-3.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.5 15a7.5 7.5 0 1 1 5.807-2.754l2.473 2.474a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-2.474-2.473A7.472 7.472 0 0 1 7.5 15Zm0-13.5a6 6 0 1 0 4.094 10.386.748.748 0 0 1 .293-.292 6.002 6.002 0 0 0 1.117-6.486A6.002 6.002 0 0 0 7.5 1.5Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.03 8.28a.75.75 0 0 0-1.06-1.06l-5.22 5.22-2.22-2.22a.75.75 0 1 0-1.06 1.06l2.75 2.75a.75.75 0 0 0 1.06 0l5.75-5.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 10.5C0 4.701 4.701 0 10.5 0S21 4.701 21 10.5c0 2.63-.967 5.033-2.564 6.875l4.344 4.345a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-4.345-4.344A10.457 10.457 0 0 1 10.5 21C4.701 21 0 16.299 0 10.5Zm10.5-9a9 9 0 0 0-9 9 9 9 0 0 0 9 9 9 9 0 0 0 9-9 9 9 0 0 0-9-9Z"
      }))
    }
  };
});
var CodespacesIcon = /*#__PURE__*/createIconComponent("CodespacesIcon", "octicon octicon-codespaces", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 11.25c0-.966.784-1.75 1.75-1.75h12.5c.966 0 1.75.784 1.75 1.75v3A1.75 1.75 0 0 1 14.25 16H1.75A1.75 1.75 0 0 1 0 14.25Zm2-9.5C2 .784 2.784 0 3.75 0h8.5C13.216 0 14 .784 14 1.75v5a1.75 1.75 0 0 1-1.75 1.75h-8.5A1.75 1.75 0 0 1 2 6.75Zm1.75-.25a.25.25 0 0 0-.25.25v5c0 .138.112.25.25.25h8.5a.25.25 0 0 0 .25-.25v-5a.25.25 0 0 0-.25-.25Zm-2 9.5a.25.25 0 0 0-.25.25v3c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-3a.25.25 0 0 0-.25-.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7 12.75a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Zm-4 0a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1-.75-.75Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.5 3.75C3.5 2.784 4.284 2 5.25 2h13.5c.966 0 1.75.784 1.75 1.75v7.5A1.75 1.75 0 0 1 18.75 13H5.25a1.75 1.75 0 0 1-1.75-1.75Zm-2 12c0-.966.784-1.75 1.75-1.75h17.5c.966 0 1.75.784 1.75 1.75v4a1.75 1.75 0 0 1-1.75 1.75H3.25a1.75 1.75 0 0 1-1.75-1.75ZM5.25 3.5a.25.25 0 0 0-.25.25v7.5c0 .138.112.25.25.25h13.5a.25.25 0 0 0 .25-.25v-7.5a.25.25 0 0 0-.25-.25Zm-2 12a.25.25 0 0 0-.25.25v4c0 .138.112.25.25.25h17.5a.25.25 0 0 0 .25-.25v-4a.25.25 0 0 0-.25-.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10 17.75a.75.75 0 0 1 .75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75Zm-4 0a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1-.75-.75Z"
      }))
    }
  };
});
var ColumnsIcon = /*#__PURE__*/createIconComponent("ColumnsIcon", "octicon octicon-columns", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 0h2.5C6.216 0 7 .784 7 1.75v12.5A1.75 1.75 0 0 1 5.25 16h-2.5A1.75 1.75 0 0 1 1 14.25V1.75C1 .784 1.784 0 2.75 0Zm8 0h2.5C14.216 0 15 .784 15 1.75v12.5A1.75 1.75 0 0 1 13.25 16h-2.5A1.75 1.75 0 0 1 9 14.25V1.75C9 .784 9.784 0 10.75 0ZM2.5 1.75v12.5c0 .138.112.25.25.25h2.5a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25h-2.5a.25.25 0 0 0-.25.25Zm8 0v12.5c0 .138.112.25.25.25h2.5a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25h-2.5a.25.25 0 0 0-.25.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 2h5.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 9.25 22h-5.5A1.75 1.75 0 0 1 2 20.25V3.75C2 2.784 2.784 2 3.75 2Zm11 0h5.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22h-5.5A1.75 1.75 0 0 1 13 20.25V3.75c0-.966.784-1.75 1.75-1.75ZM3.5 3.75v16.5c0 .138.112.25.25.25h5.5a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25h-5.5a.25.25 0 0 0-.25.25Zm11 0v16.5c0 .138.112.25.25.25h5.5a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25h-5.5a.25.25 0 0 0-.25.25Z"
      })
    }
  };
});
var CommandPaletteIcon = /*#__PURE__*/createIconComponent("CommandPaletteIcon", "octicon octicon-command-palette", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m6.354 8.04-4.773 4.773a.75.75 0 1 0 1.061 1.06L7.945 8.57a.75.75 0 0 0 0-1.06L2.642 2.206a.75.75 0 0 0-1.06 1.061L6.353 8.04ZM8.75 11.5a.75.75 0 0 0 0 1.5h5.5a.75.75 0 0 0 0-1.5h-5.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.045 18.894 9.94 12 3.045 5.106a.75.75 0 0 1 1.06-1.061l7.425 7.425a.75.75 0 0 1 0 1.06l-7.424 7.425a.75.75 0 0 1-1.061-1.06Zm8.205.606a.75.75 0 0 0 0 1.5h9.5a.75.75 0 0 0 0-1.5h-9.5Z"
      })
    }
  };
});
var CommentIcon = /*#__PURE__*/createIconComponent("CommentIcon", "octicon octicon-comment", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 2.75C1 1.784 1.784 1 2.75 1h10.5c.966 0 1.75.784 1.75 1.75v7.5A1.75 1.75 0 0 1 13.25 12H9.06l-2.573 2.573A1.458 1.458 0 0 1 4 13.543V12H2.75A1.75 1.75 0 0 1 1 10.25Zm1.75-.25a.25.25 0 0 0-.25.25v7.5c0 .138.112.25.25.25h2a.75.75 0 0 1 .75.75v2.19l2.72-2.72a.749.749 0 0 1 .53-.22h4.5a.25.25 0 0 0 .25-.25v-7.5a.25.25 0 0 0-.25-.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 4.25c0-.966.784-1.75 1.75-1.75h17.5c.966 0 1.75.784 1.75 1.75v12.5a1.75 1.75 0 0 1-1.75 1.75h-9.69l-3.573 3.573A1.458 1.458 0 0 1 5 21.043V18.5H3.25a1.75 1.75 0 0 1-1.75-1.75ZM3.25 4a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h2.5a.75.75 0 0 1 .75.75v3.19l3.72-3.72a.749.749 0 0 1 .53-.22h10a.25.25 0 0 0 .25-.25V4.25a.25.25 0 0 0-.25-.25Z"
      })
    }
  };
});
var CommentDiscussionIcon = /*#__PURE__*/createIconComponent("CommentDiscussionIcon", "octicon octicon-comment-discussion", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 1h8.5c.966 0 1.75.784 1.75 1.75v5.5A1.75 1.75 0 0 1 10.25 10H7.061l-2.574 2.573A1.458 1.458 0 0 1 2 11.543V10h-.25A1.75 1.75 0 0 1 0 8.25v-5.5C0 1.784.784 1 1.75 1ZM1.5 2.75v5.5c0 .138.112.25.25.25h1a.75.75 0 0 1 .75.75v2.19l2.72-2.72a.749.749 0 0 1 .53-.22h3.5a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25h-8.5a.25.25 0 0 0-.25.25Zm13 2a.25.25 0 0 0-.25-.25h-.5a.75.75 0 0 1 0-1.5h.5c.966 0 1.75.784 1.75 1.75v5.5A1.75 1.75 0 0 1 14.25 12H14v1.543a1.458 1.458 0 0 1-2.487 1.03L9.22 12.28a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215l2.22 2.22v-2.19a.75.75 0 0 1 .75-.75h1a.25.25 0 0 0 .25-.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 1h12.5c.966 0 1.75.784 1.75 1.75v9.5A1.75 1.75 0 0 1 14.25 14H8.061l-2.574 2.573A1.458 1.458 0 0 1 3 15.543V14H1.75A1.75 1.75 0 0 1 0 12.25v-9.5C0 1.784.784 1 1.75 1ZM1.5 2.75v9.5c0 .138.112.25.25.25h2a.75.75 0 0 1 .75.75v2.19l2.72-2.72a.749.749 0 0 1 .53-.22h6.5a.25.25 0 0 0 .25-.25v-9.5a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M22.5 8.75a.25.25 0 0 0-.25-.25h-3.5a.75.75 0 0 1 0-1.5h3.5c.966 0 1.75.784 1.75 1.75v9.5A1.75 1.75 0 0 1 22.25 20H21v1.543a1.457 1.457 0 0 1-2.487 1.03L15.939 20H10.75A1.75 1.75 0 0 1 9 18.25v-1.465a.75.75 0 0 1 1.5 0v1.465c0 .138.112.25.25.25h5.5a.75.75 0 0 1 .53.22l2.72 2.72v-2.19a.75.75 0 0 1 .75-.75h2a.25.25 0 0 0 .25-.25v-9.5Z"
      }))
    }
  };
});
var CommitIcon = /*#__PURE__*/createIconComponent("CommitIcon", "octicon octicon-commit", function () {
  return {
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 11.75A.75.75 0 0 1 .75 11h5a.75.75 0 0 1 0 1.5h-5a.75.75 0 0 1-.75-.75Zm17.5 0a.75.75 0 0 1 .75-.75h5a.75.75 0 0 1 0 1.5h-5a.75.75 0 0 1-.75-.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 17.75a6 6 0 1 1 0-12 6 6 0 0 1 0 12Zm0-1.5a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Z"
      }))
    }
  };
});
var ContainerIcon = /*#__PURE__*/createIconComponent("ContainerIcon", "octicon octicon-container", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m10.41.24 4.711 2.774c.544.316.878.897.879 1.526v5.01a1.77 1.77 0 0 1-.88 1.53l-7.753 4.521-.002.001a1.769 1.769 0 0 1-1.774 0H5.59L.873 12.85A1.761 1.761 0 0 1 0 11.327V6.292c0-.304.078-.598.22-.855l.004-.005.01-.019c.15-.262.369-.486.64-.643L8.641.239a1.752 1.752 0 0 1 1.765 0l.002.001ZM9.397 1.534l-7.17 4.182 4.116 2.388a.27.27 0 0 0 .269 0l7.152-4.148-4.115-2.422a.252.252 0 0 0-.252 0Zm-7.768 10.02 4.1 2.393V9.474a1.807 1.807 0 0 1-.138-.072L1.5 7.029v4.298c0 .095.05.181.129.227Zm8.6.642 1.521-.887v-4.45l-1.521.882ZM7.365 9.402h.001c-.044.026-.09.049-.136.071v4.472l1.5-.875V8.61Zm5.885 1.032 1.115-.65h.002a.267.267 0 0 0 .133-.232V5.264l-1.25.725Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.152.682a2.251 2.251 0 0 1 2.269 0l.007.004 6.957 4.276a2.277 2.277 0 0 1 1.126 1.964v7.516c0 .81-.432 1.56-1.133 1.968l-.002.001-11.964 7.037-.004.003c-.706.41-1.578.41-2.284 0l-.026-.015-6.503-4.502a2.268 2.268 0 0 1-1.096-1.943V9.438c0-.392.1-.77.284-1.1l.003-.006.014-.026c.197-.342.48-.627.82-.827h.002L13.152.681Zm.757 1.295h-.001L2.648 8.616l6.248 4.247a.775.775 0 0 0 .758-.01h.001l11.633-6.804-6.629-4.074a.75.75 0 0 0-.75.003ZM8.517 14.33a2.286 2.286 0 0 1-.393-.18l-.023-.014-6.102-4.147v7.003c0 .275.145.528.379.664l.025.014 6.114 4.232V14.33ZM18 9.709l-3.25 1.9v7.548L18 17.245Zm-7.59 4.438-.002.002a2.296 2.296 0 0 1-.391.18v7.612l3.233-1.902v-7.552Zm9.09-5.316v7.532l2.124-1.25a.776.776 0 0 0 .387-.671V7.363Z"
      })
    }
  };
});
var CopilotIcon = /*#__PURE__*/createIconComponent("CopilotIcon", "octicon octicon-copilot", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.998 15.035c-4.562 0-7.873-2.914-7.998-3.749V9.338c.085-.628.677-1.686 1.588-2.065.013-.07.024-.143.036-.218.029-.183.06-.384.126-.612-.201-.508-.254-1.084-.254-1.656 0-.87.128-1.769.693-2.484.579-.733 1.494-1.124 2.724-1.261 1.206-.134 2.262.034 2.944.765.05.053.096.108.139.165.044-.057.094-.112.143-.165.682-.731 1.738-.899 2.944-.765 1.23.137 2.145.528 2.724 1.261.566.715.693 1.614.693 2.484 0 .572-.053 1.148-.254 1.656.066.228.098.429.126.612.012.076.024.148.037.218.924.385 1.522 1.471 1.591 2.095v1.872c0 .766-3.351 3.795-8.002 3.795Zm0-1.485c2.28 0 4.584-1.11 5.002-1.433V7.862l-.023-.116c-.49.21-1.075.291-1.727.291-1.146 0-2.059-.327-2.71-.991A3.222 3.222 0 0 1 8 6.303a3.24 3.24 0 0 1-.544.743c-.65.664-1.563.991-2.71.991-.652 0-1.236-.081-1.727-.291l-.023.116v4.255c.419.323 2.722 1.433 5.002 1.433ZM6.762 2.83c-.193-.206-.637-.413-1.682-.297-1.019.113-1.479.404-1.713.7-.247.312-.369.789-.369 1.554 0 .793.129 1.171.308 1.371.162.181.519.379 1.442.379.853 0 1.339-.235 1.638-.54.315-.322.527-.827.617-1.553.117-.935-.037-1.395-.241-1.614Zm4.155-.297c-1.044-.116-1.488.091-1.681.297-.204.219-.359.679-.242 1.614.091.726.303 1.231.618 1.553.299.305.784.54 1.638.54.922 0 1.28-.198 1.442-.379.179-.2.308-.578.308-1.371 0-.765-.123-1.242-.37-1.554-.233-.296-.693-.587-1.713-.7Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.25 9.037a.75.75 0 0 1 .75.75v1.501a.75.75 0 0 1-1.5 0V9.787a.75.75 0 0 1 .75-.75Zm4.25.75v1.501a.75.75 0 0 1-1.5 0V9.787a.75.75 0 0 1 1.5 0Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M23.922 16.992c-.861 1.495-5.859 5.023-11.922 5.023-6.063 0-11.061-3.528-11.922-5.023A.641.641 0 0 1 0 16.736v-2.869a.841.841 0 0 1 .053-.22c.372-.935 1.347-2.292 2.605-2.656.167-.429.414-1.055.644-1.517a10.195 10.195 0 0 1-.052-1.086c0-1.331.282-2.499 1.132-3.368.397-.406.89-.717 1.474-.952 1.399-1.136 3.392-2.093 6.122-2.093 2.731 0 4.767.957 6.166 2.093.584.235 1.077.546 1.474.952.85.869 1.132 2.037 1.132 3.368 0 .368-.014.733-.052 1.086.23.462.477 1.088.644 1.517 1.258.364 2.233 1.721 2.605 2.656a.832.832 0 0 1 .053.22v2.869a.641.641 0 0 1-.078.256ZM12.172 11h-.344a4.323 4.323 0 0 1-.355.508C10.703 12.455 9.555 13 7.965 13c-1.725 0-2.989-.359-3.782-1.259a2.005 2.005 0 0 1-.085-.104L4 11.741v6.585c1.435.779 4.514 2.179 8 2.179 3.486 0 6.565-1.4 8-2.179v-6.585l-.098-.104s-.033.045-.085.104c-.793.9-2.057 1.259-3.782 1.259-1.59 0-2.738-.545-3.508-1.492a4.323 4.323 0 0 1-.355-.508h-.016.016Zm.641-2.935c.136 1.057.403 1.913.878 2.497.442.544 1.134.938 2.344.938 1.573 0 2.292-.337 2.657-.751.384-.435.558-1.15.558-2.361 0-1.14-.243-1.847-.705-2.319-.477-.488-1.319-.862-2.824-1.025-1.487-.161-2.192.138-2.533.529-.269.307-.437.808-.438 1.578v.021c0 .265.021.562.063.893Zm-1.626 0c.042-.331.063-.628.063-.894v-.02c-.001-.77-.169-1.271-.438-1.578-.341-.391-1.046-.69-2.533-.529-1.505.163-2.347.537-2.824 1.025-.462.472-.705 1.179-.705 2.319 0 1.211.175 1.926.558 2.361.365.414 1.084.751 2.657.751 1.21 0 1.902-.394 2.344-.938.475-.584.742-1.44.878-2.497Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.5 14.25a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1Zm-5 0a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1Z"
      }))
    },
    "48": {
      "width": 48,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M47.801 34.003c-1.72 2.988-11.706 10.037-23.82 10.037S1.881 36.991.161 34.003a1.309 1.309 0 0 1-.161-.57v-5.615c.012-.17.047-.338.11-.498.744-1.867 2.692-4.58 5.206-5.308.333-.855.826-2.106 1.287-3.029a20.112 20.112 0 0 1-.104-2.171c0-2.659.563-4.992 2.262-6.729.793-.811 1.777-1.433 2.945-1.901C14.502 5.911 18.483 4 23.938 4c5.455 0 9.523 1.911 12.319 4.182 1.167.468 2.151 1.09 2.944 1.901 1.699 1.737 2.263 4.07 2.263 6.729 0 .736-.027 1.465-.105 2.171.461.923.954 2.174 1.288 3.029 2.513.728 4.461 3.441 5.205 5.308.081.205.115.424.115.645v5.318c0 .252-.04.502-.166.72ZM24.325 22.031h-.688a8.52 8.52 0 0 1-.709 1.016c-1.537 1.892-3.833 2.98-7.008 2.98-3.447 0-5.972-.717-7.557-2.514a4.408 4.408 0 0 1-.171-.21l-.195.21v13.155c2.867 1.558 9.02 4.353 15.984 4.353s13.117-2.795 15.984-4.353V23.513l-.195-.21s-.066.091-.171.21c-1.584 1.797-4.11 2.514-7.557 2.514-3.175 0-5.47-1.088-7.008-2.98a8.637 8.637 0 0 1-.709-1.016h-.033.033Zm-1.969-5.864a14.31 14.31 0 0 0 .127-1.785v-.042c-.003-1.537-.339-2.538-.876-3.152-.681-.78-2.09-1.378-5.06-1.057-3.008.326-4.69 1.073-5.643 2.048-.923.944-1.408 2.356-1.408 4.633 0 2.42.348 3.849 1.115 4.719.729.827 2.165 1.499 5.309 1.499 2.417 0 3.799-.786 4.683-1.873.948-1.168 1.482-2.878 1.753-4.99Zm3.25 0c.271 2.112.805 3.822 1.754 4.99.883 1.087 2.265 1.873 4.682 1.873 3.145 0 4.58-.672 5.309-1.499.767-.87 1.116-2.299 1.116-4.719 0-2.277-.485-3.689-1.408-4.633-.954-.975-2.635-1.722-5.644-2.048-2.969-.321-4.378.277-5.06 1.057-.537.614-.873 1.615-.876 3.152v.042c.002.53.042 1.123.127 1.785Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M28.998 28.516c1.104 0 1.999.895 1.999 1.999v3.998a2 2 0 1 1-3.998 0v-3.998c0-1.104.895-1.999 1.999-1.999Zm-9.996 0c1.104 0 1.999.895 1.999 1.999v3.998a2 2 0 1 1-3.998 0v-3.998c0-1.104.895-1.999 1.999-1.999Z"
      }))
    },
    "96": {
      "width": 96,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M95.667 67.954C92.225 73.933 72.24 88.04 47.997 88.04 23.754 88.04 3.769 73.933.328 67.954c-.216-.375-.307-.796-.328-1.226V55.661c.019-.371.089-.736.226-1.081 1.489-3.738 5.386-9.166 10.417-10.623.667-1.712 1.655-4.215 2.576-6.062-.154-1.414-.208-2.872-.208-4.345 0-5.322 1.128-9.99 4.527-13.466 1.587-1.623 3.557-2.869 5.893-3.805 5.595-4.545 13.563-8.369 24.48-8.369s19.057 3.824 24.652 8.369c2.337.936 4.306 2.182 5.894 3.805 3.399 3.476 4.527 8.144 4.527 13.466 0 1.473-.054 2.931-.208 4.345.921 1.847 1.909 4.35 2.576 6.062 5.03 1.457 8.928 6.885 10.417 10.623.163.41.231.848.231 1.289v10.644c0 .504-.081 1.004-.333 1.441ZM48.686 43.993l-.3.001-1.077-.001c-.423.709-.894 1.39-1.418 2.035-3.078 3.787-7.672 5.964-14.026 5.964-6.897 0-11.952-1.435-15.123-5.032a7.886 7.886 0 0 1-.342-.419l-.39.419v26.326c5.737 3.118 18.05 8.713 31.987 8.713 13.938 0 26.251-5.595 31.988-8.713V46.96l-.39-.419s-.132.181-.342.419c-3.171 3.597-8.226 5.032-15.123 5.032-6.354 0-10.949-2.177-14.026-5.964a17.178 17.178 0 0 1-1.418-2.034h-.066l.066-.001Zm-3.94-11.733c.17-1.326.251-2.513.253-3.573v-.084c-.005-3.077-.678-5.079-1.752-6.308-1.365-1.562-4.184-2.758-10.127-2.115-6.021.652-9.386 2.146-11.294 4.098-1.847 1.889-2.818 4.715-2.818 9.272 0 4.842.698 7.703 2.232 9.443 1.459 1.655 4.332 3.001 10.625 3.001 4.837 0 7.603-1.573 9.371-3.749 1.899-2.336 2.967-5.759 3.51-9.985Zm6.503 0c.543 4.226 1.611 7.649 3.51 9.985 1.768 2.176 4.533 3.749 9.371 3.749 6.292 0 9.165-1.346 10.624-3.001 1.535-1.74 2.232-4.601 2.232-9.443 0-4.557-.97-7.383-2.817-9.272-1.908-1.952-5.274-3.446-11.294-4.098-5.943-.643-8.763.553-10.127 2.115-1.074 1.229-1.747 3.231-1.752 6.308v.084c.002 1.06.083 2.247.253 3.573Zm-2.563 11.734h.066l-.066-.001v.001Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M38.5 55.75a3.5 3.5 0 0 1 3.5 3.5v8.5a3.5 3.5 0 1 1-7 0v-8.5a3.5 3.5 0 0 1 3.5-3.5Zm19 0a3.5 3.5 0 0 1 3.5 3.5v8.5a3.5 3.5 0 1 1-7 0v-8.5a3.5 3.5 0 0 1 3.5-3.5Z"
      }))
    }
  };
});
var CopilotErrorIcon = /*#__PURE__*/createIconComponent("CopilotErrorIcon", "octicon octicon-copilot-error", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16 11.24c0 .112-.072.274-.21.467L13 9.688V7.862l-.023-.116c-.49.21-1.075.291-1.727.291-.198 0-.388-.009-.571-.029L6.833 5.226a4.01 4.01 0 0 0 .17-.782c.117-.935-.037-1.395-.241-1.614-.193-.206-.637-.413-1.682-.297-.683.076-1.115.231-1.395.415l-1.257-.91c.579-.564 1.413-.877 2.485-.996 1.206-.134 2.262.034 2.944.765.05.053.096.108.139.165.044-.057.094-.112.143-.165.682-.731 1.738-.899 2.944-.765 1.23.137 2.145.528 2.724 1.261.566.715.693 1.614.693 2.484 0 .572-.053 1.148-.254 1.656.066.228.098.429.126.612.012.076.024.148.037.218.924.385 1.522 1.471 1.591 2.095Zm-5.083-8.707c-1.044-.116-1.488.091-1.681.297-.204.219-.359.679-.242 1.614.091.726.303 1.231.618 1.553.299.305.784.54 1.638.54.922 0 1.28-.198 1.442-.379.179-.2.308-.578.308-1.371 0-.765-.123-1.242-.37-1.554-.233-.296-.693-.587-1.713-.7Zm2.511 11.074c-1.393.776-3.272 1.428-5.43 1.428-4.562 0-7.873-2.914-7.998-3.749V9.338c.085-.628.677-1.686 1.588-2.065.013-.07.024-.143.036-.218.029-.183.06-.384.126-.612-.18-.455-.241-.963-.252-1.475L.31 4.107A.747.747 0 0 1 0 3.509V3.49a.748.748 0 0 1 .625-.73c.156-.026.306.047.435.139l14.667 10.578a.592.592 0 0 1 .227.264.752.752 0 0 1 .046.249v.022a.75.75 0 0 1-1.19.596Zm-1.367-.991L5.635 7.964a5.128 5.128 0 0 1-.889.073c-.652 0-1.236-.081-1.727-.291l-.023.116v4.255c.419.323 2.722 1.433 5.002 1.433 1.539 0 3.089-.505 4.063-.934Z"
      })
    }
  };
});
var CopilotWarningIcon = /*#__PURE__*/createIconComponent("CopilotWarningIcon", "octicon octicon-copilot-warning", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.498 14.811a4.53 4.53 0 0 1-1.161-1.337 4.476 4.476 0 0 1-.587-2.224 4.496 4.496 0 0 1 4.5-4.5 4.5 4.5 0 0 1 4.5 4.5 4.5 4.5 0 0 1-7.252 3.561ZM10.5 8.75V11a.75.75 0 0 0 1.5 0V8.75a.75.75 0 1 0-1.5 0Zm.75 5.75a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m14.354 6.114-.05-.029a5.949 5.949 0 0 0-1.351-.589c.03-.19.047-.422.047-.709 0-.765-.123-1.242-.37-1.554-.233-.296-.693-.587-1.713-.7-1.044-.116-1.488.091-1.681.297-.204.219-.359.679-.242 1.614.058.462.165.834.316 1.127A6.025 6.025 0 0 0 6.369 7.76c-.472.185-1.015.277-1.623.277-.652 0-1.236-.081-1.727-.291l-.023.116v4.255c.265.205 1.285.725 2.577 1.079a5.937 5.937 0 0 0 .939 1.736C2.733 14.407.111 12.027 0 11.286V9.338c.085-.628.677-1.686 1.588-2.065.013-.07.024-.143.036-.218.029-.183.06-.384.126-.612-.201-.508-.254-1.084-.254-1.656 0-.87.128-1.769.693-2.484.579-.733 1.494-1.124 2.724-1.261 1.206-.134 2.262.034 2.944.765.05.053.096.108.139.165.044-.057.094-.112.143-.165.682-.731 1.738-.899 2.944-.765 1.23.137 2.145.528 2.724 1.261.566.715.693 1.614.693 2.484 0 .452-.033.906-.146 1.327ZM6.762 2.83c-.193-.206-.637-.413-1.682-.297-1.019.113-1.479.404-1.713.7-.247.312-.369.789-.369 1.554 0 .793.129 1.171.308 1.371.162.181.519.379 1.442.379.853 0 1.339-.235 1.638-.54.315-.322.527-.827.617-1.553.117-.935-.037-1.395-.241-1.614Z"
      }))
    }
  };
});
var CopyIcon = /*#__PURE__*/createIconComponent("CopyIcon", "octicon octicon-copy", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 6.75C0 5.784.784 5 1.75 5h1.5a.75.75 0 0 1 0 1.5h-1.5a.25.25 0 0 0-.25.25v7.5c0 .138.112.25.25.25h7.5a.25.25 0 0 0 .25-.25v-1.5a.75.75 0 0 1 1.5 0v1.5A1.75 1.75 0 0 1 9.25 16h-7.5A1.75 1.75 0 0 1 0 14.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 1.75C5 .784 5.784 0 6.75 0h7.5C15.216 0 16 .784 16 1.75v7.5A1.75 1.75 0 0 1 14.25 11h-7.5A1.75 1.75 0 0 1 5 9.25Zm1.75-.25a.25.25 0 0 0-.25.25v7.5c0 .138.112.25.25.25h7.5a.25.25 0 0 0 .25-.25v-7.5a.25.25 0 0 0-.25-.25Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.024 3.75c0-.966.784-1.75 1.75-1.75H20.25c.966 0 1.75.784 1.75 1.75v11.498a1.75 1.75 0 0 1-1.75 1.75H8.774a1.75 1.75 0 0 1-1.75-1.75Zm1.75-.25a.25.25 0 0 0-.25.25v11.498c0 .139.112.25.25.25H20.25a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.995 10.749a1.75 1.75 0 0 1 1.75-1.751H5.25a.75.75 0 1 1 0 1.5H3.745a.25.25 0 0 0-.25.25L3.5 20.25c0 .138.111.25.25.25h9.5a.25.25 0 0 0 .25-.25v-1.51a.75.75 0 1 1 1.5 0v1.51A1.75 1.75 0 0 1 13.25 22h-9.5A1.75 1.75 0 0 1 2 20.25l-.005-9.501Z"
      }))
    }
  };
});
var CpuIcon = /*#__PURE__*/createIconComponent("CpuIcon", "octicon octicon-cpu", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.5.75V2h3V.75a.75.75 0 0 1 1.5 0V2h1.25c.966 0 1.75.784 1.75 1.75V5h1.25a.75.75 0 0 1 0 1.5H14v3h1.25a.75.75 0 0 1 0 1.5H14v1.25A1.75 1.75 0 0 1 12.25 14H11v1.25a.75.75 0 0 1-1.5 0V14h-3v1.25a.75.75 0 0 1-1.5 0V14H3.75A1.75 1.75 0 0 1 2 12.25V11H.75a.75.75 0 0 1 0-1.5H2v-3H.75a.75.75 0 0 1 0-1.5H2V3.75C2 2.784 2.784 2 3.75 2H5V.75a.75.75 0 0 1 1.5 0Zm5.75 11.75a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25h-8.5a.25.25 0 0 0-.25.25v8.5c0 .138.112.25.25.25ZM5.75 5h4.5a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-.75.75h-4.5a.75.75 0 0 1-.75-.75v-4.5A.75.75 0 0 1 5.75 5Zm.75 4.5h3v-3h-3Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75 8h6.5a.75.75 0 0 1 .75.75v6.5a.75.75 0 0 1-.75.75h-6.5a.75.75 0 0 1-.75-.75v-6.5A.75.75 0 0 1 8.75 8Zm.75 6.5h5v-5h-5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.25 1a.75.75 0 0 1 .75.75V4h2.25c.966 0 1.75.784 1.75 1.75V8h2.25a.75.75 0 0 1 0 1.5H20v5h2.25a.75.75 0 0 1 0 1.5H20v2.25A1.75 1.75 0 0 1 18.25 20H16v2.25a.75.75 0 0 1-1.5 0V20h-5v2.25a.75.75 0 0 1-1.5 0V20H5.75A1.75 1.75 0 0 1 4 18.25V16H1.75a.75.75 0 0 1 0-1.5H4v-5H1.75a.75.75 0 0 1 0-1.5H4V5.75C4 4.784 4.784 4 5.75 4H8V1.75a.75.75 0 0 1 1.5 0V4h5V1.75a.75.75 0 0 1 .75-.75Zm3 17.5a.25.25 0 0 0 .25-.25V5.75a.25.25 0 0 0-.25-.25H5.75a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25Z"
      }))
    }
  };
});
var CreditCardIcon = /*#__PURE__*/createIconComponent("CreditCardIcon", "octicon octicon-credit-card", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.75 9a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5h-1.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 3.75C0 2.784.784 2 1.75 2h12.5c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 14H1.75A1.75 1.75 0 0 1 0 12.25ZM14.5 6.5h-13v5.75c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25Zm0-2.75a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25V5h13Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.25 14a.75.75 0 0 0 0 1.5h3.5a.75.75 0 0 0 0-1.5h-3.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 3h20.5c.966 0 1.75.784 1.75 1.75v14.5A1.75 1.75 0 0 1 22.25 21H1.75A1.75 1.75 0 0 1 0 19.25V4.75C0 3.784.784 3 1.75 3Zm-.25 7v9.25c0 .138.112.25.25.25h20.5a.25.25 0 0 0 .25-.25V10Zm0-5.25V8.5h21V4.75a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25Z"
      }))
    }
  };
});
var CrossReferenceIcon = /*#__PURE__*/createIconComponent("CrossReferenceIcon", "octicon octicon-cross-reference", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 3.5a.25.25 0 0 0-.25.25v7.5c0 .138.112.25.25.25h2a.75.75 0 0 1 .75.75v2.19l2.72-2.72a.749.749 0 0 1 .53-.22h4.5a.25.25 0 0 0 .25-.25v-2.5a.75.75 0 0 1 1.5 0v2.5A1.75 1.75 0 0 1 13.25 13H9.06l-2.573 2.573A1.458 1.458 0 0 1 4 14.543V13H2.75A1.75 1.75 0 0 1 1 11.25v-7.5C1 2.784 1.784 2 2.75 2h5.5a.75.75 0 0 1 0 1.5ZM16 1.25v4.146a.25.25 0 0 1-.427.177L14.03 4.03l-3.75 3.75a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l3.75-3.75-1.543-1.543A.25.25 0 0 1 11.604 1h4.146a.25.25 0 0 1 .25.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16.5 2.25a.75.75 0 0 1 .75-.75h5.5a.75.75 0 0 1 .75.75v5.5a.75.75 0 0 1-1.5 0V4.06l-6.22 6.22a.75.75 0 1 1-1.06-1.06L20.94 3h-3.69a.75.75 0 0 1-.75-.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.25 4a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h2.5a.75.75 0 0 1 .75.75v3.19l3.72-3.72a.75.75 0 0 1 .53-.22h10a.25.25 0 0 0 .25-.25v-6a.75.75 0 0 1 1.5 0v6a1.75 1.75 0 0 1-1.75 1.75h-9.69l-3.573 3.573A1.457 1.457 0 0 1 5 21.043V18.5H3.25a1.75 1.75 0 0 1-1.75-1.75V4.25c0-.966.784-1.75 1.75-1.75h11a.75.75 0 0 1 0 1.5h-11Z"
      }))
    }
  };
});
var DashIcon = /*#__PURE__*/createIconComponent("DashIcon", "octicon octicon-dash", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 7.75A.75.75 0 0 1 2.75 7h10a.75.75 0 0 1 0 1.5h-10A.75.75 0 0 1 2 7.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.5 12.75a.75.75 0 0 1 .75-.75h13.5a.75.75 0 0 1 0 1.5H5.25a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var DatabaseIcon = /*#__PURE__*/createIconComponent("DatabaseIcon", "octicon octicon-database", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 3.5c0-.626.292-1.165.7-1.59.406-.422.956-.767 1.579-1.041C4.525.32 6.195 0 8 0c1.805 0 3.475.32 4.722.869.622.274 1.172.62 1.578 1.04.408.426.7.965.7 1.591v9c0 .626-.292 1.165-.7 1.59-.406.422-.956.767-1.579 1.041C11.476 15.68 9.806 16 8 16c-1.805 0-3.475-.32-4.721-.869-.623-.274-1.173-.62-1.579-1.04-.408-.426-.7-.965-.7-1.591Zm1.5 0c0 .133.058.318.282.551.227.237.591.483 1.101.707C4.898 5.205 6.353 5.5 8 5.5c1.646 0 3.101-.295 4.118-.742.508-.224.873-.471 1.1-.708.224-.232.282-.417.282-.55 0-.133-.058-.318-.282-.551-.227-.237-.591-.483-1.101-.707C11.102 1.795 9.647 1.5 8 1.5c-1.646 0-3.101.295-4.118.742-.508.224-.873.471-1.1.708-.224.232-.282.417-.282.55Zm0 4.5c0 .133.058.318.282.551.227.237.591.483 1.101.707C4.898 9.705 6.353 10 8 10c1.646 0 3.101-.295 4.118-.742.508-.224.873-.471 1.1-.708.224-.232.282-.417.282-.55V5.724c-.241.15-.503.286-.778.407C11.475 6.68 9.805 7 8 7c-1.805 0-3.475-.32-4.721-.869a6.15 6.15 0 0 1-.779-.407Zm0 2.225V12.5c0 .133.058.318.282.55.227.237.592.484 1.1.708 1.016.447 2.471.742 4.118.742 1.647 0 3.102-.295 4.117-.742.51-.224.874-.47 1.101-.707.224-.233.282-.418.282-.551v-2.275c-.241.15-.503.285-.778.406-1.247.549-2.917.869-4.722.869-1.805 0-3.475-.32-4.721-.869a6.327 6.327 0 0 1-.779-.406Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1.25c2.487 0 4.773.402 6.466 1.079.844.337 1.577.758 2.112 1.264.536.507.922 1.151.922 1.907v12.987l-.026.013h.026c0 .756-.386 1.4-.922 1.907-.535.506-1.268.927-2.112 1.264-1.693.677-3.979 1.079-6.466 1.079s-4.774-.402-6.466-1.079c-.844-.337-1.577-.758-2.112-1.264C2.886 19.9 2.5 19.256 2.5 18.5h.026l-.026-.013V5.5c0-.756.386-1.4.922-1.907.535-.506 1.268-.927 2.112-1.264C7.226 1.652 9.513 1.25 12 1.25ZM4 14.371v4.116l-.013.013H4c0 .211.103.487.453.817.351.332.898.666 1.638.962 1.475.589 3.564.971 5.909.971 2.345 0 4.434-.381 5.909-.971.739-.296 1.288-.63 1.638-.962.349-.33.453-.607.453-.817h.013L20 18.487v-4.116a7.85 7.85 0 0 1-1.534.8c-1.693.677-3.979 1.079-6.466 1.079s-4.774-.402-6.466-1.079a7.843 7.843 0 0 1-1.534-.8ZM20 12V7.871a7.85 7.85 0 0 1-1.534.8C16.773 9.348 14.487 9.75 12 9.75s-4.774-.402-6.466-1.079A7.85 7.85 0 0 1 4 7.871V12c0 .21.104.487.453.817.35.332.899.666 1.638.961 1.475.59 3.564.972 5.909.972 2.345 0 4.434-.382 5.909-.972.74-.295 1.287-.629 1.638-.96.35-.33.453-.607.453-.818ZM4 5.5c0 .211.103.487.453.817.351.332.898.666 1.638.962 1.475.589 3.564.971 5.909.971 2.345 0 4.434-.381 5.909-.971.739-.296 1.288-.63 1.638-.962.349-.33.453-.607.453-.817 0-.211-.103-.487-.453-.817-.351-.332-.898-.666-1.638-.962-1.475-.589-3.564-.971-5.909-.971-2.345 0-4.434.381-5.909.971-.739.296-1.288.63-1.638.962C4.104 5.013 4 5.29 4 5.5Z"
      })
    }
  };
});
var DependabotIcon = /*#__PURE__*/createIconComponent("DependabotIcon", "octicon octicon-dependabot", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 7.5a.75.75 0 0 1 .75.75v1.5a.75.75 0 0 1-1.5 0v-1.5a.75.75 0 0 1 .75-.75Zm5.25.75a.75.75 0 0 0-1.5 0v1.5a.75.75 0 0 0 1.5 0v-1.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.25 0h2A.75.75 0 0 1 9 .75V3.5h3.25a2.25 2.25 0 0 1 2.25 2.25V8h.75a.75.75 0 0 1 0 1.5h-.75v2.75a2.25 2.25 0 0 1-2.25 2.25h-8.5a2.25 2.25 0 0 1-2.25-2.25V9.5H.75a.75.75 0 0 1 0-1.5h.75V5.75A2.25 2.25 0 0 1 3.75 3.5H7.5v-2H6.25a.75.75 0 0 1 0-1.5ZM3 5.75v6.5c0 .414.336.75.75.75h8.5a.75.75 0 0 0 .75-.75v-6.5a.75.75 0 0 0-.75-.75h-8.5a.75.75 0 0 0-.75.75Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75 11a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-3.5a.75.75 0 0 1 .75-.75Zm7.25.75a.75.75 0 0 0-1.5 0v3.5a.75.75 0 0 0 1.5 0v-3.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.813 1h2.437a.75.75 0 0 1 .75.75V5h6.75A2.25 2.25 0 0 1 22 7.25v5.25h1.25a.75.75 0 0 1 0 1.5H22v5.75A2.25 2.25 0 0 1 19.75 22H4.25A2.25 2.25 0 0 1 2 19.75V14H.75a.75.75 0 0 1 0-1.5H2V7.25A2.25 2.25 0 0 1 4.25 5h7.25V2.5H9.813A.75.75 0 0 1 9.812 1ZM3.5 7.25v12.5c0 .414.336.75.75.75h15.5a.75.75 0 0 0 .75-.75V7.25a.75.75 0 0 0-.75-.75H4.25a.75.75 0 0 0-.75.75Z"
      }))
    }
  };
});
var DesktopDownloadIcon = /*#__PURE__*/createIconComponent("DesktopDownloadIcon", "octicon octicon-desktop-download", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m4.927 5.427 2.896 2.896a.25.25 0 0 0 .354 0l2.896-2.896A.25.25 0 0 0 10.896 5H8.75V.75a.75.75 0 1 0-1.5 0V5H5.104a.25.25 0 0 0-.177.427Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.573 2.573a.25.25 0 0 0-.073.177v7.5a.25.25 0 0 0 .25.25h12.5a.25.25 0 0 0 .25-.25v-7.5a.25.25 0 0 0-.25-.25h-3a.75.75 0 1 1 0-1.5h3A1.75 1.75 0 0 1 16 2.75v7.5A1.75 1.75 0 0 1 14.25 12h-3.727c.099 1.041.52 1.872 1.292 2.757A.75.75 0 0 1 11.25 16h-6.5a.75.75 0 0 1-.565-1.243c.772-.885 1.192-1.716 1.292-2.757H1.75A1.75 1.75 0 0 1 0 10.25v-7.5A1.75 1.75 0 0 1 1.75 1h3a.75.75 0 0 1 0 1.5h-3a.25.25 0 0 0-.177.073ZM6.982 12a5.72 5.72 0 0 1-.765 2.5h3.566a5.72 5.72 0 0 1-.765-2.5H6.982Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.25 9.331V.75a.75.75 0 0 1 1.5 0v8.58l1.949-2.11A.75.75 0 1 1 15.8 8.237l-3.25 3.52a.75.75 0 0 1-1.102 0l-3.25-3.52A.75.75 0 1 1 9.3 7.22l1.949 2.111Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.5 3.75v11.5c0 .138.112.25.25.25h18.5a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25h-5.5a.75.75 0 0 1 0-1.5h5.5c.966 0 1.75.784 1.75 1.75v11.5A1.75 1.75 0 0 1 21.25 17h-6.204c.171 1.375.805 2.652 1.769 3.757A.752.752 0 0 1 16.25 22h-8.5a.75.75 0 0 1-.566-1.243c.965-1.105 1.599-2.382 1.77-3.757H2.75A1.75 1.75 0 0 1 1 15.25V3.75C1 2.784 1.784 2 2.75 2h5.5a.75.75 0 0 1 0 1.5h-5.5a.25.25 0 0 0-.25.25ZM10.463 17c-.126 1.266-.564 2.445-1.223 3.5h5.52c-.66-1.055-1.098-2.234-1.223-3.5Z"
      }))
    }
  };
});
var DeviceCameraIcon = /*#__PURE__*/createIconComponent("DeviceCameraIcon", "octicon octicon-device-camera", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15 3c.55 0 1 .45 1 1v9c0 .55-.45 1-1 1H1c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1 0-.55.45-1 1-1h4c.55 0 1 .45 1 1Zm-4.5 9c1.94 0 3.5-1.56 3.5-3.5S12.44 5 10.5 5 7 6.56 7 8.5 8.56 12 10.5 12ZM13 8.5c0 1.38-1.13 2.5-2.5 2.5S8 9.87 8 8.5 9.13 6 10.5 6 13 7.13 13 8.5ZM6 5V4H2v1Z"
      })
    }
  };
});
var DeviceCameraVideoIcon = /*#__PURE__*/createIconComponent("DeviceCameraVideoIcon", "octicon octicon-device-camera-video", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16 3.75v8.5a.75.75 0 0 1-1.136.643L11 10.575v.675A1.75 1.75 0 0 1 9.25 13h-7.5A1.75 1.75 0 0 1 0 11.25v-6.5C0 3.784.784 3 1.75 3h7.5c.966 0 1.75.784 1.75 1.75v.675l3.864-2.318A.75.75 0 0 1 16 3.75Zm-6.5 1a.25.25 0 0 0-.25-.25h-7.5a.25.25 0 0 0-.25.25v6.5c0 .138.112.25.25.25h7.5a.25.25 0 0 0 .25-.25v-6.5ZM11 8.825l3.5 2.1v-5.85l-3.5 2.1Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M24 5.25v13a.75.75 0 0 1-1.136.643L16.5 15.075v2.175A1.75 1.75 0 0 1 14.75 19h-13A1.75 1.75 0 0 1 0 17.25v-11C0 5.284.784 4.5 1.75 4.5h13c.966 0 1.75.784 1.75 1.75v2.175l6.364-3.818A.75.75 0 0 1 24 5.25Zm-9 1a.25.25 0 0 0-.25-.25h-13a.25.25 0 0 0-.25.25v11c0 .138.112.25.25.25h13a.25.25 0 0 0 .25-.25v-11Zm1.5 7.075 6 3.6V6.575l-6 3.6Z"
      })
    }
  };
});
var DeviceDesktopIcon = /*#__PURE__*/createIconComponent("DeviceDesktopIcon", "octicon octicon-device-desktop", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.25 1c.966 0 1.75.784 1.75 1.75v7.5A1.75 1.75 0 0 1 14.25 12h-3.727c.099 1.041.52 1.872 1.292 2.757A.752.752 0 0 1 11.25 16h-6.5a.75.75 0 0 1-.565-1.243c.772-.885 1.192-1.716 1.292-2.757H1.75A1.75 1.75 0 0 1 0 10.25v-7.5C0 1.784.784 1 1.75 1ZM1.75 2.5a.25.25 0 0 0-.25.25v7.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-7.5a.25.25 0 0 0-.25-.25ZM9.018 12H6.982a5.72 5.72 0 0 1-.765 2.5h3.566a5.72 5.72 0 0 1-.765-2.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.954 17H2.75A1.75 1.75 0 0 1 1 15.25V3.75C1 2.784 1.784 2 2.75 2h18.5c.966 0 1.75.784 1.75 1.75v11.5A1.75 1.75 0 0 1 21.25 17h-6.204c.171 1.375.805 2.652 1.769 3.757A.752.752 0 0 1 16.25 22h-8.5a.75.75 0 0 1-.565-1.243c.964-1.105 1.598-2.382 1.769-3.757ZM21.5 3.75a.25.25 0 0 0-.25-.25H2.75a.25.25 0 0 0-.25.25v11.5c0 .138.112.25.25.25h18.5a.25.25 0 0 0 .25-.25ZM13.537 17h-3.074c-.126 1.266-.564 2.445-1.223 3.5h5.52c-.659-1.055-1.098-2.234-1.223-3.5Z"
      })
    }
  };
});
var DeviceMobileIcon = /*#__PURE__*/createIconComponent("DeviceMobileIcon", "octicon octicon-device-mobile", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 0h8.5C13.216 0 14 .784 14 1.75v12.5A1.75 1.75 0 0 1 12.25 16h-8.5A1.75 1.75 0 0 1 2 14.25V1.75C2 .784 2.784 0 3.75 0ZM3.5 1.75v12.5c0 .138.112.25.25.25h8.5a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25h-8.5a.25.25 0 0 0-.25.25ZM8 13a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.25 5.25A.75.75 0 0 1 11 4.5h2A.75.75 0 0 1 13 6h-2a.75.75 0 0 1-.75-.75ZM12 19.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 2.75C4 1.784 4.784 1 5.75 1h12.5c.966 0 1.75.784 1.75 1.75v18.5A1.75 1.75 0 0 1 18.25 23H5.75A1.75 1.75 0 0 1 4 21.25Zm1.75-.25a.25.25 0 0 0-.25.25v18.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V2.75a.25.25 0 0 0-.25-.25Z"
      }))
    }
  };
});
var DevicesIcon = /*#__PURE__*/createIconComponent("DevicesIcon", "octicon octicon-devices", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.784.784 1 1.75 1h12.5c.966 0 1.75.784 1.75 1.75V5a.75.75 0 0 1-1.5 0V2.75a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25v7.5c0 .138.112.25.25.25H7A.75.75 0 0 1 7 12h-.268a5.712 5.712 0 0 1-.765 2.5H7A.75.75 0 0 1 7 16H4.5a.75.75 0 0 1-.565-1.243c.772-.885 1.193-1.716 1.292-2.757H1.75A1.75 1.75 0 0 1 0 10.25v-7.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.75 7h3.5c.967 0 1.75.784 1.75 1.75v5.5A1.75 1.75 0 0 1 14.25 16h-3.5A1.75 1.75 0 0 1 9 14.25v-5.5C9 7.784 9.783 7 10.75 7Zm-.25 1.75v5.5c0 .138.112.25.25.25h3.5a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25h-3.5a.25.25 0 0 0-.25.25Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 3.75C1 2.784 1.784 2 2.75 2h18.5c.966 0 1.75.784 1.75 1.75v4a.75.75 0 0 1-1.5 0v-4a.25.25 0 0 0-.25-.25H2.75a.25.25 0 0 0-.25.25v11.5c0 .138.112.25.25.25h9a.75.75 0 0 1 0 1.5h-1.287c-.126 1.266-.564 2.445-1.223 3.5h2.51a.75.75 0 0 1 0 1.5h-4a.75.75 0 0 1-.565-1.243c.964-1.105 1.598-2.382 1.769-3.757H2.75A1.75 1.75 0 0 1 1 15.25V3.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14 11.75c0-.967.783-1.75 1.75-1.75h5.5c.966 0 1.75.783 1.75 1.75v8.5A1.75 1.75 0 0 1 21.25 22h-5.5A1.75 1.75 0 0 1 14 20.25Zm1.75-.25a.25.25 0 0 0-.25.25v8.5c0 .138.112.25.25.25h5.5a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25Z"
      }))
    }
  };
});
var DiamondIcon = /*#__PURE__*/createIconComponent("DiamondIcon", "octicon octicon-diamond", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.527 9.237a1.75 1.75 0 0 1 0-2.474L6.777.512a1.75 1.75 0 0 1 2.475 0l6.251 6.25a1.75 1.75 0 0 1 0 2.475l-6.25 6.251a1.75 1.75 0 0 1-2.475 0L.527 9.238Zm1.06-1.414a.25.25 0 0 0 0 .354l6.251 6.25a.25.25 0 0 0 .354 0l6.25-6.25a.25.25 0 0 0 0-.354l-6.25-6.25a.25.25 0 0 0-.354 0l-6.25 6.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.527 13.237a1.75 1.75 0 0 1 0-2.474l9.272-9.273a1.75 1.75 0 0 1 2.475 0l9.272 9.273a1.75 1.75 0 0 1 0 2.474l-9.272 9.272a1.75 1.75 0 0 1-2.475 0Zm1.06-1.414a.25.25 0 0 0 0 .354l9.273 9.272a.25.25 0 0 0 .353 0l9.272-9.272a.25.25 0 0 0 0-.354l-9.272-9.272a.25.25 0 0 0-.353 0Z"
      })
    }
  };
});
var DiffIcon = /*#__PURE__*/createIconComponent("DiffIcon", "octicon octicon-diff", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75 1.75V5H12a.75.75 0 0 1 0 1.5H8.75v3.25a.75.75 0 0 1-1.5 0V6.5H4A.75.75 0 0 1 4 5h3.25V1.75a.75.75 0 0 1 1.5 0ZM4 13h8a.75.75 0 0 1 0 1.5H4A.75.75 0 0 1 4 13Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.25 3.5a.75.75 0 0 1 .75.75V8.5h4.25a.75.75 0 0 1 0 1.5H13v4.25a.75.75 0 0 1-1.5 0V10H7.25a.75.75 0 0 1 0-1.5h4.25V4.25a.75.75 0 0 1 .75-.75ZM6.562 19.25a.75.75 0 0 1 .75-.75h9.938a.75.75 0 0 1 0 1.5H7.312a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var DiffAddedIcon = /*#__PURE__*/createIconComponent("DiffAddedIcon", "octicon octicon-diff-added", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 1h10.5c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 13.25 15H2.75A1.75 1.75 0 0 1 1 13.25V2.75C1 1.784 1.784 1 2.75 1Zm10.5 1.5H2.75a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V2.75a.25.25 0 0 0-.25-.25ZM8 4a.75.75 0 0 1 .75.75v2.5h2.5a.75.75 0 0 1 0 1.5h-2.5v2.5a.75.75 0 0 1-1.5 0v-2.5h-2.5a.75.75 0 0 1 0-1.5h2.5v-2.5A.75.75 0 0 1 8 4Z"
      })
    }
  };
});
var DiffIgnoredIcon = /*#__PURE__*/createIconComponent("DiffIgnoredIcon", "octicon octicon-diff-ignored", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.25 1c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 13.25 15H2.75A1.75 1.75 0 0 1 1 13.25V2.75C1 1.784 1.784 1 2.75 1ZM2.75 2.5a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V2.75a.25.25 0 0 0-.25-.25Zm8.53 3.28-5.5 5.5a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l5.5-5.5a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042Z"
      })
    }
  };
});
var DiffModifiedIcon = /*#__PURE__*/createIconComponent("DiffModifiedIcon", "octicon octicon-diff-modified", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.25 1c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 13.25 15H2.75A1.75 1.75 0 0 1 1 13.25V2.75C1 1.784 1.784 1 2.75 1ZM2.75 2.5a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V2.75a.25.25 0 0 0-.25-.25ZM8 10a2 2 0 1 1-.001-3.999A2 2 0 0 1 8 10Z"
      })
    }
  };
});
var DiffRemovedIcon = /*#__PURE__*/createIconComponent("DiffRemovedIcon", "octicon octicon-diff-removed", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.25 1c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 13.25 15H2.75A1.75 1.75 0 0 1 1 13.25V2.75C1 1.784 1.784 1 2.75 1ZM2.75 2.5a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V2.75a.25.25 0 0 0-.25-.25Zm8.5 6.25h-6.5a.75.75 0 0 1 0-1.5h6.5a.75.75 0 0 1 0 1.5Z"
      })
    }
  };
});
var DiffRenamedIcon = /*#__PURE__*/createIconComponent("DiffRenamedIcon", "octicon octicon-diff-renamed", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.25 1c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 13.25 15H2.75A1.75 1.75 0 0 1 1 13.25V2.75C1 1.784 1.784 1 2.75 1ZM2.75 2.5a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V2.75a.25.25 0 0 0-.25-.25Zm9.03 6.03-3.25 3.25a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l1.97-1.97H4.75a.75.75 0 0 1 0-1.5h4.69L7.47 5.28a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018l3.25 3.25a.75.75 0 0 1 0 1.06Z"
      })
    }
  };
});
var DiscussionClosedIcon = /*#__PURE__*/createIconComponent("DiscussionClosedIcon", "octicon octicon-discussion-closed", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.783.784 1 1.75 1h8.5c.967 0 1.75.783 1.75 1.75v5.5A1.75 1.75 0 0 1 10.25 10H7.061l-2.574 2.573A1.457 1.457 0 0 1 2 11.543V10h-.25A1.75 1.75 0 0 1 0 8.25Zm1.75-.25a.25.25 0 0 0-.25.25v5.5c0 .138.112.25.25.25h1a.75.75 0 0 1 .75.75v2.189L6.22 8.72a.747.747 0 0 1 .53-.22h3.5a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25Zm12.5 2h-.5a.75.75 0 0 1 0-1.5h.5c.967 0 1.75.783 1.75 1.75v5.5A1.75 1.75 0 0 1 14.25 12H14v1.543a1.457 1.457 0 0 1-2.487 1.03L9.22 12.28a.749.749 0 1 1 1.06-1.06l2.22 2.219V11.25a.75.75 0 0 1 .75-.75h1a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25Zm-5.47.28-3 3a.747.747 0 0 1-1.06 0l-1.5-1.5a.749.749 0 1 1 1.06-1.06l.97.969L7.72 3.72a.749.749 0 1 1 1.06 1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.783.784 1 1.75 1h12.5c.967 0 1.75.783 1.75 1.75v9.5A1.75 1.75 0 0 1 14.25 14H8.061l-2.574 2.573A1.457 1.457 0 0 1 3 15.543V14H1.75A1.75 1.75 0 0 1 0 12.25Zm1.75-.25a.25.25 0 0 0-.25.25v9.5c0 .138.112.25.25.25h2a.75.75 0 0 1 .75.75v2.189l2.72-2.719a.747.747 0 0 1 .53-.22h6.5a.25.25 0 0 0 .25-.25v-9.5a.25.25 0 0 0-.25-.25Zm20.5 6h-3.5a.75.75 0 0 1 0-1.5h3.5c.966 0 1.75.784 1.75 1.75v9.5A1.75 1.75 0 0 1 22.25 20H21v1.543a1.457 1.457 0 0 1-2.487 1.03L15.939 20H10.75A1.75 1.75 0 0 1 9 18.25v-1.465a.75.75 0 0 1 1.5 0v1.465c0 .138.112.25.25.25h5.5c.199 0 .39.079.53.22l2.72 2.719V19.25a.75.75 0 0 1 .75-.75h2a.25.25 0 0 0 .25-.25v-9.5a.25.25 0 0 0-.25-.25Zm-9.72-3.22-5 5a.747.747 0 0 1-1.06 0l-2.5-2.5a.749.749 0 1 1 1.06-1.06L7 8.689l4.47-4.469a.749.749 0 1 1 1.06 1.06Z"
      })
    }
  };
});
var DiscussionDuplicateIcon = /*#__PURE__*/createIconComponent("DiscussionDuplicateIcon", "octicon octicon-discussion-duplicate", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.783.784 1 1.75 1h8.5c.967 0 1.75.783 1.75 1.75v5.5A1.75 1.75 0 0 1 10.25 10H7.061l-2.574 2.573A1.457 1.457 0 0 1 2 11.543V10h-.25A1.75 1.75 0 0 1 0 8.25Zm1.75-.25a.25.25 0 0 0-.25.25v5.5c0 .138.112.25.25.25h1a.75.75 0 0 1 .75.75v2.189L6.22 8.72a.747.747 0 0 1 .53-.22h3.5a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25Zm12.5 2h-.5a.75.75 0 0 1 0-1.5h.5c.967 0 1.75.783 1.75 1.75v5.5A1.75 1.75 0 0 1 14.25 12H14v1.543a1.457 1.457 0 0 1-2.487 1.03L9.22 12.28a.749.749 0 1 1 1.06-1.06l2.22 2.219V11.25a.75.75 0 0 1 .75-.75h1a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25Zm-6.282.03L5.03 7.468a.749.749 0 1 1-1.06-1.061L6.907 3.47a.75.75 0 0 1 1.061 1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.783.784 1 1.75 1h12.5c.967 0 1.75.783 1.75 1.75v9.5A1.75 1.75 0 0 1 14.25 14H8.061l-2.574 2.573A1.457 1.457 0 0 1 3 15.543V14H1.75A1.75 1.75 0 0 1 0 12.25Zm1.75-.25a.25.25 0 0 0-.25.25v9.5c0 .138.112.25.25.25h2a.75.75 0 0 1 .75.75v2.189l2.72-2.719a.747.747 0 0 1 .53-.22h6.5a.25.25 0 0 0 .25-.25v-9.5a.25.25 0 0 0-.25-.25Zm20.5 6h-3.5a.75.75 0 0 1 0-1.5h3.5c.966 0 1.75.784 1.75 1.75v9.5A1.75 1.75 0 0 1 22.25 20H21v1.543a1.457 1.457 0 0 1-2.487 1.03L15.939 20H10.75A1.75 1.75 0 0 1 9 18.25v-1.465a.75.75 0 0 1 1.5 0v1.465c0 .138.112.25.25.25h5.5c.199 0 .39.079.53.22l2.72 2.719V19.25a.75.75 0 0 1 .75-.75h2a.25.25 0 0 0 .25-.25v-9.5a.25.25 0 0 0-.25-.25ZM11.28 5.53l-5 5a.749.749 0 1 1-1.06-1.06l5-5a.749.749 0 1 1 1.06 1.06Z"
      })
    }
  };
});
var DiscussionOutdatedIcon = /*#__PURE__*/createIconComponent("DiscussionOutdatedIcon", "octicon octicon-discussion-outdated", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.783.784 1 1.75 1h8.5c.967 0 1.75.783 1.75 1.75v5.5A1.75 1.75 0 0 1 10.25 10H7.061l-2.574 2.573A1.457 1.457 0 0 1 2 11.543V10h-.25A1.75 1.75 0 0 1 0 8.25Zm1.75-.25a.25.25 0 0 0-.25.25v5.5c0 .138.112.25.25.25h1a.75.75 0 0 1 .75.75v2.189L6.22 8.72a.747.747 0 0 1 .53-.22h3.5a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25Zm12.5 2h-.5a.75.75 0 0 1 0-1.5h.5c.967 0 1.75.783 1.75 1.75v5.5A1.75 1.75 0 0 1 14.25 12H14v1.543a1.457 1.457 0 0 1-2.487 1.03L9.22 12.28a.749.749 0 1 1 1.06-1.06l2.22 2.219V11.25a.75.75 0 0 1 .75-.75h1a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25ZM6.5 4v1.492l.466.187.036.015.812.375a.75.75 0 1 1-.628 1.362l-.795-.367-.92-.368A.75.75 0 0 1 5 6V4a.75.75 0 0 1 1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.783.784 1 1.75 1h12.5c.967 0 1.75.783 1.75 1.75v9.5A1.75 1.75 0 0 1 14.25 14H8.061l-2.574 2.573A1.457 1.457 0 0 1 3 15.543V14H1.75A1.75 1.75 0 0 1 0 12.25Zm1.75-.25a.25.25 0 0 0-.25.25v9.5c0 .138.112.25.25.25h2a.75.75 0 0 1 .75.75v2.189l2.72-2.719a.747.747 0 0 1 .53-.22h6.5a.25.25 0 0 0 .25-.25v-9.5a.25.25 0 0 0-.25-.25Zm20.5 6h-3.5a.75.75 0 0 1 0-1.5h3.5c.966 0 1.75.784 1.75 1.75v9.5A1.75 1.75 0 0 1 22.25 20H21v1.543a1.457 1.457 0 0 1-2.487 1.03L15.939 20H10.75A1.75 1.75 0 0 1 9 18.25v-1.465a.75.75 0 0 1 1.5 0v1.465c0 .138.112.25.25.25h5.5c.199 0 .39.079.53.22l2.72 2.719V19.25a.75.75 0 0 1 .75-.75h2a.25.25 0 0 0 .25-.25v-9.5a.25.25 0 0 0-.25-.25ZM8.5 4.75v3.14l1.15.488a.608.608 0 0 1 .037.017l1.393.681a.75.75 0 0 1-.66 1.348l-1.374-.673-1.589-.674A.751.751 0 0 1 7 8.386V4.75a.75.75 0 0 1 1.5 0Z"
      })
    }
  };
});
var DotIcon = /*#__PURE__*/createIconComponent("DotIcon", "octicon octicon-dot", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 8a4 4 0 1 1 8 0 4 4 0 0 1-8 0Zm4-2.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 18a6 6 0 1 1 0-12 6 6 0 0 1 0 12Zm0-1.5a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Z"
      })
    }
  };
});
var DotFillIcon = /*#__PURE__*/createIconComponent("DotFillIcon", "octicon octicon-dot-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 4a4 4 0 1 1 0 8 4 4 0 0 1 0-8Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 18a6 6 0 1 0 0-12 6 6 0 0 0 0 12Z"
      })
    }
  };
});
var DownloadIcon = /*#__PURE__*/createIconComponent("DownloadIcon", "octicon octicon-download", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 14A1.75 1.75 0 0 1 1 12.25v-2.5a.75.75 0 0 1 1.5 0v2.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25v-2.5a.75.75 0 0 1 1.5 0v2.5A1.75 1.75 0 0 1 13.25 14Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.25 7.689V2a.75.75 0 0 1 1.5 0v5.689l1.97-1.969a.749.749 0 1 1 1.06 1.06l-3.25 3.25a.749.749 0 0 1-1.06 0L4.22 6.78a.749.749 0 1 1 1.06-1.06l1.97 1.969Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 17.25a.75.75 0 0 1 .75.75v2.25c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V18a.75.75 0 0 1 1.5 0v2.25A1.75 1.75 0 0 1 18.25 22H5.75A1.75 1.75 0 0 1 4 20.25V18a.75.75 0 0 1 .75-.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.22 9.97a.749.749 0 0 1 1.06 0l4.97 4.969V2.75a.75.75 0 0 1 1.5 0v12.189l4.97-4.969a.749.749 0 1 1 1.06 1.06l-6.25 6.25a.749.749 0 0 1-1.06 0l-6.25-6.25a.749.749 0 0 1 0-1.06Z"
      }))
    }
  };
});
var DuplicateIcon = /*#__PURE__*/createIconComponent("DuplicateIcon", "octicon octicon-duplicate", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.5 3a.75.75 0 0 1 .75.75v1h1a.75.75 0 0 1 0 1.5h-1v1a.75.75 0 0 1-1.5 0v-1h-1a.75.75 0 0 1 0-1.5h1v-1A.75.75 0 0 1 10.5 3Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.75 0h7.5C15.216 0 16 .784 16 1.75v7.5A1.75 1.75 0 0 1 14.25 11h-7.5A1.75 1.75 0 0 1 5 9.25v-7.5C5 .784 5.784 0 6.75 0ZM6.5 1.75v7.5c0 .138.112.25.25.25h7.5a.25.25 0 0 0 .25-.25v-7.5a.25.25 0 0 0-.25-.25h-7.5a.25.25 0 0 0-.25.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 5A1.75 1.75 0 0 0 0 6.75v7.5C0 15.216.784 16 1.75 16h7.5A1.75 1.75 0 0 0 11 14.25v-1.5a.75.75 0 0 0-1.5 0v1.5a.25.25 0 0 1-.25.25h-7.5a.25.25 0 0 1-.25-.25v-7.5a.25.25 0 0 1 .25-.25h1.5a.75.75 0 0 0 0-1.5h-1.5Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.513 6a.75.75 0 0 1 .75.75v2h1.987a.75.75 0 0 1 0 1.5h-1.987v2a.75.75 0 1 1-1.5 0v-2H11.75a.75.75 0 0 1 0-1.5h2.013v-2a.75.75 0 0 1 .75-.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.024 3.75c0-.966.784-1.75 1.75-1.75H20.25c.966 0 1.75.784 1.75 1.75v11.498a1.75 1.75 0 0 1-1.75 1.75H8.774a1.75 1.75 0 0 1-1.75-1.75Zm1.75-.25a.25.25 0 0 0-.25.25v11.498c0 .139.112.25.25.25H20.25a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.995 10.749a1.75 1.75 0 0 1 1.75-1.751H5.25a.75.75 0 1 1 0 1.5H3.745a.25.25 0 0 0-.25.25L3.5 20.25c0 .138.111.25.25.25h9.5a.25.25 0 0 0 .25-.25v-1.51a.75.75 0 1 1 1.5 0v1.51A1.75 1.75 0 0 1 13.25 22h-9.5A1.75 1.75 0 0 1 2 20.25l-.005-9.501Z"
      }))
    }
  };
});
var EllipsisIcon = /*#__PURE__*/createIconComponent("EllipsisIcon", "octicon octicon-ellipsis", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 5.75C0 4.784.784 4 1.75 4h12.5c.966 0 1.75.784 1.75 1.75v4.5A1.75 1.75 0 0 1 14.25 12H1.75A1.75 1.75 0 0 1 0 10.25ZM12 7a1 1 0 1 0 0 2 1 1 0 0 0 0-2ZM7 8a1 1 0 1 0 2 0 1 1 0 0 0-2 0ZM4 7a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"
      })
    }
  };
});
var EyeIcon = /*#__PURE__*/createIconComponent("EyeIcon", "octicon octicon-eye", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 2c1.981 0 3.671.992 4.933 2.078 1.27 1.091 2.187 2.345 2.637 3.023a1.62 1.62 0 0 1 0 1.798c-.45.678-1.367 1.932-2.637 3.023C11.67 13.008 9.981 14 8 14c-1.981 0-3.671-.992-4.933-2.078C1.797 10.83.88 9.576.43 8.898a1.62 1.62 0 0 1 0-1.798c.45-.677 1.367-1.931 2.637-3.022C4.33 2.992 6.019 2 8 2ZM1.679 7.932a.12.12 0 0 0 0 .136c.411.622 1.241 1.75 2.366 2.717C5.176 11.758 6.527 12.5 8 12.5c1.473 0 2.825-.742 3.955-1.715 1.124-.967 1.954-2.096 2.366-2.717a.12.12 0 0 0 0-.136c-.412-.621-1.242-1.75-2.366-2.717C10.824 4.242 9.473 3.5 8 3.5c-1.473 0-2.825.742-3.955 1.715-1.124.967-1.954 2.096-2.366 2.717ZM8 10a2 2 0 1 1-.001-3.999A2 2 0 0 1 8 10Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.5 12a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 3.5c3.432 0 6.124 1.534 8.054 3.241 1.926 1.703 3.132 3.61 3.616 4.46a1.6 1.6 0 0 1 0 1.598c-.484.85-1.69 2.757-3.616 4.461-1.929 1.706-4.622 3.24-8.054 3.24-3.432 0-6.124-1.534-8.054-3.24C2.02 15.558.814 13.65.33 12.8a1.6 1.6 0 0 1 0-1.598c.484-.85 1.69-2.757 3.616-4.462C5.875 5.034 8.568 3.5 12 3.5ZM1.633 11.945a.115.115 0 0 0-.017.055c.001.02.006.039.017.056.441.774 1.551 2.527 3.307 4.08C6.691 17.685 9.045 19 12 19c2.955 0 5.31-1.315 7.06-2.864 1.756-1.553 2.866-3.306 3.307-4.08a.111.111 0 0 0 .017-.056.111.111 0 0 0-.017-.056c-.441-.773-1.551-2.527-3.307-4.08C17.309 6.315 14.955 5 12 5 9.045 5 6.69 6.314 4.94 7.865c-1.756 1.552-2.866 3.306-3.307 4.08Z"
      }))
    }
  };
});
var EyeClosedIcon = /*#__PURE__*/createIconComponent("EyeClosedIcon", "octicon octicon-eye-closed", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.143 2.31a.75.75 0 0 1 1.047-.167l14.5 10.5a.75.75 0 1 1-.88 1.214l-2.248-1.628C11.346 13.19 9.792 14 8 14c-1.981 0-3.67-.992-4.933-2.078C1.797 10.832.88 9.577.43 8.9a1.619 1.619 0 0 1 0-1.797c.353-.533.995-1.42 1.868-2.305L.31 3.357A.75.75 0 0 1 .143 2.31Zm1.536 5.622A.12.12 0 0 0 1.657 8c0 .021.006.045.022.068.412.621 1.242 1.75 2.366 2.717C5.175 11.758 6.527 12.5 8 12.5c1.195 0 2.31-.488 3.29-1.191L9.063 9.695A2 2 0 0 1 6.058 7.52L3.529 5.688a14.207 14.207 0 0 0-1.85 2.244ZM8 3.5c-.516 0-1.017.09-1.499.251a.75.75 0 1 1-.473-1.423A6.207 6.207 0 0 1 8 2c1.981 0 3.67.992 4.933 2.078 1.27 1.091 2.187 2.345 2.637 3.023a1.62 1.62 0 0 1 0 1.798c-.11.166-.248.365-.41.587a.75.75 0 1 1-1.21-.887c.148-.201.272-.382.371-.53a.119.119 0 0 0 0-.137c-.412-.621-1.242-1.75-2.366-2.717C10.825 4.242 9.473 3.5 8 3.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.052 5.837A9.715 9.715 0 0 1 12 5c2.955 0 5.309 1.315 7.06 2.864 1.756 1.553 2.866 3.307 3.307 4.08a.11.11 0 0 1 .016.055.122.122 0 0 1-.017.06 16.766 16.766 0 0 1-1.53 2.218.75.75 0 1 0 1.163.946 18.253 18.253 0 0 0 1.67-2.42 1.607 1.607 0 0 0 .001-1.602c-.485-.85-1.69-2.757-3.616-4.46C18.124 5.034 15.432 3.5 12 3.5c-1.695 0-3.215.374-4.552.963a.75.75 0 0 0 .604 1.373Zm11.114 12.15C17.328 19.38 14.933 20.5 12 20.5c-3.432 0-6.125-1.534-8.054-3.24C2.02 15.556.814 13.648.33 12.798a1.606 1.606 0 0 1 .001-1.6A18.283 18.283 0 0 1 3.648 7.01L1.317 5.362a.75.75 0 1 1 .866-1.224l20.5 14.5a.75.75 0 1 1-.866 1.224ZM4.902 7.898c-1.73 1.541-2.828 3.273-3.268 4.044a.112.112 0 0 0-.017.059c0 .015.003.034.016.055.441.774 1.551 2.527 3.307 4.08C6.69 17.685 9.045 19 12 19c2.334 0 4.29-.82 5.874-1.927l-3.516-2.487a3.5 3.5 0 0 1-5.583-3.949L4.902 7.899Z"
      })
    }
  };
});
var FeedDiscussionIcon = /*#__PURE__*/createIconComponent("FeedDiscussionIcon", "octicon octicon-feed-discussion", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16ZM4 5v5a1 1 0 0 0 1 1h1v1.5a.5.5 0 0 0 .854.354L8.707 11H11a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1Z"
      })
    }
  };
});
var FeedForkedIcon = /*#__PURE__*/createIconComponent("FeedForkedIcon", "octicon octicon-feed-forked", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16ZM6 6.928a1.75 1.75 0 1 0-1 0V7.5A1.5 1.5 0 0 0 6.5 9h1v1.072a1.75 1.75 0 1 0 1 0V9h1A1.5 1.5 0 0 0 11 7.5v-.572a1.75 1.75 0 1 0-1 0V7.5a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5Z"
      })
    }
  };
});
var FeedHeartIcon = /*#__PURE__*/createIconComponent("FeedHeartIcon", "octicon octicon-feed-heart", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16Zm2.33-11.5c-1.22 0-1.83.5-2.323 1.136C7.513 5 6.903 4.5 5.682 4.5c-1.028 0-2.169.784-2.169 2.5 0 1.499 1.493 3.433 3.246 4.517.52.321.89.479 1.248.484.357-.005.728-.163 1.247-.484C11.007 10.433 12.5 8.5 12.5 7c0-1.716-1.14-2.5-2.17-2.5Z"
      })
    }
  };
});
var FeedIssueClosedIcon = /*#__PURE__*/createIconComponent("FeedIssueClosedIcon", "octicon octicon-feed-issue-closed", function () {
  return {
    "16": {
      "width": 17,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.5 0a8 8 0 1 1 0 16 8 8 0 0 1 0-16Zm3.457 6.957a.999.999 0 1 0-1.414-1.414L7.75 8.336 6.457 7.043a.999.999 0 1 0-1.414 1.414l2 2a.999.999 0 0 0 1.414 0Z"
      })
    }
  };
});
var FeedIssueDraftIcon = /*#__PURE__*/createIconComponent("FeedIssueDraftIcon", "octicon octicon-feed-issue-draft", function () {
  return {
    "16": {
      "width": 17,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.5 0a8 8 0 1 1 0 16 8 8 0 0 1 0-16ZM4.302 7.334a.75.75 0 0 0-1.482-.233 5.8 5.8 0 0 0 0 1.798.749.749 0 1 0 1.482-.233 4.296 4.296 0 0 1 0-1.332ZM8.5 2.25a5.8 5.8 0 0 0-.899.07.749.749 0 1 0 .233 1.482 4.296 4.296 0 0 1 1.332 0 .75.75 0 0 0 .233-1.482 5.8 5.8 0 0 0-.899-.07Zm5.68 4.851a.749.749 0 1 0-1.482.233 4.296 4.296 0 0 1 0 1.332.75.75 0 0 0 1.482.233 5.8 5.8 0 0 0 0-1.798Zm-6.346 5.097a.75.75 0 0 0-.233 1.482 5.8 5.8 0 0 0 1.798 0 .749.749 0 1 0-.233-1.482 4.296 4.296 0 0 1-1.332 0ZM6.002 4.561a.75.75 0 0 0-.882-1.213A5.77 5.77 0 0 0 3.848 4.62a.749.749 0 1 0 1.213.882c.263-.361.58-.678.941-.941Zm-.941 5.937a.75.75 0 0 0-1.213.882 5.77 5.77 0 0 0 1.272 1.272.749.749 0 1 0 .882-1.213 4.285 4.285 0 0 1-.941-.941Zm6.819-7.15a.749.749 0 1 0-.882 1.213c.36.263.679.58.941.941a.75.75 0 0 0 1.213-.882 5.77 5.77 0 0 0-1.272-1.272Zm1.272 8.032a.749.749 0 1 0-1.213-.882c-.262.36-.581.679-.941.941a.75.75 0 0 0 .882 1.213 5.77 5.77 0 0 0 1.272-1.272Z"
      })
    }
  };
});
var FeedIssueOpenIcon = /*#__PURE__*/createIconComponent("FeedIssueOpenIcon", "octicon octicon-feed-issue-open", function () {
  return {
    "16": {
      "width": 17,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.5 8a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm3.427-4.323a.25.25 0 0 0-.427.177V6c0 .138.112.25.25.25h2.146a.25.25 0 0 0 .177-.427l-.524-.524a4.003 4.003 0 0 1 6.862 1.858.75.75 0 0 0 1.467-.314 5.502 5.502 0 0 0-9.39-2.605Zm9.573 8.469V10a.25.25 0 0 0-.25-.25h-2.146a.25.25 0 0 0-.177.427l.524.524a4.002 4.002 0 0 1-6.862-1.858.75.75 0 0 0-1.467.314 5.502 5.502 0 0 0 9.39 2.605l.561.561a.25.25 0 0 0 .427-.177ZM10 8a1.5 1.5 0 1 0-3.001.001A1.5 1.5 0 0 0 10 8Z"
      })
    }
  };
});
var FeedMergedIcon = /*#__PURE__*/createIconComponent("FeedMergedIcon", "octicon octicon-feed-merged", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16Zm.25-11.25A1.75 1.75 0 1 0 6 6.428v3.144a1.75 1.75 0 1 0 1 0V8.236A2.99 2.99 0 0 0 9 9h.571a1.75 1.75 0 1 0 0-1H9a2 2 0 0 1-1.957-1.586A1.75 1.75 0 0 0 8.25 4.75Z"
      })
    }
  };
});
var FeedPersonIcon = /*#__PURE__*/createIconComponent("FeedPersonIcon", "octicon octicon-feed-person", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16Zm.847-8.145a2.502 2.502 0 1 0-1.694 0C5.471 8.261 4 9.775 4 11c0 .395.145.995 1 .995h6c.855 0 1-.6 1-.995 0-1.224-1.47-2.74-3.153-3.145Z"
      })
    }
  };
});
var FeedPlusIcon = /*#__PURE__*/createIconComponent("FeedPlusIcon", "octicon octicon-feed-plus", function () {
  return {
    "16": {
      "width": 17,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.5 0a8 8 0 1 1 0 16 8 8 0 0 1 0-16Zm1.062 4.312a1 1 0 1 0-2 0v2.75h-2.75a1 1 0 0 0 0 2h2.75v2.75a1 1 0 1 0 2 0v-2.75h2.75a1 1 0 1 0 0-2h-2.75Z"
      })
    }
  };
});
var FeedPublicIcon = /*#__PURE__*/createIconComponent("FeedPublicIcon", "octicon octicon-feed-public", function () {
  return {
    "16": {
      "width": 17,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.5 8a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm4.5.25v3a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1H7.5v-1.5a1.5 1.5 0 0 1 2.443-1.167.749.749 0 1 0 .943-1.166A3 3 0 0 0 6 5.75v1.5a1 1 0 0 0-1 1Z"
      })
    }
  };
});
var FeedPullRequestClosedIcon = /*#__PURE__*/createIconComponent("FeedPullRequestClosedIcon", "octicon octicon-feed-pull-request-closed", function () {
  return {
    "16": {
      "width": 17,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.5 0a8 8 0 1 1 0 16 8 8 0 0 1 0-16ZM6 12.25a1.75 1.75 0 0 0 .5-3.428V6.928A1.752 1.752 0 0 0 6 3.5a1.75 1.75 0 0 0-.5 3.428v1.894A1.752 1.752 0 0 0 6 12.25Zm5-5a.5.5 0 0 0-.5.5v1.072a1.752 1.752 0 0 0 .5 3.428 1.75 1.75 0 0 0 .5-3.428V7.75a.5.5 0 0 0-.5-.5Zm1.255-2.763a.5.5 0 0 0-.707-.707l-.53.531-.531-.531a.5.5 0 0 0-.707.707l.531.531-.531.53a.5.5 0 0 0 .707.707l.531-.53.53.53a.5.5 0 0 0 .707-.707l-.53-.53Z"
      })
    }
  };
});
var FeedPullRequestDraftIcon = /*#__PURE__*/createIconComponent("FeedPullRequestDraftIcon", "octicon octicon-feed-pull-request-draft", function () {
  return {
    "16": {
      "width": 17,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.5 8a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm7.25 2.5c0-.793-.527-1.462-1.25-1.678V6.928A1.752 1.752 0 0 0 6 3.5a1.75 1.75 0 0 0-.5 3.428v1.894A1.752 1.752 0 0 0 6 12.25a1.75 1.75 0 0 0 1.75-1.75ZM11 12.25a1.75 1.75 0 1 0 .001-3.499A1.75 1.75 0 0 0 11 12.25Zm0-4.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75-3.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z"
      })
    }
  };
});
var FeedPullRequestOpenIcon = /*#__PURE__*/createIconComponent("FeedPullRequestOpenIcon", "octicon octicon-feed-pull-request-open", function () {
  return {
    "16": {
      "width": 17,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.5 8a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm6.75 2.5c0-.793-.527-1.462-1.25-1.678V6.928A1.752 1.752 0 0 0 5.5 3.5 1.75 1.75 0 0 0 5 6.928v1.894a1.752 1.752 0 0 0 .5 3.428 1.75 1.75 0 0 0 1.75-1.75Zm3.25-5h.25a.5.5 0 0 1 .5.5v2.822a1.752 1.752 0 0 0 .5 3.428 1.75 1.75 0 0 0 .5-3.428V6a1.5 1.5 0 0 0-1.5-1.5h-.25V3.129a.25.25 0 0 0-.427-.177L8.202 4.823a.25.25 0 0 0 0 .354l1.871 1.871a.25.25 0 0 0 .427-.177Z"
      })
    }
  };
});
var FeedRepoIcon = /*#__PURE__*/createIconComponent("FeedRepoIcon", "octicon octicon-feed-repo", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16ZM5.5 4A1.5 1.5 0 0 0 4 5.5v5c0 .828.5 1.5 1 1.5v-1a1 1 0 0 1 1-1h5v1h-1v1h1.5a.5.5 0 0 0 .5-.5v-7a.5.5 0 0 0-.5-.5Zm.5 7.25v2.514a.25.25 0 0 0 .426.178l.898-.888a.25.25 0 0 1 .352 0l.898.888A.25.25 0 0 0 9 13.764V11H6.25a.25.25 0 0 0-.25.25Z"
      })
    }
  };
});
var FeedRocketIcon = /*#__PURE__*/createIconComponent("FeedRocketIcon", "octicon octicon-feed-rocket", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16Zm3.031-12a4.38 4.38 0 0 0-3.097 1.283l-.23.229c-.156.157-.308.32-.452.49H5.65a.876.876 0 0 0-.746.417l-.856 1.388a.377.377 0 0 0 .21.556l1.552.477 1.35 1.35.478 1.553a.374.374 0 0 0 .555.21l1.389-.855a.876.876 0 0 0 .416-.746V8.747c.17-.144.333-.295.49-.452l.23-.23A4.379 4.379 0 0 0 12 4.969v-.093A.876.876 0 0 0 11.124 4Zm-5.107 7.144h-.001a.809.809 0 0 0-1.33-.881c-.395.394-.564 1.258-.62 1.62a.12.12 0 0 0 .035.108.12.12 0 0 0 .108.035c.362-.056 1.226-.225 1.62-.619a.803.803 0 0 0 .188-.263Z"
      })
    }
  };
});
var FeedStarIcon = /*#__PURE__*/createIconComponent("FeedStarIcon", "octicon octicon-feed-star", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16Zm.252-12.932a.476.476 0 0 0-.682.195l-1.2 2.432-2.684.39a.477.477 0 0 0-.266.816l1.944 1.892-.46 2.674a.479.479 0 0 0 .694.504L8 10.709l2.4 1.261a.478.478 0 0 0 .694-.504l-.458-2.673L12.578 6.9a.479.479 0 0 0-.265-.815l-2.685-.39-1.2-2.432a.473.473 0 0 0-.176-.195Z"
      })
    }
  };
});
var FeedTagIcon = /*#__PURE__*/createIconComponent("FeedTagIcon", "octicon octicon-feed-tag", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.22 6.5a.72.72 0 1 1-1.44 0 .72.72 0 0 1 1.44 0Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16ZM4 5v3.38c.001.397.159.778.44 1.059l3.211 3.213a1.202 1.202 0 0 0 1.698 0l3.303-3.303a1.202 1.202 0 0 0 0-1.698L9.439 4.44A1.5 1.5 0 0 0 8.379 4H5a1 1 0 0 0-1 1Z"
      }))
    }
  };
});
var FeedTrophyIcon = /*#__PURE__*/createIconComponent("FeedTrophyIcon", "octicon octicon-feed-trophy", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11 5h1v1.146a1 1 0 0 1-.629.928L11 7.223V5ZM5 7.223l-.371-.149A1 1 0 0 1 4 6.146V5h1v2.223Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16ZM3 5v1.146a2 2 0 0 0 1.257 1.858l.865.346a3.005 3.005 0 0 0 2.294 2.093C7.22 11.404 6.658 12 5.502 12H5.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1c-1.158 0-1.72-.595-1.916-1.557a3.005 3.005 0 0 0 2.294-2.094l.865-.346A2 2 0 0 0 13 6.146V5a1 1 0 0 0-1-1H4a1 1 0 0 0-1 1Z"
      }))
    }
  };
});
var FileIcon = /*#__PURE__*/createIconComponent("FileIcon", "octicon octicon-file", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 1.75C2 .784 2.784 0 3.75 0h6.586c.464 0 .909.184 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v9.586A1.75 1.75 0 0 1 13.25 16h-9.5A1.75 1.75 0 0 1 2 14.25Zm1.75-.25a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h9.5a.25.25 0 0 0 .25-.25V6h-2.75A1.75 1.75 0 0 1 9 4.25V1.5Zm6.75.062V4.25c0 .138.112.25.25.25h2.688l-.011-.013-2.914-2.914-.013-.011Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 3a2 2 0 0 1 2-2h9.982a2 2 0 0 1 1.414.586l4.018 4.018A2 2 0 0 1 21 7.018V21a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2Zm2-.5a.5.5 0 0 0-.5.5v18a.5.5 0 0 0 .5.5h14a.5.5 0 0 0 .5-.5V8.5h-4a2 2 0 0 1-2-2v-4Zm10 0v4a.5.5 0 0 0 .5.5h4a.5.5 0 0 0-.146-.336l-4.018-4.018A.5.5 0 0 0 15 2.5Z"
      })
    }
  };
});
var FileAddedIcon = /*#__PURE__*/createIconComponent("FileAddedIcon", "octicon octicon-file-added", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 1.75C2 .784 2.784 0 3.75 0h6.586c.464 0 .909.184 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v9.586A1.75 1.75 0 0 1 13.25 16h-9.5A1.75 1.75 0 0 1 2 14.25Zm1.75-.25a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h9.5a.25.25 0 0 0 .25-.25V4.664a.25.25 0 0 0-.073-.177l-2.914-2.914a.25.25 0 0 0-.177-.073Zm4.48 3.758a.75.75 0 0 1 .755.745l.01 1.497h1.497a.75.75 0 0 1 0 1.5H9v1.507a.75.75 0 0 1-1.5 0V9.005l-1.502.01a.75.75 0 0 1-.01-1.5l1.507-.01-.01-1.492a.75.75 0 0 1 .745-.755Z"
      })
    }
  };
});
var FileBadgeIcon = /*#__PURE__*/createIconComponent("FileBadgeIcon", "octicon octicon-file-badge", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 1.5a.25.25 0 0 0-.25.25v11.5c0 .138.112.25.25.25h3.5a.75.75 0 0 1 0 1.5h-3.5A1.75 1.75 0 0 1 1 13.25V1.75C1 .784 1.784 0 2.75 0h8a1.75 1.75 0 0 1 1.508.862.75.75 0 1 1-1.289.768.25.25 0 0 0-.219-.13h-8Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 7a3.999 3.999 0 0 1 7.605-1.733 4 4 0 0 1-1.115 4.863l.995 4.973a.75.75 0 0 1-.991.852l-2.409-.876a.248.248 0 0 0-.17 0l-2.409.876a.75.75 0 0 1-.991-.852l.994-4.973A3.994 3.994 0 0 1 8 7Zm4-2.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5Zm0 6.5c-.373 0-.745-.051-1.104-.154l-.649 3.243 1.155-.42c.386-.14.81-.14 1.196 0l1.155.42-.649-3.243A4.004 4.004 0 0 1 12 11Z"
      }))
    }
  };
});
var FileBinaryIcon = /*#__PURE__*/createIconComponent("FileBinaryIcon", "octicon octicon-file-binary", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 1.75C4 .784 4.784 0 5.75 0h5.586c.464 0 .909.184 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v8.586A1.75 1.75 0 0 1 14.25 15h-9a.75.75 0 0 1 0-1.5h9a.25.25 0 0 0 .25-.25V6h-2.75A1.75 1.75 0 0 1 10 4.25V1.5H5.75a.25.25 0 0 0-.25.25v2a.75.75 0 0 1-1.5 0Zm-4 6C0 6.784.784 6 1.75 6h1.5C4.216 6 5 6.784 5 7.75v2.5A1.75 1.75 0 0 1 3.25 12h-1.5A1.75 1.75 0 0 1 0 10.25ZM6.75 6h1.5a.75.75 0 0 1 .75.75v3.75h.75a.75.75 0 0 1 0 1.5h-3a.75.75 0 0 1 0-1.5h.75v-3h-.75a.75.75 0 0 1 0-1.5Zm-5 1.5a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25h1.5a.25.25 0 0 0 .25-.25v-2.5a.25.25 0 0 0-.25-.25Zm9.75-5.938V4.25c0 .138.112.25.25.25h2.688l-.011-.013-2.914-2.914-.013-.011Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 3a2 2 0 0 1 2-2h9.982a2 2 0 0 1 1.414.586l4.018 4.018A2 2 0 0 1 21 7.018V21a2 2 0 0 1-2 2H4.75a.75.75 0 0 1 0-1.5H19a.5.5 0 0 0 .5-.5V8.5h-4a2 2 0 0 1-2-2v-4H5a.5.5 0 0 0-.5.5v6.25a.75.75 0 0 1-1.5 0Zm12-.5v4a.5.5 0 0 0 .5.5h4a.5.5 0 0 0-.146-.336l-4.018-4.018A.5.5 0 0 0 15 2.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 13.75C0 12.784.784 12 1.75 12h3c.966 0 1.75.784 1.75 1.75v4a1.75 1.75 0 0 1-1.75 1.75h-3A1.75 1.75 0 0 1 0 17.75Zm1.75-.25a.25.25 0 0 0-.25.25v4c0 .138.112.25.25.25h3a.25.25 0 0 0 .25-.25v-4a.25.25 0 0 0-.25-.25ZM9 12a.75.75 0 0 0 0 1.5h1.5V18H9a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5H12v-5.25a.75.75 0 0 0-.75-.75H9Z"
      }))
    }
  };
});
var FileCodeIcon = /*#__PURE__*/createIconComponent("FileCodeIcon", "octicon octicon-file-code", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 1.75C4 .784 4.784 0 5.75 0h5.586c.464 0 .909.184 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v8.586A1.75 1.75 0 0 1 14.25 15h-9a.75.75 0 0 1 0-1.5h9a.25.25 0 0 0 .25-.25V6h-2.75A1.75 1.75 0 0 1 10 4.25V1.5H5.75a.25.25 0 0 0-.25.25v2.5a.75.75 0 0 1-1.5 0Zm1.72 4.97a.75.75 0 0 1 1.06 0l2 2a.75.75 0 0 1 0 1.06l-2 2a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l1.47-1.47-1.47-1.47a.75.75 0 0 1 0-1.06ZM3.28 7.78 1.81 9.25l1.47 1.47a.751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018l-2-2a.75.75 0 0 1 0-1.06l2-2a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042Zm8.22-6.218V4.25c0 .138.112.25.25.25h2.688l-.011-.013-2.914-2.914-.013-.011Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 3a2 2 0 0 1 2-2h9.982a2 2 0 0 1 1.414.586l4.018 4.018A2 2 0 0 1 21 7.018V21a2 2 0 0 1-2 2H4.75a.75.75 0 0 1 0-1.5H19a.5.5 0 0 0 .5-.5V8.5h-4a2 2 0 0 1-2-2v-4H5a.5.5 0 0 0-.5.5v6.25a.75.75 0 0 1-1.5 0Zm12-.5v4a.5.5 0 0 0 .5.5h4a.5.5 0 0 0-.146-.336l-4.018-4.018A.5.5 0 0 0 15 2.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.53 12.24a.75.75 0 0 1-.039 1.06l-2.639 2.45 2.64 2.45a.75.75 0 1 1-1.022 1.1l-3.23-3a.75.75 0 0 1 0-1.1l3.23-3a.75.75 0 0 1 1.06.04Zm3.979 1.06a.75.75 0 1 1 1.02-1.1l3.231 3a.75.75 0 0 1 0 1.1l-3.23 3a.75.75 0 1 1-1.021-1.1l2.639-2.45-2.64-2.45Z"
      }))
    }
  };
});
var FileDiffIcon = /*#__PURE__*/createIconComponent("FileDiffIcon", "octicon octicon-file-diff", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 1.75C1 .784 1.784 0 2.75 0h7.586c.464 0 .909.184 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v9.586A1.75 1.75 0 0 1 13.25 16H2.75A1.75 1.75 0 0 1 1 14.25Zm1.75-.25a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V4.664a.25.25 0 0 0-.073-.177l-2.914-2.914a.25.25 0 0 0-.177-.073ZM8 3.25a.75.75 0 0 1 .75.75v1.5h1.5a.75.75 0 0 1 0 1.5h-1.5v1.5a.75.75 0 0 1-1.5 0V7h-1.5a.75.75 0 0 1 0-1.5h1.5V4A.75.75 0 0 1 8 3.25Zm-3 8a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.5 6.75a.75.75 0 0 0-1.5 0V9H8.75a.75.75 0 0 0 0 1.5H11v2.25a.75.75 0 0 0 1.5 0V10.5h2.25a.75.75 0 0 0 0-1.5H12.5V6.75ZM8.75 16a.75.75 0 0 0 0 1.5h6a.75.75 0 0 0 0-1.5h-6Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 1h9.982a2 2 0 0 1 1.414.586l4.018 4.018A2 2 0 0 1 21 7.018V21a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2Zm-.5 2v18a.5.5 0 0 0 .5.5h14a.5.5 0 0 0 .5-.5V7.018a.5.5 0 0 0-.146-.354l-4.018-4.018a.5.5 0 0 0-.354-.146H5a.5.5 0 0 0-.5.5Z"
      }))
    }
  };
});
var FileDirectoryIcon = /*#__PURE__*/createIconComponent("FileDirectoryIcon", "octicon octicon-file-directory", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.784.784 1 1.75 1H5c.55 0 1.07.26 1.4.7l.9 1.2a.25.25 0 0 0 .2.1h6.75c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 15H1.75A1.75 1.75 0 0 1 0 13.25Zm1.75-.25a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25H7.5c-.55 0-1.07-.26-1.4-.7l-.9-1.2a.25.25 0 0 0-.2-.1Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 4.75C2 3.784 2.784 3 3.75 3h4.971c.58 0 1.12.286 1.447.765l1.404 2.063c.046.069.124.11.207.11h8.471c.966 0 1.75.783 1.75 1.75V19.25A1.75 1.75 0 0 1 20.25 21H3.75A1.75 1.75 0 0 1 2 19.25Zm1.75-.25a.25.25 0 0 0-.25.25v14.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25V7.687a.25.25 0 0 0-.25-.25h-8.471a1.75 1.75 0 0 1-1.447-.765L8.928 4.61a.252.252 0 0 0-.208-.11Z"
      })
    }
  };
});
var FileDirectoryFillIcon = /*#__PURE__*/createIconComponent("FileDirectoryFillIcon", "octicon octicon-file-directory-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 1A1.75 1.75 0 0 0 0 2.75v10.5C0 14.216.784 15 1.75 15h12.5A1.75 1.75 0 0 0 16 13.25v-8.5A1.75 1.75 0 0 0 14.25 3H7.5a.25.25 0 0 1-.2-.1l-.9-1.2C6.07 1.26 5.55 1 5 1H1.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 4.75C2 3.784 2.784 3 3.75 3h4.971c.58 0 1.12.286 1.447.765l1.404 2.063c.046.069.124.11.207.11h8.471c.966 0 1.75.783 1.75 1.75V19.25A1.75 1.75 0 0 1 20.25 21H3.75A1.75 1.75 0 0 1 2 19.25Z"
      })
    }
  };
});
var FileDirectoryOpenFillIcon = /*#__PURE__*/createIconComponent("FileDirectoryOpenFillIcon", "octicon octicon-file-directory-open-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.513 1.513A1.75 1.75 0 0 1 1.75 1h3.5c.55 0 1.07.26 1.4.7l.9 1.2a.25.25 0 0 0 .2.1H13a1 1 0 0 1 1 1v.5H2.75a.75.75 0 0 0 0 1.5h11.978a1 1 0 0 1 .994 1.117L15 13.25A1.75 1.75 0 0 1 13.25 15H1.75A1.75 1.75 0 0 1 0 13.25V2.75c0-.464.184-.91.513-1.237Z"
      })
    }
  };
});
var FileDirectorySymlinkIcon = /*#__PURE__*/createIconComponent("FileDirectorySymlinkIcon", "octicon octicon-file-directory-symlink", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.784.784 1 1.75 1H5a1.75 1.75 0 0 1 1.4.7l.9 1.2a.25.25 0 0 0 .2.1h6.75c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 15H5.375a.75.75 0 0 1 0-1.5h8.875a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25H7.5a1.75 1.75 0 0 1-1.4-.7l-.9-1.2a.25.25 0 0 0-.2-.1H1.75a.25.25 0 0 0-.25.25v3a.75.75 0 0 1-1.5 0v-3Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 12.237a2.25 2.25 0 0 1 2.262-2.249L4 9.989v1.938c0 .218.26.331.42.183l2.883-2.677a.25.25 0 0 0 0-.366L4.42 6.39a.25.25 0 0 0-.42.183v1.916l-.229-.001A3.75 3.75 0 0 0 0 12.237v1.013a.75.75 0 0 0 1.5 0v-1.013Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 4.75C2 3.784 2.784 3 3.75 3h4.971a1.75 1.75 0 0 1 1.447.765l1.404 2.063a.25.25 0 0 0 .207.11h8.471c.966 0 1.75.783 1.75 1.75V19.25A1.75 1.75 0 0 1 20.25 21H4.75a.75.75 0 0 1 0-1.5h15.5a.25.25 0 0 0 .25-.25V7.688a.25.25 0 0 0-.25-.25h-8.471a1.751 1.751 0 0 1-1.447-.766L8.928 4.609a.252.252 0 0 0-.207-.109H3.75a.25.25 0 0 0-.25.25v3.5a.75.75 0 0 1-1.5 0v-3.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m9.308 12.5-2.104-2.236a.75.75 0 1 1 1.092-1.028l3.294 3.5a.75.75 0 0 1 0 1.028l-3.294 3.5a.75.75 0 1 1-1.092-1.028L9.308 14H4.09a2.59 2.59 0 0 0-2.59 2.59v3.16a.75.75 0 0 1-1.5 0v-3.16a4.09 4.09 0 0 1 4.09-4.09h5.218Z"
      }))
    }
  };
});
var FileMediaIcon = /*#__PURE__*/createIconComponent("FileMediaIcon", "octicon octicon-file-media", function () {
  return {
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M21.75 21.5H2.25A1.75 1.75 0 0 1 .5 19.75V4.25c0-.966.784-1.75 1.75-1.75h19.5c.966 0 1.75.784 1.75 1.75v15.5a1.75 1.75 0 0 1-1.75 1.75ZM2.25 4a.25.25 0 0 0-.25.25v15.5c0 .138.112.25.25.25h3.178L14 10.977a1.749 1.749 0 0 1 2.506-.032L22 16.44V4.25a.25.25 0 0 0-.25-.25ZM22 19.75v-1.19l-6.555-6.554a.248.248 0 0 0-.18-.073.247.247 0 0 0-.178.077L7.497 20H21.75a.25.25 0 0 0 .25-.25ZM10.5 9.25a3.25 3.25 0 1 1-6.5 0 3.25 3.25 0 0 1 6.5 0Zm-1.5 0a1.75 1.75 0 1 0-3.501.001A1.75 1.75 0 0 0 9 9.25Z"
      })
    }
  };
});
var FileMovedIcon = /*#__PURE__*/createIconComponent("FileMovedIcon", "octicon octicon-file-moved", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 1.75C2 .784 2.784 0 3.75 0h6.586c.464 0 .909.184 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v9.586A1.75 1.75 0 0 1 13.25 16h-3.5a.75.75 0 0 1 0-1.5h3.5a.25.25 0 0 0 .25-.25V4.664a.25.25 0 0 0-.073-.177l-2.914-2.914a.25.25 0 0 0-.177-.073H3.75a.25.25 0 0 0-.25.25v6.5a.75.75 0 0 1-1.5 0v-6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m5.427 15.573 3.146-3.146a.25.25 0 0 0 0-.354L5.427 8.927A.25.25 0 0 0 5 9.104V11.5H.75a.75.75 0 0 0 0 1.5H5v2.396c0 .223.27.335.427.177Z"
      }))
    }
  };
});
var FileRemovedIcon = /*#__PURE__*/createIconComponent("FileRemovedIcon", "octicon octicon-file-removed", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 1.75C2 .784 2.784 0 3.75 0h6.586c.464 0 .909.184 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v9.586A1.75 1.75 0 0 1 13.25 16h-9.5A1.75 1.75 0 0 1 2 14.25Zm1.75-.25a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h9.5a.25.25 0 0 0 .25-.25V4.664a.25.25 0 0 0-.073-.177l-2.914-2.914a.25.25 0 0 0-.177-.073Zm4.5 6h2.242a.75.75 0 0 1 0 1.5h-2.24l-2.254.015a.75.75 0 0 1-.01-1.5Z"
      })
    }
  };
});
var FileSubmoduleIcon = /*#__PURE__*/createIconComponent("FileSubmoduleIcon", "octicon octicon-file-submodule", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75C0 1.784.784 1 1.75 1H5c.55 0 1.07.26 1.4.7l.9 1.2a.25.25 0 0 0 .2.1h6.75c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 15H1.75A1.75 1.75 0 0 1 0 13.25Zm9.42 9.36 2.883-2.677a.25.25 0 0 0 0-.366L9.42 6.39a.249.249 0 0 0-.42.183V8.5H4.75a.75.75 0 0 0 0 1.5H9v1.927c0 .218.26.331.42.183Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 4.75C2 3.784 2.784 3 3.75 3h4.965a1.75 1.75 0 0 1 1.456.78l1.406 2.109a.25.25 0 0 0 .208.111h8.465c.966 0 1.75.784 1.75 1.75v11.5A1.75 1.75 0 0 1 20.25 21H3.75A1.75 1.75 0 0 1 2 19.25Zm12.78 4.97a.749.749 0 0 0-1.275.326.749.749 0 0 0 .215.734l1.72 1.72H6.75a.75.75 0 0 0 0 1.5h8.69l-1.72 1.72a.749.749 0 0 0 .326 1.275.749.749 0 0 0 .734-.215l3-3a.75.75 0 0 0 0-1.06Z"
      })
    }
  };
});
var FileSymlinkFileIcon = /*#__PURE__*/createIconComponent("FileSymlinkFileIcon", "octicon octicon-file-symlink-file", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 1.75C2 .784 2.784 0 3.75 0h5.586c.464 0 .909.184 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v8.586A1.75 1.75 0 0 1 12.25 15h-7a.75.75 0 0 1 0-1.5h7a.25.25 0 0 0 .25-.25V6H9.75A1.75 1.75 0 0 1 8 4.25V1.5H3.75a.25.25 0 0 0-.25.25V4.5a.75.75 0 0 1-1.5 0Zm-.5 10.487v1.013a.75.75 0 0 1-1.5 0v-1.012a3.748 3.748 0 0 1 3.77-3.749L4 8.49V6.573a.25.25 0 0 1 .42-.183l2.883 2.678a.25.25 0 0 1 0 .366L4.42 12.111a.25.25 0 0 1-.42-.183V9.99l-.238-.003a2.25 2.25 0 0 0-2.262 2.25Zm8-10.675V4.25c0 .138.112.25.25.25h2.688l-.011-.013-2.914-2.914-.013-.011Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 3a2 2 0 0 1 2-2h9.982a2 2 0 0 1 1.414.586l4.018 4.018A2 2 0 0 1 21 7.018V21a2 2 0 0 1-2 2H4.75a.75.75 0 0 1 0-1.5H19a.5.5 0 0 0 .5-.5V8.5h-4a2 2 0 0 1-2-2v-4H5a.5.5 0 0 0-.5.5v6.25a.75.75 0 0 1-1.5 0Zm6.308 11.5-2.104-2.236a.751.751 0 0 1 .369-1.255.749.749 0 0 1 .723.227l3.294 3.5a.75.75 0 0 1 0 1.028l-3.294 3.5a.749.749 0 0 1-1.275-.293.751.751 0 0 1 .183-.735L9.308 16H4.09a2.59 2.59 0 0 0-2.59 2.59v3.16a.75.75 0 0 1-1.5 0v-3.16a4.09 4.09 0 0 1 4.09-4.09ZM15 2.5v4a.5.5 0 0 0 .5.5h4a.5.5 0 0 0-.146-.336l-4.018-4.018A.5.5 0 0 0 15 2.5Z"
      })
    }
  };
});
var FileZipIcon = /*#__PURE__*/createIconComponent("FileZipIcon", "octicon octicon-file-zip", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.5 1.75v11.5c0 .09.048.173.126.217a.75.75 0 0 1-.752 1.298A1.748 1.748 0 0 1 2 13.25V1.75C2 .784 2.784 0 3.75 0h5.586c.464 0 .909.185 1.237.513l2.914 2.914c.329.328.513.773.513 1.237v8.586A1.75 1.75 0 0 1 12.25 15h-.5a.75.75 0 0 1 0-1.5h.5a.25.25 0 0 0 .25-.25V4.664a.25.25 0 0 0-.073-.177L9.513 1.573a.25.25 0 0 0-.177-.073H7.25a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1 0-1.5h-3a.25.25 0 0 0-.25.25Zm3.75 8.75h.5c.966 0 1.75.784 1.75 1.75v3a.75.75 0 0 1-.75.75h-2.5a.75.75 0 0 1-.75-.75v-3c0-.966.784-1.75 1.75-1.75ZM6 5.25a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 6 5.25Zm.75 2.25h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1 0-1.5ZM8 6.75A.75.75 0 0 1 8.75 6h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 8 6.75ZM8.75 3h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1 0-1.5ZM8 9.75A.75.75 0 0 1 8.75 9h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 8 9.75Zm-1 2.5v2.25h1v-2.25a.25.25 0 0 0-.25-.25h-.5a.25.25 0 0 0-.25.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 2.5a.5.5 0 0 0-.5.5v18a.5.5 0 0 0 .5.5h1.75a.75.75 0 0 1 0 1.5H5a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h9.982a2 2 0 0 1 1.414.586l4.018 4.018A2 2 0 0 1 21 7.018V21a2 2 0 0 1-2 2h-2.75a.75.75 0 0 1 0-1.5H19a.5.5 0 0 0 .5-.5V7.018a.5.5 0 0 0-.146-.354l-4.018-4.018a.5.5 0 0 0-.354-.146H5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.5 15.75a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm.75-3.75a.75.75 0 0 0 0 1.5h1a.75.75 0 0 0 0-1.5h-1Zm-.75-2.25a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75ZM12.25 6a.75.75 0 0 0 0 1.5h1a.75.75 0 0 0 0-1.5h-1Zm-.75-2.25a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75ZM9.75 13.5a.75.75 0 0 0 0 1.5h1a.75.75 0 0 0 0-1.5h-1ZM9 11.25a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm.75-3.75a.75.75 0 0 0 0 1.5h1a.75.75 0 0 0 0-1.5h-1ZM9 5.25a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1A.75.75 0 0 1 9 5.25ZM11 17h1a2 2 0 0 1 2 2v4.25a.75.75 0 0 1-.75.75h-3.5a.75.75 0 0 1-.75-.75V19a2 2 0 0 1 2-2Zm-.5 2v3.5h2V19a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5Z"
      }))
    }
  };
});
var FilterIcon = /*#__PURE__*/createIconComponent("FilterIcon", "octicon octicon-filter", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.75 3h14.5a.75.75 0 0 1 0 1.5H.75a.75.75 0 0 1 0-1.5ZM3 7.75A.75.75 0 0 1 3.75 7h8.5a.75.75 0 0 1 0 1.5h-8.5A.75.75 0 0 1 3 7.75Zm3 4a.75.75 0 0 1 .75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.75.75 0 0 1-.75-.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 6a.75.75 0 0 0 0 1.5h18.5a.75.75 0 0 0 0-1.5H2.75ZM6 11.75a.75.75 0 0 1 .75-.75h10.5a.75.75 0 0 1 0 1.5H6.75a.75.75 0 0 1-.75-.75Zm4 4.938a.75.75 0 0 1 .75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var FiscalHostIcon = /*#__PURE__*/createIconComponent("FiscalHostIcon", "octicon octicon-fiscal-host", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10 8a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 9.25h-.75a.75.75 0 0 1 0-1.5H4v-1.5h-.75a.75.75 0 0 1 0-1.5H4V3.5a1 1 0 0 1 1-1h7.5a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1ZM5.5 4v.793a.75.75 0 0 1 0 1.414v1.586a.75.75 0 0 1 0 1.414V10H12V4Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.75 14.25V14h-9.5v.25a.75.75 0 0 1-1.5 0V14A1.75 1.75 0 0 1 0 12.25V1.75C0 .784.784 0 1.75 0h12.5C15.217 0 16 .784 16 1.75v10.5A1.75 1.75 0 0 1 14.25 14v.25a.75.75 0 0 1-1.5 0ZM1.75 1.5a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25Z"
      }))
    }
  };
});
var FlameIcon = /*#__PURE__*/createIconComponent("FlameIcon", "octicon octicon-flame", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.533.753V.752c.217 2.385 1.463 3.626 2.653 4.81C13.37 6.74 14.498 7.863 14.498 10c0 3.5-3 6-6.5 6S1.5 13.512 1.5 10c0-1.298.536-2.56 1.425-3.286.376-.308.862 0 1.035.454C4.46 8.487 5.581 8.419 6 8c.282-.282.341-.811-.003-1.5C4.34 3.187 7.035.75 8.77.146c.39-.137.726.194.763.607ZM7.998 14.5c2.832 0 5-1.98 5-4.5 0-1.463-.68-2.19-1.879-3.383l-.036-.037c-1.013-1.008-2.3-2.29-2.834-4.434-.322.256-.63.579-.864.953-.432.696-.621 1.58-.046 2.73.473.947.67 2.284-.278 3.232-.61.61-1.545.84-2.403.633a2.79 2.79 0 0 1-1.436-.874A3.198 3.198 0 0 0 3 10c0 2.53 2.164 4.5 4.998 4.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.265 1.627c0 3.545 1.869 5.327 3.479 7.021 1.54 1.62 3.006 3.163 3.006 6.102 0 4.812-3.753 8.25-8.565 8.25-4.813 0-8.935-3.421-8.935-8.25 0-2.039.962-4.011 2.509-4.899.305-.175.672.007.803.334C7.563 12.684 8.797 12.64 9.437 12c.388-.387.47-1.116-.004-2.062-2.405-4.812 1.863-8.279 4.2-8.854.336-.082.615.198.632.543ZM12.185 21.5c4.059 0 7.065-2.84 7.065-6.75 0-2.337-1.093-3.489-2.678-5.158l-.021-.023c-1.44-1.517-3.139-3.351-3.649-6.557a6.148 6.148 0 0 0-1.911 1.76c-.787 1.144-1.147 2.633-.216 4.495.603 1.205.777 2.74-.277 3.794-.657.657-1.762 1.1-2.956.586-.752-.324-1.353-.955-1.838-1.79-.567.706-.954 1.74-.954 2.893 0 3.847 3.288 6.75 7.435 6.75Z"
      })
    }
  };
});
var FoldIcon = /*#__PURE__*/createIconComponent("FoldIcon", "octicon octicon-fold", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.896 2H8.75V.75a.75.75 0 0 0-1.5 0V2H5.104a.25.25 0 0 0-.177.427l2.896 2.896a.25.25 0 0 0 .354 0l2.896-2.896A.25.25 0 0 0 10.896 2ZM8.75 15.25a.75.75 0 0 1-1.5 0V14H5.104a.25.25 0 0 1-.177-.427l2.896-2.896a.25.25 0 0 1 .354 0l2.896 2.896a.25.25 0 0 1-.177.427H8.75v1.25Zm-6.5-6.5a.75.75 0 0 0 0-1.5h-.5a.75.75 0 0 0 0 1.5h.5ZM6 8a.75.75 0 0 1-.75.75h-.5a.75.75 0 0 1 0-1.5h.5A.75.75 0 0 1 6 8Zm2.25.75a.75.75 0 0 0 0-1.5h-.5a.75.75 0 0 0 0 1.5h.5ZM12 8a.75.75 0 0 1-.75.75h-.5a.75.75 0 0 1 0-1.5h.5A.75.75 0 0 1 12 8Zm2.25.75a.75.75 0 0 0 0-1.5h-.5a.75.75 0 0 0 0 1.5h.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 15c.199 0 .389.079.53.22l3.25 3.25a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L12 16.81l-2.72 2.72a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042l3.25-3.25A.749.749 0 0 1 12 15Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.53 8.78a.75.75 0 0 1-1.06 0L8.22 5.53a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018L12 7.19l2.72-2.72a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734ZM12 15.75a.75.75 0 0 1 .75.75v5.75a.75.75 0 0 1-1.5 0V16.5a.75.75 0 0 1 .75-.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 8.5a.75.75 0 0 1-.75-.75v-6a.75.75 0 0 1 1.5 0v6a.75.75 0 0 1-.75.75ZM2.75 12a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Z"
      }))
    }
  };
});
var FoldDownIcon = /*#__PURE__*/createIconComponent("FoldDownIcon", "octicon octicon-fold-down", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m8.177 14.323 2.896-2.896a.25.25 0 0 0-.177-.427H8.75V7.764a.75.75 0 1 0-1.5 0V11H5.104a.25.25 0 0 0-.177.427l2.896 2.896a.25.25 0 0 0 .354 0ZM2.25 5a.75.75 0 0 0 0-1.5h-.5a.75.75 0 0 0 0 1.5h.5ZM6 4.25a.75.75 0 0 1-.75.75h-.5a.75.75 0 0 1 0-1.5h.5a.75.75 0 0 1 .75.75ZM8.25 5a.75.75 0 0 0 0-1.5h-.5a.75.75 0 0 0 0 1.5h.5ZM12 4.25a.75.75 0 0 1-.75.75h-.5a.75.75 0 0 1 0-1.5h.5a.75.75 0 0 1 .75.75Zm2.25.75a.75.75 0 0 0 0-1.5h-.5a.75.75 0 0 0 0 1.5h.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 19a.749.749 0 0 1-.53-.22l-3.25-3.25a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215L12 17.19l2.72-2.72a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734l-3.25 3.25A.749.749 0 0 1 12 19Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 18a.75.75 0 0 1-.75-.75v-7.5a.75.75 0 0 1 1.5 0v7.5A.75.75 0 0 1 12 18ZM2.75 6a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1A.75.75 0 0 1 2.75 6Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1A.75.75 0 0 1 6.75 6Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Z"
      }))
    }
  };
});
var FoldUpIcon = /*#__PURE__*/createIconComponent("FoldUpIcon", "octicon octicon-fold-up", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.823 1.677 4.927 4.573A.25.25 0 0 0 5.104 5H7.25v3.236a.75.75 0 1 0 1.5 0V5h2.146a.25.25 0 0 0 .177-.427L8.177 1.677a.25.25 0 0 0-.354 0ZM13.75 11a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5Zm-3.75.75a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1-.75-.75ZM7.75 11a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5ZM4 11.75a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1-.75-.75ZM1.75 11a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.47 5.22a.75.75 0 0 1 1.06 0l3.25 3.25a.751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018L12 6.81 9.28 9.53a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 5.5a.75.75 0 0 1 .75.75v8a.75.75 0 0 1-1.5 0v-8A.75.75 0 0 1 12 5.5ZM2.75 18a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm4 0a.75.75 0 0 1 .75-.75h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Z"
      }))
    }
  };
});
var GearIcon = /*#__PURE__*/createIconComponent("GearIcon", "octicon octicon-gear", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8.2 8.2 0 0 1 .701.031C9.444.095 9.99.645 10.16 1.29l.288 1.107c.018.066.079.158.212.224.231.114.454.243.668.386.123.082.233.09.299.071l1.103-.303c.644-.176 1.392.021 1.82.63.27.385.506.792.704 1.218.315.675.111 1.422-.364 1.891l-.814.806c-.049.048-.098.147-.088.294.016.257.016.515 0 .772-.01.147.038.246.088.294l.814.806c.475.469.679 1.216.364 1.891a7.977 7.977 0 0 1-.704 1.217c-.428.61-1.176.807-1.82.63l-1.102-.302c-.067-.019-.177-.011-.3.071a5.909 5.909 0 0 1-.668.386c-.133.066-.194.158-.211.224l-.29 1.106c-.168.646-.715 1.196-1.458 1.26a8.006 8.006 0 0 1-1.402 0c-.743-.064-1.289-.614-1.458-1.26l-.289-1.106c-.018-.066-.079-.158-.212-.224a5.738 5.738 0 0 1-.668-.386c-.123-.082-.233-.09-.299-.071l-1.103.303c-.644.176-1.392-.021-1.82-.63a8.12 8.12 0 0 1-.704-1.218c-.315-.675-.111-1.422.363-1.891l.815-.806c.05-.048.098-.147.088-.294a6.214 6.214 0 0 1 0-.772c.01-.147-.038-.246-.088-.294l-.815-.806C.635 6.045.431 5.298.746 4.623a7.92 7.92 0 0 1 .704-1.217c.428-.61 1.176-.807 1.82-.63l1.102.302c.067.019.177.011.3-.071.214-.143.437-.272.668-.386.133-.066.194-.158.211-.224l.29-1.106C6.009.645 6.556.095 7.299.03 7.53.01 7.764 0 8 0Zm-.571 1.525c-.036.003-.108.036-.137.146l-.289 1.105c-.147.561-.549.967-.998 1.189-.173.086-.34.183-.5.29-.417.278-.97.423-1.529.27l-1.103-.303c-.109-.03-.175.016-.195.045-.22.312-.412.644-.573.99-.014.031-.021.11.059.19l.815.806c.411.406.562.957.53 1.456a4.709 4.709 0 0 0 0 .582c.032.499-.119 1.05-.53 1.456l-.815.806c-.081.08-.073.159-.059.19.162.346.353.677.573.989.02.03.085.076.195.046l1.102-.303c.56-.153 1.113-.008 1.53.27.161.107.328.204.501.29.447.222.85.629.997 1.189l.289 1.105c.029.109.101.143.137.146a6.6 6.6 0 0 0 1.142 0c.036-.003.108-.036.137-.146l.289-1.105c.147-.561.549-.967.998-1.189.173-.086.34-.183.5-.29.417-.278.97-.423 1.529-.27l1.103.303c.109.029.175-.016.195-.045.22-.313.411-.644.573-.99.014-.031.021-.11-.059-.19l-.815-.806c-.411-.406-.562-.957-.53-1.456a4.709 4.709 0 0 0 0-.582c-.032-.499.119-1.05.53-1.456l.815-.806c.081-.08.073-.159.059-.19a6.464 6.464 0 0 0-.573-.989c-.02-.03-.085-.076-.195-.046l-1.102.303c-.56.153-1.113.008-1.53-.27a4.44 4.44 0 0 0-.501-.29c-.447-.222-.85-.629-.997-1.189l-.289-1.105c-.029-.11-.101-.143-.137-.146a6.6 6.6 0 0 0-1.142 0ZM11 8a3 3 0 1 1-6 0 3 3 0 0 1 6 0ZM9.5 8a1.5 1.5 0 1 0-3.001.001A1.5 1.5 0 0 0 9.5 8Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16 12a4 4 0 1 1-8 0 4 4 0 0 1 8 0Zm-1.5 0a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c.266 0 .532.009.797.028.763.055 1.345.617 1.512 1.304l.352 1.45c.019.078.09.171.225.221.247.089.49.19.728.302.13.061.246.044.315.002l1.275-.776c.603-.368 1.411-.353 1.99.147.402.349.78.726 1.128 1.129.501.578.515 1.386.147 1.99l-.776 1.274c-.042.069-.058.185.002.315.112.238.213.481.303.728.048.135.142.205.22.225l1.45.352c.687.167 1.249.749 1.303 1.512.038.531.038 1.063 0 1.594-.054.763-.616 1.345-1.303 1.512l-1.45.352c-.078.019-.171.09-.221.225-.089.248-.19.491-.302.728-.061.13-.044.246-.002.315l.776 1.275c.368.603.353 1.411-.147 1.99-.349.402-.726.78-1.129 1.128-.578.501-1.386.515-1.99.147l-1.274-.776c-.069-.042-.185-.058-.314.002a8.606 8.606 0 0 1-.729.303c-.135.048-.205.142-.225.22l-.352 1.45c-.167.687-.749 1.249-1.512 1.303-.531.038-1.063.038-1.594 0-.763-.054-1.345-.616-1.512-1.303l-.352-1.45c-.019-.078-.09-.171-.225-.221a8.138 8.138 0 0 1-.728-.302c-.13-.061-.246-.044-.315-.002l-1.275.776c-.603.368-1.411.353-1.99-.147-.402-.349-.78-.726-1.128-1.129-.501-.578-.515-1.386-.147-1.99l.776-1.274c.042-.069.058-.185-.002-.314a8.606 8.606 0 0 1-.303-.729c-.048-.135-.142-.205-.22-.225l-1.45-.352c-.687-.167-1.249-.749-1.304-1.512a11.158 11.158 0 0 1 0-1.594c.055-.763.617-1.345 1.304-1.512l1.45-.352c.078-.019.171-.09.221-.225.089-.248.19-.491.302-.728.061-.13.044-.246.002-.315l-.776-1.275c-.368-.603-.353-1.411.147-1.99.349-.402.726-.78 1.129-1.128.578-.501 1.386-.515 1.99-.147l1.274.776c.069.042.185.058.315-.002.238-.112.481-.213.728-.303.135-.048.205-.142.225-.22l.352-1.45c.167-.687.749-1.249 1.512-1.304C11.466 1.01 11.732 1 12 1Zm-.69 1.525c-.055.004-.135.05-.161.161l-.353 1.45a1.832 1.832 0 0 1-1.172 1.277 7.147 7.147 0 0 0-.6.249 1.833 1.833 0 0 1-1.734-.074l-1.274-.776c-.098-.06-.186-.036-.228 0a9.774 9.774 0 0 0-.976.976c-.036.042-.06.131 0 .228l.776 1.274c.314.529.342 1.18.074 1.734a7.147 7.147 0 0 0-.249.6 1.831 1.831 0 0 1-1.278 1.173l-1.45.351c-.11.027-.156.107-.16.162a9.63 9.63 0 0 0 0 1.38c.004.055.05.135.161.161l1.45.353a1.832 1.832 0 0 1 1.277 1.172c.074.204.157.404.249.6.268.553.24 1.204-.074 1.733l-.776 1.275c-.06.098-.036.186 0 .228.301.348.628.675.976.976.042.036.131.06.228 0l1.274-.776a1.83 1.83 0 0 1 1.734-.075c.196.093.396.176.6.25a1.831 1.831 0 0 1 1.173 1.278l.351 1.45c.027.11.107.156.162.16a9.63 9.63 0 0 0 1.38 0c.055-.004.135-.05.161-.161l.353-1.45a1.834 1.834 0 0 1 1.172-1.278 6.82 6.82 0 0 0 .6-.248 1.831 1.831 0 0 1 1.733.074l1.275.776c.098.06.186.036.228 0 .348-.301.675-.628.976-.976.036-.042.06-.131 0-.228l-.776-1.275a1.834 1.834 0 0 1-.075-1.733c.093-.196.176-.396.25-.6a1.831 1.831 0 0 1 1.278-1.173l1.45-.351c.11-.027.156-.107.16-.162a9.63 9.63 0 0 0 0-1.38c-.004-.055-.05-.135-.161-.161l-1.45-.353c-.626-.152-1.08-.625-1.278-1.172a6.576 6.576 0 0 0-.248-.6 1.833 1.833 0 0 1 .074-1.734l.776-1.274c.06-.098.036-.186 0-.228a9.774 9.774 0 0 0-.976-.976c-.042-.036-.131-.06-.228 0l-1.275.776a1.831 1.831 0 0 1-1.733.074 6.88 6.88 0 0 0-.6-.249 1.835 1.835 0 0 1-1.173-1.278l-.351-1.45c-.027-.11-.107-.156-.162-.16a9.63 9.63 0 0 0-1.38 0Z"
      }))
    }
  };
});
var GiftIcon = /*#__PURE__*/createIconComponent("GiftIcon", "octicon octicon-gift", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 2.75A2.75 2.75 0 0 1 4.75 0c.983 0 1.873.42 2.57 1.232.268.318.497.668.68 1.042.183-.375.411-.725.68-1.044C9.376.42 10.266 0 11.25 0a2.75 2.75 0 0 1 2.45 4h.55c.966 0 1.75.784 1.75 1.75v2c0 .698-.409 1.301-1 1.582v4.918A1.75 1.75 0 0 1 13.25 16H2.75A1.75 1.75 0 0 1 1 14.25V9.332C.409 9.05 0 8.448 0 7.75v-2C0 4.784.784 4 1.75 4h.55c-.192-.375-.3-.8-.3-1.25ZM7.25 9.5H2.5v4.75c0 .138.112.25.25.25h4.5Zm1.5 0v5h4.5a.25.25 0 0 0 .25-.25V9.5Zm0-4V8h5.5a.25.25 0 0 0 .25-.25v-2a.25.25 0 0 0-.25-.25Zm-7 0a.25.25 0 0 0-.25.25v2c0 .138.112.25.25.25h5.5V5.5h-5.5Zm3-4a1.25 1.25 0 0 0 0 2.5h2.309c-.233-.818-.542-1.401-.878-1.793-.43-.502-.915-.707-1.431-.707ZM8.941 4h2.309a1.25 1.25 0 0 0 0-2.5c-.516 0-1 .205-1.43.707-.337.392-.646.975-.879 1.793Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 3.75A3.75 3.75 0 0 1 7.5 0c1.455 0 3.436.901 4.5 3.11C13.064.901 15.044 0 16.5 0a3.75 3.75 0 0 1 3 6h1.75c.966 0 1.75.784 1.75 1.75v2.5c0 .698-.409 1.301-1 1.582v8.418A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25v-8.418c-.591-.282-1-.884-1-1.582v-2.5C1 6.784 1.784 6 2.75 6H4.5a3.733 3.733 0 0 1-.75-2.25ZM20.5 12h-7.75v8.5h7.5a.25.25 0 0 0 .25-.25Zm-9.25 8.5V12H3.5v8.25c0 .138.112.25.25.25Zm10-10a.25.25 0 0 0 .25-.25v-2.5a.25.25 0 0 0-.25-.25h-8.5v3Zm-18.5 0h8.5v-3h-8.5a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25Zm16-6.75A2.25 2.25 0 0 0 16.5 1.5c-1.15 0-3.433 1.007-3.72 4.5h3.72a2.25 2.25 0 0 0 2.25-2.25ZM11.22 6c-.287-3.493-2.57-4.5-3.72-4.5a2.25 2.25 0 1 0 0 4.5Z"
      })
    }
  };
});
var GitBranchIcon = /*#__PURE__*/createIconComponent("GitBranchIcon", "octicon octicon-git-branch", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.5 3.25a2.25 2.25 0 1 1 3 2.122V6A2.5 2.5 0 0 1 10 8.5H6a1 1 0 0 0-1 1v1.128a2.251 2.251 0 1 1-1.5 0V5.372a2.25 2.25 0 1 1 1.5 0v1.836A2.493 2.493 0 0 1 6 7h4a1 1 0 0 0 1-1v-.628A2.25 2.25 0 0 1 9.5 3.25Zm-6 0a.75.75 0 1 0 1.5 0 .75.75 0 0 0-1.5 0Zm8.25-.75a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5ZM4.25 12a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15 4.75a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0ZM2.5 19.25a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0Zm0-14.5a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0ZM5.75 6.5a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 5.75 6.5Zm0 14.5a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 5.75 21Zm12.5-14.5a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 18.25 6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 16.75A.75.75 0 0 1 5 16V8a.75.75 0 0 1 1.5 0v8a.75.75 0 0 1-.75.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M17.5 8.75v-1H19v1a3.75 3.75 0 0 1-3.75 3.75h-7a1.75 1.75 0 0 0-1.75 1.75H5A3.25 3.25 0 0 1 8.25 11h7a2.25 2.25 0 0 0 2.25-2.25Z"
      }))
    }
  };
});
var GitCommitIcon = /*#__PURE__*/createIconComponent("GitCommitIcon", "octicon octicon-git-commit", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.93 8.5a4.002 4.002 0 0 1-7.86 0H.75a.75.75 0 0 1 0-1.5h3.32a4.002 4.002 0 0 1 7.86 0h3.32a.75.75 0 0 1 0 1.5Zm-1.43-.75a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16.944 11h4.306a.75.75 0 0 1 0 1.5h-4.306a5.001 5.001 0 0 1-9.888 0H2.75a.75.75 0 0 1 0-1.5h4.306a5.001 5.001 0 0 1 9.888 0Zm-1.444.75a3.5 3.5 0 1 0-7 0 3.5 3.5 0 0 0 7 0Z"
      })
    }
  };
});
var GitCompareIcon = /*#__PURE__*/createIconComponent("GitCompareIcon", "octicon octicon-git-compare", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.573.677A.25.25 0 0 1 10 .854V2.5h1A2.5 2.5 0 0 1 13.5 5v5.628a2.251 2.251 0 1 1-1.5 0V5a1 1 0 0 0-1-1h-1v1.646a.25.25 0 0 1-.427.177L7.177 3.427a.25.25 0 0 1 0-.354ZM6 12v-1.646a.25.25 0 0 1 .427-.177l2.396 2.396a.25.25 0 0 1 0 .354l-2.396 2.396A.25.25 0 0 1 6 15.146V13.5H5A2.5 2.5 0 0 1 2.5 11V5.372a2.25 2.25 0 1 1 1.5 0V11a1 1 0 0 0 1 1ZM4 3.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM12.75 12a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16.5 19.25a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0Zm3.25-1.75a1.75 1.75 0 1 0 .001 3.501 1.75 1.75 0 0 0-.001-3.501Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.905 1.72a.75.75 0 0 1 0 1.06L12.685 4h4.065a3.75 3.75 0 0 1 3.75 3.75v8.75a.75.75 0 0 1-1.5 0V7.75a2.25 2.25 0 0 0-2.25-2.25h-4.064l1.22 1.22a.75.75 0 0 1-1.061 1.06l-2.5-2.5a.75.75 0 0 1 0-1.06l2.5-2.5a.75.75 0 0 1 1.06 0ZM7.5 4.75a3.25 3.25 0 1 1-6.5 0 3.25 3.25 0 0 1 6.5 0ZM4.25 6.5a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 4.25 6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.095 22.28a.75.75 0 0 1 0-1.06l1.22-1.22H7.25a3.75 3.75 0 0 1-3.75-3.75V7.5a.75.75 0 0 1 1.5 0v8.75a2.25 2.25 0 0 0 2.25 2.25h4.064l-1.22-1.22a.748.748 0 0 1 .332-1.265.75.75 0 0 1 .729.205l2.5 2.5a.75.75 0 0 1 0 1.06l-2.5 2.5a.75.75 0 0 1-1.06 0Z"
      }))
    }
  };
});
var GitMergeIcon = /*#__PURE__*/createIconComponent("GitMergeIcon", "octicon octicon-git-merge", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.45 5.154A4.25 4.25 0 0 0 9.25 7.5h1.378a2.251 2.251 0 1 1 0 1.5H9.25A5.734 5.734 0 0 1 5 7.123v3.505a2.25 2.25 0 1 1-1.5 0V5.372a2.25 2.25 0 1 1 1.95-.218ZM4.25 13.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm8.5-4.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM5 3.25a.75.75 0 1 0 0 .005V3.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15 13.25a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0Zm-12.5 6a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0Zm0-14.5a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0ZM5.75 6.5a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 5.75 6.5Zm0 14.5a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 5.75 21Zm12.5-6a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 18.25 15Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.5 7.25c0 2.9 2.35 5.25 5.25 5.25h4.5V14h-4.5A6.75 6.75 0 0 1 5 7.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 16.75A.75.75 0 0 1 5 16V8a.75.75 0 0 1 1.5 0v8a.75.75 0 0 1-.75.75Z"
      }))
    }
  };
});
var GitMergeQueueIcon = /*#__PURE__*/createIconComponent("GitMergeQueueIcon", "octicon octicon-git-merge-queue", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 4.5a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5ZM3 7.75a.75.75 0 0 1 1.5 0v2.878a2.251 2.251 0 1 1-1.5 0Zm.75 5.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm5-7.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0Zm5.75 2.5a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0Zm-1.5 0a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 6.5a1.75 1.75 0 1 1 .001-3.501A1.75 1.75 0 0 1 5.75 6.5ZM9.5 8.75a1.75 1.75 0 1 1 3.501.001A1.75 1.75 0 0 1 9.5 8.75ZM5.75 22.5a3.25 3.25 0 0 1-.745-6.414A.81.81 0 0 1 5 16v-5a.75.75 0 0 1 1.5 0v5a.81.81 0 0 1-.005.086A3.252 3.252 0 0 1 5.75 22.5ZM4 19.25a1.75 1.75 0 1 0 3.501-.001A1.75 1.75 0 0 0 4 19.25Zm11-6.5a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0Zm3.25 1.75a1.75 1.75 0 1 0 0-3.5 1.75 1.75 0 0 0 0 3.5Z"
      })
    }
  };
});
var GitPullRequestIcon = /*#__PURE__*/createIconComponent("GitPullRequestIcon", "octicon octicon-git-pull-request", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 3.25a2.25 2.25 0 1 1 3 2.122v5.256a2.251 2.251 0 1 1-1.5 0V5.372A2.25 2.25 0 0 1 1.5 3.25Zm5.677-.177L9.573.677A.25.25 0 0 1 10 .854V2.5h1A2.5 2.5 0 0 1 13.5 5v5.628a2.251 2.251 0 1 1-1.5 0V5a1 1 0 0 0-1-1h-1v1.646a.25.25 0 0 1-.427.177L7.177 3.427a.25.25 0 0 1 0-.354ZM3.75 2.5a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Zm0 9.5a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Zm8.25.75a.75.75 0 1 0 1.5 0 .75.75 0 0 0-1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16 19.25a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0Zm-14.5 0a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0Zm0-14.5a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0ZM4.75 3a1.75 1.75 0 1 0 .001 3.501A1.75 1.75 0 0 0 4.75 3Zm0 14.5a1.75 1.75 0 1 0 .001 3.501A1.75 1.75 0 0 0 4.75 17.5Zm14.5 0a1.75 1.75 0 1 0 .001 3.501 1.75 1.75 0 0 0-.001-3.501Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.405 1.72a.75.75 0 0 1 0 1.06L12.185 4h4.065A3.75 3.75 0 0 1 20 7.75v8.75a.75.75 0 0 1-1.5 0V7.75a2.25 2.25 0 0 0-2.25-2.25h-4.064l1.22 1.22a.75.75 0 0 1-1.061 1.06l-2.5-2.5a.75.75 0 0 1 0-1.06l2.5-2.5a.75.75 0 0 1 1.06 0ZM4.75 7.25A.75.75 0 0 1 5.5 8v8A.75.75 0 0 1 4 16V8a.75.75 0 0 1 .75-.75Z"
      }))
    }
  };
});
var GitPullRequestClosedIcon = /*#__PURE__*/createIconComponent("GitPullRequestClosedIcon", "octicon octicon-git-pull-request-closed", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.25 1A2.25 2.25 0 0 1 4 5.372v5.256a2.251 2.251 0 1 1-1.5 0V5.372A2.251 2.251 0 0 1 3.25 1Zm9.5 5.5a.75.75 0 0 1 .75.75v3.378a2.251 2.251 0 1 1-1.5 0V7.25a.75.75 0 0 1 .75-.75Zm-2.03-5.273a.75.75 0 0 1 1.06 0l.97.97.97-.97a.748.748 0 0 1 1.265.332.75.75 0 0 1-.205.729l-.97.97.97.97a.751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018l-.97-.97-.97.97a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l.97-.97-.97-.97a.75.75 0 0 1 0-1.06ZM2.5 3.25a.75.75 0 1 0 1.5 0 .75.75 0 0 0-1.5 0ZM3.25 12a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Zm9.5 0a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M22.266 2.711a.75.75 0 1 0-1.061-1.06l-1.983 1.983-1.984-1.983a.75.75 0 1 0-1.06 1.06l1.983 1.983-1.983 1.984a.75.75 0 0 0 1.06 1.06l1.984-1.983 1.983 1.983a.75.75 0 0 0 1.06-1.06l-1.983-1.984 1.984-1.983ZM4.75 1.5a3.25 3.25 0 0 1 .745 6.414A.827.827 0 0 1 5.5 8v8a.827.827 0 0 1-.005.086A3.25 3.25 0 0 1 4.75 22.5a3.25 3.25 0 0 1-.745-6.414A.827.827 0 0 1 4 16V8c0-.029.002-.057.005-.086A3.25 3.25 0 0 1 4.75 1.5ZM16 19.25a3.252 3.252 0 0 1 2.5-3.163V9.625a.75.75 0 0 1 1.5 0v6.462a3.252 3.252 0 0 1-.75 6.413A3.25 3.25 0 0 1 16 19.25ZM3 4.75a1.75 1.75 0 1 0 3.501-.001A1.75 1.75 0 0 0 3 4.75Zm0 14.5a1.75 1.75 0 1 0 3.501-.001A1.75 1.75 0 0 0 3 19.25Zm16.25-1.75a1.75 1.75 0 1 0 .001 3.501 1.75 1.75 0 0 0-.001-3.501Z"
      })
    }
  };
});
var GitPullRequestDraftIcon = /*#__PURE__*/createIconComponent("GitPullRequestDraftIcon", "octicon octicon-git-pull-request-draft", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.25 1A2.25 2.25 0 0 1 4 5.372v5.256a2.251 2.251 0 1 1-1.5 0V5.372A2.251 2.251 0 0 1 3.25 1Zm9.5 14a2.25 2.25 0 1 1 0-4.5 2.25 2.25 0 0 1 0 4.5ZM2.5 3.25a.75.75 0 1 0 1.5 0 .75.75 0 0 0-1.5 0ZM3.25 12a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Zm9.5 0a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5ZM14 7.5a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0Zm0-4.25a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 1.5a3.25 3.25 0 0 1 .745 6.414A.827.827 0 0 1 5.5 8v8a.827.827 0 0 1-.005.086A3.25 3.25 0 0 1 4.75 22.5a3.25 3.25 0 0 1-.745-6.414A.827.827 0 0 1 4 16V8c0-.029.002-.057.005-.086A3.25 3.25 0 0 1 4.75 1.5ZM16 19.25a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0ZM3 4.75a1.75 1.75 0 1 0 3.501-.001A1.75 1.75 0 0 0 3 4.75Zm0 14.5a1.75 1.75 0 1 0 3.501-.001A1.75 1.75 0 0 0 3 19.25Zm16.25-1.75a1.75 1.75 0 1 0 .001 3.501 1.75 1.75 0 0 0-.001-3.501Zm0-11.5a1.75 1.75 0 1 0 0-3.5 1.75 1.75 0 0 0 0 3.5ZM21 11.25a1.75 1.75 0 1 1-3.5 0 1.75 1.75 0 0 1 3.5 0Z"
      })
    }
  };
});
var GlobeIcon = /*#__PURE__*/createIconComponent("GlobeIcon", "octicon octicon-globe", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0ZM5.78 8.75a9.64 9.64 0 0 0 1.363 4.177c.255.426.542.832.857 1.215.245-.296.551-.705.857-1.215A9.64 9.64 0 0 0 10.22 8.75Zm4.44-1.5a9.64 9.64 0 0 0-1.363-4.177c-.307-.51-.612-.919-.857-1.215a9.927 9.927 0 0 0-.857 1.215A9.64 9.64 0 0 0 5.78 7.25Zm-5.944 1.5H1.543a6.507 6.507 0 0 0 4.666 5.5c-.123-.181-.24-.365-.352-.552-.715-1.192-1.437-2.874-1.581-4.948Zm-2.733-1.5h2.733c.144-2.074.866-3.756 1.58-4.948.12-.197.237-.381.353-.552a6.507 6.507 0 0 0-4.666 5.5Zm10.181 1.5c-.144 2.074-.866 3.756-1.58 4.948-.12.197-.237.381-.353.552a6.507 6.507 0 0 0 4.666-5.5Zm2.733-1.5a6.507 6.507 0 0 0-4.666-5.5c.123.181.24.365.353.552.714 1.192 1.436 2.874 1.58 4.948Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1Zm3.241 10.5v-.001c-.1-2.708-.992-4.904-1.89-6.452a13.919 13.919 0 0 0-1.304-1.88L12 3.11l-.047.059c-.354.425-.828 1.06-1.304 1.88-.898 1.547-1.79 3.743-1.89 6.451Zm-12.728 0h4.745c.1-3.037 1.1-5.49 2.093-7.204.39-.672.78-1.233 1.119-1.673C6.11 3.329 2.746 7 2.513 11.5Zm18.974 0C21.254 7 17.89 3.329 13.53 2.623c.339.44.729 1.001 1.119 1.673.993 1.714 1.993 4.167 2.093 7.204ZM8.787 13c.182 2.478 1.02 4.5 1.862 5.953.382.661.818 1.29 1.304 1.88l.047.057.047-.059c.354-.425.828-1.06 1.304-1.88.842-1.451 1.679-3.471 1.862-5.951Zm-1.504 0H2.552a9.505 9.505 0 0 0 7.918 8.377 15.773 15.773 0 0 1-1.119-1.673C8.413 18.085 7.47 15.807 7.283 13Zm9.434 0c-.186 2.807-1.13 5.085-2.068 6.704-.39.672-.78 1.233-1.118 1.673A9.506 9.506 0 0 0 21.447 13Z"
      })
    }
  };
});
var GoalIcon = /*#__PURE__*/createIconComponent("GoalIcon", "octicon octicon-goal", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.637 2.363h-.001l1.676.335c.09.018.164.084.19.173a.25.25 0 0 1-.062.249l-1.373 1.374a.876.876 0 0 1-.619.256H12.31L9.45 7.611A1.5 1.5 0 1 1 6.5 8a1.501 1.501 0 0 1 1.889-1.449l2.861-2.862V2.552c0-.232.092-.455.256-.619L12.88.559a.25.25 0 0 1 .249-.062c.089.026.155.1.173.19Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 8a6 6 0 1 0 11.769-1.656.751.751 0 1 1 1.442-.413 7.502 7.502 0 0 1-12.513 7.371A7.501 7.501 0 0 1 10.069.789a.75.75 0 0 1-.413 1.442A6.001 6.001 0 0 0 2 8Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 8a3.002 3.002 0 0 0 4.699 2.476 3 3 0 0 0 1.28-2.827.748.748 0 0 1 1.045-.782.75.75 0 0 1 .445.61A4.5 4.5 0 1 1 8.516 3.53a.75.75 0 1 1-.17 1.49A3 3 0 0 0 5 8Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M20.172 6.75h-1.861l-4.566 4.564a1.874 1.874 0 1 1-1.06-1.06l4.565-4.565V3.828a.94.94 0 0 1 .275-.664l1.73-1.73a.249.249 0 0 1 .25-.063c.089.026.155.1.173.191l.46 2.301 2.3.46c.09.018.164.084.19.173a.25.25 0 0 1-.062.249l-1.731 1.73a.937.937 0 0 1-.663.275Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.625 12A9.375 9.375 0 0 0 12 21.375 9.375 9.375 0 0 0 21.375 12c0-.898-.126-1.766-.361-2.587A.75.75 0 0 1 22.455 9c.274.954.42 1.96.42 3 0 6.006-4.869 10.875-10.875 10.875S1.125 18.006 1.125 12 5.994 1.125 12 1.125c1.015-.001 2.024.14 3 .419a.75.75 0 1 1-.413 1.442A9.39 9.39 0 0 0 12 2.625 9.375 9.375 0 0 0 2.625 12Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.125 12a4.874 4.874 0 1 0 9.717-.569.748.748 0 0 1 1.047-.798c.251.112.42.351.442.625a6.373 6.373 0 0 1-10.836 5.253 6.376 6.376 0 0 1 5.236-10.844.75.75 0 1 1-.17 1.49A4.876 4.876 0 0 0 7.125 12Z"
      }))
    }
  };
});
var GrabberIcon = /*#__PURE__*/createIconComponent("GrabberIcon", "octicon octicon-grabber", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10 13a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm0-4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-4 4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm5-9a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM7 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM6 5a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9 13a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm7-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM9 8a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm7-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM9 18a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm6 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    }
  };
});
var GraphIcon = /*#__PURE__*/createIconComponent("GraphIcon", "octicon octicon-graph", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 1.75V13.5h13.75a.75.75 0 0 1 0 1.5H.75a.75.75 0 0 1-.75-.75V1.75a.75.75 0 0 1 1.5 0Zm14.28 2.53-5.25 5.25a.75.75 0 0 1-1.06 0L7 7.06 4.28 9.78a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042l3.25-3.25a.75.75 0 0 1 1.06 0L10 7.94l4.72-4.72a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.5 2.75a.75.75 0 0 0-1.5 0v18.5c0 .414.336.75.75.75H20a.75.75 0 0 0 0-1.5H2.5V2.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M22.28 7.78a.75.75 0 0 0-1.06-1.06l-5.72 5.72-3.72-3.72a.75.75 0 0 0-1.06 0l-6 6a.75.75 0 1 0 1.06 1.06l5.47-5.47 3.72 3.72a.75.75 0 0 0 1.06 0l6.25-6.25Z"
      }))
    }
  };
});
var HashIcon = /*#__PURE__*/createIconComponent("HashIcon", "octicon octicon-hash", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.368 1.01a.75.75 0 0 1 .623.859L6.57 4.5h3.98l.46-2.868a.75.75 0 0 1 1.48.237L12.07 4.5h2.18a.75.75 0 0 1 0 1.5h-2.42l-.64 4h2.56a.75.75 0 0 1 0 1.5h-2.8l-.46 2.869a.75.75 0 0 1-1.48-.237l.42-2.632H5.45l-.46 2.869a.75.75 0 0 1-1.48-.237l.42-2.632H1.75a.75.75 0 0 1 0-1.5h2.42l.64-4H2.25a.75.75 0 0 1 0-1.5h2.8l.46-2.868a.75.75 0 0 1 .858-.622ZM9.67 10l.64-4H6.33l-.64 4Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.618 1.76a.75.75 0 0 1 .623.859L9.46 7.5h6.48l.82-5.118a.75.75 0 0 1 1.48.237L17.46 7.5h3.79a.75.75 0 0 1 0 1.5h-4.03l-.96 6h3.99a.75.75 0 0 1 0 1.5h-4.23l-.78 4.869a.75.75 0 0 1-1.48-.237l.74-4.632H8.02l-.78 4.869a.75.75 0 0 1-1.48-.237L6.5 16.5H2.745a.75.75 0 0 1 0-1.5H6.74l.96-6H3.75a.75.75 0 0 1 0-1.5h4.19l.82-5.118a.75.75 0 0 1 .858-.622ZM14.741 15l.96-6H9.22l-.96 6Z"
      })
    }
  };
});
var HeadingIcon = /*#__PURE__*/createIconComponent("HeadingIcon", "octicon octicon-heading", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 2a.75.75 0 0 1 .75.75V7h7V2.75a.75.75 0 0 1 1.5 0v10.5a.75.75 0 0 1-1.5 0V8.5h-7v4.75a.75.75 0 0 1-1.5 0V2.75A.75.75 0 0 1 3.75 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.25 4a.75.75 0 0 1 .75.75V11h10V4.75a.75.75 0 0 1 1.5 0v14.5a.75.75 0 0 1-1.5 0V12.5H7v6.75a.75.75 0 0 1-1.5 0V4.75A.75.75 0 0 1 6.25 4Z"
      })
    }
  };
});
var HeartIcon = /*#__PURE__*/createIconComponent("HeartIcon", "octicon octicon-heart", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m8 14.25.345.666a.75.75 0 0 1-.69 0l-.008-.004-.018-.01a7.152 7.152 0 0 1-.31-.17 22.055 22.055 0 0 1-3.434-2.414C2.045 10.731 0 8.35 0 5.5 0 2.836 2.086 1 4.25 1 5.797 1 7.153 1.802 8 3.02 8.847 1.802 10.203 1 11.75 1 13.914 1 16 2.836 16 5.5c0 2.85-2.045 5.231-3.885 6.818a22.066 22.066 0 0 1-3.744 2.584l-.018.01-.006.003h-.002ZM4.25 2.5c-1.336 0-2.75 1.164-2.75 3 0 2.15 1.58 4.144 3.365 5.682A20.58 20.58 0 0 0 8 13.393a20.58 20.58 0 0 0 3.135-2.211C12.92 9.644 14.5 7.65 14.5 5.5c0-1.836-1.414-3-2.75-3-1.373 0-2.609.986-3.029 2.456a.749.749 0 0 1-1.442 0C6.859 3.486 5.623 2.5 4.25 2.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m12 20.703.343.667a.748.748 0 0 1-.686 0l-.003-.002-.007-.003-.025-.013a31.138 31.138 0 0 1-5.233-3.576C3.8 15.573 1 12.332 1 8.514v-.001C1 5.053 3.829 2.5 6.736 2.5 9.03 2.5 10.881 3.726 12 5.605 13.12 3.726 14.97 2.5 17.264 2.5 20.17 2.5 23 5.052 23 8.514c0 3.818-2.801 7.06-5.389 9.262a31.148 31.148 0 0 1-5.233 3.576l-.025.013-.007.003-.002.001ZM6.736 4C4.657 4 2.5 5.88 2.5 8.514c0 3.107 2.324 5.96 4.861 8.12a29.655 29.655 0 0 0 4.566 3.175l.073.041.073-.04c.271-.153.661-.38 1.13-.674.94-.588 2.19-1.441 3.436-2.502 2.537-2.16 4.861-5.013 4.861-8.12C21.5 5.88 19.343 4 17.264 4c-2.106 0-3.801 1.389-4.553 3.643a.751.751 0 0 1-1.422 0C10.537 5.389 8.841 4 6.736 4Z"
      })
    }
  };
});
var HeartFillIcon = /*#__PURE__*/createIconComponent("HeartFillIcon", "octicon octicon-heart-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.655 14.916v-.001h-.002l-.006-.003-.018-.01a22.066 22.066 0 0 1-3.744-2.584C2.045 10.731 0 8.35 0 5.5 0 2.836 2.086 1 4.25 1 5.797 1 7.153 1.802 8 3.02 8.847 1.802 10.203 1 11.75 1 13.914 1 16 2.836 16 5.5c0 2.85-2.044 5.231-3.886 6.818a22.094 22.094 0 0 1-3.433 2.414 7.152 7.152 0 0 1-.31.17l-.018.01-.008.004a.75.75 0 0 1-.69 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14 20.408c-.492.308-.903.546-1.192.709-.153.086-.308.17-.463.252h-.002a.75.75 0 0 1-.686 0 16.709 16.709 0 0 1-.465-.252 31.147 31.147 0 0 1-4.803-3.34C3.8 15.572 1 12.331 1 8.513 1 5.052 3.829 2.5 6.736 2.5 9.03 2.5 10.881 3.726 12 5.605 13.12 3.726 14.97 2.5 17.264 2.5 20.17 2.5 23 5.052 23 8.514c0 3.818-2.801 7.06-5.389 9.262A31.146 31.146 0 0 1 14 20.408Z"
      })
    }
  };
});
var HistoryIcon = /*#__PURE__*/createIconComponent("HistoryIcon", "octicon octicon-history", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m.427 1.927 1.215 1.215a8.002 8.002 0 1 1-1.6 5.685.75.75 0 1 1 1.493-.154 6.5 6.5 0 1 0 1.18-4.458l1.358 1.358A.25.25 0 0 1 3.896 6H.25A.25.25 0 0 1 0 5.75V2.104a.25.25 0 0 1 .427-.177ZM7.75 4a.75.75 0 0 1 .75.75v2.992l2.028.812a.75.75 0 0 1-.557 1.392l-2.5-1A.751.751 0 0 1 7 8.25v-3.5A.75.75 0 0 1 7.75 4Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.998 2.5A9.503 9.503 0 0 0 3.378 8H5.75a.75.75 0 0 1 0 1.5H2a1 1 0 0 1-1-1V4.75a.75.75 0 0 1 1.5 0v1.697A10.997 10.997 0 0 1 11.998 1C18.074 1 23 5.925 23 12s-4.926 11-11.002 11C6.014 23 1.146 18.223 1 12.275a.75.75 0 0 1 1.5-.037 9.5 9.5 0 0 0 9.498 9.262c5.248 0 9.502-4.253 9.502-9.5s-4.254-9.5-9.502-9.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.5 7.25a.75.75 0 0 0-1.5 0v5.5c0 .27.144.518.378.651l3.5 2a.75.75 0 0 0 .744-1.302L12.5 12.315V7.25Z"
      }))
    }
  };
});
var HomeIcon = /*#__PURE__*/createIconComponent("HomeIcon", "octicon octicon-home", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.906.664a1.749 1.749 0 0 1 2.187 0l5.25 4.2c.415.332.657.835.657 1.367v7.019A1.75 1.75 0 0 1 13.25 15h-3.5a.75.75 0 0 1-.75-.75V9H7v5.25a.75.75 0 0 1-.75.75h-3.5A1.75 1.75 0 0 1 1 13.25V6.23c0-.531.242-1.034.657-1.366l5.25-4.2Zm1.25 1.171a.25.25 0 0 0-.312 0l-5.25 4.2a.25.25 0 0 0-.094.196v7.019c0 .138.112.25.25.25H5.5V8.25a.75.75 0 0 1 .75-.75h3.5a.75.75 0 0 1 .75.75v5.25h2.75a.25.25 0 0 0 .25-.25V6.23a.25.25 0 0 0-.094-.195Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.03 2.59a1.501 1.501 0 0 1 1.94 0l7.5 6.363a1.5 1.5 0 0 1 .53 1.144V19.5a1.5 1.5 0 0 1-1.5 1.5h-5.75a.75.75 0 0 1-.75-.75V14h-2v6.25a.75.75 0 0 1-.75.75H4.5A1.5 1.5 0 0 1 3 19.5v-9.403c0-.44.194-.859.53-1.144ZM12 3.734l-7.5 6.363V19.5h5v-6.25a.75.75 0 0 1 .75-.75h3.5a.75.75 0 0 1 .75.75v6.25h5v-9.403Z"
      })
    }
  };
});
var HomeFillIcon = /*#__PURE__*/createIconComponent("HomeFillIcon", "octicon octicon-home-fill", function () {
  return {
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.97 2.59a1.5 1.5 0 0 0-1.94 0l-7.5 6.363A1.5 1.5 0 0 0 3 10.097V19.5A1.5 1.5 0 0 0 4.5 21h4.75a.75.75 0 0 0 .75-.75V14h4v6.25c0 .414.336.75.75.75h4.75a1.5 1.5 0 0 0 1.5-1.5v-9.403a1.5 1.5 0 0 0-.53-1.144l-7.5-6.363Z"
      })
    }
  };
});
var HorizontalRuleIcon = /*#__PURE__*/createIconComponent("HorizontalRuleIcon", "octicon octicon-horizontal-rule", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 7.75A.75.75 0 0 1 .75 7h14.5a.75.75 0 0 1 0 1.5H.75A.75.75 0 0 1 0 7.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 12.75a.75.75 0 0 1 .75-.75h18.5a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var HourglassIcon = /*#__PURE__*/createIconComponent("HourglassIcon", "octicon octicon-hourglass", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.75 1h10.5a.75.75 0 0 1 0 1.5h-.75v1.25a4.75 4.75 0 0 1-1.9 3.8l-.333.25a.25.25 0 0 0 0 .4l.333.25a4.75 4.75 0 0 1 1.9 3.8v1.25h.75a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1 0-1.5h.75v-1.25a4.75 4.75 0 0 1 1.9-3.8l.333-.25a.25.25 0 0 0 0-.4L5.4 7.55a4.75 4.75 0 0 1-1.9-3.8V2.5h-.75a.75.75 0 0 1 0-1.5ZM11 2.5H5v1.25c0 1.023.482 1.986 1.3 2.6l.333.25c.934.7.934 2.1 0 2.8l-.333.25a3.251 3.251 0 0 0-1.3 2.6v1.25h6v-1.25a3.251 3.251 0 0 0-1.3-2.6l-.333-.25a1.748 1.748 0 0 1 0-2.8l.333-.25a3.251 3.251 0 0 0 1.3-2.6Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 2h14.5a.75.75 0 0 1 0 1.5h-.75v2.982a4.75 4.75 0 0 1-2.215 4.017l-2.044 1.29a.25.25 0 0 0 0 .422l2.044 1.29a4.75 4.75 0 0 1 2.215 4.017V20.5h.75a.75.75 0 0 1 0 1.5H4.75a.75.75 0 0 1 0-1.5h.75v-2.982a4.75 4.75 0 0 1 2.215-4.017l2.044-1.29a.25.25 0 0 0 0-.422l-2.044-1.29A4.75 4.75 0 0 1 5.5 6.482V3.5h-.75a.75.75 0 0 1 0-1.5ZM17 3.5H7v2.982A3.25 3.25 0 0 0 8.516 9.23l2.044 1.29a1.75 1.75 0 0 1 0 2.96l-2.044 1.29A3.25 3.25 0 0 0 7 17.518V20.5h10v-2.982a3.25 3.25 0 0 0-1.516-2.748l-2.044-1.29a1.75 1.75 0 0 1 0-2.96l2.044-1.29A3.25 3.25 0 0 0 17 6.482Z"
      })
    }
  };
});
var HubotIcon = /*#__PURE__*/createIconComponent("HubotIcon", "octicon octicon-hubot", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 8a8 8 0 0 1 16 0v5.25a.75.75 0 0 1-1.5 0V8a6.5 6.5 0 1 0-13 0v5.25a.75.75 0 0 1-1.5 0Zm3-1.25C3 5.784 3.784 5 4.75 5h6.5c.966 0 1.75.784 1.75 1.75v1.5A1.75 1.75 0 0 1 11.25 10h-6.5A1.75 1.75 0 0 1 3 8.25Zm1.47-.53a.75.75 0 0 0 0 1.06l1.5 1.5a.75.75 0 0 0 1.06 0L8 7.81l.97.97a.75.75 0 0 0 1.06 0l1.5-1.5a.749.749 0 0 0-.326-1.275.749.749 0 0 0-.734.215l-.97.97-.97-.97a.75.75 0 0 0-1.06 0l-.97.97-.97-.97a.75.75 0 0 0-1.06 0Zm1.03 6.03a.75.75 0 0 1 .75-.75h3.5a.75.75 0 0 1 0 1.5h-3.5a.75.75 0 0 1-.75-.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 13C0 6.373 5.373 1 12 1s12 5.373 12 12v8.657a.75.75 0 0 1-1.5 0V13c0-5.799-4.701-10.5-10.5-10.5S1.5 7.201 1.5 13v8.657a.75.75 0 0 1-1.5 0V13Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 19.75a.75.75 0 0 1 .75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75ZM5.25 9.5h13.5c.966 0 1.75.784 1.75 1.75v3.5a1.75 1.75 0 0 1-1.75 1.75H5.25a1.75 1.75 0 0 1-1.75-1.75v-3.5c0-.966.784-1.75 1.75-1.75Zm.22 1.47a.75.75 0 0 0 0 1.06l3 3a.75.75 0 0 0 1.06 0L12 12.56l2.47 2.47a.75.75 0 0 0 1.06 0l3-3a.749.749 0 0 0-.326-1.275.749.749 0 0 0-.734.215L15 13.44l-2.47-2.47a.75.75 0 0 0-1.06 0L9 13.44l-2.47-2.47a.75.75 0 0 0-1.06 0Z"
      }))
    }
  };
});
var IdBadgeIcon = /*#__PURE__*/createIconComponent("IdBadgeIcon", "octicon octicon-id-badge", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 7.5a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5v-3Zm10 .25a.75.75 0 0 1-.75.75h-4.5a.75.75 0 0 1 0-1.5h4.5a.75.75 0 0 1 .75.75ZM10.25 11a.75.75 0 0 0 0-1.5h-2.5a.75.75 0 0 0 0 1.5h2.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.25 0h1.5c.966 0 1.75.784 1.75 1.75V3h3.75c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 15H1.75A1.75 1.75 0 0 1 0 13.25v-8.5C0 3.784.784 3 1.75 3H5.5V1.75C5.5.784 6.284 0 7.25 0Zm3.232 4.5A1.75 1.75 0 0 1 8.75 6h-1.5a1.75 1.75 0 0 1-1.732-1.5H1.75a.25.25 0 0 0-.25.25v8.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25ZM7 1.75v2.5c0 .138.112.25.25.25h1.5A.25.25 0 0 0 9 4.25v-2.5a.25.25 0 0 0-.25-.25h-1.5a.25.25 0 0 0-.25.25Z"
      }))
    }
  };
});
var ImageIcon = /*#__PURE__*/createIconComponent("ImageIcon", "octicon octicon-image", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16 13.25A1.75 1.75 0 0 1 14.25 15H1.75A1.75 1.75 0 0 1 0 13.25V2.75C0 1.784.784 1 1.75 1h12.5c.966 0 1.75.784 1.75 1.75ZM1.75 2.5a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h.94l.03-.03 6.077-6.078a1.75 1.75 0 0 1 2.412-.06L14.5 10.31V2.75a.25.25 0 0 0-.25-.25Zm12.5 11a.25.25 0 0 0 .25-.25v-.917l-4.298-3.889a.25.25 0 0 0-.344.009L4.81 13.5ZM7 6a2 2 0 1 1-3.999.001A2 2 0 0 1 7 6ZM5.5 6a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 3h14.5c.966 0 1.75.784 1.75 1.75v14.5A1.75 1.75 0 0 1 19.25 21H4.75A1.75 1.75 0 0 1 3 19.25V4.75C3 3.784 3.784 3 4.75 3Zm14.5 1.5H4.75a.25.25 0 0 0-.25.25v14.5c0 .138.112.25.25.25h.19l9.823-9.823a1.75 1.75 0 0 1 2.475 0l2.262 2.262V4.75a.25.25 0 0 0-.25-.25Zm.25 9.56-3.323-3.323a.25.25 0 0 0-.354 0L7.061 19.5H19.25a.25.25 0 0 0 .25-.25ZM8.5 11a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Zm0-1.5a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
      })
    }
  };
});
var InboxIcon = /*#__PURE__*/createIconComponent("InboxIcon", "octicon octicon-inbox", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.8 2.06A1.75 1.75 0 0 1 4.41 1h7.18c.7 0 1.333.417 1.61 1.06l2.74 6.395c.04.093.06.194.06.295v4.5A1.75 1.75 0 0 1 14.25 15H1.75A1.75 1.75 0 0 1 0 13.25v-4.5c0-.101.02-.202.06-.295Zm1.61.44a.25.25 0 0 0-.23.152L1.887 8H4.75a.75.75 0 0 1 .6.3L6.625 10h2.75l1.275-1.7a.75.75 0 0 1 .6-.3h2.863L11.82 2.652a.25.25 0 0 0-.23-.152Zm10.09 7h-2.875l-1.275 1.7a.75.75 0 0 1-.6.3h-3.5a.75.75 0 0 1-.6-.3L4.375 9.5H1.5v3.75c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.801 3.57A1.75 1.75 0 0 1 6.414 2.5h11.174c.702 0 1.337.42 1.611 1.067l3.741 8.828c.04.092.06.192.06.293v7.562A1.75 1.75 0 0 1 21.25 22H2.75A1.75 1.75 0 0 1 1 20.25v-7.5c0-.1.02-.199.059-.291L4.8 3.571ZM6.414 4a.25.25 0 0 0-.23.153L2.88 12H8a.75.75 0 0 1 .648.372L10.18 15h3.638l1.533-2.628a.75.75 0 0 1 .64-.372l5.13-.051-3.304-7.797a.25.25 0 0 0-.23-.152ZM21.5 13.445l-5.067.05-1.535 2.633a.75.75 0 0 1-.648.372h-4.5a.75.75 0 0 1-.648-.372L7.57 13.5H2.5v6.75c0 .138.112.25.25.25h18.5a.25.25 0 0 0 .25-.25Z"
      })
    }
  };
});
var InfinityIcon = /*#__PURE__*/createIconComponent("InfinityIcon", "octicon octicon-infinity", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 6.984c.59-.533 1.204-1.066 1.825-1.493.797-.548 1.7-.991 2.675-.991C14.414 4.5 16 6.086 16 8s-1.586 3.5-3.5 3.5c-.975 0-1.878-.444-2.675-.991-.621-.427-1.235-.96-1.825-1.493-.59.533-1.204 1.066-1.825 1.493-.797.547-1.7.991-2.675.991C1.586 11.5 0 9.914 0 8s1.586-3.5 3.5-3.5c.975 0 1.878.443 2.675.991.621.427 1.235.96 1.825 1.493ZM9.114 8c.536.483 1.052.922 1.56 1.273.704.483 1.3.727 1.826.727 1.086 0 2-.914 2-2 0-1.086-.914-2-2-2-.525 0-1.122.244-1.825.727-.51.35-1.025.79-1.561 1.273ZM3.5 6c-1.086 0-2 .914-2 2 0 1.086.914 2 2 2 .525 0 1.122-.244 1.825-.727.51-.35 1.025-.79 1.561-1.273-.536-.483-1.052-.922-1.56-1.273C4.621 6.244 4.025 6 3.5 6Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 11.16c.887-.933 1.813-1.865 2.78-2.6C15.952 7.668 17.267 7 18.75 7 21.657 7 24 9.615 24 12.25s-2.343 5.25-5.25 5.25c-1.483 0-2.798-.668-3.97-1.56-.967-.735-1.893-1.667-2.78-2.6-.887.933-1.813 1.865-2.78 2.6-1.172.892-2.487 1.56-3.97 1.56C2.343 17.5 0 14.885 0 12.25S2.343 7 5.25 7c1.483 0 2.798.667 3.97 1.56.967.735 1.893 1.667 2.78 2.6ZM5.25 8.5c-2.032 0-3.75 1.895-3.75 3.75S3.218 16 5.25 16c1.017 0 2.014-.457 3.062-1.253.89-.678 1.758-1.554 2.655-2.497-.897-.943-1.765-1.82-2.655-2.497C7.264 8.957 6.267 8.5 5.25 8.5Zm7.783 3.75c.897.943 1.765 1.82 2.655 2.497C16.736 15.543 17.733 16 18.75 16c2.032 0 3.75-1.895 3.75-3.75S20.782 8.5 18.75 8.5c-1.017 0-2.014.457-3.062 1.253-.89.678-1.758 1.554-2.655 2.497Z"
      })
    }
  };
});
var InfoIcon = /*#__PURE__*/createIconComponent("InfoIcon", "octicon octicon-info", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8Zm8-6.5a6.5 6.5 0 1 0 0 13 6.5 6.5 0 0 0 0-13ZM6.5 7.75A.75.75 0 0 1 7.25 7h1a.75.75 0 0 1 .75.75v2.75h.25a.75.75 0 0 1 0 1.5h-2a.75.75 0 0 1 0-1.5h.25v-2h-.25a.75.75 0 0 1-.75-.75ZM8 6a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13 7.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-3 3.75a.75.75 0 0 1 .75-.75h1.5a.75.75 0 0 1 .75.75v4.25h.75a.75.75 0 0 1 0 1.5h-3a.75.75 0 0 1 0-1.5h.75V12h-.75a.75.75 0 0 1-.75-.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      }))
    }
  };
});
var IssueClosedIcon = /*#__PURE__*/createIconComponent("IssueClosedIcon", "octicon octicon-issue-closed", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.28 6.78a.75.75 0 0 0-1.06-1.06L7.25 8.69 5.78 7.22a.75.75 0 0 0-1.06 1.06l2 2a.75.75 0 0 0 1.06 0l3.5-3.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0Zm-1.5 0a6.5 6.5 0 1 0-13 0 6.5 6.5 0 0 0 13 0Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M17.28 9.28a.75.75 0 0 0-1.06-1.06l-5.97 5.97-2.47-2.47a.75.75 0 0 0-1.06 1.06l3 3a.75.75 0 0 0 1.06 0l6.5-6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      }))
    }
  };
});
var IssueDraftIcon = /*#__PURE__*/createIconComponent("IssueDraftIcon", "octicon octicon-issue-draft", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.307 11.655a.75.75 0 0 1 .165 1.048 8.05 8.05 0 0 1-1.769 1.77.75.75 0 0 1-.883-1.214 6.552 6.552 0 0 0 1.44-1.439.75.75 0 0 1 1.047-.165Zm-2.652-9.962a.75.75 0 0 1 1.048-.165 8.05 8.05 0 0 1 1.77 1.769.75.75 0 0 1-1.214.883 6.552 6.552 0 0 0-1.439-1.44.75.75 0 0 1-.165-1.047ZM6.749.097a8.074 8.074 0 0 1 2.502 0 .75.75 0 1 1-.233 1.482 6.558 6.558 0 0 0-2.036 0A.751.751 0 0 1 6.749.097ZM.955 6.125a.75.75 0 0 1 .624.857 6.558 6.558 0 0 0 0 2.036.75.75 0 1 1-1.482.233 8.074 8.074 0 0 1 0-2.502.75.75 0 0 1 .858-.624Zm14.09 0a.75.75 0 0 1 .858.624c.13.829.13 1.673 0 2.502a.75.75 0 1 1-1.482-.233 6.558 6.558 0 0 0 0-2.036.75.75 0 0 1 .624-.857Zm-8.92 8.92a.75.75 0 0 1 .857-.624 6.558 6.558 0 0 0 2.036 0 .75.75 0 1 1 .233 1.482c-.829.13-1.673.13-2.502 0a.75.75 0 0 1-.624-.858Zm-4.432-3.39a.75.75 0 0 1 1.048.165 6.552 6.552 0 0 0 1.439 1.44.751.751 0 0 1-.883 1.212 8.05 8.05 0 0 1-1.77-1.769.75.75 0 0 1 .166-1.048Zm2.652-9.962A.75.75 0 0 1 4.18 2.74a6.556 6.556 0 0 0-1.44 1.44.751.751 0 0 1-1.212-.883 8.05 8.05 0 0 1 1.769-1.77.75.75 0 0 1 1.048.166Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M17.32 3.205a.75.75 0 0 1 1.046-.177 11.056 11.056 0 0 1 2.605 2.606.75.75 0 1 1-1.222.869 9.554 9.554 0 0 0-2.252-2.252.75.75 0 0 1-.177-1.046Zm3.475 14.115a.75.75 0 0 1 .176 1.046 11.07 11.07 0 0 1-2.605 2.605.75.75 0 1 1-.869-1.222 9.554 9.554 0 0 0 2.252-2.252.75.75 0 0 1 1.046-.177ZM2.018 9.543a.75.75 0 0 1 .615.864 9.571 9.571 0 0 0 0 3.186.75.75 0 1 1-1.48.25 11.07 11.07 0 0 1 0-3.686.75.75 0 0 1 .865-.614Zm7.525 12.439a.75.75 0 0 1 .864-.615 9.571 9.571 0 0 0 3.186 0 .75.75 0 1 1 .25 1.48 11.07 11.07 0 0 1-3.686 0 .75.75 0 0 1-.614-.865ZM6.68 3.205a.75.75 0 0 1-.177 1.046A9.558 9.558 0 0 0 4.25 6.503a.75.75 0 1 1-1.223-.87 11.056 11.056 0 0 1 2.606-2.605.75.75 0 0 1 1.046.177ZM3.205 17.32a.75.75 0 0 1 1.046.177 9.554 9.554 0 0 0 2.252 2.252.75.75 0 1 1-.87 1.223 11.056 11.056 0 0 1-2.605-2.606.75.75 0 0 1 .177-1.046Zm6.952-16.166a11.07 11.07 0 0 1 3.686 0 .75.75 0 0 1-.25 1.479 9.571 9.571 0 0 0-3.186 0 .75.75 0 1 1-.25-1.48Zm11.825 8.389a.75.75 0 0 1 .864.614 11.07 11.07 0 0 1 0 3.686.75.75 0 0 1-1.479-.25 9.571 9.571 0 0 0 0-3.186.75.75 0 0 1 .615-.864Z"
      })
    }
  };
});
var IssueOpenedIcon = /*#__PURE__*/createIconComponent("IssueOpenedIcon", "octicon octicon-issue-opened", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 9.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0ZM1.5 8a6.5 6.5 0 1 0 13 0 6.5 6.5 0 0 0-13 0Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Zm9.5 2a2 2 0 1 1-.001-3.999A2 2 0 0 1 12 14Z"
      })
    }
  };
});
var IssueReopenedIcon = /*#__PURE__*/createIconComponent("IssueReopenedIcon", "octicon octicon-issue-reopened", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.029 2.217a6.5 6.5 0 0 1 9.437 5.11.75.75 0 1 0 1.492-.154 8 8 0 0 0-14.315-4.03L.427 1.927A.25.25 0 0 0 0 2.104V5.75A.25.25 0 0 0 .25 6h3.646a.25.25 0 0 0 .177-.427L2.715 4.215a6.491 6.491 0 0 1 2.314-1.998ZM1.262 8.169a.75.75 0 0 0-1.22.658 8.001 8.001 0 0 0 14.315 4.03l1.216 1.216a.25.25 0 0 0 .427-.177V10.25a.25.25 0 0 0-.25-.25h-3.646a.25.25 0 0 0-.177.427l1.358 1.358a6.501 6.501 0 0 1-11.751-3.11.75.75 0 0 0-.272-.506Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.06 9.06a1.5 1.5 0 1 1-2.12-2.12 1.5 1.5 0 0 1 2.12 2.12Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.38 8A9.502 9.502 0 0 1 12 2.5a9.502 9.502 0 0 1 9.215 7.182.75.75 0 1 0 1.456-.364C21.473 4.539 17.15 1 12 1a10.995 10.995 0 0 0-9.5 5.452V4.75a.75.75 0 0 0-1.5 0V8.5a1 1 0 0 0 1 1h3.75a.75.75 0 0 0 0-1.5H3.38Zm-.595 6.318a.75.75 0 0 0-1.455.364C2.527 19.461 6.85 23 12 23c4.052 0 7.592-2.191 9.5-5.451v1.701a.75.75 0 0 0 1.5 0V15.5a1 1 0 0 0-1-1h-3.75a.75.75 0 0 0 0 1.5h2.37A9.502 9.502 0 0 1 12 21.5c-4.446 0-8.181-3.055-9.215-7.182Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.414 13.414a2 2 0 1 1-2.828-2.828 2 2 0 0 1 2.828 2.828Z"
      }))
    }
  };
});
var IssueTrackedByIcon = /*#__PURE__*/createIconComponent("IssueTrackedByIcon", "octicon octicon-issue-tracked-by", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 8a6.5 6.5 0 0 1 13 0A.75.75 0 0 0 16 8a8 8 0 1 0-8 8 .75.75 0 0 0 0-1.5A6.5 6.5 0 0 1 1.5 8Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 9.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm3.573 5.823-2.896-2.896a.25.25 0 0 1 0-.354l2.896-2.896a.25.25 0 0 1 .427.177V11.5h3.25a.75.75 0 0 1 0 1.5H12v2.146a.25.25 0 0 1-.427.177Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 2.5a9.5 9.5 0 1 0 0 19 .75.75 0 0 1 0 1.5C5.925 23 1 18.075 1 12S5.925 1 12 1s11 4.925 11 11a.75.75 0 0 1-1.5 0A9.5 9.5 0 0 0 12 2.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m13.759 17.48 3.728 3.314a.308.308 0 0 0 .513-.23V18h4.25a.75.75 0 0 0 0-1.5H18v-2.564a.308.308 0 0 0-.513-.23L13.76 17.02a.308.308 0 0 0 0 .46ZM12 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"
      }))
    }
  };
});
var IssueTracksIcon = /*#__PURE__*/createIconComponent("IssueTracksIcon", "octicon octicon-issue-tracks", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 8a6.5 6.5 0 0 1 13 0A.75.75 0 0 0 16 8a8 8 0 1 0-8 8 .75.75 0 0 0 0-1.5A6.5 6.5 0 0 1 1.5 8Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 9.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm1.5 1.75a.75.75 0 0 1 .75-.75h5a.75.75 0 0 1 0 1.5h-5a.75.75 0 0 1-.75-.75Zm2.75 2.25a.75.75 0 0 0 0 1.5h3a.75.75 0 0 0 0-1.5h-3Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.5 12a9.5 9.5 0 1 1 19 0 .75.75 0 0 0 1.5 0c0-6.075-4.925-11-11-11S1 5.925 1 12s4.925 11 11 11a.75.75 0 0 0 0-1.5A9.5 9.5 0 0 1 2.5 12Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm2.5 2.75a.75.75 0 0 1 .75-.75h7a.75.75 0 0 1 0 1.5h-7a.75.75 0 0 1-.75-.75Zm3.75 2.75a.75.75 0 0 0 0 1.5h4a.75.75 0 0 0 0-1.5h-4Z"
      }))
    }
  };
});
var ItalicIcon = /*#__PURE__*/createIconComponent("ItalicIcon", "octicon octicon-italic", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 2.75A.75.75 0 0 1 6.75 2h6.5a.75.75 0 0 1 0 1.5h-2.505l-3.858 9H9.25a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1 0-1.5h2.505l3.858-9H6.75A.75.75 0 0 1 6 2.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10 4.75a.75.75 0 0 1 .75-.75h8.5a.75.75 0 0 1 0 1.5h-3.514l-5.828 13h3.342a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1 0-1.5h3.514l5.828-13H10.75a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var IterationsIcon = /*#__PURE__*/createIconComponent("IterationsIcon", "octicon octicon-iterations", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.5 7.25a4.75 4.75 0 0 1 9.5 0 .75.75 0 0 0 1.5 0 6.25 6.25 0 1 0-6.25 6.25H12v2.146c0 .223.27.335.427.177l2.896-2.896a.25.25 0 0 0 0-.354l-2.896-2.896a.25.25 0 0 0-.427.177V12H7.25A4.75 4.75 0 0 1 2.5 7.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.5 10.5a8 8 0 1 1 16 0 .75.75 0 0 0 1.5 0 9.5 9.5 0 1 0-9.5 9.5h10.94l-2.72 2.72a.75.75 0 1 0 1.06 1.06l3.735-3.735c.44-.439.44-1.151 0-1.59L19.78 14.72a.75.75 0 0 0-1.06 1.06l2.72 2.72H10.5a8 8 0 0 1-8-8Z"
      })
    }
  };
});
var KebabHorizontalIcon = /*#__PURE__*/createIconComponent("KebabHorizontalIcon", "octicon octicon-kebab-horizontal", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 9a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM1.5 9a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm13 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M20 14a2 2 0 1 1-.001-3.999A2 2 0 0 1 20 14ZM6 12a2 2 0 1 1-3.999.001A2 2 0 0 1 6 12Zm8 0a2 2 0 1 1-3.999.001A2 2 0 0 1 14 12Z"
      })
    }
  };
});
var KeyIcon = /*#__PURE__*/createIconComponent("KeyIcon", "octicon octicon-key", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.5 0a5.499 5.499 0 1 1-1.288 10.848l-.932.932a.749.749 0 0 1-.53.22H7v.75a.749.749 0 0 1-.22.53l-.5.5a.749.749 0 0 1-.53.22H5v.75a.749.749 0 0 1-.22.53l-.5.5a.749.749 0 0 1-.53.22h-2A1.75 1.75 0 0 1 0 14.25v-2c0-.199.079-.389.22-.53l4.932-4.932A5.5 5.5 0 0 1 10.5 0Zm-4 5.5c-.001.431.069.86.205 1.269a.75.75 0 0 1-.181.768L1.5 12.56v1.69c0 .138.112.25.25.25h1.69l.06-.06v-1.19a.75.75 0 0 1 .75-.75h1.19l.06-.06v-1.19a.75.75 0 0 1 .75-.75h1.19l1.023-1.025a.75.75 0 0 1 .768-.18A4 4 0 1 0 6.5 5.5ZM11 6a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16.75 8.5a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.75 0a8.25 8.25 0 1 1-2.541 16.101l-1.636 1.636a1.744 1.744 0 0 1-1.237.513H9.25a.25.25 0 0 0-.25.25v1.448a.876.876 0 0 1-.256.619l-.214.213a.75.75 0 0 1-.545.22H5.25a.25.25 0 0 0-.25.25v1A1.75 1.75 0 0 1 3.25 24h-1.5A1.75 1.75 0 0 1 0 22.25v-2.836c0-.464.185-.908.513-1.236l7.386-7.388A8.249 8.249 0 0 1 15.75 0ZM9 8.25a6.733 6.733 0 0 0 .463 2.462.75.75 0 0 1-.168.804l-7.722 7.721a.25.25 0 0 0-.073.177v2.836c0 .138.112.25.25.25h1.5a.25.25 0 0 0 .25-.25v-1c0-.966.784-1.75 1.75-1.75H7.5v-1c0-.966.784-1.75 1.75-1.75h1.086a.25.25 0 0 0 .177-.073l1.971-1.972a.75.75 0 0 1 .804-.168A6.75 6.75 0 1 0 9 8.25Z"
      }))
    }
  };
});
var KeyAsteriskIcon = /*#__PURE__*/createIconComponent("KeyAsteriskIcon", "octicon octicon-key-asterisk", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 2.75A2.75 2.75 0 0 1 2.75 0h10.5A2.75 2.75 0 0 1 16 2.75v10.5A2.75 2.75 0 0 1 13.25 16H2.75A2.75 2.75 0 0 1 0 13.25ZM2.75 1.5c-.69 0-1.25.56-1.25 1.25v10.5c0 .69.56 1.25 1.25 1.25h10.5c.69 0 1.25-.56 1.25-1.25V2.75c0-.69-.56-1.25-1.25-1.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 4a.75.75 0 0 1 .75.75V6.7l1.69-.975a.75.75 0 0 1 .75 1.3L9.5 8l1.69.976a.75.75 0 0 1-.75 1.298L8.75 9.3v1.951a.75.75 0 0 1-1.5 0V9.299l-1.69.976a.75.75 0 0 1-.75-1.3L6.5 8l-1.69-.975a.75.75 0 0 1 .75-1.3l1.69.976V4.75A.75.75 0 0 1 8 4Z"
      }))
    }
  };
});
var LawIcon = /*#__PURE__*/createIconComponent("LawIcon", "octicon octicon-law", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75.75V2h.985c.304 0 .603.08.867.231l1.29.736c.038.022.08.033.124.033h2.234a.75.75 0 0 1 0 1.5h-.427l2.111 4.692a.75.75 0 0 1-.154.838l-.53-.53.529.531-.001.002-.002.002-.006.006-.006.005-.01.01-.045.04c-.21.176-.441.327-.686.45C14.556 10.78 13.88 11 13 11a4.498 4.498 0 0 1-2.023-.454 3.544 3.544 0 0 1-.686-.45l-.045-.04-.016-.015-.006-.006-.004-.004v-.001a.75.75 0 0 1-.154-.838L12.178 4.5h-.162c-.305 0-.604-.079-.868-.231l-1.29-.736a.245.245 0 0 0-.124-.033H8.75V13h2.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1 0-1.5h2.5V3.5h-.984a.245.245 0 0 0-.124.033l-1.289.737c-.265.15-.564.23-.869.23h-.162l2.112 4.692a.75.75 0 0 1-.154.838l-.53-.53.529.531-.001.002-.002.002-.006.006-.016.015-.045.04c-.21.176-.441.327-.686.45C4.556 10.78 3.88 11 3 11a4.498 4.498 0 0 1-2.023-.454 3.544 3.544 0 0 1-.686-.45l-.045-.04-.016-.015-.006-.006-.004-.004v-.001a.75.75 0 0 1-.154-.838L2.178 4.5H1.75a.75.75 0 0 1 0-1.5h2.234a.249.249 0 0 0 .125-.033l1.288-.737c.265-.15.564-.23.869-.23h.984V.75a.75.75 0 0 1 1.5 0Zm2.945 8.477c.285.135.718.273 1.305.273s1.02-.138 1.305-.273L13 6.327Zm-10 0c.285.135.718.273 1.305.273s1.02-.138 1.305-.273L3 6.327Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.75 2.75V4.5h1.975c.351 0 .694.106.984.303l1.697 1.154c.041.028.09.043.14.043h4.102a.75.75 0 0 1 0 1.5H20.07l3.366 7.68a.749.749 0 0 1-.23.896c-.1.074-.203.143-.31.206a6.296 6.296 0 0 1-.79.399 7.349 7.349 0 0 1-2.856.569 7.343 7.343 0 0 1-2.855-.568 6.205 6.205 0 0 1-.79-.4 3.205 3.205 0 0 1-.307-.202l-.005-.004a.749.749 0 0 1-.23-.896l3.368-7.68h-.886c-.351 0-.694-.106-.984-.303l-1.697-1.154a.246.246 0 0 0-.14-.043H12.75v14.5h4.487a.75.75 0 0 1 0 1.5H6.763a.75.75 0 0 1 0-1.5h4.487V6H9.275a.249.249 0 0 0-.14.043L7.439 7.197c-.29.197-.633.303-.984.303h-.886l3.368 7.68a.75.75 0 0 1-.209.878c-.08.065-.16.126-.31.223a6.077 6.077 0 0 1-.792.433 6.924 6.924 0 0 1-2.876.62 6.913 6.913 0 0 1-2.876-.62 6.077 6.077 0 0 1-.792-.433 3.483 3.483 0 0 1-.309-.221.762.762 0 0 1-.21-.88L3.93 7.5H2.353a.75.75 0 0 1 0-1.5h4.102c.05 0 .099-.015.141-.043l1.695-1.154c.29-.198.634-.303.985-.303h1.974V2.75a.75.75 0 0 1 1.5 0ZM2.193 15.198a5.414 5.414 0 0 0 2.557.635 5.414 5.414 0 0 0 2.557-.635L4.75 9.368Zm14.51-.024c.082.04.174.083.275.126.53.223 1.305.45 2.272.45a5.847 5.847 0 0 0 2.547-.576L19.25 9.367Z"
      })
    }
  };
});
var LightBulbIcon = /*#__PURE__*/createIconComponent("LightBulbIcon", "octicon octicon-light-bulb", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 1.5c-2.363 0-4 1.69-4 3.75 0 .984.424 1.625.984 2.304l.214.253c.223.264.47.556.673.848.284.411.537.896.621 1.49a.75.75 0 0 1-1.484.211c-.04-.282-.163-.547-.37-.847a8.456 8.456 0 0 0-.542-.68c-.084-.1-.173-.205-.268-.32C3.201 7.75 2.5 6.766 2.5 5.25 2.5 2.31 4.863 0 8 0s5.5 2.31 5.5 5.25c0 1.516-.701 2.5-1.328 3.259-.095.115-.184.22-.268.319-.207.245-.383.453-.541.681-.208.3-.33.565-.37.847a.751.751 0 0 1-1.485-.212c.084-.593.337-1.078.621-1.489.203-.292.45-.584.673-.848.075-.088.147-.173.213-.253.561-.679.985-1.32.985-2.304 0-2.06-1.637-3.75-4-3.75ZM5.75 12h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1 0-1.5ZM6 15.25a.75.75 0 0 1 .75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.75.75 0 0 1-.75-.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 2.5c-3.81 0-6.5 2.743-6.5 6.119 0 1.536.632 2.572 1.425 3.56.172.215.347.422.527.635l.096.112c.21.25.427.508.63.774.404.531.783 1.128.995 1.834a.75.75 0 0 1-1.436.432c-.138-.46-.397-.89-.753-1.357a18.111 18.111 0 0 0-.582-.714l-.092-.11c-.18-.212-.37-.436-.555-.667C4.87 12.016 4 10.651 4 8.618 4 4.363 7.415 1 12 1s8 3.362 8 7.619c0 2.032-.87 3.397-1.755 4.5-.185.23-.375.454-.555.667l-.092.109c-.21.248-.405.481-.582.714-.356.467-.615.898-.753 1.357a.751.751 0 0 1-1.437-.432c.213-.706.592-1.303.997-1.834.202-.266.419-.524.63-.774l.095-.112c.18-.213.355-.42.527-.634.793-.99 1.425-2.025 1.425-3.561C18.5 5.243 15.81 2.5 12 2.5ZM8.75 18h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1 0-1.5Zm.75 3.75a.75.75 0 0 1 .75-.75h3.5a.75.75 0 0 1 0 1.5h-3.5a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var LinkIcon = /*#__PURE__*/createIconComponent("LinkIcon", "octicon octicon-link", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m7.775 3.275 1.25-1.25a3.5 3.5 0 1 1 4.95 4.95l-2.5 2.5a3.5 3.5 0 0 1-4.95 0 .751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018 1.998 1.998 0 0 0 2.83 0l2.5-2.5a2.002 2.002 0 0 0-2.83-2.83l-1.25 1.25a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042Zm-4.69 9.64a1.998 1.998 0 0 0 2.83 0l1.25-1.25a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042l-1.25 1.25a3.5 3.5 0 1 1-4.95-4.95l2.5-2.5a3.5 3.5 0 0 1 4.95 0 .751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018 1.998 1.998 0 0 0-2.83 0l-2.5 2.5a1.998 1.998 0 0 0 0 2.83Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.78 3.653a3.936 3.936 0 1 1 5.567 5.567l-3.627 3.627a3.936 3.936 0 0 1-5.88-.353.75.75 0 0 0-1.18.928 5.436 5.436 0 0 0 8.12.486l3.628-3.628a5.436 5.436 0 1 0-7.688-7.688l-3 3a.75.75 0 0 0 1.06 1.061l3-3Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.28 11.153a3.936 3.936 0 0 1 5.88.353.75.75 0 0 0 1.18-.928 5.436 5.436 0 0 0-8.12-.486L2.592 13.72a5.436 5.436 0 1 0 7.688 7.688l3-3a.75.75 0 1 0-1.06-1.06l-3 3a3.936 3.936 0 0 1-5.567-5.568l3.627-3.627Z"
      }))
    }
  };
});
var LinkExternalIcon = /*#__PURE__*/createIconComponent("LinkExternalIcon", "octicon octicon-link-external", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 2h3.5a.75.75 0 0 1 0 1.5h-3.5a.25.25 0 0 0-.25.25v8.5c0 .138.112.25.25.25h8.5a.25.25 0 0 0 .25-.25v-3.5a.75.75 0 0 1 1.5 0v3.5A1.75 1.75 0 0 1 12.25 14h-8.5A1.75 1.75 0 0 1 2 12.25v-8.5C2 2.784 2.784 2 3.75 2Zm6.854-1h4.146a.25.25 0 0 1 .25.25v4.146a.25.25 0 0 1-.427.177L13.03 4.03 9.28 7.78a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042l3.75-3.75-1.543-1.543A.25.25 0 0 1 10.604 1Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.5 2.25a.75.75 0 0 1 .75-.75h5.5a.75.75 0 0 1 .75.75v5.5a.75.75 0 0 1-1.5 0V4.06l-6.22 6.22a.75.75 0 1 1-1.06-1.06L19.94 3h-3.69a.75.75 0 0 1-.75-.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.5 4.25c0-.966.784-1.75 1.75-1.75h8.5a.75.75 0 0 1 0 1.5h-8.5a.25.25 0 0 0-.25.25v15.5c0 .138.112.25.25.25h15.5a.25.25 0 0 0 .25-.25v-8.5a.75.75 0 0 1 1.5 0v8.5a1.75 1.75 0 0 1-1.75 1.75H4.25a1.75 1.75 0 0 1-1.75-1.75V4.25Z"
      }))
    }
  };
});
var ListOrderedIcon = /*#__PURE__*/createIconComponent("ListOrderedIcon", "octicon octicon-list-ordered", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 3.25a.75.75 0 0 1 .75-.75h8.5a.75.75 0 0 1 0 1.5h-8.5A.75.75 0 0 1 5 3.25Zm0 5a.75.75 0 0 1 .75-.75h8.5a.75.75 0 0 1 0 1.5h-8.5A.75.75 0 0 1 5 8.25Zm0 5a.75.75 0 0 1 .75-.75h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1-.75-.75ZM.924 10.32a.5.5 0 0 1-.851-.525l.001-.001.001-.002.002-.004.007-.011c.097-.144.215-.273.348-.384.228-.19.588-.392 1.068-.392.468 0 .858.181 1.126.484.259.294.377.673.377 1.038 0 .987-.686 1.495-1.156 1.845l-.047.035c-.303.225-.522.4-.654.597h1.357a.5.5 0 0 1 0 1H.5a.5.5 0 0 1-.5-.5c0-1.005.692-1.52 1.167-1.875l.035-.025c.531-.396.8-.625.8-1.078a.57.57 0 0 0-.128-.376C1.806 10.068 1.695 10 1.5 10a.658.658 0 0 0-.429.163.835.835 0 0 0-.144.153ZM2.003 2.5V6h.503a.5.5 0 0 1 0 1H.5a.5.5 0 0 1 0-1h.503V3.308l-.28.14a.5.5 0 0 1-.446-.895l1.003-.5a.5.5 0 0 1 .723.447Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.604 3.089A.75.75 0 0 1 4 3.75V8.5h.75a.75.75 0 0 1 0 1.5h-3a.75.75 0 1 1 0-1.5h.75V5.151l-.334.223a.75.75 0 0 1-.832-1.248l1.5-1a.75.75 0 0 1 .77-.037ZM8.75 5.5a.75.75 0 0 0 0 1.5h11.5a.75.75 0 0 0 0-1.5H8.75Zm0 6a.75.75 0 0 0 0 1.5h11.5a.75.75 0 0 0 0-1.5H8.75Zm0 6a.75.75 0 0 0 0 1.5h11.5a.75.75 0 0 0 0-1.5H8.75ZM5.5 15.75c0-.704-.271-1.286-.72-1.686a2.302 2.302 0 0 0-1.53-.564c-.535 0-1.094.178-1.53.565-.449.399-.72.982-.72 1.685a.75.75 0 0 0 1.5 0c0-.296.104-.464.217-.564A.805.805 0 0 1 3.25 15c.215 0 .406.072.533.185.113.101.217.268.217.565 0 .332-.069.48-.21.657-.092.113-.216.24-.403.419l-.147.14c-.152.144-.33.313-.52.504l-1.5 1.5a.75.75 0 0 0-.22.53v.25c0 .414.336.75.75.75H5A.75.75 0 0 0 5 19H3.31l.47-.47c.176-.176.333-.324.48-.465l.165-.156a5.98 5.98 0 0 0 .536-.566c.358-.447.539-.925.539-1.593Z"
      })
    }
  };
});
var ListUnorderedIcon = /*#__PURE__*/createIconComponent("ListUnorderedIcon", "octicon octicon-list-unordered", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 2.5h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1 0-1.5Zm0 5h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1 0-1.5Zm0 5h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1 0-1.5ZM2 14a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm1-6a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM2 4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75 5.5h11.5a.75.75 0 0 1 0 1.5H8.75a.75.75 0 0 1 0-1.5Zm0 6h11.5a.75.75 0 0 1 0 1.5H8.75a.75.75 0 0 1 0-1.5Zm0 6h11.5a.75.75 0 0 1 0 1.5H8.75a.75.75 0 0 1 0-1.5ZM5 12a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM4 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm0 12a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    }
  };
});
var LocationIcon = /*#__PURE__*/createIconComponent("LocationIcon", "octicon octicon-location", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m12.596 11.596-3.535 3.536a1.5 1.5 0 0 1-2.122 0l-3.535-3.536a6.5 6.5 0 1 1 9.192-9.193 6.5 6.5 0 0 1 0 9.193Zm-1.06-8.132v-.001a5 5 0 1 0-7.072 7.072L8 14.07l3.536-3.534a5 5 0 0 0 0-7.072ZM8 9a2 2 0 1 1-.001-3.999A2 2 0 0 1 8 9Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 13.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M19.071 3.429h.001c3.905 3.905 3.905 10.237 0 14.142l-5.403 5.403a2.36 2.36 0 0 1-3.336 0l-5.375-5.375-.028-.028c-3.905-3.905-3.905-10.237 0-14.142 3.904-3.905 10.236-3.905 14.141 0ZM5.99 4.489v.001a8.5 8.5 0 0 0 0 12.02l.023.024.002.002 5.378 5.378a.859.859 0 0 0 1.214 0l5.403-5.404a8.5 8.5 0 0 0-.043-11.977A8.5 8.5 0 0 0 5.99 4.489Z"
      }))
    }
  };
});
var LockIcon = /*#__PURE__*/createIconComponent("LockIcon", "octicon octicon-lock", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 4a4 4 0 0 1 8 0v2h.25c.966 0 1.75.784 1.75 1.75v5.5A1.75 1.75 0 0 1 12.25 15h-8.5A1.75 1.75 0 0 1 2 13.25v-5.5C2 6.784 2.784 6 3.75 6H4Zm8.25 3.5h-8.5a.25.25 0 0 0-.25.25v5.5c0 .138.112.25.25.25h8.5a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25ZM10.5 6V4a2.5 2.5 0 1 0-5 0v2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 9V7.25C6 3.845 8.503 1 12 1s6 2.845 6 6.25V9h.5a2.5 2.5 0 0 1 2.5 2.5v8a2.5 2.5 0 0 1-2.5 2.5h-13A2.5 2.5 0 0 1 3 19.5v-8A2.5 2.5 0 0 1 5.5 9Zm-1.5 2.5v8a1 1 0 0 0 1 1h13a1 1 0 0 0 1-1v-8a1 1 0 0 0-1-1h-13a1 1 0 0 0-1 1Zm3-4.25V9h9V7.25c0-2.67-1.922-4.75-4.5-4.75-2.578 0-4.5 2.08-4.5 4.75Z"
      })
    }
  };
});
var LogIcon = /*#__PURE__*/createIconComponent("LogIcon", "octicon octicon-log", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 8.25a.75.75 0 0 1 .75-.75h4a.75.75 0 0 1 0 1.5h-4A.75.75 0 0 1 5 8.25ZM4 10.5A.75.75 0 0 0 4 12h4a.75.75 0 0 0 0-1.5H4Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13-.005c1.654 0 3 1.328 3 3 0 .982-.338 1.933-.783 2.818-.443.879-1.028 1.758-1.582 2.588l-.011.017c-.568.853-1.104 1.659-1.501 2.446-.398.789-.623 1.494-.623 2.136a1.5 1.5 0 1 0 2.333-1.248.75.75 0 0 1 .834-1.246A3 3 0 0 1 13 16H3a3 3 0 0 1-3-3c0-1.582.891-3.135 1.777-4.506.209-.322.418-.637.623-.946.473-.709.923-1.386 1.287-2.048H2.51c-.576 0-1.381-.133-1.907-.783A2.68 2.68 0 0 1 0 2.995a3 3 0 0 1 3-3Zm0 1.5a1.5 1.5 0 0 0-1.5 1.5c0 .476.223.834.667 1.132A.75.75 0 0 1 11.75 5.5H5.368c-.467 1.003-1.141 2.015-1.773 2.963-.192.289-.381.571-.558.845C2.13 10.711 1.5 11.916 1.5 13A1.5 1.5 0 0 0 3 14.5h7.401A2.989 2.989 0 0 1 10 13c0-.979.338-1.928.784-2.812.441-.874 1.023-1.748 1.575-2.576l.017-.026c.568-.853 1.103-1.658 1.501-2.448.398-.79.623-1.497.623-2.143 0-.838-.669-1.5-1.5-1.5Zm-10 0a1.5 1.5 0 0 0-1.5 1.5c0 .321.1.569.27.778.097.12.325.227.74.227h7.674A2.737 2.737 0 0 1 10 2.995c0-.546.146-1.059.401-1.5Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.197 10a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5Zm-2.382 4a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5Zm-1.581 4a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.125 0h15.75a4.11 4.11 0 0 1 2.92 1.205A4.11 4.11 0 0 1 24 4.125c0 1.384-.476 2.794-1.128 4.16-.652 1.365-1.515 2.757-2.352 4.104l-.008.013c-.849 1.368-1.669 2.691-2.28 3.97-.614 1.283-.982 2.45-.982 3.503a2.625 2.625 0 1 0 4.083-2.183.75.75 0 1 1 .834-1.247A4.126 4.126 0 0 1 19.875 24H4.5a4.125 4.125 0 0 1-4.125-4.125c0-2.234 1.258-4.656 2.59-6.902.348-.586.702-1.162 1.05-1.728.8-1.304 1.567-2.553 2.144-3.738H3.39c-.823 0-1.886-.193-2.567-1.035A3.647 3.647 0 0 1 0 4.125 4.125 4.125 0 0 1 4.125 0ZM15.75 19.875c0-1.38.476-2.786 1.128-4.15.649-1.358 1.509-2.743 2.343-4.086l.017-.028c.849-1.367 1.669-2.692 2.28-3.972.614-1.285.982-2.457.982-3.514A2.615 2.615 0 0 0 19.875 1.5a2.625 2.625 0 0 0-2.625 2.625c0 .865.421 1.509 1.167 2.009A.75.75 0 0 1 18 7.507H7.812c-.65 1.483-1.624 3.069-2.577 4.619-.334.544-.666 1.083-.98 1.612-1.355 2.287-2.38 4.371-2.38 6.137A2.625 2.625 0 0 0 4.5 22.5h12.193a4.108 4.108 0 0 1-.943-2.625ZM1.5 4.125c-.01.511.163 1.008.487 1.403.254.313.74.479 1.402.479h12.86a3.648 3.648 0 0 1-.499-1.882 4.11 4.11 0 0 1 .943-2.625H4.125A2.625 2.625 0 0 0 1.5 4.125Z"
      }))
    }
  };
});
var LogoGistIcon = /*#__PURE__*/createIconComponent("LogoGistIcon", "octicon octicon-logo-gist", function () {
  return {
    "16": {
      "width": 25,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.7 8.73v-1h3.52v5.69c-.78.37-1.95.64-3.59.64C1.11 14.06 0 11.37 0 8.03 0 4.69 1.13 2 4.63 2c1.62 0 2.64.33 3.28.66v1.05c-1.22-.5-2-.73-3.28-.73-2.57 0-3.48 2.21-3.48 5.06 0 2.85.91 5.05 3.47 5.05.89 0 1.98-.07 2.53-.34V8.73Zm10.98.69h.03c2.22.2 2.75.95 2.75 2.23 0 1.21-.76 2.41-3.14 2.41-.75 0-1.83-.19-2.33-.39v-.94c.47.17 1.22.36 2.33.36 1.62 0 2.06-.69 2.06-1.42 0-.71-.22-1.21-1.77-1.34-2.26-.2-2.73-1-2.73-2.08 0-1.11.72-2.31 2.92-2.31.73 0 1.56.09 2.25.39v.94c-.61-.2-1.22-.36-2.27-.36-1.55 0-1.88.57-1.88 1.34 0 .69.28 1.04 1.78 1.17Zm8.58-3.33v.85h-2.42v4.87c0 .95.53 1.34 1.5 1.34.2 0 .42 0 .61-.03v.89c-.17.03-.5.05-.69.05-1.31 0-2.5-.6-2.5-2.13v-5H19.2v-.48l1.56-.44V3.9l1.08-.31v2.5h2.42Zm-13.17-.03v6.41c0 .54.19.7.67.7v.89c-1.14 0-1.72-.47-1.72-1.72V6.06h1.05Zm.25-2.33c0 .44-.34.78-.78.78a.76.76 0 0 1-.77-.78c0-.44.32-.78.77-.78s.78.34.78.78Z"
      })
    }
  };
});
var LogoGithubIcon = /*#__PURE__*/createIconComponent("LogoGithubIcon", "octicon octicon-logo-github", function () {
  return {
    "16": {
      "width": 45,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.81 7.35v5.74c0 .04-.01.11-.06.13 0 0-1.25.89-3.31.89-2.49 0-5.44-.78-5.44-5.92S2.58 1.99 5.1 2c2.18 0 3.06.49 3.2.58.04.05.06.09.06.14L7.94 4.5c0 .09-.09.2-.2.17-.36-.11-.9-.33-2.17-.33-1.47 0-3.05.42-3.05 3.73s1.5 3.7 2.58 3.7c.92 0 1.25-.11 1.25-.11v-2.3H4.88c-.11 0-.19-.08-.19-.17V7.35c0-.09.08-.17.19-.17h3.74c.11 0 .19.08.19.17Zm35.85 2.33c0 3.43-1.11 4.41-3.05 4.41-1.64 0-2.52-.83-2.52-.83s-.04.46-.09.52c-.03.06-.08.08-.14.08h-1.48c-.1 0-.19-.08-.19-.17l.02-11.11c0-.09.08-.17.17-.17h2.13c.09 0 .17.08.17.17v3.77s.82-.53 2.02-.53l-.01-.02c1.2 0 2.97.45 2.97 3.88ZM27.68 2.43c.09 0 .17.08.17.17v11.11c0 .09-.08.17-.17.17h-2.13c-.09 0-.17-.08-.17-.17l.02-4.75h-3.31v4.75c0 .09-.08.17-.17.17h-2.13c-.08 0-.17-.08-.17-.17V2.6c0-.09.08-.17.17-.17h2.13c.09 0 .17.08.17.17v4.09h3.31V2.6c0-.09.08-.17.17-.17Zm8.26 3.64c.11 0 .19.08.19.17l-.02 7.47c0 .09-.06.17-.17.17H34.6c-.07 0-.14-.04-.16-.09-.03-.06-.08-.45-.08-.45s-1.13.77-2.52.77c-1.69 0-2.92-.55-2.92-2.75V6.25c0-.09.08-.17.17-.17h2.14c.09 0 .17.08.17.17V11c0 .75.22 1.09.97 1.09s1.3-.39 1.3-.39V6.26c0-.11.06-.19.17-.19Zm-17.406 5.971h.005a.177.177 0 0 1 .141.179v1.5c0 .07-.03.14-.09.16-.1.05-.74.22-1.27.22-1.16 0-2.86-.25-2.86-2.69V8.13h-1.11c-.09 0-.17-.08-.17-.19V6.58c0-.08.05-.15.13-.17.07-.01 1.16-.28 1.16-.28V3.96c0-.08.05-.13.14-.13h2.16c.09 0 .14.05.14.13v2.11h1.59c.08 0 .16.08.16.17v1.7c0 .11-.07.19-.16.19h-1.59v3.131c0 .47.27.83 1.05.83.247 0 .481-.049.574-.05ZM12.24 6.06c.09 0 .17.08.17.17v7.37c0 .18-.05.27-.25.27h-1.92c-.17 0-.3-.07-.3-.27V6.26c0-.11.08-.2.17-.2Zm29.99 3.78c0-1.81-.73-2.05-1.5-1.97-.6.04-1.08.34-1.08.34v3.52s.49.34 1.22.36c1.03.03 1.36-.34 1.36-2.25ZM11.19 2.68c.75 0 1.36.61 1.36 1.38 0 .77-.61 1.38-1.36 1.38-.77 0-1.38-.61-1.38-1.38 0-.77.61-1.38 1.38-1.38Zm7.34 9.35v.001l.01.01h-.001l-.005-.001v.001c-.009-.001-.015-.011-.024-.011Z"
      })
    }
  };
});
var MailIcon = /*#__PURE__*/createIconComponent("MailIcon", "octicon octicon-mail", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 2h12.5c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 14H1.75A1.75 1.75 0 0 1 0 12.25v-8.5C0 2.784.784 2 1.75 2ZM1.5 12.251c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V5.809L8.38 9.397a.75.75 0 0 1-.76 0L1.5 5.809v6.442Zm13-8.181v-.32a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25v.32L8 7.88Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 3h20.5c.966 0 1.75.784 1.75 1.75v14a1.75 1.75 0 0 1-1.75 1.75H1.75A1.75 1.75 0 0 1 0 18.75v-14C0 3.784.784 3 1.75 3ZM1.5 7.412V18.75c0 .138.112.25.25.25h20.5a.25.25 0 0 0 .25-.25V7.412l-9.52 6.433c-.592.4-1.368.4-1.96 0Zm0-2.662v.852l10.36 7a.25.25 0 0 0 .28 0l10.36-7V4.75a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25Z"
      })
    }
  };
});
var MarkGithubIcon = /*#__PURE__*/createIconComponent("MarkGithubIcon", "octicon octicon-mark-github", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0c4.42 0 8 3.58 8 8a8.013 8.013 0 0 1-5.45 7.59c-.4.08-.55-.17-.55-.38 0-.27.01-1.13.01-2.2 0-.75-.25-1.23-.54-1.48 1.78-.2 3.65-.88 3.65-3.95 0-.88-.31-1.59-.82-2.15.08-.2.36-1.02-.08-2.12 0 0-.67-.22-2.2.82-.64-.18-1.32-.27-2-.27-.68 0-1.36.09-2 .27-1.53-1.03-2.2-.82-2.2-.82-.44 1.1-.16 1.92-.08 2.12-.51.56-.82 1.28-.82 2.15 0 3.06 1.86 3.75 3.64 3.95-.23.2-.44.55-.51 1.07-.46.21-1.61.55-2.33-.66-.15-.24-.6-.83-1.23-.82-.67.01-.27.38.01.53.34.19.73.9.82 1.13.16.45.68 1.31 2.69.94 0 .67.01 1.3.01 1.49 0 .21-.15.45-.55.38A7.995 7.995 0 0 1 0 8c0-4.42 3.58-8 8-8Z"
      })
    }
  };
});
var MarkdownIcon = /*#__PURE__*/createIconComponent("MarkdownIcon", "octicon octicon-markdown", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.85 3c.63 0 1.15.52 1.14 1.15v7.7c0 .63-.51 1.15-1.15 1.15H1.15C.52 13 0 12.48 0 11.84V4.15C0 3.52.52 3 1.15 3ZM9 11V5H7L5.5 7 4 5H2v6h2V8l1.5 1.92L7 8v3Zm2.99.5L14.5 8H13V5h-2v3H9.5Z"
      })
    }
  };
});
var MegaphoneIcon = /*#__PURE__*/createIconComponent("MegaphoneIcon", "octicon octicon-megaphone", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.25 9a.75.75 0 0 1 .75.75c0 2.142.456 3.828.733 4.653a.122.122 0 0 0 .05.064.212.212 0 0 0 .117.033h1.31c.085 0 .18-.042.258-.152a.45.45 0 0 0 .075-.366A16.743 16.743 0 0 1 6 9.75a.75.75 0 0 1 1.5 0c0 1.588.25 2.926.494 3.85.293 1.113-.504 2.4-1.783 2.4H4.9c-.686 0-1.35-.41-1.589-1.12A16.4 16.4 0 0 1 2.5 9.75.75.75 0 0 1 3.25 9Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 6a4 4 0 0 1 4-4h2.75a.75.75 0 0 1 .75.75v6.5a.75.75 0 0 1-.75.75H4a4 4 0 0 1-4-4Zm4-2.5a2.5 2.5 0 1 0 0 5h2v-5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.59.082A.75.75 0 0 1 16 .75v10.5a.75.75 0 0 1-1.189.608l-.002-.001h.001l-.014-.01a5.775 5.775 0 0 0-.422-.25 10.63 10.63 0 0 0-1.469-.64C11.576 10.484 9.536 10 6.75 10a.75.75 0 0 1 0-1.5c2.964 0 5.174.516 6.658 1.043.423.151.787.302 1.092.443V2.014c-.305.14-.669.292-1.092.443C11.924 2.984 9.713 3.5 6.75 3.5a.75.75 0 0 1 0-1.5c2.786 0 4.826-.484 6.155-.957.665-.236 1.154-.47 1.47-.64.144-.077.284-.161.421-.25l.014-.01a.75.75 0 0 1 .78-.061Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M22 1.75v14.5a.75.75 0 0 1-.399.662c-.384.204-.783-.035-1.139-.248l-.003-.002c-.09-.054-.177-.107-.261-.15a15.53 15.53 0 0 0-2-.849c-1.738-.607-4.321-1.223-7.703-1.251a.833.833 0 0 1 .005.088c0 2.279.494 4.279.906 5.547.368 1.131-.438 2.453-1.732 2.453H7.661c-.696 0-1.36-.42-1.6-1.129C5.684 20.255 5 17.811 5 14.75v-.457A5.5 5.5 0 0 1 6.5 3.5h3.75c3.505 0 6.175-.61 7.955-1.21a15.88 15.88 0 0 0 2.002-.82 9.21 9.21 0 0 0 .49-.262c.048-.028.095-.055.142-.085A.751.751 0 0 1 22 1.75ZM10.5 12.912c3.564.029 6.313.678 8.193 1.335.737.258 1.34.517 1.807.74V2.993c-.467.216-1.073.467-1.815.718-1.878.634-4.624 1.26-8.185 1.288ZM6.5 5a4 4 0 0 0 0 8H9V5Zm0 9.75c0 2.847.638 5.123.982 6.141.018.051.074.109.179.109h2.013c.087 0 .179-.043.249-.147a.396.396 0 0 0 .057-.343C9.537 19.148 9 16.986 9 14.5H6.5Z"
      })
    }
  };
});
var MentionIcon = /*#__PURE__*/createIconComponent("MentionIcon", "octicon octicon-mention", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 2.37a6.501 6.501 0 0 0 6.5 11.26.75.75 0 0 1 .75 1.298A7.999 7.999 0 0 1 .989 4.148 8 8 0 0 1 16 7.75v1.5a2.75 2.75 0 0 1-5.072 1.475 3.999 3.999 0 0 1-6.65-4.19A4 4 0 0 1 12 8v1.25a1.25 1.25 0 0 0 2.5 0V7.867a6.5 6.5 0 0 0-9.75-5.496ZM10.5 8a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M20.226 7.25c-2.623-4.542-8.432-6.098-12.974-3.475-4.543 2.622-6.099 8.431-3.477 12.974 2.623 4.542 8.431 6.099 12.974 3.477a.75.75 0 0 1 .75 1.299c-5.26 3.037-11.987 1.235-15.024-4.026C-.562 12.24 1.24 5.512 6.501 2.475 11.76-.562 18.488 1.24 21.525 6.501a10.959 10.959 0 0 1 1.455 4.826c.013.056.02.113.02.173v2.25a3.5 3.5 0 0 1-6.623 1.581 5.5 5.5 0 1 1 1.112-3.682.802.802 0 0 1 .011.129v1.972a2 2 0 1 0 4 0v-1.766a9.456 9.456 0 0 0-1.274-4.733ZM16 12a4 4 0 1 0-8 0 4 4 0 0 0 8 0Z"
      })
    }
  };
});
var MeterIcon = /*#__PURE__*/createIconComponent("MeterIcon", "octicon octicon-meter", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 1.5a6.5 6.5 0 1 0 6.016 4.035.75.75 0 0 1 1.388-.57 8 8 0 1 1-4.37-4.37.75.75 0 1 1-.569 1.389A6.473 6.473 0 0 0 8 1.5Zm6.28.22a.75.75 0 0 1 0 1.06l-4.063 4.064a2.5 2.5 0 1 1-1.06-1.06L13.22 1.72a.75.75 0 0 1 1.06 0ZM7 8a1 1 0 1 0 2 0 1 1 0 0 0-2 0Z"
      })
    }
  };
});
var MilestoneIcon = /*#__PURE__*/createIconComponent("MilestoneIcon", "octicon octicon-milestone", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.75 0a.75.75 0 0 1 .75.75V3h3.634c.414 0 .814.147 1.13.414l2.07 1.75a1.75 1.75 0 0 1 0 2.672l-2.07 1.75a1.75 1.75 0 0 1-1.13.414H8.5v5.25a.75.75 0 0 1-1.5 0V10H2.75A1.75 1.75 0 0 1 1 8.25v-3.5C1 3.784 1.784 3 2.75 3H7V.75A.75.75 0 0 1 7.75 0Zm4.384 8.5a.25.25 0 0 0 .161-.06l2.07-1.75a.248.248 0 0 0 0-.38l-2.07-1.75a.25.25 0 0 0-.161-.06H2.75a.25.25 0 0 0-.25.25v3.5c0 .138.112.25.25.25h9.384Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.75 1a.75.75 0 0 1 .75.75V4h6.532c.42 0 .826.15 1.143.425l3.187 2.75a1.75 1.75 0 0 1 0 2.65l-3.187 2.75a1.75 1.75 0 0 1-1.143.425H12.5v9.25a.75.75 0 0 1-1.5 0V13H3.75A1.75 1.75 0 0 1 2 11.25v-5.5C2 4.783 2.784 4 3.75 4H11V1.75a.75.75 0 0 1 .75-.75Zm7.282 4.5H3.75a.25.25 0 0 0-.25.25v5.5c0 .138.112.25.25.25h15.282c.06 0 .118-.021.163-.06l3.188-2.75a.248.248 0 0 0 0-.38l-3.188-2.75a.249.249 0 0 0-.163-.06Z"
      })
    }
  };
});
var MirrorIcon = /*#__PURE__*/createIconComponent("MirrorIcon", "octicon octicon-mirror", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.547 3.061A.75.75 0 0 1 16 3.75v8.5a.751.751 0 0 1-1.265.545l-4.5-4.25a.75.75 0 0 1 0-1.09l4.5-4.25a.75.75 0 0 1 .812-.144ZM0 12.25v-8.5a.751.751 0 0 1 1.265-.545l4.5 4.25a.75.75 0 0 1 0 1.09l-4.5 4.25A.75.75 0 0 1 0 12.25Zm1.5-6.76v5.02L4.158 8ZM11.842 8l2.658 2.51V5.49ZM8 4a.75.75 0 0 1 .75.75v.5a.75.75 0 0 1-1.5 0v-.5A.75.75 0 0 1 8 4Zm.75-2.25v.5a.75.75 0 0 1-1.5 0v-.5a.75.75 0 0 1 1.5 0Zm0 6v.5a.75.75 0 0 1-1.5 0v-.5a.75.75 0 0 1 1.5 0ZM8 10a.75.75 0 0 1 .75.75v.5a.75.75 0 0 1-1.5 0v-.5A.75.75 0 0 1 8 10Zm0 3a.75.75 0 0 1 .75.75v.5a.75.75 0 0 1-1.5 0v-.5A.75.75 0 0 1 8 13Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M21.553 6.064A.75.75 0 0 1 22 6.75v10.5a.75.75 0 0 1-1.256.554l-5.75-5.25a.748.748 0 0 1 0-1.108l5.75-5.25a.75.75 0 0 1 .809-.132ZM2.447 17.936A.75.75 0 0 1 2 17.25V6.75a.75.75 0 0 1 1.256-.554l5.75 5.25a.748.748 0 0 1 0 1.108l-5.75 5.25a.75.75 0 0 1-.809.132ZM7.387 12 3.5 8.45v7.1L7.388 12Zm9.226 0 3.887 3.55v-7.1L16.612 12ZM12 2.75a.75.75 0 0 1 .75.75v1a.75.75 0 0 1-1.5 0v-1a.75.75 0 0 1 .75-.75Zm0 4a.75.75 0 0 1 .75.75v1a.75.75 0 0 1-1.5 0v-1a.75.75 0 0 1 .75-.75Zm0 8a.75.75 0 0 1 .75.75v1a.75.75 0 0 1-1.5 0v-1a.75.75 0 0 1 .75-.75Zm0 4a.75.75 0 0 1 .75.75v1a.75.75 0 0 1-1.5 0v-1a.75.75 0 0 1 .75-.75Zm0-8a.75.75 0 0 1 .75.75v1a.75.75 0 0 1-1.5 0v-1a.75.75 0 0 1 .75-.75Z"
      })
    }
  };
});
var MoonIcon = /*#__PURE__*/createIconComponent("MoonIcon", "octicon octicon-moon", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.598 1.591a.749.749 0 0 1 .785-.175 7.001 7.001 0 1 1-8.967 8.967.75.75 0 0 1 .961-.96 5.5 5.5 0 0 0 7.046-7.046.75.75 0 0 1 .175-.786Zm1.616 1.945a7 7 0 0 1-7.678 7.678 5.499 5.499 0 1 0 7.678-7.678Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.768 3.96v.001l-.002-.005a9.08 9.08 0 0 0-.218-.779c-.13-.394.21-.8.602-.67.29.096.575.205.855.328l.01.005A10.002 10.002 0 0 1 12 22a10.002 10.002 0 0 1-9.162-5.985l-.004-.01a9.722 9.722 0 0 1-.329-.855c-.13-.392.277-.732.67-.602.257.084.517.157.78.218l.004.002A9 9 0 0 0 14.999 6a9.09 9.09 0 0 0-.231-2.04ZM16.5 6c0 5.799-4.701 10.5-10.5 10.5-.426 0-.847-.026-1.26-.075A8.5 8.5 0 1 0 16.425 4.74c.05.413.075.833.075 1.259Z"
      })
    }
  };
});
var MortarBoardIcon = /*#__PURE__*/createIconComponent("MortarBoardIcon", "octicon octicon-mortar-board", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.693 1.066a.747.747 0 0 1 .614 0l7.25 3.25a.75.75 0 0 1 0 1.368L13 6.831v2.794c0 1.024-.81 1.749-1.66 2.173-.893.447-2.075.702-3.34.702-.278 0-.55-.012-.816-.036a.75.75 0 0 1 .133-1.494c.22.02.45.03.683.03 1.082 0 2.025-.221 2.67-.543.69-.345.83-.682.83-.832V7.503L8.307 8.934a.747.747 0 0 1-.614 0L4 7.28v1.663c.296.105.575.275.812.512.438.438.688 1.059.688 1.796v3a.75.75 0 0 1-.75.75h-3a.75.75 0 0 1-.75-.75v-3c0-.737.25-1.358.688-1.796.237-.237.516-.407.812-.512V6.606L.443 5.684a.75.75 0 0 1 0-1.368ZM2.583 5 8 7.428 13.416 5 8 2.572ZM2.5 11.25v2.25H4v-2.25c0-.388-.125-.611-.25-.735a.697.697 0 0 0-.5-.203.707.707 0 0 0-.5.203c-.125.124-.25.347-.25.735Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.292 2.06v-.001l11.25 4.75a.749.749 0 0 1 0 1.382L19 10.108V15a.75.75 0 0 1-.11.391h-.001a2.84 2.84 0 0 1-.392.482c-.249.256-.625.58-1.163.896-1.08.638-2.776 1.23-5.334 1.23-.673 0-1.286-.041-1.846-.113a.75.75 0 0 1 .192-1.487c.492.063 1.042.1 1.654.1 2.317 0 3.746-.533 4.572-1.021.31-.178.596-.397.849-.65l.079-.085V10.74l-5.208 2.2a.75.75 0 0 1-.584 0L5.75 10.424v3.17c.502.129.96.391 1.327.758.579.578.923 1.41.923 2.428v4.5a.761.761 0 0 1-.345.634 2.157 2.157 0 0 1-.21.117 3.923 3.923 0 0 1-.52.213A6.121 6.121 0 0 1 5 22.532a6.092 6.092 0 0 1-1.925-.288 4.065 4.065 0 0 1-.52-.213 1.816 1.816 0 0 1-.22-.124.757.757 0 0 1-.335-.624v-4.5c0-1.02.344-1.85.923-2.43a2.904 2.904 0 0 1 1.327-.757V9.793L.458 8.19a.75.75 0 0 1 0-1.38l11.25-4.75a.75.75 0 0 1 .584 0ZM12 11.436 21.322 7.5 12 3.564 2.678 7.5ZM5 15c-.377 0-.745.141-1.017.413-.265.265-.483.7-.483 1.368v4.022c.299.105.797.228 1.5.228s1.201-.123 1.5-.228V16.78c0-.669-.218-1.103-.483-1.368A1.433 1.433 0 0 0 5 15Z"
      })
    }
  };
});
var MoveToBottomIcon = /*#__PURE__*/createIconComponent("MoveToBottomIcon", "octicon octicon-move-to-bottom", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.47 10.78a.749.749 0 0 0 1.06 0l3.75-3.75a.749.749 0 1 0-1.06-1.06L8.75 8.439V1.75a.75.75 0 0 0-1.5 0v6.689L4.78 5.97a.749.749 0 1 0-1.06 1.06l3.75 3.75ZM3.75 13a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 21.25a.75.75 0 0 1 .75-.75h14.5a.75.75 0 0 1 0 1.5H4.75a.75.75 0 0 1-.75-.75ZM5.22 9.97a.749.749 0 0 1 1.06 0l4.97 4.969V2.75a.75.75 0 0 1 1.5 0v12.189l4.97-4.969a.749.749 0 1 1 1.06 1.06l-6.25 6.25a.749.749 0 0 1-1.06 0l-6.25-6.25a.749.749 0 0 1 0-1.06Z"
      })
    }
  };
});
var MoveToEndIcon = /*#__PURE__*/createIconComponent("MoveToEndIcon", "octicon octicon-move-to-end", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m10.78 8.53-3.75 3.75a.749.749 0 1 1-1.06-1.06l2.469-2.47H1.75a.75.75 0 0 1 0-1.5h6.689L5.97 4.78a.749.749 0 1 1 1.06-1.06l3.75 3.75a.749.749 0 0 1 0 1.06ZM13 12.25v-8.5a.75.75 0 0 1 1.5 0v8.5a.75.75 0 0 1-1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.22 5.22a.749.749 0 0 1 1.06 0l6.25 6.25a.749.749 0 0 1 0 1.06l-6.25 6.25a.749.749 0 1 1-1.06-1.06l4.969-4.97H1.75a.75.75 0 0 1 0-1.5h14.439L11.22 6.28a.749.749 0 0 1 0-1.06Zm10.03-1.47a.75.75 0 0 1 .75.75v15a.75.75 0 0 1-1.5 0v-15a.75.75 0 0 1 .75-.75Z"
      })
    }
  };
});
var MoveToStartIcon = /*#__PURE__*/createIconComponent("MoveToStartIcon", "octicon octicon-move-to-start", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.22 7.47a.749.749 0 0 0 0 1.06l3.75 3.75a.749.749 0 1 0 1.06-1.06L7.561 8.75h6.689a.75.75 0 0 0 0-1.5H7.561l2.469-2.47a.749.749 0 1 0-1.06-1.06L5.22 7.47ZM3 3.75a.75.75 0 0 0-1.5 0v8.5a.75.75 0 0 0 1.5 0v-8.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.78 18.78a.749.749 0 0 1-1.06 0l-6.25-6.25a.749.749 0 0 1 0-1.06l6.25-6.25a.749.749 0 1 1 1.06 1.06l-4.969 4.97H22.25a.75.75 0 0 1 0 1.5H7.811l4.969 4.97a.749.749 0 0 1 0 1.06ZM2.75 3.75a.75.75 0 0 1 .75.75v15a.75.75 0 0 1-1.5 0v-15a.75.75 0 0 1 .75-.75Z"
      })
    }
  };
});
var MoveToTopIcon = /*#__PURE__*/createIconComponent("MoveToTopIcon", "octicon octicon-move-to-top", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 2.25a.75.75 0 0 1 .75-.75h8.5a.75.75 0 0 1 0 1.5h-8.5A.75.75 0 0 1 3 2.25Zm5.53 2.97 3.75 3.75a.749.749 0 1 1-1.06 1.06L8.75 7.561v6.689a.75.75 0 0 1-1.5 0V7.561L4.78 10.03a.749.749 0 1 1-1.06-1.06l3.75-3.75a.749.749 0 0 1 1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 3.5a.75.75 0 0 1 0-1.5h14.5a.75.75 0 0 1 0 1.5H4.75Zm.47 9.47a.749.749 0 1 0 1.06 1.06l4.97-4.969V21.25a.75.75 0 0 0 1.5 0V9.061l4.97 4.969a.749.749 0 1 0 1.06-1.06l-6.25-6.25a.749.749 0 0 0-1.06 0l-6.25 6.25Z"
      })
    }
  };
});
var MultiSelectIcon = /*#__PURE__*/createIconComponent("MultiSelectIcon", "octicon octicon-multi-select", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 7.5h7.5a.75.75 0 0 1 0 1.5h-7.5a.75.75 0 0 1 0-1.5Zm0 5h7.5a.75.75 0 0 1 0 1.5h-7.5a.75.75 0 0 1 0-1.5Zm-4-10h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1 0-1.5ZM2 14a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm1-6a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm10.314-3.082L11.07 2.417A.25.25 0 0 1 11.256 2h4.488a.25.25 0 0 1 .186.417l-2.244 2.5a.25.25 0 0 1-.372 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75 11.5h11.5a.75.75 0 0 1 0 1.5H8.75a.75.75 0 0 1 0-1.5Zm0 6h11.5a.75.75 0 0 1 0 1.5H8.75a.75.75 0 0 1 0-1.5Zm-5-12h10a.75.75 0 0 1 0 1.5h-10a.75.75 0 0 1 0-1.5ZM5 12a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 7a1 1 0 1 1 0-2 1 1 0 0 1 0 2ZM19.309 7.918l-2.245-2.501A.25.25 0 0 1 17.25 5h4.49a.25.25 0 0 1 .185.417l-2.244 2.5a.25.25 0 0 1-.372 0Z"
      })
    }
  };
});
var MuteIcon = /*#__PURE__*/createIconComponent("MuteIcon", "octicon octicon-mute", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 2.75v10.5a.751.751 0 0 1-1.238.57L3.473 11H1.75A1.75 1.75 0 0 1 0 9.25v-2.5C0 5.784.784 5 1.75 5h1.722l3.29-2.82A.75.75 0 0 1 8 2.75Zm3.28 2.47L13 6.94l1.72-1.72a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042L14.06 8l1.72 1.72a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L13 9.06l-1.72 1.72a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734L11.94 8l-1.72-1.72a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215Zm-7.042 1.1a.752.752 0 0 1-.488.18h-2a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25h2c.179 0 .352.064.488.18L6.5 11.62V4.38Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 3.75v16.5a.75.75 0 0 1-1.255.555L5.46 16H2.75A1.75 1.75 0 0 1 1 14.25v-4.5C1 8.784 1.784 8 2.75 8h2.71l5.285-4.805A.75.75 0 0 1 12 3.75ZM6.255 9.305a.748.748 0 0 1-.505.195h-3a.25.25 0 0 0-.25.25v4.5c0 .138.112.25.25.25h3c.187 0 .367.069.505.195l4.245 3.86V5.445ZM16.28 8.22a.75.75 0 1 0-1.06 1.06L17.94 12l-2.72 2.72a.75.75 0 1 0 1.06 1.06L19 13.06l2.72 2.72a.75.75 0 1 0 1.06-1.06L20.06 12l2.72-2.72a.75.75 0 0 0-1.06-1.06L19 10.94l-2.72-2.72Z"
      })
    }
  };
});
var NoEntryIcon = /*#__PURE__*/createIconComponent("NoEntryIcon", "octicon octicon-no-entry", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.25 7.25a.75.75 0 0 0 0 1.5h7.5a.75.75 0 0 0 0-1.5h-7.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0Zm-1.5 0a6.5 6.5 0 1 0-13 0 6.5 6.5 0 0 0 13 0Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Zm15.75.75H5.75a.75.75 0 0 1 0-1.5h12.5a.75.75 0 0 1 0 1.5Z"
      })
    }
  };
});
var NoEntryFillIcon = /*#__PURE__*/createIconComponent("NoEntryFillIcon", "octicon octicon-no-entry-fill", function () {
  return {
    "12": {
      "width": 12,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 0a6 6 0 1 1 0 12A6 6 0 0 1 6 0Zm3 5H3v2h6Z"
      })
    }
  };
});
var NorthStarIcon = /*#__PURE__*/createIconComponent("NorthStarIcon", "octicon octicon-north-star", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.5.75a.75.75 0 0 0-1.5 0v5.19L4.391 3.33a.75.75 0 1 0-1.06 1.061L5.939 7H.75a.75.75 0 0 0 0 1.5h5.19l-2.61 2.609a.75.75 0 1 0 1.061 1.06L7 9.561v5.189a.75.75 0 0 0 1.5 0V9.56l2.609 2.61a.75.75 0 1 0 1.06-1.061L9.561 8.5h5.189a.75.75 0 0 0 0-1.5H9.56l2.61-2.609a.75.75 0 0 0-1.061-1.06L8.5 5.939V.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.5 1.25a.75.75 0 0 0-1.5 0v8.69L6.447 5.385a.75.75 0 1 0-1.061 1.06L9.94 11H1.25a.75.75 0 0 0 0 1.5h8.69l-4.554 4.553a.75.75 0 0 0 1.06 1.061L11 13.561v8.689a.75.75 0 0 0 1.5 0v-8.69l4.553 4.554a.75.75 0 0 0 1.061-1.06L13.561 12.5h8.689a.75.75 0 0 0 0-1.5h-8.69l4.554-4.553a.75.75 0 1 0-1.06-1.061L12.5 9.939V1.25Z"
      })
    }
  };
});
var NoteIcon = /*#__PURE__*/createIconComponent("NoteIcon", "octicon octicon-note", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 3.75C0 2.784.784 2 1.75 2h12.5c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 14.25 14H1.75A1.75 1.75 0 0 1 0 12.25Zm1.75-.25a.25.25 0 0 0-.25.25v8.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25ZM3.5 6.25a.75.75 0 0 1 .75-.75h7a.75.75 0 0 1 0 1.5h-7a.75.75 0 0 1-.75-.75Zm.75 2.25h4a.75.75 0 0 1 0 1.5h-4a.75.75 0 0 1 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 4.75C0 3.784.784 3 1.75 3h20.5c.966 0 1.75.784 1.75 1.75v14.5A1.75 1.75 0 0 1 22.25 21H1.75A1.75 1.75 0 0 1 0 19.25Zm1.75-.25a.25.25 0 0 0-.25.25v14.5c0 .138.112.25.25.25h20.5a.25.25 0 0 0 .25-.25V4.75a.25.25 0 0 0-.25-.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 8.75A.75.75 0 0 1 5.75 8h11.5a.75.75 0 0 1 0 1.5H5.75A.75.75 0 0 1 5 8.75Zm0 4a.75.75 0 0 1 .75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.75.75 0 0 1-.75-.75Z"
      }))
    }
  };
});
var NumberIcon = /*#__PURE__*/createIconComponent("NumberIcon", "octicon octicon-number", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9 4.75A.75.75 0 0 1 9.75 4h4a.75.75 0 0 1 .53 1.28l-1.89 1.892c.312.076.604.18.867.319.742.391 1.244 1.063 1.244 2.005 0 .653-.231 1.208-.629 1.627-.386.408-.894.653-1.408.777-1.01.243-2.225.063-3.124-.527a.751.751 0 0 1 .822-1.254c.534.35 1.32.474 1.951.322.306-.073.53-.201.67-.349.129-.136.218-.32.218-.596 0-.308-.123-.509-.444-.678-.373-.197-.98-.318-1.806-.318a.75.75 0 0 1-.53-1.28l1.72-1.72H9.75A.75.75 0 0 1 9 4.75Zm-3.587 5.763c-.35-.05-.77.113-.983.572a.75.75 0 1 1-1.36-.632c.508-1.094 1.589-1.565 2.558-1.425 1 .145 1.872.945 1.872 2.222 0 1.433-1.088 2.192-1.79 2.681-.308.216-.571.397-.772.573H7a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1-.75-.75c0-.69.3-1.211.67-1.61.348-.372.8-.676 1.15-.92.8-.56 1.18-.904 1.18-1.474 0-.473-.267-.69-.587-.737ZM5.604.089A.75.75 0 0 1 6 .75v4.77h.711a.75.75 0 0 1 0 1.5H3.759a.75.75 0 0 1 0-1.5H4.5V2.15l-.334.223a.75.75 0 0 1-.832-1.248l1.5-1a.75.75 0 0 1 .77-.037Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.003 7.754a.75.75 0 0 1 .75-.75h5.232a.75.75 0 0 1 .53 1.28l-2.776 2.777c.55.097 1.057.253 1.492.483.905.477 1.504 1.284 1.504 2.418 0 .966-.471 1.75-1.172 2.27-.687.511-1.587.77-2.521.77-1.367 0-2.274-.528-2.667-.756a.75.75 0 0 1 .755-1.297c.331.193.953.553 1.912.553.673 0 1.243-.188 1.627-.473.37-.275.566-.635.566-1.067 0-.5-.219-.836-.703-1.091-.538-.284-1.375-.443-2.471-.443a.75.75 0 0 1-.53-1.28l2.643-2.644h-3.421a.75.75 0 0 1-.75-.75ZM7.88 15.215a1.4 1.4 0 0 0-1.446.83.75.75 0 0 1-1.37-.61 2.899 2.899 0 0 1 2.986-1.71c.589.06 1.139.323 1.557.743.434.446.685 1.058.685 1.778 0 1.641-1.254 2.437-2.12 2.986-.538.341-1.18.694-1.495 1.273H9.75a.75.75 0 0 1 0 1.5h-4a.75.75 0 0 1-.75-.75c0-1.799 1.337-2.63 2.243-3.21 1.032-.659 1.55-1.031 1.55-1.8 0-.355-.116-.584-.26-.732a1.071 1.071 0 0 0-.652-.298Zm.234-13.121a.75.75 0 0 1 .386.656V9h1.252a.75.75 0 0 1 0 1.5H5.75a.75.75 0 0 1 0-1.5H7V4.103l-.853.533a.749.749 0 1 1-.795-1.272l2-1.25a.749.749 0 0 1 .762-.02Z"
      })
    }
  };
});
var OrganizationIcon = /*#__PURE__*/createIconComponent("OrganizationIcon", "octicon octicon-organization", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 16A1.75 1.75 0 0 1 0 14.25V1.75C0 .784.784 0 1.75 0h8.5C11.216 0 12 .784 12 1.75v12.5c0 .085-.006.168-.018.25h2.268a.25.25 0 0 0 .25-.25V8.285a.25.25 0 0 0-.111-.208l-1.055-.703a.749.749 0 1 1 .832-1.248l1.055.703c.487.325.779.871.779 1.456v5.965A1.75 1.75 0 0 1 14.25 16h-3.5a.766.766 0 0 1-.197-.026c-.099.017-.2.026-.303.026h-3a.75.75 0 0 1-.75-.75V14h-1v1.25a.75.75 0 0 1-.75.75Zm-.25-1.75c0 .138.112.25.25.25H4v-1.25a.75.75 0 0 1 .75-.75h2.5a.75.75 0 0 1 .75.75v1.25h2.25a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25h-8.5a.25.25 0 0 0-.25.25ZM3.75 6h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1 0-1.5ZM3 3.75A.75.75 0 0 1 3.75 3h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 3 3.75Zm4 3A.75.75 0 0 1 7.75 6h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 7 6.75ZM7.75 3h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1 0-1.5ZM3 9.75A.75.75 0 0 1 3.75 9h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 3 9.75ZM7.75 9h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.25 12a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5ZM5.5 9.25a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1-.75-.75ZM6.25 5a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5ZM9 12.75a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1-.75-.75Zm.75-4.25a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5ZM9 5.75A.75.75 0 0 1 9.75 5h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 9 5.75ZM13.25 12a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5Zm-.75-2.75a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1-.75-.75ZM13.25 5a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 20V3a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v17c0 .173-.022.34-.063.5H20a.5.5 0 0 0 .5-.5v-8a.5.5 0 0 0-.2-.4l-.5-.375a.75.75 0 0 1 .9-1.2l.5.375c.504.378.8.97.8 1.6v8a2 2 0 0 1-2 2h-3.562a.767.767 0 0 1-.166-.018c-.089.012-.18.018-.272.018h-3.75a.75.75 0 0 1-.75-.75V19h-3v2.25a.75.75 0 0 1-.75.75H4a2 2 0 0 1-2-2Zm2 .5h3v-2.25a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 .75.75v2.25h3a.5.5 0 0 0 .5-.5V3a.5.5 0 0 0-.5-.5H4a.5.5 0 0 0-.5.5v17a.5.5 0 0 0 .5.5Z"
      }))
    }
  };
});
var PackageIcon = /*#__PURE__*/createIconComponent("PackageIcon", "octicon octicon-package", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m8.878.392 5.25 3.045c.54.314.872.89.872 1.514v6.098a1.75 1.75 0 0 1-.872 1.514l-5.25 3.045a1.75 1.75 0 0 1-1.756 0l-5.25-3.045A1.75 1.75 0 0 1 1 11.049V4.951c0-.624.332-1.201.872-1.514L7.122.392a1.75 1.75 0 0 1 1.756 0ZM7.875 1.69l-4.63 2.685L8 7.133l4.755-2.758-4.63-2.685a.248.248 0 0 0-.25 0ZM2.5 5.677v5.372c0 .09.047.171.125.216l4.625 2.683V8.432Zm6.25 8.271 4.625-2.683a.25.25 0 0 0 .125-.216V5.677L8.75 8.432Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.876.64V.639l8.25 4.763c.541.313.875.89.875 1.515v9.525a1.75 1.75 0 0 1-.875 1.516l-8.25 4.762a1.748 1.748 0 0 1-1.75 0l-8.25-4.763a1.75 1.75 0 0 1-.875-1.515V6.917c0-.625.334-1.202.875-1.515L11.126.64a1.748 1.748 0 0 1 1.75 0Zm-1 1.298L4.251 6.34l7.75 4.474 7.75-4.474-7.625-4.402a.248.248 0 0 0-.25 0Zm.875 19.123 7.625-4.402a.25.25 0 0 0 .125-.216V7.639l-7.75 4.474ZM3.501 7.64v8.803c0 .09.048.172.125.216l7.625 4.402v-8.947Z"
      })
    }
  };
});
var PackageDependenciesIcon = /*#__PURE__*/createIconComponent("PackageDependenciesIcon", "octicon octicon-package-dependencies", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.122.392a1.75 1.75 0 0 1 1.756 0l5.25 3.045c.54.313.872.89.872 1.514V7.25a.75.75 0 0 1-1.5 0V5.677L7.75 8.432v6.384a1 1 0 0 1-1.502.865L.872 12.563A1.75 1.75 0 0 1 0 11.049V4.951c0-.624.332-1.2.872-1.514ZM7.125 1.69a.248.248 0 0 0-.25 0l-4.63 2.685L7 7.133l4.755-2.758ZM1.5 11.049a.25.25 0 0 0 .125.216l4.625 2.683V8.432L1.5 5.677Zm11.672-.282L11.999 12h3.251a.75.75 0 0 1 0 1.5h-3.251l1.173 1.233a.75.75 0 1 1-1.087 1.034l-2.378-2.5a.75.75 0 0 1 0-1.034l2.378-2.5a.75.75 0 0 1 1.087 1.034Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.126.64a1.748 1.748 0 0 1 1.75 0l8.25 4.762c.103.06.199.128.286.206a.75.75 0 0 1 .554.96c.023.113.035.23.035.35v3.332a.75.75 0 0 1-1.5 0V7.64l-7.75 4.474V22.36a.75.75 0 0 1-1.125.65l-8.75-5.052a1.75 1.75 0 0 1-.875-1.515V6.917c0-.119.012-.236.035-.35a.749.749 0 0 1 .554-.96c.088-.078.184-.146.286-.205L9.126.639Zm.875 10.173v.001l7.75-4.474-7.625-4.402a.248.248 0 0 0-.25 0L2.251 6.34Zm-8.5-3.175v8.803c0 .09.048.172.125.216l7.625 4.402v-8.947Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m16.617 17.5 2.895-2.702a.75.75 0 0 0-1.024-1.096l-4.285 4a.75.75 0 0 0 0 1.096l4.285 4a.75.75 0 1 0 1.024-1.096L16.617 19h6.633a.75.75 0 0 0 0-1.5h-6.633Z"
      }))
    }
  };
});
var PackageDependentsIcon = /*#__PURE__*/createIconComponent("PackageDependentsIcon", "octicon octicon-package-dependents", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.122.392a1.75 1.75 0 0 1 1.756 0l5.25 3.045c.54.313.872.89.872 1.514V7.25a.75.75 0 0 1-1.5 0V5.677L7.75 8.432v6.384a1 1 0 0 1-1.502.865L.872 12.563A1.75 1.75 0 0 1 0 11.049V4.951c0-.624.332-1.2.872-1.514ZM7.125 1.69a.248.248 0 0 0-.25 0l-4.63 2.685L7 7.133l4.755-2.758ZM1.5 11.049a.25.25 0 0 0 .125.216l4.625 2.683V8.432L1.5 5.677Zm10.828 3.684 1.173-1.233H10.25a.75.75 0 0 1 0-1.5h3.251l-1.173-1.233a.75.75 0 1 1 1.087-1.034l2.378 2.5a.75.75 0 0 1 0 1.034l-2.378 2.5a.75.75 0 0 1-1.087-1.034Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.126.64a1.748 1.748 0 0 1 1.75 0l8.25 4.762c.103.06.199.128.286.206a.75.75 0 0 1 .554.96c.023.113.035.23.035.35v3.332a.75.75 0 0 1-1.5 0V7.64l-7.75 4.474V22.36a.75.75 0 0 1-1.125.65l-8.75-5.052a1.75 1.75 0 0 1-.875-1.515V6.917c0-.119.012-.236.035-.35a.749.749 0 0 1 .554-.96c.088-.078.184-.146.286-.205L9.126.639Zm.875 10.173v.001l7.75-4.474-7.625-4.402a.248.248 0 0 0-.25 0L2.251 6.34Zm-8.5-3.175v8.803c0 .09.048.172.125.216l7.625 4.402v-8.947Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m21.347 17.5-2.894-2.702a.75.75 0 1 1 1.023-1.096l4.286 4a.75.75 0 0 1 0 1.096l-4.286 4a.75.75 0 1 1-1.023-1.096L21.347 19h-6.633a.75.75 0 0 1 0-1.5h6.633Z"
      }))
    }
  };
});
var PaintbrushIcon = /*#__PURE__*/createIconComponent("PaintbrushIcon", "octicon octicon-paintbrush", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.134 1.535c.7-.509 1.416-.942 2.076-1.155.649-.21 1.463-.267 2.069.34.603.601.568 1.411.368 2.07-.202.668-.624 1.39-1.125 2.096-1.011 1.424-2.496 2.987-3.775 4.249-1.098 1.084-2.132 1.839-3.04 2.3a3.744 3.744 0 0 1-1.055 3.217c-.431.431-1.065.691-1.657.861-.614.177-1.294.287-1.914.357A21.151 21.151 0 0 1 .797 16H.743l.007-.75H.749L.742 16a.75.75 0 0 1-.743-.742l.743-.008-.742.007v-.054a21.25 21.25 0 0 1 .13-2.284c.067-.647.187-1.287.358-1.914.17-.591.43-1.226.86-1.657a3.746 3.746 0 0 1 3.227-1.054c.466-.893 1.225-1.907 2.314-2.982 1.271-1.255 2.833-2.75 4.245-3.777ZM1.62 13.089c-.051.464-.086.929-.104 1.395.466-.018.932-.053 1.396-.104a10.511 10.511 0 0 0 1.668-.309c.526-.151.856-.325 1.011-.48a2.25 2.25 0 1 0-3.182-3.182c-.155.155-.329.485-.48 1.01a10.515 10.515 0 0 0-.309 1.67Zm10.396-10.34c-1.224.89-2.605 2.189-3.822 3.384l1.718 1.718c1.21-1.205 2.51-2.597 3.387-3.833.47-.662.78-1.227.912-1.662.134-.444.032-.551.009-.575h-.001V1.78c-.014-.014-.113-.113-.548.027-.432.14-.995.462-1.655.942Zm-4.832 7.266-.001.001a9.859 9.859 0 0 0 1.63-1.142L7.155 7.216a9.7 9.7 0 0 0-1.161 1.607c.482.302.889.71 1.19 1.192Z"
      })
    }
  };
});
var PaperAirplaneIcon = /*#__PURE__*/createIconComponent("PaperAirplaneIcon", "octicon octicon-paper-airplane", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M.989 8 .064 2.68a1.342 1.342 0 0 1 1.85-1.462l13.402 5.744a1.13 1.13 0 0 1 0 2.076L1.913 14.782a1.343 1.343 0 0 1-1.85-1.463L.99 8Zm.603-5.288L2.38 7.25h4.87a.75.75 0 0 1 0 1.5H2.38l-.788 4.538L13.929 8Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.513 1.96a1.374 1.374 0 0 1 1.499-.21l19.335 9.215a1.147 1.147 0 0 1 0 2.07L3.012 22.25a1.374 1.374 0 0 1-1.947-1.46L2.49 12 1.065 3.21a1.375 1.375 0 0 1 .448-1.25Zm2.375 10.79-1.304 8.042L21.031 12 2.584 3.208l1.304 8.042h7.362a.75.75 0 0 1 0 1.5Z"
      })
    }
  };
});
var PaperclipIcon = /*#__PURE__*/createIconComponent("PaperclipIcon", "octicon octicon-paperclip", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.212 3.02a1.753 1.753 0 0 0-2.478.003l-5.83 5.83a3.007 3.007 0 0 0-.88 2.127c0 .795.315 1.551.88 2.116.567.567 1.333.89 2.126.89.79 0 1.548-.321 2.116-.89l5.48-5.48a.75.75 0 0 1 1.061 1.06l-5.48 5.48a4.492 4.492 0 0 1-3.177 1.33c-1.2 0-2.345-.487-3.187-1.33a4.483 4.483 0 0 1-1.32-3.177c0-1.195.475-2.341 1.32-3.186l5.83-5.83a3.25 3.25 0 0 1 5.553 2.297c0 .863-.343 1.691-.953 2.301L7.439 12.39c-.375.377-.884.59-1.416.593a1.998 1.998 0 0 1-1.412-.593 1.992 1.992 0 0 1 0-2.828l5.48-5.48a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042l-5.48 5.48a.492.492 0 0 0 0 .707.499.499 0 0 0 .352.154.51.51 0 0 0 .356-.154l5.833-5.827a1.755 1.755 0 0 0 0-2.481Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M19.187 3.588a2.75 2.75 0 0 0-3.889 0L5.575 13.31a4.5 4.5 0 0 0 6.364 6.364l8.662-8.662a.75.75 0 0 1 1.061 1.06L13 20.735a6 6 0 0 1-8.485-8.485l9.723-9.723a4.247 4.247 0 0 1 4.124-1.139 4.247 4.247 0 0 1 3.025 3.025 4.247 4.247 0 0 1-1.139 4.124l-9.193 9.193a2.64 2.64 0 0 1-1.858.779 2.626 2.626 0 0 1-1.854-.779c-.196-.196-.338-.47-.43-.726a2.822 2.822 0 0 1-.168-.946c0-.7.284-1.373.775-1.864l8.132-8.131a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734l-8.131 8.132a1.148 1.148 0 0 0-.336.803c.003.204.053.405.146.587.01.018.018.028.02.032.22.215.501.332.786.332.29 0 .58-.121.798-.34l9.192-9.192a2.75 2.75 0 0 0 0-3.89Z"
      })
    }
  };
});
var PasskeyFillIcon = /*#__PURE__*/createIconComponent("PasskeyFillIcon", "octicon octicon-passkey-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.743 4.757a3.757 3.757 0 1 1 5.851 3.119 5.991 5.991 0 0 1 2.15 1.383c.17.17.257.405.258.646.003.598.001 1.197 0 1.795L11 12.778v.721a.5.5 0 0 1-.5.5H1.221a.749.749 0 0 1-.714-.784 6.004 6.004 0 0 1 3.899-5.339 3.754 3.754 0 0 1-1.663-3.119Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.75 6.875c0 .874-.448 1.643-1.127 2.09a.265.265 0 0 0-.123.22v.59c0 .067-.026.13-.073.177l-.356.356a.125.125 0 0 0 0 .177l.356.356c.047.047.073.11.073.176v.231c0 .067-.026.13-.073.177l-.356.356a.125.125 0 0 0 0 .177l.356.356c.047.047.073.11.073.177v.287a.247.247 0 0 1-.065.168l-.8.88a.52.52 0 0 1-.77 0l-.8-.88a.247.247 0 0 1-.065-.168V9.185a.264.264 0 0 0-.123-.22 2.5 2.5 0 1 1 3.873-2.09ZM14 6.5a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.496 2a5.25 5.25 0 0 0-2.519 9.857A9.006 9.006 0 0 0 .5 20.228a.751.751 0 0 0 .728.772h5.257c3.338.001 6.677.002 10.015 0a.5.5 0 0 0 .5-.5v-4.669a.95.95 0 0 0-.171-.551 9.02 9.02 0 0 0-4.814-3.423A5.25 5.25 0 0 0 9.496 2Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M23.625 10.313c0 1.31-.672 2.464-1.691 3.134a.398.398 0 0 0-.184.33v.886a.372.372 0 0 1-.11.265l-.534.534a.188.188 0 0 0 0 .265l.534.534c.071.07.11.166.11.265v.347a.374.374 0 0 1-.11.265l-.534.534a.188.188 0 0 0 0 .265l.534.534a.37.37 0 0 1 .11.265v.431a.379.379 0 0 1-.097.253l-1.2 1.319a.781.781 0 0 1-1.156 0l-1.2-1.319a.379.379 0 0 1-.097-.253v-5.39a.398.398 0 0 0-.184-.33 3.75 3.75 0 1 1 5.809-3.134ZM21 9.75a1.125 1.125 0 1 0-2.25 0 1.125 1.125 0 0 0 2.25 0Z"
      }))
    }
  };
});
var PasteIcon = /*#__PURE__*/createIconComponent("PasteIcon", "octicon octicon-paste", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.626 3.533a.249.249 0 0 0-.126.217v9.5c0 .138.112.25.25.25h8.5a.25.25 0 0 0 .25-.25v-9.5a.249.249 0 0 0-.126-.217.75.75 0 0 1 .752-1.298c.541.313.874.89.874 1.515v9.5A1.75 1.75 0 0 1 12.25 15h-8.5A1.75 1.75 0 0 1 2 13.25v-9.5c0-.625.333-1.202.874-1.515a.75.75 0 0 1 .752 1.298ZM5.75 1h4.5a.75.75 0 0 1 .75.75v3a.75.75 0 0 1-.75.75h-4.5A.75.75 0 0 1 5 4.75v-3A.75.75 0 0 1 5.75 1Zm.75 3h3V2.5h-3Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.962 2.513a.75.75 0 0 1-.475.949l-.816.272a.25.25 0 0 0-.171.237V21.25c0 .138.112.25.25.25h14.5a.25.25 0 0 0 .25-.25V3.97a.25.25 0 0 0-.17-.236l-.817-.272a.75.75 0 0 1 .474-1.424l.816.273A1.751 1.751 0 0 1 21 3.97v17.28A1.75 1.75 0 0 1 19.25 23H4.75A1.75 1.75 0 0 1 3 21.25V3.97a1.75 1.75 0 0 1 1.197-1.66l.816-.272a.75.75 0 0 1 .949.475Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7 1.75C7 .784 7.784 0 8.75 0h6.5C16.216 0 17 .784 17 1.75v1.5A1.75 1.75 0 0 1 15.25 5h-6.5A1.75 1.75 0 0 1 7 3.25Zm1.75-.25a.25.25 0 0 0-.25.25v1.5c0 .138.112.25.25.25h6.5a.25.25 0 0 0 .25-.25v-1.5a.25.25 0 0 0-.25-.25Z"
      }))
    }
  };
});
var PencilIcon = /*#__PURE__*/createIconComponent("PencilIcon", "octicon octicon-pencil", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.013 1.427a1.75 1.75 0 0 1 2.474 0l1.086 1.086a1.75 1.75 0 0 1 0 2.474l-8.61 8.61c-.21.21-.47.364-.756.445l-3.251.93a.75.75 0 0 1-.927-.928l.929-3.25c.081-.286.235-.547.445-.758l8.61-8.61Zm.176 4.823L9.75 4.81l-6.286 6.287a.253.253 0 0 0-.064.108l-.558 1.953 1.953-.558a.253.253 0 0 0 .108-.064Zm1.238-3.763a.25.25 0 0 0-.354 0L10.811 3.75l1.439 1.44 1.263-1.263a.25.25 0 0 0 0-.354Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M17.263 2.177a1.75 1.75 0 0 1 2.474 0l2.586 2.586a1.75 1.75 0 0 1 0 2.474L19.53 10.03l-.012.013L8.69 20.378a1.753 1.753 0 0 1-.699.409l-5.523 1.68a.748.748 0 0 1-.747-.188.748.748 0 0 1-.188-.747l1.673-5.5a1.75 1.75 0 0 1 .466-.756L14.476 4.963ZM4.708 16.361a.26.26 0 0 0-.067.108l-1.264 4.154 4.177-1.271a.253.253 0 0 0 .1-.059l10.273-9.806-2.94-2.939-10.279 9.813ZM19 8.44l2.263-2.262a.25.25 0 0 0 0-.354l-2.586-2.586a.25.25 0 0 0-.354 0L16.061 5.5Z"
      })
    }
  };
});
var PeopleIcon = /*#__PURE__*/createIconComponent("PeopleIcon", "octicon octicon-people", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 5.5a3.5 3.5 0 1 1 5.898 2.549 5.508 5.508 0 0 1 3.034 4.084.75.75 0 1 1-1.482.235 4 4 0 0 0-7.9 0 .75.75 0 0 1-1.482-.236A5.507 5.507 0 0 1 3.102 8.05 3.493 3.493 0 0 1 2 5.5ZM11 4a3.001 3.001 0 0 1 2.22 5.018 5.01 5.01 0 0 1 2.56 3.012.749.749 0 0 1-.885.954.752.752 0 0 1-.549-.514 3.507 3.507 0 0 0-2.522-2.372.75.75 0 0 1-.574-.73v-.352a.75.75 0 0 1 .416-.672A1.5 1.5 0 0 0 11 5.5.75.75 0 0 1 11 4Zm-5.5-.5a2 2 0 1 0-.001 3.999A2 2 0 0 0 5.5 3.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.5 8a5.5 5.5 0 1 1 8.596 4.547 9.005 9.005 0 0 1 5.9 8.18.751.751 0 0 1-1.5.045 7.5 7.5 0 0 0-14.993 0 .75.75 0 0 1-1.499-.044 9.005 9.005 0 0 1 5.9-8.181A5.496 5.496 0 0 1 3.5 8ZM9 4a4 4 0 1 0 0 8 4 4 0 0 0 0-8Zm8.29 4c-.148 0-.292.01-.434.03a.75.75 0 1 1-.212-1.484 4.53 4.53 0 0 1 3.38 8.097 6.69 6.69 0 0 1 3.956 6.107.75.75 0 0 1-1.5 0 5.193 5.193 0 0 0-3.696-4.972l-.534-.16v-1.676l.41-.209A3.03 3.03 0 0 0 17.29 8Z"
      })
    }
  };
});
var PersonIcon = /*#__PURE__*/createIconComponent("PersonIcon", "octicon octicon-person", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.561 8.073a6.005 6.005 0 0 1 3.432 5.142.75.75 0 1 1-1.498.07 4.5 4.5 0 0 0-8.99 0 .75.75 0 0 1-1.498-.07 6.004 6.004 0 0 1 3.431-5.142 3.999 3.999 0 1 1 5.123 0ZM10.5 5a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 2.5a5.5 5.5 0 0 1 3.096 10.047 9.005 9.005 0 0 1 5.9 8.181.75.75 0 1 1-1.499.044 7.5 7.5 0 0 0-14.993 0 .75.75 0 0 1-1.5-.045 9.005 9.005 0 0 1 5.9-8.18A5.5 5.5 0 0 1 12 2.5ZM8 8a4 4 0 1 0 8 0 4 4 0 0 0-8 0Z"
      })
    }
  };
});
var PersonAddIcon = /*#__PURE__*/createIconComponent("PersonAddIcon", "octicon octicon-person-add", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.9 8.548h-.001a5.528 5.528 0 0 1 3.1 4.659.75.75 0 1 1-1.498.086A4.01 4.01 0 0 0 5.5 9.5a4.01 4.01 0 0 0-4.001 3.793.75.75 0 1 1-1.498-.085 5.527 5.527 0 0 1 3.1-4.66 3.5 3.5 0 1 1 4.799 0ZM13.25 0a.75.75 0 0 1 .75.75V2h1.25a.75.75 0 0 1 0 1.5H14v1.25a.75.75 0 0 1-1.5 0V3.5h-1.25a.75.75 0 0 1 0-1.5h1.25V.75a.75.75 0 0 1 .75-.75ZM5.5 4a2 2 0 1 0-.001 3.999A2 2 0 0 0 5.5 4Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 9.5a5 5 0 1 1 7.916 4.062 7.973 7.973 0 0 1 5.018 7.166.75.75 0 1 1-1.499.044 6.469 6.469 0 0 0-12.932 0 .75.75 0 0 1-1.499-.044 7.972 7.972 0 0 1 5.059-7.181A4.994 4.994 0 0 1 4 9.5ZM9 6a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7Zm10.25-5a.75.75 0 0 1 .75.75V4h2.25a.75.75 0 0 1 0 1.5H20v2.25a.75.75 0 0 1-1.5 0V5.5h-2.25a.75.75 0 0 1 0-1.5h2.25V1.75a.75.75 0 0 1 .75-.75Z"
      })
    }
  };
});
var PersonFillIcon = /*#__PURE__*/createIconComponent("PersonFillIcon", "octicon octicon-person-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.243 4.757a3.757 3.757 0 1 1 5.851 3.119 6.006 6.006 0 0 1 3.9 5.339.75.75 0 0 1-.715.784H2.721a.75.75 0 0 1-.714-.784 6.006 6.006 0 0 1 3.9-5.34 3.753 3.753 0 0 1-1.664-3.118Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 2.5a5.25 5.25 0 0 0-2.519 9.857 9.005 9.005 0 0 0-6.477 8.37.75.75 0 0 0 .727.773H20.27a.75.75 0 0 0 .727-.772 9.005 9.005 0 0 0-6.477-8.37A5.25 5.25 0 0 0 12 2.5Z"
      })
    }
  };
});
var PinIcon = /*#__PURE__*/createIconComponent("PinIcon", "octicon octicon-pin", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m11.294.984 3.722 3.722a1.75 1.75 0 0 1-.504 2.826l-1.327.613a3.089 3.089 0 0 0-1.707 2.084l-.584 2.454c-.317 1.332-1.972 1.8-2.94.832L5.75 11.311 1.78 15.28a.749.749 0 1 1-1.06-1.06l3.969-3.97-2.204-2.204c-.968-.968-.5-2.623.832-2.94l2.454-.584a3.08 3.08 0 0 0 2.084-1.707l.613-1.327a1.75 1.75 0 0 1 2.826-.504ZM6.283 9.723l2.732 2.731a.25.25 0 0 0 .42-.119l.584-2.454a4.586 4.586 0 0 1 2.537-3.098l1.328-.613a.25.25 0 0 0 .072-.404l-3.722-3.722a.25.25 0 0 0-.404.072l-.613 1.328a4.584 4.584 0 0 1-3.098 2.537l-2.454.584a.25.25 0 0 0-.119.42l2.731 2.732Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m16.114 1.553 6.333 6.333a1.75 1.75 0 0 1-.603 2.869l-1.63.633a5.67 5.67 0 0 0-3.395 3.725l-1.131 3.959a1.75 1.75 0 0 1-2.92.757L9 16.061l-5.595 5.594a.749.749 0 1 1-1.06-1.06L7.939 15l-3.768-3.768a1.75 1.75 0 0 1 .757-2.92l3.959-1.131a5.666 5.666 0 0 0 3.725-3.395l.633-1.63a1.75 1.75 0 0 1 2.869-.603ZM5.232 10.171l8.597 8.597a.25.25 0 0 0 .417-.108l1.131-3.959A7.17 7.17 0 0 1 19.67 9.99l1.63-.634a.25.25 0 0 0 .086-.409l-6.333-6.333a.25.25 0 0 0-.409.086l-.634 1.63a7.17 7.17 0 0 1-4.711 4.293L5.34 9.754a.25.25 0 0 0-.108.417Z"
      })
    }
  };
});
var PinSlashIcon = /*#__PURE__*/createIconComponent("PinSlashIcon", "octicon octicon-pin-slash", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m1.655.595 13.75 13.75q.22.219.22.53 0 .311-.22.53-.219.22-.53.22-.311 0-.53-.22L.595 1.655q-.22-.219-.22-.53 0-.311.22-.53.219-.22.53-.22.311 0 .53.22ZM.72 14.22l4.5-4.5q.219-.22.53-.22.311 0 .53.22.22.219.22.53 0 .311-.22.53l-4.5 4.5q-.219.22-.53.22-.311 0-.53-.22-.22-.219-.22-.53 0-.311.22-.53Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m5.424 6.146-1.759.419q-.143.034-.183.175-.04.141.064.245l5.469 5.469q.104.104.245.064.141-.04.175-.183l.359-1.509q.072-.302.337-.465.264-.163.567-.091.302.072.465.337.162.264.09.567l-.359 1.509q-.238.999-1.226 1.278-.988.28-1.714-.446L2.485 8.046q-.726-.726-.446-1.714.279-.988 1.278-1.226l1.759-.419q.303-.072.567.091.265.163.337.465.072.302-.091.567-.163.264-.465.336ZM7.47 3.47q.155-.156.247-.355l.751-1.627Q8.851.659 9.75.498q.899-.16 1.544.486l3.722 3.722q.646.645.486 1.544-.161.899-.99 1.282l-1.627.751q-.199.092-.355.247-.219.22-.53.22-.311 0-.53-.22-.22-.219-.22-.53 0-.311.22-.53.344-.345.787-.549l1.627-.751q.118-.055.141-.183.023-.128-.069-.221l-3.722-3.722q-.092-.092-.221-.069-.128.023-.183.141l-.751 1.627q-.204.443-.549.787-.219.22-.53.22-.311 0-.53-.22-.22-.219-.22-.53 0-.311.22-.53Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.345 20.595 8.47 14.47q.219-.22.53-.22.311 0 .53.22.22.219.22.53 0 .311-.22.53l-6.125 6.125q-.219.22-.53.22-.311 0-.53-.22-.22-.219-.22-.53 0-.311.22-.53Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m16.72 11.97.358-.358a6.738 6.738 0 0 1 2.326-1.518l1.896-.738a.25.25 0 0 0 .086-.409l-6.333-6.333a.25.25 0 0 0-.409.086l-.521 1.34a8.663 8.663 0 0 1-2.243 3.265.75.75 0 0 1-1.01-1.11 7.132 7.132 0 0 0 1.854-2.699l.521-1.34a1.75 1.75 0 0 1 2.869-.603l6.333 6.333a1.75 1.75 0 0 1-.603 2.869l-1.896.737a5.26 5.26 0 0 0-1.81 1.18l-.358.358a.749.749 0 1 1-1.06-1.06Zm-12.549-.738a1.75 1.75 0 0 1 .757-2.92l3.366-.962.412 1.443-3.366.961a.25.25 0 0 0-.108.417l8.597 8.597a.25.25 0 0 0 .417-.108l.961-3.366 1.443.412-.962 3.366a1.75 1.75 0 0 1-2.92.757Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m3.405 2.095 18.75 18.75q.22.219.22.53 0 .311-.22.53-.219.22-.53.22-.311 0-.53-.22L2.345 3.155q-.22-.219-.22-.53 0-.311.22-.53.219-.22.53-.22.311 0 .53.22Z"
      }))
    }
  };
});
var PivotColumnIcon = /*#__PURE__*/createIconComponent("PivotColumnIcon", "octicon octicon-pivot-column", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 1.75C0 .784.784 0 1.75 0h12.5C15.217 0 16 .784 16 1.75v5.5a.75.75 0 0 1-1.5 0V6.5h-8v8h.75a.75.75 0 0 1 0 1.5h-5.5A1.75 1.75 0 0 1 0 14.25ZM1.5 6.5v7.75c0 .138.112.25.25.25H5v-8Zm5-1.5h8V1.75a.25.25 0 0 0-.25-.25H6.5ZM5 5V1.5H1.75a.25.25 0 0 0-.25.25V5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m11.017 9.89-2.882 2.677a.249.249 0 0 0 0 .366l2.882 2.677a.25.25 0 0 0 .421-.183V13.5H12.5A3.5 3.5 0 0 0 16 10a.75.75 0 0 0-1.5 0 2 2 0 0 1-2 2h-1.062v-1.927a.25.25 0 0 0-.421-.183Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 3.75C2 2.783 2.783 2 3.75 2h16.5c.966 0 1.75.783 1.75 1.75V10a.75.75 0 0 1-1.5 0V8.75H8.75V20.5H10a.75.75 0 0 1 0 1.5H3.75A1.75 1.75 0 0 1 2 20.25Zm6.75-.25v3.75H20.5v-3.5a.25.25 0 0 0-.25-.25Zm-1.5 17V8.75H3.5v11.5c0 .138.112.25.25.25ZM3.5 7.25h3.75V3.5h-3.5a.25.25 0 0 0-.25.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M21.25 12.312a.75.75 0 0 1 .75.75v2.626a3.75 3.75 0 0 1-3.75 3.75h-3.502l2.032 2.032a.749.749 0 1 1-1.06 1.06l-3.25-3.25a.749.749 0 0 1 0-1.06l3.25-3.25a.749.749 0 1 1 1.06 1.06l-1.907 1.908h3.377a2.25 2.25 0 0 0 2.25-2.25v-2.626a.75.75 0 0 1 .75-.75Z"
      }))
    }
  };
});
var PlayIcon = /*#__PURE__*/createIconComponent("PlayIcon", "octicon octicon-play", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0ZM1.5 8a6.5 6.5 0 1 0 13 0 6.5 6.5 0 0 0-13 0Zm4.879-2.773 4.264 2.559a.25.25 0 0 1 0 .428l-4.264 2.559A.25.25 0 0 1 6 10.559V5.442a.25.25 0 0 1 .379-.215Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.5 15.584V8.416a.5.5 0 0 1 .77-.42l5.576 3.583a.5.5 0 0 1 0 .842l-5.576 3.584a.5.5 0 0 1-.77-.42Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 12C1 5.925 5.925 1 12 1s11 4.925 11 11-4.925 11-11 11S1 18.075 1 12Zm11-9.5A9.5 9.5 0 0 0 2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5Z"
      }))
    }
  };
});
var PlugIcon = /*#__PURE__*/createIconComponent("PlugIcon", "octicon octicon-plug", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 8H2.5a1 1 0 0 0-1 1v5.25a.75.75 0 0 1-1.5 0V9a2.5 2.5 0 0 1 2.5-2.5H4V5.133a1.75 1.75 0 0 1 1.533-1.737l2.831-.353.76-.913c.332-.4.825-.63 1.344-.63h.782c.966 0 1.75.784 1.75 1.75V4h2.25a.75.75 0 0 1 0 1.5H13v4h2.25a.75.75 0 0 1 0 1.5H13v.75a1.75 1.75 0 0 1-1.75 1.75h-.782c-.519 0-1.012-.23-1.344-.63l-.761-.912-2.83-.354A1.75 1.75 0 0 1 4 9.867Zm6.276-4.91-.95 1.14a.753.753 0 0 1-.483.265l-3.124.39a.25.25 0 0 0-.219.248v4.734c0 .126.094.233.219.249l3.124.39a.752.752 0 0 1 .483.264l.95 1.14a.25.25 0 0 0 .192.09h.782a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25h-.782a.25.25 0 0 0-.192.09Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7 11.5H2.938c-.794 0-1.438.644-1.438 1.437v8.313a.75.75 0 0 1-1.5 0v-8.312A2.939 2.939 0 0 1 2.937 10H7V6.151c0-.897.678-1.648 1.57-1.74l6.055-.626 1.006-1.174A1.752 1.752 0 0 1 16.96 2h1.29c.966 0 1.75.784 1.75 1.75V6h3.25a.75.75 0 0 1 0 1.5H20V14h3.25a.75.75 0 0 1 0 1.5H20v2.25a1.75 1.75 0 0 1-1.75 1.75h-1.29a1.75 1.75 0 0 1-1.329-.611l-1.006-1.174-6.055-.627A1.749 1.749 0 0 1 7 15.348Zm9.77-7.913v.001l-1.201 1.4a.75.75 0 0 1-.492.258l-6.353.657a.25.25 0 0 0-.224.249v9.196a.25.25 0 0 0 .224.249l6.353.657c.191.02.368.112.493.258l1.2 1.401a.252.252 0 0 0 .19.087h1.29a.25.25 0 0 0 .25-.25v-14a.25.25 0 0 0-.25-.25h-1.29a.252.252 0 0 0-.19.087Z"
      })
    }
  };
});
var PlusIcon = /*#__PURE__*/createIconComponent("PlusIcon", "octicon octicon-plus", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.75 2a.75.75 0 0 1 .75.75V7h4.25a.75.75 0 0 1 0 1.5H8.5v4.25a.75.75 0 0 1-1.5 0V8.5H2.75a.75.75 0 0 1 0-1.5H7V2.75A.75.75 0 0 1 7.75 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.75 4.5a.75.75 0 0 1 .75.75V11h5.75a.75.75 0 0 1 0 1.5H12.5v5.75a.75.75 0 0 1-1.5 0V12.5H5.25a.75.75 0 0 1 0-1.5H11V5.25a.75.75 0 0 1 .75-.75Z"
      })
    }
  };
});
var PlusCircleIcon = /*#__PURE__*/createIconComponent("PlusCircleIcon", "octicon octicon-plus-circle", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0ZM1.5 8a6.5 6.5 0 1 0 13 0 6.5 6.5 0 0 0-13 0Zm7.25-3.25v2.5h2.5a.75.75 0 0 1 0 1.5h-2.5v2.5a.75.75 0 0 1-1.5 0v-2.5h-2.5a.75.75 0 0 1 0-1.5h2.5v-2.5a.75.75 0 0 1 1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.75 7.75a.75.75 0 0 0-1.5 0v3.5h-3.5a.75.75 0 0 0 0 1.5h3.5v3.5a.75.75 0 0 0 1.5 0v-3.5h3.5a.75.75 0 0 0 0-1.5h-3.5v-3.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      }))
    }
  };
});
var ProjectIcon = /*#__PURE__*/createIconComponent("ProjectIcon", "octicon octicon-project", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 0h12.5C15.216 0 16 .784 16 1.75v12.5A1.75 1.75 0 0 1 14.25 16H1.75A1.75 1.75 0 0 1 0 14.25V1.75C0 .784.784 0 1.75 0ZM1.5 1.75v12.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25ZM11.75 3a.75.75 0 0 1 .75.75v7.5a.75.75 0 0 1-1.5 0v-7.5a.75.75 0 0 1 .75-.75Zm-8.25.75a.75.75 0 0 1 1.5 0v5.5a.75.75 0 0 1-1.5 0ZM8 3a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-3.5A.75.75 0 0 1 8 3Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.25 6a.75.75 0 0 0-.75.75v7.5a.75.75 0 0 0 1.5 0v-7.5A.75.75 0 0 0 7.25 6ZM12 6a.75.75 0 0 0-.75.75v4.5a.75.75 0 0 0 1.5 0v-4.5A.75.75 0 0 0 12 6Zm4 .75a.75.75 0 0 1 1.5 0v9.5a.75.75 0 0 1-1.5 0v-9.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 2h16.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25V3.75C2 2.784 2.784 2 3.75 2ZM3.5 3.75v16.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25H3.75a.25.25 0 0 0-.25.25Z"
      }))
    }
  };
});
var ProjectRoadmapIcon = /*#__PURE__*/createIconComponent("ProjectRoadmapIcon", "octicon octicon-project-roadmap", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 7a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5ZM5 4.75A.75.75 0 0 1 5.75 4h5.5a.75.75 0 0 1 0 1.5h-5.5A.75.75 0 0 1 5 4.75ZM6.75 10a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 1.75C0 .784.784 0 1.75 0h12.5C15.216 0 16 .784 16 1.75v12.5A1.75 1.75 0 0 1 14.25 16H1.75A1.75 1.75 0 0 1 0 14.25Zm1.75-.25a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75 7a.75.75 0 0 0 0 1.5h7.5a.75.75 0 0 0 0-1.5h-7.5ZM7 11.75a.75.75 0 0 1 .75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75ZM9.75 15a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 3.75C2 2.784 2.784 2 3.75 2h16.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25Zm1.75-.25a.25.25 0 0 0-.25.25v16.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25Z"
      }))
    }
  };
});
var ProjectSymlinkIcon = /*#__PURE__*/createIconComponent("ProjectSymlinkIcon", "octicon octicon-project-symlink", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 1.75C0 .784.784 0 1.75 0h12.5C15.216 0 16 .784 16 1.75v12.5A1.75 1.75 0 0 1 14.25 16h-8.5a.75.75 0 0 1 0-1.5h8.5a.25.25 0 0 0 .25-.25V6.5h-13v1.75a.75.75 0 0 1-1.5 0ZM6.5 5h8V1.75a.25.25 0 0 0-.25-.25H6.5Zm-5 0H5V1.5H1.75a.25.25 0 0 0-.25.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 13.737a2.25 2.25 0 0 1 2.262-2.25L4 11.49v1.938c0 .218.26.331.42.183l2.883-2.677a.25.25 0 0 0 0-.366L4.42 7.89a.25.25 0 0 0-.42.183V9.99l-.23-.001A3.75 3.75 0 0 0 0 13.738v1.012a.75.75 0 0 0 1.5 0v-1.013Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 3.75C2 2.784 2.784 2 3.75 2h16.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22H9.75a.75.75 0 0 1 0-1.5h10.5a.25.25 0 0 0 .25-.25V9h-17v3A.75.75 0 0 1 2 12ZM9 7.5h11.5V3.75a.25.25 0 0 0-.25-.25H9Zm-5.5 0h4v-4H3.75a.25.25 0 0 0-.25.25Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m9.308 14.5-2.104-2.236a.75.75 0 1 1 1.092-1.028l3.294 3.5a.75.75 0 0 1 0 1.028l-3.294 3.5a.75.75 0 1 1-1.092-1.028L9.308 16H6.09a2.59 2.59 0 0 0-2.59 2.59v2.66a.75.75 0 0 1-1.5 0v-2.66a4.09 4.09 0 0 1 4.09-4.09h3.218Z"
      }))
    }
  };
});
var ProjectTemplateIcon = /*#__PURE__*/createIconComponent("ProjectTemplateIcon", "octicon octicon-project-template", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 1.75v1.562a.75.75 0 1 1-1.5 0V1.75C0 .784.784 0 1.75 0h1.562a.75.75 0 1 1 0 1.5H1.75a.25.25 0 0 0-.25.25ZM6.438 0h3.124a.75.75 0 1 1 0 1.5H6.438a.75.75 0 1 1 0-1.5Zm6.25 0h1.562C15.217 0 16 .784 16 1.75v1.562a.75.75 0 1 1-1.5 0V1.75a.25.25 0 0 0-.25-.25h-1.562a.75.75 0 1 1 0-1.5ZM1.5 6.438v3.124a.75.75 0 1 1-1.5 0V6.438a.75.75 0 1 1 1.5 0Zm14.5 0v3.124a.75.75 0 1 1-1.5 0V6.438a.75.75 0 1 1 1.5 0Zm-14.5 6.25v1.562c0 .138.112.25.25.25h1.562a.75.75 0 1 1 0 1.5H1.75A1.75 1.75 0 0 1 0 14.25v-1.562a.75.75 0 1 1 1.5 0Zm14.5 0v1.562A1.75 1.75 0 0 1 14.25 16h-1.562a.75.75 0 1 1 0-1.5h1.562a.25.25 0 0 0 .25-.25v-1.562a.75.75 0 1 1 1.5 0ZM6.438 14.5h3.124a.75.75 0 1 1 0 1.5H6.438a.75.75 0 1 1 0-1.5ZM6.5 3v1A.75.75 0 0 1 5 4V3a.75.75 0 0 1 1.5 0ZM2.25 5.75A.75.75 0 0 1 3 5h1a.75.75 0 0 1 0 1.5H3a.75.75 0 0 1-.75-.75Zm4.5 0A.75.75 0 0 1 7.5 5h1a.75.75 0 0 1 0 1.5h-1a.75.75 0 0 1-.75-.75Zm-1 1a.75.75 0 0 1 .75.75v1a.75.75 0 0 1-1.5 0v-1a.75.75 0 0 1 .75-.75Zm.75 4v2.5a.75.75 0 0 1-1.5 0v-2.5a.75.75 0 0 1 1.5 0Zm3.5-5a.75.75 0 0 1 .75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.75.75 0 0 1-.75-.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 3.5a.25.25 0 0 0-.25.25v2.062a.75.75 0 1 1-1.5 0V3.75C2 2.783 2.783 2 3.75 2h2.062a.75.75 0 1 1 0 1.5Zm13.688-.75a.75.75 0 0 1 .75-.75h2.062c.966 0 1.75.783 1.75 1.75v2.062a.75.75 0 1 1-1.5 0V3.75a.25.25 0 0 0-.25-.25h-2.062a.75.75 0 0 1-.75-.75ZM2.75 17.438a.75.75 0 0 1 .75.75v2.062c0 .138.112.25.25.25h2.062a.75.75 0 1 1 0 1.5H3.75A1.75 1.75 0 0 1 2 20.25v-2.062a.75.75 0 0 1 .75-.75Zm18.5 0a.75.75 0 0 1 .75.75v2.062A1.75 1.75 0 0 1 20.25 22h-2.062a.75.75 0 1 1 0-1.5h2.062a.25.25 0 0 0 .25-.25v-2.062a.75.75 0 0 1 .75-.75Zm-18.5-8.25a.75.75 0 0 1 .75.75v4.124a.75.75 0 1 1-1.5 0V9.938a.75.75 0 0 1 .75-.75ZM9.188 2.75a.75.75 0 0 1 .75-.75h4.124a.75.75 0 1 1 0 1.5H9.938a.75.75 0 0 1-.75-.75Zm0 18.5a.75.75 0 0 1 .75-.75h4.124a.75.75 0 1 1 0 1.5H9.938a.75.75 0 0 1-.75-.75ZM21.25 9.188a.75.75 0 0 1 .75.75v4.124a.75.75 0 1 1-1.5 0V9.938a.75.75 0 0 1 .75-.75ZM3.75 8.25a.75.75 0 0 1 .75-.75h2a.75.75 0 0 1 0 1.5h-2a.75.75 0 0 1-.75-.75Zm5.5 0A.75.75 0 0 1 10 7.5h2A.75.75 0 0 1 12 9h-2a.75.75 0 0 1-.75-.75Zm-1-4.5A.75.75 0 0 1 9 4.5v2a.75.75 0 0 1-1.5 0v-2a.75.75 0 0 1 .75-.75Zm0 5.5A.75.75 0 0 1 9 10v2a.75.75 0 0 1-1.5 0v-2a.75.75 0 0 1 .75-.75Zm0 4.75a.75.75 0 0 1 .75.75v4a.75.75 0 0 1-1.5 0v-4a.75.75 0 0 1 .75-.75ZM14 8.25a.75.75 0 0 1 .75-.75h4a.75.75 0 0 1 0 1.5h-4a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var PulseIcon = /*#__PURE__*/createIconComponent("PulseIcon", "octicon octicon-pulse", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 2c.306 0 .582.187.696.471L10 10.731l1.304-3.26A.751.751 0 0 1 12 7h3.25a.75.75 0 0 1 0 1.5h-2.742l-1.812 4.528a.751.751 0 0 1-1.392 0L6 4.77 4.696 8.03A.75.75 0 0 1 4 8.5H.75a.75.75 0 0 1 0-1.5h2.742l1.812-4.529A.751.751 0 0 1 6 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.002 2.5a.75.75 0 0 1 .691.464l6.302 15.305 2.56-6.301a.75.75 0 0 1 .695-.468h4a.75.75 0 0 1 0 1.5h-3.495l-3.06 7.532a.75.75 0 0 1-1.389.004L8.997 5.21l-3.054 7.329A.75.75 0 0 1 5.25 13H.75a.75.75 0 0 1 0-1.5h4l3.558-8.538a.75.75 0 0 1 .694-.462Z"
      })
    }
  };
});
var QuestionIcon = /*#__PURE__*/createIconComponent("QuestionIcon", "octicon octicon-question", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8Zm8-6.5a6.5 6.5 0 1 0 0 13 6.5 6.5 0 0 0 0-13ZM6.92 6.085h.001a.749.749 0 1 1-1.342-.67c.169-.339.436-.701.849-.977C6.845 4.16 7.369 4 8 4a2.756 2.756 0 0 1 1.637.525c.503.377.863.965.863 1.725 0 .448-.115.83-.329 1.15-.205.307-.47.513-.692.662-.109.072-.22.138-.313.195l-.006.004a6.24 6.24 0 0 0-.26.16.952.952 0 0 0-.276.245.75.75 0 0 1-1.248-.832c.184-.264.42-.489.692-.661.103-.067.207-.132.313-.195l.007-.004c.1-.061.182-.11.258-.161a.969.969 0 0 0 .277-.245C8.96 6.514 9 6.427 9 6.25a.612.612 0 0 0-.262-.525A1.27 1.27 0 0 0 8 5.5c-.369 0-.595.09-.74.187a1.01 1.01 0 0 0-.34.398ZM9 11a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.97 8.265a1.45 1.45 0 0 0-.487.57.75.75 0 0 1-1.341-.67c.2-.402.513-.826.997-1.148C10.627 6.69 11.244 6.5 12 6.5c.658 0 1.369.195 1.934.619a2.45 2.45 0 0 1 1.004 2.006c0 1.033-.513 1.72-1.027 2.215-.19.183-.399.358-.579.508l-.147.123a4.329 4.329 0 0 0-.435.409v1.37a.75.75 0 1 1-1.5 0v-1.473c0-.237.067-.504.247-.736.22-.28.486-.517.718-.714l.183-.153.001-.001c.172-.143.324-.27.47-.412.368-.355.569-.676.569-1.136a.953.953 0 0 0-.404-.806C12.766 8.118 12.384 8 12 8c-.494 0-.814.121-1.03.265ZM13 17a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      }))
    }
  };
});
var QuoteIcon = /*#__PURE__*/createIconComponent("QuoteIcon", "octicon octicon-quote", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 2.5h10.5a.75.75 0 0 1 0 1.5H1.75a.75.75 0 0 1 0-1.5Zm4 5h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1 0-1.5Zm0 5h8.5a.75.75 0 0 1 0 1.5h-8.5a.75.75 0 0 1 0-1.5ZM2.5 7.75v6a.75.75 0 0 1-1.5 0v-6a.75.75 0 0 1 1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 6.25a.75.75 0 0 1 .75-.75h13.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 6.25Zm5 6.063a.75.75 0 0 1 .75-.75h11.5a.75.75 0 0 1 0 1.5H8.75a.75.75 0 0 1-.75-.75Zm0 5.937a.75.75 0 0 1 .75-.75h11.5a.75.75 0 0 1 0 1.5H8.75a.75.75 0 0 1-.75-.75ZM3.75 11a.75.75 0 0 1 .75.75v7a.75.75 0 0 1-1.5 0v-7a.75.75 0 0 1 .75-.75Z"
      })
    }
  };
});
var ReadIcon = /*#__PURE__*/createIconComponent("ReadIcon", "octicon octicon-read", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.115.65a1.752 1.752 0 0 1 1.77 0l6.25 3.663c.536.314.865.889.865 1.51v6.427A1.75 1.75 0 0 1 14.25 14H1.75A1.75 1.75 0 0 1 0 12.25V5.823c0-.621.33-1.196.865-1.51Zm1.011 1.293a.252.252 0 0 0-.252 0l-5.72 3.353L6.468 7.76a2.748 2.748 0 0 1 3.066 0l4.312-2.464-5.719-3.353ZM13.15 12.5 8.772 9.06a1.25 1.25 0 0 0-1.544 0L2.85 12.5Zm1.35-5.85-3.687 2.106 3.687 2.897ZM5.187 8.756 1.5 6.65v5.003Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.89 1.767a2.252 2.252 0 0 1 2.22 0l9.75 5.525A2.25 2.25 0 0 1 24 9.249v9.501A2.25 2.25 0 0 1 21.75 21H2.25A2.25 2.25 0 0 1 0 18.75v-9.5c0-.81.435-1.558 1.14-1.958Zm1.48 1.305a.75.75 0 0 0-.74 0l-9.316 5.28 7.41 4.233a3.75 3.75 0 0 1 4.553 0l7.41-4.234-9.317-5.28ZM20.65 19.5l-7.26-5.704a2.25 2.25 0 0 0-2.78 0L3.35 19.5Zm1.85-9.886-6.95 3.971 6.663 5.236c.089.07.161.159.21.26a.745.745 0 0 0 .077-.331ZM8.45 13.585 1.5 9.614v9.136c0 .119.028.23.076.33a.744.744 0 0 1 .21-.259Z"
      })
    }
  };
});
var RedoIcon = /*#__PURE__*/createIconComponent("RedoIcon", "octicon octicon-redo", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.78 6.28a.749.749 0 0 0 0-1.06l-3.5-3.5a.749.749 0 1 0-1.06 1.06L12.439 5H5.251l-.001.007L5.251 5a.8.8 0 0 0-.171.019A4.501 4.501 0 0 0 5.5 14h1.704a.75.75 0 0 0 0-1.5H5.5a3 3 0 1 1 0-6h6.939L10.22 8.72a.749.749 0 1 0 1.06 1.06l3.5-3.5Z"
      })
    }
  };
});
var RelFilePathIcon = /*#__PURE__*/createIconComponent("RelFilePathIcon", "octicon octicon-rel-file-path", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.94 3.045a.75.75 0 0 0-1.38-.59l-4.5 10.5a.75.75 0 1 0 1.38.59l4.5-10.5ZM5 11.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M19.564 4.42a.75.75 0 0 0-1.378-.59l-6.75 15.75a.75.75 0 0 0 1.378.59l6.75-15.75ZM7 18.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"
      })
    }
  };
});
var ReplyIcon = /*#__PURE__*/createIconComponent("ReplyIcon", "octicon octicon-reply", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.78 1.97a.75.75 0 0 1 0 1.06L3.81 6h6.44A4.75 4.75 0 0 1 15 10.75v2.5a.75.75 0 0 1-1.5 0v-2.5a3.25 3.25 0 0 0-3.25-3.25H3.81l2.97 2.97a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L1.47 7.28a.75.75 0 0 1 0-1.06l4.25-4.25a.75.75 0 0 1 1.06 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.53 5.03a.75.75 0 1 0-1.06-1.06l-6.25 6.25a.75.75 0 0 0 0 1.06l6.25 6.25a.75.75 0 1 0 1.06-1.06L5.56 11.5H17a3.248 3.248 0 0 1 3.25 3.248v4.502a.75.75 0 0 0 1.5 0v-4.502A4.748 4.748 0 0 0 17 10H5.56l4.97-4.97Z"
      })
    }
  };
});
var RepoIcon = /*#__PURE__*/createIconComponent("RepoIcon", "octicon octicon-repo", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 2.5A2.5 2.5 0 0 1 4.5 0h8.75a.75.75 0 0 1 .75.75v12.5a.75.75 0 0 1-.75.75h-2.5a.75.75 0 0 1 0-1.5h1.75v-2h-8a1 1 0 0 0-.714 1.7.75.75 0 1 1-1.072 1.05A2.495 2.495 0 0 1 2 11.5Zm10.5-1h-8a1 1 0 0 0-1 1v6.708A2.486 2.486 0 0 1 4.5 9h8ZM5 12.25a.25.25 0 0 1 .25-.25h3.5a.25.25 0 0 1 .25.25v3.25a.25.25 0 0 1-.4.2l-1.45-1.087a.249.249 0 0 0-.3 0L5.4 15.7a.25.25 0 0 1-.4-.2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 2.75A2.75 2.75 0 0 1 5.75 0h14.5a.75.75 0 0 1 .75.75v20.5a.75.75 0 0 1-.75.75h-6a.75.75 0 0 1 0-1.5h5.25v-4H6A1.5 1.5 0 0 0 4.5 18v.75c0 .716.43 1.334 1.05 1.605a.75.75 0 0 1-.6 1.374A3.251 3.251 0 0 1 3 18.75ZM19.5 1.5H5.75c-.69 0-1.25.56-1.25 1.25v12.651A2.989 2.989 0 0 1 6 15h13.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7 18.25a.25.25 0 0 1 .25-.25h5a.25.25 0 0 1 .25.25v5.01a.25.25 0 0 1-.397.201l-2.206-1.604a.25.25 0 0 0-.294 0L7.397 23.46a.25.25 0 0 1-.397-.2v-5.01Z"
      }))
    }
  };
});
var RepoCloneIcon = /*#__PURE__*/createIconComponent("RepoCloneIcon", "octicon octicon-repo-clone", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.5 0A2.5 2.5 0 0 0 1 2.5v9A2.5 2.5 0 0 0 3.5 14h2.75a.75.75 0 0 0 0-1.5H3.5a1 1 0 0 1 0-2h2.75a.75.75 0 0 0 0-1.5H3.5c-.356 0-.694.074-1 .208V2.5a1 1 0 0 1 1-1h8v2.75a.75.75 0 0 0 1.5 0V.75a.75.75 0 0 0-.75-.75H3.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 8.058C8 7.023 8.75 6 9.887 6h5.363a.75.75 0 0 1 .75.75v8.5a.75.75 0 0 1-.75.75h-5A2.25 2.25 0 0 1 8 13.75Zm6.5 3.442v-4H9.887c-.07 0-.156.031-.238.125a.663.663 0 0 0-.149.433v3.57c.235-.083.487-.128.75-.128Zm-5 2.25c0 .414.336.75.75.75h4.25V13h-4.25a.75.75 0 0 0-.75.75Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.375.375a2.5 2.5 0 0 0-2.5 2.5v15.25a2.5 2.5 0 0 0 2.5 2.5h5.187a.75.75 0 1 0 0-1.5H4.375a1 1 0 0 1-1-1v-1.75a1 1 0 0 1 1-1h5.687a.75.75 0 1 0 0-1.5H4.375c-.356 0-.694.074-1 .208V2.875a1 1 0 0 1 1-1h13.25v5.25a.75.75 0 0 0 1.5 0v-6a.75.75 0 0 0-.75-.75h-14Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.375 12.087c0-1.396 1.005-2.712 2.456-2.712h8.044a.75.75 0 0 1 .75.75v12.75a.75.75 0 0 1-.75.75h-7.5a3 3 0 0 1-3-3Zm9.75 5.538v-6.75h-7.294c-.433 0-.956.441-.956 1.212v5.939a2.989 2.989 0 0 1 1.5-.401Zm-8.25 3a1.5 1.5 0 0 0 1.5 1.5h6.75v-3h-6.75a1.5 1.5 0 0 0-1.5 1.5Z"
      }))
    }
  };
});
var RepoDeletedIcon = /*#__PURE__*/createIconComponent("RepoDeletedIcon", "octicon octicon-repo-deleted", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 2.5A2.5 2.5 0 0 1 3.5 0h8.75a.75.75 0 0 1 .75.75v7.5a.75.75 0 0 1-1.5 0V1.5h-8a1 1 0 0 0-1 1v6.708A2.492 2.492 0 0 1 3.5 9h4.75a.75.75 0 0 1 0 1.5H3.5a1 1 0 1 0 0 2h4.75a.75.75 0 0 1 0 1.5H3.5A2.5 2.5 0 0 1 1 11.5v-9Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.28 10.22a.75.75 0 1 0-1.06 1.06L11.94 13l-1.72 1.72a.75.75 0 1 0 1.06 1.06L13 14.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L14.06 13l1.72-1.72a.75.75 0 1 0-1.06-1.06L13 11.94l-1.72-1.72Z"
      }))
    }
  };
});
var RepoForkedIcon = /*#__PURE__*/createIconComponent("RepoForkedIcon", "octicon octicon-repo-forked", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5 5.372v.878c0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75v-.878a2.25 2.25 0 1 1 1.5 0v.878a2.25 2.25 0 0 1-2.25 2.25h-1.5v2.128a2.251 2.251 0 1 1-1.5 0V8.5h-1.5A2.25 2.25 0 0 1 3.5 6.25v-.878a2.25 2.25 0 1 1 1.5 0ZM5 3.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm6.75.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm-3 8.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.75 19.25a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0ZM15 4.75a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0Zm-12.5 0a3.25 3.25 0 1 1 6.5 0 3.25 3.25 0 0 1-6.5 0ZM5.75 6.5a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 5.75 6.5ZM12 21a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 12 21Zm6.25-14.5a1.75 1.75 0 1 0-.001-3.501A1.75 1.75 0 0 0 18.25 6.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.5 7.75v1A2.25 2.25 0 0 0 8.75 11h6.5a2.25 2.25 0 0 0 2.25-2.25v-1H19v1a3.75 3.75 0 0 1-3.75 3.75h-6.5A3.75 3.75 0 0 1 5 8.75v-1Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.25 16.25v-5h1.5v5h-1.5Z"
      }))
    }
  };
});
var RepoLockedIcon = /*#__PURE__*/createIconComponent("RepoLockedIcon", "octicon octicon-repo-locked", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 2.5A2.5 2.5 0 0 1 3.5 0h8.75a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0V1.5h-8a1 1 0 0 0-1 1v6.708A2.492 2.492 0 0 1 3.5 9h2.75a.75.75 0 0 1 0 1.5H3.5a1 1 0 1 0 0 2h2.75a.75.75 0 0 1 0 1.5H3.5A2.5 2.5 0 0 1 1 11.5v-9Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9 10.168V9a3 3 0 1 1 6 0v1.168c.591.281 1 .884 1 1.582v2.5A1.75 1.75 0 0 1 14.25 16h-4.5A1.75 1.75 0 0 1 8 14.25v-2.5c0-.698.409-1.3 1-1.582ZM13.5 10V9a1.5 1.5 0 0 0-3 0v1Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 2.75A2.75 2.75 0 0 1 4.75 0h14.5a.75.75 0 0 1 .75.75v8a.75.75 0 0 1-1.5 0V1.5H4.75c-.69 0-1.25.56-1.25 1.25v12.651A2.987 2.987 0 0 1 5 15h6.25a.75.75 0 0 1 0 1.5H5A1.5 1.5 0 0 0 3.5 18v1.25c0 .69.56 1.25 1.25 1.25h6a.75.75 0 0 1 0 1.5h-6A2.75 2.75 0 0 1 2 19.25V2.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15 14.5a3.5 3.5 0 1 1 7 0V16h.25c.966 0 1.75.784 1.75 1.75v4.5A1.75 1.75 0 0 1 22.25 24h-7.5A1.75 1.75 0 0 1 13 22.25v-4.5c0-.966.784-1.75 1.75-1.75H15Zm3.5-2a2 2 0 0 0-2 2V16h4v-1.5a2 2 0 0 0-2-2Z"
      }))
    }
  };
});
var RepoPullIcon = /*#__PURE__*/createIconComponent("RepoPullIcon", "octicon octicon-repo-pull", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 2.5A2.5 2.5 0 0 1 3.5 0h8.75a.75.75 0 0 1 .75.75V6a.75.75 0 0 1-1.5 0V1.5h-8a1 1 0 0 0-1 1v6.708A2.486 2.486 0 0 1 3.5 9h3a.75.75 0 0 1 0 1.5h-3a1 1 0 0 0 0 2h3a.75.75 0 0 1 0 1.5h-3A2.5 2.5 0 0 1 1 11.5v-9Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.21 13.479a.75.75 0 1 0 1.061 1.061l2.504-2.505a.75.75 0 0 0 0-1.061L13.271 8.47a.75.75 0 0 0-1.061 1.06l1.224 1.225H8.75a.75.75 0 1 0 0 1.5h4.685l-1.225 1.224Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.875 2.875a2.5 2.5 0 0 1 2.5-2.5h14a.75.75 0 0 1 .75.75v9.125a.75.75 0 0 1-1.5 0V1.875H4.375a1 1 0 0 0-1 1v11.208a2.486 2.486 0 0 1 1-.208h5.937a.75.75 0 1 1 0 1.5H4.375a1 1 0 0 0-1 1v1.75a1 1 0 0 0 1 1h6a.75.75 0 0 1 0 1.5h-6a2.5 2.5 0 0 1-2.5-2.5V2.875Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M18.643 20.484a.749.749 0 1 0 1.061 1.06l3.757-3.757a.75.75 0 0 0 0-1.06l-3.757-3.757a.75.75 0 0 0-1.061 1.06l2.476 2.477H13a.75.75 0 0 0 0 1.5h8.12l-2.477 2.477Z"
      }))
    }
  };
});
var RepoPushIcon = /*#__PURE__*/createIconComponent("RepoPushIcon", "octicon octicon-repo-push", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 2.5A2.5 2.5 0 0 1 3.5 0h8.75a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0V1.5h-8a1 1 0 0 0-1 1v6.708A2.493 2.493 0 0 1 3.5 9h3.25a.75.75 0 0 1 0 1.5H3.5a1 1 0 0 0 0 2h5.75a.75.75 0 0 1 0 1.5H3.5A2.5 2.5 0 0 1 1 11.5Zm13.23 7.79h-.001l-1.224-1.224v6.184a.75.75 0 0 1-1.5 0V9.066L10.28 10.29a.75.75 0 0 1-1.06-1.061l2.505-2.504a.75.75 0 0 1 1.06 0L15.29 9.23a.751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.75 0A2.75 2.75 0 0 0 2 2.75v16.5A2.75 2.75 0 0 0 4.75 22h11a.75.75 0 0 0 0-1.5h-11c-.69 0-1.25-.56-1.25-1.25V18A1.5 1.5 0 0 1 5 16.5h7.25a.75.75 0 0 0 0-1.5H5c-.546 0-1.059.146-1.5.401V2.75c0-.69.56-1.25 1.25-1.25H18.5v7a.75.75 0 0 0 1.5 0V.75a.75.75 0 0 0-.75-.75H4.75Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m20 13.903 2.202 2.359a.75.75 0 0 0 1.096-1.024l-3.5-3.75a.75.75 0 0 0-1.096 0l-3.5 3.75a.75.75 0 1 0 1.096 1.024l2.202-2.36v9.348a.75.75 0 0 0 1.5 0v-9.347Z"
      }))
    }
  };
});
var RepoTemplateIcon = /*#__PURE__*/createIconComponent("RepoTemplateIcon", "octicon octicon-repo-template", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13.25 8a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-.75.75h-2.5a.75.75 0 0 1 0-1.5h1.75v-2h-.75a.75.75 0 0 1 0-1.5h.75v-.25a.75.75 0 0 1 .75-.75ZM5 12.25a.25.25 0 0 1 .25-.25h3.5a.25.25 0 0 1 .25.25v3.25a.25.25 0 0 1-.4.2l-1.45-1.087a.249.249 0 0 0-.3 0L5.4 15.7a.25.25 0 0 1-.4-.2ZM2.75 8a.75.75 0 0 1 .75.75v.268c.083-.012.166-.018.25-.018h.5a.75.75 0 0 1 0 1.5h-.5a.25.25 0 0 0-.25.25v.75c0 .28.114.532.3.714a.75.75 0 1 1-1.05 1.072A2.495 2.495 0 0 1 2 11.5V8.75A.75.75 0 0 1 2.75 8ZM11 .75a.75.75 0 0 1 .75-.75h1.5a.75.75 0 0 1 .75.75v1.5a.75.75 0 0 1-1.5 0V1.5h-.75A.75.75 0 0 1 11 .75Zm-5 0A.75.75 0 0 1 6.75 0h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 6 .75Zm0 9A.75.75 0 0 1 6.75 9h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 6 9.75ZM4.992.662a.75.75 0 0 1-.636.848c-.436.063-.783.41-.846.846a.751.751 0 0 1-1.485-.212A2.501 2.501 0 0 1 4.144.025a.75.75 0 0 1 .848.637ZM2.75 4a.75.75 0 0 1 .75.75v1.5a.75.75 0 0 1-1.5 0v-1.5A.75.75 0 0 1 2.75 4Zm10.5 0a.75.75 0 0 1 .75.75v1.5a.75.75 0 0 1-1.5 0v-1.5a.75.75 0 0 1 .75-.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 0A2.75 2.75 0 0 0 3 2.75v1a.75.75 0 0 0 1.5 0v-1c0-.69.56-1.25 1.25-1.25h1a.75.75 0 0 0 0-1.5h-1Zm4 0a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5Zm7.5 0a.75.75 0 0 0 0 1.5h2.25v2.25a.75.75 0 0 0 1.5 0v-3a.75.75 0 0 0-.75-.75h-3ZM4.5 6.5a.75.75 0 0 0-1.5 0v3.75a.75.75 0 0 0 1.5 0V6.5Zm16.5 0a.75.75 0 0 0-1.5 0v3.75a.75.75 0 0 0 1.5 0V6.5ZM4.5 13.25a.75.75 0 0 0-1.5 0v5.5a3.25 3.25 0 0 0 1.95 2.98.75.75 0 1 0 .6-1.375A1.75 1.75 0 0 1 4.5 18.75V18A1.5 1.5 0 0 1 6 16.5h.75a.75.75 0 0 0 0-1.5H6c-.546 0-1.059.146-1.5.401V13.25Zm16.5 0a.75.75 0 0 0-1.5 0V15h-2.25a.75.75 0 0 0 0 1.5h2.25v4h-5.25a.75.75 0 0 0 0 1.5h6a.75.75 0 0 0 .75-.75v-8ZM9.75 15a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5Zm-2.353 8.461A.25.25 0 0 1 7 23.26v-5.01a.25.25 0 0 1 .25-.25h5a.25.25 0 0 1 .25.25v5.01a.25.25 0 0 1-.397.201l-2.206-1.604a.25.25 0 0 0-.294 0L7.397 23.46Z"
      })
    }
  };
});
var ReportIcon = /*#__PURE__*/createIconComponent("ReportIcon", "octicon octicon-report", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 1.75C0 .784.784 0 1.75 0h12.5C15.216 0 16 .784 16 1.75v9.5A1.75 1.75 0 0 1 14.25 13H8.06l-2.573 2.573A1.458 1.458 0 0 1 3 14.543V13H1.75A1.75 1.75 0 0 1 0 11.25Zm1.75-.25a.25.25 0 0 0-.25.25v9.5c0 .138.112.25.25.25h2a.75.75 0 0 1 .75.75v2.19l2.72-2.72a.749.749 0 0 1 .53-.22h6.5a.25.25 0 0 0 .25-.25v-9.5a.25.25 0 0 0-.25-.25Zm7 2.25v2.5a.75.75 0 0 1-1.5 0v-2.5a.75.75 0 0 1 1.5 0ZM9 9a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.5 4.25c0-.966.784-1.75 1.75-1.75h17.5c.966 0 1.75.784 1.75 1.75v12.5a1.75 1.75 0 0 1-1.75 1.75h-9.586a.25.25 0 0 0-.177.073l-3.5 3.5A1.458 1.458 0 0 1 5 21.043V18.5H3.25a1.75 1.75 0 0 1-1.75-1.75ZM3.25 4a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25h2.5a.75.75 0 0 1 .75.75v3.19l3.427-3.427A1.75 1.75 0 0 1 11.164 17h9.586a.25.25 0 0 0 .25-.25V4.25a.25.25 0 0 0-.25-.25ZM12 6a.75.75 0 0 1 .75.75v4a.75.75 0 0 1-1.5 0v-4A.75.75 0 0 1 12 6Zm0 9a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    }
  };
});
var RocketIcon = /*#__PURE__*/createIconComponent("RocketIcon", "octicon octicon-rocket", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M14.064 0h.186C15.216 0 16 .784 16 1.75v.186a8.752 8.752 0 0 1-2.564 6.186l-.458.459c-.314.314-.641.616-.979.904v3.207c0 .608-.315 1.172-.833 1.49l-2.774 1.707a.749.749 0 0 1-1.11-.418l-.954-3.102a1.214 1.214 0 0 1-.145-.125L3.754 9.816a1.218 1.218 0 0 1-.124-.145L.528 8.717a.749.749 0 0 1-.418-1.11l1.71-2.774A1.748 1.748 0 0 1 3.31 4h3.204c.288-.338.59-.665.904-.979l.459-.458A8.749 8.749 0 0 1 14.064 0ZM8.938 3.623h-.002l-.458.458c-.76.76-1.437 1.598-2.02 2.5l-1.5 2.317 2.143 2.143 2.317-1.5c.902-.583 1.74-1.26 2.499-2.02l.459-.458a7.25 7.25 0 0 0 2.123-5.127V1.75a.25.25 0 0 0-.25-.25h-.186a7.249 7.249 0 0 0-5.125 2.123ZM3.56 14.56c-.732.732-2.334 1.045-3.005 1.148a.234.234 0 0 1-.201-.064.234.234 0 0 1-.064-.201c.103-.671.416-2.273 1.15-3.003a1.502 1.502 0 1 1 2.12 2.12Zm6.94-3.935c-.088.06-.177.118-.266.175l-2.35 1.521.548 1.783 1.949-1.2a.25.25 0 0 0 .119-.213ZM3.678 8.116 5.2 5.766c.058-.09.117-.178.176-.266H3.309a.25.25 0 0 0-.213.119l-1.2 1.95ZM12 5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M20.322.75h1.176a1.75 1.75 0 0 1 1.75 1.749v1.177a10.75 10.75 0 0 1-2.925 7.374l-1.228 1.304a23.699 23.699 0 0 1-1.596 1.542v5.038c0 .615-.323 1.184-.85 1.5l-4.514 2.709a.75.75 0 0 1-1.12-.488l-.963-4.572a1.305 1.305 0 0 1-.14-.129L8.04 15.96l-1.994-1.873a1.305 1.305 0 0 1-.129-.14l-4.571-.963a.75.75 0 0 1-.49-1.12l2.71-4.514c.316-.527.885-.85 1.5-.85h5.037a23.668 23.668 0 0 1 1.542-1.594l1.304-1.23A10.753 10.753 0 0 1 20.321.75Zm-6.344 4.018v-.001l-1.304 1.23a22.275 22.275 0 0 0-3.255 3.851l-2.193 3.29 1.859 1.744a.545.545 0 0 1 .034.034l1.743 1.858 3.288-2.192a22.263 22.263 0 0 0 3.854-3.257l1.228-1.303a9.251 9.251 0 0 0 2.517-6.346V2.5a.25.25 0 0 0-.25-.25h-1.177a9.252 9.252 0 0 0-6.344 2.518ZM6.5 21c-1.209 1.209-3.901 1.445-4.743 1.49a.236.236 0 0 1-.18-.067.236.236 0 0 1-.067-.18c.045-.842.281-3.534 1.49-4.743.9-.9 2.6-.9 3.5 0 .9.9.9 2.6 0 3.5Zm-.592-8.588L8.17 9.017c.23-.346.47-.685.717-1.017H5.066a.25.25 0 0 0-.214.121l-2.167 3.612ZM16 15.112c-.333.248-.672.487-1.018.718l-3.393 2.262.678 3.223 3.612-2.167a.25.25 0 0 0 .121-.214ZM17.5 8a1.5 1.5 0 1 1-3.001-.001A1.5 1.5 0 0 1 17.5 8Z"
      })
    }
  };
});
var RowsIcon = /*#__PURE__*/createIconComponent("RowsIcon", "octicon octicon-rows", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16 10.75v2.5A1.75 1.75 0 0 1 14.25 15H1.75A1.75 1.75 0 0 1 0 13.25v-2.5C0 9.784.784 9 1.75 9h12.5c.966 0 1.75.784 1.75 1.75Zm0-8v2.5A1.75 1.75 0 0 1 14.25 7H1.75A1.75 1.75 0 0 1 0 5.25v-2.5C0 1.784.784 1 1.75 1h12.5c.966 0 1.75.784 1.75 1.75Zm-1.75-.25H1.75a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-2.5a.25.25 0 0 0-.25-.25Zm0 8H1.75a.25.25 0 0 0-.25.25v2.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-2.5a.25.25 0 0 0-.25-.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M22 3.75v5.5A1.75 1.75 0 0 1 20.25 11H3.75A1.75 1.75 0 0 1 2 9.25v-5.5C2 2.784 2.784 2 3.75 2h16.5c.966 0 1.75.784 1.75 1.75Zm0 11v5.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25v-5.5c0-.966.784-1.75 1.75-1.75h16.5c.966 0 1.75.784 1.75 1.75ZM20.25 3.5H3.75a.25.25 0 0 0-.25.25v5.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25Zm0 11H3.75a.25.25 0 0 0-.25.25v5.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25v-5.5a.25.25 0 0 0-.25-.25Z"
      })
    }
  };
});
var RssIcon = /*#__PURE__*/createIconComponent("RssIcon", "octicon octicon-rss", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2.002 2.725a.75.75 0 0 1 .797-.699C8.79 2.42 13.58 7.21 13.974 13.201a.75.75 0 0 1-1.497.098 10.502 10.502 0 0 0-9.776-9.776.747.747 0 0 1-.7-.798ZM2.84 7.05h-.002a7.002 7.002 0 0 1 6.113 6.111.75.75 0 0 1-1.49.178 5.503 5.503 0 0 0-4.8-4.8.75.75 0 0 1 .179-1.489ZM2 13a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.5 3.25a.75.75 0 0 1 .75-.75C14.053 2.5 22 10.447 22 20.25a.75.75 0 0 1-1.5 0C20.5 11.275 13.225 4 4.25 4a.75.75 0 0 1-.75-.75Zm.75 6.25C10.187 9.5 15 14.313 15 20.25a.75.75 0 0 1-1.5 0A9.25 9.25 0 0 0 4.25 11a.75.75 0 0 1 0-1.5ZM3.5 19a2 2 0 1 1 3.999-.001A2 2 0 0 1 3.5 19Z"
      })
    }
  };
});
var RubyIcon = /*#__PURE__*/createIconComponent("RubyIcon", "octicon octicon-ruby", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.637 2.291A.748.748 0 0 1 4.23 2h7.54c.232 0 .451.107.593.291l3.48 4.5a.75.75 0 0 1-.072.999l-7.25 7a.75.75 0 0 1-1.042 0l-7.25-7a.75.75 0 0 1-.072-.999ZM4.598 3.5 1.754 7.177 8 13.207l6.246-6.03L11.402 3.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.873 3.26A.748.748 0 0 1 6.44 3h11.31c.223 0 .434.099.576.27l5 6a.75.75 0 0 1-.028.992l-10.75 11.5a.75.75 0 0 1-1.096 0l-10.75-11.5a.75.75 0 0 1-.02-1.003l5.19-6Zm.91 1.24L2.258 9.73 12 20.153l9.75-10.43L17.399 4.5Z"
      })
    }
  };
});
var ScreenFullIcon = /*#__PURE__*/createIconComponent("ScreenFullIcon", "octicon octicon-screen-full", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 10a.75.75 0 0 1 .75.75v2.5c0 .138.112.25.25.25h2.5a.75.75 0 0 1 0 1.5h-2.5A1.75 1.75 0 0 1 1 13.25v-2.5a.75.75 0 0 1 .75-.75Zm12.5 0a.75.75 0 0 1 .75.75v2.5A1.75 1.75 0 0 1 13.25 15h-2.5a.75.75 0 0 1 0-1.5h2.5a.25.25 0 0 0 .25-.25v-2.5a.75.75 0 0 1 .75-.75ZM2.75 2.5a.25.25 0 0 0-.25.25v2.5a.75.75 0 0 1-1.5 0v-2.5C1 1.784 1.784 1 2.75 1h2.5a.75.75 0 0 1 0 1.5ZM10 1.75a.75.75 0 0 1 .75-.75h2.5c.966 0 1.75.784 1.75 1.75v2.5a.75.75 0 0 1-1.5 0v-2.5a.25.25 0 0 0-.25-.25h-2.5a.75.75 0 0 1-.75-.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 15a.75.75 0 0 1 .75.75v3.5c0 .138.112.25.25.25h3.5a.75.75 0 0 1 0 1.5h-3.5A1.75 1.75 0 0 1 3 19.25v-3.5a.75.75 0 0 1 .75-.75Zm16.5 0a.75.75 0 0 1 .75.75v3.5A1.75 1.75 0 0 1 19.25 21h-3.5a.75.75 0 0 1 0-1.5h3.5a.25.25 0 0 0 .25-.25v-3.5a.75.75 0 0 1 .75-.75ZM4.75 4.5a.25.25 0 0 0-.25.25v3.5a.75.75 0 0 1-1.5 0v-3.5C3 3.784 3.784 3 4.75 3h3.5a.75.75 0 0 1 0 1.5ZM15 3.75a.75.75 0 0 1 .75-.75h3.5c.966 0 1.75.784 1.75 1.75v3.5a.75.75 0 0 1-1.5 0v-3.5a.25.25 0 0 0-.25-.25h-3.5a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var ScreenNormalIcon = /*#__PURE__*/createIconComponent("ScreenNormalIcon", "octicon octicon-screen-normal", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.75 1a.75.75 0 0 1 .75.75v2.5c0 .138.112.25.25.25h2.5a.75.75 0 0 1 0 1.5h-2.5A1.75 1.75 0 0 1 10 4.25v-2.5a.75.75 0 0 1 .75-.75Zm-5.5 0a.75.75 0 0 1 .75.75v2.5A1.75 1.75 0 0 1 4.25 6h-2.5a.75.75 0 0 1 0-1.5h2.5a.25.25 0 0 0 .25-.25v-2.5A.75.75 0 0 1 5.25 1ZM1 10.75a.75.75 0 0 1 .75-.75h2.5c.966 0 1.75.784 1.75 1.75v2.5a.75.75 0 0 1-1.5 0v-2.5a.25.25 0 0 0-.25-.25h-2.5a.75.75 0 0 1-.75-.75Zm9 1c0-.966.784-1.75 1.75-1.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.25.25 0 0 0-.25.25v2.5a.75.75 0 0 1-1.5 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15.75 3a.75.75 0 0 1 .75.75v3.5c0 .138.112.25.25.25h3.5a.75.75 0 0 1 0 1.5h-3.5A1.75 1.75 0 0 1 15 7.25v-3.5a.75.75 0 0 1 .75-.75Zm-7.5 0a.75.75 0 0 1 .75.75v3.5A1.75 1.75 0 0 1 7.25 9h-3.5a.75.75 0 0 1 0-1.5h3.5a.25.25 0 0 0 .25-.25v-3.5A.75.75 0 0 1 8.25 3ZM3 15.75a.75.75 0 0 1 .75-.75h3.5c.966 0 1.75.784 1.75 1.75v3.5a.75.75 0 0 1-1.5 0v-3.5a.25.25 0 0 0-.25-.25h-3.5a.75.75 0 0 1-.75-.75Zm12 1c0-.966.784-1.75 1.75-1.75h3.5a.75.75 0 0 1 0 1.5h-3.5a.25.25 0 0 0-.25.25v3.5a.75.75 0 0 1-1.5 0Z"
      })
    }
  };
});
var SearchIcon = /*#__PURE__*/createIconComponent("SearchIcon", "octicon octicon-search", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.68 11.74a6 6 0 0 1-7.922-8.982 6 6 0 0 1 8.982 7.922l3.04 3.04a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215ZM11.5 7a4.499 4.499 0 1 0-8.997 0A4.499 4.499 0 0 0 11.5 7Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.25 2a8.25 8.25 0 0 1 6.34 13.53l5.69 5.69a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-5.69-5.69A8.25 8.25 0 1 1 10.25 2ZM3.5 10.25a6.75 6.75 0 1 0 13.5 0 6.75 6.75 0 0 0-13.5 0Z"
      })
    }
  };
});
var ServerIcon = /*#__PURE__*/createIconComponent("ServerIcon", "octicon octicon-server", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 1h12.5c.966 0 1.75.784 1.75 1.75v4c0 .372-.116.717-.314 1 .198.283.314.628.314 1v4a1.75 1.75 0 0 1-1.75 1.75H1.75A1.75 1.75 0 0 1 0 12.75v-4c0-.358.109-.707.314-1a1.739 1.739 0 0 1-.314-1v-4C0 1.784.784 1 1.75 1ZM1.5 2.75v4c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-4a.25.25 0 0 0-.25-.25H1.75a.25.25 0 0 0-.25.25Zm.25 5.75a.25.25 0 0 0-.25.25v4c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25v-4a.25.25 0 0 0-.25-.25ZM7 4.75A.75.75 0 0 1 7.75 4h4.5a.75.75 0 0 1 0 1.5h-4.5A.75.75 0 0 1 7 4.75ZM7.75 10h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1 0-1.5ZM3 4.75A.75.75 0 0 1 3.75 4h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 3 4.75ZM3.75 10h.5a.75.75 0 0 1 0 1.5h-.5a.75.75 0 0 1 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.75 6.5a.75.75 0 0 0 0 1.5h6.5a.75.75 0 0 0 0-1.5h-6.5ZM6 7.25a.75.75 0 0 1 .75-.75h.5a.75.75 0 0 1 0 1.5h-.5A.75.75 0 0 1 6 7.25Zm4 9a.75.75 0 0 1 .75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75Zm-3.25-.75a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5h-.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.25 2h17.5c.966 0 1.75.784 1.75 1.75v7c0 .372-.116.716-.314 1 .198.284.314.628.314 1v7a1.75 1.75 0 0 1-1.75 1.75H3.25a1.75 1.75 0 0 1-1.75-1.75v-7c0-.358.109-.707.314-1a1.741 1.741 0 0 1-.314-1v-7C1.5 2.784 2.284 2 3.25 2Zm0 10.5a.25.25 0 0 0-.25.25v7c0 .138.112.25.25.25h17.5a.25.25 0 0 0 .25-.25v-7a.25.25 0 0 0-.25-.25Zm0-1.5h17.5a.25.25 0 0 0 .25-.25v-7a.25.25 0 0 0-.25-.25H3.25a.25.25 0 0 0-.25.25v7c0 .138.112.25.25.25Z"
      }))
    }
  };
});
var ShareIcon = /*#__PURE__*/createIconComponent("ShareIcon", "octicon octicon-share", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 6.5a.25.25 0 0 0-.25.25v6.5c0 .138.112.25.25.25h8.5a.25.25 0 0 0 .25-.25v-6.5a.25.25 0 0 0-.25-.25h-1a.75.75 0 0 1 0-1.5h1c.966 0 1.75.784 1.75 1.75v6.5A1.75 1.75 0 0 1 12.25 15h-8.5A1.75 1.75 0 0 1 2 13.25v-6.5C2 5.784 2.784 5 3.75 5h1a.75.75 0 0 1 0 1.5ZM7.823.177a.25.25 0 0 1 .354 0l2.896 2.896a.25.25 0 0 1-.177.427H8.75v5.75a.75.75 0 0 1-1.5 0V3.5H5.104a.25.25 0 0 1-.177-.427Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.5 9.75v10.5c0 .138.112.25.25.25h12.5a.25.25 0 0 0 .25-.25V9.75a.25.25 0 0 0-.25-.25h-2.5a.75.75 0 0 1 0-1.5h2.5c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 18.25 22H5.75A1.75 1.75 0 0 1 4 20.25V9.75C4 8.784 4.784 8 5.75 8h2.5a.75.75 0 0 1 0 1.5h-2.5a.25.25 0 0 0-.25.25Zm7.03-8.53 3.25 3.25a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-1.97-1.97v10.69a.75.75 0 0 1-1.5 0V3.56L9.28 5.53a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042l3.25-3.25a.75.75 0 0 1 1.06 0Z"
      })
    }
  };
});
var ShareAndroidIcon = /*#__PURE__*/createIconComponent("ShareAndroidIcon", "octicon octicon-share-android", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15 3a3 3 0 0 1-5.175 2.066l-3.92 2.179a2.994 2.994 0 0 1 0 1.51l3.92 2.179a3 3 0 1 1-.73 1.31l-3.92-2.178a3 3 0 1 1 0-4.133l3.92-2.178A3 3 0 1 1 15 3Zm-1.5 10a1.5 1.5 0 1 0-3.001.001A1.5 1.5 0 0 0 13.5 13Zm-9-5a1.5 1.5 0 1 0-3.001.001A1.5 1.5 0 0 0 4.5 8Zm9-5a1.5 1.5 0 1 0-3.001.001A1.5 1.5 0 0 0 13.5 3Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M20 5.5a3.498 3.498 0 0 1-6.062 2.385l-5.112 3.021a3.498 3.498 0 0 1 0 2.188l5.112 3.021a3.5 3.5 0 1 1-.764 1.29l-5.112-3.02a3.499 3.499 0 1 1-3.843-5.642 3.499 3.499 0 0 1 3.843.872l5.112-3.021A3.5 3.5 0 1 1 20 5.5Zm-1.5 13a2 2 0 1 0-3.999-.001 2 2 0 0 0 3.999.001Zm0-13a2 2 0 1 0-3.999-.001A2 2 0 0 0 18.5 5.5ZM5.5 14a2 2 0 1 0 .001-3.999A2 2 0 0 0 5.5 14Z"
      })
    }
  };
});
var ShieldIcon = /*#__PURE__*/createIconComponent("ShieldIcon", "octicon octicon-shield", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.467.133a1.748 1.748 0 0 1 1.066 0l5.25 1.68A1.75 1.75 0 0 1 15 3.48V7c0 1.566-.32 3.182-1.303 4.682-.983 1.498-2.585 2.813-5.032 3.855a1.697 1.697 0 0 1-1.33 0c-2.447-1.042-4.049-2.357-5.032-3.855C1.32 10.182 1 8.566 1 7V3.48a1.75 1.75 0 0 1 1.217-1.667Zm.61 1.429a.25.25 0 0 0-.153 0l-5.25 1.68a.25.25 0 0 0-.174.238V7c0 1.358.275 2.666 1.057 3.86.784 1.194 2.121 2.34 4.366 3.297a.196.196 0 0 0 .154 0c2.245-.956 3.582-2.104 4.366-3.298C13.225 9.666 13.5 8.36 13.5 7V3.48a.251.251 0 0 0-.174-.237l-5.25-1.68ZM8.75 4.75v3a.75.75 0 0 1-1.5 0v-3a.75.75 0 0 1 1.5 0ZM9 10.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M13 15.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-.25-8.25a.75.75 0 0 0-1.5 0v4.5a.75.75 0 0 0 1.5 0v-4.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.46.637a1.748 1.748 0 0 1 1.08 0l8.25 2.675A1.75 1.75 0 0 1 22 4.976V10c0 6.19-3.77 10.705-9.401 12.83a1.704 1.704 0 0 1-1.198 0C5.771 20.704 2 16.19 2 10V4.976c0-.76.49-1.43 1.21-1.664Zm.617 1.426a.253.253 0 0 0-.154 0L3.673 4.74a.25.25 0 0 0-.173.237V10c0 5.461 3.28 9.483 8.43 11.426a.199.199 0 0 0 .14 0C17.22 19.483 20.5 15.46 20.5 10V4.976a.25.25 0 0 0-.173-.237Z"
      }))
    }
  };
});
var ShieldCheckIcon = /*#__PURE__*/createIconComponent("ShieldCheckIcon", "octicon octicon-shield-check", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m8.533.133 5.25 1.68A1.75 1.75 0 0 1 15 3.48V7c0 1.566-.32 3.182-1.303 4.682-.983 1.498-2.585 2.813-5.032 3.855a1.697 1.697 0 0 1-1.33 0c-2.447-1.042-4.049-2.357-5.032-3.855C1.32 10.182 1 8.566 1 7V3.48a1.75 1.75 0 0 1 1.217-1.667l5.25-1.68a1.748 1.748 0 0 1 1.066 0Zm-.61 1.429.001.001-5.25 1.68a.251.251 0 0 0-.174.237V7c0 1.36.275 2.666 1.057 3.859.784 1.194 2.121 2.342 4.366 3.298a.196.196 0 0 0 .154 0c2.245-.957 3.582-2.103 4.366-3.297C13.225 9.666 13.5 8.358 13.5 7V3.48a.25.25 0 0 0-.174-.238l-5.25-1.68a.25.25 0 0 0-.153 0ZM11.28 6.28l-3.5 3.5a.75.75 0 0 1-1.06 0l-1.5-1.5a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215l.97.97 2.97-2.97a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16.53 9.78a.75.75 0 0 0-1.06-1.06L11 13.19l-1.97-1.97a.75.75 0 0 0-1.06 1.06l2.5 2.5a.75.75 0 0 0 1.06 0l5-5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m12.54.637 8.25 2.675A1.75 1.75 0 0 1 22 4.976V10c0 6.19-3.771 10.704-9.401 12.83a1.704 1.704 0 0 1-1.198 0C5.77 20.705 2 16.19 2 10V4.976c0-.758.489-1.43 1.21-1.664L11.46.637a1.748 1.748 0 0 1 1.08 0Zm-.617 1.426-8.25 2.676a.249.249 0 0 0-.173.237V10c0 5.46 3.28 9.483 8.43 11.426a.199.199 0 0 0 .14 0C17.22 19.483 20.5 15.461 20.5 10V4.976a.25.25 0 0 0-.173-.237l-8.25-2.676a.253.253 0 0 0-.154 0Z"
      }))
    }
  };
});
var ShieldLockIcon = /*#__PURE__*/createIconComponent("ShieldLockIcon", "octicon octicon-shield-lock", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m8.533.133 5.25 1.68A1.75 1.75 0 0 1 15 3.48V7c0 1.566-.32 3.182-1.303 4.682-.983 1.498-2.585 2.813-5.032 3.855a1.697 1.697 0 0 1-1.33 0c-2.447-1.042-4.049-2.357-5.032-3.855C1.32 10.182 1 8.566 1 7V3.48a1.75 1.75 0 0 1 1.217-1.667l5.25-1.68a1.748 1.748 0 0 1 1.066 0Zm-.61 1.429.001.001-5.25 1.68a.251.251 0 0 0-.174.237V7c0 1.36.275 2.666 1.057 3.859.784 1.194 2.121 2.342 4.366 3.298a.196.196 0 0 0 .154 0c2.245-.957 3.582-2.103 4.366-3.297C13.225 9.666 13.5 8.358 13.5 7V3.48a.25.25 0 0 0-.174-.238l-5.25-1.68a.25.25 0 0 0-.153 0ZM9.5 6.5c0 .536-.286 1.032-.75 1.3v2.45a.75.75 0 0 1-1.5 0V7.8A1.5 1.5 0 1 1 9.5 6.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.46 1.137a1.748 1.748 0 0 1 1.08 0l8.25 2.675A1.75 1.75 0 0 1 22 5.476V10.5c0 6.19-3.77 10.705-9.401 12.83a1.704 1.704 0 0 1-1.198 0C5.771 21.204 2 16.69 2 10.5V5.476c0-.76.49-1.43 1.21-1.664Zm.617 1.426a.253.253 0 0 0-.154 0L3.673 5.24a.25.25 0 0 0-.173.237V10.5c0 5.461 3.28 9.483 8.43 11.426a.199.199 0 0 0 .14 0c5.15-1.943 8.43-5.965 8.43-11.426V5.476a.25.25 0 0 0-.173-.237ZM13 12.232V15a1 1 0 0 1-2 0v-2.768a2 2 0 1 1 2 0Z"
      })
    }
  };
});
var ShieldSlashIcon = /*#__PURE__*/createIconComponent("ShieldSlashIcon", "octicon octicon-shield-slash", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.533.133a1.75 1.75 0 0 0-1.066 0l-2.091.67a.75.75 0 0 0 .457 1.428l2.09-.67a.25.25 0 0 1 .153 0l5.25 1.68a.25.25 0 0 1 .174.239V7c0 .233-.008.464-.025.694a.75.75 0 1 0 1.495.112c.02-.27.03-.538.03-.806V3.48a1.75 1.75 0 0 0-1.217-1.667L8.533.133ZM1 2.857l-.69-.5a.75.75 0 1 1 .88-1.214l14.5 10.5a.75.75 0 1 1-.88 1.214l-1.282-.928c-.995 1.397-2.553 2.624-4.864 3.608-.425.181-.905.18-1.329 0-2.447-1.042-4.049-2.356-5.032-3.855C1.32 10.182 1 8.566 1 7Zm1.5 1.086V7c0 1.358.275 2.666 1.057 3.86.784 1.194 2.121 2.34 4.366 3.297.05.02.106.02.153 0 2.127-.905 3.439-1.982 4.237-3.108Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12.54 1.137a1.748 1.748 0 0 0-1.08 0L6.018 2.905a.75.75 0 1 0 .464 1.427l5.441-1.768a.239.239 0 0 1 .154 0l8.25 2.675a.249.249 0 0 1 .173.237V10.5c0 1.284-.24 2.83-.696 3.971a.75.75 0 1 0 1.392.557C21.74 13.67 22 11.927 22 10.5V5.476a1.75 1.75 0 0 0-1.21-1.664l-8.25-2.675ZM2.017 4.843l-.974-.748a.751.751 0 0 1 .914-1.19l20.5 15.75a.751.751 0 0 1-.914 1.19l-2.012-1.546-.702.852-.008.009a.07.07 0 0 1-.008.01c-1.603 1.821-3.731 3.223-6.214 4.16a1.699 1.699 0 0 1-1.198-.001C5.771 21.205 2 16.689 2 10.5V5c0-.054.006-.107.017-.157ZM3.5 5.982V10.5c0 5.461 3.281 9.483 8.431 11.426a.193.193 0 0 0 .138 0c2.283-.861 4.192-2.131 5.61-3.738l.662-.803Z"
      })
    }
  };
});
var ShieldXIcon = /*#__PURE__*/createIconComponent("ShieldXIcon", "octicon octicon-shield-x", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m8.533.133 5.25 1.68A1.75 1.75 0 0 1 15 3.48V7c0 1.566-.32 3.182-1.303 4.682-.983 1.498-2.585 2.813-5.032 3.855a1.697 1.697 0 0 1-1.33 0c-2.447-1.042-4.049-2.357-5.032-3.855C1.32 10.182 1 8.566 1 7V3.48a1.75 1.75 0 0 1 1.217-1.667l5.25-1.68a1.748 1.748 0 0 1 1.066 0Zm-.61 1.429.001.001-5.25 1.68a.251.251 0 0 0-.174.237V7c0 1.36.275 2.666 1.057 3.859.784 1.194 2.121 2.342 4.366 3.298a.196.196 0 0 0 .154 0c2.245-.957 3.582-2.103 4.366-3.297C13.225 9.666 13.5 8.358 13.5 7V3.48a.25.25 0 0 0-.174-.238l-5.25-1.68a.25.25 0 0 0-.153 0ZM6.78 5.22 8 6.44l1.22-1.22a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734L9.06 7.5l1.22 1.22a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L8 8.56 6.78 9.78a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042L6.94 7.5 5.72 6.28a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9.28 7.72a.75.75 0 0 0-1.06 1.06l2.72 2.72-2.72 2.72a.75.75 0 1 0 1.06 1.06L12 12.56l2.72 2.72a.75.75 0 1 0 1.06-1.06l-2.72-2.72 2.72-2.72a.75.75 0 0 0-1.06-1.06L12 10.44 9.28 7.72Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m12.54.637 8.25 2.675A1.75 1.75 0 0 1 22 4.976V10c0 6.19-3.771 10.704-9.401 12.83a1.704 1.704 0 0 1-1.198 0C5.77 20.705 2 16.19 2 10V4.976c0-.758.489-1.43 1.21-1.664L11.46.637a1.748 1.748 0 0 1 1.08 0Zm-.617 1.426-8.25 2.676a.249.249 0 0 0-.173.237V10c0 5.46 3.28 9.483 8.43 11.426a.199.199 0 0 0 .14 0C17.22 19.483 20.5 15.461 20.5 10V4.976a.25.25 0 0 0-.173-.237l-8.25-2.676a.253.253 0 0 0-.154 0Z"
      }))
    }
  };
});
var SidebarCollapseIcon = /*#__PURE__*/createIconComponent("SidebarCollapseIcon", "octicon octicon-sidebar-collapse", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6.823 7.823a.25.25 0 0 1 0 .354l-2.396 2.396A.25.25 0 0 1 4 10.396V5.604a.25.25 0 0 1 .427-.177Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.75 0h12.5C15.216 0 16 .784 16 1.75v12.5A1.75 1.75 0 0 1 14.25 16H1.75A1.75 1.75 0 0 1 0 14.25V1.75C0 .784.784 0 1.75 0ZM1.5 1.75v12.5c0 .138.112.25.25.25H9.5v-13H1.75a.25.25 0 0 0-.25.25ZM11 14.5h3.25a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25H11Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.22 14.47 9.69 12 7.22 9.53a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215l3 3a.75.75 0 0 1 0 1.06l-3 3a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 2h16.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25V3.75C2 2.784 2.784 2 3.75 2ZM3.5 3.75v16.5c0 .138.112.25.25.25H15v-17H3.75a.25.25 0 0 0-.25.25Zm13 16.75h3.75a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25H16.5Z"
      }))
    }
  };
});
var SidebarExpandIcon = /*#__PURE__*/createIconComponent("SidebarExpandIcon", "octicon octicon-sidebar-expand", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m4.177 7.823 2.396-2.396A.25.25 0 0 1 7 5.604v4.792a.25.25 0 0 1-.427.177L4.177 8.177a.25.25 0 0 1 0-.354Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 1.75C0 .784.784 0 1.75 0h12.5C15.216 0 16 .784 16 1.75v12.5A1.75 1.75 0 0 1 14.25 16H1.75A1.75 1.75 0 0 1 0 14.25Zm1.75-.25a.25.25 0 0 0-.25.25v12.5c0 .138.112.25.25.25H9.5v-13Zm12.5 13a.25.25 0 0 0 .25-.25V1.75a.25.25 0 0 0-.25-.25H11v13Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.28 9.53 8.81 12l2.47 2.47a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215l-3-3a.75.75 0 0 1 0-1.06l3-3a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.75 2h16.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25V3.75C2 2.784 2.784 2 3.75 2ZM3.5 3.75v16.5c0 .138.112.25.25.25H15v-17H3.75a.25.25 0 0 0-.25.25Zm13 16.75h3.75a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25H16.5Z"
      }))
    }
  };
});
var SignInIcon = /*#__PURE__*/createIconComponent("SignInIcon", "octicon octicon-sign-in", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 2.75C2 1.784 2.784 1 3.75 1h2.5a.75.75 0 0 1 0 1.5h-2.5a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h2.5a.75.75 0 0 1 0 1.5h-2.5A1.75 1.75 0 0 1 2 13.25Zm6.56 4.5h5.69a.75.75 0 0 1 0 1.5H8.56l1.97 1.97a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L6.22 8.53a.75.75 0 0 1 0-1.06l3.25-3.25a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 3.25c0-.966.784-1.75 1.75-1.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.25.25 0 0 0-.25.25v17.5c0 .138.112.25.25.25h5.5a.75.75 0 0 1 0 1.5h-5.5A1.75 1.75 0 0 1 3 20.75Zm9.994 9.5 3.3 3.484a.75.75 0 0 1-1.088 1.032l-4.5-4.75a.75.75 0 0 1 0-1.032l4.5-4.75a.75.75 0 0 1 1.088 1.032l-3.3 3.484h8.256a.75.75 0 0 1 0 1.5Z"
      })
    }
  };
});
var SignOutIcon = /*#__PURE__*/createIconComponent("SignOutIcon", "octicon octicon-sign-out", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 2.75C2 1.784 2.784 1 3.75 1h2.5a.75.75 0 0 1 0 1.5h-2.5a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h2.5a.75.75 0 0 1 0 1.5h-2.5A1.75 1.75 0 0 1 2 13.25Zm10.44 4.5-1.97-1.97a.749.749 0 0 1 .326-1.275.749.749 0 0 1 .734.215l3.25 3.25a.75.75 0 0 1 0 1.06l-3.25 3.25a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l1.97-1.97H6.75a.75.75 0 0 1 0-1.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3 3.25c0-.966.784-1.75 1.75-1.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.25.25 0 0 0-.25.25v17.5c0 .138.112.25.25.25h5.5a.75.75 0 0 1 0 1.5h-5.5A1.75 1.75 0 0 1 3 20.75Zm16.006 9.5H10.75a.75.75 0 0 1 0-1.5h8.256l-3.3-3.484a.75.75 0 0 1 1.088-1.032l4.5 4.75a.75.75 0 0 1 0 1.032l-4.5 4.75a.75.75 0 0 1-1.088-1.032Z"
      })
    }
  };
});
var SingleSelectIcon = /*#__PURE__*/createIconComponent("SingleSelectIcon", "octicon octicon-single-select", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m5.06 7.356 2.795 2.833c.08.081.21.081.29 0l2.794-2.833c.13-.131.038-.356-.145-.356H5.206c-.183 0-.275.225-.145.356Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 2.75C1 1.784 1.784 1 2.75 1h10.5c.966 0 1.75.784 1.75 1.75v10.5A1.75 1.75 0 0 1 13.25 15H2.75A1.75 1.75 0 0 1 1 13.25Zm1.75-.25a.25.25 0 0 0-.25.25v10.5c0 .138.112.25.25.25h10.5a.25.25 0 0 0 .25-.25V2.75a.25.25 0 0 0-.25-.25Z"
      }))
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m7.854 10.854 3.792 3.792a.5.5 0 0 0 .708 0l3.793-3.792a.5.5 0 0 0-.354-.854H8.207a.5.5 0 0 0-.353.854Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M2 3.75C2 2.784 2.784 2 3.75 2h16.5c.966 0 1.75.784 1.75 1.75v16.5A1.75 1.75 0 0 1 20.25 22H3.75A1.75 1.75 0 0 1 2 20.25Zm1.75-.25a.25.25 0 0 0-.25.25v16.5c0 .138.112.25.25.25h16.5a.25.25 0 0 0 .25-.25V3.75a.25.25 0 0 0-.25-.25Z"
      }))
    }
  };
});
var SkipIcon = /*#__PURE__*/createIconComponent("SkipIcon", "octicon octicon-skip", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0ZM1.5 8a6.5 6.5 0 1 0 13 0 6.5 6.5 0 0 0-13 0Zm9.78-2.22-5.5 5.5a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l5.5-5.5a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M17.28 7.78a.75.75 0 0 0-1.06-1.06l-9.5 9.5a.75.75 0 1 0 1.06 1.06l9.5-9.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      }))
    }
  };
});
var SkipFillIcon = /*#__PURE__*/createIconComponent("SkipFillIcon", "octicon octicon-skip-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8Zm11.333-2.167a.825.825 0 0 0-1.166-1.166l-5.5 5.5a.825.825 0 0 0 1.166 1.166Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1 12C1 5.925 5.925 1 12 1s11 4.925 11 11-4.925 11-11 11S1 18.075 1 12Zm16.333-4.167a.825.825 0 0 0-1.166-1.166l-9.5 9.5a.825.825 0 0 0 1.166 1.166Z"
      })
    }
  };
});
var SlidersIcon = /*#__PURE__*/createIconComponent("SlidersIcon", "octicon octicon-sliders", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M15 2.75a.75.75 0 0 1-.75.75h-4a.75.75 0 0 1 0-1.5h4a.75.75 0 0 1 .75.75Zm-8.5.75v1.25a.75.75 0 0 0 1.5 0v-4a.75.75 0 0 0-1.5 0V2H1.75a.75.75 0 0 0 0 1.5H6.5Zm1.25 5.25a.75.75 0 0 0 0-1.5h-6a.75.75 0 0 0 0 1.5h6ZM15 8a.75.75 0 0 1-.75.75H11.5V10a.75.75 0 1 1-1.5 0V6a.75.75 0 0 1 1.5 0v1.25h2.75A.75.75 0 0 1 15 8Zm-9 5.25v-2a.75.75 0 0 0-1.5 0v1.25H1.75a.75.75 0 0 0 0 1.5H4.5v1.25a.75.75 0 0 0 1.5 0v-2Zm9 0a.75.75 0 0 1-.75.75h-6a.75.75 0 0 1 0-1.5h6a.75.75 0 0 1 .75.75Z"
      })
    }
  };
});
var SmileyIcon = /*#__PURE__*/createIconComponent("SmileyIcon", "octicon octicon-smiley", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0ZM1.5 8a6.5 6.5 0 1 0 13 0 6.5 6.5 0 0 0-13 0Zm3.82 1.636a.75.75 0 0 1 1.038.175l.007.009c.103.118.22.222.35.31.264.178.683.37 1.285.37.602 0 1.02-.192 1.285-.371.13-.088.247-.192.35-.31l.007-.008a.75.75 0 0 1 1.222.87l-.022-.015c.02.013.021.015.021.015v.001l-.001.002-.002.003-.005.007-.014.019a2.066 2.066 0 0 1-.184.213c-.16.166-.338.316-.53.445-.63.418-1.37.638-2.127.629-.946 0-1.652-.308-2.126-.63a3.331 3.331 0 0 1-.715-.657l-.014-.02-.005-.006-.002-.003v-.002h-.001l.613-.432-.614.43a.75.75 0 0 1 .183-1.044ZM12 7a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM5 8a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm5.25 2.25.592.416a97.71 97.71 0 0 0-.592-.416Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8.456 14.494a.75.75 0 0 1 1.068.17 3.08 3.08 0 0 0 .572.492A3.381 3.381 0 0 0 12 15.72c.855 0 1.487-.283 1.904-.562a3.081 3.081 0 0 0 .572-.492l.021-.026a.75.75 0 0 1 1.197.905l-.027.034c-.013.016-.03.038-.052.063-.044.05-.105.119-.184.198a4.569 4.569 0 0 1-.695.566A4.88 4.88 0 0 1 12 17.22a4.88 4.88 0 0 1-2.736-.814 4.57 4.57 0 0 1-.695-.566 3.253 3.253 0 0 1-.236-.261c-.259-.332-.223-.824.123-1.084Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1ZM2.5 12a9.5 9.5 0 0 0 9.5 9.5 9.5 9.5 0 0 0 9.5-9.5A9.5 9.5 0 0 0 12 2.5 9.5 9.5 0 0 0 2.5 12Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M9 10.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM16.25 12a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"
      }))
    }
  };
});
var SortAscIcon = /*#__PURE__*/createIconComponent("SortAscIcon", "octicon octicon-sort-asc", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m12.927 2.573 3 3A.25.25 0 0 1 15.75 6H13.5v6.75a.75.75 0 0 1-1.5 0V6H9.75a.25.25 0 0 1-.177-.427l3-3a.25.25 0 0 1 .354 0ZM0 12.25a.75.75 0 0 1 .75-.75h7.5a.75.75 0 0 1 0 1.5H.75a.75.75 0 0 1-.75-.75Zm0-4a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 0 1.5H.75A.75.75 0 0 1 0 8.25Zm0-4a.75.75 0 0 1 .75-.75h2.5a.75.75 0 0 1 0 1.5H.75A.75.75 0 0 1 0 4.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M18.5 17.25a.75.75 0 0 1-1.5 0V7.56l-2.22 2.22a.75.75 0 1 1-1.06-1.06l3.5-3.5a.75.75 0 0 1 1.06 0l3.5 3.5a.75.75 0 0 1-1.06 1.06L18.5 7.56v9.69Zm-15.75.25a.75.75 0 0 1 0-1.5h9.5a.75.75 0 0 1 0 1.5h-9.5Zm0-5a.75.75 0 0 1 0-1.5h5.5a.75.75 0 0 1 0 1.5h-5.5Zm0-5a.75.75 0 0 1 0-1.5h3.5a.75.75 0 0 1 0 1.5h-3.5Z"
      })
    }
  };
});
var SortDescIcon = /*#__PURE__*/createIconComponent("SortDescIcon", "octicon octicon-sort-desc", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M0 4.25a.75.75 0 0 1 .75-.75h7.5a.75.75 0 0 1 0 1.5H.75A.75.75 0 0 1 0 4.25Zm0 4a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 0 1.5H.75A.75.75 0 0 1 0 8.25Zm0 4a.75.75 0 0 1 .75-.75h2.5a.75.75 0 0 1 0 1.5H.75a.75.75 0 0 1-.75-.75ZM13.5 10h2.25a.25.25 0 0 1 .177.427l-3 3a.25.25 0 0 1-.354 0l-3-3A.25.25 0 0 1 9.75 10H12V3.75a.75.75 0 0 1 1.5 0V10Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M18.5 16.44V6.75a.75.75 0 0 0-1.5 0v9.69l-2.22-2.22a.75.75 0 1 0-1.06 1.06l3.5 3.5a.75.75 0 0 0 1.06 0l3.5-3.5a.75.75 0 1 0-1.06-1.06l-2.22 2.22ZM2 7.25a.75.75 0 0 1 .75-.75h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 2 7.25Zm0 5a.75.75 0 0 1 .75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.75.75 0 0 1-.75-.75Zm0 5a.75.75 0 0 1 .75-.75h3.5a.75.75 0 0 1 0 1.5h-3.5a.75.75 0 0 1-.75-.75Z"
      })
    }
  };
});
var SparkleFillIcon = /*#__PURE__*/createIconComponent("SparkleFillIcon", "octicon octicon-sparkle-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.53 1.282a.5.5 0 0 1 .94 0l.478 1.306a7.492 7.492 0 0 0 4.464 4.464l1.305.478a.5.5 0 0 1 0 .94l-1.305.478a7.492 7.492 0 0 0-4.464 4.464l-.478 1.305a.5.5 0 0 1-.94 0l-.478-1.305a7.492 7.492 0 0 0-4.464-4.464L1.282 8.47a.5.5 0 0 1 0-.94l1.306-.478a7.492 7.492 0 0 0 4.464-4.464Z"
      })
    }
  };
});
var SponsorTiersIcon = /*#__PURE__*/createIconComponent("SponsorTiersIcon", "octicon octicon-sponsor-tiers", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.586 1C12.268 1 13.5 2.37 13.5 4.25c0 1.745-.996 3.359-2.622 4.831-.166.15-.336.297-.509.438l1.116 5.584a.75.75 0 0 1-.991.852l-2.409-.876a.25.25 0 0 0-.17 0l-2.409.876a.75.75 0 0 1-.991-.852L5.63 9.519a13.78 13.78 0 0 1-.51-.438C3.497 7.609 2.5 5.995 2.5 4.25 2.5 2.37 3.732 1 5.414 1c.963 0 1.843.403 2.474 1.073L8 2.198l.112-.125a3.385 3.385 0 0 1 2.283-1.068L10.586 1Zm-3.621 9.495-.718 3.594 1.155-.42a1.75 1.75 0 0 1 1.028-.051l.168.051 1.154.42-.718-3.592c-.199.13-.37.235-.505.314l-.169.097a.75.75 0 0 1-.72 0 9.54 9.54 0 0 1-.515-.308l-.16-.105ZM10.586 2.5c-.863 0-1.611.58-1.866 1.459-.209.721-1.231.721-1.44 0C7.025 3.08 6.277 2.5 5.414 2.5 4.598 2.5 4 3.165 4 4.25c0 1.23.786 2.504 2.128 3.719.49.443 1.018.846 1.546 1.198l.325.21.076-.047.251-.163a13.341 13.341 0 0 0 1.546-1.198C11.214 6.754 12 5.479 12 4.25c0-1.085-.598-1.75-1.414-1.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M16.004 1.25C18.311 1.25 20 3.128 20 5.75c0 2.292-1.23 4.464-3.295 6.485-.481.47-.98.909-1.482 1.31l.265 1.32 1.375 7.5a.75.75 0 0 1-.982.844l-3.512-1.207a.75.75 0 0 0-.488 0L8.37 23.209a.75.75 0 0 1-.982-.844l1.378-7.512.261-1.309c-.5-.4-1-.838-1.481-1.31C5.479 10.215 4.25 8.043 4.25 5.75c0-2.622 1.689-4.5 3.996-4.5 1.55 0 2.947.752 3.832 1.967l.047.067.047-.067a4.726 4.726 0 0 1 3.612-1.962l.22-.005ZM13.89 14.531c-.418.285-.828.542-1.218.77l-.18.103a.75.75 0 0 1-.734 0l-.071-.04-.46-.272c-.282-.173-.573-.36-.868-.562l-.121.605-1.145 6.239 2.3-.79a2.248 2.248 0 0 1 1.284-.054l.18.053 2.299.79-1.141-6.226-.125-.616ZM16.004 2.75c-1.464 0-2.731.983-3.159 2.459-.209.721-1.231.721-1.44 0-.428-1.476-1.695-2.459-3.16-2.459-1.44 0-2.495 1.173-2.495 3 0 1.811 1.039 3.647 2.844 5.412a19.624 19.624 0 0 0 3.734 2.84l-.019-.011-.184-.111.147-.088a19.81 19.81 0 0 0 3.015-2.278l.37-.352C17.46 9.397 18.5 7.561 18.5 5.75c0-1.827-1.055-3-2.496-3Z"
      })
    }
  };
});
var SquareIcon = /*#__PURE__*/createIconComponent("SquareIcon", "octicon octicon-square", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4 5.75C4 4.784 4.784 4 5.75 4h4.5c.966 0 1.75.784 1.75 1.75v4.5A1.75 1.75 0 0 1 10.25 12h-4.5A1.75 1.75 0 0 1 4 10.25Zm1.75-.25a.25.25 0 0 0-.25.25v4.5c0 .138.112.25.25.25h4.5a.25.25 0 0 0 .25-.25v-4.5a.25.25 0 0 0-.25-.25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M6 7.75C6 6.784 6.784 6 7.75 6h8.5c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 16.25 18h-8.5A1.75 1.75 0 0 1 6 16.25Zm1.75-.25a.25.25 0 0 0-.25.25v8.5c0 .138.112.25.25.25h8.5a.25.25 0 0 0 .25-.25v-8.5a.25.25 0 0 0-.25-.25Z"
      })
    }
  };
});
var SquareFillIcon = /*#__PURE__*/createIconComponent("SquareFillIcon", "octicon octicon-square-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75 4h4.5c.966 0 1.75.784 1.75 1.75v4.5A1.75 1.75 0 0 1 10.25 12h-4.5A1.75 1.75 0 0 1 4 10.25v-4.5C4 4.784 4.784 4 5.75 4Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.75 6h8.5c.966 0 1.75.784 1.75 1.75v8.5A1.75 1.75 0 0 1 16.25 18h-8.5A1.75 1.75 0 0 1 6 16.25v-8.5C6 6.784 6.784 6 7.75 6Z"
      })
    }
  };
});
var SquirrelIcon = /*#__PURE__*/createIconComponent("SquirrelIcon", "octicon octicon-squirrel", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.499.75a.75.75 0 0 1 1.5 0v.996C5.9 2.903 6.793 3.65 7.662 4.376l.24.202c-.036-.694.055-1.422.426-2.163C9.1.873 10.794-.045 12.622.26 14.408.558 16 1.94 16 4.25c0 1.278-.954 2.575-2.44 2.734l.146.508.065.22c.203.701.412 1.455.476 2.226.142 1.707-.4 3.03-1.487 3.898C11.714 14.671 10.27 15 8.75 15h-6a.75.75 0 0 1 0-1.5h1.376a4.484 4.484 0 0 1-.563-1.191 3.835 3.835 0 0 1-.05-2.063 4.647 4.647 0 0 1-2.025-.293.75.75 0 0 1 .525-1.406c1.357.507 2.376-.006 2.698-.318l.009-.01a.747.747 0 0 1 1.06 0 .748.748 0 0 1-.012 1.074c-.912.92-.992 1.835-.768 2.586.221.74.745 1.337 1.196 1.621H8.75c1.343 0 2.398-.296 3.074-.836.635-.507 1.036-1.31.928-2.602-.05-.603-.216-1.224-.422-1.93l-.064-.221c-.12-.407-.246-.84-.353-1.29a2.425 2.425 0 0 1-.507-.441 3.075 3.075 0 0 1-.633-1.248.75.75 0 0 1 1.455-.364c.046.185.144.436.31.627.146.168.353.305.712.305.738 0 1.25-.615 1.25-1.25 0-1.47-.95-2.315-2.123-2.51-1.172-.196-2.227.387-2.706 1.345-.46.92-.27 1.774.019 3.062l.042.19a.884.884 0 0 1 .01.05c.348.443.666.949.94 1.553a.75.75 0 1 1-1.365.62c-.553-1.217-1.32-1.94-2.3-2.768L6.7 5.527c-.814-.68-1.75-1.462-2.692-2.619a3.737 3.737 0 0 0-1.023.88c-.406.495-.663 1.036-.722 1.508.116.122.306.21.591.239.388.038.797-.06 1.032-.19a.75.75 0 0 1 .728 1.31c-.515.287-1.23.439-1.906.373-.682-.067-1.473-.38-1.879-1.193L.75 5.677V5.5c0-.984.48-1.94 1.077-2.664.46-.559 1.05-1.055 1.673-1.353V.75Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M18.377 3.49c-1.862-.31-3.718.62-4.456 2.095-.428.857-.691 1.624-.728 2.361-.035.71.138 1.444.67 2.252.644.854 1.199 1.913 1.608 3.346a.75.75 0 1 1-1.442.412c-.353-1.236-.82-2.135-1.372-2.865l-.008-.01c-.53-.698-1.14-1.242-1.807-1.778a50.724 50.724 0 0 0-.667-.524C9.024 7.884 7.71 6.863 6.471 5.16c-.59.287-1.248.798-1.806 1.454-.665.78-1.097 1.66-1.158 2.446.246.36.685.61 1.246.715.643.12 1.278.015 1.633-.182a.75.75 0 1 1 .728 1.311c-.723.402-1.728.516-2.637.346-.916-.172-1.898-.667-2.398-1.666L2 9.427V9.25c0-1.323.678-2.615 1.523-3.607.7-.824 1.59-1.528 2.477-1.917V2.75a.75.75 0 1 1 1.5 0v1.27c1.154 1.67 2.363 2.612 3.568 3.551.207.162.415.323.621.489.001-.063.003-.126.006-.188.052-1.034.414-2.017.884-2.958 1.06-2.118 3.594-3.313 6.044-2.904 1.225.204 2.329.795 3.125 1.748C22.546 4.713 23 5.988 23 7.5c0 1.496-.913 3.255-2.688 3.652.838 1.699 1.438 3.768 1.181 5.697-.269 2.017-1.04 3.615-2.582 4.675C17.409 22.558 15.288 23 12.5 23H4.75a.75.75 0 0 1 0-1.5h2.322c-.58-.701-.998-1.578-1.223-2.471-.327-1.3-.297-2.786.265-4.131-.92.091-1.985-.02-3.126-.445a.75.75 0 1 1 .524-1.406c1.964.733 3.428.266 4.045-.19.068-.06.137-.12.208-.18a.745.745 0 0 1 .861-.076.746.746 0 0 1 .32.368.752.752 0 0 1-.173.819c-.077.076-.16.15-.252.221-1.322 1.234-1.62 3.055-1.218 4.654.438 1.737 1.574 2.833 2.69 2.837H12.5c2.674 0 4.429-.433 5.56-1.212 1.094-.752 1.715-1.904 1.946-3.637.236-1.768-.445-3.845-1.407-5.529a.576.576 0 0 1-.012-.02 3.557 3.557 0 0 1-1.553-.94c-.556-.565-.89-1.243-1.012-1.73a.75.75 0 0 1 1.456-.364c.057.231.26.67.626 1.043.35.357.822.623 1.443.623 1.172 0 1.953-1.058 1.953-2.234 0-1.205-.357-2.127-.903-2.78-.547-.654-1.318-1.08-2.22-1.23Z"
      })
    }
  };
});
var StackIcon = /*#__PURE__*/createIconComponent("StackIcon", "octicon octicon-stack", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.122.392a1.75 1.75 0 0 1 1.756 0l5.003 2.902c.83.481.83 1.68 0 2.162L8.878 8.358a1.75 1.75 0 0 1-1.756 0L2.119 5.456a1.251 1.251 0 0 1 0-2.162ZM8.125 1.69a.248.248 0 0 0-.25 0l-4.63 2.685 4.63 2.685a.248.248 0 0 0 .25 0l4.63-2.685ZM1.601 7.789a.75.75 0 0 1 1.025-.273l5.249 3.044a.248.248 0 0 0 .25 0l5.249-3.044a.75.75 0 0 1 .752 1.298l-5.248 3.044a1.75 1.75 0 0 1-1.756 0L1.874 8.814A.75.75 0 0 1 1.6 7.789Zm0 3.5a.75.75 0 0 1 1.025-.273l5.249 3.044a.248.248 0 0 0 .25 0l5.249-3.044a.75.75 0 0 1 .752 1.298l-5.248 3.044a1.75 1.75 0 0 1-1.756 0l-5.248-3.044a.75.75 0 0 1-.273-1.025Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.063 1.456a1.749 1.749 0 0 1 1.874 0l8.383 5.316a1.751 1.751 0 0 1 0 2.956l-8.383 5.316a1.749 1.749 0 0 1-1.874 0L2.68 9.728a1.751 1.751 0 0 1 0-2.956Zm1.071 1.267a.25.25 0 0 0-.268 0L3.483 8.039a.25.25 0 0 0 0 .422l8.383 5.316a.25.25 0 0 0 .268 0l8.383-5.316a.25.25 0 0 0 0-.422Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.867 12.324a.75.75 0 0 1 1.035-.232l8.964 5.685a.25.25 0 0 0 .268 0l8.964-5.685a.75.75 0 0 1 .804 1.267l-8.965 5.685a1.749 1.749 0 0 1-1.874 0l-8.965-5.685a.75.75 0 0 1-.231-1.035Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.867 16.324a.75.75 0 0 1 1.035-.232l8.964 5.685a.25.25 0 0 0 .268 0l8.964-5.685a.75.75 0 0 1 .804 1.267l-8.965 5.685a1.749 1.749 0 0 1-1.874 0l-8.965-5.685a.75.75 0 0 1-.231-1.035Z"
      }))
    }
  };
});
var StarIcon = /*#__PURE__*/createIconComponent("StarIcon", "octicon octicon-star", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 .25a.75.75 0 0 1 .673.418l1.882 3.815 4.21.612a.75.75 0 0 1 .416 1.279l-3.046 2.97.719 4.192a.751.751 0 0 1-1.088.791L8 12.347l-3.766 1.98a.75.75 0 0 1-1.088-.79l.72-4.194L.818 6.374a.75.75 0 0 1 .416-1.28l4.21-.611L7.327.668A.75.75 0 0 1 8 .25Zm0 2.445L6.615 5.5a.75.75 0 0 1-.564.41l-3.097.45 2.24 2.184a.75.75 0 0 1 .216.664l-.528 3.084 2.769-1.456a.75.75 0 0 1 .698 0l2.77 1.456-.53-3.084a.75.75 0 0 1 .216-.664l2.24-2.183-3.096-.45a.75.75 0 0 1-.564-.41L8 2.694Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 .25a.75.75 0 0 1 .673.418l3.058 6.197 6.839.994a.75.75 0 0 1 .415 1.279l-4.948 4.823 1.168 6.811a.751.751 0 0 1-1.088.791L12 18.347l-6.117 3.216a.75.75 0 0 1-1.088-.79l1.168-6.812-4.948-4.823a.75.75 0 0 1 .416-1.28l6.838-.993L11.328.668A.75.75 0 0 1 12 .25Zm0 2.445L9.44 7.882a.75.75 0 0 1-.565.41l-5.725.832 4.143 4.038a.748.748 0 0 1 .215.664l-.978 5.702 5.121-2.692a.75.75 0 0 1 .698 0l5.12 2.692-.977-5.702a.748.748 0 0 1 .215-.664l4.143-4.038-5.725-.831a.75.75 0 0 1-.565-.41L12 2.694Z"
      })
    }
  };
});
var StarFillIcon = /*#__PURE__*/createIconComponent("StarFillIcon", "octicon octicon-star-fill", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 .25a.75.75 0 0 1 .673.418l1.882 3.815 4.21.612a.75.75 0 0 1 .416 1.279l-3.046 2.97.719 4.192a.751.751 0 0 1-1.088.791L8 12.347l-3.766 1.98a.75.75 0 0 1-1.088-.79l.72-4.194L.818 6.374a.75.75 0 0 1 .416-1.28l4.21-.611L7.327.668A.75.75 0 0 1 8 .25Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m12.672.668 3.059 6.197 6.838.993a.75.75 0 0 1 .416 1.28l-4.948 4.823 1.168 6.812a.75.75 0 0 1-1.088.79L12 18.347l-6.116 3.216a.75.75 0 0 1-1.088-.791l1.168-6.811-4.948-4.823a.749.749 0 0 1 .416-1.279l6.838-.994L11.327.668a.75.75 0 0 1 1.345 0Z"
      })
    }
  };
});
var StopIcon = /*#__PURE__*/createIconComponent("StopIcon", "octicon octicon-stop", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M4.47.22A.749.749 0 0 1 5 0h6c.199 0 .389.079.53.22l4.25 4.25c.141.14.22.331.22.53v6a.749.749 0 0 1-.22.53l-4.25 4.25A.749.749 0 0 1 11 16H5a.749.749 0 0 1-.53-.22L.22 11.53A.749.749 0 0 1 0 11V5c0-.199.079-.389.22-.53Zm.84 1.28L1.5 5.31v5.38l3.81 3.81h5.38l3.81-3.81V5.31L10.69 1.5ZM8 4a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-3.5A.75.75 0 0 1 8 4Zm0 8a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 7a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-1.5 0v-4.5A.75.75 0 0 1 12 7Zm0 10a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M7.328 1.47a.749.749 0 0 1 .53-.22h8.284c.199 0 .389.079.53.22l5.858 5.858c.141.14.22.33.22.53v8.284a.749.749 0 0 1-.22.53l-5.858 5.858a.749.749 0 0 1-.53.22H7.858a.749.749 0 0 1-.53-.22L1.47 16.672a.749.749 0 0 1-.22-.53V7.858c0-.199.079-.389.22-.53Zm.84 1.28L2.75 8.169v7.662l5.419 5.419h7.662l5.419-5.418V8.168L15.832 2.75Z"
      }))
    }
  };
});
var StopwatchIcon = /*#__PURE__*/createIconComponent("StopwatchIcon", "octicon octicon-stopwatch", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M5.75.75A.75.75 0 0 1 6.5 0h3a.75.75 0 0 1 0 1.5h-.75v1l-.001.041a6.724 6.724 0 0 1 3.464 1.435l.007-.006.75-.75a.749.749 0 0 1 1.275.326.749.749 0 0 1-.215.734l-.75.75-.006.007a6.75 6.75 0 1 1-10.548 0L2.72 5.03l-.75-.75a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018l.75.75.007.006A6.72 6.72 0 0 1 7.25 2.541V1.5H6.5a.75.75 0 0 1-.75-.75ZM8 14.5a5.25 5.25 0 1 0-.001-10.501A5.25 5.25 0 0 0 8 14.5Zm.389-6.7 1.33-1.33a.75.75 0 1 1 1.061 1.06L9.45 8.861A1.503 1.503 0 0 1 8 10.75a1.499 1.499 0 1 1 .389-2.95Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M10.25 0h3.5a.75.75 0 0 1 0 1.5h-1v1.278a9.954 9.954 0 0 1 5.636 2.276L19.72 3.72a.751.751 0 0 1 1.042.018.751.751 0 0 1 .018 1.042l-1.315 1.316A9.959 9.959 0 0 1 22 12.75c0 5.523-4.477 10-10 10s-10-4.477-10-10a9.959 9.959 0 0 1 2.535-6.654L3.22 4.78a.751.751 0 0 1 .018-1.042.751.751 0 0 1 1.042-.018l1.335 1.334a9.958 9.958 0 0 1 5.635-2.276V1.5h-1a.75.75 0 0 1 0-1.5ZM12 21.25a8.5 8.5 0 1 0-.001-17.001A8.5 8.5 0 0 0 12 21.25Zm4.03-12.53a.75.75 0 0 1 0 1.06l-2.381 2.382a1.75 1.75 0 1 1-1.06-1.06l2.38-2.382a.75.75 0 0 1 1.061 0Z"
      })
    }
  };
});
var StrikethroughIcon = /*#__PURE__*/createIconComponent("StrikethroughIcon", "octicon octicon-strikethrough", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M11.055 8.5c.524.536.815 1.257.811 2.007a3.133 3.133 0 0 1-1.12 2.408C9.948 13.597 8.748 14 7.096 14c-1.706 0-3.104-.607-3.902-1.377a.751.751 0 0 1 1.042-1.079c.48.463 1.487.956 2.86.956 1.422 0 2.232-.346 2.676-.726.435-.372.594-.839.594-1.267 0-.472-.208-.857-.647-1.197-.448-.346-1.116-.623-1.951-.81H1.75a.75.75 0 0 1 0-1.5h12.5a.75.75 0 0 1 0 1.5ZM7.581 3.25c-2.036 0-2.778 1.082-2.778 1.786 0 .055.002.107.006.157a.75.75 0 0 1-1.496.114 3.506 3.506 0 0 1-.01-.271c0-1.832 1.75-3.286 4.278-3.286 1.418 0 2.721.58 3.514 1.093a.75.75 0 1 1-.814 1.26c-.64-.414-1.662-.853-2.7-.853Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m16.533 12.5.054.043c.93.75 1.538 1.77 1.538 3.066a4.13 4.13 0 0 1-1.479 3.177c-1.058.904-2.679 1.464-4.974 1.464-2.35 0-4.252-.837-5.318-1.865a.75.75 0 1 1 1.042-1.08c.747.722 2.258 1.445 4.276 1.445 2.065 0 3.296-.504 3.999-1.105a2.63 2.63 0 0 0 .954-2.036c0-.764-.337-1.38-.979-1.898-.649-.523-1.598-.931-2.76-1.211H3.75a.75.75 0 0 1 0-1.5h16.5a.75.75 0 0 1 0 1.5ZM12.36 5C9.37 5 8.105 6.613 8.105 7.848c0 .411.072.744.193 1.02a.75.75 0 0 1-1.373.603 3.988 3.988 0 0 1-.32-1.623c0-2.363 2.271-4.348 5.755-4.348 1.931 0 3.722.794 4.814 1.5a.75.75 0 1 1-.814 1.26c-.94-.607-2.448-1.26-4-1.26Z"
      })
    }
  };
});
var SunIcon = /*#__PURE__*/createIconComponent("SunIcon", "octicon octicon-sun", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M8 12a4 4 0 1 1 0-8 4 4 0 0 1 0 8Zm0-1.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Zm5.657-8.157a.75.75 0 0 1 0 1.061l-1.061 1.06a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l1.06-1.06a.75.75 0 0 1 1.06 0Zm-9.193 9.193a.75.75 0 0 1 0 1.06l-1.06 1.061a.75.75 0 1 1-1.061-1.06l1.06-1.061a.75.75 0 0 1 1.061 0ZM8 0a.75.75 0 0 1 .75.75v1.5a.75.75 0 0 1-1.5 0V.75A.75.75 0 0 1 8 0ZM3 8a.75.75 0 0 1-.75.75H.75a.75.75 0 0 1 0-1.5h1.5A.75.75 0 0 1 3 8Zm13 0a.75.75 0 0 1-.75.75h-1.5a.75.75 0 0 1 0-1.5h1.5A.75.75 0 0 1 16 8Zm-8 5a.75.75 0 0 1 .75.75v1.5a.75.75 0 0 1-1.5 0v-1.5A.75.75 0 0 1 8 13Zm3.536-1.464a.75.75 0 0 1 1.06 0l1.061 1.06a.75.75 0 0 1-1.06 1.061l-1.061-1.06a.75.75 0 0 1 0-1.061ZM2.343 2.343a.75.75 0 0 1 1.061 0l1.06 1.061a.751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018l-1.06-1.06a.75.75 0 0 1 0-1.06Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M12 19a7 7 0 1 1 0-14 7 7 0 0 1 0 14Zm0-1.5a5.5 5.5 0 1 0 0-11 5.5 5.5 0 1 0 0 11Zm-5.657.157a.75.75 0 0 1 0 1.06l-1.768 1.768a.749.749 0 0 1-1.275-.326.749.749 0 0 1 .215-.734l1.767-1.768a.75.75 0 0 1 1.061 0ZM3.515 3.515a.75.75 0 0 1 1.06 0l1.768 1.768a.749.749 0 0 1-.326 1.275.749.749 0 0 1-.734-.215L3.515 4.575a.75.75 0 0 1 0-1.06ZM12 0a.75.75 0 0 1 .75.75v2.5a.75.75 0 0 1-1.5 0V.75A.75.75 0 0 1 12 0ZM4 12a.75.75 0 0 1-.75.75H.75a.75.75 0 0 1 0-1.5h2.5A.75.75 0 0 1 4 12Zm8 8a.75.75 0 0 1 .75.75v2.5a.75.75 0 0 1-1.5 0v-2.5A.75.75 0 0 1 12 20Zm12-8a.75.75 0 0 1-.75.75h-2.5a.75.75 0 0 1 0-1.5h2.5A.75.75 0 0 1 24 12Zm-6.343 5.657a.75.75 0 0 1 1.06 0l1.768 1.768a.751.751 0 0 1-.018 1.042.751.751 0 0 1-1.042.018l-1.768-1.767a.75.75 0 0 1 0-1.061Zm2.828-14.142a.75.75 0 0 1 0 1.06l-1.768 1.768a.751.751 0 0 1-1.042-.018.751.751 0 0 1-.018-1.042l1.767-1.768a.75.75 0 0 1 1.061 0Z"
      })
    }
  };
});
var SyncIcon = /*#__PURE__*/createIconComponent("SyncIcon", "octicon octicon-sync", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M1.705 8.005a.75.75 0 0 1 .834.656 5.5 5.5 0 0 0 9.592 2.97l-1.204-1.204a.25.25 0 0 1 .177-.427h3.646a.25.25 0 0 1 .25.25v3.646a.25.25 0 0 1-.427.177l-1.38-1.38A7.002 7.002 0 0 1 1.05 8.84a.75.75 0 0 1 .656-.834ZM8 2.5a5.487 5.487 0 0 0-4.131 1.869l1.204 1.204A.25.25 0 0 1 4.896 6H1.25A.25.25 0 0 1 1 5.75V2.104a.25.25 0 0 1 .427-.177l1.38 1.38A7.002 7.002 0 0 1 14.95 7.16a.75.75 0 0 1-1.49.178A5.5 5.5 0 0 0 8 2.5Z"
      })
    },
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.38 8A9.502 9.502 0 0 1 12 2.5a9.502 9.502 0 0 1 9.215 7.182.75.75 0 1 0 1.456-.364C21.473 4.539 17.15 1 12 1a10.995 10.995 0 0 0-9.5 5.452V4.75a.75.75 0 0 0-1.5 0V8.5a1 1 0 0 0 1 1h3.75a.75.75 0 0 0 0-1.5H3.38Zm-.595 6.318a.75.75 0 0 0-1.455.364C2.527 19.461 6.85 23 12 23c4.052 0 7.592-2.191 9.5-5.451v1.701a.75.75 0 0 0 1.5 0V15.5a1 1 0 0 0-1-1h-3.75a.75.75 0 0 0 0 1.5h2.37A9.502 9.502 0 0 1 12 21.5c-4.446 0-8.181-3.055-9.215-7.182Z"
      })
    }
  };
});
var TabIcon = /*#__PURE__*/createIconComponent("TabIcon", "octicon octicon-tab", function () {
  return {
    "24": {
      "width": 24,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M22 4.25a.75.75 0 0 0-1.5 0v15a.75.75 0 0 0 1.5 0v-15Zm-9.72 14.28a.75.75 0 1 1-1.06-1.06l4.97-4.97H1.75a.75.75 0 0 1 0-1.5h14.44l-4.97-4.97a.75.75 0 0 1 1.06-1.06l6.25 6.25a.75.75 0 0 1 0 1.06l-6.25 6.25Z"
      })
    }
  };
});
var TabExternalIcon = /*#__PURE__*/createIconComponent("TabExternalIcon", "octicon octicon-tab-external", function () {
  return {
    "16": {
      "width": 16,
      "path": /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "M3.25 4a.25.25 0 0 0-.25.25v9a.75.75 0 0 1-.75.75H.75a.75.75 0 0 1 0-1.5h.75V4.25c0-.966.784-1.75 1.75-1.75h9.5c.966 0 1.75.784 1.75 1.75v8.25h.75a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75v-9a.25.25 0 0 0-.25-.25h-9.5Z"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
        d: "m7.97 7.97-2.75 2.75a.75.75 0 1 0 1.06 1.06l2.75-2.75 1.543 1.543a.25.25 0 0 0 .427-.177V6.25a.25.25 0 0 0-.25-.25H6.604a.25.25 0 0 0-.177.427L7.97 7.97Z"
      