"""
Set of top level domains for domain validation.

Sourced from https://data.iana.org/TLD/tlds-alpha-by-domain.txt.
Version 2023053100, Last Updated Wed May 31 07:07:01 2023 UTC
"""

TOP_LEVEL_DOMAINS = {
    b"AAA",
    b"AARP",
    b"ABARTH",
    b"ABB",
    b"ABBOTT",
    b"ABBVIE",
    b"ABC",
    b"ABLE",
    b"ABOGADO",
    b"ABUDHABI",
    b"AC",
    b"ACADEMY",
    b"ACCENTURE",
    b"ACCOUNTANT",
    b"ACCOUNTANTS",
    b"ACO",
    b"ACTOR",
    b"AD",
    b"ADS",
    b"ADULT",
    b"AE",
    b"AEG",
    b"AERO",
    b"AETNA",
    b"AF",
    b"AFL",
    b"AFRICA",
    b"AG",
    b"AGAKHAN",
    b"AGENCY",
    b"AI",
    b"AIG",
    b"AIRBUS",
    b"AIRFORCE",
    b"AIRTEL",
    b"AKDN",
    b"AL",
    b"ALFAROMEO",
    b"ALIBABA",
    b"ALIPAY",
    b"ALLFINANZ",
    b"ALLSTATE",
    b"ALLY",
    b"ALSACE",
    b"ALSTOM",
    b"AM",
    b"AMAZON",
    b"AMERICANEXPRESS",
    b"AMERICANFAMILY",
    b"AMEX",
    b"AMFAM",
    b"AMICA",
    b"AMSTERDAM",
    b"ANALYTICS",
    b"ANDROID",
    b"ANQUAN",
    b"ANZ",
    b"AO",
    b"AOL",
    b"APARTMENTS",
    b"APP",
    b"APPLE",
    b"AQ",
    b"AQUARELLE",
    b"AR",
    b"ARAB",
    b"ARAMCO",
    b"ARCHI",
    b"ARMY",
    b"ARPA",
    b"ART",
    b"ARTE",
    b"AS",
    b"ASDA",
    b"ASIA",
    b"ASSOCIATES",
    b"AT",
    b"ATHLETA",
    b"ATTORNEY",
    b"AU",
    b"AUCTION",
    b"AUDI",
    b"AUDIBLE",
    b"AUDIO",
    b"AUSPOST",
    b"AUTHOR",
    b"AUTO",
    b"AUTOS",
    b"AVIANCA",
    b"AW",
    b"AWS",
    b"AX",
    b"AXA",
    b"AZ",
    b"AZURE",
    b"BA",
    b"BABY",
    b"BAIDU",
    b"BANAMEX",
    b"BANANAREPUBLIC",
    b"BAND",
    b"BANK",
    b"BAR",
    b"BARCELONA",
    b"BARCLAYCARD",
    b"BARCLAYS",
    b"BAREFOOT",
    b"BARGAINS",
    b"BASEBALL",
    b"BASKETBALL",
    b"BAUHAUS",
    b"BAYERN",
    b"BB",
    b"BBC",
    b"BBT",
    b"BBVA",
    b"BCG",
    b"BCN",
    b"BD",
    b"BE",
    b"BEATS",
    b"BEAUTY",
    b"BEER",
    b"BENTLEY",
    b"BERLIN",
    b"BEST",
    b"BESTBUY",
    b"BET",
    b"BF",
    b"BG",
    b"BH",
    b"BHARTI",
    b"BI",
    b"BIBLE",
    b"BID",
    b"BIKE",
    b"BING",
    b"BINGO",
    b"BIO",
    b"BIZ",
    b"BJ",
    b"BLACK",
    b"BLACKFRIDAY",
    b"BLOCKBUSTER",
    b"BLOG",
    b"BLOOMBERG",
    b"BLUE",
    b"BM",
    b"BMS",
    b"BMW",
    b"BN",
    b"BNPPARIBAS",
    b"BO",
    b"BOATS",
    b"BOEHRINGER",
    b"BOFA",
    b"BOM",
    b"BOND",
    b"BOO",
    b"BOOK",
    b"BOOKING",
    b"BOSCH",
    b"BOSTIK",
    b"BOSTON",
    b"BOT",
    b"BOUTIQUE",
    b"BOX",
    b"BR",
    b"BRADESCO",
    b"BRIDGESTONE",
    b"BROADWAY",
    b"BROKER",
    b"BROTHER",
    b"BRUSSELS",
    b"BS",
    b"BT",
    b"BUILD",
    b"BUILDERS",
    b"BUSINESS",
    b"BUY",
    b"BUZZ",
    b"BV",
    b"BW",
    b"BY",
    b"BZ",
    b"BZH",
    b"CA",
    b"CAB",
    b"CAFE",
    b"CAL",
    b"CALL",
    b"CALVINKLEIN",
    b"CAM",
    b"CAMERA",
    b"CAMP",
    b"CANON",
    b"CAPETOWN",
    b"CAPITAL",
    b"CAPITALONE",
    b"CAR",
    b"CARAVAN",
    b"CARDS",
    b"CARE",
    b"CAREER",
    b"CAREERS",
    b"CARS",
    b"CASA",
    b"CASE",
    b"CASH",
    b"CASINO",
    b"CAT",
    b"CATERING",
    b"CATHOLIC",
    b"CBA",
    b"CBN",
    b"CBRE",
    b"CBS",
    b"CC",
    b"CD",
    b"CENTER",
    b"CEO",
    b"CERN",
    b"CF",
    b"CFA",
    b"CFD",
    b"CG",
    b"CH",
    b"CHANEL",
    b"CHANNEL",
    b"CHARITY",
    b"CHASE",
    b"CHAT",
    b"CHEAP",
    b"CHINTAI",
    b"CHRISTMAS",
    b"CHROME",
    b"CHURCH",
    b"CI",
    b"CIPRIANI",
    b"CIRCLE",
    b"CISCO",
    b"CITADEL",
    b"CITI",
    b"CITIC",
    b"CITY",
    b"CITYEATS",
    b"CK",
    b"CL",
    b"CLAIMS",
    b"CLEANING",
    b"CLICK",
    b"CLINIC",
    b"CLINIQUE",
    b"CLOTHING",
    b"CLOUD",
    b"CLUB",
    b"CLUBMED",
    b"CM",
    b"CN",
    b"CO",
    b"COACH",
    b"CODES",
    b"COFFEE",
    b"COLLEGE",
    b"COLOGNE",
    b"COM",
    b"COMCAST",
    b"COMMBANK",
    b"COMMUNITY",
    b"COMPANY",
    b"COMPARE",
    b"COMPUTER",
    b"COMSEC",
    b"CONDOS",
    b"CONSTRUCTION",
    b"CONSULTING",
    b"CONTACT",
    b"CONTRACTORS",
    b"COOKING",
    b"COOKINGCHANNEL",
    b"COOL",
    b"COOP",
    b"CORSICA",
    b"COUNTRY",
    b"COUPON",
    b"COUPONS",
    b"COURSES",
    b"CPA",
    b"CR",
    b"CREDIT",
    b"CREDITCARD",
    b"CREDITUNION",
    b"CRICKET",
    b"CROWN",
    b"CRS",
    b"CRUISE",
    b"CRUISES",
    b"CU",
    b"CUISINELLA",
    b"CV",
    b"CW",
    b"CX",
    b"CY",
    b"CYMRU",
    b"CYOU",
    b"CZ",
    b"DABUR",
    b"DAD",
    b"DANCE",
    b"DATA",
    b"DATE",
    b"DATING",
    b"DATSUN",
    b"DAY",
    b"DCLK",
    b"DDS",
    b"DE",
    b"DEAL",
    b"DEALER",
    b"DEALS",
    b"DEGREE",
    b"DELIVERY",
    b"DELL",
    b"DELOITTE",
    b"DELTA",
    b"DEMOCRAT",
    b"DENTAL",
    b"DENTIST",
    b"DESI",
    b"DESIGN",
    b"DEV",
    b"DHL",
    b"DIAMONDS",
    b"DIET",
    b"DIGITAL",
    b"DIRECT",
    b"DIRECTORY",
    b"DISCOUNT",
    b"DISCOVER",
    b"DISH",
    b"DIY",
    b"DJ",
    b"DK",
    b"DM",
    b"DNP",
    b"DO",
    b"DOCS",
    b"DOCTOR",
    b"DOG",
    b"DOMAINS",
    b"DOT",
    b"DOWNLOAD",
    b"DRIVE",
    b"DTV",
    b"DUBAI",
    b"DUNLOP",
    b"DUPONT",
    b"DURBAN",
    b"DVAG",
    b"DVR",
    b"DZ",
    b"EARTH",
    b"EAT",
    b"EC",
    b"ECO",
    b"EDEKA",
    b"EDU",
    b"EDUCATION",
    b"EE",
    b"EG",
    b"EMAIL",
    b"EMERCK",
    b"ENERGY",
    b"ENGINEER",
    b"ENGINEERING",
    b"ENTERPRISES",
    b"EPSON",
    b"EQUIPMENT",
    b"ER",
    b"ERICSSON",
    b"ERNI",
    b"ES",
    b"ESQ",
    b"ESTATE",
    b"ET",
    b"ETISALAT",
    b"EU",
    b"EUROVISION",
    b"EUS",
    b"EVENTS",
    b"EXCHANGE",
    b"EXPERT",
    b"EXPOSED",
    b"EXPRESS",
    b"EXTRASPACE",
    b"FAGE",
    b"FAIL",
    b"FAIRWINDS",
    b"FAITH",
    b"FAMILY",
    b"FAN",
    b"FANS",
    b"FARM",
    b"FARMERS",
    b"FASHION",
    b"FAST",
    b"FEDEX",
    b"FEEDBACK",
    b"FERRARI",
    b"FERRERO",
    b"FI",
    b"FIAT",
    b"FIDELITY",
    b"FIDO",
    b"FILM",
    b"FINAL",
    b"FINANCE",
    b"FINANCIAL",
    b"FIRE",
    b"FIRESTONE",
    b"FIRMDALE",
    b"FISH",
    b"FISHING",
    b"FIT",
    b"FITNESS",
    b"FJ",
    b"FK",
    b"FLICKR",
    b"FLIGHTS",
    b"FLIR",
    b"FLORIST",
    b"FLOWERS",
    b"FLY",
    b"FM",
    b"FO",
    b"FOO",
    b"FOOD",
    b"FOODNETWORK",
    b"FOOTBALL",
    b"FORD",
    b"FOREX",
    b"FORSALE",
    b"FORUM",
    b"FOUNDATION",
    b"FOX",
    b"FR",
    b"FREE",
    b"FRESENIUS",
    b"FRL",
    b"FROGANS",
    b"FRONTDOOR",
    b"FRONTIER",
    b"FTR",
    b"FUJITSU",
    b"FUN",
    b"FUND",
    b"FURNITURE",
    b"FUTBOL",
    b"FYI",
    b"GA",
    b"GAL",
    b"GALLERY",
    b"GALLO",
    b"GALLUP",
    b"GAME",
    b"GAMES",
    b"GAP",
    b"GARDEN",
    b"GAY",
    b"GB",
    b"GBIZ",
    b"GD",
    b"GDN",
    b"GE",
    b"GEA",
    b"GENT",
    b"GENTING",
    b"GEORGE",
    b"GF",
    b"GG",
    b"GGEE",
    b"GH",
    b"GI",
    b"GIFT",
    b"GIFTS",
    b"GIVES",
    b"GIVING",
    b"GL",
    b"GLASS",
    b"GLE",
    b"GLOBAL",
    b"GLOBO",
    b"GM",
    b"GMAIL",
    b"GMBH",
    b"GMO",
    b"GMX",
    b"GN",
    b"GODADDY",
    b"GOLD",
    b"GOLDPOINT",
    b"GOLF",
    b"GOO",
    b"GOODYEAR",
    b"GOOG",
    b"GOOGLE",
    b"GOP",
    b"GOT",
    b"GOV",
    b"GP",
    b"GQ",
    b"GR",
    b"GRAINGER",
    b"GRAPHICS",
    b"GRATIS",
    b"GREEN",
    b"GRIPE",
    b"GROCERY",
    b"GROUP",
    b"GS",
    b"GT",
    b"GU",
    b"GUARDIAN",
    b"GUCCI",
    b"GUGE",
    b"GUIDE",
    b"GUITARS",
    b"GURU",
    b"GW",
    b"GY",
    b"HAIR",
    b"HAMBURG",
    b"HANGOUT",
    b"HAUS",
    b"HBO",
    b"HDFC",
    b"HDFCBANK",
    b"HEALTH",
    b"HEALTHCARE",
    b"HELP",
    b"HELSINKI",
    b"HERE",
    b"HERMES",
    b"HGTV",
    b"HIPHOP",
    b"HISAMITSU",
    b"HITACHI",
    b"HIV",
    b"HK",
    b"HKT",
    b"HM",
    b"HN",
    b"HOCKEY",
    b"HOLDINGS",
    b"HOLIDAY",
    b"HOMEDEPOT",
    b"HOMEGOODS",
    b"HOMES",
    b"HOMESENSE",
    b"HONDA",
    b"HORSE",
    b"HOSPITAL",
    b"HOST",
    b"HOSTING",
    b"HOT",
    b"HOTELES",
    b"HOTELS",
    b"HOTMAIL",
    b"HOUSE",
    b"HOW",
    b"HR",
    b"HSBC",
    b"HT",
    b"HU",
    b"HUGHES",
    b"HYATT",
    b"HYUNDAI",
    b"IBM",
    b"ICBC",
    b"ICE",
    b"ICU",
    b"ID",
    b"IE",
    b"IEEE",
    b"IFM",
    b"IKANO",
    b"IL",
    b"IM",
    b"IMAMAT",
    b"IMDB",
    b"IMMO",
    b"IMMOBILIEN",
    b"IN",
    b"INC",
    b"INDUSTRIES",
    b"INFINITI",
    b"INFO",
    b"ING",
    b"INK",
    b"INSTITUTE",
    b"INSURANCE",
    b"INSURE",
    b"INT",
    b"INTERNATIONAL",
    b"INTUIT",
    b"INVESTMENTS",
    b"IO",
    b"IPIRANGA",
    b"IQ",
    b"IR",
    b"IRISH",
    b"IS",
    b"ISMAILI",
    b"IST",
    b"ISTANBUL",
    b"IT",
    b"ITAU",
    b"ITV",
    b"JAGUAR",
    b"JAVA",
    b"JCB",
    b"JE",
    b"JEEP",
    b"JETZT",
    b"JEWELRY",
    b"JIO",
    b"JLL",
    b"JM",
    b"JMP",
    b"JNJ",
    b"JO",
    b"JOBS",
    b"JOBURG",
    b"JOT",
    b"JOY",
    b"JP",
    b"JPMORGAN",
    b"JPRS",
    b"JUEGOS",
    b"JUNIPER",
    b"KAUFEN",
    b"KDDI",
    b"KE",
    b"KERRYHOTELS",
    b"KERRYLOGISTICS",
    b"KERRYPROPERTIES",
    b"KFH",
    b"KG",
    b"KH",
    b"KI",
    b"KIA",
    b"KIDS",
    b"KIM",
    b"KINDER",
    b"KINDLE",
    b"KITCHEN",
    b"KIWI",
    b"KM",
    b"KN",
    b"KOELN",
    b"KOMATSU",
    b"KOSHER",
    b"KP",
    b"KPMG",
    b"KPN",
    b"KR",
    b"KRD",
    b"KRED",
    b"KUOKGROUP",
    b"KW",
    b"KY",
    b"KYOTO",
    b"KZ",
    b"LA",
    b"LACAIXA",
    b"LAMBORGHINI",
    b"LAMER",
    b"LANCASTER",
    b"LANCIA",
    b"LAND",
    b"LANDROVER",
    b"LANXESS",
    b"LASALLE",
    b"LAT",
    b"LATINO",
    b"LATROBE",
    b"LAW",
    b"LAWYER",
    b"LB",
    b"LC",
    b"LDS",
    b"LEASE",
    b"LECLERC",
    b"LEFRAK",
    b"LEGAL",
    b"LEGO",
    b"LEXUS",
    b"LGBT",
    b"LI",
    b"LIDL",
    b"LIFE",
    b"LIFEINSURANCE",
    b"LIFESTYLE",
    b"LIGHTING",
    b"LIKE",
    b"LILLY",
    b"LIMITED",
    b"LIMO",
    b"LINCOLN",
    b"LINK",
    b"LIPSY",
    b"LIVE",
    b"LIVING",
    b"LK",
    b"LLC",
    b"LLP",
    b"LOAN",
    b"LOANS",
    b"LOCKER",
    b"LOCUS",
    b"LOL",
    b"LONDON",
    b"LOTTE",
    b"LOTTO",
    b"LOVE",
    b"LPL",
    b"LPLFINANCIAL",
    b"LR",
    b"LS",
    b"LT",
    b"LTD",
    b"LTDA",
    b"LU",
    b"LUNDBECK",
    b"LUXE",
    b"LUXURY",
    b"LV",
    b"LY",
    b"MA",
    b"MADRID",
    b"MAIF",
    b"MAISON",
    b"MAKEUP",
    b"MAN",
    b"MANAGEMENT",
    b"MANGO",
    b"MAP",
    b"MARKET",
    b"MARKETING",
    b"MARKETS",
    b"MARRIOTT",
    b"MARSHALLS",
    b"MASERATI",
    b"MATTEL",
    b"MBA",
    b"MC",
    b"MCKINSEY",
    b"MD",
    b"ME",
    b"MED",
    b"MEDIA",
    b"MEET",
    b"MELBOURNE",
    b"MEME",
    b"MEMORIAL",
    b"MEN",
    b"MENU",
    b"MERCKMSD",
    b"MG",
    b"MH",
    b"MIAMI",
    b"MICROSOFT",
    b"MIL",
    b"MINI",
    b"MINT",
    b"MIT",
    b"MITSUBISHI",
    b"MK",
    b"ML",
    b"MLB",
    b"MLS",
    b"MM",
    b"MMA",
    b"MN",
    b"MO",
    b"MOBI",
    b"MOBILE",
    b"MODA",
    b"MOE",
    b"MOI",
    b"MOM",
    b"MONASH",
    b"MONEY",
    b"MONSTER",
    b"MORMON",
    b"MORTGAGE",
    b"MOSCOW",
    b"MOTO",
    b"MOTORCYCLES",
    b"MOV",
    b"MOVIE",
    b"MP",
    b"MQ",
    b"MR",
    b"MS",
    b"MSD",
    b"MT",
    b"MTN",
    b"MTR",
    b"MU",
    b"MUSEUM",
    b"MUSIC",
    b"MUTUAL",
    b"MV",
    b"MW",
    b"MX",
    b"MY",
    b"MZ",
    b"NA",
    b"NAB",
    b"NAGOYA",
    b"NAME",
    b"NATURA",
    b"NAVY",
    b"NBA",
    b"NC",
    b"NE",
    b"NEC",
    b"NET",
    b"NETBANK",
    b"NETFLIX",
    b"NETWORK",
    b"NEUSTAR",
    b"NEW",
    b"NEWS",
    b"NEXT",
    b"NEXTDIRECT",
    b"NEXUS",
    b"NF",
    b"NFL",
    b"NG",
    b"NGO",
    b"NHK",
    b"NI",
    b"NICO",
    b"NIKE",
    b"NIKON",
    b"NINJA",
    b"NISSAN",
    b"NISSAY",
    b"NL",
    b"NO",
    b"NOKIA",
    b"NORTHWESTERNMUTUAL",
    b"NORTON",
    b"NOW",
    b"NOWRUZ",
    b"NOWTV",
    b"NP",
    b"NR",
    b"NRA",
    b"NRW",
    b"NTT",
    b"NU",
    b"NYC",
    b"NZ",
    b"OBI",
    b"OBSERVER",
    b"OFFICE",
    b"OKINAWA",
    b"OLAYAN",
    b"OLAYANGROUP",
    b"OLDNAVY",
    b"OLLO",
    b"OM",
    b"OMEGA",
    b"ONE",
    b"ONG",
    b"ONL",
    b"ONLINE",
    b"OOO",
    b"OPEN",
    b"ORACLE",
    b"ORANGE",
    b"ORG",
    b"ORGANIC",
    b"ORIGINS",
    b"OSAKA",
    b"OTSUKA",
    b"OTT",
    b"OVH",
    b"PA",
    b"PAGE",
    b"PANASONIC",
    b"PARIS",
    b"PARS",
    b"PARTNERS",
    b"PARTS",
    b"PARTY",
    b"PASSAGENS",
    b"PAY",
    b"PCCW",
    b"PE",
    b"PET",
    b"PF",
    b"PFIZER",
    b"PG",
    b"PH",
    b"PHARMACY",
    b"PHD",
    b"PHILIPS",
    b"PHONE",
    b"PHOTO",
    b"PHOTOGRAPHY",
    b"PHOTOS",
    b"PHYSIO",
    b"PICS",
    b"PICTET",
    b"PICTURES",
    b"PID",
    b"PIN",
    b"PING",
    b"PINK",
    b"PIONEER",
    b"PIZZA",
    b"PK",
    b"PL",
    b"PLACE",
    b"PLAY",
    b"PLAYSTATION",
    b"PLUMBING",
    b"PLUS",
    b"PM",
    b"PN",
    b"PNC",
    b"POHL",
    b"POKER",
    b"POLITIE",
    b"PORN",
    b"POST",
    b"PR",
    b"PRAMERICA",
    b"PRAXI",
    b"PRESS",
    b"PRIME",
    b"PRO",
    b"PROD",
    b"PRODUCTIONS",
    b"PROF",
    b"PROGRESSIVE",
    b"PROMO",
    b"PROPERTIES",
    b"PROPERTY",
    b"PROTECTION",
    b"PRU",
    b"PRUDENTIAL",
    b"PS",
    b"PT",
    b"PUB",
    b"PW",
    b"PWC",
    b"PY",
    b"QA",
    b"QPON",
    b"QUEBEC",
    b"QUEST",
    b"RACING",
    b"RADIO",
    b"RE",
    b"READ",
    b"REALESTATE",
    b"REALTOR",
    b"REALTY",
    b"RECIPES",
    b"RED",
    b"REDSTONE",
    b"REDUMBRELLA",
    b"REHAB",
    b"REISE",
    b"REISEN",
    b"REIT",
    b"RELIANCE",
    b"REN",
    b"RENT",
    b"RENTALS",
    b"REPAIR",
    b"REPORT",
    b"REPUBLICAN",
    b"REST",
    b"RESTAURANT",
    b"REVIEW",
    b"REVIEWS",
    b"REXROTH",
    b"RICH",
    b"RICHARDLI",
    b"RICOH",
    b"RIL",
    b"RIO",
    b"RIP",
    b"RO",
    b"ROCHER",
    b"ROCKS",
    b"RODEO",
    b"ROGERS",
    b"ROOM",
    b"RS",
    b"RSVP",
    b"RU",
    b"RUGBY",
    b"RUHR",
    b"RUN",
    b"RW",
    b"RWE",
    b"RYUKYU",
    b"SA",
    b"SAARLAND",
    b"SAFE",
    b"SAFETY",
    b"SAKURA",
    b"SALE",
    b"SALON",
    b"SAMSCLUB",
    b"SAMSUNG",
    b"SANDVIK",
    b"SANDVIKCOROMANT",
    b"SANOFI",
    b"SAP",
    b"SARL",
    b"SAS",
    b"SAVE",
    b"SAXO",
    b"SB",
    b"SBI",
    b"SBS",
    b"SC",
    b"SCA",
    b"SCB",
    b"SCHAEFFLER",
    b"SCHMIDT",
    b"SCHOLARSHIPS",
    b"SCHOOL",
    b"SCHULE",
    b"SCHWARZ",
    b"SCIENCE",
    b"SCOT",
    b"SD",
    b"SE",
    b"SEARCH",
    b"SEAT",
    b"SECURE",
    b"SECURITY",
    b"SEEK",
    b"SELECT",
    b"SENER",
    b"SERVICES",
    b"SEVEN",
    b"SEW",
    b"SEX",
    b"SEXY",
    b"SFR",
    b"SG",
    b"SH",
    b"SHANGRILA",
    b"SHARP",
    b"SHAW",
    b"SHELL",
    b"SHIA",
    b"SHIKSHA",
    b"SHOES",
    b"SHOP",
    b"SHOPPING",
    b"SHOUJI",
    b"SHOW",
    b"SHOWTIME",
    b"SI",
    b"SILK",
    b"SINA",
    b"SINGLES",
    b"SITE",
    b"SJ",
    b"SK",
    b"SKI",
    b"SKIN",
    b"SKY",
    b"SKYPE",
    b"SL",
    b"SLING",
    b"SM",
    b"SMART",
    b"SMILE",
    b"SN",
    b"SNCF",
    b"SO",
    b"SOCCER",
    b"SOCIAL",
    b"SOFTBANK",
    b"SOFTWARE",
    b"SOHU",
    b"SOLAR",
    b"SOLUTIONS",
    b"SONG",
    b"SONY",
    b"SOY",
    b"SPA",
    b"SPACE",
    b"SPORT",
    b"SPOT",
    b"SR",
    b"SRL",
    b"SS",
    b"ST",
    b"STADA",
    b"STAPLES",
    b"STAR",
    b"STATEBANK",
    b"STATEFARM",
    b"STC",
    b"STCGROUP",
    b"STOCKHOLM",
    b"STORAGE",
    b"STORE",
    b"STREAM",
    b"STUDIO",
    b"STUDY",
    b"STYLE",
    b"SU",
    b"SUCKS",
    b"SUPPLIES",
    b"SUPPLY",
    b"SUPPORT",
    b"SURF",
    b"SURGERY",
    b"SUZUKI",
    b"SV",
    b"SWATCH",
    b"SWISS",
    b"SX",
    b"SY",
    b"SYDNEY",
    b"SYSTEMS",
    b"SZ",
    b"TAB",
    b"TAIPEI",
    b"TALK",
    b"TAOBAO",
    b"TARGET",
    b"TATAMOTORS",
    b"TATAR",
    b"TATTOO",
    b"TAX",
    b"TAXI",
    b"TC",
    b"TCI",
    b"TD",
    b"TDK",
    b"TEAM",
    b"TECH",
    b"TECHNOLOGY",
    b"TEL",
    b"TEMASEK",
    b"TENNIS",
    b"TEVA",
    b"TF",
    b"TG",
    b"TH",
    b"THD",
    b"THEATER",
    b"THEATRE",
    b"TIAA",
    b"TICKETS",
    b"TIENDA",
    b"TIFFANY",
    b"TIPS",
    b"TIRES",
    b"TIROL",
    b"TJ",
    b"TJMAXX",
    b"TJX",
    b"TK",
    b"TKMAXX",
    b"TL",
    b"TM",
    b"TMALL",
    b"TN",
    b"TO",
    b"TODAY",
    b"TOKYO",
    b"TOOLS",
    b"TOP",
    b"TORAY",
    b"TOSHIBA",
    b"TOTAL",
    b"TOURS",
    b"TOWN",
    b"TOYOTA",
    b"TOYS",
    b"TR",
    b"TRADE",
    b"TRADING",
    b"TRAINING",
    b"TRAVEL",
    b"TRAVELCHANNEL",
    b"TRAVELERS",
    b"TRAVELERSINSURANCE",
    b"TRUST",
    b"TRV",
    b"TT",
    b"TUBE",
    b"TUI",
    b"TUNES",
    b"TUSHU",
    b"TV",
    b"TVS",
    b"TW",
    b"TZ",
    b"UA",
    b"UBANK",
    b"UBS",
    b"UG",
    b"UK",
    b"UNICOM",
    b"UNIVERSITY",
    b"UNO",
    b"UOL",
    b"UPS",
    b"US",
    b"UY",
    b"UZ",
    b"VA",
    b"VACATIONS",
    b"VANA",
    b"VANGUARD",
    b"VC",
    b"VE",
    b"VEGAS",
    b"VENTURES",
    b"VERISIGN",
    b"VERSICHERUNG",
    b"VET",
    b"VG",
    b"VI",
    b"VIAJES",
    b"VIDEO",
    b"VIG",
    b"VIKING",
    b"VILLAS",
    b"VIN",
    b"VIP",
    b"VIRGIN",
    b"VISA",
    b"VISION",
    b"VIVA",
    b"VIVO",
    b"VLAANDEREN",
    b"VN",
    b"VODKA",
    b"VOLKSWAGEN",
    b"VOLVO",
    b"VOTE",
    b"VOTING",
    b"VOTO",
    b"VOYAGE",
    b"VU",
    b"VUELOS",
    b"WALES",
    b"WALMART",
    b"WALTER",
    b"WANG",
    b"WANGGOU",
    b"WATCH",
    b"WATCHES",
    b"WEATHER",
    b"WEATHERCHANNEL",
    b"WEBCAM",
    b"WEBER",
    b"WEBSITE",
    b"WED",
    b"WEDDING",
    b"WEIBO",
    b"WEIR",
    b"WF",
    b"WHOSWHO",
    b"WIEN",
    b"WIKI",
    b"WILLIAMHILL",
    b"WIN",
    b"WINDOWS",
    b"WINE",
    b"WINNERS",
    b"WME",
    b"WOLTERSKLUWER",
    b"WOODSIDE",
    b"WORK",
    b"WORKS",
    b"WORLD",
    b"WOW",
    b"WS",
    b"WTC",
    b"WTF",
    b"XBOX",
    b"XEROX",
    b"XFINITY",
    b"XIHUAN",
    b"XIN",
    b"XN--11B4C3D",
    b"XN--1CK2E1B",
    b"XN--1QQW23A",
    b"XN--2SCRJ9C",
    b"XN--30RR7Y",
    b"XN--3BST00M",
    b"XN--3DS443G",
    b"XN--3E0B707E",
    b"XN--3HCRJ9C",
    b"XN--3PXU8K",
    b"XN--42C2D9A",
    b"XN--45BR5CYL",
    b"XN--45BRJ9C",
    b"XN--45Q11C",
    b"XN--4DBRK0CE",
    b"XN--4GBRIM",
    b"XN--54B7FTA0CC",
    b"XN--55QW42G",
    b"XN--55QX5D",
    b"XN--5SU34J936BGSG",
    b"XN--5TZM5G",
    b"XN--6FRZ82G",
    b"XN--6QQ986B3XL",
    b"XN--80ADXHKS",
    b"XN--80AO21A",
    b"XN--80AQECDR1A",
    b"XN--80ASEHDB",
    b"XN--80ASWG",
    b"XN--8Y0A063A",
    b"XN--90A3AC",
    b"XN--90AE",
    b"XN--90AIS",
    b"XN--9DBQ2A",
    b"XN--9ET52U",
    b"XN--9KRT00A",
    b"XN--B4W605FERD",
    b"XN--BCK1B9A5DRE4C",
    b"XN--C1AVG",
    b"XN--C2BR7G",
    b"XN--CCK2B3B",
    b"XN--CCKWCXETD",
    b"XN--CG4BKI",
    b"XN--CLCHC0EA0B2G2A9GCD",
    b"XN--CZR694B",
    b"XN--CZRS0T",
    b"XN--CZRU2D",
    b"XN--D1ACJ3B",
    b"XN--D1ALF",
    b"XN--E1A4C",
    b"XN--ECKVDTC9D",
    b"XN--EFVY88H",
    b"XN--FCT429K",
    b"XN--FHBEI",
    b"XN--FIQ228C5HS",
    b"XN--FIQ64B",
    b"XN--FIQS8S",
    b"XN--FIQZ9S",
    b"XN--FJQ720A",
    b"XN--FLW351E",
    b"XN--FPCRJ9C3D",
    b"XN--FZC2C9E2C",
    b"XN--FZYS8D69UVGM",
    b"XN--G2XX48C",
    b"XN--GCKR3F0F",
    b"XN--GECRJ9C",
    b"XN--GK3AT1E",
    b"XN--H2BREG3EVE",
    b"XN--H2BRJ9C",
    b"XN--H2BRJ9C8C",
    b"XN--HXT814E",
    b"XN--I1B6B1A6A2E",
    b"XN--IMR513N",
    b"XN--IO0A7I",
    b"XN--J1AEF",
    b"XN--J1AMH",
    b"XN--J6W193G",
    b"XN--JLQ480N2RG",
    b"XN--JVR189M",
    b"XN--KCRX77D1X4A",
    b"XN--KPRW13D",
    b"XN--KPRY57D",
    b"XN--KPUT3I",
    b"XN--L1ACC",
    b"XN--LGBBAT1AD8J",
    b"XN--MGB9AWBF",
    b"XN--MGBA3A3EJT",
    b"XN--MGBA3A4F16A",
    b"XN--MGBA7C0BBN0A",
    b"XN--MGBAAKC7DVF",
    b"XN--MGBAAM7A8H",
    b"XN--MGBAB2BD",
    b"XN--MGBAH1A3HJKRD",
    b"XN--MGBAI9AZGQP6J",
    b"XN--MGBAYH7GPA",
    b"XN--MGBBH1A",
    b"XN--MGBBH1A71E",
    b"XN--MGBC0A9AZCG",
    b"XN--MGBCA7DZDO",
    b"XN--MGBCPQ6GPA1A",
    b"XN--MGBERP4A5D4AR",
    b"XN--MGBGU82A",
    b"XN--MGBI4ECEXP",
    b"XN--MGBPL2FH",
    b"XN--MGBT3DHD",
    b"XN--MGBTX2B",
    b"XN--MGBX4CD0AB",
    b"XN--MIX891F",
    b"XN--MK1BU44C",
    b"XN--MXTQ1M",
    b"XN--NGBC5AZD",
    b"XN--NGBE9E0A",
    b"XN--NGBRX",
    b"XN--NODE",
    b"XN--NQV7F",
    b"XN--NQV7FS00EMA",
    b"XN--NYQY26A",
    b"XN--O3CW4H",
    b"XN--OGBPF8FL",
    b"XN--OTU796D",
    b"XN--P1ACF",
    b"XN--P1AI",
    b"XN--PGBS0DH",
    b"XN--PSSY2U",
    b"XN--Q7CE6A",
    b"XN--Q9JYB4C",
    b"XN--QCKA1PMC",
    b"XN--QXA6A",
    b"XN--QXAM",
    b"XN--RHQV96G",
    b"XN--ROVU88B",
    b"XN--RVC1E0AM3E",
    b"XN--S9BRJ9C",
    b"XN--SES554G",
    b"XN--T60B56A",
    b"XN--TCKWE",
    b"XN--TIQ49XQYJ",
    b"XN--UNUP4Y",
    b"XN--VERMGENSBERATER-CTB",
    b"XN--VERMGENSBERATUNG-PWB",
    b"XN--VHQUV",
    b"XN--VUQ861B",
    b"XN--W4R85EL8FHU5DNRA",
    b"XN--W4RS40L",
    b"XN--WGBH1C",
    b"XN--WGBL6A",
    b"XN--XHQ521B",
    b"XN--XKC2AL3HYE2A",
    b"XN--XKC2DL3A5EE0H",
    b"XN--Y9A3AQ",
    b"XN--YFRO4I67O",
    b"XN--YGBI2AMMX",
    b"XN--ZFR164B",
    b"XXX",
    b"XYZ",
    b"YACHTS",
    b"YAHOO",
    b"YAMAXUN",
    b"YANDEX",
    b"YE",
    b"YODOBASHI",
    b"YOGA",
    b"YOKOHAMA",
    b"YOU",
    b"YOUTUBE",
    b"YT",
    b"YUN",
    b"ZA",
    b"ZAPPOS",
    b"ZARA",
    b"ZERO",
    b"ZIP",
    b"ZM",
    b"ZONE",
    b"ZUERICH",
    b"ZW",
}
