"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToStepfunctions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
class FargateToStepfunctions extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.STEP_FUNCTIONS);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            const createFargateServiceResponse = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
            this.service = createFargateServiceResponse.service;
            this.container = createFargateServiceResponse.containerDefinition;
        }
        const buildStateMachineResponse = defaults.buildStateMachine(this, props.stateMachineProps, props.logGroupProps);
        this.stateMachine = buildStateMachineResponse.stateMachine;
        this.stateMachineLogGroup = buildStateMachineResponse.logGroup;
        this.stateMachine.grantStartExecution(this.service.taskDefinition.taskRole);
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            // Deploy best-practice CloudWatch Alarm for state machine
            this.cloudwatchAlarms = defaults.buildStepFunctionCWAlarms(this, this.stateMachine);
        }
        // Add environment variable
        const stateMachineEnvironmentVariableName = props.stateMachineEnvironmentVariableName || 'STATE_MACHINE_ARN';
        this.container.addEnvironment(stateMachineEnvironmentVariableName, this.stateMachine.stateMachineArn);
    }
}
exports.FargateToStepfunctions = FargateToStepfunctions;
_a = JSII_RTTI_SYMBOL_1;
FargateToStepfunctions[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-stepfunctions.FargateToStepfunctions", version: "2.39.0" };
//# sourceMappingURL=data:application/json;base64,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