"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("node:fs");
const path = require("node:path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        const { workspacePackage, handler = 'handler', index = 'index.py', runtime = aws_lambda_1.Runtime.PYTHON_3_12, } = props;
        const architecture = props.architecture ?? aws_lambda_1.Architecture.ARM_64;
        const rootDir = path.resolve(props.rootDir);
        // Strip .py from the end of handler if it exists
        const strippedIndex = index.endsWith('.py') ? index.slice(0, -3) : index;
        const resolvedHandler = `${strippedIndex}.${handler}`.replace(/\//g, '.');
        if (runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only Python runtimes are supported');
        }
        const code = bundling_1.Bundling.bundle({
            rootDir,
            runtime,
            skip: !aws_cdk_lib_1.Stack.of(scope).bundlingRequired,
            architecture,
            workspacePackage,
            ...props.bundling,
        });
        const environment = props.environment ?? {};
        super(scope, id, {
            ...props,
            environment,
            architecture,
            runtime,
            code,
            handler: resolvedHandler,
        });
        const assetPath = (this.node.defaultChild).getMetadata('aws:asset:path');
        if (assetPath) { // TODO - remove - we always need one
            const codePath = path.join(process.env.CDK_OUTDIR, assetPath);
            const pythonPaths = getPthFilePaths(codePath);
            if (pythonPaths.length > 0) {
                let pythonPathValue = environment.PYTHONPATH;
                const addedPaths = pythonPaths.join(':');
                pythonPathValue = pythonPathValue ? `${pythonPathValue}:${addedPaths}` : addedPaths;
                this.addEnvironment('PYTHONPATH', pythonPathValue);
            }
        }
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "uv-python-lambda.PythonFunction", version: "0.0.2" };
function getPthFilePaths(basePath) {
    const pthFiles = fs.readdirSync(basePath).filter(file => file.endsWith('.pth'));
    const pythonPaths = [];
    for (const pthFile of pthFiles) {
        const filePath = path.join(basePath, pthFile);
        const content = fs.readFileSync(filePath, 'utf-8');
        const dirs = content.split('\n').filter(line => line.trim() !== '');
        pythonPaths.push(...dirs.map(dir => path.join('/var/task', path.relative('/asset-output', dir))));
    }
    return pythonPaths;
}
//# sourceMappingURL=data:application/json;base64,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