import { type BundlingFileAccess, DockerImage, type DockerVolume } from 'aws-cdk-lib';
import { Architecture, type AssetCode, type Runtime } from 'aws-cdk-lib/aws-lambda';
import type { BundlingOptions } from './types';
export declare const HASHABLE_DEPENDENCIES_EXCLUDE: string[];
export declare const DEFAULT_ASSET_EXCLUDES: string[];
export interface BundlingProps extends BundlingOptions {
    /**
     * uv project root (workspace root)
     */
    readonly rootDir: string;
    /**
     * uv package to use for the Lambda Function
     */
    readonly workspacePackage?: string;
    /**
     * Lambda runtime (must be one of the Python runtimes)
     */
    readonly runtime: Runtime;
    /**
     * Lambda CPU architecture
     *
     * @default Architecture.ARM_64
     */
    readonly architecture?: Architecture;
    /**
     * Skip bundling process
     *
     * @default false
     */
    readonly skip?: boolean;
}
/**
 * Bundling options for Python Lambda assets
 */
export declare class Bundling {
    static bundle(options: BundlingProps): AssetCode;
    readonly image: DockerImage;
    readonly entrypoint?: string[] | undefined;
    readonly command: string[] | undefined;
    readonly volumes?: DockerVolume[] | undefined;
    readonly volumesFrom?: string[] | undefined;
    readonly environment?: {
        [key: string]: string;
    } | undefined;
    readonly workingDirectory?: string | undefined;
    readonly user?: string | undefined;
    readonly securityOpt?: string | undefined;
    readonly network?: string | undefined;
    readonly bundlingFileAccess?: BundlingFileAccess | undefined;
    constructor(props: BundlingProps);
    private createBundlingCommands;
}
