"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingletonCfnLaunchTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * An Amazon S3 Bucket implementing the singleton pattern
 */
class SingletonCfnLaunchTemplate extends aws_ec2_1.CfnLaunchTemplate {
    static getOrCreate(scope, name, data) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = `${name}`;
        return stack.node.tryFindChild(id) || new aws_ec2_1.CfnLaunchTemplate(stack, id, {
            launchTemplateName: name,
            launchTemplateData: {
                userData: data,
                metadataOptions: {
                    httpEndpoint: 'enabled',
                    httpProtocolIpv6: 'disabled',
                    httpPutResponseHopLimit: 2,
                    httpTokens: 'required'
                }
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
SingletonCfnLaunchTemplate[_a] = { fqn: "aws-analytics-reference-architecture.SingletonCfnLaunchTemplate", version: "2.12.6" };
exports.SingletonCfnLaunchTemplate = SingletonCfnLaunchTemplate;
//# sourceMappingURL=data:application/json;base64,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