"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingletonKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * An Amazon S3 Bucket implementing the singleton pattern
 */
class SingletonKey extends aws_kms_1.Key {
    /**
       * Get the Amazon KMS Key the AWS CDK Stack based on the provided name.
       * If no key exists, it creates a new one.
       */
    static getOrCreate(scope, keyName) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = `${keyName}`;
        const stackKey = stack.node.tryFindChild(id) ?? (stack.nestedStackParent ? stack.nestedStackParent.node.tryFindChild(id) : undefined);
        return stackKey || new aws_kms_1.Key(stack, id, {
            enableKeyRotation: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
SingletonKey[_a] = { fqn: "aws-analytics-reference-architecture.SingletonKey", version: "2.12.6" };
exports.SingletonKey = SingletonKey;
//# sourceMappingURL=data:application/json;base64,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