"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueDemoRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * GlueDemoRole Construct to automatically setup a new Amazon IAM role to use with AWS Glue jobs.
 * The role is created with AWSGlueServiceRole policy and authorize all actions on S3.
 * If you would like to scope down the permission you should create a new role with a scoped down policy
 * The Construct provides a getOrCreate method for SingletonInstantiation
 */
class GlueDemoRole extends constructs_1.Construct {
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = 'GlueDemoRole';
        return stack.node.tryFindChild(id) || new GlueDemoRole(stack, id);
    }
    /**
     * Constructs a new instance of the GlueDemoRole class
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @access private
     */
    constructor(scope, id) {
        super(scope, id);
        const stack = aws_cdk_lib_1.Stack.of(this);
        this.iamRole = new aws_iam_1.Role(this, 'GlueDemoRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('glue.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSGlueServiceRole')],
            inlinePolicies: {
                DataAccess: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                stack.formatArn({
                                    region: '',
                                    account: '',
                                    service: 's3',
                                    resource: '*',
                                    resourceName: '*',
                                }),
                            ],
                            actions: [
                                's3:ListBucket',
                                's3:*Object*',
                                's3:AbortMultipartUpload',
                                's3:ListBucketMultipartUploads',
                                's3:ListMultipartUploadParts',
                            ],
                        }),
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: ['lakeformation:GetDataAccess'],
                        }),
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'kms:Encrypt*',
                                'kms:Decrypt*',
                                'kms:ReEncrypt*',
                                'kms:GenerateDataKey*',
                                'kms:Describe*',
                            ],
                        }),
                    ],
                }),
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
GlueDemoRole[_a] = { fqn: "aws-analytics-reference-architecture.GlueDemoRole", version: "2.12.6" };
exports.GlueDemoRole = GlueDemoRole;
//# sourceMappingURL=data:application/json;base64,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