"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrEksJobTemplateProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const pre_bundled_function_1 = require("../common/pre-bundled-function");
const constructs_1 = require("constructs");
const pre_bundled_layer_1 = require("../common/pre-bundled-layer");
/**
 * A custom resource provider for CRUD operations on Amazon EMR on EKS Managed Endpoints.
 * @private
 */
class EmrEksJobTemplateProvider extends constructs_1.Construct {
    /**
     * Constructs a new instance of the ManageEndpointProvider. The provider can then be used to create Amazon EMR on EKS Managed Endpoint custom resources
     * @param { Construct} scope the Scope of the CDK Construct
     * @param id the ID of the CDK Construct
     * @private
     */
    constructor(scope, id) {
        super(scope, id);
        //The policy allowing the creatio of the job template
        const lambdaPolicy = [
            new aws_iam_1.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:DeleteJobTemplate'],
                conditions: { StringEquals: { 'aws:ResourceTag/for-use-with': 'cdk-analytics-reference-architecture' } }
            }),
            new aws_iam_1.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:CreateJobTemplate', 'emr-containers:TagResource'],
                conditions: { StringEquals: { 'aws:RequestTag/for-use-with': 'cdk-analytics-reference-architecture' } }
            }),
        ];
        // AWS Lambda function supporting the create, update, delete operations on Amazon EMR on EKS managed endpoints
        const onEvent = new pre_bundled_function_1.PreBundledFunction(this, 'OnEvent', {
            codePath: 'emr-eks-platform/resources/lambdas/job-template',
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            handler: 'lambda.on_event',
            layers: [pre_bundled_layer_1.PreBundledLayer.getOrCreate(scope, 'common/resources/lambdas/pre-bundled-layer')],
            lambdaPolicyStatements: lambdaPolicy,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
            timeout: aws_cdk_lib_1.Duration.seconds(120),
        });
        this.provider = new custom_resources_1.Provider(this, 'CustomResourceProvider', {
            onEventHandler: onEvent,
            providerFunctionName: 'jobTemplateFn',
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
EmrEksJobTemplateProvider[_a] = { fqn: "aws-analytics-reference-architecture.EmrEksJobTemplateProvider", version: "2.12.6" };
exports.EmrEksJobTemplateProvider = EmrEksJobTemplateProvider;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW1yLWVrcy1qb2ItdGVtcGxhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZW1yLWVrcy1wbGF0Zm9ybS9lbXItZWtzLWpvYi10ZW1wbGF0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHFFQUFxRTtBQUNyRSxpQ0FBaUM7QUFFakMsaURBQXNEO0FBQ3RELHVEQUFpRDtBQUNqRCxtREFBcUQ7QUFDckQsNkNBQXVDO0FBQ3ZDLG1FQUF3RDtBQUN4RCx5RUFBb0U7QUFDcEUsMkNBQXVDO0FBQ3ZDLG1FQUE4RDtBQWlCOUQ7OztHQUdHO0FBQ0gsTUFBYSx5QkFBMEIsU0FBUSxzQkFBUztJQU10RDs7Ozs7T0FLRztJQUVILFlBQVksS0FBZ0IsRUFBRSxFQUFVO1FBQ3RDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIscURBQXFEO1FBQ3JELE1BQU0sWUFBWSxHQUFHO1lBQ25CLElBQUkseUJBQWUsQ0FBQztnQkFDbEIsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO2dCQUNoQixPQUFPLEVBQUUsQ0FBQyxrQ0FBa0MsQ0FBQztnQkFDN0MsVUFBVSxFQUFFLEVBQUUsWUFBWSxFQUFFLEVBQUUsOEJBQThCLEVBQUUsc0NBQXNDLEVBQUUsRUFBRTthQUN6RyxDQUFDO1lBQ0YsSUFBSSx5QkFBZSxDQUFDO2dCQUNsQixTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7Z0JBQ2hCLE9BQU8sRUFBRSxDQUFDLGtDQUFrQyxFQUFFLDRCQUE0QixDQUFDO2dCQUMzRSxVQUFVLEVBQUUsRUFBRSxZQUFZLEVBQUUsRUFBRSw2QkFBNkIsRUFBRSxzQ0FBc0MsRUFBRSxFQUFFO2FBQ3hHLENBQUM7U0FDSCxDQUFDO1FBRUYsOEdBQThHO1FBQzlHLE1BQU0sT0FBTyxHQUFHLElBQUkseUNBQWtCLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRTtZQUN0RCxRQUFRLEVBQUUsaURBQWlEO1lBQzNELE9BQU8sRUFBRSxvQkFBTyxDQUFDLFVBQVU7WUFDM0IsT0FBTyxFQUFFLGlCQUFpQjtZQUMxQixNQUFNLEVBQUUsQ0FBQyxtQ0FBZSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsNENBQTRDLENBQUMsQ0FBQztZQUMxRixzQkFBc0IsRUFBRSxZQUFZO1lBQ3BDLFlBQVksRUFBRSx3QkFBYSxDQUFDLFFBQVE7WUFDcEMsT0FBTyxFQUFFLHNCQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQztTQUMvQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksMkJBQVEsQ0FBQyxJQUFJLEVBQUUsd0JBQXdCLEVBQUU7WUFDM0QsY0FBYyxFQUFFLE9BQU87WUFDdkIsb0JBQW9CLEVBQUUsZUFBZTtTQUN0QyxDQUFDLENBQUM7SUFFTCxDQUFDOzs7O0FBOUNVLDhEQUF5QiIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1JVC0wXG5cbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgUnVudGltZSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgUmV0ZW50aW9uRGF5cyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1sb2dzJztcbmltcG9ydCB7IER1cmF0aW9uIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgUHJvdmlkZXIgfSBmcm9tICdhd3MtY2RrLWxpYi9jdXN0b20tcmVzb3VyY2VzJztcbmltcG9ydCB7IFByZUJ1bmRsZWRGdW5jdGlvbiB9IGZyb20gJy4uL2NvbW1vbi9wcmUtYnVuZGxlZC1mdW5jdGlvbic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFByZUJ1bmRsZWRMYXllciB9IGZyb20gJy4uL2NvbW1vbi9wcmUtYnVuZGxlZC1sYXllcic7XG5cblxuLyoqXG4qIFRoZSBwcm9wZXJ0aWVzIGZvciB0aGUgRU1SIE1hbmFnZWQgRW5kcG9pbnQgdG8gY3JlYXRlLlxuKi9cbmV4cG9ydCBpbnRlcmZhY2UgRW1yRWtzSm9iVGVtcGxhdGVEZWZpbml0aW9uIHtcbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgam9iIHRlbXBsYXRlXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBKU09OIGRlZmluaXRpb24gb2YgdGhlIGpvYiB0ZW1wbGF0ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGpvYlRlbXBsYXRlRGF0YTogc3RyaW5nO1xuICB9XG5cbi8qKlxuICogQSBjdXN0b20gcmVzb3VyY2UgcHJvdmlkZXIgZm9yIENSVUQgb3BlcmF0aW9ucyBvbiBBbWF6b24gRU1SIG9uIEVLUyBNYW5hZ2VkIEVuZHBvaW50cy5cbiAqIEBwcml2YXRlXG4gKi9cbmV4cG9ydCBjbGFzcyBFbXJFa3NKb2JUZW1wbGF0ZVByb3ZpZGVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIFRoZSBjdXN0b20gcmVzb3VyY2UgUHJvdmlkZXIgZm9yIGNyZWF0aW5nIEFtYXpvbiBFTVIgTWFuYWdlZCBFbmRwb2ludHMgY3VzdG9tIHJlc291cmNlc1xuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHByb3ZpZGVyOiBQcm92aWRlcjtcblxuICAvKipcbiAgICogQ29uc3RydWN0cyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgTWFuYWdlRW5kcG9pbnRQcm92aWRlci4gVGhlIHByb3ZpZGVyIGNhbiB0aGVuIGJlIHVzZWQgdG8gY3JlYXRlIEFtYXpvbiBFTVIgb24gRUtTIE1hbmFnZWQgRW5kcG9pbnQgY3VzdG9tIHJlc291cmNlc1xuICAgKiBAcGFyYW0geyBDb25zdHJ1Y3R9IHNjb3BlIHRoZSBTY29wZSBvZiB0aGUgQ0RLIENvbnN0cnVjdFxuICAgKiBAcGFyYW0gaWQgdGhlIElEIG9mIHRoZSBDREsgQ29uc3RydWN0XG4gICAqIEBwcml2YXRlXG4gICAqL1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgLy9UaGUgcG9saWN5IGFsbG93aW5nIHRoZSBjcmVhdGlvIG9mIHRoZSBqb2IgdGVtcGxhdGVcbiAgICBjb25zdCBsYW1iZGFQb2xpY3kgPSBbXG4gICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgICAgYWN0aW9uczogWydlbXItY29udGFpbmVyczpEZWxldGVKb2JUZW1wbGF0ZSddLFxuICAgICAgICBjb25kaXRpb25zOiB7IFN0cmluZ0VxdWFsczogeyAnYXdzOlJlc291cmNlVGFnL2Zvci11c2Utd2l0aCc6ICdjZGstYW5hbHl0aWNzLXJlZmVyZW5jZS1hcmNoaXRlY3R1cmUnIH0gfVxuICAgICAgfSksXG4gICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgICAgYWN0aW9uczogWydlbXItY29udGFpbmVyczpDcmVhdGVKb2JUZW1wbGF0ZScsICdlbXItY29udGFpbmVyczpUYWdSZXNvdXJjZSddLFxuICAgICAgICBjb25kaXRpb25zOiB7IFN0cmluZ0VxdWFsczogeyAnYXdzOlJlcXVlc3RUYWcvZm9yLXVzZS13aXRoJzogJ2Nkay1hbmFseXRpY3MtcmVmZXJlbmNlLWFyY2hpdGVjdHVyZScgfSB9XG4gICAgICB9KSxcbiAgICBdO1xuXG4gICAgLy8gQVdTIExhbWJkYSBmdW5jdGlvbiBzdXBwb3J0aW5nIHRoZSBjcmVhdGUsIHVwZGF0ZSwgZGVsZXRlIG9wZXJhdGlvbnMgb24gQW1hem9uIEVNUiBvbiBFS1MgbWFuYWdlZCBlbmRwb2ludHNcbiAgICBjb25zdCBvbkV2ZW50ID0gbmV3IFByZUJ1bmRsZWRGdW5jdGlvbih0aGlzLCAnT25FdmVudCcsIHtcbiAgICAgIGNvZGVQYXRoOiAnZW1yLWVrcy1wbGF0Zm9ybS9yZXNvdXJjZXMvbGFtYmRhcy9qb2ItdGVtcGxhdGUnLFxuICAgICAgcnVudGltZTogUnVudGltZS5QWVRIT05fM185LFxuICAgICAgaGFuZGxlcjogJ2xhbWJkYS5vbl9ldmVudCcsXG4gICAgICBsYXllcnM6IFtQcmVCdW5kbGVkTGF5ZXIuZ2V0T3JDcmVhdGUoc2NvcGUsICdjb21tb24vcmVzb3VyY2VzL2xhbWJkYXMvcHJlLWJ1bmRsZWQtbGF5ZXInKV0sXG4gICAgICBsYW1iZGFQb2xpY3lTdGF0ZW1lbnRzOiBsYW1iZGFQb2xpY3ksXG4gICAgICBsb2dSZXRlbnRpb246IFJldGVudGlvbkRheXMuT05FX1dFRUssXG4gICAgICB0aW1lb3V0OiBEdXJhdGlvbi5zZWNvbmRzKDEyMCksXG4gICAgfSk7XG5cbiAgICB0aGlzLnByb3ZpZGVyID0gbmV3IFByb3ZpZGVyKHRoaXMsICdDdXN0b21SZXNvdXJjZVByb3ZpZGVyJywge1xuICAgICAgb25FdmVudEhhbmRsZXI6IG9uRXZlbnQsXG4gICAgICBwcm92aWRlckZ1bmN0aW9uTmFtZTogJ2pvYlRlbXBsYXRlRm4nLFxuICAgIH0pO1xuXG4gIH1cbn1cbiJdfQ==