import { Construct } from "constructs";
/**
 * @internal
 * Create a Customer Resource to start a codebuild project
 * The policy allow access only to a single bucket to store notebooks
 * @returns Return the token to the Provider for CR
 */
export declare function EmrEksImageBuilderCRProviderSetup(scope: Construct, codeBuildProjectArn: string): string;
/**
 * @internal
 * a Map containing the account for each region where the docker image are stored
 * The list is maintained in this AWS documentation (link)[https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/docker-custom-images-tag.html]
 */
export declare const emrOnEksImageMap: Map<string, string>;
