"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataLakeCatalog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_glue_alpha_1 = require("@aws-cdk/aws-glue-alpha");
const context_options_1 = require("./common/context-options");
const tracked_construct_1 = require("./common/tracked-construct");
/**
 * A Data Lake Catalog composed of 3 AWS Glue Database configured with AWS best practices:
 *  Databases for Raw/Cleaned/Transformed data,
 */
class DataLakeCatalog extends tracked_construct_1.TrackedConstruct {
    /**
       * Construct a new instance of DataLakeCatalog based on S3 buckets with best practices configuration
       * @param {Construct} scope the Scope of the CDK Construct
       * @param {string} id the ID of the CDK Construct
       * @access public
       */
    constructor(scope, id) {
        const trackedConstructProps = {
            trackingCode: context_options_1.ContextOptions.DATA_LAKE_ID,
        };
        super(scope, id, trackedConstructProps);
        this.rawDatabase = new aws_glue_alpha_1.Database(this, 'raw-database', {
            databaseName: 'raw',
        });
        this.cleanDatabase = new aws_glue_alpha_1.Database(this, 'clean-database', {
            databaseName: 'clean',
        });
        this.transformDatabase = new aws_glue_alpha_1.Database(this, 'transform-database', {
            databaseName: 'transform',
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
DataLakeCatalog[_a] = { fqn: "aws-analytics-reference-architecture.DataLakeCatalog", version: "2.12.6" };
exports.DataLakeCatalog = DataLakeCatalog;
//# sourceMappingURL=data:application/json;base64,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