import { BuildSpec } from "aws-cdk-lib/aws-codebuild";
export declare const startBuild: (deployBuildSpec?: BuildSpec, destroyBuildSpec?: BuildSpec) => string;
export declare const reportBuild = "\n// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.\n// SPDX-License-Identifier: MIT-0\n\nconst respond = async function(event, context, responseStatus, responseData, physicalResourceId, noEcho) {\n  return new Promise((resolve, reject) => {\n    var responseBody = JSON.stringify({\n      Status: responseStatus,\n      Reason: \"See the details in CloudWatch Log Stream: \" + context.logGroupName + \" \" + context.logStreamName,\n      PhysicalResourceId: physicalResourceId || context.logStreamName,\n      StackId: event.StackId,\n      RequestId: event.RequestId,\n      LogicalResourceId: event.LogicalResourceId,\n      NoEcho: noEcho || false,\n      Data: responseData\n    });\n    \n    console.log(\"Response body:    \", responseBody);\n    \n    var https = require(\"https\");\n    var url = require(\"url\");\n    \n    var parsedUrl = url.parse(event.ResponseURL);\n    var options = {\n      hostname: parsedUrl.hostname,\n      port: 443,\n      path: parsedUrl.path,\n      method: \"PUT\",\n      headers: {\n        \"content-type\": \"\",\n        \"content-length\": responseBody.length\n      }\n    };\n    \n    var request = https.request(options, function(response) {\n      console.log(\"Status code: \" + response.statusCode);\n      console.log(\"Status message: \" + response.statusMessage);\n      resolve();\n    });\n    \n    request.on(\"error\", function(error) {\n      console.log(\"respond(..) failed executing https.request(..): \" + error);\n      resolve();\n    });\n    \n    request.write(responseBody);\n    request.end();\n  });\n};\n\nconst AWS = require('aws-sdk');\n\nexports.handler = async function (event, context) {\n  console.log(JSON.stringify(event, null, 4));\n  \n  const projectName = event['detail']['project-name'];\n  \n  const codebuild = new AWS.CodeBuild();\n  \n  const buildId = event['detail']['build-id'];\n  const { builds } = await codebuild.batchGetBuilds({\n    ids: [ buildId ]\n  }).promise();\n  \n  console.log(JSON.stringify(builds, null, 4));\n  \n  const build = builds[0];\n  // Fetch the CFN resource and response parameters from the build environment.\n  const environment = {};\n  build.environment.environmentVariables.forEach(e => environment[e.name] = e.value);\n  \n  const response = {\n    ResponseURL: environment.CFN_RESPONSE_URL,\n    StackId: environment.CFN_STACK_ID,\n    LogicalResourceId: environment.CFN_LOGICAL_RESOURCE_ID,\n    RequestId: environment.CFN_REQUEST_ID\n  };\n  \n  if (event['detail']['build-status'] === 'SUCCEEDED') {\n    await respond(response, context, 'SUCCESS', { BuildStatus: 'SUCCESS'}, 'build');\n  } else {\n    await respond(response, context, 'FAILED', { Error: 'Build failed' });\n  }\n};\n";
