#  Copyright 2014 Michael Medin
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from google.protobuf.descriptor import FieldDescriptor
import re
from jinja2 import Template, Environment
import hashlib

FIELD_LABEL_MAP = {
    FieldDescriptor.LABEL_OPTIONAL: 'optional',
    FieldDescriptor.LABEL_REQUIRED: 'required',
    FieldDescriptor.LABEL_REPEATED: 'repeated'
}

FIELD_TYPE_MAP = {
    FieldDescriptor.TYPE_DOUBLE: 'double',
    FieldDescriptor.TYPE_FLOAT: 'float',
    FieldDescriptor.TYPE_INT64: 'int64',
    FieldDescriptor.TYPE_UINT64: 'uint64',
    FieldDescriptor.TYPE_INT32: 'int32',
    FieldDescriptor.TYPE_FIXED64: 'fixed64',
    FieldDescriptor.TYPE_FIXED32: 'fixed32',
    FieldDescriptor.TYPE_BOOL: 'bool',
    FieldDescriptor.TYPE_STRING: 'string',
    FieldDescriptor.TYPE_GROUP: 'group',
    FieldDescriptor.TYPE_MESSAGE: 'message',
    FieldDescriptor.TYPE_BYTES: 'bytes',
    FieldDescriptor.TYPE_UINT32: 'uint32',
    FieldDescriptor.TYPE_ENUM: 'enum',
    FieldDescriptor.TYPE_SFIXED32: 'sfixed32',
    FieldDescriptor.TYPE_SFIXED64: 'sfixed64',
    FieldDescriptor.TYPE_SINT32: 'sint32',
    FieldDescriptor.TYPE_SINT64: 'sint64',
}

EXCEPTION_TPL = """// Generated by the json-protobuf compiler.
// You shouldn't be editing this file manually
//
#pragma once

namespace json_pb {
    class json_pb_exception : public std::exception {
        std::string error;
    public:
        json_pb_exception(std::string error) : error(error) {}
        ~json_pb_exception() throw() {}
        const char* what() const throw() { return error.c_str(); }
    };
}
"""
def file_exception():
    '''Obtains the source code for a FileDescriptor instance'''
    env = Environment()
    env.filters['cinclude'] = cinclude
    template = env.from_string(EXCEPTION_TPL)
    return template.render()



def cinclude(string):
    return string.replace('.', '/').lower()

HEADER_TPL = """// Generated by the lua-protobuf compiler.
// You shouldn't be editing this file manually
//
// source proto file: {{desc.name}}

#if defined (WIN32) 
  #if defined(json_protobuf_NOLIB)
    #define JSON_PROTOBUF_EXPORT
  #else
    #if defined(json_protobuf_EXPORTS)
      #define JSON_PROTOBUF_EXPORT __declspec(dllexport)
    #else
      #define JSON_PROTOBUF_EXPORT __declspec(dllimport)
    #endif /* json_protobuf_EXPORTS */
  #endif /* json_protobuf_NOLIB */
#else /* defined (_WIN32) */
 #define JSON_PROTOBUF_EXPORT
#endif

{% macro gen_message(desc, level, pbobj) -%}
{% set in = ''|indent(4*level, True) %}
{{in}}namespace {{desc.name}} {
{% for field_descriptor in desc.enum_type -%}
{{in}}    ::{{pbobj}}::{{desc.name}}::{{field_descriptor.name}} JSON_PROTOBUF_EXPORT {{field_descriptor.name}}_to_pb(const std::string &value);
{{in}}    std::string JSON_PROTOBUF_EXPORT {{field_descriptor.name}}_to_json(const ::{{pbobj}}::{{desc.name}}::{{field_descriptor.name}} &value);
{% endfor %}
{{in}}    void JSON_PROTOBUF_EXPORT to_pb(::{{pbobj}}::{{desc.name}} *pb, const json_spirit::Object &json);
{{in}}    json_spirit::Object JSON_PROTOBUF_EXPORT to_json(const ::{{pbobj}}::{{desc.name}} &pb);
{% for sdesc in desc.nested_type %}
{{ gen_message(sdesc, level+1, pbobj + '::' + desc.name) }}
{% endfor %}
{{in}}}
{%- endmacro %}
#pragma once

#include <{{target_name}}.pb.h>
#include <json_spirit.h>
#include <boost/foreach.hpp>

namespace json_pb {
{% for ns in desc.package.split(".") %}
    namespace {{ns}} {
{% endfor %}
{% for sdesc in desc.message_type %}
{{ gen_message(sdesc, 3, desc.package.replace('.', '::')) }}
{% endfor %}
{% for field_descriptor in desc.enum_type -%}
{{in}}        ::{{desc.package.replace('.', '::')}}::{{field_descriptor.name}} JSON_PROTOBUF_EXPORT {{field_descriptor.name}}_to_pb(const std::string &value);
{{in}}        std::string JSON_PROTOBUF_EXPORT {{field_descriptor.name}}_to_json(const ::{{desc.package.replace('.', '::')}}::{{field_descriptor.name}} &value);
{% endfor %}
{% for ns in desc.package.split(".") %}
    }
{% endfor %}
}
"""
def file_header(file_descriptor, target_name):
    env = Environment()
    env.filters['cinclude'] = cinclude
    template = env.from_string(HEADER_TPL)
    return template.render({'desc':file_descriptor, 'target_name':target_name, 'FIELD_TYPE_MAP':FIELD_TYPE_MAP, 'FIELD_LABEL_MAP':FIELD_LABEL_MAP})
# D:\source\build\x64\protobuf-2.4.1\vsprojects\Release\protoc.exe --json_out D:/source/build/x64/dev/libs/json_pb --plugin=protoc-gen-json=D:/source/nscp/ext/json-protobuf/protoc-gen-json.cmd --proto_path D:/source/nscp/libs/protobuf D:/source/nscp/libs/protobuf/plugin.proto

SOURCE_TPL = """// Generated by the json-protobuf compiler.
// You shouldn't be editing this file manually
//
// source proto file: {{desc.name}}
{% macro gen_message(desc, level, pbobj) -%}
{% set in = ''|indent(4*level, True) %}
{{in}}namespace {{desc.name}} {
{{in}}    // message {{desc.name}} {
{% for field_descriptor in desc.enum_type -%}
{{in}}    //   enum {{field_descriptor.name}} {
{% for value in field_descriptor.value -%}
{{in}}    //       {{value.name}} = {{value.number}};
{% endfor %}{{in}}    // }
{{in}}    ::{{pbobj}}::{{desc.name}}::{{field_descriptor.name}} {{field_descriptor.name}}_to_pb(const std::string &value) {
{{in}}        if (false)
{{in}}            ;
{% for value in field_descriptor.value -%}
{{in}}        else if (value == "{{value.name}}")
{{in}}            return ::{{pbobj}}::{{desc.name}}::{{value.name}};
{% endfor %}{{in}}    // }
{{in}}        throw json_pb_exception("Invalid value for: {{field_descriptor.name}}");
{{in}}    }
{{in}}    std::string {{field_descriptor.name}}_to_json(const ::{{pbobj}}::{{desc.name}}::{{field_descriptor.name}} &value) {
{{in}}        if (false)
{{in}}            ;
{% for value in field_descriptor.value -%}
{{in}}        else if (value == ::{{pbobj}}::{{desc.name}}::{{value.name}})
{{in}}            return "{{value.name}}";
{% endfor %}{{in}}    // }
{{in}}        throw json_pb_exception("Invalid value for: {{field_descriptor.name}}");
{{in}}    }
{% endfor %}
{% for field_descriptor in desc.field -%}{{in}}    //   {{FIELD_LABEL_MAP[field_descriptor.label]}} {{FIELD_TYPE_MAP[field_descriptor.type]}} {{field_descriptor.name}} = {{field_descriptor.number}}
{% endfor %}
{{in}}    // }

{{in}}    void to_pb(::{{pbobj}}::{{desc.name}} *pb, const json_spirit::Object &json){
{% if desc.field -%}
{{in}}        BOOST_FOREACH(const json_spirit::Object::value_type &node, json) {
{% for field_descriptor in desc.field -%}
{% if FIELD_LABEL_MAP[field_descriptor.label] == 'repeated' -%}
{{in}}            if (node.second.isArray() && node.first == "{{field_descriptor.name}}") {
{{in}}                BOOST_FOREACH(const json_spirit::Value &s, node.second.getArray()) {
{% if FIELD_TYPE_MAP[field_descriptor.type] == 'enum' -%}
{{in}}                    if (s.isString())
{{in}}                        pb->add_{{field_descriptor.name}}(json_pb{{field_descriptor.type_name|replace('.', '::')}}_to_pb(s.getString()));
{% elif FIELD_TYPE_MAP[field_descriptor.type] in ['int32', 'uint32', 'fixed32', 'sfixed32'] -%}
{{in}}                    if (s.isInt())
{{in}}                        pb->add_{{field_descriptor.name}}(s.getInt());
{% elif FIELD_TYPE_MAP[field_descriptor.type] in ['int64', 'uint64', 'fixed64', 'sfixed64'] -%}
{{in}}                    if (s.isInt64())
{{in}}                        pb->add_{{field_descriptor.name}}(s.getInt64());
{% elif FIELD_TYPE_MAP[field_descriptor.type] in ['bytes', 'string'] -%}
{{in}}                    if (s.isString())
{{in}}                        pb->add_{{field_descriptor.name}}(s.getString());
{% elif FIELD_TYPE_MAP[field_descriptor.type] == 'message' -%}
{{in}}                    if (s.isObject())
{{in}}                        json_pb{{field_descriptor.type_name|replace('.', '::')}}::to_pb(pb->add_{{field_descriptor.name}}(), s.getObject()); 
{% else -%}
//{{in}}            throw "Unknown";
{% endif %}
{{in}}                }
{{in}}                continue; 
{{in}}            }
{% else -%}
{% if FIELD_TYPE_MAP[field_descriptor.type] == 'enum' -%}
{{in}}            if (node.second.isString() && node.first == "{{field_descriptor.name}}") {
{{in}}                pb->set_{{field_descriptor.name}}(json_pb{{field_descriptor.type_name|replace('.', '::')}}_to_pb(node.second.getString()));
{{in}}                continue; 
{{in}}            }
{{in}}            if (node.second.isInt() && node.first == "{{field_descriptor.name}}") {
{{in}}                pb->set_{{field_descriptor.name}}(({{field_descriptor.type_name|replace('.', '::')}})node.second.getInt());
{{in}}                continue; 
{{in}}            }
{% elif FIELD_TYPE_MAP[field_descriptor.type] in ['int32', 'uint32', 'fixed32', 'sfixed32'] -%}
{{in}}            if (node.second.isInt() && node.first == "{{field_descriptor.name}}") {
{{in}}                pb->set_{{field_descriptor.name}}(node.second.getInt());
{{in}}                continue; 
{{in}}            }
{% elif FIELD_TYPE_MAP[field_descriptor.type] in ['int64', 'uint64', 'fixed64', 'sfixed64'] -%}
{{in}}            if (node.second.isInt64() && node.first == "{{field_descriptor.name}}") {
{{in}}                pb->set_{{field_descriptor.name}}(node.second.getInt64());
{{in}}                continue; 
{{in}}            }
{% elif FIELD_TYPE_MAP[field_descriptor.type] in ['bytes', 'string'] -%}
{{in}}            if (node.second.isString() && node.first == "{{field_descriptor.name}}") {
{{in}}                pb->set_{{field_descriptor.name}}(node.second.getString());
{{in}}                continue; 
{{in}}            }
{% elif FIELD_TYPE_MAP[field_descriptor.type] == 'message' -%}
{{in}}            if (node.second.isObject() && node.first == "{{field_descriptor.name}}") {
{{in}}                json_pb{{field_descriptor.type_name|replace('.', '::')}}::to_pb(pb->mutable_{{field_descriptor.name}}(), node.second.getObject()); 
{{in}}                continue; 
{{in}}            }
{% else -%}
//{{in}}            throw "Unknown";
{% endif %}
{% endif %}
{% endfor %}
{{in}}        }
{% endif %}
{{in}}    }
{{in}}    json_spirit::Object to_json(const ::{{pbobj}}::{{desc.name}} &pb) {
{{in}}        json_spirit::Object node;
{% for field_descriptor in desc.field -%}
{% if FIELD_LABEL_MAP[field_descriptor.label] == 'repeated' %}
{{in}}    if (pb.{{field_descriptor.name}}_size() > 0) {
{{in}}        json_spirit::Array arr; 
{{in}}        for (int i=0;i<pb.{{field_descriptor.name}}_size();++i) {
{% if FIELD_TYPE_MAP[field_descriptor.type] == 'enum' %}
{{in}}            arr.push_back(json_spirit::Value(json_pb{{field_descriptor.type_name|replace('.', '::')}}_to_json(pb.{{field_descriptor.name}}(i))));
{% elif FIELD_TYPE_MAP[field_descriptor.type] == 'message'%}
{{in}}            arr.push_back(json_spirit::Value(json_pb{{field_descriptor.type_name|replace('.', '::')}}::to_json(pb.{{field_descriptor.name}}(i))));
{% else %}
{{in}}            arr.push_back(json_spirit::Value(pb.{{field_descriptor.name}}(i)));
{% endif %}
{{in}}        }
{{in}}        node.insert(json_spirit::Object::value_type("{{field_descriptor.name}}", arr)); 
{{in}}    }
{% else %}
{% if FIELD_TYPE_MAP[field_descriptor.type] == 'enum' %}
{{in}}        node.insert(json_spirit::Object::value_type("{{field_descriptor.name}}", json_pb{{field_descriptor.type_name|replace('.', '::')}}_to_json(pb.{{field_descriptor.name}}()))); 
{% elif FIELD_TYPE_MAP[field_descriptor.type] == 'message'%}
{{in}}        if (pb.has_{{field_descriptor.name}}())
{{in}}            node.insert(json_spirit::Object::value_type("{{field_descriptor.name}}", json_pb{{field_descriptor.type_name|replace('.', '::')}}::to_json(pb.{{field_descriptor.name}}()))); 
{% else %}
{{in}}        node.insert(json_spirit::Object::value_type("{{field_descriptor.name}}", pb.{{field_descriptor.name}}())); 
{% endif %}
{% endif %}
{% endfor %}
{{in}}        return node;
{{in}}    }
{% for sdesc in desc.nested_type %}
{{ gen_message(sdesc, level+1, pbobj + '::' + desc.name) }}
{% endfor %}
{{in}}}
{%- endmacro %}

#include <{{target_name}}.pb.h>
#include "exception.pb-json.h"
#include "{{target_name}}.pb-json.h"

{% for dep in desc.dependency %}
#include "{{dep.replace('.proto','')}}.pb-json.h"
{% endfor %}

namespace json_pb {
{% for ns in desc.package.split(".") %}
    namespace {{ns}} {
{% endfor %}
{% for sdesc in desc.message_type %}
{{ gen_message(sdesc, 2, desc.package.replace('.', '::')) }}
{% endfor %}
{% for field_descriptor in desc.enum_type -%}
    //   enum {{field_descriptor.name}} {
{% for value in field_descriptor.value -%}
    //       {{value.name}} = {{value.number}};
{% endfor %}    // }
    ::{{desc.package.replace('.', '::')}}::{{field_descriptor.name}} {{field_descriptor.name}}_to_pb(const std::string &value) {
        if (false)
            ;
{% for value in field_descriptor.value -%}
        else if (value == "{{value.name}}")
            return ::{{desc.package.replace('.', '::')}}::{{field_descriptor.name}}::{{value.name}};
{% endfor %}
        throw json_pb_exception("Invalid value for: {{field_descriptor.name}}");
    }
    std::string {{field_descriptor.name}}_to_json(const ::{{desc.package.replace('.', '::')}}::{{field_descriptor.name}} &value) {
        if (false)
            ;
{% for value in field_descriptor.value -%}
        else if (value == ::{{desc.package.replace('.', '::')}}::{{value.name}})
            return "{{value.name}}";
{% endfor %}    // }
        throw json_pb_exception("Invalid value for: {{field_descriptor.name}}");
    }
{% endfor %}

{% for ns in desc.package.split(".") %}
    }
{% endfor %}
}
"""
def file_source(file_descriptor, target_name, ltag):
    '''Obtains the source code for a FileDescriptor instance'''
    env = Environment()
    env.filters['cinclude'] = cinclude
    template = env.from_string(SOURCE_TPL)
    return template.render({'desc':file_descriptor, 'target_name':target_name, 'FIELD_TYPE_MAP':FIELD_TYPE_MAP, 'FIELD_LABEL_MAP':FIELD_LABEL_MAP})

