"""init

Revision ID: 0000
Revises: 
Create Date: 2022-05-16 09:32:53.130752

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "0000"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "lf_machine",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("location", sa.String(), nullable=False),
        sa.Column("provider", sa.String(), nullable=False),
        sa.Column("desc", sa.String(), nullable=True),
        sa.Column("machine_type", sa.JSON(), nullable=False),
        sa.Column("gpu", sa.JSON(), nullable=True),
        sa.Column("volumes", sa.JSON(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name", "provider", name="_lf_machine__name_provider"),
    )
    op.create_index(
        op.f("ix_lf_machine_created_at"), "lf_machine", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_lf_machine_location"), "lf_machine", ["location"], unique=False
    )
    op.create_index(op.f("ix_lf_machine_name"), "lf_machine", ["name"], unique=True)
    op.create_index(
        op.f("ix_lf_machine_provider"), "lf_machine", ["provider"], unique=False
    )
    op.create_table(
        "lf_user",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("password", sa.BINARY(), nullable=True),
        sa.Column("is_superuser", sa.Boolean(), nullable=False),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("scopes", sa.String(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column("username", sa.String(), nullable=False),
        sa.Column("email", sa.String(), nullable=True),
        sa.Column("is_agent", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_lf_user_email"), "lf_user", ["email"], unique=False)
    op.create_index(op.f("ix_lf_user_is_agent"), "lf_user", ["is_agent"], unique=False)
    op.create_index(op.f("ix_lf_user_username"), "lf_user", ["username"], unique=True)
    op.create_table(
        "lf_project",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("projectid", sa.String(length=16), nullable=False),
        sa.Column("name", sa.String(length=128), nullable=False),
        sa.Column("private_key", sa.BINARY(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("repository", sa.String(length=2048), nullable=True),
        sa.Column("owner_id", sa.BigInteger(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["owner_id"], ["lf_user.id"], ondelete="SET NULL"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_index(
        op.f("ix_lf_project_projectid"), "lf_project", ["projectid"], unique=True
    )
    op.create_table(
        "lf_history",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("wfid", sa.String(length=24), nullable=True),
        sa.Column("execid", sa.String(length=24), nullable=True),
        sa.Column("nb_name", sa.String(), nullable=False),
        sa.Column("result", sa.JSON(), nullable=False),
        sa.Column("elapsed_secs", sa.Float(), nullable=False),
        sa.Column("status", sa.Integer(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"], ["lf_project.projectid"], ondelete="SET NULL"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_lf_history_created_at"), "lf_history", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_lf_history_status"), "lf_history", ["status"], unique=False
    )
    op.create_table(
        "lf_notebook_file",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("nb_name", sa.String(length=24), nullable=True),
        sa.Column("remote_path", sa.String(length=24), nullable=True),
        sa.Column("params", sa.String(), nullable=True),
        sa.Column("runtimeid", sa.String(), nullable=False),
        sa.Column("owner_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.ForeignKeyConstraint(["owner_id"], ["lf_user.id"], ondelete="SET NULL"),
        sa.ForeignKeyConstraint(
            ["project_id"], ["lf_project.projectid"], ondelete="SET NULL"
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint(
            "nb_name", "project_id", name="_lf_notebook_file__name_project"
        ),
    )
    op.create_index(
        op.f("ix_lf_notebook_file_nb_name"),
        "lf_notebook_file",
        ["nb_name"],
        unique=False,
    )
    op.create_index(
        op.f("ix_lf_notebook_file_runtimeid"),
        "lf_notebook_file",
        ["runtimeid"],
        unique=False,
    )
    op.create_table(
        "lf_projects_users",
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.Column("user_id", sa.BigInteger(), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["lf_project.projectid"],
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["lf_user.id"],
        ),
    )
    op.create_table(
        "lf_runtime",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("runtimeid", sa.String(), nullable=False),
        sa.Column("runtime_name", sa.String(), nullable=False),
        sa.Column("docker_name", sa.String(), nullable=False),
        sa.Column("spec", sa.JSON(), nullable=False),
        sa.Column("version", sa.String(), nullable=False),
        sa.Column("registry", sa.String(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"], ["lf_project.projectid"], ondelete="SET NULL"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_lf_runtime_created_at"), "lf_runtime", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_lf_runtime_runtime_name"), "lf_runtime", ["runtime_name"], unique=False
    )
    op.create_index(
        op.f("ix_lf_runtime_runtimeid"), "lf_runtime", ["runtimeid"], unique=True
    )
    op.create_table(
        "lf_workflow",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("wfid", sa.String(length=24), nullable=True),
        sa.Column("alias", sa.String(length=33), nullable=False),
        sa.Column("nbtask", sa.JSON(), nullable=False),
        sa.Column("schedule", sa.JSON(), nullable=False),
        sa.Column("enabled", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=True
        ),
        sa.Column("project_id", sa.String(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"], ["lf_project.projectid"], ondelete="SET NULL"
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("alias", "project_id", name="_lf_workflow__project_alias"),
    )
    op.create_index(
        op.f("ix_lf_workflow_alias"), "lf_workflow", ["alias"], unique=False
    )
    op.create_index(op.f("ix_lf_workflow_wfid"), "lf_workflow", ["wfid"], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_lf_workflow_wfid"), table_name="lf_workflow")
    op.drop_index(op.f("ix_lf_workflow_alias"), table_name="lf_workflow")
    op.drop_table("lf_workflow")
    op.drop_index(op.f("ix_lf_runtime_runtimeid"), table_name="lf_runtime")
    op.drop_index(op.f("ix_lf_runtime_runtime_name"), table_name="lf_runtime")
    op.drop_index(op.f("ix_lf_runtime_created_at"), table_name="lf_runtime")
    op.drop_table("lf_runtime")
    op.drop_table("lf_projects_users")
    op.drop_index(op.f("ix_lf_notebook_file_runtimeid"), table_name="lf_notebook_file")
    op.drop_index(op.f("ix_lf_notebook_file_nb_name"), table_name="lf_notebook_file")
    op.drop_table("lf_notebook_file")
    op.drop_index(op.f("ix_lf_history_status"), table_name="lf_history")
    op.drop_index(op.f("ix_lf_history_created_at"), table_name="lf_history")
    op.drop_table("lf_history")
    op.drop_index(op.f("ix_lf_project_projectid"), table_name="lf_project")
    op.drop_table("lf_project")
    op.drop_index(op.f("ix_lf_user_username"), table_name="lf_user")
    op.drop_index(op.f("ix_lf_user_is_agent"), table_name="lf_user")
    op.drop_index(op.f("ix_lf_user_email"), table_name="lf_user")
    op.drop_table("lf_user")
    op.drop_index(op.f("ix_lf_machine_provider"), table_name="lf_machine")
    op.drop_index(op.f("ix_lf_machine_name"), table_name="lf_machine")
    op.drop_index(op.f("ix_lf_machine_location"), table_name="lf_machine")
    op.drop_index(op.f("ix_lf_machine_created_at"), table_name="lf_machine")
    op.drop_table("lf_machine")
    # ### end Alembic commands ###
