#!/usr/bin/env python3
import os
import subprocess
import sys

import base_parser


class CppCodeParser(base_parser.BaseParser):
    def __init__(self, file_path):
        super().__init__(file_path)
        self.language = "cpp"

    def parse(self):
        try:
            clang_output = subprocess.check_output(
                ["clang-check", "-ast-dump=full", self.file_path],
                stderr=subprocess.STDOUT,
                universal_newlines=True,
            )
        except subprocess.CalledProcessError as e:
            print(f"Error: {e.output}")
            return

        self.parse_clang_output(clang_output)

    def parse_clang_output(self, clang_output):
        for line in clang_output.split("\n"):
            if line.strip().startswith("###"):
                self.handle_section_header(line.strip())
            elif line.strip().startswith("##"):
                self.handle_entity_header(line.strip())
            elif line.strip():
                self.handle_entity_line(line.strip())

    def handle_section_header(self, line):
        pass

    def handle_entity_header(self, line):
        pass

    def handle_entity_line(self, line):
        pass


if __name__ == "__main__":
    if len(sys.argv) != 2:
        print(f"Usage: {sys.argv[0]} <file_path>")
        sys.exit(1)

    file_path = sys.argv[1]
    if not os.path.isfile(file_path):
        print(f"Error: {file_path} is not a valid file path")
        sys.exit(1)

    parser = CppCodeParser(file_path)
    parser.parse()
