import { Architecture, AssetCode, Runtime } from 'aws-cdk-lib/aws-lambda';
import { BundlingFileAccess, BundlingOptions as CdkBundlingOptions, DockerImage, DockerVolume } from 'aws-cdk-lib/core';
import { BundlingOptions } from './types';
/**
 * Dependency files to exclude from the asset hash.
 */
export declare const DEPENDENCY_EXCLUDES: string[];
/**
 * The location in the image that the bundler image caches dependencies.
 */
export declare const BUNDLER_DEPENDENCIES_CACHE = "/var/dependencies";
/**
 * Options for bundling
 */
export interface BundlingProps extends BundlingOptions {
    /**
     * Entry path
     */
    readonly entry: string;
    /**
     * The runtime environment.
     */
    readonly runtime: Runtime;
    /**
     * The system architecture of the lambda function
     *
     * @default Architecture.X86_64
     */
    readonly architecture?: Architecture;
    /**
     * Whether or not the bundling process should be skipped
     *
     * @default - Does not skip bundling
     */
    readonly skip?: boolean;
    /**
     * Which option to use to copy the source files to the docker container and output files back
     * @default - BundlingFileAccess.BIND_MOUNT
     */
    bundlingFileAccess?: BundlingFileAccess;
}
/**
 * Produce bundled Lambda asset code
 */
export declare class Bundling implements CdkBundlingOptions {
    static bundle(options: BundlingProps): AssetCode;
    readonly image: DockerImage;
    readonly entrypoint?: string[];
    readonly command: string[];
    readonly volumes?: DockerVolume[];
    readonly volumesFrom?: string[];
    readonly environment?: {
        [key: string]: string;
    };
    readonly workingDirectory?: string;
    readonly user?: string;
    readonly securityOpt?: string;
    readonly network?: string;
    readonly bundlingFileAccess?: BundlingFileAccess;
    constructor(props: BundlingProps);
    private createBundlingCommand;
}
