# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class Acct(AbstractModel):
    """账户信息

    """

    def __init__(self):
        r"""
        :param _SubAcctNo: STRING(50)，见证子账户的账号（可重复）
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAcctNo: str
        :param _SubAcctProperty: STRING(10)，见证子账户的属性（可重复。1: 普通会员子账号; 2: 挂账子账号; 3: 手续费子账号; 4: 利息子账号; 5: 平台担保子账号）
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAcctProperty: str
        :param _TranNetMemberCode: STRING(32)，交易网会员代码（可重复）
注意：此字段可能返回 null，表示取不到有效值。
        :type TranNetMemberCode: str
        :param _SubAcctName: STRING(150)，见证子账户的名称（可重复）
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAcctName: str
        :param _AcctAvailBal: STRING(20)，见证子账户可用余额（可重复）
注意：此字段可能返回 null，表示取不到有效值。
        :type AcctAvailBal: str
        :param _CashAmt: STRING(20)，见证子账户可提现金额（可重复。开户日期或修改日期）
注意：此字段可能返回 null，表示取不到有效值。
        :type CashAmt: str
        :param _MaintenanceDate: STRING(8)，维护日期
注意：此字段可能返回 null，表示取不到有效值。
        :type MaintenanceDate: str
        """
        self._SubAcctNo = None
        self._SubAcctProperty = None
        self._TranNetMemberCode = None
        self._SubAcctName = None
        self._AcctAvailBal = None
        self._CashAmt = None
        self._MaintenanceDate = None

    @property
    def SubAcctNo(self):
        """STRING(50)，见证子账户的账号（可重复）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAcctNo

    @SubAcctNo.setter
    def SubAcctNo(self, SubAcctNo):
        self._SubAcctNo = SubAcctNo

    @property
    def SubAcctProperty(self):
        """STRING(10)，见证子账户的属性（可重复。1: 普通会员子账号; 2: 挂账子账号; 3: 手续费子账号; 4: 利息子账号; 5: 平台担保子账号）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAcctProperty

    @SubAcctProperty.setter
    def SubAcctProperty(self, SubAcctProperty):
        self._SubAcctProperty = SubAcctProperty

    @property
    def TranNetMemberCode(self):
        """STRING(32)，交易网会员代码（可重复）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TranNetMemberCode

    @TranNetMemberCode.setter
    def TranNetMemberCode(self, TranNetMemberCode):
        self._TranNetMemberCode = TranNetMemberCode

    @property
    def SubAcctName(self):
        """STRING(150)，见证子账户的名称（可重复）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAcctName

    @SubAcctName.setter
    def SubAcctName(self, SubAcctName):
        self._SubAcctName = SubAcctName

    @property
    def AcctAvailBal(self):
        """STRING(20)，见证子账户可用余额（可重复）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AcctAvailBal

    @AcctAvailBal.setter
    def AcctAvailBal(self, AcctAvailBal):
        self._AcctAvailBal = AcctAvailBal

    @property
    def CashAmt(self):
        """STRING(20)，见证子账户可提现金额（可重复。开户日期或修改日期）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CashAmt

    @CashAmt.setter
    def CashAmt(self, CashAmt):
        self._CashAmt = CashAmt

    @property
    def MaintenanceDate(self):
        """STRING(8)，维护日期
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MaintenanceDate

    @MaintenanceDate.setter
    def MaintenanceDate(self, MaintenanceDate):
        self._MaintenanceDate = MaintenanceDate


    def _deserialize(self, params):
        self._SubAcctNo = params.get("SubAcctNo")
        self._SubAcctProperty = params.get("SubAcctProperty")
        self._TranNetMemberCode = params.get("TranNetMemberCode")
        self._SubAcctName = params.get("SubAcctName")
        self._AcctAvailBal = params.get("AcctAvailBal")
        self._CashAmt = params.get("CashAmt")
        self._MaintenanceDate = params.get("MaintenanceDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddContractRequest(AbstractModel):
    """AddContract请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 收单系统分配的开放ID
        :type OpenId: str
        :param _OpenKey: 收单系统分配的密钥
        :type OpenKey: str
        :param _OutContractId: 机构合同主键（系统有唯一性校验），建议使用合同表的主键ID，防止重复添加合同
        :type OutContractId: str
        :param _Code: 合同编号（系统有唯一性校验）
        :type Code: str
        :param _PaymentId: 支付方式编号
        :type PaymentId: str
        :param _PaymentClassificationId: 支付方式行业分类编号
        :type PaymentClassificationId: str
        :param _PaymentClassificationLimit: 封顶值（分为单位，无封顶填0）
        :type PaymentClassificationLimit: str
        :param _MerchantNo: 商户编号
        :type MerchantNo: str
        :param _Fee: 签约扣率百分比（如：0.32）
        :type Fee: str
        :param _StartDate: 合同生效日期（yyyy-mm-dd）
        :type StartDate: str
        :param _EndDate: 合同过期日期（yyyy-mm-dd）
        :type EndDate: str
        :param _SignMan: 合同签约人
        :type SignMan: str
        :param _SignName: 签购单名称，建议使用商户招牌名称
        :type SignName: str
        :param _SignDate: 合同签署日期（yyyy-mm-dd）
        :type SignDate: str
        :param _AutoSign: 是否自动续签（1是，0否）
        :type AutoSign: str
        :param _Contact: 联系人
        :type Contact: str
        :param _ContactTelephone: 联系人电话
        :type ContactTelephone: str
        :param _PictureOne: 合同照片【私密区】
        :type PictureOne: str
        :param _PictureTwo: 合同照片【私密区】
        :type PictureTwo: str
        :param _ChannelExtJson: 渠道扩展字段，json格式
        :type ChannelExtJson: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        :param _PaymentOptionOne: 合同选项1（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionOne: str
        :param _PaymentOptionTwo: 合同选项2（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionTwo: str
        :param _PaymentOptionThree: 合同选项3（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionThree: str
        :param _PaymentOptionFour: 合同选项4（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionFour: str
        :param _PaymentOptionFive: 合同证书选项1（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionFive: str
        :param _PaymentOptionSix: 合同证书选项2（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionSix: str
        :param _PaymentOptionSeven: 合同选项5（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionSeven: str
        :param _PaymentOptionOther: 合同选项6（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionOther: str
        :param _PaymentOptionTen: 合同选项8
        :type PaymentOptionTen: str
        :param _PaymentOptionNine: 合同选项7（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :type PaymentOptionNine: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._OutContractId = None
        self._Code = None
        self._PaymentId = None
        self._PaymentClassificationId = None
        self._PaymentClassificationLimit = None
        self._MerchantNo = None
        self._Fee = None
        self._StartDate = None
        self._EndDate = None
        self._SignMan = None
        self._SignName = None
        self._SignDate = None
        self._AutoSign = None
        self._Contact = None
        self._ContactTelephone = None
        self._PictureOne = None
        self._PictureTwo = None
        self._ChannelExtJson = None
        self._Profile = None
        self._PaymentOptionOne = None
        self._PaymentOptionTwo = None
        self._PaymentOptionThree = None
        self._PaymentOptionFour = None
        self._PaymentOptionFive = None
        self._PaymentOptionSix = None
        self._PaymentOptionSeven = None
        self._PaymentOptionOther = None
        self._PaymentOptionTen = None
        self._PaymentOptionNine = None

    @property
    def OpenId(self):
        """收单系统分配的开放ID
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """收单系统分配的密钥
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def OutContractId(self):
        """机构合同主键（系统有唯一性校验），建议使用合同表的主键ID，防止重复添加合同
        :rtype: str
        """
        return self._OutContractId

    @OutContractId.setter
    def OutContractId(self, OutContractId):
        self._OutContractId = OutContractId

    @property
    def Code(self):
        """合同编号（系统有唯一性校验）
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def PaymentId(self):
        """支付方式编号
        :rtype: str
        """
        return self._PaymentId

    @PaymentId.setter
    def PaymentId(self, PaymentId):
        self._PaymentId = PaymentId

    @property
    def PaymentClassificationId(self):
        """支付方式行业分类编号
        :rtype: str
        """
        return self._PaymentClassificationId

    @PaymentClassificationId.setter
    def PaymentClassificationId(self, PaymentClassificationId):
        self._PaymentClassificationId = PaymentClassificationId

    @property
    def PaymentClassificationLimit(self):
        """封顶值（分为单位，无封顶填0）
        :rtype: str
        """
        return self._PaymentClassificationLimit

    @PaymentClassificationLimit.setter
    def PaymentClassificationLimit(self, PaymentClassificationLimit):
        self._PaymentClassificationLimit = PaymentClassificationLimit

    @property
    def MerchantNo(self):
        """商户编号
        :rtype: str
        """
        return self._MerchantNo

    @MerchantNo.setter
    def MerchantNo(self, MerchantNo):
        self._MerchantNo = MerchantNo

    @property
    def Fee(self):
        """签约扣率百分比（如：0.32）
        :rtype: str
        """
        return self._Fee

    @Fee.setter
    def Fee(self, Fee):
        self._Fee = Fee

    @property
    def StartDate(self):
        """合同生效日期（yyyy-mm-dd）
        :rtype: str
        """
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        """合同过期日期（yyyy-mm-dd）
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def SignMan(self):
        """合同签约人
        :rtype: str
        """
        return self._SignMan

    @SignMan.setter
    def SignMan(self, SignMan):
        self._SignMan = SignMan

    @property
    def SignName(self):
        """签购单名称，建议使用商户招牌名称
        :rtype: str
        """
        return self._SignName

    @SignName.setter
    def SignName(self, SignName):
        self._SignName = SignName

    @property
    def SignDate(self):
        """合同签署日期（yyyy-mm-dd）
        :rtype: str
        """
        return self._SignDate

    @SignDate.setter
    def SignDate(self, SignDate):
        self._SignDate = SignDate

    @property
    def AutoSign(self):
        """是否自动续签（1是，0否）
        :rtype: str
        """
        return self._AutoSign

    @AutoSign.setter
    def AutoSign(self, AutoSign):
        self._AutoSign = AutoSign

    @property
    def Contact(self):
        """联系人
        :rtype: str
        """
        return self._Contact

    @Contact.setter
    def Contact(self, Contact):
        self._Contact = Contact

    @property
    def ContactTelephone(self):
        """联系人电话
        :rtype: str
        """
        return self._ContactTelephone

    @ContactTelephone.setter
    def ContactTelephone(self, ContactTelephone):
        self._ContactTelephone = ContactTelephone

    @property
    def PictureOne(self):
        """合同照片【私密区】
        :rtype: str
        """
        return self._PictureOne

    @PictureOne.setter
    def PictureOne(self, PictureOne):
        self._PictureOne = PictureOne

    @property
    def PictureTwo(self):
        """合同照片【私密区】
        :rtype: str
        """
        return self._PictureTwo

    @PictureTwo.setter
    def PictureTwo(self, PictureTwo):
        self._PictureTwo = PictureTwo

    @property
    def ChannelExtJson(self):
        """渠道扩展字段，json格式
        :rtype: str
        """
        return self._ChannelExtJson

    @ChannelExtJson.setter
    def ChannelExtJson(self, ChannelExtJson):
        self._ChannelExtJson = ChannelExtJson

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def PaymentOptionOne(self):
        """合同选项1（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionOne

    @PaymentOptionOne.setter
    def PaymentOptionOne(self, PaymentOptionOne):
        self._PaymentOptionOne = PaymentOptionOne

    @property
    def PaymentOptionTwo(self):
        """合同选项2（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionTwo

    @PaymentOptionTwo.setter
    def PaymentOptionTwo(self, PaymentOptionTwo):
        self._PaymentOptionTwo = PaymentOptionTwo

    @property
    def PaymentOptionThree(self):
        """合同选项3（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionThree

    @PaymentOptionThree.setter
    def PaymentOptionThree(self, PaymentOptionThree):
        self._PaymentOptionThree = PaymentOptionThree

    @property
    def PaymentOptionFour(self):
        """合同选项4（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionFour

    @PaymentOptionFour.setter
    def PaymentOptionFour(self, PaymentOptionFour):
        self._PaymentOptionFour = PaymentOptionFour

    @property
    def PaymentOptionFive(self):
        """合同证书选项1（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionFive

    @PaymentOptionFive.setter
    def PaymentOptionFive(self, PaymentOptionFive):
        self._PaymentOptionFive = PaymentOptionFive

    @property
    def PaymentOptionSix(self):
        """合同证书选项2（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionSix

    @PaymentOptionSix.setter
    def PaymentOptionSix(self, PaymentOptionSix):
        self._PaymentOptionSix = PaymentOptionSix

    @property
    def PaymentOptionSeven(self):
        """合同选项5（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionSeven

    @PaymentOptionSeven.setter
    def PaymentOptionSeven(self, PaymentOptionSeven):
        self._PaymentOptionSeven = PaymentOptionSeven

    @property
    def PaymentOptionOther(self):
        """合同选项6（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionOther

    @PaymentOptionOther.setter
    def PaymentOptionOther(self, PaymentOptionOther):
        self._PaymentOptionOther = PaymentOptionOther

    @property
    def PaymentOptionTen(self):
        """合同选项8
        :rtype: str
        """
        return self._PaymentOptionTen

    @PaymentOptionTen.setter
    def PaymentOptionTen(self, PaymentOptionTen):
        self._PaymentOptionTen = PaymentOptionTen

    @property
    def PaymentOptionNine(self):
        """合同选项7（不同支付方式规则不一样，请以支付方式规定的格式传值）
        :rtype: str
        """
        return self._PaymentOptionNine

    @PaymentOptionNine.setter
    def PaymentOptionNine(self, PaymentOptionNine):
        self._PaymentOptionNine = PaymentOptionNine


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._OutContractId = params.get("OutContractId")
        self._Code = params.get("Code")
        self._PaymentId = params.get("PaymentId")
        self._PaymentClassificationId = params.get("PaymentClassificationId")
        self._PaymentClassificationLimit = params.get("PaymentClassificationLimit")
        self._MerchantNo = params.get("MerchantNo")
        self._Fee = params.get("Fee")
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._SignMan = params.get("SignMan")
        self._SignName = params.get("SignName")
        self._SignDate = params.get("SignDate")
        self._AutoSign = params.get("AutoSign")
        self._Contact = params.get("Contact")
        self._ContactTelephone = params.get("ContactTelephone")
        self._PictureOne = params.get("PictureOne")
        self._PictureTwo = params.get("PictureTwo")
        self._ChannelExtJson = params.get("ChannelExtJson")
        self._Profile = params.get("Profile")
        self._PaymentOptionOne = params.get("PaymentOptionOne")
        self._PaymentOptionTwo = params.get("PaymentOptionTwo")
        self._PaymentOptionThree = params.get("PaymentOptionThree")
        self._PaymentOptionFour = params.get("PaymentOptionFour")
        self._PaymentOptionFive = params.get("PaymentOptionFive")
        self._PaymentOptionSix = params.get("PaymentOptionSix")
        self._PaymentOptionSeven = params.get("PaymentOptionSeven")
        self._PaymentOptionOther = params.get("PaymentOptionOther")
        self._PaymentOptionTen = params.get("PaymentOptionTen")
        self._PaymentOptionNine = params.get("PaymentOptionNine")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddContractResponse(AbstractModel):
    """AddContract返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 添加合同响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.AddContractResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """添加合同响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.AddContractResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = AddContractResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class AddContractResult(AbstractModel):
    """添加合同响应对象

    """

    def __init__(self):
        r"""
        :param _ContractId: 合同主键
注意：此字段可能返回 null，表示取不到有效值。
        :type ContractId: str
        """
        self._ContractId = None

    @property
    def ContractId(self):
        """合同主键
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ContractId

    @ContractId.setter
    def ContractId(self, ContractId):
        self._ContractId = ContractId


    def _deserialize(self, params):
        self._ContractId = params.get("ContractId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddFlexFundingAccountRequest(AbstractModel):
    """AddFlexFundingAccount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FundingAccountType: 资金账户类型
PINGAN_BANK:平安银行
        :type FundingAccountType: str
        :param _FundingAccountName: 收款资金账户姓名
        :type FundingAccountName: str
        :param _FundingAccountNo: 收款资金账户号
        :type FundingAccountNo: str
        :param _PhoneNo: 收款资金账户手机号
        :type PhoneNo: str
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        :param _BankBranchName: 开户支行名
        :type BankBranchName: str
        """
        self._FundingAccountType = None
        self._FundingAccountName = None
        self._FundingAccountNo = None
        self._PhoneNo = None
        self._PayeeId = None
        self._Environment = None
        self._BankBranchName = None

    @property
    def FundingAccountType(self):
        """资金账户类型
PINGAN_BANK:平安银行
        :rtype: str
        """
        return self._FundingAccountType

    @FundingAccountType.setter
    def FundingAccountType(self, FundingAccountType):
        self._FundingAccountType = FundingAccountType

    @property
    def FundingAccountName(self):
        """收款资金账户姓名
        :rtype: str
        """
        return self._FundingAccountName

    @FundingAccountName.setter
    def FundingAccountName(self, FundingAccountName):
        self._FundingAccountName = FundingAccountName

    @property
    def FundingAccountNo(self):
        """收款资金账户号
        :rtype: str
        """
        return self._FundingAccountNo

    @FundingAccountNo.setter
    def FundingAccountNo(self, FundingAccountNo):
        self._FundingAccountNo = FundingAccountNo

    @property
    def PhoneNo(self):
        """收款资金账户手机号
        :rtype: str
        """
        return self._PhoneNo

    @PhoneNo.setter
    def PhoneNo(self, PhoneNo):
        self._PhoneNo = PhoneNo

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment

    @property
    def BankBranchName(self):
        """开户支行名
        :rtype: str
        """
        return self._BankBranchName

    @BankBranchName.setter
    def BankBranchName(self, BankBranchName):
        self._BankBranchName = BankBranchName


    def _deserialize(self, params):
        self._FundingAccountType = params.get("FundingAccountType")
        self._FundingAccountName = params.get("FundingAccountName")
        self._FundingAccountNo = params.get("FundingAccountNo")
        self._PhoneNo = params.get("PhoneNo")
        self._PayeeId = params.get("PayeeId")
        self._Environment = params.get("Environment")
        self._BankBranchName = params.get("BankBranchName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddFlexFundingAccountResponse(AbstractModel):
    """AddFlexFundingAccount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.PayeeFundingAccountResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.PayeeFundingAccountResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = PayeeFundingAccountResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class AddFlexIdInfoRequest(AbstractModel):
    """AddFlexIdInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _IdType: 证件类型
0:身份证
1:社会信用代码
        :type IdType: int
        :param _IdNo: 证件号
        :type IdNo: str
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        :param _Name: 姓名
        :type Name: str
        """
        self._IdType = None
        self._IdNo = None
        self._PayeeId = None
        self._Environment = None
        self._Name = None

    @property
    def IdType(self):
        """证件类型
0:身份证
1:社会信用代码
        :rtype: int
        """
        return self._IdType

    @IdType.setter
    def IdType(self, IdType):
        self._IdType = IdType

    @property
    def IdNo(self):
        """证件号
        :rtype: str
        """
        return self._IdNo

    @IdNo.setter
    def IdNo(self, IdNo):
        self._IdNo = IdNo

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment

    @property
    def Name(self):
        """姓名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._IdType = params.get("IdType")
        self._IdNo = params.get("IdNo")
        self._PayeeId = params.get("PayeeId")
        self._Environment = params.get("Environment")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddFlexIdInfoResponse(AbstractModel):
    """AddFlexIdInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AddFlexPhoneNoRequest(AbstractModel):
    """AddFlexPhoneNo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PhoneNo: 手机号
        :type PhoneNo: str
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        """
        self._PhoneNo = None
        self._PayeeId = None
        self._Environment = None

    @property
    def PhoneNo(self):
        """手机号
        :rtype: str
        """
        return self._PhoneNo

    @PhoneNo.setter
    def PhoneNo(self, PhoneNo):
        self._PhoneNo = PhoneNo

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._PhoneNo = params.get("PhoneNo")
        self._PayeeId = params.get("PayeeId")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddFlexPhoneNoResponse(AbstractModel):
    """AddFlexPhoneNo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AddMerchantRequest(AbstractModel):
    """AddMerchant请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 收单系统分配的开放ID
        :type OpenId: str
        :param _OpenKey: 收单系统分配的密钥
        :type OpenKey: str
        :param _OutMerchantId: 机构商户主键（系统有唯一性校验），建议使用商户表的主键ID，防止重复添加商户
        :type OutMerchantId: str
        :param _MerchantName: 商户名称，小微商户命名要符合“”商户_名字” （例如：商户_张三）
        :type MerchantName: str
        :param _BusinessLicenseType: 营业执照类型（1三证合一，2非三证合一）
        :type BusinessLicenseType: str
        :param _BusinessLicenseNo: 营业执照编号（系统有唯一性校验），（小微商户不效验，随意传要有值，公司/个体户必传）
        :type BusinessLicenseNo: str
        :param _BusinessLicensePicture: 营业执照图片【私密区】（系统返回的图片路径），（小微商户不效验，随意传要有值，公司/个体户必传）
        :type BusinessLicensePicture: str
        :param _BusinessLicenseStartDate: 营业执照生效时间（yyyy-mm-dd），（小微商户不效验，随意传要有值，公司/个体户必传）
        :type BusinessLicenseStartDate: str
        :param _BusinessLicenseEndDate: 营业执照过期时间（yyyy-mm-dd），（小微商户不效验，随意传要有值，公司/个体户必传）
        :type BusinessLicenseEndDate: str
        :param _ClassificationIds: 行业分类编号列表（第一个分类编号为主分类，后面的为二级分类）
        :type ClassificationIds: list of str
        :param _BrandName: 招牌名称
        :type BrandName: str
        :param _Telephone: 联系电话
        :type Telephone: str
        :param _CityId: 城市编号
        :type CityId: str
        :param _Address: 详细地址，不含省市区县名称，长度需要大于5。
        :type Address: str
        :param _OpenHours: 营业时间，多个以小写逗号分开(9:00-12:00,13:00-18:00)
        :type OpenHours: str
        :param _AccountType: 结算账户类型（2对私，1对公）
        :type AccountType: str
        :param _BankNo: 清算联行号，开户行行号
        :type BankNo: str
        :param _BankName: 开户行名称
        :type BankName: str
        :param _AccountNo: 银行账号
        :type AccountNo: str
        :param _AccountName: 银行户名
        :type AccountName: str
        :param _BossIdType: 法人证件类型（1居民身份证,2临时居民身份证,3居民户口簿,4护照,5港澳居民来往内地通行证,6回乡证,7军人证,8武警身份证,9其他法定文件）
        :type BossIdType: str
        :param _BossIdNo: 法人证件号码
        :type BossIdNo: str
        :param _BossName: 法人姓名
        :type BossName: str
        :param _BossSex: 法人性别（1男，2女）
        :type BossSex: str
        :param _BossIdCountry: 法人证件国别/地区（中国CHN，香港HKG，澳门MAC，台湾CTN）
        :type BossIdCountry: str
        :param _BossPositive: 法人身份证正面【私密区】（系统返回的图片路径）
        :type BossPositive: str
        :param _BossBack: 法人身份证背面【私密区】（系统返回的图片路径）
        :type BossBack: str
        :param _BossStartDate: 法人证件生效时间（yyyy-mm-dd）
        :type BossStartDate: str
        :param _BossEndDate: 法人证件过期时间（yyyy-mm-dd）
        :type BossEndDate: str
        :param _LicencePicture: 许可证图片【私密区】，（小微商户不效验，随意传要有值，公司/个体户必传）
        :type LicencePicture: str
        :param _Type: 商户类型：1-个体，2-小微，3-企业。不传默认为2-小微商户。
        :type Type: str
        :param _OrganizationNo: 组织机构代码证号
        :type OrganizationNo: str
        :param _OrganizationStartDate: 组织机构代码证生效时间（yyyy-mm-dd）
        :type OrganizationStartDate: str
        :param _OrganizationPicture: 组织机构代码证图片【私密区】
        :type OrganizationPicture: str
        :param _OrganizationEndDate: 组织机构代码证过期时间（yyyy-mm-dd）
        :type OrganizationEndDate: str
        :param _Intro: 商户简介
        :type Intro: str
        :param _Logo: 商户logo【公共区】
        :type Logo: str
        :param _Tag: 商户标记，自定义参数
        :type Tag: str
        :param _FinancialTelephone: 财务联系人电话
        :type FinancialTelephone: str
        :param _FinancialContact: 财务联系人
        :type FinancialContact: str
        :param _TaxRegistrationNo: 税务登记证号
        :type TaxRegistrationNo: str
        :param _TaxRegistrationPicture: 税务登记证图片【私密区】
        :type TaxRegistrationPicture: str
        :param _TaxRegistrationStartDate: 税务登记证生效时间（yyyy-mm-dd）
        :type TaxRegistrationStartDate: str
        :param _TaxRegistrationEndDate: 税务登记证过期时间（yyyy-mm-dd）
        :type TaxRegistrationEndDate: str
        :param _AccountBoss: 结算账户人身份（1法人，2法人亲属），结算帐户为对私时必填
        :type AccountBoss: str
        :param _AccountManagerName: 客户经理姓名，必须为系统后台的管理员真实姓名
        :type AccountManagerName: str
        :param _BossTelephone: 法人电话
        :type BossTelephone: str
        :param _BossJob: 法人职业
        :type BossJob: str
        :param _BossEmail: 法人邮箱
        :type BossEmail: str
        :param _BossAddress: 法人住址
        :type BossAddress: str
        :param _AccountIdType: 法人亲属证件类型（1居民身份证,2临时居民身份证,3居民户口簿,4护照,5港澳居民来往内地通行证,6回乡证,7军人证,8武警身份证,9其他法定文件）结算账户人身份为法人亲属时必填
        :type AccountIdType: str
        :param _AccountIdNo: 法人亲属证件号码
        :type AccountIdNo: str
        :param _LicencePictureTwo: 授权文件【私密区】
        :type LicencePictureTwo: str
        :param _OtherPictureOne: 其他资料1
        :type OtherPictureOne: str
        :param _OtherPictureTwo: 其他资料2
        :type OtherPictureTwo: str
        :param _OtherPictureThree: 其他资料3
        :type OtherPictureThree: str
        :param _OtherPictureFour: 其他资料4
        :type OtherPictureFour: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._OutMerchantId = None
        self._MerchantName = None
        self._BusinessLicenseType = None
        self._BusinessLicenseNo = None
        self._BusinessLicensePicture = None
        self._BusinessLicenseStartDate = None
        self._BusinessLicenseEndDate = None
        self._ClassificationIds = None
        self._BrandName = None
        self._Telephone = None
        self._CityId = None
        self._Address = None
        self._OpenHours = None
        self._AccountType = None
        self._BankNo = None
        self._BankName = None
        self._AccountNo = None
        self._AccountName = None
        self._BossIdType = None
        self._BossIdNo = None
        self._BossName = None
        self._BossSex = None
        self._BossIdCountry = None
        self._BossPositive = None
        self._BossBack = None
        self._BossStartDate = None
        self._BossEndDate = None
        self._LicencePicture = None
        self._Type = None
        self._OrganizationNo = None
        self._OrganizationStartDate = None
        self._OrganizationPicture = None
        self._OrganizationEndDate = None
        self._Intro = None
        self._Logo = None
        self._Tag = None
        self._FinancialTelephone = None
        self._FinancialContact = None
        self._TaxRegistrationNo = None
        self._TaxRegistrationPicture = None
        self._TaxRegistrationStartDate = None
        self._TaxRegistrationEndDate = None
        self._AccountBoss = None
        self._AccountManagerName = None
        self._BossTelephone = None
        self._BossJob = None
        self._BossEmail = None
        self._BossAddress = None
        self._AccountIdType = None
        self._AccountIdNo = None
        self._LicencePictureTwo = None
        self._OtherPictureOne = None
        self._OtherPictureTwo = None
        self._OtherPictureThree = None
        self._OtherPictureFour = None
        self._Profile = None

    @property
    def OpenId(self):
        """收单系统分配的开放ID
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """收单系统分配的密钥
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def OutMerchantId(self):
        """机构商户主键（系统有唯一性校验），建议使用商户表的主键ID，防止重复添加商户
        :rtype: str
        """
        return self._OutMerchantId

    @OutMerchantId.setter
    def OutMerchantId(self, OutMerchantId):
        self._OutMerchantId = OutMerchantId

    @property
    def MerchantName(self):
        """商户名称，小微商户命名要符合“”商户_名字” （例如：商户_张三）
        :rtype: str
        """
        return self._MerchantName

    @MerchantName.setter
    def MerchantName(self, MerchantName):
        self._MerchantName = MerchantName

    @property
    def BusinessLicenseType(self):
        """营业执照类型（1三证合一，2非三证合一）
        :rtype: str
        """
        return self._BusinessLicenseType

    @BusinessLicenseType.setter
    def BusinessLicenseType(self, BusinessLicenseType):
        self._BusinessLicenseType = BusinessLicenseType

    @property
    def BusinessLicenseNo(self):
        """营业执照编号（系统有唯一性校验），（小微商户不效验，随意传要有值，公司/个体户必传）
        :rtype: str
        """
        return self._BusinessLicenseNo

    @BusinessLicenseNo.setter
    def BusinessLicenseNo(self, BusinessLicenseNo):
        self._BusinessLicenseNo = BusinessLicenseNo

    @property
    def BusinessLicensePicture(self):
        """营业执照图片【私密区】（系统返回的图片路径），（小微商户不效验，随意传要有值，公司/个体户必传）
        :rtype: str
        """
        return self._BusinessLicensePicture

    @BusinessLicensePicture.setter
    def BusinessLicensePicture(self, BusinessLicensePicture):
        self._BusinessLicensePicture = BusinessLicensePicture

    @property
    def BusinessLicenseStartDate(self):
        """营业执照生效时间（yyyy-mm-dd），（小微商户不效验，随意传要有值，公司/个体户必传）
        :rtype: str
        """
        return self._BusinessLicenseStartDate

    @BusinessLicenseStartDate.setter
    def BusinessLicenseStartDate(self, BusinessLicenseStartDate):
        self._BusinessLicenseStartDate = BusinessLicenseStartDate

    @property
    def BusinessLicenseEndDate(self):
        """营业执照过期时间（yyyy-mm-dd），（小微商户不效验，随意传要有值，公司/个体户必传）
        :rtype: str
        """
        return self._BusinessLicenseEndDate

    @BusinessLicenseEndDate.setter
    def BusinessLicenseEndDate(self, BusinessLicenseEndDate):
        self._BusinessLicenseEndDate = BusinessLicenseEndDate

    @property
    def ClassificationIds(self):
        """行业分类编号列表（第一个分类编号为主分类，后面的为二级分类）
        :rtype: list of str
        """
        return self._ClassificationIds

    @ClassificationIds.setter
    def ClassificationIds(self, ClassificationIds):
        self._ClassificationIds = ClassificationIds

    @property
    def BrandName(self):
        """招牌名称
        :rtype: str
        """
        return self._BrandName

    @BrandName.setter
    def BrandName(self, BrandName):
        self._BrandName = BrandName

    @property
    def Telephone(self):
        """联系电话
        :rtype: str
        """
        return self._Telephone

    @Telephone.setter
    def Telephone(self, Telephone):
        self._Telephone = Telephone

    @property
    def CityId(self):
        """城市编号
        :rtype: str
        """
        return self._CityId

    @CityId.setter
    def CityId(self, CityId):
        self._CityId = CityId

    @property
    def Address(self):
        """详细地址，不含省市区县名称，长度需要大于5。
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def OpenHours(self):
        """营业时间，多个以小写逗号分开(9:00-12:00,13:00-18:00)
        :rtype: str
        """
        return self._OpenHours

    @OpenHours.setter
    def OpenHours(self, OpenHours):
        self._OpenHours = OpenHours

    @property
    def AccountType(self):
        """结算账户类型（2对私，1对公）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def BankNo(self):
        """清算联行号，开户行行号
        :rtype: str
        """
        return self._BankNo

    @BankNo.setter
    def BankNo(self, BankNo):
        self._BankNo = BankNo

    @property
    def BankName(self):
        """开户行名称
        :rtype: str
        """
        return self._BankName

    @BankName.setter
    def BankName(self, BankName):
        self._BankName = BankName

    @property
    def AccountNo(self):
        """银行账号
        :rtype: str
        """
        return self._AccountNo

    @AccountNo.setter
    def AccountNo(self, AccountNo):
        self._AccountNo = AccountNo

    @property
    def AccountName(self):
        """银行户名
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def BossIdType(self):
        """法人证件类型（1居民身份证,2临时居民身份证,3居民户口簿,4护照,5港澳居民来往内地通行证,6回乡证,7军人证,8武警身份证,9其他法定文件）
        :rtype: str
        """
        return self._BossIdType

    @BossIdType.setter
    def BossIdType(self, BossIdType):
        self._BossIdType = BossIdType

    @property
    def BossIdNo(self):
        """法人证件号码
        :rtype: str
        """
        return self._BossIdNo

    @BossIdNo.setter
    def BossIdNo(self, BossIdNo):
        self._BossIdNo = BossIdNo

    @property
    def BossName(self):
        """法人姓名
        :rtype: str
        """
        return self._BossName

    @BossName.setter
    def BossName(self, BossName):
        self._BossName = BossName

    @property
    def BossSex(self):
        """法人性别（1男，2女）
        :rtype: str
        """
        return self._BossSex

    @BossSex.setter
    def BossSex(self, BossSex):
        self._BossSex = BossSex

    @property
    def BossIdCountry(self):
        """法人证件国别/地区（中国CHN，香港HKG，澳门MAC，台湾CTN）
        :rtype: str
        """
        return self._BossIdCountry

    @BossIdCountry.setter
    def BossIdCountry(self, BossIdCountry):
        self._BossIdCountry = BossIdCountry

    @property
    def BossPositive(self):
        """法人身份证正面【私密区】（系统返回的图片路径）
        :rtype: str
        """
        return self._BossPositive

    @BossPositive.setter
    def BossPositive(self, BossPositive):
        self._BossPositive = BossPositive

    @property
    def BossBack(self):
        """法人身份证背面【私密区】（系统返回的图片路径）
        :rtype: str
        """
        return self._BossBack

    @BossBack.setter
    def BossBack(self, BossBack):
        self._BossBack = BossBack

    @property
    def BossStartDate(self):
        """法人证件生效时间（yyyy-mm-dd）
        :rtype: str
        """
        return self._BossStartDate

    @BossStartDate.setter
    def BossStartDate(self, BossStartDate):
        self._BossStartDate = BossStartDate

    @property
    def BossEndDate(self):
        """法人证件过期时间（yyyy-mm-dd）
        :rtype: str
        """
        return self._BossEndDate

    @BossEndDate.setter
    def BossEndDate(self, BossEndDate):
        self._BossEndDate = BossEndDate

    @property
    def LicencePicture(self):
        """许可证图片【私密区】，（小微商户不效验，随意传要有值，公司/个体户必传）
        :rtype: str
        """
        return self._LicencePicture

    @LicencePicture.setter
    def LicencePicture(self, LicencePicture):
        self._LicencePicture = LicencePicture

    @property
    def Type(self):
        """商户类型：1-个体，2-小微，3-企业。不传默认为2-小微商户。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def OrganizationNo(self):
        """组织机构代码证号
        :rtype: str
        """
        return self._OrganizationNo

    @OrganizationNo.setter
    def OrganizationNo(self, OrganizationNo):
        self._OrganizationNo = OrganizationNo

    @property
    def OrganizationStartDate(self):
        """组织机构代码证生效时间（yyyy-mm-dd）
        :rtype: str
        """
        return self._OrganizationStartDate

    @OrganizationStartDate.setter
    def OrganizationStartDate(self, OrganizationStartDate):
        self._OrganizationStartDate = OrganizationStartDate

    @property
    def OrganizationPicture(self):
        """组织机构代码证图片【私密区】
        :rtype: str
        """
        return self._OrganizationPicture

    @OrganizationPicture.setter
    def OrganizationPicture(self, OrganizationPicture):
        self._OrganizationPicture = OrganizationPicture

    @property
    def OrganizationEndDate(self):
        """组织机构代码证过期时间（yyyy-mm-dd）
        :rtype: str
        """
        return self._OrganizationEndDate

    @OrganizationEndDate.setter
    def OrganizationEndDate(self, OrganizationEndDate):
        self._OrganizationEndDate = OrganizationEndDate

    @property
    def Intro(self):
        """商户简介
        :rtype: str
        """
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def Logo(self):
        """商户logo【公共区】
        :rtype: str
        """
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def Tag(self):
        """商户标记，自定义参数
        :rtype: str
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def FinancialTelephone(self):
        """财务联系人电话
        :rtype: str
        """
        return self._FinancialTelephone

    @FinancialTelephone.setter
    def FinancialTelephone(self, FinancialTelephone):
        self._FinancialTelephone = FinancialTelephone

    @property
    def FinancialContact(self):
        """财务联系人
        :rtype: str
        """
        return self._FinancialContact

    @FinancialContact.setter
    def FinancialContact(self, FinancialContact):
        self._FinancialContact = FinancialContact

    @property
    def TaxRegistrationNo(self):
        """税务登记证号
        :rtype: str
        """
        return self._TaxRegistrationNo

    @TaxRegistrationNo.setter
    def TaxRegistrationNo(self, TaxRegistrationNo):
        self._TaxRegistrationNo = TaxRegistrationNo

    @property
    def TaxRegistrationPicture(self):
        """税务登记证图片【私密区】
        :rtype: str
        """
        return self._TaxRegistrationPicture

    @TaxRegistrationPicture.setter
    def TaxRegistrationPicture(self, TaxRegistrationPicture):
        self._TaxRegistrationPicture = TaxRegistrationPicture

    @property
    def TaxRegistrationStartDate(self):
        """税务登记证生效时间（yyyy-mm-dd）
        :rtype: str
        """
        return self._TaxRegistrationStartDate

    @TaxRegistrationStartDate.setter
    def TaxRegistrationStartDate(self, TaxRegistrationStartDate):
        self._TaxRegistrationStartDate = TaxRegistrationStartDate

    @property
    def TaxRegistrationEndDate(self):
        """税务登记证过期时间（yyyy-mm-dd）
        :rtype: str
        """
        return self._TaxRegistrationEndDate

    @TaxRegistrationEndDate.setter
    def TaxRegistrationEndDate(self, TaxRegistrationEndDate):
        self._TaxRegistrationEndDate = TaxRegistrationEndDate

    @property
    def AccountBoss(self):
        """结算账户人身份（1法人，2法人亲属），结算帐户为对私时必填
        :rtype: str
        """
        return self._AccountBoss

    @AccountBoss.setter
    def AccountBoss(self, AccountBoss):
        self._AccountBoss = AccountBoss

    @property
    def AccountManagerName(self):
        """客户经理姓名，必须为系统后台的管理员真实姓名
        :rtype: str
        """
        return self._AccountManagerName

    @AccountManagerName.setter
    def AccountManagerName(self, AccountManagerName):
        self._AccountManagerName = AccountManagerName

    @property
    def BossTelephone(self):
        """法人电话
        :rtype: str
        """
        return self._BossTelephone

    @BossTelephone.setter
    def BossTelephone(self, BossTelephone):
        self._BossTelephone = BossTelephone

    @property
    def BossJob(self):
        """法人职业
        :rtype: str
        """
        return self._BossJob

    @BossJob.setter
    def BossJob(self, BossJob):
        self._BossJob = BossJob

    @property
    def BossEmail(self):
        """法人邮箱
        :rtype: str
        """
        return self._BossEmail

    @BossEmail.setter
    def BossEmail(self, BossEmail):
        self._BossEmail = BossEmail

    @property
    def BossAddress(self):
        """法人住址
        :rtype: str
        """
        return self._BossAddress

    @BossAddress.setter
    def BossAddress(self, BossAddress):
        self._BossAddress = BossAddress

    @property
    def AccountIdType(self):
        """法人亲属证件类型（1居民身份证,2临时居民身份证,3居民户口簿,4护照,5港澳居民来往内地通行证,6回乡证,7军人证,8武警身份证,9其他法定文件）结算账户人身份为法人亲属时必填
        :rtype: str
        """
        return self._AccountIdType

    @AccountIdType.setter
    def AccountIdType(self, AccountIdType):
        self._AccountIdType = AccountIdType

    @property
    def AccountIdNo(self):
        """法人亲属证件号码
        :rtype: str
        """
        return self._AccountIdNo

    @AccountIdNo.setter
    def AccountIdNo(self, AccountIdNo):
        self._AccountIdNo = AccountIdNo

    @property
    def LicencePictureTwo(self):
        """授权文件【私密区】
        :rtype: str
        """
        return self._LicencePictureTwo

    @LicencePictureTwo.setter
    def LicencePictureTwo(self, LicencePictureTwo):
        self._LicencePictureTwo = LicencePictureTwo

    @property
    def OtherPictureOne(self):
        """其他资料1
        :rtype: str
        """
        return self._OtherPictureOne

    @OtherPictureOne.setter
    def OtherPictureOne(self, OtherPictureOne):
        self._OtherPictureOne = OtherPictureOne

    @property
    def OtherPictureTwo(self):
        """其他资料2
        :rtype: str
        """
        return self._OtherPictureTwo

    @OtherPictureTwo.setter
    def OtherPictureTwo(self, OtherPictureTwo):
        self._OtherPictureTwo = OtherPictureTwo

    @property
    def OtherPictureThree(self):
        """其他资料3
        :rtype: str
        """
        return self._OtherPictureThree

    @OtherPictureThree.setter
    def OtherPictureThree(self, OtherPictureThree):
        self._OtherPictureThree = OtherPictureThree

    @property
    def OtherPictureFour(self):
        """其他资料4
        :rtype: str
        """
        return self._OtherPictureFour

    @OtherPictureFour.setter
    def OtherPictureFour(self, OtherPictureFour):
        self._OtherPictureFour = OtherPictureFour

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._OutMerchantId = params.get("OutMerchantId")
        self._MerchantName = params.get("MerchantName")
        self._BusinessLicenseType = params.get("BusinessLicenseType")
        self._BusinessLicenseNo = params.get("BusinessLicenseNo")
        self._BusinessLicensePicture = params.get("BusinessLicensePicture")
        self._BusinessLicenseStartDate = params.get("BusinessLicenseStartDate")
        self._BusinessLicenseEndDate = params.get("BusinessLicenseEndDate")
        self._ClassificationIds = params.get("ClassificationIds")
        self._BrandName = params.get("BrandName")
        self._Telephone = params.get("Telephone")
        self._CityId = params.get("CityId")
        self._Address = params.get("Address")
        self._OpenHours = params.get("OpenHours")
        self._AccountType = params.get("AccountType")
        self._BankNo = params.get("BankNo")
        self._BankName = params.get("BankName")
        self._AccountNo = params.get("AccountNo")
        self._AccountName = params.get("AccountName")
        self._BossIdType = params.get("BossIdType")
        self._BossIdNo = params.get("BossIdNo")
        self._BossName = params.get("BossName")
        self._BossSex = params.get("BossSex")
        self._BossIdCountry = params.get("BossIdCountry")
        self._BossPositive = params.get("BossPositive")
        self._BossBack = params.get("BossBack")
        self._BossStartDate = params.get("BossStartDate")
        self._BossEndDate = params.get("BossEndDate")
        self._LicencePicture = params.get("LicencePicture")
        self._Type = params.get("Type")
        self._OrganizationNo = params.get("OrganizationNo")
        self._OrganizationStartDate = params.get("OrganizationStartDate")
        self._OrganizationPicture = params.get("OrganizationPicture")
        self._OrganizationEndDate = params.get("OrganizationEndDate")
        self._Intro = params.get("Intro")
        self._Logo = params.get("Logo")
        self._Tag = params.get("Tag")
        self._FinancialTelephone = params.get("FinancialTelephone")
        self._FinancialContact = params.get("FinancialContact")
        self._TaxRegistrationNo = params.get("TaxRegistrationNo")
        self._TaxRegistrationPicture = params.get("TaxRegistrationPicture")
        self._TaxRegistrationStartDate = params.get("TaxRegistrationStartDate")
        self._TaxRegistrationEndDate = params.get("TaxRegistrationEndDate")
        self._AccountBoss = params.get("AccountBoss")
        self._AccountManagerName = params.get("AccountManagerName")
        self._BossTelephone = params.get("BossTelephone")
        self._BossJob = params.get("BossJob")
        self._BossEmail = params.get("BossEmail")
        self._BossAddress = params.get("BossAddress")
        self._AccountIdType = params.get("AccountIdType")
        self._AccountIdNo = params.get("AccountIdNo")
        self._LicencePictureTwo = params.get("LicencePictureTwo")
        self._OtherPictureOne = params.get("OtherPictureOne")
        self._OtherPictureTwo = params.get("OtherPictureTwo")
        self._OtherPictureThree = params.get("OtherPictureThree")
        self._OtherPictureFour = params.get("OtherPictureFour")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddMerchantResponse(AbstractModel):
    """AddMerchant返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码，0表示成功，其他表示失败。
        :type ErrCode: str
        :param _Result: 添加商户响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.AddMerchantResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码，0表示成功，其他表示失败。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """添加商户响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.AddMerchantResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = AddMerchantResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class AddMerchantResult(AbstractModel):
    """添加商户响应对象

    """

    def __init__(self):
        r"""
        :param _MerchantNo: 系统商户号
注意：此字段可能返回 null，表示取不到有效值。
        :type MerchantNo: str
        """
        self._MerchantNo = None

    @property
    def MerchantNo(self):
        """系统商户号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MerchantNo

    @MerchantNo.setter
    def MerchantNo(self, MerchantNo):
        self._MerchantNo = MerchantNo


    def _deserialize(self, params):
        self._MerchantNo = params.get("MerchantNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddShopRequest(AbstractModel):
    """AddShop请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 收单系统分配的开放ID
        :type OpenId: str
        :param _OpenKey: 收单系统分配的密钥
        :type OpenKey: str
        :param _OutShopId: 机构门店主键（系统有唯一性校验），建议使用门店表的主键ID，防止重复添加门店
        :type OutShopId: str
        :param _ShopName: 门店简称（例如：南山店）
        :type ShopName: str
        :param _ShopFullName: 门店全称（例如：江山小厨（南山店））
        :type ShopFullName: str
        :param _MerchantNo: 商户编号
        :type MerchantNo: str
        :param _Telephone: 门店电话
        :type Telephone: str
        :param _OpenHours: 营业时间，多个以小写逗号分开(9:00-12:00,13:00-18:00)
        :type OpenHours: str
        :param _CityId: 门店所在的城市编码
        :type CityId: str
        :param _Address: 门店详细地址，不含省市区县名称
        :type Address: str
        :param _PictureOne: 整体门面（含招牌）图片【公共区】
        :type PictureOne: str
        :param _PictureTwo: 整体门面（含招牌）图片【公共区】
        :type PictureTwo: str
        :param _PictureThree: 店内环境图片【公共区】
        :type PictureThree: str
        :param _FinancialTelephone: 负责人手机号码
        :type FinancialTelephone: str
        :param _Contact: 门店负责人
        :type Contact: str
        :param _Latitude: 百度地图纬度
        :type Latitude: str
        :param _LatitudeTwo: 高德地图纬度
        :type LatitudeTwo: str
        :param _Longitude: 百度地图经度
        :type Longitude: str
        :param _LongitudeTwo: 高德地图经度
        :type LongitudeTwo: str
        :param _OtherPicture: 其他照片【公共区】
        :type OtherPicture: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._OutShopId = None
        self._ShopName = None
        self._ShopFullName = None
        self._MerchantNo = None
        self._Telephone = None
        self._OpenHours = None
        self._CityId = None
        self._Address = None
        self._PictureOne = None
        self._PictureTwo = None
        self._PictureThree = None
        self._FinancialTelephone = None
        self._Contact = None
        self._Latitude = None
        self._LatitudeTwo = None
        self._Longitude = None
        self._LongitudeTwo = None
        self._OtherPicture = None
        self._Profile = None

    @property
    def OpenId(self):
        """收单系统分配的开放ID
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """收单系统分配的密钥
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def OutShopId(self):
        """机构门店主键（系统有唯一性校验），建议使用门店表的主键ID，防止重复添加门店
        :rtype: str
        """
        return self._OutShopId

    @OutShopId.setter
    def OutShopId(self, OutShopId):
        self._OutShopId = OutShopId

    @property
    def ShopName(self):
        """门店简称（例如：南山店）
        :rtype: str
        """
        return self._ShopName

    @ShopName.setter
    def ShopName(self, ShopName):
        self._ShopName = ShopName

    @property
    def ShopFullName(self):
        """门店全称（例如：江山小厨（南山店））
        :rtype: str
        """
        return self._ShopFullName

    @ShopFullName.setter
    def ShopFullName(self, ShopFullName):
        self._ShopFullName = ShopFullName

    @property
    def MerchantNo(self):
        """商户编号
        :rtype: str
        """
        return self._MerchantNo

    @MerchantNo.setter
    def MerchantNo(self, MerchantNo):
        self._MerchantNo = MerchantNo

    @property
    def Telephone(self):
        """门店电话
        :rtype: str
        """
        return self._Telephone

    @Telephone.setter
    def Telephone(self, Telephone):
        self._Telephone = Telephone

    @property
    def OpenHours(self):
        """营业时间，多个以小写逗号分开(9:00-12:00,13:00-18:00)
        :rtype: str
        """
        return self._OpenHours

    @OpenHours.setter
    def OpenHours(self, OpenHours):
        self._OpenHours = OpenHours

    @property
    def CityId(self):
        """门店所在的城市编码
        :rtype: str
        """
        return self._CityId

    @CityId.setter
    def CityId(self, CityId):
        self._CityId = CityId

    @property
    def Address(self):
        """门店详细地址，不含省市区县名称
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def PictureOne(self):
        """整体门面（含招牌）图片【公共区】
        :rtype: str
        """
        return self._PictureOne

    @PictureOne.setter
    def PictureOne(self, PictureOne):
        self._PictureOne = PictureOne

    @property
    def PictureTwo(self):
        """整体门面（含招牌）图片【公共区】
        :rtype: str
        """
        return self._PictureTwo

    @PictureTwo.setter
    def PictureTwo(self, PictureTwo):
        self._PictureTwo = PictureTwo

    @property
    def PictureThree(self):
        """店内环境图片【公共区】
        :rtype: str
        """
        return self._PictureThree

    @PictureThree.setter
    def PictureThree(self, PictureThree):
        self._PictureThree = PictureThree

    @property
    def FinancialTelephone(self):
        """负责人手机号码
        :rtype: str
        """
        return self._FinancialTelephone

    @FinancialTelephone.setter
    def FinancialTelephone(self, FinancialTelephone):
        self._FinancialTelephone = FinancialTelephone

    @property
    def Contact(self):
        """门店负责人
        :rtype: str
        """
        return self._Contact

    @Contact.setter
    def Contact(self, Contact):
        self._Contact = Contact

    @property
    def Latitude(self):
        """百度地图纬度
        :rtype: str
        """
        return self._Latitude

    @Latitude.setter
    def Latitude(self, Latitude):
        self._Latitude = Latitude

    @property
    def LatitudeTwo(self):
        """高德地图纬度
        :rtype: str
        """
        return self._LatitudeTwo

    @LatitudeTwo.setter
    def LatitudeTwo(self, LatitudeTwo):
        self._LatitudeTwo = LatitudeTwo

    @property
    def Longitude(self):
        """百度地图经度
        :rtype: str
        """
        return self._Longitude

    @Longitude.setter
    def Longitude(self, Longitude):
        self._Longitude = Longitude

    @property
    def LongitudeTwo(self):
        """高德地图经度
        :rtype: str
        """
        return self._LongitudeTwo

    @LongitudeTwo.setter
    def LongitudeTwo(self, LongitudeTwo):
        self._LongitudeTwo = LongitudeTwo

    @property
    def OtherPicture(self):
        """其他照片【公共区】
        :rtype: str
        """
        return self._OtherPicture

    @OtherPicture.setter
    def OtherPicture(self, OtherPicture):
        self._OtherPicture = OtherPicture

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._OutShopId = params.get("OutShopId")
        self._ShopName = params.get("ShopName")
        self._ShopFullName = params.get("ShopFullName")
        self._MerchantNo = params.get("MerchantNo")
        self._Telephone = params.get("Telephone")
        self._OpenHours = params.get("OpenHours")
        self._CityId = params.get("CityId")
        self._Address = params.get("Address")
        self._PictureOne = params.get("PictureOne")
        self._PictureTwo = params.get("PictureTwo")
        self._PictureThree = params.get("PictureThree")
        self._FinancialTelephone = params.get("FinancialTelephone")
        self._Contact = params.get("Contact")
        self._Latitude = params.get("Latitude")
        self._LatitudeTwo = params.get("LatitudeTwo")
        self._Longitude = params.get("Longitude")
        self._LongitudeTwo = params.get("LongitudeTwo")
        self._OtherPicture = params.get("OtherPicture")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddShopResponse(AbstractModel):
    """AddShop返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 添加申请响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.AddShopResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """添加申请响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.AddShopResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = AddShopResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class AddShopResult(AbstractModel):
    """添加门店响应对象

    """

    def __init__(self):
        r"""
        :param _ShopNo: 门店编号
注意：此字段可能返回 null，表示取不到有效值。
        :type ShopNo: str
        """
        self._ShopNo = None

    @property
    def ShopNo(self):
        """门店编号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ShopNo

    @ShopNo.setter
    def ShopNo(self, ShopNo):
        self._ShopNo = ShopNo


    def _deserialize(self, params):
        self._ShopNo = params.get("ShopNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AgencyClientInfo(AbstractModel):
    """经办人信息

    """

    def __init__(self):
        r"""
        :param _AgencyClientName: 经办人姓名，存在经办人必输
        :type AgencyClientName: str
        :param _AgencyClientGlobalType: 经办人证件类型，存在经办人必输
        :type AgencyClientGlobalType: str
        :param _AgencyClientGlobalId: 经办人证件号，存在经办人必输
        :type AgencyClientGlobalId: str
        :param _AgencyClientMobile: 经办人手机号，存在经办人必输
        :type AgencyClientMobile: str
        """
        self._AgencyClientName = None
        self._AgencyClientGlobalType = None
        self._AgencyClientGlobalId = None
        self._AgencyClientMobile = None

    @property
    def AgencyClientName(self):
        """经办人姓名，存在经办人必输
        :rtype: str
        """
        return self._AgencyClientName

    @AgencyClientName.setter
    def AgencyClientName(self, AgencyClientName):
        self._AgencyClientName = AgencyClientName

    @property
    def AgencyClientGlobalType(self):
        """经办人证件类型，存在经办人必输
        :rtype: str
        """
        return self._AgencyClientGlobalType

    @AgencyClientGlobalType.setter
    def AgencyClientGlobalType(self, AgencyClientGlobalType):
        self._AgencyClientGlobalType = AgencyClientGlobalType

    @property
    def AgencyClientGlobalId(self):
        """经办人证件号，存在经办人必输
        :rtype: str
        """
        return self._AgencyClientGlobalId

    @AgencyClientGlobalId.setter
    def AgencyClientGlobalId(self, AgencyClientGlobalId):
        self._AgencyClientGlobalId = AgencyClientGlobalId

    @property
    def AgencyClientMobile(self):
        """经办人手机号，存在经办人必输
        :rtype: str
        """
        return self._AgencyClientMobile

    @AgencyClientMobile.setter
    def AgencyClientMobile(self, AgencyClientMobile):
        self._AgencyClientMobile = AgencyClientMobile


    def _deserialize(self, params):
        self._AgencyClientName = params.get("AgencyClientName")
        self._AgencyClientGlobalType = params.get("AgencyClientGlobalType")
        self._AgencyClientGlobalId = params.get("AgencyClientGlobalId")
        self._AgencyClientMobile = params.get("AgencyClientMobile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AgentTaxPayment(AbstractModel):
    """代理商完税证明

    """

    def __init__(self):
        r"""
        :param _AnchorId: 主播银行账号
        :type AnchorId: str
        :param _AnchorName: 主播姓名
        :type AnchorName: str
        :param _AnchorIDCard: 主播身份证
        :type AnchorIDCard: str
        :param _StartTime: 纳税的开始时间，格式yyyy-MM-dd
        :type StartTime: str
        :param _EndTime: 纳税的结束时间，格式yyyy-MM-dd
        :type EndTime: str
        :param _Amount: 流水金额。以“分”为单位
        :type Amount: int
        :param _Tax: 应缴税款。以“分”为单位
        :type Tax: int
        """
        self._AnchorId = None
        self._AnchorName = None
        self._AnchorIDCard = None
        self._StartTime = None
        self._EndTime = None
        self._Amount = None
        self._Tax = None

    @property
    def AnchorId(self):
        """主播银行账号
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def AnchorName(self):
        """主播姓名
        :rtype: str
        """
        return self._AnchorName

    @AnchorName.setter
    def AnchorName(self, AnchorName):
        self._AnchorName = AnchorName

    @property
    def AnchorIDCard(self):
        """主播身份证
        :rtype: str
        """
        return self._AnchorIDCard

    @AnchorIDCard.setter
    def AnchorIDCard(self, AnchorIDCard):
        self._AnchorIDCard = AnchorIDCard

    @property
    def StartTime(self):
        """纳税的开始时间，格式yyyy-MM-dd
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """纳税的结束时间，格式yyyy-MM-dd
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Amount(self):
        """流水金额。以“分”为单位
        :rtype: int
        """
        return self._Amount

    @Amount.setter
    def Amount(self, Amount):
        self._Amount = Amount

    @property
    def Tax(self):
        """应缴税款。以“分”为单位
        :rtype: int
        """
        return self._Tax

    @Tax.setter
    def Tax(self, Tax):
        self._Tax = Tax


    def _deserialize(self, params):
        self._AnchorId = params.get("AnchorId")
        self._AnchorName = params.get("AnchorName")
        self._AnchorIDCard = params.get("AnchorIDCard")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Amount = params.get("Amount")
        self._Tax = params.get("Tax")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AgentTaxPaymentBatch(AbstractModel):
    """代理商完税证明批次信息

    """

    def __init__(self):
        r"""
        :param _StatusMsg: 状态消息
        :type StatusMsg: str
        :param _BatchNum: 批次号
        :type BatchNum: int
        :param _InfoNum: 录入记录的条数
        :type InfoNum: int
        :param _RawElectronicCertUrl: 源电子凭证下载地址
        :type RawElectronicCertUrl: str
        :param _AgentId: 代理商账号
        :type AgentId: str
        :param _FileName: 文件名
        :type FileName: str
        :param _StatusCode: 状态码。0表示下载成功
        :type StatusCode: int
        :param _Channel: 渠道号
        :type Channel: int
        :param _Type: 0-视同，1-个体工商户
        :type Type: int
        """
        self._StatusMsg = None
        self._BatchNum = None
        self._InfoNum = None
        self._RawElectronicCertUrl = None
        self._AgentId = None
        self._FileName = None
        self._StatusCode = None
        self._Channel = None
        self._Type = None

    @property
    def StatusMsg(self):
        """状态消息
        :rtype: str
        """
        return self._StatusMsg

    @StatusMsg.setter
    def StatusMsg(self, StatusMsg):
        self._StatusMsg = StatusMsg

    @property
    def BatchNum(self):
        """批次号
        :rtype: int
        """
        return self._BatchNum

    @BatchNum.setter
    def BatchNum(self, BatchNum):
        self._BatchNum = BatchNum

    @property
    def InfoNum(self):
        """录入记录的条数
        :rtype: int
        """
        return self._InfoNum

    @InfoNum.setter
    def InfoNum(self, InfoNum):
        self._InfoNum = InfoNum

    @property
    def RawElectronicCertUrl(self):
        """源电子凭证下载地址
        :rtype: str
        """
        return self._RawElectronicCertUrl

    @RawElectronicCertUrl.setter
    def RawElectronicCertUrl(self, RawElectronicCertUrl):
        self._RawElectronicCertUrl = RawElectronicCertUrl

    @property
    def AgentId(self):
        """代理商账号
        :rtype: str
        """
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def FileName(self):
        """文件名
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def StatusCode(self):
        """状态码。0表示下载成功
        :rtype: int
        """
        return self._StatusCode

    @StatusCode.setter
    def StatusCode(self, StatusCode):
        self._StatusCode = StatusCode

    @property
    def Channel(self):
        """渠道号
        :rtype: int
        """
        return self._Channel

    @Channel.setter
    def Channel(self, Channel):
        self._Channel = Channel

    @property
    def Type(self):
        """0-视同，1-个体工商户
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._StatusMsg = params.get("StatusMsg")
        self._BatchNum = params.get("BatchNum")
        self._InfoNum = params.get("InfoNum")
        self._RawElectronicCertUrl = params.get("RawElectronicCertUrl")
        self._AgentId = params.get("AgentId")
        self._FileName = params.get("FileName")
        self._StatusCode = params.get("StatusCode")
        self._Channel = params.get("Channel")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AmountBeforeTaxResult(AbstractModel):
    """税前金额结果

    """

    def __init__(self):
        r"""
        :param _AmountBeforeTax: 税前金额
注意：此字段可能返回 null，表示取不到有效值。
        :type AmountBeforeTax: str
        :param _AmountBeforeTaxWithTwoDigitPrecision: 两位精度税前金额
注意：此字段可能返回 null，表示取不到有效值。
        :type AmountBeforeTaxWithTwoDigitPrecision: str
        """
        self._AmountBeforeTax = None
        self._AmountBeforeTaxWithTwoDigitPrecision = None

    @property
    def AmountBeforeTax(self):
        """税前金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AmountBeforeTax

    @AmountBeforeTax.setter
    def AmountBeforeTax(self, AmountBeforeTax):
        self._AmountBeforeTax = AmountBeforeTax

    @property
    def AmountBeforeTaxWithTwoDigitPrecision(self):
        """两位精度税前金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AmountBeforeTaxWithTwoDigitPrecision

    @AmountBeforeTaxWithTwoDigitPrecision.setter
    def AmountBeforeTaxWithTwoDigitPrecision(self, AmountBeforeTaxWithTwoDigitPrecision):
        self._AmountBeforeTaxWithTwoDigitPrecision = AmountBeforeTaxWithTwoDigitPrecision


    def _deserialize(self, params):
        self._AmountBeforeTax = params.get("AmountBeforeTax")
        self._AmountBeforeTaxWithTwoDigitPrecision = params.get("AmountBeforeTaxWithTwoDigitPrecision")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnchorContractInfo(AbstractModel):
    """主播签约信息

    """

    def __init__(self):
        r"""
        :param _AnchorId: 主播ID
        :type AnchorId: str
        :param _AnchorName: 主播名称
        :type AnchorName: str
        :param _AgentId: 代理商ID
        :type AgentId: str
        :param _AgentName: 代理商名称
        :type AgentName: str
        :param _IdNo: 主播身份证号
        :type IdNo: str
        """
        self._AnchorId = None
        self._AnchorName = None
        self._AgentId = None
        self._AgentName = None
        self._IdNo = None

    @property
    def AnchorId(self):
        """主播ID
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def AnchorName(self):
        """主播名称
        :rtype: str
        """
        return self._AnchorName

    @AnchorName.setter
    def AnchorName(self, AnchorName):
        self._AnchorName = AnchorName

    @property
    def AgentId(self):
        """代理商ID
        :rtype: str
        """
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def AgentName(self):
        """代理商名称
        :rtype: str
        """
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName

    @property
    def IdNo(self):
        """主播身份证号
        :rtype: str
        """
        return self._IdNo

    @IdNo.setter
    def IdNo(self, IdNo):
        self._IdNo = IdNo


    def _deserialize(self, params):
        self._AnchorId = params.get("AnchorId")
        self._AnchorName = params.get("AnchorName")
        self._AgentId = params.get("AgentId")
        self._AgentName = params.get("AgentName")
        self._IdNo = params.get("IdNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnchorExtendInfo(AbstractModel):
    """主播扩展信息

    """

    def __init__(self):
        r"""
        :param _Type: 扩展信息类型
__id_card_no__:身份证号码
__id_card_name__:身份证姓名
__id_card_front__:身份证图片正面
__id_card_back__:身份证图片反面
__tax_type__:完税类型:0-自然人,1-个体工商户
__channel_account__:渠道账号(_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密)
        :type Type: str
        :param _Value: 扩展信息
        :type Value: str
        """
        self._Type = None
        self._Value = None

    @property
    def Type(self):
        """扩展信息类型
__id_card_no__:身份证号码
__id_card_name__:身份证姓名
__id_card_front__:身份证图片正面
__id_card_back__:身份证图片反面
__tax_type__:完税类型:0-自然人,1-个体工商户
__channel_account__:渠道账号(_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密)
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Value(self):
        """扩展信息
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyApplicationMaterialRequest(AbstractModel):
    """ApplyApplicationMaterial请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TransactionId: 对接方汇出指令编号
        :type TransactionId: str
        :param _DeclareId: 申报流水号
        :type DeclareId: str
        :param _PayerId: 付款人ID
        :type PayerId: str
        :param _SourceCurrency: 源币种
        :type SourceCurrency: str
        :param _TargetCurrency: 目的币种
        :type TargetCurrency: str
        :param _TradeCode: 贸易编码
        :type TradeCode: str
        :param _OriginalDeclareId: 原申报流水号
        :type OriginalDeclareId: str
        :param _SourceAmount: 源金额
        :type SourceAmount: int
        :param _TargetAmount: 目的金额
        :type TargetAmount: int
        :param _Profile: 接入环境。沙箱环境填sandbox
        :type Profile: str
        """
        self._TransactionId = None
        self._DeclareId = None
        self._PayerId = None
        self._SourceCurrency = None
        self._TargetCurrency = None
        self._TradeCode = None
        self._OriginalDeclareId = None
        self._SourceAmount = None
        self._TargetAmount = None
        self._Profile = None

    @property
    def TransactionId(self):
        """对接方汇出指令编号
        :rtype: str
        """
        return self._TransactionId

    @TransactionId.setter
    def TransactionId(self, TransactionId):
        self._TransactionId = TransactionId

    @property
    def DeclareId(self):
        """申报流水号
        :rtype: str
        """
        return self._DeclareId

    @DeclareId.setter
    def DeclareId(self, DeclareId):
        self._DeclareId = DeclareId

    @property
    def PayerId(self):
        """付款人ID
        :rtype: str
        """
        return self._PayerId

    @PayerId.setter
    def PayerId(self, PayerId):
        self._PayerId = PayerId

    @property
    def SourceCurrency(self):
        """源币种
        :rtype: str
        """
        return self._SourceCurrency

    @SourceCurrency.setter
    def SourceCurrency(self, SourceCurrency):
        self._SourceCurrency = SourceCurrency

    @property
    def TargetCurrency(self):
        """目的币种
        :rtype: str
        """
        return self._TargetCurrency

    @TargetCurrency.setter
    def TargetCurrency(self, TargetCurrency):
        self._TargetCurrency = TargetCurrency

    @property
    def TradeCode(self):
        """贸易编码
        :rtype: str
        """
        return self._TradeCode

    @TradeCode.setter
    def TradeCode(self, TradeCode):
        self._TradeCode = TradeCode

    @property
    def OriginalDeclareId(self):
        """原申报流水号
        :rtype: str
        """
        return self._OriginalDeclareId

    @OriginalDeclareId.setter
    def OriginalDeclareId(self, OriginalDeclareId):
        self._OriginalDeclareId = OriginalDeclareId

    @property
    def SourceAmount(self):
        """源金额
        :rtype: int
        """
        return self._SourceAmount

    @SourceAmount.setter
    def SourceAmount(self, SourceAmount):
        self._SourceAmount = SourceAmount

    @property
    def TargetAmount(self):
        """目的金额
        :rtype: int
        """
        return self._TargetAmount

    @TargetAmount.setter
    def TargetAmount(self, TargetAmount):
        self._TargetAmount = TargetAmount

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._TransactionId = params.get("TransactionId")
        self._DeclareId = params.get("DeclareId")
        self._PayerId = params.get("PayerId")
        self._SourceCurrency = params.get("SourceCurrency")
        self._TargetCurrency = params.get("TargetCurrency")
        self._TradeCode = params.get("TradeCode")
        self._OriginalDeclareId = params.get("OriginalDeclareId")
        self._SourceAmount = params.get("SourceAmount")
        self._TargetAmount = params.get("TargetAmount")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyApplicationMaterialResponse(AbstractModel):
    """ApplyApplicationMaterial返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 提交申报材料结果
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyDeclareResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """提交申报材料结果
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyDeclareResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApplyDeclareResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyDeclareData(AbstractModel):
    """提交申报材料结果

    """

    def __init__(self):
        r"""
        :param _MerchantId: 商户号
        :type MerchantId: str
        :param _TransactionId: 第三方指令编号
        :type TransactionId: str
        :param _Status: 受理状态
        :type Status: str
        :param _DeclareId: 申报流水号
        :type DeclareId: str
        :param _OriginalDeclareId: 原申报流水号
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginalDeclareId: str
        :param _PayerId: 付款人ID
        :type PayerId: str
        """
        self._MerchantId = None
        self._TransactionId = None
        self._Status = None
        self._DeclareId = None
        self._OriginalDeclareId = None
        self._PayerId = None

    @property
    def MerchantId(self):
        """商户号
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def TransactionId(self):
        """第三方指令编号
        :rtype: str
        """
        return self._TransactionId

    @TransactionId.setter
    def TransactionId(self, TransactionId):
        self._TransactionId = TransactionId

    @property
    def Status(self):
        """受理状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def DeclareId(self):
        """申报流水号
        :rtype: str
        """
        return self._DeclareId

    @DeclareId.setter
    def DeclareId(self, DeclareId):
        self._DeclareId = DeclareId

    @property
    def OriginalDeclareId(self):
        """原申报流水号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OriginalDeclareId

    @OriginalDeclareId.setter
    def OriginalDeclareId(self, OriginalDeclareId):
        self._OriginalDeclareId = OriginalDeclareId

    @property
    def PayerId(self):
        """付款人ID
        :rtype: str
        """
        return self._PayerId

    @PayerId.setter
    def PayerId(self, PayerId):
        self._PayerId = PayerId


    def _deserialize(self, params):
        self._MerchantId = params.get("MerchantId")
        self._TransactionId = params.get("TransactionId")
        self._Status = params.get("Status")
        self._DeclareId = params.get("DeclareId")
        self._OriginalDeclareId = params.get("OriginalDeclareId")
        self._PayerId = params.get("PayerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyDeclareResult(AbstractModel):
    """提交申报材料结果

    """

    def __init__(self):
        r"""
        :param _Code: 错误码
        :type Code: str
        :param _Data: 提交申报材料数据
        :type Data: :class:`tencentcloud.cpdp.v20190820.models.ApplyDeclareData`
        """
        self._Code = None
        self._Data = None

    @property
    def Code(self):
        """错误码
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Data(self):
        """提交申报材料数据
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyDeclareData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Code = params.get("Code")
        if params.get("Data") is not None:
            self._Data = ApplyDeclareData()
            self._Data._deserialize(params.get("Data"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyFlexPaymentRequest(AbstractModel):
    """ApplyFlexPayment请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _IncomeType: 收入类型
LABOR:劳务所得
OCCASION:偶然所得
        :type IncomeType: str
        :param _AmountBeforeTax: 税前金额
        :type AmountBeforeTax: str
        :param _OutOrderId: 外部订单ID
        :type OutOrderId: str
        :param _FundingAccountInfo: 资金账户信息
        :type FundingAccountInfo: :class:`tencentcloud.cpdp.v20190820.models.FlexFundingAccountInfo`
        :param _Remark: 提现备注
        :type Remark: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        :param _NotifyUrl: 支付结果通知回调地址
        :type NotifyUrl: str
        """
        self._PayeeId = None
        self._IncomeType = None
        self._AmountBeforeTax = None
        self._OutOrderId = None
        self._FundingAccountInfo = None
        self._Remark = None
        self._Environment = None
        self._NotifyUrl = None

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def IncomeType(self):
        """收入类型
LABOR:劳务所得
OCCASION:偶然所得
        :rtype: str
        """
        return self._IncomeType

    @IncomeType.setter
    def IncomeType(self, IncomeType):
        self._IncomeType = IncomeType

    @property
    def AmountBeforeTax(self):
        """税前金额
        :rtype: str
        """
        return self._AmountBeforeTax

    @AmountBeforeTax.setter
    def AmountBeforeTax(self, AmountBeforeTax):
        self._AmountBeforeTax = AmountBeforeTax

    @property
    def OutOrderId(self):
        """外部订单ID
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def FundingAccountInfo(self):
        """资金账户信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.FlexFundingAccountInfo`
        """
        return self._FundingAccountInfo

    @FundingAccountInfo.setter
    def FundingAccountInfo(self, FundingAccountInfo):
        self._FundingAccountInfo = FundingAccountInfo

    @property
    def Remark(self):
        """提现备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment

    @property
    def NotifyUrl(self):
        """支付结果通知回调地址
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl


    def _deserialize(self, params):
        self._PayeeId = params.get("PayeeId")
        self._IncomeType = params.get("IncomeType")
        self._AmountBeforeTax = params.get("AmountBeforeTax")
        self._OutOrderId = params.get("OutOrderId")
        if params.get("FundingAccountInfo") is not None:
            self._FundingAccountInfo = FlexFundingAccountInfo()
            self._FundingAccountInfo._deserialize(params.get("FundingAccountInfo"))
        self._Remark = params.get("Remark")
        self._Environment = params.get("Environment")
        self._NotifyUrl = params.get("NotifyUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyFlexPaymentResponse(AbstractModel):
    """ApplyFlexPayment返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyFlexPaymentResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyFlexPaymentResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = ApplyFlexPaymentResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyFlexPaymentResult(AbstractModel):
    """付款结果

    """

    def __init__(self):
        r"""
        :param _OrderId: 订单ID
        :type OrderId: str
        :param _AmountBeforeTax: 税前金额
        :type AmountBeforeTax: str
        :param _AmountAfterTax: 税后金额
        :type AmountAfterTax: str
        :param _Tax: 税金
        :type Tax: str
        :param _Vat: 增值税
注意：此字段可能返回 null，表示取不到有效值。
        :type Vat: str
        :param _IndividualIncomeTax: 个人所得税
注意：此字段可能返回 null，表示取不到有效值。
        :type IndividualIncomeTax: str
        :param _AdditionalTaxSum: 附加税总税额
注意：此字段可能返回 null，表示取不到有效值。
        :type AdditionalTaxSum: str
        :param _AdditionalTaxItem: 附加税税项。格式为JSON格式
注意：此字段可能返回 null，表示取不到有效值。
        :type AdditionalTaxItem: str
        """
        self._OrderId = None
        self._AmountBeforeTax = None
        self._AmountAfterTax = None
        self._Tax = None
        self._Vat = None
        self._IndividualIncomeTax = None
        self._AdditionalTaxSum = None
        self._AdditionalTaxItem = None

    @property
    def OrderId(self):
        """订单ID
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def AmountBeforeTax(self):
        """税前金额
        :rtype: str
        """
        return self._AmountBeforeTax

    @AmountBeforeTax.setter
    def AmountBeforeTax(self, AmountBeforeTax):
        self._AmountBeforeTax = AmountBeforeTax

    @property
    def AmountAfterTax(self):
        """税后金额
        :rtype: str
        """
        return self._AmountAfterTax

    @AmountAfterTax.setter
    def AmountAfterTax(self, AmountAfterTax):
        self._AmountAfterTax = AmountAfterTax

    @property
    def Tax(self):
        """税金
        :rtype: str
        """
        return self._Tax

    @Tax.setter
    def Tax(self, Tax):
        self._Tax = Tax

    @property
    def Vat(self):
        """增值税
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Vat

    @Vat.setter
    def Vat(self, Vat):
        self._Vat = Vat

    @property
    def IndividualIncomeTax(self):
        """个人所得税
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IndividualIncomeTax

    @IndividualIncomeTax.setter
    def IndividualIncomeTax(self, IndividualIncomeTax):
        self._IndividualIncomeTax = IndividualIncomeTax

    @property
    def AdditionalTaxSum(self):
        """附加税总税额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AdditionalTaxSum

    @AdditionalTaxSum.setter
    def AdditionalTaxSum(self, AdditionalTaxSum):
        self._AdditionalTaxSum = AdditionalTaxSum

    @property
    def AdditionalTaxItem(self):
        """附加税税项。格式为JSON格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AdditionalTaxItem

    @AdditionalTaxItem.setter
    def AdditionalTaxItem(self, AdditionalTaxItem):
        self._AdditionalTaxItem = AdditionalTaxItem


    def _deserialize(self, params):
        self._OrderId = params.get("OrderId")
        self._AmountBeforeTax = params.get("AmountBeforeTax")
        self._AmountAfterTax = params.get("AmountAfterTax")
        self._Tax = params.get("Tax")
        self._Vat = params.get("Vat")
        self._IndividualIncomeTax = params.get("IndividualIncomeTax")
        self._AdditionalTaxSum = params.get("AdditionalTaxSum")
        self._AdditionalTaxItem = params.get("AdditionalTaxItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyFlexSettlementRequest(AbstractModel):
    """ApplyFlexSettlement请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _IncomeType: 收入类型
LABOR:劳务所得
OCCASION:偶然所得
        :type IncomeType: str
        :param _AmountBeforeTax: 税前金额
        :type AmountBeforeTax: str
        :param _OutOrderId: 外部订单ID
        :type OutOrderId: str
        :param _Remark: 备注
        :type Remark: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        """
        self._PayeeId = None
        self._IncomeType = None
        self._AmountBeforeTax = None
        self._OutOrderId = None
        self._Remark = None
        self._Environment = None

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def IncomeType(self):
        """收入类型
LABOR:劳务所得
OCCASION:偶然所得
        :rtype: str
        """
        return self._IncomeType

    @IncomeType.setter
    def IncomeType(self, IncomeType):
        self._IncomeType = IncomeType

    @property
    def AmountBeforeTax(self):
        """税前金额
        :rtype: str
        """
        return self._AmountBeforeTax

    @AmountBeforeTax.setter
    def AmountBeforeTax(self, AmountBeforeTax):
        self._AmountBeforeTax = AmountBeforeTax

    @property
    def OutOrderId(self):
        """外部订单ID
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def Remark(self):
        """备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._PayeeId = params.get("PayeeId")
        self._IncomeType = params.get("IncomeType")
        self._AmountBeforeTax = params.get("AmountBeforeTax")
        self._OutOrderId = params.get("OutOrderId")
        self._Remark = params.get("Remark")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyFlexSettlementResponse(AbstractModel):
    """ApplyFlexSettlement返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyFlexSettlementResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyFlexSettlementResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = ApplyFlexSettlementResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyFlexSettlementResult(AbstractModel):
    """结算结果

    """

    def __init__(self):
        r"""
        :param _OrderId: 订单ID
        :type OrderId: str
        :param _AmountBeforeTax: 税前金额
        :type AmountBeforeTax: str
        :param _AmountAfterTax: 税后金额
        :type AmountAfterTax: str
        :param _Tax: 税金
        :type Tax: str
        """
        self._OrderId = None
        self._AmountBeforeTax = None
        self._AmountAfterTax = None
        self._Tax = None

    @property
    def OrderId(self):
        """订单ID
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def AmountBeforeTax(self):
        """税前金额
        :rtype: str
        """
        return self._AmountBeforeTax

    @AmountBeforeTax.setter
    def AmountBeforeTax(self, AmountBeforeTax):
        self._AmountBeforeTax = AmountBeforeTax

    @property
    def AmountAfterTax(self):
        """税后金额
        :rtype: str
        """
        return self._AmountAfterTax

    @AmountAfterTax.setter
    def AmountAfterTax(self, AmountAfterTax):
        self._AmountAfterTax = AmountAfterTax

    @property
    def Tax(self):
        """税金
        :rtype: str
        """
        return self._Tax

    @Tax.setter
    def Tax(self, Tax):
        self._Tax = Tax


    def _deserialize(self, params):
        self._OrderId = params.get("OrderId")
        self._AmountBeforeTax = params.get("AmountBeforeTax")
        self._AmountAfterTax = params.get("AmountAfterTax")
        self._Tax = params.get("Tax")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyFlexWechatPreAuthRequest(AbstractModel):
    """ApplyFlexWechatPreAuth请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AuthNo: 商家核身单号
        :type AuthNo: str
        :param _OpenId: 微信用户标识
        :type OpenId: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _EmployerName: 用工单位名称
        :type EmployerName: str
        :param _UserName: 用户姓名
        :type UserName: str
        :param _IdNo: 用户证件号
        :type IdNo: str
        :param _EmploymentType: 用工类型
LONG_TERM_EMPLOYMENT：长期用工，
SHORT_TERM_EMPLOYMENT： 短期用工，
COOPERATION_EMPLOYMENT：合作关系
        :type EmploymentType: str
        :param _AuthType: 核身类型
SIGN_IN：考勤、签到打卡类型
INSURANCE：投保类型
CONTRACT：签约类型
        :type AuthType: str
        :param _Environment: 环境类型
test 测试
release 生产
sandbox 沙箱
        :type Environment: str
        """
        self._AuthNo = None
        self._OpenId = None
        self._ProjectName = None
        self._EmployerName = None
        self._UserName = None
        self._IdNo = None
        self._EmploymentType = None
        self._AuthType = None
        self._Environment = None

    @property
    def AuthNo(self):
        """商家核身单号
        :rtype: str
        """
        return self._AuthNo

    @AuthNo.setter
    def AuthNo(self, AuthNo):
        self._AuthNo = AuthNo

    @property
    def OpenId(self):
        """微信用户标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def ProjectName(self):
        """项目名称
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def EmployerName(self):
        """用工单位名称
        :rtype: str
        """
        return self._EmployerName

    @EmployerName.setter
    def EmployerName(self, EmployerName):
        self._EmployerName = EmployerName

    @property
    def UserName(self):
        """用户姓名
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def IdNo(self):
        """用户证件号
        :rtype: str
        """
        return self._IdNo

    @IdNo.setter
    def IdNo(self, IdNo):
        self._IdNo = IdNo

    @property
    def EmploymentType(self):
        """用工类型
LONG_TERM_EMPLOYMENT：长期用工，
SHORT_TERM_EMPLOYMENT： 短期用工，
COOPERATION_EMPLOYMENT：合作关系
        :rtype: str
        """
        return self._EmploymentType

    @EmploymentType.setter
    def EmploymentType(self, EmploymentType):
        self._EmploymentType = EmploymentType

    @property
    def AuthType(self):
        """核身类型
SIGN_IN：考勤、签到打卡类型
INSURANCE：投保类型
CONTRACT：签约类型
        :rtype: str
        """
        return self._AuthType

    @AuthType.setter
    def AuthType(self, AuthType):
        self._AuthType = AuthType

    @property
    def Environment(self):
        """环境类型
test 测试
release 生产
sandbox 沙箱
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._AuthNo = params.get("AuthNo")
        self._OpenId = params.get("OpenId")
        self._ProjectName = params.get("ProjectName")
        self._EmployerName = params.get("EmployerName")
        self._UserName = params.get("UserName")
        self._IdNo = params.get("IdNo")
        self._EmploymentType = params.get("EmploymentType")
        self._AuthType = params.get("AuthType")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyFlexWechatPreAuthResponse(AbstractModel):
    """ApplyFlexWechatPreAuth返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误信息
        :type ErrMessage: str
        :param _Result: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.WechatPreAuthResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误信息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.WechatPreAuthResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = WechatPreAuthResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyOpenBankOrderDetailReceiptRequest(AbstractModel):
    """ApplyOpenBankOrderDetailReceipt请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OutApplyId: 外部回单申请编号
        :type OutApplyId: str
        :param _ChannelMerchantId: 渠道商户ID
        :type ChannelMerchantId: str
        :param _ChannelSubMerchantId: 渠道子商户ID
        :type ChannelSubMerchantId: str
        :param _ChannelName: 渠道名称，目前只支持ALIPAY
        :type ChannelName: str
        :param _PaymentMethod: 支付方式，目前只支持SAFT_ISV
        :type PaymentMethod: str
        :param _ChannelOrderId: 云企付平台订单号
        :type ChannelOrderId: str
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._OutApplyId = None
        self._ChannelMerchantId = None
        self._ChannelSubMerchantId = None
        self._ChannelName = None
        self._PaymentMethod = None
        self._ChannelOrderId = None
        self._Environment = None

    @property
    def OutApplyId(self):
        """外部回单申请编号
        :rtype: str
        """
        return self._OutApplyId

    @OutApplyId.setter
    def OutApplyId(self, OutApplyId):
        self._OutApplyId = OutApplyId

    @property
    def ChannelMerchantId(self):
        """渠道商户ID
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户ID
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def ChannelName(self):
        """渠道名称，目前只支持ALIPAY
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PaymentMethod(self):
        """支付方式，目前只支持SAFT_ISV
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def ChannelOrderId(self):
        """云企付平台订单号
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._OutApplyId = params.get("OutApplyId")
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._PaymentMethod = params.get("PaymentMethod")
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyOpenBankOrderDetailReceiptResponse(AbstractModel):
    """ApplyOpenBankOrderDetailReceipt返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
        :type ErrCode: str
        :param _ErrMessage: 错误消息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyOpenBankOrderDetailReceiptResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyOpenBankOrderDetailReceiptResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = ApplyOpenBankOrderDetailReceiptResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyOpenBankOrderDetailReceiptResult(AbstractModel):
    """申请单笔交易回单结果

    """

    def __init__(self):
        r"""
        :param _ChannelApplyId: 渠道回单申请ID
        :type ChannelApplyId: str
        :param _ReceiptStatus: 申请状态。
SUCCESS：申请成功；
FAILED：申请失败；
PROCESSING：申请中。
注意：若返回申请中，需要再次调用回单申请结果查询接口，查询结果。
        :type ReceiptStatus: str
        :param _ReceiptMessage: 申请返回描述，例如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :type ReceiptMessage: str
        :param _DownloadUrl: 回单下载链接，申请成功时返回。
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _ExpireTime: 过期时间，yyyy-MM-dd HH:mm:ss格式。
注意：此字段可能返回 null，表示取不到有效值。
        :type ExpireTime: str
        """
        self._ChannelApplyId = None
        self._ReceiptStatus = None
        self._ReceiptMessage = None
        self._DownloadUrl = None
        self._ExpireTime = None

    @property
    def ChannelApplyId(self):
        """渠道回单申请ID
        :rtype: str
        """
        return self._ChannelApplyId

    @ChannelApplyId.setter
    def ChannelApplyId(self, ChannelApplyId):
        self._ChannelApplyId = ChannelApplyId

    @property
    def ReceiptStatus(self):
        """申请状态。
SUCCESS：申请成功；
FAILED：申请失败；
PROCESSING：申请中。
注意：若返回申请中，需要再次调用回单申请结果查询接口，查询结果。
        :rtype: str
        """
        return self._ReceiptStatus

    @ReceiptStatus.setter
    def ReceiptStatus(self, ReceiptStatus):
        self._ReceiptStatus = ReceiptStatus

    @property
    def ReceiptMessage(self):
        """申请返回描述，例如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReceiptMessage

    @ReceiptMessage.setter
    def ReceiptMessage(self, ReceiptMessage):
        self._ReceiptMessage = ReceiptMessage

    @property
    def DownloadUrl(self):
        """回单下载链接，申请成功时返回。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def ExpireTime(self):
        """过期时间，yyyy-MM-dd HH:mm:ss格式。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._ChannelApplyId = params.get("ChannelApplyId")
        self._ReceiptStatus = params.get("ReceiptStatus")
        self._ReceiptMessage = params.get("ReceiptMessage")
        self._DownloadUrl = params.get("DownloadUrl")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyOpenBankSettleOrderRequest(AbstractModel):
    """ApplyOpenBankSettleOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 渠道商户号
        :type ChannelMerchantId: str
        :param _OutSettleId: 外部结算流水号
        :type OutSettleId: str
        :param _SettleAmount: 结算金额
        :type SettleAmount: int
        :param _ChannelName: 渠道名称。详见附录-枚举类型-ChannelName。
        :type ChannelName: str
        :param _ChannelSubMerchantId: 渠道子商户号
        :type ChannelSubMerchantId: str
        :param _SettleDetail: 结算备注
        :type SettleDetail: str
        :param _NotifyUrl: 结算成功回调地址
        :type NotifyUrl: str
        :param _Remark: 附言
        :type Remark: str
        :param _ExternalSettleData: 结算第三方渠道扩展信息。通联国际必选
        :type ExternalSettleData: str
        :param _Environment: 接入环境。沙箱环境填 sandbox。缺省默认调用生产环境
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._OutSettleId = None
        self._SettleAmount = None
        self._ChannelName = None
        self._ChannelSubMerchantId = None
        self._SettleDetail = None
        self._NotifyUrl = None
        self._Remark = None
        self._ExternalSettleData = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """渠道商户号
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def OutSettleId(self):
        """外部结算流水号
        :rtype: str
        """
        return self._OutSettleId

    @OutSettleId.setter
    def OutSettleId(self, OutSettleId):
        self._OutSettleId = OutSettleId

    @property
    def SettleAmount(self):
        """结算金额
        :rtype: int
        """
        return self._SettleAmount

    @SettleAmount.setter
    def SettleAmount(self, SettleAmount):
        self._SettleAmount = SettleAmount

    @property
    def ChannelName(self):
        """渠道名称。详见附录-枚举类型-ChannelName。
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户号
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def SettleDetail(self):
        """结算备注
        :rtype: str
        """
        return self._SettleDetail

    @SettleDetail.setter
    def SettleDetail(self, SettleDetail):
        self._SettleDetail = SettleDetail

    @property
    def NotifyUrl(self):
        """结算成功回调地址
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def Remark(self):
        """附言
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ExternalSettleData(self):
        """结算第三方渠道扩展信息。通联国际必选
        :rtype: str
        """
        return self._ExternalSettleData

    @ExternalSettleData.setter
    def ExternalSettleData(self, ExternalSettleData):
        self._ExternalSettleData = ExternalSettleData

    @property
    def Environment(self):
        """接入环境。沙箱环境填 sandbox。缺省默认调用生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._OutSettleId = params.get("OutSettleId")
        self._SettleAmount = params.get("SettleAmount")
        self._ChannelName = params.get("ChannelName")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._SettleDetail = params.get("SettleDetail")
        self._NotifyUrl = params.get("NotifyUrl")
        self._Remark = params.get("Remark")
        self._ExternalSettleData = params.get("ExternalSettleData")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyOpenBankSettleOrderResponse(AbstractModel):
    """ApplyOpenBankSettleOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
        :type ErrCode: str
        :param _ErrMessage: 错误信息。
        :type ErrMessage: str
        :param _Result: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyOpenBankSettleOrderResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误信息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyOpenBankSettleOrderResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = ApplyOpenBankSettleOrderResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyOpenBankSettleOrderResult(AbstractModel):
    """云企付结算申请结果

    """

    def __init__(self):
        r"""
        :param _OutSettleId: 外部结算流水号
        :type OutSettleId: str
        :param _ChannelSettleId: 渠道结算流水号
        :type ChannelSettleId: str
        :param _SettleStatus: 退款状态。
SUCCESS：结算成功；
FAILED：结算失败；
PROCESSING：结算中;
INIT:初始化;
ACCEPT_FAILED:受理失败,底层银行返回订单不存在
ACCEPTED：受理成功
_UNKNOWN：默认未知
        :type SettleStatus: str
        """
        self._OutSettleId = None
        self._ChannelSettleId = None
        self._SettleStatus = None

    @property
    def OutSettleId(self):
        """外部结算流水号
        :rtype: str
        """
        return self._OutSettleId

    @OutSettleId.setter
    def OutSettleId(self, OutSettleId):
        self._OutSettleId = OutSettleId

    @property
    def ChannelSettleId(self):
        """渠道结算流水号
        :rtype: str
        """
        return self._ChannelSettleId

    @ChannelSettleId.setter
    def ChannelSettleId(self, ChannelSettleId):
        self._ChannelSettleId = ChannelSettleId

    @property
    def SettleStatus(self):
        """退款状态。
SUCCESS：结算成功；
FAILED：结算失败；
PROCESSING：结算中;
INIT:初始化;
ACCEPT_FAILED:受理失败,底层银行返回订单不存在
ACCEPTED：受理成功
_UNKNOWN：默认未知
        :rtype: str
        """
        return self._SettleStatus

    @SettleStatus.setter
    def SettleStatus(self, SettleStatus):
        self._SettleStatus = SettleStatus


    def _deserialize(self, params):
        self._OutSettleId = params.get("OutSettleId")
        self._ChannelSettleId = params.get("ChannelSettleId")
        self._SettleStatus = params.get("SettleStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyOpenBankSubMerchantSignOnlineRequest(AbstractModel):
    """ApplyOpenBankSubMerchantSignOnline请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 渠道商户号。外部平台接入云企付平台下发。必填。
        :type ChannelMerchantId: str
        :param _ChannelName: 渠道名称。详见附录-枚举类型-ChannelName。
        :type ChannelName: str
        :param _OutSubMerchantId: 外部子商户ID。
        :type OutSubMerchantId: str
        :param _ChannelSubMerchantId: 渠道子商户ID。
        :type ChannelSubMerchantId: str
        :param _NotifyUrl: 签约成功回调地址。
        :type NotifyUrl: str
        """
        self._ChannelMerchantId = None
        self._ChannelName = None
        self._OutSubMerchantId = None
        self._ChannelSubMerchantId = None
        self._NotifyUrl = None

    @property
    def ChannelMerchantId(self):
        """渠道商户号。外部平台接入云企付平台下发。必填。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def ChannelName(self):
        """渠道名称。详见附录-枚举类型-ChannelName。
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def OutSubMerchantId(self):
        """外部子商户ID。
        :rtype: str
        """
        return self._OutSubMerchantId

    @OutSubMerchantId.setter
    def OutSubMerchantId(self, OutSubMerchantId):
        self._OutSubMerchantId = OutSubMerchantId

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户ID。
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def NotifyUrl(self):
        """签约成功回调地址。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._OutSubMerchantId = params.get("OutSubMerchantId")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._NotifyUrl = params.get("NotifyUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyOpenBankSubMerchantSignOnlineResponse(AbstractModel):
    """ApplyOpenBankSubMerchantSignOnline返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
        :type ErrCode: str
        :param _ErrMessage: 错误信息。
        :type ErrMessage: str
        :param _Result: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyOpenBankSubMerchantSignOnlineResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误信息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyOpenBankSubMerchantSignOnlineResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = ApplyOpenBankSubMerchantSignOnlineResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyOpenBankSubMerchantSignOnlineResult(AbstractModel):
    """子商户在线签约返回结果

    """

    def __init__(self):
        r"""
        :param _SignStatus: 处理状态
  SUCCESS：签约成功
  FAILED：签约失败
  PROCESSING：签约中
        :type SignStatus: str
        :param _SignMessage: 上传返回描述，例如失败原因等
注意：此字段可能返回 null，表示取不到有效值。
        :type SignMessage: str
        :param _ExternalReturnData: 第三方渠道返回信息，见渠道特殊说明
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnData: str
        """
        self._SignStatus = None
        self._SignMessage = None
        self._ExternalReturnData = None

    @property
    def SignStatus(self):
        """处理状态
  SUCCESS：签约成功
  FAILED：签约失败
  PROCESSING：签约中
        :rtype: str
        """
        return self._SignStatus

    @SignStatus.setter
    def SignStatus(self, SignStatus):
        self._SignStatus = SignStatus

    @property
    def SignMessage(self):
        """上传返回描述，例如失败原因等
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SignMessage

    @SignMessage.setter
    def SignMessage(self, SignMessage):
        self._SignMessage = SignMessage

    @property
    def ExternalReturnData(self):
        """第三方渠道返回信息，见渠道特殊说明
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnData

    @ExternalReturnData.setter
    def ExternalReturnData(self, ExternalReturnData):
        self._ExternalReturnData = ExternalReturnData


    def _deserialize(self, params):
        self._SignStatus = params.get("SignStatus")
        self._SignMessage = params.get("SignMessage")
        self._ExternalReturnData = params.get("ExternalReturnData")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyOutwardOrderData(AbstractModel):
    """汇出指令申请数据

    """

    def __init__(self):
        r"""
        :param _MerchantId: 商户号
        :type MerchantId: str
        :param _TransactionId: 对接方汇出指令编号
        :type TransactionId: str
        :param _Status: 受理状态
        :type Status: str
        """
        self._MerchantId = None
        self._TransactionId = None
        self._Status = None

    @property
    def MerchantId(self):
        """商户号
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def TransactionId(self):
        """对接方汇出指令编号
        :rtype: str
        """
        return self._TransactionId

    @TransactionId.setter
    def TransactionId(self, TransactionId):
        self._TransactionId = TransactionId

    @property
    def Status(self):
        """受理状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._MerchantId = params.get("MerchantId")
        self._TransactionId = params.get("TransactionId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyOutwardOrderRequest(AbstractModel):
    """ApplyOutwardOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TransactionId: 对接方汇出指令编号
        :type TransactionId: str
        :param _PricingCurrency: 定价币种
        :type PricingCurrency: str
        :param _SourceCurrency: 源币种
        :type SourceCurrency: str
        :param _TargetCurrency: 目的币种
        :type TargetCurrency: str
        :param _PayeeType: 收款人类型（银行卡填"BANK_ACCOUNT"）
        :type PayeeType: str
        :param _PayeeAccount: 收款人账号
        :type PayeeAccount: str
        :param _SourceAmount: 源币种金额
        :type SourceAmount: float
        :param _TargetAmount: 目的金额
        :type TargetAmount: float
        :param _PayeeName: 收款人姓名（PayeeType为"BANK_COUNT"时必填）
        :type PayeeName: str
        :param _PayeeAddress: 收款人地址（PayeeType为"BANK_COUNT"时必填）
        :type PayeeAddress: str
        :param _PayeeBankAccountType: 收款人银行账号类型（PayeeType为"BANK_COUNT"时必填）
个人填"INDIVIDUAL"
企业填"CORPORATE"
        :type PayeeBankAccountType: str
        :param _PayeeCountryCode: 收款人国家或地区编码（PayeeType为"BANK_COUNT"时必填）
        :type PayeeCountryCode: str
        :param _PayeeBankName: 收款人开户银行名称（PayeeType为"BANK_COUNT"时必填）
        :type PayeeBankName: str
        :param _PayeeBankAddress: 收款人开户银行地址（PayeeType为"BANK_COUNT"时必填）
        :type PayeeBankAddress: str
        :param _PayeeBankDistrict: 收款人开户银行所在国家或地区编码（PayeeType为"BANK_COUNT"时必填）
        :type PayeeBankDistrict: str
        :param _PayeeBankSwiftCode: 收款银行SwiftCode（PayeeType为"BANK_COUNT"时必填）
        :type PayeeBankSwiftCode: str
        :param _PayeeBankType: 收款银行国际编码类型
        :type PayeeBankType: str
        :param _PayeeBankCode: 收款银行国际编码
        :type PayeeBankCode: str
        :param _ReferenceForBeneficiary: 收款人附言
        :type ReferenceForBeneficiary: str
        :param _Profile: 接入环境。沙箱环境填sandbox
        :type Profile: str
        """
        self._TransactionId = None
        self._PricingCurrency = None
        self._SourceCurrency = None
        self._TargetCurrency = None
        self._PayeeType = None
        self._PayeeAccount = None
        self._SourceAmount = None
        self._TargetAmount = None
        self._PayeeName = None
        self._PayeeAddress = None
        self._PayeeBankAccountType = None
        self._PayeeCountryCode = None
        self._PayeeBankName = None
        self._PayeeBankAddress = None
        self._PayeeBankDistrict = None
        self._PayeeBankSwiftCode = None
        self._PayeeBankType = None
        self._PayeeBankCode = None
        self._ReferenceForBeneficiary = None
        self._Profile = None

    @property
    def TransactionId(self):
        """对接方汇出指令编号
        :rtype: str
        """
        return self._TransactionId

    @TransactionId.setter
    def TransactionId(self, TransactionId):
        self._TransactionId = TransactionId

    @property
    def PricingCurrency(self):
        """定价币种
        :rtype: str
        """
        return self._PricingCurrency

    @PricingCurrency.setter
    def PricingCurrency(self, PricingCurrency):
        self._PricingCurrency = PricingCurrency

    @property
    def SourceCurrency(self):
        """源币种
        :rtype: str
        """
        return self._SourceCurrency

    @SourceCurrency.setter
    def SourceCurrency(self, SourceCurrency):
        self._SourceCurrency = SourceCurrency

    @property
    def TargetCurrency(self):
        """目的币种
        :rtype: str
        """
        return self._TargetCurrency

    @TargetCurrency.setter
    def TargetCurrency(self, TargetCurrency):
        self._TargetCurrency = TargetCurrency

    @property
    def PayeeType(self):
        """收款人类型（银行卡填"BANK_ACCOUNT"）
        :rtype: str
        """
        return self._PayeeType

    @PayeeType.setter
    def PayeeType(self, PayeeType):
        self._PayeeType = PayeeType

    @property
    def PayeeAccount(self):
        """收款人账号
        :rtype: str
        """
        return self._PayeeAccount

    @PayeeAccount.setter
    def PayeeAccount(self, PayeeAccount):
        self._PayeeAccount = PayeeAccount

    @property
    def SourceAmount(self):
        """源币种金额
        :rtype: float
        """
        return self._SourceAmount

    @SourceAmount.setter
    def SourceAmount(self, SourceAmount):
        self._SourceAmount = SourceAmount

    @property
    def TargetAmount(self):
        """目的金额
        :rtype: float
        """
        return self._TargetAmount

    @TargetAmount.setter
    def TargetAmount(self, TargetAmount):
        self._TargetAmount = TargetAmount

    @property
    def PayeeName(self):
        """收款人姓名（PayeeType为"BANK_COUNT"时必填）
        :rtype: str
        """
        return self._PayeeName

    @PayeeName.setter
    def PayeeName(self, PayeeName):
        self._PayeeName = PayeeName

    @property
    def PayeeAddress(self):
        """收款人地址（PayeeType为"BANK_COUNT"时必填）
        :rtype: str
        """
        return self._PayeeAddress

    @PayeeAddress.setter
    def PayeeAddress(self, PayeeAddress):
        self._PayeeAddress = PayeeAddress

    @property
    def PayeeBankAccountType(self):
        """收款人银行账号类型（PayeeType为"BANK_COUNT"时必填）
个人填"INDIVIDUAL"
企业填"CORPORATE"
        :rtype: str
        """
        return self._PayeeBankAccountType

    @PayeeBankAccountType.setter
    def PayeeBankAccountType(self, PayeeBankAccountType):
        self._PayeeBankAccountType = PayeeBankAccountType

    @property
    def PayeeCountryCode(self):
        """收款人国家或地区编码（PayeeType为"BANK_COUNT"时必填）
        :rtype: str
        """
        return self._PayeeCountryCode

    @PayeeCountryCode.setter
    def PayeeCountryCode(self, PayeeCountryCode):
        self._PayeeCountryCode = PayeeCountryCode

    @property
    def PayeeBankName(self):
        """收款人开户银行名称（PayeeType为"BANK_COUNT"时必填）
        :rtype: str
        """
        return self._PayeeBankName

    @PayeeBankName.setter
    def PayeeBankName(self, PayeeBankName):
        self._PayeeBankName = PayeeBankName

    @property
    def PayeeBankAddress(self):
        """收款人开户银行地址（PayeeType为"BANK_COUNT"时必填）
        :rtype: str
        """
        return self._PayeeBankAddress

    @PayeeBankAddress.setter
    def PayeeBankAddress(self, PayeeBankAddress):
        self._PayeeBankAddress = PayeeBankAddress

    @property
    def PayeeBankDistrict(self):
        """收款人开户银行所在国家或地区编码（PayeeType为"BANK_COUNT"时必填）
        :rtype: str
        """
        return self._PayeeBankDistrict

    @PayeeBankDistrict.setter
    def PayeeBankDistrict(self, PayeeBankDistrict):
        self._PayeeBankDistrict = PayeeBankDistrict

    @property
    def PayeeBankSwiftCode(self):
        """收款银行SwiftCode（PayeeType为"BANK_COUNT"时必填）
        :rtype: str
        """
        return self._PayeeBankSwiftCode

    @PayeeBankSwiftCode.setter
    def PayeeBankSwiftCode(self, PayeeBankSwiftCode):
        self._PayeeBankSwiftCode = PayeeBankSwiftCode

    @property
    def PayeeBankType(self):
        """收款银行国际编码类型
        :rtype: str
        """
        return self._PayeeBankType

    @PayeeBankType.setter
    def PayeeBankType(self, PayeeBankType):
        self._PayeeBankType = PayeeBankType

    @property
    def PayeeBankCode(self):
        """收款银行国际编码
        :rtype: str
        """
        return self._PayeeBankCode

    @PayeeBankCode.setter
    def PayeeBankCode(self, PayeeBankCode):
        self._PayeeBankCode = PayeeBankCode

    @property
    def ReferenceForBeneficiary(self):
        """收款人附言
        :rtype: str
        """
        return self._ReferenceForBeneficiary

    @ReferenceForBeneficiary.setter
    def ReferenceForBeneficiary(self, ReferenceForBeneficiary):
        self._ReferenceForBeneficiary = ReferenceForBeneficiary

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._TransactionId = params.get("TransactionId")
        self._PricingCurrency = params.get("PricingCurrency")
        self._SourceCurrency = params.get("SourceCurrency")
        self._TargetCurrency = params.get("TargetCurrency")
        self._PayeeType = params.get("PayeeType")
        self._PayeeAccount = params.get("PayeeAccount")
        self._SourceAmount = params.get("SourceAmount")
        self._TargetAmount = params.get("TargetAmount")
        self._PayeeName = params.get("PayeeName")
        self._PayeeAddress = params.get("PayeeAddress")
        self._PayeeBankAccountType = params.get("PayeeBankAccountType")
        self._PayeeCountryCode = params.get("PayeeCountryCode")
        self._PayeeBankName = params.get("PayeeBankName")
        self._PayeeBankAddress = params.get("PayeeBankAddress")
        self._PayeeBankDistrict = params.get("PayeeBankDistrict")
        self._PayeeBankSwiftCode = params.get("PayeeBankSwiftCode")
        self._PayeeBankType = params.get("PayeeBankType")
        self._PayeeBankCode = params.get("PayeeBankCode")
        self._ReferenceForBeneficiary = params.get("ReferenceForBeneficiary")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyOutwardOrderResponse(AbstractModel):
    """ApplyOutwardOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 汇出指令申请
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyOutwardOrderResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """汇出指令申请
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyOutwardOrderResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApplyOutwardOrderResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyOutwardOrderResult(AbstractModel):
    """汇出指令申请结果

    """

    def __init__(self):
        r"""
        :param _Data: 汇出指令申请数据
        :type Data: :class:`tencentcloud.cpdp.v20190820.models.ApplyOutwardOrderData`
        :param _Code: 错误码
        :type Code: str
        """
        self._Data = None
        self._Code = None

    @property
    def Data(self):
        """汇出指令申请数据
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyOutwardOrderData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Code(self):
        """错误码
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ApplyOutwardOrderData()
            self._Data._deserialize(params.get("Data"))
        self._Code = params.get("Code")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyPayerInfoRequest(AbstractModel):
    """ApplyPayerInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PayerId: 付款人ID
        :type PayerId: str
        :param _PayerType: 付款人类型 (个人: INDIVIDUAL, 企业: CORPORATE)
        :type PayerType: str
        :param _PayerName: 付款人姓名
        :type PayerName: str
        :param _PayerIdType: 付款人证件类型 (身份证: ID_CARD, 统一社会信用代码: UNIFIED_CREDIT_CODE)
        :type PayerIdType: str
        :param _PayerIdNo: 付款人证件号
        :type PayerIdNo: str
        :param _PayerCountryCode: 付款人常驻国家或地区编码 (见常见问题-国家/地区编码)
        :type PayerCountryCode: str
        :param _PayerContactName: 付款人联系人名称
        :type PayerContactName: str
        :param _PayerContactNumber: 付款人联系电话
        :type PayerContactNumber: str
        :param _PayerEmailAddress: 付款人联系邮箱
        :type PayerEmailAddress: str
        :param _Profile: 接入环境。沙箱环境填sandbox
        :type Profile: str
        """
        self._PayerId = None
        self._PayerType = None
        self._PayerName = None
        self._PayerIdType = None
        self._PayerIdNo = None
        self._PayerCountryCode = None
        self._PayerContactName = None
        self._PayerContactNumber = None
        self._PayerEmailAddress = None
        self._Profile = None

    @property
    def PayerId(self):
        """付款人ID
        :rtype: str
        """
        return self._PayerId

    @PayerId.setter
    def PayerId(self, PayerId):
        self._PayerId = PayerId

    @property
    def PayerType(self):
        """付款人类型 (个人: INDIVIDUAL, 企业: CORPORATE)
        :rtype: str
        """
        return self._PayerType

    @PayerType.setter
    def PayerType(self, PayerType):
        self._PayerType = PayerType

    @property
    def PayerName(self):
        """付款人姓名
        :rtype: str
        """
        return self._PayerName

    @PayerName.setter
    def PayerName(self, PayerName):
        self._PayerName = PayerName

    @property
    def PayerIdType(self):
        """付款人证件类型 (身份证: ID_CARD, 统一社会信用代码: UNIFIED_CREDIT_CODE)
        :rtype: str
        """
        return self._PayerIdType

    @PayerIdType.setter
    def PayerIdType(self, PayerIdType):
        self._PayerIdType = PayerIdType

    @property
    def PayerIdNo(self):
        """付款人证件号
        :rtype: str
        """
        return self._PayerIdNo

    @PayerIdNo.setter
    def PayerIdNo(self, PayerIdNo):
        self._PayerIdNo = PayerIdNo

    @property
    def PayerCountryCode(self):
        """付款人常驻国家或地区编码 (见常见问题-国家/地区编码)
        :rtype: str
        """
        return self._PayerCountryCode

    @PayerCountryCode.setter
    def PayerCountryCode(self, PayerCountryCode):
        self._PayerCountryCode = PayerCountryCode

    @property
    def PayerContactName(self):
        """付款人联系人名称
        :rtype: str
        """
        return self._PayerContactName

    @PayerContactName.setter
    def PayerContactName(self, PayerContactName):
        self._PayerContactName = PayerContactName

    @property
    def PayerContactNumber(self):
        """付款人联系电话
        :rtype: str
        """
        return self._PayerContactNumber

    @PayerContactNumber.setter
    def PayerContactNumber(self, PayerContactNumber):
        self._PayerContactNumber = PayerContactNumber

    @property
    def PayerEmailAddress(self):
        """付款人联系邮箱
        :rtype: str
        """
        return self._PayerEmailAddress

    @PayerEmailAddress.setter
    def PayerEmailAddress(self, PayerEmailAddress):
        self._PayerEmailAddress = PayerEmailAddress

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._PayerId = params.get("PayerId")
        self._PayerType = params.get("PayerType")
        self._PayerName = params.get("PayerName")
        self._PayerIdType = params.get("PayerIdType")
        self._PayerIdNo = params.get("PayerIdNo")
        self._PayerCountryCode = params.get("PayerCountryCode")
        self._PayerContactName = params.get("PayerContactName")
        self._PayerContactNumber = params.get("PayerContactNumber")
        self._PayerEmailAddress = params.get("PayerEmailAddress")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyPayerInfoResponse(AbstractModel):
    """ApplyPayerInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 付款人申请结果
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyPayerinfoResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """付款人申请结果
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyPayerinfoResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApplyPayerinfoResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyPayerinfoData(AbstractModel):
    """付款人申请结果

    """

    def __init__(self):
        r"""
        :param _MerchantId: 商户号
        :type MerchantId: str
        :param _PayerId: 付款人ID
        :type PayerId: str
        :param _Status: 状态
        :type Status: str
        :param _FailReason: 失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type FailReason: str
        """
        self._MerchantId = None
        self._PayerId = None
        self._Status = None
        self._FailReason = None

    @property
    def MerchantId(self):
        """商户号
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def PayerId(self):
        """付款人ID
        :rtype: str
        """
        return self._PayerId

    @PayerId.setter
    def PayerId(self, PayerId):
        self._PayerId = PayerId

    @property
    def Status(self):
        """状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def FailReason(self):
        """失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FailReason

    @FailReason.setter
    def FailReason(self, FailReason):
        self._FailReason = FailReason


    def _deserialize(self, params):
        self._MerchantId = params.get("MerchantId")
        self._PayerId = params.get("PayerId")
        self._Status = params.get("Status")
        self._FailReason = params.get("FailReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyPayerinfoResult(AbstractModel):
    """付款人申请结果

    """

    def __init__(self):
        r"""
        :param _Code: 错误码
        :type Code: str
        :param _Data: 数据
        :type Data: :class:`tencentcloud.cpdp.v20190820.models.ApplyPayerinfoData`
        """
        self._Code = None
        self._Data = None

    @property
    def Code(self):
        """错误码
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Data(self):
        """数据
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyPayerinfoData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Code = params.get("Code")
        if params.get("Data") is not None:
            self._Data = ApplyPayerinfoData()
            self._Data._deserialize(params.get("Data"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyReWithdrawalRequest(AbstractModel):
    """ApplyReWithdrawal请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BusinessType: 聚鑫业务类型
        :type BusinessType: int
        :param _MidasSecretId: 由平台客服提供的计费密钥Id
        :type MidasSecretId: str
        :param _MidasSignature: 计费签名
        :type MidasSignature: str
        :param _Body: 提现信息
        :type Body: :class:`tencentcloud.cpdp.v20190820.models.WithdrawBill`
        :param _MidasAppId: 聚鑫业务ID
        :type MidasAppId: str
        :param _MidasEnvironment: 环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type MidasEnvironment: str
        """
        self._BusinessType = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._Body = None
        self._MidasAppId = None
        self._MidasEnvironment = None

    @property
    def BusinessType(self):
        """聚鑫业务类型
        :rtype: int
        """
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def MidasSecretId(self):
        """由平台客服提供的计费密钥Id
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """计费签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def Body(self):
        """提现信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.WithdrawBill`
        """
        return self._Body

    @Body.setter
    def Body(self, Body):
        self._Body = Body

    @property
    def MidasAppId(self):
        """聚鑫业务ID
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def MidasEnvironment(self):
        """环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment


    def _deserialize(self, params):
        self._BusinessType = params.get("BusinessType")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        if params.get("Body") is not None:
            self._Body = WithdrawBill()
            self._Body._deserialize(params.get("Body"))
        self._MidasAppId = params.get("MidasAppId")
        self._MidasEnvironment = params.get("MidasEnvironment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyReWithdrawalResponse(AbstractModel):
    """ApplyReWithdrawal返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WithdrawOrderId: 重新提现业务订单号
        :type WithdrawOrderId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WithdrawOrderId = None
        self._RequestId = None

    @property
    def WithdrawOrderId(self):
        """重新提现业务订单号
        :rtype: str
        """
        return self._WithdrawOrderId

    @WithdrawOrderId.setter
    def WithdrawOrderId(self, WithdrawOrderId):
        self._WithdrawOrderId = WithdrawOrderId

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WithdrawOrderId = params.get("WithdrawOrderId")
        self._RequestId = params.get("RequestId")


class ApplyReconciliationFileRequest(AbstractModel):
    """ApplyReconciliationFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApplyFileType: 申请的文件类型。
__CZ__：充值文件
__TX__：提现文件
__JY__：交易文件
__YE__：余额文件
        :type ApplyFileType: str
        :param _ApplyFileDate: 申请的对账文件日期，格式：yyyyMMdd。
        :type ApplyFileDate: str
        :param _BankAccountNumber: 父账户账号。
_平安渠道为资金汇总账号_
        :type BankAccountNumber: str
        :param _MidasEnvironment: 环境名。
__release__: 现网环境
__sandbox__: 沙箱环境
__development__: 开发环境
_缺省: release_
        :type MidasEnvironment: str
        """
        self._ApplyFileType = None
        self._ApplyFileDate = None
        self._BankAccountNumber = None
        self._MidasEnvironment = None

    @property
    def ApplyFileType(self):
        """申请的文件类型。
__CZ__：充值文件
__TX__：提现文件
__JY__：交易文件
__YE__：余额文件
        :rtype: str
        """
        return self._ApplyFileType

    @ApplyFileType.setter
    def ApplyFileType(self, ApplyFileType):
        self._ApplyFileType = ApplyFileType

    @property
    def ApplyFileDate(self):
        """申请的对账文件日期，格式：yyyyMMdd。
        :rtype: str
        """
        return self._ApplyFileDate

    @ApplyFileDate.setter
    def ApplyFileDate(self, ApplyFileDate):
        self._ApplyFileDate = ApplyFileDate

    @property
    def BankAccountNumber(self):
        """父账户账号。
_平安渠道为资金汇总账号_
        :rtype: str
        """
        return self._BankAccountNumber

    @BankAccountNumber.setter
    def BankAccountNumber(self, BankAccountNumber):
        self._BankAccountNumber = BankAccountNumber

    @property
    def MidasEnvironment(self):
        """环境名。
__release__: 现网环境
__sandbox__: 沙箱环境
__development__: 开发环境
_缺省: release_
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment


    def _deserialize(self, params):
        self._ApplyFileType = params.get("ApplyFileType")
        self._ApplyFileDate = params.get("ApplyFileDate")
        self._BankAccountNumber = params.get("BankAccountNumber")
        self._MidasEnvironment = params.get("MidasEnvironment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyReconciliationFileResponse(AbstractModel):
    """ApplyReconciliationFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :type ErrCode: str
        :param _ErrMessage: 错误消息。
        :type ErrMessage: str
        :param _Result: 返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyReconciliationFileResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyReconciliationFileResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = ApplyReconciliationFileResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyReconciliationFileResult(AbstractModel):
    """申请对账文件结果

    """

    def __init__(self):
        r"""
        :param _ApplyFileId: 申请对账文件的任务ID。
        :type ApplyFileId: str
        :param _ApplyStatus: 对账文件申请状态。
__I__：申请中
__S__：申请成功
__F__：申请失败
        :type ApplyStatus: str
        :param _ApplyMessage: 申请结果描述。
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplyMessage: str
        """
        self._ApplyFileId = None
        self._ApplyStatus = None
        self._ApplyMessage = None

    @property
    def ApplyFileId(self):
        """申请对账文件的任务ID。
        :rtype: str
        """
        return self._ApplyFileId

    @ApplyFileId.setter
    def ApplyFileId(self, ApplyFileId):
        self._ApplyFileId = ApplyFileId

    @property
    def ApplyStatus(self):
        """对账文件申请状态。
__I__：申请中
__S__：申请成功
__F__：申请失败
        :rtype: str
        """
        return self._ApplyStatus

    @ApplyStatus.setter
    def ApplyStatus(self, ApplyStatus):
        self._ApplyStatus = ApplyStatus

    @property
    def ApplyMessage(self):
        """申请结果描述。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ApplyMessage

    @ApplyMessage.setter
    def ApplyMessage(self, ApplyMessage):
        self._ApplyMessage = ApplyMessage


    def _deserialize(self, params):
        self._ApplyFileId = params.get("ApplyFileId")
        self._ApplyStatus = params.get("ApplyStatus")
        self._ApplyMessage = params.get("ApplyMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyTradeData(AbstractModel):
    """提交贸易材料结果

    """

    def __init__(self):
        r"""
        :param _MerchantId: 商户号
        :type MerchantId: str
        :param _TradeFileId: 贸易材料流水号
        :type TradeFileId: str
        :param _TradeCurrency: 交易币种
        :type TradeCurrency: str
        :param _TradeAmount: 交易金额
        :type TradeAmount: str
        :param _PayerId: 付款人ID
        :type PayerId: str
        :param _Status: 状态
        :type Status: str
        """
        self._MerchantId = None
        self._TradeFileId = None
        self._TradeCurrency = None
        self._TradeAmount = None
        self._PayerId = None
        self._Status = None

    @property
    def MerchantId(self):
        """商户号
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def TradeFileId(self):
        """贸易材料流水号
        :rtype: str
        """
        return self._TradeFileId

    @TradeFileId.setter
    def TradeFileId(self, TradeFileId):
        self._TradeFileId = TradeFileId

    @property
    def TradeCurrency(self):
        """交易币种
        :rtype: str
        """
        return self._TradeCurrency

    @TradeCurrency.setter
    def TradeCurrency(self, TradeCurrency):
        self._TradeCurrency = TradeCurrency

    @property
    def TradeAmount(self):
        """交易金额
        :rtype: str
        """
        return self._TradeAmount

    @TradeAmount.setter
    def TradeAmount(self, TradeAmount):
        self._TradeAmount = TradeAmount

    @property
    def PayerId(self):
        """付款人ID
        :rtype: str
        """
        return self._PayerId

    @PayerId.setter
    def PayerId(self, PayerId):
        self._PayerId = PayerId

    @property
    def Status(self):
        """状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._MerchantId = params.get("MerchantId")
        self._TradeFileId = params.get("TradeFileId")
        self._TradeCurrency = params.get("TradeCurrency")
        self._TradeAmount = params.get("TradeAmount")
        self._PayerId = params.get("PayerId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyTradeRequest(AbstractModel):
    """ApplyTrade请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TradeFileId: 贸易材料流水号
        :type TradeFileId: str
        :param _TradeOrderId: 贸易材料订单号
        :type TradeOrderId: str
        :param _PayerId: 付款人ID
        :type PayerId: str
        :param _PayeeName: 收款人姓名
        :type PayeeName: str
        :param _PayeeCountryCode: 收款人常驻国家或地区编码 (见常见问题)
        :type PayeeCountryCode: str
        :param _TradeType: 贸易类型 (GOODS: 商品, SERVICE: 服务)
        :type TradeType: str
        :param _TradeTime: 交易时间 (格式: yyyyMMdd)
        :type TradeTime: str
        :param _TradeCurrency: 交易币种
        :type TradeCurrency: str
        :param _TradeAmount: 交易金额
        :type TradeAmount: float
        :param _TradeName: 交易名称 
(TradeType=GOODS时填写物品名称，可填写多个，格式无要求；
TradeType=SERVICE时填写贸易类别，见常见问题-贸易类别)
        :type TradeName: str
        :param _TradeCount: 交易数量 (TradeType=GOODS 填写物品数量, TradeType=SERVICE填写服务次数)
        :type TradeCount: int
        :param _GoodsCarrier: 货贸承运人 (TradeType=GOODS 必填)
        :type GoodsCarrier: str
        :param _ServiceDetail: 服贸交易细节 (TradeType=GOODS 必填, 见常见问题-交易细节)
        :type ServiceDetail: str
        :param _ServiceTime: 服贸服务时间 (TradeType=GOODS 必填, 见常见问题-服务时间)
        :type ServiceTime: str
        :param _Profile: 接入环境。沙箱环境填sandbox
        :type Profile: str
        """
        self._TradeFileId = None
        self._TradeOrderId = None
        self._PayerId = None
        self._PayeeName = None
        self._PayeeCountryCode = None
        self._TradeType = None
        self._TradeTime = None
        self._TradeCurrency = None
        self._TradeAmount = None
        self._TradeName = None
        self._TradeCount = None
        self._GoodsCarrier = None
        self._ServiceDetail = None
        self._ServiceTime = None
        self._Profile = None

    @property
    def TradeFileId(self):
        """贸易材料流水号
        :rtype: str
        """
        return self._TradeFileId

    @TradeFileId.setter
    def TradeFileId(self, TradeFileId):
        self._TradeFileId = TradeFileId

    @property
    def TradeOrderId(self):
        """贸易材料订单号
        :rtype: str
        """
        return self._TradeOrderId

    @TradeOrderId.setter
    def TradeOrderId(self, TradeOrderId):
        self._TradeOrderId = TradeOrderId

    @property
    def PayerId(self):
        """付款人ID
        :rtype: str
        """
        return self._PayerId

    @PayerId.setter
    def PayerId(self, PayerId):
        self._PayerId = PayerId

    @property
    def PayeeName(self):
        """收款人姓名
        :rtype: str
        """
        return self._PayeeName

    @PayeeName.setter
    def PayeeName(self, PayeeName):
        self._PayeeName = PayeeName

    @property
    def PayeeCountryCode(self):
        """收款人常驻国家或地区编码 (见常见问题)
        :rtype: str
        """
        return self._PayeeCountryCode

    @PayeeCountryCode.setter
    def PayeeCountryCode(self, PayeeCountryCode):
        self._PayeeCountryCode = PayeeCountryCode

    @property
    def TradeType(self):
        """贸易类型 (GOODS: 商品, SERVICE: 服务)
        :rtype: str
        """
        return self._TradeType

    @TradeType.setter
    def TradeType(self, TradeType):
        self._TradeType = TradeType

    @property
    def TradeTime(self):
        """交易时间 (格式: yyyyMMdd)
        :rtype: str
        """
        return self._TradeTime

    @TradeTime.setter
    def TradeTime(self, TradeTime):
        self._TradeTime = TradeTime

    @property
    def TradeCurrency(self):
        """交易币种
        :rtype: str
        """
        return self._TradeCurrency

    @TradeCurrency.setter
    def TradeCurrency(self, TradeCurrency):
        self._TradeCurrency = TradeCurrency

    @property
    def TradeAmount(self):
        """交易金额
        :rtype: float
        """
        return self._TradeAmount

    @TradeAmount.setter
    def TradeAmount(self, TradeAmount):
        self._TradeAmount = TradeAmount

    @property
    def TradeName(self):
        """交易名称 
(TradeType=GOODS时填写物品名称，可填写多个，格式无要求；
TradeType=SERVICE时填写贸易类别，见常见问题-贸易类别)
        :rtype: str
        """
        return self._TradeName

    @TradeName.setter
    def TradeName(self, TradeName):
        self._TradeName = TradeName

    @property
    def TradeCount(self):
        """交易数量 (TradeType=GOODS 填写物品数量, TradeType=SERVICE填写服务次数)
        :rtype: int
        """
        return self._TradeCount

    @TradeCount.setter
    def TradeCount(self, TradeCount):
        self._TradeCount = TradeCount

    @property
    def GoodsCarrier(self):
        """货贸承运人 (TradeType=GOODS 必填)
        :rtype: str
        """
        return self._GoodsCarrier

    @GoodsCarrier.setter
    def GoodsCarrier(self, GoodsCarrier):
        self._GoodsCarrier = GoodsCarrier

    @property
    def ServiceDetail(self):
        """服贸交易细节 (TradeType=GOODS 必填, 见常见问题-交易细节)
        :rtype: str
        """
        return self._ServiceDetail

    @ServiceDetail.setter
    def ServiceDetail(self, ServiceDetail):
        self._ServiceDetail = ServiceDetail

    @property
    def ServiceTime(self):
        """服贸服务时间 (TradeType=GOODS 必填, 见常见问题-服务时间)
        :rtype: str
        """
        return self._ServiceTime

    @ServiceTime.setter
    def ServiceTime(self, ServiceTime):
        self._ServiceTime = ServiceTime

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._TradeFileId = params.get("TradeFileId")
        self._TradeOrderId = params.get("TradeOrderId")
        self._PayerId = params.get("PayerId")
        self._PayeeName = params.get("PayeeName")
        self._PayeeCountryCode = params.get("PayeeCountryCode")
        self._TradeType = params.get("TradeType")
        self._TradeTime = params.get("TradeTime")
        self._TradeCurrency = params.get("TradeCurrency")
        self._TradeAmount = params.get("TradeAmount")
        self._TradeName = params.get("TradeName")
        self._TradeCount = params.get("TradeCount")
        self._GoodsCarrier = params.get("GoodsCarrier")
        self._ServiceDetail = params.get("ServiceDetail")
        self._ServiceTime = params.get("ServiceTime")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyTradeResponse(AbstractModel):
    """ApplyTrade返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 提交贸易材料结果
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.ApplyTradeResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """提交贸易材料结果
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyTradeResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = ApplyTradeResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class ApplyTradeResult(AbstractModel):
    """提交贸易材料结果

    """

    def __init__(self):
        r"""
        :param _Code: 错误码
        :type Code: str
        :param _Data: 提交贸易材料数据
        :type Data: :class:`tencentcloud.cpdp.v20190820.models.ApplyTradeData`
        """
        self._Code = None
        self._Data = None

    @property
    def Code(self):
        """错误码
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Data(self):
        """提交贸易材料数据
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ApplyTradeData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Code = params.get("Code")
        if params.get("Data") is not None:
            self._Data = ApplyTradeData()
            self._Data._deserialize(params.get("Data"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyWithdrawalRequest(AbstractModel):
    """ApplyWithdrawal请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MidasAppId: 聚鑫分配的支付主MidasAppId
        :type MidasAppId: str
        :param _SubAppId: 聚鑫计费SubAppId，代表子商户
        :type SubAppId: str
        :param _SettleAcctNo: 用于提现
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type SettleAcctNo: str
        :param _SettleAcctName: 结算账户户名
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type SettleAcctName: str
        :param _CurrencyType: 币种 RMB
        :type CurrencyType: str
        :param _CurrencyUnit: 单位，1：元，2：角，3：分
        :type CurrencyUnit: int
        :param _CurrencyAmt: 金额
        :type CurrencyAmt: str
        :param _TranWebName: 交易网名称
        :type TranWebName: str
        :param _IdType: 会员证件类型
        :type IdType: str
        :param _IdCode: 会员证件号码
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type IdCode: str
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasSignature: 按照聚鑫安全密钥计算的签名
        :type MidasSignature: str
        :param _EncryptType: 敏感信息加密类型:
RSA: rsa非对称加密，使用RSA-PKCS1-v1_5
AES: aes对称加密，使用AES256-CBC-PCKS7padding
缺省: RSA
        :type EncryptType: str
        :param _MidasEnvironment: 环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type MidasEnvironment: str
        :param _CommissionAmount: 手续费金额
        :type CommissionAmount: str
        :param _WithdrawOrderId: 提现单号，长度32字节
        :type WithdrawOrderId: str
        """
        self._MidasAppId = None
        self._SubAppId = None
        self._SettleAcctNo = None
        self._SettleAcctName = None
        self._CurrencyType = None
        self._CurrencyUnit = None
        self._CurrencyAmt = None
        self._TranWebName = None
        self._IdType = None
        self._IdCode = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._EncryptType = None
        self._MidasEnvironment = None
        self._CommissionAmount = None
        self._WithdrawOrderId = None

    @property
    def MidasAppId(self):
        """聚鑫分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def SubAppId(self):
        """聚鑫计费SubAppId，代表子商户
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SettleAcctNo(self):
        """用于提现
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._SettleAcctNo

    @SettleAcctNo.setter
    def SettleAcctNo(self, SettleAcctNo):
        self._SettleAcctNo = SettleAcctNo

    @property
    def SettleAcctName(self):
        """结算账户户名
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._SettleAcctName

    @SettleAcctName.setter
    def SettleAcctName(self, SettleAcctName):
        self._SettleAcctName = SettleAcctName

    @property
    def CurrencyType(self):
        """币种 RMB
        :rtype: str
        """
        return self._CurrencyType

    @CurrencyType.setter
    def CurrencyType(self, CurrencyType):
        self._CurrencyType = CurrencyType

    @property
    def CurrencyUnit(self):
        """单位，1：元，2：角，3：分
        :rtype: int
        """
        return self._CurrencyUnit

    @CurrencyUnit.setter
    def CurrencyUnit(self, CurrencyUnit):
        self._CurrencyUnit = CurrencyUnit

    @property
    def CurrencyAmt(self):
        """金额
        :rtype: str
        """
        return self._CurrencyAmt

    @CurrencyAmt.setter
    def CurrencyAmt(self, CurrencyAmt):
        self._CurrencyAmt = CurrencyAmt

    @property
    def TranWebName(self):
        """交易网名称
        :rtype: str
        """
        return self._TranWebName

    @TranWebName.setter
    def TranWebName(self, TranWebName):
        self._TranWebName = TranWebName

    @property
    def IdType(self):
        """会员证件类型
        :rtype: str
        """
        return self._IdType

    @IdType.setter
    def IdType(self, IdType):
        self._IdType = IdType

    @property
    def IdCode(self):
        """会员证件号码
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._IdCode

    @IdCode.setter
    def IdCode(self, IdCode):
        self._IdCode = IdCode

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """按照聚鑫安全密钥计算的签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def EncryptType(self):
        """敏感信息加密类型:
RSA: rsa非对称加密，使用RSA-PKCS1-v1_5
AES: aes对称加密，使用AES256-CBC-PCKS7padding
缺省: RSA
        :rtype: str
        """
        return self._EncryptType

    @EncryptType.setter
    def EncryptType(self, EncryptType):
        self._EncryptType = EncryptType

    @property
    def MidasEnvironment(self):
        """环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment

    @property
    def CommissionAmount(self):
        """手续费金额
        :rtype: str
        """
        return self._CommissionAmount

    @CommissionAmount.setter
    def CommissionAmount(self, CommissionAmount):
        self._CommissionAmount = CommissionAmount

    @property
    def WithdrawOrderId(self):
        """提现单号，长度32字节
        :rtype: str
        """
        return self._WithdrawOrderId

    @WithdrawOrderId.setter
    def WithdrawOrderId(self, WithdrawOrderId):
        self._WithdrawOrderId = WithdrawOrderId


    def _deserialize(self, params):
        self._MidasAppId = params.get("MidasAppId")
        self._SubAppId = params.get("SubAppId")
        self._SettleAcctNo = params.get("SettleAcctNo")
        self._SettleAcctName = params.get("SettleAcctName")
        self._CurrencyType = params.get("CurrencyType")
        self._CurrencyUnit = params.get("CurrencyUnit")
        self._CurrencyAmt = params.get("CurrencyAmt")
        self._TranWebName = params.get("TranWebName")
        self._IdType = params.get("IdType")
        self._IdCode = params.get("IdCode")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        self._EncryptType = params.get("EncryptType")
        self._MidasEnvironment = params.get("MidasEnvironment")
        self._CommissionAmount = params.get("CommissionAmount")
        self._WithdrawOrderId = params.get("WithdrawOrderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyWithdrawalResponse(AbstractModel):
    """ApplyWithdrawal返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssignmentData(AbstractModel):
    """分配关系

    """

    def __init__(self):
        r"""
        :param _AnchorId: 主播ID
        :type AnchorId: str
        :param _AnchorName: 主播名称
        :type AnchorName: str
        :param _AgentId: 代理商ID
        :type AgentId: str
        :param _AgentName: 代理商名称
        :type AgentName: str
        """
        self._AnchorId = None
        self._AnchorName = None
        self._AgentId = None
        self._AgentName = None

    @property
    def AnchorId(self):
        """主播ID
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def AnchorName(self):
        """主播名称
        :rtype: str
        """
        return self._AnchorName

    @AnchorName.setter
    def AnchorName(self, AnchorName):
        self._AnchorName = AnchorName

    @property
    def AgentId(self):
        """代理商ID
        :rtype: str
        """
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def AgentName(self):
        """代理商名称
        :rtype: str
        """
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName


    def _deserialize(self, params):
        self._AnchorId = params.get("AnchorId")
        self._AnchorName = params.get("AnchorName")
        self._AgentId = params.get("AgentId")
        self._AgentName = params.get("AgentName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BankBranchInfo(AbstractModel):
    """支行信息

    """

    def __init__(self):
        r"""
        :param _BankName: 银行名称。
        :type BankName: str
        :param _BankAbbreviation: 银行简称。
        :type BankAbbreviation: str
        :param _BankBranchName: 支行名。
        :type BankBranchName: str
        :param _BankBranchId: 联行号。
        :type BankBranchId: str
        """
        self._BankName = None
        self._BankAbbreviation = None
        self._BankBranchName = None
        self._BankBranchId = None

    @property
    def BankName(self):
        """银行名称。
        :rtype: str
        """
        return self._BankName

    @BankName.setter
    def BankName(self, BankName):
        self._BankName = BankName

    @property
    def BankAbbreviation(self):
        """银行简称。
        :rtype: str
        """
        return self._BankAbbreviation

    @BankAbbreviation.setter
    def BankAbbreviation(self, BankAbbreviation):
        self._BankAbbreviation = BankAbbreviation

    @property
    def BankBranchName(self):
        """支行名。
        :rtype: str
        """
        return self._BankBranchName

    @BankBranchName.setter
    def BankBranchName(self, BankBranchName):
        self._BankBranchName = BankBranchName

    @property
    def BankBranchId(self):
        """联行号。
        :rtype: str
        """
        return self._BankBranchId

    @BankBranchId.setter
    def BankBranchId(self, BankBranchId):
        self._BankBranchId = BankBranchId


    def _deserialize(self, params):
        self._BankName = params.get("BankName")
        self._BankAbbreviation = params.get("BankAbbreviation")
        self._BankBranchName = params.get("BankBranchName")
        self._BankBranchId = params.get("BankBranchId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BankCardItem(AbstractModel):
    """绑卡列表

    """

    def __init__(self):
        r"""
        :param _EiconBankBranchId: 超级网银行号
        :type EiconBankBranchId: str
        :param _CnapsBranchId: 大小额行号
        :type CnapsBranchId: str
        :param _SettleAcctType: 结算账户类型
1 – 本行账户
2 – 他行账户
        :type SettleAcctType: int
        :param _SettleAcctName: 结算账户户名
<敏感信息>
        :type SettleAcctName: str
        :param _AcctBranchName: 开户行名称
        :type AcctBranchName: str
        :param _SettleAcctNo: 用于提现
<敏感信息>
        :type SettleAcctNo: str
        :param _SubAppId: 聚鑫计费SubAppId，代表子商户
        :type SubAppId: str
        :param _BindType: 验证类型
1 – 小额转账验证
2 – 短信验证
        :type BindType: int
        :param _Mobile: 用于短信验证
BindType==2时必填
<敏感信息>
        :type Mobile: str
        :param _IdType: 证件类型
        :type IdType: str
        :param _IdCode: 证件号码
<敏感信息>
        :type IdCode: str
        """
        self._EiconBankBranchId = None
        self._CnapsBranchId = None
        self._SettleAcctType = None
        self._SettleAcctName = None
        self._AcctBranchName = None
        self._SettleAcctNo = None
        self._SubAppId = None
        self._BindType = None
        self._Mobile = None
        self._IdType = None
        self._IdCode = None

    @property
    def EiconBankBranchId(self):
        """超级网银行号
        :rtype: str
        """
        return self._EiconBankBranchId

    @EiconBankBranchId.setter
    def EiconBankBranchId(self, EiconBankBranchId):
        self._EiconBankBranchId = EiconBankBranchId

    @property
    def CnapsBranchId(self):
        """大小额行号
        :rtype: str
        """
        return self._CnapsBranchId

    @CnapsBranchId.setter
    def CnapsBranchId(self, CnapsBranchId):
        self._CnapsBranchId = CnapsBranchId

    @property
    def SettleAcctType(self):
        """结算账户类型
1 – 本行账户
2 – 他行账户
        :rtype: int
        """
        return self._SettleAcctType

    @SettleAcctType.setter
    def SettleAcctType(self, SettleAcctType):
        self._SettleAcctType = SettleAcctType

    @property
    def SettleAcctName(self):
        """结算账户户名
<敏感信息>
        :rtype: str
        """
        return self._SettleAcctName

    @SettleAcctName.setter
    def SettleAcctName(self, SettleAcctName):
        self._SettleAcctName = SettleAcctName

    @property
    def AcctBranchName(self):
        """开户行名称
        :rtype: str
        """
        return self._AcctBranchName

    @AcctBranchName.setter
    def AcctBranchName(self, AcctBranchName):
        self._AcctBranchName = AcctBranchName

    @property
    def SettleAcctNo(self):
        """用于提现
<敏感信息>
        :rtype: str
        """
        return self._SettleAcctNo

    @SettleAcctNo.setter
    def SettleAcctNo(self, SettleAcctNo):
        self._SettleAcctNo = SettleAcctNo

    @property
    def SubAppId(self):
        """聚鑫计费SubAppId，代表子商户
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def BindType(self):
        """验证类型
1 – 小额转账验证
2 – 短信验证
        :rtype: int
        """
        return self._BindType

    @BindType.setter
    def BindType(self, BindType):
        self._BindType = BindType

    @property
    def Mobile(self):
        """用于短信验证
BindType==2时必填
<敏感信息>
        :rtype: str
        """
        return self._Mobile

    @Mobile.setter
    def Mobile(self, Mobile):
        self._Mobile = Mobile

    @property
    def IdType(self):
        """证件类型
        :rtype: str
        """
        return self._IdType

    @IdType.setter
    def IdType(self, IdType):
        self._IdType = IdType

    @property
    def IdCode(self):
        """证件号码
<敏感信息>
        :rtype: str
        """
        return self._IdCode

    @IdCode.setter
    def IdCode(self, IdCode):
        self._IdCode = IdCode


    def _deserialize(self, params):
        self._EiconBankBranchId = params.get("EiconBankBranchId")
        self._CnapsBranchId = params.get("CnapsBranchId")
        self._SettleAcctType = params.get("SettleAcctType")
        self._SettleAcctName = params.get("SettleAcctName")
        self._AcctBranchName = params.get("AcctBranchName")
        self._SettleAcctNo = params.get("SettleAcctNo")
        self._SubAppId = params.get("SubAppId")
        self._BindType = params.get("BindType")
        self._Mobile = params.get("Mobile")
        self._IdType = params.get("IdType")
        self._IdCode = params.get("IdCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BillDownloadUrlResult(AbstractModel):
    """机构账单文件下载地址响应对象

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 对账单下载地址。GET方式访问，返回zip包，解压后为csv格式文件。
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        """
        self._DownloadUrl = None

    @property
    def DownloadUrl(self):
        """对账单下载地址。GET方式访问，返回zip包，解压后为csv格式文件。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindAccountRequest(AbstractModel):
    """BindAccount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AnchorId: 主播Id
        :type AnchorId: str
        :param _TransferType: 1 微信企业付款 
2 支付宝转账 
3 平安银企直连代发转账
        :type TransferType: int
        :param _AccountNo: 收款方标识。
微信为open_id；
支付宝为会员alipay_user_id;
平安为收款方银行账号;
        :type AccountNo: str
        :param _PhoneNum: 手机号
        :type PhoneNum: str
        """
        self._AnchorId = None
        self._TransferType = None
        self._AccountNo = None
        self._PhoneNum = None

    @property
    def AnchorId(self):
        """主播Id
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def TransferType(self):
        """1 微信企业付款 
2 支付宝转账 
3 平安银企直连代发转账
        :rtype: int
        """
        return self._TransferType

    @TransferType.setter
    def TransferType(self, TransferType):
        self._TransferType = TransferType

    @property
    def AccountNo(self):
        """收款方标识。
微信为open_id；
支付宝为会员alipay_user_id;
平安为收款方银行账号;
        :rtype: str
        """
        return self._AccountNo

    @AccountNo.setter
    def AccountNo(self, AccountNo):
        self._AccountNo = AccountNo

    @property
    def PhoneNum(self):
        """手机号
        :rtype: str
        """
        return self._PhoneNum

    @PhoneNum.setter
    def PhoneNum(self, PhoneNum):
        self._PhoneNum = PhoneNum


    def _deserialize(self, params):
        self._AnchorId = params.get("AnchorId")
        self._TransferType = params.get("TransferType")
        self._AccountNo = params.get("AccountNo")
        self._PhoneNum = params.get("PhoneNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindAccountResponse(AbstractModel):
    """BindAccount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。响应成功："SUCCESS"，其他为不成功。
        :type ErrCode: str
        :param _ErrMessage: 响应消息。
        :type ErrMessage: str
        :param _Result: 该字段为null。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。响应成功："SUCCESS"，其他为不成功。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """响应消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """该字段为null。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class BindAcctRequest(AbstractModel):
    """BindAcct请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MidasAppId: 聚鑫分配的支付主MidasAppId
        :type MidasAppId: str
        :param _SubAppId: 聚鑫计费SubAppId，代表子商户
        :type SubAppId: str
        :param _BindType: 1 – 小额转账验证
2 – 短信验证
3 - 一分钱转账验证，无需再调CheckAcct验证绑卡
4 - 银行四要素验证，无需再调CheckAcct验证绑卡
每个结算账户每天只能使用一次小额转账验证
        :type BindType: int
        :param _SettleAcctNo: 用于提现
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type SettleAcctNo: str
        :param _SettleAcctName: 结算账户户名
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type SettleAcctName: str
        :param _SettleAcctType: 1 – 本行账户
2 – 他行账户
        :type SettleAcctType: int
        :param _IdType: 证件类型，见《证件类型》表
        :type IdType: str
        :param _IdCode: 证件号码
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type IdCode: str
        :param _AcctBranchName: 开户行名称
        :type AcctBranchName: str
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasSignature: 按照聚鑫安全密钥计算的签名
        :type MidasSignature: str
        :param _Mobile: 用于短信验证
BindType==2时必填
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type Mobile: str
        :param _CnapsBranchId: 大小额行号，超级网银行号和大小额行号
二选一
        :type CnapsBranchId: str
        :param _EiconBankBranchId: 超级网银行号，超级网银行号和大小额行号
二选一
        :type EiconBankBranchId: str
        :param _EncryptType: 敏感信息加密类型:
RSA: rsa非对称加密，使用RSA-PKCS1-v1_5
AES: aes对称加密，使用AES256-CBC-PCKS7padding
缺省: RSA
        :type EncryptType: str
        :param _MidasEnvironment: 环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type MidasEnvironment: str
        :param _AgencyClientInfo: 经办人信息
        :type AgencyClientInfo: :class:`tencentcloud.cpdp.v20190820.models.AgencyClientInfo`
        """
        self._MidasAppId = None
        self._SubAppId = None
        self._BindType = None
        self._SettleAcctNo = None
        self._SettleAcctName = None
        self._SettleAcctType = None
        self._IdType = None
        self._IdCode = None
        self._AcctBranchName = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._Mobile = None
        self._CnapsBranchId = None
        self._EiconBankBranchId = None
        self._EncryptType = None
        self._MidasEnvironment = None
        self._AgencyClientInfo = None

    @property
    def MidasAppId(self):
        """聚鑫分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def SubAppId(self):
        """聚鑫计费SubAppId，代表子商户
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def BindType(self):
        """1 – 小额转账验证
2 – 短信验证
3 - 一分钱转账验证，无需再调CheckAcct验证绑卡
4 - 银行四要素验证，无需再调CheckAcct验证绑卡
每个结算账户每天只能使用一次小额转账验证
        :rtype: int
        """
        return self._BindType

    @BindType.setter
    def BindType(self, BindType):
        self._BindType = BindType

    @property
    def SettleAcctNo(self):
        """用于提现
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._SettleAcctNo

    @SettleAcctNo.setter
    def SettleAcctNo(self, SettleAcctNo):
        self._SettleAcctNo = SettleAcctNo

    @property
    def SettleAcctName(self):
        """结算账户户名
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._SettleAcctName

    @SettleAcctName.setter
    def SettleAcctName(self, SettleAcctName):
        self._SettleAcctName = SettleAcctName

    @property
    def SettleAcctType(self):
        """1 – 本行账户
2 – 他行账户
        :rtype: int
        """
        return self._SettleAcctType

    @SettleAcctType.setter
    def SettleAcctType(self, SettleAcctType):
        self._SettleAcctType = SettleAcctType

    @property
    def IdType(self):
        """证件类型，见《证件类型》表
        :rtype: str
        """
        return self._IdType

    @IdType.setter
    def IdType(self, IdType):
        self._IdType = IdType

    @property
    def IdCode(self):
        """证件号码
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._IdCode

    @IdCode.setter
    def IdCode(self, IdCode):
        self._IdCode = IdCode

    @property
    def AcctBranchName(self):
        """开户行名称
        :rtype: str
        """
        return self._AcctBranchName

    @AcctBranchName.setter
    def AcctBranchName(self, AcctBranchName):
        self._AcctBranchName = AcctBranchName

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """按照聚鑫安全密钥计算的签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def Mobile(self):
        """用于短信验证
BindType==2时必填
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._Mobile

    @Mobile.setter
    def Mobile(self, Mobile):
        self._Mobile = Mobile

    @property
    def CnapsBranchId(self):
        """大小额行号，超级网银行号和大小额行号
二选一
        :rtype: str
        """
        return self._CnapsBranchId

    @CnapsBranchId.setter
    def CnapsBranchId(self, CnapsBranchId):
        self._CnapsBranchId = CnapsBranchId

    @property
    def EiconBankBranchId(self):
        """超级网银行号，超级网银行号和大小额行号
二选一
        :rtype: str
        """
        return self._EiconBankBranchId

    @EiconBankBranchId.setter
    def EiconBankBranchId(self, EiconBankBranchId):
        self._EiconBankBranchId = EiconBankBranchId

    @property
    def EncryptType(self):
        """敏感信息加密类型:
RSA: rsa非对称加密，使用RSA-PKCS1-v1_5
AES: aes对称加密，使用AES256-CBC-PCKS7padding
缺省: RSA
        :rtype: str
        """
        return self._EncryptType

    @EncryptType.setter
    def EncryptType(self, EncryptType):
        self._EncryptType = EncryptType

    @property
    def MidasEnvironment(self):
        """环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment

    @property
    def AgencyClientInfo(self):
        """经办人信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.AgencyClientInfo`
        """
        return self._AgencyClientInfo

    @AgencyClientInfo.setter
    def AgencyClientInfo(self, AgencyClientInfo):
        self._AgencyClientInfo = AgencyClientInfo


    def _deserialize(self, params):
        self._MidasAppId = params.get("MidasAppId")
        self._SubAppId = params.get("SubAppId")
        self._BindType = params.get("BindType")
        self._SettleAcctNo = params.get("SettleAcctNo")
        self._SettleAcctName = params.get("SettleAcctName")
        self._SettleAcctType = params.get("SettleAcctType")
        self._IdType = params.get("IdType")
        self._IdCode = params.get("IdCode")
        self._AcctBranchName = params.get("AcctBranchName")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        self._Mobile = params.get("Mobile")
        self._CnapsBranchId = params.get("CnapsBranchId")
        self._EiconBankBranchId = params.get("EiconBankBranchId")
        self._EncryptType = params.get("EncryptType")
        self._MidasEnvironment = params.get("MidasEnvironment")
        if params.get("AgencyClientInfo") is not None:
            self._AgencyClientInfo = AgencyClientInfo()
            self._AgencyClientInfo._deserialize(params.get("AgencyClientInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindAcctResponse(AbstractModel):
    """BindAcct返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BindOpenBankExternalSubMerchantBankAccountRequest(AbstractModel):
    """BindOpenBankExternalSubMerchantBankAccount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 渠道商户ID。
        :type ChannelMerchantId: str
        :param _ChannelSubMerchantId: 渠道子商户ID。
        :type ChannelSubMerchantId: str
        :param _ChannelName: 渠道名称。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :type ChannelName: str
        :param _PaymentMethod: 支付方式。
__EBANK_PAYMENT__: ebank支付
__OPENBANK_PAYMENT__: openbank支付
        :type PaymentMethod: str
        :param _ExternalSubMerchantBindBankAccountData: 第三方渠道子商户收款方银行卡信息, 为JSON格式字符串。详情见附录-复杂类型。
        :type ExternalSubMerchantBindBankAccountData: str
        :param _OutApplyId: 外部申请编号。
        :type OutApplyId: str
        :param _NotifyUrl: 通知地址。
        :type NotifyUrl: str
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._ChannelSubMerchantId = None
        self._ChannelName = None
        self._PaymentMethod = None
        self._ExternalSubMerchantBindBankAccountData = None
        self._OutApplyId = None
        self._NotifyUrl = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """渠道商户ID。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户ID。
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def ChannelName(self):
        """渠道名称。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PaymentMethod(self):
        """支付方式。
__EBANK_PAYMENT__: ebank支付
__OPENBANK_PAYMENT__: openbank支付
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def ExternalSubMerchantBindBankAccountData(self):
        """第三方渠道子商户收款方银行卡信息, 为JSON格式字符串。详情见附录-复杂类型。
        :rtype: str
        """
        return self._ExternalSubMerchantBindBankAccountData

    @ExternalSubMerchantBindBankAccountData.setter
    def ExternalSubMerchantBindBankAccountData(self, ExternalSubMerchantBindBankAccountData):
        self._ExternalSubMerchantBindBankAccountData = ExternalSubMerchantBindBankAccountData

    @property
    def OutApplyId(self):
        """外部申请编号。
        :rtype: str
        """
        return self._OutApplyId

    @OutApplyId.setter
    def OutApplyId(self, OutApplyId):
        self._OutApplyId = OutApplyId

    @property
    def NotifyUrl(self):
        """通知地址。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._PaymentMethod = params.get("PaymentMethod")
        self._ExternalSubMerchantBindBankAccountData = params.get("ExternalSubMerchantBindBankAccountData")
        self._OutApplyId = params.get("OutApplyId")
        self._NotifyUrl = params.get("NotifyUrl")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindOpenBankExternalSubMerchantBankAccountResponse(AbstractModel):
    """BindOpenBankExternalSubMerchantBankAccount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :type ErrCode: str
        :param _ErrMessage: 错误消息。
        :type ErrMessage: str
        :param _Result: 返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.BindOpenBankExternalSubMerchantBankAccountResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.BindOpenBankExternalSubMerchantBankAccountResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = BindOpenBankExternalSubMerchantBankAccountResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class BindOpenBankExternalSubMerchantBankAccountResult(AbstractModel):
    """第三方子商户银行卡绑定返回结果

    """

    def __init__(self):
        r"""
        :param _ChannelApplyId: 渠道申请编号。
        :type ChannelApplyId: str
        :param _BindStatus: 绑定状态。
__SUCCESS__: 绑定成功
__FAILED__: 绑定失败
__PROCESSING__: 绑定中。
注意：若返回绑定中，需要再次调用绑定结果查询接口,查询结果。
        :type BindStatus: str
        :param _BindMessage: 绑定返回描述, 例如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :type BindMessage: str
        :param _ExternalSubMerchantBankAccountReturnData: 渠道子商户银行账户信息, 为JSON格式字符串（绑定成功状态下返回）。详情见附录-复杂类型。
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalSubMerchantBankAccountReturnData: str
        :param _BindSerialNo: 绑卡序列号。
注意：此字段可能返回 null，表示取不到有效值。
        :type BindSerialNo: str
        """
        self._ChannelApplyId = None
        self._BindStatus = None
        self._BindMessage = None
        self._ExternalSubMerchantBankAccountReturnData = None
        self._BindSerialNo = None

    @property
    def ChannelApplyId(self):
        """渠道申请编号。
        :rtype: str
        """
        return self._ChannelApplyId

    @ChannelApplyId.setter
    def ChannelApplyId(self, ChannelApplyId):
        self._ChannelApplyId = ChannelApplyId

    @property
    def BindStatus(self):
        """绑定状态。
__SUCCESS__: 绑定成功
__FAILED__: 绑定失败
__PROCESSING__: 绑定中。
注意：若返回绑定中，需要再次调用绑定结果查询接口,查询结果。
        :rtype: str
        """
        return self._BindStatus

    @BindStatus.setter
    def BindStatus(self, BindStatus):
        self._BindStatus = BindStatus

    @property
    def BindMessage(self):
        """绑定返回描述, 例如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BindMessage

    @BindMessage.setter
    def BindMessage(self, BindMessage):
        self._BindMessage = BindMessage

    @property
    def ExternalSubMerchantBankAccountReturnData(self):
        """渠道子商户银行账户信息, 为JSON格式字符串（绑定成功状态下返回）。详情见附录-复杂类型。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalSubMerchantBankAccountReturnData

    @ExternalSubMerchantBankAccountReturnData.setter
    def ExternalSubMerchantBankAccountReturnData(self, ExternalSubMerchantBankAccountReturnData):
        self._ExternalSubMerchantBankAccountReturnData = ExternalSubMerchantBankAccountReturnData

    @property
    def BindSerialNo(self):
        """绑卡序列号。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BindSerialNo

    @BindSerialNo.setter
    def BindSerialNo(self, BindSerialNo):
        self._BindSerialNo = BindSerialNo


    def _deserialize(self, params):
        self._ChannelApplyId = params.get("ChannelApplyId")
        self._BindStatus = params.get("BindStatus")
        self._BindMessage = params.get("BindMessage")
        self._ExternalSubMerchantBankAccountReturnData = params.get("ExternalSubMerchantBankAccountReturnData")
        self._BindSerialNo = params.get("BindSerialNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindOpenBankProfitSharePayeeRequest(AbstractModel):
    """BindOpenBankProfitSharePayee请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 渠道商户号。代理商/集团ID
        :type ChannelMerchantId: str
        :param _AccountNo: 收款人银行账户号。唯一
        :type AccountNo: str
        :param _ChannelName: 渠道名称
通联国际: CNP
        :type ChannelName: str
        :param _ChannelSubMerchantId: 渠道子商户号。商户ID
        :type ChannelSubMerchantId: str
        :param _NotifyUrl: 绑定状态通知地址,若为空，即不回调通知。
        :type NotifyUrl: str
        :param _ProfitSharePayeeInfo: 分账收款人信息。通联国际必选
        :type ProfitSharePayeeInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankProfitSharePayeeInfo`
        :param _ExternalProfitSharingData: 第三方拓展信息。若无特殊说明，可为空
        :type ExternalProfitSharingData: str
        :param _Environment: 接入环境。沙箱环境填 sandbox。缺省默认调用生产环境
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._AccountNo = None
        self._ChannelName = None
        self._ChannelSubMerchantId = None
        self._NotifyUrl = None
        self._ProfitSharePayeeInfo = None
        self._ExternalProfitSharingData = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """渠道商户号。代理商/集团ID
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def AccountNo(self):
        """收款人银行账户号。唯一
        :rtype: str
        """
        return self._AccountNo

    @AccountNo.setter
    def AccountNo(self, AccountNo):
        self._AccountNo = AccountNo

    @property
    def ChannelName(self):
        """渠道名称
通联国际: CNP
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户号。商户ID
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def NotifyUrl(self):
        """绑定状态通知地址,若为空，即不回调通知。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def ProfitSharePayeeInfo(self):
        """分账收款人信息。通联国际必选
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankProfitSharePayeeInfo`
        """
        return self._ProfitSharePayeeInfo

    @ProfitSharePayeeInfo.setter
    def ProfitSharePayeeInfo(self, ProfitSharePayeeInfo):
        self._ProfitSharePayeeInfo = ProfitSharePayeeInfo

    @property
    def ExternalProfitSharingData(self):
        """第三方拓展信息。若无特殊说明，可为空
        :rtype: str
        """
        return self._ExternalProfitSharingData

    @ExternalProfitSharingData.setter
    def ExternalProfitSharingData(self, ExternalProfitSharingData):
        self._ExternalProfitSharingData = ExternalProfitSharingData

    @property
    def Environment(self):
        """接入环境。沙箱环境填 sandbox。缺省默认调用生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._AccountNo = params.get("AccountNo")
        self._ChannelName = params.get("ChannelName")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._NotifyUrl = params.get("NotifyUrl")
        if params.get("ProfitSharePayeeInfo") is not None:
            self._ProfitSharePayeeInfo = OpenBankProfitSharePayeeInfo()
            self._ProfitSharePayeeInfo._deserialize(params.get("ProfitSharePayeeInfo"))
        self._ExternalProfitSharingData = params.get("ExternalProfitSharingData")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindOpenBankProfitSharePayeeResponse(AbstractModel):
    """BindOpenBankProfitSharePayee返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
        :type ErrCode: str
        :param _ErrMessage: 错误信息。
        :type ErrMessage: str
        :param _Result: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.BindOpenBankProfitSharePayeeResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误信息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.BindOpenBankProfitSharePayeeResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = BindOpenBankProfitSharePayeeResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class BindOpenBankProfitSharePayeeResult(AbstractModel):
    """绑定分账收款方响应

    """

    def __init__(self):
        r"""
        :param _AccountId: 账户ID。受益人ID
        :type AccountId: str
        :param _AccountNo: 账户号，通联渠道指客户银行账号
        :type AccountNo: str
        :param _Currency: 账户货币。参考附录“币种类型”。
        :type Currency: str
        """
        self._AccountId = None
        self._AccountNo = None
        self._Currency = None

    @property
    def AccountId(self):
        """账户ID。受益人ID
        :rtype: str
        """
        return self._AccountId

    @AccountId.setter
    def AccountId(self, AccountId):
        self._AccountId = AccountId

    @property
    def AccountNo(self):
        """账户号，通联渠道指客户银行账号
        :rtype: str
        """
        return self._AccountNo

    @AccountNo.setter
    def AccountNo(self, AccountNo):
        self._AccountNo = AccountNo

    @property
    def Currency(self):
        """账户货币。参考附录“币种类型”。
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency


    def _deserialize(self, params):
        self._AccountId = params.get("AccountId")
        self._AccountNo = params.get("AccountNo")
        self._Currency = params.get("Currency")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindRelateAccReUnionPayRequest(AbstractModel):
    """BindRelateAccReUnionPay请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MrchCode: String(22)，商户号（签约客户号）
        :type MrchCode: str
        :param _TranNetMemberCode: STRING(32)，交易网会员代码（若需要把一个待绑定账户关联到两个会员名下，此字段可上送两个会员的交易网代码，并且须用“|::|”（右侧）进行分隔）
        :type TranNetMemberCode: str
        :param _MemberAcctNo: STRING(50)，会员的待绑定账户的账号（即 BindRelateAcctUnionPay接口中的“会员的待绑定账户的账号”）
        :type MemberAcctNo: str
        :param _MessageCheckCode: STRING(20)，短信验证码（即 BindRelateAcctUnionPay接口中的手机所接收到的短信验证码）
        :type MessageCheckCode: str
        :param _ReservedMsg: STRING(1027)，保留域
        :type ReservedMsg: str
        :param _Profile: STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :type Profile: str
        """
        self._MrchCode = None
        self._TranNetMemberCode = None
        self._MemberAcctNo = None
        self._MessageCheckCode = None
        self._ReservedMsg = None
        self._Profile = None

    @property
    def MrchCode(self):
        """String(22)，商户号（签约客户号）
        :rtype: str
        """
        return self._MrchCode

    @MrchCode.setter
    def MrchCode(self, MrchCode):
        self._MrchCode = MrchCode

    @property
    def TranNetMemberCode(self):
        """STRING(32)，交易网会员代码（若需要把一个待绑定账户关联到两个会员名下，此字段可上送两个会员的交易网代码，并且须用“|::|”（右侧）进行分隔）
        :rtype: str
        """
        return self._TranNetMemberCode

    @TranNetMemberCode.setter
    def TranNetMemberCode(self, TranNetMemberCode):
        self._TranNetMemberCode = TranNetMemberCode

    @property
    def MemberAcctNo(self):
        """STRING(50)，会员的待绑定账户的账号（即 BindRelateAcctUnionPay接口中的“会员的待绑定账户的账号”）
        :rtype: str
        """
        return self._MemberAcctNo

    @MemberAcctNo.setter
    def MemberAcctNo(self, MemberAcctNo):
        self._MemberAcctNo = MemberAcctNo

    @property
    def MessageCheckCode(self):
        """STRING(20)，短信验证码（即 BindRelateAcctUnionPay接口中的手机所接收到的短信验证码）
        :rtype: str
        """
        return self._MessageCheckCode

    @MessageCheckCode.setter
    def MessageCheckCode(self, MessageCheckCode):
        self._MessageCheckCode = MessageCheckCode

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def Profile(self):
        """STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._MrchCode = params.get("MrchCode")
        self._TranNetMemberCode = params.get("TranNetMemberCode")
        self._MemberAcctNo = params.get("MemberAcctNo")
        self._MessageCheckCode = params.get("MessageCheckCode")
        self._ReservedMsg = params.get("ReservedMsg")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindRelateAccReUnionPayResponse(AbstractModel):
    """BindRelateAccReUnionPay返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FrontSeqNo: STRING(52)，见证系统流水号
注意：此字段可能返回 null，表示取不到有效值。
        :type FrontSeqNo: str
        :param _ReservedMsg: STRING(1027)，保留域
注意：此字段可能返回 null，表示取不到有效值。
        :type ReservedMsg: str
        :param _TxnReturnCode: String(20)，返回码
        :type TxnReturnCode: str
        :param _TxnReturnMsg: String(100)，返回信息
        :type TxnReturnMsg: str
        :param _CnsmrSeqNo: String(22)，交易流水号
        :type CnsmrSeqNo: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FrontSeqNo = None
        self._ReservedMsg = None
        self._TxnReturnCode = None
        self._TxnReturnMsg = None
        self._CnsmrSeqNo = None
        self._RequestId = None

    @property
    def FrontSeqNo(self):
        """STRING(52)，见证系统流水号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FrontSeqNo

    @FrontSeqNo.setter
    def FrontSeqNo(self, FrontSeqNo):
        self._FrontSeqNo = FrontSeqNo

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def TxnReturnCode(self):
        """String(20)，返回码
        :rtype: str
        """
        return self._TxnReturnCode

    @TxnReturnCode.setter
    def TxnReturnCode(self, TxnReturnCode):
        self._TxnReturnCode = TxnReturnCode

    @property
    def TxnReturnMsg(self):
        """String(100)，返回信息
        :rtype: str
        """
        return self._TxnReturnMsg

    @TxnReturnMsg.setter
    def TxnReturnMsg(self, TxnReturnMsg):
        self._TxnReturnMsg = TxnReturnMsg

    @property
    def CnsmrSeqNo(self):
        """String(22)，交易流水号
        :rtype: str
        """
        return self._CnsmrSeqNo

    @CnsmrSeqNo.setter
    def CnsmrSeqNo(self, CnsmrSeqNo):
        self._CnsmrSeqNo = CnsmrSeqNo

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FrontSeqNo = params.get("FrontSeqNo")
        self._ReservedMsg = params.get("ReservedMsg")
        self._TxnReturnCode = params.get("TxnReturnCode")
        self._TxnReturnMsg = params.get("TxnReturnMsg")
        self._CnsmrSeqNo = params.get("CnsmrSeqNo")
        self._RequestId = params.get("RequestId")


class BindRelateAcctSmallAmountRequest(AbstractModel):
    """BindRelateAcctSmallAmount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MrchCode: String(22)，商户号（签约客户号）
        :type MrchCode: str
        :param _TranNetMemberCode: STRING(32)，交易网会员代码（若需要把一个待绑定账户关联到两个会员名下，此字段可上送两个会员的交易网代码，并且须用“|::|”(右侧)进行分隔）
        :type TranNetMemberCode: str
        :param _MemberName: STRING(150)，见证子账户的户名（首次绑定的情况下，此字段即为待绑定的提现账户的户名。非首次绑定的情况下，须注意带绑定的提现账户的户名须与留存在后台系统的会员户名一致）
        :type MemberName: str
        :param _MemberGlobalType: STRING(5)，会员证件类型（详情见“常见问题”）
        :type MemberGlobalType: str
        :param _MemberGlobalId: STRING(32)，会员证件号码
        :type MemberGlobalId: str
        :param _MemberAcctNo: STRING(50)，会员的待绑定账户的账号（提现的银行卡）
        :type MemberAcctNo: str
        :param _BankType: STRING(10)，会员的待绑定账户的本他行类型（1: 本行; 2: 他行）
        :type BankType: str
        :param _AcctOpenBranchName: STRING(150)，会员的待绑定账户的开户行名称
        :type AcctOpenBranchName: str
        :param _Mobile: STRING(30)，会员的手机号（手机号须由长度为11位的数字构成）
        :type Mobile: str
        :param _CnapsBranchId: STRING(20)，会员的待绑定账户的开户行的联行号（本他行类型为他行的情况下，此字段和下一个字段至少一个不为空）
        :type CnapsBranchId: str
        :param _EiconBankBranchId: STRING(20)，会员的待绑定账户的开户行的超级网银行号（本他行类型为他行的情况下，此字段和上一个字段至少一个不为空）
        :type EiconBankBranchId: str
        :param _ReservedMsg: STRING(1027)，转账方式（1: 往账鉴权(默认值); 2: 来账鉴权）
        :type ReservedMsg: str
        :param _Profile: STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :type Profile: str
        """
        self._MrchCode = None
        self._TranNetMemberCode = None
        self._MemberName = None
        self._MemberGlobalType = None
        self._MemberGlobalId = None
        self._MemberAcctNo = None
        self._BankType = None
        self._AcctOpenBranchName = None
        self._Mobile = None
        self._CnapsBranchId = None
        self._EiconBankBranchId = None
        self._ReservedMsg = None
        self._Profile = None

    @property
    def MrchCode(self):
        """String(22)，商户号（签约客户号）
        :rtype: str
        """
        return self._MrchCode

    @MrchCode.setter
    def MrchCode(self, MrchCode):
        self._MrchCode = MrchCode

    @property
    def TranNetMemberCode(self):
        """STRING(32)，交易网会员代码（若需要把一个待绑定账户关联到两个会员名下，此字段可上送两个会员的交易网代码，并且须用“|::|”(右侧)进行分隔）
        :rtype: str
        """
        return self._TranNetMemberCode

    @TranNetMemberCode.setter
    def TranNetMemberCode(self, TranNetMemberCode):
        self._TranNetMemberCode = TranNetMemberCode

    @property
    def MemberName(self):
        """STRING(150)，见证子账户的户名（首次绑定的情况下，此字段即为待绑定的提现账户的户名。非首次绑定的情况下，须注意带绑定的提现账户的户名须与留存在后台系统的会员户名一致）
        :rtype: str
        """
        return self._MemberName

    @MemberName.setter
    def MemberName(self, MemberName):
        self._MemberName = MemberName

    @property
    def MemberGlobalType(self):
        """STRING(5)，会员证件类型（详情见“常见问题”）
        :rtype: str
        """
        return self._MemberGlobalType

    @MemberGlobalType.setter
    def MemberGlobalType(self, MemberGlobalType):
        self._MemberGlobalType = MemberGlobalType

    @property
    def MemberGlobalId(self):
        """STRING(32)，会员证件号码
        :rtype: str
        """
        return self._MemberGlobalId

    @MemberGlobalId.setter
    def MemberGlobalId(self, MemberGlobalId):
        self._MemberGlobalId = MemberGlobalId

    @property
    def MemberAcctNo(self):
        """STRING(50)，会员的待绑定账户的账号（提现的银行卡）
        :rtype: str
        """
        return self._MemberAcctNo

    @MemberAcctNo.setter
    def MemberAcctNo(self, MemberAcctNo):
        self._MemberAcctNo = MemberAcctNo

    @property
    def BankType(self):
        """STRING(10)，会员的待绑定账户的本他行类型（1: 本行; 2: 他行）
        :rtype: str
        """
        return self._BankType

    @BankType.setter
    def BankType(self, BankType):
        self._BankType = BankType

    @property
    def AcctOpenBranchName(self):
        """STRING(150)，会员的待绑定账户的开户行名称
        :rtype: str
        """
        return self._AcctOpenBranchName

    @AcctOpenBranchName.setter
    def AcctOpenBranchName(self, AcctOpenBranchName):
        self._AcctOpenBranchName = AcctOpenBranchName

    @property
    def Mobile(self):
        """STRING(30)，会员的手机号（手机号须由长度为11位的数字构成）
        :rtype: str
        """
        return self._Mobile

    @Mobile.setter
    def Mobile(self, Mobile):
        self._Mobile = Mobile

    @property
    def CnapsBranchId(self):
        """STRING(20)，会员的待绑定账户的开户行的联行号（本他行类型为他行的情况下，此字段和下一个字段至少一个不为空）
        :rtype: str
        """
        return self._CnapsBranchId

    @CnapsBranchId.setter
    def CnapsBranchId(self, CnapsBranchId):
        self._CnapsBranchId = CnapsBranchId

    @property
    def EiconBankBranchId(self):
        """STRING(20)，会员的待绑定账户的开户行的超级网银行号（本他行类型为他行的情况下，此字段和上一个字段至少一个不为空）
        :rtype: str
        """
        return self._EiconBankBranchId

    @EiconBankBranchId.setter
    def EiconBankBranchId(self, EiconBankBranchId):
        self._EiconBankBranchId = EiconBankBranchId

    @property
    def ReservedMsg(self):
        """STRING(1027)，转账方式（1: 往账鉴权(默认值); 2: 来账鉴权）
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def Profile(self):
        """STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._MrchCode = params.get("MrchCode")
        self._TranNetMemberCode = params.get("TranNetMemberCode")
        self._MemberName = params.get("MemberName")
        self._MemberGlobalType = params.get("MemberGlobalType")
        self._MemberGlobalId = params.get("MemberGlobalId")
        self._MemberAcctNo = params.get("MemberAcctNo")
        self._BankType = params.get("BankType")
        self._AcctOpenBranchName = params.get("AcctOpenBranchName")
        self._Mobile = params.get("Mobile")
        self._CnapsBranchId = params.get("CnapsBranchId")
        self._EiconBankBranchId = params.get("EiconBankBranchId")
        self._ReservedMsg = params.get("ReservedMsg")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindRelateAcctSmallAmountResponse(AbstractModel):
    """BindRelateAcctSmallAmount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TxnReturnCode: String(20)，返回码
        :type TxnReturnCode: str
        :param _TxnReturnMsg: String(100)，返回信息
        :type TxnReturnMsg: str
        :param _CnsmrSeqNo: String(22)，交易流水号
        :type CnsmrSeqNo: str
        :param _ReservedMsg: STRING(1027)，保留域（来账鉴权的方式下，此字段的值为客户需往监管账户转入的金额。在同名子账户绑定的场景下，若返回""VERIFIED""则说明无需验证直接绑定成功）
注意：此字段可能返回 null，表示取不到有效值。
        :type ReservedMsg: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TxnReturnCode = None
        self._TxnReturnMsg = None
        self._CnsmrSeqNo = None
        self._ReservedMsg = None
        self._RequestId = None

    @property
    def TxnReturnCode(self):
        """String(20)，返回码
        :rtype: str
        """
        return self._TxnReturnCode

    @TxnReturnCode.setter
    def TxnReturnCode(self, TxnReturnCode):
        self._TxnReturnCode = TxnReturnCode

    @property
    def TxnReturnMsg(self):
        """String(100)，返回信息
        :rtype: str
        """
        return self._TxnReturnMsg

    @TxnReturnMsg.setter
    def TxnReturnMsg(self, TxnReturnMsg):
        self._TxnReturnMsg = TxnReturnMsg

    @property
    def CnsmrSeqNo(self):
        """String(22)，交易流水号
        :rtype: str
        """
        return self._CnsmrSeqNo

    @CnsmrSeqNo.setter
    def CnsmrSeqNo(self, CnsmrSeqNo):
        self._CnsmrSeqNo = CnsmrSeqNo

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域（来账鉴权的方式下，此字段的值为客户需往监管账户转入的金额。在同名子账户绑定的场景下，若返回""VERIFIED""则说明无需验证直接绑定成功）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TxnReturnCode = params.get("TxnReturnCode")
        self._TxnReturnMsg = params.get("TxnReturnMsg")
        self._CnsmrSeqNo = params.get("CnsmrSeqNo")
        self._ReservedMsg = params.get("ReservedMsg")
        self._RequestId = params.get("RequestId")


class BindRelateAcctUnionPayRequest(AbstractModel):
    """BindRelateAcctUnionPay请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TranNetMemberCode: STRING(32)，交易网会员代码（若需要把一个待绑定账户关联到两个会员名下，此字段可上送两个会员的交易网代码，并且须用“|::|”（右侧）进行分隔）
        :type TranNetMemberCode: str
        :param _MemberName: STRING(150)，见证子账户的户名（首次绑定的情况下，此字段即为待绑定的提现账户的户名。非首次绑定的情况下，须注意带绑定的提现账户的户名须与留存在后台系统的会员户名一致）
        :type MemberName: str
        :param _MemberGlobalType: STRING(5)，会员证件类型（详情见“常见问题”）
        :type MemberGlobalType: str
        :param _MemberGlobalId: STRING(32)，会员证件号码
        :type MemberGlobalId: str
        :param _MemberAcctNo: STRING(50)，会员的待绑定账户的账号（提现的银行卡）
        :type MemberAcctNo: str
        :param _BankType: STRING(10)，会员的待绑定账户的本他行类型（1: 本行; 2: 他行）
        :type BankType: str
        :param _AcctOpenBranchName: STRING(150)，会员的待绑定账户的开户行名称（若大小额行号不填则送超级网银号对应的银行名称，若填大小额行号则送大小额行号对应的银行名称）
        :type AcctOpenBranchName: str
        :param _Mobile: STRING(30)，会员的手机号（手机号须由长度为11位的数字构成）
        :type Mobile: str
        :param _MrchCode: String(22)，商户号（签约客户号）
        :type MrchCode: str
        :param _CnapsBranchId: STRING(20)，会员的待绑定账户的开户行的联行号（本他行类型为他行的情况下，此字段和下一个字段至少一个不为空）
        :type CnapsBranchId: str
        :param _EiconBankBranchId: STRING(20)，会员的待绑定账户的开户行的超级网银行号（本他行类型为他行的情况下，此字段和上一个字段至少一个不为空）
        :type EiconBankBranchId: str
        :param _ReservedMsg: STRING(1027)，保留域
        :type ReservedMsg: str
        :param _Profile: STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :type Profile: str
        """
        self._TranNetMemberCode = None
        self._MemberName = None
        self._MemberGlobalType = None
        self._MemberGlobalId = None
        self._MemberAcctNo = None
        self._BankType = None
        self._AcctOpenBranchName = None
        self._Mobile = None
        self._MrchCode = None
        self._CnapsBranchId = None
        self._EiconBankBranchId = None
        self._ReservedMsg = None
        self._Profile = None

    @property
    def TranNetMemberCode(self):
        """STRING(32)，交易网会员代码（若需要把一个待绑定账户关联到两个会员名下，此字段可上送两个会员的交易网代码，并且须用“|::|”（右侧）进行分隔）
        :rtype: str
        """
        return self._TranNetMemberCode

    @TranNetMemberCode.setter
    def TranNetMemberCode(self, TranNetMemberCode):
        self._TranNetMemberCode = TranNetMemberCode

    @property
    def MemberName(self):
        """STRING(150)，见证子账户的户名（首次绑定的情况下，此字段即为待绑定的提现账户的户名。非首次绑定的情况下，须注意带绑定的提现账户的户名须与留存在后台系统的会员户名一致）
        :rtype: str
        """
        return self._MemberName

    @MemberName.setter
    def MemberName(self, MemberName):
        self._MemberName = MemberName

    @property
    def MemberGlobalType(self):
        """STRING(5)，会员证件类型（详情见“常见问题”）
        :rtype: str
        """
        return self._MemberGlobalType

    @MemberGlobalType.setter
    def MemberGlobalType(self, MemberGlobalType):
        self._MemberGlobalType = MemberGlobalType

    @property
    def MemberGlobalId(self):
        """STRING(32)，会员证件号码
        :rtype: str
        """
        return self._MemberGlobalId

    @MemberGlobalId.setter
    def MemberGlobalId(self, MemberGlobalId):
        self._MemberGlobalId = MemberGlobalId

    @property
    def MemberAcctNo(self):
        """STRING(50)，会员的待绑定账户的账号（提现的银行卡）
        :rtype: str
        """
        return self._MemberAcctNo

    @MemberAcctNo.setter
    def MemberAcctNo(self, MemberAcctNo):
        self._MemberAcctNo = MemberAcctNo

    @property
    def BankType(self):
        """STRING(10)，会员的待绑定账户的本他行类型（1: 本行; 2: 他行）
        :rtype: str
        """
        return self._BankType

    @BankType.setter
    def BankType(self, BankType):
        self._BankType = BankType

    @property
    def AcctOpenBranchName(self):
        """STRING(150)，会员的待绑定账户的开户行名称（若大小额行号不填则送超级网银号对应的银行名称，若填大小额行号则送大小额行号对应的银行名称）
        :rtype: str
        """
        return self._AcctOpenBranchName

    @AcctOpenBranchName.setter
    def AcctOpenBranchName(self, AcctOpenBranchName):
        self._AcctOpenBranchName = AcctOpenBranchName

    @property
    def Mobile(self):
        """STRING(30)，会员的手机号（手机号须由长度为11位的数字构成）
        :rtype: str
        """
        return self._Mobile

    @Mobile.setter
    def Mobile(self, Mobile):
        self._Mobile = Mobile

    @property
    def MrchCode(self):
        """String(22)，商户号（签约客户号）
        :rtype: str
        """
        return self._MrchCode

    @MrchCode.setter
    def MrchCode(self, MrchCode):
        self._MrchCode = MrchCode

    @property
    def CnapsBranchId(self):
        """STRING(20)，会员的待绑定账户的开户行的联行号（本他行类型为他行的情况下，此字段和下一个字段至少一个不为空）
        :rtype: str
        """
        return self._CnapsBranchId

    @CnapsBranchId.setter
    def CnapsBranchId(self, CnapsBranchId):
        self._CnapsBranchId = CnapsBranchId

    @property
    def EiconBankBranchId(self):
        """STRING(20)，会员的待绑定账户的开户行的超级网银行号（本他行类型为他行的情况下，此字段和上一个字段至少一个不为空）
        :rtype: str
        """
        return self._EiconBankBranchId

    @EiconBankBranchId.setter
    def EiconBankBranchId(self, EiconBankBranchId):
        self._EiconBankBranchId = EiconBankBranchId

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def Profile(self):
        """STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._TranNetMemberCode = params.get("TranNetMemberCode")
        self._MemberName = params.get("MemberName")
        self._MemberGlobalType = params.get("MemberGlobalType")
        self._MemberGlobalId = params.get("MemberGlobalId")
        self._MemberAcctNo = params.get("MemberAcctNo")
        self._BankType = params.get("BankType")
        self._AcctOpenBranchName = params.get("AcctOpenBranchName")
        self._Mobile = params.get("Mobile")
        self._MrchCode = params.get("MrchCode")
        self._CnapsBranchId = params.get("CnapsBranchId")
        self._EiconBankBranchId = params.get("EiconBankBranchId")
        self._ReservedMsg = params.get("ReservedMsg")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindRelateAcctUnionPayResponse(AbstractModel):
    """BindRelateAcctUnionPay返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReservedMsg: STRING(1027)，保留域（在同名子账户绑定的场景下，若返回"VERIFIED"则说明无需验证直接绑定成功）
注意：此字段可能返回 null，表示取不到有效值。
        :type ReservedMsg: str
        :param _TxnReturnCode: String(20)，返回码
        :type TxnReturnCode: str
        :param _TxnReturnMsg: String(100)，返回信息
        :type TxnReturnMsg: str
        :param _CnsmrSeqNo: String(22)，交易流水号
        :type CnsmrSeqNo: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReservedMsg = None
        self._TxnReturnCode = None
        self._TxnReturnMsg = None
        self._CnsmrSeqNo = None
        self._RequestId = None

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域（在同名子账户绑定的场景下，若返回"VERIFIED"则说明无需验证直接绑定成功）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def TxnReturnCode(self):
        """String(20)，返回码
        :rtype: str
        """
        return self._TxnReturnCode

    @TxnReturnCode.setter
    def TxnReturnCode(self, TxnReturnCode):
        self._TxnReturnCode = TxnReturnCode

    @property
    def TxnReturnMsg(self):
        """String(100)，返回信息
        :rtype: str
        """
        return self._TxnReturnMsg

    @TxnReturnMsg.setter
    def TxnReturnMsg(self, TxnReturnMsg):
        self._TxnReturnMsg = TxnReturnMsg

    @property
    def CnsmrSeqNo(self):
        """String(22)，交易流水号
        :rtype: str
        """
        return self._CnsmrSeqNo

    @CnsmrSeqNo.setter
    def CnsmrSeqNo(self, CnsmrSeqNo):
        self._CnsmrSeqNo = CnsmrSeqNo

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ReservedMsg = params.get("ReservedMsg")
        self._TxnReturnCode = params.get("TxnReturnCode")
        self._TxnReturnMsg = params.get("TxnReturnMsg")
        self._CnsmrSeqNo = params.get("CnsmrSeqNo")
        self._RequestId = params.get("RequestId")


class BusinessLicenseInfo(AbstractModel):
    """营业证件信息

    """

    def __init__(self):
        r"""
        :param _BusinessLicenseType: 营业证件类型
 IDCARD：身份证
 CREDITCODE：统一社会信用代码
        :type BusinessLicenseType: str
        :param _BusinessLicenseNumber: 营业证件号码 非个人商户上送统一社会信用代码，个人商户上送身份证号码
        :type BusinessLicenseNumber: str
        :param _BusinessLicenseValidityType: 营业证件有效期类型 
LONGTERM：长期有效
OTHER：非长期有效
        :type BusinessLicenseValidityType: str
        :param _BusinessLicenseEffectiveDate: 营业证件生效日期，yyyy-MM-dd
        :type BusinessLicenseEffectiveDate: str
        :param _BusinessLicenseExpireDate: 营业证件失效日期，yyyy-MM-dd
        :type BusinessLicenseExpireDate: str
        """
        self._BusinessLicenseType = None
        self._BusinessLicenseNumber = None
        self._BusinessLicenseValidityType = None
        self._BusinessLicenseEffectiveDate = None
        self._BusinessLicenseExpireDate = None

    @property
    def BusinessLicenseType(self):
        """营业证件类型
 IDCARD：身份证
 CREDITCODE：统一社会信用代码
        :rtype: str
        """
        return self._BusinessLicenseType

    @BusinessLicenseType.setter
    def BusinessLicenseType(self, BusinessLicenseType):
        self._BusinessLicenseType = BusinessLicenseType

    @property
    def BusinessLicenseNumber(self):
        """营业证件号码 非个人商户上送统一社会信用代码，个人商户上送身份证号码
        :rtype: str
        """
        return self._BusinessLicenseNumber

    @BusinessLicenseNumber.setter
    def BusinessLicenseNumber(self, BusinessLicenseNumber):
        self._BusinessLicenseNumber = BusinessLicenseNumber

    @property
    def BusinessLicenseValidityType(self):
        """营业证件有效期类型 
LONGTERM：长期有效
OTHER：非长期有效
        :rtype: str
        """
        return self._BusinessLicenseValidityType

    @BusinessLicenseValidityType.setter
    def BusinessLicenseValidityType(self, BusinessLicenseValidityType):
        self._BusinessLicenseValidityType = BusinessLicenseValidityType

    @property
    def BusinessLicenseEffectiveDate(self):
        """营业证件生效日期，yyyy-MM-dd
        :rtype: str
        """
        return self._BusinessLicenseEffectiveDate

    @BusinessLicenseEffectiveDate.setter
    def BusinessLicenseEffectiveDate(self, BusinessLicenseEffectiveDate):
        self._BusinessLicenseEffectiveDate = BusinessLicenseEffectiveDate

    @property
    def BusinessLicenseExpireDate(self):
        """营业证件失效日期，yyyy-MM-dd
        :rtype: str
        """
        return self._BusinessLicenseExpireDate

    @BusinessLicenseExpireDate.setter
    def BusinessLicenseExpireDate(self, BusinessLicenseExpireDate):
        self._BusinessLicenseExpireDate = BusinessLicenseExpireDate


    def _deserialize(self, params):
        self._BusinessLicenseType = params.get("BusinessLicenseType")
        self._BusinessLicenseNumber = params.get("BusinessLicenseNumber")
        self._BusinessLicenseValidityType = params.get("BusinessLicenseValidityType")
        self._BusinessLicenseEffectiveDate = params.get("BusinessLicenseEffectiveDate")
        self._BusinessLicenseExpireDate = params.get("BusinessLicenseExpireDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChannelContractInfo(AbstractModel):
    """米大师内部存放的合约信息

    """

    def __init__(self):
        r"""
        :param _OutContractCode: 外部合约协议号
        :type OutContractCode: str
        :param _ChannelContractCode: 米大师内部生成的合约协议号
        :type ChannelContractCode: str
        """
        self._OutContractCode = None
        self._ChannelContractCode = None

    @property
    def OutContractCode(self):
        """外部合约协议号
        :rtype: str
        """
        return self._OutContractCode

    @OutContractCode.setter
    def OutContractCode(self, OutContractCode):
        self._OutContractCode = OutContractCode

    @property
    def ChannelContractCode(self):
        """米大师内部生成的合约协议号
        :rtype: str
        """
        return self._ChannelContractCode

    @ChannelContractCode.setter
    def ChannelContractCode(self, ChannelContractCode):
        self._ChannelContractCode = ChannelContractCode


    def _deserialize(self, params):
        self._OutContractCode = params.get("OutContractCode")
        self._ChannelContractCode = params.get("ChannelContractCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChannelReturnContractInfo(AbstractModel):
    """米大师内部生成的合约信息

    """

    def __init__(self):
        r"""
        :param _ContractStatus: 平台合约状态
协议状态，枚举值：
CONTRACT_STATUS_SIGNED：已签约
CONTRACT_STATUS_TERMINATED：未签约
CONTRACT_STATUS_PENDING：签约进行中
        :type ContractStatus: str
        :param _ChannelContractInfo: 米大师内部存放的合约信息
        :type ChannelContractInfo: :class:`tencentcloud.cpdp.v20190820.models.ChannelContractInfo`
        """
        self._ContractStatus = None
        self._ChannelContractInfo = None

    @property
    def ContractStatus(self):
        """平台合约状态
协议状态，枚举值：
CONTRACT_STATUS_SIGNED：已签约
CONTRACT_STATUS_TERMINATED：未签约
CONTRACT_STATUS_PENDING：签约进行中
        :rtype: str
        """
        return self._ContractStatus

    @ContractStatus.setter
    def ContractStatus(self, ContractStatus):
        self._ContractStatus = ContractStatus

    @property
    def ChannelContractInfo(self):
        """米大师内部存放的合约信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ChannelContractInfo`
        """
        return self._ChannelContractInfo

    @ChannelContractInfo.setter
    def ChannelContractInfo(self, ChannelContractInfo):
        self._ChannelContractInfo = ChannelContractInfo


    def _deserialize(self, params):
        self._ContractStatus = params.get("ContractStatus")
        if params.get("ChannelContractInfo") is not None:
            self._ChannelContractInfo = ChannelContractInfo()
            self._ChannelContractInfo._deserialize(params.get("ChannelContractInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAcctRequest(AbstractModel):
    """CheckAcct请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MidasAppId: 聚鑫分配的支付主MidasAppId
        :type MidasAppId: str
        :param _SubAppId: 聚鑫计费SubAppId，代表子商户
        :type SubAppId: str
        :param _BindType: 1 – 小额转账验证
2 – 短信验证
每个结算账户每天只能使用一次小额转账验证
        :type BindType: int
        :param _SettleAcctNo: 结算账户账号
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type SettleAcctNo: str
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasSignature: 按照聚鑫安全密钥计算的签名
        :type MidasSignature: str
        :param _CheckCode: 短信验证码或指令号
BindType==2必填，平安渠道必填
        :type CheckCode: str
        :param _CurrencyType: 币种 RMB
BindType==1必填
        :type CurrencyType: str
        :param _CurrencyUnit: 单位
1：元，2：角，3：分
BindType==1必填
        :type CurrencyUnit: int
        :param _CurrencyAmt: 金额
BindType==1必填
        :type CurrencyAmt: str
        :param _EncryptType: 敏感信息加密类型:
RSA: rsa非对称加密，使用RSA-PKCS1-v1_5
AES: aes对称加密，使用AES256-CBC-PCKS7padding
缺省: RSA
        :type EncryptType: str
        :param _MidasEnvironment: 环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type MidasEnvironment: str
        """
        self._MidasAppId = None
        self._SubAppId = None
        self._BindType = None
        self._SettleAcctNo = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._CheckCode = None
        self._CurrencyType = None
        self._CurrencyUnit = None
        self._CurrencyAmt = None
        self._EncryptType = None
        self._MidasEnvironment = None

    @property
    def MidasAppId(self):
        """聚鑫分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def SubAppId(self):
        """聚鑫计费SubAppId，代表子商户
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def BindType(self):
        """1 – 小额转账验证
2 – 短信验证
每个结算账户每天只能使用一次小额转账验证
        :rtype: int
        """
        return self._BindType

    @BindType.setter
    def BindType(self, BindType):
        self._BindType = BindType

    @property
    def SettleAcctNo(self):
        """结算账户账号
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._SettleAcctNo

    @SettleAcctNo.setter
    def SettleAcctNo(self, SettleAcctNo):
        self._SettleAcctNo = SettleAcctNo

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """按照聚鑫安全密钥计算的签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def CheckCode(self):
        """短信验证码或指令号
BindType==2必填，平安渠道必填
        :rtype: str
        """
        return self._CheckCode

    @CheckCode.setter
    def CheckCode(self, CheckCode):
        self._CheckCode = CheckCode

    @property
    def CurrencyType(self):
        """币种 RMB
BindType==1必填
        :rtype: str
        """
        return self._CurrencyType

    @CurrencyType.setter
    def CurrencyType(self, CurrencyType):
        self._CurrencyType = CurrencyType

    @property
    def CurrencyUnit(self):
        """单位
1：元，2：角，3：分
BindType==1必填
        :rtype: int
        """
        return self._CurrencyUnit

    @CurrencyUnit.setter
    def CurrencyUnit(self, CurrencyUnit):
        self._CurrencyUnit = CurrencyUnit

    @property
    def CurrencyAmt(self):
        """金额
BindType==1必填
        :rtype: str
        """
        return self._CurrencyAmt

    @CurrencyAmt.setter
    def CurrencyAmt(self, CurrencyAmt):
        self._CurrencyAmt = CurrencyAmt

    @property
    def EncryptType(self):
        """敏感信息加密类型:
RSA: rsa非对称加密，使用RSA-PKCS1-v1_5
AES: aes对称加密，使用AES256-CBC-PCKS7padding
缺省: RSA
        :rtype: str
        """
        return self._EncryptType

    @EncryptType.setter
    def EncryptType(self, EncryptType):
        self._EncryptType = EncryptType

    @property
    def MidasEnvironment(self):
        """环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment


    def _deserialize(self, params):
        self._MidasAppId = params.get("MidasAppId")
        self._SubAppId = params.get("SubAppId")
        self._BindType = params.get("BindType")
        self._SettleAcctNo = params.get("SettleAcctNo")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        self._CheckCode = params.get("CheckCode")
        self._CurrencyType = params.get("CurrencyType")
        self._CurrencyUnit = params.get("CurrencyUnit")
        self._CurrencyAmt = params.get("CurrencyAmt")
        self._EncryptType = params.get("EncryptType")
        self._MidasEnvironment = params.get("MidasEnvironment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAcctResponse(AbstractModel):
    """CheckAcct返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FrontSeqNo: 前置流水号，请保存
        :type FrontSeqNo: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FrontSeqNo = None
        self._RequestId = None

    @property
    def FrontSeqNo(self):
        """前置流水号，请保存
        :rtype: str
        """
        return self._FrontSeqNo

    @FrontSeqNo.setter
    def FrontSeqNo(self, FrontSeqNo):
        self._FrontSeqNo = FrontSeqNo

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FrontSeqNo = params.get("FrontSeqNo")
        self._RequestId = params.get("RequestId")


class CheckAmountRequest(AbstractModel):
    """CheckAmount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MrchCode: String(22)，商户号（签约客户号）
        :type MrchCode: str
        :param _TranNetMemberCode: STRING(32)，交易网会员代码（若需要把一个待绑定账户关联到两个会员名下，此字段可上送两个会员的交易网代码，并且须用“|::|”(右侧)进行分隔）
        :type TranNetMemberCode: str
        :param _TakeCashAcctNo: STRING(50)，会员的待绑定账户的账号（即 BindRelateAcctSmallAmount接口中的“会员的待绑定账户的账号”）
        :type TakeCashAcctNo: str
        :param _AuthAmt: STRING(20)，鉴权验证金额（即 BindRelateAcctSmallAmount接口中的“会员的待绑定账户收到的验证金额。原小额转账鉴权方式为来账鉴权的情况下此字段须赋值为0.00）
        :type AuthAmt: str
        :param _Ccy: STRING(3)，币种（默认为RMB）
        :type Ccy: str
        :param _ReservedMsg: STRING(1027)，原小额转账方式（1: 往账鉴权，此为默认值; 2: 来账鉴权）
        :type ReservedMsg: str
        :param _Profile: STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :type Profile: str
        """
        self._MrchCode = None
        self._TranNetMemberCode = None
        self._TakeCashAcctNo = None
        self._AuthAmt = None
        self._Ccy = None
        self._ReservedMsg = None
        self._Profile = None

    @property
    def MrchCode(self):
        """String(22)，商户号（签约客户号）
        :rtype: str
        """
        return self._MrchCode

    @MrchCode.setter
    def MrchCode(self, MrchCode):
        self._MrchCode = MrchCode

    @property
    def TranNetMemberCode(self):
        """STRING(32)，交易网会员代码（若需要把一个待绑定账户关联到两个会员名下，此字段可上送两个会员的交易网代码，并且须用“|::|”(右侧)进行分隔）
        :rtype: str
        """
        return self._TranNetMemberCode

    @TranNetMemberCode.setter
    def TranNetMemberCode(self, TranNetMemberCode):
        self._TranNetMemberCode = TranNetMemberCode

    @property
    def TakeCashAcctNo(self):
        """STRING(50)，会员的待绑定账户的账号（即 BindRelateAcctSmallAmount接口中的“会员的待绑定账户的账号”）
        :rtype: str
        """
        return self._TakeCashAcctNo

    @TakeCashAcctNo.setter
    def TakeCashAcctNo(self, TakeCashAcctNo):
        self._TakeCashAcctNo = TakeCashAcctNo

    @property
    def AuthAmt(self):
        """STRING(20)，鉴权验证金额（即 BindRelateAcctSmallAmount接口中的“会员的待绑定账户收到的验证金额。原小额转账鉴权方式为来账鉴权的情况下此字段须赋值为0.00）
        :rtype: str
        """
        return self._AuthAmt

    @AuthAmt.setter
    def AuthAmt(self, AuthAmt):
        self._AuthAmt = AuthAmt

    @property
    def Ccy(self):
        """STRING(3)，币种（默认为RMB）
        :rtype: str
        """
        return self._Ccy

    @Ccy.setter
    def Ccy(self, Ccy):
        self._Ccy = Ccy

    @property
    def ReservedMsg(self):
        """STRING(1027)，原小额转账方式（1: 往账鉴权，此为默认值; 2: 来账鉴权）
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def Profile(self):
        """STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._MrchCode = params.get("MrchCode")
        self._TranNetMemberCode = params.get("TranNetMemberCode")
        self._TakeCashAcctNo = params.get("TakeCashAcctNo")
        self._AuthAmt = params.get("AuthAmt")
        self._Ccy = params.get("Ccy")
        self._ReservedMsg = params.get("ReservedMsg")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAmountResponse(AbstractModel):
    """CheckAmount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TxnReturnCode: String(20)，返回码
        :type TxnReturnCode: str
        :param _TxnReturnMsg: String(100)，返回信息
        :type TxnReturnMsg: str
        :param _CnsmrSeqNo: String(22)，交易流水号
        :type CnsmrSeqNo: str
        :param _FrontSeqNo: STRING(52)，见证系统流水号（即电商见证宝系统生成的流水号，可关联具体一笔请求）
        :type FrontSeqNo: str
        :param _ReservedMsg: STRING(1027)，保留域
        :type ReservedMsg: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TxnReturnCode = None
        self._TxnReturnMsg = None
        self._CnsmrSeqNo = None
        self._FrontSeqNo = None
        self._ReservedMsg = None
        self._RequestId = None

    @property
    def TxnReturnCode(self):
        """String(20)，返回码
        :rtype: str
        """
        return self._TxnReturnCode

    @TxnReturnCode.setter
    def TxnReturnCode(self, TxnReturnCode):
        self._TxnReturnCode = TxnReturnCode

    @property
    def TxnReturnMsg(self):
        """String(100)，返回信息
        :rtype: str
        """
        return self._TxnReturnMsg

    @TxnReturnMsg.setter
    def TxnReturnMsg(self, TxnReturnMsg):
        self._TxnReturnMsg = TxnReturnMsg

    @property
    def CnsmrSeqNo(self):
        """String(22)，交易流水号
        :rtype: str
        """
        return self._CnsmrSeqNo

    @CnsmrSeqNo.setter
    def CnsmrSeqNo(self, CnsmrSeqNo):
        self._CnsmrSeqNo = CnsmrSeqNo

    @property
    def FrontSeqNo(self):
        """STRING(52)，见证系统流水号（即电商见证宝系统生成的流水号，可关联具体一笔请求）
        :rtype: str
        """
        return self._FrontSeqNo

    @FrontSeqNo.setter
    def FrontSeqNo(self, FrontSeqNo):
        self._FrontSeqNo = FrontSeqNo

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TxnReturnCode = params.get("TxnReturnCode")
        self._TxnReturnMsg = params.get("TxnReturnMsg")
        self._CnsmrSeqNo = params.get("CnsmrSeqNo")
        self._FrontSeqNo = params.get("FrontSeqNo")
        self._ReservedMsg = params.get("ReservedMsg")
        self._RequestId = params.get("RequestId")


class CityCodeResult(AbstractModel):
    """查询城市编码响应对象

    """

    def __init__(self):
        r"""
        :param _CityId: 城市编码cityid，数字与字母的结合
注意：此字段可能返回 null，表示取不到有效值。
        :type CityId: str
        :param _Province: 省份
注意：此字段可能返回 null，表示取不到有效值。
        :type Province: str
        :param _District: 县区
注意：此字段可能返回 null，表示取不到有效值。
        :type District: str
        :param _City: 城市
注意：此字段可能返回 null，表示取不到有效值。
        :type City: str
        """
        self._CityId = None
        self._Province = None
        self._District = None
        self._City = None

    @property
    def CityId(self):
        """城市编码cityid，数字与字母的结合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CityId

    @CityId.setter
    def CityId(self, CityId):
        self._CityId = CityId

    @property
    def Province(self):
        """省份
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Province

    @Province.setter
    def Province(self, Province):
        self._Province = Province

    @property
    def District(self):
        """县区
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._District

    @District.setter
    def District(self, District):
        self._District = District

    @property
    def City(self):
        """城市
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._City

    @City.setter
    def City(self, City):
        self._City = City


    def _deserialize(self, params):
        self._CityId = params.get("CityId")
        self._Province = params.get("Province")
        self._District = params.get("District")
        self._City = params.get("City")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClearItem(AbstractModel):
    """银行在途清算结果信息

    """

    def __init__(self):
        r"""
        :param _Date: STRING(8)，日期（格式: 20190101）
注意：此字段可能返回 null，表示取不到有效值。
        :type Date: str
        :param _SubAcctType: STRING(40)，子账号类型（子帐号类型。1: 普通会员子账号; 2: 挂账子账号; 3: 手续费子账号; 4: 利息子账号; 5: 平台担保子账号; 7: 在途; 8: 理财购买子帐号; 9: 理财赎回子帐号; 10: 平台子拥有结算子帐号）
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAcctType: str
        :param _ReconcileStatus: STRING(3)，对账状态（0: 成功; 1: 失败）
注意：此字段可能返回 null，表示取不到有效值。
        :type ReconcileStatus: str
        :param _ReconcileReturnMsg: STRING(300)，对账返回信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ReconcileReturnMsg: str
        :param _ClearingStatus: STRING(20)，清算状态（0: 成功; 1: 失败; 2: 异常; 3: 待处理）
注意：此字段可能返回 null，表示取不到有效值。
        :type ClearingStatus: str
        :param _ClearingReturnMsg: STRING(2)，清算返回信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ClearingReturnMsg: str
        :param _TotalAmt: STRING(300)，待清算总金额
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalAmt: str
        """
        self._Date = None
        self._SubAcctType = None
        self._ReconcileStatus = None
        self._ReconcileReturnMsg = None
        self._ClearingStatus = None
        self._ClearingReturnMsg = None
        self._TotalAmt = None

    @property
    def Date(self):
        """STRING(8)，日期（格式: 20190101）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def SubAcctType(self):
        """STRING(40)，子账号类型（子帐号类型。1: 普通会员子账号; 2: 挂账子账号; 3: 手续费子账号; 4: 利息子账号; 5: 平台担保子账号; 7: 在途; 8: 理财购买子帐号; 9: 理财赎回子帐号; 10: 平台子拥有结算子帐号）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAcctType

    @SubAcctType.setter
    def SubAcctType(self, SubAcctType):
        self._SubAcctType = SubAcctType

    @property
    def ReconcileStatus(self):
        """STRING(3)，对账状态（0: 成功; 1: 失败）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReconcileStatus

    @ReconcileStatus.setter
    def ReconcileStatus(self, ReconcileStatus):
        self._ReconcileStatus = ReconcileStatus

    @property
    def ReconcileReturnMsg(self):
        """STRING(300)，对账返回信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReconcileReturnMsg

    @ReconcileReturnMsg.setter
    def ReconcileReturnMsg(self, ReconcileReturnMsg):
        self._ReconcileReturnMsg = ReconcileReturnMsg

    @property
    def ClearingStatus(self):
        """STRING(20)，清算状态（0: 成功; 1: 失败; 2: 异常; 3: 待处理）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClearingStatus

    @ClearingStatus.setter
    def ClearingStatus(self, ClearingStatus):
        self._ClearingStatus = ClearingStatus

    @property
    def ClearingReturnMsg(self):
        """STRING(2)，清算返回信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClearingReturnMsg

    @ClearingReturnMsg.setter
    def ClearingReturnMsg(self, ClearingReturnMsg):
        self._ClearingReturnMsg = ClearingReturnMsg

    @property
    def TotalAmt(self):
        """STRING(300)，待清算总金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TotalAmt

    @TotalAmt.setter
    def TotalAmt(self, TotalAmt):
        self._TotalAmt = TotalAmt


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._SubAcctType = params.get("SubAcctType")
        self._ReconcileStatus = params.get("ReconcileStatus")
        self._ReconcileReturnMsg = params.get("ReconcileReturnMsg")
        self._ClearingStatus = params.get("ClearingStatus")
        self._ClearingReturnMsg = params.get("ClearingReturnMsg")
        self._TotalAmt = params.get("TotalAmt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseCloudOrderRequest(AbstractModel):
    """CloseCloudOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MidasAppId: 米大师分配的支付主MidasAppId
        :type MidasAppId: str
        :param _UserId: 用户Id，长度不小于5位，仅支持字母和数字的组合
        :type UserId: str
        :param _OutTradeNo: 开发者订单号
        :type OutTradeNo: str
        :param _MidasEnvironment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type MidasEnvironment: str
        """
        self._MidasAppId = None
        self._UserId = None
        self._OutTradeNo = None
        self._MidasEnvironment = None

    @property
    def MidasAppId(self):
        """米大师分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def UserId(self):
        """用户Id，长度不小于5位，仅支持字母和数字的组合
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def OutTradeNo(self):
        """开发者订单号
        :rtype: str
        """
        return self._OutTradeNo

    @OutTradeNo.setter
    def OutTradeNo(self, OutTradeNo):
        self._OutTradeNo = OutTradeNo

    @property
    def MidasEnvironment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment


    def _deserialize(self, params):
        self._MidasAppId = params.get("MidasAppId")
        self._UserId = params.get("UserId")
        self._OutTradeNo = params.get("OutTradeNo")
        self._MidasEnvironment = params.get("MidasEnvironment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseCloudOrderResponse(AbstractModel):
    """CloseCloudOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CloseOpenBankPaymentOrderRequest(AbstractModel):
    """CloseOpenBankPaymentOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 渠道商户ID，云企付平台下发给外部接入平台。
        :type ChannelMerchantId: str
        :param _OutOrderId: 外部商户订单号，与ChannelOrderId不能同时为空
        :type OutOrderId: str
        :param _ChannelOrderId: 云企付平台订单号，与OutOrderId不能同时为空
        :type ChannelOrderId: str
        :param _Environment: 接入环境。沙箱环境填 sandbox。缺省默认调用生产环境
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._OutOrderId = None
        self._ChannelOrderId = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """渠道商户ID，云企付平台下发给外部接入平台。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def OutOrderId(self):
        """外部商户订单号，与ChannelOrderId不能同时为空
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def ChannelOrderId(self):
        """云企付平台订单号，与OutOrderId不能同时为空
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def Environment(self):
        """接入环境。沙箱环境填 sandbox。缺省默认调用生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._OutOrderId = params.get("OutOrderId")
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseOpenBankPaymentOrderResponse(AbstractModel):
    """CloseOpenBankPaymentOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 业务系统返回码，SUCCESS表示成功，其他表示失败。
        :type ErrCode: str
        :param _ErrMessage: 业务系统返回消息
        :type ErrMessage: str
        :param _Result: 关单响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CloseOpenBankPaymentOrderResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """业务系统返回码，SUCCESS表示成功，其他表示失败。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """业务系统返回消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """关单响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CloseOpenBankPaymentOrderResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CloseOpenBankPaymentOrderResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CloseOpenBankPaymentOrderResult(AbstractModel):
    """云企付-关单响应

    """

    def __init__(self):
        r"""
        :param _OutOrderId: 外部商户订单号
        :type OutOrderId: str
        :param _ChannelOrderId: 云企付平台订单号
        :type ChannelOrderId: str
        :param _OrderStatus: 订单状态。关单成功CLOSED
        :type OrderStatus: str
        """
        self._OutOrderId = None
        self._ChannelOrderId = None
        self._OrderStatus = None

    @property
    def OutOrderId(self):
        """外部商户订单号
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def ChannelOrderId(self):
        """云企付平台订单号
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def OrderStatus(self):
        """订单状态。关单成功CLOSED
        :rtype: str
        """
        return self._OrderStatus

    @OrderStatus.setter
    def OrderStatus(self, OrderStatus):
        self._OrderStatus = OrderStatus


    def _deserialize(self, params):
        self._OutOrderId = params.get("OutOrderId")
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._OrderStatus = params.get("OrderStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseOrderRequest(AbstractModel):
    """CloseOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MidasAppId: 聚鑫分配的支付主MidasAppId
        :type MidasAppId: str
        :param _UserId: 用户ID，长度不小于5位， 仅支持字母和数字的组合
        :type UserId: str
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasSignature: 按照聚鑫安全密钥计算的签名
        :type MidasSignature: str
        :param _OutTradeNo: 业务订单号，OutTradeNo ， TransactionId二选一，不能都为空,优先使用 OutTradeNo
        :type OutTradeNo: str
        :param _TransactionId: 聚鑫订单号，OutTradeNo ， TransactionId二选一，不能都为空,优先使用 OutTradeNo
        :type TransactionId: str
        :param _MidasEnvironment: 环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type MidasEnvironment: str
        """
        self._MidasAppId = None
        self._UserId = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._OutTradeNo = None
        self._TransactionId = None
        self._MidasEnvironment = None

    @property
    def MidasAppId(self):
        """聚鑫分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def UserId(self):
        """用户ID，长度不小于5位， 仅支持字母和数字的组合
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """按照聚鑫安全密钥计算的签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def OutTradeNo(self):
        """业务订单号，OutTradeNo ， TransactionId二选一，不能都为空,优先使用 OutTradeNo
        :rtype: str
        """
        return self._OutTradeNo

    @OutTradeNo.setter
    def OutTradeNo(self, OutTradeNo):
        self._OutTradeNo = OutTradeNo

    @property
    def TransactionId(self):
        """聚鑫订单号，OutTradeNo ， TransactionId二选一，不能都为空,优先使用 OutTradeNo
        :rtype: str
        """
        return self._TransactionId

    @TransactionId.setter
    def TransactionId(self, TransactionId):
        self._TransactionId = TransactionId

    @property
    def MidasEnvironment(self):
        """环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment


    def _deserialize(self, params):
        self._MidasAppId = params.get("MidasAppId")
        self._UserId = params.get("UserId")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        self._OutTradeNo = params.get("OutTradeNo")
        self._TransactionId = params.get("TransactionId")
        self._MidasEnvironment = params.get("MidasEnvironment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseOrderResponse(AbstractModel):
    """CloseOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CloudAttachmentInfo(AbstractModel):
    """附加项信息对象

    """

    def __init__(self):
        r"""
        :param _AttachmentAmount: 附加项金额。
附加项的金额（必须是正数，单位：分），代表积分的数量、抵扣的金额、溢价的金额、补贴的金额
        :type AttachmentAmount: int
        :param _AttachmentType: 附加项类型。
Add：加项；
Sub：减项；
Point：积分项；
Subsidy：补贴项。
        :type AttachmentType: str
        :param _AttachmentName: 附加项名称。
当银行作为收单机构可能会对该字段有要求，请向米大师确认。
        :type AttachmentName: str
        :param _AttachmentCode: 附加项编号。
当银行作为收单机构可能会对该字段有要求，请向米大师确认。
        :type AttachmentCode: str
        """
        self._AttachmentAmount = None
        self._AttachmentType = None
        self._AttachmentName = None
        self._AttachmentCode = None

    @property
    def AttachmentAmount(self):
        """附加项金额。
附加项的金额（必须是正数，单位：分），代表积分的数量、抵扣的金额、溢价的金额、补贴的金额
        :rtype: int
        """
        return self._AttachmentAmount

    @AttachmentAmount.setter
    def AttachmentAmount(self, AttachmentAmount):
        self._AttachmentAmount = AttachmentAmount

    @property
    def AttachmentType(self):
        """附加项类型。
Add：加项；
Sub：减项；
Point：积分项；
Subsidy：补贴项。
        :rtype: str
        """
        return self._AttachmentType

    @AttachmentType.setter
    def AttachmentType(self, AttachmentType):
        self._AttachmentType = AttachmentType

    @property
    def AttachmentName(self):
        """附加项名称。
当银行作为收单机构可能会对该字段有要求，请向米大师确认。
        :rtype: str
        """
        return self._AttachmentName

    @AttachmentName.setter
    def AttachmentName(self, AttachmentName):
        self._AttachmentName = AttachmentName

    @property
    def AttachmentCode(self):
        """附加项编号。
当银行作为收单机构可能会对该字段有要求，请向米大师确认。
        :rtype: str
        """
        return self._AttachmentCode

    @AttachmentCode.setter
    def AttachmentCode(self, AttachmentCode):
        self._AttachmentCode = AttachmentCode


    def _deserialize(self, params):
        self._AttachmentAmount = params.get("AttachmentAmount")
        self._AttachmentType = params.get("AttachmentType")
        self._AttachmentName = params.get("AttachmentName")
        self._AttachmentCode = params.get("AttachmentCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudChannelExternalUserInfo(AbstractModel):
    """渠道方用户信息

    """

    def __init__(self):
        r"""
        :param _ChannelExternalUserType: 渠道方用户类型，枚举值:
WX_OPENID 微信支付类型
ALIPAY_BUYERID 支付宝支付类型
        :type ChannelExternalUserType: str
        :param _ChannelExternalUserId: 渠道方用户Id
        :type ChannelExternalUserId: str
        """
        self._ChannelExternalUserType = None
        self._ChannelExternalUserId = None

    @property
    def ChannelExternalUserType(self):
        """渠道方用户类型，枚举值:
WX_OPENID 微信支付类型
ALIPAY_BUYERID 支付宝支付类型
        :rtype: str
        """
        return self._ChannelExternalUserType

    @ChannelExternalUserType.setter
    def ChannelExternalUserType(self, ChannelExternalUserType):
        self._ChannelExternalUserType = ChannelExternalUserType

    @property
    def ChannelExternalUserId(self):
        """渠道方用户Id
        :rtype: str
        """
        return self._ChannelExternalUserId

    @ChannelExternalUserId.setter
    def ChannelExternalUserId(self, ChannelExternalUserId):
        self._ChannelExternalUserId = ChannelExternalUserId


    def _deserialize(self, params):
        self._ChannelExternalUserType = params.get("ChannelExternalUserType")
        self._ChannelExternalUserId = params.get("ChannelExternalUserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudClientInfo(AbstractModel):
    """客户端信息

    """

    def __init__(self):
        r"""
        :param _ClientType: 场景类型。
wechat_ecommerce渠道 - h5支付方式，此字段必填；
枚举值：
CLIENT_TYPE_UNKNOWN 未知;
CLIENT_TYPE_IOS ios系统;
CLIENT_TYPE_ANDROID 安卓系统;
CLIENT_TYPE_WAP WAP场景;
CLIENT_TYPE_H5 H5场景;
        :type ClientType: str
        :param _AppName: 应用名称。
        :type AppName: str
        :param _AppUrl: 网站URL。
        :type AppUrl: str
        :param _BundleId: IOS平台BundleID。
        :type BundleId: str
        :param _PackageName: Android平台PackageName
        :type PackageName: str
        """
        self._ClientType = None
        self._AppName = None
        self._AppUrl = None
        self._BundleId = None
        self._PackageName = None

    @property
    def ClientType(self):
        """场景类型。
wechat_ecommerce渠道 - h5支付方式，此字段必填；
枚举值：
CLIENT_TYPE_UNKNOWN 未知;
CLIENT_TYPE_IOS ios系统;
CLIENT_TYPE_ANDROID 安卓系统;
CLIENT_TYPE_WAP WAP场景;
CLIENT_TYPE_H5 H5场景;
        :rtype: str
        """
        return self._ClientType

    @ClientType.setter
    def ClientType(self, ClientType):
        self._ClientType = ClientType

    @property
    def AppName(self):
        """应用名称。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def AppUrl(self):
        """网站URL。
        :rtype: str
        """
        return self._AppUrl

    @AppUrl.setter
    def AppUrl(self, AppUrl):
        self._AppUrl = AppUrl

    @property
    def BundleId(self):
        """IOS平台BundleID。
        :rtype: str
        """
        return self._BundleId

    @BundleId.setter
    def BundleId(self, BundleId):
        self._BundleId = BundleId

    @property
    def PackageName(self):
        """Android平台PackageName
        :rtype: str
        """
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName


    def _deserialize(self, params):
        self._ClientType = params.get("ClientType")
        self._AppName = params.get("AppName")
        self._AppUrl = params.get("AppUrl")
        self._BundleId = params.get("BundleId")
        self._PackageName = params.get("PackageName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudExternalAttachmentData(AbstractModel):
    """渠道透传字段

    """

    def __init__(self):
        r"""
        :param _ChannelName: 渠道名
        :type ChannelName: str
        :param _AttachmentData: 渠道透传字段，由各个渠道自行定义
        :type AttachmentData: str
        """
        self._ChannelName = None
        self._AttachmentData = None

    @property
    def ChannelName(self):
        """渠道名
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def AttachmentData(self):
        """渠道透传字段，由各个渠道自行定义
        :rtype: str
        """
        return self._AttachmentData

    @AttachmentData.setter
    def AttachmentData(self, AttachmentData):
        self._AttachmentData = AttachmentData


    def _deserialize(self, params):
        self._ChannelName = params.get("ChannelName")
        self._AttachmentData = params.get("AttachmentData")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudExternalChannelData(AbstractModel):
    """第三方渠道数据信息

    """

    def __init__(self):
        r"""
        :param _ExternalChannelDataName: 第三方渠道数据名。
PAYMENT_ORDER_EXTERNAL_REQUEST_DATA: 支付下单请求数据
PAYMENT_ORDER_EXTERNAL_RETURN_DATA: 支付下单返回数据
PAYMENT_ORDER_EXTERNAL_NOTIFY_DATA: 支付通知数据
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalChannelDataName: str
        :param _ExternalChannelDataValue: 第三方渠道数据值。
当ExternalChannelDataType=PAYMENT时，反序列化格式请参考[ExternalChannelPaymentDataValue](https://dev.tke.midas.qq.com/juxin-doc-next/apidocs/external-channel-data/QueryExternalChannelData.html#externalchannelpaymentdatavalue)
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalChannelDataValue: str
        """
        self._ExternalChannelDataName = None
        self._ExternalChannelDataValue = None

    @property
    def ExternalChannelDataName(self):
        """第三方渠道数据名。
PAYMENT_ORDER_EXTERNAL_REQUEST_DATA: 支付下单请求数据
PAYMENT_ORDER_EXTERNAL_RETURN_DATA: 支付下单返回数据
PAYMENT_ORDER_EXTERNAL_NOTIFY_DATA: 支付通知数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalChannelDataName

    @ExternalChannelDataName.setter
    def ExternalChannelDataName(self, ExternalChannelDataName):
        self._ExternalChannelDataName = ExternalChannelDataName

    @property
    def ExternalChannelDataValue(self):
        """第三方渠道数据值。
当ExternalChannelDataType=PAYMENT时，反序列化格式请参考[ExternalChannelPaymentDataValue](https://dev.tke.midas.qq.com/juxin-doc-next/apidocs/external-channel-data/QueryExternalChannelData.html#externalchannelpaymentdatavalue)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalChannelDataValue

    @ExternalChannelDataValue.setter
    def ExternalChannelDataValue(self, ExternalChannelDataValue):
        self._ExternalChannelDataValue = ExternalChannelDataValue


    def _deserialize(self, params):
        self._ExternalChannelDataName = params.get("ExternalChannelDataName")
        self._ExternalChannelDataValue = params.get("ExternalChannelDataValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudExternalPromptGroup(AbstractModel):
    """渠道扩展促销信息

    """

    def __init__(self):
        r"""
        :param _ChannelName: 渠道名。
为米大师定义的枚举值：
wechat 微信渠道
        :type ChannelName: str
        :param _ExternalPromptInfoList: 渠道扩展促销信息列表，由各个渠道自行定义。
ChannelName为wechat时，组成为 <Wechat-ExternalPromptInfo>
        :type ExternalPromptInfoList: list of CloudExternalPromptInfo
        """
        self._ChannelName = None
        self._ExternalPromptInfoList = None

    @property
    def ChannelName(self):
        """渠道名。
为米大师定义的枚举值：
wechat 微信渠道
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def ExternalPromptInfoList(self):
        """渠道扩展促销信息列表，由各个渠道自行定义。
ChannelName为wechat时，组成为 <Wechat-ExternalPromptInfo>
        :rtype: list of CloudExternalPromptInfo
        """
        return self._ExternalPromptInfoList

    @ExternalPromptInfoList.setter
    def ExternalPromptInfoList(self, ExternalPromptInfoList):
        self._ExternalPromptInfoList = ExternalPromptInfoList


    def _deserialize(self, params):
        self._ChannelName = params.get("ChannelName")
        if params.get("ExternalPromptInfoList") is not None:
            self._ExternalPromptInfoList = []
            for item in params.get("ExternalPromptInfoList"):
                obj = CloudExternalPromptInfo()
                obj._deserialize(item)
                self._ExternalPromptInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudExternalPromptInfo(AbstractModel):
    """渠道扩展促销信息

    """

    def __init__(self):
        r"""
        :param _ExternalPromptType: 优惠商品信息类型。
        :type ExternalPromptType: str
        :param _ExternalPromptValue: 优惠商品信息数据。
        :type ExternalPromptValue: str
        :param _ExternalPromptName: 优惠商品名称。
        :type ExternalPromptName: str
        """
        self._ExternalPromptType = None
        self._ExternalPromptValue = None
        self._ExternalPromptName = None

    @property
    def ExternalPromptType(self):
        """优惠商品信息类型。
        :rtype: str
        """
        return self._ExternalPromptType

    @ExternalPromptType.setter
    def ExternalPromptType(self, ExternalPromptType):
        self._ExternalPromptType = ExternalPromptType

    @property
    def ExternalPromptValue(self):
        """优惠商品信息数据。
        :rtype: str
        """
        return self._ExternalPromptValue

    @ExternalPromptValue.setter
    def ExternalPromptValue(self, ExternalPromptValue):
        self._ExternalPromptValue = ExternalPromptValue

    @property
    def ExternalPromptName(self):
        """优惠商品名称。
        :rtype: str
        """
        return self._ExternalPromptName

    @ExternalPromptName.setter
    def ExternalPromptName(self, ExternalPromptName):
        self._ExternalPromptName = ExternalPromptName


    def _deserialize(self, params):
        self._ExternalPromptType = params.get("ExternalPromptType")
        self._ExternalPromptValue = params.get("ExternalPromptValue")
        self._ExternalPromptName = params.get("ExternalPromptName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudExternalUserInfo(AbstractModel):
    """渠道方用户信息

    """

    def __init__(self):
        r"""
        :param _ExternalUserType: 渠道方用户类型
        :type ExternalUserType: str
        :param _ExternalUserId: 渠道方用户ID
        :type ExternalUserId: str
        """
        self._ExternalUserType = None
        self._ExternalUserId = None

    @property
    def ExternalUserType(self):
        """渠道方用户类型
        :rtype: str
        """
        return self._ExternalUserType

    @ExternalUserType.setter
    def ExternalUserType(self, ExternalUserType):
        self._ExternalUserType = ExternalUserType

    @property
    def ExternalUserId(self):
        """渠道方用户ID
        :rtype: str
        """
        return self._ExternalUserId

    @ExternalUserId.setter
    def ExternalUserId(self, ExternalUserId):
        self._ExternalUserId = ExternalUserId


    def _deserialize(self, params):
        self._ExternalUserType = params.get("ExternalUserType")
        self._ExternalUserId = params.get("ExternalUserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudGlobalPayTimeInfo(AbstractModel):
    """全局支付时间信息

    """

    def __init__(self):
        r"""
        :param _StartTimestamp: 订单开始时间。
不指定时默认为当前时间。
        :type StartTimestamp: int
        :param _ExpireTimestamp: 订单结束时间。
逾期将会拒绝下单。不指定时默认为当前时间的7天后结束。
        :type ExpireTimestamp: int
        :param _TimeOffset: 时区。
不指定时默认为28800，表示北京时间（东八区）。
        :type TimeOffset: int
        """
        self._StartTimestamp = None
        self._ExpireTimestamp = None
        self._TimeOffset = None

    @property
    def StartTimestamp(self):
        """订单开始时间。
不指定时默认为当前时间。
        :rtype: int
        """
        return self._StartTimestamp

    @StartTimestamp.setter
    def StartTimestamp(self, StartTimestamp):
        self._StartTimestamp = StartTimestamp

    @property
    def ExpireTimestamp(self):
        """订单结束时间。
逾期将会拒绝下单。不指定时默认为当前时间的7天后结束。
        :rtype: int
        """
        return self._ExpireTimestamp

    @ExpireTimestamp.setter
    def ExpireTimestamp(self, ExpireTimestamp):
        self._ExpireTimestamp = ExpireTimestamp

    @property
    def TimeOffset(self):
        """时区。
不指定时默认为28800，表示北京时间（东八区）。
        :rtype: int
        """
        return self._TimeOffset

    @TimeOffset.setter
    def TimeOffset(self, TimeOffset):
        self._TimeOffset = TimeOffset


    def _deserialize(self, params):
        self._StartTimestamp = params.get("StartTimestamp")
        self._ExpireTimestamp = params.get("ExpireTimestamp")
        self._TimeOffset = params.get("TimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudOrderReturn(AbstractModel):
    """返回订单信息

    """

    def __init__(self):
        r"""
        :param _AppId: 米大师分配的支付主MidasAppId
        :type AppId: str
        :param _OutTradeNo: 开发者支付订单号
        :type OutTradeNo: str
        :param _SubOrderList: 调用下单接口传进来的子单列表
注意：此字段可能返回 null，表示取不到有效值。
        :type SubOrderList: list of CloudSubOrderReturn
        :param _TransactionId: 调用下单接口获取的米大师交易订单号
        :type TransactionId: str
        :param _UserId: 用户Id
        :type UserId: str
        :param _Channel: 支付渠道
wechat:微信支付
        :type Channel: str
        :param _ProductId: 物品Id
        :type ProductId: str
        :param _Metadata: 发货标识，由开发者在调用下单接口的时候传入
        :type Metadata: str
        :param _CurrencyType: ISO货币代码
        :type CurrencyType: str
        :param _Amt: 支付金额，单位：分
        :type Amt: int
        :param _OrderState: 订单状态
0:初始状态，获取米大师交易订单成功
1:拉起米大师支付页面成功，用户未支付
2:用户支付成功，正在发货
3:用户支付成功，发货失败
4:用户支付成功，发货成功
5:关单中
6:已关单
        :type OrderState: str
        :param _OrderTime: 下单时间，unix时间戳
        :type OrderTime: str
        :param _PayTime: 支付时间，unix时间戳
        :type PayTime: str
        :param _CallBackTime: 支付回调时间，unix时间戳
        :type CallBackTime: str
        :param _ChannelExternalOrderId: 支付机构订单号
        :type ChannelExternalOrderId: str
        :param _ChannelOrderId: 米大师内部渠道订单号
        :type ChannelOrderId: str
        :param _RefundFlag: 是否曾退款
        :type RefundFlag: str
        :param _CashAmt: 用户支付金额
        :type CashAmt: str
        :param _CouponAmt: 抵扣券金额
        :type CouponAmt: str
        :param _ProductName: 商品名称
        :type ProductName: str
        :param _SettleInfo: 结算信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SettleInfo: :class:`tencentcloud.cpdp.v20190820.models.CloudSettleInfo`
        :param _AttachmentInfoList: 附加项信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AttachmentInfoList: list of CloudAttachmentInfo
        :param _ChannelExternalUserInfoList: 渠道方返回的用户信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExternalUserInfoList: list of CloudChannelExternalUserInfo
        :param _ExternalReturnPromptGroupList: 渠道扩展促销列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnPromptGroupList: list of CloudExternalPromptGroup
        :param _SceneInfo: 场景扩展信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SceneInfo: str
        :param _SubAppId: 子应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAppId: str
        :param _PayScene: 支付场景
注意：此字段可能返回 null，表示取不到有效值。
        :type PayScene: str
        :param _PaymentMethod: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentMethod: str
        :param _TotalPlatformIncome: 平台应收金额
单位：分，需要注意的是，TotalAmt=TotalPlatformIncome+TotalMchIncome
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPlatformIncome: int
        :param _TotalMchIncome: 商户应收金额
单位：分，需要注意的是，TotalAmt=TotalPlatformIncome+TotalMchIncome
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalMchIncome: int
        """
        self._AppId = None
        self._OutTradeNo = None
        self._SubOrderList = None
        self._TransactionId = None
        self._UserId = None
        self._Channel = None
        self._ProductId = None
        self._Metadata = None
        self._CurrencyType = None
        self._Amt = None
        self._OrderState = None
        self._OrderTime = None
        self._PayTime = None
        self._CallBackTime = None
        self._ChannelExternalOrderId = None
        self._ChannelOrderId = None
        self._RefundFlag = None
        self._CashAmt = None
        self._CouponAmt = None
        self._ProductName = None
        self._SettleInfo = None
        self._AttachmentInfoList = None
        self._ChannelExternalUserInfoList = None
        self._ExternalReturnPromptGroupList = None
        self._SceneInfo = None
        self._SubAppId = None
        self._PayScene = None
        self._PaymentMethod = None
        self._TotalPlatformIncome = None
        self._TotalMchIncome = None

    @property
    def AppId(self):
        """米大师分配的支付主MidasAppId
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def OutTradeNo(self):
        """开发者支付订单号
        :rtype: str
        """
        return self._OutTradeNo

    @OutTradeNo.setter
    def OutTradeNo(self, OutTradeNo):
        self._OutTradeNo = OutTradeNo

    @property
    def SubOrderList(self):
        """调用下单接口传进来的子单列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CloudSubOrderReturn
        """
        return self._SubOrderList

    @SubOrderList.setter
    def SubOrderList(self, SubOrderList):
        self._SubOrderList = SubOrderList

    @property
    def TransactionId(self):
        """调用下单接口获取的米大师交易订单号
        :rtype: str
        """
        return self._TransactionId

    @TransactionId.setter
    def TransactionId(self, TransactionId):
        self._TransactionId = TransactionId

    @property
    def UserId(self):
        """用户Id
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Channel(self):
        """支付渠道
wechat:微信支付
        :rtype: str
        """
        return self._Channel

    @Channel.setter
    def Channel(self, Channel):
        self._Channel = Channel

    @property
    def ProductId(self):
        """物品Id
        :rtype: str
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def Metadata(self):
        """发货标识，由开发者在调用下单接口的时候传入
        :rtype: str
        """
        return self._Metadata

    @Metadata.setter
    def Metadata(self, Metadata):
        self._Metadata = Metadata

    @property
    def CurrencyType(self):
        """ISO货币代码
        :rtype: str
        """
        return self._CurrencyType

    @CurrencyType.setter
    def CurrencyType(self, CurrencyType):
        self._CurrencyType = CurrencyType

    @property
    def Amt(self):
        """支付金额，单位：分
        :rtype: int
        """
        return self._Amt

    @Amt.setter
    def Amt(self, Amt):
        self._Amt = Amt

    @property
    def OrderState(self):
        """订单状态
0:初始状态，获取米大师交易订单成功
1:拉起米大师支付页面成功，用户未支付
2:用户支付成功，正在发货
3:用户支付成功，发货失败
4:用户支付成功，发货成功
5:关单中
6:已关单
        :rtype: str
        """
        return self._OrderState

    @OrderState.setter
    def OrderState(self, OrderState):
        self._OrderState = OrderState

    @property
    def OrderTime(self):
        """下单时间，unix时间戳
        :rtype: str
        """
        return self._OrderTime

    @OrderTime.setter
    def OrderTime(self, OrderTime):
        self._OrderTime = OrderTime

    @property
    def PayTime(self):
        """支付时间，unix时间戳
        :rtype: str
        """
        return self._PayTime

    @PayTime.setter
    def PayTime(self, PayTime):
        self._PayTime = PayTime

    @property
    def CallBackTime(self):
        """支付回调时间，unix时间戳
        :rtype: str
        """
        return self._CallBackTime

    @CallBackTime.setter
    def CallBackTime(self, CallBackTime):
        self._CallBackTime = CallBackTime

    @property
    def ChannelExternalOrderId(self):
        """支付机构订单号
        :rtype: str
        """
        return self._ChannelExternalOrderId

    @ChannelExternalOrderId.setter
    def ChannelExternalOrderId(self, ChannelExternalOrderId):
        self._ChannelExternalOrderId = ChannelExternalOrderId

    @property
    def ChannelOrderId(self):
        """米大师内部渠道订单号
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def RefundFlag(self):
        """是否曾退款
        :rtype: str
        """
        return self._RefundFlag

    @RefundFlag.setter
    def RefundFlag(self, RefundFlag):
        self._RefundFlag = RefundFlag

    @property
    def CashAmt(self):
        """用户支付金额
        :rtype: str
        """
        return self._CashAmt

    @CashAmt.setter
    def CashAmt(self, CashAmt):
        self._CashAmt = CashAmt

    @property
    def CouponAmt(self):
        """抵扣券金额
        :rtype: str
        """
        return self._CouponAmt

    @CouponAmt.setter
    def CouponAmt(self, CouponAmt):
        self._CouponAmt = CouponAmt

    @property
    def ProductName(self):
        """商品名称
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def SettleInfo(self):
        """结算信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CloudSettleInfo`
        """
        return self._SettleInfo

    @SettleInfo.setter
    def SettleInfo(self, SettleInfo):
        self._SettleInfo = SettleInfo

    @property
    def AttachmentInfoList(self):
        """附加项信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CloudAttachmentInfo
        """
        return self._AttachmentInfoList

    @AttachmentInfoList.setter
    def AttachmentInfoList(self, AttachmentInfoList):
        self._AttachmentInfoList = AttachmentInfoList

    @property
    def ChannelExternalUserInfoList(self):
        """渠道方返回的用户信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CloudChannelExternalUserInfo
        """
        return self._ChannelExternalUserInfoList

    @ChannelExternalUserInfoList.setter
    def ChannelExternalUserInfoList(self, ChannelExternalUserInfoList):
        self._ChannelExternalUserInfoList = ChannelExternalUserInfoList

    @property
    def ExternalReturnPromptGroupList(self):
        """渠道扩展促销列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CloudExternalPromptGroup
        """
        return self._ExternalReturnPromptGroupList

    @ExternalReturnPromptGroupList.setter
    def ExternalReturnPromptGroupList(self, ExternalReturnPromptGroupList):
        self._ExternalReturnPromptGroupList = ExternalReturnPromptGroupList

    @property
    def SceneInfo(self):
        """场景扩展信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SceneInfo

    @SceneInfo.setter
    def SceneInfo(self, SceneInfo):
        self._SceneInfo = SceneInfo

    @property
    def SubAppId(self):
        """子应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def PayScene(self):
        """支付场景
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayScene

    @PayScene.setter
    def PayScene(self, PayScene):
        self._PayScene = PayScene

    @property
    def PaymentMethod(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def TotalPlatformIncome(self):
        """平台应收金额
单位：分，需要注意的是，TotalAmt=TotalPlatformIncome+TotalMchIncome
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalPlatformIncome

    @TotalPlatformIncome.setter
    def TotalPlatformIncome(self, TotalPlatformIncome):
        self._TotalPlatformIncome = TotalPlatformIncome

    @property
    def TotalMchIncome(self):
        """商户应收金额
单位：分，需要注意的是，TotalAmt=TotalPlatformIncome+TotalMchIncome
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalMchIncome

    @TotalMchIncome.setter
    def TotalMchIncome(self, TotalMchIncome):
        self._TotalMchIncome = TotalMchIncome


    def _deserialize(self, params):
        self._AppId = params.get("AppId")
        self._OutTradeNo = params.get("OutTradeNo")
        if params.get("SubOrderList") is not None:
            self._SubOrderList = []
            for item in params.get("SubOrderList"):
                obj = CloudSubOrderReturn()
                obj._deserialize(item)
                self._SubOrderList.append(obj)
        self._TransactionId = params.get("TransactionId")
        self._UserId = params.get("UserId")
        self._Channel = params.get("Channel")
        self._ProductId = params.get("ProductId")
        self._Metadata = params.get("Metadata")
        self._CurrencyType = params.get("CurrencyType")
        self._Amt = params.get("Amt")
        self._OrderState = params.get("OrderState")
        self._OrderTime = params.get("OrderTime")
        self._PayTime = params.get("PayTime")
        self._CallBackTime = params.get("CallBackTime")
        self._ChannelExternalOrderId = params.get("ChannelExternalOrderId")
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._RefundFlag = params.get("RefundFlag")
        self._CashAmt = params.get("CashAmt")
        self._CouponAmt = params.get("CouponAmt")
        self._ProductName = params.get("ProductName")
        if params.get("SettleInfo") is not None:
            self._SettleInfo = CloudSettleInfo()
            self._SettleInfo._deserialize(params.get("SettleInfo"))
        if params.get("AttachmentInfoList") is not None:
            self._AttachmentInfoList = []
            for item in params.get("AttachmentInfoList"):
                obj = CloudAttachmentInfo()
                obj._deserialize(item)
                self._AttachmentInfoList.append(obj)
        if params.get("ChannelExternalUserInfoList") is not None:
            self._ChannelExternalUserInfoList = []
            for item in params.get("ChannelExternalUserInfoList"):
                obj = CloudChannelExternalUserInfo()
                obj._deserialize(item)
                self._ChannelExternalUserInfoList.append(obj)
        if params.get("ExternalReturnPromptGroupList") is not None:
            self._ExternalReturnPromptGroupList = []
            for item in params.get("ExternalReturnPromptGroupList"):
                obj = CloudExternalPromptGroup()
                obj._deserialize(item)
                self._ExternalReturnPromptGroupList.append(obj)
        self._SceneInfo = params.get("SceneInfo")
        self._SubAppId = params.get("SubAppId")
        self._PayScene = params.get("PayScene")
        self._PaymentMethod = params.get("PaymentMethod")
        self._TotalPlatformIncome = params.get("TotalPlatformIncome")
        self._TotalMchIncome = params.get("TotalMchIncome")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudSettleInfo(AbstractModel):
    """结算信息对象

    """

    def __init__(self):
        r"""
        :param _NeedToBeConfirmed: 是否需要支付确认。
0: 不需要支付确认
1: 需要支付确认
传1时，需要在支付完成后成功调用了《支付确认》接口，该笔订单才会被清分出去
        :type NeedToBeConfirmed: int
        :param _ProfitSharing: 是否指定分账。
0: 不指定分账
1: 指定分账
        :type ProfitSharing: int
        """
        self._NeedToBeConfirmed = None
        self._ProfitSharing = None

    @property
    def NeedToBeConfirmed(self):
        """是否需要支付确认。
0: 不需要支付确认
1: 需要支付确认
传1时，需要在支付完成后成功调用了《支付确认》接口，该笔订单才会被清分出去
        :rtype: int
        """
        return self._NeedToBeConfirmed

    @NeedToBeConfirmed.setter
    def NeedToBeConfirmed(self, NeedToBeConfirmed):
        self._NeedToBeConfirmed = NeedToBeConfirmed

    @property
    def ProfitSharing(self):
        """是否指定分账。
0: 不指定分账
1: 指定分账
        :rtype: int
        """
        return self._ProfitSharing

    @ProfitSharing.setter
    def ProfitSharing(self, ProfitSharing):
        self._ProfitSharing = ProfitSharing


    def _deserialize(self, params):
        self._NeedToBeConfirmed = params.get("NeedToBeConfirmed")
        self._ProfitSharing = params.get("ProfitSharing")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudStoreInfo(AbstractModel):
    """门店信息

    """

    def __init__(self):
        r"""
        :param _StoreId: 门店ID。
        :type StoreId: str
        :param _StoreName: 门店名称。
        :type StoreName: str
        :param _StoreAddress: 门店地址。
        :type StoreAddress: str
        :param _StoreAreaCode: 门店地区代码。
        :type StoreAreaCode: str
        :param _StoreDeviceId: 设备ID。
wechat_ecommerce渠道 - h5支付方式，此字段必填。
        :type StoreDeviceId: str
        """
        self._StoreId = None
        self._StoreName = None
        self._StoreAddress = None
        self._StoreAreaCode = None
        self._StoreDeviceId = None

    @property
    def StoreId(self):
        """门店ID。
        :rtype: str
        """
        return self._StoreId

    @StoreId.setter
    def StoreId(self, StoreId):
        self._StoreId = StoreId

    @property
    def StoreName(self):
        """门店名称。
        :rtype: str
        """
        return self._StoreName

    @StoreName.setter
    def StoreName(self, StoreName):
        self._StoreName = StoreName

    @property
    def StoreAddress(self):
        """门店地址。
        :rtype: str
        """
        return self._StoreAddress

    @StoreAddress.setter
    def StoreAddress(self, StoreAddress):
        self._StoreAddress = StoreAddress

    @property
    def StoreAreaCode(self):
        """门店地区代码。
        :rtype: str
        """
        return self._StoreAreaCode

    @StoreAreaCode.setter
    def StoreAreaCode(self, StoreAreaCode):
        self._StoreAreaCode = StoreAreaCode

    @property
    def StoreDeviceId(self):
        """设备ID。
wechat_ecommerce渠道 - h5支付方式，此字段必填。
        :rtype: str
        """
        return self._StoreDeviceId

    @StoreDeviceId.setter
    def StoreDeviceId(self, StoreDeviceId):
        self._StoreDeviceId = StoreDeviceId


    def _deserialize(self, params):
        self._StoreId = params.get("StoreId")
        self._StoreName = params.get("StoreName")
        self._StoreAddress = params.get("StoreAddress")
        self._StoreAreaCode = params.get("StoreAreaCode")
        self._StoreDeviceId = params.get("StoreDeviceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudSubOrder(AbstractModel):
    """子订单对象

    """

    def __init__(self):
        r"""
        :param _SubOutTradeNo: 子订单号。
长度32个字符供参考，部分渠道存在长度更短的情况接入时请联系开发咨询。
        :type SubOutTradeNo: str
        :param _SubAppId: 支付子商户ID。
米大师计费SubAppId，代表子商户。
        :type SubAppId: str
        :param _ProductName: 商品名称。
业务自定义的子订单商品名称，无需URL编码，长度限制以具体所接入渠道为准。
        :type ProductName: str
        :param _ProductDetail: 商品详情。
业务自定义的子订单商品详情，无需URL编码，长度限制以具体所接入渠道为准。
        :type ProductDetail: str
        :param _PlatformIncome: 平台应收。
子订单平台应收金额，单位：分，需要注意的是Amt = PlatformIncome+SubMchIncome。
        :type PlatformIncome: int
        :param _SubMchIncome: 商户应收。
子订单结算应收金额，单位：分，需要注意的是Amt = PlatformIncome+SubMchIncome。
        :type SubMchIncome: int
        :param _Metadata: 透传字段。
发货标识，由开发者在调用米大师下单接口的 时候下发。
        :type Metadata: str
        :param _Amt: 支付金额。
子订单支付金额，需要注意的是Amt = PlatformIncome+SubMchIncome。
        :type Amt: int
        :param _OriginalAmt: 原始金额。
子订单原始金额，OriginalAmt>=Amt。
        :type OriginalAmt: int
        :param _WxSubMchId: 微信子商户号。
        :type WxSubMchId: str
        :param _SettleInfo: 结算信息。
例如是否需要分账、是否需要支付确认等。
        :type SettleInfo: :class:`tencentcloud.cpdp.v20190820.models.CloudSettleInfo`
        :param _AttachmentInfoList: 附加项信息列表。
例如溢价信息、抵扣信息、积分信息、补贴信息
通过该字段可以实现渠道方的优惠抵扣补贴等营销功能。
        :type AttachmentInfoList: list of CloudAttachmentInfo
        :param _ExternalAttachmentDataList: 渠道透传数据列表。
        :type ExternalAttachmentDataList: list of CloudExternalAttachmentData
        """
        self._SubOutTradeNo = None
        self._SubAppId = None
        self._ProductName = None
        self._ProductDetail = None
        self._PlatformIncome = None
        self._SubMchIncome = None
        self._Metadata = None
        self._Amt = None
        self._OriginalAmt = None
        self._WxSubMchId = None
        self._SettleInfo = None
        self._AttachmentInfoList = None
        self._ExternalAttachmentDataList = None

    @property
    def SubOutTradeNo(self):
        """子订单号。
长度32个字符供参考，部分渠道存在长度更短的情况接入时请联系开发咨询。
        :rtype: str
        """
        return self._SubOutTradeNo

    @SubOutTradeNo.setter
    def SubOutTradeNo(self, SubOutTradeNo):
        self._SubOutTradeNo = SubOutTradeNo

    @property
    def SubAppId(self):
        """支付子商户ID。
米大师计费SubAppId，代表子商户。
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def ProductName(self):
        """商品名称。
业务自定义的子订单商品名称，无需URL编码，长度限制以具体所接入渠道为准。
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def ProductDetail(self):
        """商品详情。
业务自定义的子订单商品详情，无需URL编码，长度限制以具体所接入渠道为准。
        :rtype: str
        """
        return self._ProductDetail

    @ProductDetail.setter
    def ProductDetail(self, ProductDetail):
        self._ProductDetail = ProductDetail

    @property
    def PlatformIncome(self):
        """平台应收。
子订单平台应收金额，单位：分，需要注意的是Amt = PlatformIncome+SubMchIncome。
        :rtype: int
        """
        return self._PlatformIncome

    @PlatformIncome.setter
    def PlatformIncome(self, PlatformIncome):
        self._PlatformIncome = PlatformIncome

    @property
    def SubMchIncome(self):
        """商户应收。
子订单结算应收金额，单位：分，需要注意的是Amt = PlatformIncome+SubMchIncome。
        :rtype: int
        """
        return self._SubMchIncome

    @SubMchIncome.setter
    def SubMchIncome(self, SubMchIncome):
        self._SubMchIncome = SubMchIncome

    @property
    def Metadata(self):
        """透传字段。
发货标识，由开发者在调用米大师下单接口的 时候下发。
        :rtype: str
        """
        return self._Metadata

    @Metadata.setter
    def Metadata(self, Metadata):
        self._Metadata = Metadata

    @property
    def Amt(self):
        """支付金额。
子订单支付金额，需要注意的是Amt = PlatformIncome+SubMchIncome。
        :rtype: int
        """
        return self._Amt

    @Amt.setter
    def Amt(self, Amt):
        self._Amt = Amt

    @property
    def OriginalAmt(self):
        """原始金额。
子订单原始金额，OriginalAmt>=Amt。
        :rtype: int
        """
        return self._OriginalAmt

    @OriginalAmt.setter
    def OriginalAmt(self, OriginalAmt):
        self._OriginalAmt = OriginalAmt

    @property
    def WxSubMchId(self):
        """微信子商户号。
        :rtype: str
        """
        return self._WxSubMchId

    @WxSubMchId.setter
    def WxSubMchId(self, WxSubMchId):
        self._WxSubMchId = WxSubMchId

    @property
    def SettleInfo(self):
        """结算信息。
例如是否需要分账、是否需要支付确认等。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CloudSettleInfo`
        """
        return self._SettleInfo

    @SettleInfo.setter
    def SettleInfo(self, SettleInfo):
        self._SettleInfo = SettleInfo

    @property
    def AttachmentInfoList(self):
        """附加项信息列表。
例如溢价信息、抵扣信息、积分信息、补贴信息
通过该字段可以实现渠道方的优惠抵扣补贴等营销功能。
        :rtype: list of CloudAttachmentInfo
        """
        return self._AttachmentInfoList

    @AttachmentInfoList.setter
    def AttachmentInfoList(self, AttachmentInfoList):
        self._AttachmentInfoList = AttachmentInfoList

    @property
    def ExternalAttachmentDataList(self):
        """渠道透传数据列表。
        :rtype: list of CloudExternalAttachmentData
        """
        return self._ExternalAttachmentDataList

    @ExternalAttachmentDataList.setter
    def ExternalAttachmentDataList(self, ExternalAttachmentDataList):
        self._ExternalAttachmentDataList = ExternalAttachmentDataList


    def _deserialize(self, params):
        self._SubOutTradeNo = params.get("SubOutTradeNo")
        self._SubAppId = params.get("SubAppId")
        self._ProductName = params.get("ProductName")
        self._ProductDetail = params.get("ProductDetail")
        self._PlatformIncome = params.get("PlatformIncome")
        self._SubMchIncome = params.get("SubMchIncome")
        self._Metadata = params.get("Metadata")
        self._Amt = params.get("Amt")
        self._OriginalAmt = params.get("OriginalAmt")
        self._WxSubMchId = params.get("WxSubMchId")
        if params.get("SettleInfo") is not None:
            self._SettleInfo = CloudSettleInfo()
            self._SettleInfo._deserialize(params.get("SettleInfo"))
        if params.get("AttachmentInfoList") is not None:
            self._AttachmentInfoList = []
            for item in params.get("AttachmentInfoList"):
                obj = CloudAttachmentInfo()
                obj._deserialize(item)
                self._AttachmentInfoList.append(obj)
        if params.get("ExternalAttachmentDataList") is not None:
            self._ExternalAttachmentDataList = []
            for item in params.get("ExternalAttachmentDataList"):
                obj = CloudExternalAttachmentData()
                obj._deserialize(item)
                self._ExternalAttachmentDataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudSubOrderRefund(AbstractModel):
    """退款子单

    """

    def __init__(self):
        r"""
        :param _RefundAmt: 子订单退款金额
        :type RefundAmt: int
        :param _PlatformRefundAmt: 平台应退金额
        :type PlatformRefundAmt: int
        :param _SubMchRefundAmt: 商家应退金额
        :type SubMchRefundAmt: int
        :param _SubOutTradeNo: 子订单号
        :type SubOutTradeNo: str
        :param _SubRefundId: 子退款单号，调用方需要保证全局唯一性
        :type SubRefundId: str
        """
        self._RefundAmt = None
        self._PlatformRefundAmt = None
        self._SubMchRefundAmt = None
        self._SubOutTradeNo = None
        self._SubRefundId = None

    @property
    def RefundAmt(self):
        """子订单退款金额
        :rtype: int
        """
        return self._RefundAmt

    @RefundAmt.setter
    def RefundAmt(self, RefundAmt):
        self._RefundAmt = RefundAmt

    @property
    def PlatformRefundAmt(self):
        """平台应退金额
        :rtype: int
        """
        return self._PlatformRefundAmt

    @PlatformRefundAmt.setter
    def PlatformRefundAmt(self, PlatformRefundAmt):
        self._PlatformRefundAmt = PlatformRefundAmt

    @property
    def SubMchRefundAmt(self):
        """商家应退金额
        :rtype: int
        """
        return self._SubMchRefundAmt

    @SubMchRefundAmt.setter
    def SubMchRefundAmt(self, SubMchRefundAmt):
        self._SubMchRefundAmt = SubMchRefundAmt

    @property
    def SubOutTradeNo(self):
        """子订单号
        :rtype: str
        """
        return self._SubOutTradeNo

    @SubOutTradeNo.setter
    def SubOutTradeNo(self, SubOutTradeNo):
        self._SubOutTradeNo = SubOutTradeNo

    @property
    def SubRefundId(self):
        """子退款单号，调用方需要保证全局唯一性
        :rtype: str
        """
        return self._SubRefundId

    @SubRefundId.setter
    def SubRefundId(self, SubRefundId):
        self._SubRefundId = SubRefundId


    def _deserialize(self, params):
        self._RefundAmt = params.get("RefundAmt")
        self._PlatformRefundAmt = params.get("PlatformRefundAmt")
        self._SubMchRefundAmt = params.get("SubMchRefundAmt")
        self._SubOutTradeNo = params.get("SubOutTradeNo")
        self._SubRefundId = params.get("SubRefundId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudSubOrderReturn(AbstractModel):
    """子订单详情

    """

    def __init__(self):
        r"""
        :param _SubOutTradeNo: 子订单号
        :type SubOutTradeNo: str
        :param _SubAppId: 米大师计费SubAppId，代表子商户
        :type SubAppId: str
        :param _ProductName: 子订单商品名称
        :type ProductName: str
        :param _ProductDetail: 子订单商品详情
        :type ProductDetail: str
        :param _PlatformIncome: 子订单平台应收金额，单位：分
        :type PlatformIncome: int
        :param _SubMchIncome: 子订单结算应收金额，单位：分
        :type SubMchIncome: int
        :param _Amt: 子订单支付金额
        :type Amt: int
        :param _OriginalAmt: 子订单原始金额
        :type OriginalAmt: int
        :param _SettleCheck: 核销状态，1表示核销，0表示未核销
        :type SettleCheck: int
        :param _SettleInfo: 结算信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SettleInfo: :class:`tencentcloud.cpdp.v20190820.models.CloudSettleInfo`
        :param _Metadata: 透传字段，由开发者在调用米大师下单接口的时候下发
        :type Metadata: str
        :param _AttachmentInfoList: 附加项信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AttachmentInfoList: :class:`tencentcloud.cpdp.v20190820.models.CloudAttachmentInfo`
        :param _ChannelExternalSubOrderId: 渠道方应答的订单号，透传处理
        :type ChannelExternalSubOrderId: str
        :param _WxSubMchId: 微信子商户号
        :type WxSubMchId: str
        :param _ChannelSubPayOrderId: 米大师侧渠道子订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelSubPayOrderId: str
        :param _ProductId: 物品ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ProductId: str
        """
        self._SubOutTradeNo = None
        self._SubAppId = None
        self._ProductName = None
        self._ProductDetail = None
        self._PlatformIncome = None
        self._SubMchIncome = None
        self._Amt = None
        self._OriginalAmt = None
        self._SettleCheck = None
        self._SettleInfo = None
        self._Metadata = None
        self._AttachmentInfoList = None
        self._ChannelExternalSubOrderId = None
        self._WxSubMchId = None
        self._ChannelSubPayOrderId = None
        self._ProductId = None

    @property
    def SubOutTradeNo(self):
        """子订单号
        :rtype: str
        """
        return self._SubOutTradeNo

    @SubOutTradeNo.setter
    def SubOutTradeNo(self, SubOutTradeNo):
        self._SubOutTradeNo = SubOutTradeNo

    @property
    def SubAppId(self):
        """米大师计费SubAppId，代表子商户
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def ProductName(self):
        """子订单商品名称
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def ProductDetail(self):
        """子订单商品详情
        :rtype: str
        """
        return self._ProductDetail

    @ProductDetail.setter
    def ProductDetail(self, ProductDetail):
        self._ProductDetail = ProductDetail

    @property
    def PlatformIncome(self):
        """子订单平台应收金额，单位：分
        :rtype: int
        """
        return self._PlatformIncome

    @PlatformIncome.setter
    def PlatformIncome(self, PlatformIncome):
        self._PlatformIncome = PlatformIncome

    @property
    def SubMchIncome(self):
        """子订单结算应收金额，单位：分
        :rtype: int
        """
        return self._SubMchIncome

    @SubMchIncome.setter
    def SubMchIncome(self, SubMchIncome):
        self._SubMchIncome = SubMchIncome

    @property
    def Amt(self):
        """子订单支付金额
        :rtype: int
        """
        return self._Amt

    @Amt.setter
    def Amt(self, Amt):
        self._Amt = Amt

    @property
    def OriginalAmt(self):
        """子订单原始金额
        :rtype: int
        """
        return self._OriginalAmt

    @OriginalAmt.setter
    def OriginalAmt(self, OriginalAmt):
        self._OriginalAmt = OriginalAmt

    @property
    def SettleCheck(self):
        """核销状态，1表示核销，0表示未核销
        :rtype: int
        """
        return self._SettleCheck

    @SettleCheck.setter
    def SettleCheck(self, SettleCheck):
        self._SettleCheck = SettleCheck

    @property
    def SettleInfo(self):
        """结算信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CloudSettleInfo`
        """
        return self._SettleInfo

    @SettleInfo.setter
    def SettleInfo(self, SettleInfo):
        self._SettleInfo = SettleInfo

    @property
    def Metadata(self):
        """透传字段，由开发者在调用米大师下单接口的时候下发
        :rtype: str
        """
        return self._Metadata

    @Metadata.setter
    def Metadata(self, Metadata):
        self._Metadata = Metadata

    @property
    def AttachmentInfoList(self):
        """附加项信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CloudAttachmentInfo`
        """
        return self._AttachmentInfoList

    @AttachmentInfoList.setter
    def AttachmentInfoList(self, AttachmentInfoList):
        self._AttachmentInfoList = AttachmentInfoList

    @property
    def ChannelExternalSubOrderId(self):
        """渠道方应答的订单号，透传处理
        :rtype: str
        """
        return self._ChannelExternalSubOrderId

    @ChannelExternalSubOrderId.setter
    def ChannelExternalSubOrderId(self, ChannelExternalSubOrderId):
        self._ChannelExternalSubOrderId = ChannelExternalSubOrderId

    @property
    def WxSubMchId(self):
        """微信子商户号
        :rtype: str
        """
        return self._WxSubMchId

    @WxSubMchId.setter
    def WxSubMchId(self, WxSubMchId):
        self._WxSubMchId = WxSubMchId

    @property
    def ChannelSubPayOrderId(self):
        """米大师侧渠道子订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelSubPayOrderId

    @ChannelSubPayOrderId.setter
    def ChannelSubPayOrderId(self, ChannelSubPayOrderId):
        self._ChannelSubPayOrderId = ChannelSubPayOrderId

    @property
    def ProductId(self):
        """物品ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId


    def _deserialize(self, params):
        self._SubOutTradeNo = params.get("SubOutTradeNo")
        self._SubAppId = params.get("SubAppId")
        self._ProductName = params.get("ProductName")
        self._ProductDetail = params.get("ProductDetail")
        self._PlatformIncome = params.get("PlatformIncome")
        self._SubMchIncome = params.get("SubMchIncome")
        self._Amt = params.get("Amt")
        self._OriginalAmt = params.get("OriginalAmt")
        self._SettleCheck = params.get("SettleCheck")
        if params.get("SettleInfo") is not None:
            self._SettleInfo = CloudSettleInfo()
            self._SettleInfo._deserialize(params.get("SettleInfo"))
        self._Metadata = params.get("Metadata")
        if params.get("AttachmentInfoList") is not None:
            self._AttachmentInfoList = CloudAttachmentInfo()
            self._AttachmentInfoList._deserialize(params.get("AttachmentInfoList"))
        self._ChannelExternalSubOrderId = params.get("ChannelExternalSubOrderId")
        self._WxSubMchId = params.get("WxSubMchId")
        self._ChannelSubPayOrderId = params.get("ChannelSubPayOrderId")
        self._ProductId = params.get("ProductId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudSubRefundItem(AbstractModel):
    """子单退款信息

    """

    def __init__(self):
        r"""
        :param _ChannelExternalRefundId: 渠道方应答的退款ID，透传处理
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExternalRefundId: str
        :param _ChannelExternalOrderId: 渠道方应答的订单号，透传处理
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExternalOrderId: str
        :param _RefundAmt: 子单退款金额
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundAmt: int
        :param _SubOutTradeNo: 子单订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type SubOutTradeNo: str
        :param _SubRefundId: 子单退款id
注意：此字段可能返回 null，表示取不到有效值。
        :type SubRefundId: str
        :param _SubAppId: 子应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAppId: str
        :param _ChannelSubOrderId: 渠道子单支付订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelSubOrderId: str
        :param _ChannelSubRefundId: 渠道子退款订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelSubRefundId: str
        """
        self._ChannelExternalRefundId = None
        self._ChannelExternalOrderId = None
        self._RefundAmt = None
        self._SubOutTradeNo = None
        self._SubRefundId = None
        self._SubAppId = None
        self._ChannelSubOrderId = None
        self._ChannelSubRefundId = None

    @property
    def ChannelExternalRefundId(self):
        """渠道方应答的退款ID，透传处理
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelExternalRefundId

    @ChannelExternalRefundId.setter
    def ChannelExternalRefundId(self, ChannelExternalRefundId):
        self._ChannelExternalRefundId = ChannelExternalRefundId

    @property
    def ChannelExternalOrderId(self):
        """渠道方应答的订单号，透传处理
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelExternalOrderId

    @ChannelExternalOrderId.setter
    def ChannelExternalOrderId(self, ChannelExternalOrderId):
        self._ChannelExternalOrderId = ChannelExternalOrderId

    @property
    def RefundAmt(self):
        """子单退款金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RefundAmt

    @RefundAmt.setter
    def RefundAmt(self, RefundAmt):
        self._RefundAmt = RefundAmt

    @property
    def SubOutTradeNo(self):
        """子单订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubOutTradeNo

    @SubOutTradeNo.setter
    def SubOutTradeNo(self, SubOutTradeNo):
        self._SubOutTradeNo = SubOutTradeNo

    @property
    def SubRefundId(self):
        """子单退款id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubRefundId

    @SubRefundId.setter
    def SubRefundId(self, SubRefundId):
        self._SubRefundId = SubRefundId

    @property
    def SubAppId(self):
        """子应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def ChannelSubOrderId(self):
        """渠道子单支付订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelSubOrderId

    @ChannelSubOrderId.setter
    def ChannelSubOrderId(self, ChannelSubOrderId):
        self._ChannelSubOrderId = ChannelSubOrderId

    @property
    def ChannelSubRefundId(self):
        """渠道子退款订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelSubRefundId

    @ChannelSubRefundId.setter
    def ChannelSubRefundId(self, ChannelSubRefundId):
        self._ChannelSubRefundId = ChannelSubRefundId


    def _deserialize(self, params):
        self._ChannelExternalRefundId = params.get("ChannelExternalRefundId")
        self._ChannelExternalOrderId = params.get("ChannelExternalOrderId")
        self._RefundAmt = params.get("RefundAmt")
        self._SubOutTradeNo = params.get("SubOutTradeNo")
        self._SubRefundId = params.get("SubRefundId")
        self._SubAppId = params.get("SubAppId")
        self._ChannelSubOrderId = params.get("ChannelSubOrderId")
        self._ChannelSubRefundId = params.get("ChannelSubRefundId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompanyTitleResult(AbstractModel):
    """公司抬头结果

    """

    def __init__(self):
        r"""
        :param _CompanyBankAccount: 公司银行账号
注意：此字段可能返回 null，表示取不到有效值。
        :type CompanyBankAccount: str
        :param _CompanyAddress: 公司地址
注意：此字段可能返回 null，表示取不到有效值。
        :type CompanyAddress: str
        :param _CompanyTaxpayerNum: 公司税号
注意：此字段可能返回 null，表示取不到有效值。
        :type CompanyTaxpayerNum: str
        :param _CompanyName: 公司名称
注意：此字段可能返回 null，表示取不到有效值。
        :type CompanyName: str
        :param _CompanyBankName: 公司银行名称
注意：此字段可能返回 null，表示取不到有效值。
        :type CompanyBankName: str
        :param _CompanyPhone: 公司电话
注意：此字段可能返回 null，表示取不到有效值。
        :type CompanyPhone: str
        """
        self._CompanyBankAccount = None
        self._CompanyAddress = None
        self._CompanyTaxpayerNum = None
        self._CompanyName = None
        self._CompanyBankName = None
        self._CompanyPhone = None

    @property
    def CompanyBankAccount(self):
        """公司银行账号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CompanyBankAccount

    @CompanyBankAccount.setter
    def CompanyBankAccount(self, CompanyBankAccount):
        self._CompanyBankAccount = CompanyBankAccount

    @property
    def CompanyAddress(self):
        """公司地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CompanyAddress

    @CompanyAddress.setter
    def CompanyAddress(self, CompanyAddress):
        self._CompanyAddress = CompanyAddress

    @property
    def CompanyTaxpayerNum(self):
        """公司税号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CompanyTaxpayerNum

    @CompanyTaxpayerNum.setter
    def CompanyTaxpayerNum(self, CompanyTaxpayerNum):
        self._CompanyTaxpayerNum = CompanyTaxpayerNum

    @property
    def CompanyName(self):
        """公司名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CompanyName

    @CompanyName.setter
    def CompanyName(self, CompanyName):
        self._CompanyName = CompanyName

    @property
    def CompanyBankName(self):
        """公司银行名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CompanyBankName

    @CompanyBankName.setter
    def CompanyBankName(self, CompanyBankName):
        self._CompanyBankName = CompanyBankName

    @property
    def CompanyPhone(self):
        """公司电话
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CompanyPhone

    @CompanyPhone.setter
    def CompanyPhone(self, CompanyPhone):
        self._CompanyPhone = CompanyPhone


    def _deserialize(self, params):
        self._CompanyBankAccount = params.get("CompanyBankAccount")
        self._CompanyAddress = params.get("CompanyAddress")
        self._CompanyTaxpayerNum = params.get("CompanyTaxpayerNum")
        self._CompanyName = params.get("CompanyName")
        self._CompanyBankName = params.get("CompanyBankName")
        self._CompanyPhone = params.get("CompanyPhone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmOrderRequest(AbstractModel):
    """ConfirmOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantAppId: 分配给商户的AppId
        :type MerchantAppId: str
        :param _OrderNo: 平台流水号。消费订单发起成功后，返回的平台唯一订单号。
        :type OrderNo: str
        """
        self._MerchantAppId = None
        self._OrderNo = None

    @property
    def MerchantAppId(self):
        """分配给商户的AppId
        :rtype: str
        """
        return self._MerchantAppId

    @MerchantAppId.setter
    def MerchantAppId(self, MerchantAppId):
        self._MerchantAppId = MerchantAppId

    @property
    def OrderNo(self):
        """平台流水号。消费订单发起成功后，返回的平台唯一订单号。
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo


    def _deserialize(self, params):
        self._MerchantAppId = params.get("MerchantAppId")
        self._OrderNo = params.get("OrderNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmOrderResponse(AbstractModel):
    """ConfirmOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantAppId: 分配给商户的AppId
        :type MerchantAppId: str
        :param _OrderNo: 平台流水号。消费订单发起成功后，返回的平台唯一订单号。
        :type OrderNo: str
        :param _Status: 订单确认状态。0-确认失败
1-确认成功 
2-可疑状态
        :type Status: str
        :param _Description: 订单确认状态描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MerchantAppId = None
        self._OrderNo = None
        self._Status = None
        self._Description = None
        self._RequestId = None

    @property
    def MerchantAppId(self):
        """分配给商户的AppId
        :rtype: str
        """
        return self._MerchantAppId

    @MerchantAppId.setter
    def MerchantAppId(self, MerchantAppId):
        self._MerchantAppId = MerchantAppId

    @property
    def OrderNo(self):
        """平台流水号。消费订单发起成功后，返回的平台唯一订单号。
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo

    @property
    def Status(self):
        """订单确认状态。0-确认失败
1-确认成功 
2-可疑状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Description(self):
        """订单确认状态描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MerchantAppId = params.get("MerchantAppId")
        self._OrderNo = params.get("OrderNo")
        self._Status = params.get("Status")
        self._Description = params.get("Description")
        self._RequestId = params.get("RequestId")


class ContractInfo(AbstractModel):
    """合约信息

    """

    def __init__(self):
        r"""
        :param _ChannelContractMerchantId: 米大师内部签约商户号
        :type ChannelContractMerchantId: str
        :param _ChannelContractSubMerchantId: 米大师内部签约子商户号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelContractSubMerchantId: str
        :param _ChannelContractAppId: 米大师内部签约应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelContractAppId: str
        :param _ChannelContractSubAppId: 米大师内部签约子应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelContractSubAppId: str
        :param _OutContractCode: 业务合约协议号
        :type OutContractCode: str
        :param _ExternalContractUserInfoList: 第三方渠道用户信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalContractUserInfoList: list of ExternalContractUserInfo
        :param _ContractMethod: 签约方式，如 wechat_app ，使用app方式下的微信签
        :type ContractMethod: str
        :param _ContractSceneId: 合约场景id
注意：此字段可能返回 null，表示取不到有效值。
        :type ContractSceneId: str
        :param _UserInfo: 用户信息
        :type UserInfo: :class:`tencentcloud.cpdp.v20190820.models.ContractUserInfo`
        :param _ExternalContractData: 第三方渠道签约数据
        :type ExternalContractData: str
        """
        self._ChannelContractMerchantId = None
        self._ChannelContractSubMerchantId = None
        self._ChannelContractAppId = None
        self._ChannelContractSubAppId = None
        self._OutContractCode = None
        self._ExternalContractUserInfoList = None
        self._ContractMethod = None
        self._ContractSceneId = None
        self._UserInfo = None
        self._ExternalContractData = None

    @property
    def ChannelContractMerchantId(self):
        """米大师内部签约商户号
        :rtype: str
        """
        return self._ChannelContractMerchantId

    @ChannelContractMerchantId.setter
    def ChannelContractMerchantId(self, ChannelContractMerchantId):
        self._ChannelContractMerchantId = ChannelContractMerchantId

    @property
    def ChannelContractSubMerchantId(self):
        """米大师内部签约子商户号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelContractSubMerchantId

    @ChannelContractSubMerchantId.setter
    def ChannelContractSubMerchantId(self, ChannelContractSubMerchantId):
        self._ChannelContractSubMerchantId = ChannelContractSubMerchantId

    @property
    def ChannelContractAppId(self):
        """米大师内部签约应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelContractAppId

    @ChannelContractAppId.setter
    def ChannelContractAppId(self, ChannelContractAppId):
        self._ChannelContractAppId = ChannelContractAppId

    @property
    def ChannelContractSubAppId(self):
        """米大师内部签约子应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelContractSubAppId

    @ChannelContractSubAppId.setter
    def ChannelContractSubAppId(self, ChannelContractSubAppId):
        self._ChannelContractSubAppId = ChannelContractSubAppId

    @property
    def OutContractCode(self):
        """业务合约协议号
        :rtype: str
        """
        return self._OutContractCode

    @OutContractCode.setter
    def OutContractCode(self, OutContractCode):
        self._OutContractCode = OutContractCode

    @property
    def ExternalContractUserInfoList(self):
        """第三方渠道用户信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ExternalContractUserInfo
        """
        return self._ExternalContractUserInfoList

    @ExternalContractUserInfoList.setter
    def ExternalContractUserInfoList(self, ExternalContractUserInfoList):
        self._ExternalContractUserInfoList = ExternalContractUserInfoList

    @property
    def ContractMethod(self):
        """签约方式，如 wechat_app ，使用app方式下的微信签
        :rtype: str
        """
        return self._ContractMethod

    @ContractMethod.setter
    def ContractMethod(self, ContractMethod):
        self._ContractMethod = ContractMethod

    @property
    def ContractSceneId(self):
        """合约场景id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ContractSceneId

    @ContractSceneId.setter
    def ContractSceneId(self, ContractSceneId):
        self._ContractSceneId = ContractSceneId

    @property
    def UserInfo(self):
        """用户信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ContractUserInfo`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def ExternalContractData(self):
        """第三方渠道签约数据
        :rtype: str
        """
        return self._ExternalContractData

    @ExternalContractData.setter
    def ExternalContractData(self, ExternalContractData):
        self._ExternalContractData = ExternalContractData


    def _deserialize(self, params):
        self._ChannelContractMerchantId = params.get("ChannelContractMerchantId")
        self._ChannelContractSubMerchantId = params.get("ChannelContractSubMerchantId")
        self._ChannelContractAppId = params.get("ChannelContractAppId")
        self._ChannelContractSubAppId = params.get("ChannelContractSubAppId")
        self._OutContractCode = params.get("OutContractCode")
        if params.get("ExternalContractUserInfoList") is not None:
            self._ExternalContractUserInfoList = []
            for item in params.get("ExternalContractUserInfoList"):
                obj = ExternalContractUserInfo()
                obj._deserialize(item)
                self._ExternalContractUserInfoList.append(obj)
        self._ContractMethod = params.get("ContractMethod")
        self._ContractSceneId = params.get("ContractSceneId")
        if params.get("UserInfo") is not None:
            self._UserInfo = ContractUserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._ExternalContractData = params.get("ExternalContractData")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContractOrderInSubOrder(AbstractModel):
    """支付中签约子订单列表

    """

    def __init__(self):
        r"""
        :param _SubMchIncome: 子订单结算应收金额，单位： 分
        :type SubMchIncome: int
        :param _PlatformIncome: 子订单平台应收金额，单位：分
        :type PlatformIncome: int
        :param _ProductDetail: 子订单商品详情
        :type ProductDetail: str
        :param _ProductName: 子订单商品名称
        :type ProductName: str
        :param _SubAppId: 聚鑫计费SubAppId，代表子商户
        :type SubAppId: str
        :param _SubOutTradeNo: 子订单号
        :type SubOutTradeNo: str
        :param _Amt: 子订单支付金额
        :type Amt: int
        :param _OriginalAmt: 子订单原始金额
        :type OriginalAmt: int
        :param _Metadata: 发货标识，由业务在调用聚鑫下单接口的 时候下发
        :type Metadata: str
        """
        self._SubMchIncome = None
        self._PlatformIncome = None
        self._ProductDetail = None
        self._ProductName = None
        self._SubAppId = None
        self._SubOutTradeNo = None
        self._Amt = None
        self._OriginalAmt = None
        self._Metadata = None

    @property
    def SubMchIncome(self):
        """子订单结算应收金额，单位： 分
        :rtype: int
        """
        return self._SubMchIncome

    @SubMchIncome.setter
    def SubMchIncome(self, SubMchIncome):
        self._SubMchIncome = SubMchIncome

    @property
    def PlatformIncome(self):
        """子订单平台应收金额，单位：分
        :rtype: int
        """
        return self._PlatformIncome

    @PlatformIncome.setter
    def PlatformIncome(self, PlatformIncome):
        self._PlatformIncome = PlatformIncome

    @property
    def ProductDetail(self):
        """子订单商品详情
        :rtype: str
        """
        return self._ProductDetail

    @ProductDetail.setter
    def ProductDetail(self, ProductDetail):
        self._ProductDetail = ProductDetail

    @property
    def ProductName(self):
        """子订单商品名称
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def SubAppId(self):
        """聚鑫计费SubAppId，代表子商户
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SubOutTradeNo(self):
        """子订单号
        :rtype: str
        """
        return self._SubOutTradeNo

    @SubOutTradeNo.setter
    def SubOutTradeNo(self, SubOutTradeNo):
        self._SubOutTradeNo = SubOutTradeNo

    @property
    def Amt(self):
        """子订单支付金额
        :rtype: int
        """
        return self._Amt

    @Amt.setter
    def Amt(self, Amt):
        self._Amt = Amt

    @property
    def OriginalAmt(self):
        """子订单原始金额
        :rtype: int
        """
        return self._OriginalAmt

    @OriginalAmt.setter
    def OriginalAmt(self, OriginalAmt):
        self._OriginalAmt = OriginalAmt

    @property
    def Metadata(self):
        """发货标识，由业务在调用聚鑫下单接口的 时候下发
        :rtype: str
        """
        return self._Metadata

    @Metadata.setter
    def Metadata(self, Metadata):
        self._Metadata = Metadata


    def _deserialize(self, params):
        self._SubMchIncome = params.get("SubMchIncome")
        self._PlatformIncome = params.get("PlatformIncome")
        self._ProductDetail = params.get("ProductDetail")
        self._ProductName = params.get("ProductName")
        self._SubAppId = params.get("SubAppId")
        self._SubOutTradeNo = params.get("SubOutTradeNo")
        self._Amt = params.get("Amt")
        self._OriginalAmt = params.get("OriginalAmt")
        self._Metadata = params.get("Metadata")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContractOrderRequest(AbstractModel):
    """ContractOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrencyType: ISO 货币代码，CNY
        :type CurrencyType: str
        :param _MidasAppId: 聚鑫分配的支付主MidasAppId
        :type MidasAppId: str
        :param _OutTradeNo: 支付订单号，仅支持数字、字母、下划线（_）、横杠字符（-）、点（.）的组合
        :type OutTradeNo: str
        :param _ProductDetail: 商品详情，需要URL编码
        :type ProductDetail: str
        :param _ProductId: 商品ID，仅支持数字、字母、下划线（_）、横杠字符（-）、点（.）的组合
        :type ProductId: str
        :param _ProductName: 商品名称，需要URL编码
        :type ProductName: str
        :param _TotalAmt: 支付金额，单位： 分
        :type TotalAmt: int
        :param _UserId: 用户ID，长度不小于5位，仅支持字母和数字的组合
        :type UserId: str
        :param _RealChannel: 银行真实渠道.如:bank_pingan
        :type RealChannel: str
        :param _OriginalAmt: 原始金额
        :type OriginalAmt: int
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasSignature: 按照聚鑫安全密钥计算的签名
        :type MidasSignature: str
        :param _ContractNotifyUrl: 签约通知地址
        :type ContractNotifyUrl: str
        :param _CallbackUrl: Web端回调地址
        :type CallbackUrl: str
        :param _Channel: 指定支付渠道：  wechat：微信支付  qqwallet：QQ钱包 
 bank：网银支付  只有一个渠道时需要指定
        :type Channel: str
        :param _Metadata: 透传字段，支付成功回调透传给应用，用于业务透传自定义内容
        :type Metadata: str
        :param _Quantity: 购买数量，不传默认为1
        :type Quantity: int
        :param _SubAppId: 聚鑫计费SubAppId，代表子商户
        :type SubAppId: str
        :param _SubOrderList: 子订单信息列表，格式：子订单号、子应用ID、金额。 压缩后最长不可超过65535字节(去除空格，换行，制表符等无意义字符)
注：接入银行或其他支付渠道服务商模式下，必传
        :type SubOrderList: list of ContractOrderInSubOrder
        :param _TotalMchIncome: 结算应收金额，单位：分
        :type TotalMchIncome: int
        :param _TotalPlatformIncome: 平台应收金额，单位：分
        :type TotalPlatformIncome: int
        :param _WxOpenId: 微信公众号/小程序支付时为必选，需要传微信下的openid
        :type WxOpenId: str
        :param _WxSubOpenId: 在服务商模式下，微信公众号/小程序支付时wx_sub_openid和wx_openid二选一
        :type WxSubOpenId: str
        :param _MidasEnvironment: 环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type MidasEnvironment: str
        :param _WxAppId: 微信商户应用ID
        :type WxAppId: str
        :param _WxSubAppId: 微信商户子应用ID
        :type WxSubAppId: str
        :param _PaymentNotifyUrl: 支付通知地址
        :type PaymentNotifyUrl: str
        :param _ContractSceneId: 传入调用方在Midas注册签约信息时获得的ContractSceneId。若未在Midas注册签约信息，则传入ExternalContractData。注意：ContractSceneId与ExternalContractData必须二选一传入其中一个
        :type ContractSceneId: str
        :param _ExternalContractData: 需要按照各个渠道的扩展签约信息规范组装好该字段。若未在Midas注册签约信息，则传入该字段。注意：ContractSceneId与ExternalContractData必须二选一传入其中一个
        :type ExternalContractData: str
        :param _OutContractCode: 外部签约协议号，唯一标记一个签约关系。仅支持数字、字母、下划线（_）、横杠字符（-）、点（.）的组合
        :type OutContractCode: str
        :param _AttachData: 透传给第三方渠道的附加数据
        :type AttachData: str
        :param _ContractDisplayName: 展示用的签约用户名称，若不传入时，默认取UserId
        :type ContractDisplayName: str
        """
        self._CurrencyType = None
        self._MidasAppId = None
        self._OutTradeNo = None
        self._ProductDetail = None
        self._ProductId = None
        self._ProductName = None
        self._TotalAmt = None
        self._UserId = None
        self._RealChannel = None
        self._OriginalAmt = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._ContractNotifyUrl = None
        self._CallbackUrl = None
        self._Channel = None
        self._Metadata = None
        self._Quantity = None
        self._SubAppId = None
        self._SubOrderList = None
        self._TotalMchIncome = None
        self._TotalPlatformIncome = None
        self._WxOpenId = None
        self._WxSubOpenId = None
        self._MidasEnvironment = None
        self._WxAppId = None
        self._WxSubAppId = None
        self._PaymentNotifyUrl = None
        self._ContractSceneId = None
        self._ExternalContractData = None
        self._OutContractCode = None
        self._AttachData = None
        self._ContractDisplayName = None

    @property
    def CurrencyType(self):
        """ISO 货币代码，CNY
        :rtype: str
        """
        return self._CurrencyType

    @CurrencyType.setter
    def CurrencyType(self, CurrencyType):
        self._CurrencyType = CurrencyType

    @property
    def MidasAppId(self):
        """聚鑫分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def OutTradeNo(self):
        """支付订单号，仅支持数字、字母、下划线（_）、横杠字符（-）、点（.）的组合
        :rtype: str
        """
        return self._OutTradeNo

    @OutTradeNo.setter
    def OutTradeNo(self, OutTradeNo):
        self._OutTradeNo = OutTradeNo

    @property
    def ProductDetail(self):
        """商品详情，需要URL编码
        :rtype: str
        """
        return self._ProductDetail

    @ProductDetail.setter
    def ProductDetail(self, ProductDetail):
        self._ProductDetail = ProductDetail

    @property
    def ProductId(self):
        """商品ID，仅支持数字、字母、下划线（_）、横杠字符（-）、点（.）的组合
        :rtype: str
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def ProductName(self):
        """商品名称，需要URL编码
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def TotalAmt(self):
        """支付金额，单位： 分
        :rtype: int
        """
        return self._TotalAmt

    @TotalAmt.setter
    def TotalAmt(self, TotalAmt):
        self._TotalAmt = TotalAmt

    @property
    def UserId(self):
        """用户ID，长度不小于5位，仅支持字母和数字的组合
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def RealChannel(self):
        """银行真实渠道.如:bank_pingan
        :rtype: str
        """
        return self._RealChannel

    @RealChannel.setter
    def RealChannel(self, RealChannel):
        self._RealChannel = RealChannel

    @property
    def OriginalAmt(self):
        """原始金额
        :rtype: int
        """
        return self._OriginalAmt

    @OriginalAmt.setter
    def OriginalAmt(self, OriginalAmt):
        self._OriginalAmt = OriginalAmt

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """按照聚鑫安全密钥计算的签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def ContractNotifyUrl(self):
        """签约通知地址
        :rtype: str
        """
        return self._ContractNotifyUrl

    @ContractNotifyUrl.setter
    def ContractNotifyUrl(self, ContractNotifyUrl):
        self._ContractNotifyUrl = ContractNotifyUrl

    @property
    def CallbackUrl(self):
        """Web端回调地址
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def Channel(self):
        """指定支付渠道：  wechat：微信支付  qqwallet：QQ钱包 
 bank：网银支付  只有一个渠道时需要指定
        :rtype: str
        """
        return self._Channel

    @Channel.setter
    def Channel(self, Channel):
        self._Channel = Channel

    @property
    def Metadata(self):
        """透传字段，支付成功回调透传给应用，用于业务透传自定义内容
        :rtype: str
        """
        return self._Metadata

    @Metadata.setter
    def Metadata(self, Metadata):
        self._Metadata = Metadata

    @property
    def Quantity(self):
        """购买数量，不传默认为1
        :rtype: int
        """
        return self._Quantity

    @Quantity.setter
    def Quantity(self, Quantity):
        self._Quantity = Quantity

    @property
    def SubAppId(self):
        """聚鑫计费SubAppId，代表子商户
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SubOrderList(self):
        """子订单信息列表，格式：子订单号、子应用ID、金额。 压缩后最长不可超过65535字节(去除空格，换行，制表符等无意义字符)
注：接入银行或其他支付渠道服务商模式下，必传
        :rtype: list of ContractOrderInSubOrder
        """
        return self._SubOrderList

    @SubOrderList.setter
    def SubOrderList(self, SubOrderList):
        self._SubOrderList = SubOrderList

    @property
    def TotalMchIncome(self):
        """结算应收金额，单位：分
        :rtype: int
        """
        return self._TotalMchIncome

    @TotalMchIncome.setter
    def TotalMchIncome(self, TotalMchIncome):
        self._TotalMchIncome = TotalMchIncome

    @property
    def TotalPlatformIncome(self):
        """平台应收金额，单位：分
        :rtype: int
        """
        return self._TotalPlatformIncome

    @TotalPlatformIncome.setter
    def TotalPlatformIncome(self, TotalPlatformIncome):
        self._TotalPlatformIncome = TotalPlatformIncome

    @property
    def WxOpenId(self):
        """微信公众号/小程序支付时为必选，需要传微信下的openid
        :rtype: str
        """
        return self._WxOpenId

    @WxOpenId.setter
    def WxOpenId(self, WxOpenId):
        self._WxOpenId = WxOpenId

    @property
    def WxSubOpenId(self):
        """在服务商模式下，微信公众号/小程序支付时wx_sub_openid和wx_openid二选一
        :rtype: str
        """
        return self._WxSubOpenId

    @WxSubOpenId.setter
    def WxSubOpenId(self, WxSubOpenId):
        self._WxSubOpenId = WxSubOpenId

    @property
    def MidasEnvironment(self):
        """环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment

    @property
    def WxAppId(self):
        """微信商户应用ID
        :rtype: str
        """
        return self._WxAppId

    @WxAppId.setter
    def WxAppId(self, WxAppId):
        self._WxAppId = WxAppId

    @property
    def WxSubAppId(self):
        """微信商户子应用ID
        :rtype: str
        """
        return self._WxSubAppId

    @WxSubAppId.setter
    def WxSubAppId(self, WxSubAppId):
        self._WxSubAppId = WxSubAppId

    @property
    def PaymentNotifyUrl(self):
        """支付通知地址
        :rtype: str
        """
        return self._PaymentNotifyUrl

    @PaymentNotifyUrl.setter
    def PaymentNotifyUrl(self, PaymentNotifyUrl):
        self._PaymentNotifyUrl = PaymentNotifyUrl

    @property
    def ContractSceneId(self):
        """传入调用方在Midas注册签约信息时获得的ContractSceneId。若未在Midas注册签约信息，则传入ExternalContractData。注意：ContractSceneId与ExternalContractData必须二选一传入其中一个
        :rtype: str
        """
        return self._ContractSceneId

    @ContractSceneId.setter
    def ContractSceneId(self, ContractSceneId):
        self._ContractSceneId = ContractSceneId

    @property
    def ExternalContractData(self):
        """需要按照各个渠道的扩展签约信息规范组装好该字段。若未在Midas注册签约信息，则传入该字段。注意：ContractSceneId与ExternalContractData必须二选一传入其中一个
        :rtype: str
        """
        return self._ExternalContractData

    @ExternalContractData.setter
    def ExternalContractData(self, ExternalContractData):
        self._ExternalContractData = ExternalContractData

    @property
    def OutContractCode(self):
        """外部签约协议号，唯一标记一个签约关系。仅支持数字、字母、下划线（_）、横杠字符（-）、点（.）的组合
        :rtype: str
        """
        return self._OutContractCode

    @OutContractCode.setter
    def OutContractCode(self, OutContractCode):
        self._OutContractCode = OutContractCode

    @property
    def AttachData(self):
        """透传给第三方渠道的附加数据
        :rtype: str
        """
        return self._AttachData

    @AttachData.setter
    def AttachData(self, AttachData):
        self._AttachData = AttachData

    @property
    def ContractDisplayName(self):
        """展示用的签约用户名称，若不传入时，默认取UserId
        :rtype: str
        """
        return self._ContractDisplayName

    @ContractDisplayName.setter
    def ContractDisplayName(self, ContractDisplayName):
        self._ContractDisplayName = ContractDisplayName


    def _deserialize(self, params):
        self._CurrencyType = params.get("CurrencyType")
        self._MidasAppId = params.get("MidasAppId")
        self._OutTradeNo = params.get("OutTradeNo")
        self._ProductDetail = params.get("ProductDetail")
        self._ProductId = params.get("ProductId")
        self._ProductName = params.get("ProductName")
        self._TotalAmt = params.get("TotalAmt")
        self._UserId = params.get("UserId")
        self._RealChannel = params.get("RealChannel")
        self._OriginalAmt = params.get("OriginalAmt")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        self._ContractNotifyUrl = params.get("ContractNotifyUrl")
        self._CallbackUrl = params.get("CallbackUrl")
        self._Channel = params.get("Channel")
        self._Metadata = params.get("Metadata")
        self._Quantity = params.get("Quantity")
        self._SubAppId = params.get("SubAppId")
        if params.get("SubOrderList") is not None:
            self._SubOrderList = []
            for item in params.get("SubOrderList"):
                obj = ContractOrderInSubOrder()
                obj._deserialize(item)
                self._SubOrderList.append(obj)
        self._TotalMchIncome = params.get("TotalMchIncome")
        self._TotalPlatformIncome = params.get("TotalPlatformIncome")
        self._WxOpenId = params.get("WxOpenId")
        self._WxSubOpenId = params.get("WxSubOpenId")
        self._MidasEnvironment = params.get("MidasEnvironment")
        self._WxAppId = params.get("WxAppId")
        self._WxSubAppId = params.get("WxSubAppId")
        self._PaymentNotifyUrl = params.get("PaymentNotifyUrl")
        self._ContractSceneId = params.get("ContractSceneId")
        self._ExternalContractData = params.get("ExternalContractData")
        self._OutContractCode = params.get("OutContractCode")
        self._AttachData = params.get("AttachData")
        self._ContractDisplayName = params.get("ContractDisplayName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContractOrderResponse(AbstractModel):
    """ContractOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalAmt: 支付金额，单位： 分
        :type TotalAmt: int
        :param _OutTradeNo: 应用支付订单号
        :type OutTradeNo: str
        :param _PayInfo: 支付参数透传给聚鑫SDK（原文透传给SDK即可，不需要解码）
        :type PayInfo: str
        :param _TransactionId: 聚鑫的交易订单号
        :type TransactionId: str
        :param _OutContractCode: 外部签约协议号
        :type OutContractCode: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalAmt = None
        self._OutTradeNo = None
        self._PayInfo = None
        self._TransactionId = None
        self._OutContractCode = None
        self._RequestId = None

    @property
    def TotalAmt(self):
        """支付金额，单位： 分
        :rtype: int
        """
        return self._TotalAmt

    @TotalAmt.setter
    def TotalAmt(self, TotalAmt):
        self._TotalAmt = TotalAmt

    @property
    def OutTradeNo(self):
        """应用支付订单号
        :rtype: str
        """
        return self._OutTradeNo

    @OutTradeNo.setter
    def OutTradeNo(self, OutTradeNo):
        self._OutTradeNo = OutTradeNo

    @property
    def PayInfo(self):
        """支付参数透传给聚鑫SDK（原文透传给SDK即可，不需要解码）
        :rtype: str
        """
        return self._PayInfo

    @PayInfo.setter
    def PayInfo(self, PayInfo):
        self._PayInfo = PayInfo

    @property
    def TransactionId(self):
        """聚鑫的交易订单号
        :rtype: str
        """
        return self._TransactionId

    @TransactionId.setter
    def TransactionId(self, TransactionId):
        self._TransactionId = TransactionId

    @property
    def OutContractCode(self):
        """外部签约协议号
        :rtype: str
        """
        return self._OutContractCode

    @OutContractCode.setter
    def OutContractCode(self, OutContractCode):
        self._OutContractCode = OutContractCode

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalAmt = params.get("TotalAmt")
        self._OutTradeNo = params.get("OutTradeNo")
        self._PayInfo = params.get("PayInfo")
        self._TransactionId = params.get("TransactionId")
        self._OutContractCode = params.get("OutContractCode")
        self._RequestId = params.get("RequestId")


class ContractPayListResult(AbstractModel):
    """合同-支付方式列表响应对象

    """

    def __init__(self):
        r"""
        :param _PaymentId: 支付方式编号
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentId: str
        :param _PaymentType: 支持的交易类型（多个以小写逗号分开，0现金，1刷卡，2主扫，3被扫，4JSPAY，5预授权）
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentType: str
        :param _PaymentTag: 支付标签
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentTag: str
        :param _PaymentIcon: 支付方式图片url路径
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentIcon: str
        :param _PaymentName: 付款方式名称
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentName: str
        :param _PaymentInternalName: 付款方式名称（内部名称）
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentInternalName: str
        :param _PaymentOptionOne: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionOne: str
        :param _PaymentOptionTwo: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionTwo: str
        :param _PaymentOptionThree: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionThree: str
        :param _PaymentOptionFour: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionFour: str
        :param _PaymentOptionFive: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionFive: str
        :param _PaymentOptionSix: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionSix: str
        :param _PaymentOptionSeven: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionSeven: str
        :param _PaymentOptionOther: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionOther: str
        :param _PaymentOptionNine: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionNine: str
        :param _PaymentOptionTen: 支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :type PaymentOptionTen: str
        """
        self._PaymentId = None
        self._PaymentType = None
        self._PaymentTag = None
        self._PaymentIcon = None
        self._PaymentName = None
        self._PaymentInternalName = None
        self._PaymentOptionOne = None
        self._PaymentOptionTwo = None
        self._PaymentOptionThree = None
        self._PaymentOptionFour = None
        self._PaymentOptionFive = None
        self._PaymentOptionSix = None
        self._PaymentOptionSeven = None
        self._PaymentOptionOther = None
        self._PaymentOptionNine = None
        self._PaymentOptionTen = None

    @property
    def PaymentId(self):
        """支付方式编号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentId

    @PaymentId.setter
    def PaymentId(self, PaymentId):
        self._PaymentId = PaymentId

    @property
    def PaymentType(self):
        """支持的交易类型（多个以小写逗号分开，0现金，1刷卡，2主扫，3被扫，4JSPAY，5预授权）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentType

    @PaymentType.setter
    def PaymentType(self, PaymentType):
        self._PaymentType = PaymentType

    @property
    def PaymentTag(self):
        """支付标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentTag

    @PaymentTag.setter
    def PaymentTag(self, PaymentTag):
        self._PaymentTag = PaymentTag

    @property
    def PaymentIcon(self):
        """支付方式图片url路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentIcon

    @PaymentIcon.setter
    def PaymentIcon(self, PaymentIcon):
        self._PaymentIcon = PaymentIcon

    @property
    def PaymentName(self):
        """付款方式名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentName

    @PaymentName.setter
    def PaymentName(self, PaymentName):
        self._PaymentName = PaymentName

    @property
    def PaymentInternalName(self):
        """付款方式名称（内部名称）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentInternalName

    @PaymentInternalName.setter
    def PaymentInternalName(self, PaymentInternalName):
        self._PaymentInternalName = PaymentInternalName

    @property
    def PaymentOptionOne(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionOne

    @PaymentOptionOne.setter
    def PaymentOptionOne(self, PaymentOptionOne):
        self._PaymentOptionOne = PaymentOptionOne

    @property
    def PaymentOptionTwo(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionTwo

    @PaymentOptionTwo.setter
    def PaymentOptionTwo(self, PaymentOptionTwo):
        self._PaymentOptionTwo = PaymentOptionTwo

    @property
    def PaymentOptionThree(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionThree

    @PaymentOptionThree.setter
    def PaymentOptionThree(self, PaymentOptionThree):
        self._PaymentOptionThree = PaymentOptionThree

    @property
    def PaymentOptionFour(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionFour

    @PaymentOptionFour.setter
    def PaymentOptionFour(self, PaymentOptionFour):
        self._PaymentOptionFour = PaymentOptionFour

    @property
    def PaymentOptionFive(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionFive

    @PaymentOptionFive.setter
    def PaymentOptionFive(self, PaymentOptionFive):
        self._PaymentOptionFive = PaymentOptionFive

    @property
    def PaymentOptionSix(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionSix

    @PaymentOptionSix.setter
    def PaymentOptionSix(self, PaymentOptionSix):
        self._PaymentOptionSix = PaymentOptionSix

    @property
    def PaymentOptionSeven(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionSeven

    @PaymentOptionSeven.setter
    def PaymentOptionSeven(self, PaymentOptionSeven):
        self._PaymentOptionSeven = PaymentOptionSeven

    @property
    def PaymentOptionOther(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionOther

    @PaymentOptionOther.setter
    def PaymentOptionOther(self, PaymentOptionOther):
        self._PaymentOptionOther = PaymentOptionOther

    @property
    def PaymentOptionNine(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionNine

    @PaymentOptionNine.setter
    def PaymentOptionNine(self, PaymentOptionNine):
        self._PaymentOptionNine = PaymentOptionNine

    @property
    def PaymentOptionTen(self):
        """支付方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaymentOptionTen

    @PaymentOptionTen.setter
    def PaymentOptionTen(self, PaymentOptionTen):
        self._PaymentOptionTen = PaymentOptionTen


    def _deserialize(self, params):
        self._PaymentId = params.get("PaymentId")
        self._PaymentType = params.get("PaymentType")
        self._PaymentTag = params.get("PaymentTag")
        self._PaymentIcon = params.get("PaymentIcon")
        self._PaymentName = params.get("PaymentName")
        self._PaymentInternalName = params.get("PaymentInternalName")
        self._PaymentOptionOne = params.get("PaymentOptionOne")
        self._PaymentOptionTwo = params.get("PaymentOptionTwo")
        self._PaymentOptionThree = params.get("PaymentOptionThree")
        self._PaymentOptionFour = params.get("PaymentOptionFour")
        self._PaymentOptionFive = params.get("PaymentOptionFive")
        self._PaymentOptionSix = params.get("PaymentOptionSix")
        self._PaymentOptionSeven = params.get("PaymentOptionSeven")
        self._PaymentOptionOther = params.get("PaymentOptionOther")
        self._PaymentOptionNine = params.get("PaymentOptionNine")
        self._PaymentOptionTen = params.get("PaymentOptionTen")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContractSyncInfo(AbstractModel):
    """签约同步信息

    """

    def __init__(self):
        r"""
        :param _ExternalReturnContractInfo: 第三方渠道合约信息
        :type ExternalReturnContractInfo: :class:`tencentcloud.cpdp.v20190820.models.ExternalReturnContractInfo`
        :param _ExternalContractUserInfo: 第三方渠道用户信息
        :type ExternalContractUserInfo: list of ExternalContractUserInfo
        :param _ContractMethod: 签约方式，枚举值，
<br/>CONTRACT_METHOD_WECHAT_INVALID: 无效
CONTRACT_METHOD_WECHAT_APP: 微信APP
CONTRACT_METHOD_WECHAT_PUBLIC: 微信公众号
CONTRACT_METHOD_WECHAT_MINIPROGRAM: 微信小程序
CONTRACT_METHOD_WECHAT_H5: 微信H5
        :type ContractMethod: str
        :param _ContractSceneId: 在米大师侧分配的场景id
        :type ContractSceneId: str
        :param _ExternalReturnContractData: 调用方从第三方渠道查询到的签约数据，由各个渠道定义
        :type ExternalReturnContractData: str
        """
        self._ExternalReturnContractInfo = None
        self._ExternalContractUserInfo = None
        self._ContractMethod = None
        self._ContractSceneId = None
        self._ExternalReturnContractData = None

    @property
    def ExternalReturnContractInfo(self):
        """第三方渠道合约信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.ExternalReturnContractInfo`
        """
        return self._ExternalReturnContractInfo

    @ExternalReturnContractInfo.setter
    def ExternalReturnContractInfo(self, ExternalReturnContractInfo):
        self._ExternalReturnContractInfo = ExternalReturnContractInfo

    @property
    def ExternalContractUserInfo(self):
        """第三方渠道用户信息
        :rtype: list of ExternalContractUserInfo
        """
        return self._ExternalContractUserInfo

    @ExternalContractUserInfo.setter
    def ExternalContractUserInfo(self, ExternalContractUserInfo):
        self._ExternalContractUserInfo = ExternalContractUserInfo

    @property
    def ContractMethod(self):
        """签约方式，枚举值，
<br/>CONTRACT_METHOD_WECHAT_INVALID: 无效
CONTRACT_METHOD_WECHAT_APP: 微信APP
CONTRACT_METHOD_WECHAT_PUBLIC: 微信公众号
CONTRACT_METHOD_WECHAT_MINIPROGRAM: 微信小程序
CONTRACT_METHOD_WECHAT_H5: 微信H5
        :rtype: str
        """
        return self._ContractMethod

    @ContractMethod.setter
    def ContractMethod(self, ContractMethod):
        self._ContractMethod = ContractMethod

    @property
    def ContractSceneId(self):
        """在米大师侧分配的场景id
        :rtype: str
        """
        return self._ContractSceneId

    @ContractSceneId.setter
    def ContractSceneId(self, ContractSceneId):
        self._ContractSceneId = ContractSceneId

    @property
    def ExternalReturnContractData(self):
        """调用方从第三方渠道查询到的签约数据，由各个渠道定义
        :rtype: str
        """
        return self._ExternalReturnContractData

    @ExternalReturnContractData.setter
    def ExternalReturnContractData(self, ExternalReturnContractData):
        self._ExternalReturnContractData = ExternalReturnContractData


    def _deserialize(self, params):
        if params.get("ExternalReturnContractInfo") is not None:
            self._ExternalReturnContractInfo = ExternalReturnContractInfo()
            self._ExternalReturnContractInfo._deserialize(params.get("ExternalReturnContractInfo"))
        if params.get("ExternalContractUserInfo") is not None:
            self._ExternalContractUserInfo = []
            for item in params.get("ExternalContractUserInfo"):
                obj = ExternalContractUserInfo()
                obj._deserialize(item)
                self._ExternalContractUserInfo.append(obj)
        self._ContractMethod = params.get("ContractMethod")
        self._ContractSceneId = params.get("ContractSceneId")
        self._ExternalReturnContractData = params.get("ExternalReturnContractData")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContractUserInfo(AbstractModel):
    """用户信息

    """

    def __init__(self):
        r"""
        :param _UserType: USER_ID: 用户ID
ANONYMOUS: 匿名类型用户ID
        :type UserType: str
        :param _UserId: 用户类型
        :type UserId: str
        """
        self._UserType = None
        self._UserId = None

    @property
    def UserType(self):
        """USER_ID: 用户ID
ANONYMOUS: 匿名类型用户ID
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserId(self):
        """用户类型
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._UserType = params.get("UserType")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAcctRequest(AbstractModel):
    """CreateAcct请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MidasAppId: 聚鑫平台分配的支付MidasAppId
        :type MidasAppId: str
        :param _SubMchId: 业务平台的子商户ID，唯一
        :type SubMchId: str
        :param _SubMchName: 子商户名称
        :type SubMchName: str
        :param _Address: 子商户地址
        :type Address: str
        :param _Contact: 子商户联系人
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type Contact: str
        :param _Mobile: 联系人手机号
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type Mobile: str
        :param _Email: 邮箱 
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type Email: str
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasSignature: 按照聚鑫安全密钥计算的签名
        :type MidasSignature: str
        :param _SubMchType: 子商户类型：
个人: personal
企业: enterprise
个体工商户: individual
缺省: enterprise
        :type SubMchType: str
        :param _ShortName: 不填则默认子商户名称
        :type ShortName: str
        :param _SubMerchantMemberType: 子商户会员类型：
general: 普通子账户
merchant: 商户子账户
缺省: general
        :type SubMerchantMemberType: str
        :param _SubMerchantKey: 子商户密钥
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type SubMerchantKey: str
        :param _SubMerchantPrivateKey: 子商户私钥
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type SubMerchantPrivateKey: str
        :param _EncryptType: 敏感信息加密类型:
RSA: rsa非对称加密，使用RSA-PKCS1-v1_5
AES: aes对称加密，使用AES256-CBC-PCKS7padding
缺省: RSA
        :type EncryptType: str
        :param _SubAcctNo: 银行生成的子商户账户，已开户的场景需要录入
        :type SubAcctNo: str
        :param _MidasEnvironment: 环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type MidasEnvironment: str
        :param _SubMerchantStoreName: 店铺名称
企业、个体工商户必输
        :type SubMerchantStoreName: str
        :param _OrganizationInfo: 公司信息
        :type OrganizationInfo: :class:`tencentcloud.cpdp.v20190820.models.OrganizationInfo`
        :param _SubMerchantIdType: 子商户证件类型
1 - 身份证
3 - 回乡证
4 - 中国护照
5 - 台胞证
19 - 外国护照
52 - 组织机构代码证
68 - 营业执照 
73 - 统一社会信用代码
        :type SubMerchantIdType: str
        :param _SubMerchantIdCode: 子商户证件号码
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :type SubMerchantIdCode: str
        """
        self._MidasAppId = None
        self._SubMchId = None
        self._SubMchName = None
        self._Address = None
        self._Contact = None
        self._Mobile = None
        self._Email = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._SubMchType = None
        self._ShortName = None
        self._SubMerchantMemberType = None
        self._SubMerchantKey = None
        self._SubMerchantPrivateKey = None
        self._EncryptType = None
        self._SubAcctNo = None
        self._MidasEnvironment = None
        self._SubMerchantStoreName = None
        self._OrganizationInfo = None
        self._SubMerchantIdType = None
        self._SubMerchantIdCode = None

    @property
    def MidasAppId(self):
        """聚鑫平台分配的支付MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def SubMchId(self):
        """业务平台的子商户ID，唯一
        :rtype: str
        """
        return self._SubMchId

    @SubMchId.setter
    def SubMchId(self, SubMchId):
        self._SubMchId = SubMchId

    @property
    def SubMchName(self):
        """子商户名称
        :rtype: str
        """
        return self._SubMchName

    @SubMchName.setter
    def SubMchName(self, SubMchName):
        self._SubMchName = SubMchName

    @property
    def Address(self):
        """子商户地址
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def Contact(self):
        """子商户联系人
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._Contact

    @Contact.setter
    def Contact(self, Contact):
        self._Contact = Contact

    @property
    def Mobile(self):
        """联系人手机号
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._Mobile

    @Mobile.setter
    def Mobile(self, Mobile):
        self._Mobile = Mobile

    @property
    def Email(self):
        """邮箱 
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """按照聚鑫安全密钥计算的签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def SubMchType(self):
        """子商户类型：
个人: personal
企业: enterprise
个体工商户: individual
缺省: enterprise
        :rtype: str
        """
        return self._SubMchType

    @SubMchType.setter
    def SubMchType(self, SubMchType):
        self._SubMchType = SubMchType

    @property
    def ShortName(self):
        """不填则默认子商户名称
        :rtype: str
        """
        return self._ShortName

    @ShortName.setter
    def ShortName(self, ShortName):
        self._ShortName = ShortName

    @property
    def SubMerchantMemberType(self):
        """子商户会员类型：
general: 普通子账户
merchant: 商户子账户
缺省: general
        :rtype: str
        """
        return self._SubMerchantMemberType

    @SubMerchantMemberType.setter
    def SubMerchantMemberType(self, SubMerchantMemberType):
        self._SubMerchantMemberType = SubMerchantMemberType

    @property
    def SubMerchantKey(self):
        """子商户密钥
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._SubMerchantKey

    @SubMerchantKey.setter
    def SubMerchantKey(self, SubMerchantKey):
        self._SubMerchantKey = SubMerchantKey

    @property
    def SubMerchantPrivateKey(self):
        """子商户私钥
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._SubMerchantPrivateKey

    @SubMerchantPrivateKey.setter
    def SubMerchantPrivateKey(self, SubMerchantPrivateKey):
        self._SubMerchantPrivateKey = SubMerchantPrivateKey

    @property
    def EncryptType(self):
        """敏感信息加密类型:
RSA: rsa非对称加密，使用RSA-PKCS1-v1_5
AES: aes对称加密，使用AES256-CBC-PCKS7padding
缺省: RSA
        :rtype: str
        """
        return self._EncryptType

    @EncryptType.setter
    def EncryptType(self, EncryptType):
        self._EncryptType = EncryptType

    @property
    def SubAcctNo(self):
        """银行生成的子商户账户，已开户的场景需要录入
        :rtype: str
        """
        return self._SubAcctNo

    @SubAcctNo.setter
    def SubAcctNo(self, SubAcctNo):
        self._SubAcctNo = SubAcctNo

    @property
    def MidasEnvironment(self):
        """环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment

    @property
    def SubMerchantStoreName(self):
        """店铺名称
企业、个体工商户必输
        :rtype: str
        """
        return self._SubMerchantStoreName

    @SubMerchantStoreName.setter
    def SubMerchantStoreName(self, SubMerchantStoreName):
        self._SubMerchantStoreName = SubMerchantStoreName

    @property
    def OrganizationInfo(self):
        """公司信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OrganizationInfo`
        """
        return self._OrganizationInfo

    @OrganizationInfo.setter
    def OrganizationInfo(self, OrganizationInfo):
        self._OrganizationInfo = OrganizationInfo

    @property
    def SubMerchantIdType(self):
        """子商户证件类型
1 - 身份证
3 - 回乡证
4 - 中国护照
5 - 台胞证
19 - 外国护照
52 - 组织机构代码证
68 - 营业执照 
73 - 统一社会信用代码
        :rtype: str
        """
        return self._SubMerchantIdType

    @SubMerchantIdType.setter
    def SubMerchantIdType(self, SubMerchantIdType):
        self._SubMerchantIdType = SubMerchantIdType

    @property
    def SubMerchantIdCode(self):
        """子商户证件号码
<敏感信息>加密详见<a href="https://cloud.tencent.com/document/product/1122/48979" target="_blank">《商户端接口敏感信息加密说明》</a>
        :rtype: str
        """
        return self._SubMerchantIdCode

    @SubMerchantIdCode.setter
    def SubMerchantIdCode(self, SubMerchantIdCode):
        self._SubMerchantIdCode = SubMerchantIdCode


    def _deserialize(self, params):
        self._MidasAppId = params.get("MidasAppId")
        self._SubMchId = params.get("SubMchId")
        self._SubMchName = params.get("SubMchName")
        self._Address = params.get("Address")
        self._Contact = params.get("Contact")
        self._Mobile = params.get("Mobile")
        self._Email = params.get("Email")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        self._SubMchType = params.get("SubMchType")
        self._ShortName = params.get("ShortName")
        self._SubMerchantMemberType = params.get("SubMerchantMemberType")
        self._SubMerchantKey = params.get("SubMerchantKey")
        self._SubMerchantPrivateKey = params.get("SubMerchantPrivateKey")
        self._EncryptType = params.get("EncryptType")
        self._SubAcctNo = params.get("SubAcctNo")
        self._MidasEnvironment = params.get("MidasEnvironment")
        self._SubMerchantStoreName = params.get("SubMerchantStoreName")
        if params.get("OrganizationInfo") is not None:
            self._OrganizationInfo = OrganizationInfo()
            self._OrganizationInfo._deserialize(params.get("OrganizationInfo"))
        self._SubMerchantIdType = params.get("SubMerchantIdType")
        self._SubMerchantIdCode = params.get("SubMerchantIdCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAcctResponse(AbstractModel):
    """CreateAcct返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: 聚鑫计费SubAppId，代表子商户
        :type SubAppId: str
        :param _SubAcctNo: 银行生成的子商户账户
        :type SubAcctNo: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SubAppId = None
        self._SubAcctNo = None
        self._RequestId = None

    @property
    def SubAppId(self):
        """聚鑫计费SubAppId，代表子商户
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SubAcctNo(self):
        """银行生成的子商户账户
        :rtype: str
        """
        return self._SubAcctNo

    @SubAcctNo.setter
    def SubAcctNo(self, SubAcctNo):
        self._SubAcctNo = SubAcctNo

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._SubAcctNo = params.get("SubAcctNo")
        self._RequestId = params.get("RequestId")


class CreateAgentTaxPaymentInfosRequest(AbstractModel):
    """CreateAgentTaxPaymentInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentId: 代理商ID
        :type AgentId: str
        :param _Channel: 平台渠道
        :type Channel: int
        :param _Type: 类型。0-视同，1-个体工商户
        :type Type: int
        :param _RawElectronicCertUrl: 源电子凭证下载地址
        :type RawElectronicCertUrl: str
        :param _FileName: 文件名
        :type FileName: str
        :param _AgentTaxPaymentInfos: 完税信息
        :type AgentTaxPaymentInfos: list of AgentTaxPayment
        :param _Profile: 接入环境。沙箱环境填sandbox
        :type Profile: str
        """
        self._AgentId = None
        self._Channel = None
        self._Type = None
        self._RawElectronicCertUrl = None
        self._FileName = None
        self._AgentTaxPaymentInfos = None
        self._Profile = None

    @property
    def AgentId(self):
        """代理商ID
        :rtype: str
        """
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def Channel(self):
        """平台渠道
        :rtype: int
        """
        return self._Channel

    @Channel.setter
    def Channel(self, Channel):
        self._Channel = Channel

    @property
    def Type(self):
        """类型。0-视同，1-个体工商户
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RawElectronicCertUrl(self):
        """源电子凭证下载地址
        :rtype: str
        """
        return self._RawElectronicCertUrl

    @RawElectronicCertUrl.setter
    def RawElectronicCertUrl(self, RawElectronicCertUrl):
        self._RawElectronicCertUrl = RawElectronicCertUrl

    @property
    def FileName(self):
        """文件名
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def AgentTaxPaymentInfos(self):
        """完税信息
        :rtype: list of AgentTaxPayment
        """
        return self._AgentTaxPaymentInfos

    @AgentTaxPaymentInfos.setter
    def AgentTaxPaymentInfos(self, AgentTaxPaymentInfos):
        self._AgentTaxPaymentInfos = AgentTaxPaymentInfos

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._Channel = params.get("Channel")
        self._Type = params.get("Type")
        self._RawElectronicCertUrl = params.get("RawElectronicCertUrl")
        self._FileName = params.get("FileName")
        if params.get("AgentTaxPaymentInfos") is not None:
            self._AgentTaxPaymentInfos = []
            for item in params.get("AgentTaxPaymentInfos"):
                obj = AgentTaxPayment()
                obj._deserialize(item)
                self._AgentTaxPaymentInfos.append(obj)
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAgentTaxPaymentInfosResponse(AbstractModel):
    """CreateAgentTaxPaymentInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentTaxPaymentBatch: 代理商完税证明批次信息
        :type AgentTaxPaymentBatch: :class:`tencentcloud.cpdp.v20190820.models.AgentTaxPaymentBatch`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AgentTaxPaymentBatch = None
        self._RequestId = None

    @property
    def AgentTaxPaymentBatch(self):
        """代理商完税证明批次信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.AgentTaxPaymentBatch`
        """
        return self._AgentTaxPaymentBatch

    @AgentTaxPaymentBatch.setter
    def AgentTaxPaymentBatch(self, AgentTaxPaymentBatch):
        self._AgentTaxPaymentBatch = AgentTaxPaymentBatch

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AgentTaxPaymentBatch") is not None:
            self._AgentTaxPaymentBatch = AgentTaxPaymentBatch()
            self._AgentTaxPaymentBatch._deserialize(params.get("AgentTaxPaymentBatch"))
        self._RequestId = params.get("RequestId")


class CreateAnchorRequest(AbstractModel):
    """CreateAnchor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AnchorUid: 主播业务ID，唯一
        :type AnchorUid: str
        :param _AnchorName: 主播姓名
        :type AnchorName: str
        :param _AnchorPhone: 主播电话
_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密
        :type AnchorPhone: str
        :param _AnchorEmail: 主播邮箱
_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密
        :type AnchorEmail: str
        :param _AnchorAddress: 主播地址
_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密
        :type AnchorAddress: str
        :param _AnchorIdNo: 主播身份证号
_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密
        :type AnchorIdNo: str
        :param _AnchorType: 主播类型
__KMusic__:全民K歌
__QMusic__:QQ音乐
__WeChat__:微信视频号
        :type AnchorType: str
        :param _AnchorExtendInfo: 主播扩展信息
        :type AnchorExtendInfo: list of AnchorExtendInfo
        """
        self._AnchorUid = None
        self._AnchorName = None
        self._AnchorPhone = None
        self._AnchorEmail = None
        self._AnchorAddress = None
        self._AnchorIdNo = None
        self._AnchorType = None
        self._AnchorExtendInfo = None

    @property
    def AnchorUid(self):
        """主播业务ID，唯一
        :rtype: str
        """
        return self._AnchorUid

    @AnchorUid.setter
    def AnchorUid(self, AnchorUid):
        self._AnchorUid = AnchorUid

    @property
    def AnchorName(self):
        """主播姓名
        :rtype: str
        """
        return self._AnchorName

    @AnchorName.setter
    def AnchorName(self, AnchorName):
        self._AnchorName = AnchorName

    @property
    def AnchorPhone(self):
        """主播电话
_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密
        :rtype: str
        """
        return self._AnchorPhone

    @AnchorPhone.setter
    def AnchorPhone(self, AnchorPhone):
        self._AnchorPhone = AnchorPhone

    @property
    def AnchorEmail(self):
        """主播邮箱
_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密
        :rtype: str
        """
        return self._AnchorEmail

    @AnchorEmail.setter
    def AnchorEmail(self, AnchorEmail):
        self._AnchorEmail = AnchorEmail

    @property
    def AnchorAddress(self):
        """主播地址
_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密
        :rtype: str
        """
        return self._AnchorAddress

    @AnchorAddress.setter
    def AnchorAddress(self, AnchorAddress):
        self._AnchorAddress = AnchorAddress

    @property
    def AnchorIdNo(self):
        """主播身份证号
_敏感信息_ 使用 __AES128-CBC-PKCS#7__ 加密
        :rtype: str
        """
        return self._AnchorIdNo

    @AnchorIdNo.setter
    def AnchorIdNo(self, AnchorIdNo):
        self._AnchorIdNo = AnchorIdNo

    @property
    def AnchorType(self):
        """主播类型
__KMusic__:全民K歌
__QMusic__:QQ音乐
__WeChat__:微信视频号
        :rtype: str
        """
        return self._AnchorType

    @AnchorType.setter
    def AnchorType(self, AnchorType):
        self._AnchorType = AnchorType

    @property
    def AnchorExtendInfo(self):
        """主播扩展信息
        :rtype: list of AnchorExtendInfo
        """
        return self._AnchorExtendInfo

    @AnchorExtendInfo.setter
    def AnchorExtendInfo(self, AnchorExtendInfo):
        self._AnchorExtendInfo = AnchorExtendInfo


    def _deserialize(self, params):
        self._AnchorUid = params.get("AnchorUid")
        self._AnchorName = params.get("AnchorName")
        self._AnchorPhone = params.get("AnchorPhone")
        self._AnchorEmail = params.get("AnchorEmail")
        self._AnchorAddress = params.get("AnchorAddress")
        self._AnchorIdNo = params.get("AnchorIdNo")
        self._AnchorType = params.get("AnchorType")
        if params.get("AnchorExtendInfo") is not None:
            self._AnchorExtendInfo = []
            for item in params.get("AnchorExtendInfo"):
                obj = AnchorExtendInfo()
                obj._deserialize(item)
                self._AnchorExtendInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnchorResponse(AbstractModel):
    """CreateAnchor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AnchorId: 主播ID
        :type AnchorId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AnchorId = None
        self._RequestId = None

    @property
    def AnchorId(self):
        """主播ID
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AnchorId = params.get("AnchorId")
        self._RequestId = params.get("RequestId")


class CreateBatchPaymentBatchData(AbstractModel):
    """CreateBatchPayment接口BatchInfo对象

    """

    def __init__(self):
        r"""
        :param _OrderId: 订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OrderId: str
        :param _TradeSerialNo: 交易流水号
注意：此字段可能返回 null，表示取不到有效值。
        :type TradeSerialNo: str
        :param _Status: 交易状态。
0 处理中  
1 预占成功 
2 交易成功 
3 交易失败 
4 未知渠道异常 
5 预占额度失败
6 提交成功
7 提交失败
8 订单重复提交
99 未知系统异常
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _StatusDesc: 状态描述
注意：此字段可能返回 null，表示取不到有效值。
        :type StatusDesc: str
        :param _AgentId: 代理商ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentId: str
        :param _AgentName: 代理商名称
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentName: str
        """
        self._OrderId = None
        self._TradeSerialNo = None
        self._Status = None
        self._StatusDesc = None
        self._AgentId = None
        self._AgentName = None

    @property
    def OrderId(self):
        """订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def TradeSerialNo(self):
        """交易流水号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TradeSerialNo

    @TradeSerialNo.setter
    def TradeSerialNo(self, TradeSerialNo):
        self._TradeSerialNo = TradeSerialNo

    @property
    def Status(self):
        """交易状态。
0 处理中  
1 预占成功 
2 交易成功 
3 交易失败 
4 未知渠道异常 
5 预占额度失败
6 提交成功
7 提交失败
8 订单重复提交
99 未知系统异常
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusDesc(self):
        """状态描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def AgentId(self):
        """代理商ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def AgentName(self):
        """代理商名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName


    def _deserialize(self, params):
        self._OrderId = params.get("OrderId")
        self._TradeSerialNo = params.get("TradeSerialNo")
        self._Status = params.get("Status")
        self._StatusDesc = params.get("StatusDesc")
        self._AgentId = params.get("AgentId")
        self._AgentName = params.get("AgentName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBatchPaymentData(AbstractModel):
    """CreateBatchPayment接口返回响应

    """

    def __init__(self):
        r"""
        :param _BatchId: 批次号
        :type BatchId: str
        :param _BatchInfoList: 批次列表详情
注意：此字段可能返回 null，表示取不到有效值。
        :type BatchInfoList: list of CreateBatchPaymentBatchData
        """
        self._BatchId = None
        self._BatchInfoList = None

    @property
    def BatchId(self):
        """批次号
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def BatchInfoList(self):
        """批次列表详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CreateBatchPaymentBatchData
        """
        return self._BatchInfoList

    @BatchInfoList.setter
    def BatchInfoList(self, BatchInfoList):
        self._BatchInfoList = BatchInfoList


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        if params.get("BatchInfoList") is not None:
            self._BatchInfoList = []
            for item in params.get("BatchInfoList"):
                obj = CreateBatchPaymentBatchData()
                obj._deserialize(item)
                self._BatchInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBatchPaymentRecipient(AbstractModel):
    """CreateBatchPayment转账明细

    """

    def __init__(self):
        r"""
        :param _TransferAmount: 转账金额
        :type TransferAmount: int
        :param _OrderId: 订单号
        :type OrderId: str
        :param _AnchorId: 主播ID（与主播业务ID不能同时为空，两者都填取主播ID）
        :type AnchorId: str
        :param _Uid: 主播业务ID（与主播业务ID不能同时为空，两者都填取主播ID）
        :type Uid: str
        :param _AnchorName: 主播名称。如果该字段填入，则会对AnchorName和AnchorId/Uid进行校验。
        :type AnchorName: str
        :param _Remark: 业务备注
        :type Remark: str
        :param _ReqReserved: 子单请求预留字段
        :type ReqReserved: str
        """
        self._TransferAmount = None
        self._OrderId = None
        self._AnchorId = None
        self._Uid = None
        self._AnchorName = None
        self._Remark = None
        self._ReqReserved = None

    @property
    def TransferAmount(self):
        """转账金额
        :rtype: int
        """
        return self._TransferAmount

    @TransferAmount.setter
    def TransferAmount(self, TransferAmount):
        self._TransferAmount = TransferAmount

    @property
    def OrderId(self):
        """订单号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def AnchorId(self):
        """主播ID（与主播业务ID不能同时为空，两者都填取主播ID）
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def Uid(self):
        """主播业务ID（与主播业务ID不能同时为空，两者都填取主播ID）
        :rtype: str
        """
        return self._Uid

    @Uid.setter
    def Uid(self, Uid):
        self._Uid = Uid

    @property
    def AnchorName(self):
        """主播名称。如果该字段填入，则会对AnchorName和AnchorId/Uid进行校验。
        :rtype: str
        """
        return self._AnchorName

    @AnchorName.setter
    def AnchorName(self, AnchorName):
        self._AnchorName = AnchorName

    @property
    def Remark(self):
        """业务备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ReqReserved(self):
        """子单请求预留字段
        :rtype: str
        """
        return self._ReqReserved

    @ReqReserved.setter
    def ReqReserved(self, ReqReserved):
        self._ReqReserved = ReqReserved


    def _deserialize(self, params):
        self._TransferAmount = params.get("TransferAmount")
        self._OrderId = params.get("OrderId")
        self._AnchorId = params.get("AnchorId")
        self._Uid = params.get("Uid")
        self._AnchorName = params.get("AnchorName")
        self._Remark = params.get("Remark")
        self._ReqReserved = params.get("ReqReserved")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBatchPaymentRequest(AbstractModel):
    """CreateBatchPayment请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TransferType: 1 微信企业付款 
2 支付宝转账 
3 平安银企直连代发转账
        :type TransferType: int
        :param _RecipientList: 转账详情
        :type RecipientList: list of CreateBatchPaymentRecipient
        :param _ReqReserved: 请求预留字段
        :type ReqReserved: str
        :param _NotifyUrl: 回调Url
        :type NotifyUrl: str
        """
        self._TransferType = None
        self._RecipientList = None
        self._ReqReserved = None
        self._NotifyUrl = None

    @property
    def TransferType(self):
        """1 微信企业付款 
2 支付宝转账 
3 平安银企直连代发转账
        :rtype: int
        """
        return self._TransferType

    @TransferType.setter
    def TransferType(self, TransferType):
        self._TransferType = TransferType

    @property
    def RecipientList(self):
        """转账详情
        :rtype: list of CreateBatchPaymentRecipient
        """
        return self._RecipientList

    @RecipientList.setter
    def RecipientList(self, RecipientList):
        self._RecipientList = RecipientList

    @property
    def ReqReserved(self):
        """请求预留字段
        :rtype: str
        """
        return self._ReqReserved

    @ReqReserved.setter
    def ReqReserved(self, ReqReserved):
        self._ReqReserved = ReqReserved

    @property
    def NotifyUrl(self):
        """回调Url
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl


    def _deserialize(self, params):
        self._TransferType = params.get("TransferType")
        if params.get("RecipientList") is not None:
            self._RecipientList = []
            for item in params.get("RecipientList"):
                obj = CreateBatchPaymentRecipient()
                obj._deserialize(item)
                self._RecipientList.append(obj)
        self._ReqReserved = params.get("ReqReserved")
        self._NotifyUrl = params.get("NotifyUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBatchPaymentResponse(AbstractModel):
    """CreateBatchPayment返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。响应成功："SUCCESS"，其他为不成功。
        :type ErrCode: str
        :param _ErrMessage: 响应消息。
        :type ErrMessage: str
        :param _Result: 返回响应
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateBatchPaymentData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。响应成功："SUCCESS"，其他为不成功。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """响应消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回响应
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateBatchPaymentData`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateBatchPaymentData()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateCloudSubMerchantRequest(AbstractModel):
    """CreateCloudSubMerchant请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MidasAppId: 米大师分配的支付主MidasAppId，根应用Id。
        :type MidasAppId: str
        :param _ParentAppId: 父应用Id。
        :type ParentAppId: str
        :param _SubMchName: 子商户名。
        :type SubMchName: str
        :param _SubMchDescription: 子商户描述。
        :type SubMchDescription: str
        :param _MidasEnvironment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type MidasEnvironment: str
        :param _SubAppId: 子应用Id，为空则自动创建子应用id。
        :type SubAppId: str
        :param _SubMchShortName: 子商户名缩写。
        :type SubMchShortName: str
        :param _OutSubMerchantId: 业务平台自定义的子商户Id，唯一。
        :type OutSubMerchantId: str
        """
        self._MidasAppId = None
        self._ParentAppId = None
        self._SubMchName = None
        self._SubMchDescription = None
        self._MidasEnvironment = None
        self._SubAppId = None
        self._SubMchShortName = None
        self._OutSubMerchantId = None

    @property
    def MidasAppId(self):
        """米大师分配的支付主MidasAppId，根应用Id。
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def ParentAppId(self):
        """父应用Id。
        :rtype: str
        """
        return self._ParentAppId

    @ParentAppId.setter
    def ParentAppId(self, ParentAppId):
        self._ParentAppId = ParentAppId

    @property
    def SubMchName(self):
        """子商户名。
        :rtype: str
        """
        return self._SubMchName

    @SubMchName.setter
    def SubMchName(self, SubMchName):
        self._SubMchName = SubMchName

    @property
    def SubMchDescription(self):
        """子商户描述。
        :rtype: str
        """
        return self._SubMchDescription

    @SubMchDescription.setter
    def SubMchDescription(self, SubMchDescription):
        self._SubMchDescription = SubMchDescription

    @property
    def MidasEnvironment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment

    @property
    def SubAppId(self):
        """子应用Id，为空则自动创建子应用id。
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SubMchShortName(self):
        """子商户名缩写。
        :rtype: str
        """
        return self._SubMchShortName

    @SubMchShortName.setter
    def SubMchShortName(self, SubMchShortName):
        self._SubMchShortName = SubMchShortName

    @property
    def OutSubMerchantId(self):
        """业务平台自定义的子商户Id，唯一。
        :rtype: str
        """
        return self._OutSubMerchantId

    @OutSubMerchantId.setter
    def OutSubMerchantId(self, OutSubMerchantId):
        self._OutSubMerchantId = OutSubMerchantId


    def _deserialize(self, params):
        self._MidasAppId = params.get("MidasAppId")
        self._ParentAppId = params.get("ParentAppId")
        self._SubMchName = params.get("SubMchName")
        self._SubMchDescription = params.get("SubMchDescription")
        self._MidasEnvironment = params.get("MidasEnvironment")
        self._SubAppId = params.get("SubAppId")
        self._SubMchShortName = params.get("SubMchShortName")
        self._OutSubMerchantId = params.get("OutSubMerchantId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCloudSubMerchantResponse(AbstractModel):
    """CreateCloudSubMerchant返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: 子应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAppId: str
        :param _ChannelSubMerchantId: 渠道子商户ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelSubMerchantId: str
        :param _Level: 层级，从0开始
注意：此字段可能返回 null，表示取不到有效值。
        :type Level: int
        :param _ChannelAppId: 渠道应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelAppId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SubAppId = None
        self._ChannelSubMerchantId = None
        self._Level = None
        self._ChannelAppId = None
        self._RequestId = None

    @property
    def SubAppId(self):
        """子应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def Level(self):
        """层级，从0开始
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def ChannelAppId(self):
        """渠道应用ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelAppId

    @ChannelAppId.setter
    def ChannelAppId(self, ChannelAppId):
        self._ChannelAppId = ChannelAppId

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._Level = params.get("Level")
        self._ChannelAppId = params.get("ChannelAppId")
        self._RequestId = params.get("RequestId")


class CreateCustAcctIdRequest(AbstractModel):
    """CreateCustAcctId请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionFlag: STRING(2)，功能标志（1: 开户; 3: 销户）
        :type FunctionFlag: str
        :param _FundSummaryAcctNo: STRING(50)，资金汇总账号（即收单资金归集入账的账号）
        :type FundSummaryAcctNo: str
        :param _TranNetMemberCode: STRING(32)，交易网会员代码（平台端的用户ID，需要保证唯一性，可数字字母混合，如HY_120）
        :type TranNetMemberCode: str
        :param _MemberProperty: STRING(10)，会员属性（00-普通子账户(默认); SH-商户子账户）
        :type MemberProperty: str
        :param _Mobile: STRING(30)，手机号码
        :type Mobile: str
        :param _MrchCode: String(22)，商户号（签约客户号）
        :type MrchCode: str
        :param _SelfBusiness: String(2)，是否为自营业务（0位非自营，1为自营）
        :type SelfBusiness: bool
        :param _ContactName: String(64)，联系人
        :type ContactName: str
        :param _SubAcctName: String(64)，子账户名称
        :type SubAcctName: str
        :param _SubAcctShortName: String(64)，子账户简称
        :type SubAcctShortName: str
        :param _SubAcctType: String(4)，子账户类型（0: 个人子账户; 1: 企业子账户）
        :type SubAcctType: int
        :param _UserNickname: STRING(150)，用户昵称
        :type UserNickname: str
        :param _Email: STRING(150)，邮箱
        :type Email: str
        :param _ReservedMsg: STRING(1027)，保留域
        :type ReservedMsg: str
        :param _Profile: STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :type Profile: str
        """
        self._FunctionFlag = None
        self._FundSummaryAcctNo = None
        self._TranNetMemberCode = None
        self._MemberProperty = None
        self._Mobile = None
        self._MrchCode = None
        self._SelfBusiness = None
        self._ContactName = None
        self._SubAcctName = None
        self._SubAcctShortName = None
        self._SubAcctType = None
        self._UserNickname = None
        self._Email = None
        self._ReservedMsg = None
        self._Profile = None

    @property
    def FunctionFlag(self):
        """STRING(2)，功能标志（1: 开户; 3: 销户）
        :rtype: str
        """
        return self._FunctionFlag

    @FunctionFlag.setter
    def FunctionFlag(self, FunctionFlag):
        self._FunctionFlag = FunctionFlag

    @property
    def FundSummaryAcctNo(self):
        """STRING(50)，资金汇总账号（即收单资金归集入账的账号）
        :rtype: str
        """
        return self._FundSummaryAcctNo

    @FundSummaryAcctNo.setter
    def FundSummaryAcctNo(self, FundSummaryAcctNo):
        self._FundSummaryAcctNo = FundSummaryAcctNo

    @property
    def TranNetMemberCode(self):
        """STRING(32)，交易网会员代码（平台端的用户ID，需要保证唯一性，可数字字母混合，如HY_120）
        :rtype: str
        """
        return self._TranNetMemberCode

    @TranNetMemberCode.setter
    def TranNetMemberCode(self, TranNetMemberCode):
        self._TranNetMemberCode = TranNetMemberCode

    @property
    def MemberProperty(self):
        """STRING(10)，会员属性（00-普通子账户(默认); SH-商户子账户）
        :rtype: str
        """
        return self._MemberProperty

    @MemberProperty.setter
    def MemberProperty(self, MemberProperty):
        self._MemberProperty = MemberProperty

    @property
    def Mobile(self):
        """STRING(30)，手机号码
        :rtype: str
        """
        return self._Mobile

    @Mobile.setter
    def Mobile(self, Mobile):
        self._Mobile = Mobile

    @property
    def MrchCode(self):
        """String(22)，商户号（签约客户号）
        :rtype: str
        """
        return self._MrchCode

    @MrchCode.setter
    def MrchCode(self, MrchCode):
        self._MrchCode = MrchCode

    @property
    def SelfBusiness(self):
        """String(2)，是否为自营业务（0位非自营，1为自营）
        :rtype: bool
        """
        return self._SelfBusiness

    @SelfBusiness.setter
    def SelfBusiness(self, SelfBusiness):
        self._SelfBusiness = SelfBusiness

    @property
    def ContactName(self):
        """String(64)，联系人
        :rtype: str
        """
        return self._ContactName

    @ContactName.setter
    def ContactName(self, ContactName):
        self._ContactName = ContactName

    @property
    def SubAcctName(self):
        """String(64)，子账户名称
        :rtype: str
        """
        return self._SubAcctName

    @SubAcctName.setter
    def SubAcctName(self, SubAcctName):
        self._SubAcctName = SubAcctName

    @property
    def SubAcctShortName(self):
        """String(64)，子账户简称
        :rtype: str
        """
        return self._SubAcctShortName

    @SubAcctShortName.setter
    def SubAcctShortName(self, SubAcctShortName):
        self._SubAcctShortName = SubAcctShortName

    @property
    def SubAcctType(self):
        """String(4)，子账户类型（0: 个人子账户; 1: 企业子账户）
        :rtype: int
        """
        return self._SubAcctType

    @SubAcctType.setter
    def SubAcctType(self, SubAcctType):
        self._SubAcctType = SubAcctType

    @property
    def UserNickname(self):
        """STRING(150)，用户昵称
        :rtype: str
        """
        return self._UserNickname

    @UserNickname.setter
    def UserNickname(self, UserNickname):
        self._UserNickname = UserNickname

    @property
    def Email(self):
        """STRING(150)，邮箱
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def Profile(self):
        """STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._FunctionFlag = params.get("FunctionFlag")
        self._FundSummaryAcctNo = params.get("FundSummaryAcctNo")
        self._TranNetMemberCode = params.get("TranNetMemberCode")
        self._MemberProperty = params.get("MemberProperty")
        self._Mobile = params.get("Mobile")
        self._MrchCode = params.get("MrchCode")
        self._SelfBusiness = params.get("SelfBusiness")
        self._ContactName = params.get("ContactName")
        self._SubAcctName = params.get("SubAcctName")
        self._SubAcctShortName = params.get("SubAcctShortName")
        self._SubAcctType = params.get("SubAcctType")
        self._UserNickname = params.get("UserNickname")
        self._Email = params.get("Email")
        self._ReservedMsg = params.get("ReservedMsg")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustAcctIdResponse(AbstractModel):
    """CreateCustAcctId返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAcctNo: STRING(50)，见证子账户的账号（平台需要记录下来，后续所有接口交互都会用到）
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAcctNo: str
        :param _ReservedMsg: STRING(1027)，保留域（需要开通智能收款，此处返回智能收款账号，正常情况下返回空）
注意：此字段可能返回 null，表示取不到有效值。
        :type ReservedMsg: str
        :param _TxnReturnCode: String(20)，返回码
        :type TxnReturnCode: str
        :param _TxnReturnMsg: String(100)，返回信息
        :type TxnReturnMsg: str
        :param _CnsmrSeqNo: String(22)，交易流水号
        :type CnsmrSeqNo: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SubAcctNo = None
        self._ReservedMsg = None
        self._TxnReturnCode = None
        self._TxnReturnMsg = None
        self._CnsmrSeqNo = None
        self._RequestId = None

    @property
    def SubAcctNo(self):
        """STRING(50)，见证子账户的账号（平台需要记录下来，后续所有接口交互都会用到）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAcctNo

    @SubAcctNo.setter
    def SubAcctNo(self, SubAcctNo):
        self._SubAcctNo = SubAcctNo

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域（需要开通智能收款，此处返回智能收款账号，正常情况下返回空）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def TxnReturnCode(self):
        """String(20)，返回码
        :rtype: str
        """
        return self._TxnReturnCode

    @TxnReturnCode.setter
    def TxnReturnCode(self, TxnReturnCode):
        self._TxnReturnCode = TxnReturnCode

    @property
    def TxnReturnMsg(self):
        """String(100)，返回信息
        :rtype: str
        """
        return self._TxnReturnMsg

    @TxnReturnMsg.setter
    def TxnReturnMsg(self, TxnReturnMsg):
        self._TxnReturnMsg = TxnReturnMsg

    @property
    def CnsmrSeqNo(self):
        """String(22)，交易流水号
        :rtype: str
        """
        return self._CnsmrSeqNo

    @CnsmrSeqNo.setter
    def CnsmrSeqNo(self, CnsmrSeqNo):
        self._CnsmrSeqNo = CnsmrSeqNo

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SubAcctNo = params.get("SubAcctNo")
        self._ReservedMsg = params.get("ReservedMsg")
        self._TxnReturnCode = params.get("TxnReturnCode")
        self._TxnReturnMsg = params.get("TxnReturnMsg")
        self._CnsmrSeqNo = params.get("CnsmrSeqNo")
        self._RequestId = params.get("RequestId")


class CreateExternalAccountBookResult(AbstractModel):
    """创建第三方电子记账本返回值

    """

    def __init__(self):
        r"""
        :param _DealStatus: 处理状态。
__SUCCESS__: 成功
__FAILED__: 失败
__PROCESSING__: 进行中。
        :type DealStatus: str
        :param _DealMessage: 处理返回描述，例如失败原因等
注意：此字段可能返回 null，表示取不到有效值。
        :type DealMessage: str
        :param _ChannelAccountBookId: 渠道电子记账本ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelAccountBookId: str
        :param _CollectMoneyAccountInfo: 电子记账本对外收款的账户信息。为JSON格式字符串（成功状态下返回）。详情见附录-复杂类型。
注意：此字段可能返回 null，表示取不到有效值。
        :type CollectMoneyAccountInfo: str
        """
        self._DealStatus = None
        self._DealMessage = None
        self._ChannelAccountBookId = None
        self._CollectMoneyAccountInfo = None

    @property
    def DealStatus(self):
        """处理状态。
__SUCCESS__: 成功
__FAILED__: 失败
__PROCESSING__: 进行中。
        :rtype: str
        """
        return self._DealStatus

    @DealStatus.setter
    def DealStatus(self, DealStatus):
        self._DealStatus = DealStatus

    @property
    def DealMessage(self):
        """处理返回描述，例如失败原因等
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DealMessage

    @DealMessage.setter
    def DealMessage(self, DealMessage):
        self._DealMessage = DealMessage

    @property
    def ChannelAccountBookId(self):
        """渠道电子记账本ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelAccountBookId

    @ChannelAccountBookId.setter
    def ChannelAccountBookId(self, ChannelAccountBookId):
        self._ChannelAccountBookId = ChannelAccountBookId

    @property
    def CollectMoneyAccountInfo(self):
        """电子记账本对外收款的账户信息。为JSON格式字符串（成功状态下返回）。详情见附录-复杂类型。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CollectMoneyAccountInfo

    @CollectMoneyAccountInfo.setter
    def CollectMoneyAccountInfo(self, CollectMoneyAccountInfo):
        self._CollectMoneyAccountInfo = CollectMoneyAccountInfo


    def _deserialize(self, params):
        self._DealStatus = params.get("DealStatus")
        self._DealMessage = params.get("DealMessage")
        self._ChannelAccountBookId = params.get("ChannelAccountBookId")
        self._CollectMoneyAccountInfo = params.get("CollectMoneyAccountInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExternalAnchorData(AbstractModel):
    """CreateExternalAnchor接口返回参数

    """

    def __init__(self):
        r"""
        :param _AnchorId: 主播Id
        :type AnchorId: str
        """
        self._AnchorId = None

    @property
    def AnchorId(self):
        """主播Id
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId


    def _deserialize(self, params):
        self._AnchorId = params.get("AnchorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExternalAnchorRequest(AbstractModel):
    """CreateExternalAnchor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uid: 平台业务系统唯一标示的主播id
        :type Uid: str
        :param _Name: 主播名称
        :type Name: str
        :param _IdNo: 身份证号
        :type IdNo: str
        :param _IdCardFront: 身份证正面图片下载链接
        :type IdCardFront: str
        :param _IdCardReverse: 身份证反面图片下载链接
        :type IdCardReverse: str
        :param _AgentId: 指定分配的代理商ID
        :type AgentId: str
        """
        self._Uid = None
        self._Name = None
        self._IdNo = None
        self._IdCardFront = None
        self._IdCardReverse = None
        self._AgentId = None

    @property
    def Uid(self):
        """平台业务系统唯一标示的主播id
        :rtype: str
        """
        return self._Uid

    @Uid.setter
    def Uid(self, Uid):
        self._Uid = Uid

    @property
    def Name(self):
        """主播名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def IdNo(self):
        """身份证号
        :rtype: str
        """
        return self._IdNo

    @IdNo.setter
    def IdNo(self, IdNo):
        self._IdNo = IdNo

    @property
    def IdCardFront(self):
        """身份证正面图片下载链接
        :rtype: str
        """
        return self._IdCardFront

    @IdCardFront.setter
    def IdCardFront(self, IdCardFront):
        self._IdCardFront = IdCardFront

    @property
    def IdCardReverse(self):
        """身份证反面图片下载链接
        :rtype: str
        """
        return self._IdCardReverse

    @IdCardReverse.setter
    def IdCardReverse(self, IdCardReverse):
        self._IdCardReverse = IdCardReverse

    @property
    def AgentId(self):
        """指定分配的代理商ID
        :rtype: str
        """
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId


    def _deserialize(self, params):
        self._Uid = params.get("Uid")
        self._Name = params.get("Name")
        self._IdNo = params.get("IdNo")
        self._IdCardFront = params.get("IdCardFront")
        self._IdCardReverse = params.get("IdCardReverse")
        self._AgentId = params.get("AgentId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExternalAnchorResponse(AbstractModel):
    """CreateExternalAnchor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。响应成功："SUCCESS"，其他为不成功。
        :type ErrCode: str
        :param _ErrMessage: 响应消息。
        :type ErrMessage: str
        :param _Result: 返回响应
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateExternalAnchorData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。响应成功："SUCCESS"，其他为不成功。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """响应消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回响应
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateExternalAnchorData`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateExternalAnchorData()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateFlexPayeeRequest(AbstractModel):
    """CreateFlexPayee请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OutUserId: 用户外部业务ID
        :type OutUserId: str
        :param _Name: 姓名
        :type Name: str
        :param _IdNo: 证件号
        :type IdNo: str
        :param _AccountName: 账户名称
        :type AccountName: str
        :param _ServiceProviderId: 服务商ID
        :type ServiceProviderId: str
        :param _TaxInfo: 计税信息
        :type TaxInfo: :class:`tencentcloud.cpdp.v20190820.models.PayeeTaxInfo`
        :param _IdType: 证件类型
0:身份证
1:社会信用代码
        :type IdType: int
        :param _Remark: 备注
        :type Remark: str
        :param _PhoneNo: 手机号码
        :type PhoneNo: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        """
        self._OutUserId = None
        self._Name = None
        self._IdNo = None
        self._AccountName = None
        self._ServiceProviderId = None
        self._TaxInfo = None
        self._IdType = None
        self._Remark = None
        self._PhoneNo = None
        self._Environment = None

    @property
    def OutUserId(self):
        """用户外部业务ID
        :rtype: str
        """
        return self._OutUserId

    @OutUserId.setter
    def OutUserId(self, OutUserId):
        self._OutUserId = OutUserId

    @property
    def Name(self):
        """姓名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def IdNo(self):
        """证件号
        :rtype: str
        """
        return self._IdNo

    @IdNo.setter
    def IdNo(self, IdNo):
        self._IdNo = IdNo

    @property
    def AccountName(self):
        """账户名称
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def ServiceProviderId(self):
        """服务商ID
        :rtype: str
        """
        return self._ServiceProviderId

    @ServiceProviderId.setter
    def ServiceProviderId(self, ServiceProviderId):
        self._ServiceProviderId = ServiceProviderId

    @property
    def TaxInfo(self):
        """计税信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.PayeeTaxInfo`
        """
        return self._TaxInfo

    @TaxInfo.setter
    def TaxInfo(self, TaxInfo):
        self._TaxInfo = TaxInfo

    @property
    def IdType(self):
        """证件类型
0:身份证
1:社会信用代码
        :rtype: int
        """
        return self._IdType

    @IdType.setter
    def IdType(self, IdType):
        self._IdType = IdType

    @property
    def Remark(self):
        """备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PhoneNo(self):
        """手机号码
        :rtype: str
        """
        return self._PhoneNo

    @PhoneNo.setter
    def PhoneNo(self, PhoneNo):
        self._PhoneNo = PhoneNo

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._OutUserId = params.get("OutUserId")
        self._Name = params.get("Name")
        self._IdNo = params.get("IdNo")
        self._AccountName = params.get("AccountName")
        self._ServiceProviderId = params.get("ServiceProviderId")
        if params.get("TaxInfo") is not None:
            self._TaxInfo = PayeeTaxInfo()
            self._TaxInfo._deserialize(params.get("TaxInfo"))
        self._IdType = params.get("IdType")
        self._Remark = params.get("Remark")
        self._PhoneNo = params.get("PhoneNo")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFlexPayeeResponse(AbstractModel):
    """CreateFlexPayee返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateFlexPayeeResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateFlexPayeeResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateFlexPayeeResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateFlexPayeeResult(AbstractModel):
    """账户开立结果

    """

    def __init__(self):
        r"""
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        """
        self._PayeeId = None

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId


    def _deserialize(self, params):
        self._PayeeId = params.get("PayeeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInvoiceItem(AbstractModel):
    """发票开具明细

    """

    def __init__(self):
        r"""
        :param _Name: 商品名称
        :type Name: str
        :param _TaxCode: 税收商品编码
        :type TaxCode: str
        :param _TotalPrice: 不含税商品总价（商品含税价总额/（1+税率））。InvoicePlatformId 为1时，该金额为含税总金额。单位为分。
        :type TotalPrice: int
        :param _TaxRate: 商品税率
        :type TaxRate: int
        :param _TaxAmount: 商品税额（不含税商品总价*税率）。单位为分
        :type TaxAmount: int
        :param _TaxType: 税收商品类别
        :type TaxType: str
        :param _Models: 商品规格
        :type Models: str
        :param _Unit: 商品单位
        :type Unit: str
        :param _Total: 商品数量
        :type Total: str
        :param _Price: 不含税商品单价。InvoicePlatformId 为1时，该金额为含税单价。
        :type Price: str
        :param _Discount: 含税折扣总额。单位为分
        :type Discount: int
        :param _PreferentialPolicyFlag: 优惠政策标志。0：不使用优惠政策；1：使用优惠政策。
        :type PreferentialPolicyFlag: str
        :param _ZeroTaxFlag: 零税率标识：
空：非零税率；
0：出口零税率；
1：免税；
2：不征税；
3：普通零税率。
        :type ZeroTaxFlag: str
        :param _VatSpecialManagement: 增值税特殊管理。PreferentialPolicyFlag字段为1时，必填。目前仅支持5%(3%，2%，1.5%)简易征税、免税、不征税。
        :type VatSpecialManagement: str
        """
        self._Name = None
        self._TaxCode = None
        self._TotalPrice = None
        self._TaxRate = None
        self._TaxAmount = None
        self._TaxType = None
        self._Models = None
        self._Unit = None
        self._Total = None
        self._Price = None
        self._Discount = None
        self._PreferentialPolicyFlag = None
        self._ZeroTaxFlag = None
        self._VatSpecialManagement = None

    @property
    def Name(self):
        """商品名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TaxCode(self):
        """税收商品编码
        :rtype: str
        """
        return self._TaxCode

    @TaxCode.setter
    def TaxCode(self, TaxCode):
        self._TaxCode = TaxCode

    @property
    def TotalPrice(self):
        """不含税商品总价（商品含税价总额/（1+税率））。InvoicePlatformId 为1时，该金额为含税总金额。单位为分。
        :rtype: int
        """
        return self._TotalPrice

    @TotalPrice.setter
    def TotalPrice(self, TotalPrice):
        self._TotalPrice = TotalPrice

    @property
    def TaxRate(self):
        """商品税率
        :rtype: int
        """
        return self._TaxRate

    @TaxRate.setter
    def TaxRate(self, TaxRate):
        self._TaxRate = TaxRate

    @property
    def TaxAmount(self):
        """商品税额（不含税商品总价*税率）。单位为分
        :rtype: int
        """
        return self._TaxAmount

    @TaxAmount.setter
    def TaxAmount(self, TaxAmount):
        self._TaxAmount = TaxAmount

    @property
    def TaxType(self):
        """税收商品类别
        :rtype: str
        """
        return self._TaxType

    @TaxType.setter
    def TaxType(self, TaxType):
        self._TaxType = TaxType

    @property
    def Models(self):
        """商品规格
        :rtype: str
        """
        return self._Models

    @Models.setter
    def Models(self, Models):
        self._Models = Models

    @property
    def Unit(self):
        """商品单位
        :rtype: str
        """
        return self._Unit

    @Unit.setter
    def Unit(self, Unit):
        self._Unit = Unit

    @property
    def Total(self):
        """商品数量
        :rtype: str
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Price(self):
        """不含税商品单价。InvoicePlatformId 为1时，该金额为含税单价。
        :rtype: str
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def Discount(self):
        """含税折扣总额。单位为分
        :rtype: int
        """
        return self._Discount

    @Discount.setter
    def Discount(self, Discount):
        self._Discount = Discount

    @property
    def PreferentialPolicyFlag(self):
        """优惠政策标志。0：不使用优惠政策；1：使用优惠政策。
        :rtype: str
        """
        return self._PreferentialPolicyFlag

    @PreferentialPolicyFlag.setter
    def PreferentialPolicyFlag(self, PreferentialPolicyFlag):
        self._PreferentialPolicyFlag = PreferentialPolicyFlag

    @property
    def ZeroTaxFlag(self):
        """零税率标识：
空：非零税率；
0：出口零税率；
1：免税；
2：不征税；
3：普通零税率。
        :rtype: str
        """
        return self._ZeroTaxFlag

    @ZeroTaxFlag.setter
    def ZeroTaxFlag(self, ZeroTaxFlag):
        self._ZeroTaxFlag = ZeroTaxFlag

    @property
    def VatSpecialManagement(self):
        """增值税特殊管理。PreferentialPolicyFlag字段为1时，必填。目前仅支持5%(3%，2%，1.5%)简易征税、免税、不征税。
        :rtype: str
        """
        return self._VatSpecialManagement

    @VatSpecialManagement.setter
    def VatSpecialManagement(self, VatSpecialManagement):
        self._VatSpecialManagement = VatSpecialManagement


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._TaxCode = params.get("TaxCode")
        self._TotalPrice = params.get("TotalPrice")
        self._TaxRate = params.get("TaxRate")
        self._TaxAmount = params.get("TaxAmount")
        self._TaxType = params.get("TaxType")
        self._Models = params.get("Models")
        self._Unit = params.get("Unit")
        self._Total = params.get("Total")
        self._Price = params.get("Price")
        self._Discount = params.get("Discount")
        self._PreferentialPolicyFlag = params.get("PreferentialPolicyFlag")
        self._ZeroTaxFlag = params.get("ZeroTaxFlag")
        self._VatSpecialManagement = params.get("VatSpecialManagement")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInvoiceRequest(AbstractModel):
    """CreateInvoice请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InvoicePlatformId: 开票平台ID。0：高灯，1：票易通
        :type InvoicePlatformId: int
        :param _TitleType: 抬头类型：1：个人/政府事业单位；2：企业
        :type TitleType: int
        :param _BuyerTitle: 购方名称
        :type BuyerTitle: str
        :param _OrderId: 业务开票号
        :type OrderId: str
        :param _AmountHasTax: 含税总金额（单位为分）
        :type AmountHasTax: int
        :param _TaxAmount: 总税额（单位为分）
        :type TaxAmount: int
        :param _AmountWithoutTax: 不含税总金额（单位为分）。InvoicePlatformId 为1时，传默认值-1
        :type AmountWithoutTax: int
        :param _SellerTaxpayerNum: 销方纳税人识别号
        :type SellerTaxpayerNum: str
        :param _SellerName: 销方名称。（不填默认读取商户注册时输入的信息）
        :type SellerName: str
        :param _SellerAddress: 销方地址。（不填默认读取商户注册时输入的信息）
        :type SellerAddress: str
        :param _SellerPhone: 销方电话。（不填默认读取商户注册时输入的信息）
        :type SellerPhone: str
        :param _SellerBankName: 销方银行名称。（不填默认读取商户注册时输入的信息）
        :type SellerBankName: str
        :param _SellerBankAccount: 销方银行账号。（不填默认读取商户注册时输入的信息）
        :type SellerBankAccount: str
        :param _BuyerTaxpayerNum: 购方纳税人识别号（购方票面信息）,若抬头类型为2时，必传
        :type BuyerTaxpayerNum: str
        :param _BuyerAddress: 购方地址。开具专用发票时必填
        :type BuyerAddress: str
        :param _BuyerBankName: 购方银行名称。开具专用发票时必填
        :type BuyerBankName: str
        :param _BuyerBankAccount: 购方银行账号。开具专用发票时必填
        :type BuyerBankAccount: str
        :param _BuyerPhone: 购方电话。开具专用发票时必填
        :type BuyerPhone: str
        :param _BuyerEmail: 收票人邮箱。若填入，会收到发票推送邮件
        :type BuyerEmail: str
        :param _TakerPhone: 收票人手机号。若填入，会收到发票推送短信
        :type TakerPhone: str
        :param _InvoiceType: 开票类型：
1：增值税专用发票；
2：增值税普通发票；
3：增值税电子发票；
4：增值税卷式发票；
5：区块链电子发票。
若该字段不填，或值不为1-5，则认为开具”增值税电子发票”
        :type InvoiceType: int
        :param _CallbackUrl: 发票结果回传地址
        :type CallbackUrl: str
        :param _Drawer: 开票人姓名。（不填默认读取商户注册时输入的信息）
        :type Drawer: str
        :param _Payee: 收款人姓名。（不填默认读取商户注册时输入的信息）
        :type Payee: str
        :param _Checker: 复核人姓名。（不填默认读取商户注册时输入的信息）
        :type Checker: str
        :param _TerminalCode: 税盘号
        :type TerminalCode: str
        :param _LevyMethod: 征收方式。开具差额征税发票时必填2。开具普通征税发票时为空
        :type LevyMethod: str
        :param _Deduction: 差额征税扣除额（单位为分）
        :type Deduction: int
        :param _Remark: 备注（票面信息）
        :type Remark: str
        :param _Items: 项目商品明细
        :type Items: list of CreateInvoiceItem
        :param _Profile: 接入环境。沙箱环境填sandbox。
        :type Profile: str
        :param _UndoPart: 撤销部分商品。0-不撤销，1-撤销
        :type UndoPart: int
        :param _OrderDate: 订单下单时间（格式 YYYYMMDD）
        :type OrderDate: str
        :param _Discount: 订单级别折扣（单位为分）
        :type Discount: int
        :param _StoreNo: 门店编码
        :type StoreNo: str
        :param _InvoiceChannel: 开票渠道。0：APP渠道，1：线下渠道，2：小程序渠道。不填默认为APP渠道
        :type InvoiceChannel: int
        """
        self._InvoicePlatformId = None
        self._TitleType = None
        self._BuyerTitle = None
        self._OrderId = None
        self._AmountHasTax = None
        self._TaxAmount = None
        self._AmountWithoutTax = None
        self._SellerTaxpayerNum = None
        self._SellerName = None
        self._SellerAddress = None
        self._SellerPhone = None
        self._SellerBankName = None
        self._SellerBankAccount = None
        self._BuyerTaxpayerNum = None
        self._BuyerAddress = None
        self._BuyerBankName = None
        self._BuyerBankAccount = None
        self._BuyerPhone = None
        self._BuyerEmail = None
        self._TakerPhone = None
        self._InvoiceType = None
        self._CallbackUrl = None
        self._Drawer = None
        self._Payee = None
        self._Checker = None
        self._TerminalCode = None
        self._LevyMethod = None
        self._Deduction = None
        self._Remark = None
        self._Items = None
        self._Profile = None
        self._UndoPart = None
        self._OrderDate = None
        self._Discount = None
        self._StoreNo = None
        self._InvoiceChannel = None

    @property
    def InvoicePlatformId(self):
        """开票平台ID。0：高灯，1：票易通
        :rtype: int
        """
        return self._InvoicePlatformId

    @InvoicePlatformId.setter
    def InvoicePlatformId(self, InvoicePlatformId):
        self._InvoicePlatformId = InvoicePlatformId

    @property
    def TitleType(self):
        """抬头类型：1：个人/政府事业单位；2：企业
        :rtype: int
        """
        return self._TitleType

    @TitleType.setter
    def TitleType(self, TitleType):
        self._TitleType = TitleType

    @property
    def BuyerTitle(self):
        """购方名称
        :rtype: str
        """
        return self._BuyerTitle

    @BuyerTitle.setter
    def BuyerTitle(self, BuyerTitle):
        self._BuyerTitle = BuyerTitle

    @property
    def OrderId(self):
        """业务开票号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def AmountHasTax(self):
        """含税总金额（单位为分）
        :rtype: int
        """
        return self._AmountHasTax

    @AmountHasTax.setter
    def AmountHasTax(self, AmountHasTax):
        self._AmountHasTax = AmountHasTax

    @property
    def TaxAmount(self):
        """总税额（单位为分）
        :rtype: int
        """
        return self._TaxAmount

    @TaxAmount.setter
    def TaxAmount(self, TaxAmount):
        self._TaxAmount = TaxAmount

    @property
    def AmountWithoutTax(self):
        """不含税总金额（单位为分）。InvoicePlatformId 为1时，传默认值-1
        :rtype: int
        """
        return self._AmountWithoutTax

    @AmountWithoutTax.setter
    def AmountWithoutTax(self, AmountWithoutTax):
        self._AmountWithoutTax = AmountWithoutTax

    @property
    def SellerTaxpayerNum(self):
        """销方纳税人识别号
        :rtype: str
        """
        return self._SellerTaxpayerNum

    @SellerTaxpayerNum.setter
    def SellerTaxpayerNum(self, SellerTaxpayerNum):
        self._SellerTaxpayerNum = SellerTaxpayerNum

    @property
    def SellerName(self):
        """销方名称。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerName

    @SellerName.setter
    def SellerName(self, SellerName):
        self._SellerName = SellerName

    @property
    def SellerAddress(self):
        """销方地址。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerAddress

    @SellerAddress.setter
    def SellerAddress(self, SellerAddress):
        self._SellerAddress = SellerAddress

    @property
    def SellerPhone(self):
        """销方电话。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerPhone

    @SellerPhone.setter
    def SellerPhone(self, SellerPhone):
        self._SellerPhone = SellerPhone

    @property
    def SellerBankName(self):
        """销方银行名称。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerBankName

    @SellerBankName.setter
    def SellerBankName(self, SellerBankName):
        self._SellerBankName = SellerBankName

    @property
    def SellerBankAccount(self):
        """销方银行账号。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerBankAccount

    @SellerBankAccount.setter
    def SellerBankAccount(self, SellerBankAccount):
        self._SellerBankAccount = SellerBankAccount

    @property
    def BuyerTaxpayerNum(self):
        """购方纳税人识别号（购方票面信息）,若抬头类型为2时，必传
        :rtype: str
        """
        return self._BuyerTaxpayerNum

    @BuyerTaxpayerNum.setter
    def BuyerTaxpayerNum(self, BuyerTaxpayerNum):
        self._BuyerTaxpayerNum = BuyerTaxpayerNum

    @property
    def BuyerAddress(self):
        """购方地址。开具专用发票时必填
        :rtype: str
        """
        return self._BuyerAddress

    @BuyerAddress.setter
    def BuyerAddress(self, BuyerAddress):
        self._BuyerAddress = BuyerAddress

    @property
    def BuyerBankName(self):
        """购方银行名称。开具专用发票时必填
        :rtype: str
        """
        return self._BuyerBankName

    @BuyerBankName.setter
    def BuyerBankName(self, BuyerBankName):
        self._BuyerBankName = BuyerBankName

    @property
    def BuyerBankAccount(self):
        """购方银行账号。开具专用发票时必填
        :rtype: str
        """
        return self._BuyerBankAccount

    @BuyerBankAccount.setter
    def BuyerBankAccount(self, BuyerBankAccount):
        self._BuyerBankAccount = BuyerBankAccount

    @property
    def BuyerPhone(self):
        """购方电话。开具专用发票时必填
        :rtype: str
        """
        return self._BuyerPhone

    @BuyerPhone.setter
    def BuyerPhone(self, BuyerPhone):
        self._BuyerPhone = BuyerPhone

    @property
    def BuyerEmail(self):
        """收票人邮箱。若填入，会收到发票推送邮件
        :rtype: str
        """
        return self._BuyerEmail

    @BuyerEmail.setter
    def BuyerEmail(self, BuyerEmail):
        self._BuyerEmail = BuyerEmail

    @property
    def TakerPhone(self):
        """收票人手机号。若填入，会收到发票推送短信
        :rtype: str
        """
        return self._TakerPhone

    @TakerPhone.setter
    def TakerPhone(self, TakerPhone):
        self._TakerPhone = TakerPhone

    @property
    def InvoiceType(self):
        """开票类型：
1：增值税专用发票；
2：增值税普通发票；
3：增值税电子发票；
4：增值税卷式发票；
5：区块链电子发票。
若该字段不填，或值不为1-5，则认为开具”增值税电子发票”
        :rtype: int
        """
        return self._InvoiceType

    @InvoiceType.setter
    def InvoiceType(self, InvoiceType):
        self._InvoiceType = InvoiceType

    @property
    def CallbackUrl(self):
        """发票结果回传地址
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def Drawer(self):
        """开票人姓名。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._Drawer

    @Drawer.setter
    def Drawer(self, Drawer):
        self._Drawer = Drawer

    @property
    def Payee(self):
        """收款人姓名。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._Payee

    @Payee.setter
    def Payee(self, Payee):
        self._Payee = Payee

    @property
    def Checker(self):
        """复核人姓名。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._Checker

    @Checker.setter
    def Checker(self, Checker):
        self._Checker = Checker

    @property
    def TerminalCode(self):
        """税盘号
        :rtype: str
        """
        return self._TerminalCode

    @TerminalCode.setter
    def TerminalCode(self, TerminalCode):
        self._TerminalCode = TerminalCode

    @property
    def LevyMethod(self):
        """征收方式。开具差额征税发票时必填2。开具普通征税发票时为空
        :rtype: str
        """
        return self._LevyMethod

    @LevyMethod.setter
    def LevyMethod(self, LevyMethod):
        self._LevyMethod = LevyMethod

    @property
    def Deduction(self):
        """差额征税扣除额（单位为分）
        :rtype: int
        """
        return self._Deduction

    @Deduction.setter
    def Deduction(self, Deduction):
        self._Deduction = Deduction

    @property
    def Remark(self):
        """备注（票面信息）
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Items(self):
        """项目商品明细
        :rtype: list of CreateInvoiceItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def UndoPart(self):
        """撤销部分商品。0-不撤销，1-撤销
        :rtype: int
        """
        return self._UndoPart

    @UndoPart.setter
    def UndoPart(self, UndoPart):
        self._UndoPart = UndoPart

    @property
    def OrderDate(self):
        """订单下单时间（格式 YYYYMMDD）
        :rtype: str
        """
        return self._OrderDate

    @OrderDate.setter
    def OrderDate(self, OrderDate):
        self._OrderDate = OrderDate

    @property
    def Discount(self):
        """订单级别折扣（单位为分）
        :rtype: int
        """
        return self._Discount

    @Discount.setter
    def Discount(self, Discount):
        self._Discount = Discount

    @property
    def StoreNo(self):
        """门店编码
        :rtype: str
        """
        return self._StoreNo

    @StoreNo.setter
    def StoreNo(self, StoreNo):
        self._StoreNo = StoreNo

    @property
    def InvoiceChannel(self):
        """开票渠道。0：APP渠道，1：线下渠道，2：小程序渠道。不填默认为APP渠道
        :rtype: int
        """
        return self._InvoiceChannel

    @InvoiceChannel.setter
    def InvoiceChannel(self, InvoiceChannel):
        self._InvoiceChannel = InvoiceChannel


    def _deserialize(self, params):
        self._InvoicePlatformId = params.get("InvoicePlatformId")
        self._TitleType = params.get("TitleType")
        self._BuyerTitle = params.get("BuyerTitle")
        self._OrderId = params.get("OrderId")
        self._AmountHasTax = params.get("AmountHasTax")
        self._TaxAmount = params.get("TaxAmount")
        self._AmountWithoutTax = params.get("AmountWithoutTax")
        self._SellerTaxpayerNum = params.get("SellerTaxpayerNum")
        self._SellerName = params.get("SellerName")
        self._SellerAddress = params.get("SellerAddress")
        self._SellerPhone = params.get("SellerPhone")
        self._SellerBankName = params.get("SellerBankName")
        self._SellerBankAccount = params.get("SellerBankAccount")
        self._BuyerTaxpayerNum = params.get("BuyerTaxpayerNum")
        self._BuyerAddress = params.get("BuyerAddress")
        self._BuyerBankName = params.get("BuyerBankName")
        self._BuyerBankAccount = params.get("BuyerBankAccount")
        self._BuyerPhone = params.get("BuyerPhone")
        self._BuyerEmail = params.get("BuyerEmail")
        self._TakerPhone = params.get("TakerPhone")
        self._InvoiceType = params.get("InvoiceType")
        self._CallbackUrl = params.get("CallbackUrl")
        self._Drawer = params.get("Drawer")
        self._Payee = params.get("Payee")
        self._Checker = params.get("Checker")
        self._TerminalCode = params.get("TerminalCode")
        self._LevyMethod = params.get("LevyMethod")
        self._Deduction = params.get("Deduction")
        self._Remark = params.get("Remark")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CreateInvoiceItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Profile = params.get("Profile")
        self._UndoPart = params.get("UndoPart")
        self._OrderDate = params.get("OrderDate")
        self._Discount = params.get("Discount")
        self._StoreNo = params.get("StoreNo")
        self._InvoiceChannel = params.get("InvoiceChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInvoiceResponse(AbstractModel):
    """CreateInvoice返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 发票开具结果
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateInvoiceResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """发票开具结果
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateInvoiceResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = CreateInvoiceResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateInvoiceResult(AbstractModel):
    """发票结果

    """

    def __init__(self):
        r"""
        :param _Message: 错误消息
        :type Message: str
        :param _Code: 错误码
        :type Code: int
        :param _Data: 数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.cpdp.v20190820.models.CreateInvoiceResultData`
        """
        self._Message = None
        self._Code = None
        self._Data = None

    @property
    def Message(self):
        """错误消息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Code(self):
        """错误码
        :rtype: int
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Data(self):
        """数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateInvoiceResultData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Message = params.get("Message")
        self._Code = params.get("Code")
        if params.get("Data") is not None:
            self._Data = CreateInvoiceResultData()
            self._Data._deserialize(params.get("Data"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInvoiceResultData(AbstractModel):
    """蓝票结果数据

    """

    def __init__(self):
        r"""
        :param _State: 开票状态
        :type State: int
        :param _InvoiceId: 发票ID
        :type InvoiceId: str
        :param _OrderSn: 业务开票号
        :type OrderSn: str
        """
        self._State = None
        self._InvoiceId = None
        self._OrderSn = None

    @property
    def State(self):
        """开票状态
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def InvoiceId(self):
        """发票ID
        :rtype: str
        """
        return self._InvoiceId

    @InvoiceId.setter
    def InvoiceId(self, InvoiceId):
        self._InvoiceId = InvoiceId

    @property
    def OrderSn(self):
        """业务开票号
        :rtype: str
        """
        return self._OrderSn

    @OrderSn.setter
    def OrderSn(self, OrderSn):
        self._OrderSn = OrderSn


    def _deserialize(self, params):
        self._State = params.get("State")
        self._InvoiceId = params.get("InvoiceId")
        self._OrderSn = params.get("OrderSn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInvoiceResultV2(AbstractModel):
    """发票结果V2

    """

    def __init__(self):
        r"""
        :param _InvoiceId: 发票ID
        :type InvoiceId: str
        """
        self._InvoiceId = None

    @property
    def InvoiceId(self):
        """发票ID
        :rtype: str
        """
        return self._InvoiceId

    @InvoiceId.setter
    def InvoiceId(self, InvoiceId):
        self._InvoiceId = InvoiceId


    def _deserialize(self, params):
        self._InvoiceId = params.get("InvoiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInvoiceV2Request(AbstractModel):
    """CreateInvoiceV2请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InvoicePlatformId: 开票平台ID。0：高灯，1：票易通
        :type InvoicePlatformId: int
        :param _TitleType: 抬头类型：1：个人/政府事业单位；2：企业
        :type TitleType: int
        :param _BuyerTitle: 购方名称
        :type BuyerTitle: str
        :param _OrderId: 业务开票号
        :type OrderId: str
        :param _AmountHasTax: 含税总金额（单位为分）
        :type AmountHasTax: int
        :param _TaxAmount: 总税额（单位为分）
        :type TaxAmount: int
        :param _AmountWithoutTax: 不含税总金额（单位为分）。InvoicePlatformId 为1时，传默认值-1
        :type AmountWithoutTax: int
        :param _SellerTaxpayerNum: 销方纳税人识别号
        :type SellerTaxpayerNum: str
        :param _SellerName: 销方名称。（不填默认读取商户注册时输入的信息）
        :type SellerName: str
        :param _SellerAddress: 销方地址。（不填默认读取商户注册时输入的信息）
        :type SellerAddress: str
        :param _SellerPhone: 销方电话。（不填默认读取商户注册时输入的信息）
        :type SellerPhone: str
        :param _SellerBankName: 销方银行名称。（不填默认读取商户注册时输入的信息）
        :type SellerBankName: str
        :param _SellerBankAccount: 销方银行账号。（不填默认读取商户注册时输入的信息）
        :type SellerBankAccount: str
        :param _BuyerTaxpayerNum: 购方纳税人识别号（购方票面信息）,若抬头类型为2时，必传
        :type BuyerTaxpayerNum: str
        :param _BuyerAddress: 购方地址。开具专用发票时必填
        :type BuyerAddress: str
        :param _BuyerBankName: 购方银行名称。开具专用发票时必填
        :type BuyerBankName: str
        :param _BuyerBankAccount: 购方银行账号。开具专用发票时必填
        :type BuyerBankAccount: str
        :param _BuyerPhone: 购方电话。开具专用发票时必填
        :type BuyerPhone: str
        :param _BuyerEmail: 收票人邮箱。若填入，会收到发票推送邮件
        :type BuyerEmail: str
        :param _TakerPhone: 收票人手机号。若填入，会收到发票推送短信
        :type TakerPhone: str
        :param _InvoiceType: 开票类型：
1：增值税专用发票；
2：增值税普通发票；
3：增值税电子发票；
4：增值税卷式发票；
5：区块链电子发票。
若该字段不填，或值不为1-5，则认为开具”增值税电子发票”
        :type InvoiceType: int
        :param _CallbackUrl: 发票结果回传地址
        :type CallbackUrl: str
        :param _Drawer: 开票人姓名。（不填默认读取商户注册时输入的信息）
        :type Drawer: str
        :param _Payee: 收款人姓名。（不填默认读取商户注册时输入的信息）
        :type Payee: str
        :param _Checker: 复核人姓名。（不填默认读取商户注册时输入的信息）
        :type Checker: str
        :param _TerminalCode: 税盘号
        :type TerminalCode: str
        :param _LevyMethod: 征收方式。开具差额征税发票时必填2。开具普通征税发票时为空
        :type LevyMethod: str
        :param _Deduction: 差额征税扣除额（单位为分）
        :type Deduction: int
        :param _Remark: 备注（票面信息）
        :type Remark: str
        :param _Items: 项目商品明细
        :type Items: list of CreateInvoiceItem
        :param _Profile: 接入环境。沙箱环境填sandbox。
        :type Profile: str
        :param _UndoPart: 撤销部分商品。0-不撤销，1-撤销
        :type UndoPart: int
        :param _OrderDate: 订单下单时间（格式 YYYYMMDD）
        :type OrderDate: str
        :param _Discount: 订单级别折扣（单位为分）
        :type Discount: int
        :param _StoreNo: 门店编码
        :type StoreNo: str
        :param _InvoiceChannel: 开票渠道。0：APP渠道，1：线下渠道，2：小程序渠道。不填默认为APP渠道
        :type InvoiceChannel: int
        """
        self._InvoicePlatformId = None
        self._TitleType = None
        self._BuyerTitle = None
        self._OrderId = None
        self._AmountHasTax = None
        self._TaxAmount = None
        self._AmountWithoutTax = None
        self._SellerTaxpayerNum = None
        self._SellerName = None
        self._SellerAddress = None
        self._SellerPhone = None
        self._SellerBankName = None
        self._SellerBankAccount = None
        self._BuyerTaxpayerNum = None
        self._BuyerAddress = None
        self._BuyerBankName = None
        self._BuyerBankAccount = None
        self._BuyerPhone = None
        self._BuyerEmail = None
        self._TakerPhone = None
        self._InvoiceType = None
        self._CallbackUrl = None
        self._Drawer = None
        self._Payee = None
        self._Checker = None
        self._TerminalCode = None
        self._LevyMethod = None
        self._Deduction = None
        self._Remark = None
        self._Items = None
        self._Profile = None
        self._UndoPart = None
        self._OrderDate = None
        self._Discount = None
        self._StoreNo = None
        self._InvoiceChannel = None

    @property
    def InvoicePlatformId(self):
        """开票平台ID。0：高灯，1：票易通
        :rtype: int
        """
        return self._InvoicePlatformId

    @InvoicePlatformId.setter
    def InvoicePlatformId(self, InvoicePlatformId):
        self._InvoicePlatformId = InvoicePlatformId

    @property
    def TitleType(self):
        """抬头类型：1：个人/政府事业单位；2：企业
        :rtype: int
        """
        return self._TitleType

    @TitleType.setter
    def TitleType(self, TitleType):
        self._TitleType = TitleType

    @property
    def BuyerTitle(self):
        """购方名称
        :rtype: str
        """
        return self._BuyerTitle

    @BuyerTitle.setter
    def BuyerTitle(self, BuyerTitle):
        self._BuyerTitle = BuyerTitle

    @property
    def OrderId(self):
        """业务开票号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def AmountHasTax(self):
        """含税总金额（单位为分）
        :rtype: int
        """
        return self._AmountHasTax

    @AmountHasTax.setter
    def AmountHasTax(self, AmountHasTax):
        self._AmountHasTax = AmountHasTax

    @property
    def TaxAmount(self):
        """总税额（单位为分）
        :rtype: int
        """
        return self._TaxAmount

    @TaxAmount.setter
    def TaxAmount(self, TaxAmount):
        self._TaxAmount = TaxAmount

    @property
    def AmountWithoutTax(self):
        """不含税总金额（单位为分）。InvoicePlatformId 为1时，传默认值-1
        :rtype: int
        """
        return self._AmountWithoutTax

    @AmountWithoutTax.setter
    def AmountWithoutTax(self, AmountWithoutTax):
        self._AmountWithoutTax = AmountWithoutTax

    @property
    def SellerTaxpayerNum(self):
        """销方纳税人识别号
        :rtype: str
        """
        return self._SellerTaxpayerNum

    @SellerTaxpayerNum.setter
    def SellerTaxpayerNum(self, SellerTaxpayerNum):
        self._SellerTaxpayerNum = SellerTaxpayerNum

    @property
    def SellerName(self):
        """销方名称。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerName

    @SellerName.setter
    def SellerName(self, SellerName):
        self._SellerName = SellerName

    @property
    def SellerAddress(self):
        """销方地址。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerAddress

    @SellerAddress.setter
    def SellerAddress(self, SellerAddress):
        self._SellerAddress = SellerAddress

    @property
    def SellerPhone(self):
        """销方电话。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerPhone

    @SellerPhone.setter
    def SellerPhone(self, SellerPhone):
        self._SellerPhone = SellerPhone

    @property
    def SellerBankName(self):
        """销方银行名称。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerBankName

    @SellerBankName.setter
    def SellerBankName(self, SellerBankName):
        self._SellerBankName = SellerBankName

    @property
    def SellerBankAccount(self):
        """销方银行账号。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._SellerBankAccount

    @SellerBankAccount.setter
    def SellerBankAccount(self, SellerBankAccount):
        self._SellerBankAccount = SellerBankAccount

    @property
    def BuyerTaxpayerNum(self):
        """购方纳税人识别号（购方票面信息）,若抬头类型为2时，必传
        :rtype: str
        """
        return self._BuyerTaxpayerNum

    @BuyerTaxpayerNum.setter
    def BuyerTaxpayerNum(self, BuyerTaxpayerNum):
        self._BuyerTaxpayerNum = BuyerTaxpayerNum

    @property
    def BuyerAddress(self):
        """购方地址。开具专用发票时必填
        :rtype: str
        """
        return self._BuyerAddress

    @BuyerAddress.setter
    def BuyerAddress(self, BuyerAddress):
        self._BuyerAddress = BuyerAddress

    @property
    def BuyerBankName(self):
        """购方银行名称。开具专用发票时必填
        :rtype: str
        """
        return self._BuyerBankName

    @BuyerBankName.setter
    def BuyerBankName(self, BuyerBankName):
        self._BuyerBankName = BuyerBankName

    @property
    def BuyerBankAccount(self):
        """购方银行账号。开具专用发票时必填
        :rtype: str
        """
        return self._BuyerBankAccount

    @BuyerBankAccount.setter
    def BuyerBankAccount(self, BuyerBankAccount):
        self._BuyerBankAccount = BuyerBankAccount

    @property
    def BuyerPhone(self):
        """购方电话。开具专用发票时必填
        :rtype: str
        """
        return self._BuyerPhone

    @BuyerPhone.setter
    def BuyerPhone(self, BuyerPhone):
        self._BuyerPhone = BuyerPhone

    @property
    def BuyerEmail(self):
        """收票人邮箱。若填入，会收到发票推送邮件
        :rtype: str
        """
        return self._BuyerEmail

    @BuyerEmail.setter
    def BuyerEmail(self, BuyerEmail):
        self._BuyerEmail = BuyerEmail

    @property
    def TakerPhone(self):
        """收票人手机号。若填入，会收到发票推送短信
        :rtype: str
        """
        return self._TakerPhone

    @TakerPhone.setter
    def TakerPhone(self, TakerPhone):
        self._TakerPhone = TakerPhone

    @property
    def InvoiceType(self):
        """开票类型：
1：增值税专用发票；
2：增值税普通发票；
3：增值税电子发票；
4：增值税卷式发票；
5：区块链电子发票。
若该字段不填，或值不为1-5，则认为开具”增值税电子发票”
        :rtype: int
        """
        return self._InvoiceType

    @InvoiceType.setter
    def InvoiceType(self, InvoiceType):
        self._InvoiceType = InvoiceType

    @property
    def CallbackUrl(self):
        """发票结果回传地址
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def Drawer(self):
        """开票人姓名。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._Drawer

    @Drawer.setter
    def Drawer(self, Drawer):
        self._Drawer = Drawer

    @property
    def Payee(self):
        """收款人姓名。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._Payee

    @Payee.setter
    def Payee(self, Payee):
        self._Payee = Payee

    @property
    def Checker(self):
        """复核人姓名。（不填默认读取商户注册时输入的信息）
        :rtype: str
        """
        return self._Checker

    @Checker.setter
    def Checker(self, Checker):
        self._Checker = Checker

    @property
    def TerminalCode(self):
        """税盘号
        :rtype: str
        """
        return self._TerminalCode

    @TerminalCode.setter
    def TerminalCode(self, TerminalCode):
        self._TerminalCode = TerminalCode

    @property
    def LevyMethod(self):
        """征收方式。开具差额征税发票时必填2。开具普通征税发票时为空
        :rtype: str
        """
        return self._LevyMethod

    @LevyMethod.setter
    def LevyMethod(self, LevyMethod):
        self._LevyMethod = LevyMethod

    @property
    def Deduction(self):
        """差额征税扣除额（单位为分）
        :rtype: int
        """
        return self._Deduction

    @Deduction.setter
    def Deduction(self, Deduction):
        self._Deduction = Deduction

    @property
    def Remark(self):
        """备注（票面信息）
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Items(self):
        """项目商品明细
        :rtype: list of CreateInvoiceItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def UndoPart(self):
        """撤销部分商品。0-不撤销，1-撤销
        :rtype: int
        """
        return self._UndoPart

    @UndoPart.setter
    def UndoPart(self, UndoPart):
        self._UndoPart = UndoPart

    @property
    def OrderDate(self):
        """订单下单时间（格式 YYYYMMDD）
        :rtype: str
        """
        return self._OrderDate

    @OrderDate.setter
    def OrderDate(self, OrderDate):
        self._OrderDate = OrderDate

    @property
    def Discount(self):
        """订单级别折扣（单位为分）
        :rtype: int
        """
        return self._Discount

    @Discount.setter
    def Discount(self, Discount):
        self._Discount = Discount

    @property
    def StoreNo(self):
        """门店编码
        :rtype: str
        """
        return self._StoreNo

    @StoreNo.setter
    def StoreNo(self, StoreNo):
        self._StoreNo = StoreNo

    @property
    def InvoiceChannel(self):
        """开票渠道。0：APP渠道，1：线下渠道，2：小程序渠道。不填默认为APP渠道
        :rtype: int
        """
        return self._InvoiceChannel

    @InvoiceChannel.setter
    def InvoiceChannel(self, InvoiceChannel):
        self._InvoiceChannel = InvoiceChannel


    def _deserialize(self, params):
        self._InvoicePlatformId = params.get("InvoicePlatformId")
        self._TitleType = params.get("TitleType")
        self._BuyerTitle = params.get("BuyerTitle")
        self._OrderId = params.get("OrderId")
        self._AmountHasTax = params.get("AmountHasTax")
        self._TaxAmount = params.get("TaxAmount")
        self._AmountWithoutTax = params.get("AmountWithoutTax")
        self._SellerTaxpayerNum = params.get("SellerTaxpayerNum")
        self._SellerName = params.get("SellerName")
        self._SellerAddress = params.get("SellerAddress")
        self._SellerPhone = params.get("SellerPhone")
        self._SellerBankName = params.get("SellerBankName")
        self._SellerBankAccount = params.get("SellerBankAccount")
        self._BuyerTaxpayerNum = params.get("BuyerTaxpayerNum")
        self._BuyerAddress = params.get("BuyerAddress")
        self._BuyerBankName = params.get("BuyerBankName")
        self._BuyerBankAccount = params.get("BuyerBankAccount")
        self._BuyerPhone = params.get("BuyerPhone")
        self._BuyerEmail = params.get("BuyerEmail")
        self._TakerPhone = params.get("TakerPhone")
        self._InvoiceType = params.get("InvoiceType")
        self._CallbackUrl = params.get("CallbackUrl")
        self._Drawer = params.get("Drawer")
        self._Payee = params.get("Payee")
        self._Checker = params.get("Checker")
        self._TerminalCode = params.get("TerminalCode")
        self._LevyMethod = params.get("LevyMethod")
        self._Deduction = params.get("Deduction")
        self._Remark = params.get("Remark")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CreateInvoiceItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Profile = params.get("Profile")
        self._UndoPart = params.get("UndoPart")
        self._OrderDate = params.get("OrderDate")
        self._Discount = params.get("Discount")
        self._StoreNo = params.get("StoreNo")
        self._InvoiceChannel = params.get("InvoiceChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInvoiceV2Response(AbstractModel):
    """CreateInvoiceV2返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 发票开具结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateInvoiceResultV2`
        :param _ErrCode: 错误码
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._ErrCode = None
        self._ErrMessage = None
        self._RequestId = None

    @property
    def Result(self):
        """发票开具结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateInvoiceResultV2`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrCode(self):
        """错误码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = CreateInvoiceResultV2()
            self._Result._deserialize(params.get("Result"))
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        self._RequestId = params.get("RequestId")


class CreateMerchantRequest(AbstractModel):
    """CreateMerchant请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InvoicePlatformId: 开票平台ID
        :type InvoicePlatformId: int
        :param _TaxpayerName: 企业名称
        :type TaxpayerName: str
        :param _TaxpayerNum: 销方纳税人识别号
        :type TaxpayerNum: str
        :param _LegalPersonName: 注册企业法定代表人名称
        :type LegalPersonName: str
        :param _ContactsName: 联系人
        :type ContactsName: str
        :param _Phone: 联系人手机号
        :type Phone: str
        :param _Address: 不包含省市名称的地址
        :type Address: str
        :param _RegionCode: 地区编码
        :type RegionCode: int
        :param _CityName: 市（地区）名称
        :type CityName: str
        :param _Drawer: 开票人
        :type Drawer: str
        :param _TaxRegistrationCertificate: 税务登记证图片（Base64）字符串，需小于 3M
        :type TaxRegistrationCertificate: str
        :param _Email: 联系人邮箱地址
        :type Email: str
        :param _BusinessMobile: 企业电话
        :type BusinessMobile: str
        :param _BankName: 银行名称
        :type BankName: str
        :param _BankAccount: 银行账号
        :type BankAccount: str
        :param _Reviewer: 复核人
        :type Reviewer: str
        :param _Payee: 收款人
        :type Payee: str
        :param _RegisterCode: 注册邀请码
        :type RegisterCode: str
        :param _State: 不填默认为1，有效状态
0：表示无效；
1:表示有效；
2:表示禁止开蓝票；
3:表示禁止冲红。
        :type State: str
        :param _CallbackUrl: 接收推送的消息地址
        :type CallbackUrl: str
        :param _Profile: 接入环境。沙箱环境填 sandbox。
        :type Profile: str
        """
        self._InvoicePlatformId = None
        self._TaxpayerName = None
        self._TaxpayerNum = None
        self._LegalPersonName = None
        self._ContactsName = None
        self._Phone = None
        self._Address = None
        self._RegionCode = None
        self._CityName = None
        self._Drawer = None
        self._TaxRegistrationCertificate = None
        self._Email = None
        self._BusinessMobile = None
        self._BankName = None
        self._BankAccount = None
        self._Reviewer = None
        self._Payee = None
        self._RegisterCode = None
        self._State = None
        self._CallbackUrl = None
        self._Profile = None

    @property
    def InvoicePlatformId(self):
        """开票平台ID
        :rtype: int
        """
        return self._InvoicePlatformId

    @InvoicePlatformId.setter
    def InvoicePlatformId(self, InvoicePlatformId):
        self._InvoicePlatformId = InvoicePlatformId

    @property
    def TaxpayerName(self):
        """企业名称
        :rtype: str
        """
        return self._TaxpayerName

    @TaxpayerName.setter
    def TaxpayerName(self, TaxpayerName):
        self._TaxpayerName = TaxpayerName

    @property
    def TaxpayerNum(self):
        """销方纳税人识别号
        :rtype: str
        """
        return self._TaxpayerNum

    @TaxpayerNum.setter
    def TaxpayerNum(self, TaxpayerNum):
        self._TaxpayerNum = TaxpayerNum

    @property
    def LegalPersonName(self):
        """注册企业法定代表人名称
        :rtype: str
        """
        return self._LegalPersonName

    @LegalPersonName.setter
    def LegalPersonName(self, LegalPersonName):
        self._LegalPersonName = LegalPersonName

    @property
    def ContactsName(self):
        """联系人
        :rtype: str
        """
        return self._ContactsName

    @ContactsName.setter
    def ContactsName(self, ContactsName):
        self._ContactsName = ContactsName

    @property
    def Phone(self):
        """联系人手机号
        :rtype: str
        """
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone

    @property
    def Address(self):
        """不包含省市名称的地址
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def RegionCode(self):
        """地区编码
        :rtype: int
        """
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def CityName(self):
        """市（地区）名称
        :rtype: str
        """
        return self._CityName

    @CityName.setter
    def CityName(self, CityName):
        self._CityName = CityName

    @property
    def Drawer(self):
        """开票人
        :rtype: str
        """
        return self._Drawer

    @Drawer.setter
    def Drawer(self, Drawer):
        self._Drawer = Drawer

    @property
    def TaxRegistrationCertificate(self):
        """税务登记证图片（Base64）字符串，需小于 3M
        :rtype: str
        """
        return self._TaxRegistrationCertificate

    @TaxRegistrationCertificate.setter
    def TaxRegistrationCertificate(self, TaxRegistrationCertificate):
        self._TaxRegistrationCertificate = TaxRegistrationCertificate

    @property
    def Email(self):
        """联系人邮箱地址
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def BusinessMobile(self):
        """企业电话
        :rtype: str
        """
        return self._BusinessMobile

    @BusinessMobile.setter
    def BusinessMobile(self, BusinessMobile):
        self._BusinessMobile = BusinessMobile

    @property
    def BankName(self):
        """银行名称
        :rtype: str
        """
        return self._BankName

    @BankName.setter
    def BankName(self, BankName):
        self._BankName = BankName

    @property
    def BankAccount(self):
        """银行账号
        :rtype: str
        """
        return self._BankAccount

    @BankAccount.setter
    def BankAccount(self, BankAccount):
        self._BankAccount = BankAccount

    @property
    def Reviewer(self):
        """复核人
        :rtype: str
        """
        return self._Reviewer

    @Reviewer.setter
    def Reviewer(self, Reviewer):
        self._Reviewer = Reviewer

    @property
    def Payee(self):
        """收款人
        :rtype: str
        """
        return self._Payee

    @Payee.setter
    def Payee(self, Payee):
        self._Payee = Payee

    @property
    def RegisterCode(self):
        """注册邀请码
        :rtype: str
        """
        return self._RegisterCode

    @RegisterCode.setter
    def RegisterCode(self, RegisterCode):
        self._RegisterCode = RegisterCode

    @property
    def State(self):
        """不填默认为1，有效状态
0：表示无效；
1:表示有效；
2:表示禁止开蓝票；
3:表示禁止冲红。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CallbackUrl(self):
        """接收推送的消息地址
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def Profile(self):
        """接入环境。沙箱环境填 sandbox。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._InvoicePlatformId = params.get("InvoicePlatformId")
        self._TaxpayerName = params.get("TaxpayerName")
        self._TaxpayerNum = params.get("TaxpayerNum")
        self._LegalPersonName = params.get("LegalPersonName")
        self._ContactsName = params.get("ContactsName")
        self._Phone = params.get("Phone")
        self._Address = params.get("Address")
        self._RegionCode = params.get("RegionCode")
        self._CityName = params.get("CityName")
        self._Drawer = params.get("Drawer")
        self._TaxRegistrationCertificate = params.get("TaxRegistrationCertificate")
        self._Email = params.get("Email")
        self._BusinessMobile = params.get("BusinessMobile")
        self._BankName = params.get("BankName")
        self._BankAccount = params.get("BankAccount")
        self._Reviewer = params.get("Reviewer")
        self._Payee = params.get("Payee")
        self._RegisterCode = params.get("RegisterCode")
        self._State = params.get("State")
        self._CallbackUrl = params.get("CallbackUrl")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMerchantResponse(AbstractModel):
    """CreateMerchant返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 商户注册结果
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateMerchantResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """商户注册结果
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateMerchantResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = CreateMerchantResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateMerchantResult(AbstractModel):
    """创建商户结果

    """

    def __init__(self):
        r"""
        :param _Code: 状态码
        :type Code: int
        :param _Message: 响应消息
        :type Message: str
        :param _Data: 创建商户结果数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.cpdp.v20190820.models.CreateMerchantResultData`
        """
        self._Code = None
        self._Message = None
        self._Data = None

    @property
    def Code(self):
        """状态码
        :rtype: int
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Message(self):
        """响应消息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Data(self):
        """创建商户结果数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateMerchantResultData`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Code = params.get("Code")
        self._Message = params.get("Message")
        if params.get("Data") is not None:
            self._Data = CreateMerchantResultData()
            self._Data._deserialize(params.get("Data"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMerchantResultData(AbstractModel):
    """创建商户结果数据

    """

    def __init__(self):
        r"""
        :param _TaxpayerName: 企业名称
        :type TaxpayerName: str
        :param _SerialNo: 请求流水号
        :type SerialNo: str
        :param _TaxpayerNum: 纳税号
        :type TaxpayerNum: str
        """
        self._TaxpayerName = None
        self._SerialNo = None
        self._TaxpayerNum = None

    @property
    def TaxpayerName(self):
        """企业名称
        :rtype: str
        """
        return self._TaxpayerName

    @TaxpayerName.setter
    def TaxpayerName(self, TaxpayerName):
        self._TaxpayerName = TaxpayerName

    @property
    def SerialNo(self):
        """请求流水号
        :rtype: str
        """
        return self._SerialNo

    @SerialNo.setter
    def SerialNo(self, SerialNo):
        self._SerialNo = SerialNo

    @property
    def TaxpayerNum(self):
        """纳税号
        :rtype: str
        """
        return self._TaxpayerNum

    @TaxpayerNum.setter
    def TaxpayerNum(self, TaxpayerNum):
        self._TaxpayerNum = TaxpayerNum


    def _deserialize(self, params):
        self._TaxpayerName = params.get("TaxpayerName")
        self._SerialNo = params.get("SerialNo")
        self._TaxpayerNum = params.get("TaxpayerNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankAggregatedSubMerchantRegistrationRequest(AbstractModel):
    """CreateOpenBankAggregatedSubMerchantRegistration请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OutRegistrationNo: 外部进件序列号。
        :type OutRegistrationNo: str
        :param _ChannelMerchantId: 渠道商户ID。
        :type ChannelMerchantId: str
        :param _OutSubMerchantId: 外部子商户ID。
        :type OutSubMerchantId: str
        :param _ChannelName: 渠道名称。详见附录-云企付枚举类说明-ChannelName。
TENPAY: 商企付
WECHAT: 微信支付
ALIPAY: 支付宝
HELIPAY:合利宝
        :type ChannelName: str
        :param _OutSubMerchantType: 外部子商户类型。
ENTERPRISE：企业商户 
INSTITUTION：事业单位商户 
INDIVIDUALBISS：个体工商户 
PERSON：个人商户(小微商户) 
SUBJECT_TYPE_OTHERS：其他组织
        :type OutSubMerchantType: str
        :param _OutSubMerchantName: 外部子商户名称。
HELIPAY渠道(长度不能小于5大于150)。
        :type OutSubMerchantName: str
        :param _LegalPersonInfo: 商户法人代表信息。
        :type LegalPersonInfo: :class:`tencentcloud.cpdp.v20190820.models.LegalPersonInfo`
        :param _BusinessLicenseInfo: 营业证件信息。
        :type BusinessLicenseInfo: :class:`tencentcloud.cpdp.v20190820.models.BusinessLicenseInfo`
        :param _InterConnectionSubMerchantData: 支付渠道子商户进件信息。
json字符串，详情见附录-复杂类型-InterConnectionSubMerchantData。
        :type InterConnectionSubMerchantData: str
        :param _PaymentMethod: 支付方式。详见附录-云企付枚举类说明-PaymentMethod。
合利宝渠道不需要传。
        :type PaymentMethod: str
        :param _OutSubMerchantShortName: 外部子商户简称。
HELIPAY渠道必传(长度不能小于2大于20)。
        :type OutSubMerchantShortName: str
        :param _OutSubMerchantDescription: 外部子商户描述。
        :type OutSubMerchantDescription: str
        :param _NotifyUrl: 通知地址。
        :type NotifyUrl: str
        :param _NaturalPersonList: 相关自然人信息列表。
HELIPAY渠道必传业务联系人。
        :type NaturalPersonList: list of NaturalPersonInfo
        :param _SettleInfo: 商户结算信息。
HELIPAY渠道必传。
        :type SettleInfo: :class:`tencentcloud.cpdp.v20190820.models.SettleInfo`
        :param _OutSubMerchantExtensionInfo: 外部子商户其他公用扩展信息。
HELIPAY渠道必传。
        :type OutSubMerchantExtensionInfo: :class:`tencentcloud.cpdp.v20190820.models.OutSubMerchantExtensionInfo`
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._OutRegistrationNo = None
        self._ChannelMerchantId = None
        self._OutSubMerchantId = None
        self._ChannelName = None
        self._OutSubMerchantType = None
        self._OutSubMerchantName = None
        self._LegalPersonInfo = None
        self._BusinessLicenseInfo = None
        self._InterConnectionSubMerchantData = None
        self._PaymentMethod = None
        self._OutSubMerchantShortName = None
        self._OutSubMerchantDescription = None
        self._NotifyUrl = None
        self._NaturalPersonList = None
        self._SettleInfo = None
        self._OutSubMerchantExtensionInfo = None
        self._Environment = None

    @property
    def OutRegistrationNo(self):
        """外部进件序列号。
        :rtype: str
        """
        return self._OutRegistrationNo

    @OutRegistrationNo.setter
    def OutRegistrationNo(self, OutRegistrationNo):
        self._OutRegistrationNo = OutRegistrationNo

    @property
    def ChannelMerchantId(self):
        """渠道商户ID。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def OutSubMerchantId(self):
        """外部子商户ID。
        :rtype: str
        """
        return self._OutSubMerchantId

    @OutSubMerchantId.setter
    def OutSubMerchantId(self, OutSubMerchantId):
        self._OutSubMerchantId = OutSubMerchantId

    @property
    def ChannelName(self):
        """渠道名称。详见附录-云企付枚举类说明-ChannelName。
TENPAY: 商企付
WECHAT: 微信支付
ALIPAY: 支付宝
HELIPAY:合利宝
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def OutSubMerchantType(self):
        """外部子商户类型。
ENTERPRISE：企业商户 
INSTITUTION：事业单位商户 
INDIVIDUALBISS：个体工商户 
PERSON：个人商户(小微商户) 
SUBJECT_TYPE_OTHERS：其他组织
        :rtype: str
        """
        return self._OutSubMerchantType

    @OutSubMerchantType.setter
    def OutSubMerchantType(self, OutSubMerchantType):
        self._OutSubMerchantType = OutSubMerchantType

    @property
    def OutSubMerchantName(self):
        """外部子商户名称。
HELIPAY渠道(长度不能小于5大于150)。
        :rtype: str
        """
        return self._OutSubMerchantName

    @OutSubMerchantName.setter
    def OutSubMerchantName(self, OutSubMerchantName):
        self._OutSubMerchantName = OutSubMerchantName

    @property
    def LegalPersonInfo(self):
        """商户法人代表信息。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.LegalPersonInfo`
        """
        return self._LegalPersonInfo

    @LegalPersonInfo.setter
    def LegalPersonInfo(self, LegalPersonInfo):
        self._LegalPersonInfo = LegalPersonInfo

    @property
    def BusinessLicenseInfo(self):
        """营业证件信息。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.BusinessLicenseInfo`
        """
        return self._BusinessLicenseInfo

    @BusinessLicenseInfo.setter
    def BusinessLicenseInfo(self, BusinessLicenseInfo):
        self._BusinessLicenseInfo = BusinessLicenseInfo

    @property
    def InterConnectionSubMerchantData(self):
        """支付渠道子商户进件信息。
json字符串，详情见附录-复杂类型-InterConnectionSubMerchantData。
        :rtype: str
        """
        return self._InterConnectionSubMerchantData

    @InterConnectionSubMerchantData.setter
    def InterConnectionSubMerchantData(self, InterConnectionSubMerchantData):
        self._InterConnectionSubMerchantData = InterConnectionSubMerchantData

    @property
    def PaymentMethod(self):
        """支付方式。详见附录-云企付枚举类说明-PaymentMethod。
合利宝渠道不需要传。
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def OutSubMerchantShortName(self):
        """外部子商户简称。
HELIPAY渠道必传(长度不能小于2大于20)。
        :rtype: str
        """
        return self._OutSubMerchantShortName

    @OutSubMerchantShortName.setter
    def OutSubMerchantShortName(self, OutSubMerchantShortName):
        self._OutSubMerchantShortName = OutSubMerchantShortName

    @property
    def OutSubMerchantDescription(self):
        """外部子商户描述。
        :rtype: str
        """
        return self._OutSubMerchantDescription

    @OutSubMerchantDescription.setter
    def OutSubMerchantDescription(self, OutSubMerchantDescription):
        self._OutSubMerchantDescription = OutSubMerchantDescription

    @property
    def NotifyUrl(self):
        """通知地址。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def NaturalPersonList(self):
        """相关自然人信息列表。
HELIPAY渠道必传业务联系人。
        :rtype: list of NaturalPersonInfo
        """
        return self._NaturalPersonList

    @NaturalPersonList.setter
    def NaturalPersonList(self, NaturalPersonList):
        self._NaturalPersonList = NaturalPersonList

    @property
    def SettleInfo(self):
        """商户结算信息。
HELIPAY渠道必传。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.SettleInfo`
        """
        return self._SettleInfo

    @SettleInfo.setter
    def SettleInfo(self, SettleInfo):
        self._SettleInfo = SettleInfo

    @property
    def OutSubMerchantExtensionInfo(self):
        """外部子商户其他公用扩展信息。
HELIPAY渠道必传。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OutSubMerchantExtensionInfo`
        """
        return self._OutSubMerchantExtensionInfo

    @OutSubMerchantExtensionInfo.setter
    def OutSubMerchantExtensionInfo(self, OutSubMerchantExtensionInfo):
        self._OutSubMerchantExtensionInfo = OutSubMerchantExtensionInfo

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._OutRegistrationNo = params.get("OutRegistrationNo")
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._OutSubMerchantId = params.get("OutSubMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._OutSubMerchantType = params.get("OutSubMerchantType")
        self._OutSubMerchantName = params.get("OutSubMerchantName")
        if params.get("LegalPersonInfo") is not None:
            self._LegalPersonInfo = LegalPersonInfo()
            self._LegalPersonInfo._deserialize(params.get("LegalPersonInfo"))
        if params.get("BusinessLicenseInfo") is not None:
            self._BusinessLicenseInfo = BusinessLicenseInfo()
            self._BusinessLicenseInfo._deserialize(params.get("BusinessLicenseInfo"))
        self._InterConnectionSubMerchantData = params.get("InterConnectionSubMerchantData")
        self._PaymentMethod = params.get("PaymentMethod")
        self._OutSubMerchantShortName = params.get("OutSubMerchantShortName")
        self._OutSubMerchantDescription = params.get("OutSubMerchantDescription")
        self._NotifyUrl = params.get("NotifyUrl")
        if params.get("NaturalPersonList") is not None:
            self._NaturalPersonList = []
            for item in params.get("NaturalPersonList"):
                obj = NaturalPersonInfo()
                obj._deserialize(item)
                self._NaturalPersonList.append(obj)
        if params.get("SettleInfo") is not None:
            self._SettleInfo = SettleInfo()
            self._SettleInfo._deserialize(params.get("SettleInfo"))
        if params.get("OutSubMerchantExtensionInfo") is not None:
            self._OutSubMerchantExtensionInfo = OutSubMerchantExtensionInfo()
            self._OutSubMerchantExtensionInfo._deserialize(params.get("OutSubMerchantExtensionInfo"))
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankAggregatedSubMerchantRegistrationResponse(AbstractModel):
    """CreateOpenBankAggregatedSubMerchantRegistration返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :type ErrCode: str
        :param _ErrMessage: 错误消息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankExternalAggregatedSubMerchantRegistrationResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankExternalAggregatedSubMerchantRegistrationResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankExternalAggregatedSubMerchantRegistrationResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankExternalAggregatedSubMerchantRegistrationResult(AbstractModel):
    """聚合支付子商户线上入驻结果

    """

    def __init__(self):
        r"""
        :param _RegistrationStatus: 进件状态 
SUCCESS: 进件成功 
FAILED: 进件失败
PROCESSING: 进件中 
注意：若返回进件中，需要再次调用进件结果查询接口，查询结果。
        :type RegistrationStatus: str
        :param _RegistrationMessage: 进件返回描述
注意：此字段可能返回 null，表示取不到有效值。
        :type RegistrationMessage: str
        :param _ChannelRegistrationNo: 渠道进件序列号
        :type ChannelRegistrationNo: str
        :param _ChannelSubMerchantId: 渠道子商户ID
        :type ChannelSubMerchantId: str
        """
        self._RegistrationStatus = None
        self._RegistrationMessage = None
        self._ChannelRegistrationNo = None
        self._ChannelSubMerchantId = None

    @property
    def RegistrationStatus(self):
        """进件状态 
SUCCESS: 进件成功 
FAILED: 进件失败
PROCESSING: 进件中 
注意：若返回进件中，需要再次调用进件结果查询接口，查询结果。
        :rtype: str
        """
        return self._RegistrationStatus

    @RegistrationStatus.setter
    def RegistrationStatus(self, RegistrationStatus):
        self._RegistrationStatus = RegistrationStatus

    @property
    def RegistrationMessage(self):
        """进件返回描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RegistrationMessage

    @RegistrationMessage.setter
    def RegistrationMessage(self, RegistrationMessage):
        self._RegistrationMessage = RegistrationMessage

    @property
    def ChannelRegistrationNo(self):
        """渠道进件序列号
        :rtype: str
        """
        return self._ChannelRegistrationNo

    @ChannelRegistrationNo.setter
    def ChannelRegistrationNo(self, ChannelRegistrationNo):
        self._ChannelRegistrationNo = ChannelRegistrationNo

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户ID
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId


    def _deserialize(self, params):
        self._RegistrationStatus = params.get("RegistrationStatus")
        self._RegistrationMessage = params.get("RegistrationMessage")
        self._ChannelRegistrationNo = params.get("ChannelRegistrationNo")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankExternalSubMerchantAccountBookRequest(AbstractModel):
    """CreateOpenBankExternalSubMerchantAccountBook请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OutAccountBookId: 外部账本ID
        :type OutAccountBookId: str
        :param _ChannelMerchantId: 渠道商户ID
        :type ChannelMerchantId: str
        :param _ChannelSubMerchantId: 渠道子商户ID
        :type ChannelSubMerchantId: str
        :param _ChannelName: 渠道名称。目前只支持支付宝
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :type ChannelName: str
        :param _PaymentMethod: 支付方式。目前只支持安心发支付
__EBANK_PAYMENT__: ebank支付
__OPENBANK_PAYMENT__: openbank支付
__SAFT_ISV__: 安心发支付
        :type PaymentMethod: str
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._OutAccountBookId = None
        self._ChannelMerchantId = None
        self._ChannelSubMerchantId = None
        self._ChannelName = None
        self._PaymentMethod = None
        self._Environment = None

    @property
    def OutAccountBookId(self):
        """外部账本ID
        :rtype: str
        """
        return self._OutAccountBookId

    @OutAccountBookId.setter
    def OutAccountBookId(self, OutAccountBookId):
        self._OutAccountBookId = OutAccountBookId

    @property
    def ChannelMerchantId(self):
        """渠道商户ID
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户ID
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def ChannelName(self):
        """渠道名称。目前只支持支付宝
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PaymentMethod(self):
        """支付方式。目前只支持安心发支付
__EBANK_PAYMENT__: ebank支付
__OPENBANK_PAYMENT__: openbank支付
__SAFT_ISV__: 安心发支付
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._OutAccountBookId = params.get("OutAccountBookId")
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._PaymentMethod = params.get("PaymentMethod")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankExternalSubMerchantAccountBookResponse(AbstractModel):
    """CreateOpenBankExternalSubMerchantAccountBook返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :type ErrCode: str
        :param _ErrMessage: 错误消息。
        :type ErrMessage: str
        :param _Result: 返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateExternalAccountBookResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateExternalAccountBookResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateExternalAccountBookResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankExternalSubMerchantRegistrationRequest(AbstractModel):
    """CreateOpenBankExternalSubMerchantRegistration请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OutRegistrationNo: 外部进件序列号。
        :type OutRegistrationNo: str
        :param _ChannelMerchantId: 渠道商户ID。
        :type ChannelMerchantId: str
        :param _OutSubMerchantId: 外部子商户ID,平台侧商户唯一ID。
        :type OutSubMerchantId: str
        :param _ChannelName: 渠道名称。详见附录-云企付枚举类说明-ChannelName。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :type ChannelName: str
        :param _PaymentMethod: 支付方式。详见附录-云企付枚举类说明-PaymentMethod。
__EBANK_PAYMENT__: ebank支付
__OPENBANK_PAYMENT__: openbank支付
        :type PaymentMethod: str
        :param _BusinessLicenseNumber: 社会信用代码。
        :type BusinessLicenseNumber: str
        :param _OutSubMerchantName: 外部子商户名称。
        :type OutSubMerchantName: str
        :param _LegalName: 法人姓名。
        :type LegalName: str
        :param _OutSubMerchantShortName: 外部子商户简称。
        :type OutSubMerchantShortName: str
        :param _OutSubMerchantDescription: 外部子商户描述。
        :type OutSubMerchantDescription: str
        :param _ExternalSubMerchantRegistrationData: 第三方子商户进件信息，为JSON格式字符串。详情见附录-复杂类型。
        :type ExternalSubMerchantRegistrationData: str
        :param _NotifyUrl: 通知地址。
        :type NotifyUrl: str
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._OutRegistrationNo = None
        self._ChannelMerchantId = None
        self._OutSubMerchantId = None
        self._ChannelName = None
        self._PaymentMethod = None
        self._BusinessLicenseNumber = None
        self._OutSubMerchantName = None
        self._LegalName = None
        self._OutSubMerchantShortName = None
        self._OutSubMerchantDescription = None
        self._ExternalSubMerchantRegistrationData = None
        self._NotifyUrl = None
        self._Environment = None

    @property
    def OutRegistrationNo(self):
        """外部进件序列号。
        :rtype: str
        """
        return self._OutRegistrationNo

    @OutRegistrationNo.setter
    def OutRegistrationNo(self, OutRegistrationNo):
        self._OutRegistrationNo = OutRegistrationNo

    @property
    def ChannelMerchantId(self):
        """渠道商户ID。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def OutSubMerchantId(self):
        """外部子商户ID,平台侧商户唯一ID。
        :rtype: str
        """
        return self._OutSubMerchantId

    @OutSubMerchantId.setter
    def OutSubMerchantId(self, OutSubMerchantId):
        self._OutSubMerchantId = OutSubMerchantId

    @property
    def ChannelName(self):
        """渠道名称。详见附录-云企付枚举类说明-ChannelName。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PaymentMethod(self):
        """支付方式。详见附录-云企付枚举类说明-PaymentMethod。
__EBANK_PAYMENT__: ebank支付
__OPENBANK_PAYMENT__: openbank支付
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def BusinessLicenseNumber(self):
        """社会信用代码。
        :rtype: str
        """
        return self._BusinessLicenseNumber

    @BusinessLicenseNumber.setter
    def BusinessLicenseNumber(self, BusinessLicenseNumber):
        self._BusinessLicenseNumber = BusinessLicenseNumber

    @property
    def OutSubMerchantName(self):
        """外部子商户名称。
        :rtype: str
        """
        return self._OutSubMerchantName

    @OutSubMerchantName.setter
    def OutSubMerchantName(self, OutSubMerchantName):
        self._OutSubMerchantName = OutSubMerchantName

    @property
    def LegalName(self):
        """法人姓名。
        :rtype: str
        """
        return self._LegalName

    @LegalName.setter
    def LegalName(self, LegalName):
        self._LegalName = LegalName

    @property
    def OutSubMerchantShortName(self):
        """外部子商户简称。
        :rtype: str
        """
        return self._OutSubMerchantShortName

    @OutSubMerchantShortName.setter
    def OutSubMerchantShortName(self, OutSubMerchantShortName):
        self._OutSubMerchantShortName = OutSubMerchantShortName

    @property
    def OutSubMerchantDescription(self):
        """外部子商户描述。
        :rtype: str
        """
        return self._OutSubMerchantDescription

    @OutSubMerchantDescription.setter
    def OutSubMerchantDescription(self, OutSubMerchantDescription):
        self._OutSubMerchantDescription = OutSubMerchantDescription

    @property
    def ExternalSubMerchantRegistrationData(self):
        """第三方子商户进件信息，为JSON格式字符串。详情见附录-复杂类型。
        :rtype: str
        """
        return self._ExternalSubMerchantRegistrationData

    @ExternalSubMerchantRegistrationData.setter
    def ExternalSubMerchantRegistrationData(self, ExternalSubMerchantRegistrationData):
        self._ExternalSubMerchantRegistrationData = ExternalSubMerchantRegistrationData

    @property
    def NotifyUrl(self):
        """通知地址。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._OutRegistrationNo = params.get("OutRegistrationNo")
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._OutSubMerchantId = params.get("OutSubMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._PaymentMethod = params.get("PaymentMethod")
        self._BusinessLicenseNumber = params.get("BusinessLicenseNumber")
        self._OutSubMerchantName = params.get("OutSubMerchantName")
        self._LegalName = params.get("LegalName")
        self._OutSubMerchantShortName = params.get("OutSubMerchantShortName")
        self._OutSubMerchantDescription = params.get("OutSubMerchantDescription")
        self._ExternalSubMerchantRegistrationData = params.get("ExternalSubMerchantRegistrationData")
        self._NotifyUrl = params.get("NotifyUrl")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankExternalSubMerchantRegistrationResponse(AbstractModel):
    """CreateOpenBankExternalSubMerchantRegistration返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :type ErrCode: str
        :param _ErrMessage: 错误消息。
        :type ErrMessage: str
        :param _Result: 返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankExternalSubMerchantRegistrationResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankExternalSubMerchantRegistrationResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankExternalSubMerchantRegistrationResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankExternalSubMerchantRegistrationResult(AbstractModel):
    """子商户进件返回结果

    """

    def __init__(self):
        r"""
        :param _RegistrationStatus: 进件状态。
__SUCCESS__: 进件成功
__FAILED__: 进件失败
__PROCESSING__: 进件中
注意：若返回进件中，需要再次调用进件结果查询接口，查询结果。
        :type RegistrationStatus: str
        :param _RegistrationMessage: 进件返回描述, 例如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :type RegistrationMessage: str
        :param _ChannelRegistrationNo: 渠道进件序列号。
        :type ChannelRegistrationNo: str
        :param _ChannelSubMerchantId: 渠道子商户ID。
        :type ChannelSubMerchantId: str
        :param _ExternalReturnData: 第三方渠道返回信息, 为JSON格式字符串。详情见附录-复杂类型。
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnData: str
        """
        self._RegistrationStatus = None
        self._RegistrationMessage = None
        self._ChannelRegistrationNo = None
        self._ChannelSubMerchantId = None
        self._ExternalReturnData = None

    @property
    def RegistrationStatus(self):
        """进件状态。
__SUCCESS__: 进件成功
__FAILED__: 进件失败
__PROCESSING__: 进件中
注意：若返回进件中，需要再次调用进件结果查询接口，查询结果。
        :rtype: str
        """
        return self._RegistrationStatus

    @RegistrationStatus.setter
    def RegistrationStatus(self, RegistrationStatus):
        self._RegistrationStatus = RegistrationStatus

    @property
    def RegistrationMessage(self):
        """进件返回描述, 例如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RegistrationMessage

    @RegistrationMessage.setter
    def RegistrationMessage(self, RegistrationMessage):
        self._RegistrationMessage = RegistrationMessage

    @property
    def ChannelRegistrationNo(self):
        """渠道进件序列号。
        :rtype: str
        """
        return self._ChannelRegistrationNo

    @ChannelRegistrationNo.setter
    def ChannelRegistrationNo(self, ChannelRegistrationNo):
        self._ChannelRegistrationNo = ChannelRegistrationNo

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户ID。
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def ExternalReturnData(self):
        """第三方渠道返回信息, 为JSON格式字符串。详情见附录-复杂类型。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnData

    @ExternalReturnData.setter
    def ExternalReturnData(self, ExternalReturnData):
        self._ExternalReturnData = ExternalReturnData


    def _deserialize(self, params):
        self._RegistrationStatus = params.get("RegistrationStatus")
        self._RegistrationMessage = params.get("RegistrationMessage")
        self._ChannelRegistrationNo = params.get("ChannelRegistrationNo")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._ExternalReturnData = params.get("ExternalReturnData")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankGlobalPaymentOrderRequest(AbstractModel):
    """CreateOpenBankGlobalPaymentOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 渠道商户号
        :type ChannelMerchantId: str
        :param _ChannelName: 渠道名称
        :type ChannelName: str
        :param _PayType: 付款方式
        :type PayType: str
        :param _OutOrderId: 外部商户订单号,只能是数字、大小写字母，且在同一个接入平台下唯一
        :type OutOrderId: str
        :param _TotalAmount: 付款金额，单位分
        :type TotalAmount: int
        :param _Currency: 支付币种，参考附录：货币代码
        :type Currency: str
        :param _ChannelSubMerchantId: 渠道子商户号
        :type ChannelSubMerchantId: str
        :param _NotifyUrl: 支付成功回调地址。
        :type NotifyUrl: str
        :param _FrontUrl: 前端跳转地址。通联支付成功后，支付网关跳回商户的地址
        :type FrontUrl: str
        :param _FrontLanguage: 网站语言。收银台显示语言，见附录网站语言
        :type FrontLanguage: str
        :param _Remark: 付款备注
        :type Remark: str
        :param _ExternalPaymentData: 第三方拓展信息信息
        :type ExternalPaymentData: str
        :param _GoodsInfos: 商品信息
        :type GoodsInfos: list of OpenBankGoodsInfo
        :param _ShippingInfo: 邮寄信息
        :type ShippingInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankShippingInfo`
        :param _BillingInfo: 账单信息
        :type BillingInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankBillingInfo`
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
缺省默认为生产环境
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._ChannelName = None
        self._PayType = None
        self._OutOrderId = None
        self._TotalAmount = None
        self._Currency = None
        self._ChannelSubMerchantId = None
        self._NotifyUrl = None
        self._FrontUrl = None
        self._FrontLanguage = None
        self._Remark = None
        self._ExternalPaymentData = None
        self._GoodsInfos = None
        self._ShippingInfo = None
        self._BillingInfo = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """渠道商户号
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def ChannelName(self):
        """渠道名称
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PayType(self):
        """付款方式
        :rtype: str
        """
        return self._PayType

    @PayType.setter
    def PayType(self, PayType):
        self._PayType = PayType

    @property
    def OutOrderId(self):
        """外部商户订单号,只能是数字、大小写字母，且在同一个接入平台下唯一
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def TotalAmount(self):
        """付款金额，单位分
        :rtype: int
        """
        return self._TotalAmount

    @TotalAmount.setter
    def TotalAmount(self, TotalAmount):
        self._TotalAmount = TotalAmount

    @property
    def Currency(self):
        """支付币种，参考附录：货币代码
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户号
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def NotifyUrl(self):
        """支付成功回调地址。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def FrontUrl(self):
        """前端跳转地址。通联支付成功后，支付网关跳回商户的地址
        :rtype: str
        """
        return self._FrontUrl

    @FrontUrl.setter
    def FrontUrl(self, FrontUrl):
        self._FrontUrl = FrontUrl

    @property
    def FrontLanguage(self):
        """网站语言。收银台显示语言，见附录网站语言
        :rtype: str
        """
        return self._FrontLanguage

    @FrontLanguage.setter
    def FrontLanguage(self, FrontLanguage):
        self._FrontLanguage = FrontLanguage

    @property
    def Remark(self):
        """付款备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ExternalPaymentData(self):
        """第三方拓展信息信息
        :rtype: str
        """
        return self._ExternalPaymentData

    @ExternalPaymentData.setter
    def ExternalPaymentData(self, ExternalPaymentData):
        self._ExternalPaymentData = ExternalPaymentData

    @property
    def GoodsInfos(self):
        """商品信息
        :rtype: list of OpenBankGoodsInfo
        """
        return self._GoodsInfos

    @GoodsInfos.setter
    def GoodsInfos(self, GoodsInfos):
        self._GoodsInfos = GoodsInfos

    @property
    def ShippingInfo(self):
        """邮寄信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankShippingInfo`
        """
        return self._ShippingInfo

    @ShippingInfo.setter
    def ShippingInfo(self, ShippingInfo):
        self._ShippingInfo = ShippingInfo

    @property
    def BillingInfo(self):
        """账单信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankBillingInfo`
        """
        return self._BillingInfo

    @BillingInfo.setter
    def BillingInfo(self, BillingInfo):
        self._BillingInfo = BillingInfo

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._PayType = params.get("PayType")
        self._OutOrderId = params.get("OutOrderId")
        self._TotalAmount = params.get("TotalAmount")
        self._Currency = params.get("Currency")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._NotifyUrl = params.get("NotifyUrl")
        self._FrontUrl = params.get("FrontUrl")
        self._FrontLanguage = params.get("FrontLanguage")
        self._Remark = params.get("Remark")
        self._ExternalPaymentData = params.get("ExternalPaymentData")
        if params.get("GoodsInfos") is not None:
            self._GoodsInfos = []
            for item in params.get("GoodsInfos"):
                obj = OpenBankGoodsInfo()
                obj._deserialize(item)
                self._GoodsInfos.append(obj)
        if params.get("ShippingInfo") is not None:
            self._ShippingInfo = OpenBankShippingInfo()
            self._ShippingInfo._deserialize(params.get("ShippingInfo"))
        if params.get("BillingInfo") is not None:
            self._BillingInfo = OpenBankBillingInfo()
            self._BillingInfo._deserialize(params.get("BillingInfo"))
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankGlobalPaymentOrderResponse(AbstractModel):
    """CreateOpenBankGlobalPaymentOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 业务系统返回码，SUCCESS表示成功，其他表示失败。
        :type ErrCode: str
        :param _ErrMessage: 业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 统一下单响应对象。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankUnifiedOrderPaymentResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """业务系统返回码，SUCCESS表示成功，其他表示失败。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """统一下单响应对象。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankUnifiedOrderPaymentResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankUnifiedOrderPaymentResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankMerchantRequest(AbstractModel):
    """CreateOpenBankMerchant请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OutMerchantId: 外部商户ID。
        :type OutMerchantId: str
        :param _ChannelName: 渠道名称。
__TENPAY__: 商企付
        :type ChannelName: str
        :param _OutMerchantName: 外部商户名称。
        :type OutMerchantName: str
        :param _ExternalMerchantInfo: 第三方渠道商户信息。详情见附录-复杂类型。
        :type ExternalMerchantInfo: str
        :param _OutMerchantShortName: 外部商户简称。
        :type OutMerchantShortName: str
        :param _OutMerchantDescription: 外部商户描述
        :type OutMerchantDescription: str
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._OutMerchantId = None
        self._ChannelName = None
        self._OutMerchantName = None
        self._ExternalMerchantInfo = None
        self._OutMerchantShortName = None
        self._OutMerchantDescription = None
        self._Environment = None

    @property
    def OutMerchantId(self):
        """外部商户ID。
        :rtype: str
        """
        return self._OutMerchantId

    @OutMerchantId.setter
    def OutMerchantId(self, OutMerchantId):
        self._OutMerchantId = OutMerchantId

    @property
    def ChannelName(self):
        """渠道名称。
__TENPAY__: 商企付
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def OutMerchantName(self):
        """外部商户名称。
        :rtype: str
        """
        return self._OutMerchantName

    @OutMerchantName.setter
    def OutMerchantName(self, OutMerchantName):
        self._OutMerchantName = OutMerchantName

    @property
    def ExternalMerchantInfo(self):
        """第三方渠道商户信息。详情见附录-复杂类型。
        :rtype: str
        """
        return self._ExternalMerchantInfo

    @ExternalMerchantInfo.setter
    def ExternalMerchantInfo(self, ExternalMerchantInfo):
        self._ExternalMerchantInfo = ExternalMerchantInfo

    @property
    def OutMerchantShortName(self):
        """外部商户简称。
        :rtype: str
        """
        return self._OutMerchantShortName

    @OutMerchantShortName.setter
    def OutMerchantShortName(self, OutMerchantShortName):
        self._OutMerchantShortName = OutMerchantShortName

    @property
    def OutMerchantDescription(self):
        """外部商户描述
        :rtype: str
        """
        return self._OutMerchantDescription

    @OutMerchantDescription.setter
    def OutMerchantDescription(self, OutMerchantDescription):
        self._OutMerchantDescription = OutMerchantDescription

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._OutMerchantId = params.get("OutMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._OutMerchantName = params.get("OutMerchantName")
        self._ExternalMerchantInfo = params.get("ExternalMerchantInfo")
        self._OutMerchantShortName = params.get("OutMerchantShortName")
        self._OutMerchantDescription = params.get("OutMerchantDescription")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankMerchantResponse(AbstractModel):
    """CreateOpenBankMerchant返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :type ErrCode: str
        :param _ErrMessage: 错误消息。
        :type ErrMessage: str
        :param _Result: 返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankMerchantResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankMerchantResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankMerchantResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankMerchantResult(AbstractModel):
    """创建渠道商户返回结果

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 渠道商户ID。
        :type ChannelMerchantId: str
        """
        self._ChannelMerchantId = None

    @property
    def ChannelMerchantId(self):
        """渠道商户ID。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankOrderPaymentResult(AbstractModel):
    """云企付-支付下单返回响应

    """

    def __init__(self):
        r"""
        :param _ChannelOrderId: 云企付平台订单号。
        :type ChannelOrderId: str
        :param _ThirdPayOrderId: 第三方支付平台返回支付订单号。
注意：此字段可能返回 null，表示取不到有效值。
        :type ThirdPayOrderId: str
        :param _RedirectInfo: 跳转参数渠道为TENPAY，付款方式为EBANK_PAYMENT时必选。
注意：此字段可能返回 null，表示取不到有效值。
        :type RedirectInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankRedirectInfo`
        :param _OutOrderId: 外部商户订单号，只能是数字、大小写字母，且在同一个接入平台下唯一。
        :type OutOrderId: str
        :param _PayInfo: 渠道扩展支付信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PayInfo: str
        :param _PayInfoType: 渠道扩展支付信息类型
注意：此字段可能返回 null，表示取不到有效值。
        :type PayInfoType: str
        """
        self._ChannelOrderId = None
        self._ThirdPayOrderId = None
        self._RedirectInfo = None
        self._OutOrderId = None
        self._PayInfo = None
        self._PayInfoType = None

    @property
    def ChannelOrderId(self):
        """云企付平台订单号。
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def ThirdPayOrderId(self):
        """第三方支付平台返回支付订单号。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ThirdPayOrderId

    @ThirdPayOrderId.setter
    def ThirdPayOrderId(self, ThirdPayOrderId):
        self._ThirdPayOrderId = ThirdPayOrderId

    @property
    def RedirectInfo(self):
        """跳转参数渠道为TENPAY，付款方式为EBANK_PAYMENT时必选。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankRedirectInfo`
        """
        return self._RedirectInfo

    @RedirectInfo.setter
    def RedirectInfo(self, RedirectInfo):
        self._RedirectInfo = RedirectInfo

    @property
    def OutOrderId(self):
        """外部商户订单号，只能是数字、大小写字母，且在同一个接入平台下唯一。
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def PayInfo(self):
        """渠道扩展支付信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayInfo

    @PayInfo.setter
    def PayInfo(self, PayInfo):
        self._PayInfo = PayInfo

    @property
    def PayInfoType(self):
        """渠道扩展支付信息类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayInfoType

    @PayInfoType.setter
    def PayInfoType(self, PayInfoType):
        self._PayInfoType = PayInfoType


    def _deserialize(self, params):
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._ThirdPayOrderId = params.get("ThirdPayOrderId")
        if params.get("RedirectInfo") is not None:
            self._RedirectInfo = OpenBankRedirectInfo()
            self._RedirectInfo._deserialize(params.get("RedirectInfo"))
        self._OutOrderId = params.get("OutOrderId")
        self._PayInfo = params.get("PayInfo")
        self._PayInfoType = params.get("PayInfoType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankOrderRechargeResult(AbstractModel):
    """云企付-充值下单返回响应

    """

    def __init__(self):
        r"""
        :param _ChannelOrderId: 云企付平台订单号。
        :type ChannelOrderId: str
        :param _ThirdPayOrderId: 第三方支付平台返回支付订单号。
注意：此字段可能返回 null，表示取不到有效值。
        :type ThirdPayOrderId: str
        :param _RedirectInfo: 跳转参数
注意：此字段可能返回 null，表示取不到有效值。
        :type RedirectInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankRechargeRedirectInfo`
        :param _OutOrderId: 外部商户订单号，只能是数字、大小写字母，且在同一个接入平台下唯一。
        :type OutOrderId: str
        :param _DealStatus: 充值状态
注意：此字段可能返回 null，表示取不到有效值。
        :type DealStatus: str
        :param _DealMessage: 充值返回描述
注意：此字段可能返回 null，表示取不到有效值。
        :type DealMessage: str
        :param _PcWebUrl: PC web端跳转链接
注意：此字段可能返回 null，表示取不到有效值。
        :type PcWebUrl: str
        """
        self._ChannelOrderId = None
        self._ThirdPayOrderId = None
        self._RedirectInfo = None
        self._OutOrderId = None
        self._DealStatus = None
        self._DealMessage = None
        self._PcWebUrl = None

    @property
    def ChannelOrderId(self):
        """云企付平台订单号。
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def ThirdPayOrderId(self):
        """第三方支付平台返回支付订单号。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ThirdPayOrderId

    @ThirdPayOrderId.setter
    def ThirdPayOrderId(self, ThirdPayOrderId):
        self._ThirdPayOrderId = ThirdPayOrderId

    @property
    def RedirectInfo(self):
        """跳转参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankRechargeRedirectInfo`
        """
        return self._RedirectInfo

    @RedirectInfo.setter
    def RedirectInfo(self, RedirectInfo):
        self._RedirectInfo = RedirectInfo

    @property
    def OutOrderId(self):
        """外部商户订单号，只能是数字、大小写字母，且在同一个接入平台下唯一。
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def DealStatus(self):
        """充值状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DealStatus

    @DealStatus.setter
    def DealStatus(self, DealStatus):
        self._DealStatus = DealStatus

    @property
    def DealMessage(self):
        """充值返回描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DealMessage

    @DealMessage.setter
    def DealMessage(self, DealMessage):
        self._DealMessage = DealMessage

    @property
    def PcWebUrl(self):
        """PC web端跳转链接
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PcWebUrl

    @PcWebUrl.setter
    def PcWebUrl(self, PcWebUrl):
        self._PcWebUrl = PcWebUrl


    def _deserialize(self, params):
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._ThirdPayOrderId = params.get("ThirdPayOrderId")
        if params.get("RedirectInfo") is not None:
            self._RedirectInfo = OpenBankRechargeRedirectInfo()
            self._RedirectInfo._deserialize(params.get("RedirectInfo"))
        self._OutOrderId = params.get("OutOrderId")
        self._DealStatus = params.get("DealStatus")
        self._DealMessage = params.get("DealMessage")
        self._PcWebUrl = params.get("PcWebUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankPaymentOrderRequest(AbstractModel):
    """CreateOpenBankPaymentOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 云企付渠道商户号。外部接入平台入驻云企付平台后下发。
        :type ChannelMerchantId: str
        :param _ChannelName: 渠道名称。详见附录-云企付枚举类说明-ChannelName。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
__HUIFU__: 汇付斗拱
        :type ChannelName: str
        :param _PaymentMethod: 付款方式。详见附录-云企付枚举类说明-PaymentMethod。
__EBANK_PAYMENT__:B2B EBank付款
__OPENBANK_PAYMENT__:B2C  openbank付款
__SAFT_ISV__:支付宝安心发
__TRANS_TO_CHANGE__: 微信支付转账到零钱v2
__TRANS_TO_CHANGE_V3__: 微信支付转账到零钱v3
__ONLINEBANK__: 汇付网银
        :type PaymentMethod: str
        :param _PaymentMode: 付款模式。默认直接支付，如
__DIRECT__:直接支付
__FREEZE__:担保支付
        :type PaymentMode: str
        :param _OutOrderId: 外部订单号,只能是数字、大小写字母，且在同一个接入平台下唯一，限定长度40位。
        :type OutOrderId: str
        :param _TotalAmount: 付款金额，单位分。
        :type TotalAmount: int
        :param _Currency: 固定值CNY。
        :type Currency: str
        :param _PayerInfo: 付款方信息。
        :type PayerInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankPayerInfo`
        :param _PayeeInfo: 收款方信息。
        :type PayeeInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankPayeeInfo`
        :param _NotifyUrl: 通知地址，如www.test.com。
        :type NotifyUrl: str
        :param _ExpireTime: 订单过期时间，yyyy-MM-dd HH:mm:ss格式。
        :type ExpireTime: str
        :param _FrontUrl: 前端成功回调URL。条件可选。
        :type FrontUrl: str
        :param _RefreshUrl: 前端刷新 URL。条件可选。
        :type RefreshUrl: str
        :param _SceneInfo: 设备信息，条件可选。
        :type SceneInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankSceneInfo`
        :param _GoodsInfo: 商品信息，条件可选。
        :type GoodsInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankGoodsInfo`
        :param _Attachment: 附加信息，查询时原样返回。
        :type Attachment: str
        :param _ProfitShareFlag: 若不上传，即使用默认值无需分润
__NO_NEED_SHARE__：无需分润；
__SHARE_BY_INFO__：分润时指定金额，此时如果分润信息 ProfitShareInfo为空，只冻结，不分账给其他商户；需要调用解冻接口。
__SHARE_BY_API__：后续调用分润接口决定分润金额
        :type ProfitShareFlag: str
        :param _ProfitShareInfoList: 分润信息，配合ProfitShareFlag使用。
        :type ProfitShareInfoList: list of OpenBankProfitShareInfo
        :param _SettlementRulesInfo: 商企付-担保支付（PaymentMode为 FREEZE ）时需设置该参数
        :type SettlementRulesInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankSettlementRulesInfo`
        :param _ExternalPaymentData: 底层支付渠道特殊字段，若无特殊说明时，可以为空
        :type ExternalPaymentData: str
        :param _Remark: 备注信息。
        :type Remark: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
缺省默认为生产环境
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._ChannelName = None
        self._PaymentMethod = None
        self._PaymentMode = None
        self._OutOrderId = None
        self._TotalAmount = None
        self._Currency = None
        self._PayerInfo = None
        self._PayeeInfo = None
        self._NotifyUrl = None
        self._ExpireTime = None
        self._FrontUrl = None
        self._RefreshUrl = None
        self._SceneInfo = None
        self._GoodsInfo = None
        self._Attachment = None
        self._ProfitShareFlag = None
        self._ProfitShareInfoList = None
        self._SettlementRulesInfo = None
        self._ExternalPaymentData = None
        self._Remark = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """云企付渠道商户号。外部接入平台入驻云企付平台后下发。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def ChannelName(self):
        """渠道名称。详见附录-云企付枚举类说明-ChannelName。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
__HUIFU__: 汇付斗拱
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PaymentMethod(self):
        """付款方式。详见附录-云企付枚举类说明-PaymentMethod。
__EBANK_PAYMENT__:B2B EBank付款
__OPENBANK_PAYMENT__:B2C  openbank付款
__SAFT_ISV__:支付宝安心发
__TRANS_TO_CHANGE__: 微信支付转账到零钱v2
__TRANS_TO_CHANGE_V3__: 微信支付转账到零钱v3
__ONLINEBANK__: 汇付网银
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def PaymentMode(self):
        """付款模式。默认直接支付，如
__DIRECT__:直接支付
__FREEZE__:担保支付
        :rtype: str
        """
        return self._PaymentMode

    @PaymentMode.setter
    def PaymentMode(self, PaymentMode):
        self._PaymentMode = PaymentMode

    @property
    def OutOrderId(self):
        """外部订单号,只能是数字、大小写字母，且在同一个接入平台下唯一，限定长度40位。
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def TotalAmount(self):
        """付款金额，单位分。
        :rtype: int
        """
        return self._TotalAmount

    @TotalAmount.setter
    def TotalAmount(self, TotalAmount):
        self._TotalAmount = TotalAmount

    @property
    def Currency(self):
        """固定值CNY。
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def PayerInfo(self):
        """付款方信息。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankPayerInfo`
        """
        return self._PayerInfo

    @PayerInfo.setter
    def PayerInfo(self, PayerInfo):
        self._PayerInfo = PayerInfo

    @property
    def PayeeInfo(self):
        """收款方信息。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankPayeeInfo`
        """
        return self._PayeeInfo

    @PayeeInfo.setter
    def PayeeInfo(self, PayeeInfo):
        self._PayeeInfo = PayeeInfo

    @property
    def NotifyUrl(self):
        """通知地址，如www.test.com。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def ExpireTime(self):
        """订单过期时间，yyyy-MM-dd HH:mm:ss格式。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def FrontUrl(self):
        """前端成功回调URL。条件可选。
        :rtype: str
        """
        return self._FrontUrl

    @FrontUrl.setter
    def FrontUrl(self, FrontUrl):
        self._FrontUrl = FrontUrl

    @property
    def RefreshUrl(self):
        """前端刷新 URL。条件可选。
        :rtype: str
        """
        return self._RefreshUrl

    @RefreshUrl.setter
    def RefreshUrl(self, RefreshUrl):
        self._RefreshUrl = RefreshUrl

    @property
    def SceneInfo(self):
        """设备信息，条件可选。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankSceneInfo`
        """
        return self._SceneInfo

    @SceneInfo.setter
    def SceneInfo(self, SceneInfo):
        self._SceneInfo = SceneInfo

    @property
    def GoodsInfo(self):
        """商品信息，条件可选。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankGoodsInfo`
        """
        return self._GoodsInfo

    @GoodsInfo.setter
    def GoodsInfo(self, GoodsInfo):
        self._GoodsInfo = GoodsInfo

    @property
    def Attachment(self):
        """附加信息，查询时原样返回。
        :rtype: str
        """
        return self._Attachment

    @Attachment.setter
    def Attachment(self, Attachment):
        self._Attachment = Attachment

    @property
    def ProfitShareFlag(self):
        """若不上传，即使用默认值无需分润
__NO_NEED_SHARE__：无需分润；
__SHARE_BY_INFO__：分润时指定金额，此时如果分润信息 ProfitShareInfo为空，只冻结，不分账给其他商户；需要调用解冻接口。
__SHARE_BY_API__：后续调用分润接口决定分润金额
        :rtype: str
        """
        return self._ProfitShareFlag

    @ProfitShareFlag.setter
    def ProfitShareFlag(self, ProfitShareFlag):
        self._ProfitShareFlag = ProfitShareFlag

    @property
    def ProfitShareInfoList(self):
        """分润信息，配合ProfitShareFlag使用。
        :rtype: list of OpenBankProfitShareInfo
        """
        return self._ProfitShareInfoList

    @ProfitShareInfoList.setter
    def ProfitShareInfoList(self, ProfitShareInfoList):
        self._ProfitShareInfoList = ProfitShareInfoList

    @property
    def SettlementRulesInfo(self):
        """商企付-担保支付（PaymentMode为 FREEZE ）时需设置该参数
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankSettlementRulesInfo`
        """
        return self._SettlementRulesInfo

    @SettlementRulesInfo.setter
    def SettlementRulesInfo(self, SettlementRulesInfo):
        self._SettlementRulesInfo = SettlementRulesInfo

    @property
    def ExternalPaymentData(self):
        """底层支付渠道特殊字段，若无特殊说明时，可以为空
        :rtype: str
        """
        return self._ExternalPaymentData

    @ExternalPaymentData.setter
    def ExternalPaymentData(self, ExternalPaymentData):
        self._ExternalPaymentData = ExternalPaymentData

    @property
    def Remark(self):
        """备注信息。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._PaymentMethod = params.get("PaymentMethod")
        self._PaymentMode = params.get("PaymentMode")
        self._OutOrderId = params.get("OutOrderId")
        self._TotalAmount = params.get("TotalAmount")
        self._Currency = params.get("Currency")
        if params.get("PayerInfo") is not None:
            self._PayerInfo = OpenBankPayerInfo()
            self._PayerInfo._deserialize(params.get("PayerInfo"))
        if params.get("PayeeInfo") is not None:
            self._PayeeInfo = OpenBankPayeeInfo()
            self._PayeeInfo._deserialize(params.get("PayeeInfo"))
        self._NotifyUrl = params.get("NotifyUrl")
        self._ExpireTime = params.get("ExpireTime")
        self._FrontUrl = params.get("FrontUrl")
        self._RefreshUrl = params.get("RefreshUrl")
        if params.get("SceneInfo") is not None:
            self._SceneInfo = OpenBankSceneInfo()
            self._SceneInfo._deserialize(params.get("SceneInfo"))
        if params.get("GoodsInfo") is not None:
            self._GoodsInfo = OpenBankGoodsInfo()
            self._GoodsInfo._deserialize(params.get("GoodsInfo"))
        self._Attachment = params.get("Attachment")
        self._ProfitShareFlag = params.get("ProfitShareFlag")
        if params.get("ProfitShareInfoList") is not None:
            self._ProfitShareInfoList = []
            for item in params.get("ProfitShareInfoList"):
                obj = OpenBankProfitShareInfo()
                obj._deserialize(item)
                self._ProfitShareInfoList.append(obj)
        if params.get("SettlementRulesInfo") is not None:
            self._SettlementRulesInfo = OpenBankSettlementRulesInfo()
            self._SettlementRulesInfo._deserialize(params.get("SettlementRulesInfo"))
        self._ExternalPaymentData = params.get("ExternalPaymentData")
        self._Remark = params.get("Remark")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankPaymentOrderResponse(AbstractModel):
    """CreateOpenBankPaymentOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 业务系统返回码，SUCCESS表示成功，其他表示失败。
        :type ErrCode: str
        :param _ErrMessage: 业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 统一下单响应对象。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankOrderPaymentResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """业务系统返回码，SUCCESS表示成功，其他表示失败。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """统一下单响应对象。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankOrderPaymentResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankOrderPaymentResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankRechargeOrderRequest(AbstractModel):
    """CreateOpenBankRechargeOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 云企付渠道商户号。外部接入平台入驻云企付平台后下发。
        :type ChannelMerchantId: str
        :param _OutOrderId: 外部订单号,只能是数字、大小写字母，且在同一个接入平台下唯一，限定长度40位。
        :type OutOrderId: str
        :param _TotalAmount: 付款金额，单位分。
        :type TotalAmount: int
        :param _Currency: 固定值CNY。
        :type Currency: str
        :param _ExpireTime: 订单过期时间，yyyy-MM-dd HH:mm:ss格式。
        :type ExpireTime: str
        :param _ChannelName: 渠道名称。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :type ChannelName: str
        :param _PaymentMethod: 渠道名称。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :type PaymentMethod: str
        :param _PayeeInfo: 收款方信息。
        :type PayeeInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankRechargePayeeInfo`
        :param _ChannelSubMerchantId: 渠道子商户号
        :type ChannelSubMerchantId: str
        :param _NotifyUrl: 通知地址，如www.test.com。
        :type NotifyUrl: str
        :param _Remark: 备注信息。限制200个字符。
        :type Remark: str
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._OutOrderId = None
        self._TotalAmount = None
        self._Currency = None
        self._ExpireTime = None
        self._ChannelName = None
        self._PaymentMethod = None
        self._PayeeInfo = None
        self._ChannelSubMerchantId = None
        self._NotifyUrl = None
        self._Remark = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """云企付渠道商户号。外部接入平台入驻云企付平台后下发。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def OutOrderId(self):
        """外部订单号,只能是数字、大小写字母，且在同一个接入平台下唯一，限定长度40位。
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def TotalAmount(self):
        """付款金额，单位分。
        :rtype: int
        """
        return self._TotalAmount

    @TotalAmount.setter
    def TotalAmount(self, TotalAmount):
        self._TotalAmount = TotalAmount

    @property
    def Currency(self):
        """固定值CNY。
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def ExpireTime(self):
        """订单过期时间，yyyy-MM-dd HH:mm:ss格式。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def ChannelName(self):
        """渠道名称。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PaymentMethod(self):
        """渠道名称。
__TENPAY__: 商企付
__WECHAT__: 微信支付
__ALIPAY__: 支付宝
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def PayeeInfo(self):
        """收款方信息。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankRechargePayeeInfo`
        """
        return self._PayeeInfo

    @PayeeInfo.setter
    def PayeeInfo(self, PayeeInfo):
        self._PayeeInfo = PayeeInfo

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户号
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def NotifyUrl(self):
        """通知地址，如www.test.com。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def Remark(self):
        """备注信息。限制200个字符。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._OutOrderId = params.get("OutOrderId")
        self._TotalAmount = params.get("TotalAmount")
        self._Currency = params.get("Currency")
        self._ExpireTime = params.get("ExpireTime")
        self._ChannelName = params.get("ChannelName")
        self._PaymentMethod = params.get("PaymentMethod")
        if params.get("PayeeInfo") is not None:
            self._PayeeInfo = OpenBankRechargePayeeInfo()
            self._PayeeInfo._deserialize(params.get("PayeeInfo"))
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._NotifyUrl = params.get("NotifyUrl")
        self._Remark = params.get("Remark")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankRechargeOrderResponse(AbstractModel):
    """CreateOpenBankRechargeOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 业务系统返回码，SUCCESS表示成功，其他表示失败。
        :type ErrCode: str
        :param _ErrMessage: 业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 充值响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankOrderRechargeResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """业务系统返回码，SUCCESS表示成功，其他表示失败。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """充值响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankOrderRechargeResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankOrderRechargeResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankSubMerchantRateConfigureRequest(AbstractModel):
    """CreateOpenBankSubMerchantRateConfigure请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelRegistrationNo: 渠道进件序列号。
填写子商户进件返回的渠道进件编号。
        :type ChannelRegistrationNo: str
        :param _OutProductFeeNo: 外部产品费率申请序列号。
        :type OutProductFeeNo: str
        :param _ChannelMerchantId: 渠道商户ID。
        :type ChannelMerchantId: str
        :param _ChannelSubMerchantId: 渠道子商户ID。
        :type ChannelSubMerchantId: str
        :param _ChannelName: 渠道名称。详见附录-云企付枚举类说明-ChannelName。
        :type ChannelName: str
        :param _PayType: 支付类型。
SWIPE:刷卡
SCAN:扫码
WAP:WAP
PUBLIC:公众号支付
SDK:SDK
MINI_PROGRAM:小程序
注意：HELIPAY渠道传SDK。
        :type PayType: str
        :param _PayChannel: 支付渠道。
ALIPAY：支付宝 
WXPAY：微信支付 
UNIONPAY：银联
        :type PayChannel: str
        :param _FeeMode: 计费模式。
SINGLE：按单笔金额计费
RATIO：按单笔费率计费 
RANGE：按分段区间计费
        :type FeeMode: str
        :param _FeeValue: 费用值，单位（0.01%或分）。
        :type FeeValue: int
        :param _PaymentMethod: 支付方式。详见附录-云企付枚举类说明-PaymentMethod。
HELIPAY渠道不需要传入。
        :type PaymentMethod: str
        :param _MinFee: 最低收费金额，单位（分）。
        :type MinFee: int
        :param _MaxFee: 最高收费金额，单位（分）。
        :type MaxFee: int
        :param _NotifyUrl: 通知地址。
        :type NotifyUrl: str
        :param _FeeRangeList: 分段计费区间列表。
        :type FeeRangeList: list of FeeRangInfo
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._ChannelRegistrationNo = None
        self._OutProductFeeNo = None
        self._ChannelMerchantId = None
        self._ChannelSubMerchantId = None
        self._ChannelName = None
        self._PayType = None
        self._PayChannel = None
        self._FeeMode = None
        self._FeeValue = None
        self._PaymentMethod = None
        self._MinFee = None
        self._MaxFee = None
        self._NotifyUrl = None
        self._FeeRangeList = None
        self._Environment = None

    @property
    def ChannelRegistrationNo(self):
        """渠道进件序列号。
填写子商户进件返回的渠道进件编号。
        :rtype: str
        """
        return self._ChannelRegistrationNo

    @ChannelRegistrationNo.setter
    def ChannelRegistrationNo(self, ChannelRegistrationNo):
        self._ChannelRegistrationNo = ChannelRegistrationNo

    @property
    def OutProductFeeNo(self):
        """外部产品费率申请序列号。
        :rtype: str
        """
        return self._OutProductFeeNo

    @OutProductFeeNo.setter
    def OutProductFeeNo(self, OutProductFeeNo):
        self._OutProductFeeNo = OutProductFeeNo

    @property
    def ChannelMerchantId(self):
        """渠道商户ID。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户ID。
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def ChannelName(self):
        """渠道名称。详见附录-云企付枚举类说明-ChannelName。
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PayType(self):
        """支付类型。
SWIPE:刷卡
SCAN:扫码
WAP:WAP
PUBLIC:公众号支付
SDK:SDK
MINI_PROGRAM:小程序
注意：HELIPAY渠道传SDK。
        :rtype: str
        """
        return self._PayType

    @PayType.setter
    def PayType(self, PayType):
        self._PayType = PayType

    @property
    def PayChannel(self):
        """支付渠道。
ALIPAY：支付宝 
WXPAY：微信支付 
UNIONPAY：银联
        :rtype: str
        """
        return self._PayChannel

    @PayChannel.setter
    def PayChannel(self, PayChannel):
        self._PayChannel = PayChannel

    @property
    def FeeMode(self):
        """计费模式。
SINGLE：按单笔金额计费
RATIO：按单笔费率计费 
RANGE：按分段区间计费
        :rtype: str
        """
        return self._FeeMode

    @FeeMode.setter
    def FeeMode(self, FeeMode):
        self._FeeMode = FeeMode

    @property
    def FeeValue(self):
        """费用值，单位（0.01%或分）。
        :rtype: int
        """
        return self._FeeValue

    @FeeValue.setter
    def FeeValue(self, FeeValue):
        self._FeeValue = FeeValue

    @property
    def PaymentMethod(self):
        """支付方式。详见附录-云企付枚举类说明-PaymentMethod。
HELIPAY渠道不需要传入。
        :rtype: str
        """
        return self._PaymentMethod

    @PaymentMethod.setter
    def PaymentMethod(self, PaymentMethod):
        self._PaymentMethod = PaymentMethod

    @property
    def MinFee(self):
        """最低收费金额，单位（分）。
        :rtype: int
        """
        return self._MinFee

    @MinFee.setter
    def MinFee(self, MinFee):
        self._MinFee = MinFee

    @property
    def MaxFee(self):
        """最高收费金额，单位（分）。
        :rtype: int
        """
        return self._MaxFee

    @MaxFee.setter
    def MaxFee(self, MaxFee):
        self._MaxFee = MaxFee

    @property
    def NotifyUrl(self):
        """通知地址。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def FeeRangeList(self):
        """分段计费区间列表。
        :rtype: list of FeeRangInfo
        """
        return self._FeeRangeList

    @FeeRangeList.setter
    def FeeRangeList(self, FeeRangeList):
        self._FeeRangeList = FeeRangeList

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelRegistrationNo = params.get("ChannelRegistrationNo")
        self._OutProductFeeNo = params.get("OutProductFeeNo")
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._PayType = params.get("PayType")
        self._PayChannel = params.get("PayChannel")
        self._FeeMode = params.get("FeeMode")
        self._FeeValue = params.get("FeeValue")
        self._PaymentMethod = params.get("PaymentMethod")
        self._MinFee = params.get("MinFee")
        self._MaxFee = params.get("MaxFee")
        self._NotifyUrl = params.get("NotifyUrl")
        if params.get("FeeRangeList") is not None:
            self._FeeRangeList = []
            for item in params.get("FeeRangeList"):
                obj = FeeRangInfo()
                obj._deserialize(item)
                self._FeeRangeList.append(obj)
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankSubMerchantRateConfigureResponse(AbstractModel):
    """CreateOpenBankSubMerchantRateConfigure返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :type ErrCode: str
        :param _ErrMessage: 错误消息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankSubMerchantRateConfigureResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。
__SUCCESS__: 成功
__其他__: 见附录-错误码表
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankSubMerchantRateConfigureResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankSubMerchantRateConfigureResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankSubMerchantRateConfigureResult(AbstractModel):
    """聚合支付子商户费率配置结果

    """

    def __init__(self):
        r"""
        :param _DealStatus: 处理状态 
SUCCESS: 开通成功 
FAILED: 开通失败
PROCESSING: 开通中 
注意：若返回开通中，需要再次调用费率配置结果查询接口，查询结果。
        :type DealStatus: str
        :param _DealMessage: 处理描述
注意：此字段可能返回 null，表示取不到有效值。
        :type DealMessage: str
        :param _ChannelProductFeeNo: 渠道产品费率序列号
        :type ChannelProductFeeNo: str
        """
        self._DealStatus = None
        self._DealMessage = None
        self._ChannelProductFeeNo = None

    @property
    def DealStatus(self):
        """处理状态 
SUCCESS: 开通成功 
FAILED: 开通失败
PROCESSING: 开通中 
注意：若返回开通中，需要再次调用费率配置结果查询接口，查询结果。
        :rtype: str
        """
        return self._DealStatus

    @DealStatus.setter
    def DealStatus(self, DealStatus):
        self._DealStatus = DealStatus

    @property
    def DealMessage(self):
        """处理描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DealMessage

    @DealMessage.setter
    def DealMessage(self, DealMessage):
        self._DealMessage = DealMessage

    @property
    def ChannelProductFeeNo(self):
        """渠道产品费率序列号
        :rtype: str
        """
        return self._ChannelProductFeeNo

    @ChannelProductFeeNo.setter
    def ChannelProductFeeNo(self, ChannelProductFeeNo):
        self._ChannelProductFeeNo = ChannelProductFeeNo


    def _deserialize(self, params):
        self._DealStatus = params.get("DealStatus")
        self._DealMessage = params.get("DealMessage")
        self._ChannelProductFeeNo = params.get("ChannelProductFeeNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankUnifiedOrderPaymentResult(AbstractModel):
    """云企付-支付下单返回响应

    """

    def __init__(self):
        r"""
        :param _ChannelOrderId: 云企付平台订单号。
        :type ChannelOrderId: str
        :param _ThirdPayOrderId: 第三方支付平台返回支付订单号。
注意：此字段可能返回 null，表示取不到有效值。
        :type ThirdPayOrderId: str
        :param _RedirectInfo: 跳转参数渠道为TENPAY，付款方式为EBANK_PAYMENT时必选。
注意：此字段可能返回 null，表示取不到有效值。
        :type RedirectInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankOrderRedirectInfo`
        :param _OutOrderId: 外部商户订单号，只能是数字、大小写字母，且在同一个接入平台下唯一。
        :type OutOrderId: str
        :param _PayInfo: 渠道扩展支付信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PayInfo: str
        :param _PayInfoType: 渠道扩展支付信息类型
注意：此字段可能返回 null，表示取不到有效值。
        :type PayInfoType: str
        """
        self._ChannelOrderId = None
        self._ThirdPayOrderId = None
        self._RedirectInfo = None
        self._OutOrderId = None
        self._PayInfo = None
        self._PayInfoType = None

    @property
    def ChannelOrderId(self):
        """云企付平台订单号。
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def ThirdPayOrderId(self):
        """第三方支付平台返回支付订单号。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ThirdPayOrderId

    @ThirdPayOrderId.setter
    def ThirdPayOrderId(self, ThirdPayOrderId):
        self._ThirdPayOrderId = ThirdPayOrderId

    @property
    def RedirectInfo(self):
        """跳转参数渠道为TENPAY，付款方式为EBANK_PAYMENT时必选。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankOrderRedirectInfo`
        """
        return self._RedirectInfo

    @RedirectInfo.setter
    def RedirectInfo(self, RedirectInfo):
        self._RedirectInfo = RedirectInfo

    @property
    def OutOrderId(self):
        """外部商户订单号，只能是数字、大小写字母，且在同一个接入平台下唯一。
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def PayInfo(self):
        """渠道扩展支付信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayInfo

    @PayInfo.setter
    def PayInfo(self, PayInfo):
        self._PayInfo = PayInfo

    @property
    def PayInfoType(self):
        """渠道扩展支付信息类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayInfoType

    @PayInfoType.setter
    def PayInfoType(self, PayInfoType):
        self._PayInfoType = PayInfoType


    def _deserialize(self, params):
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._ThirdPayOrderId = params.get("ThirdPayOrderId")
        if params.get("RedirectInfo") is not None:
            self._RedirectInfo = OpenBankOrderRedirectInfo()
            self._RedirectInfo._deserialize(params.get("RedirectInfo"))
        self._OutOrderId = params.get("OutOrderId")
        self._PayInfo = params.get("PayInfo")
        self._PayInfoType = params.get("PayInfoType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankUnifiedOrderRequest(AbstractModel):
    """CreateOpenBankUnifiedOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 渠道商户号。
        :type ChannelMerchantId: str
        :param _ChannelName: 渠道名称。
        :type ChannelName: str
        :param _PayType: 支付产品类型。
被扫（扫码）：SWIPE, 主扫（刷卡）：SCAN, 
H5：WAP, 公众号：PUBLIC, 
APP-SDK：SDK, 小程序：MINI_PROGRAM, 
快捷支付：QUICK, 网银支付：ONLINE_BANK。
        :type PayType: str
        :param _OutOrderId: 外部商户订单号。
只能是数字、大小写字母，且在同一个接入平台下唯一。
        :type OutOrderId: str
        :param _TotalAmount: 交易金额，单位分。
        :type TotalAmount: int
        :param _Currency: 币种。固定：CNY。
        :type Currency: str
        :param _ChannelSubMerchantId: 渠道子商户号。
        :type ChannelSubMerchantId: str
        :param _PayChannel: 实际支付渠道。没有则无需填写。如
支付宝 ALIPAY
微信支付 WXPAY
银联 UNIONPAY
一般在间连模式下使用。
        :type PayChannel: str
        :param _SceneInfo: 设备信息。
        :type SceneInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankSceneInfo`
        :param _ProfitShareInfoList: 分账信息列表。
        :type ProfitShareInfoList: list of OpenBankProfitShareInfo
        :param _OrderSubject: 订单标题。
        :type OrderSubject: str
        :param _GoodsDetail: 商品信息。
        :type GoodsDetail: str
        :param _ExpireTime: 超时时间。
        :type ExpireTime: str
        :param _NotifyUrl: 支付成功回调地址。
        :type NotifyUrl: str
        :param _FrontUrl: 支付成功前端跳转URL。
        :type FrontUrl: str
        :param _Attachment: 订单附加信息，查询或者回调的时候原样返回。
        :type Attachment: str
        :param _ExternalPaymentData: 第三方渠道扩展字段。见附录-复杂类型。
未作特殊说明，则无需传入。
        :type ExternalPaymentData: str
        :param _Remark: 备注。
        :type Remark: str
        :param _StoreInfo: 门店信息。
        :type StoreInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankStoreInfo`
        :param _PayLimitInfo: 支付限制。
        :type PayLimitInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankPayLimitInfo`
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._ChannelName = None
        self._PayType = None
        self._OutOrderId = None
        self._TotalAmount = None
        self._Currency = None
        self._ChannelSubMerchantId = None
        self._PayChannel = None
        self._SceneInfo = None
        self._ProfitShareInfoList = None
        self._OrderSubject = None
        self._GoodsDetail = None
        self._ExpireTime = None
        self._NotifyUrl = None
        self._FrontUrl = None
        self._Attachment = None
        self._ExternalPaymentData = None
        self._Remark = None
        self._StoreInfo = None
        self._PayLimitInfo = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """渠道商户号。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def ChannelName(self):
        """渠道名称。
        :rtype: str
        """
        return self._ChannelName

    @ChannelName.setter
    def ChannelName(self, ChannelName):
        self._ChannelName = ChannelName

    @property
    def PayType(self):
        """支付产品类型。
被扫（扫码）：SWIPE, 主扫（刷卡）：SCAN, 
H5：WAP, 公众号：PUBLIC, 
APP-SDK：SDK, 小程序：MINI_PROGRAM, 
快捷支付：QUICK, 网银支付：ONLINE_BANK。
        :rtype: str
        """
        return self._PayType

    @PayType.setter
    def PayType(self, PayType):
        self._PayType = PayType

    @property
    def OutOrderId(self):
        """外部商户订单号。
只能是数字、大小写字母，且在同一个接入平台下唯一。
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def TotalAmount(self):
        """交易金额，单位分。
        :rtype: int
        """
        return self._TotalAmount

    @TotalAmount.setter
    def TotalAmount(self, TotalAmount):
        self._TotalAmount = TotalAmount

    @property
    def Currency(self):
        """币种。固定：CNY。
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def ChannelSubMerchantId(self):
        """渠道子商户号。
        :rtype: str
        """
        return self._ChannelSubMerchantId

    @ChannelSubMerchantId.setter
    def ChannelSubMerchantId(self, ChannelSubMerchantId):
        self._ChannelSubMerchantId = ChannelSubMerchantId

    @property
    def PayChannel(self):
        """实际支付渠道。没有则无需填写。如
支付宝 ALIPAY
微信支付 WXPAY
银联 UNIONPAY
一般在间连模式下使用。
        :rtype: str
        """
        return self._PayChannel

    @PayChannel.setter
    def PayChannel(self, PayChannel):
        self._PayChannel = PayChannel

    @property
    def SceneInfo(self):
        """设备信息。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankSceneInfo`
        """
        return self._SceneInfo

    @SceneInfo.setter
    def SceneInfo(self, SceneInfo):
        self._SceneInfo = SceneInfo

    @property
    def ProfitShareInfoList(self):
        """分账信息列表。
        :rtype: list of OpenBankProfitShareInfo
        """
        return self._ProfitShareInfoList

    @ProfitShareInfoList.setter
    def ProfitShareInfoList(self, ProfitShareInfoList):
        self._ProfitShareInfoList = ProfitShareInfoList

    @property
    def OrderSubject(self):
        """订单标题。
        :rtype: str
        """
        return self._OrderSubject

    @OrderSubject.setter
    def OrderSubject(self, OrderSubject):
        self._OrderSubject = OrderSubject

    @property
    def GoodsDetail(self):
        """商品信息。
        :rtype: str
        """
        return self._GoodsDetail

    @GoodsDetail.setter
    def GoodsDetail(self, GoodsDetail):
        self._GoodsDetail = GoodsDetail

    @property
    def ExpireTime(self):
        """超时时间。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def NotifyUrl(self):
        """支付成功回调地址。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def FrontUrl(self):
        """支付成功前端跳转URL。
        :rtype: str
        """
        return self._FrontUrl

    @FrontUrl.setter
    def FrontUrl(self, FrontUrl):
        self._FrontUrl = FrontUrl

    @property
    def Attachment(self):
        """订单附加信息，查询或者回调的时候原样返回。
        :rtype: str
        """
        return self._Attachment

    @Attachment.setter
    def Attachment(self, Attachment):
        self._Attachment = Attachment

    @property
    def ExternalPaymentData(self):
        """第三方渠道扩展字段。见附录-复杂类型。
未作特殊说明，则无需传入。
        :rtype: str
        """
        return self._ExternalPaymentData

    @ExternalPaymentData.setter
    def ExternalPaymentData(self, ExternalPaymentData):
        self._ExternalPaymentData = ExternalPaymentData

    @property
    def Remark(self):
        """备注。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def StoreInfo(self):
        """门店信息。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankStoreInfo`
        """
        return self._StoreInfo

    @StoreInfo.setter
    def StoreInfo(self, StoreInfo):
        self._StoreInfo = StoreInfo

    @property
    def PayLimitInfo(self):
        """支付限制。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankPayLimitInfo`
        """
        return self._PayLimitInfo

    @PayLimitInfo.setter
    def PayLimitInfo(self, PayLimitInfo):
        self._PayLimitInfo = PayLimitInfo

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._ChannelName = params.get("ChannelName")
        self._PayType = params.get("PayType")
        self._OutOrderId = params.get("OutOrderId")
        self._TotalAmount = params.get("TotalAmount")
        self._Currency = params.get("Currency")
        self._ChannelSubMerchantId = params.get("ChannelSubMerchantId")
        self._PayChannel = params.get("PayChannel")
        if params.get("SceneInfo") is not None:
            self._SceneInfo = OpenBankSceneInfo()
            self._SceneInfo._deserialize(params.get("SceneInfo"))
        if params.get("ProfitShareInfoList") is not None:
            self._ProfitShareInfoList = []
            for item in params.get("ProfitShareInfoList"):
                obj = OpenBankProfitShareInfo()
                obj._deserialize(item)
                self._ProfitShareInfoList.append(obj)
        self._OrderSubject = params.get("OrderSubject")
        self._GoodsDetail = params.get("GoodsDetail")
        self._ExpireTime = params.get("ExpireTime")
        self._NotifyUrl = params.get("NotifyUrl")
        self._FrontUrl = params.get("FrontUrl")
        self._Attachment = params.get("Attachment")
        self._ExternalPaymentData = params.get("ExternalPaymentData")
        self._Remark = params.get("Remark")
        if params.get("StoreInfo") is not None:
            self._StoreInfo = OpenBankStoreInfo()
            self._StoreInfo._deserialize(params.get("StoreInfo"))
        if params.get("PayLimitInfo") is not None:
            self._PayLimitInfo = OpenBankPayLimitInfo()
            self._PayLimitInfo._deserialize(params.get("PayLimitInfo"))
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankUnifiedOrderResponse(AbstractModel):
    """CreateOpenBankUnifiedOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 业务系统返回码，SUCCESS表示成功，其他表示失败。
        :type ErrCode: str
        :param _ErrMessage: 业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 统一下单响应对象。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankOrderPaymentResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """业务系统返回码，SUCCESS表示成功，其他表示失败。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """统一下单响应对象。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankOrderPaymentResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankOrderPaymentResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankVerificationOrderRequest(AbstractModel):
    """CreateOpenBankVerificationOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelMerchantId: 云企付渠道商户号。外部接入平台入驻云企付平台后下发。
        :type ChannelMerchantId: str
        :param _OutVerificationId: 外部核销申请订单号
        :type OutVerificationId: str
        :param _VerificationAmount: 核销金额，单位分
        :type VerificationAmount: int
        :param _OutOrderId: 外部支付订单号。调用创建支付订单时，下单支付时的外部订单号。与ChannelOrderId不能同时为空。
        :type OutOrderId: str
        :param _ChannelOrderId: 云企付渠道订单号。调用创建支付订单时，下单支付时的云企付渠道订单号。与OutOrderId不能同时为空。
        :type ChannelOrderId: str
        :param _NotifyUrl: 核销成功回调地址。若不上送，则不回调通知。
        :type NotifyUrl: str
        :param _Remark: 备注。
        :type Remark: str
        :param _ExternalVerificationData: 第三方支付渠道需要额外上送字段。详情见附录描述。
        :type ExternalVerificationData: str
        :param _Environment: 环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :type Environment: str
        """
        self._ChannelMerchantId = None
        self._OutVerificationId = None
        self._VerificationAmount = None
        self._OutOrderId = None
        self._ChannelOrderId = None
        self._NotifyUrl = None
        self._Remark = None
        self._ExternalVerificationData = None
        self._Environment = None

    @property
    def ChannelMerchantId(self):
        """云企付渠道商户号。外部接入平台入驻云企付平台后下发。
        :rtype: str
        """
        return self._ChannelMerchantId

    @ChannelMerchantId.setter
    def ChannelMerchantId(self, ChannelMerchantId):
        self._ChannelMerchantId = ChannelMerchantId

    @property
    def OutVerificationId(self):
        """外部核销申请订单号
        :rtype: str
        """
        return self._OutVerificationId

    @OutVerificationId.setter
    def OutVerificationId(self, OutVerificationId):
        self._OutVerificationId = OutVerificationId

    @property
    def VerificationAmount(self):
        """核销金额，单位分
        :rtype: int
        """
        return self._VerificationAmount

    @VerificationAmount.setter
    def VerificationAmount(self, VerificationAmount):
        self._VerificationAmount = VerificationAmount

    @property
    def OutOrderId(self):
        """外部支付订单号。调用创建支付订单时，下单支付时的外部订单号。与ChannelOrderId不能同时为空。
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def ChannelOrderId(self):
        """云企付渠道订单号。调用创建支付订单时，下单支付时的云企付渠道订单号。与OutOrderId不能同时为空。
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def NotifyUrl(self):
        """核销成功回调地址。若不上送，则不回调通知。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def Remark(self):
        """备注。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ExternalVerificationData(self):
        """第三方支付渠道需要额外上送字段。详情见附录描述。
        :rtype: str
        """
        return self._ExternalVerificationData

    @ExternalVerificationData.setter
    def ExternalVerificationData(self, ExternalVerificationData):
        self._ExternalVerificationData = ExternalVerificationData

    @property
    def Environment(self):
        """环境类型。
__release__:生产环境
__sandbox__:沙箱环境
_不填默认为生产环境_
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._ChannelMerchantId = params.get("ChannelMerchantId")
        self._OutVerificationId = params.get("OutVerificationId")
        self._VerificationAmount = params.get("VerificationAmount")
        self._OutOrderId = params.get("OutOrderId")
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._NotifyUrl = params.get("NotifyUrl")
        self._Remark = params.get("Remark")
        self._ExternalVerificationData = params.get("ExternalVerificationData")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpenBankVerificationOrderResponse(AbstractModel):
    """CreateOpenBankVerificationOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 业务系统返回码，SUCCESS表示成功，其他表示失败。
        :type ErrCode: str
        :param _ErrMessage: 业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 核销申请响应对象。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankVerificationResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """业务系统返回码，SUCCESS表示成功，其他表示失败。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """业务系统返回消息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """核销申请响应对象。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateOpenBankVerificationResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateOpenBankVerificationResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateOpenBankVerificationResult(AbstractModel):
    """云企付-核销确认收货申请响应结果

    """

    def __init__(self):
        r"""
        :param _ChannelVerificationId: 云企付渠道核销订单号
        :type ChannelVerificationId: str
        :param _ThirdVerificationId: 第三方支付渠道核销订单号
        :type ThirdVerificationId: str
        :param _VerificationStatus: 核销状态
INIT("INIT","初始化"),
SUCCESS("SUCCESS","核销成功"),
FAILED("FAILED","核销失败"),
PROCESSING("PROCESSING","核销中");
        :type VerificationStatus: str
        :param _VerificationAmount: 核销金额，单位分
        :type VerificationAmount: int
        :param _ThirdVerificationReturnInfo: 渠道附加返回信息，一般情况可以不关注
注意：此字段可能返回 null，表示取不到有效值。
        :type ThirdVerificationReturnInfo: str
        """
        self._ChannelVerificationId = None
        self._ThirdVerificationId = None
        self._VerificationStatus = None
        self._VerificationAmount = None
        self._ThirdVerificationReturnInfo = None

    @property
    def ChannelVerificationId(self):
        """云企付渠道核销订单号
        :rtype: str
        """
        return self._ChannelVerificationId

    @ChannelVerificationId.setter
    def ChannelVerificationId(self, ChannelVerificationId):
        self._ChannelVerificationId = ChannelVerificationId

    @property
    def ThirdVerificationId(self):
        """第三方支付渠道核销订单号
        :rtype: str
        """
        return self._ThirdVerificationId

    @ThirdVerificationId.setter
    def ThirdVerificationId(self, ThirdVerificationId):
        self._ThirdVerificationId = ThirdVerificationId

    @property
    def VerificationStatus(self):
        """核销状态
INIT("INIT","初始化"),
SUCCESS("SUCCESS","核销成功"),
FAILED("FAILED","核销失败"),
PROCESSING("PROCESSING","核销中");
        :rtype: str
        """
        return self._VerificationStatus

    @VerificationStatus.setter
    def VerificationStatus(self, VerificationStatus):
        self._VerificationStatus = VerificationStatus

    @property
    def VerificationAmount(self):
        """核销金额，单位分
        :rtype: int
        """
        return self._VerificationAmount

    @VerificationAmount.setter
    def VerificationAmount(self, VerificationAmount):
        self._VerificationAmount = VerificationAmount

    @property
    def ThirdVerificationReturnInfo(self):
        """渠道附加返回信息，一般情况可以不关注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ThirdVerificationReturnInfo

    @ThirdVerificationReturnInfo.setter
    def ThirdVerificationReturnInfo(self, ThirdVerificationReturnInfo):
        self._ThirdVerificationReturnInfo = ThirdVerificationReturnInfo


    def _deserialize(self, params):
        self._ChannelVerificationId = params.get("ChannelVerificationId")
        self._ThirdVerificationId = params.get("ThirdVerificationId")
        self._VerificationStatus = params.get("VerificationStatus")
        self._VerificationAmount = params.get("VerificationAmount")
        self._ThirdVerificationReturnInfo = params.get("ThirdVerificationReturnInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrderRequest(AbstractModel):
    """CreateOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChannelCode: 渠道编号。ZSB2B：招商银行B2B。
        :type ChannelCode: str
        :param _MerchantAppId: 进件成功后返给商户方的 AppId。
        :type MerchantAppId: str
        :param _Amount: 交易金额。单位：元
        :type Amount: str
        :param _TraceNo: 商户流水号。商户唯一订单号由字母或数字组成。
        :type TraceNo: str
        :param _NotifyUrl: 通知地址。商户接收交易结果的通知地址。
        :type NotifyUrl: str
        :param _ReturnUrl: 返回地址。支付成功后，页面将跳 转返回到商户的该地址。
        :type ReturnUrl: str
        """
        self._ChannelCode = None
        self._MerchantAppId = None
        self._Amount = None
        self._TraceNo = None
        self._NotifyUrl = None
        self._ReturnUrl = None

    @property
    def ChannelCode(self):
        """渠道编号。ZSB2B：招商银行B2B。
        :rtype: str
        """
        return self._ChannelCode

    @ChannelCode.setter
    def ChannelCode(self, ChannelCode):
        self._ChannelCode = ChannelCode

    @property
    def MerchantAppId(self):
        """进件成功后返给商户方的 AppId。
        :rtype: str
        """
        return self._MerchantAppId

    @MerchantAppId.setter
    def MerchantAppId(self, MerchantAppId):
        self._MerchantAppId = MerchantAppId

    @property
    def Amount(self):
        """交易金额。单位：元
        :rtype: str
        """
        return self._Amount

    @Amount.setter
    def Amount(self, Amount):
        self._Amount = Amount

    @property
    def TraceNo(self):
        """商户流水号。商户唯一订单号由字母或数字组成。
        :rtype: str
        """
        return self._TraceNo

    @TraceNo.setter
    def TraceNo(self, TraceNo):
        self._TraceNo = TraceNo

    @property
    def NotifyUrl(self):
        """通知地址。商户接收交易结果的通知地址。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def ReturnUrl(self):
        """返回地址。支付成功后，页面将跳 转返回到商户的该地址。
        :rtype: str
        """
        return self._ReturnUrl

    @ReturnUrl.setter
    def ReturnUrl(self, ReturnUrl):
        self._ReturnUrl = ReturnUrl


    def _deserialize(self, params):
        self._ChannelCode = params.get("ChannelCode")
        self._MerchantAppId = params.get("MerchantAppId")
        self._Amount = params.get("Amount")
        self._TraceNo = params.get("TraceNo")
        self._NotifyUrl = params.get("NotifyUrl")
        self._ReturnUrl = params.get("ReturnUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrderResponse(AbstractModel):
    """CreateOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantAppId: 进件成功后返给商户方的AppId。
        :type MerchantAppId: str
        :param _TraceNo: 商户流水号，商户唯一订单号由字母或数字组成。
        :type TraceNo: str
        :param _OrderNo: 平台流水号，若下单成功则返回。
        :type OrderNo: str
        :param _PayUrl: 支付页面跳转地址，若下单成功则返回。
        :type PayUrl: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MerchantAppId = None
        self._TraceNo = None
        self._OrderNo = None
        self._PayUrl = None
        self._RequestId = None

    @property
    def MerchantAppId(self):
        """进件成功后返给商户方的AppId。
        :rtype: str
        """
        return self._MerchantAppId

    @MerchantAppId.setter
    def MerchantAppId(self, MerchantAppId):
        self._MerchantAppId = MerchantAppId

    @property
    def TraceNo(self):
        """商户流水号，商户唯一订单号由字母或数字组成。
        :rtype: str
        """
        return self._TraceNo

    @TraceNo.setter
    def TraceNo(self, TraceNo):
        self._TraceNo = TraceNo

    @property
    def OrderNo(self):
        """平台流水号，若下单成功则返回。
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo

    @property
    def PayUrl(self):
        """支付页面跳转地址，若下单成功则返回。
        :rtype: str
        """
        return self._PayUrl

    @PayUrl.setter
    def PayUrl(self, PayUrl):
        self._PayUrl = PayUrl

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MerchantAppId = params.get("MerchantAppId")
        self._TraceNo = params.get("TraceNo")
        self._OrderNo = params.get("OrderNo")
        self._PayUrl = params.get("PayUrl")
        self._RequestId = params.get("RequestId")


class CreatePayMerchantRequest(AbstractModel):
    """CreatePayMerchant请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PlatformCode: 平台编号
        :type PlatformCode: str
        :param _ChannelMerchantNo: 渠道方收款商户编号，由渠道方(银行)提 供。
        :type ChannelMerchantNo: str
        :param _ChannelCheckFlag: 是否需要向渠道进行 商户信息验证 1:验证
0:不验证
        :type ChannelCheckFlag: str
        :param _MerchantName: 收款商户名称
        :type MerchantName: str
        :param _BusinessPayFlag: 是否开通 B2B 支付 1:开通 0:不开通 缺省:1
        :type BusinessPayFlag: str
        """
        self._PlatformCode = None
        self._ChannelMerchantNo = None
        self._ChannelCheckFlag = None
        self._MerchantName = None
        self._BusinessPayFlag = None

    @property
    def PlatformCode(self):
        """平台编号
        :rtype: str
        """
        return self._PlatformCode

    @PlatformCode.setter
    def PlatformCode(self, PlatformCode):
        self._PlatformCode = PlatformCode

    @property
    def ChannelMerchantNo(self):
        """渠道方收款商户编号，由渠道方(银行)提 供。
        :rtype: str
        """
        return self._ChannelMerchantNo

    @ChannelMerchantNo.setter
    def ChannelMerchantNo(self, ChannelMerchantNo):
        self._ChannelMerchantNo = ChannelMerchantNo

    @property
    def ChannelCheckFlag(self):
        """是否需要向渠道进行 商户信息验证 1:验证
0:不验证
        :rtype: str
        """
        return self._ChannelCheckFlag

    @ChannelCheckFlag.setter
    def ChannelCheckFlag(self, ChannelCheckFlag):
        self._ChannelCheckFlag = ChannelCheckFlag

    @property
    def MerchantName(self):
        """收款商户名称
        :rtype: str
        """
        return self._MerchantName

    @MerchantName.setter
    def MerchantName(self, MerchantName):
        self._MerchantName = MerchantName

    @property
    def BusinessPayFlag(self):
        """是否开通 B2B 支付 1:开通 0:不开通 缺省:1
        :rtype: str
        """
        return self._BusinessPayFlag

    @BusinessPayFlag.setter
    def BusinessPayFlag(self, BusinessPayFlag):
        self._BusinessPayFlag = BusinessPayFlag


    def _deserialize(self, params):
        self._PlatformCode = params.get("PlatformCode")
        self._ChannelMerchantNo = params.get("ChannelMerchantNo")
        self._ChannelCheckFlag = params.get("ChannelCheckFlag")
        self._MerchantName = params.get("MerchantName")
        self._BusinessPayFlag = params.get("BusinessPayFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePayMerchantResponse(AbstractModel):
    """CreatePayMerchant返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantAppId: 分配给商户的 AppId。该 AppId 为后续各项 交易的商户标识。
        :type MerchantAppId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MerchantAppId = None
        self._RequestId = None

    @property
    def MerchantAppId(self):
        """分配给商户的 AppId。该 AppId 为后续各项 交易的商户标识。
        :rtype: str
        """
        return self._MerchantAppId

    @MerchantAppId.setter
    def MerchantAppId(self, MerchantAppId):
        self._MerchantAppId = MerchantAppId

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MerchantAppId = params.get("MerchantAppId")
        self._RequestId = params.get("RequestId")


class CreatePayRollPreOrderRequest(AbstractModel):
    """CreatePayRollPreOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _AuthNumber: 商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :type AuthNumber: str
        :param _ProjectName: 该劳务活动的项目名称
        :type ProjectName: str
        :param _CompanyName: 该工人所属的用工企业
        :type CompanyName: str
        :param _WechatAppId: 是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatAppId: str
        :param _WechatSubAppId: 特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatSubAppId: str
        """
        self._OpenId = None
        self._SubMerchantId = None
        self._AuthNumber = None
        self._ProjectName = None
        self._CompanyName = None
        self._WechatAppId = None
        self._WechatSubAppId = None

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def AuthNumber(self):
        """商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :rtype: str
        """
        return self._AuthNumber

    @AuthNumber.setter
    def AuthNumber(self, AuthNumber):
        self._AuthNumber = AuthNumber

    @property
    def ProjectName(self):
        """该劳务活动的项目名称
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def CompanyName(self):
        """该工人所属的用工企业
        :rtype: str
        """
        return self._CompanyName

    @CompanyName.setter
    def CompanyName(self, CompanyName):
        self._CompanyName = CompanyName

    @property
    def WechatAppId(self):
        """是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatAppId

    @WechatAppId.setter
    def WechatAppId(self, WechatAppId):
        self._WechatAppId = WechatAppId

    @property
    def WechatSubAppId(self):
        """特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatSubAppId

    @WechatSubAppId.setter
    def WechatSubAppId(self, WechatSubAppId):
        self._WechatSubAppId = WechatSubAppId


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._AuthNumber = params.get("AuthNumber")
        self._ProjectName = params.get("ProjectName")
        self._CompanyName = params.get("CompanyName")
        self._WechatAppId = params.get("WechatAppId")
        self._WechatSubAppId = params.get("WechatSubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePayRollPreOrderResponse(AbstractModel):
    """CreatePayRollPreOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AuthNumber: 商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :type AuthNumber: str
        :param _ExpireTime: Token有效时间，单位秒
        :type ExpireTime: int
        :param _MerchantId: 微信服务商商户的商户号，由微信支付生成并下发
        :type MerchantId: str
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _Token: Token值
        :type Token: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AuthNumber = None
        self._ExpireTime = None
        self._MerchantId = None
        self._OpenId = None
        self._SubMerchantId = None
        self._Token = None
        self._RequestId = None

    @property
    def AuthNumber(self):
        """商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :rtype: str
        """
        return self._AuthNumber

    @AuthNumber.setter
    def AuthNumber(self, AuthNumber):
        self._AuthNumber = AuthNumber

    @property
    def ExpireTime(self):
        """Token有效时间，单位秒
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def MerchantId(self):
        """微信服务商商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def Token(self):
        """Token值
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AuthNumber = params.get("AuthNumber")
        self._ExpireTime = params.get("ExpireTime")
        self._MerchantId = params.get("MerchantId")
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._Token = params.get("Token")
        self._RequestId = params.get("RequestId")


class CreatePayRollPreOrderWithAuthRequest(AbstractModel):
    """CreatePayRollPreOrderWithAuth请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _AuthNumber: 商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :type AuthNumber: str
        :param _ProjectName: 该劳务活动的项目名称
        :type ProjectName: str
        :param _CompanyName: 该工人所属的用工企业
        :type CompanyName: str
        :param _UserName: 用户实名信息，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
        :type UserName: str
        :param _IdNo: 用户证件号，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
        :type IdNo: str
        :param _EmploymentType: 微工卡服务仅支持用于与商户有用工关系的用户，需明确用工类型；参考值：
LONG_TERM_EMPLOYMENT：长期用工，
SHORT_TERM_EMPLOYMENT： 短期用工，
COOPERATION_EMPLOYMENT：合作关系
        :type EmploymentType: str
        :param _WechatAppId: 是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatAppId: str
        :param _WechatSubAppId: 特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatSubAppId: str
        """
        self._OpenId = None
        self._SubMerchantId = None
        self._AuthNumber = None
        self._ProjectName = None
        self._CompanyName = None
        self._UserName = None
        self._IdNo = None
        self._EmploymentType = None
        self._WechatAppId = None
        self._WechatSubAppId = None

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def AuthNumber(self):
        """商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :rtype: str
        """
        return self._AuthNumber

    @AuthNumber.setter
    def AuthNumber(self, AuthNumber):
        self._AuthNumber = AuthNumber

    @property
    def ProjectName(self):
        """该劳务活动的项目名称
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def CompanyName(self):
        """该工人所属的用工企业
        :rtype: str
        """
        return self._CompanyName

    @CompanyName.setter
    def CompanyName(self, CompanyName):
        self._CompanyName = CompanyName

    @property
    def UserName(self):
        """用户实名信息，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def IdNo(self):
        """用户证件号，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
        :rtype: str
        """
        return self._IdNo

    @IdNo.setter
    def IdNo(self, IdNo):
        self._IdNo = IdNo

    @property
    def EmploymentType(self):
        """微工卡服务仅支持用于与商户有用工关系的用户，需明确用工类型；参考值：
LONG_TERM_EMPLOYMENT：长期用工，
SHORT_TERM_EMPLOYMENT： 短期用工，
COOPERATION_EMPLOYMENT：合作关系
        :rtype: str
        """
        return self._EmploymentType

    @EmploymentType.setter
    def EmploymentType(self, EmploymentType):
        self._EmploymentType = EmploymentType

    @property
    def WechatAppId(self):
        """是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatAppId

    @WechatAppId.setter
    def WechatAppId(self, WechatAppId):
        self._WechatAppId = WechatAppId

    @property
    def WechatSubAppId(self):
        """特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatSubAppId

    @WechatSubAppId.setter
    def WechatSubAppId(self, WechatSubAppId):
        self._WechatSubAppId = WechatSubAppId


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._AuthNumber = params.get("AuthNumber")
        self._ProjectName = params.get("ProjectName")
        self._CompanyName = params.get("CompanyName")
        self._UserName = params.get("UserName")
        self._IdNo = params.get("IdNo")
        self._EmploymentType = params.get("EmploymentType")
        self._WechatAppId = params.get("WechatAppId")
        self._WechatSubAppId = params.get("WechatSubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePayRollPreOrderWithAuthResponse(AbstractModel):
    """CreatePayRollPreOrderWithAuth返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AuthNumber: 商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :type AuthNumber: str
        :param _ExpireTime: Token有效时间，单位秒
        :type ExpireTime: int
        :param _MerchantId: 微信服务商商户的商户号，由微信支付生成并下发
        :type MerchantId: str
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _Token: Token值
        :type Token: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AuthNumber = None
        self._ExpireTime = None
        self._MerchantId = None
        self._OpenId = None
        self._SubMerchantId = None
        self._Token = None
        self._RequestId = None

    @property
    def AuthNumber(self):
        """商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :rtype: str
        """
        return self._AuthNumber

    @AuthNumber.setter
    def AuthNumber(self, AuthNumber):
        self._AuthNumber = AuthNumber

    @property
    def ExpireTime(self):
        """Token有效时间，单位秒
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def MerchantId(self):
        """微信服务商商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def Token(self):
        """Token值
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AuthNumber = params.get("AuthNumber")
        self._ExpireTime = params.get("ExpireTime")
        self._MerchantId = params.get("MerchantId")
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._Token = params.get("Token")
        self._RequestId = params.get("RequestId")


class CreatePayRollTokenRequest(AbstractModel):
    """CreatePayRollToken请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _UserName: 用户实名信息，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
        :type UserName: str
        :param _IdNo: 用户证件号，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
        :type IdNo: str
        :param _EmploymentType: 微工卡服务仅支持用于与商户有用工关系的用户，需明确用工类型；参考值：
LONG_TERM_EMPLOYMENT：长期用工，
SHORT_TERM_EMPLOYMENT： 短期用工，
COOPERATION_EMPLOYMENT：合作关系
        :type EmploymentType: str
        :param _WechatAppId: 是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatAppId: str
        :param _WechatSubAppId: 特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatSubAppId: str
        """
        self._OpenId = None
        self._SubMerchantId = None
        self._UserName = None
        self._IdNo = None
        self._EmploymentType = None
        self._WechatAppId = None
        self._WechatSubAppId = None

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def UserName(self):
        """用户实名信息，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def IdNo(self):
        """用户证件号，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
        :rtype: str
        """
        return self._IdNo

    @IdNo.setter
    def IdNo(self, IdNo):
        self._IdNo = IdNo

    @property
    def EmploymentType(self):
        """微工卡服务仅支持用于与商户有用工关系的用户，需明确用工类型；参考值：
LONG_TERM_EMPLOYMENT：长期用工，
SHORT_TERM_EMPLOYMENT： 短期用工，
COOPERATION_EMPLOYMENT：合作关系
        :rtype: str
        """
        return self._EmploymentType

    @EmploymentType.setter
    def EmploymentType(self, EmploymentType):
        self._EmploymentType = EmploymentType

    @property
    def WechatAppId(self):
        """是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatAppId

    @WechatAppId.setter
    def WechatAppId(self, WechatAppId):
        self._WechatAppId = WechatAppId

    @property
    def WechatSubAppId(self):
        """特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatSubAppId

    @WechatSubAppId.setter
    def WechatSubAppId(self, WechatSubAppId):
        self._WechatSubAppId = WechatSubAppId


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._UserName = params.get("UserName")
        self._IdNo = params.get("IdNo")
        self._EmploymentType = params.get("EmploymentType")
        self._WechatAppId = params.get("WechatAppId")
        self._WechatSubAppId = params.get("WechatSubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePayRollTokenResponse(AbstractModel):
    """CreatePayRollToken返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExpireTime: Token有效时间，单位秒
        :type ExpireTime: int
        :param _MerchantId: 微信服务商商户的商户号，由微信支付生成并下发
        :type MerchantId: str
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _Token: Token值
        :type Token: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExpireTime = None
        self._MerchantId = None
        self._OpenId = None
        self._SubMerchantId = None
        self._Token = None
        self._RequestId = None

    @property
    def ExpireTime(self):
        """Token有效时间，单位秒
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def MerchantId(self):
        """微信服务商商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def Token(self):
        """Token值
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExpireTime = params.get("ExpireTime")
        self._MerchantId = params.get("MerchantId")
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._Token = params.get("Token")
        self._RequestId = params.get("RequestId")


class CreateRedInvoiceItem(AbstractModel):
    """创建红票明细

    """

    def __init__(self):
        r"""
        :param _OrderId: 订单号
        :type OrderId: str
        :param _CallbackUrl: 发票结果回传地址
        :type CallbackUrl: str
        :param _OrderSn: 业务开票号
        :type OrderSn: str
        :param _RedSerialNo: 红字信息表编码
        :type RedSerialNo: str
        :param _StoreNo: 门店编号
        :type StoreNo: str
        """
        self._OrderId = None
        self._CallbackUrl = None
        self._OrderSn = None
        self._RedSerialNo = None
        self._StoreNo = None

    @property
    def OrderId(self):
        """订单号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def CallbackUrl(self):
        """发票结果回传地址
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def OrderSn(self):
        """业务开票号
        :rtype: str
        """
        return self._OrderSn

    @OrderSn.setter
    def OrderSn(self, OrderSn):
        self._OrderSn = OrderSn

    @property
    def RedSerialNo(self):
        """红字信息表编码
        :rtype: str
        """
        return self._RedSerialNo

    @RedSerialNo.setter
    def RedSerialNo(self, RedSerialNo):
        self._RedSerialNo = RedSerialNo

    @property
    def StoreNo(self):
        """门店编号
        :rtype: str
        """
        return self._StoreNo

    @StoreNo.setter
    def StoreNo(self, StoreNo):
        self._StoreNo = StoreNo


    def _deserialize(self, params):
        self._OrderId = params.get("OrderId")
        self._CallbackUrl = params.get("CallbackUrl")
        self._OrderSn = params.get("OrderSn")
        self._RedSerialNo = params.get("RedSerialNo")
        self._StoreNo = params.get("StoreNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRedInvoiceRequest(AbstractModel):
    """CreateRedInvoice请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InvoicePlatformId: 开票平台ID
0 : 高灯
1 : 票易通
        :type InvoicePlatformId: int
        :param _Invoices: 红冲明细
        :type Invoices: list of CreateRedInvoiceItem
        :param _Profile: 接入环境。沙箱环境填 sandbox。
        :type Profile: str
        :param _InvoiceChannel: 开票渠道。0：线上渠道，1：线下渠道。不填默认为线上渠道
        :type InvoiceChannel: int
        """
        self._InvoicePlatformId = None
        self._Invoices = None
        self._Profile = None
        self._InvoiceChannel = None

    @property
    def InvoicePlatformId(self):
        """开票平台ID
0 : 高灯
1 : 票易通
        :rtype: int
        """
        return self._InvoicePlatformId

    @InvoicePlatformId.setter
    def InvoicePlatformId(self, InvoicePlatformId):
        self._InvoicePlatformId = InvoicePlatformId

    @property
    def Invoices(self):
        """红冲明细
        :rtype: list of CreateRedInvoiceItem
        """
        return self._Invoices

    @Invoices.setter
    def Invoices(self, Invoices):
        self._Invoices = Invoices

    @property
    def Profile(self):
        """接入环境。沙箱环境填 sandbox。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def InvoiceChannel(self):
        """开票渠道。0：线上渠道，1：线下渠道。不填默认为线上渠道
        :rtype: int
        """
        return self._InvoiceChannel

    @InvoiceChannel.setter
    def InvoiceChannel(self, InvoiceChannel):
        self._InvoiceChannel = InvoiceChannel


    def _deserialize(self, params):
        self._InvoicePlatformId = params.get("InvoicePlatformId")
        if params.get("Invoices") is not None:
            self._Invoices = []
            for item in params.get("Invoices"):
                obj = CreateRedInvoiceItem()
                obj._deserialize(item)
                self._Invoices.append(obj)
        self._Profile = params.get("Profile")
        self._InvoiceChannel = params.get("InvoiceChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRedInvoiceResponse(AbstractModel):
    """CreateRedInvoice返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 红冲结果
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateRedInvoiceResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """红冲结果
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateRedInvoiceResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = CreateRedInvoiceResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateRedInvoiceResult(AbstractModel):
    """红票结果

    """

    def __init__(self):
        r"""
        :param _Message: 错误消息
        :type Message: str
        :param _Code: 错误码
        :type Code: int
        :param _Data: 红票数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of CreateRedInvoiceResultData
        """
        self._Message = None
        self._Code = None
        self._Data = None

    @property
    def Message(self):
        """错误消息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Code(self):
        """错误码
        :rtype: int
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Data(self):
        """红票数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CreateRedInvoiceResultData
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Message = params.get("Message")
        self._Code = params.get("Code")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = CreateRedInvoiceResultData()
                obj._deserialize(item)
                self._Data.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRedInvoiceResultData(AbstractModel):
    """红票结果数据

    """

    def __init__(self):
        r"""
        :param _Code: 红冲状态码
        :type Code: int
        :param _Message: 红冲状态消息
        :type Message: str
        :param _InvoiceId: 发票ID
        :type InvoiceId: str
        :param _OrderSn: 业务开票号
        :type OrderSn: str
        """
        self._Code = None
        self._Message = None
        self._InvoiceId = None
        self._OrderSn = None

    @property
    def Code(self):
        """红冲状态码
        :rtype: int
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Message(self):
        """红冲状态消息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def InvoiceId(self):
        """发票ID
        :rtype: str
        """
        return self._InvoiceId

    @InvoiceId.setter
    def InvoiceId(self, InvoiceId):
        self._InvoiceId = InvoiceId

    @property
    def OrderSn(self):
        """业务开票号
        :rtype: str
        """
        return self._OrderSn

    @OrderSn.setter
    def OrderSn(self, OrderSn):
        self._OrderSn = OrderSn


    def _deserialize(self, params):
        self._Code = params.get("Code")
        self._Message = params.get("Message")
        self._InvoiceId = params.get("InvoiceId")
        self._OrderSn = params.get("OrderSn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRedInvoiceResultV2(AbstractModel):
    """红票结果V2

    """

    def __init__(self):
        r"""
        :param _InvoiceId: 红票ID
        :type InvoiceId: str
        """
        self._InvoiceId = None

    @property
    def InvoiceId(self):
        """红票ID
        :rtype: str
        """
        return self._InvoiceId

    @InvoiceId.setter
    def InvoiceId(self, InvoiceId):
        self._InvoiceId = InvoiceId


    def _deserialize(self, params):
        self._InvoiceId = params.get("InvoiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRedInvoiceV2Request(AbstractModel):
    """CreateRedInvoiceV2请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InvoicePlatformId: 开票平台ID
0 : 高灯
1 : 票易通
        :type InvoicePlatformId: int
        :param _OrderId: 订单号
        :type OrderId: str
        :param _Profile: 接入环境。沙箱环境填 sandbox。
        :type Profile: str
        :param _InvoiceChannel: 开票渠道。0：线上渠道，1：线下渠道。不填默认为线上渠道
        :type InvoiceChannel: int
        """
        self._InvoicePlatformId = None
        self._OrderId = None
        self._Profile = None
        self._InvoiceChannel = None

    @property
    def InvoicePlatformId(self):
        """开票平台ID
0 : 高灯
1 : 票易通
        :rtype: int
        """
        return self._InvoicePlatformId

    @InvoicePlatformId.setter
    def InvoicePlatformId(self, InvoicePlatformId):
        self._InvoicePlatformId = InvoicePlatformId

    @property
    def OrderId(self):
        """订单号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def Profile(self):
        """接入环境。沙箱环境填 sandbox。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def InvoiceChannel(self):
        """开票渠道。0：线上渠道，1：线下渠道。不填默认为线上渠道
        :rtype: int
        """
        return self._InvoiceChannel

    @InvoiceChannel.setter
    def InvoiceChannel(self, InvoiceChannel):
        self._InvoiceChannel = InvoiceChannel


    def _deserialize(self, params):
        self._InvoicePlatformId = params.get("InvoicePlatformId")
        self._OrderId = params.get("OrderId")
        self._Profile = params.get("Profile")
        self._InvoiceChannel = params.get("InvoiceChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRedInvoiceV2Response(AbstractModel):
    """CreateRedInvoiceV2返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 红冲结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateRedInvoiceResultV2`
        :param _ErrCode: 错误码
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._ErrCode = None
        self._ErrMessage = None
        self._RequestId = None

    @property
    def Result(self):
        """红冲结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateRedInvoiceResultV2`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrCode(self):
        """错误码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = CreateRedInvoiceResultV2()
            self._Result._deserialize(params.get("Result"))
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        self._RequestId = params.get("RequestId")


class CreateSinglePaymentData(AbstractModel):
    """CreateSinglePayment接口返回响应

    """

    def __init__(self):
        r"""
        :param _TradeSerialNo: 平台交易流水号，唯一
        :type TradeSerialNo: str
        :param _AgentId: 代理商ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentId: str
        :param _AgentName: 代理商名称
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentName: str
        """
        self._TradeSerialNo = None
        self._AgentId = None
        self._AgentName = None

    @property
    def TradeSerialNo(self):
        """平台交易流水号，唯一
        :rtype: str
        """
        return self._TradeSerialNo

    @TradeSerialNo.setter
    def TradeSerialNo(self, TradeSerialNo):
        self._TradeSerialNo = TradeSerialNo

    @property
    def AgentId(self):
        """代理商ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def AgentName(self):
        """代理商名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName


    def _deserialize(self, params):
        self._TradeSerialNo = params.get("TradeSerialNo")
        self._AgentId = params.get("AgentId")
        self._AgentName = params.get("AgentName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSinglePaymentRequest(AbstractModel):
    """CreateSinglePayment请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TransferType: 转账类型
1 微信企业付款 
2 支付宝转账 
3 平安银企直连代发转账
        :type TransferType: int
        :param _OrderId: 订单流水号
        :type OrderId: str
        :param _TransferAmount: 转账金额
        :type TransferAmount: int
        :param _AnchorId: 主播ID（与主播业务ID不能同时为空，两者都填取主播ID）
        :type AnchorId: str
        :param _ReqReserved: 请求预留字段，原样透传返回
        :type ReqReserved: str
        :param _Remark: 业务备注
        :type Remark: str
        :param _AnchorName: 主播名称。如果该字段填入，则会对AnchorName和AnchorId/Uid进行校验。
        :type AnchorName: str
        :param _Uid: 主播业务ID（与主播ID不能同时为空，两者都填取主播ID）
        :type Uid: str
        :param _NotifyUrl: 转账结果回调通知URL。若不填，则不进行回调。
        :type NotifyUrl: str
        """
        self._TransferType = None
        self._OrderId = None
        self._TransferAmount = None
        self._AnchorId = None
        self._ReqReserved = None
        self._Remark = None
        self._AnchorName = None
        self._Uid = None
        self._NotifyUrl = None

    @property
    def TransferType(self):
        """转账类型
1 微信企业付款 
2 支付宝转账 
3 平安银企直连代发转账
        :rtype: int
        """
        return self._TransferType

    @TransferType.setter
    def TransferType(self, TransferType):
        self._TransferType = TransferType

    @property
    def OrderId(self):
        """订单流水号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def TransferAmount(self):
        """转账金额
        :rtype: int
        """
        return self._TransferAmount

    @TransferAmount.setter
    def TransferAmount(self, TransferAmount):
        self._TransferAmount = TransferAmount

    @property
    def AnchorId(self):
        """主播ID（与主播业务ID不能同时为空，两者都填取主播ID）
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def ReqReserved(self):
        """请求预留字段，原样透传返回
        :rtype: str
        """
        return self._ReqReserved

    @ReqReserved.setter
    def ReqReserved(self, ReqReserved):
        self._ReqReserved = ReqReserved

    @property
    def Remark(self):
        """业务备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def AnchorName(self):
        """主播名称。如果该字段填入，则会对AnchorName和AnchorId/Uid进行校验。
        :rtype: str
        """
        return self._AnchorName

    @AnchorName.setter
    def AnchorName(self, AnchorName):
        self._AnchorName = AnchorName

    @property
    def Uid(self):
        """主播业务ID（与主播ID不能同时为空，两者都填取主播ID）
        :rtype: str
        """
        return self._Uid

    @Uid.setter
    def Uid(self, Uid):
        self._Uid = Uid

    @property
    def NotifyUrl(self):
        """转账结果回调通知URL。若不填，则不进行回调。
        :rtype: str
        """
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl


    def _deserialize(self, params):
        self._TransferType = params.get("TransferType")
        self._OrderId = params.get("OrderId")
        self._TransferAmount = params.get("TransferAmount")
        self._AnchorId = params.get("AnchorId")
        self._ReqReserved = params.get("ReqReserved")
        self._Remark = params.get("Remark")
        self._AnchorName = params.get("AnchorName")
        self._Uid = params.get("Uid")
        self._NotifyUrl = params.get("NotifyUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSinglePaymentResponse(AbstractModel):
    """CreateSinglePayment返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码
        :type ErrCode: str
        :param _ErrMessage: 响应消息
        :type ErrMessage: str
        :param _Result: 返回数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.CreateSinglePaymentData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """响应消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.CreateSinglePaymentData`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = CreateSinglePaymentData()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class CreateTransferBatchRequest(AbstractModel):
    """CreateTransferBatch请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantId: 商户号。
示例值：129284394
        :type MerchantId: str
        :param _TransferDetails: 转账明细列表。
发起批量转账的明细列表，最多三千笔
        :type TransferDetails: list of TransferDetailRequest
        :param _MerchantAppId: 直连商户appId。
即商户号绑定的appid。
示例值：wxf636efh567hg4356
        :type MerchantAppId: str
        :param _MerchantBatchNo: 商家批次单号。
商户系统内部的商家批次单号，此参数只能由数字、字母组成，商户系统内部唯一，UTF8编码，最多32个字符。
示例值：plfk2020042013
        :type MerchantBatchNo: str
        :param _BatchName: 批次名称。
批量转账的名称。
示例值：2019年1月深圳分部报销单
        :type BatchName: str
        :param _BatchRemark: 转账说明。
UTF8编码，最多32个字符。
示例值：2019年深圳分部报销单
        :type BatchRemark: str
        :param _TotalAmount: 转账总金额。
转账金额，单位为分。
示例值：4000000
        :type TotalAmount: int
        :param _TotalNum: 转账总笔数。
一个转账批次最多允许发起三千笔转账。
示例值：200
        :type TotalNum: int
        :param _Profile: 环境名。
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type Profile: str
        """
        self._MerchantId = None
        self._TransferDetails = None
        self._MerchantAppId = None
        self._MerchantBatchNo = None
        self._BatchName = None
        self._BatchRemark = None
        self._TotalAmount = None
        self._TotalNum = None
        self._Profile = None

    @property
    def MerchantId(self):
        """商户号。
示例值：129284394
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def TransferDetails(self):
        """转账明细列表。
发起批量转账的明细列表，最多三千笔
        :rtype: list of TransferDetailRequest
        """
        return self._TransferDetails

    @TransferDetails.setter
    def TransferDetails(self, TransferDetails):
        self._TransferDetails = TransferDetails

    @property
    def MerchantAppId(self):
        """直连商户appId。
即商户号绑定的appid。
示例值：wxf636efh567hg4356
        :rtype: str
        """
        return self._MerchantAppId

    @MerchantAppId.setter
    def MerchantAppId(self, MerchantAppId):
        self._MerchantAppId = MerchantAppId

    @property
    def MerchantBatchNo(self):
        """商家批次单号。
商户系统内部的商家批次单号，此参数只能由数字、字母组成，商户系统内部唯一，UTF8编码，最多32个字符。
示例值：plfk2020042013
        :rtype: str
        """
        return self._MerchantBatchNo

    @MerchantBatchNo.setter
    def MerchantBatchNo(self, MerchantBatchNo):
        self._MerchantBatchNo = MerchantBatchNo

    @property
    def BatchName(self):
        """批次名称。
批量转账的名称。
示例值：2019年1月深圳分部报销单
        :rtype: str
        """
        return self._BatchName

    @BatchName.setter
    def BatchName(self, BatchName):
        self._BatchName = BatchName

    @property
    def BatchRemark(self):
        """转账说明。
UTF8编码，最多32个字符。
示例值：2019年深圳分部报销单
        :rtype: str
        """
        return self._BatchRemark

    @BatchRemark.setter
    def BatchRemark(self, BatchRemark):
        self._BatchRemark = BatchRemark

    @property
    def TotalAmount(self):
        """转账总金额。
转账金额，单位为分。
示例值：4000000
        :rtype: int
        """
        return self._TotalAmount

    @TotalAmount.setter
    def TotalAmount(self, TotalAmount):
        self._TotalAmount = TotalAmount

    @property
    def TotalNum(self):
        """转账总笔数。
一个转账批次最多允许发起三千笔转账。
示例值：200
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def Profile(self):
        """环境名。
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._MerchantId = params.get("MerchantId")
        if params.get("TransferDetails") is not None:
            self._TransferDetails = []
            for item in params.get("TransferDetails"):
                obj = TransferDetailRequest()
                obj._deserialize(item)
                self._TransferDetails.append(obj)
        self._MerchantAppId = params.get("MerchantAppId")
        self._MerchantBatchNo = params.get("MerchantBatchNo")
        self._BatchName = params.get("BatchName")
        self._BatchRemark = params.get("BatchRemark")
        self._TotalAmount = params.get("TotalAmount")
        self._TotalNum = params.get("TotalNum")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTransferBatchResponse(AbstractModel):
    """CreateTransferBatch返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantBatchNo: 商家批次单号。
商户系统内部的商家批次单号，此参数只能由数字、字母组成，商户系统内部唯一，UTF8编码，最多32个字符。
示例值：plfk2020042013
        :type MerchantBatchNo: str
        :param _BatchId: 微信批次单号。
微信商家转账系统返回的唯一标识。
示例值：1030000071100999991182020050700019480001
        :type BatchId: str
        :param _CreateTime: 批次受理成功时返回，遵循rfc3339标准格式。格式为YYYY-MM-DDTHH:mm:ss.sss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss.sss表示时分秒毫秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35.120+08:00表示北京时间2015年05月20日13点29分35秒。
示例值：2015-05-20T13:29:35.120+08:00
        :type CreateTime: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MerchantBatchNo = None
        self._BatchId = None
        self._CreateTime = None
        self._RequestId = None

    @property
    def MerchantBatchNo(self):
        """商家批次单号。
商户系统内部的商家批次单号，此参数只能由数字、字母组成，商户系统内部唯一，UTF8编码，最多32个字符。
示例值：plfk2020042013
        :rtype: str
        """
        return self._MerchantBatchNo

    @MerchantBatchNo.setter
    def MerchantBatchNo(self, MerchantBatchNo):
        self._MerchantBatchNo = MerchantBatchNo

    @property
    def BatchId(self):
        """微信批次单号。
微信商家转账系统返回的唯一标识。
示例值：1030000071100999991182020050700019480001
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def CreateTime(self):
        """批次受理成功时返回，遵循rfc3339标准格式。格式为YYYY-MM-DDTHH:mm:ss.sss+TIMEZONE，YYYY-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss.sss表示时分秒毫秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35.120+08:00表示北京时间2015年05月20日13点29分35秒。
示例值：2015-05-20T13:29:35.120+08:00
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MerchantBatchNo = params.get("MerchantBatchNo")
        self._BatchId = params.get("BatchId")
        self._CreateTime = params.get("CreateTime")
        self._RequestId = params.get("RequestId")


class DeduceQuotaRequest(AbstractModel):
    """DeduceQuota请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AnchorId: 主播ID
        :type AnchorId: str
        :param _Amount: 提现金额，单位为"分"
        :type Amount: int
        :param _OrderId: 外部业务订单号
        :type OrderId: str
        """
        self._AnchorId = None
        self._Amount = None
        self._OrderId = None

    @property
    def AnchorId(self):
        """主播ID
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def Amount(self):
        """提现金额，单位为"分"
        :rtype: int
        """
        return self._Amount

    @Amount.setter
    def Amount(self, Amount):
        self._Amount = Amount

    @property
    def OrderId(self):
        """外部业务订单号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId


    def _deserialize(self, params):
        self._AnchorId = params.get("AnchorId")
        self._Amount = params.get("Amount")
        self._OrderId = params.get("OrderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeduceQuotaResponse(AbstractModel):
    """DeduceQuota返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。响应成功："SUCCESS"，其他为不成功。
        :type ErrCode: str
        :param _ErrMsg: 响应消息
        :type ErrMsg: str
        :param _Result: 返回响应
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.AssignmentData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMsg = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。响应成功："SUCCESS"，其他为不成功。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMsg(self):
        """响应消息
        :rtype: str
        """
        return self._ErrMsg

    @ErrMsg.setter
    def ErrMsg(self, ErrMsg):
        self._ErrMsg = ErrMsg

    @property
    def Result(self):
        """返回响应
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.AssignmentData`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMsg = params.get("ErrMsg")
        if params.get("Result") is not None:
            self._Result = AssignmentData()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DeleteAgentTaxPaymentInfoRequest(AbstractModel):
    """DeleteAgentTaxPaymentInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchNum: 批次号
        :type BatchNum: int
        :param _Profile: 接入环境。沙箱环境填sandbox
        :type Profile: str
        """
        self._BatchNum = None
        self._Profile = None

    @property
    def BatchNum(self):
        """批次号
        :rtype: int
        """
        return self._BatchNum

    @BatchNum.setter
    def BatchNum(self, BatchNum):
        self._BatchNum = BatchNum

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._BatchNum = params.get("BatchNum")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAgentTaxPaymentInfoResponse(AbstractModel):
    """DeleteAgentTaxPaymentInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAgentTaxPaymentInfosRequest(AbstractModel):
    """DeleteAgentTaxPaymentInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchNum: 批次号
        :type BatchNum: int
        """
        self._BatchNum = None

    @property
    def BatchNum(self):
        """批次号
        :rtype: int
        """
        return self._BatchNum

    @BatchNum.setter
    def BatchNum(self, BatchNum):
        self._BatchNum = BatchNum


    def _deserialize(self, params):
        self._BatchNum = params.get("BatchNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAgentTaxPaymentInfosResponse(AbstractModel):
    """DeleteAgentTaxPaymentInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeChargeDetailRequest(AbstractModel):
    """DescribeChargeDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestType: 请求类型
        :type RequestType: str
        :param _MerchantCode: 商户号
        :type MerchantCode: str
        :param _PayChannel: 支付渠道
        :type PayChannel: str
        :param _PayChannelSubId: 子渠道
        :type PayChannelSubId: int
        :param _OrderId: 原始交易订单号或者流水号
        :type OrderId: str
        :param _BankAccountNumber: 父账户账号，资金汇总账号
        :type BankAccountNumber: str
        :param _AcquiringChannelType: 收单渠道类型
        :type AcquiringChannelType: str
        :param _PlatformShortNumber: 平台短号(银行分配)
        :type PlatformShortNumber: str
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasAppId: 聚鑫分配的支付主MidasAppId
        :type MidasAppId: str
        :param _MidasSignature: 计费签名
        :type MidasSignature: str
        :param _TransSequenceNumber: 交易流水号
        :type TransSequenceNumber: str
        :param _MidasEnvironment: Midas环境参数
        :type MidasEnvironment: str
        :param _ReservedMessage: 保留域
        :type ReservedMessage: str
        """
        self._RequestType = None
        self._MerchantCode = None
        self._PayChannel = None
        self._PayChannelSubId = None
        self._OrderId = None
        self._BankAccountNumber = None
        self._AcquiringChannelType = None
        self._PlatformShortNumber = None
        self._MidasSecretId = None
        self._MidasAppId = None
        self._MidasSignature = None
        self._TransSequenceNumber = None
        self._MidasEnvironment = None
        self._ReservedMessage = None

    @property
    def RequestType(self):
        """请求类型
        :rtype: str
        """
        return self._RequestType

    @RequestType.setter
    def RequestType(self, RequestType):
        self._RequestType = RequestType

    @property
    def MerchantCode(self):
        """商户号
        :rtype: str
        """
        return self._MerchantCode

    @MerchantCode.setter
    def MerchantCode(self, MerchantCode):
        self._MerchantCode = MerchantCode

    @property
    def PayChannel(self):
        """支付渠道
        :rtype: str
        """
        return self._PayChannel

    @PayChannel.setter
    def PayChannel(self, PayChannel):
        self._PayChannel = PayChannel

    @property
    def PayChannelSubId(self):
        """子渠道
        :rtype: int
        """
        return self._PayChannelSubId

    @PayChannelSubId.setter
    def PayChannelSubId(self, PayChannelSubId):
        self._PayChannelSubId = PayChannelSubId

    @property
    def OrderId(self):
        """原始交易订单号或者流水号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def BankAccountNumber(self):
        """父账户账号，资金汇总账号
        :rtype: str
        """
        return self._BankAccountNumber

    @BankAccountNumber.setter
    def BankAccountNumber(self, BankAccountNumber):
        self._BankAccountNumber = BankAccountNumber

    @property
    def AcquiringChannelType(self):
        """收单渠道类型
        :rtype: str
        """
        return self._AcquiringChannelType

    @AcquiringChannelType.setter
    def AcquiringChannelType(self, AcquiringChannelType):
        self._AcquiringChannelType = AcquiringChannelType

    @property
    def PlatformShortNumber(self):
        """平台短号(银行分配)
        :rtype: str
        """
        return self._PlatformShortNumber

    @PlatformShortNumber.setter
    def PlatformShortNumber(self, PlatformShortNumber):
        self._PlatformShortNumber = PlatformShortNumber

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasAppId(self):
        """聚鑫分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def MidasSignature(self):
        """计费签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def TransSequenceNumber(self):
        """交易流水号
        :rtype: str
        """
        return self._TransSequenceNumber

    @TransSequenceNumber.setter
    def TransSequenceNumber(self, TransSequenceNumber):
        self._TransSequenceNumber = TransSequenceNumber

    @property
    def MidasEnvironment(self):
        """Midas环境参数
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment

    @property
    def ReservedMessage(self):
        """保留域
        :rtype: str
        """
        return self._ReservedMessage

    @ReservedMessage.setter
    def ReservedMessage(self, ReservedMessage):
        self._ReservedMessage = ReservedMessage


    def _deserialize(self, params):
        self._RequestType = params.get("RequestType")
        self._MerchantCode = params.get("MerchantCode")
        self._PayChannel = params.get("PayChannel")
        self._PayChannelSubId = params.get("PayChannelSubId")
        self._OrderId = params.get("OrderId")
        self._BankAccountNumber = params.get("BankAccountNumber")
        self._AcquiringChannelType = params.get("AcquiringChannelType")
        self._PlatformShortNumber = params.get("PlatformShortNumber")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasAppId = params.get("MidasAppId")
        self._MidasSignature = params.get("MidasSignature")
        self._TransSequenceNumber = params.get("TransSequenceNumber")
        self._MidasEnvironment = params.get("MidasEnvironment")
        self._ReservedMessage = params.get("ReservedMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeChargeDetailResponse(AbstractModel):
    """DescribeChargeDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OrderStatus: 交易状态 （0：成功，1：失败，2：异常,3:冲正，5：待处理）
        :type OrderStatus: str
        :param _OrderAmount: 交易金额
        :type OrderAmount: str
        :param _CommissionAmount: 佣金费
        :type CommissionAmount: str
        :param _PayMode: 支付方式  0-冻结支付 1-普通支付
        :type PayMode: str
        :param _OrderDate: 交易日期
        :type OrderDate: str
        :param _OrderTime: 交易时间
        :type OrderTime: str
        :param _OrderActualInSubAccountName: 订单实际转入见证子账户的名称
        :type OrderActualInSubAccountName: str
        :param _OrderActualInSubAccountNumber: 订单实际转入见证子账户的帐号
        :type OrderActualInSubAccountNumber: str
        :param _OrderInSubAccountName: 订单实际转入见证子账户的帐号
        :type OrderInSubAccountName: str
        :param _OrderInSubAccountNumber: 订单转入见证子账户的帐号
        :type OrderInSubAccountNumber: str
        :param _FrontSequenceNumber: 银行流水号
        :type FrontSequenceNumber: str
        :param _FailMessage: 当充值失败时，返回交易失败原因
        :type FailMessage: str
        :param _RequestType: 请求类型
        :type RequestType: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OrderStatus = None
        self._OrderAmount = None
        self._CommissionAmount = None
        self._PayMode = None
        self._OrderDate = None
        self._OrderTime = None
        self._OrderActualInSubAccountName = None
        self._OrderActualInSubAccountNumber = None
        self._OrderInSubAccountName = None
        self._OrderInSubAccountNumber = None
        self._FrontSequenceNumber = None
        self._FailMessage = None
        self._RequestType = None
        self._RequestId = None

    @property
    def OrderStatus(self):
        """交易状态 （0：成功，1：失败，2：异常,3:冲正，5：待处理）
        :rtype: str
        """
        return self._OrderStatus

    @OrderStatus.setter
    def OrderStatus(self, OrderStatus):
        self._OrderStatus = OrderStatus

    @property
    def OrderAmount(self):
        """交易金额
        :rtype: str
        """
        return self._OrderAmount

    @OrderAmount.setter
    def OrderAmount(self, OrderAmount):
        self._OrderAmount = OrderAmount

    @property
    def CommissionAmount(self):
        """佣金费
        :rtype: str
        """
        return self._CommissionAmount

    @CommissionAmount.setter
    def CommissionAmount(self, CommissionAmount):
        self._CommissionAmount = CommissionAmount

    @property
    def PayMode(self):
        """支付方式  0-冻结支付 1-普通支付
        :rtype: str
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def OrderDate(self):
        """交易日期
        :rtype: str
        """
        return self._OrderDate

    @OrderDate.setter
    def OrderDate(self, OrderDate):
        self._OrderDate = OrderDate

    @property
    def OrderTime(self):
        """交易时间
        :rtype: str
        """
        return self._OrderTime

    @OrderTime.setter
    def OrderTime(self, OrderTime):
        self._OrderTime = OrderTime

    @property
    def OrderActualInSubAccountName(self):
        """订单实际转入见证子账户的名称
        :rtype: str
        """
        return self._OrderActualInSubAccountName

    @OrderActualInSubAccountName.setter
    def OrderActualInSubAccountName(self, OrderActualInSubAccountName):
        self._OrderActualInSubAccountName = OrderActualInSubAccountName

    @property
    def OrderActualInSubAccountNumber(self):
        """订单实际转入见证子账户的帐号
        :rtype: str
        """
        return self._OrderActualInSubAccountNumber

    @OrderActualInSubAccountNumber.setter
    def OrderActualInSubAccountNumber(self, OrderActualInSubAccountNumber):
        self._OrderActualInSubAccountNumber = OrderActualInSubAccountNumber

    @property
    def OrderInSubAccountName(self):
        """订单实际转入见证子账户的帐号
        :rtype: str
        """
        return self._OrderInSubAccountName

    @OrderInSubAccountName.setter
    def OrderInSubAccountName(self, OrderInSubAccountName):
        self._OrderInSubAccountName = OrderInSubAccountName

    @property
    def OrderInSubAccountNumber(self):
        """订单转入见证子账户的帐号
        :rtype: str
        """
        return self._OrderInSubAccountNumber

    @OrderInSubAccountNumber.setter
    def OrderInSubAccountNumber(self, OrderInSubAccountNumber):
        self._OrderInSubAccountNumber = OrderInSubAccountNumber

    @property
    def FrontSequenceNumber(self):
        """银行流水号
        :rtype: str
        """
        return self._FrontSequenceNumber

    @FrontSequenceNumber.setter
    def FrontSequenceNumber(self, FrontSequenceNumber):
        self._FrontSequenceNumber = FrontSequenceNumber

    @property
    def FailMessage(self):
        """当充值失败时，返回交易失败原因
        :rtype: str
        """
        return self._FailMessage

    @FailMessage.setter
    def FailMessage(self, FailMessage):
        self._FailMessage = FailMessage

    @property
    def RequestType(self):
        """请求类型
        :rtype: str
        """
        return self._RequestType

    @RequestType.setter
    def RequestType(self, RequestType):
        self._RequestType = RequestType

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OrderStatus = params.get("OrderStatus")
        self._OrderAmount = params.get("OrderAmount")
        self._CommissionAmount = params.get("CommissionAmount")
        self._PayMode = params.get("PayMode")
        self._OrderDate = params.get("OrderDate")
        self._OrderTime = params.get("OrderTime")
        self._OrderActualInSubAccountName = params.get("OrderActualInSubAccountName")
        self._OrderActualInSubAccountNumber = params.get("OrderActualInSubAccountNumber")
        self._OrderInSubAccountName = params.get("OrderInSubAccountName")
        self._OrderInSubAccountNumber = params.get("OrderInSubAccountNumber")
        self._FrontSequenceNumber = params.get("FrontSequenceNumber")
        self._FailMessage = params.get("FailMessage")
        self._RequestType = params.get("RequestType")
        self._RequestId = params.get("RequestId")


class DescribeOrderStatusRequest(AbstractModel):
    """DescribeOrderStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestType: 请求类型，此接口固定填：QueryOrderStatusReq
        :type RequestType: str
        :param _MerchantCode: 商户号
        :type MerchantCode: str
        :param _PayChannel: 支付渠道
        :type PayChannel: str
        :param _PayChannelSubId: 子渠道
        :type PayChannelSubId: int
        :param _OrderId: 交易订单号或流水号，提现，充值或会员交易请求时的CnsmrSeqNo值
        :type OrderId: str
        :param _BankAccountNumber: 父账户账号，资金汇总账号
        :type BankAccountNumber: str
        :param _PlatformShortNumber: 平台短号(银行分配)
        :type PlatformShortNumber: str
        :param _QueryType: 功能标志 0：会员间交易 1：提现 2：充值
        :type QueryType: str
        :param _TransSequenceNumber: 银行流水号
        :type TransSequenceNumber: str
        :param _MidasSignature: 计费签名
        :type MidasSignature: str
        :param _MidasAppId: 聚鑫分配的支付主MidasAppId
        :type MidasAppId: str
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasEnvironment: Midas环境参数
        :type MidasEnvironment: str
        :param _ReservedMessage: 保留字段
        :type ReservedMessage: str
        :param _BankSubAccountNumber: 子账户账号 暂未使用
        :type BankSubAccountNumber: str
        :param _TransDate: 交易日期 暂未使用
        :type TransDate: str
        """
        self._RequestType = None
        self._MerchantCode = None
        self._PayChannel = None
        self._PayChannelSubId = None
        self._OrderId = None
        self._BankAccountNumber = None
        self._PlatformShortNumber = None
        self._QueryType = None
        self._TransSequenceNumber = None
        self._MidasSignature = None
        self._MidasAppId = None
        self._MidasSecretId = None
        self._MidasEnvironment = None
        self._ReservedMessage = None
        self._BankSubAccountNumber = None
        self._TransDate = None

    @property
    def RequestType(self):
        """请求类型，此接口固定填：QueryOrderStatusReq
        :rtype: str
        """
        return self._RequestType

    @RequestType.setter
    def RequestType(self, RequestType):
        self._RequestType = RequestType

    @property
    def MerchantCode(self):
        """商户号
        :rtype: str
        """
        return self._MerchantCode

    @MerchantCode.setter
    def MerchantCode(self, MerchantCode):
        self._MerchantCode = MerchantCode

    @property
    def PayChannel(self):
        """支付渠道
        :rtype: str
        """
        return self._PayChannel

    @PayChannel.setter
    def PayChannel(self, PayChannel):
        self._PayChannel = PayChannel

    @property
    def PayChannelSubId(self):
        """子渠道
        :rtype: int
        """
        return self._PayChannelSubId

    @PayChannelSubId.setter
    def PayChannelSubId(self, PayChannelSubId):
        self._PayChannelSubId = PayChannelSubId

    @property
    def OrderId(self):
        """交易订单号或流水号，提现，充值或会员交易请求时的CnsmrSeqNo值
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def BankAccountNumber(self):
        """父账户账号，资金汇总账号
        :rtype: str
        """
        return self._BankAccountNumber

    @BankAccountNumber.setter
    def BankAccountNumber(self, BankAccountNumber):
        self._BankAccountNumber = BankAccountNumber

    @property
    def PlatformShortNumber(self):
        """平台短号(银行分配)
        :rtype: str
        """
        return self._PlatformShortNumber

    @PlatformShortNumber.setter
    def PlatformShortNumber(self, PlatformShortNumber):
        self._PlatformShortNumber = PlatformShortNumber

    @property
    def QueryType(self):
        """功能标志 0：会员间交易 1：提现 2：充值
        :rtype: str
        """
        return self._QueryType

    @QueryType.setter
    def QueryType(self, QueryType):
        self._QueryType = QueryType

    @property
    def TransSequenceNumber(self):
        """银行流水号
        :rtype: str
        """
        return self._TransSequenceNumber

    @TransSequenceNumber.setter
    def TransSequenceNumber(self, TransSequenceNumber):
        self._TransSequenceNumber = TransSequenceNumber

    @property
    def MidasSignature(self):
        """计费签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def MidasAppId(self):
        """聚鑫分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasEnvironment(self):
        """Midas环境参数
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment

    @property
    def ReservedMessage(self):
        """保留字段
        :rtype: str
        """
        return self._ReservedMessage

    @ReservedMessage.setter
    def ReservedMessage(self, ReservedMessage):
        self._ReservedMessage = ReservedMessage

    @property
    def BankSubAccountNumber(self):
        """子账户账号 暂未使用
        :rtype: str
        """
        return self._BankSubAccountNumber

    @BankSubAccountNumber.setter
    def BankSubAccountNumber(self, BankSubAccountNumber):
        self._BankSubAccountNumber = BankSubAccountNumber

    @property
    def TransDate(self):
        """交易日期 暂未使用
        :rtype: str
        """
        return self._TransDate

    @TransDate.setter
    def TransDate(self, TransDate):
        self._TransDate = TransDate


    def _deserialize(self, params):
        self._RequestType = params.get("RequestType")
        self._MerchantCode = params.get("MerchantCode")
        self._PayChannel = params.get("PayChannel")
        self._PayChannelSubId = params.get("PayChannelSubId")
        self._OrderId = params.get("OrderId")
        self._BankAccountNumber = params.get("BankAccountNumber")
        self._PlatformShortNumber = params.get("PlatformShortNumber")
        self._QueryType = params.get("QueryType")
        self._TransSequenceNumber = params.get("TransSequenceNumber")
        self._MidasSignature = params.get("MidasSignature")
        self._MidasAppId = params.get("MidasAppId")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasEnvironment = params.get("MidasEnvironment")
        self._ReservedMessage = params.get("ReservedMessage")
        self._BankSubAccountNumber = params.get("BankSubAccountNumber")
        self._TransDate = params.get("TransDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrderStatusResponse(AbstractModel):
    """DescribeOrderStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OrderStatus: 交易状态 （0：成功，1：失败，2：待确认, 5：待处理，6：处理中）
        :type OrderStatus: str
        :param _OrderAmount: 交易金额
        :type OrderAmount: str
        :param _OrderDate: 交易日期
        :type OrderDate: str
        :param _OrderTime: 交易时间
        :type OrderTime: str
        :param _OutSubAccountNumber: 转出子账户账号
        :type OutSubAccountNumber: str
        :param _InSubAccountNumber: 转入子账户账号
        :type InSubAccountNumber: str
        :param _BookingFlag: 记账标志（1：登记挂账 2：支付 3：提现 4：清分5:下单预支付 6：确认并付款 7：退款 8：支付到平台 N:其他）
        :type BookingFlag: str
        :param _FailMessage: 当交易失败时，返回交易失败原因
        :type FailMessage: str
        :param _RequestType: 请求类型
        :type RequestType: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OrderStatus = None
        self._OrderAmount = None
        self._OrderDate = None
        self._OrderTime = None
        self._OutSubAccountNumber = None
        self._InSubAccountNumber = None
        self._BookingFlag = None
        self._FailMessage = None
        self._RequestType = None
        self._RequestId = None

    @property
    def OrderStatus(self):
        """交易状态 （0：成功，1：失败，2：待确认, 5：待处理，6：处理中）
        :rtype: str
        """
        return self._OrderStatus

    @OrderStatus.setter
    def OrderStatus(self, OrderStatus):
        self._OrderStatus = OrderStatus

    @property
    def OrderAmount(self):
        """交易金额
        :rtype: str
        """
        return self._OrderAmount

    @OrderAmount.setter
    def OrderAmount(self, OrderAmount):
        self._OrderAmount = OrderAmount

    @property
    def OrderDate(self):
        """交易日期
        :rtype: str
        """
        return self._OrderDate

    @OrderDate.setter
    def OrderDate(self, OrderDate):
        self._OrderDate = OrderDate

    @property
    def OrderTime(self):
        """交易时间
        :rtype: str
        """
        return self._OrderTime

    @OrderTime.setter
    def OrderTime(self, OrderTime):
        self._OrderTime = OrderTime

    @property
    def OutSubAccountNumber(self):
        """转出子账户账号
        :rtype: str
        """
        return self._OutSubAccountNumber

    @OutSubAccountNumber.setter
    def OutSubAccountNumber(self, OutSubAccountNumber):
        self._OutSubAccountNumber = OutSubAccountNumber

    @property
    def InSubAccountNumber(self):
        """转入子账户账号
        :rtype: str
        """
        return self._InSubAccountNumber

    @InSubAccountNumber.setter
    def InSubAccountNumber(self, InSubAccountNumber):
        self._InSubAccountNumber = InSubAccountNumber

    @property
    def BookingFlag(self):
        """记账标志（1：登记挂账 2：支付 3：提现 4：清分5:下单预支付 6：确认并付款 7：退款 8：支付到平台 N:其他）
        :rtype: str
        """
        return self._BookingFlag

    @BookingFlag.setter
    def BookingFlag(self, BookingFlag):
        self._BookingFlag = BookingFlag

    @property
    def FailMessage(self):
        """当交易失败时，返回交易失败原因
        :rtype: str
        """
        return self._FailMessage

    @FailMessage.setter
    def FailMessage(self, FailMessage):
        self._FailMessage = FailMessage

    @property
    def RequestType(self):
        """请求类型
        :rtype: str
        """
        return self._RequestType

    @RequestType.setter
    def RequestType(self, RequestType):
        self._RequestType = RequestType

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OrderStatus = params.get("OrderStatus")
        self._OrderAmount = params.get("OrderAmount")
        self._OrderDate = params.get("OrderDate")
        self._OrderTime = params.get("OrderTime")
        self._OutSubAccountNumber = params.get("OutSubAccountNumber")
        self._InSubAccountNumber = params.get("InSubAccountNumber")
        self._BookingFlag = params.get("BookingFlag")
        self._FailMessage = params.get("FailMessage")
        self._RequestType = params.get("RequestType")
        self._RequestId = params.get("RequestId")


class DistributeAccreditQueryRequest(AbstractModel):
    """DistributeAccreditQuery请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 使用门店OpenId
        :type OpenId: str
        :param _OpenKey: 使用门店OpenKey
        :type OpenKey: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._Profile = None

    @property
    def OpenId(self):
        """使用门店OpenId
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """使用门店OpenKey
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeAccreditQueryResponse(AbstractModel):
    """DistributeAccreditQuery返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 查询授权申请结果响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DistributeAccreditQueryResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """查询授权申请结果响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DistributeAccreditQueryResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DistributeAccreditQueryResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DistributeAccreditQueryResult(AbstractModel):
    """分账授权申请查询响应对象

    """

    def __init__(self):
        r"""
        :param _Status: 状态（0-未开通，1-已开通，2-商户主动关闭，3-待审核，4-冻结，5-注销，6-待签合同）
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _ContractUrl: 合同h5地址
注意：此字段可能返回 null，表示取不到有效值。
        :type ContractUrl: str
        :param _Remark: 说明
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        """
        self._Status = None
        self._ContractUrl = None
        self._Remark = None

    @property
    def Status(self):
        """状态（0-未开通，1-已开通，2-商户主动关闭，3-待审核，4-冻结，5-注销，6-待签合同）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ContractUrl(self):
        """合同h5地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ContractUrl

    @ContractUrl.setter
    def ContractUrl(self, ContractUrl):
        self._ContractUrl = ContractUrl

    @property
    def Remark(self):
        """说明
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ContractUrl = params.get("ContractUrl")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeAccreditResult(AbstractModel):
    """授权申请响应对象

    """

    def __init__(self):
        r"""
        :param _ContractUrl: 合同h5地址
注意：此字段可能返回 null，表示取不到有效值。
        :type ContractUrl: str
        :param _MerchantNo: 系统商户号
注意：此字段可能返回 null，表示取不到有效值。
        :type MerchantNo: str
        """
        self._ContractUrl = None
        self._MerchantNo = None

    @property
    def ContractUrl(self):
        """合同h5地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ContractUrl

    @ContractUrl.setter
    def ContractUrl(self, ContractUrl):
        self._ContractUrl = ContractUrl

    @property
    def MerchantNo(self):
        """系统商户号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MerchantNo

    @MerchantNo.setter
    def MerchantNo(self, MerchantNo):
        self._MerchantNo = MerchantNo


    def _deserialize(self, params):
        self._ContractUrl = params.get("ContractUrl")
        self._MerchantNo = params.get("MerchantNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeAccreditTlinxRequest(AbstractModel):
    """DistributeAccreditTlinx请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 使用门店OpenId
        :type OpenId: str
        :param _OpenKey: 使用门店OpenKey
        :type OpenKey: str
        :param _AuthType: 验证方式，传1手机验证(验证码时效60S)传2结算卡验证(时效6小时)，多种方式用逗号隔开
        :type AuthType: str
        :param _Percent: 分账比例（500=5%）不传默认百分之10
        :type Percent: str
        :param _FullName: 营业执照商户全称
        :type FullName: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._AuthType = None
        self._Percent = None
        self._FullName = None
        self._Profile = None

    @property
    def OpenId(self):
        """使用门店OpenId
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """使用门店OpenKey
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def AuthType(self):
        """验证方式，传1手机验证(验证码时效60S)传2结算卡验证(时效6小时)，多种方式用逗号隔开
        :rtype: str
        """
        return self._AuthType

    @AuthType.setter
    def AuthType(self, AuthType):
        self._AuthType = AuthType

    @property
    def Percent(self):
        """分账比例（500=5%）不传默认百分之10
        :rtype: str
        """
        return self._Percent

    @Percent.setter
    def Percent(self, Percent):
        self._Percent = Percent

    @property
    def FullName(self):
        """营业执照商户全称
        :rtype: str
        """
        return self._FullName

    @FullName.setter
    def FullName(self, FullName):
        self._FullName = FullName

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._AuthType = params.get("AuthType")
        self._Percent = params.get("Percent")
        self._FullName = params.get("FullName")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeAccreditTlinxResponse(AbstractModel):
    """DistributeAccreditTlinx返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 授权申请响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DistributeAccreditResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """授权申请响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DistributeAccreditResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DistributeAccreditResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DistributeAddReceiverRequest(AbstractModel):
    """DistributeAddReceiver请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 使用门店OpenId
        :type OpenId: str
        :param _OpenKey: 使用门店OpenKey
        :type OpenKey: str
        :param _MerchantNo: 商户编号
        :type MerchantNo: str
        :param _Remark: 备注
        :type Remark: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._MerchantNo = None
        self._Remark = None
        self._Profile = None

    @property
    def OpenId(self):
        """使用门店OpenId
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """使用门店OpenKey
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def MerchantNo(self):
        """商户编号
        :rtype: str
        """
        return self._MerchantNo

    @MerchantNo.setter
    def MerchantNo(self, MerchantNo):
        self._MerchantNo = MerchantNo

    @property
    def Remark(self):
        """备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._MerchantNo = params.get("MerchantNo")
        self._Remark = params.get("Remark")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeAddReceiverResponse(AbstractModel):
    """DistributeAddReceiver返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 添加分账接收方响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DistributeReceiverResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """添加分账接收方响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DistributeReceiverResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DistributeReceiverResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DistributeApplyRequest(AbstractModel):
    """DistributeApply请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 使用门店OpenId
        :type OpenId: str
        :param _OpenKey: 使用门店OpenKey
        :type OpenKey: str
        :param _OutDistributeNo: 商户分账单号
        :type OutDistributeNo: str
        :param _Details: 分账明细
        :type Details: list of MultiApplyDetail
        :param _DeveloperNo: 商户交易订单号，和OrderNo二者传其一
        :type DeveloperNo: str
        :param _OrderNo: 平台交易订单号，和DeveloperNo二者传其一
        :type OrderNo: str
        :param _Remark: 说明
        :type Remark: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._OutDistributeNo = None
        self._Details = None
        self._DeveloperNo = None
        self._OrderNo = None
        self._Remark = None
        self._Profile = None

    @property
    def OpenId(self):
        """使用门店OpenId
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """使用门店OpenKey
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def OutDistributeNo(self):
        """商户分账单号
        :rtype: str
        """
        return self._OutDistributeNo

    @OutDistributeNo.setter
    def OutDistributeNo(self, OutDistributeNo):
        self._OutDistributeNo = OutDistributeNo

    @property
    def Details(self):
        """分账明细
        :rtype: list of MultiApplyDetail
        """
        return self._Details

    @Details.setter
    def Details(self, Details):
        self._Details = Details

    @property
    def DeveloperNo(self):
        """商户交易订单号，和OrderNo二者传其一
        :rtype: str
        """
        return self._DeveloperNo

    @DeveloperNo.setter
    def DeveloperNo(self, DeveloperNo):
        self._DeveloperNo = DeveloperNo

    @property
    def OrderNo(self):
        """平台交易订单号，和DeveloperNo二者传其一
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo

    @property
    def Remark(self):
        """说明
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._OutDistributeNo = params.get("OutDistributeNo")
        if params.get("Details") is not None:
            self._Details = []
            for item in params.get("Details"):
                obj = MultiApplyDetail()
                obj._deserialize(item)
                self._Details.append(obj)
        self._DeveloperNo = params.get("DeveloperNo")
        self._OrderNo = params.get("OrderNo")
        self._Remark = params.get("Remark")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeApplyResponse(AbstractModel):
    """DistributeApply返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 分账申请响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DistributeMultiApplyResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """分账申请响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DistributeMultiApplyResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DistributeMultiApplyResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DistributeCancelRequest(AbstractModel):
    """DistributeCancel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 使用门店OpenId
        :type OpenId: str
        :param _OpenKey: 使用门店OpenKey
        :type OpenKey: str
        :param _OrderNo: 平台交易订单号
        :type OrderNo: str
        :param _OutDistributeNo: 商户分账单号，type为2时，和DistributeNo二者传其一
        :type OutDistributeNo: str
        :param _DistributeNo: 平台分账单号，type为2时，和OutDistributeNo二者传其一
        :type DistributeNo: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._OrderNo = None
        self._OutDistributeNo = None
        self._DistributeNo = None
        self._Profile = None

    @property
    def OpenId(self):
        """使用门店OpenId
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """使用门店OpenKey
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def OrderNo(self):
        """平台交易订单号
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo

    @property
    def OutDistributeNo(self):
        """商户分账单号，type为2时，和DistributeNo二者传其一
        :rtype: str
        """
        return self._OutDistributeNo

    @OutDistributeNo.setter
    def OutDistributeNo(self, OutDistributeNo):
        self._OutDistributeNo = OutDistributeNo

    @property
    def DistributeNo(self):
        """平台分账单号，type为2时，和OutDistributeNo二者传其一
        :rtype: str
        """
        return self._DistributeNo

    @DistributeNo.setter
    def DistributeNo(self, DistributeNo):
        self._DistributeNo = DistributeNo

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._OrderNo = params.get("OrderNo")
        self._OutDistributeNo = params.get("OutDistributeNo")
        self._DistributeNo = params.get("DistributeNo")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeCancelResponse(AbstractModel):
    """DistributeCancel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 分账撤销响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DistributeCancelResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """分账撤销响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DistributeCancelResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DistributeCancelResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DistributeCancelResult(AbstractModel):
    """分账撤销响应对象

    """

    def __init__(self):
        r"""
        :param _Status: 分账订单状态（0初始1成功2失败3撤销）
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _OrderNo: 平台交易订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OrderNo: str
        :param _OutDistributeNo: 商户分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OutDistributeNo: str
        :param _DistributeNo: 平台分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :type DistributeNo: str
        """
        self._Status = None
        self._OrderNo = None
        self._OutDistributeNo = None
        self._DistributeNo = None

    @property
    def Status(self):
        """分账订单状态（0初始1成功2失败3撤销）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def OrderNo(self):
        """平台交易订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo

    @property
    def OutDistributeNo(self):
        """商户分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OutDistributeNo

    @OutDistributeNo.setter
    def OutDistributeNo(self, OutDistributeNo):
        self._OutDistributeNo = OutDistributeNo

    @property
    def DistributeNo(self):
        """平台分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DistributeNo

    @DistributeNo.setter
    def DistributeNo(self, DistributeNo):
        self._DistributeNo = DistributeNo


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._OrderNo = params.get("OrderNo")
        self._OutDistributeNo = params.get("OutDistributeNo")
        self._DistributeNo = params.get("DistributeNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeMultiApplyResult(AbstractModel):
    """分账申请响应对象

    """

    def __init__(self):
        r"""
        :param _Status: 分账状态（0分账初始 1分账成功 2分账失败）
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _DistributeNo: 平台分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :type DistributeNo: str
        :param _InDate: 入账日期，yyyy-MM-dd格式
注意：此字段可能返回 null，表示取不到有效值。
        :type InDate: str
        :param _Amount: 分账金额
注意：此字段可能返回 null，表示取不到有效值。
        :type Amount: str
        :param _OutDistributeNo: 商户分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OutDistributeNo: str
        :param _OrderNo: 平台支付单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OrderNo: str
        """
        self._Status = None
        self._DistributeNo = None
        self._InDate = None
        self._Amount = None
        self._OutDistributeNo = None
        self._OrderNo = None

    @property
    def Status(self):
        """分账状态（0分账初始 1分账成功 2分账失败）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def DistributeNo(self):
        """平台分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DistributeNo

    @DistributeNo.setter
    def DistributeNo(self, DistributeNo):
        self._DistributeNo = DistributeNo

    @property
    def InDate(self):
        """入账日期，yyyy-MM-dd格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InDate

    @InDate.setter
    def InDate(self, InDate):
        self._InDate = InDate

    @property
    def Amount(self):
        """分账金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Amount

    @Amount.setter
    def Amount(self, Amount):
        self._Amount = Amount

    @property
    def OutDistributeNo(self):
        """商户分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OutDistributeNo

    @OutDistributeNo.setter
    def OutDistributeNo(self, OutDistributeNo):
        self._OutDistributeNo = OutDistributeNo

    @property
    def OrderNo(self):
        """平台支付单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._DistributeNo = params.get("DistributeNo")
        self._InDate = params.get("InDate")
        self._Amount = params.get("Amount")
        self._OutDistributeNo = params.get("OutDistributeNo")
        self._OrderNo = params.get("OrderNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeQueryReceiverRequest(AbstractModel):
    """DistributeQueryReceiver请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 使用门店OpenId
        :type OpenId: str
        :param _OpenKey: 使用门店OpenKey
        :type OpenKey: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._Profile = None

    @property
    def OpenId(self):
        """使用门店OpenId
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """使用门店OpenKey
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeQueryReceiverResponse(AbstractModel):
    """DistributeQueryReceiver返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 查询询已添加分账接收方响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DistributeReceiverResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """查询询已添加分账接收方响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DistributeReceiverResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DistributeReceiverResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DistributeQueryRequest(AbstractModel):
    """DistributeQuery请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 使用门店OpenId
        :type OpenId: str
        :param _OpenKey: 使用门店OpenKey
        :type OpenKey: str
        :param _Type: 查询类型（1-全部，2-单笔）
        :type Type: str
        :param _OutDistributeNo: 商户分账单号，type为2时，和DistributeNo二者传其一
        :type OutDistributeNo: str
        :param _DistributeNo: 平台分账单号，type为2时，和OutDistributeNo二者传其一
        :type DistributeNo: str
        :param _OrderNo: 平台交易订单号
        :type OrderNo: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._Type = None
        self._OutDistributeNo = None
        self._DistributeNo = None
        self._OrderNo = None
        self._Profile = None

    @property
    def OpenId(self):
        """使用门店OpenId
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """使用门店OpenKey
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def Type(self):
        """查询类型（1-全部，2-单笔）
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def OutDistributeNo(self):
        """商户分账单号，type为2时，和DistributeNo二者传其一
        :rtype: str
        """
        return self._OutDistributeNo

    @OutDistributeNo.setter
    def OutDistributeNo(self, OutDistributeNo):
        self._OutDistributeNo = OutDistributeNo

    @property
    def DistributeNo(self):
        """平台分账单号，type为2时，和OutDistributeNo二者传其一
        :rtype: str
        """
        return self._DistributeNo

    @DistributeNo.setter
    def DistributeNo(self, DistributeNo):
        self._DistributeNo = DistributeNo

    @property
    def OrderNo(self):
        """平台交易订单号
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._Type = params.get("Type")
        self._OutDistributeNo = params.get("OutDistributeNo")
        self._DistributeNo = params.get("DistributeNo")
        self._OrderNo = params.get("OrderNo")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeQueryResponse(AbstractModel):
    """DistributeQuery返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 分账结果响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DistributeQueryResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """分账结果响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DistributeQueryResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DistributeQueryResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DistributeQueryResult(AbstractModel):
    """分账结果响应对象

    """

    def __init__(self):
        r"""
        :param _Orders: 分账订单列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Orders: list of MultiApplyOrder
        """
        self._Orders = None

    @property
    def Orders(self):
        """分账订单列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of MultiApplyOrder
        """
        return self._Orders

    @Orders.setter
    def Orders(self, Orders):
        self._Orders = Orders


    def _deserialize(self, params):
        if params.get("Orders") is not None:
            self._Orders = []
            for item in params.get("Orders"):
                obj = MultiApplyOrder()
                obj._deserialize(item)
                self._Orders.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeReceiverResult(AbstractModel):
    """分账接收方响应对象

    """

    def __init__(self):
        r"""
        :param _MerchantNo: 商户编号
注意：此字段可能返回 null，表示取不到有效值。
        :type MerchantNo: str
        """
        self._MerchantNo = None

    @property
    def MerchantNo(self):
        """商户编号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MerchantNo

    @MerchantNo.setter
    def MerchantNo(self, MerchantNo):
        self._MerchantNo = MerchantNo


    def _deserialize(self, params):
        self._MerchantNo = params.get("MerchantNo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeRemoveReceiverRequest(AbstractModel):
    """DistributeRemoveReceiver请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 使用门店OpenId
        :type OpenId: str
        :param _OpenKey: 使用门店OpenKey
        :type OpenKey: str
        :param _MerchantNo: 商户编号
        :type MerchantNo: str
        :param _Remark: 备注
        :type Remark: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._MerchantNo = None
        self._Remark = None
        self._Profile = None

    @property
    def OpenId(self):
        """使用门店OpenId
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """使用门店OpenKey
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def MerchantNo(self):
        """商户编号
        :rtype: str
        """
        return self._MerchantNo

    @MerchantNo.setter
    def MerchantNo(self, MerchantNo):
        self._MerchantNo = MerchantNo

    @property
    def Remark(self):
        """备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._MerchantNo = params.get("MerchantNo")
        self._Remark = params.get("Remark")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DistributeRemoveReceiverResponse(AbstractModel):
    """DistributeRemoveReceiver返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 解除分账接收方响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DistributeReceiverResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """解除分账接收方响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DistributeReceiverResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DistributeReceiverResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DownloadBillRequest(AbstractModel):
    """DownloadBill请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StateDate: 请求下载对账单日期
        :type StateDate: str
        :param _MidasAppId: 聚鑫分配的MidasAppId
        :type MidasAppId: str
        :param _MidasSecretId: 聚鑫分配的SecretId
        :type MidasSecretId: str
        :param _MidasSignature: 使用聚鑫安全密钥计算的签名
        :type MidasSignature: str
        :param _MidasEnvironment: 环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :type MidasEnvironment: str
        """
        self._StateDate = None
        self._MidasAppId = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._MidasEnvironment = None

    @property
    def StateDate(self):
        """请求下载对账单日期
        :rtype: str
        """
        return self._StateDate

    @StateDate.setter
    def StateDate(self, StateDate):
        self._StateDate = StateDate

    @property
    def MidasAppId(self):
        """聚鑫分配的MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def MidasSecretId(self):
        """聚鑫分配的SecretId
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """使用聚鑫安全密钥计算的签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def MidasEnvironment(self):
        """环境名:
release: 现网环境
sandbox: 沙箱环境
development: 开发环境
缺省: release
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment


    def _deserialize(self, params):
        self._StateDate = params.get("StateDate")
        self._MidasAppId = params.get("MidasAppId")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        self._MidasEnvironment = params.get("MidasEnvironment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadBillResponse(AbstractModel):
    """DownloadBill返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FileName: 账单文件名
        :type FileName: str
        :param _FileMD5: 账单文件的MD5值
        :type FileMD5: str
        :param _DownloadUrl: 账单文件的真实下载地址
        :type DownloadUrl: str
        :param _StateType: 账单类型
TRADE，对账单
FUND，资金账单
注意：此字段可能返回 null，表示取不到有效值。
        :type StateType: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FileName = None
        self._FileMD5 = None
        self._DownloadUrl = None
        self._StateType = None
        self._RequestId = None

    @property
    def FileName(self):
        """账单文件名
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FileMD5(self):
        """账单文件的MD5值
        :rtype: str
        """
        return self._FileMD5

    @FileMD5.setter
    def FileMD5(self, FileMD5):
        self._FileMD5 = FileMD5

    @property
    def DownloadUrl(self):
        """账单文件的真实下载地址
        :rtype: str
        """
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def StateType(self):
        """账单类型
TRADE，对账单
FUND，资金账单
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StateType

    @StateType.setter
    def StateType(self, StateType):
        self._StateType = StateType

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FileName = params.get("FileName")
        self._FileMD5 = params.get("FileMD5")
        self._DownloadUrl = params.get("DownloadUrl")
        self._StateType = params.get("StateType")
        self._RequestId = params.get("RequestId")


class DownloadFileResult(AbstractModel):
    """上传下载响应对象

    """

    def __init__(self):
        r"""
        :param _Content: 文件内容（base64加密的二进制内容）
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: str
        :param _Storage: 存储区域（0私密区，1公共区），请严格按文件要求，上传到不同的区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Storage: str
        """
        self._Content = None
        self._Storage = None

    @property
    def Content(self):
        """文件内容（base64加密的二进制内容）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Storage(self):
        """存储区域（0私密区，1公共区），请严格按文件要求，上传到不同的区域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Content = params.get("Content")
        self._Storage = params.get("Storage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadOrgFileRequest(AbstractModel):
    """DownloadOrgFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 收单系统分配的开放ID
        :type OpenId: str
        :param _OpenKey: 收单系统分配的密钥
        :type OpenKey: str
        :param _Storage: 存储区域（0私密区，1公共区），请严格按文件要求，上传到不同的区域
        :type Storage: str
        :param _FilePath: 文件路径
        :type FilePath: str
        :param _Profile: 沙箱环境填sandbox，正式环境不填
        :type Profile: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._Storage = None
        self._FilePath = None
        self._Profile = None

    @property
    def OpenId(self):
        """收单系统分配的开放ID
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """收单系统分配的密钥
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def Storage(self):
        """存储区域（0私密区，1公共区），请严格按文件要求，上传到不同的区域
        :rtype: str
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def FilePath(self):
        """文件路径
        :rtype: str
        """
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def Profile(self):
        """沙箱环境填sandbox，正式环境不填
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._Storage = params.get("Storage")
        self._FilePath = params.get("FilePath")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadOrgFileResponse(AbstractModel):
    """DownloadOrgFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _Result: 下载机构文件响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.DownloadFileResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrMessage = None
        self._ErrCode = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Result(self):
        """下载机构文件响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.DownloadFileResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrMessage = params.get("ErrMessage")
        self._ErrCode = params.get("ErrCode")
        if params.get("Result") is not None:
            self._Result = DownloadFileResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class DownloadReconciliationUrlRequest(AbstractModel):
    """DownloadReconciliationUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MainAppId: 平台应用ID
        :type MainAppId: str
        :param _AppCode: 平台代码
        :type AppCode: str
        :param _BillDate: 账单日期，yyyy-MM-dd
        :type BillDate: str
        :param _SubAppId: 商户或者代理商ID
        :type SubAppId: str
        """
        self._MainAppId = None
        self._AppCode = None
        self._BillDate = None
        self._SubAppId = None

    @property
    def MainAppId(self):
        """平台应用ID
        :rtype: str
        """
        return self._MainAppId

    @MainAppId.setter
    def MainAppId(self, MainAppId):
        self._MainAppId = MainAppId

    @property
    def AppCode(self):
        """平台代码
        :rtype: str
        """
        return self._AppCode

    @AppCode.setter
    def AppCode(self, AppCode):
        self._AppCode = AppCode

    @property
    def BillDate(self):
        """账单日期，yyyy-MM-dd
        :rtype: str
        """
        return self._BillDate

    @BillDate.setter
    def BillDate(self, BillDate):
        self._BillDate = BillDate

    @property
    def SubAppId(self):
        """商户或者代理商ID
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._MainAppId = params.get("MainAppId")
        self._AppCode = params.get("AppCode")
        self._BillDate = params.get("BillDate")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadReconciliationUrlResponse(AbstractModel):
    """DownloadReconciliationUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 下载地址
        :type DownloadUrl: str
        :param _HashType: hash类型
注意：此字段可能返回 null，表示取不到有效值。
        :type HashType: str
        :param _HashValue: hash值
        :type HashValue: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._HashType = None
        self._HashValue = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        """下载地址
        :rtype: str
        """
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def HashType(self):
        """hash类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._HashType

    @HashType.setter
    def HashType(self, HashType):
        self._HashType = HashType

    @property
    def HashValue(self):
        """hash值
        :rtype: str
        """
        return self._HashValue

    @HashValue.setter
    def HashValue(self, HashValue):
        self._HashValue = HashValue

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._HashType = params.get("HashType")
        self._HashValue = params.get("HashValue")
        self._RequestId = params.get("RequestId")


class ExecuteMemberTransactionRequest(AbstractModel):
    """ExecuteMemberTransaction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestType: 请求类型此接口固定填：MemberTransactionReq
        :type RequestType: str
        :param _MerchantCode: 银行注册商户号
        :type MerchantCode: str
        :param _PayChannel: 支付渠道
        :type PayChannel: str
        :param _PayChannelSubId: 子渠道
        :type PayChannelSubId: int
        :param _OutTransNetMemberCode: 转出交易网会员代码
        :type OutTransNetMemberCode: str
        :param _OutSubAccountName: 转出见证子账户的户名
        :type OutSubAccountName: str
        :param _InSubAccountName: 转入见证子账户的户名
        :type InSubAccountName: str
        :param _OutSubAccountNumber: 转出子账户账号
        :type OutSubAccountNumber: str
        :param _InSubAccountNumber: 转入子账户账号
        :type InSubAccountNumber: str
        :param _BankAccountNumber: 父账户账号，资金汇总账号
        :type BankAccountNumber: str
        :param _CurrencyUnit: 货币单位 单位，1：元，2：角，3：分
        :type CurrencyUnit: str
        :param _CurrencyType: 币种
        :type CurrencyType: str
        :param _CurrencyAmount: 交易金额
        :type CurrencyAmount: str
        :param _OrderId: 订单号
        :type OrderId: str
        :param _MidasAppId: 聚鑫分配的支付主MidasAppId
        :type MidasAppId: str
        :param _MidasSecretId: 聚鑫分配的安全ID
        :type MidasSecretId: str
        :param _MidasSignature: 计费签名
        :type MidasSignature: str
        :param _TransSequenceNumber: 交易流水号 
生成方式：用户短号+日期（6位）+ 随机编号（10位）例如：F088722005120904930798
短号：F08872  日期： 200512   随机编号：0904930798
        :type TransSequenceNumber: str
        :param _InTransNetMemberCode: 转入交易网会员代码
        :type InTransNetMemberCode: str
        :param _MidasEnvironment: Midas环境标识 release 现网环境 sandbox 沙箱环境
development 开发环境
        :type MidasEnvironment: str
        :param _PlatformShortNumber: 平台短号(银行分配)
        :type PlatformShortNumber: str
        :param _TransType: 1：下单预支付 
2：确认并付款
3：退款
6：直接支付T+1
9：直接支付T+0
        :type TransType: str
        :param _TransFee: 交易手续费
        :type TransFee: str
        :param _ReservedMessage: 保留域
        :type ReservedMessage: str
        """
        self._RequestType = None
        self._MerchantCode = None
        self._PayChannel = None
        self._PayChannelSubId = None
        self._OutTransNetMemberCode = None
        self._OutSubAccountName = None
        self._InSubAccountName = None
        self._OutSubAccountNumber = None
        self._InSubAccountNumber = None
        self._BankAccountNumber = None
        self._CurrencyUnit = None
        self._CurrencyType = None
        self._CurrencyAmount = None
        self._OrderId = None
        self._MidasAppId = None
        self._MidasSecretId = None
        self._MidasSignature = None
        self._TransSequenceNumber = None
        self._InTransNetMemberCode = None
        self._MidasEnvironment = None
        self._PlatformShortNumber = None
        self._TransType = None
        self._TransFee = None
        self._ReservedMessage = None

    @property
    def RequestType(self):
        """请求类型此接口固定填：MemberTransactionReq
        :rtype: str
        """
        return self._RequestType

    @RequestType.setter
    def RequestType(self, RequestType):
        self._RequestType = RequestType

    @property
    def MerchantCode(self):
        """银行注册商户号
        :rtype: str
        """
        return self._MerchantCode

    @MerchantCode.setter
    def MerchantCode(self, MerchantCode):
        self._MerchantCode = MerchantCode

    @property
    def PayChannel(self):
        """支付渠道
        :rtype: str
        """
        return self._PayChannel

    @PayChannel.setter
    def PayChannel(self, PayChannel):
        self._PayChannel = PayChannel

    @property
    def PayChannelSubId(self):
        """子渠道
        :rtype: int
        """
        return self._PayChannelSubId

    @PayChannelSubId.setter
    def PayChannelSubId(self, PayChannelSubId):
        self._PayChannelSubId = PayChannelSubId

    @property
    def OutTransNetMemberCode(self):
        """转出交易网会员代码
        :rtype: str
        """
        return self._OutTransNetMemberCode

    @OutTransNetMemberCode.setter
    def OutTransNetMemberCode(self, OutTransNetMemberCode):
        self._OutTransNetMemberCode = OutTransNetMemberCode

    @property
    def OutSubAccountName(self):
        """转出见证子账户的户名
        :rtype: str
        """
        return self._OutSubAccountName

    @OutSubAccountName.setter
    def OutSubAccountName(self, OutSubAccountName):
        self._OutSubAccountName = OutSubAccountName

    @property
    def InSubAccountName(self):
        """转入见证子账户的户名
        :rtype: str
        """
        return self._InSubAccountName

    @InSubAccountName.setter
    def InSubAccountName(self, InSubAccountName):
        self._InSubAccountName = InSubAccountName

    @property
    def OutSubAccountNumber(self):
        """转出子账户账号
        :rtype: str
        """
        return self._OutSubAccountNumber

    @OutSubAccountNumber.setter
    def OutSubAccountNumber(self, OutSubAccountNumber):
        self._OutSubAccountNumber = OutSubAccountNumber

    @property
    def InSubAccountNumber(self):
        """转入子账户账号
        :rtype: str
        """
        return self._InSubAccountNumber

    @InSubAccountNumber.setter
    def InSubAccountNumber(self, InSubAccountNumber):
        self._InSubAccountNumber = InSubAccountNumber

    @property
    def BankAccountNumber(self):
        """父账户账号，资金汇总账号
        :rtype: str
        """
        return self._BankAccountNumber

    @BankAccountNumber.setter
    def BankAccountNumber(self, BankAccountNumber):
        self._BankAccountNumber = BankAccountNumber

    @property
    def CurrencyUnit(self):
        """货币单位 单位，1：元，2：角，3：分
        :rtype: str
        """
        return self._CurrencyUnit

    @CurrencyUnit.setter
    def CurrencyUnit(self, CurrencyUnit):
        self._CurrencyUnit = CurrencyUnit

    @property
    def CurrencyType(self):
        """币种
        :rtype: str
        """
        return self._CurrencyType

    @CurrencyType.setter
    def CurrencyType(self, CurrencyType):
        self._CurrencyType = CurrencyType

    @property
    def CurrencyAmount(self):
        """交易金额
        :rtype: str
        """
        return self._CurrencyAmount

    @CurrencyAmount.setter
    def CurrencyAmount(self, CurrencyAmount):
        self._CurrencyAmount = CurrencyAmount

    @property
    def OrderId(self):
        """订单号
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def MidasAppId(self):
        """聚鑫分配的支付主MidasAppId
        :rtype: str
        """
        return self._MidasAppId

    @MidasAppId.setter
    def MidasAppId(self, MidasAppId):
        self._MidasAppId = MidasAppId

    @property
    def MidasSecretId(self):
        """聚鑫分配的安全ID
        :rtype: str
        """
        return self._MidasSecretId

    @MidasSecretId.setter
    def MidasSecretId(self, MidasSecretId):
        self._MidasSecretId = MidasSecretId

    @property
    def MidasSignature(self):
        """计费签名
        :rtype: str
        """
        return self._MidasSignature

    @MidasSignature.setter
    def MidasSignature(self, MidasSignature):
        self._MidasSignature = MidasSignature

    @property
    def TransSequenceNumber(self):
        """交易流水号 
生成方式：用户短号+日期（6位）+ 随机编号（10位）例如：F088722005120904930798
短号：F08872  日期： 200512   随机编号：0904930798
        :rtype: str
        """
        return self._TransSequenceNumber

    @TransSequenceNumber.setter
    def TransSequenceNumber(self, TransSequenceNumber):
        self._TransSequenceNumber = TransSequenceNumber

    @property
    def InTransNetMemberCode(self):
        """转入交易网会员代码
        :rtype: str
        """
        return self._InTransNetMemberCode

    @InTransNetMemberCode.setter
    def InTransNetMemberCode(self, InTransNetMemberCode):
        self._InTransNetMemberCode = InTransNetMemberCode

    @property
    def MidasEnvironment(self):
        """Midas环境标识 release 现网环境 sandbox 沙箱环境
development 开发环境
        :rtype: str
        """
        return self._MidasEnvironment

    @MidasEnvironment.setter
    def MidasEnvironment(self, MidasEnvironment):
        self._MidasEnvironment = MidasEnvironment

    @property
    def PlatformShortNumber(self):
        """平台短号(银行分配)
        :rtype: str
        """
        return self._PlatformShortNumber

    @PlatformShortNumber.setter
    def PlatformShortNumber(self, PlatformShortNumber):
        self._PlatformShortNumber = PlatformShortNumber

    @property
    def TransType(self):
        """1：下单预支付 
2：确认并付款
3：退款
6：直接支付T+1
9：直接支付T+0
        :rtype: str
        """
        return self._TransType

    @TransType.setter
    def TransType(self, TransType):
        self._TransType = TransType

    @property
    def TransFee(self):
        """交易手续费
        :rtype: str
        """
        return self._TransFee

    @TransFee.setter
    def TransFee(self, TransFee):
        self._TransFee = TransFee

    @property
    def ReservedMessage(self):
        """保留域
        :rtype: str
        """
        return self._ReservedMessage

    @ReservedMessage.setter
    def ReservedMessage(self, ReservedMessage):
        self._ReservedMessage = ReservedMessage


    def _deserialize(self, params):
        self._RequestType = params.get("RequestType")
        self._MerchantCode = params.get("MerchantCode")
        self._PayChannel = params.get("PayChannel")
        self._PayChannelSubId = params.get("PayChannelSubId")
        self._OutTransNetMemberCode = params.get("OutTransNetMemberCode")
        self._OutSubAccountName = params.get("OutSubAccountName")
        self._InSubAccountName = params.get("InSubAccountName")
        self._OutSubAccountNumber = params.get("OutSubAccountNumber")
        self._InSubAccountNumber = params.get("InSubAccountNumber")
        self._BankAccountNumber = params.get("BankAccountNumber")
        self._CurrencyUnit = params.get("CurrencyUnit")
        self._CurrencyType = params.get("CurrencyType")
        self._CurrencyAmount = params.get("CurrencyAmount")
        self._OrderId = params.get("OrderId")
        self._MidasAppId = params.get("MidasAppId")
        self._MidasSecretId = params.get("MidasSecretId")
        self._MidasSignature = params.get("MidasSignature")
        self._TransSequenceNumber = params.get("TransSequenceNumber")
        self._InTransNetMemberCode = params.get("InTransNetMemberCode")
        self._MidasEnvironment = params.get("MidasEnvironment")
        self._PlatformShortNumber = params.get("PlatformShortNumber")
        self._TransType = params.get("TransType")
        self._TransFee = params.get("TransFee")
        self._ReservedMessage = params.get("ReservedMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteMemberTransactionResponse(AbstractModel):
    """ExecuteMemberTransaction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestType: 请求类型
        :type RequestType: str
        :param _FrontSequenceNumber: 银行流水号
        :type FrontSequenceNumber: str
        :param _ReservedMessage: 保留域
注意：此字段可能返回 null，表示取不到有效值。
        :type ReservedMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestType = None
        self._FrontSequenceNumber = None
        self._ReservedMessage = None
        self._RequestId = None

    @property
    def RequestType(self):
        """请求类型
        :rtype: str
        """
        return self._RequestType

    @RequestType.setter
    def RequestType(self, RequestType):
        self._RequestType = RequestType

    @property
    def FrontSequenceNumber(self):
        """银行流水号
        :rtype: str
        """
        return self._FrontSequenceNumber

    @FrontSequenceNumber.setter
    def FrontSequenceNumber(self, FrontSequenceNumber):
        self._FrontSequenceNumber = FrontSequenceNumber

    @property
    def ReservedMessage(self):
        """保留域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReservedMessage

    @ReservedMessage.setter
    def ReservedMessage(self, ReservedMessage):
        self._ReservedMessage = ReservedMessage

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestType = params.get("RequestType")
        self._FrontSequenceNumber = params.get("FrontSequenceNumber")
        self._ReservedMessage = params.get("ReservedMessage")
        self._RequestId = params.get("RequestId")


class ExternalContractUserInfo(AbstractModel):
    """第三方渠道用户信息

    """

    def __init__(self):
        r"""
        :param _ExternalUserType: 第三方用户类型，例如:  WX_OPENID, WX_SUB_OPENID,WX_PAYER_OPENID
        :type ExternalUserType: str
        :param _ExternalUserId: 第三方用户ID
        :type ExternalUserId: str
        """
        self._ExternalUserType = None
        self._ExternalUserId = None

    @property
    def ExternalUserType(self):
        """第三方用户类型，例如:  WX_OPENID, WX_SUB_OPENID,WX_PAYER_OPENID
        :rtype: str
        """
        return self._ExternalUserType

    @ExternalUserType.setter
    def ExternalUserType(self, ExternalUserType):
        self._ExternalUserType = ExternalUserType

    @property
    def ExternalUserId(self):
        """第三方用户ID
        :rtype: str
        """
        return self._ExternalUserId

    @ExternalUserId.setter
    def ExternalUserId(self, ExternalUserId):
        self._ExternalUserId = ExternalUserId


    def _deserialize(self, params):
        self._ExternalUserType = params.get("ExternalUserType")
        self._ExternalUserId = params.get("ExternalUserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExternalReturnContractInfo(AbstractModel):
    """第三方渠道合约信息

    """

    def __init__(self):
        r"""
        :param _ExternalReturnAgreementId: 第三方渠道协议id
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnAgreementId: str
        :param _ExternalReturnContractEffectiveTimestamp: 第三方渠道协议生效时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnContractEffectiveTimestamp: str
        :param _ExternalReturnContractTerminationTimestamp: 第三方渠道协议解约时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnContractTerminationTimestamp: str
        :param _ExternalReturnContractStatus: 平台合约状态
协议状态，枚举值：
CONTRACT_STATUS_SIGNED：已签约
CONTRACT_STATUS_TERMINATED：未签约
CONTRACT_STATUS_PENDING：签约进行中
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnContractStatus: str
        :param _ExternalReturnRequestId: 第三方渠道请求序列号
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnRequestId: str
        :param _ExternalReturnContractSignedTimestamp: 第三方渠道协议签署时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnContractSignedTimestamp: str
        :param _ExternalReturnContractExpiredTimestamp: 第三方渠道协议到期时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnContractExpiredTimestamp: str
        :param _ExternalReturnContractData: 第三方渠道返回的合约数据
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnContractData: str
        :param _ExternalReturnContractTerminationRemark: 第三方渠道解约备注
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnContractTerminationRemark: str
        :param _ExternalReturnContractTerminationMode: 第三方渠道协议解约方式
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalReturnContractTerminationMode: str
        """
        self._ExternalReturnAgreementId = None
        self._ExternalReturnContractEffectiveTimestamp = None
        self._ExternalReturnContractTerminationTimestamp = None
        self._ExternalReturnContractStatus = None
        self._ExternalReturnRequestId = None
        self._ExternalReturnContractSignedTimestamp = None
        self._ExternalReturnContractExpiredTimestamp = None
        self._ExternalReturnContractData = None
        self._ExternalReturnContractTerminationRemark = None
        self._ExternalReturnContractTerminationMode = None

    @property
    def ExternalReturnAgreementId(self):
        """第三方渠道协议id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnAgreementId

    @ExternalReturnAgreementId.setter
    def ExternalReturnAgreementId(self, ExternalReturnAgreementId):
        self._ExternalReturnAgreementId = ExternalReturnAgreementId

    @property
    def ExternalReturnContractEffectiveTimestamp(self):
        """第三方渠道协议生效时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnContractEffectiveTimestamp

    @ExternalReturnContractEffectiveTimestamp.setter
    def ExternalReturnContractEffectiveTimestamp(self, ExternalReturnContractEffectiveTimestamp):
        self._ExternalReturnContractEffectiveTimestamp = ExternalReturnContractEffectiveTimestamp

    @property
    def ExternalReturnContractTerminationTimestamp(self):
        """第三方渠道协议解约时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnContractTerminationTimestamp

    @ExternalReturnContractTerminationTimestamp.setter
    def ExternalReturnContractTerminationTimestamp(self, ExternalReturnContractTerminationTimestamp):
        self._ExternalReturnContractTerminationTimestamp = ExternalReturnContractTerminationTimestamp

    @property
    def ExternalReturnContractStatus(self):
        """平台合约状态
协议状态，枚举值：
CONTRACT_STATUS_SIGNED：已签约
CONTRACT_STATUS_TERMINATED：未签约
CONTRACT_STATUS_PENDING：签约进行中
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnContractStatus

    @ExternalReturnContractStatus.setter
    def ExternalReturnContractStatus(self, ExternalReturnContractStatus):
        self._ExternalReturnContractStatus = ExternalReturnContractStatus

    @property
    def ExternalReturnRequestId(self):
        """第三方渠道请求序列号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnRequestId

    @ExternalReturnRequestId.setter
    def ExternalReturnRequestId(self, ExternalReturnRequestId):
        self._ExternalReturnRequestId = ExternalReturnRequestId

    @property
    def ExternalReturnContractSignedTimestamp(self):
        """第三方渠道协议签署时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnContractSignedTimestamp

    @ExternalReturnContractSignedTimestamp.setter
    def ExternalReturnContractSignedTimestamp(self, ExternalReturnContractSignedTimestamp):
        self._ExternalReturnContractSignedTimestamp = ExternalReturnContractSignedTimestamp

    @property
    def ExternalReturnContractExpiredTimestamp(self):
        """第三方渠道协议到期时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnContractExpiredTimestamp

    @ExternalReturnContractExpiredTimestamp.setter
    def ExternalReturnContractExpiredTimestamp(self, ExternalReturnContractExpiredTimestamp):
        self._ExternalReturnContractExpiredTimestamp = ExternalReturnContractExpiredTimestamp

    @property
    def ExternalReturnContractData(self):
        """第三方渠道返回的合约数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnContractData

    @ExternalReturnContractData.setter
    def ExternalReturnContractData(self, ExternalReturnContractData):
        self._ExternalReturnContractData = ExternalReturnContractData

    @property
    def ExternalReturnContractTerminationRemark(self):
        """第三方渠道解约备注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnContractTerminationRemark

    @ExternalReturnContractTerminationRemark.setter
    def ExternalReturnContractTerminationRemark(self, ExternalReturnContractTerminationRemark):
        self._ExternalReturnContractTerminationRemark = ExternalReturnContractTerminationRemark

    @property
    def ExternalReturnContractTerminationMode(self):
        """第三方渠道协议解约方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalReturnContractTerminationMode

    @ExternalReturnContractTerminationMode.setter
    def ExternalReturnContractTerminationMode(self, ExternalReturnContractTerminationMode):
        self._ExternalReturnContractTerminationMode = ExternalReturnContractTerminationMode


    def _deserialize(self, params):
        self._ExternalReturnAgreementId = params.get("ExternalReturnAgreementId")
        self._ExternalReturnContractEffectiveTimestamp = params.get("ExternalReturnContractEffectiveTimestamp")
        self._ExternalReturnContractTerminationTimestamp = params.get("ExternalReturnContractTerminationTimestamp")
        self._ExternalReturnContractStatus = params.get("ExternalReturnContractStatus")
        self._ExternalReturnRequestId = params.get("ExternalReturnRequestId")
        self._ExternalReturnContractSignedTimestamp = params.get("ExternalReturnContractSignedTimestamp")
        self._ExternalReturnContractExpiredTimestamp = params.get("ExternalReturnContractExpiredTimestamp")
        self._ExternalReturnContractData = params.get("ExternalReturnContractData")
        self._ExternalReturnContractTerminationRemark = params.get("ExternalReturnContractTerminationRemark")
        self._ExternalReturnContractTerminationMode = params.get("ExternalReturnContractTerminationMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FeeRangInfo(AbstractModel):
    """分段计费区间信息

    """

    def __init__(self):
        r"""
        :param _CardType: 卡类型，银联产品使用 
DEBIT：借记卡 
CREDIT：贷记卡
        :type CardType: str
        :param _RangeStartValue: 区间起始金额，单位（分）
        :type RangeStartValue: int
        :param _RangeEndValue: 区间结束金额，单位（分）
        :type RangeEndValue: int
        :param _RangeFeeMode: 分段计费模式 
SINGLE：按金额计费 
RATIO：按费率计费
        :type RangeFeeMode: str
        :param _FeeValue: 费用值，单位（0.01%或分）
        :type FeeValue: int
        :param _MinFee: 最低收费金额，单位（分）
        :type MinFee: int
        :param _MaxFee: 最高收费金额，单位（分）
        :type MaxFee: int
        """
        self._CardType = None
        self._RangeStartValue = None
        self._RangeEndValue = None
        self._RangeFeeMode = None
        self._FeeValue = None
        self._MinFee = None
        self._MaxFee = None

    @property
    def CardType(self):
        """卡类型，银联产品使用 
DEBIT：借记卡 
CREDIT：贷记卡
        :rtype: str
        """
        return self._CardType

    @CardType.setter
    def CardType(self, CardType):
        self._CardType = CardType

    @property
    def RangeStartValue(self):
        """区间起始金额，单位（分）
        :rtype: int
        """
        return self._RangeStartValue

    @RangeStartValue.setter
    def RangeStartValue(self, RangeStartValue):
        self._RangeStartValue = RangeStartValue

    @property
    def RangeEndValue(self):
        """区间结束金额，单位（分）
        :rtype: int
        """
        return self._RangeEndValue

    @RangeEndValue.setter
    def RangeEndValue(self, RangeEndValue):
        self._RangeEndValue = RangeEndValue

    @property
    def RangeFeeMode(self):
        """分段计费模式 
SINGLE：按金额计费 
RATIO：按费率计费
        :rtype: str
        """
        return self._RangeFeeMode

    @RangeFeeMode.setter
    def RangeFeeMode(self, RangeFeeMode):
        self._RangeFeeMode = RangeFeeMode

    @property
    def FeeValue(self):
        """费用值，单位（0.01%或分）
        :rtype: int
        """
        return self._FeeValue

    @FeeValue.setter
    def FeeValue(self, FeeValue):
        self._FeeValue = FeeValue

    @property
    def MinFee(self):
        """最低收费金额，单位（分）
        :rtype: int
        """
        return self._MinFee

    @MinFee.setter
    def MinFee(self, MinFee):
        self._MinFee = MinFee

    @property
    def MaxFee(self):
        """最高收费金额，单位（分）
        :rtype: int
        """
        return self._MaxFee

    @MaxFee.setter
    def MaxFee(self, MaxFee):
        self._MaxFee = MaxFee


    def _deserialize(self, params):
        self._CardType = params.get("CardType")
        self._RangeStartValue = params.get("RangeStartValue")
        self._RangeEndValue = params.get("RangeEndValue")
        self._RangeFeeMode = params.get("RangeFeeMode")
        self._FeeValue = params.get("FeeValue")
        self._MinFee = params.get("MinFee")
        self._MaxFee = params.get("MaxFee")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FileItem(AbstractModel):
    """对账文件信息

    """

    def __init__(self):
        r"""
        :param _FileName: STRING(256)，文件名称
注意：此字段可能返回 null，表示取不到有效值。
        :type FileName: str
        :param _RandomPassword: STRING(120)，随机密码
注意：此字段可能返回 null，表示取不到有效值。
        :type RandomPassword: str
        :param _FilePath: STRING(512)，文件路径
注意：此字段可能返回 null，表示取不到有效值。
        :type FilePath: str
        :param _DrawCode: STRING(64)，提取码
注意：此字段可能返回 null，表示取不到有效值。
        :type DrawCode: str
        """
        self._FileName = None
        self._RandomPassword = None
        self._FilePath = None
        self._DrawCode = None

    @property
    def FileName(self):
        """STRING(256)，文件名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def RandomPassword(self):
        """STRING(120)，随机密码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RandomPassword

    @RandomPassword.setter
    def RandomPassword(self, RandomPassword):
        self._RandomPassword = RandomPassword

    @property
    def FilePath(self):
        """STRING(512)，文件路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def DrawCode(self):
        """STRING(64)，提取码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DrawCode

    @DrawCode.setter
    def DrawCode(self, DrawCode):
        self._DrawCode = DrawCode


    def _deserialize(self, params):
        self._FileName = params.get("FileName")
        self._RandomPassword = params.get("RandomPassword")
        self._FilePath = params.get("FilePath")
        self._DrawCode = params.get("DrawCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlexBillDownloadUrlResult(AbstractModel):
    """对账单文件下载链接

    """

    def __init__(self):
        r"""
        :param _Url: 对账单文件下载链接
        :type Url: str
        :param _ExpireTime: 下载链接过期时间
        :type ExpireTime: str
        """
        self._Url = None
        self._ExpireTime = None

    @property
    def Url(self):
        """对账单文件下载链接
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def ExpireTime(self):
        """下载链接过期时间
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlexFundingAccountInfo(AbstractModel):
    """灵云V2-银行信息

    """

    def __init__(self):
        r"""
        :param _FundingAccountNo: 资金账户号
        :type FundingAccountNo: str
        :param _FundingAccountType: 资金账户类型
        :type FundingAccountType: str
        :param _FundingAccountBindSerialNo: 资金账户绑定序列号
        :type FundingAccountBindSerialNo: str
        :param _FundingAccountName: 资金账户名称
        :type FundingAccountName: str
        """
        self._FundingAccountNo = None
        self._FundingAccountType = None
        self._FundingAccountBindSerialNo = None
        self._FundingAccountName = None

    @property
    def FundingAccountNo(self):
        """资金账户号
        :rtype: str
        """
        return self._FundingAccountNo

    @FundingAccountNo.setter
    def FundingAccountNo(self, FundingAccountNo):
        self._FundingAccountNo = FundingAccountNo

    @property
    def FundingAccountType(self):
        """资金账户类型
        :rtype: str
        """
        return self._FundingAccountType

    @FundingAccountType.setter
    def FundingAccountType(self, FundingAccountType):
        self._FundingAccountType = FundingAccountType

    @property
    def FundingAccountBindSerialNo(self):
        """资金账户绑定序列号
        :rtype: str
        """
        return self._FundingAccountBindSerialNo

    @FundingAccountBindSerialNo.setter
    def FundingAccountBindSerialNo(self, FundingAccountBindSerialNo):
        self._FundingAccountBindSerialNo = FundingAccountBindSerialNo

    @property
    def FundingAccountName(self):
        """资金账户名称
        :rtype: str
        """
        return self._FundingAccountName

    @FundingAccountName.setter
    def FundingAccountName(self, FundingAccountName):
        self._FundingAccountName = FundingAccountName


    def _deserialize(self, params):
        self._FundingAccountNo = params.get("FundingAccountNo")
        self._FundingAccountType = params.get("FundingAccountType")
        self._FundingAccountBindSerialNo = params.get("FundingAccountBindSerialNo")
        self._FundingAccountName = params.get("FundingAccountName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeFlexBalanceRequest(AbstractModel):
    """FreezeFlexBalance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _AmountBeforeTax: 税前金额
        :type AmountBeforeTax: str
        :param _IncomeType: 收入类型
LABOR:劳务所得
OCCASION:偶然所得
        :type IncomeType: str
        :param _OutOrderId: 外部订单ID
        :type OutOrderId: str
        :param _OperationType: 操作类型
FREEZE:冻结
UNFREEZE:解冻
        :type OperationType: str
        :param _Remark: 冻结备注
        :type Remark: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        """
        self._PayeeId = None
        self._AmountBeforeTax = None
        self._IncomeType = None
        self._OutOrderId = None
        self._OperationType = None
        self._Remark = None
        self._Environment = None

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def AmountBeforeTax(self):
        """税前金额
        :rtype: str
        """
        return self._AmountBeforeTax

    @AmountBeforeTax.setter
    def AmountBeforeTax(self, AmountBeforeTax):
        self._AmountBeforeTax = AmountBeforeTax

    @property
    def IncomeType(self):
        """收入类型
LABOR:劳务所得
OCCASION:偶然所得
        :rtype: str
        """
        return self._IncomeType

    @IncomeType.setter
    def IncomeType(self, IncomeType):
        self._IncomeType = IncomeType

    @property
    def OutOrderId(self):
        """外部订单ID
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def OperationType(self):
        """操作类型
FREEZE:冻结
UNFREEZE:解冻
        :rtype: str
        """
        return self._OperationType

    @OperationType.setter
    def OperationType(self, OperationType):
        self._OperationType = OperationType

    @property
    def Remark(self):
        """冻结备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._PayeeId = params.get("PayeeId")
        self._AmountBeforeTax = params.get("AmountBeforeTax")
        self._IncomeType = params.get("IncomeType")
        self._OutOrderId = params.get("OutOrderId")
        self._OperationType = params.get("OperationType")
        self._Remark = params.get("Remark")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeFlexBalanceResponse(AbstractModel):
    """FreezeFlexBalance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.FreezeFlexBalanceResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.FreezeFlexBalanceResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = FreezeFlexBalanceResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class FreezeFlexBalanceResult(AbstractModel):
    """冻结余额结果

    """

    def __init__(self):
        r"""
        :param _OrderId: 冻结订单ID
        :type OrderId: str
        """
        self._OrderId = None

    @property
    def OrderId(self):
        """冻结订单ID
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId


    def _deserialize(self, params):
        self._OrderId = params.get("OrderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeOrderResult(AbstractModel):
    """冻结单结果

    """

    def __init__(self):
        r"""
        :param _AmountBeforeTax: 税前金额
        :type AmountBeforeTax: str
        :param _IncomeType: 收入类型
LABOR:劳务所得
OCCASION:偶然所得
        :type IncomeType: str
        :param _OutOrderId: 外部订单ID
        :type OutOrderId: str
        :param _OrderId: 订单ID
        :type OrderId: str
        :param _OperationType: 操作类型
FREEZE:冻结
UNFREEZE:解冻
        :type OperationType: str
        :param _InitiateTime: 发起时间
        :type InitiateTime: str
        :param _FinishTime: 完成时间
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        :param _Status: 状态
ACCEPTED:已受理
ACCOUNTED:已记账
SUCCEED:已成功
FAILED:已失败
        :type Status: str
        :param _StatusDesc: 状态描述
        :type StatusDesc: str
        :param _Remark: 冻结备注
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _OutUserId: 外部用户ID
        :type OutUserId: str
        """
        self._AmountBeforeTax = None
        self._IncomeType = None
        self._OutOrderId = None
        self._OrderId = None
        self._OperationType = None
        self._InitiateTime = None
        self._FinishTime = None
        self._Status = None
        self._StatusDesc = None
        self._Remark = None
        self._PayeeId = None
        self._OutUserId = None

    @property
    def AmountBeforeTax(self):
        """税前金额
        :rtype: str
        """
        return self._AmountBeforeTax

    @AmountBeforeTax.setter
    def AmountBeforeTax(self, AmountBeforeTax):
        self._AmountBeforeTax = AmountBeforeTax

    @property
    def IncomeType(self):
        """收入类型
LABOR:劳务所得
OCCASION:偶然所得
        :rtype: str
        """
        return self._IncomeType

    @IncomeType.setter
    def IncomeType(self, IncomeType):
        self._IncomeType = IncomeType

    @property
    def OutOrderId(self):
        """外部订单ID
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def OrderId(self):
        """订单ID
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def OperationType(self):
        """操作类型
FREEZE:冻结
UNFREEZE:解冻
        :rtype: str
        """
        return self._OperationType

    @OperationType.setter
    def OperationType(self, OperationType):
        self._OperationType = OperationType

    @property
    def InitiateTime(self):
        """发起时间
        :rtype: str
        """
        return self._InitiateTime

    @InitiateTime.setter
    def InitiateTime(self, InitiateTime):
        self._InitiateTime = InitiateTime

    @property
    def FinishTime(self):
        """完成时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def Status(self):
        """状态
ACCEPTED:已受理
ACCOUNTED:已记账
SUCCEED:已成功
FAILED:已失败
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusDesc(self):
        """状态描述
        :rtype: str
        """
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def Remark(self):
        """冻结备注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def OutUserId(self):
        """外部用户ID
        :rtype: str
        """
        return self._OutUserId

    @OutUserId.setter
    def OutUserId(self, OutUserId):
        self._OutUserId = OutUserId


    def _deserialize(self, params):
        self._AmountBeforeTax = params.get("AmountBeforeTax")
        self._IncomeType = params.get("IncomeType")
        self._OutOrderId = params.get("OutOrderId")
        self._OrderId = params.get("OrderId")
        self._OperationType = params.get("OperationType")
        self._InitiateTime = params.get("InitiateTime")
        self._FinishTime = params.get("FinishTime")
        self._Status = params.get("Status")
        self._StatusDesc = params.get("StatusDesc")
        self._Remark = params.get("Remark")
        self._PayeeId = params.get("PayeeId")
        self._OutUserId = params.get("OutUserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeOrders(AbstractModel):
    """冻结订单列表

    """

    def __init__(self):
        r"""
        :param _List: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of FreezeOrderResult
        :param _Count: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type Count: int
        """
        self._List = None
        self._Count = None

    @property
    def List(self):
        """列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of FreezeOrderResult
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Count(self):
        """总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = FreezeOrderResult()
                obj._deserialize(item)
                self._List.append(obj)
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FundsTransactionItem(AbstractModel):
    """会员资金交易明细信息

    """

    def __init__(self):
        r"""
        :param _TransType: 资金交易类型。
__1__：提现/退款
__2__：清分/充值
        :type TransType: str
        :param _BankBookingMessage: 银行记账说明。
注意：此字段可能返回 null，表示取不到有效值。
        :type BankBookingMessage: str
        :param _TranStatus: 交易状态。
__0__：成功
        :type TranStatus: str
        :param _TransNetMemberCode: 业务方会员标识。
_平安渠道为交易网会员代码_
注意：此字段可能返回 null，表示取不到有效值。
        :type TransNetMemberCode: str
        :param _SubAccountNumber: 子账户账号。
_平安渠道为见证子账户的账号_
        :type SubAccountNumber: str
        :param _SubAccountName: 子账户名称。
_平安渠道为见证子账户的户名_
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAccountName: str
        :param _TransAmount: 交易金额。
        :type TransAmount: str
        :param _TransFee: 交易手续费。
注意：此字段可能返回 null，表示取不到有效值。
        :type TransFee: str
        :param _TransDate: 交易日期，格式：yyyyMMdd。
        :type TransDate: str
        :param _TransTime: 交易时间，格式：HHmmss。
注意：此字段可能返回 null，表示取不到有效值。
        :type TransTime: str
        :param _BankSequenceNumber: 银行系统流水号。
_平安渠道为见证系统流水号_
        :type BankSequenceNumber: str
        :param _Remark: 备注。
_平安渠道，如果是见证+收单的交易，返回交易订单号_
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        """
        self._TransType = None
        self._BankBookingMessage = None
        self._TranStatus = None
        self._TransNetMemberCode = None
        self._SubAccountNumber = None
        self._SubAccountName = None
        self._TransAmount = None
        self._TransFee = None
        self._TransDate = None
        self._TransTime = None
        self._BankSequenceNumber = None
        self._Remark = None

    @property
    def TransType(self):
        """资金交易类型。
__1__：提现/退款
__2__：清分/充值
        :rtype: str
        """
        return self._TransType

    @TransType.setter
    def TransType(self, TransType):
        self._TransType = TransType

    @property
    def BankBookingMessage(self):
        """银行记账说明。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BankBookingMessage

    @BankBookingMessage.setter
    def BankBookingMessage(self, BankBookingMessage):
        self._BankBookingMessage = BankBookingMessage

    @property
    def TranStatus(self):
        """交易状态。
__0__：成功
        :rtype: str
        """
        return self._TranStatus

    @TranStatus.setter
    def TranStatus(self, TranStatus):
        self._TranStatus = TranStatus

    @property
    def TransNetMemberCode(self):
        """业务方会员标识。
_平安渠道为交易网会员代码_
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TransNetMemberCode

    @TransNetMemberCode.setter
    def TransNetMemberCode(self, TransNetMemberCode):
        self._TransNetMemberCode = TransNetMemberCode

    @property
    def SubAccountNumber(self):
        """子账户账号。
_平安渠道为见证子账户的账号_
        :rtype: str
        """
        return self._SubAccountNumber

    @SubAccountNumber.setter
    def SubAccountNumber(self, SubAccountNumber):
        self._SubAccountNumber = SubAccountNumber

    @property
    def SubAccountName(self):
        """子账户名称。
_平安渠道为见证子账户的户名_
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAccountName

    @SubAccountName.setter
    def SubAccountName(self, SubAccountName):
        self._SubAccountName = SubAccountName

    @property
    def TransAmount(self):
        """交易金额。
        :rtype: str
        """
        return self._TransAmount

    @TransAmount.setter
    def TransAmount(self, TransAmount):
        self._TransAmount = TransAmount

    @property
    def TransFee(self):
        """交易手续费。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TransFee

    @TransFee.setter
    def TransFee(self, TransFee):
        self._TransFee = TransFee

    @property
    def TransDate(self):
        """交易日期，格式：yyyyMMdd。
        :rtype: str
        """
        return self._TransDate

    @TransDate.setter
    def TransDate(self, TransDate):
        self._TransDate = TransDate

    @property
    def TransTime(self):
        """交易时间，格式：HHmmss。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TransTime

    @TransTime.setter
    def TransTime(self, TransTime):
        self._TransTime = TransTime

    @property
    def BankSequenceNumber(self):
        """银行系统流水号。
_平安渠道为见证系统流水号_
        :rtype: str
        """
        return self._BankSequenceNumber

    @BankSequenceNumber.setter
    def BankSequenceNumber(self, BankSequenceNumber):
        self._BankSequenceNumber = BankSequenceNumber

    @property
    def Remark(self):
        """备注。
_平安渠道，如果是见证+收单的交易，返回交易订单号_
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._TransType = params.get("TransType")
        self._BankBookingMessage = params.get("BankBookingMessage")
        self._TranStatus = params.get("TranStatus")
        self._TransNetMemberCode = params.get("TransNetMemberCode")
        self._SubAccountNumber = params.get("SubAccountNumber")
        self._SubAccountName = params.get("SubAccountName")
        self._TransAmount = params.get("TransAmount")
        self._TransFee = params.get("TransFee")
        self._TransDate = params.get("TransDate")
        self._TransTime = params.get("TransTime")
        self._BankSequenceNumber = params.get("BankSequenceNumber")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetBillDownloadUrlRequest(AbstractModel):
    """GetBillDownloadUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 收单系统分配的开放ID
        :type OpenId: str
        :param _OpenKey: 收单系统分配的密钥
        :type OpenKey: str
        :param _Day: 清算日期（YYYYMMDD，今天传昨天的日期，每日下午1点后出前一日的账单）
        :type Day: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._Day = None

    @property
    def OpenId(self):
        """收单系统分配的开放ID
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """收单系统分配的密钥
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def Day(self):
        """清算日期（YYYYMMDD，今天传昨天的日期，每日下午1点后出前一日的账单）
        :rtype: str
        """
        return self._Day

    @Day.setter
    def Day(self, Day):
        self._Day = Day


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._Day = params.get("Day")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetBillDownloadUrlResponse(AbstractModel):
    """GetBillDownloadUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 账单文件下载地址响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.BillDownloadUrlResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """账单文件下载地址响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.BillDownloadUrlResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = BillDownloadUrlResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class GetDistributeBillDownloadUrlRequest(AbstractModel):
    """GetDistributeBillDownloadUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 收单系统分配的开放ID
        :type OpenId: str
        :param _OpenKey: 收单系统分配的密钥
        :type OpenKey: str
        :param _Day: 分账日期（YYYYMMDD，今天传昨天的日期）
        :type Day: str
        """
        self._OpenId = None
        self._OpenKey = None
        self._Day = None

    @property
    def OpenId(self):
        """收单系统分配的开放ID
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def OpenKey(self):
        """收单系统分配的密钥
        :rtype: str
        """
        return self._OpenKey

    @OpenKey.setter
    def OpenKey(self, OpenKey):
        self._OpenKey = OpenKey

    @property
    def Day(self):
        """分账日期（YYYYMMDD，今天传昨天的日期）
        :rtype: str
        """
        return self._Day

    @Day.setter
    def Day(self, Day):
        self._Day = Day


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._OpenKey = params.get("OpenKey")
        self._Day = params.get("Day")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetDistributeBillDownloadUrlResponse(AbstractModel):
    """GetDistributeBillDownloadUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 业务系统返回码
        :type ErrCode: str
        :param _ErrMessage: 业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrMessage: str
        :param _Result: 账单文件下载地址响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.BillDownloadUrlResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """业务系统返回码
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """业务系统返回消息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """账单文件下载地址响应对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.BillDownloadUrlResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        if params.get("Result") is not None:
            self._Result = BillDownloadUrlResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class GetPayRollAuthListRequest(AbstractModel):
    """GetPayRollAuthList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _AuthDate: 核身日期，一次只能查询一天，最久可查询90天内的记录，格式为YYYY-MM-DD
        :type AuthDate: str
        :param _Offset: 非负整数，表示该次请求资源的起始位置，从0开始计数
        :type Offset: int
        :param _Limit: 非0非负的整数，该次请求可返回的最大资源条数，默认值为10，最大支持10条
        :type Limit: int
        :param _WechatAppId: 是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatAppId: str
        :param _WechatSubAppId: 特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatSubAppId: str
        :param _AuthStatus: 核身状态，列表查询仅提供成功状态的核身记录查询，故此字段固定AUTHENTICATE_SUCCESS即可
        :type AuthStatus: str
        """
        self._OpenId = None
        self._SubMerchantId = None
        self._AuthDate = None
        self._Offset = None
        self._Limit = None
        self._WechatAppId = None
        self._WechatSubAppId = None
        self._AuthStatus = None

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def AuthDate(self):
        """核身日期，一次只能查询一天，最久可查询90天内的记录，格式为YYYY-MM-DD
        :rtype: str
        """
        return self._AuthDate

    @AuthDate.setter
    def AuthDate(self, AuthDate):
        self._AuthDate = AuthDate

    @property
    def Offset(self):
        """非负整数，表示该次请求资源的起始位置，从0开始计数
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """非0非负的整数，该次请求可返回的最大资源条数，默认值为10，最大支持10条
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def WechatAppId(self):
        """是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatAppId

    @WechatAppId.setter
    def WechatAppId(self, WechatAppId):
        self._WechatAppId = WechatAppId

    @property
    def WechatSubAppId(self):
        """特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatSubAppId

    @WechatSubAppId.setter
    def WechatSubAppId(self, WechatSubAppId):
        self._WechatSubAppId = WechatSubAppId

    @property
    def AuthStatus(self):
        """核身状态，列表查询仅提供成功状态的核身记录查询，故此字段固定AUTHENTICATE_SUCCESS即可
        :rtype: str
        """
        return self._AuthStatus

    @AuthStatus.setter
    def AuthStatus(self, AuthStatus):
        self._AuthStatus = AuthStatus


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._AuthDate = params.get("AuthDate")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._WechatAppId = params.get("WechatAppId")
        self._WechatSubAppId = params.get("WechatSubAppId")
        self._AuthStatus = params.get("AuthStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetPayRollAuthListResponse(AbstractModel):
    """GetPayRollAuthList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Results: 核身结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Results: list of PayRollAuthResult
        :param _Total: 总记录条数
        :type Total: int
        :param _Offset: 记录起始位置，该次请求资源的起始位置，请求中包含偏移量时应答消息返回相同偏移量，否则返回默认值0
        :type Offset: int
        :param _Limit: 本次返回条数
        :type Limit: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Results = None
        self._Total = None
        self._Offset = None
        self._Limit = None
        self._RequestId = None

    @property
    def Results(self):
        """核身结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of PayRollAuthResult
        """
        return self._Results

    @Results.setter
    def Results(self, Results):
        self._Results = Results

    @property
    def Total(self):
        """总记录条数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Offset(self):
        """记录起始位置，该次请求资源的起始位置，请求中包含偏移量时应答消息返回相同偏移量，否则返回默认值0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """本次返回条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Results") is not None:
            self._Results = []
            for item in params.get("Results"):
                obj = PayRollAuthResult()
                obj._deserialize(item)
                self._Results.append(obj)
        self._Total = params.get("Total")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._RequestId = params.get("RequestId")


class GetPayRollAuthRequest(AbstractModel):
    """GetPayRollAuth请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _WechatAppId: 是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatAppId: str
        :param _WechatSubAppId: 特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :type WechatSubAppId: str
        """
        self._OpenId = None
        self._SubMerchantId = None
        self._WechatAppId = None
        self._WechatSubAppId = None

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def WechatAppId(self):
        """是服务商在微信申请公众号/小程序或移动应用成功后分配的账号ID（与服务商主体一致）
当输入服务商Appid时，会校验其与服务商商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatAppId

    @WechatAppId.setter
    def WechatAppId(self, WechatAppId):
        self._WechatAppId = WechatAppId

    @property
    def WechatSubAppId(self):
        """特约商户在微信申请公众号/小程序或移动应用成功后分配的账号ID（与特约商户主体一致）
当输入特约商户Appid时，会校验其与特约商户号的绑定关系。服务商APPID和与特约商户APPID至少输入一个，且必须要有拉起领薪卡小程序时使用的APPID
        :rtype: str
        """
        return self._WechatSubAppId

    @WechatSubAppId.setter
    def WechatSubAppId(self, WechatSubAppId):
        self._WechatSubAppId = WechatSubAppId


    def _deserialize(self, params):
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._WechatAppId = params.get("WechatAppId")
        self._WechatSubAppId = params.get("WechatSubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetPayRollAuthResponse(AbstractModel):
    """GetPayRollAuth返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AuthStatus: 授权状态：
UNAUTHORIZED：未授权
AUTHORIZED：已授权
DEAUTHORIZED：已取消授权
        :type AuthStatus: str
        :param _AuthTime: 授权时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为YYYY-MM-DDTHH:mm:ss.sss+TIMEZONE，空字符串等同null
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthTime: str
        :param _CancelAuthTime: 授权时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为YYYY-MM-DDTHH:mm:ss.sss+TIMEZONE，空字符串等同null
注意：此字段可能返回 null，表示取不到有效值。
        :type CancelAuthTime: str
        :param _MerchantId: 微信服务商商户的商户号，由微信支付生成并下发
        :type MerchantId: str
        :param _OpenId: 用户在商户对应appid下的唯一标识
        :type OpenId: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AuthStatus = None
        self._AuthTime = None
        self._CancelAuthTime = None
        self._MerchantId = None
        self._OpenId = None
        self._SubMerchantId = None
        self._RequestId = None

    @property
    def AuthStatus(self):
        """授权状态：
UNAUTHORIZED：未授权
AUTHORIZED：已授权
DEAUTHORIZED：已取消授权
        :rtype: str
        """
        return self._AuthStatus

    @AuthStatus.setter
    def AuthStatus(self, AuthStatus):
        self._AuthStatus = AuthStatus

    @property
    def AuthTime(self):
        """授权时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为YYYY-MM-DDTHH:mm:ss.sss+TIMEZONE，空字符串等同null
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AuthTime

    @AuthTime.setter
    def AuthTime(self, AuthTime):
        self._AuthTime = AuthTime

    @property
    def CancelAuthTime(self):
        """授权时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为YYYY-MM-DDTHH:mm:ss.sss+TIMEZONE，空字符串等同null
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CancelAuthTime

    @CancelAuthTime.setter
    def CancelAuthTime(self, CancelAuthTime):
        self._CancelAuthTime = CancelAuthTime

    @property
    def MerchantId(self):
        """微信服务商商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def OpenId(self):
        """用户在商户对应appid下的唯一标识
        :rtype: str
        """
        return self._OpenId

    @OpenId.setter
    def OpenId(self, OpenId):
        self._OpenId = OpenId

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AuthStatus = params.get("AuthStatus")
        self._AuthTime = params.get("AuthTime")
        self._CancelAuthTime = params.get("CancelAuthTime")
        self._MerchantId = params.get("MerchantId")
        self._OpenId = params.get("OpenId")
        self._SubMerchantId = params.get("SubMerchantId")
        self._RequestId = params.get("RequestId")


class GetPayRollAuthResultRequest(AbstractModel):
    """GetPayRollAuthResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AuthNumber: 商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :type AuthNumber: str
        :param _SubMerchantId: 微信服务商下特约商户的商户号，由微信支付生成并下发
        :type SubMerchantId: str
        """
        self._AuthNumber = None
        self._SubMerchantId = None

    @property
    def AuthNumber(self):
        """商户系统内部的商家核身单号，要求此参数只能由数字、大小写字母组成，在服务商内部唯一
        :rtype: str
        """
        return self._AuthNumber

    @AuthNumber.setter
    def AuthNumber(self, AuthNumber):
        self._AuthNumber = AuthNumber

    @property
    def SubMerchantId(self):
        """微信服务商下特约商户的商户号，由微信支付生成并下发
        :rtype: str
        """
        return self._SubMerchantId

    @SubMerchantId.setter
    def SubMerchantId(self, SubMerchantId):
        self._SubMerchantId = SubMerchantId


    def _deserialize(self, params):
        self._AuthNumber = params.get("AuthNumber")
        self._SubMerchantId = params.get("SubMerchantId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetPayRollAuthResultResponse(AbstractModel):
    """GetPayRollAuthResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 核身结果
        :type Result: :class:`tencentcloud.cpdp.v20190820.models.PayRollAuthResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """核身结果
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.PayRollAuthResult`
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = PayRollAuthResult()
            self._Result._deserialize(params.get("Result"))
        self._RequestId = params.get("RequestId")


class LegalPersonInfo(AbstractModel):
    """商户法人代表信息

    """

    def __init__(self):
        r"""
        :param _IdType: 证件类型 
IDCARD：身份证 
PASSPORT：护照 SOLDIERSCERTIFICATE：士兵证 OFFICERSCERTIFICATE：军官证 GATXCERTIFICATE：香港居民来往内地通行证 TWNDCERTIFICATE：台湾同胞来往内地通行证 
MACAOCERTIFICATE：澳门来往内地通行证
        :type IdType: str
        :param _IdNumber: 证件号码
        :type IdNumber: str
        :param _PersonName: 姓名
        :type PersonName: str
        :param _IdValidityType: 证件有效期类型 
LONGTERM：长期有效 
OTHER：非长期有效
        :type IdValidityType: str
        :param _IdEffectiveDate: 证件生效日期，yyyy-MM-dd
        :type IdEffectiveDate: str
        :param _ContactPhone: 联系电话
        :type ContactPhone: str
        :param _IdExpireDate: 证件失效日期，yyyy-MM-dd
        :type IdExpireDate: str
        :param _ContactAddress: 联系地址
        :type ContactAddress: str
        :param _EmailAddress: 邮箱地址
        :type EmailAddress: str
        """
        self._IdType = None
        self._IdNumber = None
        self._PersonName = None
        self._IdValidityType = None
        self._IdEffectiveDate = None
        self._ContactPhone = None
        self._IdExpireDate = None
        self._ContactAddress = None
        self._EmailAddress = None

    @property
    def IdType(self):
        """证件类型 
IDCARD：身份证 
PASSPORT：护照 SOLDIERSCERTIFICATE：士兵证 OFFICERSCERTIFICATE：军官证 GATXCERTIFICATE：香港居民来往内地通行证 TWNDCERTIFICATE：台湾同胞来往内地通行证 
MACAOCERTIFICATE：澳门来往内地通行证
        :rtype: str
        """
        return self._IdType

    @IdType.setter
    def IdType(self, IdType):
        self._IdType = IdType

    @property
    def IdNumber(self):
        """证件号码
        :rtype: str
        """
        return self._IdNumber

    @IdNumber.setter
    def IdNumber(self, IdNumber):
        self._IdNumber = IdNumber

    @property
    def PersonName(self):
        """姓名
        :rtype: str
        """
        return self._PersonName

    @PersonName.setter
    def PersonName(self, PersonName):
        self._PersonName = PersonName

    @property
    def IdValidityType(self):
        """证件有效期类型 
LONGTERM：长期有效 
OTHER：非长期有效
        :rtype: str
        """
        return self._IdValidityType

    @IdValidityType.setter
    def IdValidityType(self, IdValidityType):
        self._IdValidityType = IdValidityType

    @property
    def IdEffectiveDate(self):
        """证件生效日期，yyyy-MM-dd
        :rtype: str
        """
        return self._IdEffectiveDate

    @IdEffectiveDate.setter
    def IdEffectiveDate(self, IdEffectiveDate):
        self._IdEffectiveDate = IdEffectiveDate

    @property
    def ContactPhone(self):
        """联系电话
        :rtype: str
        """
        return self._ContactPhone

    @ContactPhone.setter
    def ContactPhone(self, ContactPhone):
        self._ContactPhone = ContactPhone

    @property
    def IdExpireDate(self):
        """证件失效日期，yyyy-MM-dd
        :rtype: str
        """
        return self._IdExpireDate

    @IdExpireDate.setter
    def IdExpireDate(self, IdExpireDate):
        self._IdExpireDate = IdExpireDate

    @property
    def ContactAddress(self):
        """联系地址
        :rtype: str
        """
        return self._ContactAddress

    @ContactAddress.setter
    def ContactAddress(self, ContactAddress):
        self._ContactAddress = ContactAddress

    @property
    def EmailAddress(self):
        """邮箱地址
        :rtype: str
        """
        return self._EmailAddress

    @EmailAddress.setter
    def EmailAddress(self, EmailAddress):
        self._EmailAddress = EmailAddress


    def _deserialize(self, params):
        self._IdType = params.get("IdType")
        self._IdNumber = params.get("IdNumber")
        self._PersonName = params.get("PersonName")
        self._IdValidityType = params.get("IdValidityType")
        self._IdEffectiveDate = params.get("IdEffectiveDate")
        self._ContactPhone = params.get("ContactPhone")
        self._IdExpireDate = params.get("IdExpireDate")
        self._ContactAddress = params.get("ContactAddress")
        self._EmailAddress = params.get("EmailAddress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MemberTransactionItem(AbstractModel):
    """会员间交易明细信息

    """

    def __init__(self):
        r"""
        :param _TransType: 交易类型。
__1__：转出
__2__：转入
        :type TransType: str
        :param _TranStatus: 交易状态。
__0__：成功
        :type TranStatus: str
        :param _TransAmount: 交易金额。
        :type TransAmount: str
        :param _TransDate: 交易日期，格式：yyyyMMdd。
        :type TransDate: str
        :param _TransTime: 交易时间，格式：HHmmss。
注意：此字段可能返回 null，表示取不到有效值。
        :type TransTime: str
        :param _BankSequenceNumber: 银行系统流水号。
_平安渠道为见证系统流水号_
        :type BankSequenceNumber: str
        :param _BankBookingType: 银行记账类型。
_平安渠道为：_
_1：会员支付_
_2：会员冻结_
_3：会员解冻_
_4：登记挂账_
_6：下单预支付_
_7：确认并付款_
_8：会员退款_
_22：见证+收单平台调账_
_23：见证+收单资金冻结_
_24：见证+收单资金解冻_
_25：会员间交易退款_
注意：此字段可能返回 null，表示取不到有效值。
        :type BankBookingType: str
        :param _InSubAccountNumber: 转入方子账户账号。
_平安渠道为转入见证子账户的账号_
        :type InSubAccountNumber: str
        :param _OutSubAccountNumber: 转出方子账户账号。
_平安渠道为转出见证子账户的账号_
        :type OutSubAccountNumber: str
        :param _Remark: 备注。
_平安渠道，如果是见证+收单的交易，返回交易订单号_
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        """
        self._TransType = None
        self._TranStatus = None
        self._TransAmount = None
        self._TransDate = None
        self._TransTime = None
        self._BankSequenceNumber = None
        self._BankBookingType = None
        self._InSubAccountNumber = None
        self._OutSubAccountNumber = None
        self._Remark = None

    @property
    def TransType(self):
        """交易类型。
__1__：转出
__2__：转入
        :rtype: str
        """
        return self._TransType

    @TransType.setter
    def TransType(self, TransType):
        self._TransType = TransType

    @property
    def TranStatus(self):
        """交易状态。
__0__：成功
        :rtype: str
        """
        return self._TranStatus

    @TranStatus.setter
    def TranStatus(self, TranStatus):
        self._TranStatus = TranStatus

    @property
    def TransAmount(self):
        """交易金额。
        :rtype: str
        """
        return self._TransAmount

    @TransAmount.setter
    def TransAmount(self, TransAmount):
        self._TransAmount = TransAmount

    @property
    def TransDate(self):
        """交易日期，格式：yyyyMMdd。
        :rtype: str
        """
        return self._TransDate

    @TransDate.setter
    def TransDate(self, TransDate):
        self._TransDate = TransDate

    @property
    def TransTime(self):
        """交易时间，格式：HHmmss。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TransTime

    @TransTime.setter
    def TransTime(self, TransTime):
        self._TransTime = TransTime

    @property
    def BankSequenceNumber(self):
        """银行系统流水号。
_平安渠道为见证系统流水号_
        :rtype: str
        """
        return self._BankSequenceNumber

    @BankSequenceNumber.setter
    def BankSequenceNumber(self, BankSequenceNumber):
        self._BankSequenceNumber = BankSequenceNumber

    @property
    def BankBookingType(self):
        """银行记账类型。
_平安渠道为：_
_1：会员支付_
_2：会员冻结_
_3：会员解冻_
_4：登记挂账_
_6：下单预支付_
_7：确认并付款_
_8：会员退款_
_22：见证+收单平台调账_
_23：见证+收单资金冻结_
_24：见证+收单资金解冻_
_25：会员间交易退款_
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BankBookingType

    @BankBookingType.setter
    def BankBookingType(self, BankBookingType):
        self._BankBookingType = BankBookingType

    @property
    def InSubAccountNumber(self):
        """转入方子账户账号。
_平安渠道为转入见证子账户的账号_
        :rtype: str
        """
        return self._InSubAccountNumber

    @InSubAccountNumber.setter
    def InSubAccountNumber(self, InSubAccountNumber):
        self._InSubAccountNumber = InSubAccountNumber

    @property
    def OutSubAccountNumber(self):
        """转出方子账户账号。
_平安渠道为转出见证子账户的账号_
        :rtype: str
        """
        return self._OutSubAccountNumber

    @OutSubAccountNumber.setter
    def OutSubAccountNumber(self, OutSubAccountNumber):
        self._OutSubAccountNumber = OutSubAccountNumber

    @property
    def Remark(self):
        """备注。
_平安渠道，如果是见证+收单的交易，返回交易订单号_
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._TransType = params.get("TransType")
        self._TranStatus = params.get("TranStatus")
        self._TransAmount = params.get("TransAmount")
        self._TransDate = params.get("TransDate")
        self._TransTime = params.get("TransTime")
        self._BankSequenceNumber = params.get("BankSequenceNumber")
        self._BankBookingType = params.get("BankBookingType")
        self._InSubAccountNumber = params.get("InSubAccountNumber")
        self._OutSubAccountNumber = params.get("OutSubAccountNumber")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MerchantClassificationId(AbstractModel):
    """商户分类

    """

    def __init__(self):
        r"""
        :param _Code: 分类编号
        :type Code: str
        :param _Name: 分类名称
        :type Name: str
        :param _Parent: 父级编号（0为一级编号，大于0为父级分类编号）
        :type Parent: str
        """
        self._Code = None
        self._Name = None
        self._Parent = None

    @property
    def Code(self):
        """分类编号
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Name(self):
        """分类名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Parent(self):
        """父级编号（0为一级编号，大于0为父级分类编号）
        :rtype: str
        """
        return self._Parent

    @Parent.setter
    def Parent(self, Parent):
        self._Parent = Parent


    def _deserialize(self, params):
        self._Code = params.get("Code")
        self._Name = params.get("Name")
        self._Parent = params.get("Parent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MerchantManagementList(AbstractModel):
    """商户查询管理端列表

    """

    def __init__(self):
        r"""
        :param _TaxpayerName: 企业名称。
        :type TaxpayerName: str
        :param _TaxpayerNum: 纳税人识别号(税号)	。
        :type TaxpayerNum: str
        :param _SerialNo: 请求流水号。
        :type SerialNo: str
        :param _InvoicePlatformId: 开票系统ID
        :type InvoicePlatformId: int
        """
        self._TaxpayerName = None
        self._TaxpayerNum = None
        self._SerialNo = None
        self._InvoicePlatformId = None

    @property
    def TaxpayerName(self):
        """企业名称。
        :rtype: str
        """
        return self._TaxpayerName

    @TaxpayerName.setter
    def TaxpayerName(self, TaxpayerName):
        self._TaxpayerName = TaxpayerName

    @property
    def TaxpayerNum(self):
        """纳税人识别号(税号)	。
        :rtype: str
        """
        return self._TaxpayerNum

    @TaxpayerNum.setter
    def TaxpayerNum(self, TaxpayerNum):
        self._TaxpayerNum = TaxpayerNum

    @property
    def SerialNo(self):
        """请求流水号。
        :rtype: str
        """
        return self._SerialNo

    @SerialNo.setter
    def SerialNo(self, SerialNo):
        self._SerialNo = SerialNo

    @property
    def InvoicePlatformId(self):
        """开票系统ID
        :rtype: int
        """
        return self._InvoicePlatformId

    @InvoicePlatformId.setter
    def InvoicePlatformId(self, InvoicePlatformId):
        self._InvoicePlatformId = InvoicePlatformId


    def _deserialize(self, params):
        self._TaxpayerName = params.get("TaxpayerName")
        self._TaxpayerNum = params.get("TaxpayerNum")
        self._SerialNo = params.get("SerialNo")
        self._InvoicePlatformId = params.get("InvoicePlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MerchantManagementResult(AbstractModel):
    """商户管理端结果

    """

    def __init__(self):
        r"""
        :param _Total: 总数。
        :type Total: int
        :param _List: 商户列表。
        :type List: list of MerchantManagementList
        """
        self._Total = None
        self._List = None

    @property
    def Total(self):
        """总数。
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        """商户列表。
        :rtype: list of MerchantManagementList
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = MerchantManagementList()
                obj._deserialize(item)
                self._List.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MerchantPayWayData(AbstractModel):
    """商户支付方式数据

    """

    def __init__(self):
        r"""
        :param _PayCurrency: 支付币种
注意：此字段可能返回 null，表示取不到有效值。
        :type PayCurrency: str
        :param _PayIcon: 支付图标
注意：此字段可能返回 null，表示取不到有效值。
        :type PayIcon: str
        :param _PayInternalName: 支付名称
注意：此字段可能返回 null，表示取不到有效值。
        :type PayInternalName: str
        :param _PayName: 支付简称
注意：此字段可能返回 null，表示取不到有效值。
        :type PayName: str
        :param _PaySplitRefund: 是否支持退款
注意：此字段可能返回 null，表示取不到有效值。
        :type PaySplitRefund: str
        :param _PayTag: 支付标签
注意：此字段可能返回 null，表示取不到有效值。
        :type PayTag: str
        :param _PayTicketIcon: 支付凭证图标
注意：此字段可能返回 null，表示取不到有效值。
        :type PayTicketIcon: str
        :param _PayType: 支付类型，逗号分隔
注意：此字段可能返回 null，表示取不到有效值。
        :type PayType: str
        :param _TicketName: 凭证名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TicketName: str
        """
        self._PayCurrency = None
        self._PayIcon = None
        self._PayInternalName = None
        self._PayName = None
        self._PaySplitRefund = None
        self._PayTag = None
        self._PayTicketIcon = None
        self._PayType = None
        self._TicketName = None

    @property
    def PayCurrency(self):
        """支付币种
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayCurrency

    @PayCurrency.setter
    def PayCurrency(self, PayCurrency):
        self._PayCurrency = PayCurrency

    @property
    def PayIcon(self):
        """支付图标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayIcon

    @PayIcon.setter
    def PayIcon(self, PayIcon):
        self._PayIcon = PayIcon

    @property
    def PayInternalName(self):
        """支付名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayInternalName

    @PayInternalName.setter
    def PayInternalName(self, PayInternalName):
        self._PayInternalName = PayInternalName

    @property
    def PayName(self):
        """支付简称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayName

    @PayName.setter
    def PayName(self, PayName):
        self._PayName = PayName

    @property
    def PaySplitRefund(self):
        """是否支持退款
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PaySplitRefund

    @PaySplitRefund.setter
    def PaySplitRefund(self, PaySplitRefund):
        self._PaySplitRefund = PaySplitRefund

    @property
    def PayTag(self):
        """支付标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayTag

    @PayTag.setter
    def PayTag(self, PayTag):
        self._PayTag = PayTag

    @property
    def PayTicketIcon(self):
        """支付凭证图标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayTicketIcon

    @PayTicketIcon.setter
    def PayTicketIcon(self, PayTicketIcon):
        self._PayTicketIcon = PayTicketIcon

    @property
    def PayType(self):
        """支付类型，逗号分隔
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PayType

    @PayType.setter
    def PayType(self, PayType):
        self._PayType = PayType

    @property
    def TicketName(self):
        """凭证名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TicketName

    @TicketName.setter
    def TicketName(self, TicketName):
        self._TicketName = TicketName


    def _deserialize(self, params):
        self._PayCurrency = params.get("PayCurrency")
        self._PayIcon = params.get("PayIcon")
        self._PayInternalName = params.get("PayInternalName")
        self._PayName = params.get("PayName")
        self._PaySplitRefund = params.get("PaySplitRefund")
        self._PayTag = params.get("PayTag")
        self._PayTicketIcon = params.get("PayTicketIcon")
        self._PayType = params.get("PayType")
        self._TicketName = params.get("TicketName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MerchantRiskInfo(AbstractModel):
    """商户风险信息

    """

    def __init__(self):
        r"""
        :param _RiskLevel: 恶意注册等级，0-9级，9级最高
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskLevel: int
        :param _RiskTypes: 恶意注册代码，代码以|分割，如"G001|T002"
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskTypes: str
        """
        self._RiskLevel = None
        self._RiskTypes = None

    @property
    def RiskLevel(self):
        """恶意注册等级，0-9级，9级最高
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def RiskTypes(self):
        """恶意注册代码，代码以|分割，如"G001|T002"
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RiskTypes

    @RiskTypes.setter
    def RiskTypes(self, RiskTypes):
        self._RiskTypes = RiskTypes


    def _deserialize(self, params):
        self._RiskLevel = params.get("RiskLevel")
        self._RiskTypes = params.get("RiskTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigrateOrderRefundQueryRequest(AbstractModel):
    """MigrateOrderRefundQuery请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantId: 商户号
        :type MerchantId: str
        :param _PayChannel: 支付渠道，ALIPAY对应支付宝渠道；UNIONPAY对应银联渠道
        :type PayChannel: str
        :param _RefundOrderId: 退款订单号，最长64位，仅支持数字、 字母
        :type RefundOrderId: str
        :param _TradeSerialNo: 退款流水号
        :type TradeSerialNo: str
        :param _Profile: 接入环境。沙箱环境填 sandbox。
        :type Profile: str
        """
        self._MerchantId = None
        self._PayChannel = None
        self._RefundOrderId = None
        self._TradeSerialNo = None
        self._Profile = None

    @property
    def MerchantId(self):
        """商户号
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def PayChannel(self):
        """支付渠道，ALIPAY对应支付宝渠道；UNIONPAY对应银联渠道
        :rtype: str
        """
        return self._PayChannel

    @PayChannel.setter
    def PayChannel(self, PayChannel):
        self._PayChannel = PayChannel

    @property
    def RefundOrderId(self):
        """退款订单号，最长64位，仅支持数字、 字母
        :rtype: str
        """
        return self._RefundOrderId

    @RefundOrderId.setter
    def RefundOrderId(self, RefundOrderId):
        self._RefundOrderId = RefundOrderId

    @property
    def TradeSerialNo(self):
        """退款流水号
        :rtype: str
        """
        return self._TradeSerialNo

    @TradeSerialNo.setter
    def TradeSerialNo(self, TradeSerialNo):
        self._TradeSerialNo = TradeSerialNo

    @property
    def Profile(self):
        """接入环境。沙箱环境填 sandbox。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._MerchantId = params.get("MerchantId")
        self._PayChannel = params.get("PayChannel")
        self._RefundOrderId = params.get("RefundOrderId")
        self._TradeSerialNo = params.get("TradeSerialNo")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigrateOrderRefundQueryResponse(AbstractModel):
    """MigrateOrderRefundQuery返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsSuccess: 请求成功状态
        :type IsSuccess: bool
        :param _TradeSerialNo: 交易流水号
        :type TradeSerialNo: str
        :param _TradeMsg: 交易备注
        :type TradeMsg: str
        :param _TradeStatus: 交易状态：0=交易待处理；1=交易处理中；2=交易处理成功；3=交易失败；4=状态未知
        :type TradeStatus: int
        :param _ThirdChannelOrderId: 第三方支付机构支付交易号
注意：此字段可能返回 null，表示取不到有效值。
        :type ThirdChannelOrderId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsSuccess = None
        self._TradeSerialNo = None
        self._TradeMsg = None
        self._TradeStatus = None
        self._ThirdChannelOrderId = None
        self._RequestId = None

    @property
    def IsSuccess(self):
        """请求成功状态
        :rtype: bool
        """
        return self._IsSuccess

    @IsSuccess.setter
    def IsSuccess(self, IsSuccess):
        self._IsSuccess = IsSuccess

    @property
    def TradeSerialNo(self):
        """交易流水号
        :rtype: str
        """
        return self._TradeSerialNo

    @TradeSerialNo.setter
    def TradeSerialNo(self, TradeSerialNo):
        self._TradeSerialNo = TradeSerialNo

    @property
    def TradeMsg(self):
        """交易备注
        :rtype: str
        """
        return self._TradeMsg

    @TradeMsg.setter
    def TradeMsg(self, TradeMsg):
        self._TradeMsg = TradeMsg

    @property
    def TradeStatus(self):
        """交易状态：0=交易待处理；1=交易处理中；2=交易处理成功；3=交易失败；4=状态未知
        :rtype: int
        """
        return self._TradeStatus

    @TradeStatus.setter
    def TradeStatus(self, TradeStatus):
        self._TradeStatus = TradeStatus

    @property
    def ThirdChannelOrderId(self):
        """第三方支付机构支付交易号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ThirdChannelOrderId

    @ThirdChannelOrderId.setter
    def ThirdChannelOrderId(self, ThirdChannelOrderId):
        self._ThirdChannelOrderId = ThirdChannelOrderId

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsSuccess = params.get("IsSuccess")
        self._TradeSerialNo = params.get("TradeSerialNo")
        self._TradeMsg = params.get("TradeMsg")
        self._TradeStatus = params.get("TradeStatus")
        self._ThirdChannelOrderId = params.get("ThirdChannelOrderId")
        self._RequestId = params.get("RequestId")


class MigrateOrderRefundRequest(AbstractModel):
    """MigrateOrderRefund请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantId: 商户代码
        :type MerchantId: str
        :param _PayChannel: 支付渠道，ALIPAY对应支付宝渠道；UNIONPAY对应银联渠道
        :type PayChannel: str
        :param _PayOrderId: 正向支付商户订单号
        :type PayOrderId: str
        :param _RefundOrderId: 退款订单号，最长64位，仅支持数字、 字母
        :type RefundOrderId: str
        :param _RefundAmt: 退款金额，单位：分。备注：改字段必须大于0 和小于10000000000的整数。
        :type RefundAmt: int
        :param _ThirdChannelOrderId: 第三方支付机构支付交易号
        :type ThirdChannelOrderId: str
        :param _PayAmt: 原始支付金额，单位：分。备注：当该字段为空或者为0 时，系统会默认使用订单当 实付金额作为退款金额
        :type PayAmt: int
        :param _Profile: 接入环境。沙箱环境填 sandbox。
        :type Profile: str
        :param _RefundReason: 退款原因
        :type RefundReason: str
        """
        self._MerchantId = None
        self._PayChannel = None
        self._PayOrderId = None
        self._RefundOrderId = None
        self._RefundAmt = None
        self._ThirdChannelOrderId = None
        self._PayAmt = None
        self._Profile = None
        self._RefundReason = None

    @property
    def MerchantId(self):
        """商户代码
        :rtype: str
        """
        return self._MerchantId

    @MerchantId.setter
    def MerchantId(self, MerchantId):
        self._MerchantId = MerchantId

    @property
    def PayChannel(self):
        """支付渠道，ALIPAY对应支付宝渠道；UNIONPAY对应银联渠道
        :rtype: str
        """
        return self._PayChannel

    @PayChannel.setter
    def PayChannel(self, PayChannel):
        self._PayChannel = PayChannel

    @property
    def PayOrderId(self):
        """正向支付商户订单号
        :rtype: str
        """
        return self._PayOrderId

    @PayOrderId.setter
    def PayOrderId(self, PayOrderId):
        self._PayOrderId = PayOrderId

    @property
    def RefundOrderId(self):
        """退款订单号，最长64位，仅支持数字、 字母
        :rtype: str
        """
        return self._RefundOrderId

    @RefundOrderId.setter
    def RefundOrderId(self, RefundOrderId):
        self._RefundOrderId = RefundOrderId

    @property
    def RefundAmt(self):
        """退款金额，单位：分。备注：改字段必须大于0 和小于10000000000的整数。
        :rtype: int
        """
        return self._RefundAmt

    @RefundAmt.setter
    def RefundAmt(self, RefundAmt):
        self._RefundAmt = RefundAmt

    @property
    def ThirdChannelOrderId(self):
        """第三方支付机构支付交易号
        :rtype: str
        """
        return self._ThirdChannelOrderId

    @ThirdChannelOrderId.setter
    def ThirdChannelOrderId(self, ThirdChannelOrderId):
        self._ThirdChannelOrderId = ThirdChannelOrderId

    @property
    def PayAmt(self):
        """原始支付金额，单位：分。备注：当该字段为空或者为0 时，系统会默认使用订单当 实付金额作为退款金额
        :rtype: int
        """
        return self._PayAmt

    @PayAmt.setter
    def PayAmt(self, PayAmt):
        self._PayAmt = PayAmt

    @property
    def Profile(self):
        """接入环境。沙箱环境填 sandbox。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def RefundReason(self):
        """退款原因
        :rtype: str
        """
        return self._RefundReason

    @RefundReason.setter
    def RefundReason(self, RefundReason):
        self._RefundReason = RefundReason


    def _deserialize(self, params):
        self._MerchantId = params.get("MerchantId")
        self._PayChannel = params.get("PayChannel")
        self._PayOrderId = params.get("PayOrderId")
        self._RefundOrderId = params.get("RefundOrderId")
        self._RefundAmt = params.get("RefundAmt")
        self._ThirdChannelOrderId = params.get("ThirdChannelOrderId")
        self._PayAmt = params.get("PayAmt")
        self._Profile = params.get("Profile")
        self._RefundReason = params.get("RefundReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigrateOrderRefundResponse(AbstractModel):
    """MigrateOrderRefund返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsSuccess: 请求成功状态
        :type IsSuccess: bool
        :param _TradeSerialNo: 退款流水号
        :type TradeSerialNo: str
        :param _TradeMsg: 交易备注
        :type TradeMsg: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsSuccess = None
        self._TradeSerialNo = None
        self._TradeMsg = None
        self._RequestId = None

    @property
    def IsSuccess(self):
        """请求成功状态
        :rtype: bool
        """
        return self._IsSuccess

    @IsSuccess.setter
    def IsSuccess(self, IsSuccess):
        self._IsSuccess = IsSuccess

    @property
    def TradeSerialNo(self):
        """退款流水号
        :rtype: str
        """
        return self._TradeSerialNo

    @TradeSerialNo.setter
    def TradeSerialNo(self, TradeSerialNo):
        self._TradeSerialNo = TradeSerialNo

    @property
    def TradeMsg(self):
        """交易备注
        :rtype: str
        """
        return self._TradeMsg

    @TradeMsg.setter
    def TradeMsg(self, TradeMsg):
        self._TradeMsg = TradeMsg

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsSuccess = params.get("IsSuccess")
        self._TradeSerialNo = params.get("TradeSerialNo")
        self._TradeMsg = params.get("TradeMsg")
        self._RequestId = params.get("RequestId")


class ModifyAgentTaxPaymentInfoRequest(AbstractModel):
    """ModifyAgentTaxPaymentInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchNum: 批次号
        :type BatchNum: int
        :param _RawElectronicCertUrl: 新源电子凭证地址
        :type RawElectronicCertUrl: str
        :param _FileName: 新的文件名
        :type FileName: str
        :param _Profile: 接入环境。沙箱环境填sandbox
        :type Profile: str
        """
        self._BatchNum = None
        self._RawElectronicCertUrl = None
        self._FileName = None
        self._Profile = None

    @property
    def BatchNum(self):
        """批次号
        :rtype: int
        """
        return self._BatchNum

    @BatchNum.setter
    def BatchNum(self, BatchNum):
        self._BatchNum = BatchNum

    @property
    def RawElectronicCertUrl(self):
        """新源电子凭证地址
        :rtype: str
        """
        return self._RawElectronicCertUrl

    @RawElectronicCertUrl.setter
    def RawElectronicCertUrl(self, RawElectronicCertUrl):
        self._RawElectronicCertUrl = RawElectronicCertUrl

    @property
    def FileName(self):
        """新的文件名
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def Profile(self):
        """接入环境。沙箱环境填sandbox
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._BatchNum = params.get("BatchNum")
        self._RawElectronicCertUrl = params.get("RawElectronicCertUrl")
        self._FileName = params.get("FileName")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAgentTaxPaymentInfoResponse(AbstractModel):
    """ModifyAgentTaxPaymentInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentTaxPaymentBatch: 代理商完税证明批次信息
        :type AgentTaxPaymentBatch: :class:`tencentcloud.cpdp.v20190820.models.AgentTaxPaymentBatch`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AgentTaxPaymentBatch = None
        self._RequestId = None

    @property
    def AgentTaxPaymentBatch(self):
        """代理商完税证明批次信息
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.AgentTaxPaymentBatch`
        """
        return self._AgentTaxPaymentBatch

    @AgentTaxPaymentBatch.setter
    def AgentTaxPaymentBatch(self, AgentTaxPaymentBatch):
        self._AgentTaxPaymentBatch = AgentTaxPaymentBatch

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AgentTaxPaymentBatch") is not None:
            self._AgentTaxPaymentBatch = AgentTaxPaymentBatch()
            self._AgentTaxPaymentBatch._deserialize(params.get("AgentTaxPaymentBatch"))
        self._RequestId = params.get("RequestId")


class ModifyBindedAccountRequest(AbstractModel):
    """ModifyBindedAccount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AnchorId: 主播Id
        :type AnchorId: str
        :param _TransferType: 1 微信企业付款 
2 支付宝转账 
3 平安银企直连代发转账
        :type TransferType: int
        :param _AccountNo: 收款方标识。
微信为open_id；
支付宝为会员alipay_user_id;
平安为收款方银行账号;
        :type AccountNo: str
        :param _PhoneNum: 手机号
        :type PhoneNum: str
        """
        self._AnchorId = None
        self._TransferType = None
        self._AccountNo = None
        self._PhoneNum = None

    @property
    def AnchorId(self):
        """主播Id
        :rtype: str
        """
        return self._AnchorId

    @AnchorId.setter
    def AnchorId(self, AnchorId):
        self._AnchorId = AnchorId

    @property
    def TransferType(self):
        """1 微信企业付款 
2 支付宝转账 
3 平安银企直连代发转账
        :rtype: int
        """
        return self._TransferType

    @TransferType.setter
    def TransferType(self, TransferType):
        self._TransferType = TransferType

    @property
    def AccountNo(self):
        """收款方标识。
微信为open_id；
支付宝为会员alipay_user_id;
平安为收款方银行账号;
        :rtype: str
        """
        return self._AccountNo

    @AccountNo.setter
    def AccountNo(self, AccountNo):
        self._AccountNo = AccountNo

    @property
    def PhoneNum(self):
        """手机号
        :rtype: str
        """
        return self._PhoneNum

    @PhoneNum.setter
    def PhoneNum(self, PhoneNum):
        self._PhoneNum = PhoneNum


    def _deserialize(self, params):
        self._AnchorId = params.get("AnchorId")
        self._TransferType = params.get("TransferType")
        self._AccountNo = params.get("AccountNo")
        self._PhoneNum = params.get("PhoneNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBindedAccountResponse(AbstractModel):
    """ModifyBindedAccount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。响应成功："SUCCESS"，其他为不成功。
        :type ErrCode: str
        :param _ErrMessage: 响应消息。
        :type ErrMessage: str
        :param _Result: 该字段为null。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。响应成功："SUCCESS"，其他为不成功。
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """响应消息。
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """该字段为null。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ModifyFlexFundingAccountRequest(AbstractModel):
    """ModifyFlexFundingAccount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _FundingAccountBindSerialNo: 收款用户资金账户ID
        :type FundingAccountBindSerialNo: str
        :param _FundingAccountType: 资金账户类型
PINGAN_BANK:平安银行
        :type FundingAccountType: str
        :param _PhoneNo: 收款资金账户手机号
        :type PhoneNo: str
        :param _FundingAccountName: 收款资金账户姓名
        :type FundingAccountName: str
        :param _FundingAccountNo: 收款资金账户号
        :type FundingAccountNo: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        :param _BankBranchName: 开户支行名
        :type BankBranchName: str
        """
        self._PayeeId = None
        self._FundingAccountBindSerialNo = None
        self._FundingAccountType = None
        self._PhoneNo = None
        self._FundingAccountName = None
        self._FundingAccountNo = None
        self._Environment = None
        self._BankBranchName = None

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def FundingAccountBindSerialNo(self):
        """收款用户资金账户ID
        :rtype: str
        """
        return self._FundingAccountBindSerialNo

    @FundingAccountBindSerialNo.setter
    def FundingAccountBindSerialNo(self, FundingAccountBindSerialNo):
        self._FundingAccountBindSerialNo = FundingAccountBindSerialNo

    @property
    def FundingAccountType(self):
        """资金账户类型
PINGAN_BANK:平安银行
        :rtype: str
        """
        return self._FundingAccountType

    @FundingAccountType.setter
    def FundingAccountType(self, FundingAccountType):
        self._FundingAccountType = FundingAccountType

    @property
    def PhoneNo(self):
        """收款资金账户手机号
        :rtype: str
        """
        return self._PhoneNo

    @PhoneNo.setter
    def PhoneNo(self, PhoneNo):
        self._PhoneNo = PhoneNo

    @property
    def FundingAccountName(self):
        """收款资金账户姓名
        :rtype: str
        """
        return self._FundingAccountName

    @FundingAccountName.setter
    def FundingAccountName(self, FundingAccountName):
        self._FundingAccountName = FundingAccountName

    @property
    def FundingAccountNo(self):
        """收款资金账户号
        :rtype: str
        """
        return self._FundingAccountNo

    @FundingAccountNo.setter
    def FundingAccountNo(self, FundingAccountNo):
        self._FundingAccountNo = FundingAccountNo

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment

    @property
    def BankBranchName(self):
        """开户支行名
        :rtype: str
        """
        return self._BankBranchName

    @BankBranchName.setter
    def BankBranchName(self, BankBranchName):
        self._BankBranchName = BankBranchName


    def _deserialize(self, params):
        self._PayeeId = params.get("PayeeId")
        self._FundingAccountBindSerialNo = params.get("FundingAccountBindSerialNo")
        self._FundingAccountType = params.get("FundingAccountType")
        self._PhoneNo = params.get("PhoneNo")
        self._FundingAccountName = params.get("FundingAccountName")
        self._FundingAccountNo = params.get("FundingAccountNo")
        self._Environment = params.get("Environment")
        self._BankBranchName = params.get("BankBranchName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyFlexFundingAccountResponse(AbstractModel):
    """ModifyFlexFundingAccount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """无
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ModifyFlexPayeeAccountRightStatusRequest(AbstractModel):
    """ModifyFlexPayeeAccountRightStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PayeeId: 收款用户ID
        :type PayeeId: str
        :param _AccountRightType: 账户权益类型
SETTLEMENT:结算权益
PAYMENT:付款权益
        :type AccountRightType: str
        :param _AccountRightStatus: 账户权益状态
ENABLE:启用
DISABLE:停用
        :type AccountRightStatus: str
        :param _Environment: 环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :type Environment: str
        """
        self._PayeeId = None
        self._AccountRightType = None
        self._AccountRightStatus = None
        self._Environment = None

    @property
    def PayeeId(self):
        """收款用户ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def AccountRightType(self):
        """账户权益类型
SETTLEMENT:结算权益
PAYMENT:付款权益
        :rtype: str
        """
        return self._AccountRightType

    @AccountRightType.setter
    def AccountRightType(self, AccountRightType):
        self._AccountRightType = AccountRightType

    @property
    def AccountRightStatus(self):
        """账户权益状态
ENABLE:启用
DISABLE:停用
        :rtype: str
        """
        return self._AccountRightStatus

    @AccountRightStatus.setter
    def AccountRightStatus(self, AccountRightStatus):
        self._AccountRightStatus = AccountRightStatus

    @property
    def Environment(self):
        """环境类型
__release__:生产环境
__sandbox__:沙箱环境
__test__:测试环境
缺省默认为生产环境
        :rtype: str
        """
        return self._Environment

    @Environment.setter
    def Environment(self, Environment):
        self._Environment = Environment


    def _deserialize(self, params):
        self._PayeeId = params.get("PayeeId")
        self._AccountRightType = params.get("AccountRightType")
        self._AccountRightStatus = params.get("AccountRightStatus")
        self._Environment = params.get("Environment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyFlexPayeeAccountRightStatusResponse(AbstractModel):
    """ModifyFlexPayeeAccountRightStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码。SUCCESS为成功，其他为失败
        :type ErrCode: str
        :param _ErrMessage: 错误消息
        :type ErrMessage: str
        :param _Result: 返回结果。默认为空。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMessage = None
        self._Result = None
        self._RequestId = None

    @property
    def ErrCode(self):
        """错误码。SUCCESS为成功，其他为失败
        :rtype: str
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMessage(self):
        """错误消息
        :rtype: str
        """
        return self._ErrMessage

    @ErrMessage.setter
    def ErrMessage(self, ErrMessage):
        self._ErrMessage = ErrMessage

    @property
    def Result(self):
        """返回结果。默认为空。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMessage = params.get("ErrMessage")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ModifyMerchantRequest(AbstractModel):
    """ModifyMerchant请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MerchantAppId: 进件成功后返给商户的AppId
        :type MerchantAppId: str
        :param _MerchantName: 收款商户名称
        :type MerchantName: str
        :param _BusinessPayFlag: B2B 支付标志。是否开通 B2B支付， 1:开通 0:不开通。
        :type BusinessPayFlag: str
        """
        self._MerchantAppId = None
        self._MerchantName = None
        self._BusinessPayFlag = None

    @property
    def MerchantAppId(self):
        """进件成功后返给商户的AppId
        :rtype: str
        """
        return self._MerchantAppId

    @MerchantAppId.setter
    def MerchantAppId(self, MerchantAppId):
        self._MerchantAppId = MerchantAppId

    @property
    def MerchantName(self):
        """收款商户名称
        :rtype: str
        """
        return self._MerchantName

    @MerchantName.setter
    def MerchantName(self, MerchantName):
        self._MerchantName = MerchantName

    @property
    def BusinessPayFlag(self):
        """B2B 支付标志。是否开通 B2B支付， 1:开通 0:不开通。
        :rtype: str
        """
        return self._BusinessPayFlag

    @BusinessPayFlag.setter
    def BusinessPayFlag(self, BusinessPayFlag):
        self._BusinessPayFlag = BusinessPayFlag


    def _deserialize(self, params):
        self._MerchantAppId = params.get("MerchantAppId")
        self._MerchantName = params.get("MerchantName")
        self._BusinessPayFlag = params.get("BusinessPayFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMerchantResponse(AbstractModel):
    """ModifyMerchant返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyMntMbrBindRelateAcctBankCodeRequest(AbstractModel):
    """ModifyMntMbrBindRelateAcctBankCode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MrchCode: String(22)，商户号（签约客户号）
        :type MrchCode: str
        :param _SubAcctNo: STRING(50)，见证子账户的账号
        :type SubAcctNo: str
        :param _MemberBindAcctNo: STRING(50)，会员绑定账号
        :type MemberBindAcctNo: str
        :param _AcctOpenBranchName: STRING(150)，开户行名称（若大小额行号不填则送超级网银号对应的银行名称，若填大小额行号则送大小额行号对应的银行名称）
        :type AcctOpenBranchName: str
        :param _CnapsBranchId: STRING(20)，大小额行号（CnapsBranchId和EiconBankBranchId两者二选一必填）
        :type CnapsBranchId: str
        :param _EiconBankBranchId: STRING(20)，超级网银行号
        :type EiconBankBranchId: str
        :param _ReservedMsg: STRING(1027)，保留域
        :type ReservedMsg: str
        :param _Profile: STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :type Profile: str
        """
        self._MrchCode = None
        self._SubAcctNo = None
        self._MemberBindAcctNo = None
        self._AcctOpenBranchName = None
        self._CnapsBranchId = None
        self._EiconBankBranchId = None
        self._ReservedMsg = None
        self._Profile = None

    @property
    def MrchCode(self):
        """String(22)，商户号（签约客户号）
        :rtype: str
        """
        return self._MrchCode

    @MrchCode.setter
    def MrchCode(self, MrchCode):
        self._MrchCode = MrchCode

    @property
    def SubAcctNo(self):
        """STRING(50)，见证子账户的账号
        :rtype: str
        """
        return self._SubAcctNo

    @SubAcctNo.setter
    def SubAcctNo(self, SubAcctNo):
        self._SubAcctNo = SubAcctNo

    @property
    def MemberBindAcctNo(self):
        """STRING(50)，会员绑定账号
        :rtype: str
        """
        return self._MemberBindAcctNo

    @MemberBindAcctNo.setter
    def MemberBindAcctNo(self, MemberBindAcctNo):
        self._MemberBindAcctNo = MemberBindAcctNo

    @property
    def AcctOpenBranchName(self):
        """STRING(150)，开户行名称（若大小额行号不填则送超级网银号对应的银行名称，若填大小额行号则送大小额行号对应的银行名称）
        :rtype: str
        """
        return self._AcctOpenBranchName

    @AcctOpenBranchName.setter
    def AcctOpenBranchName(self, AcctOpenBranchName):
        self._AcctOpenBranchName = AcctOpenBranchName

    @property
    def CnapsBranchId(self):
        """STRING(20)，大小额行号（CnapsBranchId和EiconBankBranchId两者二选一必填）
        :rtype: str
        """
        return self._CnapsBranchId

    @CnapsBranchId.setter
    def CnapsBranchId(self, CnapsBranchId):
        self._CnapsBranchId = CnapsBranchId

    @property
    def EiconBankBranchId(self):
        """STRING(20)，超级网银行号
        :rtype: str
        """
        return self._EiconBankBranchId

    @EiconBankBranchId.setter
    def EiconBankBranchId(self, EiconBankBranchId):
        self._EiconBankBranchId = EiconBankBranchId

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def Profile(self):
        """STRING(12)，接入环境，默认接入沙箱环境。接入正式环境填"prod"
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile


    def _deserialize(self, params):
        self._MrchCode = params.get("MrchCode")
        self._SubAcctNo = params.get("SubAcctNo")
        self._MemberBindAcctNo = params.get("MemberBindAcctNo")
        self._AcctOpenBranchName = params.get("AcctOpenBranchName")
        self._CnapsBranchId = params.get("CnapsBranchId")
        self._EiconBankBranchId = params.get("EiconBankBranchId")
        self._ReservedMsg = params.get("ReservedMsg")
        self._Profile = params.get("Profile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMntMbrBindRelateAcctBankCodeResponse(AbstractModel):
    """ModifyMntMbrBindRelateAcctBankCode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TxnReturnCode: String(20)，返回码
        :type TxnReturnCode: str
        :param _TxnReturnMsg: String(100)，返回信息
        :type TxnReturnMsg: str
        :param _CnsmrSeqNo: String(22)，交易流水号
        :type CnsmrSeqNo: str
        :param _ReservedMsg: STRING(1027)，保留域
注意：此字段可能返回 null，表示取不到有效值。
        :type ReservedMsg: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TxnReturnCode = None
        self._TxnReturnMsg = None
        self._CnsmrSeqNo = None
        self._ReservedMsg = None
        self._RequestId = None

    @property
    def TxnReturnCode(self):
        """String(20)，返回码
        :rtype: str
        """
        return self._TxnReturnCode

    @TxnReturnCode.setter
    def TxnReturnCode(self, TxnReturnCode):
        self._TxnReturnCode = TxnReturnCode

    @property
    def TxnReturnMsg(self):
        """String(100)，返回信息
        :rtype: str
        """
        return self._TxnReturnMsg

    @TxnReturnMsg.setter
    def TxnReturnMsg(self, TxnReturnMsg):
        self._TxnReturnMsg = TxnReturnMsg

    @property
    def CnsmrSeqNo(self):
        """String(22)，交易流水号
        :rtype: str
        """
        return self._CnsmrSeqNo

    @CnsmrSeqNo.setter
    def CnsmrSeqNo(self, CnsmrSeqNo):
        self._CnsmrSeqNo = CnsmrSeqNo

    @property
    def ReservedMsg(self):
        """STRING(1027)，保留域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ReservedMsg

    @ReservedMsg.setter
    def ReservedMsg(self, ReservedMsg):
        self._ReservedMsg = ReservedMsg

    @property
    def RequestId(self):
        """唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TxnReturnCode = params.get("TxnReturnCode")
        self._TxnReturnMsg = params.get("TxnReturnMsg")
        self._CnsmrSeqNo = params.get("CnsmrSeqNo")
        self._ReservedMsg = params.get("ReservedMsg")
        self._RequestId = params.get("RequestId")


class MultiApplyDetail(AbstractModel):
    """分账明细

    """

    def __init__(self):
        r"""
        :param _MerchantNo: 商户编号
        :type MerchantNo: str
        :param _Amount: 分账金额
        :type Amount: str
        :param _Remark: 备注
        :type Remark: str
        """
        self._MerchantNo = None
        self._Amount = None
        self._Remark = None

    @property
    def MerchantNo(self):
        """商户编号
        :rtype: str
        """
        return self._MerchantNo

    @MerchantNo.setter
    def MerchantNo(self, MerchantNo):
        self._MerchantNo = MerchantNo

    @property
    def Amount(self):
        """分账金额
        :rtype: str
        """
        return self._Amount

    @Amount.setter
    def Amount(self, Amount):
        self._Amount = Amount

    @property
    def Remark(self):
        """备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._MerchantNo = params.get("MerchantNo")
        self._Amount = params.get("Amount")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MultiApplyOrder(AbstractModel):
    """分账订单信息

    """

    def __init__(self):
        r"""
        :param _OutDistributeNo: 商户分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OutDistributeNo: str
        :param _DistributeNo: 平台分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :type DistributeNo: str
        :param _OrderNo: 平台交易订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OrderNo: str
        :param _Status: 分账订单状态（0初始1成功2失败3撤销）
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _InDate: 入账日期，格式yyyy-MM-dd
注意：此字段可能返回 null，表示取不到有效值。
        :type InDate: str
        :param _Remark: 备注
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        :param _Details: 分账明细
注意：此字段可能返回 null，表示取不到有效值。
        :type Details: list of MultiApplyDetail
        """
        self._OutDistributeNo = None
        self._DistributeNo = None
        self._OrderNo = None
        self._Status = None
        self._InDate = None
        self._Remark = None
        self._Details = None

    @property
    def OutDistributeNo(self):
        """商户分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OutDistributeNo

    @OutDistributeNo.setter
    def OutDistributeNo(self, OutDistributeNo):
        self._OutDistributeNo = OutDistributeNo

    @property
    def DistributeNo(self):
        """平台分账单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DistributeNo

    @DistributeNo.setter
    def DistributeNo(self, DistributeNo):
        self._DistributeNo = DistributeNo

    @property
    def OrderNo(self):
        """平台交易订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo

    @property
    def Status(self):
        """分账订单状态（0初始1成功2失败3撤销）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InDate(self):
        """入账日期，格式yyyy-MM-dd
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InDate

    @InDate.setter
    def InDate(self, InDate):
        self._InDate = InDate

    @property
    def Remark(self):
        """备注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Details(self):
        """分账明细
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of MultiApplyDetail
        """
        return self._Details

    @Details.setter
    def Details(self, Details):
        self._Details = Details


    def _deserialize(self, params):
        self._OutDistributeNo = params.get("OutDistributeNo")
        self._DistributeNo = params.get("DistributeNo")
        self._OrderNo = params.get("OrderNo")
        self._Status = params.get("Status")
        self._InDate = params.get("InDate")
        self._Remark = params.get("Remark")
        if params.get("Details") is not None:
            self._Details = []
            for item in params.get("Details"):
                obj = MultiApplyDetail()
                obj._deserialize(item)
                self._Details.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NaturalPersonInfo(AbstractModel):
    """自然人信息

    """

    def __init__(self):
        r"""
        :param _PersonType: 自然人类型 
2：商户负责人 
3：授权经办人
4：业务联系人 
5：实际控制人 
6：控股股东 
7：受益人 
8：结算人
注意：HELIPAY渠道必传业务联系人
        :type PersonType: str
        :param _IdType: 证件类型 
IDCARD：身份证 
PASSPORT：护照 SOLDIERSCERTIFICATE：士兵证 OFFICERSCERTIFICATE：军官证 GATXCERTIFICATE：香港居民来往内地通行证 TWNDCERTIFICATE：台湾同胞来往内地通行证 MACAOCERTIFICATE：澳门来往内地通行证
        :type IdType: str
        :param _IdNumber: 证件号码
        :type IdNumber: str
        :param _PersonName: 姓名
        :type PersonName: str
        :param _IdValidityType: 证件有效期类型 
LONGTERM：长期有效 
OTHER：非长期有效
        :type IdValidityType: str
        :param _IdEffectiveDate: 证件生效日期，yyyy-MM-dd
        :type IdEffectiveDate: str
        :param _IdExpireDate: 证件失效日期，yyyy-MM-dd
        :type IdExpireDate: str
        :param _ContactPhone: 联系电话，HELIPAY渠道业务联系人必传
        :type ContactPhone: str
        :param _ContactAddress: 联系地址
        :type ContactAddress: str
        :param _EmailAddress: 邮箱地址
        :type EmailAddress: str
        """
        self._PersonType = None
        self._IdType = None
        self._IdNumber = None
        self._PersonName = None
        self._IdValidityType = None
        self._IdEffectiveDate = None
        self._IdExpireDate = None
        self._ContactPhone = None
        self._ContactAddress = None
        self._EmailAddress = None

    @property
    def PersonType(self):
        """自然人类型 
2：商户负责人 
3：授权经办人
4：业务联系人 
5：实际控制人 
6：控股股东 
7：受益人 
8：结算人
注意：HELIPAY渠道必传业务联系人
        :rtype: str
        """
        return self._PersonType

    @PersonType.setter
    def PersonType(self, PersonType):
        self._PersonType = PersonType

    @property
    def IdType(self):
        """证件类型 
IDCARD：身份证 
PASSPORT：护照 SOLDIERSCERTIFICATE：士兵证 OFFICERSCERTIFICATE：军官证 GATXCERTIFICATE：香港居民来往内地通行证 TWNDCERTIFICATE：台湾同胞来往内地通行证 MACAOCERTIFICATE：澳门来往内地通行证
        :rtype: str
        """
        return self._IdType

    @IdType.setter
    def IdType(self, IdType):
        self._IdType = IdType

    @property
    def IdNumber(self):
        """证件号码
        :rtype: str
        """
        return self._IdNumber

    @IdNumber.setter
    def IdNumber(self, IdNumber):
        self._IdNumber = IdNumber

    @property
    def PersonName(self):
        """姓名
        :rtype: str
        """
        return self._PersonName

    @PersonName.setter
    def PersonName(self, PersonName):
        self._PersonName = PersonName

    @property
    def IdValidityType(self):
        """证件有效期类型 
LONGTERM：长期有效 
OTHER：非长期有效
        :rtype: str
        """
        return self._IdValidityType

    @IdValidityType.setter
    def IdValidityType(self, IdValidityType):
        self._IdValidityType = IdValidityType

    @property
    def IdEffectiveDate(self):
        """证件生效日期，yyyy-MM-dd
        :rtype: str
        """
        return self._IdEffectiveDate

    @IdEffectiveDate.setter
    def IdEffectiveDate(self, IdEffectiveDate):
        self._IdEffectiveDate = IdEffectiveDate

    @property
    def IdExpireDate(self):
        """证件失效日期，yyyy-MM-dd
        :rtype: str
        """
        return self._IdExpireDate

    @IdExpireDate.setter
    def IdExpireDate(self, IdExpireDate):
        self._IdExpireDate = IdExpireDate

    @property
    def ContactPhone(self):
        """联系电话，HELIPAY渠道业务联系人必传
        :rtype: str
        """
        return self._ContactPhone

    @ContactPhone.setter
    def ContactPhone(self, ContactPhone):
        self._ContactPhone = ContactPhone

    @property
    def ContactAddress(self):
        """联系地址
        :rtype: str
        """
        return self._ContactAddress

    @ContactAddress.setter
    def ContactAddress(self, ContactAddress):
        self._ContactAddress = ContactAddress

    @property
    def EmailAddress(self):
        """邮箱地址
        :rtype: str
        """
        return self._EmailAddress

    @EmailAddress.setter
    def EmailAddress(self, EmailAddress):
        self._EmailAddress = EmailAddress


    def _deserialize(self, params):
        self._PersonType = params.get("PersonType")
        self._IdType = params.get("IdType")
        self._IdNumber = params.get("IdNumber")
        self._PersonName = params.get("PersonName")
        self._IdValidityType = params.get("IdValidityType")
        self._IdEffectiveDate = params.get("IdEffectiveDate")
        self._IdExpireDate = params.get("IdExpireDate")
        self._ContactPhone = params.get("ContactPhone")
        self._ContactAddress = params.get("ContactAddress")
        self._EmailAddress = params.get("EmailAddress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OldAttachmentInfo(AbstractModel):
    """附加项信息

    """

    def __init__(self):
        r"""
        :param _AttachmentAmount: 附加项金额
注意：此字段可能返回 null，表示取不到有效值。
        :type AttachmentAmount: int
        :param _AttachmentType: 附加项类型
注意：此字段可能返回 null，表示取不到有效值。
        :type AttachmentType: str
        :param _AttachmentName: 附加项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type AttachmentName: str
        :param _AttachmentCode: 附加项编号
注意：此字段可能返回 null，表示取不到有效值。
        :type AttachmentCode: str
        """
        self._AttachmentAmount = None
        self._AttachmentType = None
        self._AttachmentName = None
        self._AttachmentCode = None

    @property
    def AttachmentAmount(self):
        """附加项金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AttachmentAmount

    @AttachmentAmount.setter
    def AttachmentAmount(self, AttachmentAmount):
        self._AttachmentAmount = AttachmentAmount

    @property
    def AttachmentType(self):
        """附加项类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AttachmentType

    @AttachmentType.setter
    def AttachmentType(self, AttachmentType):
        self._AttachmentType = AttachmentType

    @property
    def AttachmentName(self):
        """附加项名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AttachmentName

    @AttachmentName.setter
    def AttachmentName(self, AttachmentName):
        self._AttachmentName = AttachmentName

    @property
    def AttachmentCode(self):
        """附加项编号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AttachmentCode

    @AttachmentCode.setter
    def AttachmentCode(self, AttachmentCode):
        self._AttachmentCode = AttachmentCode


    def _deserialize(self, params):
        self._AttachmentAmount = params.get("AttachmentAmount")
        self._AttachmentType = params.get("AttachmentType")
        self._AttachmentName = params.get("AttachmentName")
        self._AttachmentCode = params.get("AttachmentCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OldChannelExternalUserInfo(AbstractModel):
    """渠道方用户信息

    """

    def __init__(self):
        r"""
        :param _ChannelExternalUserType: 渠道方用户类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExternalUserType: str
        :param _ChannelExternalUserId: 渠道方用户ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExternalUserId: str
        """
        self._ChannelExternalUserType = None
        self._ChannelExternalUserId = None

    @property
    def ChannelExternalUserType(self):
        """渠道方用户类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelExternalUserType

    @ChannelExternalUserType.setter
    def ChannelExternalUserType(self, ChannelExternalUserType):
        self._ChannelExternalUserType = ChannelExternalUserType

    @property
    def ChannelExternalUserId(self):
        """渠道方用户ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelExternalUserId

    @ChannelExternalUserId.setter
    def ChannelExternalUserId(self, ChannelExternalUserId):
        self._ChannelExternalUserId = ChannelExternalUserId


    def _deserialize(self, params):
        self._ChannelExternalUserType = params.get("ChannelExternalUserType")
        self._ChannelExternalUserId = params.get("ChannelExternalUserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OldSubRefund(AbstractModel):
    """子单退款信息

    """

    def __init__(self):
        r"""
        :param _ChannelExternalRefundId: 支付机构退款流水号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExternalRefundId: str
        :param _ChannelExternalOrderId: 支付机构支付订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExternalOrderId: str
        :param _ChannelRefundId: 渠道退款订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelRefundId: str
        :param _SubOutTradeNo: 子订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type SubOutTradeNo: str
        :param _RefundAmt: 子单退款金额
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundAmt: str
        """
        self._ChannelExternalRefundId = None
        self._ChannelExternalOrderId = None
        self._ChannelRefundId = None
        self._SubOutTradeNo = None
        self._RefundAmt = None

    @property
    def ChannelExternalRefundId(self):
        """支付机构退款流水号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelExternalRefundId

    @ChannelExternalRefundId.setter
    def ChannelExternalRefundId(self, ChannelExternalRefundId):
        self._ChannelExternalRefundId = ChannelExternalRefundId

    @property
    def ChannelExternalOrderId(self):
        """支付机构支付订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelExternalOrderId

    @ChannelExternalOrderId.setter
    def ChannelExternalOrderId(self, ChannelExternalOrderId):
        self._ChannelExternalOrderId = ChannelExternalOrderId

    @property
    def ChannelRefundId(self):
        """渠道退款订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelRefundId

    @ChannelRefundId.setter
    def ChannelRefundId(self, ChannelRefundId):
        self._ChannelRefundId = ChannelRefundId

    @property
    def SubOutTradeNo(self):
        """子订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubOutTradeNo

    @SubOutTradeNo.setter
    def SubOutTradeNo(self, SubOutTradeNo):
        self._SubOutTradeNo = SubOutTradeNo

    @property
    def RefundAmt(self):
        """子单退款金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RefundAmt

    @RefundAmt.setter
    def RefundAmt(self, RefundAmt):
        self._RefundAmt = RefundAmt


    def _deserialize(self, params):
        self._ChannelExternalRefundId = params.get("ChannelExternalRefundId")
        self._ChannelExternalOrderId = params.get("ChannelExternalOrderId")
        self._ChannelRefundId = params.get("ChannelRefundId")
        self._SubOutTradeNo = params.get("SubOutTradeNo")
        self._RefundAmt = params.get("RefundAmt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankApprovalGuideInfo(AbstractModel):
    """银行复核指引。银行侧返回网银授权指引链接，一般PC网银，手机网银链接

    """

    def __init__(self):
        r"""
        :param _PcGuideUrl: PC网银指引
        :type PcGuideUrl: str
        :param _MobileGuideUrl: 手机网银指引
注意：此字段可能返回 null，表示取不到有效值。
        :type MobileGuideUrl: str
        """
        self._PcGuideUrl = None
        self._MobileGuideUrl = None

    @property
    def PcGuideUrl(self):
        """PC网银指引
        :rtype: str
        """
        return self._PcGuideUrl

    @PcGuideUrl.setter
    def PcGuideUrl(self, PcGuideUrl):
        self._PcGuideUrl = PcGuideUrl

    @property
    def MobileGuideUrl(self):
        """手机网银指引
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MobileGuideUrl

    @MobileGuideUrl.setter
    def MobileGuideUrl(self, MobileGuideUrl):
        self._MobileGuideUrl = MobileGuideUrl


    def _deserialize(self, params):
        self._PcGuideUrl = params.get("PcGuideUrl")
        self._MobileGuideUrl = params.get("MobileGuideUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankBillingInfo(AbstractModel):
    """云企付-账单信息

    """

    def __init__(self):
        r"""
        :param _FirstName: 账单人名字
        :type FirstName: str
        :param _LastName: 账单人姓氏
        :type LastName: str
        :param _AddressOne: 账单地址1
        :type AddressOne: str
        :param _AddressTwo: 账单地址1
        :type AddressTwo: str
        :param _City: 账单地址所在城市
        :type City: str
        :param _State: 账单地址所在州/省，当国家是美国或加拿大时，使用ISO-3166-2:US或ISO -3166-2:CA 中该国家地区编 码标准中的两位字母编码。
        :type State: str
        :param _Country: 账单地址所在国家，使用ISO-3166-1标准中的两位字母编码。
        :type Country: str
        :param _ZipCode: 账单地址邮编
        :type ZipCode: str
        :param _Phone: 账单人手机号
        :type Phone: str
        """
        self._FirstName = None
        self._LastName = None
        self._AddressOne = None
        self._AddressTwo = None
        self._City = None
        self._State = None
        self._Country = None
        self._ZipCode = None
        self._Phone = None

    @property
    def FirstName(self):
        """账单人名字
        :rtype: str
        """
        return self._FirstName

    @FirstName.setter
    def FirstName(self, FirstName):
        self._FirstName = FirstName

    @property
    def LastName(self):
        """账单人姓氏
        :rtype: str
        """
        return self._LastName

    @LastName.setter
    def LastName(self, LastName):
        self._LastName = LastName

    @property
    def AddressOne(self):
        """账单地址1
        :rtype: str
        """
        return self._AddressOne

    @AddressOne.setter
    def AddressOne(self, AddressOne):
        self._AddressOne = AddressOne

    @property
    def AddressTwo(self):
        """账单地址1
        :rtype: str
        """
        return self._AddressTwo

    @AddressTwo.setter
    def AddressTwo(self, AddressTwo):
        self._AddressTwo = AddressTwo

    @property
    def City(self):
        """账单地址所在城市
        :rtype: str
        """
        return self._City

    @City.setter
    def City(self, City):
        self._City = City

    @property
    def State(self):
        """账单地址所在州/省，当国家是美国或加拿大时，使用ISO-3166-2:US或ISO -3166-2:CA 中该国家地区编 码标准中的两位字母编码。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Country(self):
        """账单地址所在国家，使用ISO-3166-1标准中的两位字母编码。
        :rtype: str
        """
        return self._Country

    @Country.setter
    def Country(self, Country):
        self._Country = Country

    @property
    def ZipCode(self):
        """账单地址邮编
        :rtype: str
        """
        return self._ZipCode

    @ZipCode.setter
    def ZipCode(self, ZipCode):
        self._ZipCode = ZipCode

    @property
    def Phone(self):
        """账单人手机号
        :rtype: str
        """
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone


    def _deserialize(self, params):
        self._FirstName = params.get("FirstName")
        self._LastName = params.get("LastName")
        self._AddressOne = params.get("AddressOne")
        self._AddressTwo = params.get("AddressTwo")
        self._City = params.get("City")
        self._State = params.get("State")
        self._Country = params.get("Country")
        self._ZipCode = params.get("ZipCode")
        self._Phone = params.get("Phone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankFormInfo(AbstractModel):
    """网银页面提交html

    """

    def __init__(self):
        r"""
        :param _FormHtml: 网银页面提交html
注意：此字段可能返回 null，表示取不到有效值。
        :type FormHtml: str
        :param _FormEncoding: 网银提交页面字符集
注意：此字段可能返回 null，表示取不到有效值。
        :type FormEncoding: str
        """
        self._FormHtml = None
        self._FormEncoding = None

    @property
    def FormHtml(self):
        """网银页面提交html
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FormHtml

    @FormHtml.setter
    def FormHtml(self, FormHtml):
        self._FormHtml = FormHtml

    @property
    def FormEncoding(self):
        """网银提交页面字符集
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FormEncoding

    @FormEncoding.setter
    def FormEncoding(self, FormEncoding):
        self._FormEncoding = FormEncoding


    def _deserialize(self, params):
        self._FormHtml = params.get("FormHtml")
        self._FormEncoding = params.get("FormEncoding")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankGoodsInfo(AbstractModel):
    """云企付-商品信息

    """

    def __init__(self):
        r"""
        :param _GoodsName: 商品标题。默认值“商品支付”。
        :type GoodsName: str
        :param _GoodsDetail: 商品详细描述（商品列表）。
        :type GoodsDetail: str
        :param _GoodsDescription: 银行附言。不可以有以下字符：<>+{}()%*&';"[]等特殊符号
        :type GoodsDescription: str
        :param _GoodsBizType: 业务类型。汇付渠道必填，汇付渠道传入固定值100099。
        :type GoodsBizType: str
        :param _Sku: 商品编号。
        :type Sku: str
        :param _Price: 商品单价。
        :type Price: str
        :param _Quantity: 商品数量
        :type Quantity: str
        :param _ProductImage: 商品图片url
        :type ProductImage: str
        :param _ProductUrl: 商品链接url
        :type ProductUrl: str
        """
        self._GoodsName = None
        self._GoodsDetail = None
        self._GoodsDescription = None
        self._GoodsBizType = None
        self._Sku = None
        self._Price = None
        self._Quantity = None
        self._ProductImage = None
        self._ProductUrl = None

    @property
    def GoodsName(self):
        """商品标题。默认值“商品支付”。
        :rtype: str
        """
        return self._GoodsName

    @GoodsName.setter
    def GoodsName(self, GoodsName):
        self._GoodsName = GoodsName

    @property
    def GoodsDetail(self):
        """商品详细描述（商品列表）。
        :rtype: str
        """
        return self._GoodsDetail

    @GoodsDetail.setter
    def GoodsDetail(self, GoodsDetail):
        self._GoodsDetail = GoodsDetail

    @property
    def GoodsDescription(self):
        """银行附言。不可以有以下字符：<>+{}()%*&';"[]等特殊符号
        :rtype: str
        """
        return self._GoodsDescription

    @GoodsDescription.setter
    def GoodsDescription(self, GoodsDescription):
        self._GoodsDescription = GoodsDescription

    @property
    def GoodsBizType(self):
        """业务类型。汇付渠道必填，汇付渠道传入固定值100099。
        :rtype: str
        """
        return self._GoodsBizType

    @GoodsBizType.setter
    def GoodsBizType(self, GoodsBizType):
        self._GoodsBizType = GoodsBizType

    @property
    def Sku(self):
        """商品编号。
        :rtype: str
        """
        return self._Sku

    @Sku.setter
    def Sku(self, Sku):
        self._Sku = Sku

    @property
    def Price(self):
        """商品单价。
        :rtype: str
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def Quantity(self):
        """商品数量
        :rtype: str
        """
        return self._Quantity

    @Quantity.setter
    def Quantity(self, Quantity):
        self._Quantity = Quantity

    @property
    def ProductImage(self):
        """商品图片url
        :rtype: str
        """
        return self._ProductImage

    @ProductImage.setter
    def ProductImage(self, ProductImage):
        self._ProductImage = ProductImage

    @property
    def ProductUrl(self):
        """商品链接url
        :rtype: str
        """
        return self._ProductUrl

    @ProductUrl.setter
    def ProductUrl(self, ProductUrl):
        self._ProductUrl = ProductUrl


    def _deserialize(self, params):
        self._GoodsName = params.get("GoodsName")
        self._GoodsDetail = params.get("GoodsDetail")
        self._GoodsDescription = params.get("GoodsDescription")
        self._GoodsBizType = params.get("GoodsBizType")
        self._Sku = params.get("Sku")
        self._Price = params.get("Price")
        self._Quantity = params.get("Quantity")
        self._ProductImage = params.get("ProductImage")
        self._ProductUrl = params.get("ProductUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankOrderRedirectInfo(AbstractModel):
    """云企付-下单跳转参数，用于小程序前端跳转

    """

    def __init__(self):
        r"""
        :param _QRCodeUrl: 生成二维码，引导用户扫码
注意：此字段可能返回 null，表示取不到有效值。
        :type QRCodeUrl: str
        :param _QRCodeKey: 二维码凭证
注意：此字段可能返回 null，表示取不到有效值。
        :type QRCodeKey: str
        :param _Url: 跳转 URL,用于客户端跳转，订单未支付时返回该参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        :param _ExpireTime: 跳转凭证过期时间,yyyy-MM-dd HH:mm:ss
注意：此字段可能返回 null，表示取不到有效值。
        :type ExpireTime: str
        :param _MpAppId: 小程序 appid
注意：此字段可能返回 null，表示取不到有效值。
        :type MpAppId: str
        :param _MpPath: 小程序路径
注意：此字段可能返回 null，表示取不到有效值。
        :type MpPath: str
        :param _MpUserName: 小程序原始 id
注意：此字段可能返回 null，表示取不到有效值。
        :type MpUserName: str
        :param _FormInfo: 网银支付提交页面信息
注意：此字段可能返回 null，表示取不到有效值。
        :type FormInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankFormInfo`
        """
        self._QRCodeUrl = None
        self._QRCodeKey = None
        self._Url = None
        self._ExpireTime = None
        self._MpAppId = None
        self._MpPath = None
        self._MpUserName = None
        self._FormInfo = None

    @property
    def QRCodeUrl(self):
        """生成二维码，引导用户扫码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._QRCodeUrl

    @QRCodeUrl.setter
    def QRCodeUrl(self, QRCodeUrl):
        self._QRCodeUrl = QRCodeUrl

    @property
    def QRCodeKey(self):
        """二维码凭证
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._QRCodeKey

    @QRCodeKey.setter
    def QRCodeKey(self, QRCodeKey):
        self._QRCodeKey = QRCodeKey

    @property
    def Url(self):
        """跳转 URL,用于客户端跳转，订单未支付时返回该参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def ExpireTime(self):
        """跳转凭证过期时间,yyyy-MM-dd HH:mm:ss
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def MpAppId(self):
        """小程序 appid
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MpAppId

    @MpAppId.setter
    def MpAppId(self, MpAppId):
        self._MpAppId = MpAppId

    @property
    def MpPath(self):
        """小程序路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MpPath

    @MpPath.setter
    def MpPath(self, MpPath):
        self._MpPath = MpPath

    @property
    def MpUserName(self):
        """小程序原始 id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MpUserName

    @MpUserName.setter
    def MpUserName(self, MpUserName):
        self._MpUserName = MpUserName

    @property
    def FormInfo(self):
        """网银支付提交页面信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankFormInfo`
        """
        return self._FormInfo

    @FormInfo.setter
    def FormInfo(self, FormInfo):
        self._FormInfo = FormInfo


    def _deserialize(self, params):
        self._QRCodeUrl = params.get("QRCodeUrl")
        self._QRCodeKey = params.get("QRCodeKey")
        self._Url = params.get("Url")
        self._ExpireTime = params.get("ExpireTime")
        self._MpAppId = params.get("MpAppId")
        self._MpPath = params.get("MpPath")
        self._MpUserName = params.get("MpUserName")
        if params.get("FormInfo") is not None:
            self._FormInfo = OpenBankFormInfo()
            self._FormInfo._deserialize(params.get("FormInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankPayLimitInfo(AbstractModel):
    """云企付-支付限制

    """

    def __init__(self):
        r"""
        :param _PayLimitType: 限制类型
        :type PayLimitType: str
        :param _PayLimitValue: 限制类型值
        :type PayLimitValue: str
        """
        self._PayLimitType = None
        self._PayLimitValue = None

    @property
    def PayLimitType(self):
        """限制类型
        :rtype: str
        """
        return self._PayLimitType

    @PayLimitType.setter
    def PayLimitType(self, PayLimitType):
        self._PayLimitType = PayLimitType

    @property
    def PayLimitValue(self):
        """限制类型值
        :rtype: str
        """
        return self._PayLimitValue

    @PayLimitValue.setter
    def PayLimitValue(self, PayLimitValue):
        self._PayLimitValue = PayLimitValue


    def _deserialize(self, params):
        self._PayLimitType = params.get("PayLimitType")
        self._PayLimitValue = params.get("PayLimitValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankPayeeInfo(AbstractModel):
    """云企付-收款人信息

    """

    def __init__(self):
        r"""
        :param _PayeeId: 收款方唯一标识。
当渠道为TENPAY，付款方式为EBANK_PAYMENT，必填，上送收款方入驻云企付商户ID；
付款方式为OPENBANK_PAYMENT时，非必填，输入外部收款方的标识ID
渠道为WECHAT，付款方式为TRANS_TO_CHANGE时，上送微信OPEN_ID；
        :type PayeeId: str
        :param _BankBranchName: 支行名称。
        :type BankBranchName: str
        :param _BankAccountNumber: 银行账号。渠道为TENPAY，付款方式为OPENBANK_PAYMENT时必选
        :type BankAccountNumber: str
        :param _PayeeName: 收款方名称。
当渠道为TENPAY，付款方式为EBANK_PAYMENT时，上送收款方入驻云企付的商户名称；
渠道为TENPAY，付款方式为OPENBANK_PAYMENT时必选，上送收款方账户名称；
渠道为ALIPAY，付款方式为SAFT_ISV时，收款账户标识类型为ALIPAY_LOGON_ID时必传，上送收款方真实姓名。
渠道为WECHAT，付款方式为TRANS_TO_CHANGE时，上送收款人姓名。
        :type PayeeName: str
        :param _BankBranchId: 联行号。渠道为TENPAY，付款方式为OPENBANK_PAYMENT时必选
        :type BankBranchId: str
        :param _BindSerialNo: 收款方绑卡序列号。
当渠道为TENPAY，付款方式为EBANK_PAYMENT时，必填，上送收款方入驻云企付平台时，下发的绑卡序列号；当渠道为ALIPAY，付款方式为SAFT_ISV时，必填，根据收款账户标识类型上送。
        :type BindSerialNo: str
        :param _AccountType: 收款账户标识类型
BANK_ACCOUNT：绑定银行账户
ACCOUNT_BOOK_ID：电子记账本ID
ALIPAY_USER_ID：支付宝的会员ID
ALIPAY_LOGON_ID：支付宝登录号。
付款方式为SAFT_ISV时，必填。
        :type AccountType: str
        """
        self._PayeeId = None
        self._BankBranchName = None
        self._BankAccountNumber = None
        self._PayeeName = None
        self._BankBranchId = None
        self._BindSerialNo = None
        self._AccountType = None

    @property
    def PayeeId(self):
        """收款方唯一标识。
当渠道为TENPAY，付款方式为EBANK_PAYMENT，必填，上送收款方入驻云企付商户ID；
付款方式为OPENBANK_PAYMENT时，非必填，输入外部收款方的标识ID
渠道为WECHAT，付款方式为TRANS_TO_CHANGE时，上送微信OPEN_ID；
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def BankBranchName(self):
        """支行名称。
        :rtype: str
        """
        return self._BankBranchName

    @BankBranchName.setter
    def BankBranchName(self, BankBranchName):
        self._BankBranchName = BankBranchName

    @property
    def BankAccountNumber(self):
        """银行账号。渠道为TENPAY，付款方式为OPENBANK_PAYMENT时必选
        :rtype: str
        """
        return self._BankAccountNumber

    @BankAccountNumber.setter
    def BankAccountNumber(self, BankAccountNumber):
        self._BankAccountNumber = BankAccountNumber

    @property
    def PayeeName(self):
        """收款方名称。
当渠道为TENPAY，付款方式为EBANK_PAYMENT时，上送收款方入驻云企付的商户名称；
渠道为TENPAY，付款方式为OPENBANK_PAYMENT时必选，上送收款方账户名称；
渠道为ALIPAY，付款方式为SAFT_ISV时，收款账户标识类型为ALIPAY_LOGON_ID时必传，上送收款方真实姓名。
渠道为WECHAT，付款方式为TRANS_TO_CHANGE时，上送收款人姓名。
        :rtype: str
        """
        return self._PayeeName

    @PayeeName.setter
    def PayeeName(self, PayeeName):
        self._PayeeName = PayeeName

    @property
    def BankBranchId(self):
        """联行号。渠道为TENPAY，付款方式为OPENBANK_PAYMENT时必选
        :rtype: str
        """
        return self._BankBranchId

    @BankBranchId.setter
    def BankBranchId(self, BankBranchId):
        self._BankBranchId = BankBranchId

    @property
    def BindSerialNo(self):
        """收款方绑卡序列号。
当渠道为TENPAY，付款方式为EBANK_PAYMENT时，必填，上送收款方入驻云企付平台时，下发的绑卡序列号；当渠道为ALIPAY，付款方式为SAFT_ISV时，必填，根据收款账户标识类型上送。
        :rtype: str
        """
        return self._BindSerialNo

    @BindSerialNo.setter
    def BindSerialNo(self, BindSerialNo):
        self._BindSerialNo = BindSerialNo

    @property
    def AccountType(self):
        """收款账户标识类型
BANK_ACCOUNT：绑定银行账户
ACCOUNT_BOOK_ID：电子记账本ID
ALIPAY_USER_ID：支付宝的会员ID
ALIPAY_LOGON_ID：支付宝登录号。
付款方式为SAFT_ISV时，必填。
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._PayeeId = params.get("PayeeId")
        self._BankBranchName = params.get("BankBranchName")
        self._BankAccountNumber = params.get("BankAccountNumber")
        self._PayeeName = params.get("PayeeName")
        self._BankBranchId = params.get("BankBranchId")
        self._BindSerialNo = params.get("BindSerialNo")
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankPayerInfo(AbstractModel):
    """云企付-付款人信息

    """

    def __init__(self):
        r"""
        :param _PayerId: 付款方唯一标识。当TENPAY时，必填上送
付款方入驻云企付商户ID。
        :type PayerId: str
        :param _PayerName: 付款方名称。当TENPAY上送付款方入驻云企付的商户名称。
        :type PayerName: str
        :param _BindSerialNo: 付款方付款账户标识。
当付款方式为OPENBANK_PAYMENT时，必输表示企业账户ID；当付款方式为SAFT_ISV时，必须上送付款方的渠道电子记账本ID；当付款方式为ONLINEBANK，上送付款方银行编号BankId。
        :type BindSerialNo: str
        :param _AccountType: 付款账户标识类型
BANK_ACCOUNT：绑定银行账户
ACCOUNT_BOOK_ID：电子记账本ID。
当付款方式为SAFT_ISV时，必须上送类型为ACCOUNT_BOOK_ID。
        :type AccountType: str
        :param _BankCardType: 付款卡类型。汇付渠道必填。
DEBIT_CARD：借记卡
CREDIT_CARD：信用卡
        :type BankCardType: str
        """
        self._PayerId = None
        self._PayerName = None
        self._BindSerialNo = None
        self._AccountType = None
        self._BankCardType = None

    @property
    def PayerId(self):
        """付款方唯一标识。当TENPAY时，必填上送
付款方入驻云企付商户ID。
        :rtype: str
        """
        return self._PayerId

    @PayerId.setter
    def PayerId(self, PayerId):
        self._PayerId = PayerId

    @property
    def PayerName(self):
        """付款方名称。当TENPAY上送付款方入驻云企付的商户名称。
        :rtype: str
        """
        return self._PayerName

    @PayerName.setter
    def PayerName(self, PayerName):
        self._PayerName = PayerName

    @property
    def BindSerialNo(self):
        """付款方付款账户标识。
当付款方式为OPENBANK_PAYMENT时，必输表示企业账户ID；当付款方式为SAFT_ISV时，必须上送付款方的渠道电子记账本ID；当付款方式为ONLINEBANK，上送付款方银行编号BankId。
        :rtype: str
        """
        return self._BindSerialNo

    @BindSerialNo.setter
    def BindSerialNo(self, BindSerialNo):
        self._BindSerialNo = BindSerialNo

    @property
    def AccountType(self):
        """付款账户标识类型
BANK_ACCOUNT：绑定银行账户
ACCOUNT_BOOK_ID：电子记账本ID。
当付款方式为SAFT_ISV时，必须上送类型为ACCOUNT_BOOK_ID。
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def BankCardType(self):
        """付款卡类型。汇付渠道必填。
DEBIT_CARD：借记卡
CREDIT_CARD：信用卡
        :rtype: str
        """
        return self._BankCardType

    @BankCardType.setter
    def BankCardType(self, BankCardType):
        self._BankCardType = BankCardType


    def _deserialize(self, params):
        self._PayerId = params.get("PayerId")
        self._PayerName = params.get("PayerName")
        self._BindSerialNo = params.get("BindSerialNo")
        self._AccountType = params.get("AccountType")
        self._BankCardType = params.get("BankCardType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankProfitShareInfo(AbstractModel):
    """云企付-分润信息

    """

    def __init__(self):
        r"""
        :param _RecvId: 分润接收方，渠道商户号ID
        :type RecvId: str
        :param _ProfitShareFee: 分润金额，单位分
        :type ProfitShareFee: int
        """
        self._RecvId = None
        self._ProfitShareFee = None

    @property
    def RecvId(self):
        """分润接收方，渠道商户号ID
        :rtype: str
        """
        return self._RecvId

    @RecvId.setter
    def RecvId(self, RecvId):
        self._RecvId = RecvId

    @property
    def ProfitShareFee(self):
        """分润金额，单位分
        :rtype: int
        """
        return self._ProfitShareFee

    @ProfitShareFee.setter
    def ProfitShareFee(self, ProfitShareFee):
        self._ProfitShareFee = ProfitShareFee


    def _deserialize(self, params):
        self._RecvId = params.get("RecvId")
        self._ProfitShareFee = params.get("ProfitShareFee")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankProfitSharePayeeInfo(AbstractModel):
    """分账收款人信息

    """

    def __init__(self):
        r"""
        :param _AccountName: 收款人账户名称
        :type AccountName: str
        :param _BankName: 银行名称
可大体识别银行就行
        :type BankName: str
        :param _Currency: 账户货币
        :type Currency: str
        :param _Nature: 账户类型。
00:借记卡
01:存折 
02:信用卡 
03:准贷记卡 
04:预付卡费 
05:境外卡
        :type Nature: str
        :param _Country: 账户地区/受益人所在国家。参考附录“国家代码”表——“代码”字段
        :type Country: str
        :param _DepositCountry: 账户开户所在国家
参考附录“国家代码”表——“代码”字段
        :type DepositCountry: str
        :param _ExpireDate: 合作有效期
yyyy-MM-dd
        :type ExpireDate: str
        :param _Flag: 0:个人(对私) 1:公司(对公)
        :type Flag: str
        :param _BankAddress: 开户行地址
账户地区非中国必填，【账户名+开户行地址不可超过114个字符（只允许【英文字母数字空格.,/-()'】），否则可能导致境外银行付款失败】
        :type BankAddress: str
        :param _Address: 客户地址
非中国内地账户的客户地址不能为空
        :type Address: str
        :param _IsOSA: 账户属性
账户开户所在国家为中国则必填。
1-离岸账户 0-在岸账户
        :type IsOSA: str
        :param _Province: 账户省份
参考附录“地区代码”
        :type Province: str
        :param _City: 账户城市
参考附录“地区代码
        :type City: str
        :param _LegalIdNo: 证件号/统一信用证代码
如果country与depositcountry字段都是CHN时，必填
对公账户填统一信用证代码，对私账户填身份证号码
离岸账户非必填
        :type LegalIdNo: str
        :param _Telephone: 手机号。
账户地区是日本则必填
        :type Telephone: str
        :param _BicCode: 参考接口说明。
        :type BicCode: str
        :param _SwiftCode: 参考接口说明。
        :type SwiftCode: str
        :param _Cnaps: 大额支付行号/支付行号
参考接口说明。境外（大额支付行号）参考附录【大额行号】，境内（支付行号）参考附录【支付行号】
        :type Cnaps: str
        :param _TransferBankNo: 中转行号，参考接口说明。
        :type TransferBankNo: str
        :param _Fid: 关联附件。上传的文件ID
        :type Fid: str
        """
        self._AccountName = None
        self._BankName = None
        self._Currency = None
        self._Nature = None
        self._Country = None
        self._DepositCountry = None
        self._ExpireDate = None
        self._Flag = None
        self._BankAddress = None
        self._Address = None
        self._IsOSA = None
        self._Province = None
        self._City = None
        self._LegalIdNo = None
        self._Telephone = None
        self._BicCode = None
        self._SwiftCode = None
        self._Cnaps = None
        self._TransferBankNo = None
        self._Fid = None

    @property
    def AccountName(self):
        """收款人账户名称
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def BankName(self):
        """银行名称
可大体识别银行就行
        :rtype: str
        """
        return self._BankName

    @BankName.setter
    def BankName(self, BankName):
        self._BankName = BankName

    @property
    def Currency(self):
        """账户货币
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def Nature(self):
        """账户类型。
00:借记卡
01:存折 
02:信用卡 
03:准贷记卡 
04:预付卡费 
05:境外卡
        :rtype: str
        """
        return self._Nature

    @Nature.setter
    def Nature(self, Nature):
        self._Nature = Nature

    @property
    def Country(self):
        """账户地区/受益人所在国家。参考附录“国家代码”表——“代码”字段
        :rtype: str
        """
        return self._Country

    @Country.setter
    def Country(self, Country):
        self._Country = Country

    @property
    def DepositCountry(self):
        """账户开户所在国家
参考附录“国家代码”表——“代码”字段
        :rtype: str
        """
        return self._DepositCountry

    @DepositCountry.setter
    def DepositCountry(self, DepositCountry):
        self._DepositCountry = DepositCountry

    @property
    def ExpireDate(self):
        """合作有效期
yyyy-MM-dd
        :rtype: str
        """
        return self._ExpireDate

    @ExpireDate.setter
    def ExpireDate(self, ExpireDate):
        self._ExpireDate = ExpireDate

    @property
    def Flag(self):
        """0:个人(对私) 1:公司(对公)
        :rtype: str
        """
        return self._Flag

    @Flag.setter
    def Flag(self, Flag):
        self._Flag = Flag

    @property
    def BankAddress(self):
        """开户行地址
账户地区非中国必填，【账户名+开户行地址不可超过114个字符（只允许【英文字母数字空格.,/-()'】），否则可能导致境外银行付款失败】
        :rtype: str
        """
        return self._BankAddress

    @BankAddress.setter
    def BankAddress(self, BankAddress):
        self._BankAddress = BankAddress

    @property
    def Address(self):
        """客户地址
非中国内地账户的客户地址不能为空
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def IsOSA(self):
        """账户属性
账户开户所在国家为中国则必填。
1-离岸账户 0-在岸账户
        :rtype: str
        """
        return self._IsOSA

    @IsOSA.setter
    def IsOSA(self, IsOSA):
        self._IsOSA = IsOSA

    @property
    def Province(self):
        """账户省份
参考附录“地区代码”
        :rtype: str
        """
        return self._Province

    @Province.setter
    def Province(self, Province):
        self._Province = Province

    @property
    def City(self):
        """账户城市
参考附录“地区代码
        :rtype: str
        """
        return self._City

    @City.setter
    def City(self, City):
        self._City = City

    @property
    def LegalIdNo(self):
        """证件号/统一信用证代码
如果country与depositcountry字段都是CHN时，必填
对公账户填统一信用证代码，对私账户填身份证号码
离岸账户非必填
        :rtype: str
        """
        return self._LegalIdNo

    @LegalIdNo.setter
    def LegalIdNo(self, LegalIdNo):
        self._LegalIdNo = LegalIdNo

    @property
    def Telephone(self):
        """手机号。
账户地区是日本则必填
        :rtype: str
        """
        return self._Telephone

    @Telephone.setter
    def Telephone(self, Telephone):
        self._Telephone = Telephone

    @property
    def BicCode(self):
        """参考接口说明。
        :rtype: str
        """
        return self._BicCode

    @BicCode.setter
    def BicCode(self, BicCode):
        self._BicCode = BicCode

    @property
    def SwiftCode(self):
        """参考接口说明。
        :rtype: str
        """
        return self._SwiftCode

    @SwiftCode.setter
    def SwiftCode(self, SwiftCode):
        self._SwiftCode = SwiftCode

    @property
    def Cnaps(self):
        """大额支付行号/支付行号
参考接口说明。境外（大额支付行号）参考附录【大额行号】，境内（支付行号）参考附录【支付行号】
        :rtype: str
        """
        return self._Cnaps

    @Cnaps.setter
    def Cnaps(self, Cnaps):
        self._Cnaps = Cnaps

    @property
    def TransferBankNo(self):
        """中转行号，参考接口说明。
        :rtype: str
        """
        return self._TransferBankNo

    @TransferBankNo.setter
    def TransferBankNo(self, TransferBankNo):
        self._TransferBankNo = TransferBankNo

    @property
    def Fid(self):
        """关联附件。上传的文件ID
        :rtype: str
        """
        return self._Fid

    @Fid.setter
    def Fid(self, Fid):
        self._Fid = Fid


    def _deserialize(self, params):
        self._AccountName = params.get("AccountName")
        self._BankName = params.get("BankName")
        self._Currency = params.get("Currency")
        self._Nature = params.get("Nature")
        self._Country = params.get("Country")
        self._DepositCountry = params.get("DepositCountry")
        self._ExpireDate = params.get("ExpireDate")
        self._Flag = params.get("Flag")
        self._BankAddress = params.get("BankAddress")
        self._Address = params.get("Address")
        self._IsOSA = params.get("IsOSA")
        self._Province = params.get("Province")
        self._City = params.get("City")
        self._LegalIdNo = params.get("LegalIdNo")
        self._Telephone = params.get("Telephone")
        self._BicCode = params.get("BicCode")
        self._SwiftCode = params.get("SwiftCode")
        self._Cnaps = params.get("Cnaps")
        self._TransferBankNo = params.get("TransferBankNo")
        self._Fid = params.get("Fid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankProfitShareRespInfo(AbstractModel):
    """分账信息结果

    """

    def __init__(self):
        r"""
        :param _RecvId: 接收方企业ID
        :type RecvId: str
        :param _ProfitShareFee: 分润金额（分）
        :type ProfitShareFee: int
        :param _RealProfitShareFee: 实际分账金额
        :type RealProfitShareFee: int
        :param _ProfitShareStatus: 分账状态
        :type ProfitShareStatus: str
        :param _ProfitFinishTime: 分账完成时间
        :type ProfitFinishTime: str
        :param _ProfitShareType: 分账类型
        :type ProfitShareType: int
        """
        self._RecvId = None
        self._ProfitShareFee = None
        self._RealProfitShareFee = None
        self._ProfitShareStatus = None
        self._ProfitFinishTime = None
        self._ProfitShareType = None

    @property
    def RecvId(self):
        """接收方企业ID
        :rtype: str
        """
        return self._RecvId

    @RecvId.setter
    def RecvId(self, RecvId):
        self._RecvId = RecvId

    @property
    def ProfitShareFee(self):
        """分润金额（分）
        :rtype: int
        """
        return self._ProfitShareFee

    @ProfitShareFee.setter
    def ProfitShareFee(self, ProfitShareFee):
        self._ProfitShareFee = ProfitShareFee

    @property
    def RealProfitShareFee(self):
        """实际分账金额
        :rtype: int
        """
        return self._RealProfitShareFee

    @RealProfitShareFee.setter
    def RealProfitShareFee(self, RealProfitShareFee):
        self._RealProfitShareFee = RealProfitShareFee

    @property
    def ProfitShareStatus(self):
        """分账状态
        :rtype: str
        """
        return self._ProfitShareStatus

    @ProfitShareStatus.setter
    def ProfitShareStatus(self, ProfitShareStatus):
        self._ProfitShareStatus = ProfitShareStatus

    @property
    def ProfitFinishTime(self):
        """分账完成时间
        :rtype: str
        """
        return self._ProfitFinishTime

    @ProfitFinishTime.setter
    def ProfitFinishTime(self, ProfitFinishTime):
        self._ProfitFinishTime = ProfitFinishTime

    @property
    def ProfitShareType(self):
        """分账类型
        :rtype: int
        """
        return self._ProfitShareType

    @ProfitShareType.setter
    def ProfitShareType(self, ProfitShareType):
        self._ProfitShareType = ProfitShareType


    def _deserialize(self, params):
        self._RecvId = params.get("RecvId")
        self._ProfitShareFee = params.get("ProfitShareFee")
        self._RealProfitShareFee = params.get("RealProfitShareFee")
        self._ProfitShareStatus = params.get("ProfitShareStatus")
        self._ProfitFinishTime = params.get("ProfitFinishTime")
        self._ProfitShareType = params.get("ProfitShareType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankQueryRefundOrderResult(AbstractModel):
    """云企付-退款查询结果

    """

    def __init__(self):
        r"""
        :param _OutRefundId: 外部商户退款单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OutRefundId: str
        :param _ChannelRefundId: 渠道退款单号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelRefundId: str
        :param _RefundReason: 退款原因
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundReason: str
        :param _RefundAmount: 退款金额，单位分
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundAmount: int
        :param _RealRefundAmount: 实际退款金额，单位分
注意：此字段可能返回 null，表示取不到有效值。
        :type RealRefundAmount: int
        :param _TotalAmount: 原支付订单总金额，单位分
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalAmount: int
        :param _TimeFinish: 退款完成时间
注意：此字段可能返回 null，表示取不到有效值。
        :type TimeFinish: str
        :param _RefundStatus: 退款订单状态
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundStatus: str
        :param _RefundInfo: 退款明细信息
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundInfo: str
        :param _FeeAmount: 退款手续费金额
注意：此字段可能返回 null，表示取不到有效值。
        :type FeeAmount: int
        :param _RefundMessage: 退款返回描述，比如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundMessage: str
        :param _ProfitShareRespInfoList: 分账信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ProfitShareRespInfoList: list of OpenBankProfitShareRespInfo
        """
        self._OutRefundId = None
        self._ChannelRefundId = None
        self._RefundReason = None
        self._RefundAmount = None
        self._RealRefundAmount = None
        self._TotalAmount = None
        self._TimeFinish = None
        self._RefundStatus = None
        self._RefundInfo = None
        self._FeeAmount = None
        self._RefundMessage = None
        self._ProfitShareRespInfoList = None

    @property
    def OutRefundId(self):
        """外部商户退款单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OutRefundId

    @OutRefundId.setter
    def OutRefundId(self, OutRefundId):
        self._OutRefundId = OutRefundId

    @property
    def ChannelRefundId(self):
        """渠道退款单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelRefundId

    @ChannelRefundId.setter
    def ChannelRefundId(self, ChannelRefundId):
        self._ChannelRefundId = ChannelRefundId

    @property
    def RefundReason(self):
        """退款原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RefundReason

    @RefundReason.setter
    def RefundReason(self, RefundReason):
        self._RefundReason = RefundReason

    @property
    def RefundAmount(self):
        """退款金额，单位分
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RefundAmount

    @RefundAmount.setter
    def RefundAmount(self, RefundAmount):
        self._RefundAmount = RefundAmount

    @property
    def RealRefundAmount(self):
        """实际退款金额，单位分
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RealRefundAmount

    @RealRefundAmount.setter
    def RealRefundAmount(self, RealRefundAmount):
        self._RealRefundAmount = RealRefundAmount

    @property
    def TotalAmount(self):
        """原支付订单总金额，单位分
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalAmount

    @TotalAmount.setter
    def TotalAmount(self, TotalAmount):
        self._TotalAmount = TotalAmount

    @property
    def TimeFinish(self):
        """退款完成时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TimeFinish

    @TimeFinish.setter
    def TimeFinish(self, TimeFinish):
        self._TimeFinish = TimeFinish

    @property
    def RefundStatus(self):
        """退款订单状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RefundStatus

    @RefundStatus.setter
    def RefundStatus(self, RefundStatus):
        self._RefundStatus = RefundStatus

    @property
    def RefundInfo(self):
        """退款明细信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RefundInfo

    @RefundInfo.setter
    def RefundInfo(self, RefundInfo):
        self._RefundInfo = RefundInfo

    @property
    def FeeAmount(self):
        """退款手续费金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FeeAmount

    @FeeAmount.setter
    def FeeAmount(self, FeeAmount):
        self._FeeAmount = FeeAmount

    @property
    def RefundMessage(self):
        """退款返回描述，比如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RefundMessage

    @RefundMessage.setter
    def RefundMessage(self, RefundMessage):
        self._RefundMessage = RefundMessage

    @property
    def ProfitShareRespInfoList(self):
        """分账信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of OpenBankProfitShareRespInfo
        """
        return self._ProfitShareRespInfoList

    @ProfitShareRespInfoList.setter
    def ProfitShareRespInfoList(self, ProfitShareRespInfoList):
        self._ProfitShareRespInfoList = ProfitShareRespInfoList


    def _deserialize(self, params):
        self._OutRefundId = params.get("OutRefundId")
        self._ChannelRefundId = params.get("ChannelRefundId")
        self._RefundReason = params.get("RefundReason")
        self._RefundAmount = params.get("RefundAmount")
        self._RealRefundAmount = params.get("RealRefundAmount")
        self._TotalAmount = params.get("TotalAmount")
        self._TimeFinish = params.get("TimeFinish")
        self._RefundStatus = params.get("RefundStatus")
        self._RefundInfo = params.get("RefundInfo")
        self._FeeAmount = params.get("FeeAmount")
        self._RefundMessage = params.get("RefundMessage")
        if params.get("ProfitShareRespInfoList") is not None:
            self._ProfitShareRespInfoList = []
            for item in params.get("ProfitShareRespInfoList"):
                obj = OpenBankProfitShareRespInfo()
                obj._deserialize(item)
                self._ProfitShareRespInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankRechargePayeeInfo(AbstractModel):
    """云企付-充值单收款人信息

    """

    def __init__(self):
        r"""
        :param _PayeeId: 收款方标识
收款方类型为电子记账本时，上送渠道电子记账本ID
        :type PayeeId: str
        :param _PayeeIdType: 收款方标识类型
ACCOUNT_BOOK_ID：电子记账本ID
        :type PayeeIdType: str
        :param _PayeeName: 收款方名称
        :type PayeeName: str
        """
        self._PayeeId = None
        self._PayeeIdType = None
        self._PayeeName = None

    @property
    def PayeeId(self):
        """收款方标识
收款方类型为电子记账本时，上送渠道电子记账本ID
        :rtype: str
        """
        return self._PayeeId

    @PayeeId.setter
    def PayeeId(self, PayeeId):
        self._PayeeId = PayeeId

    @property
    def PayeeIdType(self):
        """收款方标识类型
ACCOUNT_BOOK_ID：电子记账本ID
        :rtype: str
        """
        return self._PayeeIdType

    @PayeeIdType.setter
    def PayeeIdType(self, PayeeIdType):
        self._PayeeIdType = PayeeIdType

    @property
    def PayeeName(self):
        """收款方名称
        :rtype: str
        """
        return self._PayeeName

    @PayeeName.setter
    def PayeeName(self, PayeeName):
        self._PayeeName = PayeeName


    def _deserialize(self, params):
        self._PayeeId = params.get("PayeeId")
        self._PayeeIdType = params.get("PayeeIdType")
        self._PayeeName = params.get("PayeeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankRechargeRedirectInfo(AbstractModel):
    """云企付-充值跳转参数

    """

    def __init__(self):
        r"""
        :param _Url: 跳转URL
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        """跳转URL
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankRedirectInfo(AbstractModel):
    """云企付-跳转参数，用于小程序前端跳转

    """

    def __init__(self):
        r"""
        :param _QRCodeUrl: 生成二维码，引导用户扫码
        :type QRCodeUrl: str
        :param _QRCodeKey: 二维码凭证
        :type QRCodeKey: str
        :param _Url: 跳转 URL,用于客户端跳转，订单未支付时返回该参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        :param _ExpireTime: 跳转凭证过期时间,yyyy-MM-dd HH:mm:ss
        :type ExpireTime: str
        :param _MpAppId: 小程序 appid
        :type MpAppId: str
        :param _MpPath: 小程序路径
        :type MpPath: str
        :param _MpUserName: 小程序原始 id
        :type MpUserName: str
        :param _FormInfo: 网银支付提交页面信息
注意：此字段可能返回 null，表示取不到有效值。
        :type FormInfo: :class:`tencentcloud.cpdp.v20190820.models.OpenBankFormInfo`
        """
        self._QRCodeUrl = None
        self._QRCodeKey = None
        self._Url = None
        self._ExpireTime = None
        self._MpAppId = None
        self._MpPath = None
        self._MpUserName = None
        self._FormInfo = None

    @property
    def QRCodeUrl(self):
        """生成二维码，引导用户扫码
        :rtype: str
        """
        return self._QRCodeUrl

    @QRCodeUrl.setter
    def QRCodeUrl(self, QRCodeUrl):
        self._QRCodeUrl = QRCodeUrl

    @property
    def QRCodeKey(self):
        """二维码凭证
        :rtype: str
        """
        return self._QRCodeKey

    @QRCodeKey.setter
    def QRCodeKey(self, QRCodeKey):
        self._QRCodeKey = QRCodeKey

    @property
    def Url(self):
        """跳转 URL,用于客户端跳转，订单未支付时返回该参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def ExpireTime(self):
        """跳转凭证过期时间,yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def MpAppId(self):
        """小程序 appid
        :rtype: str
        """
        return self._MpAppId

    @MpAppId.setter
    def MpAppId(self, MpAppId):
        self._MpAppId = MpAppId

    @property
    def MpPath(self):
        """小程序路径
        :rtype: str
        """
        return self._MpPath

    @MpPath.setter
    def MpPath(self, MpPath):
        self._MpPath = MpPath

    @property
    def MpUserName(self):
        """小程序原始 id
        :rtype: str
        """
        return self._MpUserName

    @MpUserName.setter
    def MpUserName(self, MpUserName):
        self._MpUserName = MpUserName

    @property
    def FormInfo(self):
        """网银支付提交页面信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.cpdp.v20190820.models.OpenBankFormInfo`
        """
        return self._FormInfo

    @FormInfo.setter
    def FormInfo(self, FormInfo):
        self._FormInfo = FormInfo


    def _deserialize(self, params):
        self._QRCodeUrl = params.get("QRCodeUrl")
        self._QRCodeKey = params.get("QRCodeKey")
        self._Url = params.get("Url")
        self._ExpireTime = params.get("ExpireTime")
        self._MpAppId = params.get("MpAppId")
        self._MpPath = params.get("MpPath")
        self._MpUserName = params.get("MpUserName")
        if params.get("FormInfo") is not None:
            self._FormInfo = OpenBankFormInfo()
            self._FormInfo._deserialize(params.get("FormInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenBankRefundOrderApplyResult(AbstractModel):
    """云企付-退款申请结果

    """

    def __init__(self):
        r"""
        :param _ChannelOrderId: 云企付订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelOrderId: str
        :param _ChannelRefundId: 云企付退款流水号
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelRefundId: str
        :param _OutRefundId: 外部商户退款单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OutRefundId: str
        :param _OutOrderId: 外部商户订单号
注意：此字段可能返回 null，表示取不到有效值。
        :type OutOrderId: str
        :param _RefundMessage: 退款返回描述，比如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundMessage: str
        :param _RefundAmount: 退款金额
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundAmount: int
        :param _FeeAmount: 退款手续费金额
注意：此字段可能返回 null，表示取不到有效值。
        :type FeeAmount: int
        :param _RefundStatus: 退款状态
注意：此字段可能返回 null，表示取不到有效值。
        :type RefundStatus: str
        """
        self._ChannelOrderId = None
        self._ChannelRefundId = None
        self._OutRefundId = None
        self._OutOrderId = None
        self._RefundMessage = None
        self._RefundAmount = None
        self._FeeAmount = None
        self._RefundStatus = None

    @property
    def ChannelOrderId(self):
        """云企付订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelOrderId

    @ChannelOrderId.setter
    def ChannelOrderId(self, ChannelOrderId):
        self._ChannelOrderId = ChannelOrderId

    @property
    def ChannelRefundId(self):
        """云企付退款流水号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelRefundId

    @ChannelRefundId.setter
    def ChannelRefundId(self, ChannelRefundId):
        self._ChannelRefundId = ChannelRefundId

    @property
    def OutRefundId(self):
        """外部商户退款单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OutRefundId

    @OutRefundId.setter
    def OutRefundId(self, OutRefundId):
        self._OutRefundId = OutRefundId

    @property
    def OutOrderId(self):
        """外部商户订单号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OutOrderId

    @OutOrderId.setter
    def OutOrderId(self, OutOrderId):
        self._OutOrderId = OutOrderId

    @property
    def RefundMessage(self):
        """退款返回描述，比如失败原因等。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RefundMessage

    @RefundMessage.setter
    def RefundMessage(self, RefundMessage):
        self._RefundMessage = RefundMessage

    @property
    def RefundAmount(self):
        """退款金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RefundAmount

    @RefundAmount.setter
    def RefundAmount(self, RefundAmount):
        self._RefundAmount = RefundAmount

    @property
    def FeeAmount(self):
        """退款手续费金额
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FeeAmount

    @FeeAmount.setter
    def FeeAmount(self, FeeAmount):
        self._FeeAmount = FeeAmount

    @property
    def RefundStatus(self):
        """退款状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RefundStatus

    @RefundStatus.setter
    def RefundStatus(self, RefundStatus):
        self._RefundStatus = RefundStatus


    def _deserialize(self, params):
        self._ChannelOrderId = params.get("ChannelOrderId")
        self._ChannelRefundId = params.get("ChannelRefundId")
        self._OutRefundId = params.get("OutRefundId")
        self._OutOrderId = params.get("OutOrderId")
        self._RefundMessage = params.get("RefundMessage")
        self._RefundAmount = params.get("RefundAmount")
        self._FeeAmount = p