# coding: utf-8

"""
    Adobe Target Delivery API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Order(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'total': 'float',
        'purchased_product_ids': 'list[str]',
        'time': 'datetime',
        'experience_local_id': 'int',
        'duplicate': 'bool',
        'outlier': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'total': 'total',
        'purchased_product_ids': 'purchasedProductIds',
        'time': 'time',
        'experience_local_id': 'experienceLocalId',
        'duplicate': 'duplicate',
        'outlier': 'outlier'
    }

    def __init__(self, id=None, total=None, purchased_product_ids=None, time=None, experience_local_id=None, duplicate=None, outlier=None):
        """Order - a model defined in OpenAPI"""

        self._id = None
        self._total = None
        self._purchased_product_ids = None
        self._time = None
        self._experience_local_id = None
        self._duplicate = None
        self._outlier = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if total is not None:
            self.total = total
        if purchased_product_ids is not None:
            self.purchased_product_ids = purchased_product_ids
        if time is not None:
            self.time = time
        if experience_local_id is not None:
            self.experience_local_id = experience_local_id
        if duplicate is not None:
            self.duplicate = duplicate
        if outlier is not None:
            self.outlier = outlier

    @property
    def id(self):
        """Gets the id of this Order.

        Order Id.

        :return: The id of this Order.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Order.

        Order Id.

        :param id: The id of this Order.
        :type: str
        """
        if id is not None and len(id) > 250:
            raise ValueError("Invalid value for `id`, length must be less than or equal to `250`")

        self._id = id

    @property
    def total(self):
        """Gets the total of this Order.

        Order Total. The amount of money in the current order. 

        :return: The total of this Order.
        :rtype: float
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this Order.

        Order Total. The amount of money in the current order. 

        :param total: The total of this Order.
        :type: float
        """
        if total is not None and total < 0:
            raise ValueError("Invalid value for `total`, must be a value greater than or equal to `0`")

        self._total = total

    @property
    def purchased_product_ids(self):
        """Gets the purchased_product_ids of this Order.

        Order's product ids. Validation   * No blank values allowed.   * Each product Id max length 50.   * Product ids, separated by commas and concatenated, total length should not exceed 250. 

        :return: The purchased_product_ids of this Order.
        :rtype: list[str]
        """
        return self._purchased_product_ids

    @purchased_product_ids.setter
    def purchased_product_ids(self, purchased_product_ids):
        """Sets the purchased_product_ids of this Order.

        Order's product ids. Validation   * No blank values allowed.   * Each product Id max length 50.   * Product ids, separated by commas and concatenated, total length should not exceed 250. 

        :param purchased_product_ids: The purchased_product_ids of this Order.
        :type: list[str]
        """

        self._purchased_product_ids = purchased_product_ids

    @property
    def time(self):
        """Gets the time of this Order.

        Time in the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format 

        :return: The time of this Order.
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this Order.

        Time in the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format 

        :param time: The time of this Order.
        :type: datetime
        """

        self._time = time

    @property
    def experience_local_id(self):
        """Gets the experience_local_id of this Order.

        Id used to track the experience across POST/PUT requests

        :return: The experience_local_id of this Order.
        :rtype: int
        """
        return self._experience_local_id

    @experience_local_id.setter
    def experience_local_id(self, experience_local_id):
        """Sets the experience_local_id of this Order.

        Id used to track the experience across POST/PUT requests

        :param experience_local_id: The experience_local_id of this Order.
        :type: int
        """
        if experience_local_id is not None and experience_local_id > 2147483647:
            raise ValueError("Invalid value for `experience_local_id`, must be a value less than or equal to `2147483647`")
        if experience_local_id is not None and experience_local_id < 0:
            raise ValueError("Invalid value for `experience_local_id`, must be a value greater than or equal to `0`")

        self._experience_local_id = experience_local_id

    @property
    def duplicate(self):
        """Gets the duplicate of this Order.

        Whether or not the order is a duplicate

        :return: The duplicate of this Order.
        :rtype: bool
        """
        return self._duplicate

    @duplicate.setter
    def duplicate(self, duplicate):
        """Sets the duplicate of this Order.

        Whether or not the order is a duplicate

        :param duplicate: The duplicate of this Order.
        :type: bool
        """

        self._duplicate = duplicate

    @property
    def outlier(self):
        """Gets the outlier of this Order.

        Whether or not the order is abnormally different from the rest in volume

        :return: The outlier of this Order.
        :rtype: bool
        """
        return self._outlier

    @outlier.setter
    def outlier(self, outlier):
        """Sets the outlier of this Order.

        Whether or not the order is abnormally different from the rest in volume

        :param outlier: The outlier of this Order.
        :type: bool
        """

        self._outlier = outlier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
