"""
PyCallGraph Visualizer
======================

Visualize Python code dependencies with interactive call graphs.

Features:
- Circular dependency detection
- Dead code identification
- Complexity metrics
- Entry point detection
- Interactive HTML visualization

Usage:
    # From command line
    $ pycallgraph
    $ pycallgraph /path/to/project
    
    # From Python
    from pycallgraph_visualizer import analyze_directory, generate_html_graph
    
    result = analyze_directory('/path/to/project')
    generate_html_graph(result, 'output.html', '/path/to/project')
"""

from .analyzer import analyze_directory, generate_html_graph

__version__ = '1.0.0'
__all__ = ['analyze_directory', 'generate_html_graph']